(cpystan.model
StanModel
q oq}q(U
model_cppnameqX+   anon_model_1988b9d517e3c16daf27a07f09e3de97qU
model_codeqT  data {
  int T;                                // Sample size
  int<lower=1> K;                       // Number of seasonal vectors
  real t[T];                            // Day
  real y[T];                            // Time-series
  int S;                                // Number of changepoints
  real A[T, S];                   // Split indicators
  real t_change[S];                 // Index of changepoints
  real X[T,K];                // season vectors
  vector[K] sigmas;              // scale on seasonality prior
  real<lower=0> tau;                  // scale on changepoints prior
}

parameters {
  real k;                            // Base growth rate
  real m;                            // offset
  real delta[S];                       // Rate adjustments
  real<lower=0> sigma_obs;               // Observation noise (incl. seasonal variation)
  real beta[K];                    // seasonal vector
}

transformed parameters {
  real gamma[S];                  // adjusted offsets, for piecewise continuity

  for (i in 1:S) {
    gamma[i] = -t_change[i] * delta[i];
  }
}

model {
  real Y[T];

  //priors
  k ~ normal(0, 5);
  m ~ normal(0, 5);
  delta ~ double_exponential(0, tau);
  sigma_obs ~ normal(0, 0.5);
  beta ~ normal(0, sigmas);

  // Likelihood
  for (i in 1:T) {
    Y[i] = (dot_product(A[i], delta) + k) * t[i] + (dot_product(A[i], gamma) + m) + dot_product(X[i], beta);
  }
  y ~ normal(Y, sigma_obs);
}
qUmodule_filenameqUBstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.pydq	U
model_cppcodeq
X^  // Code generated by Stan version 2.14

#include <stan/model/model_header.hpp>

namespace anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class anon_model_1988b9d517e3c16daf27a07f09e3de97 : public prob_grad {
private:
    int T;
    int K;
    vector<double> t;
    vector<double> y;
    int S;
    vector<vector<double> > A;
    vector<double> t_change;
    vector<vector<double> > X;
    vector_d sigmas;
    double tau;
public:
    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    anon_model_1988b9d517e3c16daf27a07f09e3de97(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "T", "int", context__.to_vec());
        T = int(0);
        vals_i__ = context__.vals_i("T");
        pos__ = 0;
        T = vals_i__[pos__++];
        context__.validate_dims("data initialization", "K", "int", context__.to_vec());
        K = int(0);
        vals_i__ = context__.vals_i("K");
        pos__ = 0;
        K = vals_i__[pos__++];
        context__.validate_dims("data initialization", "t", "double", context__.to_vec(T));
        validate_non_negative_index("t", "T", T);
        t = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("t");
        pos__ = 0;
        size_t t_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < t_limit_0__; ++i_0__) {
            t[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "y", "double", context__.to_vec(T));
        validate_non_negative_index("y", "T", T);
        y = std::vector<double>(T,double(0));
        vals_r__ = context__.vals_r("y");
        pos__ = 0;
        size_t y_limit_0__ = T;
        for (size_t i_0__ = 0; i_0__ < y_limit_0__; ++i_0__) {
            y[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "S", "int", context__.to_vec());
        S = int(0);
        vals_i__ = context__.vals_i("S");
        pos__ = 0;
        S = vals_i__[pos__++];
        context__.validate_dims("data initialization", "A", "double", context__.to_vec(T,S));
        validate_non_negative_index("A", "T", T);
        validate_non_negative_index("A", "S", S);
        A = std::vector<std::vector<double> >(T,std::vector<double>(S,double(0)));
        vals_r__ = context__.vals_r("A");
        pos__ = 0;
        size_t A_limit_1__ = S;
        for (size_t i_1__ = 0; i_1__ < A_limit_1__; ++i_1__) {
            size_t A_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < A_limit_0__; ++i_0__) {
                A[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "t_change", "double", context__.to_vec(S));
        validate_non_negative_index("t_change", "S", S);
        t_change = std::vector<double>(S,double(0));
        vals_r__ = context__.vals_r("t_change");
        pos__ = 0;
        size_t t_change_limit_0__ = S;
        for (size_t i_0__ = 0; i_0__ < t_change_limit_0__; ++i_0__) {
            t_change[i_0__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "X", "double", context__.to_vec(T,K));
        validate_non_negative_index("X", "T", T);
        validate_non_negative_index("X", "K", K);
        X = std::vector<std::vector<double> >(T,std::vector<double>(K,double(0)));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_limit_1__ = K;
        for (size_t i_1__ = 0; i_1__ < X_limit_1__; ++i_1__) {
            size_t X_limit_0__ = T;
            for (size_t i_0__ = 0; i_0__ < X_limit_0__; ++i_0__) {
                X[i_0__][i_1__] = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("sigmas", "K", K);
        sigmas = vector_d(static_cast<Eigen::VectorXd::Index>(K));
        context__.validate_dims("data initialization", "sigmas", "vector_d", context__.to_vec(K));
        vals_r__ = context__.vals_r("sigmas");
        pos__ = 0;
        size_t sigmas_i_vec_lim__ = K;
        for (size_t i_vec__ = 0; i_vec__ < sigmas_i_vec_lim__; ++i_vec__) {
            sigmas[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
        tau = double(0);
        vals_r__ = context__.vals_r("tau");
        pos__ = 0;
        tau = vals_r__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"K",K,1);
        check_greater_or_equal(function__,"tau",tau,0);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += S;
        ++num_params_r__;
        num_params_r__ += K;
    }

    ~anon_model_1988b9d517e3c16daf27a07f09e3de97() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("k")))
            throw std::runtime_error("variable k missing");
        vals_r__ = context__.vals_r("k");
        pos__ = 0U;
        context__.validate_dims("initialization", "k", "double", context__.to_vec());
        // generate_declaration k
        double k(0);
        k = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(k);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable k: ") + e.what());
        }

        if (!(context__.contains_r("m")))
            throw std::runtime_error("variable m missing");
        vals_r__ = context__.vals_r("m");
        pos__ = 0U;
        context__.validate_dims("initialization", "m", "double", context__.to_vec());
        // generate_declaration m
        double m(0);
        m = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(m);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable m: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec(S));
        // generate_declaration delta
        std::vector<double> delta(S,double(0));
        for (int i0__ = 0U; i0__ < S; ++i0__)
            delta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < S; ++i0__)
            try {
            writer__.scalar_unconstrain(delta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("sigma_obs")))
            throw std::runtime_error("variable sigma_obs missing");
        vals_r__ = context__.vals_r("sigma_obs");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma_obs", "double", context__.to_vec());
        // generate_declaration sigma_obs
        double sigma_obs(0);
        sigma_obs = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,sigma_obs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma_obs: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec(K));
        // generate_declaration beta
        std::vector<double> beta(K,double(0));
        for (int i0__ = 0U; i0__ < K; ++i0__)
            beta[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < K; ++i0__)
            try {
            writer__.scalar_unconstrain(beta[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ k;
        (void) k;  // dummy to suppress unused var warning
        if (jacobian__)
            k = in__.scalar_constrain(lp__);
        else
            k = in__.scalar_constrain();

        T__ m;
        (void) m;  // dummy to suppress unused var warning
        if (jacobian__)
            m = in__.scalar_constrain(lp__);
        else
            m = in__.scalar_constrain();

        vector<T__> delta;
        size_t dim_delta_0__ = S;
        delta.reserve(dim_delta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            if (jacobian__)
                delta.push_back(in__.scalar_constrain(lp__));
            else
                delta.push_back(in__.scalar_constrain());
        }

        T__ sigma_obs;
        (void) sigma_obs;  // dummy to suppress unused var warning
        if (jacobian__)
            sigma_obs = in__.scalar_lb_constrain(0,lp__);
        else
            sigma_obs = in__.scalar_lb_constrain(0);

        vector<T__> beta;
        size_t dim_beta_0__ = K;
        beta.reserve(dim_beta_0__);
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            if (jacobian__)
                beta.push_back(in__.scalar_constrain(lp__));
            else
                beta.push_back(in__.scalar_constrain());
        }


        // transformed parameters
        vector<T__> gamma(S);
        stan::math::initialize(gamma, DUMMY_VAR__);
        stan::math::fill(gamma,DUMMY_VAR__);


        try {
            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < S; ++i0__) {
            if (stan::math::is_uninitialized(gamma[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: gamma" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            {
                vector<T__> Y(T);
                stan::math::initialize(Y, DUMMY_VAR__);
                stan::math::fill(Y,DUMMY_VAR__);


                current_statement_begin__ = 34;
                lp_accum__.add(normal_log<propto__>(k, 0, 5));
                current_statement_begin__ = 35;
                lp_accum__.add(normal_log<propto__>(m, 0, 5));
                current_statement_begin__ = 36;
                lp_accum__.add(double_exponential_log<propto__>(delta, 0, tau));
                current_statement_begin__ = 37;
                lp_accum__.add(normal_log<propto__>(sigma_obs, 0, 0.5));
                current_statement_begin__ = 38;
                lp_accum__.add(normal_log<propto__>(beta, 0, sigmas));
                current_statement_begin__ = 41;
                for (int i = 1; i <= T; ++i) {

                    current_statement_begin__ = 42;
                    stan::math::assign(get_base1_lhs(Y,i,"Y",1), ((((dot_product(get_base1(A,i,"A",1),delta) + k) * get_base1(t,i,"t",1)) + (dot_product(get_base1(A,i,"A",1),gamma) + m)) + dot_product(get_base1(X,i,"X",1),beta)));
                }
                current_statement_begin__ = 44;
                lp_accum__.add(normal_log<propto__>(y, Y, sigma_obs));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("k");
        names__.push_back("m");
        names__.push_back("delta");
        names__.push_back("sigma_obs");
        names__.push_back("beta");
        names__.push_back("gamma");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(S);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double k = in__.scalar_constrain();
        double m = in__.scalar_constrain();
        vector<double> delta;
        size_t dim_delta_0__ = S;
        for (size_t k_0__ = 0; k_0__ < dim_delta_0__; ++k_0__) {
            delta.push_back(in__.scalar_constrain());
        }
        double sigma_obs = in__.scalar_lb_constrain(0);
        vector<double> beta;
        size_t dim_beta_0__ = K;
        for (size_t k_0__ = 0; k_0__ < dim_beta_0__; ++k_0__) {
            beta.push_back(in__.scalar_constrain());
        }
        vars__.push_back(k);
        vars__.push_back(m);
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(delta[k_0__]);
        }
        vars__.push_back(sigma_obs);
        for (int k_0__ = 0; k_0__ < K; ++k_0__) {
            vars__.push_back(beta[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        vector<double> gamma(S, 0.0);
        stan::math::initialize(gamma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(gamma,DUMMY_VAR__);


        try {
            current_statement_begin__ = 25;
            for (int i = 1; i <= S; ++i) {

                current_statement_begin__ = 26;
                stan::math::assign(get_base1_lhs(gamma,i,"gamma",1), (-(get_base1(t_change,i,"t_change",1)) * get_base1(delta,i,"delta",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < S; ++k_0__) {
            vars__.push_back(gamma[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities


        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "anon_model_1988b9d517e3c16daf27a07f09e3de97";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "m";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_obs";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= K; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= S; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

} // namespace

typedef anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97 stan_model;

qUmodule_bytesqT h MZ                @                                       	!L!This program cannot be run in DOS mode.

$       ?QQQIQQQQPQQQQRichQ                        PE  d eY         " 	  P  8     xO
                                                                                d                          
                                                   ` 0	                          .text   N     P                   `.rdata    `    T             @  @.data                         @  .pdata                        @  @.reloc          P             @  B                                                                                                                                                                                                                                                                                                                                H%!T @WH H
s V HHu H
X Hs H	X H _Hs HH\$0X HHu
HWHR0Hu%H
X Hr H	aX H\$0H _HdX H9Ct9H
_X Hr H	/X H,  HCHP0H\$0H _H,X HH! uHCHP0H Hu%H
W Hr H	W H\$0H _=	  t7H԰ H
W Hr H	DA	  W H\$0H _H   
s;H   H
vW Hr H	DA
   mW H\$0H _HP   u	Hr t%Hr H
"W H	)W H\$0H _3H\$0H _LHwH       II     MAu    IAtIIHHRL;uD  LIHHHRL;tIIHHL;u     LIHHHL;tIvI|I@SHPHD$ HHs HL$(O HHT$(HHL$(O HP[E~utAAu2D~tAAu2@WHPHD$ H\$`HHHs HL$(N HHT$(HHL$(N LHASHHL$(N HHT$(HHL$(N H1s HL$(N HHT$(HHL$(N Hs HL$(ZN HHT$(HHL$(`N LHH\$`HP_IcHT$WHPHD$ H\$`HHLHs HL$(M LHHAHL$(M HH\$`HP_H%M @SHPHD$ HL H@s HL$(}M LHHAHL$(M L H&s HL$(KM LHHAHL$(ZM LӮ Hs HL$(M LHHAHL$((M HP[@SH H7p A   E3HL HL LL;tHHL H [  HAL   MtIH@@HtH HH%P LI LYE3EIHL;AM;AEtHHAJICHA3H%P LAL9A ~HHAJI@HA3H%QP H   HD$PO Ht
333
 HĈ   HAH HA@SH HO HH HAHHIH9 uHAP0LnO 3L[H [H[O HC3H [HA H HA @SH HO HH HA HHI H9 uHAP0LN 3L[ H [HN HC 3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H3N HH HA0HHI0H9 uHAP0LN 3L[0H [HM HC03H [HA8H HA8@SH HM HH HA8HHI8H9 uHAP0LM 3L[8H [H{M HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH HL HH HA@HHI@H9 uHAP0LL 3L[@H [HL HC@3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH HK HH HAPHHIPH9 uHAP0LK 3L[PH [HK HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HK HH HAXHHIXH9 uHAP0LJ 3L[XH [HJ HCX3H [HA`H HA`@SH HJ HH HA`HHI`H9 uHAP0LnJ 3L[`H [H[J HC`3H [H\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _HAHH HAHHAXH HAXHAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH HI HH HAHHIH9 uHAP0LH 3L[H [HH HC3H [HA H HA @SH HH HH HA HHI H9 uHAP0LnH 3L[ H [H[H HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH HG HH HA(HHI(H9 uHAP0LG 3L[(H [H{G HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH HF HH HA0HHI0H9 uHAP0LF 3L[0H [HF HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH HE HH HA8HHI8H9 uHAP0LE 3L[8H [HE HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH HE HH HA@HHI@H9 uHAP0LD 3L[@H [HD HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH H3D HH HAHHHIHH9 uHAP0LD 3L[HH [HC HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH HSC HH HAPHHIPH9 uHAP0L.C 3L[PH [HC HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH HsB HH HAXHHIXH9 uHAP0LNB 3L[XH [H;B HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH HA HH HA`HHI`H9 uHAP0LnA 3L[`H [H[A HC`3H [H(   Hr
30  HA H E38  LHuH(H@ ICH@ H H@ IC H@ H H@ IC0H@ H H@ IC8H@ H H@ IC@H@ H H@ ICPH@ H H|@ ICXHq@ H Hg@ IC`H\@ H IH(H\$Ht$WH HHIIHHt
Iօ   HK Ht	HօunHK0Ht	Hօu\HK8Ht	HօuJHK@Ht	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH Hc? HHIHCHQ? H Ht
HuHAP0H5? HK HC H&? H Ht
HuHAP0H
? HK0HC0H> H Ht
HuHAP0H> HK8HC8H> H Ht
HuHAP0H> HK@HC@H> H Ht
HuHAP0H> HKPHCPHz> H Ht
HuHAP0H^> HKXHCXHO> H Ht
HuHAP0H3> HK`HC`H$> H Ht
HuHAP03H [H\$WH HH= HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _H\$Ht$WH HHIIHHt
Iօ   HK Ht
Hօ   HK(Ht
Hօ   HK0Ht	HօunHK8Ht	Hօu\HK@Ht	HօuJHKHHt	Hօu8HKPHt	Hօu&HKXHt	HօuHK`Ht	Hօu3H\$0Ht$8H _@SH H< HHIHCH< H Ht
HuHAP0He< HK HC HV< H Ht
HuHAP0H:< HK(HC(H+< H Ht
HuHAP0H< HK0HC0H < H Ht
HuHAP0H; HK8HC8H; H Ht
HuHAP0H; HK@HC@H; H Ht
HuHAP0H; HKHHCHH; H Ht
HuHAP0Hc; HKPHCPHT; H Ht
HuHAP0H8; HKXHCXH); H Ht
HuHAP0H
; HK`HC`H: H Ht
HuHAP03H [H\$WH HH: HHuH\$0H _HGHHL@pAPHHu
HSHR0HH\$0H _@SH 3Hy  L
: t=H3 Hc
 H3HCHCHLCH   9 HH [3IA0  HHuH [H\$WH H9 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
l Hz  @ǅtH` H
D H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH H8 HHIHCH8 H Ht
HuHAP0H8 HKHCHv8 H Ht
HuHAP03H [@SH 3Hy  L
. t=Hc Hc
 H3HCHCHLCH   7 HH [3IA0  HHuH [H\$WH H7 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
` Hz  @ǅtH H
8 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH 3Hy  L
 t=HS Hc
r H3HCHCHLCH   @6 HH [3IA0  HHuH [H\$WH H5 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
đ Hz  @ǅtH H
 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _@SH H5 HHIHCH4 H Ht
HuHAP0H4 HKHCH4 H Ht
HuHAP03H [@SH 3Hy  L
 t=H Hc
f H3HCHCHLCH   04 HH [3IA0  HHuH [H\$WH H3 HK3HtH{HuHAP0HKHtH{HuHAP0HSHc
 Hz  @ǅtH H
 H\$0H _HH\$0H _H@  H\$Ht$WH HHIIHHt	IօuHKHt	Hօu3H\$0Ht$8H _H   H    2 H Hu y  7 Z  `  H    x2 H Hu΄ {    Z  )  H    A2 HZ Hu   ɍ Z    H%    
2 H Hu`    [    H    1 H Hu)   [ [    H7    1 Hu Hu   $ [  M  H
1 LHl1 H͈ Hu K   &[    H
p1 LH41 H Hu K   )[    H     0 H HuK U  } 4[    Hه    0 HG Hu   F ?[  o  H    0 H Hu݂    J[  8  Hk    P0 H Hu   ؋ U[    HD    0 HR Hu-H h     `[  H HĘ   H    / H/ Hu-HK     O k[  H HĘ   H    / H Hu-H  ҁ    v[  He HĘ   Hˉ    8/ Hه Hu-H  7   [  H HĘ   HX    . H. Hu-Hj < ;  n [  Hσ HĘ   He    . H Hu-H  O  # [  H HĘ   H    W. H8 Hu-H    ؉ [  H9 HĘ   H    . H Hu-H [    [  H HĘ   Ht    - H: Hu-H>    B [  H HĘ   HA    v- H Hu 2    [  '  H:    ?- LH% Hu l  Ĉ [    H H A   HT$hD$`l  HD$XH E3HD$PH HD$HHD$@L\$8HD$0HD$(HT$    , HA Hu l  8 [  a  H܄ L
5 L H_ H$   H  HD$xH    HD$pHK HD$hHg HD$`HӅ HD$XH HD$PHK HD$HH? HD$@H# HD$8H? HD$0HC HD$(H/ HD$ + LHr Hu[ [  }Lz H A   LD$hD$`o  HD$XH AQ
AHD$PH HD$HHD$@L\$8HD$0HD$(LD$ E3Z+ H Hu-܆ [  } o  H H, HĘ   3HĘ   H\$WH HH
l HAL   MtHAL@@Mt	HW A	H9+ HHuH
* LG H H	&- HH\$0H _HB   s HAL   Mu
L@@MtH IH%* LH
&* H? H	H%, H\$Hl$Ht$WH H) MHH(IHE3MH) HHtT3H~&     HHHH H;HCHp  |3H) EHHu
HWHR0MHH\$0Hl$8Ht$@H _DD$HT$HL$SUVWATAUAVAWHhLiHyHq 3Ll$PH|$XIMcLMtI( LLH( HAH( HH( 9J~H
6 ( t3  HtMuYA}CuRHuE9}uMLIIHK  Eu)Ht$LFIcEI;uHVLIbH  H   K$( HH   LpH$   HMNMLH$   ' tQMM~f     IE IH$   H IO,H M}MMH' uLl$PD$   IHH+HLHLH$   HH(Ht
HFH^HL$   HT$XHL$HD$@H\$8Dd$0E3ILt$(D|$ 5' HHtHu
HGHP0H' HHIHhA_A^A]A\_^][H\$Hl$Ht$WH HAIHH   HHu& H& HAH& HH}& 9J~H
7 q& t3ELHHH
w& HHJHu"& HuH
& H H	( HH\$0Hl$8Ht$@H _H\$Ht$WH HAHqHHxH& HAH% L H% A9H~#H
͗ % t3H\$0Ht$8H _HHH
% HHJHu"% HuH
Z% H H	
( Ht$8HH\$0H _H\$Ht$WH H   H0% HHuH\$0Ht$8H _HE3HHHx#HHu
HSHR0H\$0Ht$8HH _HT$SHPHAHH;$    H$ Hl$`HiHHt$pHqH|$xHy BH$ HHi$ 9J~(H
 ]$ tH|$xHt$pHl$`3HP[Ã~Cu!Hu~uDGHT$hLHUNLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(LL$hHE3HD$    # H
# H|$xHt$pHHl$`JHP[H;|# uHA@tHP[@HP[@SHPHAHH;4#   Hw# Hl$`HiHHt$hHqH|$pHy BHO# HH# 9J~(H
 # tH|$pHt$hHl$`3HP[Ã~Cu:Hu9~u0LE33HfLGHcFI;uHWLHHLC(3Ht
HWHOHHLD$HT$@HL$8D$0HD$(HE3E3HՉD$ " H
" H|$pHt$hHHl$`JHP[H;" uHA@t3HP[%Hw E3HP[AE3MMEAMADtMyLMHMyLL;LOM+M33H%|! HD$8IIHtLD$0HLL$0LD$(H%[! @SH HHH
z '! Ht	H H [HH [@SH0HBIH;  t=H;  t4H;  t+3H;! LHy HDHD$ L  H0[  HHDH H0[LH
f! H' H	H%# HLH
2! H	H= L
O H LDH%O# H\$WH LQHHyPHYXHQHLAPLIXMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _HAHHHAPI HAXI3HAHHAPHAXHAWH@|$x HXHhHpHxL`LhHLpt DAH H(3LeHLmPLuXHEHHEPHEX9D$pt6MtI$MtIE MtIMMIH    H HMHHuPH}XLeHLd$0LmPLl$(LuXLt$ Hl$XHHt
HuHQR0HtHu
HFHP0Ht$`HtHu
HGHP0H|$8HuH
  H Hu
HCHP0|$x H\$Pt	A  H@A_HHLT$pM;}	H 
MH LT$0HO; L
 LDIHN HDHА HD$(LD$ LH
t H	  HH@SH HH& H
? H H	LLH [H%k  LI[IkVWATAUAVH03MMICICICH$   HMKH4MCISLI   f     LHT$hHM   IH9   HAHHuH HH9B   HB        MtiHH9tNH	 y' H  HT$ht'HH; u8H9 tHD$ H+HI  HD$ HH+HIH;    HH;   HH9G  H	 y Hf    HT$hHH;u   MtA HHHBH9AuB HT$huHH; uHD$ HH+HIH; u`HH;t9@ HH9   HHBH9Au    HT$hHH;uM   LD$ I    LL$ LD$hHT$(IL 3H\$`Hl$pH0A^A]A\_^H
 L$   HU H	 HT$hHY H HG HH H
Y L$   LH	 {LD$HT$HL$H(HtHLD$@HT$8HL$0H E3HtH;tHLD$@HL$0H LL$8Mt=L;t8I HL$@H^ H9AtH
 H H	    HL$0LL$@HA         LD$@HT$8HL$0 H LD$@HT$8LHD$0H\$HIIHIYXH|$ IyPIAHMAXIQPHt
HuHAP0HtHu
HGHP0H|$ HtHu
HCHP0H\$HH(L9L$8tH
 H H	 EHL$8HAHD$0H HY HHL$0S ,H
 H H	 HD$8HtHHL$8H9 uHAP0HD$0HtHHL$0H9 uHAP0HD$@HJHHL$@H9 8HAP0H(H\$Ht$WH03AHLD$XHT$ E3HHD$XHD$ A t:D  HD$XHH   rs]LD$XHT$ E3H u˅ukHL$XHtaO H
h H	HN LL 3H\$@Ht$HH0_H
9 H LH	n 3H\$@Ht$HH0_H\$@Ht$H   H0_@SH HHu3H [H|$0w HHu
HSHR0HH|$0H [Ht$WH 3HHLAtHALEt]L;VϋMuHHH\$01 HHtHH HHu
HSHR0HH\$0Ht$8H _JDHt$8H H _H\$Hl$Ht$WH 3HHE   HAH;H    H;C uDHDƋAEDuHQ9t$PtH;W΋H   HD   HhhH   H9u   EtGHyBHE Ht9HxHHHU   H
L H	 u3    HHUsHҋ΋EuHW9t$PtJH;W΋Hu5H HHtHHW HHu
HSHR0HHGHH H\$0Hl$8Ht$@H _H;uH H H HAH;n uD9AtH H H H; u0LIIHH3H+HMt
AIu3A;uH;l uAfAnf.zulA   H%J H\$Hl$Ht$H|$ ATH`H 3LH9AP  HiHC  HYH H9C   H LcHs Hl$PHkHT$XHAH HH 9J~H
D     }Cu!Hu}uDFHT$PMHLHS(Ht
HNHFHHHT$HL$@HD$8|$0LL$PE3IHH|$(D$    ; HH9 HIa    HHtNHE HhI$L` HE3HHHHu
HVHR0HuHSHR0HL\$`HI[IkIs I{(IA\H\$WH HAIL   MtAH@@HtH  HHt,HHHHu
HCHP0HH\$0H _3H\$0H _H(H
 H9AuSLI LYE3EIHL;AM;AEtHHAJICHA3H(p y,H(LHrj 
HHtH uH@P03H(HA`HHAhI HApIHHtH I HtH IHtH H\$WH LQ`HyhHYpHQ`LAhLIpMtIu
IBIP0HtHu
HGHP0HtHu
HCHP0H\$0H _LI[IkVWATH0HAHE3IICHAPHICHAXHLaXLaHLaPIKMCISICI L9fHtlHD$ Le L'L#HtHHL$ L9!uHAP0HD$(HtHHL$(L9!uHAP0HD$PHtHHL$PL9!uHAP0   HD$PHtH HD$PHL$ Ht
HHL$ HD$PLD$(MtI HL$ LD$(HD$PHM LHHV`H~hH^pHN`LFhHFpHtHu
HBHP0HtHu
HGHP0HtHu
HCHP03H\$XHl$`H0A\_^H\$Hl$VWATAVAWH@3LH
h HAELL   HHMtHe AH+H@@HtHe H HHe k HH   Mu3B
 HHtwLH
Xj Ll$p-
 LHtU'
 HHtGA
 LHt6Hl$0HD$(LMIHLt$  I$HuIT$IR0Ll$pHu
HVHR0HtHu
HCHP0HtHu
HGHP0H\$xHH$   H@A_A^A\_^H\$WH HAHL   MtAH@@HtH 7 HHu/H
 H	w tH
 LG H H	 HH\$0H _@UVWH H
?e  3HtHh H H   LD$HHT$PHL$XH\$@` H
d HAL   MtHg AH+H@@HtHg H HHg B
 HHt,H	 H=J HE=H HuHCHP0HLD$HHT$PHL$X
 H\$@Hu%L
 H6g H
Gd 
 H _^]H
 EH _^]H\$E3DRHEExIcHD;D~H\$E~.AA+Ù+EIcHLD;}E~#EYE;|IcHD;DA~AAH\$H\$A@WH Dt;H=,g Ht/g HI;g }HHD9Du
HH H _3H _̅Q  H\$Hl$ WH Hf HHuH   5	 H  hH8HHf f @   xf    H\$@Hl$HH _Ht$05]f DHˋLd$8LcD;}*IH9luHH<H   HAP0   f ;u.p@HHcH HHt\5e 5e He LcIM;~(MILL+IAIIIAIAIAuHƉlH<H5e Ht$0Ld$8H\$@Hl$HH _H\$Hl$Ht$WHpHIA HHtAtL  H
~ DH 	H HHu(Hu
HCHP03L\$pI[IkIs I_H[^ H
` E3HL$hl$`H|$XH\$PHD$HHD$@HD$8HD$0HD$(HL$ E333 HHu
HSHR0Hu
HWHR0HpHl$WATAUH MALt,tDADH\$@Ht$HEt6H5d Ht*d H΋0;}HcHD9Du	HH,MDŋIfHHtotHЋH
 L` E3H	H HHtHȉh| HtHu
HCHP0HtHu
HGHP0Ht$HH\$@Hl$PH A]A\_H( H(H( H(H( H(H( H(H( H(H(n H(H(N H(H(. H(Htfff     H   H;tHu3H; ø   H;tMLX  Mt#MH3M~IHH9t-HHI;|3H   H;tHu3H;* ø   @SVH(H Hl$@H|$HH(Ld$PLl$XLeHLmPLt$ LuXHEH    HEP    HEX    IHHt uH uHH uH 3HMHH}PH]XLeHLd$PLmPLl$XLuXLt$ Hl$@Ht
HuHAP0HtHu
HGHP0H|$HHtHu
HCHP0H(^[H;u   HAH; t      t
   rH% L3H\$WH IHH;t\I;tWHAH;s t;      t
   r%] u*HHM uH\$0H _H\$0H _/   H\$0H _Ht$WH HH
}  HHuHt$8H _H HWHH\$0& HH   HH      uH
 LGH| H	 %HG H9C t-H
 LGH| H	 Hu
HCHP03Hu
HFHP0Ht$8HH\$0H _H
 H	 t HH xHWLHD xHHH\$IMLI HHI`LZhLRpHB`IHBhHHBpIMLH\$@SUVH LQHHYPLYX3HHLT$XH\$@L\$PHAHHAPHAXMuVMtIHL$PH9uHAP0H\$@HtHHL$@H9 uHAP0HE H H; H3H ^][L M;   HuH H H L\$PLT$XqHK   sSH{|	H[HH H H HD$@HHL$@H9 uHAP0L\$PLT$XL\$PLT$XI   H   MtIHL$PH9 uHAP0LT$XI
HL$XH9 uHAP0H3H ^][M M;tbIBH;
 t%      tA   rII
 
3Iu"LL$PLD$@HT$XHH ^][LD$PHT$@HL$X
 H HL$@HH9AtHIHx
 tHD$PH|$HHtHHL$PH9 uHAP0HD$XHHL$XH9 uHAP0HL$@HAL   MtHRS AH,L@@MtH:S H AHH'S a  HHD$@HHL$@H9 uHAP0Ht#3H HHu
HSHR0Hu!E3E33HL
 IH=
 H>H|$H3H ^][H\$WH HQ Hy(HY03HA HA(HA0HtHu
HBHP0HtHu
HGHP0HtHu
HCHP0H\$0H _H
)
 Hx H	H%( H

 Hx H	H% H(HtH
  H	  H(H\$VH AhHHمu2Ht-H;}
 t$H
 H
x H	  3H\$8H ^Ãu"HtH
>  H	-  3H\$8H ^Hy  H
 H|$0H8tSHA0HtHHHGHtH HGHAHC LG`HWhHOpHG`HC(HGhHC0HGpLC HS(HK0A2HG`HC HGhHC(HGpHC0HC HtH HC(HtH HC0HtH LHHClSH|$0Cl H\$8H ^@SH HH   H
 HH9ZHuwH
 Ht$0H|$8L 3I HJHHrPHzXLBHHBPHBXHt
HuHAP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$8HH [H\$WH 3HHIHHD$0HtHGHHuHAP0H

 HT$0H	H\$0E3HHHHtHu
HSHR0HH\$8H _@SH HHIH{l tH

 Hou H	
 3H [HtYClHAH;RW u H;
 u   LHR Cl Hu.HHHH [0E3HHHH [H\$Hl$Ht$ ATH HV 3HLH9BuH  HH      AlHBH|$0L   MtHpS HAH2L@@MtHUS HH AHH?S H
 HHu%H
 H	>
 u	H
 3
 '3H^
 HHu
HGHP0HDH|$0AD$l HtHu
HSHR0H\$8Hl$@Ht$HH A\@SH HHIH{l tH

 Hos H	
 3H [Ht4ClHAH;RU u   Cl HuHH [H
 E3HH [H\$WH yl HYHHt$H
 Hr H	
 3H\$8H _HtIHHHt$0HOHHtHGH    HuHQR0Hu
HCHP0Ht$0uH
 H	
 3HDB9Ht4H u
HPHR0H

 Hr H	
 3H\$8H _
 Ht*L
 Hg
 HM H
 Hd
 H\$8H HU
 H _LL$ LD$SUWH0yl HYHHHt!H
8
 Hq H	8
 3H0_][Ht$PH   HH
 t$xL I;t?HBH;
 t$      t
   rIH
 
3Ht|txHH<Hu
HSHR0HOHHtHGH    HuHAP0xLD$hHT$`E3H3E33HHHHt$PH0_][GlHCH;R u+HD$pLL$hLD$`HHˉt$(HD$ H  L   MtH@Q HAH2L@@MtH%Q HH AHHQ H
 HHucHu
HCHP0H
 H	
 uHt$PGl3H0_][
 HOHHtHGH    HuHAP0Gl HT$pHtH
 H"LL$hLD$`HHHD$     T
 HHu
HFHP0Gl Hu
HCHP0HuH HHLI[WHP3HA   IC ICICICIC HICICEAHe HIC"
 u
3H\$`HP_LL$pLD$xHT$@HD$(   H\$ H\$`HP_H\$Ht$WH HHIIHHt	Iօu\HK@Ht	HօuJHKHHt	Hօu8HK Ht	Hօu&HK(Ht	HօuHK0Ht	Hօu3H\$0Ht$8H _H\$WH HHI3HtH{HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP03H\$0H _@SH H1
 H{8 t	H
 {h |&H
 L[HAx  H; H
 HH
 H [@SH yh H   H   Hw
 Hl$0Ht$8H03HnHH|$@H~PLd$HLfXHFHHFPHFX9AhuHt0HHu
 HtH
 
H uH@P0MLHHsHHLd$HH|$@Ht$8Hl$0tHH [HAPHHD
 H H(LHt2HB   s$HIPHIPPHt
HuHAP03H(H
 Hk H	
 H(HAXHHD
 H H(LHt2HB   s$HIXHIPXHt
HuHAP03H(H
C
 HDk H	K
 H(@SH HHQLAMtI 3Al AhHA@HAHHA HA(HA0HA8HD$PHtH HAXMtIHD$XLIPHtH HA`z
 HH [H\$Ht$WH0HH
 HH   LR
 Hj H
    LK Hj H
    Hj LH
 xpLMI H~j H
 xULLú  HHD$     t
 Ht3H u
HPHR0HuiHCHP0HH\$@Ht$HH0_Hu
HCHP0H
 H
$
 Hj H	A   
 yHu
HGHP03H\$@Ht$HHH0_Hi H(=L     H
k B
 Hu13
 H
~
 H?k H	A   p
 y6H(Hui HL    HHtH uH@P0H
/k 
 Ht+H5i HHtH uHPHR03H(
 3H(H(H
 H
 H H
 H HuI HH(H  A   L`l H$  AQD$    "
 $
 L H$  LȺ   
 D$  D8$  u$  8$  u
3H  H$  L$  L*l HD$(Hk HL$0   HD$ 
 HT$0A   3
 H  @SH 
 HHuH [HH|$0@
 HHu
HSHR0HH|$0H [H\$Hl$Ht$H|$ ATAUAVH  EILL}
 HH<  H
 HHu
HWHR0H  IC
 HH   HHk
 HHu
HVHR0Hu
HSHR0H   HG      uH
 Hk MH	M"
 |HG EuGH;vEHl$0HD$(Lk HL$@Mͺ   Ld$ 	
 HT$@E331
 x1HMH;tH
 Hk MH	MHl$(HD$ 
 HuHGH
Hu
HCHP03L$  I[ Ik(Is0I{8IA^A]A\@SH H9 Hte{  HKtHSE3H
 {" t
 
HSH
 HHHH9 t&H	
 u6
 H(H; u3H [ÃH [H\$WH HH
 HHIH;t6
 u,HT$0LHm
 HL$03҅HHHH\$8H _HCHH{ tHC(H\$8H _H6
 H\$8H _H(E3H;
2
 AH;
 AH;
 
 AAu
 H(@SH0HAHH
 L@H	LLD$ LHci 
 Hu
HCHP03H0[@SH HA3ۋ         H@`H|$0HtbH   HtH=
 HH   Ht<H=h HHt+HC   r=r7HHH|$0H [

 HuH
 Hh H	
 HH|$0H [HHH [H(HAH;a
 u	HcAH(H;
    LAIHH3H+HMtA3I   HH(IIw;HB  HAIHHH(ËAIHHHH(H(H%
 H\$0
 HHuHH\$0H(HH|$ 
 HHu
HSHR0H\$0HH|$ H(f    
        ~      HT$tHHHD$LD$HكH;HL$IMH HT$tHHHD$LD$HكH;HL$ICH Hq\ H+b\ HH\$Ht$WH`Hz
 )|$@3D)D$0D)L$ HHD
 8HA H+AHfAWHtTH;r
 HOH@f/v#HG H+HH;r
 HOHxHG HH+HH;rHO fEWH+OHH   )t$Pfff     H
 0H;rz
 H_fAWH@f.zt1HG H+HH;rJ
 H_H@\V	 DXHO HH+HH;r(t$PfA(;	 H\$pHt$xD(D$0D(L$ X(|$@H`_LD$HL$WH0HD$ H\$XIHD$H    H HHQHI
 D$H   H
 HH\$XH0_H\$Ht$WH L   HIL+   IgfffffffHIIHHH?HH;r2H\$0Ht$8H _H   IH+   HHHH?HH;r
 H   HHHx
 H\$0Ht$8H _HL$WH0HD$ H\$HIMHLAHy rLYLYE3AHAMtHyIHHIHMyMM;MOL+M33
 H6LHD$hHtLD$`IIHLL$`LIIU
 HH
 HH\$HH0_H(HB   s'HAL   MtAL@@Mt	H A
 Hu9L
 D@`H
 P
  4 `   = P
  L
B7 3H(HT$HL$SVWAUH8Li3339Yht3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'HR ,4 i   ^= 
  H6   ,
 LHu'H 3 i   )= 
  H6 a  IEHHHuEH
Y
 L HkR H	
 L˚ 3 i   LB6 < 
    HAH;
 tyH;
 tpHS
 HHu'H
| V3 i   < 
  H
5   H@L   Mu2HE 3 i   Q< 
  H5   H3HE3LdD  MuFHL
 H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AH;
 H	0
 HHtdHu
HSHR0IULI3
 uHu
HGHP03H 1 i   :   HQ4 (  H 1 i   :   H*4   H

 L HP H	
 Lx R1 i   L3 }:      

 HtH
 HHty
 Hu
HFHP0H\$`HL$hLK0LC(HS HHC0    HC(    HC     Ch/Lt$(Ld$0Hl$pIL|$ H8A]_^[H 0 i   9   H$3 MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
2 D0 Q9 H
 HHHATAUH8HXHhHp HxE3LpLxHBLMIH;
 t|H;
 tsHH
 HHu'H / m   8   H2   H@L   Mu3Ht N/ m   8   H1   HHIMHl MuFH|
 H9GuH;w  HGHH\HH,H;w   H] HHHHAHH   ILHt
HuHQR0HI'
 HHtVHL$PLI
 tHWHCHP0HH [. n   7   H0    HZ 4. n   f7   H0    
 HtH
 HHtbs
 Hu
HGHP0L-
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\H - m   6   H0 Hu
HGHP0HtHu
HCHP0L
/ DF- |6 H
  SH\$Hl$Ht$WH H/ HH
k
 E333oHHu'H  , q   6 D  Hm/ a  HCH5 HL   MtAL@@Mt	H A
 HHu5 F     H
 H9C&  H{H  HsHHHHHuHAP0HH輴HHuH
= S5 S  H
. QHu
HGHP03Hu
HCHP0   =
 HH   5 Z  H Ha. HE + q   u
HEHP0HtHu
HFHP0HtHu
HCHP0HtHu
HWHR0L
 . DU+ 4 H
D /3cHHH/]4 V  QH
4 HHHHh Hp(H
 HH
 HH0H
 HH
 HH8H\$0Hl$8Ht$@H _H(IL$0
 Hu9L
 D@PH

   }* P   3   L
- S3H(H(y tH
 H Hu
 Ht
 H Hj
 Hu9L
6 D@QH
+    * Q   23   L
, 3H(H\$WH E3H;
 HAE3H;{
 A3H;
 DEuH
 DEÀuRN
 HtGL
 H

 
  AQ   R) Q   2 
  L
+ (H\$0H _È_H\$03H _HAH HAH\$WH LJHHL;
=
 trH;
 tiH
 MIL
 H	H
 
 L
 H

 T
  AR   L
0+ ( R   1 T
  _H\$0H _HHAHHIH9 uHAP0H_H\$03H _@SH H
 HH HAHHIH9 uHAP0L
 3L[H [H
 HC3H [HA H HA H\$WH LJHHL;
 trH;L
 tiH
[
 MIL H	H 
 L
q H
 
  AS   L
) 2' S   d0 
  H\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH H
 HH HA HHI H9 uHAP0Ln
 3L[ H [H[
 HC 3H [H(A(A
 Hu9L
u D@TH
J 
  ?& T   q/ 
  L
( 3H(@SH0H[
 )t$ HH9Bur
H
 f(f.5 zTuR
 HtGL
 H
 -  AT   % T   . -  L
>( (t$ H0[s((t$ 3H0[HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H
 HH HA0HHI0H9 uHAP0L~
 3L[0H [Hk
 HC03H [HA8H HA8H\$WH LJHHL;

 trH;
 tiH

 MIL 
 H	H
 H
 L
1 H
   AV   L
& # V   $-   H\$0H _HHA8HHI8H9 uHAP0H_8H\$03H _@SH HS
 HH HA8HHI8H9 uHAP0L.
 3L[8H [H
 HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH Hs
 HH HA@HHI@H9 uHAP0LN
 3L[@H [H;
 HC@3H [H(AH!
 Hu9L
U D@XH
j	 }  " X   Q+ }  L
$ 3H(@SH0H;
 )t$ HH9Bur
H
 f(f.5a zTuR
 HtGL
È H
<	   AX   ! X   *   L
$ a(t$ H0[sH(t$ 3H0[HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH H
 HH HAPHHIPH9 uHAP0L^
 3L[PH [HK
 HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH H
 HH HAXHHIXH9 uHAP0L~
 3L[XH [Hk
 HCX3H [HA`H HA`H\$WH LJHHL;
 trH;
 tiH

 MIL( H	H& H
 L
1 H
:   A[   L
!  [   $(   H\$0H _HHA`HHI`H9 uHAP0H_`H\$03H _@SH HS
 HH HA`HHI`H9 uHAP0L.
 3L[`H [H
 HC`3H [H\$Ht$WH H5! H
$ HH
 HHtH H蒠HHu'H  m  '    Hp     H,
 H9CuHHp
 HHuH
 &    H
0  .E3HHHHuyH &    H   HN m  u
HGHP0HtHu
HCHP0L
 D U& H
 3H\$0Ht$8H _Hu
HWHR0Hu
HSHR0H\$0HHt$8H _H\$Hl$Ht$ WATAUH@3MHHH\$pM   LjIMtH   HZH\$pI
 HMu H" IO
 HHD$pHtPHH   H' LL$pH HD$(E3ILl$ Ϋy$  YH\$p   Hzt}HGH
 L
; H	HD$0HO
 HD$(L H; HD$    
 $  L
 H
 A  $ z   L
 Z%HZHHEHHMH9 uHAP0H]3H\$`Hl$hHt$xH@A]A\_HT$HL$SVWAUH8Li3339Yht3H8A]_^[Hl$pLd$0Lt$(L|$ Mu'H    # l%  H_   
 LHu'H    # m%  H* a  IEHHHuEH
 LZ H9 H	
 Lk E   L p# o%    HAH;
 tyH;
 tpH
 HHu'H
    (# t%  H
   H@L   Mu2H    " v%  HR   H3HE3LdD  MuFH
 H9FuH;n  HFHH\HI,H;n  I$HHIHAHH[  IMI]Ht
HuHAP0IE3HHH   HIUHHB   s8HAL   MtAH)L@@MtH AH
 H	
 HHtdHu
HSHR0IULI3F
 uHu
HGHP03H ^   ! %  H (  H] 7   i! %  H   H
 L H6 H	/
 L    L ! %     
 HtH
 HH{ty1
 Hu
HFHP0H\$`HL$hLK0LC(HS 足HHC0    HC(    HC     ChLt$(Ld$0Hl$pIL|$ H8A]_^[HW~ 1   c  %  H MtIu
IGIP0E3HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
f D  H

 蕻HHHATAUH8HXHhHp HxE3LpLxHBLMIH;
 t|H;
 tsHH"
 HHu'HK} %   W Q&  H   H@L   Mu3H}      S&  H   HHIMHl MuFH
 H9GuH;w  HGHH\HH,H;w   H] HHHHAHH   ILHt
HuHQR0HI
 HHtVHL$PLI.
 tHWHCHP0HH!|    - &  H    H{     ~&  Hg    
 HtHp
 HH]tb
 Hu
HGHP0L-L
 IE L|$ Lt$(H|$0Ht$hHl$`H\$XMtI$uIT$IR0IH8A]A\HP{ *   \ n&  H Hu
HGHP0HtHu
HCHP0L
 D  H
U SATAVHHHI H\$`Ht$pH H55 L5. H|$@L|$0LH
 E3HI
 HHtH HHHl$hLl$8Hu'Hez ?   q &  H 9  HCL   MtH HAH2L@@MtH HH AHH H
 HHu'Hy     &  HR z  Hu
HCHP0Hƾ
 LnII9E   H^H  HnHHHE HHuHAP0Hs
 LmI9E    E3HT$ HEAH\$ Lt$(_HHu'H0y 
   < &  H   Hu
HCHP0IHu
IE HP0HE Iu
HEHP0   
 HH  Hx     '  H( :     о
 HHu'H
x [    &  H
   HXIE3HHLp I襗HHu'H6x    B &  H   Hu
HGHP0IIHcHHHw     &  HM _  IGH IGHEIGL   MtHb IAH1H@@HtHG IH HH2 Ia
 HHu'HRw ,   ^ '  H    HC
 IH9G4  H_H'  HwHHHHHuHAP0HHYHHu$Hv      '  HG \Hu
HCHP0IHu
HGHP0   ϼ
 HH   H|v V    ''  H HtHE u
HEHP0HtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L
 D  H
 輳~H袘HH,Hu     #'  H< NH  LH HGHo Hw(H?
 H H5
 HG0H*
 H H 
 HG8L|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@VWAUH0HA3LL   MtH AH,L@@MtH H AHH ʻ
 HH\$PHl$XLd$`Hu'Ht 
     #)  H   H
 Lg3I9$c  H_HV  HoHHHE HHuHAP0HK
 LeI9$   E3HT$ HEAH\$ Ll$(7HHu'Ht      6)  Hu   Hu
HCHP0Hu
I$HR0HLd$`Hl$XH\$PH0A]_^ù   
 HHu'H
s m     D)  H
     HXIE E3HHLh 3跒HHu$HHs "    T J)  H RHIHFHP0:IHwHH#Hr       0)  Ha Hu
I$HP0HtHu
HCHP0HtHu
HVHR0L
  Du  H
T O3H\$VWAUH0H= LH
 H37
 HHtH H貍HHl$PLd$XHu'Hr 
 Q  % .0  H
   HCHkL   MtH HAH2L@@MtH{ HH AHHe H
 HHu'Hq o
 Q   00  H
 T  Hu
HE HP0HGL   MtHf HAH2L@@MtHK HH AHH5 H
 HHu'Hq 	 Q   30  Hr   Hu
HGHP0H
 Hk3H9E d  H{HW  LcHHI$HIuHAP0H
 Il$H9E    E3HT$ IEAH|$ Ll$(LHu'HPp *	 Q  \ G0  H   Hu
HGHP0Hu
HU HR0ILd$XHl$PH\$`H0A]_^ù   *
 HHu'H
o  Q   U0  H
H    HxIE E3HILh 3LHu$Ho j Q   [0  H
 RHIHFHP0:IH运LH#H<o  Q  H A0  H
 Hu
HE HP0HtHu
HGHP0HtHu
HVHR0L
h
 D  H
\ 藬3ATAVHHH\$`Ht$pH|$@H= E3L|$0LH

 HMIa
 HHtH H܉HHl$hLl$8Hu'HCn  T  O 0  H	 G  HCL   MtH HAH2L@@MtH HH AHH HҴ
 HHu'Hm  T   0  H0	   Hu
HCHP0HGL   MtH HAH2L@@MtHy HH AHHc HB
 HHu'H3m 
 T  ? 0  H 
  Hu
HGHP0H
 LkII9E   H{H  HkHHHE HHuHAP0H
 LmI9E    E3HT$ HEAH|$ L|$(證HHu'H~l X T   0  H H  Hu
HGHP0IHu
IE HP0H
t LܐHH  Hl  U  % 0  H      .
 HHu'H
k  T  
 0  H
L   HxIE3HHLx IHHu'Hk n T  
 0  H ^  Hu
HFHP0IIHHHH>k  T  J
 0  H   HDy'Hk  U  
 0  Hu    Hu
HCHP0E*  HEL   MtH HAH2L@@MtH HH AHH H~
 HHu$Hoj I U  { 0  H LH	 E3H蠉HHu~H1j  U  = 0  H Hu
HCHP0HtHu
HGHP0HtHu
HFHP0L
] D  H
  茧Hu
HCHP0HHE LL|$0Ll$8H|$@Ht$pHl$hH\$`MtIu
IVIR0IHHA^A\@SH HAL   MtH AH,L@@MtH H AHH 
 HHt$0H|$8Hu'Hh  X  
 01  HV   Hڭ
 3H9C   H{H   HsHHHHHuHAP0HHHHu$Hrh L X  ~
 =1  H eHu
HGHP0Hu
HSHR0HH|$8Ht$0H [HڊHHuHh   X  
 @1  Hx HtHu
HCHP0HtHu
HWHR0L
G D  	 H
 vH|$8Ht$03H [@UATH(HAH\$@E3L   Ht$HLl$ LIIMtH  AH,L@@MtH  H AHH{  
 HH|$PHu'Hg  [  
	 1  Hn   ۫
 HHu'Hf  [   1  H9       
 HHu'H
f l [   1  H
    IE LhH LH
 y$HLf & [  X 1  H LHu
HCHP0H LHmHHuIHe  [  
 1  Hk Hu
HFHP0HtkHueHGHP0YHu
HFHP0Hu
HGHP0IHH
 HHuYH~e X \   1  H  HtHu
HCHP0L
  D$ Z H
 LLl$ H|$PHt$HH\$@HtHE u
HUHR0IH(A\]H\$Ht$H|$ ATAUAVH@H= LH
 LHM3
 HHtH HHHl$`Hu'H|d V _   2  H   HCL   MtH HAH2L@@MtH HH AHH H
 HHu'Hc  _   2  Hi   Hu
HCHP0HGL   MtH HAH2L@@MtH HH AHH H{
 HHu'Hlc F _  x 2  H   Hu
HGHP0HM
 33H9Cu+H{Ht"HCHHH HHuHAP0   H
 H9C   HcHT$(DEHE3HH+H|$ Lt$(Ll$0Ld$8HHu'Hb  _   .2  H    H#  H  HGHP0
  EHc
 HHu$H
Qb + _  ] <2  H
 dHtHx3IHcE3LtIE Ll I$HHLd(^HH   Ha  _   J2  HX Hu
HCHP0HtHu
HGHP0HtHu
HVHR0L
 Dl  H
 F3#Hu
HVHR0Hu
HSHR0HHl$`H\$hHt$pH|$xH@A^A]A\AVAWH8HAE3H\$PL   Hl$XHMMtH AH,L@@MtH H AHH 
 HHt$`H|$0Ld$(Ll$ Hu'H` t    `4  H ]  H
 IH9C   H{H   HsHHHHHuHAP0HH衁HHu'H
"`    . m4  H
   Hu
HGHP0IHu
HCHP0HIu
HFHP03
 HHu^H_     }4  H" 9  HMHHuH~_ X    p4  H   HM H;

 u>H

 H
 H	
 L3_ 
   L 8 4    H n
 HHu'H^     4  Hd {  H@H;
 t|H;
 tsHH|
 HHu'H^      4  H )  H@L   Mu3Hn^ H   z  4  H   HHIMHu
HCHP0LdMuFHi
 H9GuH;o.  HGHH\HI,H;o  I$HHIHAHH   ILHt
HuHAP0H H
 HHtoHNH9N ~H HFHHAHFHHm
 uH:HCHP0+HQ] +   ] 4  H    H*]    6 4  H    
 HtH
 HH荞tkC
 Hu
HGHP0HHLu
HFHP0Ll$ Ld$(H|$0Ht$`Hl$XH\$PMtIu
IWIR0IH8A_A^Hw\ Q    4  H HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
 D ) H
 ͙;HHHATH   HXHpHxLhLpE3LxHALL   L$   ML$   Lt$ L$   IIMtH] AH,L@@MtHE H AHH2 T
 HH$   Hu'H=[    I 8  H >  H.
 IH9C   HkH   LcHE HI$HIuHAP0HIB|LHu'HZ     8  H0 U  HE u
HEHP0IHu
HCHP0I$uID$IP0IEL   MtFH> IAcH}LHuH7Z    C 8  H   L@@MtH IH AH I
 Hu'HY     8  HL   L% H
 H$   I
 HHtH IuHHu'H|Y V    8  H   HCL   MtH HAH2L@@MtH HH AHH H
 HHu'HX     8  Hi   Hu
HCHP03
 HHu'HX     8  H" G  IM H;
:
 u>H
I
 H:
 H	Q
 LjX D   L o 8    HC 
 HHu'H
.X    : 8  H
   H@IH;G
 t{H;F
 trHM
 HHu'H
W     8  H
F k  H@L   Mu0HW |    8  H 4  HHMHu
HGHP03NlfMuFH
 H9FuL;f:  HFIJ|HI,L;f  I} IHIHAHH   H$   H$   Ht
HuHAP0H* H9
 HHtmHKH9K ~H HCH<HAHCHH
 uHu
HGHP03#H|V V    9  H   HUV /   a 9  H 
  
 Ht H˞
 HH踗   j
 Hu
HFHP0H
 E3LmII9E x  HuHk  LeHHI$HIuHAP0H
 Ml$I9E    E3HT$(IEAHt$(H\$0rLHuNHqU K   } '9  H 
  HJU $   V 9  H   Hu
HFHP0HI   HCHP0      3
 HHu'HT     79  HQ v  HpE3HIIHX tLHu'HT v    =9  H	 K  Hu
HGHP0IJHHuLHu'HMT '   Y  9  H   Hu
HCHP0HE u
IE HP0H
- L$   xHHu'HS     M9  HV   H@L   MtH HAH2L@@MtHo HH AHHY Hx
 HHu'HiS C   u O9  H   HE u
HEHP03 
 HHu'H!S    - R9  H 
  H$   HI H;
 u>H
 H
 H	
 LR    LE  V9  }
  H 	
 HHu'HR l    X9  H $
  H@H;
 txH;
 toH
 HHu'HDR    P ^9  H 	  H@L   Mu3H
R     `9  Hz 	  HHMMHu
HCHP0NdMuFH
 H9FuL;~<  HFIJ\HI,L;~  I$IHIHAHH   H$   H$   Ht
HuHAP0H& H
 HHtoHMH9M ~H HEHHAHEHH
 uH0HCHP0!HP     9  HS x  HP     9  H, Q  Q
 Ht H5
 HH"   ԕ
 Hu
HFHP0Hu
 LoII9E x  HwHk  LgHHI$HIuHAP0H"
 Ml$I9E    E3HT$8IEAHt$8Hl$@
mLHuNHO     9  HK   HO     |9  H$ I  Hu
HFHP0HE Iu
HEHP0I      
 HHu'HQO +   ] 9  H   HpHh E3HIIIunLHu'HO     9  Hs   HuZHCHP0NHH9pLHu'HN     9  H' i  HE u
HEHP0IHu
IE HP0H
 Ld$ sHHu'HVN 0   b 9  H   H@L   MtH7 HAH2L@@MtH HH AHH H
 HHu'HM     9  HC   Hu
HGHP0H
 LkII9E   H{H  LcHHI$HIuHAP0Hd
 Ml$I9E    L$   E3HT$HEAIH|$HL|$PGjLHu'HM    $ 9  H   Hu
HGHP0IHu
IE HP0IL$   MHuHAP0HC
 D90  H$   4
 HH  HL b    9  H M     
 HHu'HNL (   Z 9  H   L$   HxE3IHILx IjkLHu'HK     9  Hh   HE u
HEHP0IL$   HImLHHK v    9  H	 .  I
 Hu'HfK @   r 9  H +  H;t7H
ڒ
 H	ѓ
 L*K    L / :    H
+ oHHu'HJ     :  H\   H@L   MtH0 HAH2L@@MtH HH AHH H~
 HHu'HoJ I   { :  H   Hu
HCHP0   $
 HHu'H%J    1 :  H   I$H@HL$ L HHCHHH
 LmII9E K  H}H>  LeHHI$HIuHAP0H
 Ml$I9E uvE3HT$XIEAH|$XH\$`fLHu'HhI B   t -:  H    Hu
HGHP0H  HCHP0u     T
 HHu'HI     =:  Hr    HxE3HIIHX ,hLHu$HH     C:  H* oH   HFHP0   HHiLH   HiH C   u &:  H HtHu
HCHP0E3E3HtHE u
HEHP0HtHu
HGHP0HtHu
HFHP0L$   L$   L
` D  H
 菅M(Hu
HCHP0HE u
IE HP0I$MH$   L$   H$   H$   H$   H$   Ht
HuHAP0MtIu
IGIP0HL$ L|$xHt
HuHAP0MtIu
IFIP0H$   L$   HtH u
HPHR0IHİ   A\H\$WH HYPHCH;
 u3H9CtIHCHHpH;
 u3H9Ct'H[HQHHhHtHAHt3HH33
 HHu3HH
 HHu
HGHP0Hu?L
 F A  ;  H
 L
 D  Ń3H\$0H _H H@
 HHucL
E HA  ;  D L
4  uHSHR0L
 Dp  H
o
 J3H\$0H _Hu
HSHR0HH\$0H _HAHH HAHH(HIXH HAL   MtAL@@Mt	H A
 Hu;L
D H
!
 <  A      <  L
3 v3H(HAXH HAXH\$Hl$Ht$H|$ ATAUAVH@H3 LHI@E3E33EE33uHHu'H D    , 7=  H /  E3H;
 A3H;
 3H;=
 AuH
 DEy    9=  !  Hu
HGHP0E  H! H L- H IEIL   MtAL@@Mt	H AH
 HHu'H9C    E N=  H H  H*
 LcI9$j  HsH]  H{HHHHHuHAP0Hۈ
 LgI9$   IF(E3HT$ EAHHt$ HD$(_HHuu    a=    Hu
HFHP03Hu
I$HP0   
 HH   #   U {=       e
 HHu'H
B    " o=  H
   HpIF(E3H IF(HH3HE 3aHHu    u=  *  HE u
HEHP03*IV(HbHH\    [=    H
r E3HHx`HHu%   W =    Hu
HCHP0E3E33HlHu
HGHP0H@     =  Hh   Hd IN@E3EArHHu    =    H{Dyn    =    Hu
HGHP0E   IN L
 I;uEH
;
 L(
 HM
 H	D
 L-@    L 2 =  <  H dHHu    =  X  H;
 H u
H@HP0E3AE  H H L- H IEIL   MtAL@@Mt	H Al
 HHu'H]? 7   i =  H l  HN
 LcI9$J  HkH=  H{HE HHHHuHAP0H
 LgI9$   IF(E3HT$0EAHHl$0HD$8[HHu =    HE u
HEHP03Hu
I$HP0   
 HH    =        
 HHu'HL> &   X =  H    HhIF(E3H IF(HH3HF i]HHu =  cHu
HFHP03BIV(HB_HH* =  (H
 E3HHx]HHuc =  l   H= H HtHu
HGHP0HtHu
HCHP0HtdHu^HFHP0RHu
HCHP0E3E33HhHu
HGHP0H=     =  Ho HtHE u
HEHP0L
R D  H
 zMtIE u
IUIR03
H@
 H H\$`Hl$hHt$pH|$xH@A^A]A\H\$Ht$WATAUH@H LH
 LH3
 HHtH HWHHl$`HHu'H<  $   hA  Ho   H
 33H9Au%HYHtHqHHHuHAP0   H
 H9F   IEHT$(DEHD$(HcE3HHH\$ H+Ld$0XHHu'H[; 5 $  g yA  H    H"  H  HCHP0	  EHcM
 HHu$H
:  $  
 A  H
k cHtHX3IEHcE3H IEHHDI$Ld HZHH   H: s $   A  H Hu
HFHP0HtHu
HCHP0HtHu
HWHR0L
 D P H

 w3#Hu
HWHR0Hu
HVHR0HHl$`H\$hHt$pH@A]A\_HAH HAH\$WH HHAHHHIHH9 uHAP0H_3H\$0H _H\$0HW3H _@SH H
 HH HAHHIH9 uHAP0L
 3L[H [H
 HC3H [HA H HA H\$WH LJHHL;
e
 trH;\
 tiH
k
 MIL
 H	H
 
 L
8 H
 FB  A  L
 B   t FB  vH\$0H _HHA HHI H9 uHAP0H_ H\$03H _@SH H~
 HH HA HHI H9 uHAP0L~~
 3L[ H [Hk~
 HC 3H [HA(H HA(H\$WH HHA(HHHI(HH9 uHAP0H_(3H\$0H _H\$0HW(3H _@SH H}
 HH HA(HHI(H9 uHAP0L}
 3L[(H [H}
 HC(3H [HA0H HA0H\$WH HHA0HHHI0HH9 uHAP0H_03H\$0H _H\$0HW03H _@SH H|
 HH HA0HHI0H9 uHAP0L|
 3L[0H [H|
 HC03H [HA8H HA8H\$WH HHA8HHHI8HH9 uHAP0H_83H\$0H _H\$0HW83H _@SH H|
 HH HA8HHI8H9 uHAP0L{
 3L[8H [H{
 HC83H [HA@H HA@H\$WH HHA@HHHI@HH9 uHAP0H_@3H\$0H _H\$0HW@3H _@SH H#{
 HH HA@HHI@H9 uHAP0Lz
 3L[@H [Hz
 HC@3H [HAHH HAHH\$WH HHAHHHHIHHH9 uHAP0H_H3H\$0H _H\$0HWH3H _@SH HCz
 HH HAHHHIHH9 uHAP0Lz
 3L[HH [Hz
 HCH3H [HAPH HAPH\$WH HHAPHHHIPHH9 uHAP0H_P3H\$0H _H\$0HWP3H _@SH Hcy
 HH HAPHHIPH9 uHAP0L>y
 3L[PH [H+y
 HCP3H [HAXH HAXH\$WH HHAXHHHIXHH9 uHAP0H_X3H\$0H _H\$0HWX3H _@SH Hx
 HH HAXHHIXH9 uHAP0L^x
 3L[XH [HKx
 HCX3H [HA`H HA`H\$WH HHA`HHHI`HH9 uHAP0H_`3H\$0H _H\$0HW`3H _@SH Hw
 HH HA`HHI`H9 uHAP0L~w
 3L[`H [Hkw
 HC`3H [H\$Hl$Ht$H|$ ATH H3ku
 HHu'H|0 F =   x O  H   Le 3L+eIMz   D  HE H+EHH;rs
 HEw
 HHtqHFH9F ~HHNHHHHNHHv
 u6Hu
HCHP0HI;rHH\$0Hl$8Ht$@H|$HH A\ O  
 O  H/ HV =   H u
HFHP0HtHu
HSHR0L
 D  V H
 l3kH(Hy HQrHIH	w
 Hu9L
. D@2H
 eP   2    eP  L
B l3H(H\$Hl$Ht$H|$ ATAUAVH L3gs
 HHu'Hx. B =   t P  H >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;rq
 IL$H:HH}   HGH9G ~HHOHHHHOHHt
 uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\s P  
g P  HP- H =   H u
HGHP0HtHu
HSHR0L
 D  H
?
 j3gHL$SWHXHD$ HHD$x    hn
 D$x   HKHt
 H;t9r
 u/L$   H$   Het
 x5H$   L$   LCL$   MtHS(H9t
 Hu>L
=, L
      2 P  P  A   H
 iH'HL$(m
 HH&n
 HL$(n
 HHX_[H\$Hl$VWATH H3p
 HHu'H+ n =    T  H    Le 3L+eIMtxHE H+EHH;rn
 HEL$Ho
 HHtiHFH9F ~HHNHHHHNHHq
 u.Hu
HCHP0HI;rHH\$@Hl$PH A\_^ T  
 T  H* H =   H) u
HFHP0HtHu
HSHR0L
 DV  H
]
 0h3sH\$Hl$Ht$H|$ ATAUAVH L3o
 HHu'H(*  =   $ U  H >  IL$ I*    I+L$IHLIIH?L   3IL$ II+L$HHHH?HH;r7m
 IL$HHH}   HGH9G ~HHOHHHHOHHKp
 uBHu
HCHP0HH0I;oHH\$@Hl$HHt$PH|$XH A^A]A\# 
U  
 U  H ) H =   Hc u
HGHP0HtHu
HSHR0L
; D  H

 jf3gHAH HAHA H HA HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _Hn
 H HA0HHI0H9 uHAP0Hfn
 HC0H\$03H _HA8H HA8HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _Hm
 H HA@HHI@H9 uHAP0Hm
 HC@H\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _Hm
 H HAPHHIPH9 uHAP0Hl
 HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _HXl
 H HAXHHIXH9 uHAP0H6l
 HCXH\$03H _HA`H HA`HAH HAH\$WH HHHt,HHAHHIH9 uHAP0H{3H\$0H _Hk
 H HAHHIH9 uHAP0Hfk
 HCH\$03H _HA H HA HA(H HA(H\$WH HHHt,HHA(HHI(H9 uHAP0H{(3H\$0H _Hj
 H HA(HHI(H9 uHAP0Hj
 HC(H\$03H _HA0H HA0H\$WH HHHt,HHA0HHI0H9 uHAP0H{03H\$0H _Hj
 H HA0HHI0H9 uHAP0Hi
 HC0H\$03H _HA8H HA8H\$WH HHHt,HHA8HHI8H9 uHAP0H{83H\$0H _HXi
 H HA8HHI8H9 uHAP0H6i
 HC8H\$03H _HA@H HA@H\$WH HHHt,HHA@HHI@H9 uHAP0H{@3H\$0H _Hh
 H HA@HHI@H9 uHAP0Hh
 HC@H\$03H _HAHH HAHH\$WH HHHt,HHAHHHIHH9 uHAP0H{H3H\$0H _Hg
 H HAHHHIHH9 uHAP0Hg
 HCHH\$03H _HAPH HAPH\$WH HHHt,HHAPHHIPH9 uHAP0H{P3H\$0H _HHg
 H HAPHHIPH9 uHAP0H&g
 HCPH\$03H _HAXH HAXH\$WH HHHt,HHAXHHIXH9 uHAP0H{X3H\$0H _Hf
 H HAXHHIXH9 uHAP0Hvf
 HCXH\$03H _HA`H HA`H\$WH HHHt,HHA`HHI`H9 uHAP0H{`3H\$0H _He
 H HA`HHI`H9 uHAP0He
 HC`H\$03H _H(H
 `:H) Hu*H      Z  H: H(H
 :H Hu*H e y   Z  H H(H
 9Hſ Hu*HI # <  U Z  H H(H
߿ 9H Hu*H  D   Z  Ht H(H
- X9H Hu*H    ѿ Z  H2 H(H
 9H_ Hud     Z  ZH
 8H Hu6 7  h Z  ,H
? 8H Hu*   : Z  H H H(3H(@SH H=BF  tuHIF f     { HKtHE3Hd
 { td
 HHd
 HKHHKH9 t?H	d
 ua
 H(H{ u3ka
 H Hum [  Pa [  D   <a
 H Hu> [  !   a
 H Hu+ [  H δ    Hk H [3H [H\$WH 3ALH;uAËH\$0H _H^a
 DH9AAH9BA   MAL;BtËH\$0H _B A8A uIuËH\$0H _AIB;t
tuII H E	 uËH\$0H _ÅËH\$0H _La
 M;hI;ЋAWDI_
 HHuH\$0H _HtwHu
HSHR0H\$0H _H\$UH H`
 H(H]HH   Hb
 L I;tMHCH;^
 t$      t
   rIH^
 
3HZuH\$@H ]3Ht$0HuPH|$8H}XHEHHEPHEXHu
HCHP0HtHu
HFHP0Ht$0HtHu
HGHP0H|$83H\$@H ]@SH HHt0HuHAP0H
`
 H
 LH	;b
 H [H [H\$Hl$Ht$H|$ ATAUAVH ILAHIhhLH  H}  	  39\$pu3Mt+I	H;
f_
 twHHuX_
 H  H9\$xu?HD$`Ht+HH;
(_
 tvHHu_
 H  
H9$   toHˋHt[HE HtRIHx*HyHHHHy7Hy2LHIHU i  H
^
 H	;]
 O  5]
 LHIU :  MhpM  I}   Ld$hMt	I<$   3HMtI9'9\$ptH^
 HHH   H=^
 HD$`HtH @9l$xt3H]
 HHu)H   H   HCHP0   H]
 L]
 HH]
 HHtHu
HSHR0HtHE u
HEHP0HtBHIAUHMuHu
HWHR0HH
h]
 M@H
 H	_
 3H\$@Hl$HHt$PH|$XH A^A]A\H8MLHuH
j\
 HS
 H	_
 3H8Et)H;]
 u-HAH;[
 t	H;[
 u   H8HI,VuIBLJH
 HHMHL$ H
\
 H	^
 3H8H\$Hl$Ht$WH Hj3HH~WHrLI;tbHCH;Z
 t$      t
   rIHY
 
3HUu#HHH;|3H\$0Hl$8Ht$@H _ø   HIHH;u   Hu3HB   s6HAH;sY
 t      t
   rH%\Y
 L3RUH(HA   sAH(sEHAHHw,Hi H3H(ËAH(ËAH(H(H%[
 H\$0qHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f         H(HA   sAx&H(sTHQHHtAHt3HHyH
`Z
 H
 H	H\
 H(H(H%Z
 AH(3H(H\$0pHHu
H\$0H(HH|$ ZHu
HSHR0H\$0H|$ H(H(HA   sAH(sEHAHHw,H
 H3H(ËAH(ËAH(H(H%	Z
 H\$0pHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f|
 |
 |
 j
 c
 t
 |
 |
 |
 H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%Y
 H\$0oHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(fl l l Z S d l l l H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%)X
 H\$0/nHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f\ \ \ J C T \ \ \ H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%9W
 H\$0?mHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(fL L L : 3 D L L L H(HA   sAH(sEHAHHw,H H3H(ËAH(ËAH(H(H%IV
 H\$0OlHHu
H\$0H(HH|$ mHu
HSHR0H\$0H|$ H(f< < < * # 4 < < < H(HA   s
HcAx(H(siHQHHtVHtHHt0Hy H
T
 H&
 H	V
 HH(H(H%AU
 AIHHH(ËAH(3H(H\$06kHHuHH\$0H(HH|$ CHHu
HSHR0H\$0HH|$ H(H\$Ht$WH0IIHT
 HHuH\$@Ht$HH0_HD$hLLHD$(HD$`HHD$ bH\$@Ht$HH0_33333333AVHPHD$ H\$`Hl$hHt$pH|$x)t$@AAfnf(6	 5	 D,G  l+;ttC-  H$   H$   HM
 HYt
 H IcHL$(L
 L3HuH
HHcHHISAHM
 HHq
 表 HȋL
    HL$(6L
 LHs
 Ht HHt
H HcxHIVHAfnY-(u ^,HL
 HHs
 ( Hs
 Hs
 $    HEH H$   HL
 HK
 HL
 H$   fM
 H$   H\$`Hl$hHt$pH|$x(t$@HPA^H%7M
 H(Hs
 萧 HL
 HH(H%L
 @SH H?
 H[ Hs
 HL H
 H= H H-L
 H.L
 H-L
 H
 H Hs
 H H
 H H HK
 HK
 HK
 H
 H HRs
 H貦 Hg
 H裦 H HK
 HK
 HH [H%K
 HtzH\$Ht$WH HHr
 AHG HH;K
 DD+^A}H/K
 H.K
 D[E~Af H6 HuH\$0Ht$8H _H%  WHPHD$ H\$`Hl$hHt$pIIH   D4HHJ
 HHJ
 J
 H}    Huk
 HL$(J
 Hr
 H[ HHT$(MJ
 +\$@}HEJ
 HDJ
    ~ HQ HuHL$(J
 Hq
 H HHI
 HHq
  HHI
 I
 HI
 HI
 H\$`Hl$hHt$pHP_HWHP  HD$ HXHhHpIIHH   DBHL$PI
 Hq
 HL$`N HHBI
 H v,Hp
 HL$`* HHI
 HHp
  HT$(HL$PH
 L$  LHHHL$(lI
 HL$PH
 L$P  I[IkIs I_HWH   HǄ$  HXHpH   DBH.H
 HHPHH2p
 H$0  U HȋG
 HHp
 ; HH0 H$   H$   G
 H    Ho
 H$   dH
 A   H HL$`I
 LLS L\$`L(S H$   HL$ G
 HL$   H$   G
 HLR HL$xG
 H$   	H
 HL$ G
 Hߺ
 HL$`/	 Ht    HEo
 HL$ G
 HZN HL$`H
 LR L\$`LtR H$   H$   FG
 HLD$ H$   8G
 HL6R HL$xG
 H$   UG
 H$   GG
 H
 HL$`.	 H    Hn
 HL$ F
 H3R H$0  H$0  HL$`PH
 LR L\$`LQ H$   H$   F
 HLD$ H$   qF
 HLoQ HL$xTF
 H$   F
 H$   F
 H!
 HL$`3.	 Hv    Hm
 HL$ ,F
 HQ HL$`!G
 LrQ L\$`LP H$   H$   E
 HLD$ H$   E
 HLP HL$xE
 H$   E
 H$   E
 HJ
 HL$`|-	 H tJHL$ F
 HI HD$ H$   HL$8E
 HI HD$ H
 HL$ &-	 H tJHL$ zF
 HjI HD$ H$   HL$82E
 HzI HD$ H
 HL$ ,	 H tJHL$ $F
 HI HD$ H$   HL$8D
 H<I HD$ Hh
 HL$ z,	 H tJHL$ E
 HH HD$ H$   HL$8D
 HH HD$ H
 HL$ $,	 H t>HL$`xE
 HhH HD$`H$   HL$x0D
 H
 HL$`+	 H tJHL$ .E
 HH HD$ H$   HL$8C
 HH HD$ H2
 HL$ +	 H tJHL$ D
 HpH HD$ H$   HL$8C
 HH HD$ H
 HL$ .+	 Hq tJHL$ D
 HH HD$ H$   HL$8:C
 H*H HD$ HF
 HL$ *	 H[ t>HL$`,D
 HG HD$`H$   HL$xB
 H|
 HL$`*	 Hbj
 HL$ B
 HL$`C
 LN L\$`LhM H$   H$   :B
 HLD$ H$   ,B
 HL*M HL$xB
 H$   IB
 H$   ;B
 H<
 HL$`)	 ;cH\$Hl$Ht$H|$ ATH H HH
 E3
HHuHE
 
  H   H
B HxHH5l L%
 H- PF
 HHtwH9cH_HGH3GhHG@HGHHG HG(HG0HG8Gl MtI$LgXHtHE HoPHtHHHw`E
 Hu
HCHP0HG
  L
]
 H
x
 Ai   j $ i   L
 <Hu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH H H\$0HH
_ E3Ht$8H|$@
E3HHu2H-kD
  f   ǟ G  HE H
 H   HXHH
 HAL   MtH AH,L@@MtH H AHH :D
 HHu'H+
  h   7 V  H   HB
 IH9C   H{H   HsHHHHHuHAP0HH2HHu'H

  h    c  H
     Hu
HGHP0IHu
HCHP0HIHuHHuXHR
 , i   ^ u  H jHHHuH
  h   * f  H 6HHHH   H
  i    w  HS HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L

 Db  H
v
 <9&Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\cfH(IL$0?
 Hu9L

 D@PH
v
    P      L
  c83H(H\$WH HH؃uOA
 HtDL
R
 DCQH
v
    P   N   L
 7H\$0H _É_H\$03H _{hhijH(A(aA
 Hu9L

 D@TH
jx
 
  _ T    
  L
 573H(lmH(AH@
 Hu9L

 D@XH
*y
 }  ߑ X    }  L
r 63H(o;rHUHp  3HXHpHxL`LhLpLxLLHHHl$0Hl$8Hl$@LHl$(L[=
 Hu'HO
 )    [   H %I  L&=
 Hu'H
     &   H H  A$HD$ $  <
 HHu,H
 H|$     HG ՙ   H     =
 HHu'H
 p       H E  HxH
;=
 E3HHHu'HQ
 +    ]   H gG  Hu
HCHP0H LIH<
 y'H 
 ڏ       Hm E  Hu
HGHP0AL$$  ^;
 HHu,H
 H|$     H!    G  H3 LI<
 y'Hl
 F    x   Hّ nD  Hu
HGHP0IL$"HHu,H#
 H|$     H #   F  Ho LI;
 y'H
        HM C  Hu
HGHP0A$   `=
 HHu,H
 H|$ f    H    bF  H LI:
 y'HN
 (    Z   H PC  Hu
HGHP0A8$   tH-:
 H H=#:
 H":
 H H=:
 Hu,H
 H|$     HV    E  H LIL:
 y'H
 {       H B  Hu
HGHP0A8$   tH9
 H H=v9
 Hu9
 H H=k9
 Hu,H7
 H|$     H 7   E  H LI9
 y'H
 Ό        Ha A  Hu
HGHP0A8$      I$   HHu'H
 t       H A  H LI9
 y'H\
 6    h   HɎ ^A  Hu
HGHP0A8$     I$   HHu'H
 ܋     1  Ho A  HC LIo8
 y'H
     Д 3  H1 @  Hu
HGHP0H
= 8HHu'Hy
 S     F  H B  A$   $  L7
 LHu'H
5
     A H  H
 KB  H&7
 HsHl$(H9k  HkHl$(HW  H{HE HHHHuHAP0H7
 HwH9   E3H$   HEAH$   L$   HHu'H
 \     \  H ?  HE u
HEHP03IE Hl$(u
IEIP0L      f7
 LHu'H

     # l  H
 -A  Hh3Lh E3HHHl$(L7HHu'H
     Ԓ r  H5 >  Iu
IFIP0LP3IHHHu'Hw
 Q     U  H y>  IE u
IEIP0LHu	HHP0H
݉ HHH|$0HHu'H
        H{ >  H@L   MtH HAH2L@@MtH HH AHH H6
 HHu'H
 h       H =  Hu
HGHP0A   HH4
 HHu'H=
     I   H ?=  Hu
HCHP0HHKy'H
 χ       Hb <  Hu
HGHP0F  Ht$0HFL   MtH HAH2L@@MtHΉ HH AHH Hg5
 HHu,HX
 H|$ -    Hʉ X   >  Hl LI3
 y'H
     !   H <  Hu
HGHP0A$   $   2
 HHu'H
     ͏   H. ;  Hʇ LI.3
 y'H
 ]       H ;  Hu
HGHP0A$,  L$xI2
 HHu'H2
     >   H 4;  H LI2
 y'H
 ΅        Ha :  Hu
HGHP0A$0  $   1
 HHu'H
 z       H
 :  Hы LI
2
 y'Hb
 <    n   Hχ d:  Hu
HGHP0A$$  $   %1
 HHu'H
        H{ :  H LI{1
 y'H
     ܍   H= 9  Hu
HGHP0L0
 H I)1
 y,H~
 H|$ S    H ~   #<  A$@   tHg0
 H H=]0
 H\0
 H H=R0
 Hu,H
 H|$     H    ;  Ht$ H LH0
 y'H
        HC 8  Hu
HGHP0A$H  V2
 HHu'H
 a       H 8  H LH/
 y'HI
 #    U   H K8  Hu
HGHP0A$P  1
 HHu'H
 Ԃ       Hg 7  H LHg/
 y'H
     ȋ   H) 7  Hu
HGHP0A$X  <1
 HHu'Hm
 G    y   Hڄ o7  Hޅ LH.
 y'H/
 	    ;   H 17  Hu
HGHP0A$`  $   -
 HHu'H
      	  HH 6  H LHH.
 y'H
 w       H
 6  Hu
HGHP0A$d  $   ,
 HHu'HI
 #    U   H K6  H LH-
 y'H
        Hx 
6  Hu
HGHP0A$h  $   f,
 HHu'H
     É !  H$ 5  H LH$-
 y'Hy
 S     #  H {5  Hu
HGHP0A$p  .
 HHu'H*
     6 -  H ,5  H LH,
 y'H
      /  HY 4  Hu
HGHP0A$  l.
 HHu'H
 w     9  H
 4  H LH
,
 y'H_
 9    k ;  H́ a4  Hu
HGHP0A$  -
 HHu'H
 ~     E  H} 4  H LH}+
 y'H
 ~    އ G  H? 3  Hu
HGHP0H
 F
HHu'H
 a~     Q  H 5  A$(  L$`]*
 LHu'HF
  ~    R S  H \5  H7*
 HsLH9g  LkMZ  H{IE HHHHuHAP0H*
 HwH9   E3H$  HEAL$  L$   HHu'H
 t}     g  H 2  IE u
IEIP0ILu
IFIP0L      *
 HHD$(Hu'H/
 	}    ; w  H E4  Lh3Lu E3HHLLQHHu'H
 |     }  HO 1  HE u
HEHP03Hl$(MIH
HHu'H
 h|     `  H~ 1  Iu
IFIP0LHu	HHP0HGL   MtH}~ HAH2L@@MtHb~ HH AHHL~ H)
 HHu'H
 {       HY~ 0  Hu
HGHP0Hm LII(
 y'H
 x{       H~ 2  HHH\$8HHu
HCHP0H
} HHu'HF
  {    R   H} \2  H@L   MtH~ HAH2L@@MtH|~ HH AHHf~ H(
 HHu'H
 z    ҃   H3} 1  Hu
HCHP0A   HH&
 HHu'Hu
 Oz       H| w/  Hu
HGHP0H>y'H0
 
z    <   H| F1  Hu
HCHP0   A$  $   %
 HHu'H
 y       HA| 0  Ht$ HX{ LH<&
 y'H
 ky       H{ 0  Hw  HCHP0h  H
{ HHu'H=
 y    I   H{ S0  H@L   MtHn HAH2L@@MtHS HH AHH= H&
 HHu'H
 x    Ɂ   H*{ /  Hu
HCHP0A   HH$
 HHu'Hl
 Fx    x   Hz n-  Hu
HGHP0H<y'H'
 x    3   Hz =/  Hu
HCHP0   A$  &
 HHu'H
 w    ܀   H=z .  Ht$ H{ LH8$
 y'H
 gw       Hy .  Hs  HCHP0d  H
y HHu'H9
 w    E   Hy O.  H@L   MtHJw HAH2L@@MtH/w HH AHHw H$
 HHu'H
 v       H&y -  Hu
HCHP0A   HH"
 HHu'Hh
 Bv    t   Hx j+  Hu
HGHP0H:y'H%
 u    1   Hx ;-  Hu
HCHP0Ht$ H
ix HHu'H
 u    ~   HBx ,  H@L   MtHu HAH2L@@MtHu HH AHHu Hd#
 HHu'HU
 /u    a~   Hw k,  Hu
HCHP0HL$8A   HQ!
 HHu'H
 t    ~   How *  Hu
HGHP0H8y'H
 t    }   H*w +  Hu
HCHP0H݅
  H
u & HHu'Hg
 At    s}   Hv i)  A$x  L$p= 
 LHD$(Hu'H!
 s    -}   Hv #)  H 
 LHoH9E g  LwMZ  HwIHHHHuHAP0H 
 HnH9E    E3H$   HEAL$   L$   HHu'Ht
 Ns    | )  Hu v(  Iu
IFIP03I$LuID$IP0Ht$(      X 
 LHu'H	
 r    | 9  Hvu (  Lp3E3IHMe LHD$()HHu'H
 r    { ?  H'u '  IE u
IEIP03LSIHHHu'Hh
 Br    t{ "  Ht j'  I$uID$IP03Ht$(Hu
HE HP0HCL   MtHPt HAH2L@@MtH5t HH AHHt H
 HHu'H
 q    z E  H,t (  Hu
HCHP0H
r 3LHH|$@&HHu'Hg
 Aq    sz R  Hs i&  H@L   MtHu HAH2L@@MtHt HH AHHt H
 HHu'H
 p    y T  HTs %  Hu
HGHP0A   HI
 HHu'H
 pp    y W  Hs %  Hu
HCHP0HH;4y'HN
 (p    Zy Y  Hr P%  Hu
HGHP0,  Ht$ L2w Hcw H
 y'H
 o    x d  H\r '  Hs I'
 HHu'H
 o    x m  Hr $  H)q H
 HHu'Hq
 Ko    }x o  Hq s$  Hu
HGHP0Hr LI
 y'H#
 n    /x r  Hq 9&  H@  HCHP01  H
o HHu'H
 n    w   H<q %  H@L   MtHHr HAH2L@@MtH-r HH AHHr H^
 HHu'HO
 )n    [w   Hp e%  Hu
HCHP0A   HIM
 HHu'H
 m    
w   Hkp  #  Hu
HGHP0H1y'H
 m    v   H&p $  Hu
HCHP0H݅/  Ht$ LRq Ht H
 y'HW
 1m    cv   Ho $  Hp I
 HHu'H
 l    $v   Ho .$  Hqu HH
 HHu'H
 l    u   HFo !  Hu
HCHP0HZp LIH3
 y'H
 bl    u   Hn !  H  HGHP0  H
`m HHu'H4
 l    @u   Hn 6!  H@L   MtHes HAH2L@@MtHJs HH AHH4s H
 HHu'H
 k    t   H!n    Hu
HGHP0A   HI
 HHu'Hc
 =k    ot   Hm e   Hu
HCHP0HH/y'H
 j    't   Hm    Hu
HGHP0%  Ht$ Lr H0r Hg
 y'H
 j    s   H)m !  HMn I
 HHu'H}
 Wj    s   Hl   Hr H
 HHu'H>
 j    Js   Hl @  Hu
HGHP0Hm LI
 y'H
 i    r   H]l !  HuHCHP0Ht$ Hk LIF
 !  H
 qi    r   Hl    H
 j HHu'H\
 6i    hr 
  Hk r   H@L   MtHq HAH2L@@MtHq HH AHHq H
 HHu'H
 h    q   HIk   Hu
HCHP0Ht$0A   HH
 HHu'H
 `h    q   Hj   Hu
HGHP0H.,y'HA
 h    Mq   Hj W  Hu
HCHP0^	  HFL   MtH:j HAH2L@@MtHj HH AHH	j H
 HHu,H
 H|$ ~g    Hj p   N  Hk LI
 y'Hf
 @g    rp   Hi |  Hu
HCHP0A$   $   )
 HHu'H
 f    p (  Hi (  Hh LI
 y'H
 f    o *  HAi   Hu
HCHP0A$(  $   
 HHu'H
 Zf    o 4  Hh   H!h LI
 y'HB
 f    No 6  Hh X  Hu
HCHP0A$,  $   
 HHu'H
 e    n @  H[h   He LI[
 y'H
 e    n B  Hh   Hu
HCHP0A$0  $   s
 HHu'H\
 6e    hn L  Hg r  Hn LI
 y'H
 d    *n N  Hg 4  Hu
HCHP0A$4  L$H
 HHu'H
 d    m X  H:g   H>e LI:
 y'H
 id    m Z  Hf   Hu
HCHP0A$8  
 HHu'H@
 d    Lm d  Hf V  Hi LI
 y'H
 c    m f  Hof   Hu
HCHP0A$@   tH
 H H
 H
 H H
 Hu,H
 H|$ lc    H	f l p  <  Hh LI
 y'HT
 .c    `l r  He j  Hu
HCHP0A$D  $   
 HHu'H 
 b    l |  Hme   Hd LIm
 y'H
 b    k ~  H/e   Hu
HCHP0A$H  B
 HHu'Hs
 Mb    k   Hd   HLh LI
 y'H5
 b    Ak   Hd K  Hu
HCHP0H
c HHHu'H
 a    j   HTd   A$$  $   
 LHu'H
 }a    j   Hd   H
 Hl$(HoH9E l  LgLd$(MZ  HwI$HHHHuHAP0H:
 HnH9E    E3H$  HEAL$  L$  HHu'H
 `    i   H[c   I$uID$IP03IE Ht$(u
IEIP0L      
 LHu'H
 \`    i   Hb   L`E3Lh E3HHLd$(MHHu'H2
 `    >i   Hb 4  Iu
IFIP0MPIHbHHu'H
 _    h   HPb   IE u
IEIP03LHu
HE HP0HCH\$8L   MtHa HAH2L@@MtHa HH AHHa HG
 HHu3H8
 Ht$0H|$ Ha _    3h   3  Heg LI
 y'H
 ^    g   H[a   H  HCHP0Ht$0H|$   H
T_ OHHu'H
 j^    g   H`   H@L   MtHc HAH2L@@MtHc HH AHHc H
 HHu'H
 ]    g   H}` &  Hu
HCHP0A   HH

 HHu'H
 ]    f   H,`   Hu
HGHP0Hg!y'Hz
 T]    f   H_   Hu
HCHP0]  HFL   MtHs_ HAH2L@@MtHX_ HH AHHB_ H

 HHu,H
 H|$ \    HT_ e     H` LIJ	
 y'H
 y\    e   H_   Hu
HCHP0A$   L$Pe
 HHu'HN
 (\    Ze   H^ d  HW] LI
 y'H
 [    e   H}^ &  Hu
HCHP0A$$  L$X
 HHu'H
 [    d   H,^   Hc LI,
 y'H
 [[    d   H]   Hu
HCHP0A$,   tH_
 H HU
 HT
 H HJ
 Hu,H
 H|$ Z    H] d     H2b LI~
 y'H
 Z    c   H@]   Hu
HCHP0H
` HDHHu'H
 _Z    c (  H\   A$(  L$h[
 LHu'HD
 Z    Pc *  H\ F  H5
 LHoH9E h  LoM[  HwIE HHHHuHAP0H
 HnH9E    E3H$(  HEAL$(  L$0  HHu'H
 pY    b >  H\   IE u
IEIP03ILu
IFIP0L      }
 HD$(Hu'H,
 Y    8b N  H[ .  3LhLp LLE3HHNHHu'H߿
 X    a T  HL[ 
  HL$(HuHAP03Ht$(OIH	HHu'H
 dX    a 7  HZ 
  Iu
IFIP03LHu
HE HP0HCHH\$8L   MtHnZ HAH2L@@MtHSZ HH AHH=Z H
 HHu'Hݾ
 W    ` d  HJZ   H` LIJ
 y'H
 yW    ` f  HZ   Hu
HCHP0H
p] HHu'HT
 .W    `` p  HY j  H@L   MtH\ HAH2L@@MtH\ HH AHH\ H
 HHu'HԽ
 V    _ r  HAY 
  Hu
HCHP0A   HH
 HHu'H
 ]V    _ u  HX   Hu
HGHP0H+y'H>
 V    J_ w  HX T
  Hu
HCHP0B  H
\ HHu'H
 U    ^   HXX 
  H@L   MtH\ HAH2L@@MtH\ HH AHH\ Hz
 HHu'Hk
 EU    w^   HW   Hu
HCHP0A   HHi
 HHu'H
 T    &^   HW 
  Hu
HGHP0Hy'Hջ
 T    ]   HBW   Hu
HCHP0  A$0  M
 HHu'H~
 XT    ]   HV   H[ LI 
 y'H@
 T    L]   HV V  Hu
HCHP0A$H  
 HHu'H
 S    \   H^V   HZ\ LI^ 
 y'H
 S    \   H V 
  Hu
HCHP0A$8  3
 HHu'Hd
 >S    p\   HU z
  HS LI	 y'H&
  S    2\   HU <
  Hu
HCHP0A$@  
 HHu'H׹
 R    [   HDU 	  H0T LID	 y'H
 sR    [   HU 	  Hu
HCHP0A$8  
 HHu'HJ
 $R    V[   HT `	  H#X LI	 y'H
 Q    [   HyT "	  Hu
HCHP0A$@   
 HHu'H
 Q    Z   H*T   HfT LI*	 y'H
 YQ    Z   HS   Hu
HCHP0A$@  	 HHu'H0
 
Q    <Z   HS F  HQ LI	 y'H
 P    Y   H_S   H  HCHP0Ht$0H|$ 	  H
V SHHu'H
 nP    Y   HS   H@L   MtHV HAH2L@@MtHV HH AHHV H#	 HHu'H
 O     Y   HR *  Hu
HCHP0A   HH	 HHu'Hö
 O    X   H0R   Hu
HGHP0Hky'H~
 XO    X   HQ   Hu
HCHP0j  A$0  	 HHu'H'
 O    3X   HQ =  H@V LI	 y'H
 N    W   HVQ   Hu
HCHP0A$H  i	 HHu'H
 tN    W   HQ   HW LI	 y'H\
 6N    hW   HP r  Hu
HCHP0A$8  	 HHu'H

 M    W   HzP #  HNN LIz	 y'Hϴ
 M    V    H<P   Hu
HCHP0A$@  O	 HHu'H
 ZM    V *  HO   HN LI	 y'HB
 M    NV ,  HO X  Hu
HCHP0A$8  	 HHu'H
 L    U 6  H`O 	  HR LI`	 y'H
 L    U 8  H"O   Hu
HCHP0A$@  5	 HHu'Hf
 @L    rU B  HN |  HO LI	 y'H(
 L    4U D  HN >  H  HCHP0Ht$0H|$ J  H
L HHu'Hʲ
 K    T b  H7N   H@L   MtH3T HAH2L@@MtHT HH AHHT HY	 HHu'HJ
 $K    VT d  HM `  Hu
HCHP0A   HHH	 HHuDH
 J    T g  HfM H  H  HGHP0  Hu
HGHP0Hy'H
 qJ    S i  HM   Hu
HCHP0  LPO HN I	 y,H=
 H|$ J    HL =S t    L1	 HO I	 y,H
 H|$ I    HhL R }    A$   	 HHu'H
 I    R   HL    H|$ HfL LH	 y'Ho
 II    {R   HK    Hu
HCHP0A$(  	 HHu$H 
 H    ,R   HK 9H,N LH	 y[H
 H    Q   HRK HtHu
HCHP0MtnIE u
IEIP0Ht$0H|$ 3[Hu
HCHP0HJ LI	    H_
 9H    kQ   HJ Ht$0H|$ 3HL$(Ht
HuHAP0MtIu
IFIP0L
J DG Q H
1
 SHt$0H|$ AHt$0H|$ 5Ht$0H|$ )Ht$0H|$ Ht$0H|$ Ht$0H|$ H|$ IIL$H  L$P  L$X  H$  MtIu
IGIP0L$@  HtHu
HGHP0H$`  HtHu
HFHP0HL$8H$h  Ht
HuHAP0HD$@HtH u
HPHR0HHp  ]{(H\$Hl$Ht$H|$ ATH HGI HH
-P E3蝿HHuH.	 B%  H   H
O HxHH5H L%mH H-I 	 HHtwH*H_HGH3GhHG@HGHHG HG(HG0HG8Gl MtI$LgXHtHE HoPHtHHHw`v	 Hu
HCHP0HGJ%  L

 H
&<
 A  N E   L
!H dHu
HCHP03H\$0Hl$8Ht$@H|$HH A\Hl$ ATH HG H\$0HH
N E3Ht$8H|$@-E3HHu2H-	 D   'N %  HE H
 H}G   HXHH
K HAL   MtHH AH,L@@MtHG H AHHG 	 HHu'H
 eD   M %  HF   H|	 IH9C   H{H   HsHHHHHuHAP0HHHHu'H

 C   M %  H
F    Hu
HGHP0IHu
HCHP0HIHuHHuXH
 C   L %  HF jHMHHuH~
 XC   L %  HE 6HHH   HF
  C   RL %  HE HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
mE DB K H
9
 &Hu
HFHP0HHLu
HSHR0HE H|$@Ht$8H\$0u
HUHR0IHl$HH A\+k.HHPHHAUH   HHXE3HhHpHxL`LpLxMHIIML$   MH;	 >  3	 HHu'H̨
 A   J '  H9D *
  HM H;
Q	 u>H
`	 H	:
 H	h	 L
 [A   LC J '  L  HA 	 HHu'H
E
 A   QJ '  H
C   H@H;b	    H;]	 t~HI	 HHu*H

 @   I '  H
\C M  H@H   Hl$ Hu8H
 @   I '  HC Mx  HHILl$ Hu
HGHP0JLH$   H$   HuUH	 H9Cu'L;s4  HCIJ|HHH$   2L;s
  H9IHHH$   HHH  ILHt
HuHAP0H~E H$   IL;bH	 AEH9BI9GADtUMGL;B   B IO 8   IAGDJA;tt
A   H  A^L	 AM;ucI;AAuUA   IS	 HH   HHE Du
HUHR0Hl$ Ex[H$   EMuHNH9N ~ IHFL<HAH$   HFKIH	 u:H$   .E3H|
 V>   G '  H@ MD	  HR
 ,>   ^G '  H@ M	  	 HtH	 HHt?h	 Hu
HCHP0H$   H$   HJ  HAP0M>  HȤ
 =   F '  H5@ M  H-B H
C H~	 HHtH HHHu'Hj
 D=   vF (  H? 5  H$   H	 u'H+
 =   7F (  H?   Hu
HFHP0tf   	 HHu'Hݣ
 <   E (  HJ?   H$   H$   HH@HHuHAP0MH=C H
B Hj	 HHtH HHHu*HV
 0<   bE +(  H> IZ  HCL   MtH< HAH2L@@MtH< HH AHH< H	 HHu*HӢ
 ;   D -(  H@> I  Hu
HCHP0HGL   MtH= HAH2L@@MtH~= HH AHHh= HO	 HHu'H@
 ;   LD 0(  H=    Hu
HGHP0H$   HN H;
	 uAH
	 H3
 H		 Lݡ
 :   LT= C 5(  I  H: 	 HHu'H
 x:   C 7(  H= ~  HN H;
#	 u>H
2	 H+3
 H	:	 LS
 -:   L< XC ;(  3  H@ 	 LHu'H

 9   #C =(  H
<   H	 IL$   AH9Cu4HkH$   Ht#HCHE HH HHuHAP0   H	 H9C   H$   HT$HDFHD$HHcE3HHHl$@H+H|$PLt$X}HHu'HN
 (9   ZB N(  H;   HtHE u
HEHP0HIL$   u
HGHP0IIu
IFIP0M   FHc	 LHu'H
ǟ
 8   A `(  H
4;   HtHhL$   IH$   HcE3HILI| Mt(HIIM¾HHu'HS
 -8   _A n(  H:   I$uID$IP0MHu
HCHP0H$   H$   HuHAP0H
"? HHu'H֞
 7   @ ~(  HC:   H@L   MtH; HAL2L@@MtH; HH ALH; He	 LMu'HV
 07   b@ (  H9 ]  Hu
HCHP0ID$L   MtH@ IAH2L@@MtH? IH AHH? I	 HHu'Hŝ
 6   ? (  H29   I$uID$IP0H	 MAH9Cu,LcMt#HCI$HH HHuHAP0   HU	 H9C   H$   HT$0DEHD$0HcE3HHLd$(H+Ht$8.HHu'H
 5   ? (  Hl8    M  I${  ID$IP0k  EHc	 LHu/H
 H$   r5   H8 > (     MtL`MH$   HcE3HILHHIIt 裻HH   H0
 
5   <> (  H7 HtHu
HFHP0HtHu
HGHP0H$   H$   HtHu
HCHP0MtIu
IFIP0HtHE u
HEHP0MtI$uID$IP0L
7 DX4 = H
W-
 2#Iu
IFIP0Hu
HCHP0LLt$pLd$xH$   H$   H$   H$   MtIu
IGIP0H$   L|$hHtH u
HPHR0IHĠ   A]H\$Hl$VWATH@HW	 HzILH\$pHM   HtH   HZH\$pI	 HHu)H  H8 H:	 HtHHD$pHH   Hr,
 LL$pH HD$(E3HH|$ y
(     H\$p   H   H   Hy3L
R
    L
R
 HH%	 H|$0H
 L+
 HDHR
 HD$(HL$ H
P	 H		 )  L
s
 H
+
 A  ; :2   L
4 3HZHI$H\$`Hl$hH@A\_^HLH L@HPHHAUH  HE3HXHhHpL`LpHAML   ILL$   L$   L$   Ll$8Ll$PL$   Ll$XL$   Ll$xL$   Ll$`Ll$pL$   L$   Ll$hLl$0Ll$(Ll$ IMtH3 AH+H@@HtH3 H HH2 	 HH$  L$  Hu'H
 0   : )  Hc3 J  H	 MH9C   L{M   H{IHHHHuHAP0IHHHu'H~
 X0   9  *  H2 gI  Iu
IGIP0MHu
HCHP0HIu
HGHP0H
A	 AH;  L;A  H- 0 H
Q6 H	 HHt<H BH蓹HHuHĖ
 /   8 *  H12 H  HHHu'H
 g/   8 $*  H1 vH  HGL   MtH>/ HAH2L@@MtH#/ HH AHH
/ H	 HHu'H

 .   8 &*  Hz1 G  Hu
HGHP0H.3 E3H+HHu'H
 .   7 )*  H)1 G  Hu
HCHP0HIu
HGHP0H"	 L;   L$   IM H;u>H
	 H(
 H	!	 L:
 . "  L0 ?7 K*  MG  HC. u	 HHu'H
 - "  
7 M*  Hk0 F  IILH$    IFP0  H
#2 ^HHu'H
 y- #  6 c*  H0 F  HI	 u'He
 ?- #  q6 e*  H/ NF  Hu
HGHP0ti   	 HHu'H
 , $  #6 q*  H/  F  IH@IL0ILH$  uIFP0L$   L$   L$  H
3 \HHu'H
 w, %  5 *  H
/ E  H@L   MtH- HAL2L@@MtH- HH ALH, H,	 LMu'H
 + %  )5 *  H. E  Hu
HCHP0IGL   MtH- IAH2L@@MtH- IH AHH- I	 HHu'H
 g+ %  4 *  H- D  Iu
IGIP0IM 3LH;
	 u>H
	 H%
 H		 L-
 + %  L- 24 *  +D  H6+ h	 LHu'H
 * %  3 *  H^- C  IM H;
v	 u>H
	 H%
 H		 L
 * %  L- 3 *  C  HW0 	 LHD$0Hu'H
e
 ?* %  q3 *  H
, cC  HV	 LHl$(H9Cu5LsLt$(Mt'HCIHH HHuHAP0LL$0   H	 H9C   L$X  HcH$H  HDGE3HH+L$@  L$H  L$P  ǭHHu'H
 r) %  2 *  H, B  MtIu
IFIP0ILHl$(u
IGIP0HL$0LHuHAP0Hl$0L   GHc]	 LHD$ Hu'H
	
 ( %  2 *  H
v+ B  MtLpHl$(LH$  HcE3HILHL$0IL(M| IHLHl$0 HHu'H
 k( %  1 *  H* zA  I$uID$IP0LHl$ Hu
HCHP0H$  HH$  H HuH@P0IM H;
	 u>H
	 H#
 H		 L
 ' '  Lp* 0 *  NA  H( 4	 HHu'H
 ' '  0 *  H** @  IM H;
B	 u>H
Q	 H"
 H	Y	 Lr
 L' '  L) w0 *  [@  HC) 	 HHu'H6
 ' '  B0 *  H) @  HHj	 LHD$ Hu'H
 & '  0 *  Hc) ?  Hu
HGHP0Hu
HCHP0H
- L$   Hl$ MHHu'H
 h& (  / *  H( ?  H@L   MtH' HAH2L@@MtH& HH AHH& H	 HHu'H
 % (  / *  H{( ?  Hu
HCHP0HGL   MtHO, HAH2L@@MtH4, HH AHH, H	 HHu'H~
 X% (  . *  H' g>  Hu
HGHP0H_	 HH9Cu+H{Ht"HCHHH HHuHAP0   H	 H9C   H$  H$  DEH$   HcE3HHH$  H+L$  LHD$ Hu'H
 $ (  - 
+  H' =  HtHu
HGHP03H   EHc	 LHD$0Hu'HN
 ($ (  Z- +  H& 7=  HtHx3I$H$  HcMdHIL HE3IYLHD$ Hu'H
 # (  , &+  HR& <  HL$0HuHAP03Hl$0Hu
HCHP0I$uID$IP0H
* Hl$ )HHu'Hj
 D# *  v, 4+  H% S<  H@L   MtH# HALHD$0<L@@MtH# HH ALHD$0H# H	 LHD$0Mu'Hۉ
 " *  + 6+  HH% ;  HuHCHP0LL$0IAL   MtH' IAH2L@@MtH& IH AHH& IU	 HHu'HF
  " *  R+ 9+  H$ /;  HL$0HuHAP0IM Hl$0H;
	 u>H
	 HL
 H		 L
 ! *  L[$ * >+  :  H! 	 LHD$0Hu'H
 }! *  * @+  H$ :  IM H;
(	 u>H
7	 H
 H	?	 LX
 2! +  L# ]* L+  A:  H	' 	 HHu'H
   +  (* N+  H# :  IM H;
	 u>H
	 H
 H		 Lч
   ,  LH# ) Z+  9  H" 	 LHu'H
 o  ,  ) \+  H# ~9  H	 LHl$(H9Cu0LsLt$(Mt"HCIHH HHuHAP0   H1	 H9C   H$  H$  DEH$  HcE3HHL$  H+L$  H$  L$  HD$ Hu'H
  *  ( u+  H*" 8  MtIu
IFIP03I$LHl$(uID$IP0HHl$0u
HGHP0IHu
IGIP0Ld$ L   EHck	 HHu'H

  *  (( +  H
! 8  MtLpE3Lt$(H$  Hc3H| L|(LdHHL0E3HHHl$0HLLHD$ Hu'H
 t *  ' +  H! 7  Hu
HFHP0HHu
HCHP03L$   7	 LHD$ Hu'H3
 
 /  ?' +  H  7  IM H;
	 u>H
	 H
 H		 L
  /  L_  & +  =7  H	& #	 HHu'H
  /  & +  H  6  IM H;
1	 u>H
@	 Hi
 H	H	 La
 ; /  L f& +  _6  H! 	 HHu'H%
  /  1& +  H #6     :	 LHu'H
  /  % +  HX 5  H
  HXE3HHp HHHu'H
 y /  % +  H 5  Iu
IGIP0HFH;	    H;	 t}HI	 LHD$@Hu'H4
  /  @% +  H G5  H@L   MuBH
 L|$@ /  Ho $ +  5  HE3HMMHt$@Hl$@E3Hu
HFHP0INtfMuEH	 H9EuL;m~  HEIJtHI+L;m_  I6IHIHAHH  HFH	 H;   H;q	    H	 HHD$0H  Hu
HFHP0HCHIH   HHx  HL$0A   HH_  Ld$0Iպ   HJh  I$uID$IP0Hl$@E3Ld$0>HNH  H;u
H^H~ HFHHxHHHu
HFHP0HL$XHH\$XHt
HuHAP0H$   HIH$   HtHu
HAP0HHHI2	 HH*  LD$ IHI9H ~H I@H4HAI@HI	    Hu
HFHP0IH
 L|$@\ /  H " ,  k2  HL$0HuHAP03HL$0euIȥH1
 L|$@ /  H 1" ,  2  H
 L|$@ /  Hw " 	,  2  H
 L|$@ /  HK ! ",  1  H
 L|$@ /  H !  ,  1  H~H
K	 H8
 A   H	u	 
HxHR
 L|$@' /  H R! +  `1  	 HtH	 HHtnf	 HE u
HEHP0HD$ H$  3LLHl$ H$   yXH~
 Lt$( 1  H5   0,  1  H~
 L|$@l /  H	   +  0    H
 LHu'HO~
 ) 2  [  :,  H b0  H@L   MtH IAH2L@@MtH IH AHH I	 HHu'H}
  2   <,  H< /  Iu
IGIP0H	 LH9F   L~M   H~IHHHHuHAP0IHƞLHD$ Hu'HB}
  2  N J,  H U/  Iu
IGIP0LHu
HFHP0H$  HMHALd$8H;)	    H;$	    HH|$@	 LHD$ HugH|
  3   _,  H .  HCLHD$ HcHk|
 E 2  w M,  H ~.  H@H   H$   HuEH,|
  3  8 a,  H ?.  HHLHL$ HHl$@H$   LHuLH'	 I9D$u!I;|$
  ID$H4HHH|$@.I;|$  ItHHH|$@IHH  IHt$PLHt
HuHAP03T	 HHG  H$   I	 LH  H@H;x	 tYH;w	 tPII	 HH  H@L   Mu3Hz
  5   ,  Hb ,  IILLIu
IGIP0Nl@ MuFH	 H9GuL;gS  HGIN|II,L;g4  M} IIIHALH  HL$hL|$hHt
HuHAP0H
h L؞HH  H@L   MtH HALHD$0<L@@MtH HH ALHD$0H H	 LHD$0M7  HuHCHP0LL$0IAL   MtH IAH2L@@MtH IH AHH IJ	 HH  HL$0HuHAP0H=	 HՋHT$0H9Cu8HSHT$0Ht*HCHHH HHuHAP0HT$0   HH޾	 H9CuyHD$hH$(  DAH$0  H$   H$0  H@ E3H$8  HcHHH+覕LH>  HL$0Ht
HuHAP03Hl$0   AHc	 HHD$(Hs  HD$0Ht
HAHD$0    HD$hH$   E3H HDHB H HB HHD HPLH
  HL$(HuHAP03Hl$(Hu
HCHP0HNHH9N ~IHFL<HAHFIH	 p
  IIGIP0	 Ht H	 HH  	 Hu
HGHP0H$   LH$   Ht
HuHAP0	 HH  H
 螛LH\  H@L   MtH IAH2L@@MtH IH AHH I	 HH  Iu
IGIP0H	 LHkH9E    L{M   H{IHHHHuHAP0H4	 HoH9E uHE3H$   HEAL$   L$   HH  Iu
IGIP0E3v   	 LHD$(H
  LxI$E3E3HHML` HH  Iu
IFIP0Ll$(IHHH  Hu
HE HP0HT$P3LHH޺	 ;  Hu
HGHP0HL$XLHt$XHt
HuHAP0Ll$8HIEL   MtH IAH2L@@MtH IH AHH I	 HH  H	 LgI9$   H_H   HoHHHE HHuHAP0Hc	 LeI9$uJE3H$   HEAH$   L$   JHH  Hu
HCHP03Hx   <	 LHD$(H  HXHD$XE3H IHIF 3+HHW  Iu
IFIP03Hl$(IHHHF  Hu
I$HP0Hu
HFHP0L$   HIM H;
		   H| 	 HH  H@L   MtH HALHD$(<L@@MtH HH ALHD$(H H߹	 LHD$(M  Hu
HGHP0HϷ	 MfHI9$   I~H   InHIHE HLHl$(uHAP0Hw	 LeI9$uOHD$PE3H$   EAHH$   H$   YHH
  Hu
HGHP03Hs   K	 HH3
  HxHD$PE3H HHHC 3?HH	  Hu
HCHP03HHT$PIHH  Iu
I$IP0H$   Hl$(LH$   Ht
HuHAP0IM HH;
	   H& 	 HH
  IH	 LHD$(H
  Hu
HFHP0HL$xLt$xHt
HuHAP03Hl$(ֵ	 HH+
  A   HI	 HH  Hu
HFHP0HH  Hu
HSHR03ۅt0Kh	 HH  H
M HH@3HHHII3IILHD$xuIFP0   f	 LHD$(H  H$   H
v E3H IIFTHH  Iu
IFIP0   	 LHD$(HJ  H@IIH		 HH  Iu
IFIP0H$   Hl$(LH$   Ht
HuHAP0Ll$8HT$PI	 HH
  H@L   MtH HALHD$(<L@@MtH HH ALHD$(H H	 LHD$(M	  Hu
HCHP0   	 HH	  I$L`	 HHb	  LP H	 H 	 	  LHIʍHH  Iu
IFIP0HHl$(u
HCHP0HHu
HFHP0Lt$PLIIH_	 ]  Hu
HGHP0I	 H  H|$@Ld$ HH$   L$   ID$H;	 uI|$tOID$HxH{H;ٲ	 uI|$t+I|$ H[HHhHtHAHt   IH:   	 HHuH"HI	 HE Hu
HEHP03H  H E3HEAFHH  Hu
HGHP0H  Hu
HVHR0Ld$ H$   H|$@HH
 ?HH  H@L   MtHt	 HAH2L@@MtHY	 HH AHHC	 H2	 HH  Hu
HGHP0IIr	 HHC  H	 LcHl$(I9$   LsLt$(M   HkIHHE HHuHAP0H	 LeI9$u`E3H$   HEAL$   H$  蜈HH  Iu
IFIP03HHl$(   HGHP0~   x	 LH  3E3HHL$(HLpHx oHH  Iu
IGIP03L'HHQHH  Hu
HGHP0Hu
I$HP0Lt$PLIIH	   HH|$@Ld$ H$   HFHP0H$   xH\j
 6 5  h ,  H E  H5j
  4  A ,  H   Hj
  4   ,  H{   Hi
  4   ,  HT   Hi
  4   ,  H-   Hi
 s 4   ,  H   Hri
 L 4  ~ ,  H [  HKi
 % 4  W ,  H 4  H$i
  5  0 ,  H 
  Hh
  6  	 --  Hj   Hh
  6  
 A-  HC   Hh
  6  
 ;-  H   Hh
 b 7  
 f-  H q  Hah
 ; 7  m
 z-  H J  H:h
  7  F
 t-  H #  Hh
   8  
 -  H   Hg
   8  	 -  HY   Hg
   8  	 -  H2   Hg
 x  ;  	 -  H   Hwg
 Q  A  	 ^.  H `  HPg
 *  A  \	 t.  H N  H)g
   A  5	 n.  H   Hg
 
 A  	 z.  Ho   Hf
 
 A   W.  HH   Hf
 
 A   J.  H!   Hf
 g
 A   G.  H v  Hff
 @
 A  r E.  H O  H?f
 
 @  K 8.  H R  Hf
 
 @  $ 5.  H   He
 
 @   3.  H^   He
 
 @   ,.  H7   He
 }
 >   ".  H   H|e
 V
 >   .  H  e  HUe
 /
 >  a .  H  >  H.e
 
 >  : .  H    He
 
 >   .  Ht    Hd
 
 >   .  HM    Hd
 
 >   .  H&    Hd
 l
 <   .  H
 {  Hkd
 E
 <  w -  H
 T  HDd
 
 <  P -  H
 -  Hd
 
 <  ) -  H
   Hc
 
 ;   -  Hc
   Hc
 
 ;   -  H<
   Hc
 
 ;   -  H
   Hc
 [
 9   -  H
 j  HZc
 4
 9  f -  H
 C  H
	 Ht	 H		 Lc
 
 9  L
 ! -    Hb
 
 8   -  Hb
   Hb
 
 8   -  H;
   Hb
 
 8   -  H
   H
H	 H	 H	P	 Lib
 C
 8  L
 n -  g  HBb
 
 7  N `-  H
 +  Hb
 
 7  ' S-  H
 .  Ha
 
 6    G-  Ha
   Ha
 
 6   '-  H:
   Ha
 
 6   -  H
   Ha
 Y
 6   -  H
   HXa
 2
 6  d -  H
   H1a
 
 5  = ,  H
 D  H
a
 
 4   ,  Hw
   	 HtH	 HHmt!#	 I$  ID$IP0  H`
 {
 3   |,  H
   3i	 LHu,Hj`
 Lt$(?
 C  H
 j .    H$   HD$8LHO H;
ڦ	 uCH
	 H	 H		 L
`
 Lt$(L
 
 D  
 .  Z  H
 @	 LHu,H_
 Lt$(
 D  H;
  .    H3	 LHu,H_
 Lt$(`
 D  H
  .    I$uID$IP0Hl$ LM   H
q
 HH  H@L   MtH
 HAH2L@@MtH
 HH AHH
 Hץ	 HH   Hu
HFHP0HCL   MtH
 HAH2L@@MtH
 HH AHH
 Hj	 HH  Hu
HCHP0I	 HH@  HJ	 LH9Fu.L~Mt%HFIHH HHuHAP0   HH	 H9F   HG L$  DAH$p  HcH$h  HE3HH+L$`  H$h  L$x  zHHD$ H  MtIu
IGIP03HLu
HCHP0H   AHc	 HH 
  MtLxE3H$   L$  H\HA E3HH HA HHD I$Ld(3HS|HD$ H	  Hu
HGHP0H|$ Hu
HFHP0HL$`HH|$`Ht
HuHAP0H$   Hl$ HO H;
9	   H
 ޡ	 LHD$ H  H@H;	 uIx tMI@H0HH;	 uIx t,IpHaHHhHtHAHt3ILD$ H>3	 HHt!HL$ HI	 HHu
HGHP0LD$ H$   H  I u
I@IP0HL$pHl$ Ht$pHt
HuHAP0IH\z  =  HO H;
	 O  H
 	 HH  H@H;	 u!H~ t\HFL Ld$ I$   H;]	 uH~ t2LfLd$ I$aHHhHtHAHt3HLHD$ >3e	 HHu
LHl$ $HH	 HLHD$ u
HGHP0M,  Hu
HFHP0H|$pIH	 HH  I$uID$IP0HHHt$puHGP0HH
P
 ~LHD$ H  H@L   MtH
 IAH2L@@MtH
 IH AHH
 I	 HHm  I$uID$IP0H	 LgHl$ I9$   HWHT$ H   HoHHHE HHuHAP0HT$ HU	 LeI9$uSHD$`E3H$   H$   EAHH$   7vHH=  HL$ HuHAP03Hl$ }   %	 HHY  HD$ E3HHC3HHD$ HD$`H HC xHH  Hu
HCHP03HHT$`HyHH  Hu
I$HP0HFL   MtH
 HAH2L@@MtH
 HH AHH
 H	 HHp  Hu
HFHP0H$   HLH$   Ht
HuHAP0H

 r|HH  H@L   MtH'
 HAH2L@@MtH
 HH AHH
 He	 HHu  Hu
HGHP0   ~	 HH'  H
 HIH HGH'
 H HG Hw(n	 HH  Hu
HGHP0HL$8H
{  Hu
HFHP0IHM;X  H$   hHV
 {
 E  
 .  H
   HzV
 T
 I  
 -/  H
   HSV
 -
 I  _
 */  H
 f  H,V
 
 I  8
 (/  H
 ?  H
͜	 H	 H	՞	 LU
 
 I  Le
 
 &/    HU
 
 J  
 Y/  H4
   HU
 z
 J  
 m/  H

   HyU
 S
 J  
 g/  H
 b  HRU
 ,
 K  ^
 /  H
 e  H+U
 
 K  7
 /  H
   HU
 
 K  
 /  Hq
   HT
 
 K  
 /  HJ
   HT
 
 K  
 /  H#
   HT
 i
 J  
 s/  H
   HhT
 B
 J  t
 S/  H
 Q  HAT
 
 J  M
 E/  H
 T  HT
 
 J  &
 C/  H
 -  HS
 
 H  
 /  H`
   HS
 
 G  
 /  H9
   HS
 
 G  
 
/  H
   H
F	 H'	 H	N	 LgS
 A
 G  L
 l
 /  z  H@S
 
 E  L
 .  H
 )  HS
 
 E  %
 .  H
   HR
 
 E  
 .  H_
   HR
 
 E  
 .  H8
   HR
 ~
 E  
 .  H
   H}R
 W
 E  
 .  H
   H
~
 wHHu'HBR
 
 L  N
 /  H
 +  H@L   MtH3
 HAH2L@@MtH
 HH AHH
 Hј	 HHu'HQ
 
 L  
 /  H/
   Hu
HGHP0H	 LcHI9$E  H{H8  HkHHHE HHuHAP0HP	 LeI9$a  Ll$8E3HT$@EAHH|$@Ll$H7nHHu'HQ
 
 L  
 /  Hu
   Hu
HGHP0Hu
I$HP0IHt$8LHuHAP0IE H$   L$  L$  L$  H$  H$  H$  H$  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$8Ht
HuHAP0HL$PHt
HuHAP0H$   Ht
HuHAP0HL$XHt
HuHAP0H$   Ht
HuHAP0HL$xHt
HuHAP0H$   Ht
HuHAP0HL$`Ht
HuHAP0HL$pHt
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0HL$hHt
HuHAP0H$  HtH u
HPHR0IH  A]ù   	 LHD$ Hu'HN
 
 L  
 /  H'
    HxHD$8E3H IHIE mHHu$HmN
 G
 L  y
 /  H
 nIE u
IEIP0Ll$8]Ll$8HIoHHAHN
 
 L  
 /  H
 HtHu
HGHP0HtHu
HCHP0MtIu
IGIP0HL$0HtHuHAP0Lt$(Ld$ 
Lt$(Ld$ MtIu
IFIP0MtI$uID$IP0HtHu
HFHP0E3E3L

 D
 N
 H
W	 qK[H\$Hl$Ht$WATAUHPHa	 HjMLH\$@HH\$HHM   Ht"HtH   Hz H|$HHZH\$@I	 HHHtHt+RHT  Hs
 I"	 HtHHD$@HH+  HJ
 I	 HtHHD$HHH  H	 LL$@Hu
 HD$(E3IHl$ xty
1     H|$HH\$@   H   H   H   Hy3L
p
    L
r
 HHծ	 Hl$0H_	 Ll	 HDHY
 HD$(HL$ H
 	 H	?	 1  L
#K
 H
<	 A^  0
 
 ^  L

 ʈ3Hz HZLHI H\$pHl$xH$   HPA]A\_HHPATH   E3HXHhHxLhLpHALIL   L$   Ld$HLd$0Ld$8IL$   Ld$ Ld$(MtH
 AH,L@@MtH
 H AHH
 	 HHt$xL|$XHu'HI
 
   
 75  HS
 1
  H׎	 MH9G   LM   HwIHHHHuHAP0IHjHHu'HnI
 H
   z
 D5  H
   Iu
IGIP0MHu
HGHP0HIu
HFHP03 	 HHu^HI
 
   

 T5  Hn
   HkHHuHH
 
   
 G5  H7
 w  IN H;
O	 u>H
^	 H_	 H	f	 LH
 Y
   L
 
 X5  ,  HX
 	 HHu'HCH
 
   O
 Z5  H
   H@HH$   H;T	 t~H;S	 tuH	 LHu*HG
 
   
 `5  HV
 H  H@L   Mu6HG
 
   
 b5  H
 HY  HLIMHu
HGHP0MdMuFH	 I9GuI;o  IGHH|HI,I;o}  I<$HHIIAHH4  HL$HH|$HHt
HuHAP0H[
 HJ	 HH   H
 H.	 HH   Hu
HWHR0HN3H9N ~HHFHHAHFHHu	 uHu
HCHP03H[F
 5
   g
 5  H
 H  H1F
 H$   
   H
 .
 5     HF
 H$   
   Hq
 
 5     	 HtHp	 HH]t\	 Iu
IGIP0H$   HH$   kyvHE
 Z
   
 5  H
 E3  HVE
 H$   (
   H
 S
 ~5  H  H  HFHP0  tH   3	 LHu'HD
 
   
 5  H[
   IN H;
s	 u>H
	 H	 H		 LD
 }
   L
 
 5  t  H
 މ	 HHu'HgD
 A
   s
 5  H
 8     |	 HHu'H-D
 
   9
 5  H
   HH
S
 E3HHpHX PcHHu'HC
 
   
 5  HN
   Hu
HGHP0HCH;	 t}H;	 ttHZ	 HHu'HC
 ]
   
 5  H
 ?  H@H   Ht$@HuEHGC
 !
   S
 5  H
   HE3HIL$   ILl$@E3HHu
HCHP0Lt$0LdHuVH$	 H9Gu'H;o  HGHH\H$   HI3H;o  I$HHIH$   HHHQ  HCH	 H;   H;	    H	 LHD$(H	  Hu
HSHR0INIIH   IH$   H}  Iν   HD$ He  I֍UH(  Iu
IFIP0H$   Ht$ Lt$0Ll$(NHKH  H;uHKHs H$   HCHHpH$   HHHu
HCHP0H$   ILHD$0Ht
HuHAP0HL$8HL$   HD$8HtHu
HAP0HI^Ll$ HshH   H~     H;	 t"HRHHu	 H  IHy?HHt7IHxHy(Hy#IH
	 H		   	 IHIV HSH[pH  H{ w  H	 HL	 HHw  HISHHu
HVHR0HU  IOI9O ~HIGHHAIGHIچ	    HHt$@HCHP0H?
 H$   
   H$
 
 6  i  Iu
IFIP0Ll$(%uHdH`?
 H$   2
   H
 ]
 	6    H1?
 H$   
   H
 .
 5    H?
 H$   
   Hq
 
 6    MFH
	 H	 M@H	ˇ	 IH>
 H$   
   H 
 
 6  e  H~H
L	 H
	 A   H	v	 
HxcHS>
 H$   %
   H
 P
 5    ݄	 Ht H	 HH   `	 Hu
HGHP0H$   ILL|$XLt$`Ll$hH|$pHt$xH$   HtHE u
HEHP0HL$HH$   Ht
HuHAP0HL$0Ht
HuHAP0HD$8HtH u
HPHR0IHĐ   A\HG=
 H$   
   H
 D
 5  HtHu
HGHP0MtIu
IGIP0HtHu
HCHP0H$   Ht
HuHAP0HL$ Ht
HuHAP0HL$(HtHuHAP0E3E3L

 Dk
 
 H
	 EzHHPHHH   HXHhHxL`3E3H3H$  HD$(HD$0HD$ HD$HHC3L   Ld$`Ld$pLd$@Ld$PLd$XHL$8MtH
 HAH2L@@MtH
 HH AHH
 H	 HH$   L$   L$   L$   Hu'Hx;
 R
   
 6  H
 u  Hi	 3H$   H9G   HwH$   H   H_HHHHHuHAP0HHp\LHu*H:
 
   
 6  H^
 L  Hu
HFHP0H$   3H$   Hu
HGHP03IE u
IEIP03q	 LHunHr:
 L$   D
   H
 o
 6  i  H]LHuH3:
 L$   
   H
 0
 6  *  HK H;
	 uFH
	 H 	 H	ǂ	 L9
 L$   LY
 
   
 6    H
 	 HHu/H9
 L$   n
   H
 
 6    H@H;~	    H;~	    HI	 HH$   Hu*H29
 
   >
 6  H
 L.  H@L   Mu;H8
 
   
 6  He
 L  HHH$   E3Hu
HGHP03NtMuEH}	 H9FuL;f#	  HFIJ|HI+L;f	  I>IHIHAHH  HL$XHH|$XHt
HuHAP0HS
 H

 3H	~	 HH$  HtH H|SHH$  H$  HAL   MtH
 AH,L@@MtH
 H AHHv
 ~	 HH  H$  HuHAP0H
 H|	 H$  H<  H
 H

 H7}	 HHD$0HtH HRHHD$0H  HFL   MtH
 HAHHD$ <L@@MtH
 HH AHHD$ H
 H}	 HHD$ H0  Hu
HFHP0H
 HL$X{	 HHD$0H  H
{	 HsH|$8H9.  LCLD$8M  H[HD$ I HH HH\$ uH@P0HT$0LD$8H%|	 HsH9urE3L$   H$   H$   EAH
SHD$(H+  HD$8H u
HPHR0HL$03HH\$8uHAP0H\$0H\$       {	 HHD$HH0  HL$8E3HHHD$03HL$8HL$0HHB THD$(H  HL$HHuHAP0H|$H-HVHD$(HB  HL$0HuHAP0H|$0Hu	HHP0   /{	 HHD$ H  H$  H

 E3HCHD$(HHC 3H$  
THD$(Hc  Hu
HCHP0Hy	 HuH|$ H9)  HUHT$ H  H]HHHHHuHAP0HT$ HCz	 HsH9umHD$(E3H$   H$   EAHH$   &QHH  HL$ HuHAP0HL$(3HH\$ uHAP0H\$(      y	 HH$  H  HD$ 3E3HAHD$(HT$ HT$(HHA HRHHv  H$  HuHAP03H$  5H\$(HHTHH  Hu
HCHP0HD$(    HE u	HHP0IM3I9M ~HIEH<HAIEHIy	 9  Hu
HGHP0H$   3H2
 L$   
   H
 
 7    H~2
 L$   P
   H
 {
 !7  u  HO2
 L$   !
   H
 L
 7  F  H 2
 L$   
   H
 
 D7    H1
 L$   
   H`
 
 Z7    H1
 L$   
   H1
 
 T7    H1
 L$   e
   H
 
 `7    Hd1
 L$   6
   H
 a
 =7  [  H51
 L$   
   H
 2
 /7  ,  H1
 L$   
   Hu
 
 '7  
  H0
 L$   
   HF
 
 7  
  H0
 L$   z
   H
 
 6  
  Hy0
 L$   K
   H
 v
 6  p
  HJ0
 L$   
   H
 G
 6  A
  H0
 L$   
   H
 
 6  
  H/
 L$   
   H[
 
 6  	  H/
 L$   
   H,
 
 6  	  Gv	 HtH+x	 HHqtYt	 Hu
HFHP0H$   E3MLl$`&yVH;/
 
   G
 n7  H
 	  H/
 L$   
   H
 
 6  	  t	IE E
  H$   HI H;
|u	 u>H
u	 H	 H	w	 L.
 
   L#
 
 7  d	  H
 s	 LHu'Hp.
 J
   |
 7  H
 o     t	 HHu*H6.
 
   B
 7  H
 L2  I$H
X
 E3HL`Lh UMLHu*H-
 
   
 7  HS
 L  Hu
HFHP0IEH;r	    H;r	    HIH$   Hu	 H$   Hu/Hl-
 L$   >
   H
 i
 7  c  H@H   Ht$xHuQH(-
 L$   
   H
 %
 7    IE 33ML$   Ht$xH$   L$   IE u
IEIP0ILHL$hHuoH$   Hq	 H9Fu0H;^  HFHLLlH$   IE HHL$h;H;^  L)HLIE HH$   HL$hILH  IEH{q	 H;   H;cq	    Is	 HH$  H?  IE uIEIP0H$  HA3H   HH  L$     IHH  IӍVH6Y  I$uID$IP03H$  @IMH  H;u
I}Im IEH8HhHHE IE u
IEIP0HL$pHH\$pHt
HuHAP0HL$@3Hl$@Ht
HuHAP0HC3H;.p	 tYH;-p	 tPHIr	 LH0  H@L   Mu3H*
 
   
 8  H
   HE3LE3OtMuGHo	 I9Eu M;e  IEIJlHE I,M;e  I.IHE IIAHH  HL$PHl$PHt
HuHAP0HH\o	 HH  HxHwhH   H~     HD$@H;pp	 t"H&HHu_p	 H  3Hy>HHt6HHxHy'Hy"3H
Vp	 H	n	 @  n	 IHHV HUHpH  H   Ho	 HL$@Lo	 HH  HHWHHu
HSHR0H  HE u
HEHP0H\$pHT$PLH3p	 E  Hu
HGHP03Ko	 Ht H/q	 HHj  m	 IE H$   HL$hHt$xL$   IEIP0HL$hzH.(
 
   :
 7  H
 U  L$  I$uID$IP0E3
uHpMH'
 
   
 7  HF
    H'
 
   
 7  H
   H'
 e
   
 	8  H
   Hd'
 L$   6
   H
 a
 ;8  [  L@H
m	 H	 M@H	-p	 3H'
 L$   
   H
 
 88    H&
 L$   
   HT
 
 68     H&
 L$   
   H%
 
 &8     H~H
Qm	 H	 A   H	{o	 
HxKHX&
 2
   d
 7  H
 Zl	 Hn  Hn	 HHgtpk	 H$   M  H%
 ־
   
 7  Hi
 MtIE u
IEIP0L$  L$  HtHu
HGHP0MtIu
IFIP0MtI$uID$IP0HtHE u
HEHP0HL$(Ht
HuHAP0HL$0HtHuHAP0Ld$`Ld$`HL$ Ht
HuHAP0HL$8Ht
HuHAP0HL$HHt
HuHAP0L
d
 D
 
 H
(	 bE3$H$   Hu
HFHP0Ld$`MI$L$   L$   H$   H$   H$   H$   MtI$uID$IP0HL$pL$   Ht
HuHAP0HL$@Ht
HuHAP0HL$PHt
HuHAP0HD$XHtH u
HPHR0IL$   H   +H8LJL1k	 E3H;'j	 A3M;A   MuH
vi	 H_	 H	&l	 FL;j	 uL;
i	 t]L;
i	 tTIAH
i	 MJH	L	 H9	 HD$ l	 H
"
 ѻ
 #  
 LA  3H
b
 H8H8l@SUVWATAUAVH Hh	 3L0H\$`HMn`MfhInpH\$hHH\$pMtIE MtI$HtHE T  Hi	 INHL
A"
 L   A2N  L

 
 D7
 I;trH'  I@   s
I35HAH;nf	 t!      t
   rIUf	 3Lb   L
5
 
 D
 DH
	 A^_LL$pLD$hHT$`IWyM
   
 LN  ^H
 H

 E3@HHuU
 XN  *E3E33HLHu
HCHP0)
 \N  
   H !
 H\$`Ht$hH|$pHj
 LMIIUHtHu
HCHP0HtHu
HFHP0HtHu
HGHP0L

 Dh
 
 H
	 B^H A^A]A\_^][MtIE u
IEIP0MtI$uID$IP0HtHE u
HEHP0H A^A]A\_^][H(IL$0d	 Hu9L

 D@PH
	   
 P   
   L
@
 ]3H(+H(Ht	H(鎎H
f	 HH	 H	Gh	 H(@SH HHt
H [(He	 H HAHHIH9 uHAP0He	 HC3H [@SH HHt
H [He	 H HA HHI H9 uHAP0H_e	 HC 3H [H(A(Af	 Hu9L
u
 D@TH
J	 
  ?
 T   q
 
  L
ҹ
 \3H(H(Ht	H(H
Oe	 H	 H	f	 H(@SH HHt
H [XHd	 H HA8HHI8H9 uHAP0H_d	 HC83H [H(AHAe	 Hu9L
u
 D@XH
	 }  ?
 X   q
 }  L
Ҹ
 [3H(H(Ht	H(H
Od	 H	 H	e	 H(@SH HHt
H [XHc	 H HA`HHI`H9 uHAP0H_c	 HC`3H [@SH HHt
H [H!c	 H HA HHI H9 uHAP0Hb	 HC 3H [H\$Ht$WH03Hty'H
 
    
 /\  Hy
   3$b	 H
 Hu'H
 
    ݽ
 0\  H>
   H
~	 3c	 H
 Hu'H
 i
    
 1\  H
 i  H
~	 3b	 H
 Hu'HM
 '
    Y
 2\  H
 '  sy'H
 
    )
 =\  H
   H
 H
	 E3E3D$   b	 H
 HE  H H_	 H
 Hu'H
 
    
 X\  H
   H
 H
n	 H -c	 Hn
 Hu'Hb
 <
    n
 Z\  Hϵ
 <  H
;	 b	 H
 Hu'H"
 
    .
 [\  H
   L
 H

 H	 b	 y'H
 
    
 _\  HI
   y'H
 
    
 a\  H
   95
 tFL
 H

 H	 9b	 y'H^
 8
    j
 f\  H˴
 8  Iy'H.
 
    :
 q\  H
   ,y'H
 ر
    

 s\  Hk
   H/
 Ha	 y'H
 
 E   Ϻ
 x\  H0
   H

 H	 LH5s/
 Ua	 y'Hz
 T
 E   
 z\  H
 T  Hú
 H6
 Ha	 y'H8
 
   D
 |\  H
   H
)
 HJ	 LH56
 `	 y'H
 ɰ
   
 ~\  H\
 
  H@
 H7
 Hx`	 y'H
 
 f   
 \  H
 
  H
 H8
 H57
 H/`	 y'Hd
 >
 i   p
 \  HѲ
 >
  HŹ
 H6:
 H58
 H_	 y'H
 
   '
 \  H
   H
 H};
 H5:
 H_	 y'H
 
   ޸
 \  H?
   H	 H
	 E3Ah  H5\;
 H%
 pH
 Hu'H
 O
 	   
 \  H
 O  E3H	 H
	 EA`KpH|
 Hu'H0
 
    4
 \  H
   Hy	 H
~	 E3AH
  oH5
 Hu'H
 
    
 \  HF
   HB	 H
G	 E3A0  oH
 Hu'H
 d
    
 \  H
 d  E3H	 H
		 EAP`oH
 Hu'HE
 
    I
 \  H
   H	 H
	 E3A   oHb
 Hu'H
 ȭ
 u  
 \  H[
 
  yly'H
 
    ʶ
 \  H+
 
  u'H
 g
 #   
 \  H
 g
  H

 A3{KHHu'H
L
 &
 &   X
 \  H

 	  HM
 H
~
 LY	 y
 &   
 \  	  Hu
HCHP0H

 A3JHHu
 '   ڵ
 \  w	  H
 H

 L>Y	 yt
 '   
 \  C	  Hu
HCHP0H

 A3JHHu1
 (   c
 \   	  H
 H

 LX	 y
 (   /
 \    Hu
HCHP0H

 A3JHHu
 *   
 \    H
 H

 LPX	 y
 *   
 \  U  Hu
HCHP0H

 A3IHHuC
 ,   u
 \    H
 H

 LW	 y
 ,   A
 \    Hu
HCHP0H
լ
 A3IHHu̪
 -   
 \    H

 H
+
 LbW	 y
 -   ʳ
 \  g  Hu
HCHP0   zV	 HHu\
 .   
 \  +  H
 AHH HKH
 HH
 H HKH
 HAH
ҫ
 EHHHu'H

 
 .   "
  ]  H

   Hu
HCHP0H
 HgIHHu
 .   ۲
 ]  x  H
 H

 L?V	 yu
 .   
 ]  D  Hu
HCHP0Hۭ
 HHHHu5
 .   g
 ]    H
 H

 LU	 y
 .   3
 	]    Hu
HCHP0Hu
HGHP0   T	 HHu'H
 
 /   
 ]  HA
   H-
 AHH HOH
 HH
 H HOH
 HAH
 H HOH
 HAHt
 H HOHf
 HAH
 H HOH
 HA H

 EFHHu
 /   )
 %]    Hu
HGHP0Hm
 HuGHHu
 /   
 (]    H=
 H

 LMT	 y
 /   
 *]  R  Hu
HGHP0H
 HGHHuC
 /   u
 ,]    HQ
 H

 LS	 y
 /   A
 .]    Hu
HGHP0H
 HFHHuϦ
 /   
 0]    He
 H
.
 LeS	 y
 /   ͯ
 2]  j  Hu
HGHP0H
 HFHHu[
 /   
 4]  *  Hy
 H

 LR	 y'
 0   Y
 6]    Hu
HGHP0Hͦ
 HEHHu
 /   
 8]    H
 H
F
 L}R	 y
 0   
 :]    Hu
HGHP0HHu
HCHP0H

 A1HHuc
 2   
 E]  2  H@H
 HL   MtAL@@Mt	H A9S	 HHu
 2   =
 G]    Hu
HCHP0H
 E3HV+HHuȤ
 2   
 J]    Hu
HGHP0HF
 H

 LHKQ	 y
 2   
 M]  P  Hu
HCHP0L
 H

 3R	 HHu:
 l  l
 W]  	  HX
 H

 LP	 y
 l  8
 Y]     Hu
HCHP0Ll
 H

 3R	 HHu
 o  
 c]     H%
 H

 LUP	 y
 o  
 e]  ]Hu
HCHP0O	 HHu
 m]  )H
 H
é
 LO	    h
 o]  "
    H7

 H
 HtHu
HCHP0HtHu
HGHP0H

 H   H95O
 t#L
n
 Dâ
 H
	 3GH

 HuHAP0H5Ϋ
 H\$@Ht$HH0_Hu^HCHH\$@Ht$HH0_H`0H	
 Y
    
 V\  H
 P	 HuH
*R	 Hk	 H	"R	 H\$@Ht$HH0_\H\$Hl$VWATH@HO	 HzILH\$pHM   HtH   HZH\$pIN	 HHu)H  H
 HjN	 HtHHD$pHH   HR	 LL$pH
 HD$(E3HH|$ 0y
y'     H\$p   H   H   Hy3L
	    L
	 HHUk	 H|$0H~	 L	 HDH	 HD$(HL$ H
N	 H	P	 '  L

 H
	 A  
 j
   L

 JE3HZHI'^H\$`Hl$hH@A\_^LI[IkIsI{ ATAUAVH`H=M	 H-5L	 H56L	 LbI{IkIsMLIM%  Mt0Ht!HtH1  Hr(IsHj Hl$HHzH|$@IL	 HIMtHt1HtT{H  H
 IlL	 HtHHD$@HHg  H̠
 ICL	 HtHHD$HHH>  H
 IL	 HtHHD$PHH  H2	 LL$@HN
 HD$(E3ILd$ .y
)     Ht$PHl$HH|$@   M   H   H   H   My3L
	    L
	 HHh	 Ld$0Hq|	 L	 HDHk	 HD$(HL$ H
L	 H	QN	 )  L
5
 H
	 A  B
 
   L

 B3Hr(Hj HzLLHIkL\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$VWATH@HI	 HzILH\$pHM   HtH   HZH\$pIJ	 HHu)H  H۝
 H:J	 HtHHD$pHH   Hb	 LL$pH
 HD$(E3HH|$ ,y
5     H\$p   H   H   Hy3L
	    L
¼	 HH%g	 H|$0Hz	 L	 HDH	 HD$(HL$ H
PJ	 H	L	 5  L
s
 H
ܞ	 A  
 :
   L
מ
 A3HZHI藸H\$`Hl$hH@A\_^H\$Hl$VWATH@HH	 HzILH\$pHM   HtH   HZH\$pIH	 HHu)H  H+
 HH	 HtHHD$pHH   H	 LL$pH
 HD$(E3HH|$ 	+y
`6     H\$p   H   H   Hy3L
	    L
	 HHue	 H|$0Hx	 L	 HDH	 HD$(HL$ H
H	 H	J	 n6  L

 H
l	 A  У
 
   L
'
 j?3HZHI'H\$`Hl$hH@A\_^H(Ht	H(H
H	 H	 H	J	 H(DL$ DD$T$L$SUVWATHp  HD$@AA؋/HCc
 HD$ L
/c
 L$  Hi	 H

 茬 ̅y/H@m
 HD$ L
b
 L$  Hi	 H

 Y ̅/Hb
 HD$ L
b
 L$  Hi	 H
[
 & E/Hb
 HD$ L
b
 L$  Hfi	 H
'
  fn* ) D,G;tt
m     DBHL$pA	 H$  H$   A	 Hi	 H$   ќ IcHL$0s@	 H$   LcAJ   HPH$   @	 HH+h	 芜 Hȋ@	    HL$0@	 HHh	 H$   X HHu3
HHcIHHVkdřH@	 HHg	  HKh	 HTh	 $   HEH$    H$  H$   @	 HT$HHL$p@	 H$  LHAHL$H?A	 HL$p{@	 Hp  A\_^][@SH Hs
 H
ĺ
 H+]
 H輂 H+HH [H\$Hl$Ht$WATAUH0HyXHq(Hi(MLLHT$ H HH HtH;tpA	 H9{u2SHT$ MH HHHuEA	 HHu3HH@0H9Cu&A	 HSIH@?	 H\$PHl$XHt$`H0A]A\_@UVWATAUAVAWH  HǄ$   H$  LE3IL|$`L|$hL|$pH$   >	 H$   >	 MML$  L$  E3H{
 H
<
 'LHu'H H9
 
 y   
   M  HH$  LphAACAFACINHHu'Ha H
 4
 }   f
 (  
  LHL;
~A	 tIMIL}	 H}	 H
B	 H	"E	 L L
 ޔ
 }   
 *  
  HFHHNL9!uHAP0H~IN8'HHu'H H9
 
 ~   
 8  M
  LHL;
@	 tIMIL}	 H!}	 H
:B	 H	yD	 Lb L
 5
 ~   g
 :  b  HF HHN L9!uHAP0H~ AFhF(3@	 Hu'H H
 ۓ
    

 R    HHD$`I   I;   vj>	 IFpHD$PH\$X(D$PfD$PHt$PH|$X    I   I9   v*>	 HtI;vpt>	 AH;  Hu=	 MLI;{ r=	 HG H+GHHH$   Hu=	 MLI;{ r=	 H_H;_ v=	 HHu=	 MLI;[ r=	 L|$@D$8  D|$0H\$(L|$ A   L$   AQH
 HH  HH   HL$hHD$hHt
HuHAP0LEHM HHAL;AI;tHHEJI@HEHH.@	 t(Hu<	 MLI;{ r<	 H0iH H
 Ց
    
   H$  
  H HT
 
    ؚ
   H$  `
  3=	 HHu'H H
 g
    
   	  I   I;   v;	 I   HD$PH\$X(D$PfD$PIHt$PHl$X
II   I9   v;	 Ht	I;   t;	 H;  Hu;	 MLI;k rp;	 HH$   :	 HuT;	 MLI;k r@;	 H(H$   H$   9	 H$   H$   (:	 HH$   H@H{ rHKHKII;}HH33.=	 L'H=1?	  tE3&?	 LE3E3
=	 LH9	 Mt|HOH9O ~I$HGL$HAHGIH=	 u%I$ID$IP0IH H!
 s
    
     Hy H
 L
    ~
   y  H|$pH
u
 LHu*H
9 H

 
    >
   I]  H@L   MtHϏ
 IAL2L@@MtH
 H IALH
 I<	 LMu*H H7
 
    
   I  I$uID$IP0   ;	 LHu*Hg H
 :
    l
   I  HHxHD$`H ID$ E3IH
s
 ~HH$  Hu*H
 H

 ڍ
    
   I+  I$uID$IP0MIuH9	 H9y  MeMl  I]I$HILHuHAP0HsH:	 H9   L$   H$   E3EAH$   HuHHu'HF HǏ
 
    K
   F  I$uID$IP0MHE u
HEHP0L$       (:	 HH$  Hu'H
 H
R
 
    ֕
     L`MHh L$  E3HHHHu'H H
 T
    
     H$  HuHAP0L$  SHIHHu'H( H
 
    -
   (  HE u
HEHP0L$  IE u	HIP0MH$  HF0HHN0L99uHAP0H~0Ip  
HHu'H H
 q
    
     HF@HHN@L9)uHAP0H~@A  FHI  H$(  4	 HH$   H@H{ rHKHKIII;}HH337	 H'H=9	  tE39	 HE3E37	 HHw4	 Hu'H H<
 
    
 (    HFPHHNPH9 uHAP0H~PI  HHu'Hd H
 7
    i
 7  d  HFXHHNXH9 uHAP0H~X36	 HHu'H H
 
    
 F    I  I;   v{4	 I   H$   H$   ($   fD$PHt$PHl$Xffff     I   I9  v*4	 Ht	I;   t4	 H;D  Hu4	 MLI;k r3	 HH$   2	 Hu3	 MLI;k r3	 H(H$   H$   L2	 H$   H$P  2	 HH$   H@H{ rHKHKIII;}HH335	 L'H=7	  tE37	 LE3E35	 LH%2	 MtnHOH9O ~IE HGL,HAHGIH<6	 uIE IEIP0H H
 
    $
 Q  "H H|
 ·
     
 O  HtHu
HGHP0H$  H$  MtI$uID$IP0MtIE u
IEIP0H$  Ht
HuHAP0HtHu
HGHP0H$  H$  L
̉
 D!
 W
 H
 p	 +*H$  HF`HHN`H9 uHAP0H~`HLHtHu
HFHP0HL$`Ht
HuHAP0HL$hHt
HuHAP0HD$pHtH uHPHR0H$   C0	 H$   40	 IH$  HĀ  A_A^A]A\_^]H\$Hl$Ht$H|$ ATHPH      ?)t$@HAH=L
 H5=
 HH;v0	 H=0
 H5!
 H
 H
 Hl$(H+
 H\$ (t$ HuH;v
r0	 H˨
 H\$ Ht$(ZH
0
 H+ft$ H&q H0H+Hu50	 E3LH| I;{ wHtH3H;xs
0	 H|$((D$ HL$ HT$0fD$ HHHA)t$ H|$ H\$(HBLd$8Hl$0HtH;t/	 L;   ft$0Hu/	 E3LI;[w/	 HD$0HsHuw/	 E3LI;s rc/	 HHPHuO/	 E3LI;[w;/	 HH\$((t$ `H\$`Hl$hHt$p(t$@H|$xHPA\@SH   HD$ Hߧ
 H+Ч
 HtNHP	 HL$(-	 HL$P.	 H1
 HD$PHT$(HL$h-	 HE HL$P_ H

 ^a H

 Ra 3H
 H
r
 H+HHtKfD  H;r
E.	 H
N
 LMtI    IH
1
 HH/
 H+HH;rH

 ` H
     H
 H

 H+HHu
-	 H
u
 HHä
 H
 H

 H+HHu-	 H
 H
m
 HHH

 HĐ   [@SH   HD$ HO
 H+@
 HuNHO	 HL$(&,	 HL$Pj-	 HZ0
 HD$PHT$(HL$h%,	 H HL$P H
˥
 m E3HH
A
 ` Lͥ
 IH+
 HtIL
 H

 m E3HH
7
 ` L
 IH+Ѥ
 HtILƤ
 H

 Jm HHx
 H
i
 H+HH;sEH;r
B,	 H
K
 LMtI    IH
.
 HH,
 H+HH;rH

 l E3HH

 _ L
 IH+
 HtIL
 H
O
 HĐ   [W H\$ WH0H
 H=x
 3H+
 HHT$@HuLLe
 L+IH
O
 Hl$HHt$PHH+HI;sHAHH(
    HH;v+	 H

 H=
 H
 HHt$(H+HHT$ HuH)H;v
*	 H
 HtH;t*	 H+H(D$ LL$@HT$ H

 A   fD$ > H-
 H;-
 v*	 H=S
 Hup*	 LLHL I;K wHtHHH;HsD*	 H
 H=~
 H+ߢ
 HHT$@HuLLm
 L+IH
W
 HH+HI;sHAHH:
    HH;v)	 H
 
 H=
 H
 HHt$(H+HHT$ HuH)H;v
)	 H
 HtH;t)	 H+H(D$ LL$@HT$ H

 A   fD$ = H-
 H;-
 v<)	 H=e
 Hu*)	 LLHL I;K wHtHHH;Hs(	 H
 H=
 H+
 HHT$@HuLL
 L+IH

 HH+HI;sHAHHd
    HH;v(	 H
J
 H=;
 H
 HHt$(H+HHT$ HuH)H;v
Q(	 H
 HtH;t:(	 H+H(D$ LL$@HT$ H

 A   fD$ l< H-
 H;-
 v'	 H=
 Hu'	 LLHD I;C wHtHH;Cs'	 H
 H

  H
 H
Ԟ
 ט H
 H

 Ht$PHl$HH\$XH0_鰘 @WH@HD$ H\$XHl$`Ht$h)t$0IIf(HH)
 HH0H
 H;
 r0   H

 Q HH\$PHt)f(H Li
 LHkHs HD$pHC(3HHH\$XHl$`Ht$h(t$0H@_HVWATAUAVH   HD$ HXHh)p)xD)@D)HD)PIHLL$    H=N
 LIH=A
 H;=2
 rIH

 y LH=
 Ht2IHI+Hffffff     HHHHuH=
 fWf(3H|EHVLCIIJ    HBXpHBXpHXpHBXpH IuH;sHXpHH;rfEL*K
 HyDXA^3H|tLFHSHHH    I@@\YXI@H\YXI @\YXI@H\YXI HuH;sH@\YXHH;rHCfEL*HyDXf(A^
 fD(HIH=
 H;=w
 rIH

  HH=d
 
4
 f/vEfA(
 
4-
 ^$   H  HH$   HHH=
    EY,
 A^E3H   H~HMLL+HSHHL    HG@\YAI	H\Y	HG@\YAHH\YIH H HuH=e
 L;s4JT H+HI+H2@\YHHuH=,
 HH0H=
 H;=
 r0   H

 T HH$   Ht%fA(H HP
 HH^Ln Hn(3I6IL$   I[8Ik@(t$p(|$`E(CE(KE(SIA^A]A\_^HT$HL$SUVWATH0HD$ HHE3Dd$pHz H+zHAL$	 HtH0IHDd$pLD$pHH
^ IHC H+CHHtVD  HC H+CHH;r!	 HkHF H+FHH;r!	 HND HHC H+CHH;rHKHt] LcLc Lc(HI HH0A\_^][HHHUVWATAUAVAWH   HD$ HX)p)xHH@        Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;Y"	    H;T"	 t{IH$	 HHu+L
 L
gx
 A/   Du
 <Q  ~
   H@L   Mu4L
 L
,x
 A/   D{u
 >Q  ~
 }  HE3E3Nl=;
 MuEH!	 H9GuL;g|  HGJHII,L;g^  I] HIIHAHH  ILHt
HuHQR0H-!	 H9Cus$   H#	 f($   f.zus"	 H!  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$pHH;v	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;v	 HT$PHtH;t	 H+H(D$0fD$@L$   A   HT$@HL$P, Hl$hH;l$pvu	 H\$PHue	 E3LHL I;K wHtH3H;H,6	 !L
 L
v
 A0   DZs
 iQ  |
 H$   W!	 Ht~H"	 HHt	 `L
A L
u
 A/   Ds
 YQ  2|
 H$   HuHGHP0L
{u
 Dr
 |
 H
	 %Hu
HGHP0HT$PH$   HcM MtIuIFIP0HL$hHt HD$h    HD$p    HD$x    HL$P HL$   I[HA(sA({IA_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       s Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN6 HtH3HHC    HC     HC(    Ǆ$      HGH;	    H;	 t{HH% 	 HHu+L
^ L
s
 A/   Dq
 Q  Oz
   H@L   Mu3L
# L
s
 A/   Dp
 Q  z
 Q  H3E3LlfMuEH	 H9GuH;oX  HGHHHI,H;o:  I] HHIHAHH  ILHt
HuHQR0H$HH$   Hu	 H  H\$hHu3HT$xH+HHL$pHH+HH;sH1HAHD$p%HH;v	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;v^	 HT$PMtL;tI	 H+H(D$0fD$@L$   A   HT$@HL$Pz. Ld$hL;d$pv	 H\$PHu	 E3LII;K wHtH3H;HP	 EL
. L
q
 A0   Dn
 Q  x
 H$   W	 Ht~H	 HHxt.	 `L
 L
Fq
 A/   Dn
 Q  w
 H$   HuHGHP0L
q
 Ddn
 w
 H
~	 >%Hu
HGHP0HT$PH$   HH MtIuIFIP0HL$hHt~ HD$h    HD$p    HD$x    HL$PY HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMI Ǆ$     IAN Ht
HL$PHIHD$PLt$hLt$pLt$x    Ht
H$   HIH$   L$   L$   L$   HCH
X	 H;a  H;@	 T  H	 HHu'H H[o
 l
    u
 =R     H@L   HAHHtjA   HAHHtVHAHAVy$H
 H
n
 Cl
    uu
 DR  aHU  HCHP0E3F  Hu
HCHP03uIH Hn
 k
    u
 LR  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   H	 H
J	 H		 2Mx-H5	 L
H	 ILDH	 H
	 H	M	 HF Hm
 	k
    ;t
 )R    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$PE HL$8Ht Lt$8Lt$@Lt$HHL$  Y	 Ht$H Hm
 hj
    s
 [R  tHHL$ ;HH$   
E HL$8Ht Lt$8Lt$@Lt$HHL$  	 HtGH/ Hl
 i
    $s
 \R  L
l
 Di
 s
 H
9z	 ;  H$   H$   HHT$PHL$  HH$    HH$    H$   I5D IO0H$   $D H$   Ht L$   L$   L$  H$    H$   Ht L$   L$   L$   H$   a HL$8HtQ Lt$8Lt$@Lt$HHL$ 8 H$(  Ht% L$(  L$0  L$8  H$    MtI$uID$IP0HtHE uHEHP0H$   Ht L$   L$   L$   H$    HL$hHt Lt$hLt$pLt$xHL$Pr IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@       3 Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;	    H;|	 t{HH	 HHu+L
 L
i
 A/   Df
 R  p
   H@L   Mu3L
 L
Ti
 A/   Df
 R  o
 M  H3E3LlfMuEH	 H9GuH;oT  HGHHHI,H;o6  I] HHIHAHH  ILHt
HuHQR0Ht$   u	 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v[	 HL$pH\$hHT$PLHT$0Ht$8HH+Hu3'H;v"	 HT$PMtL;t
	 H+H(D$0fD$@L$   A   HT$@HL$P& Ld$hL;d$pv	 H\$PHu	 E3LII;K wHtH3H;HT	 IL
 L
cg
 A0   Dd
 R  m
 H$   Wk	 Ht~HO	 HH<
t	 `L
 L
g
 A/   DYd
 R  m
 H$   HuHGHP0L
f
 D(d
 ^m
 H
t	 	%Hu
HGHP0HT$PH$   H MtIuIFIP0HL$hHtB HD$h    HD$p    HD$x    HL$P HH$   HĀ   A_A^A]A\_^]HHHUVWATAUAVAWHP  HǄ$@  HXHLE3DpMIO Ǆ$     IAN Ht
HL$PHIHD$PLt$hLt$pLt$x    Ht
H$   HIH$   L$   L$   L$   HCH
	 H;a  H; 	 T  Hq	 HHu'H He
 mb
    k
 'S     H@L   HAHHtjA   HAHHtVHAHAVۯy$H
@ H
d
 b
    5k
 .S  aHU  HCHP0E3F  Hu
HCHP03耮uIdH HNd
 a
    j
 6S  HtHu
HFHP0HtHu
HGHP0E3E3H  H  HCHP0  LCIt~I~A   Hـ	 H
	 H	A	 2Mx-H+	 L
=	 ILDHՀ	 H
	 H	
	 H Hwc
 `
    i
 S    H;u
HsH{ HCH0HxHHE3LHHHL$ HHL$Pp HL$8Ht Lt$8Lt$@Lt$HHL$  	 Ht$He Hb
 (`
    Zi
 ES  tHHL$ HH$   : HL$8Htf Lt$8Lt$@Lt$HHL$ M 
	 HtGH H`b
 _
    h
 FS  L
Eb
 D_
 h
 H
p	 t;  H$   H$  芷 HHT$PHL$ X HH$   G HH$   V H$   I% IO0H$   9 H$   Ht} L$   L$   L$  H$   X H$   HtF L$   L$   L$   H$   ! HL$8Ht Lt$8Lt$@Lt$HHL$  H$(  Ht L$(  L$0  L$8  H$   MtI$uID$IP0HtHE uHEHP0H$   Ht L$   L$   L$   H$   [ HL$hHtK Lt$hLt$pLt$xHL$P2 IH$  HP  A_A^A]A\_^]HHHUVWATAUAVAWH   HD$ HXHH@        Ht
HL$PH3HD$PHD$h    HD$p    HD$x    E3AN HtH3HHC    HC     HC(    Ǆ$      HGH;A		    H;<		 t{IH	 HHu+L
 L
O_
 A/   D\
 S  e
   H@L   Mu4L
 L
_
 A/   Dc\
 S  e
 N  HE3E3NlMuEH	 H9GuL;gU  HGJHII,L;g7  I] HIIHAHH  ILHt
HuHQR0H$$   u		 H  H\$hHu3HT$xH+HHL$pHH+HH;s1HAHD$p)HH;v	 HL$pH\$hHT$PHHT$0Ht$8HH+Hu3'H;v	 HT$PHtH;t	 H+H(D$0fD$@L$   A   HT$@HL$PN Hl$hH;l$pv	 H\$PHu|	 E3LHL I;K wHtH3H;HSM	 HL
 L
"]
 A0   DqZ
 T  c
 H$   W*	 Ht~H
	 HHt	 `L
X L
\
 A/   DZ
 T  Ic
 H$   HuHGHP0L
\
 DY
 c
 H
k	 %Hu
HGHP0HT$PH$   H MtIuIFIP0HL$hHt HD$h    HD$p    HD$x    HL$P HH$   HĀ   A_A^A]A\_^]H\$Ht$H|$ ATH`HQ Igfffffff3H+QIHHHHH?H}   Hl$pHfH;r	 HsH%	 A   HE3HM	 HHk	 L L;t	H:	 HK IHH+KH(HHHH?HH;rHl$pH{ H9{v	 HHsH|$(HD$ (D$ fD$ H;s v	 HH@ H{HH;{ v	 HL$ HtH;t	 HL$0 	 H+LIHHHH?HHt L\$`I[Is I{(IA\HT$SH0HD$ HfWD$PHT$PK u-J D$P2H0[HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$    H$    HT$`HK85 HHL$  H\$xHt.H$   H;tfHw 	 H(H;uH\$xH
 Ll$xL$   L$   HL$` 3z	 HHu'H{ HX
 NV
   _
 >    H\$8H;\$@v 	 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v 	 HtH;t$ t 	 L;  Hux 	 MLM;c rd 	 IH$    HuH 	 MLM;c r4 	 I(H$   H$    H$   HL$` HH$(  H@H} rHMHMII;}HH33%	 H'H=(	  tE3	 HE3E3	 HH HtlHOH9O ~HHGHHAHGHH	 uHHCHP0H H%W
 wT
   ]
 >  "H HW
 ST
   ]
 >  Hu
HGHP0HtHu
HCHP0L
V
 DT
 L]
 H
5\	 IHHuHGHP0H$    H$    H\$8Ht.Ht$@H;tD  Hw H(H;uH\$8H
 Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$    H$    HT$`HKX1 HHL$  H\$xHt.H$   H;tfHg H(H;uH\$xH Ll$xL$   L$   HL$` 3j HHu'Hk HT
 >R
   p[
 ?    H\$8H;\$@v HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v HtH;t$ t| L;  Huh MLM;c rT IH$    Hu8 MLM;c r$ I(H$   H$    H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H= 	  tE3
 	 HE3E3 HH HtlHOH9O ~HHGHHAHGHH uHHCHP0H HS
 gP
   Y
 ?  "Hp HR
 CP
   uY
 ?  Hu
HGHP0HtHu
HCHP0L
R
 DP
 <Y
 H
X	 IHHuHGHP0H$    H$    H\$8Ht.Ht$@H;tD  Hg H(H;uH\$8H Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$    H$    E3E3HT$`HK HHL$ t H\$xHt,H$   H;tHS H(H;uH\$xH Ll$xL$   L$   HL$` 3V HHu'HW HP
 *N
   \W
 @    H\$8H;\$@v HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8v~ HtH;t$ tl L;  HuX MLM;c rD IH$    Hu( MLM;c r I(H$   H$    H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H=  tE3 HE3E3 HH HtlHOH9O ~HHGHHAHGHH uHHCHP0H HO
 WL
   U
 @  "H` HN
 3L
   eU
 @  Hu
HGHP0HtHu
HCHP0L
N
 DK
 ,U
 H
V	 IHHuHGHP0H$    H$   z H\$8Ht.Ht$@H;tD  HW H(H;uH\$8H Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$    H$    E3E3HT$`HK HHL$ d H\$xHt,H$   H;tHC H(H;uH\$xH Ll$xL$   L$   HL$` 3F HHu'HG HL
 J
    LS
 A    H\$8H;\$@v HD$ HD$PH\$X(D$PfD$PIHt$PLd$X    H\$@H9\$8vn HtH;t$ t\ L;  HuH MLM;c r4 IH$    Hu MLM;c r I(H$   H$    H$   HL$` HH$(  H@H} rHMHMII;}HH33 H'H=  tE3 HE3E3 HHx HtlHOH9O ~HHGHHAHGHH uHHCHP0Ht HJ
 GH
    yQ
 A  "HP HJ
 #H
    UQ
 A  Hu
HGHP0HtHu
HCHP0L
J
 DG
 Q
 H
uR	 IHHuHGHP0H$   y H$   j H\$8Ht.Ht$@H;tD  HG H(H;uH\$8H Ll$8Ll$@Ll$HHL$  HL$   I[0Ik@IA^A]A\_^HHHUVWATAUAVAWH   HD$PHXHLE3DxAO Ht
HL$ HIHD$ L|$8L|$@L|$HM   Q HtL0IIM~M~ M~(Ǆ$      HL$X_ HCH;    H; t{HH? HHu+L
x L
H
 A/   D8F
 S  iO
   H@L   Mu4L
= L
H
 A/   DE
 S  .O
 g  HIMHlMuEH7 H9CuH;so  HCH<HHH,H;sQ  H} HHHHAHH   ILHt
HuHQR0HH$   HHL$X H$   	  Hu5HT$XH$    HHL$ -_ H$    L
" L
G
 A0   DD
 S  N
 O HtvH HHtt* XL
ѫ L
BG
 A/   DD
 S  M
 HuHCHP0L
G
 DhD
 M
 H
V	 BHu
HCHP0HT$ I MtI$uID$IP0HL$X H\$8Ht)H|$@H;tH H(H;uH\$8HX L|$8L|$@L|$HHL$ ? IH$   Hİ   A_A^A]A\_^]HT$WH0HD$ H\$PHHD$@    IH HHT3 HK H HH\$PH0_HT$WH0HD$ H\$PHHD$@    IHϫ HH2 HK H HH\$PH0_LD$WH0HD$ H\$HIHD$@    I責 HHw2 HO4 H+ HH\$HH0_HL@WHpHD$ HXHp )pIf(HǄ$       HHPIIL H^3$   H\$(H$   HD$0HSHCHD$@HT$Ht$PHT$8HL$( HH1 Hf H] HL\$pI[Is((t$`I_HT$WH0HD$ H\$PHHD$@    IH诲 HH: HK H HH\$PH0_HT$WH0HD$ H\$PHHD$@    IHO HHT: HK Hx HH\$PH0_LD$WH0HD$ H\$HIHD$@    I2 HH9 HO H HH\$HH0_LD$WH0HD$ H\$HHt$XIHD$@    L$@HT$@I2J HT$@HN$J HHY9 HN H} HH\$HHt$XH0_++++HL@HHUWATAVH  )p)xD)@D)xD)hD)XD)HD)8D)BtB|IMLLFfEWA\Y5	 D% 	 fA.D-b	 z#u!D=U	 fA(fAT\DX  D=4	 f(f(fATfATf/fD($  EY$  v
H$  H$  DfE.z	ufA(@f/v
H$  H$   A^YAX L$  f(AYfE.z?u=fA/v   f(fn^X^fA(Y\DX$fA/wfAWXfA(D^A\DXI;EHE\E}  H$  H$  H$  H$  HI\L$  H,   L$x  HD)$   D5
 L,IIVHHI+L$  H$  L<    fE.z'u%fE/vfA(fA(  fA(fA(   fE.z"u fE/fA(v
fA(   fA(   fA(fA(fATfATf/v_fE(E^fA(AYAXP fE/vfAWH$  L$  H$  fA(^IVf(AYfAWVfA(A^f(YAX fE/vfAWH$  L$  H$  fA(^IVYfAWI;KAf(f(YYf(Y\YYYfD(X\XYYDYf(f(\YYAXf(YD\DS~f(f(YKAY\KH;}fD(YDYfEWH   HL$0Ht$8Ht$@fAWt$ HL$0H$   L$   |$(HH$   Hl$PHHAHt$XHBHAHL$0HBHHT$hHHALD$ HBHAH$   HBHT$PH$   H$   蠾 H$  L$  H$  IVHHMII;/D($   L$x  L$  H$  H$  L$  A(sA({E(CE(KE(SE(xE(hE(XE(8IA^A\_]HWH   HǄ$   HXHhHpHٹ     3Ht
HL$PHHHD$PHl$hHl$pHl$x    Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HK7 HHL$Pɮ H$   HtLH$   H;t:HYHHt9 H+HkHkHK% H0HCH;uH$    H$   H$   H$   H$    HT$PHL$ ; HL$ !uHHu<L
b L
:
 58
   gA
 @  @  A  H
A	  HHL$8HtKH|$@H;t<HYD  HHt_ H+HkHkHKK H0HCH;uHL$84 Hl$8Hl$@Hl$HHL$  HL$hHtLH|$pH;t=HYfD  HHt H+HkHkHK H0HCH;uHL$h Hl$hHl$pHl$xHL$P HL$   I[IkIs I_HWH   HǄ$   HXHhHpHٹ   p 3Ht
HL$PHHHD$PHl$hHl$pHl$x   > Ht
HL$ HHHD$ Hl$8Hl$@Hl$HH$   HKW5 HHL$P9 H$   HtLH$   H;t:HYHHt H+HkHkHK H0HCH;uH$   { H$   H$   H$   H$   V HT$PHL$ 諫 HL$ rHHu<L
Ҝ L
S8
 5
   >
 b@  b@  A  H
U?	 pHHL$8HtKH|$@H;t<HYD  HHt H+HkHkHK H0HCH;uHL$8 Hl$8Hl$@Hl$HHL$  HL$hHtLH|$pH;t=HYfD  HHt_ H+HkHkHKK H0HCH;uHL$h4 Hl$hHl$pHl$xHL$P HL$   I[IkIs I_[HHPHHSUVWATAUAVAWH  HǄ$   )pHHE3DpAN Ht
HL$PHIHD$PHL$P苞 H$   ƀ   H$   H@H$   H H$   H@L$   MLt$@HQh Ǆ$0     IIM   # Ht
H$   HIH$   L$   L$   L$       Ht
H$   HIH$   L$   L$   L$   H$h   HCH;]    H;X txIH HHu'H Hk5
 2
 T  ;
 !    H@H   HD$ Hu8H H/5
 2
 T  ;
 #  e  HHMIHD$ NtHuDH H9EuL;e|  HEJ<HII*L;e^  I>HIIHHH  ILHt
HuHAP03H 98uIG     IH? HH,  H@L   MtH<:
 HAH2L@@MtH!:
 H HAHH:
 Hz HH  Hu
HGHP0HFL   MtH4
 HAH2L@@MtH3
 H HAHH3
 H
 HH  Hu
HFHP0IHM HH  H@L   MtH3
 HAL2L@@MtH2
 H HALH2
 H LMD  Hu
HFHP0    HH  HxLh 3E3HL$@HD$@HtHu
HAP0H3HH$  GHHH$   
 HS0H$   
 H$P  Ht< 3H$P  H$X  H$`  H$8   H$   Ht H$   H$(  H$0  H$   4 H   IH$  iHH$h   H$    H   H$h  HL$P!d HH$   H	 HK0H$   	 H$(  HD$ sH\6
 H
} H	 L͕ LN1
 .
 U  7
 S    H H'1
 y.
 W  7
   ]  H H 1
 R.
 W  7
 ~  6  HX H0
 +.
 V  ]7
 l    H1 H0
 .
 V  67
 i     H
 H0
 -
 V  7
 g     H Hd0
 -
 V  6
 d     H H=0
 -
 V  6
 a  vH H0
 k-
 V  6
 _  R- H  H
 HHt k  HD H/
 -
 T  I6
 >  HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIE u
IEIP0H) H(LuHLePLmX3HEHHEPHEXMtIMtI$MtIE MMIHY   6 H
	 1 HHMHHuPH}XLuHLePLmXHt
HuHQR0HtHu
HFHP0HtHu
HGHP0HuH
  H Hu
HCHP0L$      HE u
HEHP0HD$PL$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I- HT$PI耤 MtIu
IGIP0HL$@HtHuHAP0H$h   H$   Htn E3L$   L$   L$   H$   F H$   Ht4 L$   L$   L$   H$    H$   HHD$PHHH\$8HD$0(D$0fD$ Hu H$   HD$PH;u^HHtH;t H$   H;u>HRHL$P L$   M[L$   H$   H H$   H@   H|$ H\$(fHtH;t H;   (t$ Huw     th gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$PB =H$   茺 L$   L$   HL$Pr I($  H  A_A^A]A\_^][HHPHHSUVWATAUAVAWH  HǄ$   )pHHE3DpAN, Ht
HL$PHIHD$PHL$P H$   ƀ   H$   H@H$   H H$   H@L$   MLt$@H\ Ǆ$0     IIM   裹 Ht
H$   HIH$   L$   L$   L$      d Ht
H$   HIH$   L$   L$   L$   H$h  a HCH;    H; txIHA HHu'Hj H)
 ='
 f  o0
     H@H   HD$ Hu8H. H)
 '
 f  30
   e  HHMIHD$ NtHuDH4 H9EuL;e|  HEJ<HII*L;e^  I>HIIHHH  ILHt
HuHAP03H
 98uIG     IH HH,  H@L   MtH.
 HAH2L@@MtH.
 H HAHH.
 H HH  Hu
HGHP0HFL   MtH(
 HAH2L@@MtHt(
 H HAHH^(
 H HH  Hu
HFHP0IH HH  H@L   MtH'
 HAL2L@@MtH'
 H HALHi'
 H LMD  Hu
HFHP0   ! HH  HxLh 3E3HL$@HD$@HtHu
HAP0H3HH$  HHH$   d HS0H$   # H$P  Ht輵 3H$P  H$X  H$`  H$8  蕵 H$   Ht胵 H$   H$(  H$0  H$  ^  H   IH$  ^HH$h   H$  r t H   H$h  HL$Pa[ HH$   Hn HK0H$   - H$(  HD$ sH*
 H
 H	l LM L%
  #
 g  R,
      H& H%
 "
 i  +,
 /   ]  H H%
 "
 i  ,
 .   6  H؉ HY%
 "
 h  +
      H H2%
 "
 h  +
       H H%
 ]"
 h  +
       Hc H$
 6"
 h  h+
       H< H$
 "
 h  A+
    vH H$
 !
 h  +
    R H  H HHzt0 k  HĈ HE$
 !
 f  *
   HE u
HEHP0HtHu
HGHP0HtHu
HFHP0MtIE u
IEIP0H H(LuHLePLmX3HEHHEPHEXMtIMtI$MtIE MMIH٭    H
w	  HHMHHuPH}XLuHLePLmXHt
HuHQR0HtHu
HFHP0HtHu
HGHP0HuH
> P HE Hu
HCHP0L$      HE u
HEHP0HD$PL$   L;t]ID$0HD$(I$HL$ H HD$8HL$0(D$ fD$ (L$0fL$0LL$ LD$0H$   I譗 HT$PI@ MtIu
IGIP0HL$@HtHuHAP0H$h  U H$   Ht E3L$   L$   L$   H$   ư H$   Ht贰 L$   L$   L$   H$   菰 H$   HHD$PHHH\$8HD$0(D$0fD$ Hu H$   HD$PH;u^HHtH;tw H$   H;u>HRHL$P L$   M[L$   H$   H H$   H@   H|$ H\$(fHtH;t H;   (t$ Hu     t gHC    u/HH     uff     HH     tH\$(+HC    uH;XuHH@    tHHD$(ft$0LD$0H$   HL$P =H$    L$   L$   HL$P I($  H  A_A^A]A\_^][@SH HYHtHP H譮 H [HX PH   )p)xD)@D)HD)PD)XD
	 fEWfA(fA(fE(D)`D)l$PD)t$@D5i	 fD(fA(D)|$0fATf/fD(fA(AYL$(   D$   fff     AXfD/   DXf(f(θ   AXAXA\DYfA(D  tYtY3fA(LD$ H$   $   ^f(AX f(fD(fATf/
{	    $   f(跬 Y|$(AYYA^f(fATf/$   'D(l$PD(t$@D(|$0L$   fA(A(sA({E(CE(KE(SE([E(cIH
 H
J
  HUVWATAUAVAWH  HǄ$h  HX)p)xHL   蓬 Ht
H$   H3H$   H$   j H$   ƀ   H$   H@H$   H H$   H@HǄ$          " Ht
H$   H3H$   H$    H$0  ƀ   H$0  H@H$0  H H$0  H@HǄ$8      3H$   HT$`H$@   3E3L$  E33H;- uEL H|	 H
 H	 L݀ L^
 
 	  "
   e  LF
 H"
 H藥HHu'H
 H

 k
 	  "
   d  HlDu2 Ht'HV H
 )
 	  ["
   d  Hu
HCHP0E'H;- u>H	 H
 H	 L L}
 
 
  "
   d  H
 H4 HHu'H H>
 
 
  !
   #d  HkDu2? Ht'H{ H
 N
 
  !
   c  Hu
HCHP0EgH;- u>H	 H
 H	 L  L
 
   %!
   c  Hq
 HX HHu'H~ Hb
 
    
 !  Gc  HHL$hQHH$@   HL$hF H Ht'H~ H
 W
    
 #  b  Hu
HCHP0IOH$@   H;- u>H:	 H
 H	 L~ L
 
     
 0  b  Hl
 HS HHu'H} H]
 
   
 2  Bb  H
 H;uA      3Hl H9BE3H9CADteLCL;BtE3   B 8C tE3   IuE   CJ;tt
tE3   H HK 轧 E3Ai3L
 I;tE3Z3I;AtE3HA   H' LH7a  HDIE u
IUIR0L$  E
a  Hu
HCHP0E  H

 9HHu'H
z| H

 M
 
  
 ?  `  H@L   MtH
 HAL2L@@MtH
 H HALH
 H	 LMu'H{ H{
 
 
  
 A  u`  Hu
HGHP0IEL   MtH
 IAH2L@@MtH
 H IAHH
 Iy HHu'Hj{ H
 =
 
  o
 D  _  IE u
IEIP0E3H;- u>HV H
 H	 L{ L
 
 
  
 I  _  H
 HG LHu'Hz HQ
 
 
  
 K  K_  E3L$  LgH I9$y  LwL$  Md  H_IHHHHuHAP0LcH[ I9$   Lt$PLl$XE3EAHT$PHKHHu'Hz H
 
 
  !
 _  ^  Iu
IFIP0E3L$  IE u
IEIP0E3L$         HHu'H
y H
'
 y
 
  
 o  !^  LpE3L$  Lh E3L$  E3HH躘HHu'HKy H
 
 
  P
 u  ]  Hu
HFHP03VIH|HHu'Hx H~
 
 
  
 X  c]  IE u
IEIP0E3L$  Hu
I$HP03HCH H;.  H;ܽ !  HM LHu'Hvx H
 I
 
  {
   \  Hu
HCHP0IEH   E3IHHtrA   IHHt_IHAT$^y'Hw H|
 
 
   
   v\  IE u
IEIP0HǄ$         IE u
IEIP0E3@]uI$Hw H
 `
 
  
   \  HKHtVH~A   H/	 H
 H	P 
HxĜH-w H
  
 
  2
   [  H;u
H{Hs HCH8HpHHHu
HCHP0HH$   3Ht$`3HL$hOHH$   H;tmH$   HL$HH$   HT$@H	HL$8HT$0(D$@fD$@(L$0fL$0LL$@LD$0H$   H$    HH$   c H$   LHD$hLHH\$8HD$0(D$0fD$@Hu H$   HD$hH;ubHMtL;t H$   L;uBHRHL$h謿 L$   M[HǄ$       H$   H H$   H@   Ld$@H\$HMtM;t I;   (t$@Mu     t eHC    u-HH     u     HH     tH\$H+HC    uH;XuHH@    tHHD$Hft$0LD$0H$   HL$hҸ ?H$    HǄ$       HǄ$       HL$h HT$`HL$hHH$   ~ H$   HD$8HL$hHL$0H HD$HHL$@(D$0fD$0(L$@fL$@LL$0LD$@H$   HL$h H$   v HǄ$       HǄ$       HL$hT IO0H$    IOpH$    L$  H;-w u>H H
 H	 Ls L(
 z
   
   MX  H8
 H߸ HHu/Hhs H
 ;
   m
   L$  W  Hq H9Cus
Hۺ f(=	 f.z<u: Ht/Hr H~
 
   
   L$  [W  Hu
HCHP0A   H;-e u>H, H
m H	| Lr L
 h
   
   ;W  H
 Hͷ HHu/HVr H

 )
   [
   L$  V  HHL$hQEHH$@  W HL$h  Ht/Hq Hr

 

   
   L$  OV  Hu
HCHP0I   H$@   H;-M u>H< H
U H	d L}q L
 P

   
 
  #V  H^
 H HHu/H>q H
 

   C
   L$  U  HAAu: Ht/Hp Hq
 	
   
   L$  NU  Hu
HCHP0E   H;-Z u>Hq H
b H	q Lp L
 ]	
   
   0U  H3	
 Hµ HHu/HKp H
 	
   P
   L$  T  HAAu: Ht/Ho H~
 
   
   L$  [T  Hu
HCHP0E   H;-g u>H H
o H	~ Lo L
 j
   
 ,  =T  H
 Hϴ HHu/HXo H

 +
   ]
 .  L$  S  Hi

 H!eHHu/Ho H

 
   
 0  L$  pS  Hu
HCHP0H[ Ht'Hn H?

 
   
 3  dS  Hu
HFHP03A   H;-. u>H H
6 H	E L^n L	
 1
   c
 @  S  H

 H HHu'Hn H	
 
   $
 B  R  HHL$h"AHH$@  ( HL$h  Ht'Hm HC	
 
   
 D  hR  Hu
HFHP03I   H$@  ï H;-$ u>H H
, H	; LTm L
 '
   Y
 Q  Q  H
 H HHu'Hm H
 
   
 S  Q  HÀu2 Ht'Hl HR
 
   
 U  wQ  Hu
HFHP03A  H;-A u>H H
I H	X Lql L
 D
   v
 b  Q  H	
 H HHu'H2l H
 
   7
 d  P  H

 趐HHu/Hk Hx
 
   

 f  L$  UP  H
 HaHHu/Hk H2
 
   

 h  L$  P  Hu
HCHP0A   HH HHu/HXk H
 +
   ]

 k  L$  O  Hu
HFHP03Hu
HGHP03HDy/Hj Hw
 
   
 n  L$  TO  Hu
HCHP0Ee(  H;-^ u>H= H
f H	u Lj L
 a
   
 {  4O  H
 HƯ HHu/HOj H
 "
   T
 }  L$  N  Hx
 H HHu/Hj H
 
   

   L$  fN  Hu
HCHP0H
 H( HHu/Hi H2
 
   
   L$  N  Hu
HGHP03HTDu: Ht/HUi H
 (
   Z
   L$  M  Hu
HCHP0E   H;- u>H H
ǯ H	ֱ Lh Lp
 
   

   M  H 
 H' HHu/Hh H1
 
   

   L$  M  H
 H HHu/Hih H
 <
   n

   L$  L  Hu
HCHP0H:	
 H HHu/Hh H
  
   

   L$  pL  Hu
HGHP03H SDu:z Ht/Hg H7
  
   	
   L$  L  Hu
HCHP0E$  H;-  u>HO H
( H	7 LPg L
 # 
   U	
   K  H
 H HHu/Hg H
    	
   L$  oK  H:
 HA HHu/Hf HK
    
   L$  (K  Hu
HCHP0H
 H HHu/Hsf H
 F   x
   L$  J  Hu
HGHP0Ht
 H,\HHu/Hf H
    "
   L$  {J  Hu
HCHP0HS Ht/He HJ
    
   L$  <J  Hu
HGHP0A(  H;-3 u>H H
; H	J Lce L 
 6   h
   	J  H
 H HHu/H$e H 
    )
   L$  I  HM HT HHu/Hd H^ 
    
   L$  ;I  Hu
HGHP0H H HHu/Hd H 
 Y   
   L$  H  Hu
HCHP0HO؃u: Ht/H-d H     2
   L$  H  Hu
HGHP0A,  H;- u>H H
 H	 Lc LH    
   mH  H H HHu/Hc H	 [   
   L$  G  H H HHu/HAc H    F
   L$  G  Hu
HGHP0HZ
 Ha HHu/Hb Hk    
   L$  HG  Hu
HCHP0HM؃u:U Ht/Hb H d   
   L$  G  Hu
HGHP0A0  H;- u>H H
 H	 L+b L    0
   F  H\ Hc HHu/Ha Hm    
   L$  _F  H H HHu/Ha H& x   
   L$  F  Hu
HGHP0H. HŦ HHu/HNa H !   S
   L$  E  Hu
HCHP0HÀu: Ht/H` Hs    
   L$  eE  Hu
HGHP0A4  H;-\ u>H+ H
d H	s L` L
 _    
   2E  H Hĥ HHu/HM` H      R
 
  L$  D  Hv H} HHu/H` H     
   L$  dD  Hu
HGHP0H H& HHu/H_ H0     
   L$  
D  Hu
HCHP0HJ؃u: Ht/HV_ H )    [
   L$  C  Hu
HGHP0A8  H;- u>H H
ȥ H	ק L^ Lq  !   
   C  H! H( HHu/H^ H2  !   
 !  L$  $C  H H HHu/Hj^ H = !  o 
 #  L$  B  Hu
HGHP0H; H HHu/H^ H  !   
 &  L$  qB  Hu
HCHP0H#I؃u:~ Ht/H] H;  !   )  L$  -B  Hu
HGHP0A<  H;-$ u>HC H
, H	; LT] L ' "  Y 6  A  H H HHu/H] H  "   8  L$  A  H> HE HHu/H\ HO  "   :  L$  ,A  Hu
HGHP0H? H HHu/Hw\ H J "  | =  L$  @  Hu
HCHP0HÀu:ߢ Ht/H\ H  "    @  L$  @  Hu
HGHP0A@  H;- u>H H
 H	 L[ L6  #   M  [@  H H HHu/Hv[ H I #  { O  L$  ?  H H HHu/H/[ H  #  4 Q  L$  ?  Hu
HGHP0H HO HHu/HZ HY  #   T  L$  6?  Hu
HCHP0Hџ H9Guw
H; f(f.z<u:) Ht/HeZ H 8 #  j W  L$  >  Hu
HGHP0AH  H;-͠ u>H< H
ՠ H	 LY L~  $   d  >  H. H5 HHu/HY H?  $   f  L$  1>  H H HHu/HwY H J $  | h  L$  =  Hu
HGHP0H H HHu/H Y H  $  % k  L$  ~=  Hu
HCHP0H H9Guw
H f(f.z<u:q Ht/HX H.  $   n  L$   =  Hu
HGHP0AP  H;- u>H H
 H	, LEX L  %  J {  <  Hv H} HHu/HX H  %   }  L$  y<  H/ H6 HHu/HW H@  %     L$  <  Hu
HGHP0H Hߜ HHu/HhW H ; %  m   L$  ;  Hu
HCHP0Ha H9Guw
H˞ f(f.z<u: Ht/HV Hv  %     L$  h;  Hu
HGHP0AX  H;-] u>H H
e H	t LV L ` &     3;  H Hś HHu/HNV H ! &  S   L$  :  Hw H~ HHu/HV H  &     L$  e:  Hu
HGHP0H H' HHu/HU H1  &     L$  :  Hu
HCHP0HA؃u: Ht/HWU H * &  \   L$  9  Hu
HGHP0A`  H;- u>H H
ɛ H	؝ LT Lr  '     9  H" H) HHu/HT H3  '     L$  %9  H H HHu/HkT H > '  p   L$  8  Hu
HGHP0H H HHu/HT H  '     L$  r8  Hu
HCHP0H@؃u: Ht/HS H<  '     L$  .8  Hu
HGHP0Ad  H;-% u>H4 H
- H	< LUS L ( (  Z   7  H H HHu/HS H  (     L$  7  H? HF HHu/HR HP  (     L$  -7  Hu
HGHP0H H HHu/HxR H K (  }   L$  6  Hu
HCHP0Hx>؃u: Ht/HR H  (  $   L$  6  Hu
HGHP0Ah  H;- u>H H
 H	 LQ L:  )     _6  H H HHu/HzQ H M )     L$  5  H H HHu/H3Q H  )  8   L$  5  Hu
HGHP0H HS HHu/HP H]  )     L$  :5  Hu
HCHP0HՕ H9Guw
H? f(f.z<u:- Ht/HiP H < )  n   L$  4  Hu
HGHP0Ap  H;-і u>H0 H
ٖ H	 LP L  *     4  H2 H9 HHu/HO HC  *     L$  54  H H HHu/H{O H N *     L$  3  Hu
HGHP0H H HHu/H$O H  *  )   L$  3  Hu
HCHP0H% HDHHu/HN HO  *     L$  ,3  Hu
HGHP03H|=D; Ht/HwN H J *  |   L$  2  Hu
HCHP0Ex  H;- u>Hh H
 H	 LN L  +     2  HB HI HHu/HM HS  +   
  L$  02  H H HHu/HM H ^ +     L$  1  Hu
HCHP0H| H HHu/H4M H  +  9   L$  1  Hu
HGHP03H+ H9Cus
H f(f.z<u: Ht/HL H@  +     L$  1  Hu
HCHP0A  H;-' u>H H
/ H	> LWL L * ,  \   0  H H HHu/HL H  ,   !  L$  v0  HA HH HHu/HK HR  ,   #  L$  /0  Hu
HCHP0H H HHu/HzK H M ,   &  L$  /  Hu
HGHP03Hq H9Cus
Hے f(f.z<u:ɑ Ht/HK H  ,  
 )  L$  c/  Hu
HCHP0A  H;-m u>HD H
u H	 LJ L p -   6  C/  H HՏ HHu/H^J H 1 -  c 8  L$  .  H H HHu/HJ H  -   :  L$  u.  Hu
HCHP0H8 H7 HHu/HI HA  -   =  L$  .  Hu
HGHP0H
 ,nHHu/HmI H @ -  r @  L$  -  H H6?HHu/H'I H  -  , B  L$  -  Hu
HGHP0A   HH HHu/HH HO  -   E  L$  ,-  Hu
HCHP0Hu
HFHP03H\؅y/HoH H B -  t H  L$  ,  Hu
HGHP0  H;-؎ u>H H
 H	 LH L  .  
 U  ,  H9 H@ HHu/HG HJ  .   W  L$  <,  H H HHu/HG H U .   Y  L$  +  Hu
HGHP0H H HHu/H+G H  .  0 \  L$  +  Hu
HFHP03H92؃u: Ht/HF HQ  .   _  L$  C+  Hu
HGHP0A  +  H;-5 u>H\ H
= H	L LeF L 8 /  j v  +  H H HHu/H&F H  /  + x  L$  *  HO HV HHu/HE H`  /   z  L$  R*  Hu
HGHP0H  H HHu/HE H	 [ /   }  L$  )  Hu
HFHP0H
 iHHu/H5E H  /  :   L$  )  Hn H:HHu/HD Hp  /     L$  M)  Hu
HFHP0A   HH HHu/HD H i /     L$  (  Hu
HGHP03Hu
HCHP0H$؅y'H7D H 
 /  <   (  Hu
HFHP03)  H;- u>H H
 H	 LC LW  0     |(  H H HHu'HC H j 0     =(  H Hψ HHu/HXC H + 0  ]   L$  '  Hu
HFHP0H Hx HHu/HC H  0     L$  _'  Hu
HCHP0H H9Fuv
Hd f(f.z4u2R Ht'HB H a 0     4'  Hu
HFHP0A  p'  H;- u>Hp H
 H	 L)B L  1  .   &  HB Ha HHu'HA Hk  1     &  H
s nfHHu/HA H0  1     L$  
&  H  Hx7HHu/HiA H < 1  n   L$  %  Hu
HCHP0A   HH_ HHu/HA H  1     L$  n%  Hu
HFHP03Hu
HGHP03H蜝Dy/H@ H/  1     L$  %  Hu
HCHP0E  H;- u>H H
 H	- LF@ L  2  K   $  Hw H~ HHu/H@ H  2     L$  e$  H H7 HHu/H? HA  2     L$  $  Hu
HCHP0H H HHu/Hi? H < 2  n   L$  #  Hu
HGHP03Hw*Du:х Ht/H
? H  2     L$  k#  Hu
HCHP0E   H;-w u>H> H
 H	 L> L( z 3     M#  H H߃ HHu/Hh> H ; 3  m   L$  "  H) H HHu/H!> H  3  &   L$  "  Hu
HCHP0H HA HHu/H= HK  3     L$  ("  Hu
HGHP03H(Du:2 Ht/Hn= H A 3  s   L$  !  Hu
HCHP0E$  H;-؃ u>H H
 H	 L= L  4  
   !  H9 H@ HHu/H< HJ  4   	  L$  '!  H H HHu/H< H U 4     L$     Hu
HCHP0H H HHu/H+< H  4  0   L$     Hu
HGHP0H, H1HHu/H; HV  4     L$  3   Hu
HCHP0Hu+E Ht/H; H T 4     L$    Hu
HGHP0A(  H;- u>H H
 H	 L; L  5    !    HL HS HHu/H: H]  5   #  L$  O  H H HHu/H: H h 5   %  L$    Hu
HGHP0H H HHu/H>: H  5  C (  L$    Hu
HCHP0HޖÀu: Ht/H9 Hc  5   +  L$  U  Hu
HGHP0A,  H;-L u>H H
T H	c L|9 L O 6   8  "  H H~ HHu/H=9 H  6  B :  L$    H Hm~ HHu/H8 Hw  6   <  L$  T  Hu
HGHP0H H~ HHu/H8 H  r 6   ?  L$    Hu
HCHP0H} H9Guw
H f(f.z<u:~ Ht/H,8 H  6  1 B  L$    Hu
HGHP0A0  H;-~ u>H H
~ H	 L7 LE  7   O  j  H H| HHu/H7 H X 7   Q  L$    HF H| HHu/H>7 H  7  C S  L$    Hu
HGHP0Hg H^| HHu/H6 Hh  7   V  L$  E  Hu
HCHP0H{ H9Guw
HJ~ f(f.z<u:8} Ht/Ht6 H G 7  y Y  L$    Hu
HGHP0A8  H;-| u>Hk H
| H	~ L6 L  8   f    H= HD{ HHu/H5 HN  8   h  L$  @  H Hz HHu/H5 H Y 8   j  L$    Hu
HGHP0H Hz HHu/H/5 H  8  4 m  L$    Hu
HCHP0H(z H9Guw
H| f(f.z<u:{ Ht/H4 H=  8   p  L$  /  Hu
HGHP0A@  H;-${ u>H۽ H
,{ H	;} LT4 L ' 9  Y }    H Hy HHu/H4 H  9     L$    H HEy HHu/H3 HO  9     L$  ,  Hu
HGHP0H Hx HHu/Hw3 H J 9  |   L$    Hu
HCHP0Hpx H9Guw
Hz f(f.z<u:y Ht/H3 H  9  	   L$  w  Hu
HGHP0AH  H;-ly u>HK H
ty H	{ L2 L o :     B  H Hw HHu/H]2 H 0 :  b   L$    H Hw HHu/H2 H  :     L$  t  Hu
HGHP0H H6w HHu/H1 H@  :     L$    Hu
HCHP0Hv H9Guw
H"y f(f.z<u:x Ht/HL1 H  :  Q   L$    Hu
HGHP0AP  H;-w u>H H
w H	y L0 Le  ;       H Hv HHu/H0 H& x ;     L$    Hf Hu HHu/H^0 H 1 ;  c   L$    Hu
HGHP0H H~u HHu/H0 H  ;     L$  e  Hu
HCHP0H u H9Guw
Hjw f(f.z<u:Xv Ht/H/ H g ;     L$    Hu
HGHP0AX  H;-u u>H+ H
v H	x L,/ L  <  1     H] Hdt HHu/H. Hn  <     L$  `  H Ht HHu/H. H' y <     L$    Hu
HGHP0H Hs HHu/HO. H " <  T   L$    Hu
HCHP0H_؃u:t Ht/H- Hw  <     L$  i  Hu
HGHP0A`    H;-[t u>H H
ct H	rv L- L ^ =     1  H Hr HHu/HL- H  =  Q   L$    H
 QHHu/H	- H  =     L$  g  H H"HHu/H, HD  =     L$  !  Hu
HCHP0A   HHq HHu/Hj, H = =  o   L$    Hu
HGHP03Hu
HFHP03HDy/H, H  =  
   L$  f  Hu
HCHP0E  H;-pr u>H H
xr H	t L+ L! s >     F  H Hp HHu/Ha+ H 4 >  f   L$    H" Hp HHu/H+ H  >      L$  x  Hu
HCHP0H; H:p HHu/H* HD  >     L$  !  Hu
HFHP0H H| HHu/Hm* H @ >  r   L$    Hu
HCHP0Hp Ht'H* H  >   	    Hu
HFHP03A$  H;-p u>H0 H
p H	r L) L:  ?     _  H Hn HHu'Hz) H M ?        HC Hn HHu/H;) H  ?  @   L$  
  Hu
HFHP0H, H[n HHu/H( He  ?     L$  B
  Hu
HCHP0H؃u2Oo Ht'H( H ^ ?      1
  Hu
HFHP03A   H;-n u>Hʲ H
o H	q L+( L  @  0 -    H\ Hcm HHu'H' Hm  @   /    H H$m HHu/H' H.  @   1  L$    Hu
HFHP0H6 Hl HHu/HV' H ) @  [ 4  L$    Hu
HCHP0Hf؃u2m Ht'H& H~ п @   7    Hu
HFHP03A(  H;-mm u>Hd H
um H	o L& L p A   D  C  H Hk HHu'H^& H 1 A  c F    H' Hk HHu/H& H  A  $ H  L$  }
  Hu
HFHP0H H?k HHu/H% HI  A   K  L$  &
  Hu
HCHP0H؃u23l Ht'Ho% H B A  t N  
  Hu
HFHP03A,  H;-k u>H H
k H	m L% L  B   [  	  H@ HGj HHu'H$ HQ  B   ]  v	  H Hj HHu/H$ H d B   _  L$    Hu
HFHP0H" Hi HHu/H:$ H 
 B  ? b  L$    Hu
HCHP0HJ؃u2j Ht'H# Hb  B   e    Hu
HFHP03A0  H;-Qj u>H H
Yj H	hl L# L T C   r  '  H Hh HHu'HB# Hþ  C  G t    H Hzh HHu/H# H ֻ C   v  L$  a  Hu
HFHP0H\ H#h HHu/H" H-  C   y  L$  
  Hu
HCHP0H
؃u2i Ht'HS" HԽ & C  X |    Hu
HFHP03A4  H;-h u>H2 H
h H	j L! Lt ƺ D       H$ H+g HHu'H! H5  D     Z  H} Hf HHu/Hu! H H D  z   L$    Hu
HFHP0Hο Hf HHu/H! H  D  #   L$  |  Hu
HCHP0Hf H9Fuv
Hh f(f.z4u2og Ht'H  H, ~ D     Q  Hu
HFHP03A8  H;-g u>H H
!g H	0i LI  Lʻ  E  N     Hz He HHu'H
  H ݸ E       HӸ HBe HHu/H HL  E     L$  )  Hu
HFHP0H< Hd HHu/Ht H G E  y   L$    Hu
HCHP0H|Àu2e Ht'H H  E       Hu
HFHP03A@  H;-e u>HG H
e H	g L L9  F     ^  H Hc HHu'Hy H L F  ~     HB Hc HHu/H: H 
 F  ?   L$    Hu
HFHP0H HZc HHu/H Hd  F     L$  A  Hu
HCHP0Hb H9Fuv
HFe f(f.z4u24d Ht'Hp H C F  u     Hu
HFHP03AH  H;-c u>HŨ H
c H	e L L  G       H? HFb HHu'H HP  G  Ծ   u  H Hb HHu/H H c G     L$     Hu
HFHP0H1 Ha HHu/H9 H  G  >   L$     Hu
HCHP0HI؃u2b Ht'H Ha  G        Hu
HFHP0AD     H H p    4  L$  HtHu
HCHP0HtHu
HGHP0MtIE u
IEIP0MtIu
IFIP0HtHu
HFHP0D$(    D$    L
 Dֳ  H
 `AH$   Ht
HuHAP0HL$`HtHuHAP0H$@  P] H$0  HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   + H$0  D HǄ$0      HǄ$8      H$   mD H$   HD$8H$   HL$0H HD$XHL$P(D$0fD$0(L$PfL$PLL$0LD$PH$   H$   t* H$   D HǄ$       HǄ$       H$   C L$  I[@A(sA({IA_A^A]A\_^]@SH HYHtH HC H [LL$ LD$HL$SVWATAUAVAWH   HǄ$   L   fC HtHL$0H33HHD$0Ht$HHt$PHt$XLHt$(   *C Ht
HL$`HHHD$`Ht$xH$   H$   H HH
ͷ W^ HHtH H3HHu'HC Hĳ    H 2    HGL   MtH HAH2L@@MtHɵ H HAHH H^ HHu'H HD    ȹ 2  >  Hu
HGHP0HHt$ LsH\ I9Y  H{H|$ HG  LcHI$HIHuHAP0Mt$HC] I9usH$   L$   E3EAH$   I/4LHu'H
  H
 ӯ    2    Hu
HGHP0HHt$       \ LHu'H
 H
* |    2  $  HxHHt$ ILx E3HI5LHu'HY Hڱ ,   ^ 2     IE u
IEIP0LHt$(:IH7LHu'H H ׮   	 2     Hu	IHP0ID$L   MtH IAH2L@@MtHj H IAHHT I\ HHuFHt H G   y 3  M  I$  ID$IP0  I$uID$IP0HH$   C7HHL$`赈 H$   HtN? H$   H$   H$   H$   )? [ Ht'H H<     3  6  Hu
HCHP0HH$   HT$`HL$0! H$0  DqAAu2
[ Ht'HF Hǯ    K 3     H$8  pAAu/Z Ht$H H| ά     3  yHT$0H$    EEHH$   HIPT i[ HH   H H i    3  3H|$ H$   Ll$(HtHu
HGHP0HtHu
HCHP0MtIE u
IEIP0L
 D 1 H
j PHHL$xHtO= Ht$xH$   H$   HL$`0= HL$HHt = Ht$HHt$PHt$XHL$0= HH   A_A^A]A\_^[LD$HT$HL$SVWATAUAVAWH  HǄ$@     < HtH$   H33HH$   H$  H$   H$(     < Ht
H$   HHH$   H$   H$   H$   LH\$    ?< Ht
HL$hHHHD$hH$   H$   H$      < Ht
HL$8HHHD$8H\$PH\$XH\$`LH5~ HH
 6W HHtH H,HHu'H" H    ' 3    HGL   MtHî HAL2L@@MtH H HALH HW LMu'H H# u    3  !  Hu
HGHP0HH$  M|$HsU I9r  I|$H$  H\  It$HHILHuHAP0L~HV I9u~H$0  H$  H$8  E3EAH$0  H,HHu'H
 H
Q    ձ 3    Hu
HGHP0HH$        U LHu'H
v H
 I   { 3    HxHH$  H$  H IE E3IH.HHu'H H      3  6  IE u
IEIP0LH\$ ?H$  I@0HHu'H HB    ư 3    I$u	IIP0HFL   MtHB HAL2L@@MtH' H HALH H@U LMu'H1 H    6 3  L  Hu
HFHP0IH$   !0HHL$h蓁 H$   Ht,8 H$   H$   H$   H$   8 ]T Ht'H
 H l    3    I$uID$IP0LH$   HT$hH$    H$  j@@u2S Ht'H
 H    $ 3    H$   H$H   DLH$   H$  HIQ HHL$8l H$   Ht7 H$   H$   H$   H$   6 HT$8H$   ! H
 1HHu'HV Hק )   [ 3  q  H@L   MtH HAL2L@@MtHܩ H HALHƩ HR LMu'H HW    ۭ 3    Hu
HFHP0H$   HHu'H H ]    3    HM}HtP I9Y  I}HL  M}HIIMHuHAP0IOH$  HQ H9u~H|$(Ht$0E3EAHT$(I(LHu'H
 He      4     Hu
HGHP0H  HFHP0L$        P LHu'H
y
 H
 L   ~ 4     HxHp E3HI)LHu'H4
 H    9 4     Iu
IFIP0L$  fHI_+LHu9H	 Ha     3  Ht_HuYHFHP0MHuHFHP0L$  IE    IIP0   3H$  L$   Ll$ MHtHu
HGHP0MtI$uID$IP0MtIE u
IEIP0MtIu
IFIP0L
 D  H
/ FLHL$PHt43 H\$PH\$XH\$`HL$83 H$   Ht3 H$   H$   H$   HL$h2 H$   Ht2 H$   H$   H$   H$   2 H$  Ht2 H$  H$   H$(  H$   v2 IHĀ  A_A^A]A\_^[HHHUVWATAUAVAWHp  HǄ$P  HX)pL   62 3Ht
H$   HHH$   H$8  H$@  H$H  H$  L   1 Ht
H$   HHH$   H$   
 H$  ƀ   H$  H@H$  H H$  H@H$     |1 Ht
H$   HHH$   H$   R
 H$   ƀ   H$   H@H$   H H$   H@H$   HLH=æ HH
 kL HHtH H!HHu*HW Hء *   \ :  E3?  HCL   MtH՟ HAL2L@@MtH H HALH HL LMu'H HU    ٧ :  a  Hu
HCHP0ID$L   MtHĠ IAH2L@@MtH H IAHH IRL HHu*HC HĠ    H :  E3
  I$uID$IP0LHkHJ H9E M  LcM@  H{I$HHHHuHAP0HoHJ H9E usL$   L$   E3EAH$   H!HHu'H H W    :  	  I$uID$IP0E3M      |J HHu'H
- H
     2 :  	  L`E3IE Lh E3HHP#HHu'H Hb     :  Y	  Hu
HFHP0E3I=IH%HHu'H H b    :  	  E3Hu
HE HP0IHGHH H;%  H;H   HJ LHu'H  H    % :    Hu
HGHP0ID$H   IIHHtg   IHHtUIHȍURy'H H( z    :  4  I$uID$IP0M   I$uID$IP0MuH'H@ H    E ;    HOHtVH~A   H H
H H	K 
Hxw'H Ha     :  X  H;u
H_Hw HGHHpHHHu
HGHP0H$  LHHL$@fHH$   H;tmH$  HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$    HH$    HT$pLHD$@HHH\$(HD$ (D$ fD$0HuhD HT$pHD$@H;uRHHtH;tFD HT$pL;u5HRHL$@nJ L\$pM[E3Ll$xHD$pH HD$pH@   H|$0H\$8HtH;tC I;   (t$0HuC     tC dHC    u,HH     u    HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@C @E3HL$p) Ll$pLl$xHL$@) HHL$@oHH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$    HH$   S HT$pHHD$@HHH\$(HD$ (D$ fD$0Hu_B HT$pHD$@H;uOHHtH;t=B HT$pH;u2HRHL$@eH L\$pM[Ll$xHD$pH HD$pH@   H|$0H\$8    HtH;tA H;   (t$0HuA     tA gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$@A =HL$p' Ll$pLl$xHL$@' L$   L$   HT$@H$  HI< HH$   p HL$XHt' Ll$XLl$`Ll$hHL$@k' H
0 !HHu'H Hu Ǖ    .;    H@L   MtH HAH2L@@MtHz H HAHHd HC HHu'Ht H G   y 0;    Hu
HFHP0H$   HHu'H( H    - 3;    MHkHA H9E O  LcMB  H{I$HHHHuHAP0HoHA H9E uxLd$ Ht$(E3EAHT$ HHHu'H H Z    G;     I$uID$IP0H  HFHP0|     qA LHu'H
" H
    ' W;     L`MHp IE3HHFHHu$H HX    ܜ ];  RI   IFIP0   HHHH   H H V    @;  HtHu
HGHP0HtHu
HCHP0E3E3MtI$uID$IP0HtHu
HFHP0MtIu
IFIP0L
v D˒  H
J 7I Hu
HFHP0Hu
HE HP0H$  Ht
HuHAP0MtIuIGIP0H$   LH$   HHH\$(HD$ (D$ fD$0Hu< H$   H$   H;uaHHtH;t< H$   L;uAHRH$   B L$   M[L$   H$   H H$   H@   Ht$0H\$8    HtH;tP< I;   (t$0Hu7<     t(< gHC    u/HH     uff     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   ; :H$   I" L$   L$   H$   ," H$  HD$(H$   HL$ H H$   H$   (D$ fD$ ($   f$   LL$ L$   H$   H$   $ H$  ! L$  L$  H$   ! H$8  Ht! L$8  L$@  L$H  H$   ^! HH$  ($`  Hp  A_A^A]A\_^]HHHUVWATAUAVAWH   HǄ$   HXHLE3DxAO! Ht
HL$ HIHD$ L|$8L|$@L|$HM     HtL0IIM~M~ M~(Ǆ$          Ht
HL$PHIHD$PL|$hL|$pL|$xHGH;D;    H;?; t{HH= HHu+L
 L
R A/   D ]T  җ   H@L   Mu4L
 L
 A/   Df _T     HIMHl@ MuEH: H9GuH;w  HGHHHH,H;w  H] HHHHAHH   ILHt
HuHQR0HH$   ,0HHL$PD H$   Ht L$   L$   L$   H$    H; Hu]HT$PH$   YC HHL$ 2 H$   Ht L$   L$   L$   H$    L
7 L
 A0   D T  ( O: HtvH< HH5t?9 XL
 L
W A/   D zT  ו HuHGHP0L
( D}  H
 W1Hu
HGHP0HT$ I( MtI$uID$IP0HL$hHt L|$hL|$pL|$xHL$P HL$8HtFH|$@H;t7HYHHt^ L;L{L{HKJ H0HCH;uHL$83 L|$8L|$@L|$HHL$  IH$  H   A_A^A]A\_^]H\$ WH H
9 LD$0HT$8HL$@87 H{HHtH H LD$0HT$8HL$@H7 HK3HtH{HuHAP0HK HtH{ HuHAP0HK(HtH{(HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKHHtH{HHuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  @SH HYhHtH. HM H [LI[IkIsWATAUAVAWH`H-5 H55 E3MHLIkIsMcM'  LrIMt0Ht!HtH'  Hr(IsHj Hl$HLbLd$@Ix6 HIMtHt,HtOvHp I6 LHD$@H   HHj  HS I5 HtHHD$HHHA  H I5 HtHHD$PHH  H LL$@Hm HD$(E3ILt$ @y
2     Ht$PHl$HLd$@   HBH   H   H   HKH}   L
&    L
( HL$0H
5 HH	L|R Hf IDL HD$(HT$ H 7 2  L
 H
҇ Aa    a  L
= ,3Hr(Hj LbLLIIoL\$`I[0Ik8Is@IA_A^A]A\_LI[IkIsI{ ATAUAVHPH=\3 3MHLI{IsM   LjIMt!HtH   Hz I{HrHt$@I4 HIMtHt&MH I3 HHD$@H   HH.  H I3 HtHHD$HHH  H2 LL$@HV HD$(E3ILl$ 	y
e3     H|$HHt$@   HBH   H   HKH}   L
    L
  HL$0H
3 HH	LTP Hc IDL HD$(HT$ Hӥ 5 u3  L
 H
 A   x   L
 X*3Hz HrLHIL\$PI[ Ik(Is0I{8IA^A]A\K@SH HYhHtH9) Hm H [@UVWATAUAVAWH   HǄ$  H$`  L   L E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HL$p  L$h  II    Ht
H$   HIH$   L$   L$   L$       Ht
H$   HIH$   L$   L$   L$   H$   , 3/ LHu'H Hj     <    I_0HCH;0 t|H;0 tsHHj2 HHu'H
 H
 f    <  %  H@L   Mu-H\ H݅ /   a <    HILdMuEHl/ H9CuH;{  HCH4HHI,H;{  I4$HHIHAHHu  H$h  H$h  Ht
HuHQR0HFL   MtH HAH2L@@MtH H HAHH Ha0 HH   E3HS HHH   Hu
HVHR03INI9N ~HE IFH,HAIFHI/ uHE u
HEHP03H HW    ۊ <  E3e  H H-     <  E3;  H H U    <  E3  / HtHH0 HH)t- *H/ H    4 <  E3  Hu
HCHP0E3IL$p  IHL$`9HH$   ( H|$xHt4L$   I;t     HW* H(I;uH|$xH Ll$xL$   L$   HL$` $. Ht'H` H 3   e <  G  IW8HL$`bHH$    HL$xHtNL$   I;t<HyD  HHtO L/LoLoHO; H0HGI;uHL$x$ Ll$xL$   L$   HL$` [- Ht'H H j    <  ~  ALD$ H$   H$   *y 3B+ LHu'HC Hā    H <    HL$8HH\$@H;v) H\$@HL$8HD$ HD$PH|$X(D$PfD$PH|$PLd$XL$h  D  H;ve) HtH;|$ tS) L;  Hu?) E3LM;c r+) IH$   ' Hu) E3LM;c r( I(H$   H$  HC$   H$  G- HHu7L
0 L
 } 2   % eP  eP  D@2H
 "Ht  ILH$h  Ht
HuHAP0HCL   MtHp HAH2L@@MtHU H HAHH? Hv+ HH   E3H HHH   Hu
HCHP03INI9N ~HE IFH,HAIFHI+ u"HE u
HEHP03H\$@HL$8H Hb |    <  E3sH H; |    <  E3LH H f|    <  E3%Hl H~ ?|   q <  E3MtIu
IFIP0HtHu
HCHP0HtHu
HFHP0HtHE u
HEHP0L
z~ D{  H
  ME3H$p  Ht
HuHAP0H$h  HtHuHAP0H$   >% H$   HtLH$   H;t:HYHHt L+LkLkHK H0HCH;uH$    L$   L$   L$   H$   k H$   Ht3H$   H;t@ H$ H(H;uH$   H* L$   L$   L$   H$    H\$8Ht-H|$@H;t@ H7$ H(H;uH\$8H Ll$8Ll$@Ll$HHL$  IH$`  H   A_A^A]A\_^]H\$ WH H' LD$0HT$8HL$@% H{hHHtH HH LD$0HT$8HL$@H% HK3HtH{HuHAP0HK HtH{ HuHAP0HK0HtH{0HuHAP0HK8HtH{8HuHAP0HK@HtH{@HuHAP0HKPHtH{PHuHAP0HKXHtH{XHuHAP0HK`HtH{`HuHAP0HCHH\$HH _H@  HL@HPHHUVWATAUAVAWH  HǄ$(  HX MMHLE3Dd$hH$  HL$p AL$	 Ht
HL$8HIHD$8IH\$PIHL$XLd$`ILd$0H$   H+$   HH  H;r" HL$XH\$PH$   L9,M  HuIHT$`H+HHH+HH;sH1HHL$XH\$P  HH;v]" HL$XH\$PHl$8H$   H$   HH+HuI$H;v " HtH;l$8t" H+H($   f$@  LL$0A   H$@  HL$896 H\$PLHL$XH;v! HL$XH\$PHl$8Hu! E3HL$XH\$PHD$8LII;S wHt	HE E3E3IH;Psf! HL$XH\$PE3HHt$0H$   H+$   HH;gH$  IH$   H+$   HH$   Ht=H;r  H$   H4HH$   H+$   HH;rHL$XH\$PIH+HHt[H;r  H\$PHH$   H+$   HH;r  H$   L$HHD$XH\$PH+HHH;r   7 Ht
H$   HIH$   Ld$0LD$0HH$   Y IHt=    H$   H$   H+HH;r H$   HHH;rH5;;	 H$  H$  IH$    LL$pH$  LIH$P  Q L$   LIH$   5 H%m	 H$   L$   L$   H$  H$  fWD$0H$  H$       Ht
H$  HIH$  LD$0IH$  _X H$p  H$   H$  HD$0H$  H$0  H$8  H$@  H$p  H$   H$x  H$   H$  H$  H$  H$  H$   H=t	 H$  H$(  H$  H$0  H$  H$8  H$  H$@  H$  o H$  H$   H	 H$  H$x  H$  H$  H$  H$  H$  H$  H$    H$  H$0   H$  H$X  H$  H$`  H$  H$h  H$  H$p  H$   H$  H$   H$  H$  H$  H$  H$   H$  H$(  H$  H$0   H$  H$`  2 H$8  H$  H$@  H$   H$H   H$p  HD$ L$  L$  H$8  H$`   HI4 D$h   H$x  Ht L$x  L$  L$  H$`   H5!	 H$@  H$p  Y H$  L L$h  L$   H$x   H$h  H$`  H$(  Htw L$(  L$0  L$8  H$  R H$   H$  Ht8 L$  L$  L$  H$   H$  HtLH$  H;t:HYHHt L#LcLcHK H0HCH;uH$   L$  L$  L$  H$   H$p  H$X  Ht{ L$X  L$`  L$h  H$@  V H$   H$  Ht< L$  L$  L$  H$   H$  HtLH$  H;t:HYHHt  L#LcLcHK  H0HCH;uH$    L$  L$  L$  H$    H$  H$  Ht  L$  L$  L$  H$p  Z  H$P  H$    H$  H$   Ht)  L$   L$   L$   H$     HL$PHt Ld$PLd$XLd$`HL$8 H$   Ht L$   L$   L$   HL$p I IH$  HĐ  A_A^A]A\_^]HL$SVWATAUAVAWHp  HǄ$P  )$`  Hڹ   X HtH$   HE3E3IH$   H$   (  H$   ƀ   H$   H@H$   H H$   H@L$(      Ht
H$   HIH$   H$     H$   ƀ   H$   H@H$   H H$   H@L$   Lt$HILt$@IL$  MMMHKHu'H HOo l   u #    AH  Ht	H[H43! HHuIHH HHu
HGHP0Hu'HI Hn l   Nu #  @
  H\$HH$H  H=Ms HH
kr  LHtH HpLMu'H Hbn k   t #  	  IEL   MtHbl IAL2L@@MtHGl H IALH1l Ip LMu'Ha Hm 4k   ft #  m	  IE u
IEIP0ID$L   MtHPm IAL2L@@MtH5m H IALHm I LMu*H HPm j   s #  I	  I$uID$IP0ML$  IuH H9T  MeL$  M?  I}I$HILHuHAP0HwHE H9uoLd$PH\$XE3EAHT$PH:HHu'H
 H
l i   s #    I$uID$IP0ML$         LHu'H
 H
0l i   r #    L`ML$  HHX E3HHHHu'H\ Hk /i   ar #  S  Iu
IGIP0M:HIHHu'H
 Hk h   r #    IE u	HIP0MHCH H;-  H;    Hx LHu'H H"k th   q $    Hu
HCHP0ID$H   IILHto   ILHt]IHȍWӵy'H( Hj g   -q !$  4  I$uID$IP0ML$     I$uID$IP0MluHPH H:j g   p )$    HKHtVH~A   H H
E H	| 
HxHY Hi ,g   ^p $  P  H;u
LkL{ HCL(LxIE IHu
HCHP0IHT$@H$@  MIL$  L$0  ML$8  HL$`]2HH$   H;tmH$   HL$8H$   HT$0H	HL$(HT$ (D$0fD$0(L$ fL$ LL$0LD$ H$   H$   ! HH$   q H$   LHD$`HHH\$(HD$ (D$ fD$0Hu H$   HD$`H;u`HHtH;t H$   L;u@HRHL$` L$   M[3H$   H$   H H$   H@   H\$8H|$0HtH;t. I;   (t$0Hu     t eHC    u-HH     u     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$` ?3H$  H$   " H$   H$   HL$` HHL$`;HH$   H;tmH$   HL$(H$   HT$ H	HL$8HT$0(D$ fD$ (L$0fL$0LL$ LD$0H$   H$    HH$    H$   LHD$`HHH\$(HD$ (D$ fD$0Hu H$   HD$`H;uaHHtH;tg H$   L;uAHRHL$` L$   M[E3L$   H$   H H$   H@   H\$8H|$0HtH;t
 I;   (t$0Hu
     t
 fHC    u.HH     uf     HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   HL$`
 >E3H$  H$    L$   L$   HL$`    HD$0HtL$   H$   Hވ LMH$  LXAM[  E3Hd H
hb sHHucH Hd a   	k c$  HtHu
HCHP0M   IE u
IEIP0H$  Ht$@   E3E33H8Hu
HCHP0H Hd Ta   j g$  Ht$@?E3H$H  HD$HH$@  H$0  L$  L$8  
H$  Ht$@MtI$uID$IP0MtIu
IGIP0L
uc D`  j H
iV AHt$@EHL$HHt
HuHAP0HtHu
HFHP0HtHuHGHP0H$   LH$   HHH\$(HD$ (D$ fD$0Hu
 H$   H$   H;uaHHtH;t
 H$   L;uAHRH$    L$   M[L$   H$   H H$   H@   H\$8H|$0HtH;t[
 I;   (t$0HuB
     t3
 bHC    u*HH     uD  HH     tH\$8+HC    uH;XuHH@    tHHD$8ft$ LD$ H$   H$   
 ?H$   Y L$   L$   H$   < H$   HD$(H$   HL$ H HD$XHL$P(D$ fD$ (L$PfL$PLL$ LD$PH$   H$   C H$    L$   L$(  H$    A($`  Hp  A_A^A]A\_^[+HL$UVWATAUAVAWH   HǄ$   H$  HE3ML$  AN[ Ht
HL$PHIHD$PLt$hLt$pLt$xMII   " Ht
HL$ HIHD$ Lt$8Lt$@Lt$H3d	 LHu'He H_ 8]   jf E>  g  HFH;	 t|H;	 tsHH HHu'H
 H
_ \   f K>    H@L   Mu-H H]_ \   e M>    HILlMuEH H9FuH;n  HFHHHI,H;n  I] HHIHAHH  ILHt
HuHQR0HCL   MtHEa HAH2L@@MtH*a H HAHHa H	 HH   E3H_ H-HH   Hu
HSHR03IL$I9L$ ~HID$H<HAID$HIx	 uHu
HGHP03H^ H] 1[   cd u>  LE3  H1 H] [   6d r>  L$  E3  H H] Z   d p>  L$  E3   HtPHj
 HHWt
 2H H%] wZ   c h>  L$  E3E  Hu
HFHP0E3IMIH$   HHL$  H$   Ht6L$   I;t!    H H(I;uH$   HZ L$   L$   L$   H$   5  Ht'H HH\ Y   b >     HT$ HL$PH HT$PH$   v5 HH$   HI"~ ȉ$  j LH   HO H[ "Y   Tb >  MtI$uID$IP0HtHu
HFHP0HtHu
HCHP0HtHu
HGHP0L
_[ DX a H
s` MMtIE u
IEIP0MtIuIGIP0H\$8Ht)H|$@H;tH" H(H;uH\$8H Lt$8Lt$@Lt$HHL$  H\$hHt)H|$pH;tH H(H;uH\$hHk Lt$hLt$pLt$xHL$PR IH$  H   A_A^A]A\_^]HVWATAUAVH   HǄ$   HXHhHٹ    E3Ht
HL$ HIHD$ Ll$8Ll$@Ll$HH$   &  H$     HT$`HKh HHL$  H\$xHt.H$   H;tfH  H(H;uH\$xH] Ll$xL$   L$   HL$`> 3 HHu'H˽ HLY V   _ H?    H\$8H;\$@v9 HD$ HD$PH\$X(D$PfD$PIHt$PLd$Xfff     H\$@H9\$8v  HtH;t$ t  L;  Hu  MLM;c r  IH$   K Hu  MLM;c r  I(H$   H$    H$   HL$`o HH$(  H@H} rHMHMII;}HH33u H'H=x  tE3m HE3E3T HH HtlHOH9O ~HHGHHAHGHH uHHCHP0H HuW T   ] R?  "Hл HQW T   ] P?  Hu
HGHP0HtHu
HCHP0L
W DfT ] H
\ @IHHuHGHP0H$    H$    H\$8Ht.Ht$@H;tD  H H(H;uH\$8H] Ll$8Ll$@Ll$HHL$ D HL$   I[0Ik@IA^A]A\_^H\$Ht$WH IHHMt7I  H~)HH E3HCuH\$0Ht$8H _HHH>Hu
HSHR0H\$0Ht$8H _;H\$Ht$WH    IHHr
30  Hu  HnU E38  HH   HZ  LHHCHI  HH H<  HC H1  H H'  HC(H  H H  HC0H  H H HC8H H H HC@H H H HCHH H H HCPH H H HCXH H H HC`H H !y"Hu
HCHP03H\$0Ht$8H _Ht$8HH\$0H _HWATAUAVAWH   HǄ$   HXHhHp LA   HHL$`蟙 H|$pLHt$hLHHH3HuH9H;v)  H<    H HHuHt)  H|$pHt$hHL$0Ll$8Lt$@IHtHtIHHH;tN)  Ht:HtIHHH;t,)  HtIHHH;t)  HHMI;t%  HtHZ  HHD$0HH\$0Ht$8H|$@HHHH+HLMHM~!fHD$`f(f)HI;}HL$0LHT$0HL$`?  H$   HHuHI=II;vK(  HHM HHuHt+(  H$   Ht$HHl$PHtI;t(  HtI;t'  ̄t'  H;t(H HtHiY  HHD$HHH\$HH|$PHHH+HLMHM~!f     HD$xf(f)HI;|LHT$HHL$x&  HD$0H$0  MH$   H$0   7 LHHiHuH/I;v"'  H<    H  HHuHt&  HL$ Hl$(IE HxHtI;t&  HtI;t&  ̄t&  H;t HtH?X  HD$ H\$ H|$(HT$ I H$   z DM9\$~IH
	 E D  HD$ 1fT^fWAHIcI;D$|LD$ H$   HL$05 H$   HW9 HHxHtI;t%  HtI;t%  ̄t%  I;|$t!I$ HtH>W  I$I$I|$HHH+HLMM~$f     HE f(I$f)HI;|LIH  H$   @ H$   1 HL$ % H HL$0 H$     HL$x HL$` L$   I[0Ik8IsHIA_A^A]A\_HLH L@WATAUAVAWH  HǄ$  HXHp)pLE3L|$XL|$`L$P  L$   AO4 Ht
H$p  HIH$p  H$p  
  H$  ƀ   H$  H@H$  H H$  H@L$      Ht
H$  HIH$  H$  蜵  H$@  ƀ   H$@  H@H$@  H H$@  H@L$H  L$   ML$  I   B Ht
H$  HIH$  L$  L$  L$  HQ HH
P f HHtH HHHu'HR HL %J u  WS !!    HGL   MtHJ HAL2L@@MtHJ H HALHJ H LMu'HҰ HSL I u  R #!    Hu
HGHP0IFL   MtHK IAH2L@@MtHK H IAHHK IQ HHu'HB HK I u  GR &!    Iu
IFIP0ML|$PLgH I9$\  LwLt$PMJ  H_IHHHHuHAP0LcH I9$uvL$`  L$h  E3EAH$`  HHHu*H
 H
 K RH u  Q :!  MR  Iu
IFIP0ML|$P      t HHu*H% HJ G u  *Q H!  M
  LpML|$PIE Lh E3HH@HHu*HѮ HRJ G u  P N!  M  Hu
HFHP0I=IHHHu*H H J RG u  P 4!  MR  Hu
I$HP0IHCH H;1  H;v $  H LHu*H HI F u  P s!  M  Hu
HCHP0IFH   MIHHtpA   IHHt]IHAT$=y*H HI eF u  O {!  Mz  Iu
IFIP0ML|$P   Iu
IFIP0MڒuIH' HH E u  ,O !  M  HKHtYH~A   He H
 H	 
Hx[HĬ HEH E u  N ^!  M  H;u
H{Hs HCH8HpHHHu
HCHP0HHD$XH$   IL|$xHt$`H$   I0   H$   HtH HH$   IH$      H$   HtH# HHD$pIHL$pAH   E3H~J H
E HHu*H H,G ~D y  M !  M~  E3E33HHu
HCHP0Ha HF 4D y  fM !  M  AH   E3H;H H
lD wHHu*H HF C {  
M !  M  E3E33HuHu
HCHP0H H?F C {  L !  MO  HDF H$P   HHu*Hw HE JC |  |L !  MJ  H$P  H
H HHu*H1 HE C }  6L !  M  H@L   MtH7H HAH2L@@MtHH H HAHHH H HHu*H H/E B }  K !  M  Hu
HCHP0HFH;    H;    HHD$hLH HHu*H9 HD B }  >K "  M  H@L   Mu?H HD A }  K "  M  HHMMHD$hHu
HFHP0IL|$0Mu@H H9CuL;c   HCJ4HI  L;c}zJtHI  HAHHD$0H   HtHH HHt *H# HC @ }  (J #"  M
  Hu
HCHP0L$   H$P  LHL;
 tUH;| tLMIL5 H5 H
y H	 L L"C t@   I Z"  M2  HHL$p!%HT$XH$   HH$p  H;tmH$  HL$(H$p  HT$ H	HL$HHT$@(D$ fD$ (L$@fL$@LL$ LD$@H$   H$p  賷 HH$p   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu6 H$   H;ufH$   MtL;t L;uIH$   HRH$   3 L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@t H;\$H   (t$ Mu     t} ]HC    u%HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$   X :H$    L$   L$   H$    HT$`H$   'HH$  H;tsH$@  HL$HH$  HT$@H	HL$(HT$ (D$@f$   (L$ fL$@L$   LD$@H$  H$  e HH$   L$   Ll$HH$   LHD$@I] H\$(HD$ (D$@fD$@(L$ fL$ Hu H$   H;ufH$   MtL;t L;uIH$   HRH$    L$   M[L$   H$   H H$   H@   H\$(Ld$ MtL;d$@tY H;\$H   (t$ Mu>     t/ ^HC    u&HH     uHH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$   	 9H$   S L$   L$   H$   6   O HD$ HtL$  H$p  H=b LMAM   E3H"= H
; HHu*Ho H= B;   tD "  MB  E3E33HHu
HCHP0H% H= :   *D "  M
  AL$X  L;% AǅP  3 HHu*Hơ HG= :   C "  M  ID$H; t~H; tuIK HHu*Ht H< G:   yC "  MG  H@L   Mu>H: H< 
:   ?C "  M
  II$IHL$hMHMuHH; H9FuH;N  HFH<HHHL$h3H;N   H|HHHL$hHAHHD$xH  H$  H$  Ht
HuHAP0HGL   MtH> HAH2L@@MtHg> H HAHHQ> H( HH   E3H:= HjLH   Hu
HGHP0IL|$xHKH9K ~IHCL4HAHCIH u"Iu
IFIP0ML|$PHL$hH H; a8   A "  Ma  Hd H: 78   iA "  M7  H: H: 
8   ?A "  M
   HtHH HHtP *H Hh: 7   @ "  M  Hu
HFHP0IL|$0H$   L$   LcIu*H H: ^7   @ "  Ms  H$   I HH H+HHgfffffffHHHH?HAL;H$       H$   H$   HH$   H$     Ht*Hѝ HR9 6   ? "  M  H$  H$    HI>[ H$   LHT$pIE DHHHu*H[ H8 .6   `? $#  M.  HD$0HL$pyHHu,H H8 5   ? 0#  Ld$0  HL$0HA8HHI8H9 uHAP0HD$0HX8H\$pHtHh H MtI8i I MtIu
IGIP0Dd$PA HHu,Hn H7 A5   s> R#  Ld$0?     ~ HHu,H/ H7 5   4> T#  Ld$0   HXLd$0I$L`   E3H$   HL$XH$   HD$`MH$   H|$xLt$PHt$0  E3H$   HD$XH$   HD$`MIH|$xLt$PHt$0w  H$   LH$   HtHu
HAP0LIIAL   MtH7 IAH2L@@MtH7 H IAHH7 I HHu*H Hw6 3 ~  < 3"  M   ML|$PH H9GuLwLt$PMtqHwIHHHHuHAP0IHHHu'Hy H5 L3 ~  ~< @"  MOIu
IFIP0ML|$PlHHHu\H( H5 2 ~  -< C"  MHtHu
HCHP0H   H   HGHP0   Hu
HGHP0IL|$xHu
HFHP0IL|$0E3H$   HT$XH$   HT$`MLt$PI(E3H$   HT$XH$   HT$`MLt$PIMtIu
IFIP0HtHu
HFHP0L
4 D1 .; H
' IHL$XHt
HuHAP0HL$`Ht
HuHAP0H$P  Ht
HuHAP0H$   Ht
HuHAP0H$   Ht
HuHAP0MtI$uID$IP0H$  HtHuHAP0H$  Ht6H$  H;t!    H H(H;uH$  Hj L$  L$  L$  H$  E H$@  LH$  LHH\$HHD$@(D$@fD$ HuO H$@  H$  H;uaHMtL;t' H$@  L;uAHRH$  I L$@  M[L$H  H$@  H H$@  H@   H\$(H|$ HtI;t I;   (t$ Hu     t fHC    u.HH     uf     HH     tH\$(+HC    uH;XuHH@    tHHD$(f$   L$   H$  H$  i 5H$@   L$@  L$H  H$   H$  HD$HH$p  HL$@H H$h  H$`  (D$@f$   ($`  fL$@L$   LD$@H$  H$p  莦 H$   L$  L$  H$p    HL$  I[0Is8A(sIA_A^A]A\_LI[IkIsWATAUAVAWH`L% 3MHLMcI{HI{Ml  LrIMt0Ht!HtHb  Lb(McHj Hl$HHzH|$@I
 HIMtHt,HtFmH-4 I HHD$@H  HHa. I HHD$HHtHH  H- I_ HtLHD$PHH\  H! LL$@H, HD$(E3ILt$ ޼y
      Ld$PHl$HH|$@  H
 H HD$0   H	HT$(   L
L L2! HL HD$        HBH   H   HKH}   L
L    L
L HL$0H
> L H	HHe
 IDL  HT$(HZL HD$ O    L
3 H
  Ao   , o  65 L
. 3Lb(Hj HzMLHIL\$`I[0Ik8Is@IA_A^A]A\_Ha HH% H\$WH H7 HH tHм HH\$0H _H HH%O H\$WH H HH! tHp HH\$0H _@SH H HHHA HH [H% H\$WH H HHHA\ H tH HH\$0H _HL$WH0HD$ H\$HHH< H HHOH HH\$HH0_H\$WH H HHHA H tHR HH\$0H _HL$WH0HD$ H\$HHH H4 HHSHO[ HH\$HH0_HL$WH0HD$ H\$HHHD H< HHSHO HH\$HH0_́aI    H́aI   H@SH H; HHt? HH [Ha H@SH HK HHt HH [H(Ht
H   H(HL$HT$LD$LL$ H1 HH% H) H\$WH H HH tHP HH\$0H _HA H@SH H+ HHt HH [@SH Hi LJ LHH [H) HHHHE HL$ A   4 L H@ HL$ L\$ 蛸 @SH H HHHA HH [H% HL$WH0HD$ H\$HHH H HHSHOk H HHH\$HH0_HfWE3I   H$I@HHH+LYHLRL    fD  AJBI I HAYKAYBXf(AJXABAYKAYCXXuH$M;s"H+JM+HIYHXuf(HH)f(
 f( f(  f(h f f(fYfYfYfX
 fX fYfYfXf(
 fXf( fYfXfYf( fXfYf(
 fXfYf( fXfYf( fXfYf(
 fXfYfYfXfXf)$^D$HH)f(
 f( f(  f(H f f(fYfYfYfX
 fX fYfYfXf(
 fXf( fYfXfYf( fXfYf(
 fXfYf( fXfYf( fXfYf(
 fXfYfYfXfXf)$^D$HHL$WH0HD$ H\$HHH H HHSHO[ H HHH\$HH0_AA ̋Q<A4A@    QHTQDHH% HA H3HAHAHAH\$WH HHIHHP uHOHHP uH\$0H _ðH\$0H _H\$WH HHIHHPuHOHHPuH\$0H _ðH\$0H _H HHL$SH0HD$ HH H HH0[HL$WH0HD$ H\$HHH H HHSHO H HHH\$HH0_̋   tt
tt3Ë   @SH HY L" LHH [HL$WH0HD$ H\$HHH H HHSHO H HHH\$HH0_@SH H HHHA L HLH [H% @SH Hc HHHAR HH [H%[ @SH HK HHHA" L HLH [H%Y @SH H3 HHHA HH [H% @SH H+ HHHA HH [H% Hy8rHA HA H   HD$ H! HL$(> HL$P Hr HD$PHT$(HL$h= H HD$PHY9 HL$P۰ H   HD$ Hq HL$( HL$P H HD$PHT$(HL$h H- HD$PHY8 HL$Pk H(HHHcHHLHHt
H H(LBI HBI     uHPHBI@HA0H;PuL@ILBHBH;uL ILBL@ILBLI@HI@    uHPHBI@HA0H;Pu
L@IPLBHBH;Pu
L@IPLBL IPLB@SH H9 Hu HK    tHAHC    tH [H%a H    u/HH    u     HHI    tHCH [HI    uHH9CuHKHI    tHC    uHKH [@SH LHHuHRAHH [HHRHcHHAHH [HHHD$0D$    L
 L 3P 2HHHHHD$0D$    L
 L] 3 2HHHHHD$0D$    L
 L 3Э 2HHHHHD$0D$    L
T L 3萭 2HHHHHD$0D$    L
 L 3P 2HHHHHD$0D$    L
 L] 3 2HHHHHD$0D$    L
 L 3Ь 2HHHHHD$0D$    L
 L 3萬 2HHHHHD$0D$    L
 L 3P 2HHHHHD$0D$    L
 L] 3 2HHHHHD$0D$    L
 L 3Ы 2HHHHHD$0D$    L
\ L 3萫 2HHHHHD$0D$    L
 L 3P 2HHH\$Ht$WH HQ 3HH+Q   HHt'H;r+ HFHV HH+H|H;rH\$0Ht$8H _H HH@WHPHD$ H\$`IHH? HL$( HHT$(HHL$( LHASHHL$(r HHT$(HHL$(x HQ HL$(F HHT$(HHL$(L H HL$( HHT$(HHL$(  LHH\$`HP_IcH\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$3һDDRDDD+t?fff     3AAAADD+t#3AAAADD+uAH\$A+ۋH\$H\$Ht$WH HHHH;tp H(H;tdHH[ uHH(H;t2f     HH4 uH(HH( H(H;uHG(H\$0Ht$8H _H\$0HHt$8H _Hl$Ht$ WAUAVH LI HIgfffffffL+IIMHIHHH?HtHu HVHt HN Iƿ   H+NHHHH?HH;skH\$@Ld$HDg'H;r HFIHI! HH HN IH+NHI(HHHH?HH;rLd$HH\$@H HHl$PHt$XH A^A]_H%Ͼ Hl$Ht$H|$ ATH HA MHH+AHHHtHu HFH] HF    H+FHH;sGH\$0H;r H^IH/ H HF H+FHHH;rH\$0H	 HHl$8Ht$@H|$HH A\H% H\$LLLM+HgfffffffHIHLI?IL;~HIHI+HHHH?HL+H\$KHL+I@SH AHD$@    A)   H[Ic  HH H HH [H H{ HH [H+ Hb HH [H HI HH [Hy H0 HH [H H HH [H H HH [H> H HH [H H̼ HH [   y  . G `  ĥ  ihQp%^ H8  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(ihQp% H  f(f(fTfTf/L$\$wHL$f/wHL$\fT^f(H   "U A))t$p)|$`D)D$PE f(f(D)L$@D)T$0D)\$ YD	f(AXYf(YfA(YDY Y YD^\fA(Y ^fA(X^YD\YfA(AY\ 
j H$   DQ D@ fA(0\f(H$   ^AXf(f(Y^fWA^fWf(YAXA^YAXYAYAXAYYAXYf/vf(f(f/v8f/v2f(YA^AXYAYAXYf/vf(f(f/v6f/v0f(YA^AXYAYAXYf/vf(f((t$p(|$`D(D$PD(L$@D(T$0D(\$ HĈ   H\$WH HH* L LHCHGHC H\$0HG HH _@WH0HA HH+AHHu
fWH0_H\$@)t$ Hu HGHO    H+H0H;s(H;rϹ HGHO HH+HXtH;rH\$@f((t$ H0_HA HHA@HHAXD H3HHHWH@  HD$ HXHH@       DBHL$@[    HL$(R HL$PHcQHLPHPHL$P7 HHL$@1 Ǆ$`     HL$@# HH$X  H@  _3f(LTDIDA     Apx f/sffA;ufDA0x f/sffA;ufDAAHkHfAB@w HL$WH0HD$ H\$HHHD H HHSHO H+ HHH\$HH0_@SH HH	Ʒ HK HKH [H% A f/ryf(f(YA0YJ0XA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0^As f/   f(f(YA8YJ8XA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8^A3 f/   f(f(YA@YJ@XA8XJ8YYXA0XJ0YYXA(XJ(YYXA XJ YYXAXJYYXAXJYYXAXJYYXX
^^f(f(YY
XAXJYYXAXJYYXAXJYYXA XJ YYXA(XJ(YYXA0XJ0YYXA8XJ8YYXA@XJ@^LL$ LD$HT$SVWH`H$   L$   HHME3HHHHHT$8Hg  H$   Ld$XLl$PKRLt$HL|$@IHJMIMHIMK,HMH$L|$0Ll$Hl$HL$E3I4  IKLHHL$ HHIM+HL$(JLH+H+MM+MELl$ IMHUH+L+Hl$(IEHHMLfD  KIHHpHBH HxI@I HAHEH M;HAIDHAHBHAHDHAHDHAKDHAHBHAI@HAKDHAHD/HAHBHAI@HAHEHAWL$   H$   Hl$Ll$L|$0H$HL$M;}_MIHML+H+H+M+JTOJL I
H HIHBHAHBHDHBHDHBuH$HL$IMIMHHl$Ll$H$HL$2H$   HT$8L$   L$   L|$@Lt$HLl$PLd$XH$   H;   HJ4    IH+H$   IfE3I|]MSJLHSIIN    M     HBH H IHAHBHAHBHAHBHAuH$   M;}JIIM;JD|HHH$   lH`_^[HL$WH0HD$ H\$HHH H| HHSHOK Hó HHH\$HH0_@SH HHt*H|$0CuHHPCu	HHPH|$0H [@SH HA HHA`    H+AHHu HCHHKpHCPH+CHHHu HCHHHKpHKhH [̋ f()f(
 ufo% f%W a fo%G f]- f_- fYfX
 fffT
 f\f(f(fY fY
 f\f\f(fYf(f(fY fY fX fX fYfYfX2 fX fYfYfX ff\ffrf^fpcfYx fX fYf_f(H\$WH0HA 3)t$ H+AfWHHHt,H;r HOHHDXpHG H+HH;rH\$@f((t$ H0_@SH HK HHt HH [H(HQHI H HH(H% @SH HHQHI HHݫ Hޫ HH [H%׫ HL$WH0HD$ H\$HHH) Hٲ Ht
H轓 HHH\$HH0_H\$WH HǶ HHHA̫ Lկ HL	 tHX HH\$0H _H\$WH H HHHAl H{ tH HH\$0H _H\$WH HG HHHA L
 HLY tH訒 HH\$0H _H\$WH H HHHA H tHR HH\$0H _H\$WH H HHHAl H tH HH\$0H _@SH HH	HtHP tH    H [@SH H9 Hu HK    tH [H%Ҫ HA    u.H    uf     HH	    tHCH [HI    uHAH9CuHKHI    tHKH [HL$SH0HD$ HL u
HG HHHcHHLHHt
HȨ H0[HHLHuKHא HH3HIH(sE3HT$XHL$ LD$X; L H HL$ L\$ 肐 HHLHuJ    g HH3HIHsE3HT$XHL$ LD$X˩ Lt H} HL$ L\$  HHLHuJ     HH3HIHsE3HT$XHL$ LD$X[ L H
 HL$ L\$ 袏 HHLHuK@H臏 HH3HIH0sE3HT$XHL$ LD$X L H HL$ L\$ 2 HL$VWATAUAVH@HD$ H\$xDH3ۉ$   LHL$(HLc@ILHHtH HHcH|1 uHL1PHt HHcH|1 D$0   H|1(H3HϋD1%  @t=A      H~0HHcHT1XHL1Hr AD܉$   HA   HHcHAHL1HC AD܉$   u/H~*HHcHT1XHL1H AD܉$   HHt$p$   Ll$(HHcHHD1(    HHcHHE3Ҥ Ӥ u
IΤ IE HcHJL)HHtHQ HHH\$xH@A^A]A\_^HL$VWATAUAVH@HD$ H\$xLH3ۉ$   3HHHLiHHcHH|1(H~
I;~I+3LHt$(HL1HHtH HHcH|1 uHL1PHt  HHcH|1 D$0u
      D1%  @t6H~-HHcHT1XHL1H u$   H΅u]HHcHMIHL1H[ I;t   $   2H~-HHcHT1XHL1H4 u$   HHHcHHD1(    Ht$p$   Ld$(HHcHHE3  u
I I$HcHJL!HHtHm HHH\$xH@A^A]A\_^HWH  HD$ HXHhHpIIHHٺ   DBH. HH$   HH HHHH HHHȋU  HH$  }HT$hH$   ʡ HHL$( H HD$(HHL$@٢ H! HD$(H HL$(w HD@WHP  HD$0HhHpIHHD;$        DBHL$`% HI HL$`HHHH& HH$   HH HT$8HL$`٠ HD$@H|$XHCD$@HD$ L
 L$p  HH(L$P  IkIsI_HD@WHP  HD$0HhHpIHHD;$        DBHL$`5 HY HL$`HHHH6 Hȋ$   HH HT$8HL$` HD$@H|$XHCD$@HD$ L
ľ L$p  HH9L$P  IkIsI_H\$WH HH I$HHH H
HH H HH\$0H _H% ATAUAVAWH(HQ I*E3H+QIE3LHHHH?H   H\$PHl$XHt$`H|$ 3L;r I~3۽   HL> H+L>HHt)H;rՠ HD>HL> HH+HlH;rIN III+NDH0HHHH?HL;rH|$ Ht$`Hl$XH\$PAH(A_A^A]A\H(Hu3H(HH;v<H\$ H    H5 HuHtH\$ H(H\$Hl$Ht$WH HAIIHHHAH;t4H	џ HtH\HsH{HH    HsH{LALIH\$0Hl$8Ht$@H _H(y t	H	u H(HH B(H\$Hl$Ht$ LD$WATAUAVAWH LT$xL$   Ht$pLIIHE3E3ۃH<HHH|$H  H$   MMlL+H    MxL+HL$L,$ILd$fff     L3H  H\$`IDkIkHL$LH|HNKTHIMHHHH    Lfff     IBHHpIBHxIHBIBMHBIEHBIEHBIE HBIEMHBID$HBID$HBI$HBID$MHBHGHBHGHBHHBHGIHHB_L,$H|$Ld$LD$`H;}RHKLL    HIITLL+OHBH HAHBHAHHAHBIIHAuLD$`HL$I IMI L;L,$oLT$xL$   I;   L$   L+M,LT$xD  ME3H   H~LHDm HIHHKLHL$    MMM\ I\ MfIH LHAHHHAI LHAILHHAuLT$xL$   L;}.IHL    HI+IL HIIHKDuIIH+I+LILT$xH\$PHl$XHt$hH A_A^A]A\_LL$ LD$SUVWATAULl$hH|$XLILL$`E3IIHH,HHH   HD$pLL$HILl$PH+L]H+IH4    HI    LH~<KN    IHfD  fH If)@fAIHf)@uLI IuH\$PHt$HLL$`Ll$hIH+H|UL\$pKZH~4L    HLfHHIDHBIIIDuLL$`IH+I+HLAL\$pI;  Lt$8H+L|$@L<L4fD  ME3H   HL] HD] LHKTILHHwHMIHL,    M IH MHBHIHBHIHBIMHHBuH\$PL\$pHt$HLL$`L;}0IHL    HHI+HHIIHKDuHD$hHIH+II+LI;L|$@Lt$8A]A\_^][H\$Hl$Ht$H|$ ATHPH$   HH$   )t$@)|$0f(f(Y= H|$(IHf(LH\$ Pf(M$LHIH|$(H\$ ASM$Lf(HIH|$(H\$ ASH\$`(t$@(|$0Hl$hHt$pH|$xHPA\@SH LHH~qLHIIgfffffffMQIIH+HHHH?HL;|M+IIHHH?HL+KHHHKI;IuMHC    H [y:IM~%HQHuHHPH	HCHH [yIIBHH [HWH  HD$ HXHhHpIIHHٺ   DBH^ HH$   HH HHHH HHHȋU  HH$  HT$hH$    HHL$(L H< HD$(HHL$@	 H9 HD$(H- HL$(} HWH  HD$ HXHhHpIIHHٺ   DBH^ HH$   HH HHHH HHHHU  HH$  HT$hH$    HHL$(K H; HD$(HHL$@ HP HD$(H HL$(| H\$Hl$Ht$WH LHHgfffffffL+IHIHHH?HHI,H;tH+fHH H(H;uH\$0Ht$@HHl$8H _H\$WH HHH IHHH& HHH H HH\$0H _H% H\$WH HH0" ITHHIH! H:Hn H/ HH\$0H _H%# H\$WH HH* IHHH* HHŒ HΒ HH\$0H _H% H\$WH HHd* IHHHF* HzHe Hn HH\$0H _H%b H\$WH HH* I4HH)H) HH H HH\$0H _H% H\$WH HH) IHHH) HH H HH\$0H _H% H\$WH HH\) ItHHiH>) HZHE HN HH\$0H _H%B H\$WH HH) IHH	H( HH H HH\$0H _H% H\$WH HH( IHHH( HHǏ H HH\$0H _H% Hh)t$P  )|$@  L
 L D$     D)D$0D  3x LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 LȜ 3D$     w HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
K LD D$     D)D$0D  3@w LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
ϴ L 3D$     v HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
 L D$     D)D$0D  3 v LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 LH 3D$     Su HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
۶ Lę D$     D)D$0D  3t LfWf/v2f/v,   ^xx,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
o L 3D$     t HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
+ L D$     D)D$0D  3s LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 Lȗ 3D$     r HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_Hh)t$P  )|$@  L
{ LD D$     D)D$0D  3@r LfWf/v5f/v/   ^   ,Ή      ;LA   IfA(I(t$P(|$@D(D$0HhH`@H\$WHP  )t$@  )|$0  L
 L 3D$     q HHHf(R8Lf(HAS@~   H\$`(t$@(|$0HP_HWH  HD$ HXHhHpIIHHٺ   DBH HH$   HH HHHH tHHiHM S HH$  KHT$hH$    HHL$( Hڌ HD$(HHL$@ H׌ HD$(H
 HL$(Ep LL$ LD$SUVWATHHl$hLd$`HHE3IHI؃LIIM~`MKIIfM~?JL    HIf     fH If)@fAIHf)@uH IuH\$PHI+H|CM~:L    JIfffff     HIJDHAIHJDuIL;
  Ll$@Lt$I;L<$N4L<fff     E3I   I{I{LHIl$JTHIHHMIL,    HM    IH MHBHIHBHIHBHIHHBuH|$XH\$PHl$hM;}0IIL    HII+HHIIHJDuIIIL;&L<$Lt$Ll$@HA\_^][H\$Hl$ LD$VWATAUAVHLT$hLl$`LIIE3HE3IH<HHH|$H  MdL|$@MxL$$     3I   IDsIsLHKTIH|Hl IMHMHHHH    LfIBHHpIBHxIHBIBMHBID$HBID$HBI$HBID$MHBHEHBHEHBHE HBHEIHBHGHBHGHBHHBHGIHHB_L$$H|$Hl$PI;}RHMKLL    HIL+OHTHBH HAHBHAHHAHBIIHAuI II L;L$$LT$hL|$@I;   L+Hl LT$hE3I|~I}LHvHIHHKLHL$    LLL\ H\ Mff     IH LHAHHHAI LHAILHHAuLT$hM;}.IIL    HI+HL HIIHKDuHILT$h3H\$HHl$XHA^A]A\_^HWH`  HD$0HXHhHpIIHH3EEE;|HHrp   DBHL$`@ H HL$pvHL$p HT$8HL$`) HD$@H|$XHCD$@HD$ L
s LHHL$`  I[IkIs I_HWH`  HD$0HXHhHpIIHH3fAnA@ f/rHHrp   DBHL$`c H; HL$pHL$p HT$8HL$`L HD$@H|$XHCD$@HD$ L
 LHH`L$`  I[IkIs I_HWH  HD$ HXHhHpIIHHٺ   DBH> HH$   HH HHHH HHHHU  HH$  HT$hH$    HHL$(+ H HD$(HHL$@ H0 HD$(H
 HL$(h HWH  HD$ HXHhHpIIHHٺ   DBH> HH$   HH HHHH HHHHHH$  HT$hH$   ~ HHL$(- H HD$(HHL$@ H HD$(H
 HL$(g L LLMu    A   H L H HHL$HHI;HD$IMLMM~I3II3I;}HIHSH  HD$p)p)xIf(f(HB HL$H~    DBH$   ~ HHPH HL$ ~ HT$ H$   O} HL$ ~ HT$HH$   ~ Hf(} HH HT$ H$   } LHHAHL$ X~ H HL$ &~ HT$ H$   | HL$ &~ A HT$`HL$ | HH$   q} Hf(\} HH UHL$ } HT$ H$   } LHHAHL$ } H HL$ {} HT$ H$   | HL$ {} A HT$`HL$  | XHH$   | Hf(| HH# HL$ *} HT$ H$   W| LHHAHL$ | LHASH$   -| HL$H| ($  ($  HĠ  [H%| MLAuGHA L HAXLcHA@IcKLILM+M;IB KL IB@D+HIBXED 3HHBBHHD$0MLt3HHBBHHHA H$HHA@HIBXLc L+LH+EtwAtBA   M   M;   IB HHIB@I+IHIBXD+DD XJHxbI;]HIB HIB@D+HIBXDD )Mx7M;2IB JHIB@D+HIBXDD IJ@IB H	H+H
HH$3HBBHHD$HD$HH#H H;w	HH      H;s   H¸    HH   )p)xf(z f(D)@D)Pf/fEWfD(fA(vf(a fW c  fA.zR  fA.zE  D)$   D)\$`D fA/D)d$PD)l$@D)t$0D)|$   D
 D fA/r6fff     fA(A\Xf(` fA/Xsf(A\7    ǜ 
 %  D D
| Dk D%Z  
 % D D
 D D% <D% D D
y Dh %X 
H 8    ț D5 D= E   D  d D5  C D=  " fE( D=j D5Y D-H f(AXYf(YAYAXYXYXf(AYAXYXf(Y
/ YX
 Xf(YY X
 X YAXYYAXYXAX^YY5< XV  D
b fD/vf(^ fA(fD(\AX f/      ϙ 
 5  D D D%s D-b  
 5 D D D% D- <D- D% D Dx 5h 
X H uxԘ D5Ø D=    D
  p D5  O D=  D= D5 D
y fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
V AYX
9 Xf(YY- AXX YAXYAXAYX^YY%m X   uq%J : 5*  D D D% %F F 5F DE DD D%C 3D%8 D' D 5  %  uz
r D-a D5P   D=6 
 
 
 
 D
U 
} D-L D5K D=J $D=? D5. D- D
 DYfW-g f(f(YYf(AYAXYXf(AYXYYf(Y
 Xf(Y X
 XYAXAXYYAXAXYX^AYDY AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIHT$WH0HD$ H\$@HHH       Z Ht@   @   H
 HHx3HHH\$@H0_HT$WH0HD$ H\$@HHH       Z Ht@   @   H
O HHx3HHH\$@H0_HILH+HH(  HH$HHHHHL    IL
f/v
H;t	A
f/vL;t	A

f/v
H;t	A	IKI+ f/vL;t	A	Af/vI;t	A	A	 f/vL;t	AIIH+H$I+f/v
H;t 	A f/vL;t	A f/v
H;t 	A	f/vL;t	A
Af/vI;t	 A	A	f/vfL;taA
H
f/v
H;t	Af/vL;t	A 

f/v
H;t	HHVWATHP  HD$0HXHhIIHL   DBHL$`qn HHL$`HHA HHV'n HHEz HT$8HL$`8n HE H+EHH;r@p HE$  HT$@H|$XHCT$@H$  HD$ L$  L$  IL LLMu    A   H L H HHL$  HH	I;HD$IMLMM~I3II3I;}HIH(HIHt
H   H(H\$UVWH0I@ 3II+@HHHHtNLd$PI      H;ro HOD$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]H LLHD$(Hl HHHD$ @SH Hs HHt?U HH [H8HD$  H;tMtHI IHIH8H\$H|$ 3HLH9yLH|$   MQMM;},HI	MMIHSIIHJMQM;|IAHT$HL$I;HD$HMHLI|bMZff     IIIIHH<IIIIHH|IIIIHH|IIIIHHI;H||I;}IIIIHHI;H<|IM;ALD$H\$H|$ LL$ LD$HT$HL$SUVWATAUAVAWH  H$   HLHHT$t
LHT$`+HHD$HT$(HHكH;HL$(HMLLT$`LM+IML\$PICH$   IHH3H+LIAu33ILcHl$L$   L$  IՃtH&IHD$LL$(HHكH;HL$(IMHE3Ld$0Ld$ EL$HujHuefff     HHH3H+L;tIIILd$ |IuE3L$   Ld$0.M;H$   HL$ HML Ld$0E3E3LT$`L\$P$@  fW   L;ADL;DDHcII+IcHHHM<M;L$    L$  L$8  L$  )$  )$  D)$  H$0  IID)$p  D)$`  D)$P  HH$   ID)$@  D)$0  D)$   HH$   ID)$  IHIH$   H$0  IL    IHK<1HH|$pH$   HIHIHHT$(IT$HIIL$0  HML$   N&H$0  N$1ILd$ MIH$8  O,0HJ42L$   H$   IH$   HLM+LL+HI+HD$XH+IH+D$0L4$LL$HHHL$hHHHD$    D$D$f(E3IfD(fD(fD((sc fD(fD(fD(fD(.  MLML$   ML+L+L+MLL$LL$XHVHl$LIML$   LHGH$   M+LL$ML\$M+L$   LL$hLL$   ML$   L$   L+LL$xLL$HLH$   LL$@MJHt$@IIN    LT$8LT$xff     A08H I H H If(f(Y@YIXDXf(YBAYPf(DXDXBT!BYL0DXf(f(Y@YIXf(DXBYD8Y\(DXDXB\*f(f(Y@YIXf(DXBYDYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   DT$DL$H|$pH$  H$   Ld$ L$   L|$8L4$M;}uILMILH+L+L+JI+AHHf(f(Y@YLXf(DXAYD AYTDXDXuDT$DL$M;$  H$   HE  H  H   M;  L4$III+LMHLH+HL+L+HJfB(0f HHfYfDXfDfYfDXfBD fYfDXfADfYfDXu)  L;$   fB(DfC(LMfG(|f)$   f)$   U  JHHHD$8KDLfD(fD(Hl$8HD$@H$   L\$@I+H+HH+L+HNLO|HM4f     fA(qfA(fA(oI I fA((fB(
EI H HfYfYDf(fAXfDYfAYfAYfF(T	fE(KfD(fAXfAXfDXf(EfA(fE(fYAfD(fA(CfAXfYfYfD(fDXfDXfD(fDX4DL$DT$$@  L\$PH$  M;  L<$III+LMHLH+HL+L+HJfff     fB(8f( HHfYfDXfDfYfDXfBD fYfDXfBDfYfDXu  M;  L4$III+LMHLH+HL+L+HJff     fB(0f( HHfYfDXfDfYfDXfB(D fYfDXfBDfYfDXu~M;}yL4$III+LMHLH+HL+L+HJאfB(0f( HHfYfDXf(DfYfDXfB(D fYfDXfB(DfYfDXufA(fADXfA(AXfADXfA(EXfADXfA(EXfADXEXL;M  HI+H  L$MLLL+L+L$   MOL+JTKLLD$8LD$XJDH$   LLD$xLM+LD$@MM+L$   LD$hLL$   MLd$xL$   L+L$   LD$HLH\$8LD$LHl$@Ht$M+IIIOL$   LT$L$   B8H I H H If(f(Y@YIXDXf(YBAYQf(DXDXATBYL0DXf(f(Y@YIXf(DXBYD8Y\DXDXA\f(f(Y@YIXf(DXYD)BYTDXf(DXY@Xf(BY\YBDXDXLT$`L\$PH$   H|$pH$  H$   Ld$ L$   L|$L;}kL4$ILMHLH+L+L+I+JB0HHf(f(Y@YLXf(DXBYD BYTDXDXuH$   H$   L$   fWYDYX9L$   HT$(DYDY9EXHD$XHD$hHD$HEEXEDXL4$LH$   DHLHLH$   L4$HHLLHl$H|$pHT$(L$   H$   Ld$ H$   L$   L$   VL$   L$  L$  D($  D($   D($0  D($@  D($P  D($`  D($p  D($  ($  ($  HD$0M;  H$8  H$  H$  (%XX H    H$  IHH$0  L$IHMD LLIIIM+L$  fffff     3If(f(|jIRHKI@HI4HH<    HH H HYIY@Xf(HX@YIYAXXuI;}&IIIH+HHY@XuM;   AAu@M;}|IKII+HHHff     f(HHfYAfXuAM;}<IKII+HHHff     ff(HHfYfXuf(fXXL;I   HI+H|wHJLKDI+I4HHHI<ff     H0H H HYIY@Xf(HX@YIYAXXuH;}&HIIH+HHY@XuH$  fWYMH    LAX$A$MIHD$0HtfWL$  E3L3HD$0Hĸ  A_A^A]A\_^][LD$HT$HL$UVWATAUAVAWH`  Hl$ H  )0  )   HIMLHD)  D)   D)   D)   D)   D)   D)   H;v轈L  3IHDH  L3HIDH   H    H=   E Ity3H|QLON    IJIIJ    HIH HAHIHAHIHAHIIHAuH;}J    HHHH;ID|L  D  fEWHOMN    HHM IHU8HE8    HE HNIIҋI+ѸH#I+IHHU0   H   IO49HI+M]H   HMHH   IMI+MH]xHE(M+II+L}MHEM+   I+LUpL]`H   HL   I+L}8HU H   HCLu@LeH;  f(=S fE(fE(HMKfD(H+fA(EYGY;H  AEEfDAfDAu&IH  LEXHHكH;HMXICHLHfA(I+fA(LEPHI@H   IYBYL0lAXCAXACf(AYXACY,;LAXI;#  IH+H  HM8H}I@LE HEhH   I\ IJL]0NL LE0HE(IHH  ILu(H+ILEH}XH  LeXfD  IAAAII H AYAYaXH CXLCLKf(YIAYAXf(AYXADAYXAXL9AL9CD1YAYDXAQXf(f(AYAYXBXL!BL!f(BYTBY\XAQXAYf(AYXAXLALYSYcXXL;}hH  LEPL]`Lu@LeM;scIIO,MH+JI+HHAYf(AYXBXLBLBD YYDXXuOL L;s{LeHII+I+HHII+HMHff     fAffIHHf(fYfAYfYfAYfAXYfDXfXfXfA)YuH;  H]HH+H  L]N<HGN$+KMH]PL  H  H}PHEhILLuMLHDL+O<+ffff     YP!HH H I f(f(AYAYXBD AYAXLALAYQAYYXPXYf(AYXBXL BL DYBYD XPXf(f(AYAYXBXL9BL9f(YT9Yd9XPXAYf(AYXCXLCLAYQAYYXXH;UhH  L]`Lu@H]H;sdMHN+IL+HH+BHHAYf(AYXBXL BL DYBYDXXuL   L   H]xf(fLE(LELE0XfA(XfADXAYAX{DXLeHMHL}8EYEXA{MLEpHEIIMIH]xLEpL]`L,    I   w<H   HHH;w
HHHA H+LT$ IIIbR LHM8H  H  L}H   HMML HHHL+HLL+H;   HE fA(fA(IHHMHHBY\f(AYDIK8AXAfH;},	HHf(YXDDAYLXHMHAYLLIAXQAQa}  t
H   PQ H  (0  (   D(  D(   D(   D(   D(   D(   D(   H@  A_A^A]A\_^]Hl$ WH H\$03Ht$8IHHtHJHͲ(_HF HH+FHHtbLd$@LgfHtHHͲ,IE*HF H+FHH;rcP HVIHN HF HH+FHH;rLd$@Ht$8H\$0HtHo)HHl$HH _§@SH Hr HHHIHtHP tHC    H [@SH  HD$ O HH         DBH$   M Hr H$   HHM HHM M HT$hH$   M HHL$({O HS HD$(HHL$@8N Hп
 HL$(5 HĐ  [HWH  HD$ HXHhHpIAHٺ   DBHL HH$   .HHlr HHUr Hȋ]L HH+r HHq HȺ   1L HHq ʧHȋL HH货HH$  褧HT$hH$   K HHL$(CN H3Q HD$(HHL$@ M HxQ HD$(H
 HL$(4 E  HWH  HD$ HXHpAHH   DBHK Hq H$   HHq ئHHͦHHq 辦HH賦HHaq 褦HȋJ HT$(H$   VK HT$0H|$HHCT$0H$   K HL$PM H
P HD$PH$   HL$hK HP HD$PH
 HL$Pp3 HWH  HD$pHXHpH   LAHr HL$H8K Lr HHL$ K H$  LHHAHL$ )K HL$HK Hr HL$ J HHT$ HHL$ J LHASi  C$  ;>  Hq HL$ J H$  HHT$ HHL$ J H
q HL$ gJ HHT$ HHL$ mJ w0fH*f(Yp H,ȉO4Y
p H,G8++w<Hgp HL$ J HHT$ HHL$ 
J    DBH$   I Hp H$   NHȋW4zH HT$HH$   H LHHAHL$HI Hj HL$ tI HT$ H$   H HL$ tI Heo H$   УHȋW<G HT$HH$   H LHHAHL$H(I Haj HL$ H HT$ H$   G HL$ H Hn H$   RHȋW8~G HT$HH$   H LHHAHL$HH LHASH$   G w0DG4DO8O<HHL$  I[IsI_@SH0HHQHI)t$ f(G HHG Ho H蕢Hf(G HG H(t$ H0[H%}G H\$WH HHQHIABG HH6G Ho H'HtF HG HH\$0H _H%G H\$WH HHQHIIF HHF Hn HǡHHF HF HH\$0H _H%F E   H\$Hl$Ht$WH HHHQHIIcIiF HH]F Hd HNHO8F    H;},fD  HOHn  H
F HH;|HF HO	F H\$0Hl$8Ht$@H _E  UVWATH(H\$PHc\$pIcILH   HQHILl$XL|$ E IHE HE HE LL   Lt$`L4    HNHVRE HM <E I~5H]I|$D  HNHm  HE HHuH
E HNE IIuLt$`Ll$XL|$ H\$PH(A\_^]HL$WH0HD$ H\$HHHdF HP HHSHO+E HH\$HH0_HL$WH0HD$ H\$HHHE HO HHSHOD HH\$HH0_HL$WH0HD$ H\$HHH4E HO HHSHOD HH\$HH0_HL$WH0HD$ H\$HHHtE HI HHSHO;D HCI HHH\$HH0_HL$WH0HD$ H\$HHHE HH HHSHOC HH HHH\$HH0_HL$WH0HD$ H\$HHHD HN HHSHO{C HH\$HH0_HL$WH0HD$ H\$HHHdD HLN HHSHO+C HH\$HH0_@SH Hk HH(HAHG H8D Lf LHKHtHP tHC    H [H\$WH HOk HH(HAHF HC L[f LHKHtHP tHC    @tH) HH\$0H _@SH Hj HH(HAHF HhC Le LHKHtHP tHC    H [H\$WH Hj HH(HAHE HC Le LHKHtHP tHC    @tH+) HH\$0H _H\$WH HH<e HHHJHKHtHPHGHCHGHCG C HH\$0H _H	( H\$WH 3HHHAHA HA(Ht0HH;vwHHCHC HHC(H\$0H _@SH HHIHt5( 3HCHC HC(H [H\$WH 3HHHAHA HA(Ht0H?H;v)wHHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht4HfffffffH;vvH诖HHCHC HHC(H\$0H _H\$WH 3HHHAHA HA(Ht7HUUUUUUUH;vYvH菗HHHCHC HȰHK(H\$0H _H8HD$    & HD$HHt3H3HPHtH
HPHtH
ƀ   ƀ    H8H\$Hl$Ht$WH IIHHu%3HHkHl$8HsHt$@HH\$0H _HH;vemH<    Hc? HuHtDmH\$Ht$WH IHHu3HHsHt$8HH\$0H _HH;vlH<    H> HuHtlHL@WHP  HD$0HhHpIHHHc$  L;      DBHL$`R< Hv[ HL$`HHHHS[ ֗Hȋ$  < HH[ 跗HT$8HL$`< HD$@H|$XHCD$@HD$ L
Z L$p  HH&L$P  IkIsI_@SH H+MHH    J H~LLHI= HH [@SH L+LIIJ    J
MtLMHE= HH [@SH H+MHH    J H~LLHI= HH [@SH L+LIIJ    J
MtLMH< HH [@SH H+IHH    H+H~LLHH< HH [@SH H+IHH    H+H~LLHHF< HH [HL$WH0HD$ H\$HHHt< H@ HHSHO;; HtH@3H^ HG@HKHOHHtHPHCHGPHCHGXC G`HZd HH@d HG@HH\$HH0_H@7  @SH Hd HHHv^ HA@HIHHtHP tHCH    H@? HKHc: HH [H%; @SH Hc HHHc HA@HAhHcPHc HD
hHAhHcPHc DBDD
dHH] HA@HIHHtHP tHCH    H> HKH9 HH [H%
; HcAH+Hx  H@ׂ  @SH Hc HHHV] HA@HIHHtHP tHCH    Hx= HKHC9 HH [H%: H\$WH Hc HًHH\ HA@HIHHtHP tHCH    H= HKH8 H$: @tHr  HH\$0H _HWH`  HD$0HXHhHp IIHHI@ I+@HL;      DBHL$`7 Hc HL$p蹒HH6 HH{c 螒HH,c 菒HHb 耒HHb qHT$8HL$`17 HC H+CHH$  HD$@H|$XHCD$@HD$ L
Gb L$  HHL$`  I[IkIs(I_HLH WHp  HD$0HhHpIHHL;$       DBH6 HH$   袑HH藑HT$8H$   5    DBH$  5 HT H$  WHH$  GHH$  7HHT (HH$  G5 HHmT HT$`H$  U5 HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
T L$  H胴L$p  IkIsI_HSH   fW)pD)Hf/fD(   u"5zI 3fDWfA(fW  I fA/v+fDW
HI fA(
SI \f(  fDW
I 3fA(aXY?   H )$   D)$   f/D)T$pD)\$`D)d$PD? D)l$@D)t$0D)|$   4c fA/vRfD.z  r u%c %S U %C AYDY
b AX  - u[b 
b -b  5xb =hb  
 - 5 = (= 5 - 
 v uaDb D%a D-a ~ D5a D D% D- D5 D fE(-D5  D- D%ޘ D͘ D fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X%` AYtu` fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [U` fA/v
>U fA/   uuD` D%
` D-_ З D5_ D=_ _ D% D%$ D-# D5" D=! ! -D= D5 D- D%ۖ Dʖ urF_ Dz 4 t _ l _ d ^ \ ^ T ^ L fA(fE(D\AYfWD fA(fA(AYAYI f(f(f(f(Y/ Y
 X
ߕ AXAYYYX
 AXAXYAYYX
 Xf(Y A^X AXYX` AYX^X] Yt] fA/    uuD] D%] D-r]   D5X] D=G] 7] D D% D- D5 D=  -D= D5~ D-m D%\ DK @ub\ @D   \  }\  e\  M\ ݓ fA(fE(D\AYfWB fA(fA(AYAYB f(f(f(f(Y Y
 X
p AXAYYYX
F AXAXYAYAYXf(Y6 AXA^X YXX
 ^Xp[ YyW[ fA/   xvD1[ D% [ D-[  D5Z D=Z Z DJ D%I D-H D5G D=F F -D=3 D5" D- D%  D rcYZ D   .Z  Z  Y  Y ~ fE(fA(D\Y AYfW@ fA(fA(AYAY? f(f(f(f(Y] Y
% X

 AXAYYYX
 AXAXYAYAYXf(YӐ AXA^X YXX
 ^XX Yv 	   DX D%X D-X 	Ǒ D5X D=X uX 
eX D D% D- D5 D=  
 -D=ŏ D5 D- D% D 
rsW 
D.  ( W   W  W  pW  XW   fE(fA(E^AYfA(fA(fW> AYAY- f(f(f(f(Y Y Y
 X
 AXAXYYYX
] AXAXAYYYX
. AXA^Xf(Y< X$ YX AYX^XcV YLHLH WHp  HD$0HhHpIHHL;$       DBH( HH$   rHHgHT$8H$   (    DBH$  ( HG H$  'HH$  HH$  HHuG HH$  /( HH=G ؃HT$`H$  %( HD$hH$   HCD$hHT$@H|$XHCT$@HD$ L
F L$  H3L$p  IkIsI_HWH  HD$ HXHhHpIIHHٺ   DBHn' HH$   
HH/F HHHHF HHقHM HuHL HIH' H$  H衂HT$hH$   & HHL$(@) H0, HD$(HHL$@' H-, HD$(H!
 HL$( H8HD$  HtHtI HHHH8HVWATHP  HD$0HXHhIIHL   DBHL$`!& HHL$`ÁHHJ 贁HHV% HH1 蘁HT$8HL$`% HcHE $  HT$@H|$XHCT$@H$  HD$ L$  L$  ILHL$WH0HD$ H\$HHH' H* HHSHO& H* HHtH@3HDJ HG@HKHOHHtHPHCHGPHCHGXC G`H0P HH6U HG@HH\$HH0_H@H(GH(HL$WH0HD$ H\$HHH& H) HHSHO% H* HHtH@3HdI HG@HKHOHHtHPHCHGPHCHGXC G`HT HHT HG@HH\$HH0_H@z  HL$WH0HD$ H\$HHHHH HHJHOHtHPHCHGHCHGC G HS(HO(% HjM HHS HG(HH\$HH0_HL$WH0HD$ H\$HHHHKH HHJHOHtHPHCHGHCHGC G HS(HO(Y% HL HHXS HG(HH\$HH0_HL$WH0HD$ H\$HHH% H( HHSHO# 3HGHHGPHGXG`HM HHL HG@HH\$HH0_HL$WH0HD$ H\$HHH$ H|' HHSHOK# 3HGHHGPHGXG`H&M HH,R HG@HH\$HH0_LALIHH+HLIHHHHM   IIf(
~DHf(B~+HALR HH    fAX
fAXBI HuL;fX~fXM;f(fX}dII+H|>IJDI+HHHMfD  XHH HXHXHXHuM;}JM+XHIuf(M
   L;A~YI@H|5IHIAHHH   X@H HX@X@X@uI;}IL+X HIu@SH HR HHHQ HA@HAhHcPHQ HD
hHAhHcPHOK DBDD
dHHE HA@HIHHtHP tHCH    H>% HKH	! HH [H%J" HcAH+Hxu  H@u  @SH HH(HQ HAHyQ HHC@HcPHGQ HD@HC@HcPH;I DBDD<HH$ H! LHD LHKHtHP tHC    H [H(7u  HcAH+HP u  @SH HH(H4Q HAHQ HHC@HcPHP HD@HC@HcPHH DBDD<HH# H! LC LHKHtHP tHC    H [H(t  HcAH+HPt  @SH HN HHH6C HA@HIHHtHP tHCH    HX# HKH# HH [H%d  @SH HkP HHHNP HA@HAhHcPHP HD
hHAhHcPH_N DBDD
dHHB HA@HIHHtHP tHCH    H" HKH HH [H% HcAH+Hxs  H@s  HSH   fW)pD)Hf/fD(   u"51 3fDWfA(fW  1 fA/v+fDW
x1 fA(
1 \f(  fDW
M1 3fA(aX'   1 )$   D)$   f/D)T$pD)\$`D)d$PDL' D)l$@D)t$0D)|$   dK fA/vRfD.z   u%6K %{ } %k AYDY
K AX  U u[J 
J -J 0 5J =J  
 - 5 = (=ރ 5΃ - 
  uaD1J D% J D-J  D5I DD D%C D-B D5A D fE(-D5( D- D% D D fA(AYf(Yf(YXYXf(YXf(AYAXYYXAYAXAXYX^X%I AYtuI fA/wuD(|$ D(t$0D(l$@D(d$PD(\$`D($   ($   t
D\fA(D(T$pf(($   D($   H   [H fA/v
n= fA/    uuDKH D%:H D-)H  D5H D=G G DM D%L D-K D5J D=I I -D=6 D5% D- D% D urvG D \  LG  4G  G  G | F t fA(fE(D\AYfW- fA(fA(AYAYy  f(f(f(f(YW Y
 X
 AXAYYYX
 AXAXYAYYX
 Xf(Y A^X AXYX AYX^XF YtE fA/  	  uuDE D%E D-E   D5E D=wE gE D~ D%~ D-~ D5~ D=~ ~ -D=~ D5~ D-~ D%~ Ds~ @ubD @D+~ E %~ D ~ D ~ D 
~ }D ~ fA(fE(D\AYfW	+ fA(fA(AYAYr f(f(f(f(Y} Y
} X
} AXAYYYX
n} AXAXYAYAYXf(Y^} AXA^X<} YXX
} ^XC YyC fA/  ~ xvDaC D%PC D-?C } D5$C D=C C Dr| D%q| D-p| D5o| D=n| n| -D=[| D5J| D-9| D%(| D| rcB D{ F} { ^B { FB { .B { B { fE(fA(D\A AYfW) fA(fA(AYAYo f(f(f(f(Y{ Y
M{ X
5{ AXAYYYX
{ AXAXYAYAYXf(Yz AXA^Xz YXX
z ^X-A Yv| 	   DA D%@ D-@ 	{ D5@ D=@ @ 
@ Dz D%z D-
z D5	z D=z z 
z -D=y D5y D-y D%y Dy 
rs@ 
DVy @{ Py ? Hy ? @y ? 8y ? 0y ? (y fE(fA(E^AYfA(fA(fW& AYAY] f(f(f(f(Yy Yy Y
x X
x AXAXYYYX
x AXAXAYYYX
Vx AXA^Xf(Ydx XLx YX0x AYX^X> YLHH   )p)xD)@f(D)HD)PD)XD)`D)l$@D)t$0y D)|$    D
C D%C D-C y D5C D=C C DrC D
ay D%`y D-_y D5^y D=]y ]y D
\y D[y fE(?DKy D:y D=!y D5y D-x D%x D
x 5E fW\fD(Xf(f($   YD^fA(AYI $   Y
$ DYDYL$   DXx EXD(|$ DYDY^EXD(t$0EXD(l$@XA(sDYDYA({EXE(cEYEXE([EXE(KEYE(CA\E(SIHH   )p)xD)@$   D)HD)PD)XD)`D)l$ D)t$Rx D)<$u
AB 
.x 0x 
x uoB B 5A x =A DA D
A w w 5w =w Dw D
w 2D
w Dw =yw 5iw Yw Iw %1    D0A D%A D-A Mw D5@ D=@ @ Dv D%v D-v D5v D=v v %v fD(6D=v D5v D-|v D%kv DZv DIv $   L$   f(\\-0@ $   \-@ \f(YYf(AYE(KX$   YXf(AYE(CYXA(sYf(AYD(<$XXAXD(l$ YAXf(E([Yu YA({AXD(t$YAXE(cYAXE(SX^YY->? Xf(I@SH HD$0    HH [LD$SVWH0HD$ IHHH\$PH;t+H\$XH\$(Ht
HH%
 H(H\$`H(HH0_^[HATH`  HD$0HXHhHpHx IMHHHY H+YH|C;}HH;r
 HFHj   DBHL$` Hc1 HL$pfHȋ6 HT$8HL$` LL$@H|$XLCL$@Ld$ DǋH
> &L$`  I[IkIs I{(IA\HATH`  HD$0HXHhHpHx IMHHLQ L+QH*IHHHH?H|#G;}HH;r H[HHFj   DBHL$`
 HU0 HL$peHȋ(
 HT$8HL$`
 LL$@H|$XLCL$@Ld$ DËH
= L$`  I[IkIs I{(IA\LD$SVWH`HD$ IHHH$   HL$0	 H;t?H$   H\$(HtHT$0H
 HH	 H(H$   H(HL$0
 HH`_^[HL$WH0HD$ H\$HHH L} LHGHCHG HC H. HC(HO0HK0HtHPHG8HC8HG@HC@GHCHH'= HH
= HC(HH\$HH0_H(Wg  HL$WH0HD$ H\$HHH
 H
 HHSHO	 3HGHHGPHGXG`H8 HH8 HG@HH\$HH0_@SH Hc< HHH- HA(HI0HtHP tHC0    H8 HHH [H%
 @SH Hs< HHHV< HA(HAPHcPH#< HD
PHAPHcPH; DBDD
LHHl, HA(HI0HtHP tHC0    H HHH [H%l	 H(e  HcAH+H`e  H8MPE3MtIMH\$0H      ffffff     IcAD$PHD$PH#H;tIM;rH\$0H8H' HD$(Hg' HD$ @SH0fW)t$    f/f(vfW5 f( 
Y H,f(t
X\f(\f(f/- v\f(Y- f(Z fnY(t$ YH0[HH   )p)xf( f(D)@D)Pf/fEWfD(fA(vf( fWN c  fA.zR  fA.zE  D)$   D)\$`D7 fA/D)d$PD)l$@D)t$0D)|$   D
 D2 fA/r6fff     fA(A\Xf(G fA/Xsf(A\o    ) 
) %( no D( D
( D( D%( 
o 
o %
o D	o D
o Do D%o <D%n Dn D
n Dn %n 
n n    ( D5( D=' n =n ' Dn ,n ' D5n n ' D=m 
n r' fE(m D=m D5m D-m f(AXYf(YAYAXYXYXf(AYAXYXf(Y
m YX
sm Xf(YYgm X
Gm XGm YAXYYAXYXAX^YY5& XV  D

 fD/vf( fA(fD(\AXG& f/  m    & 
& 5% l D% D% D%% D-% l 
l 5l Dl Dl D%l D-l <D-l D%k Dk Dk 5k 
k k ux$% D5% D=% 1l Qk $ D
(k @k $ D5k /k $ D=k k D=j D5j D
j fA(fA(AYYf(AYAXYXYXf(AYAXYXf(Y
j AYX
j Xf(YYj AXXhj YAXYAXAYX^YY%# X  k uq%# # 5z# j D`# DO# D%># %i i 5i Di Di D%i 3D%i Di Dni 5^i Ni %>i  uz
" D-" D5"  7j D=" 
h 
n" 
h 
V" D
h 
h D-h D5h D=h $D=h D5h D-uh D
dh DYfW- f(f(YYf(AYAXYXf(AYXYYf(Y
@h Xf(Y(h X
h XYAXAXYYAXAXYX^AYDYR! AXD(t$0D(l$@D(d$PXD(\$`D($   D(|$ f(L$   A(sA({E(CE(SIH\$Hl$Ht$WH HIIH+HIHHHH+HHHHKH;s&D  CHCf/wf/wHH;rH;   HH+HHHHH|vfD  	f/   f/wzIf/p  f/f  If/N  f/D  If/,  f/"  HGH H;|H;sf/wf/w	HH;rLLL;C  HI+HHHHH   IPAf/w#f/  HHI;t
 A JLRf/w#f/  HHI;t
 A
f/w"f/d  HHH;t JLRf/w#f/8  HHI;t
 AHGI H L;L;s7Af/wf/w"HHI;t
 A IL;rL;vFIQ    f/wf/w$HH;tHHIHI;rL;   L;   I;tH;tHHILHHIL;'HAIHHHI;I2I)IL;u8HL;tHAIHH;HHM;tIA I AI~Ht$@H] H\$0HMHHl$8H _M;   H\$H|$IMHI+HH|WLHII+ODL+HJTHHMI@H I HHBIDHBI@HBI@HBuM;}"HHH+JM+HHIHAuH\$H|$H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3AY@@MtIJHtH3AY@@MtIJHtH3AY  MtIJHtH3AH HY@@dM;};HM+HJMtIJHtH3AHIY@@uH\$H\$WH H tH HH\$0H _H\$ UVWH0I@ 3II+@HHHHtbLd$PLl$XI      IH;r HOD$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]HZ" LLHD$(H( HHHD$ 耈HH   - )pD)@D)XD)`D)l$@b fD(D)t$0D)|$    N- %>- -.- b 5- D%- D-, D5, D=, , Ab , a 1b , %a !b i, -a b I, 5a b ), D%a a D-a D5a D=a a f(DD=a D5ua D-da D%Sa 5Ca -3a %#a 
a D  u\+ ~+ ea ` ]+ ` ` =+ ` ` D` j` uy+ * ` ` * _ ` * _ * _ * _ m* _ )$   D)$      <* ,* D
* b` :_ ) fA(-_ ) 
_ _ ) D
$_ _ ) =_ ^ =_ D
^ fD. zu
fA(  R) D)T$pfA/  EYfA(AYfD(f(Y_ DY_ Xh_ DXg_ YDYX>_ DX=_ YDYDX_ AXYDYAXEXYDYXEXYDYXAYDXDYDXf(Y
t^ DXf(Y[^ X
K^ X;^ YX
'^ YAYXXD^   E^fA(D\!( fA(AY fD(fA( YDYf(X=n] DX
]] Y
] D^X
] f(Y] YYX=$] X
T] YYDYXG] X=\ X
] DX
\ YAYDYX] AXAYX=\ X^DYfA(D(T$pD($   ($   D(l$@L$   A(sE(CE([E(cD(t$0D(|$ IHH   )pD)HD)PfD(D)XD)`D)l$@u^ D)t$0D)|$   ( 
( ( @^ %( -( 5p( D%_( D-N( D5=( D=,( ( ] ( 
l] l] ] ' %\] ] ' -L] ] ' 5<] ] D%3] D-2] D51] D=0] 0] LD=] D5] D-\ D%\ 5\ -\ %\ \ 
\ D
 ub& & \ D\ & ,\ 4\ & D
;\ #\ & \    c& S& \ [ 2& [ [ & [ % z[ % r[ % j[ % b[ )$   D)$   uz% Dt% fA([ Z N% DZ Z -% =Z Z 
% Z $ }Z =Z DrZ fWfE(fD.fDTS z  # fA/  EYfA(D$   AYfD(f(DY
[ YZ DXZ XZ DYYDXZ XZ DYYEXAXDYYEXAXDYYDXXDYYDX$   XYDYDXf(Y
Y DXf(YY X
Y XY YX
Y YYXX
Y D^EY   E^fA(D\
b" fA(AY- fD(fA(< YDYf(X=X DXX Y
Y D^X
Y f(YX YYX
X X=X YDYYXX X
X DXWX X=GX YAYEYXX AXYXX
\X ^DYfA(D($   ($   D(l$@L$   A(sE(KE(SE([E(cD(t$0D(|$ IH;   Ht$WH0H\$@HYHHH;   Hl$H   )t$ H+ 3Hf/v+HT+HH~HLH+LHR 7.CHCf/vD  @HHf/w1HH;u(t$ Hl$HH\$@Ht$PH0_@SH HD$0    誰HH [@UHMILH;u2H]Ht$0L$$<-AEu<+uHHH+H}Ht$0L$$2H]H\$(H\$@3H+DHL+ِD D:tE:uDAHArHL;   IH+H|D$X8uD$`A8B   2   LT$PL\$HH|$Hu5IIDH+H+HD  D D:tD:uAHAr+Hu|L+L+fD  B:tB:uaHrEuH HHM 'H H        D$ HD$ H3HE H|$H\$(Ht$0L$$H]2EuH HHM Hv H        D$ HD$ H3HE HVWATHP  HD$0HXHhIIHL   DBHL$` HHL$`SDHH
 DDHHVg HH (DHT$8HL$`x HE H+EHH;r HEHH$  HT$@H|$XHCT$@H$  HD$ L$  L$  IZM;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDB\DCD|HL$WH0HD$ H\$HHH H HHSHO H HHtH@3HT HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@gi  HL$WH0HD$ H\$HHH H HHSHO H HHtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@gi  @SH H HHH HA@HIHHtHP tHCH    H8 HKH HH [H%D @SH HK HHH. HA@HAhHcPH HD
hHAhHcPH DBDD
dHH|
 HA@HIHHtHP tHCH    H HKHi HH [H% HcAH+HxPg  H@Gg  @SH HC HHH	 HA@HIHHtHP tHCH    H HKH HH [H%$ @SH Hs HHHV HA@HAhHcPH# HD
hHAhHcPH DBDD
dHH\	 HA@HIHHtHP tHCH    H& HKHI HH [H% HcAH+Hxf  H@f  H\$WH`)t$P)|$@D)D$0fD(f(Af   f(fYEYD)L$ fW=S D
 fA(\AYYd  fA(YY f(Xj f;vGfffff     f(ffA(YAY\fn^f(YXf;rH\$p(t$P(|$@f(D(D$0D(L$ H`_HH   D)@D)PD)XfD(D)`Q uy
c S C Q 
rQ 
" zQ 
 
bQ 
 
bQ 
 :Q 
ZQ JQ D%A fEWҨuk 
 /Q P o 
P 
W P ? P 
P D%P DP     
 P P  
O 
 O  
O 
 O t 
O 
\ O 
O    4 
$ +P 3O  
+O 
 #O  #O  
O 
 O D%O 
N z ujf 
V O uN 5 
mN 
 eN  eN 5N 
MN DTN  uj 
  /O M  
M 
 M o M M 
M D%M @ur: 
* @N !M 	 
M 
 M  
	M 
 M 
M D M xs 
 JN rL b 
jL 
J bL 2 
ZL 
 RL 
RL D%QL D)l$@rD- D-K M 	D-K 	r 	K M 
)$   r5 
5K vM 5K D)|$ rD=G D=ZK DM 	D=IK )$   r= =K M =K 
D)t$0rD5 
D5J L 	D5J fE.fE(fDT zu
fA(  [ D)$   fA/rifA(L$   HL H
HL E3AY$   'Y5: fA(fD(fA(\AXAYA\YDY,  D- fE/rlfA(L$   HK H
WK E3AY$   a(Y= fA(fD(fA(XI \AYA\YDY   E^fA(AY$   fA( f(fA( L$   HI H
I E3f(&L$   HI f(XfD(H
J E3EYDY&\YDXfA(X Yh D^EYfE/v	DY
 fA(D($   D(|$ D(t$0D(l$@($   ($   D($   D(T$pD(\$`D(d$PH   LL$ LD$HT$HL$SUVWATAUAVAWHx  H$  D)$   MLLHAHL$t
LHL$8+HHD$HT$HHكH;HL$HMLL\$8HI+HIH\$@HCH$   IHH3H+LIAu33IHcHl$H$   H$  HփtH&HHD$LL$HHكH;HL$IMHE3Ld$L$$EL$Hu]MuXHHH3H+L;tIIIL$$|IuE3L$   Ld$,M;H$  H$HML Ld$3E3L\$8H\$@D$      L;ADL;DDHcII+McHHHIL;HT$  L$  H$  I)$`  )$P  D)$@  MIHH$   HD)$0  D)$   D)$  D)$   HH$   ID)$   D)$   IL    IM,1HH$  HIHHT$hIT$HH$   IIL4HL4$IL    HIIL$  HN$8HD$0IIM+Ld$xI+L$  L|$(HD$PH$  HLHOIMHL$0L$   H$   H+L$   H$  HL$0HL$H+L$HHHHL$HL$hfA(3IY	DfA(AY	fDDfDfA(Y
DfA(AYfDDfD  MKL\$0HI+MIHD$HIM+I+MIT$HD$XIHOH|$HHl$XH+HD$`ILFH\$`H+HD$pILd$pI+IH$   J    L$   HD$ ffff     IfA(fA(H I H fA(I ICYD2XAAYJXfA(IAYPXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(AYLXIIYBXfA(AAYHXfA(ICYD XAL\$8H\$@H$  H$  Ld$xL4$HD$ I;}MLMMIM+M+M+L+H+HIfA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuI;  H$   H  Hc  H   L;k  HT$(HMI+MMHL+HHL+L+HJސfBfBfB HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  H$   fG(dfF(lL;MfG(t  I+ILHLH+HL+M+KDHK\ NTKlM<Lfff     f(}f(fA("KfEYfEYI H fB(,fA(sf(H I HfAYfAYfAYEDfAXJfXfA(fD((fEYfAYfA(fD(eAfXfXfAYfXfAXfA)JfE(sfXfXfA)zBL\$8H\$@H$  L;  HT$(HMI+MMHL+HHL+L+HJff     fBfA(fA HHfAYfAYfAYfXf@fAYfXfXfXTf)Tu  L;  HT$(HMI+MMHL+HHL+L+HJ     fBfB(fB HHfAYfAYfAYfXf(@fAYfXfXfXTf)Tu   L;   HT$PHMI+MLHM+HHM+M+HKD     fB(fB(fB( HHfAYfAYfAYfXf(@fAYfXfXfXTf)TuH;H\$H  HH+H'  ILMH+L+ITHD$pIHI+HLMHD$ IM+H|$ I+IH$   ILLH$   H+HD$`ILd$`H+HD$XII+Lt$XIH$   JH\$pL$   HD$HfD  HfA(fA(H I H fA(I ICYDXAAYJXfA(IAYQXfA(QAYBXAfA(AYXIIY XfA(AYXfA(IY(XfA(AfA(AYLXIIYBXfA(AYLXfA(IYD*XfA(AfA(CYLXIIYBXfA(AAYIXfA(ICYDXAL\$8H\$@H$  H$  Ld$xL4$HD$HH;}MLMMHM+M+M+L+H+HJ9fA(fA(HHfA(AY XAAYXfA(IAYXQAYXAuH$   HL$hL$   H$   L$   HLHLH$   HL$hL$   HD$PHD$(H$   HD$0LLLHHl$Ld$xL4$H$   L$   L$  HT$H$  D($   D($   D($   L$  D($  D($   D($0  D($@  ($P  ($`  HD$fD  I;  H$  HMIH$  MkL    HM2L+HH$  LL+L$fA(E3IAY$f||ISIHHGHHL    D  f(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuM;}.IIJH+I+f(HHYDX@@uCuHL;}   HIJI+H+HHH    f(HHfYfX@f)@u>L;}9HIJI+H+HHH fHHfYfX@f)@uH;H   HH+H   HMILH+L+HDHHHH4ff(f(H H HYAX@@f(AYLXHHf(YAX@@YIXHHuH;}.IHHH+H+f(HHYDX@@uH$  MMH    LIHD$Ht!H$  L$  3L3HD$3D($   Hx  A_A^A]A\_^][M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCD|HL$WH0HD$ H\$HHHd H HHSHO+ HK HHtH@3H HG@HKHOHHtHPHCHGPHCHGXC G`H HH HG@HH\$HH0_H@]  HL$WH0HD$ H\$HHH H HHSHOk 3HGHHGPHGXG`H HH  HG@HH\$HH0_HL$WH0HD$ H\$HHH$ H HHSHO 3HGHHGPHGXG`H  HH  HG@HH\$HH0_@SH Hc HHHf HA@HIHHtHP tHCH    H0 HKHS HH [H% @SH H HHH HA@HAhHcPHS HD
hHAhHcPH DBDD
dHH HA@HIHHtHP tHCH    H HKH HH [H% HcAH+Hx[  H@[  @SH H HHHF HA@HIHHtHP tHCH    Hh HKH3 HH [H%t H\$WH H HًHH HA@HIHHtHP tHCH    H HKH H @tHb HH\$0H _HHXHpWH   )p)xfW3H5d{
D)@D)HD)PfD(fD(fD(EYDYD)XDY D fD  fA(Y3Н AXf(AY! HHY3X ^Xu(t$pL$   AYE(CE(KE(SI[Isf((|$`E([I_HL$WH0HD$ H\$HHH H HHSHO{ HtH@3H> HG@HKHOHHtHPHCHGPHCHGXC G`H  HH HG@HH\$HH0_H@HL$WH0HD$ H\$HHH H HHSHO 3HGHHGPHGXG`Hf HHL HG@HH\$HH0_HL$WH0HD$ H\$HHHt Hl HHSHO; 3HGHHGPHGXG`H HH  HG@HH\$HH0_@SH H3 HHH HA@HAhHcPH  HD
hHAhHcPH7 DBDD
dHH| HA@HIHHtHP tHCH    H HKHi HH [H% HcAH+Hx`  H@`  @SH HD$0    jHH [HE3LLL9QLT$S  H\$H<$fff     ICHL$ HT$I;HD$ HME3H9H   H_fMtI@HtH3IH@IISIHMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIHDMtI@HtH3IH@IISIIL;HDDL;}3MtI@HtH3IH@IISIIL;H|IM;SLT$H<$H\$HM;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBu@SLLHL$MBIBHT$ L;LD$HD$ HME3HH   H|$H{MtIAHtH3IRI
H@HIHMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIHDMtIAHtH3I
H@IPIRIIL;HDAH|$L;}3MtIAHtH3IRI
H@HIIL;H|[@WH0HD$ H\$PHt$XHH3H\$@HJHt3HHT$HP(HH\$@Ht
HHPHL$HHtHP HFHGF G HFHGHOHtHP tHG    H_Ht
HHPHt	HHP H\$PHt$XH0_@SHPd- )t$@HѨu+ ! X% ?- Y '- - I(3fnY   HBHl$`HjHt$hH|$pH4   )|$0= D)D$ fEWHfHH(fTfA.zt	Х XHHuD(D$ (|$0H|$pHt$hHl$`f((t$@HP[@SH HHIHt H3HCHC HC(H [ H\$Hl$Ht$WH0Hi HH9iv H3Hl$(3Ht$ (D$ fD$ HuԾ LLH]I;[ wHtHHH;Xs HD$ Hu H8H;_ r Hl$HHt$PHH\$@H0_H\$Hl$Ht$WH0Hi HH9ivI H3Hl$(3Ht$ (D$ fD$ Hu$ LLH]I;[ wHtHHH;Xs HD$ Hu H8H;_ rؽ Hl$HHt$PHH\$@H0_H\$WH HHH;Qt>H	 HtH4H{HH\$0H _H    H{H\$0H _HQH\$0H _H\$WH HHIHHt HK03H{HH{PH{Xڣ HKHt̣ HH{H{ H{(H\$0H _鮣 H\$Hl$WH0LA HYHIHH+HH;wOHt$@I;v H?H\$(3H|$ (D$ fD$ Hu LLHI;[ wHtHHH;Xs^ HD$ HuN H0H;^ Ht$@r8 Hl$PHH\$HH0_H\$Hl$Ht$WH HcjHHH;it!H	 t
HHH    Hk~LFHHI謢 H\$0Hl$8Ht$@H _H\$Ht$WH HHI3HC    H+HHt6 HC H+HH;rZ HKHC HH+HHtH;rHKHt HHC    HC     HC(    ˡ H\$0HHt$8H _HATAUAVH`  HD$0HXHhHpHx ILLA   MPMM;3  fW@ 33E~4LE HcI;}%HM IIHf.z uHI;|AIIcI;   믺   DBHL$`s H3 HL$pHH HIHH HȍV̷ HHV eHAT$ HH HHT$8HL$` LL$@H|$XLCL$@IcHMHHcHHE LH HD$ II/L$`  I[ Ik(Is0I{8IA^A]A\D$Hx  HD$0)$`  f(HW fW f.z   3f/rHHr\#       DBHL$` H HL$pJf(HL$p3 HT$8HL$` HD$@H|$XHCD$@HD$ L
E L$  H H
 .($`  Hx  @SH H}LC L[xH [HL$SH0HD$ HD$P    EtH HAhH HAxD$P   {L LH HC@HChHcHHn HDhHChHcHDd    HH0[H\$WH H\|L L_xtH@ HH\$0H _H\$WH H HًHH@ HA@HIHHtHP tHCH    H
 HKH- Ht @tH HH\$0H _H\$WH HH   Ht莝 HKp3H   H   H   n HKXHt` HK@H{XH{`H{hK HK Ht= HKH{ H{(H{0H\$0H _ LSH   HǄ$   AC    HYH ICH# ICAC   HHL$ I H HD$ HSHL$8
 HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hl HD$ HP HD$`H$   HcHH H   H$   HcHǄ       H"*
 HL$ $ H8MPE3MPMtYMH\$@H|$0H      Hff     IcAD$PHD$PH#H;wIM;rH\$@H|$0H8H HD$(Hr HD$  H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
P
 H L
 H HD$ q̃y +LAH

 H L
 H: HD$ @̃y  +LA H
 H L
 H HD$ ̃ 'H
 H L
| H HD$ HH8H8D$`LALA$AD$hHAD$pLIA D$xA y +LAH
X
 H L
 H HD$ q̃y +LAH
'
 H L
 H: HD$ @̃y  +LA H
 H L
 H HD$ ̃ 'H
 H L
| H HD$ HH8HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHX HAxD$X   uH HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_@SH HD$0    ڌHH [@SH`
 )t$P)|$@f/Hf(D)D$0D)L$ fEWDs fA(rtfA(\f(f(莗 f(\f/
 vfA(A\XfA.zu  !   H     = Yf(R ^fA.ztf/5 rf(Hiu f/v*f     fA(fA(A\Xf/^XwfD/v*     fA(fA(^AXfD/\Xwf(HXf((t$P(|$@D(D$0D(L$ H`[@SH HD$0    躋HH [HL$WH@HD$ H\$`Ht$hIHHHL$XD  Ht*H\$(H\$0Ht
HH HH(H\$PH\$`Ht$hH@_H\$Hl$Ht$WH HH+HgfffffffIIHHHHH?HHHH+H;tH+H(HH H;uH\$0Ht$@HHl$8H _HMLH+HL+H;tL+D  HJHII;uI@SH HbLӳ L[xH [HL$SH0HD$ HD$P    EtH> HAhH HAxD$P   چL# LH	 HC@HChHcHH HDhHChHcHDd    HH0[@SH HrL# L[PH [HL$SH0HD$ HD$P    EtHn HA@H HAPD$P   ʇL LH HC(HC@HcHHn HD@HC@HcHD<    HH0[@SH HrLs L[PH [HL$SH0HD$ HD$P    EtH HA@H3 HAPD$P   誇L[ LH9 HC(HC@HcHH HD@HC@HcHD<    HH0[@SH HҌLñ L[xH [HL$SH0HD$ HD$P    EtH. HAhH HAxD$P   誅L LH HC@HChHcHH HDhHChHcHDd    HH0[H\$WH H蜉L
 L_xtH HH\$0H _H\$WH HLͰ L_PtH耒 HH\$0H _H\$WH H茊L L_PtH@ HH\$0H _H\$WH H\LM L_xtH  HH\$0H _H\$WH H HًHH  HA@HIHHtHP tHCH    H" HKH H4 @tH肑 HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHh HAxD$P   mH HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HǄ$   AC    HYH^ ICH ICAC   HHL$ ٩ HѬ HD$ HSHL$8 H HD$ HtH@3HT HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHHt H   H$   HcHǄ       H
 HL$ 訏 LSH   HD$ HAC    H" ICH ICAC   H| ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$P H5 HD$(H HD$PHD$hHcHH HDhHD$hHcHDd    Hw
 HL$(ю LSH   HD$ HAC    HB ICH ICAC   H ICHIIKHtHPHCHD$8HCHD$@CЉD$HHSHL$P H HD$(Hy HD$PHD$hHcHHD HDhHD$hHcHDd    H
 HL$( LSH   HǄ$   AC    HYH~ ICHӫ ICAC   HHL$  H HD$ HSHL$8 H HD$ HtH@3Ht HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHHl H   H$   HcHǄ       H
 HL$ Ȍ HL$WH0HD$ H\$HHt$PHH3|$XEtHS HAhH HAxD$X   }H7 HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@!HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhH HAxD$X   ~HO HH5 HC@HChHcHH HDhHChHcHQTdHtH~@HHK@aHH\$HHt$PH0_@SH HD$0    誙HH [@SH HrL3 L[`H [HL$SH0HD$ HD$P    EtH. HAPH HA`D$P   芘L LHy HC(HCPHcHHF HDPHCPHcHDL    HH0[H\$WH H輙L} L_`tH0 HH\$0H _H\$WH H HًHH0 HA(HI0HtHP tHC0    Hb HH6 @tH載 HH\$0H _H\$Hl$Ht$WH0Hi HH9ivɢ H3Hl$(3Ht$ (D$ fD$ Hu LLH]I;[ wHtHHH;Xsy HD$ Hui H8H;_ rX Hl$HHt$PHH\$@H0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH HAxD$P   ?zH HHm HC@HChHcHH: HDhHChHcHQTdHtH~@HHK@qHH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhH8 HAxD$P   _zH HH HC@HChHcHHR HDhHChHcHQTdHtH~@HHK@HH\$HHt$XH0_LSH   HD$ AC    HYH ICH ICAC   HIKE L L\$(HCHD$@HC HD$HH@ HD$PHK0HL$XHtHPHC8HD$`HC@HD$hCHD$pH HD$(H HD$PHD$xHcHHv HDxHD$xHcHDt    H
 HL$(裆 @WE3LHL9I   H\$HYfL;M}gMtI@HtHH3HtHA3H@HPLIIHtH3AHI^AIIH_L;|IL;O|H\$_H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(fY   MtI@3H@HMtI@3H@A   M;Hf(JfYI}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXN  HI+H   LSMtI@3H@HMtI@3H@HBBYXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@HBDBYDXMtI@3H@HMtI@3H@IM;HBDBYDX
L;}BMtI@3H@HMtI@3H@IL;HBLBYLX|f(H\$MtI@3H@HMtI@3H@HY   H;N  HCH   LS    MtI@3H@LMtI@3H@HAYXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HDAYDXMtI@3H@LMtI@3H@HI;HDAYDXH;}AMtI@3H@LMtI@3H@HH;HLAYLX|H\$f(HL$WH0HD$ H\$HHt$PHH3|$XEtH HAPHX HA`D$X   H HH HC(HCPHcHH HDPHCPHcHQTLHtH~(HHK(HH\$HHt$PH0_H\$Ht$WH 3HHt$0 L  LHCHGHC H\$8HG Hw0Hw8Hw@Ht$@H GHHH HG(HH _HhI)|$@9|$pHD$pI#I      I;v*LH
*
 H L
̷ HR HD$ D)D$0fDnEDD$pHD$pI#I;u*H
 H LH^R L
w HD$  A 'H
 H_ L
P HAR HD$  fn)t$P5e ^~ 
 X
P A\D(D$0\Y(t$PYY=4
 X(|$@f(HhHl$Ht$ WHPHA IHH+AHH  LH
 HQ )t$@fW(H      fnm l$`HD$`H#H;u*H
 Hy L
R HQ LHD$ f/w*H
 H- L
 HQ LHD$ D$`HD$`H#H;u*H
G
 H L
 HZQ LHD$ LO H

 HrQ L+OLH\$h)|$0IH]HG H+GHHuі H_H = H+   HH;^HF| 3f(HtVfnU 
 %q fffff     Hcf(HX\f(\fTY\H;r(|$0H\$hf((t$@Hl$pHt$xHP_fWHl$pHt$xHP_HhID)D$@DDD$pHD$pI#I      I;v*LH
 H L
i H:P HD$ 0D)L$0fDn
EDL$pHD$pI#I;u*H
 HE LHP L
 HD$ A f/< w'H
[
 H L
 HO HD$ 
)t$P5 ^3{ 
 X
 E\D(L$0\DY(t$PEYDY
 AXD(D$@f(HhATAUAVHpHA MLH+ALH!  HB H+BH
  LH
 HO )t$PfW6H

 HO M$A.f/w*H
^
 H L
ز HO MHD$ 	MD$ IU H$   M+D$I+UH$   IHH$   L$   H$   3I;Ht$hH|$`)|$@H=
 H$   Hl$0HCHO MHHLYHVO LMHYIE I+EHHuY ID$ I}I+D$HHu< Iu IL$ I\$I+uHH+HHH;w
HH+HA=    H;HF^y f(HtGr
 
 fHcf(HX\f(\YYYXH;r(|$@H|$`Ht$hH$   H$   f((t$PHpA^A]A\fWHpA^A]A\HWH  HD$ HXHHHH H H$   E3E33H$    H H$   HLCL+H$   
 A   E3H$   HL$0 HD$0HcHHL0    HD$0HcHdHHD$0HcHHDP   HHL$0 HHcQHB    HEHtHL$0f u2HL$0X H$    HL$0: H$   s 2H$   H  _M;   H\$H|$IMMI+HHH}   HILHI+MLHKLHM+HKDM@H H H^A@HA^LH@^A@H^IHuM;}3HHHHL L+M+JHIB^DAuH\$H|$HL$WH0HD$ H\$HHt$XHH3|$PEtH HAPH HA`D$P   OHW HH= HC(HCPHcHH
 HDPHCPHcHQTLHtH~(HHK(1HH\$HHt$XH0_LAMtI@3H@LPIHH+HLIHLIIM  MtI@3IH@Hf(fY   MtI@3H@   I;Hf(IfY}LMtI@3H@Hf(fYfXMtI@3H@HI;Hf(DfYfX|M;fX~"MtI@3H@HfB(fYfXM;f(fX   II+H   IRMtI@3H@HBYXMtI@3H@HBDYXMtI@3H@HBDYXMtI@3H@IL;HBDYXhM;}+MtI@3H@IM;HBLYX|f(MtI@3H@   L;HY   IBH   MJfD  MtI@3H@HYXMtI@3H@HDYXMtI@3H@HDYXMtI@3H@HI;HDYXlI;}*MtI@3H@HI;HLYX|f(H\$UVWH0I@ 3II+@HHHHtRLd$PI      H;r HOH@D$`HD$`I#I;t%HG HH+HH;rLd$PH\$XH0_^]Hz LLHD$(HH HHHD$ `H\$ UVWH0I@ 3II+@HHHHtfLd$PLl$XI      IH;r HOH@D$`HD$`I#I;w*HG HH+HH;rLd$PLl$XH\$hH0_^]H LLHD$(Ht HHHD$ 茟H\$LAMtI@3H@ HXHHH+HLHHLIIM  MtIP3HtHB3H@HHtHB3H@Hf(fYMtI@3IH@Hf(	fY  MtIP3HtHB3H@Hf(AHtHB3H@HfYAMtI@3H@A   M;Hf(YfY       MtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfBYfXMtIP3HtHB3H@HHtHB3H@HfB(TfBYTMtI@3H@IM;HfB(DfYfX,M;fX~dMtIP3HtHB3H@HHtHB3H@HfB(fBYMtI@3H@HfB(fYfXL;f(fX}iMtIH3HtHA3H@HHtHA3H@HBBYMtI@3H@IL;HBYDX|f(H\$MtIH3HtHA3H@HHtHA3H@H	Y
MtI@3H@   H;HY	}gMtIH3HtHA3H@LHtHA3H@HAYMtI@3H@HH;HYDX|H\$f(HWH`  HD$0HXHhHp IIHHM;H      DBHL$`΄ H HL$pHH( HHư HHw HH0 HH HT$8HL$`| HGH$  HD$@H|$XHCD$@HD$ L
 L$  HH?L$`  I[IkIs(I_M;D  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3AAOAYI\AAMtIBHtHH3HtHA3H@HHtH3ALAAYI\AAMtIBHtHH3HtHA3H@HHtH3AYI\AMtIBHtHH3HtHA3H@HHtH3AAI)H I HYI\AALd$0Ht$(Hl$ H\$L;}aIE L MtIBHtHH3HtHA3H@HHtH3BCIL;YI\CD|A]_M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAYAAXAAAMtIBHtHH3HtHA3H@HHtH3ADYAAXAAAMtIBHtHH3HtHA3H@HHtH3YAAXAMtIBHtHH3HtHA3H@HHtH3I)H I HYAAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;YACXDCD|A]_@SH HRL# L[xH [HL$SH0HD$ HD$P    EtH HAhH HAxD$P   LK LH1 HC@HChHcHH HDhHChHcHDd    HH0[@SH HLs L[xH [HL$SH0HD$ HD$P    EtH޼ HAhH3 HAxD$P   *L LHɶ HC@HChHcHH HDhHChHcHDd    HH0[H\$WH HL L_xtHpf HH\$0H _H\$WH Ho HًHHp HA@HIHHtHP tHCH    H HKH]~ H @tHe HH\$0H _H\$WH HLL L_xtHe HH\$0H _H\$WH H HًHH HA@HIHHtHP tHCH    Hz HKH} H~ @tH2e HH\$0H _LSH   HǄ$   AC    HYHκ ICH# ICAC   HHL$ I~ HA HD$ HSHL$8
} H= HD$ HtH@3HĠ HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H HD$ H HD$`H$   HcHH H   H$   HcHǄ       H	 HL$ d LSH   HǄ$   AC    HYH ICH ICAC   HHL$ )} Hɀ HD$ HSHL$8{ Hŀ HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H8 HD$ H HD$`H$   HcHH H   H$   HcHǄ       H>	 HL$ b HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhH؀ HAxD$X   H? HH% HC@HChHcHH HDhHChHcHQTdHtH~@HHK@QHH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHH3|$XEtH÷ HAhH HAxD$X   HǱ HH HC@HChHcHHz HDhHChHcHQTdHtH~@HHK@葹HH\$HHt$PH0_@SH HD$0    HH [@SH HD$0    ZHH [H   S
 D)$   fD(Ȩuy
 q a  
 
 
@ 
 ( 
 
 
 
 
 
 
  fWۨui 
 
 '
  

 
w 
 _ 
 

 
 
    ' 
 .
 v
  
n
 
޼ f
 Ƽ 
^
 
 V
  
N
 
~ F
 
F
    V 
F 
 
 % 
 

 
  
 ݻ 
}
 
Ż 
 
 
m
 % D)l$@D)t$0D)|$ umD-v D5e D=T 
 
; + D-
 D5
 D=
 
 
 %
 f(+
 D=
 D5x
 D-g
 -W
 )$    u[5   Z
 5

 5z %
 5
 5Z 
 5
 
 %
 @ui5$  @
 5k
 5 S
 5[
 5ӹ 5S
 5 5K
 5 5C
 xb5 w 
 5
 5U 
 5
 55 
 5
 5 5
 D)$   rD DX
 
 	DG
 	D)\$`rD 	D
 
 	D
 
)$   r=v 
=
 
 =
 D)T$prD= D
 z
 	D
 r5	 5u
 O
 5e
 
D)d$PrD%з 
D%;
 
 	D%*
 fA/v	fDW
 fD.zu	f(   fA/r^fA(L$   H]
 H
 E3AY$   Y= EXf(fA(\A\AYY7  DJ fE/rjfA(L$   Ho
 H
 E3AYY \$   覽Y5 EXf(fA(\A\AYY  E^fA(AYf/   f(fD(DY
 Y
 X
 DXDYYXx
 EXDYYEXXU
 DYEXYX7
 DYDXYXD^   f(^f(fD(DYYX
 EXDYYEXX
 DYEXYX
 DYDX
 YX
 DYDX
 YX
 D^f/   fD(f(DYc
 Y+
 DXJ
 X
 DYYDX(
 X
 DYYDX
 X
 DYYDX
 X
 DYYDX
 X
    ^fD(f(DY
 Yg
 DX
 X^
 DYYDX
 XL
 DYYDXr
 X:
 DYYDX`
 X(
 DYYDXN
 X
 D^fA(W f(fA(W f(fA(W - f(EY^X\AYAY\Yf(D(|$ D(t$0D(l$@D(d$PD(\$`D(T$pD($   ($   ($   D($   H   M;  H|$ AT
x III+LLHI  HH\$Hl$Ht$ N   II+ؾ   HHH+H+HIHMMtIBHtH3HtH3H@L*HB	fWBMtIBHtH3HtH3H@HBD	fWBMtIBHtH3HtH3H@HBfWMtIBHtH3HtH3H@H I HHHDfWBHt$ Hl$H\$L;}FI$MtIBHtH3HtH3H@IL;HBDfWBD|H|$(A\M;L}kHHLMtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBYDCXDCD|@SH HbLs L[xH [HL$SH0HD$ HD$P    EtH HAhHCs HAxD$P   L LH HC@HChHcHHf HDhHChHcHDd    HH0[H\$WH H謣Lr L_xtHT HH\$0H _H\$WH H HًHH HA@HIHHtHP tHCH    HJq HKHml Hm @tHT HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHq HAxD$P   HO HH5 HC@HChHcHH HDhHChHcHQTdHtH~@HHK@aHH\$HHt$XH0_HL$WH0HD$ H\$HHt$XHH3|$PEtHӨ HAhH(q HAxD$P   Hע HH HC@HChHcHH HDhHChHcHQTdHtH~@HHK@衪HH\$HHt$XH0_LSH   HǄ$   AC    HYH ICHsp ICAC   HHL$ k H9o HD$ HSHL$8]j H}q HD$ HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   Hh HD$ HL HD$`H$   HcHH H   H$   HcHǄ       H^	 HL$ hQ HL$WH0HD$ H\$HHt$PHH3|$XEtH HAhHHo HAxD$X   H HH HC@HChHcHHj HDhHChHcHQTdHtH~@HHK@HH\$HHt$PH0_@SH HD$0    ڢHH [@SH HD$0    :HH [@VM;MHL  II+HW  HH\$Hl$H|$ Ld$(J   I   II+H+L+HLHHMfMtIBHtH3HtH3H@KH
YAAMtIBHtH3HtH3H@HDYAAMtIBHtH3HtH3H@HYAMtIBHtH3HtH3H@I H HHHBD	YAA	Ld$(H|$ Hl$H\$M;}EHMtIBHtH3HtH3H@IM;HBDYBD|^M;  LMK ISSVAUH@IMII+HI{H`  HIkMcMsM{MM+A   HIH+N$   IL+I,ILK4HtHCHtH3HtH3H@I|- H9FM EHtHCHtH3HtH3H@HD9M EHtHCHtH3HtH3H@HB!L E HtHCHtH3HtH3H@HI)L H I IELl$xHT$hL|$ Lt$(Ld$0Hl$`I;}CH:HtHCHtH3HtH3H@H-L HI;D|H|$8H@A]^[H\$M;IML}L
MtIBHtH3HPHtHJ3HtHA3H@L HtH3CYAHtHB3H@IL;HBXDCD|H\$@SH HBLj L[xH [HL$SH0HD$ HD$P    EtH~ HAhHi HAxD$P   *L# LH	 HC@HChHcHH֟ HDhHChHcHDd    HH0[H\$WH H茞L]i L_xtHK HH\$0H _HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHh HAxD$P   蟗Hg HHM HC@HChHcHH HDhHChHcHQTdHtH~@HHK@qHH\$HHt$XH0_LSH   HǄ$   AC    HYH ICHCh ICAC   HHL$ ic Haf HD$ HSHL$8-b HtH@3H HD$`HKHL$hHtHPHCHD$pHCHD$xC $   H$ HD$ H HD$`H$   HcHHН H   H$   HcHǄ       H	 HL$ DI HL$WH0HD$ H\$HHt$PHH3|$XEtHÞ HAhHg HAxD$X   oHg HHM HC@HChHcHH HDhHChHcHQTdHtH~@HHK@葠HH\$HHt$PH0_HL$WH0HD$ H\$HHt$XHH3|$PEtH HAhHXf HAxD$P   诙H HH HC@HChHcHHZ HDhHChHcHQTdHtH~@HHK@џHH\$HHt$XH0_@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HDJD|H|$Ht$M;}%LIPI IHIIM;HJD|[HcAH+HcAH+鄩HcAH+THcAH+HcAH+餸HcAH+DHcAH+ԾHcAH+锷HcAH+餶HcAH+tHATAUAVH  HǄ$   HXHhHpHx IMLLH I]    I$IIP      DBH$   ] I$IIPH
/ H HEH$   5HHۥ &HI] HH HI\ HH} HH\ H$   H$   \ HHL$P^ Hb HD$PHHL$h=] H	 HL$PD I$IIP      DBH$   \ H& H$   QHH BHI6\ HHĤ 'HI\ HH HH \ H$   H$   [ HHL$P] H4a HD$PHHL$hY\ H	 HL$PD I$MHT$ IPH$   HT$@LHL$8L+IHF H+FHL;     DBH$   [ H H$   >HH /HI#[ HH HI[ HH. LH$   IH H$   ҵ(H$   3HL$@HHT$8H+HHtcHt,H$   ĳHL$@HT$8H+HH;r[ HT$8HH$   Y HHL$@HHT$8H+HH;r)H$   fH$   H$   Y HHL$P[ Hj_ HD$PHHL$hZ H'	 HL$P9B 3HM  fD  HF H+FHH;r9[ HT$@HL$8HnHH+HH;r[ HT$@HL$8HH9D uHHH+HH;r     DBH$   Y H3 H$   >HH /HI#Y HH HIY HH֠ HHX HH ޳LH$   Ik	H H$   跳(H$   رHL$@HHT$8H+HHtcHt,H$   諱HL$@HT$8H+HH;rY HT$8HH$   xW HHL$@HHT$8H+HH;r)H$   MH$   H$   W HHL$PY HQ] HD$PHHL$hvX H	 HL$P @ Ht? H\$8H\$@H\$HHL$ ? L$  I[ Ik(Is0I{8IA^A]A\H\$Ht$WH HA 3HH+AHHHta     HC H+CHH;rX HKH94t$HC H+HH;rX HKHX HC HH+CHH;rH   Ht"? H   H   H   H   ? H   Ht> H   H   H   H   > H   Ht> HKxH   H   H   > HKHHt> HK0HsHHsPHsX}> HKHto> HHsHs Hs(H\$0Ht$8H _L> H	H%W H\$Ht$WH@HB LI HH+BL+IHHH L HD$0Hٞ H
ƞ HD$(IHT$ HG Hs H+GH+sHHHu W HC HH+CHHuV HKLHH\$PHt$XH@_闅Hi HHIH%V H\$WH H? HHHIV tH,= HH\$0H _H\$WH HHH;t/HHL_(HWHKL[(	HW0HK0HH\$0H _@SH HHI0U HKU HKH [H%U @SH HHI(U HKU HH [H%U @SATAUH HZ LJLLHgfffffffLM+IHHH?H   Hl$@Ht$HH|$PL;vGU I4$Hu8U E3LI;[w$U HkI\$I;\$ vU I<$HtH;tT H;t`HuT E3LI;[ rT IMHIS H.{ H:HuT E3LI;[ rT H(IIMH S HS H S H|$PHt$HHl$@H A]A\[@SUAUH HZ LBHHLI+H  Ht$@H|$HLd$PL;v
T Hu HuS E3LI;[wS H}LcH;} vS H] fHtH;tS I;taHuS E3LI;{ rS IMR Hy HHutS E3LI;{ r`S HH2IMQ HQ HQ Ld$PH|$HHt$@H A]][@SH HHIS HH [H%R @SH HHI8Ht9 HK 3HC8HC@HCHn9 LsX LH [HL$ATH0HD$ H\$HHt$PH|$XHHٹ   M9 HtH33HHHw H+wHHKHK HK(Ht}HH;v(HKHHCHC HHC(Hw H9wvQ LgL;g vQ HKI+HH    H<
HtLMQ H{ HH\$HHt$PH|$XH0A\HL$WH0HD$ H\$HHt$PH   V8 3HtH8HHHwHw Hw(H_0   *8 HtHHHHsHs Hs(HH\$HHt$PH0_@SH0HD$ Hٹ   7 3HtHHHHKHK HK(HH0[H\$Hl$Ht$H|$ ATH@Hy0MHH_H{i u#HKIBO tH[HH{i tHH^0H|$(HD$ HtH;tKP H;tHWIN uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$WH HHIpHt6 HKX3H{pH{xH   g6 HK@HtY6 HK(H{@H{HH{PD6 HH\$0H _H%N H\$Hl$Ht$WH Hq HH9qvIO H{H;{ v9O H9{wH;{ v'O H+H9swH;s vO HtH;+tO H;t/HC H+HH    H,:H~LLHN Hk H\$0Hl$8Ht$@H _@SH03MM؈D$(D$@HLIMIHˈD$ 0@H0[HWHpHD$ HXHhHpHHH^M HHw H9wv3N H_H;_ v#N HHD$0H\$8(D$0fD$0H;tfD  HHL u	H(H;uHwH;w vM HD$0HtH;tM H+HgfffffffHHHHH?HHL$@L HL\$pI[IkIs I_@SH0HD$ Hٹ   44 HD$HHt3HSDIDH蔚LE3Mu3
IChHcHJDhH0[H(LALIHQ II+HH;|
L+II+IHAH	Ht3 H(@SH A   HD$0    HH [HSUVWATAUAVAWH   HǄ$   HE3D`L-Mo LhLpLxL`pED$H
 HHxL L5s L$   HBz H$   H={ H|$pL=P L$   Ǆ$0     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$XK Hw{ HD$0HS{ HD$XHD$pHcHH{ HDpHD$pHcHQTlIH$@  H$   HtRHH$8  P(HH$@  Ht
HHPH$8  HtHP H$8  IEH$8  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP H HD$@H HD$HD$P   
 X  p
 X   .1 HH$H  HtXHx@LxPǄ$0     HT$0H$Hz HHy HC(HC@HcHHy HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$H  HT$(HHL$(HH$H  Ht GuHHPGu	HHPLHHL$ SvHD$ H^
 HD$(HZ
 Ht/@H\$(Ht CuHHPCu	HHPH
B 0 H

 HE H
 HEHt@Hx HD$0Hx HD$XHD$pHcHHyx HDpHD$pHcHQTlLt$0HK H\$XHL$XH Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   H L$   H$   HtHP HHH   A_A^A]A\_^][LSUVWATAUAVAWH   HǄ$   HE3EcL-j MhMpMxMcAsHQ ICISIKH L5]o L$   Hu H$   H= H|$pL=[L L$   Ǆ$@     Ll$0H$   HL$8HtHPH$   HD$@H$   HD$H$   D$PH$   HL$X3G H+w HD$0Hw HD$XHD$pHcHHv HDpHD$pHcHQTlIH$X  H$   HtRHH$H  P(HH$X  Ht
HHPH$H  HtHP H$H  IEH$H  H$   HD$H$   D$PH$   HD$@HL$8HtHP H\$8Ht
HHPHt
HHP HT HD$@H HD$HD$P   
 X  
 X   , HH$   HtXHx@LxPǄ$@     HT$0H
 Hu HHu HC(HC@HcHHfu HD@HC@HcHDd<IHuLd$ HC@HcHHD@HD$ Ld$(HH$   HT$(HHL$(HH$   Ht GuHHPGu	HHPLHHL$ qHD$ H
 HD$(H޳
 Ht/@H\$(Ht CuHHPCu	HHPH
;= 2, H
 HE H
 HEHt@Ht HD$0Hbt HD$XHD$pHcHH-t HDpHD$pHcHQTlLt$0HG H\$XHL$X\D Ll$0HL$8HtHP HL$8IEHL$8L$   L$   H$   H$   D L$   H$   HtHP HHH   A_A^A]A\_^][HLH L@HPSUVWATAUAWH@  L$  H$  L$  D)@D)HH$  H$  L$  LHHIDIIMDE3HHH$  HHL$  HLH   IH\$hII+L$  H;HD$pILMHMH,L$HHMuL$  IHL+D$  fEWL$  )$0  H  )$   J    D)$   H$   E3IHKAO<D)$   D)$   D)$   H$   IID)$   D)$   HKܺ@   HD$xI$   Lt$@HD$8KH$  IL|$H\$ HD$(KAIHD$IHD$K@IĀ   HD$hHHL$0HHHD$`ffff     H$  J    H~XH$  H$  IIHJ         fWHfpDHHf)JuH$  HL$0M"  H$  LL$8N    AfDHLIfD)$   IDL$  HIHǀHI+IIIffff     H(: fD(fD(fD(fD(fD(fD(fD(f(f)D$PA	C
IH7  LEIIf(!fD(Af(f(Pf(X f(h@f(pPf(x`f(fAYfYfDXf(H0fDXf(fAYfYfDXf(Q fDXf(fAYfYfDXf(XpfDXf(fAYfD(D$PfYf(   fDXf(I0fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYfYfDXf(   fDXf(fYf(IPfYf(Q@fDXfDXf(fYfD)D$PfYfDXfD(   f(   fDXf(fYfYfDXf(   fDXf(fYfYfDXfDXf(fYfDXf(Y`f(   f(|$PfYH   f(IpfA(fXHIfYfDYfDXf(fEXfYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDXf)|$PfD($   I;   ML+D  f(!f(if(H f(Pf(X f(fYH@IfYfDXf(HfDXf(fYfYfDXfDXf(fYfYfDXfDXf(fYfYfXfDX{f)|$PfAAffZfA(H IfAYfAdfAiftI fzfXfA(H IfAYfA`fAhfA(fXfA(fAYfXfA(fAYfXfA(fAYfXfA(fAYfXfA(fD(D$PfAYfAYfD($   fXfApfTfTf`fhfA`fAhfApfXfAxftftfpfxfApfAxD$  fEWL$  H$  L$L$  H\$ H$  Lt$@H|$p/  L$  IHJ`H	f(5 If(f(f(H  HUHH    f(	f( H   H@HfYfXf(fYfXf( fYfXf(0fYf(IfXf(@fYfXf(PfYfXf(`fYfXf(pfYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYf(IfXf(@fYfXf(@fYfXf(@fYfXf(@fYfXI;}UIH+ff     f(	f( H@HHfYfXf(@fYfXf(@fYfXf(@fYfXuJAAffJf(f(fYf(fYfXf fYfYfXffXfBff[ffPf	fIfXfB$fBdL$  H$  L;?  H$  H$  L\$H\$H|$(IL4H$  IH$  ILL+$$L<    Ht$Lffffff     A	3IfA(fA(fA(fA(I   MBIIIIJ    fQYHH If(f(Y@YHXXf(Y@YPf(XXQYHXf(f(Y@YHXf(XY@YXXXYf(f(Y@YHXf(XY@YPXf(XY@Xf(YXY@XXI;}BAHH I;f(f(Y@YHXf(XY@YPXX|AYAYAYIHHHMIXffXoAYoXssAX{A{8L$H\$ Lt$@L|$H$   HL$0L$   HT$8HT$HT$HT$(HD$xL$  H$  H$  L$  L$  HHLHl$`H$  H\$ HL$0L|$Lt$@NH\$hD($   D($   D($   D($   D($   D($   ($   H$  H;  H$  HN4    IJ	M<HH$  H$  H+H<JH$  M$H$  HDH$  M~1IHIfW HfpDHHf)IuH$  M   L$  (5/ HIHAL$  IAfILIIA	f(f(IM~3ID  f(	f( HH HfYfXf(@fYfXufA@f(f(I LIfYfYfXfA@fAPfAPfXfAHfAHiL$L$  H|$p   L$  IL$  HJ@I	f(. M~)IIH+     f(HHfYAfXuAAffA$fYfXfA$fAL$L$  L$  H$  L;  H,    IIHIHMI+fffff     AE3IfA(|yIRLHOHM+I@HL    fffff     HAH H HYIY@Xf(HX@YIYAXXuM;}(HIKI+I+HHY@XuAYHLHXSS(L$H$  H$  H$  L$  H    MMHH$  IHH$  H$  ($0  L$  L$@  E(CE(KIA_A]A\_^][@WATAUH0HD$ H\$PHt$`HHHH;vIhHIHu3HC(H+HH;   HKLHD$XH{ H9{v2 LkL;k v1 I+HHtH    LMI1 HKH{ H+HHtu IHC(IHC LcH\$PHt$`H0A]A\_@SH0HD$ Hٹ   T HD$HHt3HSDIDHdLE3Mu3
IChHcHJDhH0[@WH0HD$ H\$@HD$H    X    HHD$PHttHko HG@H5 HGPD$H   HSH
H` HH` HG(HG@HcHHc` HD9@HG@HcHDADD9<HSHYo3Hu3
HG@HcHHD9@H\$@H0_@WH0HD$ H\$@HD$H    X    HHD$PHttHn HG@H5 HGPD$H   HSH
H0` HH` HG(HG@HcHH_ HD9@HG@HcHDADD9<HSHn3Hu3
HG@HcHHD9@H\$@H0_@SH0HD$ Hٹ   T HD$HHt3HSDIDH$LE3Mu3
IChHcHJDhH0[HHT5 3LL$XLD$`3)t$0)|$ D$XD$`51 =A fTf/v.  "   x 3LL$XLD$`3҈D$XD$`fTf/vn.  "   x 3LL$XLD$`3҈D$XD$`mfTf/v5.  "   ox 3LL$XLD$`3҈D$XD$`4fTf/v-  "   .x 3LL$XLD$`3҈D$XD$`fTf/v-  "   w 3LL$XLD$`3҈D$XD$`fTf/v-  "   (t$0(|$ HH@SH A   HD$0    DHH [@SH A   HD$0    ԋHH [M;  VAUIIMI+LLH  HH\$Hl$ L H|$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OAXAAAMtIBHtHH3HtHA3H@HHtH3ADXAAAMtIBHtHH3HtHA3H@HHtH3XAAMtIBHtHH3HtHA3H@HHtH3I)H I HXAAALd$0H|$(Hl$ H\$L;}WIE L MtIBHtHH3HtHA3H@HHtH3BIL;XACD|A]^LAMtI@3H@HHMtI@3H@LXLIHH+HLIHLIIM[  MtI@3IH@fo# Hf(	fT   MtI@3H@   I;Hf(QfT}LMtI@3H@Hf(fTf_MtI@3H@HI;Hf(DfTf_|M;f_~"MtI@3H@HfB(fTf_M;f(f_L$o  , II+H  ISMtI@3H@HHD$BfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$L$MtI@3H@HHD$BDfTf/D$wHD$IL;L$M;}FMtI@3H@HHD$BfTf/D$wHD$IM;L$|f(MtI@3H@?+    L;H	fTL$`  ICH  MKMtI@3H@HHD$fTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$L$MtI@3H@HHD$DfTf/D$wHD$HI;L$I;}EMtI@3H@HHD$fTf/D$wHD$HI;L$|f(@SH0HD$ Hٹh   
 HD$HHt3HSDIDHLE3Mu3
ICPHcHJDPH0[@SHPLQL	H)t$0Ap)|$ A8f.=#/ zuf.5/ zO  Hl$pHt$HH|$@D)D$D)$LT$`tM&HHD$`HT$hHHكL;HL$hHMLIDI+3HDHfDH+HII<CfD  ISMIIHL+HCHH4    fYP!H H Hf(f(YY\A\ YYXPPIf(f(YY\YYYXPPAL f(f(YY\YYPPXf(YYIf(YY\XPII;}NIIHH+H+HHf(f(YY\YYXXLuOLT$`AtI&IHD$`HT$hHHكL;HL$hHMH I;utL;  HII+I+HHHH     fA(f(IHHf(f(fAYfAYf\fAYfAYf)XfXfA)Hu  HHHHIL;   HIHI+I+I+HHIhHHfD  fAfm f(f($.f(I H H HfAYfAYf(fAYf\fAYf)RfXf(fAYfAYfAHfMf(fAYfAYfXf\fMf)d.fMoH;tAfAf(f(fAYfAYf(fAYfAYfXf\fAf)fALI;D($D(D$Ht$HHl$po  IH+H  IMITH+L+HDHHHH<fD  ZP"H H Hf(f(YY\A\ YYXPPJf(f(YY\ZYYXPPAL f(f(YY\YYPPXf(YYJf(YY\XPJI;}JL+HL+AHIf(f(YY\YYXXALuH|$@    (t$0(|$ HP[@SH A   HD$0    褐HH [H  HD$ HH$   P3HHL$(H#	 HL$(% H\$LAMtI@3H@HXHHH+HLHHLIIM  MtI@3H@HMtI@3IH@Hf(
fY	   MtI@3H@HMtI@3H@A   M;Hf(RfYQ}{MtI@3H@HMtI@3H@HfB(fBYfXMtI@3H@HMtI@3H@IM;HfB(DfBYDfX|M;fX~8MtI@3H@HMtI@3H@HfB(fBYfXL;f(fXM  HI+H   HSMtI@3H@HBMtI@3H@HBYXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@HBYDXMtI@3H@HBDMtI@3H@IL;HBYDX
L;}AMtI@3H@HBMtI@3H@IL;HBYDX|f(H\$MtI@3H@HMtI@3H@   H;HYA  HCH   LKMtI@3H@HMtI@3H@HYXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HYLXMtI@3H@HLMtI@3H@HI;HYLXH;}?MtI@3H@HMtI@3H@HH;HYLX|H\$@WHyLYE3LH  
$ fWH\$fD  3I   I[DRI;uf(f(IIIIHIBI;uf(f(IIIHIM;uf(f(IIIIIIBI;uf(f(IHIIIHH;I_I;}*I;uf(f(IIIIHHI;|IL;H\$_LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHǅ8  )@  MMHU8H  L(L}pHGH  L  LE8H;MMIH]XIIHN,    II;vHHHEHHuL$    I   w6H   HHH;wHHH H+HD$pHHHE1I HEHuMtGHIL  3H9HDH  H  H    H=     I;vBGHGHE HunH    H   w6H   HHH;wHHH3 H+HD$pHHHE 'H HE HuHtFI3H9_HDH   H(  H    H=   0  M;vFHGHEPHukJ    H   w=J   HHH;w
HHHy H+HD$pHHHEPH: HEPHuHtFE3L9WLDL   J    H=   E 3HUE3LE(IIH   IHH   3H}0L  IHM8IL  IHH   5}3 D  I;  H  HEpL  H9MpIML(L   ML L   I+H   IIHu LL   H~>KMHD$8    HD$0    HL$(Ll$ MIH  謏HULE(3M   HEH   IMIL  H  H~KHMHH  HHNIHMHD$8    Ll$0HHD$(H\$ MHH  9wHHII;HULE(|L  L  Hu H}03HMH  H  J    H   IHH   IHH   LEXIHH   LHUxH  LLUH L  H  LMXM;IMHE3ML   HE(HE`ML   LH   HH   LUhH}M;  Hǅ     LE@H  L]@IINH8H   HEML]@M~`HEPHD$hLt$`Lt$XLl$PLl$Ht$@H|$8Ld$0H\$(LL$ LMMIH  HMH  L]@LUhMH+  H  L4    MFN$    LxMIffffff     H  M(  LLHE`IIH  LH<I+H  I A3H   MAIJHCHHH    @ f(AYHA\Af(Y\f(AYHA\Af(AYA\AH I HuH;}0IMM+HH+f(BY  \ HHuMMIHH   H   MFL]@H  A3H|cIBHSHHH    ffff     @^@H^H ^ H^HH HuH;}A^AHH;|IMML;HML   L  E3HELH  LLd$8L   Ll$0H\$(H|$ MH}HH  vIL   H   HE`L   IH   LUhMLUhL   IL   L   L   L   HMH  wL   M~uH   IHHHEPHD$hLt$`Lt$XHD$PHD$Ht$@LD$8Ll$0H\$(H   HD$ LMH  HMH  LEXIHMLuxL   LuxLUHJ    LLUHH;  Hu H}0]L  HUHUpHUHM8H   HM8LE(L   LE(H   H}0L  L  ^}  tH    0   tH       t
H   (@  HX  A_A^A]A\_^[]M;   Hl$Ht$ WH HH\$0Ld$8L IIHHtHFHtHX3HtHC3HtH3H@H@ HtHC3H@HH;HYDAD|Ld$8H\$0Hl$@Ht$HH _@SH0HD$ Hٹ    HD$HHt3HSDIDHtLE3Mu3
IChHcHJDhH0[@SH0HD$ Hٹ   4 HD$HHt3HSDIDHԓLE3Mu3
IChHcHJDhH0[H\$HYLQE3LH   
 fWE3M~eHtHBHtH3HM;uf(f(HtH3H@(HHH II\IIIKIIM;|IL;|H\$@SH A   HD$0    HH [@SH A   HD$0    褡HH [@SH0HD$ Hٹ    HD$HHt3HSDIDH4LE3Mu3
IChHcHJDhH0[@SH A   HD$0    DHH [LWATAUAVAWHPHD$ I[Is MMLHIKIHIAHAIKI HI@HAICHtI;Ct

 Ht$8H+t$HHHCHu3H{(H+HH3  LS IH+HHHH+H;sBL1I;  HHH+H;s3HI;IBHKHMcLH$   IMLCI+HH    LL$   HtLH L$   HL$@IHIFHAHL$0IHIGHAHD$HLD$8I+HH    N4HtLI HS MEI+HHtHLI HKHC H+HHHt] IHC(IHC Lc   HL$@IHIFHAHL$0IHIGHAHT$HLD$8I+HHtHLI HK IULH;t!HL;tA HI IL;uHK HLI;t!II;tI HA HI;uHC HH;t HH;tHHHH;uHs L\$PI[8IsHIA_A^A]A\_M;   UVATH H\$@H|$HLl$PL*MIH@ HtHEHtH3HxHtHG3HX	HtHC3HtH3H@H HtHC3H@HYHtHG3H@8HI;HXDADeLl$PH|$HH\$@H A\^]@SH0HD$ Hٹ   T HD$HHt3HSDIDHLE3Mu3
IChHcHJDhH0[LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MMH0  LG(LEHGH0  L0  L   H;MMIHE(HIMLJ    HEII;v6L/HMusH4    H   w2H   HHH;wHHHw H+Ll$pII0H< LHuHt6HIE3IH9IDHEHH]PH    H=   EXM;v5HwHulJ    H   w2J   HHH;wHHH H+Ht$pHH)H HHuHtl5E3IIH HDHE`LehJ    H=   EpHUI;v*5LgMumH    H   w9H   HHH;w
HHH H+Ld$pII#H LHuHt4HUE3MH MDLE8H    H=   0  IM  HUHH   HHE0(  H   ff     HHUH   LEL;IML0L+LL$8LL$0H\$(Lt$ L  L  HHM RE3MH   H  LE(L  H   HM     K<H}@H   LE@H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM |Ld$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM LHM LE(J    HHM LH   H;A    )L   H   HMHEH  L}0L   L   I;HUmLE80  t
I }p tHM` }X t
HMH (   H   A_A^A]A\_^[]@SH A   HD$0    褢HH [LL$ LD$HT$HL$USVWATAUAVAWH  Hl$pHEx)   MH0  Lw(Lu HGH0  L0  L   H;MMIHEHIMLIII;v1L/HMusH4    H   w2H   HHH;wHHH H+Ll$pII0HG LHuHt%1HIE3IH9IDHEHH]PH    H=   EXM;v0HwHulJ    H   w2J   HHH;wHHH H+Ht$pHH&H HHuHtw0IE3IH HDHE`LehJ    H=   EpM;v90LgMuiJ    H   w9J   HHH;w
HHH' H+Ld$pIIH LHuHt/E3IH IDHU0J    H=   0  IL   M  HU HH   HHE@HL  IHHE8(  H   HHUH   LUL;IML0L+L\$8L\$0H\$(Lt$ L  HHM yE3MH   H   LEL  H   HME3K<H}(H   LE(H;IMHI+LL$8LL$0H\$(Lt$ L   LIHM wLd$h3HD$`HD$XHD$PHD$Ht$@H   HD$8Lt$0H\$(Ht$ ML   IHM żLHMLEJ    HHMLH   H;,L   H   HMHE8H  L}@L   L   I;HU L  A    oHU00  t
H }p tHM` }X t
HMH (   H   A_A^A]A\_^[]H\$M;IML}uL
MtICHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CD|H\$@SLQE3HIL   Ht$H|$H:IrfD  HWHIHMAIHDIPJHIHWIHDJDHWHIIIHDIPJDHIHWIIL;HD JD|H|$Ht$M;}&LIPI IHIIM;HDJD|[H\$M;IML   HL MtIBHtH3HPHtHJ3H	tHA3H@L HtH3CYAHtH3YB IL;CXDCD|H\$HcAH+HcAH+HcAH+HcAH+锯HcAH+dHcAH+THcAH+HcAH+HcAH+HcAH+D@WH0HD$ H\$PH3|$HO[ HtHHHH{H{ H{(HH\$PH0_HL$VWATH0HD$ H\$XHl$`HHH HHc3IuH,I;v*H,    H HuHt)HGH_HuH,I;v)H,    H HuHt)HGH_ Hw(Ht/I;v)H,    H HHuHtb)Hw0H_8HH\$XHl$`H0A\_^  H\$Hl$VH0LI HqHMHgfffffffHL+IHHH?HH;wx0H|$@I;v HHt$(3H\$ (D$ fD$ Hu LLHD H4I;s wHtHHH;ps HD$ Hur H8H;w H|$@r\ H\$HHl$PHH0^HL$WATAUAVAWH0HD$ H\$hHl$pHt$xLHHyF HHZH3HuH6H;v'H<    H HuHt'HHFH^I\$ HuH,H;v'H<    H HuHtt'HFH^ ID$(HF(I|$8Ht9HH;vD'H    HB HHuHt 'Hn0H~8IT$HN<IT$HN<IT$0HN0<HH\$hHl$pHt$xH0A_A^A]A\_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH薥t,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_H\$WH0MM@E3LMtGIHH      fffff     IcD$PHD$PH#H;w0IM;r݋A(L
{D HTD IˉD$ `H\$@H0_H HD MHD$(H IHD$ kH\$Hl$Ht$WH@I@MHHHD$0H-]D H~2 IHHI2 LHHl$(HD$ LLHH;L_DC(L
C HC HL\$ RLHHH\$PHl$XHt$`H@_	ALWH   HD$ I[IkIsHHHIHB H+BHH;tYH6D IK HL$P( H HD$PHT$(HL$h HC HD$PHod	 HL$P HGH9Gr`3HtYfff     HG@H+G8HH;ry Hw8HE H+EHH;r^ HEXHH;_rHGL$   I[IkIs I_H\$WH HHI8Ht HK 3HC8HC@HCH L L@tH HH\$0H _HL$ATH0HD$ H\$HHt$PH|$XHHٹ   m HtH33HHHw H+wHHKHK HK(Ht}H?H;vH*HKHJHCHC HHC(Hw H9wv LgL;g v HKI+HH    H<
HtLM H{ HH\$HHt$PH|$XH0A\Ht$WH HHH;  HR LFHI+HHuHHt$8H _LQLI M+II;wBI+HH~HIL% HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHM藵LO LF HHĵH\$0HG HHt$8H _MtI| HV HH+VHLtLOLF HVHtHG HHt$8H _I;t,H\$WH IHHr H(H;uH\$0H _H\$WH HYHHt.Ht$0Hq H;tH# H(H;uHO Ht$0H\$83HGHG HG(H _@WATAUAVAWH@HD$ H\$xH$   )t$0MILHHAHu3HY(H+HM  La IH+HHHH+I;sb'LI;   HHH+H;s3HI;IBHNHGLHD$pM~L+~IJHfHtIE HHHIVLFI+HHtHLI HV MFI?II+HHtHL HNHF H+HHHtM IHF(IHF Lf   II+FHH;swA1IVLMH谲HV HI+FHHH+Ht
2HHH    HF HN H+IFH;tjffff     0HH;uOA1HIH+MMHH1HF MHIN޲M^I;L;tA3IL;uH\$xH$   (t$0H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMu3Igfffffff(HI(I+IgfffffffIHHHHH?HM?  MD$ II+IHHHH?HHfffffffHH+H;s$L2I;^  HHH+H;s3HI;IBHIL$}DHHD$8IMI+L$IHLIIH?LL|$@D$0    KH3D$($   D$ ML$L$   H	>D$0   3D$($   D$ ML$LIUIL$	D$0   I7LN3D$($   D$ ML$IT$ IMML$IL$ I+IHHHH?HHMtMD$ IIIL$8 HHIL$(HHIL$ I|$  M+EIIHHH?HH;   IHL$PA HH    IML3D$($   D$ ML$IT$ MT$ II+MIHHHH?HH+3D$($   D$ ML$LD$PHI<I\$ I|$ H+I]H;tHT$PH* H(H;uHL$P~    IHL$Ps I|$ HH4    HH+3ML$D$($   D$ LHH.ID$ 3D$($   D$ D$   LHIM?<I]H<3H;tfHT$PHz H(H;uHL$P HĀ   A_A^A]A\_^[@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HHHH+I;s*!LI;   HHH+H;s3HI;IBHNHALHD$`M~L+~IJHHtIE HHHIVLFI+HHtHLIy HV MFI?II+HHtHLP HNHF H+HHHt IHF(IHF Lf   II+FHH;spIIVLMH|HV HI+FHHH+fD  HtHHHH    HF HN H+IFH;t_ HHH;uNM!HIH+MMHHHF MHIN豬M^I;L;t@ M#IL;uH\$hHt$pH0A_A^A]A\_@WATAUAVAWH0HD$ H\$hHt$pMILHHAHu3HY(H+HM  Ly IH+HH?HH+I;sLI;   HHH+H;s3HI;IBHNH?LHD$`M~L+~IJHHtAE HHIVLFI+HHtHLI* HV MFI?II+HHtHL HNHF H+HHHt IHF(IHF Lf   II+FHH;spAIVLMH譪HV HI+FHHH+    HtHHH    HF HN H+IFH;t`@ HH;uOE!HIH+MMHH5HF MHIN袪M^I;L;tD  E#IL;uH\$hHt$pH0A_A^A]A\_HL$SH0HD$ HH    H    HKX HKH HK8 HK( HK HKH0[H% H\$Hl$Ht$WH HY HH9YvY HwH;w vI H9wwH;w v7 H/H9_wH;_ v" HtH;/t H;t2HO HH+HHH;tH+ HHHDH;uHW H\$0Hl$8Ht$@H _DD$SVAUH0Hq HHIHLH+HH;sPH;v HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;v# H{H;{ v H+E3Hu ML] J<I;{ wHtLe I;|$s Ld$hH9{wH;{ v H+H9swH;s v HtH;+t H;t/HC H+HH    H,:H~LLHE Hk Hl$PH|$XH0A]^[HL$WH@HD$ H\$XHt$`IHHHI^H_8H_@    3HtHHHHsHs Hs(H_p    HtHHHHsHs Hs(H   HH\$XHt$`H@_HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H   c H   H   H   H-C6?H   H?H   H-q=H   HMbP?H   Hǃ   '  H      ?H  H:0yE>H   H  H   H     @H  H     @@H(  HH\$HH0_HL$WH0HD$ H\$HHl$PHt$XIHHHf2 HRHL. L]HE HEHH}XHV HEPHu`HuhH 
   >HEpH?HExH   Hǅ       HH\$HHl$PHt$XH0_HAHH`f/
 vIxf/
p v^ f/v   HWH`  HD$ HX)pHHٺ   DBHL$PR sxH1 HL$`:Hf(n HT$(HL$P6 LHHAHL$( HKHHPHL$P H$p  ($P  H`  _H\$WH H HHAPHI8t HO j HO` L LtH HH\$0H _HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Pt HL$HH+L$XIgfffffffIHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHfffffffHH+I;s.N"I;\  HHH+H;s3HI;IBHHN4HH$   H$   3D$($   D$ LNLH$   HRHNLH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HLH$   3D$($   D$ LNHV H$   HH;LF LNII+HgfffffffHHHH?HLMtIHnHN HHHN(KHHN H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$H&H^ I}H;tH(H;tHH H(H;uKL$    H^ I<H;t fH(H;tHH H(H;uHF II}H;tH(H;tHH[ H(H;uLf H`A_A^A]A\_^[H  HD$ HH$   0HHL$(HKR	 HL$(U H  HD$ HH$   7HHL$(HT	 HL$( @SH HJHHt H3HCHC HC(H [ HI H% HIH% H   HD$ HH$   AHHL$(HT	 HL$(u LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHH蹈H0H\$`H0HH0_^[M;   H\$H|$IMHI+HH   HLHII+ODL+HJTHHMf     HBA@H I@I HBHBADIDBHBAHI@JHBA@I@BuM;}0HHL JL+M+HAHIIDBuH\$H|$H   H%* HIPH% H   H%
 @WH  HD$pH$  HH$ HHEH=> HHEHL$H H4 HL$  A   E3H܏ HL$H HH
 H;tTffffff     L
 A   HHL$H] LCA   H HL$H1 HH/ H;uHT$HHL$  H HL$  HHL$  H$   , H H$   HT$ H$    H H$   H$   H$@  $^HH$   cHS	 H$   S H  HD$ HH$   0HHL$(HT	 HL$( H\$Hl$Ht$H|$ ATH`H$   MHHHuHAHxHQLAHFHHJIHLI IHILHLH$   IHD$XHF HD$PHBHD$HHD$@I@LCL\$8HD$0HCLT$(HD$ ?L\$`I[IkIs I{(IA\HWH   HǄ$   HXHpIHHL HHEH=f HHEHL$p HHL$H H} HL$  A   E3Hu HL$p HH
 H;tM    L
 A   HHL$p LGA   H( HL$pq HHo H;8uHT$pHL$ B H HL$ 8 HH$   H$   H$   HC$   3HHHHqDHE3H HL$H HH H;tE LA   HHL$H L7A   Hd HL$H HH H;8uHT$HHL$ v H$    HX H$   HT$ H$   u H H$   H$   H$  hkHH$  HP	 H$   M;ML   II+H   HII+NDHHHM@ HtHAHtH3H@I@HtHAHtH3H@I@HtHAHtH3H@I HtHAHtH3H@I HI@uM;}1IM+JHtHAHtH3H@HIHBuHIpH%
 H\$WH H   HH+   Hu$HOxHHO`H   HH+   HtHAH   H   xHHOpH   HH+   HtHAH   H   AHHOhH   HH+   HtHAH   H\$0H _HWH   HD$ HXHhHp IHH3hHIHIP t!HNHLHT$XP(   $   HNHLHT$(P(   $   HHt,HL$@Ht8 Hl$@Hl$HHl$PHL$( t0HL$pHt
 Hl$pHl$xH$   HL$X HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP   $   HNHLHT$(P   $   HH~t,HL$@Ht( Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$X޷ HHL$   I[Ik Is(I_HWH   HD$ HXHhHp IHH3hHIHIPt!HNHLHT$XP0   $   HNHLHT$(P0   $   HH}t,HL$@Ht Hl$@Hl$HHl$PHL$( t0HL$pHt Hl$pHl$xH$   HL$Xζ HHL$   I[Ik Is(I_Ht$WH HHH;  HR LFHI+HHu  HHt$8H _LQLI M+II;wBI+HH~HILU HN HGH+NHHHHO Ht$8H _Mu3HI(I+HH;wAIH\$0KHMGLO LF HHtH\$0HG HHt$8H _MtI謵 HV HH+VHtLOLF HVH$HG HHt$8H _HL$WATAUH@HD$0H\$hHt$xHHٹ   _ HtHE3E3IHHO H+OHgfffffffHHHHH?HLCLC LC(t{HfffffffH;v!HHK$HCHC HHHC(Hw H9wv LgL;g v 3D$(D$pD$ LKLCHInHC HH\$hHt$xH@A]A\_HL$WH0HD$ H\$HHt$PHHYHt$Hq H;tHu H(H;uHO 3HGHG HG(HH\$HHt$PH0_ H\$Hl$Ht$WH Hq HH9qv H{H;{ v H9{wH;{ v H+H9swH;s v HtH;+t H;t/HC H+HH    H,:H~LLHZ Hk H\$0Hl$8Ht$@H _@SH HHx  D$0    HHH [@SH HH  D$0    H`HH [LD$SVAUH0Hq HHIHLH+HH;sPH;v HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+MH0A]^[H;   Hl$PH|$XLd$hH;vc H{H;{ vS H+E3HuB ML] J<I;{ wHtLe I;|$s Ld$hH9{wH;{ v H+H9swH;s v HtH;+t H;t/HC H+HH    H,:H~LLH Hk Hl$PH|$XH0A]^[T$SVAUH0Hq HHIHLH+HH;sPH;vZ HHt$(LL$`HD$ HC HT$ (D$ fD$ H+CHHL+M>H0A]^[H;   Hl$PH|$XLd$hH;v H{H;{ v H+E3Hu ML] J<I;{ wHtLe I;|$s Ld$hH9{wH;{ v H+H9swH;s v| HtH;+tl H;t/HC H+HH    H,:H~LLH Hk Hl$PH|$XH0A]^[H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;t I}I+HIE HL$ HT$ HIEMHAHA   LcL;c vu HLd$(H\$ (D$ fD$ HuR LLI<I;{ wHtH3H;~s, H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\H\$Hl$Ht$H|$ ATAUAVH0LHHI H{IgfffffffLL+I3MIIHHH?HuH=H;v HM HtH;tr HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k v HHl$(H\$ (D$ fD$ Hu LLHH| I;{ wHtH3H;~s H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtSHH;vCH	LHFHF HHN(HHHtHHHHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;t I}I+HIE HL$ HT$ HIEMHAHA   LcL;c vE HLd$(H\$ (D$ fD$ Hu" LLI<I;{ wHtH3H;~s H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HL$WATAUH@HD$0H\$hHt$pMHH3HAHA HA(HtZHH;voH5HHCHC HHK(3D$(L$`L$ LKMHHqHHC H\$hHt$pH@A]A\_HL$WH0HD$ H\$HHt$PIHH3HAHA HA(HtQH?H;vHLHFHF HHN(HHHt
HHIHF H\$HHt$PH0_H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;v IE HtH;t
 I}I+HIE HL$ HT$ HIEMHAHA   LcL;c v HLd$(H\$ (D$ fD$ Hu LLI<I;{ wHtH3H;~s| H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HE3LBHLJLJHDL$3H
LBD$HBHBH@SH HH0  
HH [ATAUAVH@HD$0H\$`Ht$pH|$xHHHH;vHIHu3HC(H+HH;   HK9LHD$hH{ H9{vQ LkL;k vA 3D$(D$hD$ LKMHIRHKH{ H+HHt§ IHC(IHC LcH\$`Ht$pH|$xH@A^A]A\f/
 v%      Ix^,;L   HHHWH@  HD$ HXHH@       DBHL$@    HL$( HL$PHcQHLPHPHL$P HHL$@a Ǆ$`     HL$@S HH$X  H@  _M;L}cLD  MtIBHtHH3HtHA3H@HHtHA3H@IM;HBDBXDCD|HAHH f/
P v> f/v   f/
  v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$P    HB HL$` Hf( HT$(HL$PӼ LHHAHL$(z HKHHPHL$P H$p  ($P  H`  _f/
  v   f/
  v f/v   f/
 v(         ^,;L   HWH`  HD$ HX)pHHٺ   DBHL$P    H
 HL$`Hf( HT$(HL$P LHHAHL$(* HKHHPHL$PY H$p  ($P  H`  _f/
 v   H\$WH Hw HHH HA`HIH HO8 HO  HO| L LtH HH\$0H _H\$WH Hw HHH HA`HIH HO8 HO  HO Le LtH虢 HH\$0H _H\$WH H HHH HAhHIH HO8 HO  HO| L LtH HH\$0H _LL$ WATAUAVAWH@HD$0H\$xH$   ILLHAHu3HY(H+HM*  Lq IH+HHHH+I;sLI;   HHH+H;s3HI;IBHIL$`HHD$pMuM+t$IJ3D$(D$pD$ ML$L$   H蓑3D$(D$pD$ ML$LIUIL$KI6L3D$(D$pD$ ML$IT$ IMKIL$ID$ H+HHHt衠 HID$(HID$ I|$  II+EHH;   IH\$pH<    IML93D$(D$pD$ ML$IKIL$ HI+EHH+3D$(D$pD$ ML$LD$pH茐I|$ IL$ H+IEH;tqD  HHH;u^I3HIH+ML$D$(D$pD$ MIHJID$ MHIM	M]I3L;tfIIL;uH\$xH$   H@A_A^A]A\_H   HD$ HfffffffH;vSHR HL$(_ HL$P H HD$PHT$(HL$h^ H HD$PHL$PHu3	H(HĘ   HXHD$ H HL$( L2 L\$(H
 HD$@H
 HD$HHL$(H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HHH0H;uH\$0Ht$@HHl$8H _LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHYdHH0H\$`H@_^[E3DL$HtHIHAHBHAHBLBLJ LJ(HH\$WH   Hy HHrHIHH@D$@)D$8(H<Hcr LHD$0Hdr L
yd HD$(Hc HHL$hH|$pHL$PHD$ H|$X u8HL$PH#tG<et<Et<-t<+u2H$   HĀ   _ðH$   HĀ   _HWH   HD$ HXHpHHHyHC H+CHH;ruH
 HL$hw HL$( HS HD$(HT$hHL$@v HT$(H$   kH
#
 HHPH
 HHX@`   H蕔HGHAHC H+CHH;r HCHHHL$   I[IsI_@WH   HD$ H$  HHyHC H+CHH;ruH HL$h HL$(д Hh HD$(HT$hHL$@ HT$(H$   H
 HHPH
 HHX@`   H誓HGHAHC H+CHH;r HCH$  H   _LL$ LD$SVWH0HD$ IHHH\$PH;t*H\$XH\$(HtHHH0H\$`H0HH0_^[E3DL$HtHIHAHBHAHBI HBLJ LJ(LJ0H3H
LBD$HBHBHB HH\$Hl$VWATH0Hq A LD$PHH9qv H{H;{ v H9{wH;{ v۲ H+H9swH;s vƲ HtH;+t H;t/HC H+HH    H,:H~LLH^ Hk H{H;{ vr HH|$(LL$PHD$ HT$ M(D$ HfD$ eH\$XHl$`H0A\_^HWH   HǄ$   HXHpIHH[ HHEH=[ HHEHL$p԰ HHL$HŰ H[ HL$  A   E3H
T HL$p HH
 H;tM    L
ٷ A   HHL$p} LGA   HS HL$pQ HHO H;8uHT$pHL$ " HOY HL$  HH$   H$   H$   HC$   3HHHHqDHE3HZ HL$Hʯ HHȯ H;tE LA   HHL$H L7A   HZ HL$H HH H;8uHT$HHL$ V H$    H H$   HT$ H$   U H H$   H$   H$  x5HH$  觡H`*	 H$  ǖ @WH  HD$pH$  HH\a HHEH=va HHEHL$H Hla HL$  A   E3HY HL$Hu HH
s H;tTffffff     L
 A   HHL$HM LCA   HPY HL$H! HH H;uHT$HHL$  H?Y HL$  HHL$ ګ H$    H H$   HT$ H$   ѭ H H$   H$   H$@  4HH$   SH)	 H$   C LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCISHxHWH   HǄ$   HXHpIHHi HHEH=i HHEHL$p HHL$Hu Hj HL$ b A   E3H[ HL$pN HH
L H;tM    L
 A   HHL$p- LGA   H`[ HL$p HH H;8uHT$pHL$ ҩ HO[ HL$ ȩ HH$   hH$   H$   HC$   3HHHHqDHE3H\ HL$Hz HHx H;tE LA   HHL$Ha L7A   H[ HL$H5 HH3 H;8uHT$HHL$  H$   P H@ H$   HT$ H$    H5 H$   H$   H$  (1HH$  WH&	 H$  w E3DL$MtIMHHHAHBHAHBHAHBHA HB I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhI@HHBpI@PHBxL   L   HLIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCISHxHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHLJPLJXHHE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhI@(HBpI@0HBxI@8H   I@@H   L   L   HH;   HH$LLH	HI H
ML;tIHIHIQMPL;tI
HIH
IQ MP L;tI
HIH
I(I(M;tIII I	H@VATHH1
 LHHT$0L@HHHD$ L;LD$ HL$0HME3L I  H\$(Hl$8H<$H>Il$MtIAHtH3HWLHIHtH3H@f(HHH HI^AXAMtIAHtH3LIXLSIHWIHtH3H@f(HHH II^DAXDADMtIAHtH3LHHWIHtH3H@f(HHH HI^DAXDADMtIAHtH3LLSIHWIHtH3H@f(HHH IIIL;^DAXDADH<$Hl$8H\$(M;}aLMtIAHtH3ISMHIHtH3H@f(HHH HIIM;^AXA|HA\^LAMtI@3LX8IHH+HLIHHHHM~  MtI@3H@0f MtI@3IH@ffY   MtI@3H@0f@MtI@3H@   H;fXfY}sMtI@3H@0fMtI@3H@ffYfXMtI@3H@0fLMtI@3H@HH;fDfYfX|L;fX~4MtI@3H@0fMtI@3H@ffYfXM;f(fXB  II+H   MJ   M+IIIOMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0Y
XMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(MtIH3MtI@3H@HI0A   M;Y?  ICH   MSAQIIN   D  MtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0DYDXMtIH3MtI@3H@HI0YXMtIH3MtI@3H@HI0H IDYDX,M;}<MtIH3MtI@3H@HI0IM;BLBYLX|f(LATH   HD$`I[IkIsI{ A)sHHHyH (  H   HYH{   qAY0HWHMHEE3McMcMcICIKISMCISIK L$   IH$   H$   IH$   H$   J    H$   HFHPHFHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLG辜HL$p HL$xߠ H$   Ѡ L$   I[IkIs I{(A(sIA\H\$M;MHL  II+H   HIL I+HKDHHMMtIJHtH3@^A@MtIJHtH3@^A@MtIJHtH3 ^A MtIJHtH3@H H^A@dM;}:HM+HJMtIJHtH3 HI^A@uH\$HE3HHADL$HBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@I HBHI@HBPI@HBXI@HB`I@ HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA(HB(I HB0I@HB8I@HB@I@HBHI@ HBPLJXLJ`LJhHHE3HHADL$HBHAHBHAHBHA HB I HB(I@HB0I@HB8I@HB@I@ HBHI@(HBPI@0HBXI@8HB`I@@HBhLJpLJxHE3DL$HtHIHAHBHAHBHAHBHA HB HA(HB(HA0HB0I HB8I@HB@I@HBHLJXLJ`LJhHLATH   HD$`I[IkIsI{ A)sHHH9H "  H   HYH{   A0HWHMHEE3McMcMcICIKISMCISIK+L$   IH$   H$   IH$   H$   J    H$   HFHPHHHHuHSLU LLd$XHD$pHD$Pt$HHEHD$@LT$8HCHD$0L\$(HGHD$ LLGHL$p1 HL$x& H$    L$   I[IkIs I{(A(sIA\HLE3LMSI   IH\$H<$IzAXHfffff     III8H IIHKXBBII8IHXBBII8IHKHXBBII8L;IXBB|H<$H\$M;}-IJII8IHIIM;XBB|H@VLE3LIsH  H\$Hl$AZH|$ Hn{MtI@HtH3IS8MIHtHH33AH@L8YI(\AMtI@HtH3MHSIS8HtHH33AH@L8YI(\AMtI@HtH3MHIS8HtHH33AH@8YI(\AMtI@HtH3MHSIS8HtHH33AH@IH HL;L8YI(\AH|$ Hl$H\$L;}YMtI@HtH3IK8MIHtHH33AH@IL;BLYJ(\A|^M;   H\$H|$IMHI+HH|wLHILI+KTHM+KDHHMBH H HX@@ALXHHBX@@JXHHuM;},HHHH+M+JHIX@@uH\$H|$ATM;MML  II+H  HH\$Hl$L Ht$ H|$(N   IHI+ھ   HHI+I+HI+KHMD  HtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3BH@HAYH(\BHtHAHtH3HtHL3E3H@BAYH(\HtHAHtH3HtHL3E3BH@H HI HLAYH(\BH|$(Ht$ Hl$H\$M;}VI$L HtHAHtH3HtHH33CH@IM;BLYJ(\CD|A\M;L}yHLfMtIBHtH3HHHtHA3H	tHH33H@BYJ(HtH3CYI8IM;\CD|HWH   HD$0HXHhHp HHHIHP8   { 3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP8H_ H9_vƔ HHD$`H\$hH$   HH$   H;v H$   H$   HL$pHL$@Ht$HH;vq HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`HH$   Ht2H$   H;t H H(H;uH$   Hz H$   H$   H$   HL$pxz L$   I[Ik Is(I_HWH   HD$0HXHhHp HHHIHP@   Fz 3Ht
HL$pHHHD$pH$   H$   H$   HKHHT$pP@H_ H9_v HHD$`H\$hH$   HH$   H;v H$   H$   HL$pHL$@Ht$HH;v HL$pHL$PH\$X(D$@fD$@(L$PfL$P(D$`fD$`$   D$ LL$@LD$PHT$`H>H$   Ht2H$   H;t HW H(H;uH$   Hx H$   H$   H$   HL$px L$   I[Ik Is(I_@SH H HHHI(Htx HK3HC(HC0HC8H [ox H\$WH H HًHHI(HtEx HK3HC(HC0HC8.x @tH x HH\$0H _H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;v HH|$(LD$ HD$ HT$0L(D$ HfD$ H\$PHt$XH@_H\$Ht$WHPLAHHIgfffffffMuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ L_(L[ H\$hHt$pHP_L;v HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_H\$Hl$Ht$ WH0Hq HH9qvy H_H;_ vi H9_wH;_ vW H/H9wwH;w vB HtH;/t2 H;tIDL$@HW 3D$(D$@LHΈD$ 9Hw HHH;tH H(H;uHo H\$HHl$PHt$XH0_H\$Ht$WH@HHIHHuE3LC(L+IH{ HH+HI;sHHHGHC H\$PHt$XH@_H;vV HH|$(LD$ HD$ HT$0L(D$ HfD$ 9H\$PHt$XH@_HL@VWATAUAVHPHD$0HXHh MLHHq HILL+HgfffffffHIHHH?HI;sZH;v HHL$@Ht$H(D$@fD$@HO H+OHHHHH?HL+MMHT$@Hݝ   L;   H;vD H_H;_ v4 H/E3Hu# ML] KD HI;[ wHtLe I;\$s H9_wH;_ v H/H9wwH;w vΌ HtH;/t H;tO3D$($   D$ D$   LHW HHHw HH;tH H(H;uHo IL\$PI[8IkHIA^A]A\_^H%X @WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH H(H|$`HS(HI9HSXHO0;9D$h   Ɔ    HH\$HHt$PH0_@WH0HD$ H\$HHt$PHHLALIHyH|$@H\$`HH H(H|$`HS(H虖HSXHO08D$h   Ɔ    HH\$HHt$PH0_LATAUAVH  HD$`I[IkIsI{ IM3HJ H+JHgfffffffHLIIH?LII I+II*IHHHH?HL;  UDEIx HO H+OIHHHHH?HH? H$   HH HH HH HI̇ HH HT$hH$   J HHL$ , H HD$ HHL$8 H1 HD$ HT$ H$  rH
 HHPH
 HHX@`?   H̬HMtSHHO H+OIHHHH?HH;rY HGHHL$h6HHHH0I;rI] I+]HH;      DBH$   < H H$   oHH HH THHx HHf 9HT$hH$    HHL$ ؈ Hȋ HD$ HHL$8 H݋ HD$ HT$ H$  H
 HHPH
K HHX@`I   HxL$  I[ Ik(Is0I{8IA^A]A\@SWAWH`HLE3H34LGǄ$       Mu3HW(I+HH_ HI+HH;sHC    HG =L;v HH\$(L$   HD$ LD$ HT$0(D$ fD$ HIO H*I+OHHHHH?HH/  H$   Ht$XLd$PLl$HLt$@E3E3L$       HG H+GHL;r IO LgHI+OHHHH?HL;rΆ Io3۾   IL- I+L-HHt)H;r ID-IL- HH+HtH;rH$   HWB DD$   Hu3HO(H+HH_ HH+HH;sHCDHG    H;v) HO HoH7HHt$ H\$(H+Hu3"H;v HtH;7t H+H(D$ L$   HT$0A   HfD$0jHoH;o v H7Hu E3LHL I;K wHtH3H;Hsq IO H$   II+OH*I0HHHHH?HIFH;Lt$@Ll$HLd$PHt$XH$   H`A__[HHHz HL$(HT$0u	fWHHHT$PHL$ HH@SH H HHH> HAPHI8 HK  HK L LH [@SH H HHH HAPHI8P HK F HK< L LH [@SH H HHH HA`HIH  HK8 HK  HK LK LH [@SH H HHH HA`HIH HK8 HK  HK L LH [@SH H HHH~ HAhHIH@ HK86 HK , HK" L LH [@SH H HHH HAhHIH HK8ւ HK ̂ HK L+ LH [@SH H"z H      ?   Hǃ       ^CxH   ,;L   Hf HHH [H\$WH HH   HHH   HH   HH\$0H _HHHz  HBHD$(ufWY` HHHT$XHL$ |YD HH@SH H"E3H     @@ǃ      D   H   H D   HD   L   HH [H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hofn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v8 HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;v HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HeH   HH\$XHl$`Ht$hH@_H\$VH@Iy IHH\$0LD$(tPHT$`HL$ f/  v7H{ Ht$(H\$0t&HT$`HL$ f/ v
H\$PH@^2H\$PH@^@SHPHD$ HHG HL$(} HT$(HHL$(} H HL$(} HT$(HHL$(} H HL$(T} HT$(HHL$(Z} HP[H\$WH HH   HHH   HH   HH\$0H _@SHPHD$ HHW HL$(| HT$(HHL$(| H HL$(| HT$(HHL$(| Hw HL$(d| HT$(HHL$(j| H; HL$(8| HT$(HHL$(>| H HL$(| HT$(HnHL$(| HP[H\$Hl$Ht$ WH@HH   HHwLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;vn| HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hfn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;v{ HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H虲   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;vd{ HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HH   HH\$XHl$`Ht$hH@_H\$WH HH   HHH   HH   HH\$0H _yH\$WHPHz8 HB)t$@HD$(HB0HHHD$0ufWHT$`HL$ ]f(HHHH\$hY! \(t$@HP_H\$Hl$Ht$ WH@HH   HHLC3fn   l$PMuHHS(I+HH{ HI+HH;sHG/HC :L;vy HH|$(LL$PHD$ LD$ HT$0(D$ fD$ Hfn   HSD$PHuHHK(H+HH{ HH+HH;sHGHC :H;vHy HH|$(LL$PHD$ LD$ HT$0(D$ fD$ H   HKfnD$PHtHs(H+HH{ HH+HH;sHGHC :H;vx HH|$(LL$PHD$ LD$ HT$0(D$ fD$ HuH   HH\$XHl$`Ht$hH@_"@SH HJ 3H      ?   ^CxH   H   ,;L      Hj H   H      ?H   H   H   H?H   H      ?H   H   H      $@H   H   HD HH" H   HH [H\$WHP)t$@)|$0=d f/HHD)D$ DADXDAvf(q(f(fA(XA@\^f(Y\YAXfA(qN] K8Ys ^C0fW
 \fA(] \YY{Xf({\ H\$`(t$@(|$0D(D$ HP_@SH A(HA \ CH [@SH H HH   H: HH HAPHI8Bv HK 8v HK.v L~ LH [@SH H蒓ǃ      E3H     @@H   D   D   D   L   D   H
 L   L   H   H      ?L   H   H   H?H   H      ?H   H      $@H   HT HH* H   HH [@SH A(HA ;[ CH [@SH H HH   H HHp HAPHI8t HK t HKt L'} LH [HL$SH0HD$ HH+ HH	 H   Hx  mt Hh  `t H  [s H HH! HC`HKH3t HK8)t HK t HKt L~| LH0[M;1  WAUIIMI+LLH  HH\$Hl$ L Ht$(Ld$0J   H   I+II+HM+NHHMMtIBHtHH3HtHA3H@HHtH3OA^AAXAAAMtIBHtHH3HtHA3H@HHtH3AD^AAXAAAMtIBHtHH3HtHA3H@HHtH3^AAXAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAXAAALd$0Ht$(Hl$ H\$L;}^IE L MtIBHtHH3HtHA3H@HHtH3BIL;^ACXDCD|A]_H\$M;IML   HL MtIBHtH3HPHtHJ3HtHA3H@L HtHA3H@HBC\HtHB3H@IL;HBYDCXDCDpH\$M;L   LMtIBHtH3HHHtHA3H!tHP3J HtH3YH(HtH3H	tHA3H@HHtH3BIM;YAXCDgHL$SH0HD$ HH[ HH9 H   H  
p Hp   p H   n H+ HH} HC`HKHo HK8o HK o HKo Lx LH0[HL$SH0HD$ HHK HH) H   H  ]o Hp  Po H   Kn H HHa} HChHKH#o HK8o HK o HKo Lnw LH0[M;
  VAUIIMI+LLH  HH\$Hl$ H|$(Ld$0HI+   IHJ   H+HL+LHMMtIBHtHH3HtHA3H@HHtH3OA^AAAMtIBHtHH3HtHA3H@HHtH3AD^AAAMtIBHtHH3HtHA3H@HHtH3^AAMtIBHtHH3HtHA3H@HHtH3I)H I H^AAALd$0H|$(Hl$ H\$L;}TME MtIBHtHH3HtHA3H@HHtH3BIL;^ACD|A]^HM;ML   H$HfD  MtIBHtH3HPHtHJ3H	tHA3H@LHtHA3H@HBC\HtH3YB(IM;BD|H$HHI(H%
l H\$Ht$H|$HqHYE3LHH   t fWfff     E3H   @ MtICHtH3HtHH3H!M;uf(f(HtH3YI(HtHH3H	tHA3H@HPL IIHtH3AHIHOAYIXIL;SIL;7H\$Ht$H|$E3DL$HtHIHHHAHBHAHBHAHBI HB LJ(LJ0LJ8HHL$SH0HD$ HH HH H   H  ]j Hx  Pj H(  Ki H[ HHax HChHKH#j HK8j HK j HKj Lnr LH0[H\$WH H HHHXw HAPHI8i HO i HOi Lr LtHCP HH\$0H _H\$WH H HHHv HAPHI8Ji HO @i HO6i Lq LtHO HH\$0H _H\$WH Ho HH   Hļ HHjv HAPHI8h HO h HOh L!q LtHUO HH\$0H _H\$WH HW HH   H HHu HAPHI8Lh HO Bh HO8h Lp LtHN HH\$0H _H\$WH HLtHN HH\$0H _H\$WH H|tHkN HH\$0H _H\$WH HtH;N HH\$0H _H\$WH HtHN HH\$0H _H\$Hl$Ht$H|$ ATAUAVH0HHI 3LcHMI+MHHuH*L;vf IE HtH;tf I}I+HIE HL$ HT$ HIEMHAHA   eLcL;c vf HLd$(H\$ (D$ fD$ Hurf LLI<I;{ wHtH3H;~sLf H\$PHt$`H|$(H|$hHL$ HHE HAHEHHl$XH0A^A]A\HWATAUH   HD$ HXHhHp)pL   L Ht
HL$PH3HD$P3H\$h3HL$p3HT$xI9U u3I}HQ  Hu3H+HHH+HH;sHHHHL$pH\$h   HH;vSe HL$pH\$hHl$PHl$0Ht$8HH+Hu3$H;ve HtH;l$Pte H+H(D$0fD$@LA   HT$@HL$PsH\$hLHL$pH;vd HL$pH\$hHl$PHud E3HL$pH\$hHD$PLII;S wHtHE 3H;Psud HL$pH\$hHI;}uI} I;}tHt
HT$xLL+IIHH;v-d HL$pH\$hHH;vd HL$pH\$hHl$PHuc E3HL$pH\$hHD$PLJ4I;s wHtHE 3H;psc HL$pH\$hH;vc HH+HH=   ~Eff     LHHL$0`cL\$8L;wI
H|$0H;v HH+HH=   E3HHWuHD$pHL$hH+HL;r+c HL$hB4HtI HD$h    HD$p    HD$x    HL$PI f(L$   I[ Ik(Is0A(sIA]A\_LL$ HL$SVWH@HD$ IHHHL$hHt)H\$(H\$0HtHHmHH0H\$`H@_^[@SH03MM؈D$(D$@HLIMIHˈD$ 萆H0[@SH@Hy` HAXHHD$(ufW>H YCxH@[HT$PHL$ H YCxH@[@SHPHy )t$@qhHAHHHD$(HAfT5d HD$0t$hufWHT$`HL$ aH8  f/wHD$h^ (t$@fWs HP[@SHPHy )t$@qhHAHHHD$(HAfT5d HD$0t$hufWHT$`HL$ H  f/wHD$h^ (t$@fWzs HP[@SH HHI` HKH [H%` H\$Hl$Ht$WH LHH*L+IHIHHH?HH,RHIH;tH+HHSH0H;uH\$0Ht$@HHl$8H _HVWATAUAVH   HD$ HXHh)pIHH3IMuH,M;vЍN$    I_ HuMt词HD$8H|$@HuH,I;v萍L$    I_ HuMtoHD$(H|$0H   LuLNLL+A   L+A   L+IL+LGIIJ    fffff     KT
 INHD$8HIAHHHD$(HK
HD$8HLIHHHD$(HLKINHD$8HIAHHHD$(HAKHD$8IA@HD$(I I IdH;s0H+H)HD$8HHHD$(HH;rHD$8HD$PHD$(HD$XH|$0 ufWH$   HL$Hf(HL$(^ HL$8] f(L$   I[0Ik8(t$pIA^A]A\_^LWH   HǄ$   I[IsHISHHHAHBHAHBHAHBHA HB HyH^HF3HL$@IKIKI[ICI{MCISIKLL\$hIHD$XHD$pIHD$`HD$xJ    H$   HF HL$@HL$0HD$(HHD$ L$   L$   HH%BHL$@\ HL$H\ HL$PL$   I[IsI_H%\ H(f(f(fT
l_ f/
o vGf/
Zo r+f/Xe vH H
) K*x H(ZB \ e H(o f/v	f(H(%  f(Yf(f(Y Y
 X
 \f(Y YYX YX YXf(Y< \%, \YY\ YY- XXXd ^Xf(H(H@H   )pD)@D)P	 fD(Шum
 D  	 
j	 
 DI	 
Y	 
 9	 
I	 
q 
A	 	D	 5c ua
B 2 	 
	 
 	 
	 
 5	 
	 
 
	 uy 
 	 	  
	 
l 	 T 	 < 
	 
$ 	 
	 uq  
 7	 _	 Ͽ 
W	 
 O	  
G	 
 ?	 
?	 5?	    W 
G 	 	 & 
	 
 	  
	 
޾ 	 ƾ 
~	 
 v	 
v	      
v  -	 	 U 
	 
= 	 % 	 
 
	 
 	 5	 
	  @ugq - 
q @	 X (	 8  	 	 -	 
	 	 f(
	 -	 %	 x\ޚ Κ 	 t	  T	 d	  D	 T	 5T	 "	 rjT D 	 	 " 	 	  	  	 ҙ 	 	rb  	B	 2	  	 "	 b 5*	 	 B 
	 
D)d$PrD% 
D%	 	 	D%	 r 	 	 r e	 	 
D)\$`rDj 
D5	 _	 	D$	 D)|$ rD=/ D=	 ,	 	D=	 D)$   rD
 D
	 	 	D
	 D)t$0rD5 D5	 	 	D5p	 )$   r=z =F	 	 =6	 D)l$@rD-A D-	 ^	 	D-	 fWfA/vH
	 L$   H"9 车fD.zuH
t	 H͸ zg fA/  fA(fA(AYfD(fA(A^r: f/Yf DYD^
f    f(f(Y
	 Yd	 X
	 XL	 YYX
d	 X,	 YYX
D	 X	 YYX
$	 X	 YYX	 AX^   ^f(f(Y	 AYX
	 X	 YX
	 YX	 YX
	 YX	 YX
	 YXu	 YX
	 YXe	 ^DY؉ fE(EXE\E\EYDYEX  ( fA/rXfA(L$   Hu	 H
	 E3AY$   DY
g =	 fA(A\fD(A\hD8 fE/   fA(L$   H	 H
	 E3AY$   蜛Y= fA(fD(\=v	 A\f(AXYfA(DYD^f(fA(8 Yd Y^56d DX  E^fA(AYf/   f(fD(DY%	 Y	 DX%	 Xx	 DYYDX%	 XV	 DYYX=	 DXDYYDXX	 DYDXYXD^   f(^f(fD(DYYX	 DXDYYDX%	 X	 DYDX%	 YX	 DYDX%	 YX	 DYDX%	 YX	 D^f/   fD(f(DY
>	 Y	 DX
%	 X	 DYYDX
	 X˿	 DYYDX
	 X	 DYYDX
	 X	 DYYDX
	 Xe	    ^fD(f(DY
z	 YB	 DX
q	 X9	 DYYDX
_	 X'	 DYYDX
M	 X	 DYYDX
;	 X	 DYYDX
)	 X	 D^fA(t5 f(fA(H5 f(fA(^5 Dd f(EYD^X\AYAYXDYD(|$ D(t$0D(l$@L$   fA(A(sE(CE(SD(d$PD(\$`D($   ($   ID$H   5	 D)$   D)T$`fD(uy
U E 5 	 
	 
 	  
	 
 
	 
̵ 	 
	 	 DV ur 
 ~	 	 f 
	 
N 	 6 
	 
 	 
	 D	     
ݴ 	 D	  
<	 
 4	  4	 t 
	 
\ $	 D 
	 
, 	 
	     
 c	 S	 ӳ 
K	 
 C	  
;	 
 3	 s 
+	 
[ #	 
#	 D"	  fWҨui҃ 
 	 y	  
q	 
 i	 q i	 9	 
Q	 Y	  uj= 
-  T	 Խ	  
̽	 
 Ľ	 ܂ Ľ	 	 
	 D	 @uq 
 @	 &	 v 
	 
^ 	 F 
	 
. 	 
	 	 xs 
 p	 x	 Ё 
p	 
 h	  
`	 
 X	 
X	 DW	 D)\$PrDR D	 	 	D	 	D)d$@rD% 	D%»	 	 	D%	 
)$   r5۰ 
5	 	 5w	 D)t$ rD5 D5M	 W	 	D5<	 )$   r=f =	 $	 =	 
D)l$0rD-- 
D-غ	 	 	D-Ǻ	 fA/rL$   HA5 H
z5 -[ D)L$pfA/r|fA(L$   H+	 H
\	 E3AY$   &Y5 fA(fD(fA(\AXA\YfA(A^DYcE^f(   DB fE/   fA(L$   H	 H
L	 E3AY$   Y= fA(fD(fA(\AXA\YfA(A^DYbE^f(fA(. YZ Y^5BZ DX   E^fA(AY$   fA(- f(fA(- L$   HQ	 H
	 E3f(֏L$   H	 f(\fD(H
ù	 E3EYDY衏XYD\fA(j- Yz\ D^EYD(t$ D(l$0D(d$@fA(D(L$pD(\$P($   ($   D($   D(T$`Hĸ   H@H   )p)xD)HfD(D)P	 uk
  x o	 _ %O -? 
	 	 	 	 %	 -	 0-	 %	 	 	 պ	 
ź	 =N D)\$`D)d$PD)l$@u<D D% 	 Dk	 D%j	 =j	 fD(D-Z	 D%I	 D8	 DG D)$   D)t$0D)|$ u_D D= 5 ;	 Dڹ	 D٭ D	 Dǹ	 D=	 5	 fE(D=	 D5}	 u>5 Dx Ϲ	 5?	 D>	 D%	 =5	 	D	    D) 5 	 D	 D 5	 D	 DԬ D	 D Dy	 D Do	 D De	 Dl D[	 DR DQ	 D8 DG	     D  =ӷ	 	 Dt	 D Dj	 Dѫ D`	 D DV	 D DL	 D DB	 Di D8	 DO D.	 D5 D$	 D D	 fWfA/vH
	 L$   H5 fD.zuH
ː	 H hfA/   fA(AYf(YfD(DYDXDYDXf(YXDYYDXf(AYAXDXYAXD^fA(( f(f(f(Y
	 Y	 X
϶	 X	 YY5ö	 YX	 AXAXYYAXX^YD\8  A^fA(fWpT f(Y' fD(fA(' f(f(D^f(f(Y	 Y	 Y
	 X׵	 Xw	 X
g	 Yǵ	 YYX	 X?	 X	 YYYXk	 X
	 X	 YYYYX3	 XC	 X
Ӵ	 YYYX	 X	 X
	 YYYX	 XX״	 X^DYD(|$ D(t$0D(l$@L$   fA(A(sA({E(KE(SD(d$PD(\$`D($   IH@H   )xD)@D)HD
Z fD(D)XD)`D)l$@g	 D)t$0D)|$ uqD% D-
 D5 3	 D= ҩ D%	 D-	 D5	 D=	 	 D
	 fE(-D=͵	 D5	 D-	 D%	 D	 =IH u<
M D
I	 	 
C	 
# =C	 
3	 	D
	 fWua 
 G	 ϴ	  	 	  
	 	  	 uAc 
S 	 B	 2 
*	 2	 =2	     
 	 	 ѧ 
	 	  	  	  y	 i q	 Q i	 9 a	 ! Y	 	 Q	      
٦  س	 	  
x	 	  =	 p	 x h	 ` `	 H X	 0 P	  H	 fA/vH
	 L$   H4 fD.zuH
	 H bfA/)$   D)T$p  fA(fA(AYf(Y" f(Y
w	 f(fD(f(YZ	 X
J	 Y	 X2	 AXYYYX
	 AXYYXf(Y	 X
	 X̱	 YX	 YX	 ^f(AYDYAXYXf(Y	 AXX̱	 YX	 YAX^DXE^8  A^fA(fWN f(Y! fD(fA(! f(f(D^f(f(Y	 Y	 Yٰ	 Xɰ	 Xi	 X	 Y
a	 YYX	 X1	 X
1	 YYYX]	 X]	 X	 YYYYX%	 X
ݯ	 X	 YYYX	 X	 X
	 YYXٯ	 XYXq	 X^DY($   D(l$@D(t$0L$   fA(A({E(CE(KE([E(cD(T$pD(|$ ILATH   HǄ$   I[IkIsI{ A)sHHHH{   H{    HqH~    A0HSHMHEE3Ld$0Ld$8Ld$@ICIKISMCISIK赸L\$XIHD$HHD$`IHD$PHD$hJ    HD$pHGHHHH$   H$   H$   $   HT$0H$   Ld$(HL$ E3L@3H$   `HL$08 HL$88 HL$@8 L$   I[IkIs I{(A(sIA\M;6  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3I@IBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@HBYBPAXAAAHtHAHtH3HtL@E3HtHP3I@BYBPAXAHtHAHtH3HtL@E3HtHP3I@I I HHBDYBPAXAAALd$0H|$(Ht$ Hl$L;}]IE LHtHAHtH3HtL@E3HtHP3I@IL;BDYBPCXDCD|A][M;  WAVHIIMI+LLH  HH\$ Hl$(Ht$0Ld$8L,$HHA   I+IJ   HH+L+HL+LHMMtIBHtH3HtL@E3HtHP3I@KL
 ^BpAAMtIBHtH3HtL@E3HtHP3I@I)^BpAAMtIBHtH3HtHP3HtHH3HB^ApAMtIBHtH3HtL@E3HtHP3I@KH I H^BpAAL,$Ld$8Ht$0Hl$(H\$ L;}QMMtIBHtH3HtHP3HtHH3HBIL;BD^ApCD|HA^_E3LLIPMuIHHJuIHaHAuIH@fBHtHIIpHJffYHuIH	HAuIH@fB$HtLIAIPIHffYfXfBXfB)HtHA3LPIHH+HLIHLIIM  HtHA3IH@ffY   HtHA3H@   I;fHfY}FHtHA3H@ffYfXHtHA3H@HI;fDfYfX|M;fX~HtHA3H@fBfYfXM;f(fX   II+H   MJ   M+IIIOHtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(HtHA3H@A   M;Y   IBH   MJAPIIN   D  HtHA3H@DYXHtHA3H@DYXHtHA3H@YXHtHA3H@H IDYXwM;}(HtHA3H@IM;BLYX|f(M;I  SAUIMLHI+H  HHl$Ht$ L H|$(Ld$0N   HHI+   IHI+I+HM+OHM@ HtHAHtH3HtL@E3HtHP3AAI@IBYJp\AAHtHAHtH3HtL@E3HtHP3AAI@HBYJp\AAHtHAHtH3HtL@E3HtHP3AI@BYJp\AHtHAHtH3HtL@E3HtHP3AAI@I HI HBLYJp\AALd$0H|$(Ht$ Hl$L;}`IE LHtHAHtH3HtL@E3HtHP3CI@IL;BLYJp\CD|A][HL$WH0HD$ H\$HHHD$P        HtH3HHD$P    LD$P   HgHC H+CHHu- HCH8HH\$HH0_HL$WH0HD$ H\$HHt$PIHHD$X        HtH3HHD$X    LD$X   H~fHC H+CHHu, HCH0HC H+CHHw, HCHxHH\$HHt$PH0_H\$Ht$ WH@HA`HA Hy`H+AHHHH;s<fHCPH+CHHH;ri, HCHH94sHC`HC H{`H+CHH;rHC H+CHH9C`   HK0mHHH;HBHL$`@HT$PHHD$P>HlH8 u6H9 HL$ A   (, L. H HL$ L\$  HT$`HK0HC H{`H+CHH;r+ HCH<H7Hs`HCpHKPH+KHHH;rf+ HKHHHHt$hHHKhH\$XH@_HT$HL$UVWH`HD$ H$   HHH@H$       3HtHHHL$      HGdH{0H$       HtH8HHL$      HdHk`HC H+CHHu* HSHHHKhHC H+HHuZ* HCHHKpH{x   ! HtH8HHHoHo Ho(H       HtH8HHHoHo Ho(H       HtH8HHHoHo Ho(HC H+CHHu) HCH8 u6A   H HL$() L, L\$(H HL$(I HH$   H`_^]@SVWH03Ho/ IHHqH=	 HHL$PHuHH	 H+HH
	 HH+HH;sHAHHx	 HH0_^[Hl$XLd$`HH;v( H
N	 H=?	 H 	 HHl$(H+LHT$ HuH)H;v
( H	 MtL;t~( H+H(D$ LL$PHT$ H
	 A   fD$ <L%	 L;% 	 v:( H=	 Hu(( LLILd$`Hl$XI;C wHtH7H;Fs' HH0_^[@SH@HD$ )t$0f(HH	 HHH	 H;	 r   H
+	 HHL$PHtf( 3HH(t$0H@[LAHHI      A@D$HD$H#I;wAHB @D$HD$H#I;w%BAX@A@HB @XB@H$ HIHH# HR HHJHQII      BD$HD$I#I;w(A D$HD$I#I;wAXBBH# HHJ@WH0HD$ H\$HHl$PHt$XIHHH"	 HH(H	 H;	 r(   H
	 JHHt$@Ht,H?HOXKHuH^H~ H6 H3Hu HH\$HHl$PHt$XH0_@WH@HD$ H\$PHt$X)t$0f(HHf.h. z
uHHHmHZ	 HH(HL	 H;=	 r(   H
Ǜ	 HH|$`Ht)Hf(XKHH_w H H3H>HH\$PHt$X(t$0H@_HQII      BD$HD$I#I;w(A D$HD$I#I;wYAXBBH! HHJ@WH@HD$ H\$PHt$X)t$0f(HHf. - z
uHHHmH	 HH(H	 H;	 r(   H
	 BHH|$`Ht)Hf(YKHqH_w H H3H>HH\$PHt$X(t$0H@_@WH@HD$ H\$PHt$`)t$0If(Hf.
P, z
uI HHmHJ	 HH(H<	 H;-	 r(   H
	 rHH|$XHt)Hf(YKHH_w H H3H>HH\$PHt$`(t$0H@_H( HHE3HL9Av0@ HB IJLHB(BDYBXAAL;BrAHAYAX@@@WH0HD$ H\$HHt$PHHH*	 HH H	 H;
	 r    H
	 RHH|$@Ht)HC
 f(H|H_Hq H3H>HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHH5sf(HH HHG H+GHH    HS	 HHHF	 H;7	 rH
Ɨ	 HHNHG H+GHHF 3Ht8 HG H+GHH;r  HGHNHHHH;^ rHHH\$HHt$PH0_E3L9A v(    HAIJTBXABL;A r@WH0HD$ H\$@HHHB H+BHufWmHNHA	 HH(H3	 H;$	 r(   H
	 iHHL$HHt
HT3HHH\$@H0_HATAUAVH   HD$ HXHhHpHx ILH3H9Y~%HƐHIe$HHHcH;G|DH9w~gL H HL$PN HII $LHHL$( HH蓎HL$(7 HL$P+ AMcL;w|H ~hLD  H HL$( HII#LHHL$P HH#HL$P HL$( LcL;o|L$   I[ Ik(Is0I{8IA^A]A\H\$Hl$Ht$WH 3HHH9y~'Hf     HCHHHcH;K|H9{~XHff     HCHH谌HcH;K|H9{~*Hffff     HC0HH而HcH;K|H\$0Hl$8Ht$@H _HLH L@HHSVWATAUAVAWH  HǄ$H  )pILLIHHH$   (-~ $  H$   PH$        HtH$   H33HH$   H$8  H$@  H$H      Ht
H$   HHH$   H$  H$   H$(  H͋ H$P   IH$P  IPH$P  ~ tZH{ HL$@H H$    H!  H$   HT$@H$8  > H֌ H$    H5 H$P   IL$P  HT$@IPHH$   KHL$XHt H|$XH|$`H|$hHL$@f H$P   H! HL$@y H H$x  c Hs H$P  M HL$pHD$ LL$@L$x  H$P  IϻH$   Ht H$   H$   H$   HL$p H$P   H$x   HL$@ L$@  H$8  L+IMu H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v( H$   H$   H$   LHL$0Ht$8HH+HuH*H;v H$   MtL;t H+H(D$0fD$0L$   A   HT$0H$   'L$   L;$   v H$   Hup LLII;K wHtHHH;HsE HA HL$@" IHT$@IPHL$@# tZH HL$@ H$`  . H H$`  HT$@H$x   H{ H$`   H HL$@ ILD$@HT$pIPHH$   HH$   Ht' H$   H$   H$   HL$p HL$@M H H$P   H$ H$x   H HL$@ HL$pTHD$ L$P  L$x  HT$@IqH$   Htz H$   H$   H$   HL$pX HL$@ H$x   H$P   L$@  H$8  L+IMuP H$8   $   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v H$   H$   H$   LHL$0Ht$8HH+HuH*H;v H$   MtL;to H+H(D$0fD$0L$   A   HT$0H$   ]$L$   L;$   v% H$   Hu LLII;K wHtHHH;Hs HǄ HL$@ IHT$@IPHL$@ tZHz HL$@ H$   Hh H$  HT$@H$   H H$  , H8 HL$@5 ILD$@HT$pIPHH$   0EH$   Ht H$   H$   H$   HL$p HL$@ LH% H$P   H H$x   H HL$@ Ic   HL$pHD$ L$P  L$x  HT$@I	H$   Ht H$   H$   H$   HL$p HL$@8 H$x  ) H$P   fW$   Ic       Ht
H$  HHH$  L$   HH$  'MDHA    {   fMIH$  H$  H+HH;rx H$  H$@  H$8  H+HL;rN H$8  JHAHL$0  E;   |D@ E;     IcH$  H$  H+HH;r H$  L$H$   HuHH$   H+HL$   IH+HH;s0   IfHtI$HHHI@H$     II;vl L$   H$   H$   LHL$0Ht$8IH+HuH*I;v) H$   MtL;t H+H(D$0f$   MA   H$   H$   L$   L;$   v H$   Hu LLII;K wHtHHH;Hs L$0  L$0  ANH' HL$@L IHT$@IPHL$@M tZH HL$@ H$`  X H H$`  HT$@H$x  
 H H$`   H HL$@ ILD$@HT$pIPHH$   @H$   HtQ H$   H$   H$   HL$p/ HL$@w H H$P  B H
 H$x  , H< HL$@ HL$p~HD$ L$P  L$x  HT$@I蛰H$   Ht H$   H$   H$   HL$p HL$@ H$x   H$P   L$@  H$8  L+IMuz H$8   f(V$   H$   HuHH$   H+HH$   HH+HH;s+   HHt
HHHBH$      HH;v H$   H$   H$   LHL$0Ht$8HH+HuH*H;v H$   MtL;t H+H(D$0fD$0L$   A   HT$0H$   ~L$   L;$   vF H$   Hu3 LLII;K wHtHHH;Hs H| HL$@ IHT$@IPHL$@ tZHK| HL$@ H$`  
 H H$`  HT$@H$x   H>~ H$`  M H	| HL$@V ILD$@HT$pIPHH$   Q=H$   Ht H$   H$   H$   HL$p HL$@ LHF H$P   Hx{ H$x   H{ HL$@ IcUDHL$pHD$ L$P  L$x  HT$@I-H$   Ht6 H$   H$   H$   HL$p HL$@\ H$x  M H$P  > $   Ic]D    Ht
H$  HHH$  L$   HH$  REDHA}D v   MIH$  H$  H+HH;r H$  H$@  H$8  H+HL;r~ H$8  JHAHL$0  E;eD|D    E;uD  IcH$  H$  H+HH;r! H$  L$H$   HuHH$   H+HL$   IH+HH;s3   ID  HtI$HHHI@H$     II;v
 L$   H$   H$   LHL$0Ht$8IH+HuH*I;vY
 H$   MtL;tA
 H+H(D$0f$   MA   H$   H$   .L$   L;$   v	 H$   Hu	 LLII;K wHtHHH;Hs	 L$0  L$0  ANH$   H$H  9H$   H$@  H$  Ht H$  H$  H$  H$   H$  Ht H$  H$  H$  H$   H$  Ht H$  H$   H$(  H$    H$8  Htu H$8  H$@  H$H  H$   P H$   Ht= H$   H$   H$  H$    H$   Ht H$   H$   H$   H$    ($  H  A_A^A]A\_^[HATH   HD$0HXHhHpHx IIHH    E3Ht
HL$8HIHD$8Ld$PLd$XLd$`   r Ht
HL$hHIHD$hL$   L$   L$   H\$ LL$8LD$hHHHl$XH+l$PHH;otH4 Ht
HfHL'HoAIH~?     HD$XH+D$PHH;r HHD$PHHHHcH;G|H$   Hts L$   L$   L$   HL$hQ HL$PHtA Ld$PLd$XLd$`HL$8( L$   I[IkIs I{(IA\HWATAUHP  HD$HHXHhHpEEHH   DÍSHL$P0 HL$  HHL$P} HL$  Ht HL$`@_HT$ HL$P  HHuHL$  HL$  HHL$P HL$  Hot HL$`^HT$ HL$P HHtHL$ I 9   |~HL$ D HHL$P HL$  Hs HL$`x^HȲ.\Hȋ HT$ HL$P# HH'tHL$  ;   ~HL$  HHL$P7 HL$  HDs HL$`]HT$ HL$P HHsHL$ b 9^D|{HL$ ` HHL$P HL$ 5 Hr HL$`]HȲ.[Hȋ HT$ HL$P? HHCsHL$  ;~D~EuEuHL$P       |~HL$  HHL$P3 HL$  Hs HL$`\HȲ.[Hȋ9 HT$ HL$P HHrHL$ I ;   ~Eu
HL$Pw HL$Pj L$P  I[ Ik(Is0IA]A\_@VWH8HHH;  LZ H\$XHZLd$0MIgfffffffL+IILIIH?LurH\$XLd$0HH8_^LQHl$`Hi HII+HLIIH?LM;   DL$P3MD$(D$PIHˈD$ `lHo HH;t@ H' H(H;uHN IH+NHHHH?HHGHHHHO Hl$`H\$XLd$0H8_^Mu3HO(II+HHHH?HL;wZKDL$PHH3MD$(D$PHӈD$ kLG HV 3LOD$(D$PHˈD$ HG HgMtLIHHO HN IH+NHHHHH?HtLOLF HVH>HG HHH8_^HT$VWATH0HD$(H\$PHl$`AAHHE3Dd$ AL$p HtHIHLcLc Lc(D$    H  DDHHH\$PHl$`H0A\_^H\$Hl$WH HY3HHtLHt$0Hq H;t0D  HKHt HHkHk Hk( H0H;uHO Ht$0H\$8HoHo Ho(Hl$@H _HWATAUH   HD$0HXHhHpMLHIp    tYHWo HHE HL$8 Hy HD$8HT$xHL$PD H HD$8H`n HL$8 ITLA    tH~$HF    tIIL$HyH;   H^    uH_HE0H9puHxH93uH;H{HU0H92u8    tH'HH    uf     HH     tH
HU0H9r       tH"HHG    ufHH@    tHJ   IKHHH;NuH$HY    uH_H;HFHAHFHHHE0H9puHHHFH90uHHHHFHAH   L   L;tAA 
     HE0H;x  ff          HH;udHK    uƁ   ƃ    HH3HK    tH   H      HA   u}Ɓ    HZ    uƁ   ƃ    HH3H    tH'HA      H   uzƁ    HH[HE0H;x   HA   u Hƀ   Ɓ    HH]3HK      ƃ   HAƀ   HH2UH   u HAƀ   Ɓ    HH2H      ƃ   Hƀ   HH2Ƈ   H   Ht| 3H   H   H   HNp\ HNXHtN H~XH~`H~hHN@9 HN H' HE8HtHHE8HL$ I$HID$HAHD$(HD$(HE HD$ HL$ HIE HAIEIL$   I[ Ik(Is0IA]A\_H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ v HHL$0H^HHE HHEHAH\$8H9_wH;_ vk HHtH;tX LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$hiBHo LH;t2HXHHt HKL+LkLk H0HCH;uLg Ld$hH\$pHl$xHH@A]_^Hl$Ht$WH     HHH   H\$0fD  HVHH   H6Ht, HOp3H   H   H    HOXHt HO@3HGXHG`HGh HO1 H     HyH\$0Hl$8Ht$@H _ATHPHD$8H\$`Ht$hH|$pIIL⹨    HHD$0HD$@Ht+$   L$(H$   HL$ LLIHClHH\$`Ht$hH|$pHPA\ATHPHD$8H\$`Ht$hH|$pIIL⹨    HHD$0HD$@Ht+$   L$(H$   HL$ LLIHClHH\$`Ht$hH|$pHPA\I;tXWH H\$0Ht$8I3HZ HHt_ HKH3HsHsK H0HCH;uHt$8H\$0H _@SH03MM؈D$(D$@HLIMIHˈD$ @CH0[H\$Ht$WHPHHIHHuE3LC(L+IH{ HH+HI;s;3LLKD$(D$`   HψD$ L_L[ H\$hHt$pHP_H;v HH|$8LD$0HD$0HT$@L(D$0HfD$0<H\$hHt$pHP_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,CNH;}8D$8f    HHH;Hf(DfYf)D|HL$ LLHH\$pHH@_^]@SH HLE3LHHIHH+HLMM~+@ HIM;HIfB(DfBXDfB)D|HI\HH [HT$VWATH0HD$ H\$PHl$hH3t$`M`Il$HuH9HH;v"H    H HHuHt|"HHoI\$HHtH;tQ"HtH;t<"̄t2"H;t. Ht
HSHH7H_HHH+HLMM~!    I$f(Hf)HI;|LHIHH\$PHl$hH0A\_^H   HL$ LD$PHB@HD$(HHz HT$0HHT$HI HAI@HAI@HAI@ufWY HĈ   H$   HL$@hY HĈ   HT$UVWHPHD$ H$   H3ۉ\$pHAHpHt$0fWD$@HuH6HH;v H,    H HuHt HHwHt.HH;t~ ̄tt ̄tj HwHHH+HLMM~ (x      Hf)HI;|LHHL$(HH$   HP_^]HT$VWATH0HD$ H\$PHl$hH3t$`M`0Il$HuH9HH;vH    H HHuHtHHoI\$HHtH;taHtH;tL̄tBH;t> Ht
HPHH7H_HHH+HLMM~!    I$f(Hf)HI;|LHIHH\$PHl$hH0A\_^Dʅu3ÃuA3҃=r!Aɸ   +i+ȋDHp     MIIH+HHHHiɫL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ   +i+ȋH [At+;s
H|$0H [ÍU  H|$0H [LDA   H   Ip     AtlEtgAuE\3҃A=r#E   AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ   AA+iD+'EIMIIH+HHHHiɫL+IADʅu3ÃuA3҃=r!Aɸ  +i+ȋDH   MIIH+HHHHiL+A@SH ADuH [Ã3H|$0+ÿ;r-H|$0Aȸ  +i+ȋH [At+;s
H|$0H [Í  H|$0H [LDA   H   I   AtlEtgAuE\3҃A=r#E  AA+iD+*EALIIIH+HHHHiL+EteAt_3҃A=r)AADȸ  AA+iD+'EIMIIH+HHHHiL+IAH\$Hl$VWATH0LHyHHHL$PH|$hAtH$IHD$hHL$ IAI;LD$ HMHHLE3H+HHH+HT$PHL$CI;}2HE HHI;fDf(Lf)DHE fLfL|HT$PLMHH\$XHl$`H0A\_^HWATAUAVAWH  HǄ$X  HXHp)p)xD)@D)HD)PIILfEWfA(3L$  I H$   H$   E3L$   L$   H$   -6f($  H$   6fD($P  AM Ht
HL$@HIHD$@Ll$XLl$`Ll$hMc   MI  fD  H$   5$   H\$XHuIHT$hH+HHL$`HH+HH;sHAHD$`   HH;v; HL$`H\$XHT$@HH$@  H$H  HH+HuI'H;v HT$@HtH;t H+H($@  fD$0L$   A   HT$0HL$@Ht$XH;t$`v H\$@Hu MLHI;K wHtHIH;Hsg IH$   p4f(Hu D
 fAWfD.ztG f(AX$@      Ht
HL$pHIHD$pL$   L$   L$   McgDMX  H$   3$   H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;v\ H$   H$   HT$pHHT$0H|$8HH+HuI'H;v HT$pHtH;t H+H(D$0f$   L$   A   H$   HL$pH$   H;$   v H\$pHu MLHI;K wHtHIH;Hs IIVHuIIN(H+HI^ HH+HH;s;HCIF    H;v- I>H|$0H\$8IN IvHH+HuI"H;v HtI;>t H+H(D$0f$   L$  A   H$   IIvI;v v I>Hu MLHI;K wHtHIH;Hsn IVHuIIN(H+HI^ HH+HH;sDHCIF    H;v% I>H|$0H\$8IN IvHH+HuI"H;v HtI;>t H+H(D$0f$   L$P  A   H$   IIvI;v v I>Hu MLHI;K wHtHIH;Hsf AA9   ~Eff     HcHD$`HL$XH+HH;r1 HL$XHISA;   |IVHuIIN(H+HI^ HH+HH;s3HCIF    H;v I>H|$0H\$8IN IvHH+HuI"H;v HtI;>t H+H(D$0f$   L$@  A   H$   IwIvI;v vG I>Hu9 MLHI;K wHtHIH;Hs AA9_D~FD  HcH$   H$   H+HH;r H$   HIwRA;_D|$   ubH$   Ht_ L$   L$   L$   HL$p= HL$XHt- Ll$XLl$`Ll$hHL$@ &     ) Ht
H$  HIH$  L$   L$(  L$0  H5 8D$   Ic       Ht
H$   HIH$   L$   HH$   ) f(IH$   HH$   H+HHt:H;r H$   4HH$   HH$   H+HH;rIH+HHt= H;r5 H$   <HH$   H$   H+HHH;r<7	           A;     7	    HcH|$`Ld$XI+H  G;  LkL;r Ld$XI   A   LR H0CY4fAWH$   H$   H+H|)G;}"HH;rA H$   4=   DBH$p  N H H$  :   H H$   H$p  - H$    H
_P HL$ LDËH
K 讑   DBH$p   H~ H$  :   HK H$   H$p   H$   . H
/O HL$ LDËH
 .E3AA9   ~DHcH$   H$   H+HH;r H$   HINA;   |D8$      H$   Htv L$   L$   L$   H$   Q H$   Ht> L$   L$(  L$0  H$   H$   Ht L$   L$   L$   HL$p HL$XHt Ll$XLl$`Ll$hHL$@    H$   Ht L$   L$   L$   H$    H$   Htl L$   L$(  L$0  H$  G H$   Ht4 L$   L$   L$   HL$p HL$XHt Ll$XLl$`Ll$hHL$@ L$  I[0Is8A(sA({E(CE(KE(SIA_A^A]A\_HPWH  HǄ$   HXHhHp IHH    3Ht
HL$@HHHD$@Hl$XHl$`Hl$h   DBH$    H$   HD$8D$0D$(HD$@HD$ L$  LHHH$   H$   x Hx H$   " t7H$   H$   H H$  LHAH$    H|$XHHL$`H;v HL$`H|$XHT$@HHT$pH\$xHH+HuH'H;v HT$@HtH;tp H+H(D$pfD$pL$  A   HT$pHL$@aHt$XH;t$`v/ H|$@Hu LLHI;K wHtHHH;Hs H$  HHT$@PH$   * HL$XHt~ Hl$XHl$`Hl$hHL$@e L$  I[IkIs(I_HWH   HD$ HXHhHpIIH   = 3Ht
HL$PHHHD$PHl$hHl$pHl$xHH HL$( HT$(HL$PsJHL$( HXH HL$( HT$(HL$PEJHL$( LHT$PHASAEHT$PHvHHHT$PPH\$hHt,H|$pH;t H H(H;uH\$hH- Hl$hHl$pHl$xHL$P L$   I[IkIs I_HHPVWATH   HǄ$   HXHhIIHH    E3Ht
HL$ HIHD$ Ld$8Ld$@Ld$HH,G H$    H$   HL$ IH$    HF H$   o H$   HL$ HH$   m LHT$ HAS   $ Ht
HL$PHIHD$PLd$hLd$pLd$xE3E3HT$PHLLD$ HT$PHAS(HMHHT$ PH\$hHt,H|$pH;t H H(H;uH\$hHm Ld$hLd$pLd$xHL$PT H\$8Ht,H|$@H;t H H(H;uH\$8H Ld$8Ld$@Ld$HHL$  H HHN; L$   I[ Ik0IA\_^LL$ LD$VWATHpHD$(H$   ILHH\$    赾 HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@HH;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt譽 Ht$XHt$`Ht$hHL$@蔽 HH$   HpA\_^@WHH$H\$ HH;   MH LR f     H0I0I0I0L;tcMHI LII;tHIHIMZIYI;tHIHIM;tI	III
MZIYI;tHIHIH;uIIH\$ H_H\$UVWH@HBBHHD$(HBD$8HD$0HHxHHxH|$`tH#HHD$`HL$hHڃH;HT$hHMHHHL$ LH+E3HH+HHH,C4H;}8D$8f    HHH;Hf(Df^f)D|HL$ LLH~4H\$pHH@_^]H\$Hl$Ht$WATAUH I@ HMI+@IHHHH    HK	 HHHK	 H;K	 rH
1K	 HHHOHK	 HLHHzK	 H;kK	 rH
J	 赧LLGLG HGHN E3H+NIHHHO(HF HoH+FHHt-H;r HFHHLHLHF H+FHH;rHV HOI$H+VHHHOHHH;tfL)HH;uH\$@Hl$HHt$PHH A]A\_H\$WH@HHHL$ HHBE3HAHBHAHBHAHHHzHHH+HLMM~AL\$0LL$( IIIM;fB(DHfBYDHHfBXDfB)D|HL$ LHcHH\$PH@_H\$Ht$WH IHHMuhHQ(HI	 HHHHI	 H;I	 rH
'I	 H3HH9W(v,@ HHHHDH;W(rH\$0Ht$8H _L
H\$0Ht$8H _H\$Ht$WH IHHMuhHI	 HQ(HLHHI	 H;H	 rH
H	 BL3LH9K(v,I+JHIIAH;K(rH\$0Ht$8H _L
H\$0Ht$8H _HUVWATAUAVAWH   HD$8HX)p)xD)@MLLHA H+AH  Ix   fWLHK H
l!	 fAn.$  H      H$  H#H;u*H HD$ L
 MH H
!	 
9E3MIL$HtPI$D  Icf/v
IL;r/Ha HD$(HM HD$ MH H
 	 H= 	 H$  L$(  ME M+EILD$0H$  H$(  HHDHD$0L;HBHLMH HvLMHQ H!IIE I+EHHu I}I$Mm L+I   L;LFIt$L;LFH藶 Ht
HL$@HIHD$@$  L$  HHL$@It$   R Ht
HL$pHIHD$p$  L$  HHL$pIM9|$   D D  Hc<HD$`HL$XH+HH;r HL$XfA(^<H$   H$   H+HH;r H$   f(ߴ D HI;t$rIM   D  Hc<fEnEHD$`H+D$XHH;re A\HD$XY<YX5-	 H$   H+$   HH;r+ H$   \4F	 YXHD$`H+D$XHH;r HI;YH$   Ht蓴 L$   L$   L$   HL$pq HL$XHta L|$XL|$`L|$hHL$@H f(fWL$   I[HA(sA({E(CIA_A^A]A\_^]HATH   HD$ HXHhHpHx IHH    E3Ht
HL$PHIHD$PLd$hLd$pLd$xLOHD$0Ld$8(D$0fD$0LD$0HT$@HL$PHT$hHuIHL$xH+HH\$pHH+HH;sHG HHCHD$p=H;vv HD$PHD$0H\$8(D$0fD$0LO LD$0HT$@HL$P$HHT$PHPLHT$PHAS0HMHHT$PPHL$hHtĲ Ld$hLd$pLd$xHL$P諲 L$   I[IkIs I{(IA\HWH  HD$PHXHp HH3LQM  L	E3HH      D  C$  H$  H#H;t,$  H$  H#H;wIHcI;|E      Ht
HL$ H3HD$ HD$8    HD$@    HD$H    AEHT$ H   DBH$    H?HcHL$@LD$8I+HgfffffffHHHH?HH;r LD$8HIH$    HH #H HHg #H$   H$    HHL$Xj HZ HD$XHHL$p' Ho HD$XH9 HL$XŰ L$  I[Is(I_HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;vH    H HHuHtbHHwI\$HHtH;t7HtH;t"̄tH;t Ht
H(HH/H_HHH+HLMM~I$f(Hf)HI;|LHIuHH\$XHl$`H0A\_^HHXWH   )p)xD)@AD)HD)PD)XfD(EYDY D)`fD(fA(\ D
! fE(L$   H$      f(fA(fA(EYY= gkf(fD(fT
 f/
 vHm! H
V2 fA(AYí f(fA(Y-8 YXf;vT%S  ff(AYA\DXfnf(fA(fD(YA^^XYf;r(|$pL$   f(A(sE(CE(KI[E(SE([E(cI_HWATAUAVAWH   HǄ$   HXHhHp IILLIX   蛭 E3Ht
HL$pHIHD$pfW$   L$   HHL$pEIH9_~GfH/H$   H$   H+HH;rK H$   HD HAHIcH;G|    Ht
HL$@HIHD$@L|$XL|$`L|$h   Ѭ Ht
H$   HIH$   L$   L$   L$   H$@  HD$8$8  D$0$0  D$(HD$@HD$ L$   LD$pIIHl$`H+l$XHH;ntLH` Ht;HH;v?H    H= HuHtHL>HnAIH~=fD  HD$`H+D$XHH;r HHD$XHHHHcH;F|H$   Hts L$   L$   L$   H$   N HL$XHt> L|$XL|$`L|$hHL$@% H$   Ht L$   L$   L$   HL$p L$   I[0Ik8IsHIA_A^A]A\_Ht$WLE3IsI{HP  H\$E3H   H_HtHBHtL@E3IK IA@IIYHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIYDDHtHBHtL@E3IK IA@IIIL;YDDL;}=HtHBHtL@E3IK IA@IIIL;Y|IL;H\$Ht$_H\$M;IML   HL MtIBHtH3HHHtHA3H	tL@E3HtHP3I@BYJ0HtH3CYI@IL;\CD|H\$HWATAUHPHD$ HXHhHp )p)xf(f(LLHR	 HHyH|$pHr3HuH9HH;vrH    Hp HHuHtNHHwI\$HHtH;t#HtH;t̄tH;t  Ht
H HH/H_HHH+HLMM~#f     I$f(Hf)HI;|LHIXA}Au IL\$PI[(Ik0Is8(t$@(|$0IA]A\_@VWATAUAVH0HD$ H\$hHl$pLLH HHyH|$`Hr3HuH9HH;vH    H HHuHtHHwI^HHtH;tHtH;t̄tH;t Ht
HHH/H_HHH+HLMM~%fff     IFf(Hf)HI;|LHINIFIEIF IE IH\$hHl$pH0A^A]A\_^HHHUVWATAUH`HD$ HX)pHHHPfWp3HuH6HH;vH,    H HuHtyHH~IHt$I;tS̄tĪt?H~HHH+HLMHM~"(J ff     Hf)HI;|LHHL$(H|$0H|$8t$@HnH$   LLLLIH}Ht,IHHH;t̄t̄tLLIHwLMLMIHH+HLMM~( HE f)HI;|HHL$(!~(HH$   (t$PH`A]A\_^]HL$VWATAUAVH0HD$ H\$pHl$xMLHHj3HuH9HH;vH4    H HHuHtHHoIt$IHtI;tpHtI;t[̄tQH;tM Ht
HHHHwHHH+HLMHM~ I$f(Hf)HI;|LHI訿HwHt$hMMMEIIH|MMMEMtMtIHIL;tMt:MtIHIL;t{MtIHIL;t^IIHNLNLNIHH+HLMM~IE f(Hf)HI;|HIʾID$G(MH7	 H?MH%	 HHH\$pHl$xH0A^A]A\_^HL$UVWATAUH0HD$ H\$pLHHj3HuH9HH;vxH4    Hv HHuHtTHHoIt$IHtI;t)HtI;t̄t
H;t Ht
HHHHwHHH+HLMHM~I$f(Hf)HI;|LHIdHwHt$hML$ MD$IIHyML$ MD$MtMtIHIL;tUMt:MtIHIL;t3MtIHIL;tIIHLNLNIHH+HLMM~"    ID$f(Hf)HI;|HIL$xAD$(G(HH\$pH0A]A\_^]HHHVWATAUAVH`HD$ HXHh )pHLHPfWp3IHuH,I;v5H4    H3 HuHtI$I\$IHt$I;t̄t̄tI\$HHH+HHHHH~( fI$f)HH;|LLIHL$({H\$0t$@It$H$   HuH,I;v^L,    I\ HuMt=HH^Ht$I;t!̄t̄t
H^H~$(, ffff     Hf)HH;|LLHHL$(A\$ IL\$`I[@IkH(t$PIA^A]A\_^HHHVWATAUAVHPHD$ HXHh LHHr3IHuH/I;vRH<    HP HHuHt.HM HuI}IHtI;tHtI;t̄tH;t HtHkHE H] H}HHH+HLMHM~@ IE f(HE f)HI;|LHI7I}H|$0fWD$@HuH$   HuH,I;vCL$    IA HuMt"HH~Ht$I;t̄t̄tH~HHH+HLMM~(  Hf)HI;|LHHL$(IEE HL\$PI[@IkHIA^A]A\_^HL$UVWATAUAVAWH@HD$0H$   MLHHjH3HuH/H;v.H4    H, HHuHt
HHoIuIHtI;tHtI;t̄tH;t Ht
HHHHHwHHH+HLMHM~ IE f(Hf)HI;|LHIHoH$   MfMuH9HL;v)J4    H' HHuHtHM LeIvHtI;tHtI;t̄tI;t HtHLHE H] HuHHH+HLMHM~D  If(HE f)HI;|LHIIMO HGHD$ L
' DH H
w	 LI      H9_vbH@ Ic$   H$   I#I;wIL;Or/H HD$(H HD$ LH H
	 &HMHtaHU Hc$   H$   I#I;w
HH;r2HN HD$(H" HD$ LLH& H
	 輈HH$   H@A_A^A]A\_^]HL$UVWATAUAVAWH0HD$ H$   LHHrH3HuH/H;vH    H߰ HHuHtHM HuI^IHtI;tHtI;t}̄tsH;to HtHHE H} H]HHH+HLMHM~ If(HE f)HI;|LHIȳHuHt$xMfMuH9HL;vJ    Hگ HHuHtHLfI^HtI;tHtI;t̄tyI;tu Ht
H HH>H^HHH+HLMM~IFf(Hf)HI;|LHINղAF E HH$   H0A_A^A]A\_^]@SHPHD$ HHL$( L3H H HL$( HT$(HHL$( H HL$(x HT$(HHL$(~ HO HL$(L HT$(HHL$(R H HL$(  HT$(HHL$(& H HL$( HT$(HVHL$( H{ HL$(Ȭ HT$(H*HL$(ά HP[@SH@L
E3MJL$0HILT$(HH+HLMM~,fI
Hf(HIfBXDM;fB)D|HL$ HHH@[HL$WATAUH@HD$0H\$hHt$xHHٹ   ߓ HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vHHKHCHC HvHHHK(Hw H9wvm LgL;g v] 3D$(D$pD$ LKLCHI;HC HH\$hHt$xH@A]A\_@SH HHH [ @SH HH  D$0    HHH [@SH HH  D$0    HHH [H\$UVWH0Hq HH9qv H_H;_ vq H9_wH;_ v_ H/H9wwH;w vJ HtH;/t: H;tsDL$PHW 3D$(D$PLHΈD$ QHw HH;t?Ld$XHXE3HHt訑 HKL#LcLc蔑 H0HCH;uLd$XHo H\$`H0_^]HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LtHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYH IK HL$` H HD$`HT$8HL$x H HD$`H= HL$`O HQ0D$( H$   HD$ LLiLHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_HL$SVWH@HD$0HHHA0HD$h    ueHLN   D$(LL$ LHHD$h    HEHD$hHD$xLHHHLHVHwHGHD$hH@_^[LWH   HD$0I[IkIsIAHHHH9A8rYH IK HL$`֥ Hƨ HD$`HT$8HL$x H HD$`H HL$`/ HQ0D$( H$   HD$ LL٬LHF8HN0H;uHAHN0HHN0HA(@tHHF0H;uLHCHF0H;XuLXIMCI        D  I HHH;   LIA    u)ƀ   AƁ   I HHƁ    I HP  H;PuPHHHHHBH    uHPLBI HAHF0H;PuHHI H;uHHHHII ƀ   I HHƁ    I HHLI@HI@    uHHHAI@HF0H;HuL@HAH;HuL@L IHLA   L	A    u)ƀ   AƁ   I HHƁ    I HP   H;uRHHHAHHA    uHPLBI HAHF0H;PuHHI H;PuHHHHQII ƀ   I HHƁ    I HHLAI HAI     uHHHAI@HF0H;HuL@HAH;uL L@ILALBI     HF0HHƁ   L]HHE HL$   I[IkIs I_H\$Hl$ VWAUH@I HHL$0HI@E3HAH\$8IHL*HtH9_wH;_ v  HHL$0H^HHE HHEHAH\$8H9_wH;_ v HHtH;tء LFL;tmDL$`HW 3D$(D$`HˈD$ Ld$h	AHo LH;t2HXHHtH HKL+LkLk4 H0HCH;uLg Ld$hH\$pHl$xHH@A]_^D$HH)t$0f(
 f/vLD$PH H
t f.z+u)  "   H  fW (t$0HH)|$ f(X= f.= zuf((|$ (t$0HHf(ʆ \= ^(|$ Y(t$0HHH\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,CcH;}:D$Hfffff     HHH;f(DfYf)D|HT$ HL$0LLH$   HHP_^]HL$WHPHD$ H\$hHt$xHH3t$pN HtHHHHsHs Hs(D$p   HH H# HL$( HT$(HPHL$( HH\$hHt$xHP_@SH`HHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HLHIHH+3HLMM~\LT$@L\$8H|$pH|$(f     IIHI;f(Df\DHf(LHfYHfXLf)L|H|$pHL$ HT,HH`[HHPUVWATAUHPHD$ HXH3퉬$   Mh@LhM`L`It$HuH9HH;vH    H HHuHtnHHwI\$HHtH;tCHtH;t.̄t$H;t  Ht
HHH/H_HHH+HLMM~,f     I$IE f(fYHf)HI;|LHHL$(HH$   HPA]A\_^]HL$ATAUAVH@HD$0H\$hHt$pH|$xMHH3HAHA HA(HtaHUUUUUUUH;v9HoHHCHC L$MJHK(3D$(D$`D$ LKMHHJHC H\$hHt$pH|$xH@A^A]A\HL$SUWAUAVH0A   LH  AM  A
e  E3AADEDE+t3AAAAD+u	AD+AHp     HiM  HHH+HHHHiH+A;u3IչN  o3ɍPSDǪH0A^A]_][3Ht$hM  Ld$(E3L|$ DAD|$pM  Ip     E   uD+;sD3D3U  uA`A;uW3҃=r!˸   +i+(ƋHIHHH+HHHHiH+ȋыuAAv+;s<U  A;uAU3҃=r#Ëظ   +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ   +i+,Ӌ蛨D؅t+D;sDE;U  AIqD|$pH|$`tV3Ҹ=r)D   DAAA+iD+֋=sDpDV  Ht$hEtAD3AAD_L|$ Ld$(H0A^A]_][HL$SUWAUAVH0A   LH'  A  A>  E3AADEDE+t3AAAAD+u	AD+AH   Hi  HHH+HHHHiH+A;u3Iչ  ?3ɍP#D藩H0A^A]_][3Ht$h  Ld$(E3L|$ DAD|$pM  I   E   uD+;sD3D3  uA`A;uW3҃=r!˸  +i+(ƋHIHHH+HHHHiH+ȋы豨uAAv+;s<  A;uAU3҃=r#Ëظ  +i+$HIHHH+HHHHiH+؅u]3+=r!ݸ  +i+,ӋkD؅t+D;sDE;  AIqD|$pH|$`tV3Ҹ=r)D  DAAA+iD+֋=sDpD  Ht$hEtAD3A輦AD/L|$ Ld$(H0A^A]_][H\$Hl$WH HZHyHHHtH;tHtH;t̄tHt$03H;_tHʔ Ht
HUHH7HH_HH+HLMM~ HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _HWATAUAVAWH   HǄ$   HXHhHp )p)xD)@IHHHY    z E3Ht
H$   HIH$   fEWD$P  L$P  HH$   *Lt$pLt$xHt$HH^HHtH;tHtH;ts̄tiH;]t!HM ` HtHHE Lu H]HHH+HLMIM~2(
] fffff     Hf(fWHE f)HI;|LHHL$@!H|$pIH\$xH$   H9$   v H$   HD$0Ht$8(|$0)|$0L|$0Ld$8    H  uIHGH;  (D$pf$   HuHwH$   H$   H;0uHpf$   HuHGH$   H$   H;uHALpfD$`HuHGHD$hHL$`H;uHAHHD$HHl$PLmMufA(H$P  HL$@f(YvHl$ H$P  HD$(Lt$Ht$PIHH+HLM3M~9ffD  If(HE f(fYf\f)HI;|MHT$ HL$@gf$   Mu# E3MME3M;cw	 It$H$   Hu MLI;s rݐ 6HuH_H;uH_H(H\$xMu MMM;cw LHt$8(|$0HW0HH  uIH_H$   HH;$   vV H$   H$   HD$ Ht$((D$ fD$ HI  Hl$`H$P  HD$hLd$ Ht$(ffff     HCLkHD$HHl$PH} ufA(H$P  HL$@f(Y3Mu MM$I;s r \Ll$HL$PLMIHH+HLMIM~>fff     IE f(fYHE f(fXf)HI;|HT$`HL$@H(H;_uHH;_IDMu	 MM$I;s r HHH$   Htu L$   L$   L$   H$   lu L$   I[8Ik@IsHA(sA({E(CIA_A^A]A\_D$SH`
U )t$P)|$@f/=G HD)D$0D)L$ fEWf(fE(   f(\f(L$pf(At f(\f/
 v
fA(\XfA.z%u#\LD$pH H
"3 |$pD5 AYf(s D^fA.zuLD$pH H
2 f/5@ rf(Hyt0 f/v*ff     fA(f(\Xf/^DXwf/v*ff     f(fA(^Xf/\DXwf(H{(t$P(|$@D(L$ DXfA(D(D$0H`[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
 HR LH2 L
! HD$ bfAn D$XHD$XH#H;u'H
 H L
 H1 HD$ LA9 *H
f HǪ L
 H1 LHD$ H	 H
	 Ht$PHHH	 H;r"H
N	    _H
	 HH	 LHH	 H;rH
	    ^LHIPHIL;t3     HHH;ufn8 HLD$ LIP^fnE \A YYf(Y\Y
O A A   X
 cHt$PH\$`IH0A\_]LD$SWATAVHxHB MIH+BHLHN  H
 )t$PfWLH0 )|$@f(IH      fn+$   H$   H#H;u*H
 H L
 Hb0 LHD$ UA$f/w*H
q Hʨ L
 HD0 MHD$ $   H$   H#H;u*H
. H L
x H0 MHD$ <LO H
  H$   L+OHt$pH0 LILl$hL|$`OHG H+GHHu[ HG H_   LL+IL;LFH
. 	 H+HHD$0L,    H 	 H$   IH	 	 H;r%H
 IE\H
 H$   H HIH H;rH
V I\HHO E3H+OIHHtBL$   H;r L$   HGHHLILHO H+OHH;rE3L$   Ht$pIL- Ll$hHH;t LHH;u IA^$M   % L$   ff     fAn HcHP\f(f.f(fTY\XzuAf/v   D fnHY\D I;rLD$0f(IHl$ `L|$`(t$P(|$@H$   IHxA^A\_[fWj_IHxA^A\_[H\$UWATH0HLHIIH@D$XHD$XH#H      H;v*H
Q H LHp- L
 HD$ \fAn D$XHD$XH#H;u'H
 Hl L
E H6- HD$ Af/f w*H
 H L
 H- LHD$ H; H
, Ht$PHHH! H;r"H
    [YH
 HH LHH H;rH
p    &YLHIPHIL;t3HHH;ufnE  HLD$ LI^P\A YYf(Y\Y
 A A   X
K ]Ht$PH\$`IH0A\_]HHHUVWATAUAVAWH   HD$@HX)p)xD)@MMHHHB H+BH  Iy   fWLH+ H
= HfAn.$   H      H$   H#H;u*H] HD$ L
1 MH+ H
 E3MIL$HtKI$Icf/v
IL;r/H HD$(Hۢ HD$ MH\+ H
 x[H= H$   Ll$0LF L+FILD$8H$   HD$0HHDHD$8L;HBHLLH2+ H
JLMH* HHF H+FHHD$8H<    Hu LHHh H
Y H;r HH
 VLHC H
4 HHH/ H;rHH
 kVHIHN H+NHHt/@ H;r HFHIHHN H+NHH;rH/HH;tf     L(HH;uHF H+FHHu H~I$Ln L+I   L;LFIt$L;LFHJi Ht
HL$HH3HD$H$   L$   HHL$H覻3I9t$vMD  Hc4HD$hHL$`H+HH;r HL$`fA(^HI;t$r3HM   HcHpfEnEHL$hHHT$`H+HH;r HL$hHT$`A\Y4f(Y YXH+HH;r] HT$`Y4D \D HI;g3Hl$ MLD$8f(H$   HYHL$`Htg Ht$`Ht$hHt$pHL$Hg HfWXHL$   I[PA(sA({E(CIA_A^A]A\_^]@UAUAVAWH   HB MIH+BLLH  I@ I+@H  H
 LH' )$   fW+H
 H' LMACf/w*H
 H؞ L
ɞ H' MHD$ VLE IU H$   L+EI+UH$   IHH$   H=U L$   HT$@L$   HL$@E3)$   I;H$   Ld$HHCH' MHHLEHU' LLHEL$   H$   L\$0HD$(H$   HL$PMLIHD$ %IE I+EHHu HE I}H+EHHu~ Iu HM H]I+uHH+HHH;w
HH+H=    H;HFI@^d f(HtyHT$xLD$pffffff       Ic\IHf(\HYf(YYYXf(\YAXAXL;rHD$`LL$XLD$Pf(IHD$ VL$   H$   ($   ($   H$   H$   IHĸ   A_A^A]]fWUIHĸ   A_A^A]]LL$ LD$VWATHpHD$(H$   ILHH\$    Ed HtHL$@H33HHD$@Ht$XHt$`Ht$hI;   H\$0H\$8HtHT$@Hv*H;tkHHHHLL;tI H
IHHWLCL;tIHI H
HW LC L;tIHI H
HW(LC(L;tIHI H
H0H$   H0UHL$XHt=c Ht$XHt$`Ht$hHL$@$c HH$   HpA\_^HAUAVAWH   HǄ$  HXHpHxL` )p)xD)@D)HD)PD)XIHLH y DfEWfE(й   b HtH$   HE3E3IH$   L$   L$   L$   H|$pH\$xL$   L$   HL$pfD(D$`HL$p$     8b Ht
H$   HIH$   L$   L$   L$   Mc   IH$   HM^   HL$p$   H$   HuIH$   H+HH$   HH+HH;sHAH$      HH;vz H$   H$   H$   HHT$0H|$8HH+HuI*H;vOz H$   HtH;t7z H+H(D$0fD$PL$   A   HT$PH$   %H$   H;$   vy H$   Huy MLHI;K wHtHIH;Hsy IHL$pHw =( fWfD.ztfD(EX_ AX$      4` Ht
H$  HIH$  L$   L$(  L$0  McoDIH$  FM]  fHL$pD$PH$   HuIH$0  H+HH$(  HH+HH;sHAH$(     HH;vx H$(  H$   H$  HHT$0H|$8HH+HuI*H;vRx H$  HtH;t:x H+H(D$0f$p  LL$PA   H$p  H$  %H$   H;$(  vw H$  Huw MLHI;K wHtHIH;Hsw IIc      t^ Ht
H$8  HIH$8  DD$PLD$PHH$8  ˰IH$X  HH$P  H+HHt;H;r-w H$P  DHH$X  HH$P  H+HH;rIH+HHt;H;rv H$P  DHH$X  H$P  H+HHH;r       @ A;         HcH$   L$   I+H  G;  LsL;rLv L$   I   A   Lh H8hCt Y0fWH$X  H$P  H+H|)G;}"HH;ru H$P  44   DBH$  s H H$  (   Hrs HT$pH$  s LL$xH$   LCL$xH HD$ DËH
 U&   DBH$  us H% H$     Hr HT$pH$  Ws LL$xH$   LCL$xH HD$ DËH
r %AA    ~4    HcH$X  H+$P  HH;rt A;   |Ic_@   e[ Ht
HL$pHIHD$pDD$PLD$PHHL$pŭMĐH$   HH$   H+HL;sFII H+HH;sDHH$   H$   / "   D$P   Dd$@D\$0HHD$0H#H      H;v+H HD$ L
_ LD$`H#- H
 DD$0HD$0H#H;u+HL HD$ L
  LD$@H, H
] H|$`Ht$@H\$PfA(fA(M=| Isfnf(^?Y f(II % D  Hs0fn\YDXD\YYDXHDD$0H$   HuIH$   H+HH$   HH+HH;s,   H HtDHHHCH$   JH;vDr H$   HD$`H\$h(D$`f$p  LL$0L$p  HT$`H$   ; #   D$P   Dd$@LD$PHT$@H$  wD$0H$   HuIH$   H+HH$   HH+HH;s)   HːHt
HHHCH$   JH;veq H$   HD$`H\$h(D$`f$p  LL$0L$p  HT$`H$   \ $   Dd$PMP  HT$PH$   D$0HT$0H$    %   d D$0Dd$PLD$0HT$PH$   D$0HT$0H$   J &   Dd$PM@  HT$PH$  ҞD$0HT$0H$   
   D$  A;_@   w *   HcA   L+ HI   cH$   Hf(IOHA   L HaLA   L HI   bH$8  H<f(I  A   L HbH$  HAXAYu AXXXA   L_ HHL$pja0 ,   IOxL$   HT$pD$0HT$0H$   H$   HtU L$   L$   L$   HL$pU DT$0HT$0H$   xH$   苴f(H$P  HtaU L$P  L$X  L$`  H$8  <U H$   Ht)U L$   L$(  L$0  H$  U H$   HtT L$   L$   L$   H$   T H$   HtT L$   L$   L$   H$   T f(L$   I[ Is(I{0Mc8A(sA({E(CE(KE(SE([IA_A^A]HL$VWATH0HD$ H\$XHl$`MIHHMHH6
f(HCH HLc(3LL$pMueJ    H  HHH H; rH
 N@HHKHH9S(v7H+fff     HHHHH;S(rHSMILHwLL$xMumHS(HH LHH H; rH
 ?LLC H9{(v*fffffff     HK HD HHH;{(rHHHS MI LHMHH\$XHl$`H0A\_^LI E3L9A(v* KHAIBDYAXBBL;A(rHHq 3LL$XLD$`3)t$0)|$ D$XD$`_L5n =o~ fTf/vH H
 r 3LL$XLD$`3҈D$XD$`LfTf/vH H
F 1@ 3LL$XLD$`3҈D$XD$`KfTf/vH H
  3LL$XLD$`3҈D$XD$`KfTf/vHS H
 诐 3LL$XLD$`3҈D$XD$`KKfTf/vH H
 ne 3LL$XLD$`3҈D$XD$`
KfTf/vH H
B -(t$0(|$ HHH\$Hl$WH HZHHHHtH;tٗHtH;tė̄t躗Ht$03H;_tHi Ht
H6HH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHHmHt$0H\$8Hl$@HH _H(Yt~ 3LL$0LD$83҈D$0D$8If(fT
k f/
{ vHt H
 ЎYW{ H(H(Y~ 3LL$0LD$8D$0D$8YIf(fT
}k f/
e{ vH H
 pYz H(HATAUAVH`HD$ HXHhHpHx LHٹ   
O E3Ht
HL$(HIHD$(Ll$@Ll$HLl$PE3E3HT$(HaHL$(cIH|$HHH\$@H+IgfffffffIHHHH?H   IH;rg H\$@H+I$IPt2HH(H|$HHH\$@H+IHHHH?HH;rRH\$@Ht+H|$HH;tfHGf H(H;uH\$@HM Ll$@Ll$HLl$PHL$(M 2DHt$H;tHf H(H;uH\$@HM Ll$@Ll$HLl$PHL$(~M L\$`I[ Ik(Is0I{8IA^A]A\H\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$G@I;       HtHCHtL@E3ItIP3H	tHB3H@HfHtHB3H@Hff\MtIE3A@(HE HI;ffYf)ToLMHHH\$@Hl$XH A\_^|H;  WATAUAVAWH@HD$ H\$pHl$xH$   HLLi3MuH9HL;vՒJ<    Hd HHuHt豒Ht$(Ll$0I|$IHtI;t胒HtI;tn̄tdI;t(H]d HtHHHD$(HH\$(H|$0HHH+HLMHM~     I$f(f)HI;|LMHT$(IgLuMtM;t͑MtM;t踑̄t讑M;t$t!I$c MtI/I$I$Mt$IHH+HLMHM~"    HE f(I$f)HI;|MIHfHt$I;t#̄t̄tH;}t!HM c HtHHE H] H}M~f(HE f)HI;|LMHHL$(tfHb H\$pHl$xH$   H@A_A^A]A\_H\$Hl$WATAUH HZLLHHtH;tEHtH;t0̄t&Ht$@3I;\$t$IL$b HtHID$It$HI\$HH+HLMM~'     IEMT$HI;f(DfA)D|IT$IML`eM]Ht$@H\$HHl$PM\$IE ID$ IH A]A\_@SH HH      D$0HD$0H#H;uH H
 Lf/j rHG /G f/ f(w f/w
,H [Hĺ H
 L草HHHVWATAUAVH  HǄ$   HXHhIILL   pG E3Ht
HL$@HIHD$@Lt$XLt$`Lt$hLNHD$pLt$x(D$pf$   L$   H$   HL$@HT$XHuIHL$hH+HH\$`HH+HH;sHF HHCHD$`FH;v_ HD$@HD$pH\$x(D$pf$   LN L$   H$   HL$@芖HE HT$@HPLt$pLt$x   DBH$   ] LFH$   HD$0D$(D$ LL$pIH$   IH$   H$   ] Hx H$   -^ t3H$   H$   S] IMLHAH$   ] E3Lt$xMj  Hl$pHL$`H\$XfD  Hu3HT$hH+HHH+HH;sHE HHHL$`H\$X  HH;vt^ HL$`H\$XHt$@H$   H$   HH+Hu3$H;v8^ HtH;t$@t&^ H+H($   f$   LA   H$   HL$@lH\$XLHL$`H;v] HL$`H\$XHt$@Hu] E3HL$`H\$XHD$@LII;S wHtH3H;Ps] HL$`H\$XAHIcI;H$   H	HHT$@PH$   [ HL$pB] HL$XHtC E3Lt$XLt$`Lt$hHL$@C L$  I[8Ik@IA^A]A\_^HL$VWATH0HD$ H\$XHl$`LHHr3HuH9HH;v覊H    H\ HHuHt肊HHwI\$HHtH;tWHtH;tB̄t8H;t4\ Ht
H迻HH/H_HHH+HLMM~I$f(Hf)HI;|LHI_IT$HOHH\$XHl$`H0A\_^H   HLD$(I HAI@HAI@HAI@HA HL$PI@ HHHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@H|$X ufWHĨ   H$   HL$ 荴HĨ   HHXWH   )p)xD)@Af(f(f   fD)HD)PD)XDc fD(fD(DYDYD)`fDW
#m E^fD(f(YY9m @ Y=o 3L$   L$   3fD(f(DYƈ$   $   DYo :f(fT
] f/
l vH H
 Y|l A^f(X5b f;v5fD  ffnYfA(EY\AYXf;rDYhl fA(? (|$pL$   I[E(CE(KYo YE(SE([E(cA(sI_LH   E)K3fD(Yn E)SE)[MKMCACACfD(9f(fD(fT
[ f/
k vHr H
 ~)t$p5Pk )|$`D)D$PDYDa fA(A\EXfA(f(> E\fD(EYDYfWf.zt5AYAYY=(k ^f(m> AYYm \DX(|$`(t$pD(L$@fA(D(D$PD(T$0D(\$ HĈ   H\$H|$Lٍ   A   AHp     H   AEAAAHHiN  HHH+HHHHiH+HAEKMi  IIH+HHHHiL+EKD;sA+	A+ɁAEtAH;wH\$H|$A#H\$Hl$WH H*HHH]HtH;tHtH;t̄tڄHt$03H;_tHV Ht
HVHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHH&ZHt$0H\$8Hl$@HH _% f(LIp     I   \f     EIMiN  IIH+HHHHiL+IEAIHi  HHH+HHHHiH+AIA;sD+
D+AfAHH*^YXf/mH\$Hl$ VWATH HMtI@HtH3HtHtHXHtH3H
HrHt$HtH#HHD$HHT$PHكH;HL$PHMH8HLE3H+HHH+HHL$GpUI;       HtHCHtL@E3ItIP3H	tHB3H@HfHtH3JffYMtIE3AH HE HI;ffYf)TkLMHHH\$@Hl$XH A\_^THH   )p)xD)@f(f(D)HD)PD)XD
\ fD(fE(DYD)`D)l$ fD(fD(DYf(E^YY[f 9 Y=h 3L$   L$   3fD(f(DYƈ$   $   DYh  4f(fT
$V f/
f vH H
, yYe e H_    A^f(Y5I X5[ AYHHDXA\EYAYf(YXuDY%xe fA(8 D(l$ L$   A({E(CE(KYh YA(sE(SE([E(cIH\$UVWHPHBBJ HD$0HHD$8L$@HHxH|$ptH#HHD$pHL$xHڃH;HT$xHMHHHL$ LH+E3HH+HHH,CSH;}XD$8HT$0D$@ff HHH;fDHfYHfYfXDf)D|HL$ LLHqSH$   HHP_^]@UATAUH`Hl$PLaH]0HID$Hu8HH}@L)u A0H;v~I$HuLH<    H      H   HHH;w
HHH? H+HL$PHHID$HSLt$@3HD$8   LI94$HDHH=   IE HD$0HD$(   HL$ HK@-@t	H7P H]0Hu8H}@(u HeA]A\]HP HHmHd}@UH`Hl$PH] HYHu(HCH}0H9Le8L)u qHAY0H;v}HHuLH4    H      H   HHH;w
HHH> H+HL$PHHHCHWLt$@3HD$8   LH93HDHH=   I$H HD$0HD$(   HL$ HOt	HN H] Hu(H}0(u Le8He]HN HHnHe|HM;ML   HH$H MtIBHtHH3HtHA3HatL@E3HtHP3I@BYJpHtHA3H	tHP3HtHH3HBIM;BDYAPXBXDBD\H$HATHPHLLL MAvHPA\隉Hl$@HhH|$0Ll$(Lt$ LpH@ Hl$xHl$`HH3H+LIAMtH$IHD$`HL$pIAI;LD$pHMH8E3M;  H\$HHt$8    L3L+ILH   M$HwMtIAHtHX3IH I CIHYMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHYDDMtIAHtHX3IH I CIHHH;YDD!H;}AI$MtIAHtL@E3HK HA@IHHH;Y|I;H}ZfMtIAHtHH3II$IL@ HHH fHMf(LHI;fYfB)|L;}?M$MtIAHtHP3IH I BIIIL;Y|J/HL$xHH3H+HT$`H;HD$`HMIM;H9Ht$8H\$HLl$(H|$0Hl$@Lt$ HPA\@SH HID$8    HTHH [HL$UVWATAUHPHD$ H$   LHHj3HuH9HH;vUxH4    HSJ HHuHt1xHHoIt$IHtI;txHtI;tw̄twH;tI Ht
HnHHHwHHH+HLMM~I$f(Hf)HI;|LHIDMI\$H\$0H\$8HwH$   HHLLHH	HtWHtIHHH;t.wHtIHHH;twHtIHHH;tvLLHHHT$(H,ID$G(HH$   HPA]A\_^]H\$Hl$WH HLH HPH]HHtH;tjvHtH;tUv̄tKvHt$03H;_tH<H Ht
HǧHH7HH_HH+HLMM~!D  HE HHI;f(Df)D|LHHHt$0H\$8Hl$@H _KH\$WH HLH HPLGLOHMt\MtHHIL;tnuMt:Mt5HHIL;tLuMtHHIL;t/uIHKILK E3LKIHH+HLMM~*ffff     HHKIM;fB(DfB)D|HSHH\$0H _|JHl$Ht$WHPHcq()t$@fWHHt$8Ht$(Ht$H;tht̄t^t̄tTtH\$`3H;qtH	EF Ht
HХHHHHwHHH+HLMM~(4@ @ HHI;f)D|HL$ LHpLcG(t$8LD$(LD$0MtWMtHHIL;tsMtHHIL;tsMtHHIL;tosIHOMI[LO LOIHH+HLMM~(e? D  HGHI;f)D|HWHL$ oH\$`Hl$h(t$@Ht$pHP_Hl$Ht$H|$ ATH0B(DA(HH
ҕ HL
P H1 D$  H}IHtI;trHtI;tyr̄torH\$@3H;~tH`D Ht
HHHHH~HH+HHLMM~"fD  HE HHI;f(Df)D|LHHGLELM MtMtIHIL;tqMt:MtIHIL;tqMtIHIL;tqIHNI}LN LNIHH+HLMM~,ffffff     HELVHI;f(DfA)D|HVHMFH\$@Hl$HH|$XHHt$PH0A\H\$Ht$WH@B(DA(HH
 HL
f HG D$ LOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0H肩LO L_MKHD$PL\$0HD$8IHNHH+HLMM~-ffff     HIHI;f(DfXDf)D|HT$0H\$XHt$`HH@_H\$Ht$ WH@B(DA(HH
ؒ HL
F H' D$ HD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$P9HNHD$XHD$0HL$XLIHD$PL_LIHD$8IL\$PHH+HLMM~,@ HIHI;f(Df^Df)D}HL$XHT$0HL$P蹯H\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ LO L_t$0MKIL\$`HL\$(H+HLMM~.ffD  IHI;f(DfXf)D|HT$`HL$ eH\$hH(t$@HP_H\$Hl$Ht$ WH0A LBHH
 HL
 Hr D$  H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t5lH
 Hg H HD$(H] LHD$ *HtH;tlH;^tH> Ht
H(HH>HH^HH+HLMM~"fD  HE HHI;f(Df)D|LHHH\$HHl$PHt$XH0_AH\$Hl$Ht$ WH0A LBHH
# HL
) H D$ H]3LHH   HM I          IcD$@HD$@H#I;wIL;rHtTH;t5ykH
 HBf H HD$(H\ LHD$ HtH;t5kH;^t!HN,= HtH跜HFH~HH^HH+HLMM~  HE HNHI;f(Df)D|HVLHH\$HHl$PHt$XH0_p@Hl$Ht$WHPHcq )t$@fWHHt$8Ht$(Ht$H;thj̄t^j̄tTjH\$`3H;qtH	E< Ht
HЛHHHHwHHH+HLMM~(46 @ HHI;f)D|HL$ LHfHcw t$8Ht$(Ht$H;tītītiH;wt!HO; HtH)HGH_HHwHH+HLMM~(5 HGHI;f)D|HWHL$ L*fH\$`Hl$h(t$@Ht$pHP_Hl$WATAUH0B DA HH
1 LL
 Hh D$ 7I|$IHtI;thHtI;th̄thH\$P3Ht$XH;}t!HM : HtHHE H] HH}HH+HHLMM~!@ I$HM HI;f(Df)D|LHI=It$HtI;thHtI;tḡtgH;ut!HM9 HtHoHEH]HHuHH+HLMM~*fff     ID$LUHI;f(DfA)D|HUIL$L0=H\$PHt$XHHl$`H0A]A\_H\$Ht$WH@B DA HH
h HL
 H D$ fLOHD$PHD$83IHH|$0H+HHLMM~)     HHHI;f(DfXDf)D|HT$0HҟLOL_HD$PL\$0HNHD$8IHH+HLMM~"HIHI;f(DfXDf)D|HT$0uH\$XHt$`HH@_H\$Ht$ WH@B DA HH
` HL
 H D$ VHD$X3HD$0HD$PHt$XLNHD$8LIH|$PHH+HHLMM~.fD  IHHI;f(Df^Df)D}L\$XHT$0HL$P虦HNHD$XHD$0HD$PHL$XLIHD$8L_IL\$PHH+HLMM~1f     HIHI;f(Df^Df)D}HL$XHT$0HL$PH\$`HHt$hH@_H\$WHPLI3)t$@IL$0f(HHHL$`H+HL$(HHLMM~'f HHI;f(DfXf)D|HT$`HL$ 5	LOL_t$0IL\$`L\$(HH+HLMM~3ffff     IHI;f(DfXf)D|HT$`HL$ H\$hH(t$@HP_HL$WATAUH@HD$0H\$hHt$xHHٹ    HtHE3E3IHHO H+OH*HHHHH?HLCLC LC(t~HUUUUUUUH;vakHHK蔌HCHC HvHHHK(Hw H9wv-5 LgL;g v5 3D$(D$pD$ LKLCHI[YHC HH\$hHt$xH@A]A\_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?LuHH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ Mb|LG HHC<HN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ {LG HV 3LOHˈD$(D$@D$ dHG HMtMIHu;HO HN IH+NHHHHH?HtLOLF HVH;HG HmHHt$XH0_H\$Hl$Ht$H|$ ATHPHA0IIH(I LHHtH;t2 H9kujHHn0HtH;t2 H9ouMHV0HHR8L^0M[HF0HF8    H HF0H@HF0HHI$IL$   fD  HHtH;t2 HGH9CHt7HL$ HHCHAHLD$0HT$@(l$ fl$0H;2HL$0HHCHAHD$8HL$ HD$(HHD$ HI$HAID$H\$`Hl$hHt$pH|$xIHPA\H\$Ht$WH HY0HHR0HRLH视HCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _LSHPHHA0MKICH IS(D$ fD$ ISICMC(L$0fL$0ISHHK0 E3L[0L[8HP[H\$Ht$WH HY0HHR0HRLH臉HCHG8HV0HF8HJ    unH    uffffff     HH     tH
HV0HJHA    uf     HH@    tHJH\$0Ht$8H _H\$0HHF0Ht$8H@H _H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIH- tHH[    tIM HHL$0HD$8@tTIE0HHtH;t. H;u)AHT$0LILd$ 譄EHH@HM :HL$0fHD$8HHIP- tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$Hl$Ht$WATAUH@Hq0MHH^L@    u4fff     HSIH, tHH[    tIM HHL$0HD$8@tTIE0HHtH;t- H;u)AHT$0LILd$ 譇EHH@HM :HL$0dHD$8HHI0, tDHL$0E HHE HAH\$`Ht$pHEHHl$hH@A]A\_H\$WH@)t$02)|$ 9HHf/vH\f/55 f(v!fW?  HT$P蟋XXW HT$P膋XB\f/=5 f(vfWF?  HT$PWX HT$PBXH\$X(t$0(|$ H@_@SH   MH$   L$   )t$pf(IHLHT$@HD$ AR0LK Ht$`LH$   H\$0HD$8IL\$XHH+3HLMM~=f     IHf(HI;fYDf(Lf\f)L|HT$0HL$PȥHL$@+ (t$pHĀ   [H\$UVWH0Hq HH9qvQ+ H_H;_ vA+ H9_wH;_ v/+ H/H9wwH;w v+ HtH;/t
+ H;tsDL$PHW 3D$(D$PLHΈD$ AHw HH;t?Ld$XHXE3HHtx HKL#LcLcd H0HCH;uLd$XHo H\$`H0_^]H\$
c3 LH   Ip     ffff     MIEMiN  IIH+HHHHiL+HEAHHi  HHH+HHHHiH+AHA;sD+
D+AfAIH*AYBf/pH\$HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HHHSPH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKPHHf(X$   HH$   H#H      H;vH& (f($  \f/   vƃ   \$   H$   H$  HHf/5d1 vH$   XF1  f(i H$  X  H;t/HVHOlL^(L_(HVHOkHV0HO0kL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   袎H$   LLH$   HAS(HHXHtHH;t@UHHtH;t!ŪtUH;]t!HM ' HtH虆HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHh*H$   & HuHtHH;twTHHtH;tXT̄tNTH$  H;stH>& Ht
HɅHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHH)H$      I  HY(HSH$   H$   H#  508 fW$   H$  H[H$   fW$   HLH$   H$   HHt$H;t)S̄tS̄tSH$   HHH+HLM3HM~*( ff     fA)HI;}
L$   LH$   H$   OF$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   # H$   # 2i  HSH$   )H!  fW$   H$  HXH$   $   A   LHHL$pBHt.HH;tcQ̄tYQ̄tOQH;\$xt$HL$pD# HtHςHD$pH|$pH\$xHHH+HLMHM~(. HD$pf)HI;|LHT$pH$   MH$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$pD" H$   5" H$  '" H$   " H$   
" H$   ! 2v  H$   H$   f($   H$   H$  H$   f/vH$   H/4\ f(H$  Hhf/vH$   HH$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tNHHtH;tN̄tNH;$   t-H$     HtHNH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   Y`H$  H$   H$  H$   H$   H$   *H$  LL$   L$  HHASHH$    HL$p H$    H$   H$    H$    H$    L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.( H   zt9Hx
' Y1 \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  HXHS`H$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HK`HHf(X$   HH$   H#H      H;vH (f($  \f/   vƃ   \$   H$   H$  Hhf/5& vH$   Xf&  f( H$  X  H;t/HVHO%aL^(L_(HVHOaHV0HO0aL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   H$   LLH$   HAS(HHXHtHH;t`JHHtH;tAJ̄t7JH;]t!HM . HtH{HE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$    HuHtHH;tIHHtH;txĪtnIH$  H;stH^ Ht
HzHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHH$      I  HY(HszH$   H$   H  5P- fW$   H$  H[H$   fW$   HzLH$   H$   HHt$H;tIH̄t?H̄t5HH$   HHH+HLM3HM~*(: ff     fA)HI;}
L$   LH$   H$   DF$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$    H$    2i  HSH$   H  fW$   H$  HXH$   $   A   LHHL$pbHt.HH;tF̄tyF̄toFH;\$xt$HL$pd HtHwHD$pH|$pH\$xHHH+HLMHM~(N HD$pf)HI;|LHT$pH$   BH$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$pd H$   U H$  G H$   9 H$   * H$    2v  H$   H$   f($   H$   H$  H$   f/vH$   HO4\ f(H$  Hxf/vH$   HH$   H$   HD$pH$   A   HT$xLH$   H\$xHtHH;tDHHtH;tC̄tCH;$   t-H$    HtHnuH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   yUH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$    HL$p H$    H$   H$    H$    H$    L$  I[8A(sA({E(CE(KI_^]@SH H      Hf.8 H   zt9H
 Y& \Y   XY      H [HL@HHUVWH  HǄ$0  HX )p)xD)@D)HIIHم  H`HShH$   HsL$  Y   H$   HD$(H$  HD$ LHAL$  Av(HKhHHf(X$   HH$   H#H      H;vH3 (f($  \f/   vƃ   \$   H$   H$  Hf/5 vH$   X  f( H$  X  H;t/HVHOEVL^(L_(HVHO0VHV0HO0#VL$  L$   H$  H$   H$  H MKIHH+HLM3LM~)     HIfB(fBXfB)IM;|H$   xH$   LLH$   HAS(HHXHtHH;t?HHtH;ta?̄tW?H;]t!HM N HtHpHE H} H]HHH+HLMHM~fHf(HE f)HI;|LHHH$    HuHtHH;t>HHtH;t>̄t>H$  H;stH~ Ht
H	pHH;HsHHH+HLMLM~ @ HHE fB(fB)IM;|LHHH$      I  HY(HoH$   H$   H  5p" fW$   H$  H[H$   fW$   H:oLH$   H$   HHt$H;ti=̄t_=̄tU=H$   HHH+HLM3HM~*(Z	 ff     fA)HI;}
L$   LH$   H$   9F$  H$   HL$`H$  HL$XH$  HL$PH$   HL$HH$  HL$@D$  DD$8D$  DL$0H$   HL$(H$   HL$ LH$  LƋH$  HWu$H$   = H$   . 2i  HSH$   H6  fW$   H$  HXH$   $   A   LHHL$pHt.HH;t;̄t;̄t;H;\$xt$HL$p
 HtHmHD$pH|$pH\$xHHH+HLMHM~(n HD$pf)HI;|LHT$pH$   8H$   HD$`H$  HD$XH$  HD$PH$   HD$HH$  HD$@DD$8DL$0HD$pHD$(H$  HD$ L$   L$   $  H$  u[HL$p H$   u H$  g H$   Y H$   J H$   ; 2v  H$   H$   f($   H$   H$  H$   f/vH$   Ho4\ f(H$  H/f/vH$   H9H$   H$   HD$pH$   A   HT$xLH$   !H\$xHtHH;t=9HHtH;t9̄t9H;$   t-H$    HtHjH$   H$   H$   HHH+HLMM~-HD$pH$   f(fXH$   f)HI;|LH$   H$   JH$  H$   H$  H$   H$   H$   H$  LL$   L$  HHASHH$   
 HL$p	
 H$   	 H$  	 H$   	 H$   	 H$   	 L$  I[8A(sA({E(CE(KI_^]HHHWATAUAVAWH   HǄ$   HXHhHp )pMLHٹ    Ht
HL$ H3HD$ HD$8    HD$@    HD$H    IVHL$ {E3M9nt  E3HL$@H\$8II,Hu3HT$HH+HHH+HH;sHE HHHL$@H\$8  HH;v HL$@H\$8Ht$ H$   H$   HH+Hu3$H;vQ HtH;t$ t? H+H($   f$   LA   H$   HL$ ,H\$8HHL$@H;v HL$@H\$8Ht$ Hu E3HL$@H\$8HD$ LHT I;S wHtH3H;Ps HL$@H\$8AIIcI;FH$      P Ht
HL$PH3HD$PHD$h    HD$p    HD$x    MLD$PHT$ Hڊf(HL$hHt HD$h    HD$p    HD$x    HL$P HL$8Ht HD$8    HD$@    HD$H    HL$ y f(L$   I[8Ik@IsHA(sIA_A^A]A\_LVWATHPHD$@I[IkIHLI@ I+@HLJ L+JIICHM ICH8 ISLM H
M L} II0L} L;} r0   H
| GHHt$pHt^H_ H+_HHE H+EHHu HmHG H+GHHu 3HD$(HD$ LLHWH3I$IH\$xH$   HPA\_^HATAUAVH   HD$ HXHhHpHx )p)xD)@IMHLHHuHW H+WHfWHl:3HG H+GHHM  $   fD(DY L$   fD  HD$HHL$@H+HH;r HL$@f(XMMHT$(I.f(HG H+GHH;rc HwHD$HHL$@H+HH;rC HL$@\MMHT$(I͇\A^HE H+EHH;r HE4HG H+GHH;r HwHD$HHL$@H+HH;r HL$@HHHHG H+GHH;HL$@HtE HD$@    HD$H    HD$P    HL$(  L$   I[ Ik(Is0I{8A(s(|$pE(CIA^A]A\H\$Hl$Ht$H|$ ATH   Hj3MHHH   HtHS3HC HHtH3HHL$PLD$HHHBHt$8HAHBHAHBHVHAHHD$pHHHT$(HT$@HL$ HT$ I՛HH;nL$   I[IkIs I{(IA\H\$Hl$WH HZHHHHtH;t	0HtH;t/̄t/Ht$03H;_tH Ht
HfaHH7HH_HH+HLMM~ @ HE HHI;f(Df)D|LHH6HUHOYHt$0H\$8Hl$@HH _H\$D$WHp)t$`)|$PD)D$@fEWIHfD/f(D)L$0D
	 fA(;  % f.zu   !   HB    q~ f/   f(LHfWU `f(f(Yf(fT
 fD/vqY
d  f/v[fA.zu3(H       $      H$   E   "   H fnY %  5} ^fA.zu
fA(  f(f(  fD/v ^AXfD/w$   f(D)T$  f.z3u18} f/v#H$   H"H
k Y<  O f/v=| f/v%  "   H 8D^D\
6 AY4  H$   $   .D fD(DX
 YE\fA(" 
 Yf/   AYf/v
fA.zZuX3|AYfA(\5H f( f(fA( u f(^^Yf/v{fA.zu3(H       $      H$   E fn "   H Y -A\fA(f(J f(fA(* ^Yf(D(T$ H$   (t$`(|$PD(D$@D(L$0Hp_H\$D$WH`)t$P)|$@D)D$0D IHf(fA(D)L$ fEWfD/    f.zuH
N LD$pH }Oz f/   f(LHfW cf(f(Yf(fT
  fD/v*Y
 o f/vH
:N HK "5uz ^fA.zu
fA(  f(譀f(  fD/v#fffff     ^AXfD/wt$pf( f.z0u.z f/v HL$pHH
7 Y<7   f/v:y f/vH
pM Hi` "D^D\ AY   HL$pt$p+D
z fD(DXt YE\fA( 
 Yf/vzAYf/vH
L H !AYfA(\5E f( f(fA( G f(^^Yf/v9H
L H[ >!A\fA(f(^ f(fA(> ^Yf(H\$x(t$P(|$@D(D$0D(L$ H`_HHXHpWHp)p5 )xHHp     H   D)@D)HD)PDQ
 D s D
g HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\ f(AY^=w ff     HHiN  HHH+HHHHiH+HƉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYf/yf(\j f(YAYAYf/X=v (t$`L\$pE(CE(KE(Sf(I[Is(|$PI_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;t&Mt5HHIL;tl&MtHHIL;tO&IHI?XLK3LKIHH+HLMM~ (G     HHI;f)D|HL$ H"LD$XH-  l$XHӽH\$PH@_H\$Hl$Ht$WH@HH   H)t$0)|$ 菟4   =<y fH*Y5#y fff        HSHDfI*Xf(YH5rҺ   H%H\$Pn(|$ Hl$XfH*HX(t$0Y	 Ht$`H@_H\$Hl$H|$ ATH H*HLH]HHtH;t$HtH;t$̄t$Ht$03H;_tHr Ht
HUHH7HH_HH+HLMM~'fff     HE HHI;f(Df)D|LHHIT$HOȞHt$0H\$8Hl$@HH|$HH A\H(T f(f(YYf(\f/lw vYU H(D
 f(f(H(7H\$Hl$Ht$H|$ ATHpHj3MHHH   HtHS3HCHHtH3HBBHVHHD$XHL$hD$`HHHT$(HT$@HL$ LD$HHT$ IHt$8WHH;|L\$pI[IkIs I{(IA\H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;tI"Mt5HHIL;t,"MtHHIL;t"IHISLK3LKIHH+HLMM~ (     HHI;f)D|HL$ HLD$XH- l$XHcQH\$PH@_H\$WH@LBLJfWHHD$8LD$(LL$0MtaHMtRHHIL;t)!Mt5HHIL;t!MtHHIL;t IHIRLK3LKIHH+HLMM~ (     HHI;f)D|HL$ HLD$XH-q l$XHUH\$PH@_HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;t H;t!HI HtHQHEH]HHuHHH+HLMM~( HEHI;f)D|HUHL$ LLE LM(t$8LD$(LL$0MtWMtRIHIL;tcMt5IHIL;tFMtIHIL;t)IHMIQLM(LM IHH+HLMM~(" fHEHI;f)D|HUHL$ H\$`Hl$h(t$@Ht$pH|$xHPA\HHXHhHpHx ATHP3)pfWHHqHpHpIHtI;tLH;t!HID HtHOHEH]HHuHHH+HLMM~(1 HEHI;f)D|HUHL$ LHu t$8Ht$(HtI;tH;t!HM HtH<OHEH]HHu HH+HLMM~( HEHI;f)D|HUHL$ L<H\$`Hl$h(t$@Ht$pH|$xHPA\HWATAUH   HD$`HXHhHp LLX HPHiHhHu3HuL9HH;vH    H LHuHtLD$ Ht$(H]HHtH;teHtH;tP̄tFH;t(I? HtHMLHD$ LH|$ H\$(HHH+HHHLH~4ff     HM IE fB(fB\fC)IL;}LD$ LLHT$ HL$@A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMM~3ffD  HD$ f(HE f^fXf)HI;|HT$0HL$@<yLl$HHl$PHD$ HD$pHT$xHL$@HHHAHBHAHBHAHBID$HD$0H$   HD$8HT$hHL$0MHL$  L$   I[(Ik0Is8IA]A\_@WHP )t$@1Hf/   H\$`HY Hl$h\t$0HiHHl$(HtH;t=HtH;t(̄tHt$p3H;ZtH
 Ht
HKHH7HH_HH+HLMM~,fHE HI;f(DHf^f)D|HL$ LH|Ht$pH\$`Hl$h(t$@HP_HL$VWATHPHD$ H\$xH$   HcL Hxm I$H3HuH6HH;v!H4    H HuHt ID$@Il$HHl$0 D$@Ht.HH;t̄t̄tH;t$IL$@ HtH2JID$@I\$@Il$HHHH+HLMM~( @ ID$@f)HI;|LIT$@HL$(+IH\$xH$   HPA\_^HATHP  HD$HHXHhHpHx LHHnl HL$  I$HT$ IHL$     DƍVHL$P HE@HL$` H9uH~:~D  H]@Hk HL$`BH HHcH;EH|HT$ HL$P M$HIAHL$ D HL$P L$P  I[IkIs I{(IA\H\$WH HH HO  H\$0L LH _HWATAUAVAWH   HD$ HXHhHpHHHIHB H+BHH;tZH6 HL$([ HL$P H HD$PHT$(HL$hZ H HD$PHV HL$P HGH9GuZHb HL$( HL$P; H+ HD$PHT$(HL$h Hn HD$PHW HL$P 3H   HI*    HE H+EHH;r LuHO@H+O8IHHHH?HH;r^ Lg8LoJD& J+D&HL;r= JL&IJHH0H;_rHGL$   I[0Ik8Is@IA_A^A]A\_H\$Ht$WH HH HN  L L@tHn H\$0HHt$8H _H\$Ht$WH Hi HHH@  o H  +H   H   Ht H   3H   H   H   H   H    H   Ht HOxH   H   H    HO`Ht HOHHw`HwhHwpm L@ LHO(HtU HOHw(Hw0Hw8H\$0Ht$8H _1 H\$WH HtH HH\$0H _HL$WH0HD$ H\$HHHٹ    HtH3HHHC0ƀ   HC0H@HC0H HC0H@HC8    HHLHH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MCxHHͲHH\$`HP_HL$WH0HD$ H\$HHHٹ    HtH3HHѣHC0ƀ   HC0H@HC0H HC0H@HC8    HH|HH\$HH0_LI[WHPHHH;tLLHA0MKICH MC(D$ fD$ MCICIS(L$0fL$0MChHHHH\$`HP_Hl$ VWATHPHy8 IMHHuLL$ LI0A8  HA0H\$pHI HtH;t IT$H;u2HHt <  ML$AHHHl$ 8=  I$H_0HtH;tw IT$H;u=HG0HHHH   LO0E3HMIHHl$ %8  HH tzI$HL$0HID$HAHL$0`H\$8HHK tEHC    tLE3HHHl$ 7p  ML$AHHHl$ 7S  IL$HHS   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?uT H\$8    t@ WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0t L$   I;Lt$xtHSHs t?ML$IA    tE3HHHl$ z66LAHHHl$ b6HT$0LHHHH@HFH\$pHH$   HPA\_^Hl$ VWATHPHy8 IMHHuLL$ LI0A:  HA0H\$pHI HtH;t IT$H;u2HH <  ML$AHHHl$ 9=  I$H_0HtH;t IT$H;u=HG0HHHH(   LO0E3HMIHHl$ U9  HH tzI$HL$0HID$HAHL$0pH\$8HHK tEHC    tLE3HHHl$ 8p  ML$AHHHl$ 8S  IL$HHc   I$HL$0Lt$xLw0HID$HAH|$0 L$   L?ud H\$8    tP WHC    u"HH     u;fHH     t(HC    ufH;XuHH@    tHH|$0 tL9|$0t L$   I;Lt$xtHSH t?ML$IA    tE3HHHl$ 76LAHHHl$ 7HT$0LH HHH@HFH\$pHH$   HPA\_^LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;s}L2I;l  HHH+H;sIHI;IBHIL$3HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   H!yD$0   3D$($   D$ ML$LIVIL$D$0   HD$8HL@IL3D$($   D$ ML$IT$ INaML$IL$ I+IHHHH?HHMtMD$ IIgIL$ H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PHvHINL3D$($   D$ ML$IT$ MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHIwI\$ I|$ H+I^H;tHT$PHsH0H;uHL$hHt Ll$hLl$pLl$xHL$P    IHL$P0I|$ H4vHHH+3ML$D$($   D$ LHHID$ LHINs   I^H<3H;tfD  HT$PHH0H;uHL$hHt' Ll$hLl$pLl$xHL$P HĀ   A_A^A]A\_^[H\$Ht$WH0DL$@3ID$(D$@HD$ H>H+H\$HH*HHHH?HHRHH+HHt$PH0_Ht$ WH0HHH;  H\$HHZ Ld$PLI*L+BIILIIH?LuHH\$HLd$PHt$XH0_LY LQIII+HLIIH?LM;wiDD$@DL$@HN3HӈD$(DD$ MbwLG HH#HN IH+NHHHH?HHRHHGHG HXMu3HO(II+HHHH?HL;w^HNKIDL$@3HMD$(D$@HHӈD$ vLG HV 3LOHˈD$(D$@D$ HG HMtMIHUHOؽ HN IH+NHHHHH?HhtLOLF HVHtHG HmHHt$XH0_@SH HAx   Hf. H   zt9Hh
w Y? \Y   XY      H [HL$WH0HD$ H\$HHt$PIHHH;Z HHRH] HFXH^hH HF`H~pH~xH 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH Hw HHA`HIH HO8z HO p HOf L LtH HH\$0H _HHPHHWATAUAVAWH@  HǄ$  HXHp )p)xIMLH 0HK HHHK H;K r   H
KK HHK H$   Htf(6H3HK 3HHHHuK H;fK r   H
J 諧HH$   HtfWf(ުLHD$8LHt$8fWL$       Ht
HL$pHHHD$pH$   H$   H$   L$x  H$  H$  H$  HT$HH$x  L\$HL$h  HT$HH$x  L\$HL$p     _ Ht
H$   HHH$   H$   H$   H$   Ic   H\$PHH$   ^H  \$0HT$@H$x  >L$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$@PIM]L$      MM;v L$   L$   H$   LHL$`Lt$hII+HuL*M;vR H$   MtL;t: M+I(D$`f$  LL$@A   H$  H$   L$   L;$   v L$   Mu LM$KL I;K wMtI$HH;Hs Hl$PLl$8L$p  HT$8H$x  HH\$HH  = fWf.z   HOH LH(HAH H;2H r(   H
G wLL$   Mt*KAXMI褧Ml$I\$ Hc< I$LL$   HT$HHL$@胮Hf(HL$H"H\$HH\$H   获 Ht
H$   HHH$   H$   H$   H$   Ic_DH\$@HH$   H  \$0fHT$8H$x  nL$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$8PI$M]L$      MM;v L$   L$   H$   LHL$`Lt$hII+HuL*M;v H$   MtL;tj M+I(D$`f$  LL$8A   H$  H$   L$   L;$   v L$   Mu
 LM$KL I;K wMtI$HH;Hs Hl$@L$p  Ic      藵 Ht
H$  HHH$  Ht$8LD$8HH$  	HH$(  HH$   H+HHt9H;rR H$   H<HH$(  HH$   H+HH;rHH+HHt>D  H;r H$   H<HH$(  H$   H+HHH;r
#    A       E;     "    IcL$   H$   L+IE  AD$;8  LsM;rj H$   JHD$8L$(  L$   M+I|rAD$;}iL{M;r% L$   H$p  H   A   L9> H	fWLD$8HL$@RH KAL$p     DBH$    H H$0  &   Hi H$x  H$    L$  H$  LC$  H; HD$ DAH
 B}   DBH$   b H H$0  %   H H$8  H$   A L$@  H$X  LC$@  H: HD$ DAH
U |A       H$   LcH$(  H+HL;r H$   J< tA;   |      DBH$    HO H$0  $HȲ["Hȋ HȲ]"H$8  H$   R HH$  1 H H$  HH$   H; H$  菱 Ic_@   茱 Ht
H$8  HHH$8  Ht$8LD$8HH$8  LƐH$X  HH$P  H+HL;s	J<IHD  H+HH;sH<HH$X  H$P  Q "   D$P   t$@LL$PLD$@H$h  HL$8=LH$   HuHH$   H+HH$   HH+HH;s83D$(D$0D$ L$   Mƺ   HǠHCH$      LH;vh H$   H$   HL$pLHL$`Ld$hHH+HuL'H;v( HL$pMtL;t L+I(D$`fD$`MA   HT$`HL$p
H$   H;$   v H\$pHu LLJI;K wHtHHH;Hs  #   D$@   t$PLL$@LD$PH$p  HL$8;LH$   HuHH$   H+HH$   HH+HH;s83D$(D$0D$ L$   Mƺ   HBHCH$      LH;v H$   H$   HL$pLHL$`Ld$hHH+HuL'H;v HL$pMtL;t L+I(D$`fD$`MA   HT$`HL$p$H$   H;$   vL H\$pHu< LLJI;K wHtHHH;Hs G $   t$@MP  LD$@H$   HL$8<HHL$p %   V D$8t$@LL$8LD$@HT$HHL$Ps?HHL$pf &   t$@M@  LD$@H$   HL$8:AHHL$p-        A;@h  | *   HcI  A   L!> HL$   HHL$8xLL$p  M   A   L= HI޸L$  HHL$@9L$p  HHL$PdLIMHA   L= H訷LA   L= HI}L$   HH$  վL$h  HH$  AU HH$  נMHH$  ԞMHHL$`ĞLA   L< HH$8  I$HL$p   ,   IWxLL$HL$8  HL$`	DHHL$p|H$P  HtU H$P  H$X  H$`  H$8  0 H$   HL$p1HT$pH$x  ḤH$   Ht H$   H$(  H$0  H$  Ъ H$   Ht轪 H$   H$   H$   H$   蘪 H$   Ht腪 H$   H$   H$   H$   ` H$   HtM H$   H$   H$   HL$p+ HL$@  I[@IsHA(sA({IA_A^A]A\_HHPHHWATAUAVAWH@  HǄ$  HXHp )p)xIMLH! 0H9 HHH9 H;9 r   H
[9 HH9 H$   Htf(FH3H9 3HHHH9 H;v9 r   H
 9 軕HH$   HtfWf(HfWH$       Ht
HL$`HHHD$`Ht$xH$   H$   L$p  H$x  H$  H$  HT$HH$p  L\$HL$h  HT$HH$p  L\$HL$`      Ht
H$   HHH$   H$   H$   H$   Ic   H\$@HH$   ~H  \$0HT$8H$p  ^L$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$8PIM]L$      MM;v L$   L$   H$   LHL$PLt$XII+HuL*M;vr H$   MtL;tZ M+I(D$Pf$  LL$8A   H$  H$   L$   L;$   v
 L$   Mu LM$KL I;K wMtI$HH;Hs̿ Hl$@L$p  HT$8H$p  	H HD$HH
ǽ =+ fWf.zt%HT$HHL$@ Hf(HL$H这HD$HHD$H   + Ht
H$   HHH$   H$   H$   H$   Ic_DH\$@HH$   -H  \$0HT$8H$p  
	L$   MuHH$   I+HL$   II+HH;s33D$(\$ L$   LD$8PIÕM]L$      MM;vd L$   L$   H$   LHL$PLt$XII+HuL*M;v! H$   MtL;t	 M+I(D$Pf$  LL$8A   H$  H$   L$   L;$   v L$   Mu LM$KL I;K wMtI$HH;Hs{ Hl$@L$p  Ic      6 Ht
H$   HHH$   Ht$8LD$8HH$   _HH$   HH$  H+HHt9H;r H$  H<HH$   HH$  H+HH;rHH+HHt=@ H;r H$  H<HH$   H$  H+HHH;r    A       E;         IcL$   H$   L+IE  AD$;8  LsM;r
 H$   JHD$8L$   L$  M+I|rAD$;}iL{M;rŻ L$  H$p  H   A   L, H詭fWLD$8HL$@H KAL$p     DBH$    H< H$0     H	 H$p  H$   k L$x  H$  LC$x  H* HD$ DAH
 k   DBH$    H H$0  5   H H$0  H$    L$8  H$P  LC$8  HW) HD$ DAH
 XkA       H$  LcH$   H+HL;r" H$  J< tA;   |      DBH$   $ Hl> H$0  WHȲ[}Hȋ HȲ]hH$0  H$    HH$  ѹ Hi H$  HH$   H * H$  / Ic_@   , Ht
H$0  HHH$0  Ht$8LD$8HH$0  ULƐH$P  HH$H  H+HL;s	J<IHD  H+HH;sH<HH$P  H$H  
 "   D$@   t$8LL$@LD$8H$h  H$   +LH|$xHuHH$   H+HH$   HH+HH;s53D$(D$0D$ LL$pMƺ   HjHCH$      LH;v H$   H|$xHL$`LHL$PLd$XHH+HuL'H;vη HL$`MtL;t L+I(D$PfD$PMA   HT$PHL$`OH|$xH;$   vz H\$`Huj LLJI;K wHtHHH;Hs? u #   D$8   t$@LL$8LD$@H$`  H$   :*LH|$xHuHH$   H+HH$   HH+HH;s53D$(D$0D$ LL$pMƺ   HHCH$      LH;v H$   H|$xHL$`LHL$PLd$XHH+HuL'H;vR HL$`MtL;t= L+I(D$PfD$PMA   HT$PHL$`H|$xH;$   v H\$`Hu LLJI;K wHtHHH;Hsõ 
 $   t$8MP  LD$8H$   H$   *HHL$`W
 %    D$@t$8LL$@LD$8HT$HH$   .HHL$`x
 &   t$8M@  LD$8H$   H$   /HHL$`ֽ   A;@k  ,
 *   HcI  A   L, HͧL$   HH$   %LL$p  M   A   L, HI苧L$   HHL$8L$`  HHL$@LIMHA   LM, HULA   L9, HI*L$   HH$  肭L$h  HH$  認AU HH$  脏MHH$  聍MHHL$PqLA   L+ HH$0  豥I$HL$p   ,   IWxLL$HL$0  HL$P2HHL$`)H$H  Ht H$H  H$P  H$X  H$0  ݙ H$   HL$`޻HT$`H$x  HyH$  Ht袙 H$  H$   H$(  H$   } H$   Htj H$   H$   H$   H$   E H$   Ht2 H$   H$   H$   H$   
 HL$xHt Ht$xH$   H$   HL$`ޘ HL$@  I[@IsHA(sA({IA_A^A]A\_H\$Hl$Ht$ WH`)t$P)|$@f(6 IIH   f/D)D$0   f(Ǘ f.zuY  !   H    f(ҨfWf( f/fWvfW p E3LHfD(f(;D\f(K D\C   f/vwfWf.z^ݳ 
m. f(fTf/v  fD(fDWd " ^\ fTӖ fD(f/       f/v7f(f(LD$(LL$pHT$ \! \
I f(PfD(yf/= r# f/vf(خQ fD(LHL$p|$p5 5 fD(f(X \ \\ɸ YDXHtfA((t$P(|$@L\$`I[Ik Is(E(CI_@SH02 LD$H3)t$ H 5V fTf/: vH H
' E4 LD$H3 fTf/ vH H
' H(t$ H0[HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;v HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@H   L;   H;v8 HHD$@H\$HHnH;n v HH\$0Hl$8(D$0fD$0Hu E3LKdHHI;k wHtH3H;hsǭ Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PH襲HOHtB HG    HG     HG(    HL\$`I[ Ik(IA\_^ @WH HAHLHHL@MtDHMtHHIL;t
MtHHIL;tIHOH\$0IHWHH\$0HGH _HHXHhHp @WH`)p)xf([1 IIH   f/D)@   f(腒 f.zuH
 LD$pHa ]f(蓣fWf(þ f/fWvfWx 1 E3LHfD(f(<D\f( D\\   f/   fWf.zuH
 LD$pH`  
) f(fTf/v訑 fD(fDW "R ^\N fT{ fD(f/      ~ f/v7f(f(LD$(LL$pHT$ \ɽ \
 f(H/fD(yf/= r#? f/vf(  fD(LHL$p|$pDݐ 57 fD(f(X. \軐 \\q YDXHt(t$P(|$@L\$`fA(I[Ik Is(E(CI_HSH@  HD$0)p)xD)@IfD(f(f(fWf.zuf( Y   f.z  f.
ɲ z5u3f(fWi Af(f(@YY5; f(j  f/
z rfT= f(@J  f(HEDJy J ȃ   H HLf(f(   H$P  HD$(H\$ fA(f(f(N   L$P  fA(f(f(T   f(f(   L$P  f(f(1   f(f(oOuHN4 HL$x HL$8Ϩ H HD$8HT$xHL$P HT$8H$   >H
w. HHPH
- HHX@`B  HL$@  A(sA({E(CI[k   Ⱥ ں  HLH HPHHUVWATAUAVAWH   HǄ$   HXIMHH   虎 Ht
HL$8H3HD$8HD$P    HD$X    HD$`    IWHL$8E3M9w  3\$0Ht$XH|$PIL,Hu3HL$`H+HHH+HH;s03D$(\$ LL$HMōPHT~HHt$XH|$P  HH;v Ht$XH|$PLd$8L$   H$   HH+Hu3$H;v MtL;d$8t H+H($   f$   MA   H$   HL$82H|$PLHt$XH;vZ Ht$XH|$PLd$8Mu@ E3Ht$XH|$PHD$8LIL I;K wMtI$3H;Hs Ht$XH|$PAIcI;OH$  H$(  H$     詌 Ht
HL$hH3HD$hHǄ$       HǄ$       HǄ$       H|$ LL$hLD$8HHEH$   Ht HǄ$       HǄ$       HǄ$       HL$h HL$PHt HD$P    HD$X    HD$`    HL$8軋 HH$   H   A_A^A]A\_^]HT$HL$SVWATAUAVAWH`HD$0MMLHHL$@IHIAHAHL$PI HI@HAHD$@HtH;D$Ptu HL$HH+L$XI*IHLIIH?LLFMu3HN(I+IHHHHH?HM  LV II+IHHHH?HHUUUUUUUHH+I;sN"I;b  HHH+H;s3HI;IBHHNHH$   H$   3D$($   D$ LNLH$   HRHN%LH$   HL$PIHIFHAHL$@IHIGHA3D$($   D$ LNHT$XHL$HqLH$   3D$($   D$ LNHV H$   HH;%LF LNII+H*HHHH?HLMtIHΪHNQ H[HHHF(KdHHHF H~   HL$PIHIFHAHL$@IHIGHA3LND$($   D$ MHT$XHL$HH^ I}H;t  H0H;tHHH0H;uO$dIH^ I<H;tH0H;tHHjH0H;uHF II}H;tH0H;tHH<H0H;uLf H`A_A^A]A\_^[@UATAUAVAWH   Hl$@HE H   H   H   )u@HLqxAY0LBHL;vH>IHupJ    H=   w2J   HHH;wIHH H+H|$@HH.J    H HHuHtHHFE3ML96LDLeHEHH=   @@uIM8H;vUMM0MufH    H=   w2H   HHH;wIHHK H+LL$@II$H    H LHuHtIE8I}0 MDLu HE(HH=   È]0t$0H|$(HD$    ME IU IMKDt
I @t	I H   H   H   (u@HePA_A^A]A\]H\$UVWHpHHHL$ HHBHAHBHAHBHAHB HA HB(HA(HB0HA0HB8HA8HB@HA@HHHpH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}%HT$ fHHH;HfXDf)D|HL$ LLHlH$   HHp_^]H\$UVWHPHBB(HHL$(HHBHAHBHAHHHxD$HH|$ptH#HHD$pHT$xHكH;HL$xHMHHHL$ LH+E3HH+HHH,CH;}PD$HHT$(ffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLH1H$   HHP_^]H\$UVWH`HBB0J8HHL$0HHBHAHB HAHHHxD$PL$XH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}]D$PHT$0D$Xff@ fHf(HH;HfYfYf(Lf\f)L|HL$ LLH
H$   HH`_^]@UH`Hl$PHBH] Hu(H}0Le8L)u A0HHH;vH
HuLH    H      H   HHH;w
HHHy H+HL$PHHHFML$@M$t$@IT$3HD$8   H9>HL$0HD$(   HDIL$HH=   ID$HHD$ @t	Hۚ H] Hu(H}0(u Le8He]H HHkHbHL$SH0HD$ HiHH0[# HL$WH0HD$ H\$PHH   Ht 3H   H  H  H   ̀ H   Ht輀 H   H   H   H   蛀 H   Ht芀 H   H   H   H   i H_HH\$HHhHO H_H\$HHhH4 H HH\$PH0_HHHUVWATAUH`HD$ HX)pLHcHXfWpHqHp3uH6HH;vH,    H HuHtHH^IHt$I;t̄t̄tH^HHH+HLMHM~(  Hf)HI;|LHHL$(OH\$0H\$8t$@It$H$   HHLLHHiXHtWHtIHHH;tHtIHHH;tHtIHHH;tLLHHLNLNIHH+HLMM~(ő D  Hf)HI;|HHL$(bI	IH$   (t$PH`A]A\_^]@SHP" )t$@1Hf/   LA LI(H|$`\t$0HyHH|$(MtMtHHIL;tMt:MtHHIL;tMtHHIL;tIHILK3LKIHH+HLMM~0fD  HHI;f(DHf^f)D|HL$ HD'H|$`(t$@HP[HHHVWATAUAVH`HD$ HXHh )pLHcHxfWpHqHp3IuH,I;vH,    H HuHtHH~IHt$I;tḡt]̄tSH~HHH+HLMHM~&(^ ffffff     Hf)HI;|LHHL$(H|$0t$@It$H$   HuH,I;vH,    HД HuHtHH~Ht$I;t̄t̄tH~HHH+HLMM~( Hf)HI;|LHHL$(.I蕣IL\$`I[8IkH(t$PIA^A]A\_^HL$WHPHD$ H\$hHt$xHHo! HL$(̒ HHD$pH
 HHNHՒ E3D^0D^4D^8D^<D^@D^HFDH H
! HHNPHH\$hHt$xHP_@SH A H  HHH HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HL$WHPHD$ H\$hHt$xHH  HL$( HHD$pHݭ HHNH E3D^0D^4D^8D^<D^@D^HFDHr H:  HHNP<HH\$hHt$xHP_@SH A H  HHHb HXHAH      ?HAHAH?HAH      ?HAH      $@HA3HAHAHAHH [HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vHH4    HF HHuHt$HL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;t迾HtIHHH;t袾LLMM;t% MtIHHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;t/I
IHt:HtIHHH;tHtIHHH;tڽLLM;t%Ϗ MtIZHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;tuMt:HtIHHL;tSHtIHHL;t6IHI;t%+ HtHHHD$@HHL$@Ld$HHt$PHHH+HLMHM~Hf(fYf)HI;|LHT$@HL$($%IwHGLHD$(Ht$0I_HtI;t肼HtI;tm̄tcH;t(I\ HtHLHD$(LH|$(H\$0IwHtI;tHtI;t̄tH;t(I HtH}LHD$(LH|$(Ht$0I_HtI;t讻HtI;t虻̄t菻H;t(I HtHLHD$(LH|$(H\$0HHH+HLMM~!fD  If(fYfA)HI;|LHT$(HL$X#LD$@HT$(H$   HHL$( HL$@ HH$   HpA_A^A]A\_^]HHPUVWATAUAVAWHpHD$ HXL3$   HYHXHHLsLkIIHuH9HH;vXH4    HV HHuHt4HL$@Ll$HLt$PHsHkIHtHtIHHH;tHt:HtIHHH;tϹHtIHHH;t貹LLMM;t% MtI.HHD$@HHL$@Hl$HHt$PHsHkHt3Ht"IIHHH;t?I
IHt:HtIHHH;tHtIHHH;tLLM;t%ߊ MtIjHHD$@HHL$@Hl$HHt$PHsLcMtHtIHHL;t腸Mt:HtIHHL;tcHtIHHL;tFIHI;t%; HtHHHD$@HHL$@Ld$HHt$PHHH+HLMHM~HfQf)HI;|LHT$@HL$("IwH[LHD$(Ht$0I_HtI;t薷HtI;t職̄twH;t(Ip HtHLHD$(LH|$(H\$0IwHtI;t,HtI;t̄t
H;t(I HtHLHD$(LH|$(Ht$0I_HtI;t¶HtI;t譶̄t裶H;t(I HtH'LHD$(LH|$(H\$0HHH+HLMM~!ff     IfQfA)HI;|LHT$(HL$Xg LD$@HT$(H$   HHL$( HL$@ HH$   HpA_A^A]A\_^]HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vsH,    Hq LHuHtOLD$@Ht$HHkIHtI;t"HtI;t
̄tH;t(I HtHLHD$@LH|$@Hl$HHsHtI;t踴HtI;t裴̄t虴H;t(I HtHLHD$@LH|$@Ht$HHkHtI;tNHtI;t9̄t/H;t(I( HtHLHD$@LH|$@Hl$HHHH+HHHHH~ Hf(fYfA)HH;|LLHT$@HL$( It$HBLHD$(Ht$0I\$HtI;t|HtI;tḡt]H;t(IV HtHLHD$(LH|$(H\$0It$HtI;tHtI;t̄tH;t(I HtHvLHD$(LH|$(Ht$0I\$HtI;t覲HtI;t葲̄t臲H;t(I HtHLHD$(LH|$(H\$0HHH+HLMM~I$f(fYfA)HI;|LHT$(HL$PLD$@HT$(I}HL$( HL$@ IL\$pI[8Ik@IA^A]A\_^HVWATAUAVHpHD$ HXHhLL3$   HYHXHHHsHuL9HH;vcH,    Ha LHuHt?LD$@Ht$HHkIHtI;tHtI;t̄tH;t(I HtHwLHD$@LH|$@Hl$HHsHtI;t訰HtI;t蓰̄t艰H;t(I HtH
LHD$@LH|$@Ht$HHkHtI;t>HtI;t)̄tH;t(I HtHLHD$@LH|$@Hl$HHHH+HHHHH~ HfQfA)HH;|LLHT$@HL$(It$H6LHD$(Ht$0I\$HtI;tpHtI;t[̄tQH;t(IJ HtHLHD$(LH|$(H\$0It$HtI;tHtI;t̄tH;t(I߀ HtHjLHD$(LH|$(Ht$0I\$HtI;t蚮HtI;t腮̄t{H;t(It HtHLHD$(LH|$(H\$0HHH+HLMM~fI$fQfA)HI;|LHT$(HL$PFLD$@HT$(IsHL$( HL$@ IL\$pI[8Ik@IA^A]A\_^H\$Ht$WH HH   HtIf H   3H   H   H   &f HOp1HOpf H H_PHO8Hte HO Hw8Hw@HwHe Ht$8HH\$0H _HL$WH0HD$ H\$PHHH HHBHAHBHAHBHAH H #,HOPHL$HHj HHCXHAHC`HAHChHAHSpH HH   H   +HH\$PH0_LATH   HD$ I[IkIsI{ LHHB H+BHH;AtYHT IK} HL$PF~ H6 HD$PHT$(HL$h} Ha HD$PH HL$Pd 3H9yvtfHC@H+C8HH;r} HC8H,ID$ I+D$HH;r} It$H   H+   HH;rf} H   HHHH;{rHKPHH   L$   I[IkIs I{(IA\H`HL$WH0HD$ H\$PHt$XHH  Htc 3H  H   H(  H   xc H5} H  H  HO@H_H\$HHK{ H3H7H\$PHt$XH0_H\$WH HtHb HH\$0H _HL$WH0HD$ H\$PHHH HHHL$HH` HHBHAHHz HS@HO@H  H  H  HL$HHa HH  HAH  HAH  HAH   H (HH\$PH0_H\$WH0HAHH)t$ Hf(P@HC@HK@f(HP@H  Hf(HP@H  f(HHH\$@(t$ H0_H`@H\$Ht$WH HAHHAHP8HC@HK@DHP8H  DHHP8H  DHHH\$0Ht$8H _H`8H\$Ht$WH HAHHIHP0HC@HK@LHP0H  LHHP0H  LHHH\$0Ht$8H _H`0H\$Hl$Ht$WH HAHHAIHP(HC@HK@DLHP(H  DHLHP(H  DHLHH\$0Hl$8Ht$@H _H`(H\$Hl$Ht$H|$ ATH0HA\$`HHAIL\$ P HG@HO@DLIԉ\$ P H  DHLIԉ\$ P H  HDLIԉ\$ P H\$@Hl$HHt$PH|$XH0A\H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`H\$WH HAHHHPHC@HK@HPH  HHPH  HHH\$0H _H`@SH HAHHPHC@HK@PH  HPH  HH [H`H\$WH HAHHHHC@HK@HH  HHH  HHH\$0H _H HL$WH0HD$ H\$PHH   v H   zv H_pH\$HHFH^ H_0H\$HHFH] HOH\$PH0_H%.v HL$WH0HD$ H\$HHH  IH  Ht] 3H  H  H  Hp  p] HX  Ht^] HX  H`  Hh  H@  =] H  DvH  $] H  軨H  vH  \ Hx  蕨H  蘏HH\$HH0_HL$SH0HD$ Hٹ   \ HtH3HH5HC0ƀ   HC0H@HC0H HC0H@HC8    HH0[HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKHt tH[HH    tH|$(I4$Ht$ Ml$0HtH;tu 3I;tHWHs   (D$ f$      [ Ht
HL$0HHHD$0H\$HH\$PH\$X   [ Ht
HL$`HHHD$`H\$xH$   H$   HH$   s H$   H$p  HT$0H$   !HT$`H$   !L$   L$   H$0  IHT$ HH
H@HBH$  HtZ H$  H$   H$(  H$   Z H$   HtZ H$   H$   H$   H$   ZZ H$   r HL$xHt<Z H\$xH$   H$   HL$`Z HL$HHtZ H\$HH\$PH\$XHL$0Y H|$(Ht$ Hu$s HH;{0us HG@HG@L$P  I[(Ik0Is8IA]A\_HWATAUHP  HǄ$   HXHhHp HLHy0H_    u(fHKHSq tH[HH    tH|$(I4$Ht$ Ml$0HtH;tWr 3I;tHWHq   (D$ f$      Y Ht
HL$0HHHD$0H\$HH\$PH\$X   X Ht
HL$`HHHD$`H\$xH$   H$   HH$   p H$   H$p  HT$0H$   |HT$`H$   L$   L$   H$0  I/HT$ HH
H@HBH$  HtW H$  H$   H$(  H$   W H$   HtW H$   H$   H$   H$   W H$   o HL$xHt|W H\$xH$   H$   HL$`]W HL$HHtNW H\$HH\$PH\$XHL$05W H|$(Ht$ Hudp HH;{0uSp HG@HG@L$P  I[(Ik0Is8IA]A\_H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;vo HM HtH;to HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k vJo HHl$(H\$ (D$ fD$ Hu'o LLH<HHI;{ wHtH3H;~sn H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@WATAUAVAWH@HD$0H\$pH$   HHHUUUUUUUH;vrHAHu3I*%HI(H+I*IHHHH?HH;   HHK`HHD$xLk L9kvn LcL;c vm 3D$(D$xD$ LKLII7LC LKII+IHLIIH?LMtIHuHKTT HHHHC(KdHHHC HsH\$pH$   H@A_A^A]A\_LL$ LD$HT$HL$SVWATAUAVAWH   HD$HMILLLQMuE3II*+HI(I+I*IHHHHH?HE3Md  MD$ II+IHHHH?HHUUUUUUUHH+H;s荢L2I;l  HHH+H;sIHI;IBHIL$HHD$@INI+L$IHHHHH?HHL$8Dl$0HIHH3D$($   D$ ML$L$   H豴D$0   3D$($   D$ ML$LIVIL$!D$0   HD$8HL@IL3D$($   D$ ML$IT$ INML$IL$ I+IHHHH?HHMtMD$ IIwsIL$Q H[HHID$(HvHHID$ I|$  M+FIIHHH?HH;   IHL$PEHvHINL3D$($   D$ ML$IT$ MT$ II+NIHHHH?HH+3D$($   D$ ML$LD$PHI(I\$ I|$ H+I^H;tHT$PHSH0H;uHL$hHtP Ll$hLl$pLl$xHL$PP    IHL$P`I|$ H4vHHH+3ML$D$($   D$ LHH'ID$ LHIN胐I^H<3H;tfD  HT$PH裙H0H;uHL$hHt7P Ll$hLl$pLl$xHL$PP HĀ   A_A^A]A\_^[HHPHHWATAUAVAWH  HǄ$  HXHp )pLL=    O HtH$p  H33HH$p  H$  H$  H$     O Ht
H$   HHH$   H$   H$   H$  H HL$hYg Hu H$   Cg HK H$  -g HL$0kHD$ LL$hL$   H$  IHL$HHtN H\$HH\$PH\$XHL$0N H$  f H$   f HL$hf A^@H HL$hf ILD$hHT$0IP(HH$p  sHL$HHt-N H\$HH\$PH\$XHL$0N HL$h\f L$  H$  L+IMu*g H$   AF@H H$  e H H$   e H HL$he HL$03jHD$ L$  L$   HT$hIPHL$HHt\M H\$HH\$PH\$XHL$0CM HL$he H$   |e H$  me I~DH$  HD HL$h-e ILD$hHT$0IP(HH$p  XrHL$HHtL H\$HH\$PH\$XHL$0L HL$hd L$  H$  L+IMue H$   Hk H$  d H H$   zd H HL$hgd IcV@HL$0h7HD$ L$  L$   HT$hIHL$HHtK H\$HH\$PH\$XHL$0K HL$h d H$   d H$  d EF@H H
 fWt$`Ic~@   K Ht
HL$0HHHD$0LD$`HHL$0
MfHHT$0I蘔HL$HHt4K H\$HH\$PH\$XHL$0K HX HL$h=c ILD$hHT$0IPHH$   8HL$HHtJ H\$HH\$PH\$XHL$0J HL$hc HIcF@HHt}HؐLL<    HID$ I+D$HH;rc Ml$H$   H$   H+HL;rc H$   J9ID HH;r3L$   L$  Hi H$  Bb HB H$   ,b H4 HL$hb IcV@HL$05HD$ L$  L$   HT$hIHL$HHtI H\$HH\$PH\$XHL$0I HL$ha H$   a H$  a EF@H H
 t$`Ic~@   YI Ht
HL$0HHHD$0LD$`HHL$0MfxHT$0INHL$HHtH H\$HH\$PH\$XHL$0H H HL$h` ILD$hHT$0IPHH$   HL$HHtH H\$HH\$PH\$XHL$0qH HL$h` HIcF@HH   H LL<    HID$ I+D$HH;ria Ml$H$   H$   H+HL;rBa H$   J9ID HH;r3L$   L$  H H$  _ H H$   _ H HL$h_ HL$0.dHD$ L$  L$   HT$hIKHL$HHtWG H\$HH\$PH\$XHL$0>G HL$h_ H$   w_ H$  h_ A   H> HL$h/_ ILD$hHT$0IP(HH$p  ZlHL$HHtF H\$HH\$PH\$XHL$0F HL$h^ L$  H$  L+IMu_ H$   A   He H$  ^ H H$   w^ H HL$hd^ Mc   IcV@HL$01HD$ L$  L$   HT$hIHL$HHtE H\$HH\$PH\$XHL$0E HL$h^ H$   ^ H$  ] EF@H H
 E   H H
 t$`Ic      E Ht
HL$hHHHD$hLD$`HHL$hIc~@   HE Ht
HL$0HHHD$0LD$hHHL$0I   HL$`HT$0hHL$HHtFHt$PH;t7HyHHtD HH_H_HOD H0HGH;uHL$HD H\$HH\$PH\$XHL$0zD H$   HtgD H$   H$   H$   HL$hED H HL$hg\ ILD$hHT$0IPHH$   bHL$HHtC H\$HH\$PH\$XHL$0C HL$h-\ HIc   H$   LH  H*D  Mc~@LM   HH\$`     LH    H$8  HH$   HK H+KHHHHH?HL;r\ HsHD7 H+D7HL;rn\ Ht7H$   H$   H+HL;rG\ H$   H$8  HJIH0M;H$   H*=3H$   L$   IL;L$  H0b H$  Z H H$   Z H HL$hZ Ic   HL$0-HD$ L$  L$   HT$hIHL$HHt B H\$HH\$PH\$XHL$0B HL$hOZ H$   @Z H$  1Z E   H H
D G
$   Ic      A Ht
HL$0HHHD$0L$   HHL$01M   HT$0I輊HL$HHtXA H\$HH\$PH\$XHL$0?A H HL$haY ILD$hHT$0IPHH$   \HL$HHt@ H\$HH\$PH\$XHL$0@ HL$h'Y HIc   HHt~HfLL<    HID$ I+D$HH;rY Ml$H$   H$   H+HL;rY H$   J9ID HH;r3L$   L$  H_ H$  bX Hf H$   LX HT HL$h9X IvDLcIcV@HL$0+HD$ L$  L$   HT$hIHL$HHt? H\$HH\$PH\$XHL$0? HL$hW H$   W H$  W EF@H H
 
DH H
 
$   Hc>   Z? Ht
H$   HHH$   L$   HH$   赑Ic~@   ? Ht
HL$0HHHD$0L$   HHL$0zM  Ld$`HT$0I0HL$HHtQHt$PH;t>Hy    HHt> HH_H_HOk> H0HGH;uHL$HT> IvDH\$HH\$PH\$XHL$07> H$   Ht$> H$   H$   H$   H$   = H8 HL$h!V ILD$hHT$0IPHH$   HL$HHt= H\$HH\$PH\$XHL$0= HL$hU HHcH$8  LH  fffff     IcF@HH   HHff     LL<    HH$   IL$ I+L$H*HHHH?HH;rJV Md$JD' J+D'HL;r,V Nd'H$   H$   H+HL;rV H$   J9KHH0H;H$   Ld$`H3L$   IL;$8  
L$  IvDDH H
 Hc>HuHI9II;vpL$    InU HHuMtLH$   H$   M@  Ht.HH;t̄t̄tI;|$tEI$T Ht2I;vL,    IT HuMtI$I$I|$HHH+HLMHM~    f(I$f)HI;|LIH$   &XHdT H5 H$  7S H+ H$   !S H) HL$hS MnDIcU H$@  &HD$ L$  L$   HT$hIH$X  Ht: H$X  H$`  H$h  H$@  i: HL$hR H$   R H$  R Hh HL$0aR ILD$0H$@  IPHH$   YH$X  Ht9 H$X  H$`  H$h  H$@  9 HL$0R HMc} HMtbfD  HL,    HM4$H$   L$   I+HH;rR L$   K(IHI;rL$   L$  HX H$   oQ HO HL$h\Q Hd HL$0IQ H$@  UHD$ L$   LD$hHT$0H$  HH$X  Ht8 H$X  H$`  H$h  H$@  8 HL$0P HL$hP H$   P IP  H H$  P HL$  H$@  HPHH$   荁H$X  Ht&8 H$X  H$`  H$h  H$@  8 H$  FP L$   H$   L+IMuQ H$   H IP  Ǆ$      L$   MH H
^ y$   L$   MP  H H
5  I^IN"jMc   IcE ILINH$   Ht87 H$   H$   H$  H$   7 H$  Ht 7 H$  H$  H$  H$p  6 L$  I[@IsHA(sIA_A^A]A\_HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   6 Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$p蟍MH{   \$0ffff     IG I+GHL;r9O IGB4H( HHH H; r   H
 P"HHL$8Htf(%IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH%L_L$      H$   H9$   vUN Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vN HtH;t$ptM I+H(D$PfD$`LL$8A   HT$`HL$p蓒L$   L;$   vM Ht$pHuM MHD$pLIL I;K wHtHIH;HszM IH$   L;pHH$  HD$ L$  LD$pHT$8HxH p.H$   Ht3 L$   L$   L$   HL$p3 f(($   H   A_A^A]A\_^[HLH L@HHSVWATAUAVAWH   HD$@)pLHٹ   r3 Ht
HL$pHE3E3IHD$pL$   L$   L$   HSHL$pMH{   \$0ffff     IG I+GHL;rL IGB4H HHH H; r   H
u 0HHL$8Htf(j"IHD$8H$    uIH$   H+$   HH$   HH+$   HH;s33D$(\$ L$   LD$8PH"L_L$      H$   H9$   v5K Ht$pHt$PH|$XH$   H+$   HuI1L$   L;$   vJ HtH;t$ptJ I+H(D$PfD$`LL$8A   HT$`HL$psL$   L;$   vJ Ht$pHuJ MHD$pLIL I;K wHtHIH;HsZJ IH$   L;pHH$  HD$ L$  LD$pHT$8HۆH pH$   Ht0 L$   L$   L$   HL$p0 f(($   H   A_A^A]A\_^[HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   E0 Ht
HL$8H3HD$8HǄ$       L$   HHL$8n3I;^   IE I+EHH;r
I IE4H HHH H;ݿ r   H
g "HH$   Htf(YH3HD$XHL$PH+HH;rH HL$PH<HZH$   HD$ MLD$8H$   I0sH$   qNHT$XH+T$PHfWI}3fHD$XH|$PH+HH;s/ID$ I+D$HH;rH HIL$H@HHHtH. HD$P    HD$X    HD$`    HL$8u. f(L$   I[ I{0Mc8(t$pIA_A^A]HAUAVAWH   HD$0HXHxL` )pMMLLHZ H+ZH   . Ht
HL$8H3HD$8HǄ$       L$   HHL$8>3I;^   IE I+EHH;rF IE4Hʽ HHH H; r   H
7 HH$   Htf()H3HD$XHL$PH+HH;rfF HL$PH<HZH$   HD$ MLD$8H$   IH$   qHT$XH+T$PHfWIt{3fHD$XH|$PH+HH;s/ID$ I+D$HH;rE HIL$H@HHHtHj, HD$P    HD$X    HD$`    HL$8E, f(L$   I[ I{0Mc8(t$pIA_A^A]HL$WH0HD$ H\$PHHYHH\$HHtH+ H_H\$@HYHH\$PH0_+ H\$WH HHBHAHpC HS0HO0`HSpHOpaL   H   L      H      'C D   D      H         H      B D  H   H   A   D  + H\$0HH _@WH HA HLHHAL@MtDHMtHHIL;tqMtHHIL;tqIHO(H\$8I艣LL$0LD$0HW(HC@H\$8HG(H _HL@HHWATAUAVAWHPHD$0HXHp )pMMLLfWHRH@x3HI9\$~Dff     M,$IF`I+FXHH;rB INXID HHI;\$|L$   I   MFIF8HD$ MNpIV@I"5:U fWAE I   I+   HI;wtLIwB Ht;HH;vVpL$    ITB HuMt5pII?IwI   I+   HH   H       I   I+   HH;rA I   $   H$   H#H;tUI   I+   HH;rA I   fWIHI   I+   HH;k6IN8HtHQ ԚHH? ?    mH      AE $   H$   H#H;t3@IN8Ht+H {HH lHHj? l?       L\$PI[8IsH(t$@IA_A^A]A\_HWATAUAVAWH`  HǄ$  HXHhHp)p)xf(IHH   DBH>    /' E3Ht
HL$`HIHD$`Lt$xL$   L$   H$0  HD$ LL$`LHHPf(HT$8H$   9> Hx HL$8> L$  t,HT$8H$   > MHIAHL$8>    t& Ht
H$   HIH$   L$   L$   L$   H$0  HD$(t$ L$   LHH9HT$8H$   s= Hx HL$8 > t,HT$8H$   I= MHIAHL$8= ADt$0H\_ HL$8= HT$8H$   R< HL$8= H H$0  Hf(< MIASHT$8H$   < MHIAHL$8_= MIASH^ HL$8#= HT$8H$   ; HL$8#= 
   H$   0; H$0  HcQH0  HP   H$   ; HH H$0  <HHuI
H HcHHHW   H$   : HH HHHuI
H HcHHHW   H$   z: HH\ H踖HHuI
H HcHHHW   H$   8: HH HvHHuI
H HcHHHWH HJHT$8H$   ; MHIAHL$8; IHE H+EHH+  $  =e? D  H\ HL$8N; HT$8H$   9 HL$8N; L$   L+\$xII;r"< HD$xH$   H$   HH$   H+HH;r; H$   H$   HH$   H+HH;r; H$   H$   H+D$xHH;r; Ll$xHE H+EHH;r; Lu
   H$   8 H$0  HcQH0  HP   H$   n8 LHH$0  8 HHu3
H HcHHIT$A$   H$   (8 LAH^9 HHuE3I
H HcHHE3IT$A$   H$0  7 LAL H9 HHuI
H HcHHIT$A$   H$   7 LH8 HHuI
H HcHHIT$A$L$   AH$   \H8 HT$8H$   P8 MHIAHL$88 L$   H|$xL+II;r9 H|$xH$   H$   H+HH;r9 H$   \fTf/vt$0Ɖt$0t$0HHE H+EHH;H$   Ht  L$   L$   L$   H$    HL$xHt Lt$xL$   L$   HL$` H$   >7 L$`  I[0Ik8Is@A(sA({IA_A^A]A\_HL@HHUVWATAUAVAWH   HǄ$   HX )p)xMHH u / Ϯ uIʮ 
  
 
   
 
z H$H  HD$ pf(fW$(  HW H+WHHL$(  L$@  I臄H_ H+_H    E3Ht
H$   HIH$   $(  L$(  HH$   pH_ H9_vO7 HHD$@H\$HH_H;_ v27 HHD$0H\$8    Ht
HL$PHIHD$P(D$@fD$@(L$0fL$0D$(  LD$@HT$0HL$PыIH_ H+_HH       HIE I+EHH;r6 IEL4fffff     HG H+GHH;ri6 H_HD$pHL$hH+HH;rI6 HL$hHA XHD$     L$   MHT$PH3HG H+GHH   L=:ff     H$   H$   H+HH;r5 H$   5. CY<H Y4f(AXAHw H+wHHHIE I+EHH;re5 IEX44HHG H+GHH;_L$0  H$   II HG H+GHH;r
5 H_HD$pHL$hH+HH;r4 HL$hHHHH_ H+_HH;A    HL$hHtl Ld$hLd$pLd$xHL$PS H$   Ht@ L$   L$   L$   H$    f(L$   I[XA(sA({IA_A^A]A\_^]HHXHhHpWATAUH   D]T )p)xHHHHD)@D)HD)P'<D\$(H-+|$ AA| IcL    h AY)` f/U  D D
~< DUF Ip     I   E^      IHiN  HHH+HHHHiH+IŉDCMi  IIH+HHHHiL+DCD;sA+	A+ȁfH*AYfD/xA) A) \YXf(YAY f/wUDR HL$ H:D\$(|$ AA| IcL    h AY)` f/fnY(t$p(|$`L$   I[ Ik(Is0E(CE(KE(SIA]A\_HH7fnY@WH HAHLHHAL@MtDHMtHHIL;t_MtHHIL;t_IHO H\$8IyLL$0LD$0HW H;H\$8HG H _HHXHhHp L@WATAUAVAWH   )p)xD)@D)HD)PD)xD)hD)XD)t$pD)|$`L$  IA   MHLDD$ ADH`D@xD3 fA(A\f(fATf/V  H$  L$X  =$C DC D$  D$  D$  D$  gfffIH      AA+ufA(AXAYA$(  fA(fA(A\AXYB ^fA(AY\f(Y\ fE/f(vfW-XB f(Y-lB fA(AXA\fA(\A\YXfA(^\$  A$H$  H#H;tRfE/H$  wH$  Y5$ f(X f/w%fE/H$  wH$   \f/vfA(AXAYA$=A IH]A4$Ll$0t$HHl$@Ht!I;  HtI;  H;^tTH. Ht?HH;  H<    Hz. Hu	H|  H$@  HH    H3H^HH+HLMM~:fHE f(HI;fYLIE f(DHfXf)D|HL$(LHH$P  MLHl  @ fE/H$  wH$  fE/0H$  AX4$AYA4$wH$  A\fATf/  H]t$HLl$0Hl$@HHt!H;\  HtH;O  H;^tTH- Ht?HH;4  H<    H, Hu	H  H$@  HH    H3H^HH+HLMM~:fHE HI;f(LIE fYf(DHfXf)D|HL$(LHH$P  MLHHI4H$p  f(A$f(YH$`  Xf/wwfA/spH$x  f(fAT fWf/  fA(A\Yf/4 rD$  fE(fE(fE(E$fD(fD(D$  $  fD(fD(fD(DD$ AfA(ADD$ A\f(fATf/   D(t$pD(|$`L$   I[0Ik8IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_XXXXXXXX3tH8V 3LD$PHT$HE3)t$ D$H}5o- fTf/S= vH H
 ^Pmt 3LD$PHT$HE3ɈD$H}fTf/= vH H
I P 3LD$PHT$HE3ɈD$HK}fTf/< vH~ H
 O(t$ H8@UATAUH   Hl$PHE H]PHuXH}`)u HL!LiA0HJHH;voWHHumH    H=   w9H   HHH;w
HHH_ H+HT$PHH$H    H) HHuHtVHG3H97HDHH=   IE IL$t$@HD$8   HT$0HD$(   HD$ LM$IT$Kt	H( H]PHuXH}`(u He0A]A\]H\$UVWHPHqHHD$pHHL$ D$HHt$8Ht$pHD$(tH#HHD$pHL$xHڃH;HT$xHMHHHL$0LH+E3HH+HT$ HH,CCH;}:D$Hfffff     HHH;f(Df^f)D|HT$ HL$0LLH$   HHP_^]Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t*Ūt ŪtUH\$P3H;tH
' Ht
H蓆HHHHwHH+HLMM~#(  ff     HHI;f)D|HL$ LHQLD$XH-~/ l$XHPH\$PHl$`Ht$hH@_LI[IkIs WH   Hj3HHH   ICICICIC@ HtHS3HCHHtH3HBBHVHHD$hHL$xD$pHHHT$8HT$PHL$0HL$ HT$XHt$H\HH;|L$   I[Ik Is(I_H\$UVWH   HBBPHHL$(HHBHAHBHAHB HAHB(HA HB0HA(HB8HA0HB@HA8HBHHA@HHHxD$pH$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}ID$pHT$(fffffff     fHHH;HfYfXDf)D|HL$ LLHH$   HHĀ   _^]LI[UVWH   HBBpHHL$(HHBHAHBHAHB IKHHB(HAHB0HAHB8IKHHB@HAHBHHAHBPICHB`ACICHBhICHHHhIktH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH4CH;}U$   HT$(ffffffff     fHf(HH;HfYf(Tf\f)T|HL$ LLHqH$   HHĠ   _^]@UH   Hl$PHH   H   L   L   L)   A0HU0HHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@HAHHU HHAPHBHAXHBHA`HBHAhHB LeHL;vOH}     HM LMpLE0HU8t$@3HD$8   J    H9u HDH=   IE HD$0HD$(   HL$ HM@tt	H! H   H   L   (   L   H   ]J    H   w<J   HHH;w
HHHC H+HL$PHH$H! HHHNHL$VWATAUAVH@HD$ H\$xH$   MLHH HH}HOHsH      Q E3HtHIHLsLs Ls(H      ! HtHIHLsLs Ls(H       HtHIHLsLs Ls(IHO<;IHOH@<HH\$xH$   H@A^A]A\_^H\$Hl$Ht$H|$ ATH@Hy0MHH_H񀻡    u2ffff     HKI3 tH[HH    tHH^0H|$(HD$ HtH;t9 H;tHWI uHL$ HF0HL$0HD$8HHD$0HH\$PHt$`H|$hHE HAHEHHl$XH@A\H\$Hl$Ht$ WATAUAVAWH0Li8LqHHHT$ 3HIt$`LH HtI;ty M9l$tGHT$ HOLHHHuP HHtH1HF0H9Gu5 HWHp*HHHP tHOHHT$ LJH   HYHl$pHt$xHH\$hH0A_A^A]A\_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ LHHHu~ HHtH1HF0H9Guc HWH@H   H(Hl$PHt$XHH\$HH0_H\$Hl$Ht$ WH0HH3IIHt$@P tGHOHHT$ L/HHHu HHtH1HF0H9Gu HWHpH   H
Hl$PHt$XHH\$HH0_H\$Hl$Ht$H|$ ATHPHHL$ L 3ILHHE8H}HHu8HtH;}t8 H;   Hu$ E3LI;[0u HSIdHu     t HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\H\$Hl$Ht$H|$ ATHPHHL$ LU 3ILHExH}HHHuxHtH;}Ht H;   Hu E3LI;[0u HSI4Hu     t HC    u/HH     {     HH     t_HC    uH;XuHH@    tH4H\$`Hl$hHt$pH|$xHPA\H\$WH HtH  HH\$0H _HL$WHPHD$ H\$hHt$xHcHH HH~@H|$p3HHGHGLHMt:MtHHIL;tGMtHHIL;tjGIIMHWyLOLGLD$0LL$8MtWMtHHIL;t#GMtHHIL;tGMtHHIL;tFIIHxHT$(HHH\$hHt$xHP_HWATAUAVAWHP  HD$HHXHhHpLHH HL$ ` IHT$ IHL$ f    DBHL$Pz E3IL9vH   Hy8 HL$  HT$ HL$P HL$  HF@HL$`e A   ML9fP~Kffffff     H~@IH^HHH2 HL$`0qH AIIcH;FP|HT$ HL$P MHIAHL$ z AHIcH;FH'HL$P L$P  I[0Ik8Is@IA_A^A]A\_H\$ WH   HًI@H;K4rS0+C8;s;tHKPI'C@SD;  K0;  +K8H$   L$   )$   )$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPH)HwH|$05 D,[PHt$PfAnf(X^^* D$`|$8Y5 t$hHt.HH;tD̄tC̄tCH$   3H;tH Ht
HhuHH/HHwHH+HLMM~JffY ffD  Hf(HI;fDfYfXf)L|HL$ LH\HKP$C@H$   ($   ($   L$   H$   H$   HĠ   _C@H$   2HĠ   _HHPWATAUAVAWH@  HǄ$   HXHhHp MMHH耉3E3E3HV H+VHgfffffffHHHH?Hd  HCHD$0Hl$ 3H|$(H*$x       IO I+OHHHH?HL;r IGHH$   gH_XLIt$I;t$ v I<$H|$pHt$x(D$pfD$`Hu E3LJ4I;s wHtH3H;ps Ht$hIt$I;t$ v I<$H|$@Ht$H(D$@fD$PHua E3LH4I;s wHtH3H;ps7 Ht$X    Ht
H$   H3H$   (D$`f$  (L$Pf$0  DL$  H$0  H$   gIO I+OH*HHHH?HL;r H|$(IH$   H$   HH$   ѿH$x  HN H+NHgfffffffHHHH?HL;r: HT$ HVHL$0臜HH$   H$BHO0H$   BH$   Ht 3H$   H$   H$  H$    H$   Hts H$   H$   H$   H$   N IH$   Ht9 H$   H$   H$   H$    IH|$(H0H|$(HD$ (HN H+NHgfffffffHHHH?HL;H*L$@  I[0Ik@IsHIA_A^A]A\_H\$Hl$Ht$H|$ ATH0Hq8HiLHHLHT$ HH HtH;t H9wuHIHP tH\$@Hl$HHt$PH|$XH0A\H\$Ht$WH0HyxHqHHHLHT$ hHH HtH;t H9{Ht$HH\$@H0_HWATAUAVAWH   HD$ HXHhHp IHH3$   Li8LqHT$(HLH HtI;t M9l$tULHT$(HKHHHua HHtH1HF0H9CuF HSH@H薼H  HHHP   HKHLHT$(IHHHu HHuHHH@0H9Cu HSH@HL$8H\$XH+\$PH    Ht
HL$hHHHD$hfW$   L$   HHL$hGHHD$XH|$PH+HHtaH;rO H|$PH$   H$   H+HH;r( H$   fnHHD$XH|$PH+HH;rHT$hHLH$   Ht H$   H$   H$   HL$hs HL$PHtc Ht$PHt$XHt$`HL$8J HH   HںHL$   I[8Ik@IsHIA_A^A]A\_HHPUVWATAUAVAWH   HD$PHX)pMHLE3D$   I@HD$ L
Z DA HOZ H
a KiMIVIHtgII      Ic$   H$   I#I;w
IL;r/Hn5 HD$(HB+ HD$ MH H
` I]H\$8Lt$`HT$hHL$0HHHAHBHAHBH$   HL$XHHHAHBHAHBHAHBHA HB HA(HB(L$   ImHuI9HH;v9H4    H HHuHt9HHoIuHtI;t9HtI;t9̄tx9H;tt Ht
HjHL'HwImHtI;t;9HtI;t&9̄t9H;tH Ht
HjHL'HoIuHtI;t8HtI;t8̄t8H;tH
 Ht
HAjHL'HwHHH+HHHH~JIE fB(4HfB(f)D$0HL$0Zf(IfB(fYfXHfB)IL;|LLHH$   HH$0  ($   H   A_A^A]A\_^]LD$HT$WH0HD$ H\$XIHD$@    LAHHQHD$@   H HH\$XH0_LL$ LD$HT$HL$SUVWATAUAVH0HD$ IIHLHZ HHHL$(H$ HHBHAHH> IM@H	I  HI  HL$(HV HL$   IFHAIFHAIFHAH IV %HO Hz HHHIN8HtK 3IF8IF@IFHIN 4 IIH0A^A]A\_^][H\$WH H<tH HH\$0H _LIKVWATH`HD$ I[IkIHHHb HE3LaHyI{AL$ HtH8IHD$   D$   L$   3HBH HH{H   y HtH8IHLgLg Lg(H{x   O HtH8IHLgLg Lg(H      " HtH8IHLgLg Lg(H       HtH8IHLgLg Lg(H      HtH8IHLgLg Lg(L@  LH  LL$   HHhHL\$`I[(Ik0IA\_^HL$WH0HD$ H\$HHt$PHH   8H  H   H  = H  Ht 3H  H  H  Hp   H   KH   >8HOpHOp HOPHtx HwPHwXHw`HO8c HO HtT Hw Hw(Hw0HOH\$HHt$PH0_0 HL$SH0HD$ HHp HK06HKp,H   N H   @ HH0[H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ 迡L_0L[ H\$hHt$pHP_L;v\ HH|$8LD$0HD$0HT$@L(D$0HfD$0H\$hHt$pHP_HHPWH  HD$hHXHpIHH3t$0MHHL$pN Ht
HL$8HHHD$8Ht$PHt$XHt$`   x HtHHHHsHs Hs(D$0   H  H6  HD$ LLD$8HT$pHL$PHt Ht$PHt$XHt$`HL$8 HL$phHL$  I[Is I_HHPUVWATAUH@  HǄ$   HX)pEAHHHL$0HD$PH+D$HHH;         DBH$0    H   H\$PH+\$HHH/ H$@  [HH  HH [HH HH` [H$  H$0  f  HH$   E H5 H$   HH$     H, H$   Hr H$    E3D$p  HH  H+@  HAMy Ht
HL$`HIHD$`L$p  HHL$`]=EQ  @   H  L
 LD$`HT$0Mf(HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H{ f(  H  L
x LD$`HT$0ɳf(HL$xHtB Ll$xL$   L$   HL$`# HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(H f(X      Ht
H$   HIH$   L$   L$   L$   @t0H  H HD$ L$   LD$`HT$0f(.H  H` HD$ L$   LD$`HT$0f(H$   Ht L$   L$   L$   H$    HL$xHt Ll$xL$   L$   HL$` HL$HHt Ll$HLl$PLl$XHL$0 HKHt LkLk Lk(Hz f(H$  ($0  H@  A]A\_^]LD$HT$UVWATAUH  HǄ$   H$X  EIHHE3Dl$0IHL$8被HD$XH+D$PHH;      AUEEH$  H H   H\$XH+\$PHH H$   fWHH HH KWHHo HHQ\ 0WH$   H$   HH$    H  H$   HH$    H  H$   Hm H$    D$@  HH  H+@  H    Ht
HL$hHIHD$hL$@  HHL$h8    HtHIHLkLk Lk(D$0   Et'H  H HD$ LLD$hHT$8&H  HZ HD$ LLD$hHT$8H$   Ht L$   L$   L$   HL$h HL$PHt Ll$PLl$XLl$`HL$8 HOHt LoLo Lo(H HH$X  H  A]A\_^]HL@VWATH`HD$ HXHhILHHY HILL+H*HIHHH?HI;sZH;vk HHL$0H\$8(D$0fD$@HN H+NHHHHH?HL+LMHT$@Hэ   L;   H;v HHD$@H\$HHnH;n v HH\$0Hl$8(D$0fD$0Hu E3LKdHHI;k wHtH3H;hs Hl$8(D$@fD$@(L$0fL$0LL$@LD$0HT$PHWHOHt HG    HG     HG(    HL\$`I[ Ik(IA\_^ HT$HL$SUVWATAUAVAWH   HD$ HHH  HjH  <NL@  I,    Ht
HL$pH3HD$pHǄ$       HǄ$       HǄ$       H  H$   HT$pH]qLL; v] L7H_ H9_vJ MtL;7t: L;  Mu& E3MM;{ r IHx  蓪LH  H+  HgfffffffHHHH?HL;  Mu E3MM;{ r IH   hHN H+NH*HHHHH?HL;ro K<dHHFHH  DMuI E3MM;{ r5 He I 1  HǄ$  IUHu3IM(H+HI] HH+HH;sHHCIE H$     H;v I} H|$0H\$8IM IuHH+Hu3#H;v HtI;} t{ H+H(D$0fD$PL$  A   HT$PIIuI;u v> I} Hu/ E3LHI;K wHtH3H;H   H$   H$     HN H+NHHHHH?HL;r Hn   3HL H+LHHt/    H;r HD4HHL H+HH;r؋H$   H$   H+HL;rT H$   B,H$  L$+I;C   IUHu3IM(H+HI] HH+HH;sH+HCIE    H;v I} H|$@H\$HIM IuHH+Hu3#H;v HtI;} t H+H(D$@fD$`L$  A   HT$`I	IuI;u vi I} HuZ E3LHI;K wHtH3H;Hs0 HH$  I;H$   H$   H$   *H$   H$   H$   H$   H$   Mu E3MM;{ r I(VHp  H  lIE I+EH  H$   Ht5 HǄ$       HǄ$       HǄ$       HL$p HĨ   A_A^A]A\_^][H\$Hl$Ht$H|$ ATAUAVH0LHHI H{I*LL+I3MIIHHH?HuH=H;v HM HtH;t HMIH+HHHHH?HHE HL$ HT$ HHEMHAHA   HkH;k vZ HHl$(H\$ (D$ fD$ Hu7 LLH<HHI;{ wHtH3H;~s
 H\$PHl$XHt$`H|$(H|$hHL$ HI$HAID$IH0A^A]A\@SH Hb H      ?   Hǃ       ^   H   ,;L   H HHH [@SH HE3H     @@ǃ      D   H   H D   HD   L   HH [HL$WH0HD$ H\$HHt$PHHxH      ?H   Hǆ        ^   ,   ;L   H) HWH   ?_LS LHR H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHE3D   ǆ      H     @@H   D   D   L   Hώ HWH   ^LR LHR H   HH\$HHt$PH0_HATH   HD$ HXHhHpHx HHHZIHtI;tCHtI;t.̄t$H;Y@t%HI8 HtHOHE8HE8    H]@HHH+HLM3M~Hf(HE8f)HI;|LHU8HsHuLEhLHU8HM ;tNHh HL$(u HL$P HQ HD$PHT$(HL$ht H` HL$P Ht$0H^HtI;t,HtI;t̄t
H;]Pt%HMH HtHNHEHHEH    H]PHHH+HLM3M~3fo
 fffff     Hf(HEHfWf)HI;|LHUHHL$(}Hǅ       H   H L$   I[IkIs I{(IA\H% HL$WH0HD$ H\$HHt$PIHHHK HHRHu HF`H^pH HFhH~xH   H 
   >H   H?H   H   Hǆ       HH\$HHt$PH0_H\$WH H HHAhHIHt HO8j HO ` HOV L LtH HH\$0H _HH   )xHXD)@fD( ID)HD)PD)XfD(fDTfD(fDTfE(D)`EYD% fE/r)H@fA(fA(LHD$ fA(WBf(    )$   fA/rWfA(Mf(fA(?=w6 H$   E^LHD$ fA(YfA(\fA(A\]fA(Vf(fA(HH$   E^fA(LHD$ f(XY=n YfA(\fA(A\($   fWD(d$0D(T$PH$   fA/D(\$@D(L$`D(D$pvfW=" f(($   HĨ   HT$HL$UVWATAUAVAWH   HǄ$   H$   EHHLq L+qI    Ht
HL$PH3HD$PHD$h    HD$p    HD$x    LD$P3H;Hh&LH$   Hu4HMHtf HE    HE     HE(    HM E       Z Ht
HL$ H3HD$ 3H\$83HL$@3HT$HA   M;f  MM+L$(  Hu3H+HHH+HH;sLHHL$@H\$8	  HH;v HL$@H\$8Ht$ H$   H$   HH+Hu3$H;v HtH;t$ t H+H($   f$   L$(  A   H$   HL$ H\$8LHL$@H;vQ HL$@H\$8Ht$ Hu7 E3HL$@H\$8HD$ LII;S wHtH3H;Ps HL$@H\$8IM;w
HT$HL$   EtpE3IMthff     HH+HH;r HL$@H\$8H4H+HH;r H\$8IH+HHHI;sHL$@H\$8E3D$(     0 Ht
HL$PHIHD$PL$(  IHL$P$HT$PL$  IHL$hHt L|$hL|$pL|$xHL$P I+  IIDHHL$PIM   fD  HD$@H\$8H+HH;r H\$8HHD$pHT$hH+HH;ro HT$hH4HE H+EHH;rO HT$hHE9r.HD$pH+HH;r& HT$hD<HI;aHD$pH+HH;r HT$hHT$PIHL$hHt L|$hL|$pL|$xHL$Pv IHL$8Ht] L|$8L|$@L|$HHL$ D HMHt5 L}L} L}(HM   H$   H   A_A^A]A\_^]LD$HL$SVWATAUAVAWHPHD$ )t$@MLnI\$Hu3LI9II;vH<    H LHu
Ht3Ll$(H\$0HcI;\$}_I$4H\ HHH\ H;v\ r   H
 \ 軸HH$   Htf(HID H$   LHLD$(H$   H#=H$   HCH$   HIt$I;wt@I  Ht/I;vL4    I Hu
MtII?IwH赳D  HcI;T$}ID IH@HI (t$@HPA_A^A]A\_^[HLH HPHHUVWATAUAVAWH  HǄ$   HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(IHH$  HL$  LI|$ ufEWH$  H$   DfD(fE(H$  DY(D$  fE(H$   DYD$  H$(  D3H$  D HnHE3HuI/H;v%H    H# HHuHtH$   H$   H^HHtH;tHtH;t̄tH;t+ HtH6BHH$   IH$   H$   HHH+HLMIM~Hf(f)HI;|LH$   HEL$   H$  D5 D= D% D  L$   L$   $   I\$HtHH;  
HHtH;    H;_tHH Ht7HH;  H4    Hv Hu	H[  HL/H_HHH+HLMIM~=f    I$f(fYIf(fXHf)HI;|LHH$   {LH$  LHH$  HbtAXAYIH[f(fA(H$  YH$  X	f/,  fA/r	E  f(fATfA(fAWf/   f/=8 sMfD(fD(HH$   zfD(Y5 A



 $  H$  H$   D$   DD$xDT$p|$hT$`t$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHH
D   0   Y $  H$  H$   $   T$xt$pDL$hDD$`DT$XLd$PH$  HT$HH$  HT$@H$  HT$8HL$0L|$(Ht$ LLHHbDH$    AL$  I[PA(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]H8|
 3LD$PHT$HE3)t$ D$H',5 fTf/ v  "   ( 3LD$PHT$HE3ɈD$H+fTf/ v  "   v 3LD$PHT$HE3ɈD$H+fTf/o vO  "   (t$ H8LIKHxHD$0E3LILI LI(HICMKMKI II@IAMCHI HBI@(D$@fD$@ACD$ MKMCIS8HxHWH`HD$ HXHp HHHzHxfW@Ht4HHHHt
̄t
̄t
H;t"H Ht
H<HH    H{HHH+HLM3M~%(m fffff     Hf)HI;|LHHL$(- l$xH$   HNHtH3HAAHNHL$(HD$8D$@HD$H    HD$P    LD$xH$   HL$(賋HL$HH\$pH$   H`_H% HHX WATAUH`  LQH)p)xHCHHD$PHT$hIBHD$XHAHLRHBHAHBHA MHB HA(MHB(HA0HB0HA8HB8HA@HB@H$   H$   Iu
fWf(CH$   HT$PAh    H|$X fWuf(H$  H$   @f({ ;H$  H$  f/   f(Yf/   IE     A<$HoHt$@Hl$0H$  tH&HH$  HT$ HكH;HL$ HMHHHL$(LH+E3HH+HHH4CH;}$D$@fHHH;f)T|HL$(LLH-  f(YXտ f/A$rfW! A$H$   HT$PAh   O HHwf(A\,$H$  $0  tH&HH$  HT$ HكH;HL$ HMHHH$   LH+E3HH+HHH,C詢H;}?$0  H$   f    fHHH;f^f)D|H$   LLHOA$\A^$AE H$  H$  L$`  I[8A(sA({IA]A\_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$8f@ HHH;f)T|HL$ LLHkLD$hH-[ l$hI5H\$`Hl$xH@A\_^@UH   Hl$PH]PHuXH}`LehLHM )u0A0ID$(HHID$0HAID$8HAID$@HAID$HHA HBHH;vH
HuLH    H      H   HHH;w
HHH H+HL$PHHHFML$ M$t$@3HD$8   HL$0H9>HDIL$HH=   HEHPHE HT$(IT$HD$ zt	H H]PHuXH}`(u0LehHe@]H HHhH_@UH   Hl$PH]pHuxHHFHHM H   HHFPL   )uPA0HAHFXLHAHF`HAHFhHA HFpHA(HFxHA0H   HA8H   HA@HBHH;v$H
HuLH    H      H   HHH;w
HHH H+HL$PHHID$LN@Lt$@HV3HD$8   I9<$HL$0HDHNHH=   HE8HD$(HE HD$ t	Ht H]pHuxH   (uPL   He`]HS HHhH_)H\$UVWHpHBB8J@HHL$0HHBHAHB HAHB(HAHB0HA HHHxD$XL$`H$   tH,HH$   H$   HكH;H$   HMHHHL$ LH+E3HH+HHH,CH;}aD$XHT$0D$`ff@ fHf(HH;HfYf(fYf(Lf\f)L|HL$ LLHYH$   HHp_^]LH   HD$ LL$(HIHBIAHBIAHT$HHA(HHA0HBHA8HBHA@HBHAHHB HAPHB(HAXHB0HA`HB8HAhHB@ISHHHAHBHAHBHAHBHA HB 3ICICHT$(HL$Hc3H   H%
 HHHWH`HD$ HXHp HHY   貸 3HtHHHHsHs Hs(H_8   膸 HtHHHHsHs Hs(H_p   \ HtHHHHsHs Hs(H      / HtHHHHsHs Hs(H   H\$xHK= HK0[HKpZH    H   
 Hp     軷 HtHHHHsHs Hs(H   H     耷 HtHHHHsHs Hs(H      S HtHHHHsHs Hs(HL\$`I[ Is(I_H\$Ht$WHPLAHHI*MuE3HI(II+HLIIH?LH{ IHI+HHHH?HI;s;3LKLƈD$(D$`   HψD$ oL_0L[ H\$hHt$pHP_L;v HH|$8LD$0HD$0HT$@L(D$0HfD$0/H\$hHt$pHP_ATH@HD$ H\$PHl$XHt$`H|$hHL3HH\$(H\$0Hz H+zHHt3 H.HHD$(H|$0HN H+NHHt,H;r HFHHL HHN H+NHH;rHT$(I HL$(H\$PHl$XHt$`H|$hH@A\H%q Ht$WH 3HH9q vGH\$0fD  H_HK: HK0 HG(HGHH;GuHHGH;w rH\$0Ht$8H _HWATAUAVAWH  HD$`HXHhHpAMHLI>HC H+CHuII<     i E3Ht
HL$ HIHD$ L|$8L|$@L|$HHHL$hDHT$ HMD8$  AH\$8H;\$@v! HD$ HD$PH\$X(D$PfD$PH|$PH\$XHt$@H9t$8v HtH;|$ t H;     DBH$    IH$   ' HHI &Hu MLI;[ ry Hk H+kHHIti@ HuU MLI;[ rA HC H+CHH;r* HCIH$    HHLK %HH;rHu MLI;[ r HC H+CHH;r HCIH$   ] HHM %HT$hH$    HI:HL$h H$    HuY MLI;[ rE H0?H\$8HtJHt$@H;t6H@ HHtϱ L;L{L{HK軱 H0HCH;uHL$8褱 L|$8L|$@L|$HHL$ 英 L$  I[0Ik8Is@IA_A^A]A\_HATHp  HD$XHXHpHxIIHL   DBHL$` Ld$HHD$pHD$PLLHHL$HHT$ HL$`{ Hx HL$ ( t/HT$ HL$`T H$  LHAHL$  HL$`2 L$p  I[IsI{ IA\L$D$HXH      )t$@D$xHD$x)|$0f(H#f(H;u,H
 HK L
$ LD$`Hj HD$ >D$xHD$xHH#H;v,H
Q H L
 LD$`Hj HD$ >f/
 w,H
 H L
 LD$hHij HD$ g>L$`HD$`H#H;v,H
 H L
f LD$hH*j HD$ (>HL$`IZY(t$@X(|$0HXH\$Ht$WH 3IHt$8 HHH\$0HGHwHwHw Ht$@HH _@SH0HD$ LHHI LCL+HgfffffffIHHH?HH;u@H   HKIHIQHHC(HCH;CuHHCHCHCQHKHL$P3D$@HD$@HD$XHL$(HtIHIQHzjHC(HCH;CuHHCHC H0[H\$Ht$WH HAHHxHt HHHHtH;y(t%HI  HtH&HF HF     HV HH~(H\$0HF Ht$8H _HL@WATAUH   HD$0HXHpMHLH~H|$`fWD$pHu3L;HH;vJH    HH LHuHt&3LD$HH|$PHt.HH;t̄t̄tH|$PLT$XHHH+HHHHH~5 MtIBHtHHHffA)HH;|LLHT$HIkLd$ LL$HL$   IH$   $   I      H$   I#I;   H| HL$X
 I$HT$XIHL$X H| HL$X I$HT$XIHL$X H| HL$X I$HT$XIHL$X M$IASHL$H 2
  HHT$PH   H|$H$   H$   I#I;tHHcH;|   HA| HL$X I$HT$XIHL$X# H4| HL$X I$HT$XIHL$X HG| HL$X I$HT$XIHL$X M$IASH 2#H|$HH HL$H 22L$   I[ Is(IA]A\_LD$VWATH@HD$ H\$xIHHH\$hE3@ HWH;VthH\$(3D$`HD$`HD$0H\$8HtHHHHKfHHG(HGH;AuHHGHHHH9OuLgH(H\$pHH\$xH@A\_^H\$UVWH   HBBXHHL$0HAh   HHBHhHAHBHAHBHAHBHA HBHA(HBHA0HBHA8HBHA@H$   D$x	 H   HHh$   H$   tH,HH$   H$(  HكH;H$(  HMHHHL$ LH+E3HH+HHH4CrH;}#ff     LD$!HHpHH;|HL$ LLHrH$0  HH   _^]HLH L@HPHHSUVWATAUAVAWH8  )p5 E3H0H8H@IMHHILt$hN,    ILL$`H$   HH$   LHT$pL;H
c Lt$xh  HH\$XHD$XHOL8L|$XK7H$   M  IBHIIML$  IA   H4IEM+@ ^H  H$  H$   H$  H$h  L$p  I.HH$   H$  HHHAHBHAH$h  HBHH$  HHAHBHAH$   HBHH$(  HHAHBHAH$   HBHCH$   $`  H$   H$   L$@  H$   HD$PL$P  H$   L$X  L$  IEHHIHILt$xL|$XH$   Ht$`H$  H$   Hl$hLd$pH$  L$  HH+H~8Mt$@HD$8   LL$0HMLIHD$(   Ht$ L$  H$  L$  HH@IIL$   H$   Ht$`Hl$hLd$p($   H8  A_A^A]A\_^][LI[IkIs WH   Hj3HHH   ICHD$ ICHD$(fHtHK3HC0HtH3HAA(HT$@HHAHBHAHN@HBHHHHFHT$0D$`L$hHD$xHHL$pH$   HHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   HH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$8Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,C;H;}(D$8f@ HHH;f)T|HL$ LLHLD$hH- l$hI H\$`Hl$xH@A\_^HWATAUH   HD$`HXHhHp LLX HPHiHhHu3HuL9HH;vfH<    Hd LHuHtBLD$ Ht$(H}HHtH;tHtH;t ̄tH;t(I HtHzLHD$ LH\$ H|$(HHH+HLMHM~2ff     HM IE f(f\fA)HI;}LD$ LMHT$ HL$@3A$Hl$0H$   HD$8HD$ HD$HL$PLMIHH+HLMHM~6fАHD$ f(f^HE f(fXf)HI;|HT$0HL$@EL\$ L$   Ll$HHl$PL$   HT$hHL$ANI|$H|$0H$   HL$8HuLLOLOIHH+HLMM~&     IHf(fXf)HI;|HT$0IU H$   . HL$ " L$   I[(Ik0Is8IA]A\_H\$WH   HًI@H;K4rDK0A+C8;sA;tHKPIC@SD;r  K0;g  +K8H$   DAA;t!SH҉SHDDKDE;tAQ;rDCDHKPH!LGLOR D,[PHL$ LD$(LL$0fAnHHT$hH|$Pf(X^^L$XHHAHBHAHBHAYL HB$   MtaHMtHHIL;tMtHHIL;tMtHHIL;tzIHIjHT$@H]KHKPC@H$   H$   HĠ   _C@H$   2HĠ   _HWATAUH   HD$ HXHhHp HL   輝 E3Ht
HL$pHIHD$pL$   L$   L$   LD$p3H˺   q Ht
HL$@HIHD$@Ll$XLl$`Ll$hE33HL$@\HT$@HE33HL$@@HT$@HE33HL$@$Mc$   L$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;vƵ HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;v HT$@HtH;tw H+H(D$0fD$0L$   A   HT$0HL$@Ht$XH;t$`v6 H|$@Hu& MLHI;K wHtHIH;Hs HT$@HE33HL$@HT$@HE33HL$@Mc\$DL$   H|$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;vh HL$`H|$XHT$@HHT$0H\$8HH+HuI'H;v. HT$@HtH;t H+H(D$0fD$0L$   A   HT$0HL$@JHt$XH;t$`vس H|$@Huȳ MLHI;K wHtHIH;Hs HT$@HPE33HL$@Mc$   L$   H\$XHuIHT$hH+HHL$`HH+HH;sLHAHD$`   HH;v# HL$`H\$XHT$@HHT$0H|$8HH+HuI'H;v HT$@HtH;tԲ H+H(D$0fD$0L$   A   HT$0HL$@Ht$XH;t$`v H\$@Hu MLHI;K wHtHIH;HsX HT$@HHL$XHt Ll$XLl$`Ll$hHL$@ޘ L$   I[ Ik(Is8IA]A\_HHHVWATH`HD$ HXHh HH4 HE3LaHQLAHi AL$薘 HtH(IHE LeLe Le(HSHBIL9c   fW$    Hs   B Ht
HL$(HIHD$(L$   HHL$(HT$(HHL$@Htԗ Ld$@Ld$HLd$PHL$(軗 HH;{rHHL\$`I[0Ik8IA\_^DL$ HT$UVWATAUAVAWH   HǄ$   H$   AIHLI E3MT$ M+T$HgfffffffIHHH?H   E3E3$     % Ht
HL$0H3HD$03HD$HHD$PHD$XHO H+OH*HHHH?HL;r HGI<IL$ I+L$HgfffffffHHHH?HL;r ID$ID$  DLD$0HH} H9}v HE HD$`H|$hHD$PHH|$HH;vc HD$PH|$HHL$0HL$pHt$xH;v? HL$0H$   H$   (D$pf$   ($   f$   (D$`f$   \$ L$   L$   H$   HH|$HHt-Ht$PH;t@ Hǭ H(H;uH|$HH] 3HD$HHD$PHD$XHL$0B II0I(IL$ I+L$HgfffffffHHHH?HL;H$  @$(  H$   H   A_A^A]A\_^]HHHVWATH   HǄ$   HXHh HHE3D`AL$Ô Ht
HL$ HIHD$ Ld$8Ld$@Ld$HHT$ H   膔 HtH(IHE LeLe Le(Ǆ$0     HL$8HHt$@H;vf Ht$@HL$8HD$ HD$PH\$X(D$PfD$PH\$PH|$XH;v- HtH;\$ t H;   Hu MLI;{ r HH$   CZHH$   SHH跧H$   Htp L$   L$   L$   H$   K Hu MLI;{ rp H0Ht$@HL$8%   3 Ht
HL$`HIHD$`Ld$xL$   L$   HT$`H
HL$xHtƒ Ld$xL$   L$   HL$`角 HL$8HtHH|$@H;t9HYfHHt L#LcLcHKk H0HCH;uHL$8T Ld$8Ld$@Ld$HHL$ ; HL$   I[(Ik8IA\_^H\$Hl$ WH03IHH9Z ~GHt$@)t$ fWHfHL$HHvHGHXDHcH;G |(t$ Ht$@H\$PHl$XH0_H\$Hl$ WH@3IHH9Z ~eHt$P)t$0)|$ fWHHL$XHpvHG@f(Xʐ HGH^tHcH;G |(|$ (t$0Ht$PH\$`Hl$hH@_@SH H H      ?   Hǃ       ^   H   ,;L   HCM HHH [H\$WH Hg HHH HAhHIH HO8 HO  HO L LtH) HH\$0H _@SH HE3H     @@ǃ      D   H   HL D   HD   L   HH [HL$WH0HD$ H\$HHt$PHH舺H      ?H   Hǆ        ^   ,   ;L   HK HWH   L@ LH H   HH\$HHt$PH0_HL$WH0HD$ H\$HHt$PHHعE3D   ǆ      H     @@H   D   D   L   HK HWH   eL& LH H   HH\$HHt$PH0_HLH HPHHWH`HD$0HXHLJ0HL@LC(HIC(fW C(H\$xH0H\$HH{HtHH;tHHtH;t̄tH;t&Hߦ HtHjHE3E3LE3H{HHH+HHHH~)(
֟ fD  Hf(fBWfB)IL;|LLHHL$@q5H$   H`_H\$Hl$Ht$WH IIHHHHtڌ LHgfffffffH3L+HsIHHH?HHD Hl$8HHS H;HKHDHt$@H{H\$0H _HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q ~5L5d fWHMf(f(AAID;m |LHT$(HHHXHHtH;tHtH;t ̄tH;_tH Ht
HyHH7H_HHH+HLMM~!    HE f(Hf)HI;|LHHHHL$( L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\Hl$Ht$ WH@HrfWHD$8HHt$(Ht.HH;t
̄t ̄tH\$P3H;tH
 Ht
HsHHHHwHH+HLMM~#(ڝ ff     HHI;f)D|HL$ LHnLD$XH-^ l$XHyH\$PHl$`Ht$hH@_HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA D$ L
H DB HH H
E 0 L[L\$ L
hH EG HH H
 Ic_ H\$hfWt$xHuE3IH<HH;v{H<    Hy HHuHtWE3H$   H$   Ht.II;t%̄t̄tIH$   HHH+HLMIM~( f)HI;}
H$   LH$   HL$`Ic_ H\$ht$xHuI/H;vH<    H HHuHtiHL$HH\$PHt$I;tJ̄t@̄t6H\$PHHH+HLMIM~(@ f)HI;}HL$HLHT$HHL$`Ic_ H\$ht$xHuI/H;vH<    Hà HHuHtH$   H$   Ht.HH;tr̄th̄t^HH$   HHH+HLMIM~*([ fff     f)HI;}
H$   LH$   HL$`Ic_ H\$ht$xH{LH$   H$   Ht$H;t̄t̄tH$   HHH+HLMIM~'(     fA)HI;}
L$   LH$   HL$`2Mcw Lt$ht$xA   MIHL$8_Mt$L;t̄t̄tL;t$@t,HL$8 MtIsLHD$8MLl$8Ld$8Lt$@IHH+HLMM~-(Ș IIHHHfff     f) HHuMHT$8HL$`PA݉\$0Dl$X=; fff     $  ;/  AA  ~CIL$  ffff     H$   Mf(f(8HA;w |E3L$   HT$`IHHXHtHH;tHHtH;t̄tI;t(Iz HtHLHD$8MLl$8LH\$@HHH+HLMIM~fHf(fA)HI;|LHT$8HɠHL$`    DBH$    H$  H$   H$0  H$   L$   L$  HT$8H$   bH$   H$   ܚ Hx H$    t7H$   H$    H$  LHAH$   K L$   HA H
  L$   L$   H$  H$   L$   L$   IHH+HLMII;}I
If(fXf)HH$   IH$   H$   H$   H$   HD$HH$   H$   H$  H$  H$  H$   H$  \$0É\$0H$    E3L$  Lt$@Ld$8fW= \$0fn$  H$  H$   lr$  H$  HL$HQrI_H\$hHD$HH$   H$   HL$`HHHAHBHAHBHD$HH$  Ht$PHHH+HHHH~7HfB(f)D$`HL$`HD$HfB(fYfB)IL;|LLH$  H$   ~$  HD$HH$  H$  H$  3H$   H$  H;ZHT$HH[I H$    H$    HL$H H$    ($@  ($0  HP  A_A^A]A\_^[Hl$Ht$H|$ ATH@HqfWILHD$8Ht$(Ht.HH;t̄t̄tH\$P3H;tH	ߘ Ht
HjHHHHwHH+HLMM~(ђ HHI;f)D|HL$ LHnLIHH\$PHl$XHt$`H|$hH@A\HATAUAVH  HD$ HXHhHpHx )p)xD)@D)HD)PD)XD)xD)hIMHfD(fD(fDW
 A   L$P  D9%2    D-K Dz D%i 3H9^~pfA(AYfA(AYfD(D\3fE/vf(f(H虡AYD
 fA(fA(HAHHHcH;F|MIHsuAD;%} fD;%n      DBH$      DBH$   fA(H$  2  H$  ~ M] IASM] IASH$  H$  ʔ HH$   H$   HHT$xH$   LHp> H$h   L&8 HHL$P LHH$@  ה L> HH$    LHH$    L= HHL$( ME HIAHL$( H$    H$    H$@   HL$P H$h  q HL$xe H$   V H$  G H= HL$( IE HT$(IHL$( H$  S H$  D 2L$  I[ Ik(Is0I{8A(sA({E(CE(KE(SE([E(cE(kIA^A]A\@SH0
6 r6 LD$H)t$ HX5` fTf/D vH H
\5 _
֦  LD$HfTf/ vH H
 5 #H(t$ H0[HHHWATAUAVAWH  HǄ$  HXHp )p)xD)@D)HD)PD)xD)hD)XMMfD(f(fW/ @HH$@  H$   H$   H$X  HHHAHB   'z HtH$   H33HH$   H$   H$   H$   E3E3H$   I踌H$   A   L$H  $   D$   fEWD
L D{ Dj ff     D;- s  I|$   dy Ht
HL$pHHHD$pD$(  L$(  HHL$pfff     HcI;|$   f(AYfA(AYf(\fA/vH$   3f(AY"D
@ f(fA(H$   ;f(H$   H$   H+HH;r H$   4H$   H$   H+HH;r H$   I$HH*H$   H$  l H$P  L	LH$0  A   x Ht
H$   HHH$   H$  H$  H$      w Ht
H$(  HHH$(  H$@  H$H  H$P  H\$8D$0 D$( H$   HD$ L$(  LD$pH$@  I   Yw Ht
HL$@HHHD$@H\$XH\$`H\$hHT$@I6H* H$  H$  H$(     v Ht
H$  HHH$  H$  OH$  ƀ   H$  H@H$  H H$  H@H$  H$  H$(     ~v Ht
H$  HHH$  H$  TOH$  ƀ   H$  H@H$  H H$  H@H$      v Ht
H$  HHH$  H$   H$(  H$0     u Ht
H$8  HHH$8  H$P  H$X  H$`     u Ht
H$h  HHH$h  H$  H$  H$  LL$@L$   H$   H$  {yH[ H$X  H$0  H$`  H$  H$h  E3MH$X  IMIIW  H H$X  H$  HL$XHt?Ht$`HH;t-HOHtyt H_H_ H_(Het H0HL$XUt H\$XH\$`H\$hHL$@<t H$@  Ht)t H$@  H$H  H$P  H$(  t H$  Hts H$  H$  H$   H$   s H$0  H$   Hts H$   H$   H$   HL$ps D;-2   H$   Ht,H$   HH;tH H(H$   Cs H$   H$   H$   H$   s   H H$X  H$  HL$XHt?Ht$`HH;t-HOHtr H_H_ H_(Hr H0HL$Xr H\$XH\$`H\$hHL$@r H$@  Htr H$@  H$H  H$P  H$(  _r H$  HtLr H$  H$  H$   H$   'r H$0  H$   Htr H$   H$   H$   HL$pq A   DBH$0  A    DBH$  ) fA(H$@  U C H$   IIPIIPH$  H$   HHT$@H$0  ۈ HHT$pH$0  ň LH*C H$   D L6 HH$(   LHH$    LB HH$  ݈ LHH$X  Ј LB HH$    MHIAH$   ۈ H$X  ̈ H$   H$    H$(   H$    HL$p HL$@x H$  i H2B H$   4 IH$   IH$   4 H$  m H$0  ^ H$   Ht,H$   HH;tH H(H$   o H$   H$   H$   H$   co 22L$  I[@IsHA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_@UH@Hl$ HE H]0Hu8H}@LeHHLLBHL;vL
MumJ    H=   w9J   HHH;w
HHHv H+LL$ II$J    H LHuHt蚵HG3H97IDHH=   MD$I$IL$,t	Hf H]0Hu8H}@LeHHe ]HL$SUVWATH   HD$ IHH0 HHQLAIA I+AHHAH IQ4HOPLGHWLgH   H$      m 3HtH(HHE fW$   L$   IHH vfD  HHHOH9sHH;_rZH2- HL$(? HL$P Hs HD$PHT$(HL$h> H HD$PHZ HL$Pl HHĐ   A\_^][HHPWATAUH   HD$ HXHhHp LLHH	H$   HH$   H;v H$   H$   HH;v| H$   H$   Hl$hHl$0H\$8(D$0fD$0H;vG Hl$hH;t*fffff     H H u	H(H;uHD$0HtH;t H;u.HZ HL$@׃ HT$@HL$h7HL$@ۃ HT$hI螊M$  I$  I$  AH$   Ht2H$   H;t H H(H;uH$   Hk 3H$   H$   H$   HL$hj I葶L$   I[ Ik0Is8IA]A\_HL$UVWATAUAVAWHpHD$ H$   LcL II  {3; LAǆt        AA+iɫA+Ap  utAp  Ap   uAǆp       AA+iD+Et  uEtAAt  At   uAǆt     I  Ix  I  I  I  A  Ix  I  I  I  I@     i 3HtHHHHsHs Hs(Mp     Wi HtL(HIE IuIu Iu(A  A  M     i HtL8HIIwIw Iw(LH$   A  -  fD  HSHuHHK(H+HH{ HH+HH;sL'HGHC    H;v H+Hl$0H|$8HK LkHI+HuH"L;v HtH;+tv I+H(D$0fD$@L$   A   HT$@H評LkL;k v9 H+Hu+ LL] IL I;K wHtHE HH;Hs IL$   A  L;Mp  HǄ$   HSHuHHK(H+HH{ HH+HH;sHHGHC    H;v H+Hl$0H|$8HK LcHI+HuH"L;vO HtH;+t? I+H(D$0fD$@L$   A   HT$@HrHkH;k v HHu LLHD I;C wHtH3H;Fs II  AMI  I  IH$   HpA_A^A]A\_^]HT$WH0HD$ H\$@Ht$XHH3t$PN/f HtHHHHsHs Hs(D$P   H  H  ALBHH\$@Ht$XH0_H\$WHpI IHLHT$0H)t$`f(P(LOLWt$PLH$   LT$ HD$(IL\$HHH+3HLMM~;fff     II
f(HI;fYDfXDf)D|HT$ HL$@HL$09~ L$   L$   HHH$   (t$`Hp_tH\$Ht$WH HHHxHtHH;tɫH;yt%HI} HtHKHFHF    HVHH~=H\$0HFHt$8H _HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz Hu3H8HH;v	H    H} HuHt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVI   DBH$   z L$   HT$@Hrf(D$PHT$hH$   z Hx @HL$hW{ @t,HT$hH$   z MHIAHL$h&{ t$XHD$XI#I;u+HԚ HD$ L
 LD$PH# H
M hX|$8É\$0H$   z I      H$   L$  L$  |$8\$0fnF^IL$Hy ufW
H$  gWfAnt$ Y5ԍ 
 X
$ YXXHL$@%{ f(($  ($  H  A^A]A\_^[HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0GGxfEWfA.zJ  D
V# fA/6  HGPLG`HHOPP8MMHHOPs(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  IH$  I#H      H;vHw  \" _ fD(f/v   HcD= D% @ HD$0H;t5HKHT$88l$Xk(HKHT$HHK0HT$`HGPLG`HHOPP8MMHHOP}s(HGPHHOPf(XHGHLd$(Ll$ _xLGPHHOHs(HGPHHOPX$  H$  I#H      H;vHv  \HufA/vEGxAYHufD/v,GxAYGxfA/   fA.tkHD$0H;t6HKHT$8l$Xk(HKHT$HHK0HT$`ڻHL$`w HL$Hw HL$8w    H\  H$   v HL$xw H{ HD$xH$   H$   v H? HL$xQ^ H H$   Wv HL$xw H3{ HD$xH$   H$   Pv H HL$x] HL$`"w HL$Hw HL$8w L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HHHWATAUH  HD$pHXHpMIHHHHL$@u L$  M$LH$   IA$   t`H$   H
uLLd$0H$  HD$(Ll$ LL$  HH$   Hu XE3LH$   HmH$   vL$  HHHt H$  t 2L$  I[(Is0IA]A\_HT$WH0HD$ H\$PHHD$@    HALHHL@IIH|5HGLHHL@HMtMtHHIL;tMt:MtHHIL;tߢMtHHIL;t¢IIHHH'HH\$PH0_LSVWATAUH  IXE3IILH  IkMsHD$0M{ L$@  HD$ A)sICL4   HHD$(HHGAH+Hl$XH$   f(BYHH$   Ah   H$   HGHHAHGH$  HAHGHAHG HA HG(HA(HG0HA0HG8HA8HG@HA@HH$   H$   HFBY4H+HHL$hHD$PHHHFHAHFHAHFHAHF HA H$   HL$PH$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@H$h  HB@H$   $X  Y H$   HL$ $  Ll$0Hl$8IMHL;q($  L$8  L$(  H$   H  A]A\_^[LI[IkIs WH   Hj3HHH  HD$0HD$ ICHD$(HtHK3HC8HtH3HAA0H$   HHAHBHAHBHA HBHA(HN@HB HHHHFH$   $   $   HD$8HHL$0HL$HHHFHAHFHAHFHAHF HA HF(HA(HF0HA0HF8HA8HF@HA@H$   HL$ H$   HH;L$   I[Ik Is(I_H\$Hl$ VWATH@HrfWHHLD$0Ht$(Ht$htH#HHD$hHL$pHڃH;HT$pHMHHHL$ LH+E3HH+HHH,CH;}(D$0f@ HHH;f)T|HL$ LLHˬLD$hH-+y l$hI]H\$`Hl$xH@A\_^HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   HSHH_HGPLG`HHOPP8L$   MMHHOPHHL$@=us(HGPHHOPf(X9   ~7ff     HGHLt$(Ll$    LGPHHOH;   |s(HGPHHOPX$   HH$   H#H      H;vH	m  \f(T f(5w f/vNHOh-Df/v?HD$@H;t5HKHT$Hol$hk(HKHT$XVHK0HT$pHf/vf(s(HGPHHOPX   W0fWӀ HWf(ICHL$pn HL$Xn HL$H	n IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      蜖HSI I|$ID$PMD$`HIL$PP8L$  MMHIL$PHH$   rH$   H$P  rH$   H$  rH$   H$  rID$PLH$   IL$PP(H$   HHHu33H;v臚HHl HHuHtgH$   H$   H$   HHtH;t0HtH;t̄tH;t*
l HtHHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   CoH$   HHu3=HH;vZHH\k HHuHt:H$   H$   H$   HtH;t
HtH;t̄tH;t*j HtHuHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   !nIt$(Hu39HH;v>H    H<j HHuHtH$   H$   I\$(HtHH;tHHtH;tǗ̄t轗H;t*i HtHDHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ lfEWfA($   w(ID$PHIL$PfD(DX3퉬$  D%q D$   A$   A$   D-b{ A9$   |  D;{ D fH$   H$  D$   HuH5HH;+  H4    Hhh HHu	H  HL$pH\$xHt(HH;      H;t%
h HtHHHD$pHHL$pH\$xHHH+HLMHM~(a f)HI;}HL$pLHT$pH$  膒He  fAW$  IL$h<fA/  H$   H;tAHOH$   )$   o(HOH$   
HO0H$   Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I<H$   H;Z  HWH$   ^o($   HWH$   ?HW0H$   .  H$P  H;tAHOH$X  $x  o(HOH$h  HO0H$  ۩Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I;H$P  H;tAHWH$X  Eo($x  HWH$h  &HW0H$    A$   $  f/vSH$  H$  $  $8  H$  H$(  躨H$  H$@  襨n\J f(IL$h,:f/vQH$  H$  q$  $8  H$  H$(  JH$  H$@  5H$  H$   7f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$pM$L$   L$   H$   IASHt:HL$pc E$   E9$   }=ke_YHL$pUc HL$pHc 9̋$  A$   fn$   ^H$  H;tAHOH$  Ԧ$8  o(HOH$(  赦HO0H$@  褦w(ID$PHIL$PXA$   AT$0fAWIT$f(H$  H蝠H$   vb H$   gb H$   Xb H$   Ib H$  :b H$  ,b H$  b H$@  b H$(  b H$  a H$  a H$h  a H$X  a H$   a H$   a H$   a HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   AHSHH_HG`LGpHHO`P8L$   MMHHO`*HHL$@mfs(HG`HHO`f(X9   ~7ff     HGXLt$(Ll$    LG`HHOX;   |s(HG`HHO`X$   HH$   H#H      H;vH9^  \f(F f(5h f/vNHOx]5f/v?HD$@H;t5HKHT$H蟣l$hk(HKHT$X膣HK0HT$pxf/vf(s(HG`HHO`X   W0fWr HWf(IsHL$pO_ HL$XD_ HL$H9_ IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      L?HSIPI|$ID$`MD$pHIL$`P8L$  MMHIL$`軶HH$   cH$   H$P  cH$   H$  cH$   H$  cID$`LH$   IL$`P(H$   HHHu33H;v跋HH] HHuHt藋H$   H$   H$   HHtH;t`HtH;tK̄tAH;t*=] HtHȼHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   s`H$   HHu3=HH;v芊HH\ HHuHtjH$   H$   H$   HtH;t=HtH;t(̄tH;t*\ HtH襻HH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   Q_It$(Hu39HH;vnH    Hl[ HHuHtJH$   H$   I\$(HtHH;tHHtH;t̄tH;t*Z HtHtHH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ ^fEWfA($   w(ID$`HIL$`fD(DX3퉬$  D%c D$   A$   A$   D-l A9$   |  Dkl Du fH$   H$  D$   HuH5HH;+  H4    HY HHu	H  HL$pH\$xHt(HH;      H;t%=Y HtHȸHHD$pHHL$pH\$xHHH+HLMHM~(!S f)HI;}HL$pLHT$pH$  趃HV  fAW$  IL$x".fA/  H$   H;tAHOH$   Y$   o(HOH$   :HO0H$   )Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I9H$   H;Z  HWH$   莛o($   HWH$   oHW0H$   ^  H$P  H;tAHOH$X  ;$x  o(HOH$h  HO0H$  Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I7H$P  H;tAHWH$X  uo($x  HWH$h  VHW0H$  E  A$   $  f/vSH$  H$  $  $8  H$  H$(  H$  H$@  ՙn\< f(IL$x\+f/vQH$  H$  衙$  $8  H$  H$(  zH$  H$@  eH$  H$   @(f($   H$   H$  H$  H$  L$   IHH+HLMHM~'fHD$pH$   f(fXf)HI;|H$  HL$p	M$L$   L$   H$   IASHt:HL$pT E$   E9$   }=蛂蕂菂艂HL$pT HL$pxT i̋$  A$   fn$   ^H$  H;tAHOH$  $8  o(HOH$(  HO0H$@  ԗw(ID$`HIL$`XA$   AT$0fAWIT$f(H$  H͑H$   S H$   S H$   S H$   yS H$  jS H$  \S H$  NS H$@  ?S H$(  1S H$  #S H$  S H$h  S H$X  R H$   R H$   R H$   R HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]HWATAUAVAWH   HD$0HXHhHp )p)xMILH3$   =HSHH_HGhLGxHHOhP8L$   MMHHOhZHHL$@Ws(HGhHHOhf(X9   ~7ff     HG`Lt$(Ll$    LGhHHO`;   |s(HGhHHOhX$   HH$   H#H      H;vHiO  \f(J7 f(5Z f/vQH   &f/v?HD$@H;t5HKHT$H̔l$hk(HKHT$X賔HK0HT$p襔f/vf(s(HGhHHOhX   W0fW0c HWf(I蠎HL$p|P HL$XqP HL$HfP IL$   I[8Ik@IsHA(sA({IA_A^A]A\_HHPUVWATAUAVAWH  HǄ$  HX )p)xD)@D)HD)xD)hD)XD)HMILǄ$      \;HSI耺I|$ID$hMD$xHIL$hP8L$  MMHIL$hHH$   +UH$   H$P  UH$   H$  TH$   H$  TID$hLH$   IL$hP(H$   HHHu33H;v|HHN HHuHt|H$   H$   H$   HHtH;t|HtH;t{|̄tq|H;t*mN HtHHH$   
3H$   H$   HHH+HLM3M~&H$   f(f)HI;}
H$   LH$   H$   QH$   HHu3=HH;v{HHM HHuHt{H$   H$   H$   HtH;tm{HtH;tX{̄tN{H;t*JM HtHլHH$   
3H$   H$   HHH+HLM3M~%H$   f(f)HI;}
H$   LH$   H$   PIt$(Hu39HH;vzH    HL HHuHtzzH$   H$   I\$(HtHH;tFzHHtH;t'z̄tzH;t*L HtH褫HH$   
3H$   H$   HHH+HLM3M~/fffff     ID$ f(f)HI;}
H$   LH$   IL$ IOfEWfA($   w(ID$hHIL$hfD(DX3퉬$  D%5T D$   A$   A$   D-] A9$     D] Df fH$   H$  D$   HuH5HH;;  H4    HJ HHu	H  HL$pH\$xHt(HH;      H;t%mJ HtHHHD$pHHL$pH\$xHHH+HLMHM~(QD f)HI;}HL$pLHT$pH$  tHH  fAW$  I$   OfA/  H$   H;tAHOH$   膍$   o(HOH$   gHO0H$   VLt$`Ll$XH$   HD$PH$  HD$HH$  HD$@Dd$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I5H$   H;Z  HWH$   軌o($   HWH$   蜌HW0H$   苌  H$P  H;tAHOH$X  h$x  o(HOH$h  IHO0H$  8Lt$`Ll$XH$   HD$PH$  HD$HH$  HD$@D\$8DD$0HD$pHD$(H$   HD$ L$   L$  A$   I3H$P  H;tAHWH$X  袋o($x  HWH$h  胋HW0H$  r  A$   $  f/vSH$  H$  >$  $8  H$  H$(  H$  H$@  q\9- f(I$   f/vQH$  H$  ˊ$  $8  H$  H$(  褊H$  H$@  菊H$  H$   jf($   H$   H$  H$  H$  L$   IHH+HLMHM~1ffff     HD$pH$   f(fXf)HI;|H$  HL$p)M$L$   L$   H$   IASHt:HL$pE E$   E9$   }=ssssHL$pE HL$pE s̋$  A$   fn$   ^H$  H;tAHOH$  $$8  o(HOH$(  HO0H$@  w(ID$hHIL$hXA$   AT$0fAWIT$f(H$  HH$   D H$   D H$   D H$   D H$  D H$  |D H$  nD H$@  _D H$(  QD H$  CD H$  4D H$h  &D H$X  D H$   	D H$   C H$   C HL$  I[XA(sA({E(CE(KE(SE([E(cE(kIA_A^A]A\_^]Ht$WH0HD$`HHHD$ D$@    Y    t@W H   HVxH\$HH\$H   ^nx   ,;L   HHt$PH0_H\$WH0HD$`HHHD$ D$@        tS HWxH   ;HH\$HH0_LMK ECISIKSVWATAUAVAWH  HǄ$P  A)sA){MELHE+Ha HD$ L
	a MCH^ H
 jH2 H$   A IH$   IH$   A -\h $    $  5J $  =Ag $   $   
 $   MIH $   HHPH$   HHPH$(  Έ$   < $   $   fWL$HD$@E3D|$DH
la |$@   Ic   $      t$P A;  AAHHL$X? Ha H$   ? GLt$8HD$XHD$0H$   HD$(D$ E3ҋH$   ? HL$X}? AE D$ L
- D$   H H
 蒝HGHHHL$ L
 EE H H
 wLt$0HGHD$(GD$ LOLH$   I諜2H$P  L$h  D$`  L$X  D|$D$   t$Pu?HT$XH$   ϷHH$(  >HL$h? HL$X?    H$X  H$   荷L$   H$   dTHH$(  H$  L$   H$  3TLHHL$XRHH$(  HL$h> HL$X> H$   > H$   > fn$ f(^H$  H$(  ԺL$   H$   +SHH$   H$  3Lf(H$X  oSLHHL$XRHIHL$h/> HL$X$> H$   > H$   > Ɖt$PH
B^ MIHoL'^ ;L^ H$P  L$h  D$`  L$X  D$PD|$D$   $   f/   f/$         DBH$  ; H9 H$  ̖HH 轖HL$H; HHF 蟖A}H H$  腖H H$  oHT$XH$  ,; MHIAHL$X; MIASD$@ H$  :    A}$   |$H   f/$         DBH$  : H9 H$  ̕HH 轕HL$H: HH 蟕HT$XH$  \: MHIAHL$X; MIAS|$HD$@ H$  (: H$(  AD|$DHWHL$X
HI HL$h; HL$X; H
[ bLD$ L
 H H
 诹H$8  X; H$(  J; H$   ;; H$   -; D$H($   ($  H  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/HY HD$ L
Y L$   Hf H
 ¯fA/w/HX HD$ L
X L$  H H
 茯̋$  /HX HD$ L
X L$  H H
O HHPH$  IE HPH$p  fE(D% @L $   fn=^ YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$  7 H$  .9 H< H$  H$  H$  7 H@< H$  H$  +\Hu3HH$   aHD$pHHL$xH$   H$   H, H$   N7 L$  I$H$   IH$   E7 H H$   7 I$H$   IH$   7 7 $   AA   D=: D5eJ D  G D$ L
 D$0  Hk H
$ M]ICHD$ L
+ DG HX H
 ܓLd$0IEHD$(AED$ MMME H$  HAuHH$   H$  cHH$p  H$   7 H$   
7    H$  H$  Lf(H$   KHH$p  H$  菅L
 HL$@KLHH$   gJHH$p  fH$   6 H$   q6 H$   b6 H$   T6 fAnf(z ^HT$@H$p  dL
	? H$   JHH$  H$  ĄLf(H$   KLHH$   
JHHqH$   5 H$   5 H$   5 H$   5 AƙA} &	  fA(MHIfD($  fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(HtD  DX HI;IDH;tHufH*HyX D^HT$pIfD(Ⱥ   DBH$  :2    H$P  1 HH\ H$   WHHu3
H HcHHHW	   H$p  0 HAHq1 HH 
HH_:0 HHu3
H HcHHHW   H$@  1 LHu3
HHcHHISA   H$   K0 HfA(H1 HHx {HHu3
H HcHHHW   H$0  1 HH^Hy/ HHu3
H HcHHHW   H$`  / HfA(H0 HH HHu3
H HcHHHW   H$  {0 HHQ^H. HHu3
H HcHHHWfA(Hv0 1 +fn^5V $       Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHu1 HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;vA1 HL$`H\$XHt$@H$P  H$X  HH+Hu3$H;v1 HtH;t$@t0 H+H($P  f$  L$   A   H$  HL$@>H\$XHHL$`H;v0 HL$`H\$XHt$@Hu0 E3HL$`H\$XHD$@LHT I;S wHtH3H;PsO0 HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v/ HL$`H\$XHt$@H$`  H$h  HH+Hu3$H;v/ HtH;t$@t/ H+H($`  f$  L$   A   H$  HL$@=H\$XHHL$`H;v^/ HL$`H\$XHt$@HuD/ E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps
/ HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v. HL$`H\$XHt$@H$@  H$H  HH+Hu3$H;v. HtH;t$@tm. H+H($@  f$  L$  A   H$  HL$@U<Ht$XH;t$`v#. H\$@Hu. E3LHI;K wHtH3H;Hs- H$   HHT$@PfE/vH  H$   ;E2fE/vH H$   E2AE D;~"fE/wfE/vH H$   H$   H$  + M$HIAH$   G, E   fA(A\A^fATf/ vmH H$   + I$H$   IH$   + H# H$   + I$H$   IH$   + HL$XHtP HD$X    HD$`    HD$h    HL$@+ H$  * H$  $   D;$  uoH  H$   "+ I$H$   IH$   !+ H H$   * I$H$   IH$   * E2AE$   =9Q HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I+ H$  h+ H$p  Z+ H$   K+ H$  =+ L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HL$WH0HD$ H\$HHH3HyHyHyHy Hy(Hy0Hy8Hy@HyHHyPHyXHy`H   ( H      Q H   H   H   H   H   H-C6?H   H?H   H-q=H  HMbP?H  Hǃ  '  H      ?H8  H:0yE>H   H(  H@  H     @H0  H     @@HH  HH\$HH0_HT$VWATH`HD$ H$   HHLAL+HgfffffffIHHH?HH;   HpHH$   HK H$   H$   H$   H;HCHLH\$(3HD$0H~LHSHiHD$0HyHHL$(,HD$0Ld$(H\$8HD$@    Ld$HHD$PLK(LHT$8HL$H4eLLHH3H$   H`A\_^HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0-   fEWfA.zU  D
 fA/A  HG`LGpHHO`P8MMHHO`$s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  IH$  I#H      H;vH]%  \ F
 fD(f/v   HcD9 D%~9 HD$0H;t5HKHT$8jl$Xk(HKHT$HjHK0HT$`jHG`LGpHHO`P8MMHHO`~s(HG`HHO`f(XHGXLd$(Ll$    LG`HHOXs(HG`HHO`X$  H$  I#H      H;vH>$  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$8sil$Xk(HKHT$HZiHK0HT$`LiHL$`h% HL$H]% HL$8R%    H H$    $ HL$xd% H( HD$xH$   H$   $ H HL$x H? H$   # HL$x
% H( HD$xH$   H$   # HZ HL$xl HL$`$ HL$H$ HL$8~$ L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HWATAUAVAWHP  HD$pHXHhHp )p)xD)@D)HD)PD)xD)hMLHHYHHL$0)   fEWfA.zU  D
 fA/A  HGhLGxHHOhP8MMHHOh{s(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  IH$  I#H      H;vH!  \ 	 fD(f/v   HcDw5 D%>5 HD$0H;t5HKHT$8vfl$Xk(HKHT$H]fHK0HT$`OfHGhLGxHHOhP8MMHHOhzs(HGhHHOhf(XHG`Ld$(Ll$    LGhHHO`s(HGhHHOhX$  H$  I#H      H;vH  \HufA/vN   AYHufD/v2   AY   fA/   fA.tkHD$0H;t6HKHT$83el$Xk(HKHT$HeHK0HT$`eHL$`(! HL$H! HL$8!    H H$    HL$x$! H$ HD$xH$   H$    Hq HL$x H H$    HL$x  He$ HD$xH$   H$    H HL$x, HL$`T  HL$HI  HL$8>  L$P  I[8Ik@IsHA(sA({E(CE(KE(SE([E(cIA_A^A]A\_HL@HHUVWATAUAVAWH  HǄ$  HX)p)xILH    E3Ht
H$   HIH$   L$   L$  L$     F Ht
H$  HIH$  L$0  L$8  L$@      Ht
H$  HIH$  L$  L$  L$      Ht
H$  HIH$  L$  L$  L$       Ht
H$  HIH$  L$   L$(  L$0  HՋ H$   O H$   H$   詍H$   J H H$    H$   H$   oH$    LH$  HASAEH$  IE3E3H$  ILL$  H$  HAS(L$8  L+$0  IgfffffffIILIIH?LH$  H+$   IHLIIH?LH$  H+$  IHHHHH?HIIO$Ld$`H$  HtHXIHȵ H$P   Lc8  A+<  LcH$  HL$8Ld$0LD$(LT$ LLHH$  )   DBH$P   H= H$   k H-7 H$  H$`  H$   H$   H$  ] H$   F H2= H$   H$0  H H$8  H$  H$@   H$   H$   HtHXIH H$    LHH$  9Hr H$   H$  HP H$  H$  H$  z H$  c L$  L$   H$  H$   H$  H$   H$       u<MLHH$   l?HH$   ZMLHH$   @p D$xH; H$h   H; H$    H$   H$P  * H$    ^HQ H$`  sHȋ HH' sHH  H$  H$P  t $  D$t0  D$p   t)tttA   A      D,  H H$   EL$0  E   H$   HD$PAA+@  H$  H$    HH$h  H$   s H$   HL$8H\$0HD$(D$ DL$tD3A,HH$0  HL$ L$  LH$   HPHHwH` H$   H$    Aę|$pu.Lt$ LLIH$   LHH$   OKAE;H$  % +D$xfn^= H$h   @   1  Hy9 H$   0 H$   H$P   H$   * D$     L
# L# 3H  HHRHb* H$    H$   H$  H$  H$    LH$  HAS H$   H$P   HH$h    H$   y L$  IE3H$   H$h   HH$h   H$   4  D$|$  D$p0  D$t   t+tttE3D   E3D   D   ,  H
 H$   D+E3E  H$   HL$PfD   H$  H$    HH$h  H$   s H$   HL$8H\$0HD$(D$  DL$pED5 A*HH$0  HL$ L$  LH$   HPHHuH] H$   H$    Aę|$tu.Lt$ LLIH$   LHH$   MHAE;H$  # +D$|fn^5 L$  f(f(H$   "L$  f(f(H$   L$  f(f(H$   fW     HtH$H  HE3E3IH$H  L$`  L$h  L$p  L$  IT$ I+T$Hf(H$H  JD<  E"  fAn5w ^H$  H$  H+HHua H$  f(Y?IH$h  HL$`  I+HH   Ld$`J,    ffffff     H$  H+HJ#H;r H$  H$h  L$`  I+HH;r L$`  f(Y/AHHH$h  HL$`  I+HH;s
H$  nL$      tm^Hk H
, lHȋ HH2 lHH    HH lHH  H$      tH$    H$  HMpH$  :E H   HHMIBHp  H$H  B  H  H$h  ( L$  IH$  I;vb L$  H$  H$p  H\$`Ht$hI;v5 H$p  H\$PH|$X(D$PfD$PHu
 MLH0I;{ wHtHIH;xs H|$X     Ht
H$8  HIH$8  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$8  4H$  HH$   H;vd H$  H$   H$   H\$`Ht$hH;v7 H$   H\$PH|$X(D$PfD$PHu MLH(I;{ wHtHIH;xs H|$X     Ht
H$x  HIH$x  (D$`fD$`(L$PfL$PDL$@LD$`HT$PH$x  %bH$  H9$  vl H$x  H$   H$   H$8  HH$0  H;v6 H$8  H$0  H$  HL$PH|$XH;v	 H$  HL$`H\$h(D$PfD$P(L$`fL$`($   f$   D$@D$ LL$PLD$`H$   H$x  x/H  H$8  6H   H$x  H   H$(  |H$  Ht0H$  H;tHW H(H;uH$  H  L$  L$  L$  H$x    H$P  HtLH$X  H;t:HYHHt  L+LkLkHK  H0HCH;uH$P  k  L$P  L$X  L$`  H$8  F  H$`  Ht3  L$`  L$h  L$p  H$H    H$h  S
 H$  D
 H$h  5
 H$  &
 H H$  H$  
 H$  H$@   H$0  H$   H$  H$P   H$  Ht\  L$  L$  L$  H$  7  H$  H$   趍H$0  詍L$  L\$PH$  N H$  H$  H$   Ht2H$(  H;t H H(H;uH$   H  L$   L$(  L$0  H$    H$  Ht/H$  H;tH H(H;uH$  HH  L$  L$  L$   H$  #  H$  Ht/H$  H;tHS H(H;uH$  H  L$  L$  L$  H$    H$0  Ht/H$8  H;tH
 H(H;uH$0  H  L$0  L$8  L$@  H$  _  H$   Ht7H$  H;t"     H
 H(H;uH$   H  L$   L$  L$  H$     L$  I[HA(sA({IA_A^A]A\_^]HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxY}H      fWf/v f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;t+8HHtH;t
8t8H;^t)HN	 HtHiHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL
L$   H$   H脎2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(HAxYF      fWf/v f/v   fD/v	D   f/v   $   f/v   H   HL$   I\$HtHH;t[6HHtH;t=6t46H;^t)HN, HtHgHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI|L$   H$   H贌2L$   I[IsI{ A(s(|$pE(CIA\HVWATH   HD$ HXHh)p)xD)@D)HAIHHHPL@fEWIx ufE(H$   HL$(gfD(= E3@t;H\$0L9cufA(H$   HL$(wf(A^H[8Lg f(A^$   H\$0L9cufA(H$   HL$(?wD^DO0DD$(Ld$0Ld$8Ld$@Ld$HHT$(H,>HL$@H HL$0= L$   L\$(H\$0Hl$8HOH;uHO$   IHHT$0f(L$   I[(Ik0A(s(|$pE(CE(KIA\_^HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   Y*C      fWf/vC f/v   fD/v	D   f/v   $   f/v  H   HL$   I\$HtHH;t2HHtH;t2t2H;^t)HN HtH4dHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   YZA      fWf/vs f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;t1HHtH;t0t0H;^t)HN HtHdbHFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVI)L$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   Y?      fWf/v
 f/v   fD/v	D   f/v  $   f/v  H   HL$   I\$HtHH;t8/HHtH;t/t/H;^t)HN	 HtH`HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIYL$   H$   HQ2L$   I[IsI{ A(s(|$pE(CIA\HATH   HD$ HXHpHx)p)xD)@f(fD(f(H   Y= +     fWf/v f/v   fD/v	D  f/v  $   f/v  H   HL$   I\$HtHH;th-HHtH;tJ-tA-H;^t)HN9 HtH^HFE3E3LFE3H^HHH+HHHL;}HNI$fB(fB)ILLHVIL$   H$   H2L$   I[IsI{ A(s(|$pE(CIA\H\$Hl$H|$ ATH HH
HHt
HEH;   LeHI|$HtH;t),HtH;t,̄t
,Ht$03H;{t Ht
H]HH3HH{HH+HLMM~#    I$HHI;f(Df)D|LHIVHt$0HMHH	H\$8Hl$@H|$HH A\uHL$WH0HD$ H\$HHH   .H   Ht  H   + HOX HOH
 HO8 HO( HO HOH\$HH0_H% HWATAUAVAWH0  HǄ$  HXHhHp)pAAf(LH H(_ H$  HH$   HH$   W IUH$   E   L$  DH$   Ibf(Ho H$    L$  IH$   IH$       DBH$    H H$0  %UHf( H$   H$    MHIAH$   v H$    L$  H|$0H$  Ht$($  D$ $  f(H$   I#I}HH$   HtH;t(HtH;t(̄t(H;_t"H Ht
HMZHH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   M]I[     Ht
HL$PH3HD$PfW$  L$  HHL$Pu3E3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;v H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xsc L$   MuP E3MI;{ r< I.HAHIEIcH;p=H$  .̹     Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM LHAS   DBH$    H H$0  QHAU$+ HHa QH$   H$   ~ LHHAH$   " E3E9}$I  D  MEIUH$   +RE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;v H\$PH\$@H|$H(D$@f$   Hu} E3LH<I;{ wHtH3H;xsS L$   Mu@ E3MI;{ r, I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM AE;}$}M,H H$    HH$   HH$    H$    H$   Ht!  HǄ$       HǄ$       HǄ$       H$     HL$hHt  HD$h    HD$p    HD$x    HL$P  H$    H$    3L$0  I[0Ik8Is@A(sIA_A^A]A\_HHPVWATAUAVH@HD$0HXHh IHH@    H$   Hh+A   Dt$p       S H   H   }   ^   ,A;ALƉ   LGHWHH  t]LHH      ^,A;ALƉ   Y2      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   Hh@D$p       tuS H   H   |LGHWHH  t@LHH   Y1 
     H   H   HHHH$   H@A]A\_^]HHPVWATAUAVH@HD$0HXHh IHH@    H$   HhA   Dt$p       S H   H   {   ^   ,A;ALƉ   LGHWHH  :t]LHH      ^,A;ALƉ   Yo0      H   H   HHHL\$@I[@IkHIA^A]A\_^HHPUVWATAUH@HD$0HXIHH@    H$   Hh D$p       tuS H   H   wzLGHWHH   9t@LHH   Y/      H   H   HHHH$   H@A]A\_^]HHXHhHpWH   )pp  )xX  IIHL
 L
 D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ *h  Dd  D`  ,  H  Ht$(D$ +L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
 L D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
! L D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ h  Dd  D`  ,  H  Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HHXHhHpWH   )pp  )xX  IIHL
a L D)@DH  D)H@    DP  3  H$   f(fA(fA(HL$8Ht$0HH|$(Ht$ jh  Dd  D`  ,  H   Ht$(D$ L$   (t$p(|$`I[IkIs E(CE(KI_HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   H5
 I EL   H
 I H5 fWDY E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMHG HtHKHEHLmHH}PHHH+HLMIM~)(
D @ Hf(fWHEHf)HI;|LHUHH$   zH   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   SL$@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   L$0  H  HUxH$8  HL$(HD$ L$@  L$H  H$0  >.AY$0  $8  f/v
H$0  H$8  L    A$   L     A$   H  H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM t[Eu7A   H I HDHL$x HL$h G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;tHHtH;t̄tH;\$pt$HL$h HtH$HHD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   L$   L$   I^HtHH;tHHtH;t̄tH;$   t$HL$x HtH:GHD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   L$   I|$ uf(H$0  H$   WD  fD(HD$hH$   H|$p tH$0  H$   Wf(f(  f(EtIH   ALD$hHT$xH3f($0  H$0  HMXY   ux'H   E3LD$hHT$xHL   L]xMHUHHQmp\mhfT- (  f/vA      @  fA/vA   x   f/vA
   bH  H9   rA(   JHH(0  5 Yf/vA    H΃H  Yf/vA   HL$x HL$hw AL$   A(sA({E(CIA_A^A]A\_^][HWH`HD$ HXHhHpHHP"HgHHD$0HXHHtH;tHtH;t̄t3H;_tH Ht
HFDHH7H_HHH+HLMM~2(
 fffff     HE f(fWHf)HI;|LHHL$(RsHL$P> H\$pHl$xH$   H`_LUVWATAUAVAWH  HǄ$X  I[A)sA){LHHAE3HxH,  II(IKI0 ACHL4I      ?=S  LFHIIHHT$0LD$8Ht$HLD$PIH+HH$   H$   H$   HL$0HHHAHBHAHBHAHBHA HB L$   H$   HH$  HEH$  H$  H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$  L$  L$  H$  H$   LHFIIN|LFLIIIH$   L$   H$   IH$   IH+HH$   H$   L$   H$   HIHAIBHAIBHAIBHA IB H$   L$  H$   HIHAIBHAIBHAIBHA IB HA(IB(HA0IB0HA8IB8HA@IB@$  $P  HNH+IH+IHIHD$0Hl$8Hl$@Ht$HHT$PH$@  HL$0HHHAHBHAHBHAHBHA HB L$  H$  H$@  85IT$H+I$HHT$XHl$`Ld$pIL$HL$xHT$XHaH$0   LFIIHHHT$XLD$`Ht$pMLD$xIH+HH$   H$  L$  HL$XHIHAIBHAIBHAIBHA IB L$@  IL$H+I$HH\$0Hl$8Ld$HID$HD$PH$   L$   H$   L$   L+JH$`  H$h  H$x  H$   HHHAHBHAHBHAHBHA HB L$  H$  H$`  HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$0nf(YY$   H$   H$   L$   ID$H$   H$  H$   ?IT$HH+I$HHL$XHl$`Ld$pHT$xHVLHIIH$   H$   H$   H$   HH+HH$   H$  L$  H$   HIHAIAHAIAHAIAHA IA H$@  HNH+HHHI+IH$  HD$ LL$XL$   GiML^HJ$  BDI$B4IIHL;L$  I[HA(sA({IA_A^A]A\_^]HVWATAUAVHP  HǄ$   HXHh )p)xLHq3H  H~fW= I.MfLkIHIHD HD$ H|$(Lt$8Ld$@HT HT$pH$   L$   HǄ$      HDHD$HH|$PH\$XLt$`Ld$hID$H\ H~iYҹ   H;}IHYXHA   I}&3ɐH;}IHYXHIf(\Xf/   f(^  $  ID$HD H   H   H$   HL$pHHHAHBHAHBHAHBHA HB L$   H$   HL$H'1$  L$  HT$ HHH$   H~H$  HL$ IHL;3HHL$P  I[@IkHA(sA({IA^A]A\_^HVWATAUAVH0  HD$ HXHh )p)xLHq3H  H~fW=  IN LkI.HHIHD H$   H$   H$   H*IFHBIFHBIFHBHJ H$   H$   HD H$   H$   H$   H*IFHBIFHBIFHBHJ HǄ$     HDHD$0H|$8H\$@HT$HH*IFHBIFHBIFHBHJ HD$hHD$pLaLB\ H   L$   AYҹ   H$  H    J
 H;} YXHHA   I}(3ID  H;}YXHHIf(\Xf/   f(s  $h  BD H   H   H$   H$   HHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@L$   H$h  HL$0.$`  L$`  H$   HH$  x H~H$h  H$   IHL;wHHL$0  I[@IkHA(sA({IA^A]A\_^HWH  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HA A\ HD$8LT$@D$HHT$0HL$ ЉP  HQLL$0HT$8HI HHH$   H$   IBH$   H$   HHHQLQHCHAHC HA H$   H$   LH$   H$   7HT$0H:H$   LL\$PHCHD$XHL$hLHAHCHAHCHAHC HA H$   H$   HD$0HD$ H$  HD$(HT$PHL$ @7L$   HL$0HIHAICHAIC$  HHD$PHCHD$XHL$hHHHCHAHCHAHCHAHC HA H$   H$   HD$PHD$ H$  HD$(H$   HL$ 7L$   HIHFICHFICHFICHF IC HT$XHL$0HHHAHBHAHBD$xL$   H$   HL$Q6L$  L$  H$   HIH$x  S L$  I[Is I_HHPVWATAUAVH   HD$0HXHh IHL3퉬$   A(D$ L
A" M@H! H
g) LHSIHtgHI      Ic$   H$   I#I;w
IL;r/HU HD$(H) HD$ LHO H
( ƫIL$LHT$X#H:VLHD$@Ld$HIt$HuH9HH;v
H    H HHuHtHHwI\$HtI;tHtI;t̄tH;t Ht
H-3HH/H_HHH+HLMM~.fff     I$IE f(fXHf)HI;|LHHL$8MHL$h) HL$   I[@IkHIA^A]A\_^@SH HHP  HH [~HSH   HD$ )pHZHX8 @LB@HPHHHIHD$0H\$8H{ ufWH$   HL$(f(HL$hY f(($   HĐ   [HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD~ fAWA   DBHX H6h H$@  )+HM  HT$@H$0   L$  MHIAHL$@w L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH3$(  k2$  E3fWk L   ~<EtACu,Hg HL$@ IHT$@IHL$@ HdDFhfAWE f(HV@IIH9^@~@f     H~8IE I+EHH;re IMHHHH;^@|Ћ$(  EuH    u2H     utA  H HL$@ HT$@H$0   HL$@ H      H$    HHf H$@  ,)HHuI
H HcHHHWHH3 HHf (   H$    HHof H$@  (HHuI
H HcHHHW   H$   Z LHuI
HHcHHISAL$  AH^ HHe W(   H$    HHe H$@  -(HHuI
H HcHHHW   H$    LHuI
HHcHHISAH7lf(H HH\e 'HFHD$HHx uf(H$  HL$@>N  f(   H$   ' HHe H$@  `'HHuI
H HcHHHW   HL$p LHuI
HHcHHISAf(H  HHd &
   H$   HHd H$@  &HHuI
H HcHHHW   H$   _ LHuI
HHcHHISA   Hh HHd a&
   H$    HHc H$@  7&HHuI
H HcHHHW   H$    LHuI
HHcHHISA   H HHc %H     H$   _ HHec H$@  %HHuI
H HcHHHWHH HH!c `%H!c H$@  L%HH   < HHb -%HT$@H$0   MHIAHL$@ H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  <E$  Ex.H`b HL$@ IHT$@IHL$@ 2HZb HL$@ IHT$@IHL$@ AF   EH$0  HLH9b HL$@v MHIAHL$@ H$0  v H$0   AL$  A(sA({E(CIA_A^A]A\_^][HATAUAVH`HD$ HXHhHpHx )p)xILH3D9q(~5L5 fWHMf(f(AAID;m(|LHT$(HjHHXHHtH;tuHtH;t`̄tVH;_tHN Ht
H(HH7H_HHH+HLMM~!    HE f(Hf)HI;|LHHHL$( L\$`I[ Ik(Is0I{8(t$P(|$@IA^A]A\HL@HPHHSVWATAUAVAWHP  HǄ$  )p)xILA(D$ L
7n DB(Hn H
 %L[L\$ L
m EE(Hn H
 $Ic](H\$HfW|$XHu3H9HH;vH<    H HHuHtHL$hH\$pHt.II;t̄t̄tIH\$pHHH+HLM3M~( f)HI;}HL$hLHT$hHL$@(Ic](H\$HH\$P|$XHHHu3/H;v	L$    I HHuMtHL$xH$   H$   HtWHtIHHH;tHtIHHH;tHtIHHH;ttH$   H$   HHH+HLM3M~ (t @ f)HI;}HL$xLHT$xHL$@	Ic}(H|$H|$XHu3/H;vH4    H HHuHtH$   H$   Ht.HH;t̄t̄tHH$   HHH+HLMM~$( HIHHHff) HHuLH$   HL$@Ic}(H|$H|$XH$LH$   H$   Ht$H;t̄t̄tH$   HHH+HLM3M~"( ffA)HI;}
L$   LH$   HL$@rMcu(Lt$H|$XA   MIHL$0Mt$L;tḠt=̄t3L;t$8t,HL$0( MtI#LHD$0E3Ld$0Ld$0Lt$8IHH+HLMM~-( IIHHHfff     f) HHuMHT$0HL$@E3D$  D|$`5w     $  D;9  3A9u(~I3L$  ffffff     H$   Mf(f(x;HA;u(|D$  L$   HT$@IHHXHtHH;tHHtH;t̄tI;t(I HtH@"LHD$0E3Ld$0LH\$8HHH+HLM3M~Hf(fA)HI;|LHT$0HHL$@C    DBH$   [ H$  H$   H$0  H$   L$   L$  HT$0H$   H$   H$    Hx H$    t7H$   H$    H$  LHAH$    L$   Hf H
 >L\$hL$   H$  H$   L$   LL$pIHH+HLM3ҐI;}IIf(fXf)HH$   I(E3H$   D  E;](}QE3    E;=IcIcL$   LLHL$xH$   YBXBAAAD$  H$   Ⱦ L$  H$   Lt$8Ld$0D$  fW5, fn$  H$  HL$h褗HD$xH$   H$  H$   H$   HD$HH$   HD$Pt$XHT$@H$   M]L\$@H$   HL$@HHHAHBHD$xHD$@(D$@fD$@HD$@H$   H$  H$   H$   H$   HHHAHBHAHBHAHBH$   H$   \HT$hH$  HgvHT$xHJwI H$    H HL$x HL$h׾ ($@  ($0  HP  A_A^A]A\_^[HT$UVWH0HD$ H\$`HHD$P    HHpHu39HH;vTH<    HR HHuHt0HHsHE HxHHtH;tHtH;t̄tH;t߽ Ht
HjHH    H{HH_HH\$`H0_^]HT$UVWHPHD$ H\$pIHǄ$       IH@HT$(3HHHqHu39HH;v,H    H* HHuHtHHwHE HXHHtH;tHtH;t̄tH;t Ht
HBHH    H_HH7HL$8 HH\$pHP_^]HL@HPHHSVWATAUAVH  HD$`)p)xMLHfW|$8Hcz(Hu3H8HH;vH    H HuHt3HD$@H|$H$  \$0I      fD  ;^4  LD$@HVIv   DBH$    L$   HT$@Hf(D$PHT$hH$    Hx @HL$hG @t,HT$hH$   o MHIAHL$h t$XHD$XI#I;u+H HD$ L
 LD$PHb H
m X0X|$8É\$0H$    I      H$   L$  L$  |$8\$0fnF^If(XHL$@S f(($  ($  H  A^A]A\_^[HWATAUH  HǄ$   HXHhHp )p)xD)@D)HEIHH3H\$@H\$HH\$PHT$(LD$0fWI9Xuf(H$8  HL$ }f(D fE(D^H$8  Hl$(DL$0L$8  H$   HL$!LHNHL$(HL$0HT$`HD$ HH
HHHJHHHJH@HBI'H$   LHL@IMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHL$@HT$XHL$@lH$   u E   Ht$(H~ tH$8  HL$ )f(^D^HD$@H$8  HD$@HD$(DD$0L$8  HT$XHL$!tHHHLIHHLAMtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHHHHL$xr 0  fA(LHT$XHL$@HL$@H$8  L$8  H$   HHT$ HAHLHL@MtMtIHIL;tMt:MtIHIL;tMtIHIL;tIIHLOLOIHH+HLMM~Hf(Hf)HI;|HHHL$ X H$   I HL$h= H$8  Hl$(DL$0L$8  HT$XHL$!zL$8  L$8  HH菏HL$x HL$@ f(L$  I[ Ik0Is8A(sA({E(CE(KIA]A\_HLH VWATAUH(  L$x  IE3LIMo  HXHhH$p  LpLxL$  )p(5t IHǀ@   LD$pHMHL$xIH+H$       H$   L)H$x  f)$   f)$   f)$   IL$x  H$x  f)$   f)$   f)$   HMH$   HH$  f)$   f)$   HD$hH$  LD$`LD$XHD$PHD$H D$@H\$8L|$0A   H\$(Hl$ pE3MH~JL    IPHIIfD  H;}JHĐ   XDDIIL;|H$h  H;MHL+ILHD$pHH$x  IT H$  HD$hH$  LT$`LT$XHD$PHD$H D$@H\$8L|$0LD$(LHl$ oHl$xH$   H    HIHD$pI;A    ($  L$   L$`  H$X  H$P  H(  A]A\_^HWHp  HǄ$   HXHpIHHLQIuCHL$ H@HD$(HA A\ LT$8HD$@D$HHT$0HL$ d  HILL$0HL$@HHH$   IBH$   H$   H$   HHLQHCHAHCHAHC HA H$   H$   HL$PHHHBHAHBHAHBHAHB HA L$   H$   HL$P[HT$0H@H$`   LL\$PHCHD$`HL$hLHCHAHCHAHCHAHC HA HǄ$      HD$0HD$ H$  HD$(H$   HL$PHHHAHBHAHBHAHBHA HB HA(HB(HA0HB0HA8HB8HA@HB@H$   HL$ 
/HH$   HCH$   H$  HHHCHAHCHAHCHAHC HA HǄ$0     H$   HD$ H$  HD$(HT$XHL$0HHHAHBHAHBl$xHT$PHL$ iL\$XHIHFICHFICHFICHF IC $   LD$0H$   HL$QL$  L$  H$   Hj=H$H  ԯ L$p  I[Is I_LMK ECISIKSVWATAUAVAWHP  HǄ$p  A)sA){MELHE+H HD$ L
	 MCH^[ H
 jH2[ H$    IH$   IH$    -\ $    $   5ʷ $   =A $   G $   
Z $   MIH0$   HHPH$   HHPH$@  n$   <Z $   $   fWL$HD$@E3D|$DH
l |$@   Icĸ   $      t$P A;  AAHHL$X H H$   GLt$8HD$XHD$0H$  HD$(D$ E3ҋhH$   HL$X} AE(D$ L
-S D$  HS H
 
HGHHHL$ L
R EE(HR H
 w	Lt$0HGHD$(GD$ LOLH$   I;2H$  L$  D$  L$  D|$D$   t$Pu?HT$XH$   HH$@  iHL$h HL$X    H$x  H$   L$   H$  DHH$@  H$  lL$   H$  LHHL$X賽HH$@  gHL$h HL$X H$   ԫ H$  ƫ fn  f(^H$  H$@  L$   H$  HH$   H$  Lf(H$x  OLHHL$X_HI3hHL$h/ HL$X$ H$    H$   Ɖt$PH
B MIHL' ;L H$  L$  D$  L$  D$PD|$D$   $   f/   f/$         DBH$   H9V H$   HHV HL$H HH A}HU H$   HU H$   oHT$XH$  , MHIAHL$XӨ MIASD$@ H$      A}$   |$H   f/$         DBH$   H9U H$   HHU HL$H HHT HT$XH$  \ MHIAHL$X MIAS|$HD$@ H$  ( H$@  bAD|$DHWHL$X
^HIcHL$h HL$X H
 bLD$ L
S HS H
 &H$P  X H$@  J H$   ; H$   - D$H($@  ($0  HP  A_A^A]A\_^[HX PHPUVWATAUAVAWH  HǄ$  HX)p)xD)@D)HD)xD)hD)XD)HD)8D)(fD(f(HLfEWfA/w/H HD$ L
 L$   HfV H
 fA/w/H HD$ L
 L$(  HV H
 ̋$0  /H HD$ L
 L$0  HU H
 HHPH$   IE HPH$P  fE(D%R @ $   fn= YfAnE ^$   f/v
H$   H$   , HcHǄ$       HH;vhH H$p   H$  . H H$  H$p  H$   H@ H$  H$  +Hu3HH$   aHD$pHHL$xH$   H$   H,T H$   N L$8  I$H$   IH$   E HS H$    I$H$   IH$     $   AA   D=Χ D5e D  G(D$ L
J D$H  HkJ H
T M]ICHD$ L
+J DG(HXJ H
)  Ld$0IEHD$(AED$ MMME H$   HAu?HT$@H$   HH$P  %aHL$P! HL$@    H$  H$   DLf(H$   HH$P  H$  L
O H$  谶LHHL$@PHH$P  ^HL$P HL$@ H$   q H$   c fAnf(艉  ^H$  H$P  pL
 H$   訵HH$   H$  @Lf(H$  LHHL$@HH_HL$P̢ HL$@ H$    H$    AƙA} +	  fA(MHIfD($   fA/vfD(\^fATLD$xILL$pI+HH$   H;uUHtFH$   0H$   HLL$pLD$xI;IDH$   HH$   H$   [H$   VH$   Ht1H$   H$   LD$xLL$pHI;IDH$   HH$   H$   Hu3fE(Ht$ff     DX HI;IDH;tHufH*HyX  D^HT$pI;fD(Ⱥ   DBH$0  J    H$`  . HHlO H$@  gHHu3
H HcHHHW	   H$    HAH HHO HHJ HHu3
H HcHHHW   H$P   LHu3
HHcHHISA   H$   [ HfA(H HHN HHu3
H HcHHHW   H$0   HHH HHu3
H HcHHHW   H$  ʜ HfA(H HHM HHu3
H HcHHHW   H$@   HHaH HHu3
H HcHHHWfA(H  +fn^5fM $      Å  Ht
HL$@H3HD$@3H\$X3HL$`3HT$hHu HT$hHL$`H\$X$   Hu3H+HHH+HH;s9HHL$`H\$X
  HH;vQ HL$`H\$XHt$@H$  H$  HH+Hu3$H;v HtH;t$@t H+H($  f$  L$   A   H$  HL$@H\$XHHL$`H;v HL$`H\$XHt$@Hu E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps_ HL$`H\$XHu3HT$hH+HHH+HH;s1HHL$`H\$X
  HH;v HL$`H\$XHt$@H$   H$   HH+Hu3$H;vМ HtH;t$@t H+H($   f$  L$   A   H$  HL$@親H\$XHHL$`H;vn HL$`H\$XHt$@HuT E3HL$`H\$XHD$@LHT I;S wHtH3H;Ps HL$`H\$XHu3HT$hH+HHH+HH;sDHAHD$`   HH;v˛ HL$`H\$XHt$@H$   H$  HH+Hu3$H;v HtH;t$@t} H+H($   f$  L$   A   H$  HL$@eHt$XH;t$`v3 H\$@Hu# E3LHI;K wHtH3H;Hs H$@  HHT$@PfE/vH0I H$@  KE2fE/vHH H$@  -E2AE D;~"fE/wfE/vHH H$@  H$   H$0   M$HIAH$   W E   fA(A\A^fATf/*H vmHG H$    I$H$   IH$    H3G H$   Ř I$H$   IH$   Ę HL$XHt`  HD$X    HD$`    HD$h    HL$@;  H$0  ȗ H$  $   D;$0  uoH0F H$   2 I$H$   IH$   1 HE H$    I$H$   IH$    E2AE$   =I HT$xHL$   I+HLD$pH$   H;|
I+HH+IH$   Mt	I;  H$`  x H$P  j H$0  [ H$   M L$  I[@A(sA({E(CE(KE(SE([E(cE(kE(pE(`IA_A^A]A\_^]HSUVWATAUAVAWH   HD$`)p)xD)@HE3Ll$hLl$pLl$xLXH   H   uE}L   Hշ ID EL   H I( H5> fWDJ E   HuH$   H~HtH;  HHtH;  q  H;}Pt!HMH HtHrHEHLmHH}PHHH+HLMIM~)(
 @ Hf(fWHEHf)HI;|LHUHH$   ~%H   ,  A"  $8  HEH$   H]XH$   H{ uf(H$0  H$   $@  Eh\Ep$H  HEH$   H$   H{ uf(H$0  H$   $0  H   HUxH$8  HL$(HD$ L$@  L$H  H$0  AY$0  $8  f/v
H$0  H$8  L    A$   L      A$   H   H   L   L]HUhH]8H}HHuLMpLE(HD$XHL$PLT$HL\$@HT$8H\$0H|$(Ht$ IHM Rt[Eu7A   H4H I HDysHL$xo HL$hc G  HMpHUhH;tHHH}(Hu8H;tHHHHHWLFL;tIHI H
LuLeM;tI$II$IIVMD$L;tIHI H
HUXLEHL;tIHI H
HIL;tIHI H
H$   H$   H_HtHH;tmHHtH;tN̄tDH;\$pt$HL$h9 HtHHD$hLl$hH\$pHHH+HLMIM~-ff     HHf(f\HD$hf)HI;|LHT$hH$   舨L$   L$   I^HtHH;tHHtH;tḡt]H;$   t$HL$xO HtHHD$xLl$xH$   HHH+HLMIM~$II$f(f\HD$xf)HI;|LHT$xH$   褧L$   I|$ uf(H$0  H$   iw  fD(HD$hH$   H|$p tH$0  H$   5f(f(w  f(EtIH   ALD$hHT$xH#f($0  H$0  HMXhY   ux'H   E3LD$hHT$xHL   L]xMHUHH蠫mp\mhfT-   f/vA         fA/vA   x   f/vA
   bH   H9   rA(   JHX  5@ Yf/vA    H.(  Yf/vA   HL$x# HL$h AL$   A(sA({E(CIA_A^A]A\_^][LD$SUVWATAUAVAWH   HǄ$   )$   IHHHHXE3I;XtI Ht
H%HL7H_LnL$   HM H  HH;  Hl$HHUH$(  HEH$8  H$(  L$8  H;IMHHD$(  D$8HT$ HL$H{L]L\$PHEHD$XfWt$`HT$HHMeM  L$0  fffff     LHN MSL+M+Ԁ~    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$    HFLJT!MCIIHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@OMHT$HHL$ LEIIHE HHT$ LD$(Hl$8LD$@HHxI+HIH+HHD$pH|$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H|$Pt$`H$0  L|$pAtH/IHHكH$(  H$0  H$(  H;HMHHH+HH+HL,CLE3HT$pHL$HtI;}=D$`fIIH+HHHff     f)HHuLMHT$pHL$HIsE3L$        HHXHI+L;  LEIIHE HHT$ LD$(Hl$8LD$@I+HIH+HHD$pH\$xH$   HL$ HHHAHBHAHBHAHBHA HB L$   H\$Pt$`H$0  Ll$pAtH/IHHكH$(  H$0  H$(  H;HMH8HH+HH+HL$GLE3HT$pHL$HI;}>D$`fIL IH+HHHff     f)HHuLMHT$pHL$H蝵IL$   HL@HMt:MtHHIL;tkMtHHIL;tNIIMH;LELD$(LMLL$0MtWMtHHIL;tMtHHIL;tMtHHIL;tηIIHHT$ HmI]H>  @ LHN MSL+L+D8v   HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$    HFLHTMCIHHIHHL$HIH+HD$PL\$`LD$hHMI+HHMI+HE HHL$ LT$(LT$0Hl$8HEHD$@MLHT$HHL$ H($   H   A_A^A]A\_^][HWATAUAVAWH@  HǄ$   HXHhHp)pAAf(LH: H߆ H$  HH$   HH$   ׆ IUH$   =   L$  DH$   If(H9 H$   i L$  IH$   IH$   a    DBH$0  r H9 H$@  Hf( H$   H$0  R MHIAH$    H$0  / L$  H|$0H$  Ht$($  D$ $  f(H$   II}HH$   HtH;tiHtH;tT̄tJH;_t"HB Ht
HHH    H_HHH+HLM3M~#D  H$   f(Hf)HI;|LHH$   菉M]I[   l  Ht
HL$PH3HD$PfW$  L$  HHL$PE3IEL9`   33fffffff     L0HL$pHH|$hH+HH;   H;v5 H\$PH\$@H|$H(D$@f$   Hu
 E3LH<I;{ wHtH3H;xs L$   MuЄ E3MI;{ r I.HAHIEIcH;p=H$  ̹   ck  Ht
H$   H3H$   HǄ$       HǄ$       HǄ$       L|$0Ht$(H$   HD$ LL$Pf(IUIM &LHAS   DBH$0  - H-6 H$@  `HAU$ HH5 DH$   H$0   LHHAH$    E3E9}$I  D  MEIUH$   KE3IEL9`   33fD  L0HL$pHH|$hH+HH;   H;v% H\$PH\$@H|$H(D$@f$   Hu E3LH<I;{ wHtH3H;xsӂ L$   Mu E3MI;{ r I.HAHIEIcH;p=H$  H$  HD$0Ht$(H$   HD$ LL$Pf(IUIM `AE;}$}ͷH=4 H$    HH$   HH$    H$0  P H$   Hth  HǄ$       HǄ$       HǄ$       H$   ph  HL$hHt`h  HD$h    HD$p    HD$x    HL$P;h  H$   x H$   j 3L$@  I[0Ik8Is@A(sIA_A^A]A\_HLH L@HHSUVWATAUAVAWH  HD$h)p)xD)@IIHHBhD~ fAWA   DBHX~ H^ H$@  )HM  HT$@H$0  ~ L$  MHIAHL$@w L$   $    t2H$  HD$0Lt$(H$  HD$ MU HH3$(  k2$  E3fWk L   ~<EtACu,H HL$@~ IHT$@IHL$@~ HDFhfAWE f(HV@IIH9^@~@f     H~8IE I+EHH;re IMHHHH;^@|Ћ$(  EuH    u2H     utA  H	 HL$@} HT$@H$0  | HL$@} H      H$   { HH H$@  ,HHuI
H HcHHHWHH3| HH    H$   { HH H$@  HHuI
H HcHHHW   H$   Z| LHuI
HHcHHISAL$  AH^| HH W   H$   z HH H$@  -HHuI
H HcHHHW   H$   { LHuI
HHcHHISAH7f(H{ HH| HFHD$HHx uf(H$  HL$@Nc  f(   H$   'z HH5 H$@  `HHuI
H HcHHHW   HL$pz LHuI
HHcHHISAf(H { HH 
   H$  y HH H$@  HHuI
H HcHHHW   H$   _z LHuI
HHcHHISA   Hhz HH2 a
   H$   x HH H$@  7HHuI
H HcHHHW   H$   y LHuI
HHcHHISA   Hy HH H     H$   _x HH H$@  HHuI
H HcHHHWHHx HHA `HA H$@  LHH   <y HH -HT$@H$0  x MHIAHL$@y H$  $(  $    t<H$  HD$0Lt$(H$  HD$ MU H$  H$  <E$  Ex.H HL$@x IHT$@IHL$@x 2Hz HL$@x IHT$@IHL$@x AF   EH$0  H贺LHY HL$@vx MHIAHL$@x H$0  vx H$0  w AL$  A(sA({E(CIA_A^A]A\_^][@USVWATAUAVAWH(  Hl$pHǅ   )   A0uxHA HE8HHE(HB HELzL}hLaHHE0L}XLeHL  ML Mu    H A   L H HHHH   H   H  I;HMH	HM H~H3IHHM 3I;}LII~IHL,IIH    H  HIHIHHH;vߥL4    HI   w9H   HHH;wHHHf  H+H\$pHHH  -Iw HH  HuMthHI     H   H      HH;v%H4    H   w2H   HHH;wHHH#f  H+Lt$pIIHv LHuHtƤH      H  MLU3M  3H}HE HLMIHU`HIHHUpLE0LEPfffff     HHU@HEXL]@L;IMH0H+3HD$8HD$0Ld$(Ht$ IH  3LHU MM  ff     3K</H  HEHH  L;HMHI+HEIHM0LHT$8HT$0H\$(Ht$ LMH  H  1HE HMHM;HMHM(JLt$h3HL$`HL$XHD$PHD$Ht$@H HD$8Ht$0H\$(HEHD$ L  LE8H  1MLHEJHU8H   LL}(Lt$@HMxHL$8Ht$0H\$(HD$ H  LLIH  3LH} I;H}HM@LEPLEpLEPH}`H}L}hI;HE LULM.    t
It    t	Hqt (   H   A_A^A]A\_^[]@WH@HD$ H\$PHl$XHt$`HHHHXHu36HH;vH<    Hs HuHtסHD$(H\$0LD$(HHHL$(H\$PHl$XHt$`H@_H%s @VAVH(  HqLH }H(  A^^H$   H$  H$  HHǄ$H     L$  HL$   H$H  )$   HǄ$P     HHHHH$@  HHH$@  H$P  HMH9   HN3L(L$@  H  5 MHIMFH$@  H$H  I;H$H  HHMILt$8HI@LD$@HHH+HD$ I@H+HT$(HT$0HT$XHHHl$PLt$`HLD$hHl$xHD$HHH$   L$   L$   IHHHHL$ HD$pϖH   H   HL$ H$   HHHAHBHAHBHAHBHA H$   HB HT$HHL$pH$   $H  HL$H  HHAHBHAHBHAHBHA H$   HB HT$H"IIH;HL$   L$  H$  ($   H$  H$   H(  A^^HH\$Ht$WH LBHHHMtHHIL;t衞IMILGLOMt\MtHHIL;thMt:Mt5HHIL;tFMtHHIL;t)IHILK3LKIHH+HHLMM~ D  HHHI;f(Df)D|HHsHC.HH@ƉsH\$0Ht$8H _HL$WH0HD$ H\$HHHLJLB3HHAHAMtDHMtHHIL;tBMtHHIL;t%IIHC HH%HH\$HH0_@SH HHD$8    H4HH [HWATAUH   HD$(HXHhHp EIHHHYHu36HH;vnL$    Iln HuMtMHD$0H\$8HT$0H%Ht$@HNH$   HVHT$ H$   LD$ H;IML IMtM;tH$   HT$ H$   LD$ H;IMHHtI;t譛̄t裛H;]t%HM m HtH%HE HE     H]HT$@HHt$@LFIHH$   HVHT$ H$   LL$ H;IMHHtI;tIHH$   HT$ H$   LD$ H;IMHHtI;t̄t֚H;_t"Hl Ht
HYHH    H_HT$@HmE   HFHt$PHL$0HL$XD$` HHD$hHD$p   LFMtMtIHIL;tEMt:MtIHIL;t#MtIHIL;tIIMHHHL$PHL$0k L$   I[(Ik0Is8IA]A\_HVWATH   HD$ HXHh)pIHHZ IHu3,I;vfH<    Hdk HuHtEHD$(H\$03H~;fWfffffff     HH$   6XHD$(HH;|$0|HM@HT$PH$   H$   HD$@HD$(HD$HH|$0Ht$HH;t觘̄t蝘H;} tIHMj Ht2I;v}H4    H{j HuHt\HEHE    H} HUHL$8kHL$P7j HL$(+j L$   I[ Ik0(t$pIA\_^HUVWATAUAVAWH   HD$0HX )p)xD)@HLA   AAHjHHtH;t蚗̄t萗3H;i t!HIi HtHIEIuIm H  HIMH HE   HLLI1MELD$@MMLL$Hr D$PMtWMtHHIL;tMtHHIL;tӖMtHHIL;t趖IIIMMMMIHH+HLMHM~&(
c fffff     IE f)HI;|IHL$8AAu8AE<E}=I  LKLCMtMtHHIL;tMt:MtHHIL;tMtHHIL;tԕIIILKLCMt:MtHHIL;t蛕MtHHIL;t~IIInHI3Ll$@H$  HL$8,<$   fWf.zup $   Ll$@D$HHT$8INH}H$  HIM(6EME(IUI"E3IMH!  =i Dl H;  HH+H<  H   HH+HHHHf     ME(IEBTfTfTLfTDfTXfTAYf/rNLME(IEBTfTfTLfTfTXfTAYf/rNLME(IEBfTfTfTDfTXfTAYf/rNME(IEBTfTfTLfTDfTXfTAYf/rNLH HH;}GIM(IEfTfTLfTfTXfTAYf/rLHH;|H|]IE(HLAf.zyuwf.z8u6Af.z%u#Af.zuHH HH;H5H0H  IE(HLf.zuHHH   H   IHHkL;   H_H|]IE(HLAf.ztmf.zt*Af.zt"Af.ztHH H~H2H,H&H~!IE(HLf.ztHHHEtIE IHl$(HD$ LLIU(IMyE3HHkL;EM8AE8   A9u8   IH$  H       IEH
Iɸ   H;    f/vf(HHH;|H   LIEJHH;tHHEt^IUIM HIHHD$8HT$@Ll$PHT$XHHHHD$`HT$hLl$xH$   E3HT$8HL$`*vE3HHH;(H$   IMAE<E}=IL$   I[XA(sA({E(CIA_A^A]A\_^]HL$VWATAUAVH0HD$ H\$hHl$pELHLJLB3H1HqHqMtDHMtHHIL;tMtHHIL;tƏIIHI|$IHuH,I;v蒏H,    Ha HuHtqHCH{ I|$H~H   Ht/I;vDH,    HBa HHuHt Hs(H{0C< EIHHH\$hHl$pH0A^A]A\_^HL@HPHHSVWATAUAVAWH`  HǄ$  )p)xD)@D)HMHL   nG  HtHL$8H33HHD$8H\$PH\$XH\$`   :G  Ht
HL$xHHHD$xH$   H$   H$   H\$(HD$xHD$ LL$8MHIY'fD($   H~ H+~HH$   H$   H$   HtNHt"HHHHH;t謍HHtHHHH;t腍LLMt3x_ IH$   H$   H$   HH$   H$   H+HHtCH;r%_ H$   HH$   HHH$   H$   H+HH;rH~ H+~HHuH6HH;vČL$    I^ HuMt裌HD$hH|$pHHD$XHL$PH+HHt6H;rt^ HL$PHHD$hHHHD$XHL$PH+HH;rHT$hH$   bH~ H+~H   E  Ht
H$   HHH$   fWD$0LD$0HH$   U5p D D$   = fD/  Y5=p t$0fD/   H$   HtFD  H$   H$   H$   H$   !D  HL$ha] H$   R] H$   HtC  H$   H$   H$   HL$xC  HL$PHtC  H\$PH\$XH\$`HL$8C  fA(  HHF H+FHHtlH;r\ LfLl$hH$   H$   H+HH;r\ H$   f(AYL A\HHF H+FHH;rH\$ LL$8MH$   If(|3L$  H$  L$  D$   t$0D$   $   :HHF H+FHHtgfD  H$   L$   I+HH;r[ L$   HF H+FHH;r[ HNIHHHF H+FHH;rH$   Ht)B  H$   H$   H$   H$   B  HL$hD[ H$   5[ H$   HtA  H$   H$   H$   HL$xA  HL$PHtA  H\$PH\$XH\$`HL$8A  f(L$`  A(sA({E(CE(KIA_A^A]A\_^[HL@UVWATAUAVAWHP
  HǄ$  HX )p)xD)@D)HD)xMMLH   DǸ   $
  H$ 	  eX H4z H$  Y Hwu H$p  HV H$x  H$  H$  X H$  X Hy H$0  X H$P  HVV H$X  H$0  H$`  X H$0  X D]    AA+iA+L$
  AM utAE A}  uA}   AA+iD+E]uEtAAEA} uA}]H HIHIMUfW$
  I\$   ?  3Ht
H$   HHH$   L$
  HH$   I\$H$8  $H  HuH;HH;vMH4    HKX HHuHt)3HL$`H\$hHHt$H;t̄t̄tH\$hHHH+HLMHM~ (Q @ f)HI;}HL$`LHT$`H$0  膂$
  I\$0I+\$(H   V>  Ht
H$   HHH$   L$
  HH$   1   >  Ht
H$`  HHH$`  H$x  H$  H$     =  Ht
H$  HHH$  H$  H$  H$  HUH$  U H$  T H$  H$
  HUpH$  OrH$  H$
  HU0H$  qL$  L$
  H H$  H$  H$  pH$  H$X  qH$  V%H$  <  H$  :%H$  <  HP H$  ^T tHW H$  uR    H= H$  +T tH, H$  BR mDǺ   H$  S    H$  S HT$pH$  S HH$  S HL$p*T H$  cS H2u H$0  S HVp H$  H$	  H$   H$0  H$(  S H$0  S       H$
  H$  RtG$
  f.zuL$  IHL$`iH$  HD$ MMHT$`JH$  HL$pGS t$8\$0H$  HL$(H$  HL$ MMHT$`H8u[HT$pH$ 	  1R HH$  T HW H$  HH$  R H_ H$  n:  3H9\$h~VHD$`H$
  H$   H$   H+HH;raS H$   H$
  HHHHcH;D$h|H$(  <R HX H$  H$X  H$
  H$  H$  H$X  H$  H H$  H$  ($  f$0  ($  f$  L$0  L$  H$  H$X  H$  A9  3H$  H$  H$X  "9  H$  H$
  H$  !H$  8  H$  ;Q N9  Ht
H$   HHH$   H$   H$   H$   Ht$8D$0D$(H$   HD$ L$   L$   IIf     H+P H
lN &P HH< HHP P    (  Hq H$  BP Hl H$  HN H$  H$  H$  5P H$  P L$  L\$(t$ f(L$   H$   I/HT$pH$ 	  O HH
M 9O HH7O 9O HL$pO AAFINH$   蔀H$  O H=5V H$  H$   Ht7  H$   H$   H$   H$   6  H$  /O H$  Ht6  H$  H$  H$  H$  6  H$x  Ht6  H$x  H$  H$  H$`  k6  H$  HtX6  H$  H$   H$(  H$   36  HL$`sO H$   Ht6  H$   H$   H$   H$   5  H$`  4N H$P  H$  N H$p  H$ 	  NM 3/3  H$  oK H$  ^K    X    tAD    DEH   r	H   H   A@   H$  K       t1H  r	H   H   A@   DH$  J H H$  M Hi H$  H$  H$  H$  H$  M H$  L D   A	  (  ,  $  At*AtAtAt3   3      DH  D8  D@  D  $
  0  $
  4  $
      t@Hh H$  详HH 蠦HHK K H$     t@H H$   fHH WHHUK WK H$   TL $   I\$H$8  $H  H/LH$  H$  Ht.HH;t^z̄tTz̄tJzH$  HHH+HLMM~*(TF I@HHff     fA)IHuLH$  H$0  vL$0  HH H$8  L$  L$  HT$`H$0  oeIK +$   fDnE=  D^HJ H
MH J H H
9H HI H
&H I HI H
H I H H
G 詤HH 蚤HI H
G I HI H
G I H H
G _HfA(II HH BHH@I BI fnYAYH H
cG Hf(H HH HHH H H H
$G ϣHH H
G H HH H
F H H H$  I Hre H$  HF H$  H$  H$  H H$  H H>j H$0  H H$  H$  H$   H$0  H$(  H H$0  H Hp H$  VH LH$   H$  ng$  g            	0  Ht
HL$pH3HD$p3H$   H$   H$   H H$  G H$  HL$p1H$  G AEHT$pInBH H$  G L$  H$  HL$p.H$  G HL$pz$
  D$8$
  D$0$  D$(t$ MLD$`IHL$p芓L$  L\$@H$  HD$8H$  HD$0|$(DL$ $
  DEfA(HL$p蛿$
  $  ^            .  Ht
HL$pH3HD$p3H$   H$   H$   H H$  YF H$  HL$p趶H$  WF AEHT$pI@H H$0  F L$0  H$  HL$p賅H$0  F HL$pIy$
  D$8$
  D$0$  D$(t$ MLD$`IHL$pL$  L\$@H$  HD$8H$  HD$0|$(DL$ DEfA(HL$pII   HhH$  YE H=	L H$  H$(  ;E H$  H$  $E H$  H$  F H$  D H$  H$  wB H$  hB H$   Htq,  3H$   H$   H$   H$   J,  H$  D H$  Ht(,  H$  H$  H$  H$  ,  H$x  Ht+  H$x  H$  H$  H$`  +  H$  Ht+  H$  H$   H$(  H$   +  HL$`D H$   Htt+  H$   H$   H$   H$   O+  H$`  C H$P  H$  }C H$p  H$ 	  B 3(  A
  (  \
  H H
@ 裝HHB B H H
@ 耝HH$  oB HHmB oB     t3H H
@ CHH   3B HH1B 3B ,  H} H
^@ 	H=A HHA A 0  H^ H
'@ ҜHf(A HHA A 8  H6 H
? 蚜Hf(A HHA A @  H H
? bHf(MA HHSA UA H  H H
? *Hf(A HHA A P  H H
G? Hf(@ HH@ @ X  H H
? 躛Hf(@ HH@ @ `  Hp H
> 脛Hȋ? HHw@ y@ ] HO H
> SHȋ? HHF@ H@     >  H H$  HH HH@ @ H$  KH H$  ךHH ȚHHzv 蹚HH ? HH? ? Hn H$  腚HH vHH(v gHH
 W? HHU? W? H H$  3HH $HHu HH ? HH? ? Hz H$  HHC ҙHHL ÙHH$  > HH> > ,  Hh H$  臙HH xHH iH= HH[> ]> 0  H H$  1HH "HH Hf(= HH> > 8  H H$  ژHHh ˘HH 輘Hf(= HH= = @  H` H$  胘HH tHH6 eHf(P= HHV= X= H  H H$  ,HH HH Hf(< HH< = P  H H$  ՗HH ƗHH 跗Hf(< HH< < X  Hs H$  ~HHD oHHI `Hf(K< HHQ< S< `  H& H$  )HH HH HȋX; HH;  < ] H H$  ٖHH ʖHH 軖Hȋ: HH; ; H$  H$  Hv H$0  ; H$0  H$  :H$0  ; AEH$  It6HI HL$p; LD$pH$  H$  7{HL$p; H$  n$
  ,  $  H 9 H$0  H$  [LL$   IH$0  WH$   H$  lHc`  H$  d0  $  8  $  P  $  @  $   X  $(  H  $   H&oHcH$  H[ HL$pY: HV H$  H$  H$  HT$pH$  N: HL$p:: L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  Ih$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(II\H$  7 3Ht$8D$0D$(H$`  HD$ L$   L$   IININ8H$`  -jAvhH$  9 H=? H$  H$0  H$  <    HJ H
6 >HH<8 >8 HO H
p6 HH$  
8 HH8 
8     t3H H
36 ޒHH   7 HH7 7 ,  H H
5 褒H6 HH7 7 0  H H
5 mHf(X7 HH^7 `7 8  H H
5 5Hf( 7 HH&7 (7 @  H H
R5 Hf(6 HH6 6 H  HY H
5 őHf(6 HH6 6 P  H1 H
4 荑Hf(x6 HH~6 6 X  H	 H
4 UHf(@6 HHF6 H6 ] H H
w4 "HȋO5 HH6 6       H H$  HH אHH5 5 H$  L H H$  _LH H H$  DL H H$  )L$  H H$  }D,  D$
  L$
  Hf H$  象0  $
  L$
  HI H$  8  $
  L$
  H, H$  @  $
  L$
  H H$  JH  $
  L$
  H H$  }P  $
  L$
  HͿ H$  谢X  $
  L$
  H H$  D] D$
  L$
  H H$  H$  >H$  AHq HL$p.4 HT$pH$  苤HL$p/4 AEH$  I.Hݠ H$0  3 L$0  H$  H$  sH$0  3 H$  g$
  ,  $  Hk1 H$  H$  PLL$   IH$  PH$   H$  e0  $  8  $  P  $  @  $   X  $  H  $  HgHcH$  H]T HL$p2 H(O H$  H$  H$  HT$pH$  2 HL$p2 L$
  L\$P|$H@t$@H$p  HD$8H$  HD$0H$   HD$(H$   HD$ L$
  MH$  I$
      tLH$  HD$0H$p  HD$(H$   HD$ L$   f(IITH$  ~/ 3Ht$8D$0D$(H$`  HD$ L$   L$   IIFIN8H$`  bAvhH$  x1 H=(8 H$  H$  [{H$  >KS  C  HY H
. 蝋HH0 0       H H$  lHH: ]HH[0 ]0 H$  L H: H$  Lΐ H7 H$  ʏL H4 H$  诏L$  H, H$  D] D$
  L$
  H H$  ۞H$  H$  H HL$p/ HT$pH$  KHL$p/ AEH$  I*HU H$0  / L$0  H$  H$  EoH$0  / H$  bH$  [Ht$ L$  L$   H$   If(f(\5%9 H H
, 袉Hf(. HH. . f(\f(D
2 fAT^D fA/  A   /3 fD(E3L$   H$   If($      H H
X, IH$0  , HH
8, gHȋ0- HHB ɈHH$  h, HHN H
+ 袈HH7gHf(- f(A\H: H
+ nHf(Y- HH RHS- H
+ N- H
+ , 
   ǀ       f(H$  - HȲ,1Ht$8D$0D$(H$`  HD$ L$   L$   IIBHO HL$p(- LD$pH$  H$`  mHL$p!- f(A\f(fAT^fA/#L$
  Ht$8D$0D$(H$`  HD$ L$   L$   IIBIN8H$`  ]A~h    tdf(H$  + HȲ,%Hʟ HL$pS, LD$pH$  H$`  mHL$pL, H$  ) H$  Ht  H$  H$  H$  H$    H=2 H=2 H$  + H$  H$  a) H$  R) H$   Ht[  H$   H$   H$   H$   6  H$  {+ H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$     HL$`+ H$   Ht`  H$   H$   H$   H$   ;  H$`  * H$P  H$  i* H$p  H$ 	  ) 3{  HH$   H$   H+HHt?H;r+ H$   HHD$`HHH$   H$   H+HH;r   t,H   ' Hл   DK>DH$  B'        t@H[ H$  HH̵ HH( ( H$  j   t@H H$   轃HH 讃HH( ( H$  !x  tuD(  I|$ u_tZHm HL$p( H$  * H- H$  HT$pH$  ( HP H$  _  f(f(HT$`H$H  g  H2 H$
  ,   t-H' H
& 軂HH' ' 3ۉ,  3Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$
  MIHH.1 H$
  HWp H$H  H$P  ( H$  ' H=B. H$  H$  % H$  $ H$   Ht  H$   H$   H$   H$     H$  ' H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`  Z  H$  HtG  H$  H$   H$(  H$   "  HL$`b' H$   Ht  H$   H$   H$   H$   
  H$`  #& H$P  H$  & H$p  H$ 	  =% 3  t(ttǄ$
  '  333ۉ$
  	$
  3ۍ$
  A@   tdy]
  HcHXH
 $H
 HMIH$  赣HH$  TLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$    MIH$  HH$  lLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH[H$  ͠B  MIH$  e2HH$  dLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  腠  MIH$  =2HH$  |Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH+H$  M  MIH$  yHH$  tLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  z  MIH$  
zHH$  茔Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ݟ  MIH$  UHH$  脔p  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  MLl$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ~  MIH$  ƫHH$  Ep  H$P  HD$8H$p  HD$0HD$`HD$(D$ X  H  P  H$  .Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$    MIH$  .HH$  L$P  L\$ L$p  LD$`HH$  /Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIH[ H$  蝫B  MIH$  .HH$  ԓL$P  L\$ L$p  LD$`HH$  j/Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  ;  MIH$  svHH$  袓L$P  L\$ L$p  LD$`HH$  /Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  )   MIH$  avHH$  萓L$P  L\$ L$p  LD$`HH$  0Ll$PH$
  HD$HH$  HD$@H$  HD$8H$   HD$0L|$(H$H  HD$ L$  MIHH$  gHe H$H  H$P   H$   H=# H$  H$  L H$  = H$   HtF  H$   H$   H$   H$   !  H$  f H$  Ht  H$  H$  H$  H$    H$x  Ht  H$x  H$  H$  H$`    H$  Ht  H$  H$   H$(  H$   j  HL$` H$   HtK  H$   H$   H$   H$   &  H$`  k H$P  H$  T H$p  H$ 	   3iHJ HL$p H$  H H8 H$  HT$pH$   HE H$  H H$    L$P
  I[XA(sA({E(CE(KE(SIA_A^A]A\_^]H=
 =
 x>
 ?
 ?
 @@
 @
 A
 B
 xC
 :D
 D
 G
  	
H   HD$0LHp  L  L@  H  HD$(LT$ ItNH HL$8i HL$` HE HD$`HT$8HL$xh H  HL$`  3HĨ   % % % % %| %n %` %R %D %6 % % % % % %z %l %^ %P %B %4 H\$Ht$WH Ht*DAL
       @t	HK3   HCv  @tH   HH\$0Ht$8H _% % % %j %\ %> % % % % % % % @SH HH
$ F HD$8HuH: ~     H
  HD$8H
ܑ  HD$@H HLD$@HT$8<  HHL$8 H HL$@ H      HH [H(GHH(@SH    { HH HH H9 HuC#H#   H
  H
  3H [HHXHhHxL` AUAVAWH 3ML;8   ;#  D eH%0   HXH;t   3H uA   l t   [    H
q  LH;   H
P z MLHHI;rZH9} t< H9E tHM L H# HE H
 0 H
 H  L;uL;tLLI  Hȏ Hɏ = D;   H=    3      eH%0   HXH;t   3HZ u   C ;t   3  >Hl5 H
U5       ;uH35 H
d       ;u
HH H9= t!H
   ;tMĺ   I͎     H\$@Hl$HH|$PLd$XH A_A^A]HHXHpHxATH0IL   XUj u9C u
3ۉX   tu3H HtЋ؉D$ tLƋI4؉D$    LƋI  ؉D$ u5u1L3I  L3IL MtL3IAӅtu7LƋI#ˋىL$ tHr HtLƋIЋ؉D$ 3ۉ\$ ci H\$@Ht$HH|$PH0A\H\$Ht$WH IHug  LǋHH\$0Ht$8H _H\$DD$HL$VWATH@IALHك|$pxI+H\$`H H\$hH@A\_^HLH D@HPSVWATH8MIcH` HHHHX|$pxH+H\$`HAD$    H8A\_^[% % % % H
= 8  H\$WH H H= HHtHH;rH\$0H _H\$WH H H= HHtHH;rH\$0H _HMZ  f9t3HcH<H39PE  u  f9QLcA<E3LLA@EXJL EtQL;r
AL;rAH(E;r3HH(LL
rIjt"M+IIHt@$Ѓ3H(%@ %2 % % H(uH=  u3    H(H\$WH Hf Hd$0 H2-+  H;tHHf vHL$0
 H\$0
 DI3
 DI3
 HL$8DI3
 L\$8L3H  L#H3-+  L;LDL*f IL(f H\$@H _%& % % ff     HL$L\$M3LT$L+MBeL%   M;sfA M A M;uL$L\$H@UH HHM@ H ]@UH HHM(] H ]@UH HHM(= H ]@UH HHM( H ]@UH HHM( H ]@UH HHM( H ]@UH HHMh H ]@UH HHM( H ]@UH HHM(} H ]@UH HHM(] H ]@UH HHM(= H ]HT$UH HHM0HPHH
 H	6 H% H ]HT$UH HHMpHPHH
 H	 H H ]HT$UH HHM@HPHH
 H	 H H ]HT$UH HHM`HPHH
o H	v He H ]HT$UH HHM HPHH
/ H	6 H% H ]HT$UH HHM(HPHH
 H	 H H ]HT$UH HHM8HPHH
 H	 H H ]HT$UH HHMHHPHH
 H	v He H ]HT$UH HHMXHPHH
O H	6 H% H ]HT$UH HHMhHPHH
 H	 H H ]HT$UH HHMxHPHH
 H	 H H ]HT$UH HH4 H
 H	| Hk H ]@UH HHMP H ]@UH HHM@n9H ]@UH HEHt
eHHM@>H ]@UH HHM@
 H ]@UH HExtexHMp
 H ]@UH HHM(]
 H ]@UH HH   :
 H ]@UH HH   
 H ]@UH HHM(	 H ]@UH HHMP	 H ]@UH HHM(	 H ]@UH HH    H ]@UH HH   j	 H ]@UH HH   J	 H ]@UH HHM -	 H ]@UH HHM 
	 H ]@UH HHM  H ]@UH HHM 
 H ]@UH HHM 	 H ]@UH HHM 	 H ]@UH HHM 	 H ]@UH HHM`	 H ]@UH HHM }	 H ]@UH HHM ]	 H ]@UH HHM =	 H ]@UH HHM`	 H ]@UH HHM  H ]@UH HHMp H ]@UH HHMHm H ]@UH HH   J H ]@UH HH   * H ]@UH HH   
 H ]@UH HH    H ]@UH HH    H ]@UH HHM( H ]@UH HHMP H ]@UH HHM(] H ]@UH HHMP H ]@UH HHMPH ]@UH HH   H ]@UH HHMh^GH ]@UH HHM`H ]@UH HHMP~H ]@UH HHMPFH ]@UH HH   ;H ]@UH Hꋅ   t   H   FH ]@UH HHMPH ]@UH HHMP^FH ]@UH HH   H ]@UH Hꋅ   t   H   FH ]@UH Hꋅ  t  H  GH ]@UH HHMPH ]@UH HHMPEH ]@UH HH   H ]@UH HH   KEH ]@UH HHM .EH ]@UH HHM EH ]@UH HH  DH ]@UH HHM DH ]@UH HH   DH ]@UH HH   FH ]@UH HHMPH ]@UH HHMP>DH ]@UH HH   {H ]@UH Hꋅ   t   H   CH ]@UH Hꋅ  t  H  EH ]@UH HHMPH ]@UH HHMPnCH ]@UH HH   H ]@UH HH   +CH ]@UH HHM CH ]@UH HHM BH ]@UH HH  BH ]@UH HHM BH ]@UH HH   BH ]@UH HH   {DH ]@UH HHMP螿H ]@UH HHMPBH ]@UH HH   [H ]@UH Hꋅ   t   H   AH ]HT$UH HH$  HHEHHH H ]@UH HHM 达H ]@UH HHM 2H ]@UH HH     H ]@UH HH   j  H ]@UH HHM`2H ]@UH HHM`H ]@UH HH(  
  H ]@UH HHM ޽H ]@UH HHM 辽H ]@UH HHM 1H ]@UH HH     H ]@UH HH   j  H ]@UH HHM`1H ]@UH HHM`H ]@UH HH(  
  H ]@UH HHM ޼H ]@UH HHM 込H ]@UH HHM 0H ]@UH HH     H ]@UH HH   j  H ]@UH HHM`0H ]@UH HHM`H ]@UH HH(  
  H ]@UH HHM ޻H ]@UH HHM 辻H ]@UH HHM /H ]@UH HH     H ]@UH HH   j  H ]@UH HHM`/H ]@UH HHM`H ]@UH HH(  
  H ]@UH HHM ޺H ]@UH HHM 辺H ]@UH HHM .H ]@UH HH   {H ]@UH Hꋅ   t   H   .H ]@UH HHMX=  H ]@UH HH     H ]@UH HH     H ]@UH HHM ιH ]@UH HHMH螨H ]@UH HHMH~H ]@UH HHMP^H ]@UH HH   ;H ]@UH HHMHH ]@UH HHMHH ]@UH HHMPΧH ]@UH HHMP讧H ]@UH HHMP螸H ]@UH HHMP^NH ]@UH HHM ^H ]@UH HHM NH ]@UH HH   MH ]@UH HHMPH ]@UH HHMPMH ]@UH HHM 讷H ]@UH HHM nMH ]@UH HH   KMH ]@UH HHMP>H ]@UH HHMP^H ]@UH Hꋅ0  t0  H   W^H ]@UH HH   ˶H ]@UH HH   K9H ]@UH HH  苶H ]@UH HH   ;H ]@UH HHh  Z  H ]@UH HH  :H ]@UH HH    H ]@UH HHMPH ]@UH HHMPεH ]@UH HHMP]H ]@UH Hꋅ0  t0  H   \H ]@UH HH   [H ]@UH HH   7H ]@UH HH  H ]@UH HH   9H ]@UH HHh    H ]@UH HH  k9H ]@UH HH    H ]@UH HHMP~H ]@UH HH   [H ]@UH HH   [H ]@UH HH   H ]@UH HH   k[H ]@UH HH@    H ]@UH HHMh  H ]@UH HHMh[H ]@UH HHMh~H ]@UH HHMhZH ]@UH HHMh>H ]@UH HHMh-  H ]@UH HHMh
  H ]@UH HH   ۲H ]@UH HH   軲H ]@UH HHM0莲H ]@UH HHM05H ]@UH HHM`NH ]@UH HHM`4H ]@UH HH   4H ]HT$UH HLG LK I   LR 3  H H ]@UH HH   蛱H ]@UH HH   4H ]@UH HH   [H ]@UH HH   3H ]@UH HHMhH ]@UH HHMh3H ]@UH HHM8ްH ]@UH HHM8^3H ]@UH HH   ;3H ]@UH HH   3H ]HT$UH HnL L8J G   P 3  H H ]@UH HH   H ]@UH HH   2H ]@UH HH   ˯H ]@UH HH   WH ]@UH HH   苯H ]@UH HH   VH ]@UH HHM@VH ]@UH HHM@.H ]@UH HHM@~VH ]@UH HHM@H ]@UH HHM@n1H ]@UH HH   諮H ]@UH HH   苮H ]@UH HHM ^H ]@UH HHM DH ]@UH HH   H ]@UH Hꋅ  t  H   CH ]@UH HHMPέH ]@UH HHMPN0H ]@UH HH   +0H ]@UH HH   0H ]@UH HHM >H ]@UH HHM ~!H ]@UH HH   H ]@UH HH   ;!H ]@UH HH   軬H ]@UH HH   {BH ]@UH HH     H ]@UH HHM` H ]@UH HHM`>H ]@UH HHM`AH ]@UH HH   H ]@UH HHM ޫH ]@UH HH    H ]@UH HHMp>.H ]@UH HHM8~H ]@UH HHM8-H ]@UH HH   ;H ]@UH HH   -H ]@UH HH  {H ]@UH HH  H ]@UH HHP  mH ]@UH HH   lH ]@UH HH   H ]@UH HH   [H ]@UH HH   [H ]@UH HH   H ]@UH HH   H ]@UH HHM0^H ]@UH HHM0H Z,H ]@UH HH   H ]@UH HHM0HPzH ]@UH HHM0kH ]@UH HH0  H ]@UH HH0  H +H ]@UH HH   {H ]@UH HH0  HPH ]@UH HH0  kH ]@UH HH@  H ]@UH HH`  kmH ]@UH HEhtehH  =mH ]@UH HH`  H ]@UH HH   H ]@UH HH  kH ]@UH HH   軧H ]@UH HH   OH ]@UH HH   {H ]@UH HH   NH ]@UH HHM`NH ]@UH HHM`H ]@UH HHM`nNH ]@UH HHM`ަH ]@UH HHM0zH ]HT$UH H讛L Lx@ =   F N$  Hv H ]@UH HH   KH ]@UH HH   +H ]@UH HHMPH ]@UH HHMP>H ]@UH HHM 辥H ]@UH HHM H ]@UH HH   H ]@UH HH   [H ]@UH HHM >H ]@UH HHMPH ]@UH HHM H ]@UH HHM >H ]@UH HH     H ]@UH HH     H ]@UH HHM`H ]@UH HHM`^H ]@UH HH(  J  H ]@UH HHM H ]@UH HHM`.H ]@UH HHM0NH ]@UH HHM0.H ]@UH HHMHH ]@UH HHMHH ]@UH HH   k	H ]@UH HHM 讍H ]@UH HHM 莍H ]@UH HH   	H ]@UH HH   KH ]@UH HHp  諢H ]@UH HHp  IH ]@UH HH  kH ]@UH HH  IH ]@UH HH  +H ]@UH HH  kH ]@UH HH   H ]HT$UH HޖL' L; 8 v  ,B !  H H ]@UH HH   7H ]HT$UH HnL L8; 8 w  A !  H H ]@UH HH   {HH ]@UH HH   H ]@UH HH   ;HH ]@UH HH   諠H ]@UH HHM JH ]HT$UH H~LǞ LH: 7   @ z"  H H ]@UH HH   {H ]HT$UH HLW L9 *7   \@ #  HA H ]@UH HH  諟H ]@UH HH  苟H ]@UH HHp  kH ]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH: H0]HT$UH0HHZ H0]HT$UH0HHz H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH H0]HT$UH0HH: H0]HT$UH0HHZ H0]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(}  H ]@UH HHM(]  H ]@UH HHM@  H ]@UH Hꋅ`  t`  HP    H ]@UH HHM@^H ]@UH HHM@.H ]@UH HHM(H ]@UH HHM(4H ]HT$UATH(HHUpHHcHHA   E  H57 H(A\]@UH HHM(H ]@UH HHM(nH ]@UH HHM(~3H ]HT$SUH(HHUpHHcHHA     H8 H(][@UH HHM(H ]@UH HH   B  H ]@UH HHMhM  H ]@UH HHM(}  H ]@UH HHMH
  H ]@UH HH   2  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HHM m  H ]@UH HHM M  H ]@UH HHM -  H ]@UH HHM 
  H ]@UH HHM   H ]HT$UH HHMHHt
H   33{H ]HT$UH HHMHHt
H   33;H ]HT$UH H33H ]@UH HH   r  H ]@UH HHMh
  H ]@UH HHM(=  H ]@UH HH     H ]@UH HHM(  H ]@UH HH     H ]@UH HHMP  H ]@UH HHMHM  H ]@UH HHM -  H ]@UH HHM 
  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM   H ]@UH HH     H ]@UH HHMHm  H ]@UH HHM M  H ]@UH HHMH-  H ]@UH HHM 
  H ]@UH HHMH  H ]@UH HHM@H ]@UH HHM@  H ]@UH HHM@m  H ]@UH HHM@H ]HT$UH HHMH33H ]@UH HH     H ]@UH HHM8  H ]@UH HH    H ]@UH HHM`  H ]HT$UH H33^H ]@UH HHM`U  H ]@UH HHM8]  H ]@UH HHM@H ]@UH HHUXHM(H ]HT$SUWH HH]PH}`H;t@ H  H(H;u33虽H _][@UH HHM`  H ]@UH HHM8  H ]@UH HHM0m  H ]@UH HH   HM(H ]HT$SUWH HH   H   H;tH  H(H;u33ǼH _][@UH HHM@H ]@UH HHM@
  H ]@UH HHM@H ]@UH HHM@  H ]@UH HHM@H ]@UH HHM@)H ]@UH HHMH)H ]@UH HEPtePHM@HxlH ]@UH Hꋅ   t   HM Hx6H ]@UH HHM   H ]@UH HHM H ]@UH HEXteXHM@Hx H ]@UH HHM@~H ]@UH HHU(HM0H ]HT$SUWH HH]XH}PH;t@ H  H(H;u33艺H _][@UH HEPtePHM@HP H ]@UH HEPtePHM@HxH ]@UH HHM@莗H ]@UH Hꋅ   t   HM(HPH ]@UH HHM(΂H ]@UH HEXteXHM@Hx<H ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@ޱH ]@UH HEPtePHM@H`H ]@UH HEPtePHM@HxlH ]@UH HHM@>H ]@UH HEPtePHM@HxH ]@UH HHM@H ]@UH Hꋅ   t   HM(H`H ]@UH HHM(.H ]@UH HEXteXHM@H`|H ]@UH HHM@H ]@UH HH     H ]@UH HH   RH ]@UH HHM0  H ]HT$UH HH'? H ]@UH HEPtePHM@H`H ]@UH HHM@H ]@UH Hꋅ   t   HM HxVH ]@UH HHM 
  H ]@UH HHM H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@HxLH ]@UH HHM@^H ]@UH HEPtePHM@HxH ]@UH HHM@.H ]@UH HEXteXHM@HxH ]@UH HHM@nH ]@UH HEPtePHM@Hx\H ]@UH HHM@H ]@UH HEXteXHM@HxH ]@UH HHM@H ]@UH HEPtePHM@HxH ]@UH HHM@H ]@UH HH   B  H ]@UH HH     H ]@UH HHMP
  H ]@UH HH     H ]@UH HH   z  H ]@UH HHMP  H ]@UH HHM H ]@UH HH   b  H ]@UH HH     H ]@UH HHMP-  H ]@UH HH     H ]@UH HH     H ]@UH HHMP  H ]@UH HHM@NH ]HT$UH HHM@蚉33H ]@UH HHM@H ]@UH HHM@~H ]@UH HHM(辈H ]@UH HHM@  H ]@UH HH   kzH ]@UH HH   [H ]@UH Hꋅ0  t0  HM0HPH ]@UH HHM0yH ]@UH HHM0H ]@UH HH@  H ]@UH HH8  {H ]@UH HHM0NH ]@UH8 8 ]@UH HHH  H ]@UH Hꋅ0  t0  HH  HPH ]@UH HHM HH ]@UH HH   xH ]@UH HH   {H ]@UH Hꋅ@  t@  HM0HPH ]@UH HHM0NxH ]@UH HHM0H ]@UH HHX  H ]@UH HHH  H ]@UH HHM0NH ]@UH6 6 ]@UH HH   WH ]@UH Hꋅ@  t@  H   HPH ]@UH HHM H*H ]HT$UH HHMX֭33H ]@UH HHMP読H ]@UH HEHteHHMPHPLH ]@UH HHMP螂H ]@UH HHMP:H ]@UH HEHteHHMPHPH ]@UH HHMPH ]@UH HHMHʬH ]@UH HH   KH ]@UH HjpH  J&H ]@UH HjpH   *&H ]HT$UH HH   C33RH ]@UH HjpHMH%H ]@UH HjpHM`%H ]@UH HHM@H ]@UH HHMPHjmH ]@UH HHMPHJmH ]@UH HHM`H*mH ]@UH HHM`H
mH ]@UH HHM`H0lH ]@UH HHM@^H ]HT$UH HHM@誂33H ]HT$UH HHMpƪ33ժH ]HT$UH H33讪H ]HT$SUVWATH0HDe0A~$H}@HH]8LHH   HH   H]8H}@E~#H   HHLHHHH
33H0A\_^][@UH HHMP-  H ]HT$UH0HH   LH   HA NH   HPJU33蠩H0]@UH HHMP  H ]HT$UH HHM`F33UH ]HT$UH H33.H ]HT$UH HHM`33H ]HT$UH H33ިH ]@UH HHMPHH ]@UH HHM(H ]@UH HHMPH@JH ]@UH HHM0H ]@UH HHM@HiH ]@UH HHM@HiH ]@UH HHM@H(iH ]@UH HHM@H8ziH ]@UH HHM@HHZiH ]@UH HHM@HX:iH ]@UH HHM@H ]HT$SUH8HL   H   HH   H)338H8][@UH HH   軅H ]@UH HH   軟H ]@UH HH   ˵H ]@UH HHUXHM(H ]HT$SUVWH(HH]PH}`H;tHuhHHdH0H;u33fH(_^][@UH HHMH}  H ]@UH HHM ]  H ]@UH HH     H ]@UH HH   KH ]@UH HH@  H ]@UH HH   [H ]@UH HHMp  H ]@UH HHMH  H ]@UH HHM }  H ]@UH HH   Z  H ]@UH HH     H ]@UH HH   KH ]@UH HH  [H ]@UH Hꋅ   t   HMXZH ]@UH Hꋅ   t   HM(*H ]@UH HHM`n{H ]HT$UH0HHM`
33H0]HT$UH HHM@{33H ]HT$UH0HHM`Z{33赣H0]HT$UH HHM@*{33腣H ]HT$UH0HHMhF33UH0]@UH HHMP  H ]@UH HHM(M  H ]HT$UH0HHMp֢33H0]HT$UH0H33辢H0]@UH HHM(ݺ  H ]@UH HHMP
  H ]@UH HHMPH ]@UH HHM(~H ]@UH HHU(HM0
H ]HT$SUVWH(HH]hH}`H;tHuxHHH0H;u33֡H(_^][@UH HHMh  H ]@UH HHM(  H ]@UH HHM(H ]@UH HH   ~H ]@UH HHUXHM(H ]HT$SUVWH(HH]PH}`H;tHuhHHH0H;u33H(_^][@UH HHMp  H ]@UH HHMHݸ  H ]@UH HHM   H ]@UH HH     H ]@UH HH   ʹ  H ]@UH HH   H ]@UH HH  H ]HT$UH0HH   33ҟH0]HT$UH0HH   Gw33袟H0]@UH HHMp H ]@UH HHMpvH ]@UH HHMpH ]@UH HHMpNvH ]@UH HH   :  H ]@UH HHM@  H ]@UH HHM`H ]@UH HH   "  H ]@UH HHMh  H ]@UH HHM   H ]@UH HHM H ]@UH HH  |H ]@UH HH     H ]@UH HHMh  H ]@UH HHM M  H ]@UH HHM .H ]@UH HH  +|H ]@UH HHM(  H ]@UH HHM(}  H ]@UH HHM(]  H ]@UH HHM(=  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(ݴ  H ]@UH HHM(  H ]@UH HHM@n1H ]@UH HHM@1H ]@UH HHM@N2H ]@UH HHMP.sH ]@UH HHMPH ]@UH HHU(HM0誹H ]HT$SUVWH(HH]hH}`H;tHuxHHtH0H;u33vH(_^][@UH HHM8\H ]@UH HHM@H ]@UH HHM0nH ]@UH HH   rH ]@UH HH   H ]@UH HH   qH ]@UH HH   H0WH ]@UH HHM@qH ]@UH HH   HxH ]@UH HHMH^qH ]@UH HH   H   H ]@UH HHMPqH ]@UH HH   H   H ]@UH HHMP~H ]@UH HHM@^H ]@UH HHM`>H ]@UH HHMXH ]@UH HHM@.H ]@UH HHMH޶H ]@UH HHMP
  H ]@UH HHM(  H ]@UH HHM(Ͱ  H ]@UH HHMP  H ]@UH HH   H ]@UH HH   H ]@UH HH   ;oH ]@UH HH   H ]@UH HH   nH ]@UH HH   {H ]@UH HHP  ʯ  H ]@UH HHM@  H ]@UH HH   ڰ  H ]@UH HHP  j  H ]@UH HHM@H ]@UH HHM@-  H ]@UH HHx  
  H ]@UH HHP    H ]@UH HHMp^H ]HT$SUH8HH HM@  HH0  HRLHHx  6  HH    H6 H  HH  W  H H  H8][@UH HHM@  H ]@UH HHx    H ]@UH HH  *  H ]@UH HHM@  H ]@UH HHM@  H ]@UH HH`  ʮ  H ]@UH HHM@]  H ]@UH HHMpH ]@UH HHP    H ]@UH HHx    H ]@UH HHM@ݬ  H ]@UH HHMpNH ]HT$SUH8HH HM@q  HH8  HRLHHx  &  HH     H& H   HH8  G  H H   H8][@UH HHM@
  H ]@UH HHx    H ]@UH HH     H ]@UH HHM@  H ]@UH HHM@  H ]@UH HH    H ]@UH HHM@M  H ]@UH HHMpH ]@UH HHP  
  H ]@UH HHx    H ]@UH HHM@ͪ  H ]@UH HHMp>H ]@UH HH  {iH ]@UH HH  H ]HT$SUH8HHS HM@!  HH@  HRLHHx  ֩  HH  >  H֮ H  HH    H H  蟑H8][@UH HHM@  H ]@UH HHx    H ]@UH HH  ʪ  H ]@UH HHM@]  H ]@UH HHM@=  H ]@UH HH`  j  H ]@UH HHM@  H ]@UH HHMpnH ]@UH HHP    H ]@UH HHx    H ]@UH HHM@}  H ]@UH HHMpH ]HT$SUH8HH HM@  HHP  HRLHHx  Ƨ  HH  .  HƬ H  HH    H H  菏H8][@UH HHM@  H ]@UH HHx    H ]@UH HH    H ]@UH HHM@M  H ]@UH HHM@-  H ]@UH HH`  Z  H ]@UH HHM@  H ]@UH HHMp^H ]@UH HHP    H ]@UH HHx    H ]@UH HHM@m  H ]@UH HHMpH ]@UH HH  eH ]@UH HH  H ]HT$SUH8HH HM@  HHX  HRLHHx  v  HH  ~HO H  _H8][@UH HHM@}  H ]@UH HHx  Z  H ]@UH HHM8.dH ]@UH HHM8H ]@UH HHMhcH ]@UH HHMhnH ]@UH HHMP  H ]@UH HHM   H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM ݣ  H ]@UH HHM   H ]@UH HHM   H ]@UH HHM }  H ]@UH HHM ]  H ]@UH HHM =  H ]@UH HHMXbH ]@UH HE t
e HMX@H ]@UH HHMx͢  H ]@UH HHM8  H ]@UH HHU0HM@:H ]HT$UH0HHM033%H0]@UH HHU0HM@H ]HT$UH0HHM0Ɖ33ՉH0]@UH HHMxNKH ]@UH HHMX.KH ]@UH HHM@`H ]@UH HHM@H ]@UH HHMp^`H ]@UH HHMpH ]@UH HH  `H ]@UH HH  H ]@UH HH   _H ]@UH HH   [H ]@UH HHp    H ]@UH HH     H ]@UH HHp    H ]@UH HH   J  H ]HT$UH0H] Hh  VH0]HT$UH0H- H`  VH0]@UH HHM@^H ]@UH HHM@>H ]@UH HH   Ҟ  H ]@UH HH   j  H ]@UH HHMP>^H ]@UH HHMP~H ]@UH HHM(
  H ]@UH HHM(  H ]@UH HHMP]H ]@UH HH   HH ]@UH HHM ~]H ]@UH HHM H ]@UH HH   J  H ]@UH HH   *  H ]@UH HHMP\H ]@UH HHMP>H ]@UH HHMP\H ]@UH HHM \H ]@UH HHM@~\H ]@UH HHM@H ]@UH HHU0HM8H ]HT$SUVWH(HH] H   H;t$H   f     HHH0H;u33跄H(_^][@UH HHM@[H ]@UH HHM@>H ]@UH HHMp~[H ]@UH HHMpH ]@UH HHM >[H ]@UH HHM ~H ]@UH HH   R  H ]@UH HH     H ]@UH HHMX  H ]@UH HHMPEH ]@UH HHMp~ZH ]@UH HHMpH ]@UH HHM@>ZH ]@UH HHM@H ]@UH HH   YH ]@UH HH   {H ]@UH HHMp.DH ]@UH HHM`DH ]@UH HH   CH ]@UH HH   CH ]@UH HH   CH ]@UH HHM`CH ]@UH HHM`nCH ]@UH HHMhNCH ]@UH HHM`H*CH ]@UH HHM`CH ]@UH HHM`BH ]@UH HHMhBH ]@UH HH   BH ]@UH HH   BH ]@UH HH   kBH ]@UH HH   KBH ]@UH HH   +BH ]@UH HH   BH ]@UH HH   HAH ]@UH HHMpAH ]@UH HHMpAH ]@UH HHMxAH ]@UH HHM(
  H ]@UH HHM(  H ]@UH HHM(͗  H ]@UH HHM(  H ]@UH HHM(  H ]@UH HHM(m  H ]@UH HHM`>VH ]HT$UH0HHM`33~H0]HT$UH0HHUxHM`&33~H0]HT$UH0HHUxHM`33~H0]@UH HHM8  H ]@UH HHM`͗  H ]@UH HHM`NUH ]@UH HEpt
epHM`H ]@UH HHM(
  H ]@UH HH   K?H ]HT$UH0HHM`芖33}H0]@UH HH   TH ]@UH HH   H ]@UH HHMHNTH ]@UH HHMHH ]@UH HHM@TH ]@UH HHM@H ]@UH HHU0HM8芚H ]HT$SUVWH(HH] H   H;t$H   f     HHEH0H;u33G|H(_^][@UH HH   KSH ]@UH HH   H ]@UH HH   SH ]@UH HH   H ]@UH HH  RH ]@UH HH  KH ]@UH HH8  RH ]@UH HH8  H ]@UH HH    H ]@UH HHMp=  H ]@UH HH  b  H ]@UH HHMp  H ]HT$UH0H
 H  IH0]@UH HHMpQH ]@UH HHMpH ]HT$UH0H H  !IH0]@UH HHMPH ]@UH HHM(QH ]@UH HHM(NH ]@UH HHM(PH ]@UH HHM(PH ]@UH HHM(:H ]@UH HHM(:H ]@UH HHM@NPH ]@UH HHM@H ]@UH HHMp~:H ]@UH HH   B  H ]@UH HH   ڐ  H ]@UH HHMP:H ]@UH HHMP9H ]@UH HHM`nOH ]HT$UH0HHM`33xH0]@UH HH   9H ]@UH HH   k9H ]@UH HH   K9H ]@UH HH   +9H ]@UH HH   :H ]@UH HHMp8H ]@UH HHMp8H ]@UH HH   8H ]@UH HH   8H ]@UH HHM MH ]@UH HHM ~H ]@UH HHMPMH ]@UH HHMP>H ]@UH HHMp>H ]@UH HHM(H ]@UH HHM 7H ]@UH HHMp9H ]@UH HHMpH@j7H ]@UH HHM   H ]@UH HHMP  H ]@UH HHM   H ]@UH HHM(  H ]@UH HHMP  H ]@UH HHM(M  H ]@UH HHMP}  H ]@UH HHM@KH ]HT$UH HHM@*]33tH ]@UH HHM@KH ]HT$UH HHM@\33UtH ]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   H_H   H]@H}8E~)H   HLRILHHHH Hs33sH0A\_^][@UH HHMP^H ]HT$UH0HH   L@IH   HA MH   HPI袔33=sH0]@UH HHMPH ]@UH HH   H ]@UH HH   ːH ]@UH HHMpIH ]@UH HHMpnH ]@UH HH   IH ]@UH HH   +H ]@UH HH   +H ]@UH HH   KIH ]@UH HH   H ]@UH HH  IH ]@UH HH  H ]@UH HH   "  H ]@UH HH8    H ]@UH HH     H ]@UH HHx  z  H ]HT$UH0H H  @H0]@UH HH   r  H ]@UH HH8  
  H ]@UH HH  :  H ]@UH HH8  GH ]@UH HH8  ;H ]HT$UH0H H  A?H0]@UH HH   H ]@UH HH   H ]@UH HHM`GH ]@UH HHM`H ]@UH HH   FH ]@UH HH   KH ]@UH HH   FH ]@UH HH   H ]@UH HH   KFH ]@UH HH   H ]@UH HH   b  H ]@UH HH0    H ]@UH HH   "  H ]@UH HHp    H ]HT$UH0H H  Q=H0]@UH HH     H ]@UH HH0  J  H ]@UH HH  z  H ]@UH HH0  DH ]@UH HH0  {H ]HT$UH0H H  <H0]@UH HHMx  H ]@UH HHM8͆  H ]@UH HHM8记H ]@UH HH   軼H ]HT$SUH8HL   H   HH   %Hl33lH8][@UH Hj@HM=H ]@UH Hj@HM H ]@UH HHM@nH ]@UH HHM@HH ]@UH HHMH>CH ]@UH HHMHCH ]@UH HH   k-H ]@UH HH   HG-H ]@UH HH   +-H ]@UH HH   H-H ]@UH HHMp  H ]@UH HHM`~H ]@UH HHM@,H ]@UH HHM@,H ]@UH HHM(n,H ]@UH HHM(N,H ]@UH HHM@>H ]@UH HHM@H :H ]@UH HHMHH ]@UH HHM@HPZH ]@UH HHM@辰H ]@UH HHMH螰H ]@UH HHM@~H ]@UH HHMH^H ]@UH HHM@H躵H ]@UH HHM@H@H ]@UH HHM@H  H ]@UH HHMHޯH ]@UH HHM@HI  H ]@UH HHM@H0H ]@UH HHM@HpjH ]@UH HHM@H     H ]@UH HHMH?H ]@UH HHMH?H ]@UH HHM@H ]@UH HHM@H  ǚH ]@UH HHM@Hx  藳H ]@UH HHM@H  H ]@UH HHM@H  WH ]@UH HHM@H  H ]@UH HHM@H@  WH ]@UH HHM@Hp  7H ]@UH HHM0~>H ]@UH HHM0H ]@UH HH@  ;>H ]@UH HHM0H ]@UH HH   
  H ]@UH HHp  {H ]@UH HH   /H ]HT$UH0HHMxVf33efH0]HT$SUVWATH0HDe0A~'H}8LIH]@LHH   HoH   H]@H}8E~)H   HLRILHHHH0He33eH0A\_^][@UH HHMPnH ]HT$UH0HH   L@IH   HA MH   HPI貆33MeH0]@UH HHMPH ]@UH HHp  ;<H ]@UH HHp  軾H ]@UH HH   ;H ]@UH HH   {H ]@UH HHMh|  H ]@UH HH   |  H ]@UH HH  |  H ]@UH HHM0H ]@UH HHMhM|  H ]@UH HHM0辽H ]@UH HH  
|  H ]@UH HH   {  H ]@UH HHMh{  H ]@UH HHM0>H ]@UH HHMh{  H ]@UH HHM0H ]@UH HH  J{  H ]@UH HH   *{  H ]@UH HHMh
{  H ]@UH HHM0~H ]@UH HHM09H ]@UH HHM0>H ]@UH HHMhz  H ]@UH HHM0H ]@UH HH  Jz  H ]@UH HH   *z  H ]@UH HHMh
z  H ]@UH HHM0~H ]@UH HHM08H ]@UH HHM0>H ]@UH HHMhy  H ]@UH HHM0H ]@UH HH  Jy  H ]@UH HH   *y  H ]@UH HHMh
y  H ]@UH HHM0~H ]@UH HHMhx  H ]@UH HHM0>H ]@UH HH  x  H ]@UH HH   jx  H ]@UH HHMhMx  H ]@UH HHM0边H ]@UH HHMh6H ]@UH HHMh~H ]@UH HHM06H ]@UH HHM0~H ]@UH HHMhw  H ]@UH HHM0H ]@UH HH  Jw  H ]@UH HH   *w  H ]@UH HHMh
w  H ]@UH HHM0~H ]@UH HHM05H ]@UH HHM0>H ]@UH HHMhv  H ]@UH HHM0H ]@UH HH  Jv  H ]@UH HH   *v  H ]@UH HHMh
v  H ]@UH HHM0~H ]@UH HH   4H ]@UH HH   ;H ]@UH HHM0~4H ]@UH HHM0>H ]@UH HHMhMu  H ]@UH HHM0辶H ]@UH HH   kH ]@UH HH  t  H ]@UH HH   t  H ]@UH HHMht  H ]@UH HH@  H ]@UH HHM0mt  H ]@UH HH@  ۵H ]@UH HH   *t  H ]@UH HHMh
t  H ]@UH HHM0s  H ]@UH HH@  [H ]@UH HH  s  H ]@UH HH@  H ]HT$UH0H H  !*H0]@UH HHMp.2H ]@UH HHMp讴H ]@UH HHM8xH ]HT$UH0HD33ZH0]@UH HHMp1H ]@UH HHMpH ]@UH HHM8xH ]HT$UH0H>D33	ZH0]@UH HHM81H ]@UH HHM8莳H ]@UH HH   wH ]HT$UH0HC33yYH0]@UH HHM8~0H ]@UH HHM8H ]@UH HH   vH ]HT$UH0HC33XH0]@UH HHM@HZH ]@UH HHMH/H ]@UH HHM@/H ]HT$SUH8HH   H{8 t'HM8HPHHK8HHo  o  H0 H8][@UH HH   o  H ]@UH HHM`/H ]@UH HHM`莱H ]@UH HHM8o  H ]@UH HH   .H ]@UH HH   +H ]@UH HHM8}o  H ]@UH HHM8]o  H ]@UH HHM8=o  H ]@UH HHM8o  H ]@UH HHM8n  H ]@UH HHM8n  H ]@UH HHM8n  H ]@UH HH   -H ]@UH HH   H ]@UH HHMPN-H ]@UH HHMPίH ]@UH HjPHMH ]@UH HHMpޡH ]@UH HHMpH:H ]@UH HHMpHHH ]@UH HHM(,H ]@UH HHMpH   H ]@UH HHM0N,H ]@UH HHMpH   ǮH ]@UH HHM8,H ]@UH HHMpH   臮H ]@UH HHM`H ]@UH HHMpH ]@UH HHM`H@H ]@UH HHM }l  H ]@UH HHMPk  H ]@UH HHM =l  H ]@UH HHM l  H ]@UH HH   *H ]@UH HH   kH ]@UH HH   KH ]@UH HH   ;H ]@UH HHM8H ]@UH HHMhN*H ]@UH HHMhάH ]@UH HH(  {H ]@UH HHMPj  H ]@UH HE@t
e@HMH`H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHMx>H ]@UH HHMp螘H ]@UH HHM(~H ]@UH HHMpHڝH ]@UH HHMpH@
H ]@UH HHMpH  H ]@UH HHM(H ]@UH HHMxޗH ]@UH HHM(>(H ]@UH HH   +H ]@UH HHM0'H ]@UH HH   HHwH ]@UH HHM8'H ]@UH HH   Hx7H ]@UH HHM@~'H ]@UH HH   H   4H ]@UH HHMH.'H ]@UH HH   H   褩H ]@UH HHMP&H ]@UH HH   H  蔼H ]@UH HH   H@  H ]@UH HHM@HH ]@UH HHM@H8ڨH ]@UH HHM@HpH ]@UH HHM@H   WH ]@UH HHM@H   7H ]@UH HHM@Hp  WH ]@UH HHM@H  f  H ]@UH HHM@H  WH ]@UH HHM@Hif  H ]@UH HHM@H0H ]@UH HHM@HpH ]@UH HHM@H   f  H ]@UH HHMp~H ]@UH HHM8$H ]@UH HHM8>H ]@UH HH  {$H ]@UH HE0te0H  H ]@UH HHx  ˦H ]@UH HHM0讦H ]@UH HH0  Bd  H ]@UH HH  d  H ]@UH HH   
f  H ]@UH HHM`#H ]@UH HHM`H ]@UH HH   K#H ]@UH HH   ˥H ]@UH HHP  諥H ]@UH HHM8莥H ]@UH HH  "c  H ]@UH HH   c  H ]@UH HH   d  H ]@UH HHMhn"H ]@UH HHMhH ]@UH HHH  +"H ]@UH HE0te0HH  蝤H ]@UH HH   {H ]@UH HHMp!H ]@UH HHMp>H ]@UH HHM(b  H ]@UH HHMPc  H ]@UH HH  ۣH ]@UH HH   !H ]@UH HHM  H ]@UH HHM ~H ]@UH HHMP H ]@UH HHMP>H ]@UH HHMPH ]@UH HHM(
H ]@UH HH   fH ]HT$UH H433HH ]@UH HH   [
H ]@UH HH   ;
H ]HT$UH0HH   wa33rHH0]@UH HHM(~H ]@UH HHMHNH ]@UH HHM(>H ]@UH HHMpH躡H ]@UH HHM0H ]@UH HHMpH8zH ]@UH HHM8H ]@UH HHMpHpzH ]@UH HHM@~H ]@UH HHMpH   跒H ]@UH HHMxHI_  H ]@UH HHMxH0H ]@UH HHMxHpjH ]@UH HHMxH   ^  H ]@UH HHMpH   H ]@UH HHMHH ]@UH HHMpHp  H ]@UH HHMpH  f^  H ]@UH HHMP>H ]@UH HHMpH  H ]@UH HHMXH ]@UH HHM(NH ]@UH HHM H ]@UH HHM ~H ]@UH HH   \  H ]@UH HHMhm]  H ]@UH HHM`\  H ]HT$SUH(HHU HM`d\  Hx HM ]  t*HU HM`@\  H  LHAHM \  33DH(][@UH HHM \  H ]@UH HHM \  H ]@UH HHEXD HUPHM("bH ]HT$SUH8HHM@HPHHMX\  H   HHUXHHMX\  LHASH{ H8][@UH HHMX[  H ]@UH HHMH.H ]@UH HHMHH ]HT$SUH8HHU8H   HOHx HMXN[  HHUXHHMXV[  Ho HMX%[  HHUXHHMX-[  LHASH} H8][@UH HHMXZ  H ]@UH HHMXZ  H ]@UH HHMXZ  H ]@UH HHMXZ  H ]@UH HHMX}Z  H ]@UH HHMX]Z  H ]@UH HHMX=Z  H ]@UH HHMXZ  H ]@UH HHE0D HU(HM8_H ]HT$SUWH HH]hH}pH;t!@ HKZ  HKZ  H(H;u33^AH _][@UH HHM H ]@UH HHM H ]@UH HHMhH ]@UH HH   H ]@UH HHM@H ]@UH HHM@nH ]@UH HH   +H ]@UH HHMXH ]@UH HH   H GH ]@UH HHM(NH ]@UH HHM(ΙH ]@UH HHM0H ]@UH HHM0NH ]@UH HHM0H ]@UH HHM H ]@UH HHM nH ]@UH HH   kH ]@UH Hꋅ0  t0  H   H ]@UH HH   軘H ]@UH HHM`H ]@UH HHM`~H ]@UH HHM@^H ]HT$UH0HL   HU8HMp诓LU  AHEx@(H4 H0]@UH HH   H ]@UH HH   H ]@UH HHMH~H ]@UH HHMH^H ]@UH HH   ;H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHM8H ]@UH HHM8H ]@UH HHM`~H ]@UH HH   BT  H ]@UH HH   T  H ]HT$UH0HMXMX  ;|4  H HD$ L
 L  H] H
Ω 虽H5 H0]@UH HH  S  H ]@UH HH  rS  H ]@UH HH  
T  H ]@UH HH   S  H ]@UH HHMxS  H ]@UH HHh  S  H ]@UH HHMPS  H ]@UH HH@  jS  H ]@UH HH   JS  H ]@UH HH   *S  H ]@UH HHM(
S  H ]@UH HHM(R  H ]@UH HH   H ]@UH HH   H ]@UH HHMp~H ]@UH HHMpH ]@UH HH0  ۸H ]@UH HH   H ]@UH HH   蛓H ]@UH HH(  H ]@UH HH(  [H ]@UH HHM@H ]@UH HHM@^H ]@UH HH  KH ]@UH HH(  ;H ]@UH HH  H臷H ]@UH HH(  H ]@UH HH  HHGH ]@UH HHP  H ]@UH HH  H   4H ]@UH HHX  kH ]@UH HH  H   H ]@UH HH`  H ]@UH HH  H   蔑H ]@UH HH  kH ]@UH HHX  蛃H ]@UH HH0  N  H ]@UH HH  N  H ]@UH HH  ZO  H ]@UH HHM@=O  H ]@UH HHMpO  H ]@UH HH   N  H ]@UH HH(  N  H ]@UH HH   N  H ]@UH HH  N  H ]@UH HHX  zN  H ]@UH HH   ZN  H ]@UH HH   :N  H ]@UH HH   
H ]@UH HH   H ]HT$SUHHHH H   M  HH  HH   HH   M  H  HPHH   lM  HH   HH   nM  H HH][@UH HH   :M  H ]@UH HH   M  H ]@UH Hj HMmH ]@UH HH   K{H ]@UH HH   H GH ]@UH HH   HPdH ]@UH HH   kH ]@UH HH   H   H ]@UH HHM(-L  H ]@UH HHMP]M  H ]@UH HH   ;H ]@UH HHMhH ]@UH HHM@K  H ]@UH HHMh~
H ]@UH HH   H ]@UH HH   H  eH ]@UH HH   Hx  d~H ]@UH HH   H  负H ]@UH HH   H  ~H ]@UH HH   H  TH ]@UH HHMPN	H ]@UH HH   H@  ċH ]@UH HHMXH ]@UH HH   Hp  tH ]@UH HHM`H ]@UH HH   H  |H ]@UH HHMH^H ]@UH HEPt
ePHMH|H ]@UH HHM@~H ]@UH HH   BH  H ]@UH HHMhH  H ]HT$UH0Hꋍ    L   IA;|'H HD$ L
 Hc H
 蟱H H0]@UH HH  JH  H ]@UH HH   軮H ]HT$SUHHHH  HM@G  H  HHU@HHM@G  HMhHPHHM@G  HHU@HHM@G  H HH][@UH HHM@G  H ]@UH HHM@mG  H ]@UH HHMHH ]@UH HHM@H ]@UH HH   H ]@UH HHP  H ]@UH HH  H ]@UH HH  H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   kH ]@UH HH   KH ]@UH HH   +H ]@UH HHMpH ]@UH HHMpH ]@UH HH   jE  H ]HT$UH@HLf LD$ L
  H H
 mH@]@UH HH   H ]@UH HH(  H ]@UH HHMXD  H ]@UH HH   D  H ]HT$UH@HH   H H@]@UH HHMX>H ]@UH HH   H ]@UH HHMXH ]@UH HH   H ]@UH HHMXH ]HT$UH@H EPH H@]@UH HH  B  H ]@UH HHMXmC  H ]@UH HH  B  H ]@UH HHMX-C  H ]@UH HHMXH ]@UH HH  H ]@UH HHp  H ]@UH HH  B  H ]@UH HH  C  H ]@UH HH  mH ]@UH HHMp.H ]@UH HH   *B  H ]@UH HH   
B  H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   kH ]@UH HH   KH ]@UH HH  @  H ]@UH HHM@ H ]@UH HHM@螂H ]@UH HH   @  H ]@UH HH   @  H ]@UH HH   @  H ]@UH HH   @  H ]@UH HH   j@  H ]@UH HHM@HH ]@UH HHM@HH ]@UH HHM@H(jH ]@UH HHM@H8JH ]@UH HHM@HH*H ]@UH HHM@HX
H ]@UH HHM@H   ?  H ]HT$UH HH   Ht'33'H ]@UH HHM0.H ]@UH HH   ?  H ]@UH HHMxM@  H ]@UH HH   >  H ]@UH HHMx
@  H ]@UH HH   H ]@UH HH   qH ]@UH HH  KH ]@UH HH  qH ]@UH HH  H ]@UH HH  KqH ]@UH HH  H ]@UH HH  qH ]@UH HH  H ]@UH HH  pH ]@UH HH   Z=  H ]@UH HH   :=  H ]@UH HH  H ]@UH HHP  B<  H ]@UH HH   <  H ]@UH HH  +kH ]@UH HH  pH ]@UH HH  z<  H ]@UH HH0  jH ]@UH HH0  +pH ]@UH HH  pH ]@UH HH  ;  H ]@UH HH  KjH ]@UH HH  oH ]@UH HHh  ;  H ]@UH HH   z;  H ]@UH HH  Z;  H ]@UH HHMP=;  H ]@UH HH   KH ]@UH HHh  :  H ]@UH HH   :  H ]@UH HH   :  H ]@UH HH   :  H ]@UH HH   z:  H ]@UH HHMP]:  H ]@UH HH   kH ]@UH HHH  H ]@UH HHH  {H ]@UH HH8  H ]@UH HH8  苎H ]@UH HHx  H ]@UH HHx  lH ]@UH HHx  KH ]@UH HH  gH ]@UH HH  gH ]@UH HH0  kgH ]@UH HH  KgH ]@UH HH  +gH ]@UH HHMPgH ]@UH HH  kH ]@UH HH  KH ]@UH HH  +H ]@UH HH  H ]@UH HH   H ]HT$SUH(HH  HM07  H   HHU0HHM07  HM(HPHHM0{7  HHU0HHM07  H. H(][@UH HHM0]7  H ]@UH HHM0=7  H ]HT$SUH(HHS  HM06  H   HHU0HHM06  HM(HPHHM06  HHU0HHM06  H0 H(][@UH HHM06  H ]@UH HHM0}6  H ]@UH HHM(~H ]HT$SUH(HH  HM06  H   HHU0HHM06  HM(HPHHM05  HHU0HHM05  H2 H(][@UH HHM05  H ]@UH HHM05  H ]HT$SUH(HHs  HM0Q5  H   HHU0HHM0R5  HM(HPHHM05  HHU0HHM0#5  H3 H(][@UH HHM04  H ]@UH HHM04  H ]HT$SUH(HH  HM04  H   HHU0HHM04  HM(HPHHM0[4  HHU0HHM0c4  H4 H(][@UH HHM0=4  H ]@UH HHM04  H ]HT$SUH(HHC  HM03  H   HHU0HHM03  HM(HPHHM03  HHU0HHM03  H5 H(][@UH HHM0}3  H ]@UH HHM0]3  H ]@UH HH   :3  H ]@UH HH   H ]@UH HH   2  H ]@UH HH   "2  H ]@UH HH   2  H ]@UH HHMPH ]@UH HHMPtH ]@UH HH   KH ]@UH HH   sH ]@UH HH   b1  H ]@UH HH   1  H ]@UH HH   1  H ]@UH HEpt
epHMxH ]@UH HHMhH ]@UH HHMxH ]@UH HHM@NVH ]@UH HH  WH ]@UH HH   WH ]@UH HHh  WH ]@UH HH   ]H ]@UH HHMXUH ]@UH HH   H ]@UH HHMH^UH ]@UH HH0  /  H ]@UH HHM@-0  H ]@UH HHM@
0  H ]@UH HHM@/  H ]@UH HHM@/  H ]@UH HHM@/  H ]@UH HHM@/  H ]@UH HH0  j/  H ]@UH HHM@M/  H ]@UH HHMhH ]@UH HHMhnH ]@UH HHMxNH ]@UH HHMx.H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HH   H ]@UH HHM0H ]@UH HHM0nH ]@UH HHM@NH ]@UH HH   -  H ]@UH HH   -  H ]HT$UH0HM`M`  ;|4  H HD$ L
c L  H- H
ւ iHm H0]@UH HHM(RH ]@UH HHMx^H ]@UH HHM@>H ]@UH HH   ,  H ]@UH HHMh,  H ]HT$UH0Hꋍ    L   IA;|'H HD$ L
R H# H
ԁ _Hr H0]@UH HHM@nH ]@UH HH   PH ]@UH HHMXPH ]@UH HHMXPH ]@UH HH   PH ]@UH HHM H ]@UH HH   +XH ]@UH HH   *+  H ]HT$UH@HLLL LD$ L
 H H
 -H@]@UH HH   H ]@UH HH@  H ]@UH HHMX*  H ]@UH HH  j*  H ]HT$UH@HH   HG~ H@]@UH HHMXH ]@UH HH  H ]@UH HHMXH ]@UH HH  H ]@UH HHMX~H ]HT$UH@Hc EPH H@]@UH HH  (  H ]@UH HHMX-)  H ]@UH HH  R(  H ]@UH HHMX(  H ]@UH HHMXH ]@UH HH   H ]@UH HHP  kH ]@UH HHp  j(  H ]@UH HH  )  H ]@UH HH  {SH ]@UH HHMpH ]@UH HH   '  H ]@UH HH   '  H ]@UH HHM@H ]@UH HH   kH ]@UH HHM@NH ]@UH HH   +H ]@UH HHM@H ]@UH HH0  R&  H ]@UH HHM@H ]@UH HHM@^hH ]@UH HH   &  H ]@UH HH   &  H ]@UH HH   j&  H ]@UH HH   J&  H ]@UH HH   *&  H ]@UH HH   
&  H ]@UH HH   H ]@UH HH   %  H ]@UH HH0  $  H ]@UH HH   %  H ]@UH HHMP^H ]@UH HHMPfH ]@UH HH   H ]@UH HH   fH ]@UH HH0  2$  H ]@UH HH   $  H ]@UH HH   $  H ]@UH HjpH   H ]@UH HHM@H ]@UH HHM@H ]@UH HHM0H ]@UH HHM(nH ]@UH HHMPNH ]@UH HHM`.H ]@UH HHM`H ]@UH HHM`HH ]@UH HHM`H(H ]@UH HHM8>H ]@UH HHM8dH ]@UH HHMxH ]@UH HHMx~dH ]@UH HH   +H ]@UH HH   H ]@UH HHMhH ]@UH HH   [H ]@UH HH   cH ]HT$UH0HC    H H0]@UH HH 	  B!  H ]@UH HH  !  H ]@UH HHp  +PH ]@UH HHp  UH ]@UH HH0  z!  H ]@UH HHP  OH ]@UH HHP  +UH ]@UH HH   H ]@UH HH   bH ]@UH HHM`>H ]@UH HHM`H ]@UH HH   H ]@UH HH   bH ]@UH HH`  KH ]@UH HH`  aH ]@UH HH  H ]@UH HH  aH ]@UH HH    H ]@UH HH    H ]@UH HH
  H ]@UH HH
  ۅH ]@UH HH
  軅H ]@UH HH  H藅H ]@UH HH
  H ]@UH HH
  H ]@UH HH  {H ]@UH HH    H ]@UH HHMp  H ]@UH HH0  z  H ]@UH HH  LH ]@UH HH  +RH ]@UH HHMp  H ]@UH HH  J  H ]@UH HH  KLH ]@UH HH  HH ]@UH HH
  H ]@UH HH
  kH ]@UH HH   KH ]@UH HH   ^H ]@UH HH    H ]@UH HH  kKH ]@UH HH  PH ]@UH HHMp  H ]@UH HH  KH ]@UH HHP  JH ]@UH HHp  JH ]@UH HH    H ]@UH HH    H ]@UH HH    H ]@UH HH  KJH ]@UH HH  OH ]@UH HH  H ]@UH HH  H ]@UH HH  Z  H ]@UH HH  IH ]@UH HH  OH ]@UH HH0    H ]@UH HH  KIH ]@UH HH  NH ]@UH HH  NH ]@UH HHMpnH ]@UH HHMpMH ]@UH HH  :  H ]@UH HH    H ]@UH HHMpH ]@UH HHMp.MH ]@UH HH    H ]@UH HH0    H ]@UH HH  GH ]@UH HH  GH ]@UH HH  GH ]@UH HH  GH ]@UH HHP  kGH ]@UH HHp  KGH ]@UH HH  LH ]@UH HH0    H ]@UH HHMp}  H ]@UH HH  H ]@UH HH  HP  4bH ]@UH HH  EH ]@UH HHMp  H ]@UH HH  ;FH ]@UH HH  KH ]@UH HH  EH ]@UH HH  JH ]@UH HHMpM  H ]@UH HH0  *  H ]@UH HH  0H ]@UH HH  H0  `H ]@UH HH  UH ]@UH HHMp  H ]@UH HH  DH ]@UH HH  KJH ]@UH HH  DH ]@UH HH  kIH ]@UH HHMp  H ]@UH HH0    H ]@UH HH  KWH ]@UH HHMp  H ]@UH HHMp}  H ]@UH HH  CH ]@UH HHP  CH ]@UH HHp  CH ]@UH HHMp  H ]@UH HH  *  H ]@UH HHH  H ]@UH HH
  GH ]@UH HH  BH ]@UH HHP  BH ]@UH HHp  BH ]@UH HH  KH ]@UH HH  {H ]@UH HH  諐H ]@UH HH  H ]@UH HH  +H ]@UH HH  kH ]@UH HH  ۝H ]@UH HH  +H ]@UH HH  kH ]@UH HH  諣H ]@UH HH  ;H ]@UH HH  H ]@UH HHMp  H ]@UH HH    H ]@UH HH  @H ]@UH HHP  @H ]@UH HHp  @H ]@UH HH
P H ]@UH HH
h H ]@UH HH
 H ]@UH HH
h H ]@UH HH
 kH ]@UH HH
 KH ]@UH H   H ]@UH HHHM(HM$3 H ]@UH Hf H ]@UH HHM8HM(HE(HHM0HE08csmtE     E  H ]@UH H}  uLMxDEpHUhHM`H ]@UH HH3Ɂ8  H ]H(H1  H
q   H
  H(H(H1  H
.p   H
  H(H(H1  H
^q   H
  H(tH(d# p H(x ^p  p H($# Wp H(H(M mgp H(HY   q H9   fW" o H
   p " 
    tYtY
p H(" YY o H(H(! n H(n Yxo o ! ^xn o xo fW! n H( 
 ^
o H(H($! o H(H(m oo H(H(fWn H(H(! }_n H(H(  ]on H(0n fW  0n H( /fW  rm H(n fW`  Hm H(  fW2  m H(m Y@  m Hn Xhm (n n fW Hm H(H-  H
l   H
  H(H(H-  H
>l   H
  H(H(H-  H
fm   H
  H(TH8HD$    Y3HtH
˄ HHH H̈́ H΄ Hτ H
  H8H8HD$    3HtH
 HHH H H H H
P  H8H8HD$    3HtH
 HHH H H H H
  H83H(H
    H
t  H(H8HD$    	3HtH
 HHH H H H H
  H8H8HD$    3HtH
 HHH܂ H H H H
0  H8CH8HD$    I3HtH
 HHH H H H H
  H8H(H
 耽H
y  H(H(H
Ł H
	  H(H8+ LD$@3)t$ X5 fTf/ vo	   "   S LD$@3WfTf/a vA	   "   (t$ H8HL$&HL$vHL$*H
 tH
 YHL$V  3 s # HT$^ HT$h HT$H HT$H
h H%B  H
Yg H%2  H
h H%"  H
g H%  H
Yg H%  H
h H%  @SH H Ht*H|$0CuHHPCu	HHPH|$0H [@SH Hk Ht*H|$0CuHHPCu	HHPH|$0H [@SH H[v Ht*H|$0CuHHPCu	HHPH|$0H [@SH Hu Ht*H|$0CuHHPCu	HHPH|$0H [H(H
M~ HtGH
$~ 3H3~ H4~ H5~ H( H(H
~ HtH
t~ 3H~ H~ H~ H(H(H
 HtH
~ 3H~ H~ H~ H(H
i| ԬH(H
} HtwH
} 3H} H} H} H(PH(H
5~ Ht7H
~ 3H~ H~ H~ H(H(H
} HtH
} 3H} H} H} H(                                                                                                                                                                                                                                                                                                                                                                              v     f     L     0     (             
     
     x
     <
               J                    <     
     
     J
     	     	     t	     8	                         8               b                    P     
                              b                     J          x     &               \     :                 n                            T          t     l     0                         P          V                    D          B               
          f               t     "                                      |     p     b     P     F     >     ,                                                  |     p     ^     L     .                                             \     @     *                                        |     v     p     j     b     \     V     N     F     >                  n     P     :                                                   |     n     Z     L     :          
                                        x     j     V     B     &                                             t     \     6     $                                        |     h     Z     @     &          
                                        z     d     P     <     (                                             x     h     T     >     &                                   v     b     L     <     (                                             t     `     J     6     "                                        h     J     :     (                                             l     Z     F     0                                        F     ~                                                              pR   R   R    S    S   @S   `S   S   S   S   S   T   @T   `T   T   T   T   T   U   0U   PU   pU   U   U   U    V   0V   PV   pV   V   V   V    W                                                                                                                                                                                                                                                                   W                                                                                                                                                                                                                                                                   W                                                                                                                                                                                                                                                                   @X                                                                                                                                                                                                                                                                   pX                                                                                                                                                                                                                                                                   X                                                                                                                                                                                                                                                                   0Y                                                                                                                                                                                                                                                                   Y                                                                                                                                                                                                                                                                   Y                                                                                                                                                                                                                                                                   Y                                                                                                                                                                                                                                                                   PZ                                                                                                                                                                                                                                                                   `Z                                                                                                                                                                                                                                                                   pZ                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   Z                                                                                                                                                                                                                                                                   [                                                                                                                                                                                                                                                                   0[                                                                                                                                                                                                                                                                   P[                                                                                                                                                                                                                                                                                   K
                   bad allocation  numpy.core.multiarray   numpy.core.multiarray failed to import  _ARRAY_API  2   _ARRAY_API not found    _ARRAY_API is not PyCObject object  14  _ARRAY_API is NULL pointer  0   module compiled against ABI version %x but this version of numpy is %x  numpy.core.umath    2   module compiled against API version %x but this version of numpy is %x  FATAL: module compiled as unknown endian    14  numpy.core.umath failed to import   0   FATAL: module compiled as little endian, but detected different endianness at runtime   _UFUNC_API      _UFUNC_API not found    _UFUNC_API is not PyCObject object      _UFUNC_API is NULL pointer      SSE, SSE2       empty_nested() must be true before calling recover_memory() .           empty_nested() must be false before calling recover_memory_nested()  /  :0yE>empty_nested() must be false before calling set_zero_all_adjoints_nested()      No free parameters for unit metric              Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        model =         stan_version_major =    stan_version_minor =    stan_version_patch =    Iteration:  %]   [       (Warmup)        (Sampling)  /  stan::services::variational::print_progress %]  Total number of iterations      Starting iteration      Final iteration Refresh rate    Iteration:   [   (Adaptation)    (Variational Inference)    #   stan_version_major      stan_version_minor      stan_version_patch      )       (   --  >   =<  :       Exception thrown at line        bad_alloc       bad_cast        bad_exception   bad_typeid      unknown original type           c:\users\appveyor\appdata\local\temp\1\tmpfq3lup\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.cpp F           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.pyx      __init__.pxd    stringsource    type.pxd        Unknown exception   T   n   lp__    np  HMC PY2 eta get ret sum __str__ zip BFGS    NUTS    args    ctrl    data    flat    init    iter        __main__    misc    name    pars    plot    seed    send        __test__    thin    upar    user    warn    LBFGS   OPTIM   array   ascii   close   error   flush   index   numpy   optim   order   plots   probs   range   shape   split   throw   utf-8   value   DIAG_E  Newton  UNIT_E  append  chains  data_i  data_r  decode  diag_e  dstack  encode  fitptr  format  holder      __import__  logger  method  metric  n_save  pystan  unit_e  update  vars_i  vars_r  warmup      DENSE_E argsptr asarray control dense_e dims_oi epsilon extract genexpr handler logging mean_lp__       newaxis pars_oi refresh reshape samples squeeze _summary        tol_obj warmup2 SAMPLING        adapt_t0        chain_id        (diag_e)        __getstate__    gradient        handlers        int_time        permuted        sampling        stepsize        tol_grad        (unit_e)        warnings        algorithm       data_args       (dense_e)       eval_elbo       flatnames       fnames_oi       getLogger       holderptr       init_list       iter_save       mean_pars       row_stack       sampler_t       test_grad       tol_param       traceplot       Metropolis      ValueError      adapt_iter      _check_pars get inc_warmup      init_alpha      model_code      _split_data get ImportError b   MemoryError B   OrderedDict h   VARIATIONAL H   adapt_delta i   adapt_gamma I   adapt_kappa l   collections L   _get_samples    init_radius q   pystan.misc Q   random_seed f   sample_file d   save_warmup g   tol_rel_obj Zf  variational Zd  RuntimeError    adapt_window    _call_sampler   column_stack    elbo_samples    grad_samples    history_size    optim_algo_t    pystan.plots    string_types    tol_rel_grad    TEST_GRADIENT   adapt_engaged   max_treedepth   pars_oi_bytes   _print_stanfit  AttributeError  append_samples  output_samples  pystan._compat  sampler_params  adaptation_info diagnostic_file sampling_algo_t save_iterations stepsize_jitter adjust_transform        _get_kept_samples       pystan.constants        sample_file_flag        tol_history_size        adapt_init_buffer       adapt_term_buffer       _call_sampler_star      _remove_empty_pars      sampling_metric_t       cline_in_traceback      enable_random_init      _pars_total_indexes Zg  stan_args_method_t      variational_algo_t      _verify_has_samples O   iter_save_wo_warmup par sampler_param_names sim diagnostic_file_flag    __getstate__.<locals>.genexpr   Variable name must be bytes.    ndarray is not C contiguous s   Stan model {} is of mode 'test_grad';
sampling is not conducted.        `inc_warmup` ignored when `permuted` is True.   numpy.core.multiarray failed to import  unknown dtype code in numpy.pxd (%d)    Couldn't allocate space for StanHolder. Couldn't allocate space for stan_fit.   Format string allocated too short, see comment in numpy.pxd s   Non-native byte order not supported %s  Pickling fit objects is an experimental feature!
The relevant StanModel instance must be pickled along with this fit object.
When unpickling the StanModel must be unpickled first. int Stan model {} does not contain samples. c:\users\appveyor\appdata\local\temp\1\tmpfq3lup\stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.pyx self        data sim model_name model_pars par_dims mode inits stan_args stanmodel date =   ndarray is not Fortran contiguous               num_failed test_grad inits par value chains args mean_pars mean_lp__ adaptation_info sampler_params sampler_param_names numpy.core.umath failed to import       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835  Couldn't allocate space for StanArgs.   Format string allocated too short.      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.__getitem__ genexpr stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.__getstate__.genexpr        attr_names              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.__getstate__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.__setstate__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.__reduce__          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.num_failed.__get__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.num_failed.__set__  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.test_grad.__get__   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.test_grad.__set__   list    Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.inits.__set__   list        Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.par.__set__ dict    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.value.__get__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.value.__set__       Expected %.16s, got %.200s      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.args.__set__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.mean_lp__.__get__   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.mean_lp__.__set__   list    Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder.sampler_param_names.__set__ list    Expected %.16s, got %.200s  list        Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._pystanholder_from_stanholder    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._dict_from_stanargs      'NoneType' object has no attribute '%.30s'      'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._set_stanargs_from_dict          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._dict_to_vars_r  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._dict_to_vars_i  _call_sampler_star              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._call_sampler_star       _call_sampler   _call_sampler   _call_sampler   _call_sampler           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._call_sampler    dict    Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835._call_sampler    __cinit__       tuple index out of range        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__cinit__  __init__        __init__                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__init__           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__getstate__.genexpr       attr_names  self        genexpr plot    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__getstate__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__setstate__       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__reduce__ plot    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.plot       'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.plot       traceplot       traceplot               stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.traceplot          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.traceplot  extract extract 'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.extract    'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  list index out of range 'NoneType' object is not subscriptable  list index out of range stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.extract            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__unicode__        stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__str__            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__repr__           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.__getitem__        summary summary stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.summary            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.summary    log_prob        log_prob                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.log_prob           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.log_prob   grad_log_prob   grad_log_prob           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.grad_log_prob      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.grad_log_prob      'NoneType' object is not subscriptable          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_adaptation_info        get_logposterior        get_logposterior                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_logposterior   'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_logposterior   get_sampler_params      get_sampler_params      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_sampler_params 'NoneType' object is not subscriptable  'NoneType' object is not subscriptable  stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_posterior_mean stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.unconstrain_pars   list index out of range args    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_seed           stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.get_stancode       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.flatnames.__get__  'NoneType' object has no attribute '%.30s'      stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._verify_has_samples                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._update_param_oi   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._get_param_names   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._get_param_fnames_oi               stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._get_param_names_oi                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._get_param_dims    stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._get_param_dims_oi stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.constrained_param_names            stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.unconstrained_param_names          stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model._call_sampler  dict        Expected %.16s, got %.200s              stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model.sim.__set__        numpy.ndarray.__getbuffer__ #   numpy.PyArray_MultiIterNew1 0   numpy.PyArray_MultiIterNew2 0   numpy.PyArray_MultiIterNew3 #   numpy.PyArray_MultiIterNew4 #   numpy.PyArray_MultiIterNew5 #   'NoneType' object is not iterable       'NoneType' object is not subscriptable  tuple   Expected %.16s, got %.200s      numpy._util_dtypestring numpy.import_array      numpy.import_array      numpy.import_umath      numpy.import_umath      numpy.import_ufunc      numpy.import_ufunc      vector.to_py.__pyx_convert_vector_to_py_double  string.to_py.__pyx_convert_PyObject_string_to_py_std__in_string string.to_py.__pyx_convert_PyUnicode_string_to_py_std__in_string        string.to_py.__pyx_convert_PyStr_string_to_py_std__in_string    string.to_py.__pyx_convert_PyBytes_string_to_py_std__in_string          string.to_py.__pyx_convert_PyByteArray_string_to_py_std__in_string              vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_double_3e___       string.from_py.__pyx_convert_string_from_py_std__in_string      vector.from_py.__pyx_convert_vector_from_py_double      vector.from_py.__pyx_convert_vector_from_py_size_t      pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_double_3e_____and_std_3a__3a_vector_3c_size_t_3e___        vector.from_py.__pyx_convert_vector_from_py_int vector.to_py.__pyx_convert_vector_to_py_unsigned_int    pair.from_py.__pyx_convert_pair_from_py_std_3a__3a_vector_3c_int_3e_____and_std_3a__3a_vector_3c_size_t_3e___   vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_string   vector.from_py.__pyx_convert_vector_from_py_unsigned_int        vector.from_py.__pyx_convert_vector_from_py_std_3a__3a_vector_3c_unsigned_int_3e___ inits       vector.to_py.__pyx_convert_vector_to_py_std_3a__3a_vector_3c_unsigned_int_3e___ __del__ __del__ __del__ __del__ __getstate__    __setstate__    __reduce__      num_failed      test_grad   value   chains  args        mean_pars       mean_lp__       adaptation_info sampler_params  sampler_param_names ,   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.PyStanHolder ,   Allow access to a StanHolder instance from Python

    A PyStanHolder instance wraps a StanHolder instance. When the PyStanHolder
    instance is deleted, the StanHolder instance will be as well.

    There are slight differences between the StanHolder and PyStanHolder. For
    example, chains is an OrderedDict in the PyStanHolder where a StanHolder
    tracks the same information in the fields ``chains`` and ``chain_names``.
    The same holds for ``sampler_params``.
       __getstate__    __setstate__    __reduce__  plot        traceplot       extract __unicode__ ,   summary log_prob        grad_log_prob   get_adaptation_info ,   get_logposterior        get_sampler_params      get_posterior_mean      unconstrain_pars        get_seed        get_inits       get_stancode    get_stanmodel   _verify_has_samples ,   _update_param_oi        _get_param_names        _get_param_fnames_oi    _get_param_names_oi .   _get_param_dims _get_param_dims_oi      constrained_param_names unconstrained_param_names       _call_sampler   flatnames   data        model_name      model_pars      par_dims    mode    inits       stan_args       stanmodel   date                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.StanFit4Model    Holder for results obtained from running a Stan model with data

    Attributes
    ----------
    sim : dict
        Holder for runs. Stores samples in sim['samples']
    data : dict
        Data used to fit model.

    Note
    ----
    The only unexpected difference between PyStan and RStan is this: where RStan
    stores samples for a parameter directly in, say, fit@sim$samples[[1]]$theta,
    in PyStan they are in fit.sim['samples'][0]['chains']['theta'].

    The difference is due to Python lacking a dictionary structure that can also
    have attributes.

       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.__pyx_scope_struct____getstate__ stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.__pyx_scope_struct_1_genexpr .   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.__pyx_scope_struct_2___getstate__                stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.__pyx_scope_struct_3_genexpr ,   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835  __builtin__ ,   cython_runtime  __builtins__    __name__        PyStanHolder    StanFit4Model   type    __builtin__ dtype   numpy       flatiter    numpy       broadcast   numpy       ndarray numpy   ufunc   numpy           init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835 throw       init stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835 1.0 name '%.200s' is not defined            free variable '%s' referenced before assignment in enclosing scope       while calling a Python object   while calling a Python object  NULL result without error in PyObject_Call       while calling a Python object  NULL result without error in PyObject_Call      too many values to unpack (expected %zd)        need more than %zd value%.1s to unpack  at least        at most exactly %.200s() takes %.8s %zd positional argument%.1s (%zd given) 1.0 %s() got multiple values for keyword argument '%s'      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    raise: arg 3 must be a traceback or None        instance exception may not have a separate value        raise: exception class must be a subclass of BaseException      %.200s() keywords must be strings       %.200s() got an unexpected keyword argument '%.200s'    '%.200s' object is unsliceable  Missing type object send        Argument '%.200s' has incorrect type (expected %.200s, got %.200s)      'NoneType' object is not iterable       Missing type object 1.0 Cannot convert %.200s to %.200s cannot import name %.230s       %s (%s:%d)      value too large to convert to int       can't convert negative value to int 1.0 value too large to convert to unsigned int      can't convert negative value to unsigned int    value too large to convert to pystan::stan_args_method_t        can't convert negative value to pystan::stan_args_method_t      value too large to convert to pystan::sampling_algo_t   can't convert negative value to pystan::sampling_algo_t value too large to convert to pystan::sampling_metric_t can't convert negative value to pystan::sampling_metric_t       value too large to convert to pystan::optim_algo_t      can't convert negative value to pystan::optim_algo_t    value too large to convert to pystan::variational_algo_t        can't convert negative value to pystan::variational_algo_t      value too large to convert to size_t    can't convert negative value to size_t  value too large to convert to long      can't convert negative value to long    _cython_0_27_1  Shared Cython type %.200s is not a type object  Shared Cython type %.200s has the wrong size, try recompiling   generator already executing 1.0 can't send non-None value to a just-started generator   generator ignored GeneratorExit __name__ must be set to a string object __qualname__ must be set to a string object [   _cython_coroutine_type  _cython_generator_type  _module __builtins__    Cython module failed to patch module with custom type   if _cython_generator_type is not None:
    try: Generator = _module.Generator
    except AttributeError: pass
    else: Generator.register(_cython_generator_type)
if _cython_coroutine_type is not None:
    try: Coroutine = _module.Coroutine
    except AttributeError: pass
    else: Coroutine.register(_cython_coroutine_type)
  collections.abc collections ,   Cython module failed to register with collections.abc module    Cython module failed to register with collections module        backports_abc           send(arg) -> send 'arg' into generator,
return next yielded value or raise StopIteration.   throw               throw(typ[,val[,tb]]) -> raise exception in generator,
return next yielded value or raise StopIteration.    close       close() -> raise GeneratorExit inside generator.        gi_running      gi_yieldfrom    object being iterated by 'yield from', or None  __name__        name of the generator   __qualname__    qualified name of the generator generator   %d.%d       stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835  compiletime version %s of module '%.100s' does not match runtime version %s ]   %.200s.%.200s is not a type object              %s.%s size changed, may indicate binary incompatibility. Expected %zd, got %zd  %.200s.%.200s has the wrong size, try recompiling. Expected %zd, got %zd        __%.4s__ returned non-%.4s (type %.200s)    long        an integer is required  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)      The binomial coefficient is undefined for k > n, but got k = %1%.       Argument n out of range: got %1%        boost::math::prime<%1%> is not converging       grad_reg_inc_gamma      is not converging       grad_reg_inc_gamma  lp__    user    user        TEST GRADIENT MODE              Sample generated by Stan (Automatic Differentiation Variational Inference)      Sample generated by Stan (Automatic Differentiation Variational Inference)      This is Automatic Differentiation Variational Inference.         procedure.)    (EXPERIMENTAL ALGORITHM: expect frequent updates to the  seconds        Gradient evaluation took         seconds.       1000 iterations under these settings should take        Adjust your expectations accordingly!   lp__    lp__    STAN OPTIMIZATION COMMAND (LBFGS)       init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  #   tol_param =     tol_rel_obj =   tol_rel_grad =  history_size =  seed =  Point Estimate Generated by Stan (LBFGS)        stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj #   tol_rel_grad    history_size    seed    lp__    STAN OPTIMIZATION COMMAND (BFGS)        init =  output =        save_iterations =       init_alpha =    tol_obj =       tol_grad =  =   tol_param =     tol_rel_obj =   tol_rel_grad =  seed =  Point Estimate Generated by Stan (BFGS) stan_version_major      stan_version_minor      stan_version_patch  init        save_iterations init_alpha      tol_obj tol_grad        tol_param       tol_rel_obj #   tol_rel_grad    seed    lp__    STAN OPTIMIZATION COMMAND (Newton)      Point Estimate Generated by Stan (Newton)       stan_version_major      stan_version_minor      stan_version_patch  init    seed    lp__        initial log joint probability =         Iteration       Log joint probability =         . Improved by   Sample generated by Stan        Sample generated by Stan        Must use algorithm="Fixed_param" for model that has no parameters.              Warning: warmup will be skipped for the fixed parameter sampler!        No sampler matching HMC specification!  boost::math::expm1<%1%>(%1%)    boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  Argument to function must be finite but got %1%.        boost::math::cbrt<%1%>(%1%) =   0.003379167095512573896158903121545171688       -0.000322780120964605683831 #   -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228          C:\bld\fbprophet_1508468012784\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_alloc_>(void)       C:\bld\fbprophet_1508468012784\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/exception/detail/exception_ptr.hpp              class boost::exception_ptr __cdecl boost::exception_detail::get_static_exception_object<struct boost::exception_detail::bad_exception_>(void)    Log probability=   error       finite diff model   value       param idx   =   #   =   #   =   #   =   #   =   #   =   #   =   #   =   #       initial log joint probability =                     Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   initial log joint probability =             Iter      log prob        ||dx||      ||grad||       alpha      alpha0  # evals  Notes                                                                      Optimization terminated normally:       Optimization terminated with error:         #   #   #   #   #   )        (Chain     .    is written to file     Sample of chain         Exception initializing step size.       Exception initializing step size.       0.003379167095512573896158903121545171688       -0.000322780120964605683831 1.0 -0.00772758345802133288487      -0.0509990735146777432841       -0.338165134459360935041        0.0834305892146531832907        0.000370900071787748000569      0.00858571925074406212772       0.0875222600142252549554        0.455004033050794024546 0.00180424538297014223957       0.0195049001251218801359        0.0888900368967884466578        0.191003695796775433986 0.178114665841120341155 -0.098090592216281240205        0.337511472483094676155e-5      0.0113385233577001411017        0.12385097467900864233  0.578052804889902404909 1.42628004845511324508  1.84759070983002217845  1.0 1.0 0.000235839115596880717416      0.00323962406290842133584       0.0175679436311802092299        0.04394818964209516296  0.0386540375035707201728        -0.0243500476207698441272       0.00410369723978904575884       0.0563921837420478160373        0.325732924782444448493 0.982403709157920235114 1.53991494948552447182  0.113212406648847561139e-4      0.000250269961544794627958      0.00212825620914618649141       0.00840807615555585383007       0.0137384425896355332126        0.00295276716530971662634       0.000479411269521714493907      0.0105982906484876531489        0.0958492726301061423444        0.442597659481563127003 1.04217814166938418171  1.0 1.0 -2.8175401114513378771  -3.22729451764143718517 -2.5518551727311523996  -0.687717681153649930619        -0.212652252872804219852        0.0175389834052493308818        0.00628057170626964891937       5.48409182238641741584  13.5064170191802889145  22.9367376522880577224  15.930646027911794143   11.0567237927800161565  2.79257750980575282228  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::gamma_p<%1%>(%1%, %1%) 1.0 -0.0020713321167745952  Argument a to the incomplete gamma function must be greater than zero (got a=%1%).              Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   0.9016312093258695918615325266959189453125e-19  -0.045251321448739056   -0.28919126444774784    -0.65031853770896507    -0.32555031186804491    0.25479851061131551 ,   -0.55789841321675513e-6 0.0021284987017821144   0.054151797245674225    0.43593529692665969 %1% 1.4606242909763515      2.0767117023730469      ibeta_derivative<%1%>(%1%,%1%,%1%)              The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).           Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                Argument a to the incomplete gamma function must be greater than zero (got a=%1%).      boost::math::gamma_p_derivative<%1%>(%1%, %1%)          Argument x to the incomplete gamma function must be >= 0 (got x=%1%).   boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::gamma_p_derivative<%1%>(%1%, %1%)  boost::math::digamma<%1%>(%1%)  boost::math::digamma<%1%>(%1%)  normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable  attempts.  :   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization from source failed.      Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Exception initializing step size.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% -0.324588649825948492091e-4 %1% -0.541009869215204396339e-3 :   -0.259453563205438108893e-3 %1% 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 :   -0.223352763208617092964e-6 %1% 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 :   -0.240149820648571559892e-1 %1% -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 ,   0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 nan 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 NAN -0.827193521891290553639e-6 %1% -0.100666795539143372762e-2 :   0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. %1% Result of tgamma is too small to represent. %1% Result of tgamma is denormalized.       Result of tgamma is too large to represent. :   Result of tgamma is too large to represent. %1% Result of incomplete gamma function is too large to represent.  boost::math::detail::full_igamma_prefix<%1%>(%1%, %1%)          The arguments to the beta function must be greater than zero (got a=%1%).       boost::math::beta<%1%>(%1%,%1%) The arguments to the beta function must be greater than zero (got b=%1%).       boost::math::beta<%1%>(%1%,%1%) Unknown function operating on type %1%  Cause unknown   Error in function       Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%)          Parameter x outside the range [0,1] in the incomplete beta function (got x=%1%).                The argument a to the incomplete beta function must be >= zero (got a=%1%). 1.0 The argument b to the incomplete beta function must be >= zero (got b=%1%). 1.0 The arguments a and b to the incomplete beta function cannot both be zero, with x=%1%.          The argument a to the incomplete beta function must be greater than zero (got a=%1%).           The argument b to the incomplete beta function must be greater than zero (got b=%1%).   boost::math::ibeta<%1%>(%1%, %1%, %1%)  boost::math::lgamma<%1%>(%1%)   Evaluation of lgamma at a negative integer %1%. Evaluation of lgamma at %1%.    boost::math::tgamma<%1%>(%1%)   Evaluation of tgamma at a negative integer %1%. Result of tgamma is too large to represent. 1.0 Result of tgamma is too small to represent. 1.0 Result of tgamma is denormalized.       Result of tgamma is too large to represent. )   Result of tgamma is too large to represent. %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Got x = %1%, but we need x >= 0 boost::math::cyl_bessel_i<%1%>(%1%,%1%) Rejecting initial value:          Error evaluating the log probability at the initial value.    Rejecting initial value:          Log probability evaluates to log(0), i.e. negative infinity.    Stan can't start sampling from this initial value.    Rejecting initial value:          Gradient evaluated at the initial value is not finite.          Stan can't start sampling from this initial value.     attempts.  :   ) failed after  Initialization between (-        Try specifying initial values, reducing ranges of constrained values, or reparameterizing the model.   Initialization partially from source failed.    normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable double_exponential_log  Random variable Location parameter      Scale parameter Shape parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable normal_log      Random variable Location parameter      Scale parameter Scale parameter Location parameter      Random variable infinity        INFINITY        Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function       boost::math::ibeta<%1%>(%1%, %1%, %1%) in ibeta_series (with lanczos)   boost::math::ibeta<%1%>(%1%, %1%, %1%)  -0.324588649825948492091e-4 0.0 -0.541009869215204396339e-3 1.0 -0.259453563205438108893e-3 1.0 0.172491608709613993966e-1      0.494103151567532234274e-1      0.25126649619989678683e-1       -0.180355685678449379109e-1 1.0 -0.223352763208617092964e-6 1.0 0.224936291922115757597e-3      0.82130967464889339326e-2       0.988504251128010129477e-1      0.541391432071720958364e0       0.148019669424231326694e1       0.196202987197795200688e1   0.1e1       -0.100346687696279557415e-2 0.0 -0.240149820648571559892e-1 1.0 -0.158413586390692192217e0      -0.406567124211938417342e0      -0.414983358359495381969e0      -0.969117530159521214579e-1 1.0 0.490622454069039543534e-1      0.195768102601107189171e-2      0.577039722690451849648e-1      0.507137738614363510846e0       0.191415588274426679201e1       0.348739585360723852576e1       0.302349829846463038743e1   0.1e1       0.431171342679297331241e-3      -0.850535976868336437746e-2 0.0 0.542809694055053558157e-1      -0.142440390738631274135e0      0.144216267757192309184e0       -0.292329721830270012337e-1 1.0 -0.827193521891290553639e-6 0.0 -0.100666795539143372762e-2 1.0 0.25582797155975869989e-1       -0.220095151814995745555e0      0.846973248876495016101e0       -0.150169356054485044494e1  0.1e1       boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_j_n<%1%>(%1%,%1%)   boost::math::bessel_jn<%1%>(%1%,%1%)    boost::math::bessel_yn<%1%>(%1%,%1%)    Got x = %1%, but x must be > 0, complex result not supported.   boost::math::bessel_y_n<%1%>(%1%,%1%)   -5.2487866627945699800e-18      -1.5982226675653184646e-14      -2.6843448573468483278e-11      -3.0517226450451067446e-08      -2.5172644670688975051e-05      -1.5453977791786851041e-02      -7.0935347449210549190e+00      -2.4125195876041896775e+03      -5.9545626019847898221e+05      -1.0313066708737980747e+08      -1.1912746104985237192e+10      -8.4925101247114157499e+11      -3.2940087627407749166e+13      -5.5050369673018427753e+14      -2.2335582639474375249e+15      -4.8527560179962773045e+03      1.0377081058062166144e+07       -1.2207067397808979846e+10      7.8858692566751002988e+12       -2.2335582639474375245e+15      -9.6090021968656180000e+00      3.1611322818701131207e+01       -2.3517945679239481621e+01      5.5674518371240761397e+00       -4.4700805721174453923e-01      1.3067392038106924055e-02       -2.2210262233306573296e-04      -3.1446690275135491500e+01      8.5539563258012929600e+01       -6.0228002066743340583e+01      1.3982595353892851542e+01       -1.1151759188741312645e+00      3.2547697594819615062e-02       -5.5194330231005480228e-04      -1.9705291802535139930e-19      -6.5245515583151902910e-16      -1.1928788903603238754e-12      -1.4831904935994647675e-09      -1.3466829827635152875e-06      -9.1746443287817501309e-04      -4.7207090827310162436e-01      -1.8225946631657315931e+02      -5.1894091982308017540e+04      -1.0588550724769347106e+07      -1.4828267606612366099e+09      -1.3357437682275493024e+11      -6.9876779648010090070e+12      -1.7732037840791591320e+14      -1.4577180278143463643e+15      -5.1326864679904189920e+03      1.1594225856856884006e+07       -1.4386907088588283434e+10      9.7887501377547640438e+12       -2.9154360556286927285e+15      -6.0437159056137599999e-02      8.5591872901933459000e-01       -1.9746376087200685843e+00      1.3960118277609544334e+00       -3.4198728018058047439e-01      2.9204895411257790122e-02       -8.9359825138577646443e-04      1.4582087408985668208e-05       -3.8806586721556593450e+00      3.2593714889036996297e+00       -8.5017476463217924408e-01      7.4212010813186530069e-02       -2.2835624489492512649e-03      3.7510433111922824643e-05       boost::math::bessel_ik<%1%>(%1%,%1%)            Got x = %1% but real argument x must be non-negative, complex number result not supported.      boost::math::bessel_kn<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.   initialized to invalid value ( Unknown function operating on type %1%  Cause unknown   Error in function       boost::math::expm1<%1%>(%1%)    -1.2117036164593528341e-01      1.0344222815443188943e+02       -3.6629814655107086448e+04      6.6302997904833794242e+06       -6.2140700423540120665e+08      2.7282507878605942706e+10       -4.1298668500990866786e+11      9.3614022392337710626e+02       4.5612696224219938200e+05       1.3985097372263433271e+08       2.6328198300859648632e+10       2.3883787996332290397e+12       4.8591703355916499363e+01       7.4321196680624245801e+02       4.4176707025325087628e+03       1.1725046279757103576e+04       1.0341910641583726701e+04       -7.2879702464464618998e+03      -1.2254078161378989535e+04      -1.8319397969392084011e+03      -2.5258076240801555057e+01      3.3307310774649071172e+02       -2.9458766545509337327e+03      1.8680990008359188352e+04       -8.4055062591169562211e+04      2.4599102262586308984e+05       -3.5783478026152301072e+05      8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04       1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01      9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       2.4048255576957727686e+00       5.5200781102863106496e+00       6.160e+02       -1.42444230422723137837e-03 1.0 1.4130e+03      5.46860286310649596604e-04      -1.0767857011487300348e-02      1.0650724020080236441e+01       -4.4615792982775076130e+03      9.8062904098958257677e+05       -1.1548696764841276794e+08      6.6781041261492395835e+09       -1.4258509801366645672e+11      1.0742272239517380498e+03       5.9117614494174794095e+05       2.0228375140097033958e+08       4.2091902282580133541e+10       4.1868604460820175290e+12       4.6179191852758252278e+00       -7.5023342220781607561e+03      5.0793266148011179143e+06       -1.8113931269860667829e+09      3.5580665670910619166e+11       -3.6658018905416665164e+13      1.6608531731299018674e+15       -1.7527881995806511112e+16      1.3886978985861357615e+03       1.1267125065029138050e+06       6.4872502899596389593e+08       2.7622777286244082666e+11       8.4899346165481429307e+13       1.7128800897135812012e+16       1.7253905888447681194e+18       -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06      -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06      3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04       8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       3.8317059702075123156e+00       7.0155866698156187535e+00       9.810e+02       -3.2527979248768438556e-04      1.7960e+03      -3.8330184381246462950e-05      boost::math::bessel_jy<%1%>(%1%,%1%) in CF1_jy  bessel_yn_small_z<%1%>(%1%,%1%) -1.8402381979244993524e+01      1.0102532948020907590e+04       -2.1287548474401797963e+06      2.0422274357376619816e+08       -8.3716255451260504098e+09      1.0723538782003176831e+11       6.6475986689240190091e+02       2.3889393209447253406e+05       5.5662956624278251596e+07       8.1617187777290363573e+09       5.8873865738997033405e+11       1.7427031242901594547e+01       -1.4566865832663635920e+04      4.6905288611678631510e+06       -6.9590439394619619534e+08      4.3600098638603061642e+10       -5.5107435206722644429e+11      -2.2213976967566192242e+13  1.0 8.3030857612070288823e+02       4.0669982352539552018e+05       1.3960202770986831075e+08       3.4015103849971240096e+10       5.4266824419412347550e+12       4.3386146580707264428e+14       -1.7439661319197499338e+01      2.1363534169313901632e+04       -1.0085539923498211426e+07      2.1958827170518100757e+09       -1.9363051266772083678e+11      -1.2829912364088687306e+11      6.7016641869173237784e+14       -8.0728726905150210443e+15  1.0 8.7903362168128450017e+02       5.3924739209768057030e+05       2.4727219475672302327e+08       8.6926121104209825246e+10       2.2598377924042897629e+13       3.9272425569640309819e+15       3.4563724628846457519e+17       8.8961548424210455236e-01       1.5376201909008354296e+02       3.4806486443249270347e+03       2.1170523380864944322e+04       4.1345386639580765797e+04       2.2779090197304684302e+04   1.0 1.5711159858080893649e+02       3.5028735138235608207e+03       2.1215350561880115730e+04       4.1370412495510416640e+04       2.2779090197304684318e+04       -8.8033303048680751817e-03      -1.2441026745835638459e+00      -2.2300261666214198472e+01      -1.1183429920482737611e+02      -1.8591953644342993800e+02      -8.9226600200800094098e+01  1.0 9.0593769594993125859e+01       1.4887231232283756582e+03       7.2642780169211018836e+03       1.1951131543434613647e+04       5.7105024128512061905e+03       8.9357696627916752158e-01       3.9576784193148578684e+00       7.0860510603017726976e+00       2.280e+02       2.9519662791675215849e-03       1.0130e+03      6.4716931485786837568e-04       1.8140e+03      1.1356030177269762362e-04       boost::math::bessel_y0<%1%>(%1%,%1%)    Got x = %1% but x must be non-negative, complex result not supported.   -3.1714424660046133456e+02      2.2157953222280260820e+05       -5.9157479997408395984e+07      7.2144548214502560419e+09       -3.7595974497819597599e+11      5.4708611716525426053e+12       4.0535726612579544093e+13   1.0 8.2079908168393867438e+02       3.8136470753052572164e+05       1.2250435122182963220e+08       2.7800352738690585613e+10       4.1272286200406461981e+12       3.0737873921079286084e+14       -1.2337180442012953128e+03      1.9153806858264202986e+06       -1.1957961912070617006e+09      3.7453673962438488783e+11       -5.9530713129741981618e+13      4.0686275289804744814e+15       -2.3638408497043134724e+16      -5.6808094574724204577e+18      1.1514276357909013326e+19   1.0 1.2855164849321609336e+03       1.0453748201934079734e+06       6.3550318087088919566e+08       3.0221766852960403645e+11       1.1187010065856971027e+14       3.0837179548112881950e+16       5.6968198822857178911e+18       5.3321844313316185697e+20   0.0 -1.6116166443246101165e+03      -1.0982405543459346727e+05      -1.5235293511811373833e+06      -6.6033732483649391093e+06      -9.9422465050776411957e+06      -4.4357578167941278571e+06  1.0 -1.4550094401904961825e+03      -1.0726385991103820119e+05      -1.5118095066341608816e+06      -6.5853394797230870728e+06      -9.9341243899345856590e+06      -4.4357578167941278568e+06  0.0 3.5265133846636032186e+01       1.7063754290207680021e+03       1.8494262873223866797e+04       6.6178836581270835179e+04       8.5145160675335701966e+04       3.3220913409857223519e+04   1.0 8.6383677696049909675e+02       3.7890229745772202641e+04       4.0029443582266975117e+05       1.4194606696037208929e+06       1.8194580422439972989e+06       7.0871281941028743574e+05       2.1971413260310170351e+00       5.4296810407941351328e+00       5.620e+02       1.8288260310170351490e-03       1.3900e+03      -6.4592058648672279948e-06      Got x == %1%, but x must be > 0, complex result not supported.  bost::math::bessel_y1<%1%>(%1%,%1%) 1.0 boost::math::bessel_ik<%1%>(%1%,%1%) in temme_ik        boost::math::bessel_ik<%1%>(%1%,%1%) in CF2_ik  boost::math::asymptotic_bessel_i_large_x<%1%>(%1%,%1%)  boost::math::bessel_ik<%1%>(%1%,%1%) in CF1_ik  5.8599221412826100000e-04       1.3166052564989571850e-01       1.1999463724910714109e+01       4.6850901201934832188e+02       5.9169059852270512312e+03       2.4708152720399552679e+03       -2.4994418972832303646e+02      2.1312714303849120380e+04       -1.6414452837299064100e+00      -2.9501657892958843865e+02      -1.7984434409411765813e+04      -3.7333769444840079748e+05      -1.6128136304458193998e+06  1.0 -2.5064972445877992730e+02      2.9865713163054025489e+04       -1.6128136304458193998e+06      1.1394980557384778174e+02       3.6832589957340267940e+03       3.1075408980684392399e+04       1.0577068948034021957e+05       1.7398867902565686251e+05       1.5097646353289914539e+05       7.1557062783764037541e+04       1.8321525870183537725e+04       2.3444738764199315021e+03       1.1600249425076035558e+02   1.0 2.0013443064949242491e+02       4.4329628889746408858e+03       3.1474655750295278825e+04       9.7418829762268075784e+04       1.5144644673520157801e+05       1.2689839587977598727e+05       5.8824616785857027752e+04       1.4847228371802360957e+04       1.8821890840982713696e+03       9.2556599177304839811e+01       boost::math::bessel_k0<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported   4.8127070456878442310e-01       9.9991373567429309922e+01       7.1885382604084798576e+03       1.7733324035147015630e+05       7.1938920065420586101e+05       -2.2149374878243304548e+06  1.0 -2.8143915754538725829e+02      3.7264298672067697862e+04       -2.2149374878243304548e+06      -2.2795590826955002390e-01      -5.3103913335180275253e+01      -4.5051623763436087023e+03      -1.4758069205414222471e+05      -1.3531161492785421328e+06  0.0 1.0 1.0 -3.0507151578787595807e+02      4.3117653211351080007e+04       -2.7062322985570842656e+06      6.4257745859173138767e-02       7.5584584631176030810e+00       1.3182609918569941308e+02       8.1094256146537402173e+02       2.3123742209168871550e+03       3.4540675585544584407e+03       2.8590657697910288226e+03       1.3319486433183221990e+03       3.4122953486801312910e+02       4.4137176114230414036e+01       2.2196792496874548962e+00       3.6001069306861518855e+01       3.3031020088765390854e+02       1.2082692316002348638e+03       2.1181000487171943810e+03       1.9448440788918006154e+03       9.6929165726802648634e+02       2.5951223655579051357e+02       3.4552228452758912848e+01       1.7710478032601086579e+00       boost::math::bessel_k1<%1%>(%1%,%1%)            Got x = %1%, but argument x must be non-negative, complex number result not supported.  boost::math::binomial_coefficient<%1%>(unsigned, unsigned)              The binomial coefficient is undefined for k > n, but got k = %1%.       Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1% Unknown function operating on type %1%  Cause unknown: error caused by bad argument with value %1%      Error in function   %1% :   %1%                       "   i
            i
            "   i
         	   ,j
            "   tj
            j
            "   j
            k
            "   Pk
    Pl
    4m
 P                                  +eG?+eG?            "~+@"~+@W6}+W6}+      ?      ?      ?      ?    @.?    @.?ʫy>ʫy>K͉ ?K͉ ?_6.>_6.>~,?~,?9d?9d?t	?t	?       @       @"   w
            (x
            "   `x
            x
            "   ~
            ~
            "   
            Ȃ
            "   
            4
            "   L
            
            "   
            Є
          "   
            
 @          "   d
            ؊
           "   L
            
            "   
            ܋
            "   
            H
            "   `
            
            "   
            
            "   
            
            "   
             
            "   X
            ,
 @         "   ď
            $
            "   \
            0
 @         "   ȑ
            (
            "   
    
    
            "    
            ē
           "   4
            ؔ
           "   H
            
           "   \
             
           "   p
            
 P          "   
            
            "   
            
            "   
             
            "   8
            d
            "   |
            
            "   
            ܙ
            "   
            
            "   0
            X
            "   ؚ
         	   H
           "   
         	    
           "   H
            
           "   
            x
           "   8
            D
 h         "   
    P
    
           "   ,
    
    4
 @         "
   
            ܤ
 P         "   |
             
           "   
            ȧ
          "   l
         &   
 (         "
   
    ,
    ̬
 P         "   t
            
           "   x
            
           "   
            |
           "   
    
 (   \
          
   p   fJ
   
   Ѝ   fJ
     
   @        
   @       !
   @       !
   @       "
   @               "   м
            h
            "
           #
          #
          0$
                  "   м
            h
                    "   м
            h
                    $
      ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   0%
   ~J
   ~J
   P   %
      ~J
      ~J
   ~J
    &
                 bad lexical cast: source type value could not be interpreted as target  bad cast                 '
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   @   x'
   @   ph   -q='
          double  long double             "   м
            Դ
              E@'
@      ?R;{`Zj@     P@X@     @뇇BA    @LPEA    A]v}A    {DA*_{A   qqiA?tA   A补A   pqA&"B   A2 B   iAWLup#B    ACQB        E!jMx?      ?KwP?     P@c3@     @wݳ|@    @P+@    AJ@    {DA`u;^"A   qqiAg8JA   APBkA   pqAJdA   A
'/A   iA#wA    A.NϘ"A        "   м
            ,
                    (
   е   ~J
   ph   ph   ph   ph   ph   )
   е      ph   ph   ph   ph   ph         ?        *
      P   j                `      "   
            T
                    "   м
            
                    "   м
            
            ]        [origin:       *
   ж       h+
   0       +
          bad exception   x,
          bad typeid      X-
   0       vector<T> too long      "   
            Ե
            invalid vector<T> subscript             "   
            
                    "   tl    D
    l
 0                  "   tl    
    Զ
 0                  "   tl    
    <
 0                  "   tl    |
    
 0                  "   tl    
    
 0                  "   tl    L
    t
 0                  "   tl    
    ܸ
 0                  "   tl    
    D
 0                  "   tl    
    
 0                  "   tl    
    
 0                  "   tl    T
    |
 0                  "   tl    
    
 0                  "   tl    $
    L
 0                  -
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
           P.
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
           .
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
   ~J
           but if this warning occurs often then your model may be either severely ill-conditioned or misspecified.        If this warning occurs sporadically, such as for highly constrained variable types like covariance matrices, then the sampler is fine,          Informational Message: The current Metropolis proposal is about to be rejected because of the following issue:  "   
         	   
            Unknown termination code                Line search failed to achieve a sufficient decrease, no more progress can be made       Maximum number of iterations hit, may not be at an optima               Convergence detected: absolute parameter change was below tolerance             Convergence detected: relative gradient magnitude is below tolerance    Convergence detected: gradient norm is below tolerance  Convergence detected: relative change in objective function was below tolerance Convergence detected: absolute change in objective function was below tolerance Successful step completed       -DT!	@Adaptation terminated         ?      @                    @      (@       @      @            P>      <     (@ox?00
      @      @   @   0
      @      @   @   "               
                                             
 
                     	               	               
                                                 ?   =
?   @33?   =
?      ?   ?    ?           @z?   Q?   =
?      ?    ף?   ?   @33?   ?   @33?    ף@   @33@   G
@   @33@   @33@"   м
            ؼ
            kﴑ[?;f?     
   
                 m0_?Q63E?mBP
?        "   м
            D
                          ?      ?       @      @      8@      ^@     @     @     @     &A    KA    A    A   2A   (;L4B  uwsB  uwB  7B  s6C h0{C ZAC Ƶ;(DlYaRwNDΤ5D{zhRlD!a?@)E~tE凗Egi=-FQ[F
-n'F3
VF3
VIGAsb!G3xG]>H޲HH_Tt7IdaIp]IDh,6JHH
Jh9/JLp8;K3KKA
K$sPDL,xL;DL%{RMG#uMc:M)NZ3cN ;N(I_O@5&yOa[fO#L4Pl]öP	'WP~ϸPQ2C3QJ4xRJ4xoR.h2R`>0S
M1 |SaS91KTTmTi3ZMUfyW{Uy>B/ULRBV3q VlF	WĺL/nW	С\dW̼Ws6X픐aXf>~YgY"𤽳Y=t3ZaZyy[r>g[>t0KU[aE6\R*Q\=ٴ]syQp]1"]đ}jA^_tک^Gc׍c_x
b}_4(ȵ_;ϘfQ`ܕN0`@T&Vt%a#aGPÃap
v[fbԒ
Vb0{_>c,$ccCKld ؛8>d/GKZd?0[eϗe- 5fH㴢f/-gq1Ov~g	2c$g!rAYh6h٩c_6i7,&ia(j+*^jzj?@Sbk	k@Al@lcÀ	"m8q.QmnUsnD}Rn#F)Uo.oU;A7p.џ9pMC2q&0}qUjk& r!S͟qr9D}Hɼr8Vs~pso,<t9mtp;vg"uĂHu 9X+vb~}vFv:Udw]rfFNwA,>MxxV&,)5y'wyU zKrJzގ=_]	{Wrq{[v0{h~Gi|hx|;7;U})lgˈ}w<A~C:/~MT /9Adx01
      1
              2
   0       `      P      0      `   p           "   
            
                  "   Խ
            ܽ
                    "   L
    $
 
   t
                    "   
    
 
   D
                    "   
            
                :   "   
            
 0          (       ) must match in size     (  ) and               "   
            D
 0                  3
      P   `      p   n   q   P           3
    p   P   `      p      q   и           4
   	   P   `      p    	   q    	           "   
            D
                    "   
            
                    "   
            
            is      , but must be > 0!      , but must be finite!   "   
            
 0          , but must be greater than or equal to  "   
            
 0                  "   
            T
                    "   
            
                    "
   
            0
 p           seconds (Total)         seconds (Sampling)      seconds (Warm-up)       Elapsed Time:                  5
   `i   ~I
   I
   I
   I
   I
   I
   I
   I
             I
   I
       ?1~ʉʐ|E~Pۆ,̿]g?~vt`2?A<?4`Bkʫ?}
|;¿ȼu??    ?kr	`?[}`?P=x:?/@V;0@{R=a? ZpPT*b!ezFĿp2ڿ2s"\ڿ1i5ϸaƯ?      ?    X?IWUQ{-?f/Ҁ? BN?R?׹^oyd?S?=QAV 1 Lé?]OL?̺?`w"   tl    @
    h
                    "   tl    
    
                    "   
            X
 0          [       "   tl    
    
            `6
   ~J
           "   8
            P
            invalid alignment to 8 bytes, ptr=      uninitialized   "   
            
             and    expecting index to be between    out of range;  index   : accessing element out of range.       ; index position =              "   
            
            ; expression value=     ; dimension size expression=    ; variable=     Found negative dimension size in variable declaration           "   X
            
 p                     term_buffer =                   adapt_window =                  init_buffer =                 Defaulting to a 15%/75%/10% partition, ?333333?         overflow the total number of warmup iterations.                WARNING: The initial buffer, adaptation window, and terminal buffer              performed for num_warmup < 20   estimation is  WARNING: No           Y@ =  ,   "   4
            <
                    "   h
            p
                    "   
            
                    "   м
            
                    "   м
            
                    "   м
            (
                    "   T
            \
            6
       7
               "   tl    
    
                    "   
            
 0                  "   <
            L
            (9
    (   p8
   @       @:
   f      )   :
    )   P9
           , but must not be nan!  , but must be >= 0!     h:
   )        ;
   @   P7      P7   ;
   @   P7      P7   <
   @   P7      P7   has dimension =         multidimensional values of the same shape.      consistently sized;  all arguments must be scalars or   scalar, array, vector, or matrix types, and they were not       ; a function was called with arguments of different     , expecting dimension =         "   
            
 0                  "   
            
 0              d?Eĵ@oI+@P	6@"ܢ}/@^ʥ
&@`I2W@DNxR	x3j濍4c08˿ą@?A!y?    dL?      @[sS/k??~}?rJ󓉸?0"S?7¬?O~x>2Lf0?kFoa?@8?Ų"?Zf0h?      @    7?HS 	p?رo߬??Io?Ж}?/ēr.?Mj?DbjT?u`v`?TEvʣ?:8      @    ?H P>ئ8?ҍ?Uh?0?^бF?{]?i?tiY?K_n!r?\v?7<
w   @33@      <@    ?oN8?S(c?ng?`<?,7Z'5ICcaI`տж)[?      ?#6k?|="   
            
 0                  "   
            
                    "   tl    d
    
                    "   
            
 0                  "   (
            
            <
   <   <
   <   fJ
   <
   <   fJ
           "   (
            D
            =
   =   =
          "   
            
                    "   
            
                    "   м
            
                    "   м
            
            >
   f   @   A   x>
   A   =
          ?
   pf   0   B   ?
   B   fJ
   >
      @
    g       @C   @
   0C   fJ
   ?
       A
   f      PD   xA
   `D   @
   @       ^^^^^^ܿYY|?qAAp?UUUUUU?    ?   n?=  @cb?HO

oa?,aȹ?6(]?0ɗ^?AMg @7%l`x<rc.+ҿZ)nh/AԿxIiN?e;"   X
    0
    p
                    "   
            
 0          []      "   
            (
 0                  "   
    p
    
                    "   
            
            B
   X   A
   P      "   м
            @
            C
   f      Z   C
   pZ   B
         size of         C
   `i   ~I
   I
   I
   I
   I
   I
   I
   I
             I
   I
   ?      .@{T4bU@
+/NW+@HM%;KZr?a7	Bu?u"7#?@&p7*E@wǛܿ&-DٔÊ?39e0!cAg?IBx.ȼ٥m4XL.Q$]WsAb`CF:ey_b
٢+8 ,"zYǣp0ih8vJU;È[1
@Y?4뿡i?6+Ab\ƖG?7pc?,xV?_տZ?:ղ>GHM]!_k;>fAδ>6
)%$Ç5=ΡB)r
@.ցǼ]?t	${?N`Ch6޿
NMfV|O102dQ*Cv=?	h@k}}Sų()%a5"   
            
 0                  "   (
            
            D
   z   XD
          "   <
            T
            E
   `{   E
          F
   f       p|   F
   |   E
          G
   f      }   xG
   }   F
                 @      p?E6`     @JQ5     @Pr@	ouU@{@@ZG@FLHnAC&kĨ5A
B;AžѠ%A.A@wp@6Ґ@
b-(@M @O:8@u	2/Ʋ7wȳYXzbqw.`b YI?76O0Y)МbZFtP,811AMʲ@{aUA7oTPB[MBbzsFmNCZCRοx@MUNXG`SAF1TBU·J
&C3"OUFeȐ@5J
"AK5A)꾙#B$vBMu
TLm+M%@ÈIc⃼A)*-ANՎ]@"   <
            l
            `H
      G
           "   м
            
                    "   м
            
            XI
   f          0I
   0   H
          I
                  _+^kH?g@?S%xey?J@?;P
?M&:|?v|?2wSW?b2T'ǟ?E-?Mkodx?Ico?,[?        $<l??QԵ?jc/?vu?c?Gk
?KI?w?Ny?ᇝ ?x?Ẽ?        "   (
            8
            J
              "   м
            l
                    "   м
            
             K
   f      p   J
      8J
   0       "   
            $
            Expecting a square matrix; rows of      columns of      "   
            
 0          ]=      is not lower triangular;        "   
            0
 0          lb_free Lower bounded variable          "   `
            h
               "   
            
           Number of posterior samples for output  Evaluate ELBO at every eval_elbo iteration      Number of Monte Carlo samples for ELBO  Number of Monte Carlo samples for gradients     stan::variational::advi "   $
            4
                  $@"   
    
    
                    "   `
            0
                    "   X
            `
                    "   X
            
               "   `
            
                    "   
            
                    "   
            $
                   "   l
            |
                    "   l
            
                    "   
            
                   "   @
            P
                    "   
            
                    "   
            
               "    
            
                    "   H
            X
                    "   
            
                    "   
             
                    "   H
     
    p
                    "   
            
                    "   
            
 0                  "   `
            `
                    "   `
            
                    "   
            
                   "   
             
                   "   P
            `
                    "   
            
                  ?ȅeA?     @&GVW     @@E.,[@@.=@/R V@hcjzB@,G`@ N@Nj֐W@
z=4L6}(e[ NV` l=gW/7c@14=]@)3M3@oַ@Zw?ub8c@L1@t@WY_,0@t>@1Ds+t@HB9M_L\?>@%_ qwV.8Ao+#LKH@1%9@xB)A@~@>F2@4bwI+1
  Z,h-A@VA!q髠AHps!BՉp³`BfTO)QwMY@!|l!hBGJYA(z-	X"   `
            `
                    "   
            
                    "   
            
                    "   
            4
                   "   
            
                    "   `
            T
                    "   
            
                    "   
            
                   "   (
            8
                    "   p
            
                    "
   
            X
           ; position=     mismatch in dimension declared and found in context     ; dims found=   ; dims declared=        mismatch in number dimensions declared and found in context     ; base type=    ; variable name=        ; processing stage=     variable does not exist int variable contained non-int values   int     dot_product v2  v1      (K
   
           "   
    
    
                    "   @
            X
                    "   
            
                    "   
            
                    "   T
            
                    "   4
            
                   "   d
            
                   "   tl    
    4
                    "   T
            t
                    "   
            
                    "   
            
                    "   T
            \
                 @@      @      @      @      ?      ?        "   T
            
                    "   L
            T
                    "   
            
                  "   T
            0
                    "   T
            X
                    "   T
            
                    "   tl    
    
                    "   T
            h
                    "   
            
                   "   
            
                   "   
            t
                    "   
            
            K
   C   @E   ph           "   0
            H
            L
   C   @E   ph           "   
            
            Mean vector     Dimension of input vector       Dimension of current vector     Dimension of mean vector        Dimension of Cholesky factor    Cholesky factor         L
   ph   ph   pm   ph   ph   ph   ph   ph   ph   n           "   
             
            vector provided does not match the parameter length     "   
    t
    
                    "   
    
 
   
                    "   
    
    
 H                  "   
    
 
   
                    "   
    t
 
   
                    "   $
            T
                    "   
            $
                    "   $
            p
                    "   Hz            
                    M
       ~J
   ph   ph   `   @          0   "   D             
            Step size =             "   tl    X
    
 0                  "   
            
                    "   
            
                    "   
            
                    "   |
    T
    
                    "   
            
 p                  "   4             <                     "             	                       "   
                                 "   
            p                    "   
                                "   t    L     0                  "   
                                "   tl                            "   tl    D    l 0                  "   tl                            "   tl    L    t 0                  M
            p   `   @          0    N
   @         p   `   @          0   P           "                                   N
      p	      p      @          P   "   D                                 O
   p   	            @          P   P           P
      @	            @       Х      "   D            T                    P
      	      `      @       Ц      P           "   
     
    0                  "   \            t            circular_buffer         "                                   "            8                    "                                   C:\bld\fbprophet_1508468012784\_b_env\lib\site-packages\pystan\stan\src\stan/io/reader.hpp      class stan::math::var __cdecl stan::io::reader<class stan::math::var>::scalar(void)     no more scalars to read "               	            double __cdecl stan::io::reader<double>::scalar(void)   "   	    d	    	                    "    
         	   8
                   "   
            
 p                  "   tl        @ 0                  "    
         	              numeric overflow        "   tl         0          Value %1% can not be represented in the target integer type.            "                `                  "                `                  "               
 0                  "               ( 0          xQ
               "                0                  "                                   "                                   "
   \             `           is needed.      is found, but  array is not long enough for all elements:              C:\bld\fbprophet_1508468012784\_b_env\lib\site-packages\pystan\stan\src\stan/io/array_var_context.hpp           void __cdecl stan::io::array_var_context::validate<double>(const class std::vector<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >,class std::allocator<class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > > > &,const class std::vector<double,class std::allocator<double> > &,const class std::vector<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> >,class std::allocator<class std::vector<unsigned __int64,class std::allocator<unsigned __int64> > > > &)   ).  should be no smaller than number of parameters (found   )       size of vector of dimensions (found             Q
            p   `   @          0   energy__        int_time__      stepsize__      R
   @         p   `   @          0   P   divergent__     n_leapfrog__    treedepth__             "                                   "                           T
         S
        	      p   `   @          0   (U
                 0T
   0    	      p   `   @          0   P           "   y                        W
         PU
       n	      p      @          P   "   y                        X
         0W
      0o	            @          P   P           "               ,            HZ
         X
      p	            @       Х      "                           [
         pZ
   @   @q	      `      @       Ц      P           "               $                    "       p                        "   0            8            Overflow Error          "   l            t               6s?D?    ͜?{>MA?      ?Dݿf2	A?ʇƅȏD?{    ͜Vph?4W'ђ
cՇ?MA6;
>boost::math::erf<%1%>(%1%, %1%) boost::math::erfc<%1%>(%1%, %1%)              @!?     X@i4E?     @=Ը.h?     l@!X@VMS@Ը.?t AmqDx@3q&zA5X3=4BIB~Ӝ+C+/CD뤍p1o}/@L}<cn[P\AD
F
C9=£:CM%<<w@=JKAskPA-խBTB
胩BϚnsfQm1@_7QADT4jM$B?gx	`144o5Ƅ@cto)
AdˊA
q"aB"gAd[ag2"7D@yxl=@M/")8B%/bXAa۾     @!]?     @.N@CԾ@m@c/ALyo&AfdQBmbgoB5c[CvACt<DQ9=AFFFUB@ͷ1I/-U,CeawTïT]Cd@FAO'|5A)ÊB+EhBxBNsA?_5[A\At<U,o"B@4W=A1nBdAMi@OP@$@̴F@钳|A0U&@@<I;@	Ch@O'R#W@OQ|\@Ƭ@
R,X@@ n%=APnAT)Qx@jۧa@f\( ]@P@Topvm*@<!\C'"]I{f)DCprd
8`6>o}'-@c03C?@?I'@$H}@إ@9VkM@	# B@4t@<r@93@7V`c@gPUJ@n28p@z86V?BlFA@2s?
;@:goz`@b]W@O♿@"@!V@
o'iϔ@,Su@#1@4F@3!$sX7&D}
@Ny-Ϳ<MJr~)X7&4Sq`	2@T)#?rX@'#oˉ@?d=쩥A%f:%Aq@        "                          boost::math::trunc<%1%>(%1%)    boost::math::expm1<%1%>(%1%)            "   
                                "   
                                "
               l                    "                           \
   @   P<   0]
   @   <           "   ,            P                    "                           ]
   @   >   "                                   "                           ^
   @    A   _
   @    A   _
   @   @A   "   ,            4            #B;      C        "   d            l             `
   @   B   "                           accept_stat__   lp__    "            	               g_  p_  "O   D    |     H         Error transforming variable beta:       Error transforming variable sigma_obs:  Error transforming variable delta:      Error transforming variable m:  Error transforming variable k:  variable beta missing   beta    variable sigma_obs missing      sigma_obs       variable delta missing  delta   variable m missing  m   initialization  variable k missing  k   :0yE>        "   h"            " 0                  "
   "            T# H          gamma   "   $            $ (                  "   L%            \% 0          invalid map/set<T> iterator             "   D&    &    \& 8                  "   &    &     ' 8                  "   '            '                    "   '            '                    "   '            (                    "   $)    (     ) X         t_change                "   *            +                   "   `+         	   +                    "	   +            8,                   "   -    , 	   8- (          Evaluation of function at pole %1%      "   -            P. 8                  "               .                    "   .            / P                  "   h/            p/                    "   /         
   0                   "   0            0                    "   0            0                    "   \2            41                    "   1            1            stan::variational::normal_fullrank      "   1            2                    "   \2            t2                    "   2            2                    "   ,3            L3 0          Log std vector  Dimension of log std vector     stan::variational::normal_meanfield     "   3            3                    "   3         
   $4                    "   4    4    4 0                  "   tl    x5    5 0                  "               5 0          map/set<T> too long     "   tl    <6    d6 0                  "               6 0          log1p<%1%>(%1%) log1p(x) requires x > -1, but got x = %1%.              "   L7            d7                    "   7            7                    "   tl    ,8    T8 0                  "   D9            T9                   "   p:            : @                  "   ;    h; 	   ; (                  "%   <    X<    =          Y   X   t   A           "   >            >            `
   @      "   D?            d?             
   >"   ?            ?            boost::math::digamma<%1%>(%1%)  boost::math::itrunc<%1%>(%1%)           A        "   ,@         
   T@                   "   @            @              A?ￜ?sq￙+?zl?uS:,Q?歬*4ￇ?m0~UmaR?beώ?.Z<ؿ2?Bj/F33 ~?YtLr4l̦9?        "   2            TB            stan::variational::set_mu       stan::variational::set_L_chol   Dimension of lhs        Dimension of rhs        stan::variational::normal_fullrank::operator=   stan::variational::normal_fullrank::operator+=  stan::variational::normal_fullrank::operator/=  Input vector    stan::variational::normal_meanfield::set_mu     stan::variational::normal_meanfield::set_omega  stan::variational::normal_meanfield::operator=  stan::variational::normal_meanfield::operator+= stan::variational::normal_meanfield::operator/=         "   dC    <C    |C 0                  "	   E            D 0                 "	   E            E 0                 "	   E            F 0                 "   G            G                   "   8H            @H @                  "   H            H                        @e@-DT!	      4        gf
@AmG|@^	@b@s@n^@y&ԝ'@h@@s~@)R@@kE@Cma@u=@H@9@!7:Oi@X^r)@Tu	M@Z@}]+{@12kz1F@kӍ@uB@HsK@d@WPEmS@ w'@͕M> @Ċ( @Yި @> @!Y @6z2 @3 @ʲ?z1?E=?}?H.?
[Il?61(?}9	?<Ky?yWRb?Ǖ"?1_?N?]Me?S(?yq?~EM?U]9r?*Iu6?B{?`?QGp?E}L?ʗ|?j؜?s?bLg?g/?dW7N?Q?'?' HHO?if!r?u:?@h?*$Xr?'M;?NP?
kB?#U?C$_?)?8vM
?Dd?H܃?jGL?Xf E?X9?_t2T?Kw9n?r	$6?8?S[~d8?FtT?FqS?w4?_}?uc6?#bj?l/?[I75?z+IǶ?EEy?+K<?-?*oEX?nryG~?sN=?0?jp?\TH?#D	i]?t?kl
4??3hV?I?DO|zx?gP?
4?r\?gЩ?^X"?d`c?d?<!{?nۯ?xML?/h?:k?STk?BY6?08nW?;L?:I9?2}m?              >      >"   I            I `                  "   DJ            TJ             a
   C   @E   y           "   J            J H          ,       Diagonal elements of inverse mass matrix:       a
   ph   ph   z   ph   ph   ph   ph   ph   ph   |           "   K         	   0K             b
   @~           "   K    K    K                    "   `L    8L    xL                    "   M    M    (N H                  "   Hz             O                    b
      ~J
   ph   ph      @          P   "   O    TO (   P          Undefined transformed parameter: gamma  "   PR     R &   0S                Pboost::math::tgamma<%1%>(%1%)   "   y            T            boost::math::lgamma<%1%>(%1%)           "   U         	   ,U 0                  C:\bld\fbprophet_1508468012784\_b_env\lib\site-packages\pystan\stan\lib\stan_math_2.14.0\lib\boost_1.62.0\boost/math/special_functions/owens_t.hpp              long double __cdecl boost::math::detail::owens_t_dispatch<long double,struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy>>(const long double,const long double,const long double,const struct boost::math::policies::policy<struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy,struct boost::math::policies::default_policy> &,const struct boost::mpl::int_<64> &) selection routine in Owen's T function failed                         "   h"            U                   "   tl     V    (V 0                  "   V            V @                  "   
            W                    "   8W            XW                    "   <X            W                    "   <X            \X                    "   X            X            b
      covariance      Pc
         "   X            X            xc
      variance         d
         "   Y            <Y                    "   Y            Y                    "   Y            Z                    "   Y            dZ            (d
   Y           "   Z            Z                    d
   ph   ph   P   ph   ph   ph   ph   ph   ph   P           "   
            $[                    "   d[            t[                    "   [            [                    (e
                       0      P   P[           "   \\         
   \                    "   \         
   0]                    "   
            ]                    "   @^         
   ]                   "   @^         
   x^                   "   tl    ^     _ 0                  "   _    _    ` H                  "S   `    `    |c          tau     vector_d    sigmas  S   y   K   data initialization T           anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace::anon_model_1988b9d517e3c16daf27a07f09e3de97              "   h    xh 
   h @                  "   ti    Li 
   i @                  "   Hj     j    pj 0                  "   $k    j    Lk 0                  "   k            k                    "   tl    Ll    l 0          Non-finite function evaluation. Error evaluating model log probability:         Error evaluating model log probability: Non-finite gradient.            "
   l            Lm                  "   @n            `n           UUUUUU?UUUUUUUUUUUU?UUUUUUMb`?MbP?MbPMb`Mb@?        1s3e?-v?)?K??keG?|G	?/֩??2^WO?IX?89?]%?Z?ܤ?Ÿ ݦ?<H?N{8?k:c??6-?	?S!\?W44ز?0mx?e${)?Ƙi6?*@֫\?Uo?W9{?={q?j?ZbG?HV?ƵD?W1|?5ar^?CZl?$va??]Eީ
?T۪T?XV5??PP:JYU?Q+?ꀲ?{]Zc?-z?9?j
?g6?ٯ?CKר?-~d?o!?]Y?u3?Vb`1?uۓ?"?SZ?3\پ? ~>$?FA?G?/IY?e܏?i,?zƊ?i7q?tzBp?U0?wL?FMͻ?$-?:?.?e>)??9hr?1Ԟ?nb?{q?qpCX?k?cR?2	
?%R?kYK ?.W?u}?b?nQ?J0X:?j?\*?6?IiiV?bu9?4-?}Cb~5?8ӥ??]V?jWn?͕Tt?yeI?,Q\f?Fm|?َ?dJk?'JӖ?Z"#?/?*j?@ME?;fo?RR ?Ϩa??0a?J?AU?]'P?bB`?4h?{??jHO7?7?D?      ?{Gz?      ?        "   @o            Ho P                  "	   o            4p                    e
   I   R   S   D   `S   E   F    G   PH   "   p            p            (f
   C   @E    K           "   @q         	   `q H          Elements of inverse mass matrix:              @        "   r            4r                   f
   I   R   S   D   `S   E   F    G   PH   "   r            r                    "   s            s P          stan::variational::normal_meanfield::transform          "   Hs            Xs                    "   s            s                    "
   `t            t                    "   Xu         
   u                    "   u            v                    "   dv         	   v h                  "	   v            @w            vs     Number of unconstrained parameters does not match that of the model (           "	    x            hx                   "   y            y                    "   Dy            Ty                    (g
      p	      p      @          P   Pg
   p   	            @          P   P           "   y            y                    "   y            y                    "   
            z            Error evaluating initial BFGS point.    "   Hz            Pz                    xg
    v   ~J
   ph   ph      @       Ц      q=
ףp?        "   z            ,{                   "   {    { 
   |                    "   |            |           ؗҜ<"   tl    }    0} 0                  "   x}            }                   "   ,~            4~                    "   d~            ~                    "   Բ                        boost::math::owens_t<%1%>(%1%,%1%)      "   (            H `                  "            X          Scale parameter Location parameter      normal_rng      "                                 @      ?        "   D     "    0                  "            8                   "   ̄             `                  "   l                                "   Ѕ                                "   \            t                   "                                  g
      @	            @       Х      g
      	      `      @       Ц      P           "                                   "                                    "   tl    \     0                  "   Բ                                "   l    D              The number of dropped evaluations       has reached its maximum amount (                ). Your model may be either severely ill-conditioned or misspecified.   Gradient of mu  Dimension of variables in model Dimension of elbo_grad  Dimension of variational q      stan::variational::normal_meanfield::calc_grad  "               |                    "*   Ќ     M                      "                                   "            
                filter is looking for elements out of range             "                                   "               t                    "                                   "       p     `          log_prob        stan::variational::advi::calc_ELBO      stan::variational::advi::calc_ELBO_grad         "   $            d p          Posterior is improper. Please check your model.         No acceptably small step size could be found. Perhaps the posterior is not continuous?  ?    cA        "            P p                  "                                   "                0                  "
   T                               "                0                  "
   T                              "                0                  "
   T                              "   ̛    T ,   t P                 Cannot compute ELBO using the initial variational distribution. Your model may be either severely ill-conditioned or misspecified.      All proposed step-sizes failed. Your model may be either severely ill-conditioned or misspecified.  ].  .        earlier than expected.  Found best value [eta =        Success!        ?Begin eta adaptation.   Number of adaptation iterations stan::variational::advi::adapt_eta      "             )   Ȟ                  This variational approximation is not guaranteed to be meaningful.              Informational Message: The maximum number of iterations is reached! The algorithm may not have converged.       This variational approximation may not have converged to a good optimum.        Informational Message: The ELBO at a previous iteration is larger than the ELBO upon convergence!       ?   MAY BE DIVERGING... INSPECT ELBO        MEDIAN ELBO CONVERGED           MEAN ELBO CONVERGED       @@          iter       ELBO   delta_ELBO_mean   delta_ELBO_med   notes    Begin stochastic gradient ascent.       Maximum iterations      Relative objective function tolerance   Eta stepsize    stan::variational::advi::stochastic_gradient_ascent     "
   $         	   t                    "   tl                            "   $             p                  "   $            L p                  "9   آ         Q                     "       h 
                       "   h    @ 
                       "                                   "       h 
                       "   h    @ 
                       "   @     
   `                    "        
   8                    "   $
            Ԭ                    "   @                      COMPLETED.       from the approximate posterior...      Drawing a sample of size    eta =       Stepsize adaptation complete.   iter,time_in_seconds,ELBO               "                x 0                  "                 0                  "                Ԯ 0                  "                 0                  "   h            x `          LS failed, Hessian reset        )\(?"   ԯ            ܯ                    "                ( X                 "   l            t                   "                                   "                                  "   4            D 0          stan::variational::normal_fullrank::transform           "   |                                "	   ȱ             h                  "   Բ            ܲ                    "   T    ,    ̳          stan::variational::normal_fullrank::calc_grad           "   '                                "                                   "   x    P     `                  "   4         
   d                   "   ,            4                   "        ,    p                 "   P         )                     "   h            l `                  "               T                   "	   ȱ            8 h                  "                                   "   Բ            4                    "               ̿                    "                (                  "   L            \                    "                                   "       \              }Ô%IJz5        "               $                  "                0          Something went wrong after call_sampler.        -DT!@"   4            <                    "   d            l                    "                                   "                                   "                                   "   $            ,            g
   I
                      k 
 
                            
         
 0
                 k            @   
             k             @   X
                        p
         0
                        k 
 
                            
         
 0
                 k            @   
                         l ( 
   
                            @ 
         X 
 0
                  l            @   ( 
                        Hl  
  
                             
          
 X 
 0
                     Hl            @    
                        pl 0!
 !
                            H!
         h!
 X 
 0
                     pl            @   0!
                        l !
 !
                            !
         !
 X 
 0
                     l            @   !
                        l @"
 "
                            X"
         x"
 X 
 0
                     l            @   @"
                        l "
 "
                            "
         "
 0
                 l            @   "
                        m H#
  #
                            `#
         #
 "
 0
                     m            @   H#
                        Hm #
 #
                            #
         $
 "
 0
                     Hm            @   #
                        xm X$
 0$
                            p$
         $
 "
 0
                     xm            @   X$
                        m $
 $
                            $
         %
             m             @   $
                        m X%
 0%
                            p%
         %
             m             @   X%
                        n %
 %
                            %
         %
             n             @   %
                        @n H&
  &
                            `&
         &
 &
 0
                     @n            @   H&
             pn            @   &
                        &
         &
 0
                            n ('
  '
                            @'
         P'
             n             @   ('
                        n '
 x'
                            '
         '
             n             @   '
                        o (
 '
                            0(
         P(
 "
 0
                     o            @   (
                        (
         (
             @o             @   x(
                        po (
 (
                            )
         )
             po             @   (
                        X)
         h)
             o             @   @)
                        o )
 )
                            )
         )
 )
                 o            @   )
                        p 8*
 *
                            P*
         h*
 %
                 p            @   8*
                        *
         *
             p             @   *
                         q +
 *
                             +
         @+
 
 0
                      q            @   +
                        pq +
 h+
                            +
         +
 &
 0
                     pq            @   +
                        q ,
 +
                            0,
         P,
 
 0
                     q            @   ,
                        r ,
 x,
                            ,
         ,
  -
 0
                     r            @   ,
             @p            @   (-
                        @-
          -
 0
                            `r -
 X-
                            -
         -
 0
                 `r            @   -
                        r  .
 -
                            .
         (.
             r             @    .
                        t x.
 P.
                            .
         .
             t             @   x.
                        pu .
 .
                            /
         /
             pu             @   .
                        X/
         h/
             v             @   @/
                        /
         /
             0x             @   /
                        /
         0
             y             @   /
                        z X0
 00
                            p0
         0
 %
                 z            @   X0
                        { 0
 0
                            0
         1
 %
                 {            @   0
                        | X1
 01
                            p1
         1
 h)
                 |            @   X1
                        @| 1
 1
                            1
         2
 h)
                 @|            @   1
                        H2
         `2
 (
                 x|            @   02
                        | 2
 2
                            2
         2
 P'
                 |            @   2
                        } 03
 3
                            H3
         `3
 (.
                 }            @   03
                        P~ 3
 3
                            3
         3
 .
                 P~            @   3
                         04
 4
                            H4
         `4
 /
                             @   04
                        4
         4
 h/
                 Ѐ            @   4
                        4
         5
 /
                 0            @   4
                        P5
         h5
 0
                             @   85
                        @ 5
 5
                            5
         5
 6
                 @            @   5
                          @   86
                        P6
         6
                         6
 `6
                            6
         6
                          @   6
                           7
 6
                           7
         @7
 6
 h7
 7
                                      @    7
             k    (       @   
             k     (       @   X
                        X 7
 7
                           7
          8
 6
 H8
 7
                         X            @   7
             k    (       @   
                         8
 p8
                           8
         8
 "
 0
  9
                                     @   8
                  @       @   6
                @        8
 (9
                              x9
 P9
                           9
         9
 8
 "
 0
  9
 9
                                              @   x9
             m         h      P   X%
                @         x9
 :
                    x        x9
 @:
                             :
 h:
                           :
         :
 h!
 X 
 0
  9
                                         @   :
                          (;
  ;
                            @;
         `;
 4
 h/
                                  @   (;
                        ` ;
 ;
                            ;
         ;
 5
 /
                     `            @   ;
                         8<
 <
                            P<
         p<
 h5
 0
                                 @   8<
                @        :
 <
                    (          7
 <
                    (       X 7
 <
                              8=
 =
                           P=
         =
 !
 X 
 0
  9
                                          @   8=
                @         8=
 =
                             =
 =
                           >
         P>
 :
 h!
 X 
 0
  9
 9
                                                 @   =
                @        =
 x>
                    x       =
 >
                             >
 >
                           ?
         @?
 @7
 6
 h7
 7
 h?
                                             @   >
             m         @      P   X%
                (        >
 ?
                    P       >
 ?
                            p @
 ?
                            @
         X@
  8
 6
 H8
 7
 h?
                                 p            @   @
                (       p @
 @
                    P      p @
 @
                             @
 @
                           A
         PA
 =
 !
 X 
 0
  9
 9
                                                 @   @
                @        @
 xA
                    x       @
 A
                            ` A
 A
                           B
         8B
 &
 &
 0
 `B
                             `            @   A
                  (       @   6
                (       ` A
 B
                             B
 B
                           B
         0C
 8B
 &
 &
 0
 `B
 XC
                                                 @   B
             m         P      P   X%
                (        B
 C
                    `       B
 C
                            P C
 C
                            D
         0D
 5
 6
                     P            @   C
                         D
 XD
                           D
         D
  
 X 
 0
  9
                                         @   D
                @        D
 D
                              @E
 E
                           XE
         E
 #
 "
 0
  9
                                          @   @E
                @         @E
 E
                              F
 E
                           F
         XF
 D
  
 X 
 0
  9
 9
                                                 @    F
                @         F
 F
                    x        F
 F
                              F
 F
                           G
         PG
 E
 #
 "
 0
  9
 9
                                                  @   F
                @         F
 xG
                    x        F
 G
                             G
 G
                           H
         8H
 P(
 "
 0
  9
                                         @   G
                @        G
 `H
                             H
 H
                           H
         I
 8H
 P(
 "
 0
  9
 9
                                                 @   H
                @        H
 0I
                    x       H
 XI
                            p I
 I
                           I
         I
 X 
 0
  9
                         p            @   I
                @       p I
 J
                            С `J
 8J
                           xJ
         J
 I
 X 
 0
  9
 9
                                 С            @   `J
                @       С `J
 J
                    x      С `J
  K
                             PK
 (K
                            hK
         xK
                          @   PK
                         K
 K
                            K
         K
                          @   K
                        H @L
 L
                            XL
         pL
 K
                 H            @   @L
                        x L
 L
                            L
         L
 P'
                 x            @   L
                         @M
 M
                            XM
         pM
 )
                             @   @M
                         M
 M
                            M
         M
 pM
 )
                                 @   M
                         HN
  N
                            `N
         N
 pM
 )
                                 @   HN
                         N
 N
                            N
         O
 0O
 )
                                 @   N
             `            @   XO
                        pO
         0O
 )
                            Ъ O
 O
                            O
         O
 0O
 )
                     Ъ            @   O
                        @ 8P
 P
                            PP
         pP
 P
 )
                     @            @   8P
                         @   P
                        P
         P
 )
                              Q
 P
                            0Q
         PQ
 P
 )
                                  @   Q
                         Q
 xQ
                            Q
         Q
                          @   Q
                         R
 Q
                            0R
         XR
 M
 pM
 )
                                     @   R
                        0 R
 R
                            R
         R
 N
 pM
 )
                         0            @   R
                         8S
 S
                           PS
         S
 XR
 M
 pM
 )
 S
 S
                                                 @   8S
             x|           @   02
             @o            @   x(
                        8S
 T
                            Ѝ XT
 0T
                           pT
         T
 R
 N
 pM
 )
 T
  U
                                     Ѝ            @   XT
             x|           @   02
             @o            @   x(
                       Ѝ XT
 (U
                             xU
 PU
                           U
         U
 U
 O
 0O
 )
 `V
 V
                                                 @   xU
             p            @    V
                        8V
         U
 O
 0O
 )
                         (           @   V
                        V
         V
 (
                 (            @   V
             @o            @   x(
                        xU
 W
                            ` XW
 0W
                           pW
         W
 W
 O
 0O
 )
 @X
 hX
                                     `            @   XW
                         @    X
                        X
         W
 O
 0O
 )
                         (           @   V
             @o            @   x(
                       ` XW
 X
                             X
 X
                           X
         8Y
 `Y
 pP
 P
 )
 Y
 hX
                                                 @   X
                         @   Y
                        Y
         `Y
 pP
 P
 )
                         `           @   Y
                        Z
          Z
 (
                 `            @   Y
                        X
 HZ
                             Z
 pZ
                           Z
         Z
 [
 PQ
 P
 )
 [
 [
                                                 @   Z
             @            @   @[
                        X[
         [
 PQ
 P
 )
                         `           @   Y
             @o            @   x(
                        Z
 [
                            \
         (\
 '
                             @   [
                        h\
         \
 '
                             @   P\
                         \
 \
                            \
         ]
 (\
 '
                                 @   \
                        P X]
 0]
                            p]
         ]
 \
 '
                     P            @   X]
                         ]
 ]
                            ]
         ^
 \
 '
                                 @   ]
                        X^
         p^
 '
                 в            @   @^
                          ^
 ^
                            ^
         ^
 '
                              @   ^
                        8 @_
 _
                            X_
         p_
 '
                 8            @   @_
                        x _
 _
                            _
         _
 p^
 '
                     x            @   _
                         H`
  `
                            ``
         x`
 '
                             @   H`
                        P `
 `
                            `
         `
 '
                 P            @   `
                          Ha
  a
                            `a
         xa
 K
                              @   Ha
                        0 a
 a
                            a
         a
 P'
                 0            @   a
                         Hb
  b
                            `b
         xb
 Q
                             @   Hb
                        ` XO
 b
                              b
 b
                            c
         (c
 1
 h)
                                  @   b
                        ` Y
 Pc
                            8 c
 xc
                            c
         c
 1
 h)
                     8            @   c
                        ( V
  d
                            h Pd
 (d
                            hd
         d
 *
                 h            @   Pd
                         d
 d
                            d
          e
 P'
                             @   d
                         Pe
 (e
                            he
         e
 P'
                             @   Pe
                        8 e
 e
                            e
          f
 %
                 8            @   e
                        h Pf
 (f
                            hf
         f
 K
                 h            @   Pf
                         f
 f
                            f
          g
 %
                             @   f
                        p  V
 (g
                              X
 Pg
                             P
 xg
                             Y
 g
                            @ @[
 g
                             h
 g
                            0h
         @h
                          @   h
                                              4	 
RprJ
 `g       ͎  4	 
RprJ
 g 0 U     n  4	 
RprJ
  h         2p! 4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 !   4   U  i
 PS
  0rJ
 ]  2P          pS
 S
 S
 S
  4 prJ
 8]  2P 2P 2P 2P                      )  G     U  S
     T
  4 
prJ
 `]  2P 2P                     0T
 PT
 pT
  0rJ
 ]  2P 2P 2P        )  N     [          20        	   k 0   T
 8   	   pn p   T
 8   	   @p @   U
 8   	   Hl `   PU
 8   	   pl     U
 8   	   hp (   U
 8   	   l 8   V
 8   	   m H   PV
 8   	   xm X   V
 8   	   Hm h   V
 8   	   k x   W
 8   @           PW
 8                 `k
   rJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ] 
 
2PrJ
 ]                   T
     T
    T
     T
    T
     U
    ;U
     ]U
    {U
     U
    U
     U
    U
     V
    ;V
     ]V
    {V
     V
    V
     V
    V
     W
    ;W
     ]W
    uW
      20 20
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 20
 
4 
2p
 
4 
2p 20 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   d 4 2p 20
 
4 
2p d 4 2p 20
 
4 
2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p 20
 
4 
2p d 4 2p 20 20
 
4 
2p d 4 2p  
 
4 
2p d T 4 2p	 p`P0   d T 4 2p d 4 2p d 4 2p
 
0! t d T A  A  p
 !   t  d  T A  A  p
 !   A  A  p
  0! t d
 T B  B  q
 !   t  d
  T B  B  q
 !   B  B  q
  20 R0
 
4 
2p	 	r! 4
 F  F  |q
 !    t d T F  F  q
 !   t  d F  F  q
 !   t F  F  q
 !   F  F  q
 !   F  F  |q
     20
 T 4 R
p` B  ! 4	 K  L  4r
 ! t L  L  <r
 !   L  L  <r
 !   K  L  4r
  d	 4 Rp t 20
 
d 
2p! 4 0O  tO  r
 !   0O  tO  r
  d T 4 2p
 t d T 4 
 
4 
2p B  
 
4 
2p T 4 R
p`
 T 4 rp`!  0W  W  0s
 !   0W  W  0s
 
 
4 
2p 2p`P! 4 0Y  uY  xs
 !   0Y  uY  xs
  4  2p T	 4 2p!  d `[  [  s
 !   `[  [  s
  d T 4 p?
 ?d	 :4 T
 2
p B   B   B   B   B   B   B   B   B`0  !$
 $  
 
t	 T `  `  \t
 !   t	 `  `  \t
 !   `  `  \t
 
 
4 
2p< <4 
d 
2p 4  2`P0! t	  d  )f  t
 
 
4 
2p B   t 
4 
2` 20!
 
t d pi  i  u
 !   t pi  i  u
 !   pi  i  u
 
 
4 
2p 20 d	 T 4 2! t pk  k  pu
 !   pk  k  pu
  20
 
4 
2p! d @m  m  u
 !   @m  m  u
  R
pP0! d
 n  n  u
 !   d
 n  n  u
 !   d
 n  n  u
  4 p d 4 2p
 
4 
2p 20 20!! !	 t 
d T s  s  Xv
 !   s  s  Xv
  B   B   20 d	 4 Rp B   B   ! " "t 20!
 !t) !d( !T' !4& !"    20
 
4 
2p B   R0 20! t }  }   w
 !   t }  }   w
 !   }  }   w
  B  ! 4 ~  *  `w
 ! t  4 ~  *  `w
 !   ~  *  `w
 ) ) # x d 4 p! h P    w
 !   P    w
 W
     W
    W
  4 RprJ
 ^  2P 2P 2PЁ                         d 4 2p X
  4	 
RprJ
 ^  2P   !         B   b
p`0  !   
 T p    x
 !         T p    x
  b	  !   t d
 T 4      x
 !        x
 !       t  d
  T  4      x
  d T 4 2p B   B  
 
4 
2p
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 B   h R0
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20 d 4 2p
 d T
 4 rp b
p`0  !   
 T Н    z
 !         T Н    z
  b	  !   t d
 T 4 `  o  z
 !   `  o  z
 !       t  d
  T  4 `  o  z
    !` ` [T
 %  t 
d 4 0  ?  <{
 !   0  ?  <{
 h
 h cT ^4
 	Rp`K
 K FT
 
4 
R	p`   !Y Y TT
  t 
d 4 `  h  {
 !   `  h  {
  20!
 
t d     {
 !   t  d     {
  BP  !g gt
  d	 4     ,|
 !       ,|
 X XT t d 4
 r b  !k k f at \d T 4
     |
 !       |
 !       t  d  T  4
     |
   	  ! T    t d 4    0  |
 !         0  |
 !       0  |
 !      0  |
 
 
4 
2p B   t d T
 4 rO
 OT d 4
 r
p
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 
4 
2p 20
 t	 d T 4 2 B   t d
 T	 4 2 X
     PX
  p0  rJ
  _  2P 2P@  Z      &     3       T
 4 2p` t d
 T	 4 2
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p
 
4 
2p B   20
 
4 
2p
 
4 
2P! t d  / 
 !   t  / 
 !    / 
  20 t d
 T	 4 2 b   d T 4 2p B  ! 4 `  t
 ! t  4 `  t
 !   `  t
  B  ! 4 P  
 ! t  4 P  
  B  ! 4  
 
 
 ! t  4  
 
 
 !    
 
 
  B  ! 4  w 0
 ! t  4  w 0
 !    w 0
  B  ! 4   g t
 ! t  4   g t
 !     g t
  B  ! 4  W 
 ! t  4  W 
 !    W 
  B  ! 4  G 
 ! t  4  G 
 !    G 
  B  ! 4  ` @
 ! t  4  ` @
  d	 4 RppX
     X
 ( (h #t d T
 4 rJ
 H_  2P 2P     L     [  B   20 d 4 2pX
 & &d !T
 4 
prJ
 p_  2PP       X
      Y
  	  d. T- 4, * p  rJ
 _  2P 2P      2    I     U  Y
     @Y
    `Y
    Y
    Y
    Y
    Y
     Z
     Z
    @Z
    `Z
    Z
    Z
    Z
    Z
     [
  dH 4G D p  rJ
 _  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P          =                    R    u    	    !    A    w                # 	   C    y 
                   9    o 
               
     
 t	 d T 4 2 T	 2! t d 4 " "" ؅
 !   " "" ؅
  B  
 
4 
2p B   B   . P  ! ( ) * + t, d- 40 `' m' 4
 !   (  t,  d- `' m' 4
 !   t,  d- `' m' 4
 !   d- `' m' 4
 !   `' m' 4
 
 t	 d T 4 2 T	 2! t d 4 s s ܆
 !   s s ܆
   
  ! 
   t d T 4 v v 
 !   
 v v 
 !   v v 
  T
 4 rp` >   ! 7 t: 8 9 d; T< 4=   " 
 !     " 
 !   7  8  9  t:  d;  T<  4=   " 
 
 d T 4 p  	  !  d  
 t T 4 p  
 !   T p  
 !   p  
 !       
  t  d  T  4 p  
   !    d  t T 4   
 !        
 !      
  b   2	p`P0 B   B   20 20 B   B   20 B   B   20 20 d	 4 Rp T
 4 rp` t d T 4  T
 4 rp` T
 4 rp` B   [
     @[
 ( . p`P0  rJ
 _  2P 2P 5      d!    v!     !  20
 d T 4
 Rp`[
     [
    [
    [
    [
 ' '48 0 
p`P  rJ
 `  2P 2P 2P 2P 2P" #     #    (    )    -    @.    -0    0    o2     ~2 ) )h t d T
 4 \
     0\
  	 0  rJ
 8`  2P 2P4 4     4    5     &5 P\
     p\
  	 0  rJ
 ``  2P 2P@6 {6     6    6     6 S Sd
 NT	 
4 
Rp\
 #
 #h d
 T 4 rprJ
 `  2PP< <     < \
 : : 5 0 +x 'h #T 4 	p`rJ
 `  2P= @     @ \
      ]
  Rp
`P0rJ
 `  2P 2P0A [A     A    A     B ]
      ]
     @]
    `]
 . .x *h	 &4  
p	`P  rJ
  a  2P 2P 2P 2P@B tB     B    B    B    B    sF      ^
     ]
     ]
     ^
 &
 &4 
p	`PrJ
 (a  2P 2P 2P 2PF G     3G    NG    iG    G    J     `^
     ^
     ^
    ^
    ^
    _
    0_
    P_
    p_
    _
    _
 ) )43 * 
p	`P  rJ
 Pa  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P@K oK     K    K    K    K    3N    AN    N    N    IO    YO    jO 	   {O 
   O    P    5P    P    P     @`
     _
      `
     `
 &
 &4 
p	`PrJ
 xa  2P 2P 2P 2P Q LQ     sQ    Q    Q    Q    U     `
     `
     `
    `
    a
    0a
    Pa
    pa
    a
    a
    a
 ) )43 * 
p	`P  rJ
 a  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2PU U     U    U    %V    =V    sX    X    X    X    Y    Y    Y 	   Y 
   Y    LZ    uZ    Z    [     `b
      b
      b
    @b
 &
 &4 
p	`PrJ
 a  2P 2P 2P 2P`[ [     [    [    [    \    \_      t d 4 ! T _ ` `
 !   _ ` `
         	   @n (   b
 8                 
  
R0rJ
 a 
 
2PrJ
 a @a Va     }a b
     b
    b
     b
  c
     c
    @c
    `c
    c
    c
 c
 & &T& "4$  	p`  rJ
 b  2P 2P 2P 2P 2P 2P 2P 2Pa a     a    a    
b    b    'b    tb    c    d    	e    e    'e    ne c
  d
     d
    @d
    `d
    d
    d
 d
 & &T& "4$  	p`  rJ
 @b  2P 2P 2P 2P 2P 2P 2P 2Pe e     e    f    f    )f    7f    f    g    h    i    (i    7i    ~i d
  e
     e
    @e
    `e
    e
    e
 e
 & &T& "4$  	p`  rJ
 hb  2P 2P 2P 2P 2P 2P 2P 2Pi i     j    j    *j    ?j    Mj    j    k    /l    )m    8m    Gm    m e
  f
     f
    @f
    `f
    f
    f
 f
 & &T& "4$  	p`  rJ
 b  2P 2P 2P 2P 2P 2P 2P 2Pm 
n     n    +n    :n    On    ]n    n    o    ?p    9q    Hq    Wq    q @g
     f
      g
     g
    pg
    g
    g
     g
 & &4  
p	`P  rJ
 b  2P 2P 2P 2P 2P 2P 2P 2Pq q     #r    2r    Or    [r    rr    s    s    s    s    t    t    #u     g
  4
 
RprJ
 b  2P`u u     u h
  4
 
RprJ
 c  2Pu u     
v 0h
  4	 
RprJ
 0c  2P@v fv     zv Ph
 ! !h d 4 prJ
 Xc  2Pv v     Iw h
  4
 
RprJ
 c  2Pw w     w h
  4
 
RprJ
 c  2Pw x     -x h
  4	 
RprJ
 c  2P`x x     x h
  d 4	 
RprJ
 c  2Px x     (y U U
 M E = 5 - %  x h 3 
pP!E
 E 8/ (0 d1 42 y { p
 !   y { p
  i
  i
    @i
    `i
    i
 #	 #d T 4  p  rJ
  d  2P 2P 2P 2P 2P`                              R i
 i
    i
    j
    0j
 #	 #d T 4  p  rJ
 Hd  2P 2P 2P 2P 2P 9     H    i    x            s     j
     `j
     j
    j
    j
    k
    0k
    Pk
    pk
    k
     k
 . .h ; p`
P0rJ
 pd  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P Ԅ         ?            Ʌ                     	       ݍ        ^ 
        l
     k
     k
    @l
    `l
    l
    l
    l
    l
     m
      m
 . .h ; p`
P0rJ
 d  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P  T     {        
    "    I    a    p    |        . 	   @    ]    l    ޙ 
   p      20w w ^ X R 0 + &	 !
 x h  @m
 `m
    m
    m
    m
    m
     n
     n
    @n
    `n
    n
    n
    n
 n
 - -x )h %4: 2 
p`P  rJ
 d  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P      d        ՞        ]    o    T    Ω    h         	        
           1    b    q          
     20o
 0o
    Po
    po
    o
               @           o
 8               <
 -	 ! p`0  rJ
 d  2P 2P 2P 2P 2P
 
2PrJ
 d  E     T    }        
        2    a    
    =
 o
     o
    o
      p
  p
    @p
    `p
    p
    p
    p
    p
     q
        	    q
        @           @q
 8   	   
         
 -	 !0 p`0  rJ
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2PrJ
 e 
 
          '    ?    h                     .     	   G 
   U 	       )    R         @q
     Mq
    tq
     q
 q
    q
    q
    r
    0r
    Pr
    pr
    r
    r
    r
    r
    s
 -
 -h )47 . 
p	`P  rJ
 8e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P  y             
    1    x                      ! 	   "    " 
   "    &    3(    A(    (    ( s
     @s
     `s
    s
    s
    s
    t
    0t
 ) )4!  
p	`P  rJ
 `e  2P 2P 2P 2P 2P 2P 2P 2P@) o)     )    )    )    )    )    	*    5+    C+    +    +    ,    ,     
 
4	 
2p 20 d T 4 p t d T 4  20`t
 t
    t
    t
    t
     u
     u
    @u
    `u
    u
    u
 u
 ' '4, $ 
p`P  rJ
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P4 ^4     m4    4    4    4    5    5    08    A8    8    8 	   8    t=    =    > 
   Z>    h>    > 
 
4	 
2p@y
     u
     v
     v
    @v
    `v
    v
    v
    v
    v
 	    w
 
    w
    @w
 
   `w
 
   w
 
   w
    w
    w
     x
     x
    @x
    `x
    x
    x
    x
    x
     y
 
    y
 
   py
    y
    y
 1 14 ! p`P  rJ
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P 2P0@ u@    @    @    @    vC    C    C    C     D 	   <D    D    D 
   D    ME    E    E    F    F    kF    {F    F    F    G 
   AG    TG    G    G    G 
   G 
   "H 	   I    J    )J    1J    iJ    J    J     y
  z
     z
    @z
    `z
    z
    z
    z
           z
           P{
 p{
 @            {
 8      	   
      
 + +h . 
p`0  rJ
 e  2P 2P 2P 2P 2P 2P 2P 2P 2P
 
2PrJ
 e  2P 2P K [K     K    K    L    FR    R    ZT    tT    T    V    V    V 	   V    X    #Z    1Z    Z  {
     
{
 
   4{
     {
 {
    {
     |
     |
    @|
    `|
 |
 + +4!  
p`P  rJ
  f  2P 2P 2P 2P 2P 2P 2P 2PZ L[     [[    [    [    ^    ^    *_    `    `    `    a |
 |
    |
     }
     }
    @}
    `}
 }
 & &T& "4$  	p`  rJ
 (f  2P 2P 2P 2P 2P 2P 2P 2P@a a     a    a    a    a    a    $b    dc    c    d    d    d    e  d 4 2p d 4 2p}
     }
     }
     ~
     ~
    @~
    `~
    ~
    ~
    ~
 	   ~
 +
 +d' 'T% #4$  
p  rJ
 Pf  2P 2P 2P 2P 2P 2P 2P 2P 2P 2Pg g     7h    2i    i    Kj    sj    j    0k    k 	   k 
   jl 	   yl    l    l    l     l ~
 
    0
    P
    p
    
           
               	    
           
    
    Ѐ
    
           
           
                  
    
 0
 @           
 8   @           @
 8   @           0
 8   @           
 8               ̱
 	   
         
             
             
 3
 3h  /dI +4H B p  rJ
 xf  2P 2P 2P 2P 2P 2P 2P
 
2PrJ
 xf  2P
 
2PrJ
 xf  2P 2P 2P 2P 2P
 
2PrJ
 xf  2P
 
2PrJ
 xf  2P 2P 2P m ym     m    m    .n    kn    n    s    s    s 	   t 
   /t    x    .y 
   z    z    |{    )}    7}    F}    k}                             (    ɉ    ׉    _ 
     
    
     M
    t
     =
    d
     
    ԁ
      d T 4 p    4	 
RprJ
  j   E     ^ !     A ! 4    A  "   4	 
RprJ
 k 0 U     n  
R0rJ
  m  Ɩ     і  4	 
RprJ
 0m       .  4	 
RprJ
 `m  ՗        rJ
 Pn @ c     o           rJ
 n  ә     ߙ         
 
RPrJ
 n 
   rJ
 n               X
 @           P
 H         > @     
 
RPrJ
  o 
   rJ
  o               
 @           p
 H   P ]     ~      
 
RPrJ
 0o 
   rJ
 0o               (
 @           
 H               
 
RPrJ
 `o 
   rJ
 `o               
 @           
 H   М ݜ            
 
RPrJ
 o 
   rJ
 o               
 @           Ђ
 H         > @     
 
RPrJ
 o 
   rJ
 o               `
 @           
 H   P ]     ~      
 
RPrJ
 o 
   rJ
 o               ȸ
 @           
 H               
 
RPrJ
  p 
   rJ
  p               0
 @           0
 H   Н ݝ            
 
RPrJ
 Pp 
   rJ
 Pp               
 @           P
 H         > @     
 
RPrJ
 p 
   rJ
 p                
 @           p
 H   P ]     ~      
 
RPrJ
 p 
   rJ
 p               h
 @           
 H               
 
RPrJ
 p 
   rJ
 p               к
 @           
 H   О ݞ            
 
RPrJ
 q 
   rJ
 q               8
 @           Ѓ
 H         > @      4 prJ
 s 
 
 0
 P
 П       /    = [    i      !   `  
 !
 
	 4 `  
  d T
 2
p!     H
 ! 4   H
  t	 d T 2G G A ; ( "x h  . .h )4 Rp 4+ ( p  rJ
 w P     ڪ      4	 
RprJ
 x 0S
        !     $
 ! 
   	 
 
 T   $
  p`0 4	 
RprJ
 `y @ e     ~ !     
 ! t   
  h 
4 
Rp 4	 
RprJ
 p 
 p        
R0rJ
  
 P f     z  BP  rJ
   4 r
	p`rJ
              8
 @           @
 H    
  
               
 `                  ߼     @
     O
    l
      BP0  rJ
    4 r
	p`rJ
               
 @           
 H   
 
                
 0      ۽            þ    ׾ 
     
    
      	  d4 T3 42 0 p  rJ
 0  S     ɿ    տ           d- T, * p  rJ
 ` 0
     P
  \             d- T, * p  rJ
    L          !   P  
 ! t d 
T 4
 P  
  B  * *4 B  ! !d
 !T !4
 !2p!    $ 
 !    $ 
  p
`P07 7x 2h t d T
 4  	  d4 T3 42 0 p  rJ
   #                  	  d4 T3 42 0 p  rJ
  @
     `
    
  #                 : : x 	h   " "x h 
4 
p 	  d4 T3 42 0 p  rJ
 @ @              "    !   @ ; h
 !   
  @ ; h
  p
`P0!   `  
 !  `  
 
 T 4	 p` 	  d0 T/ 4. , p  rJ
  P            	  d0 T/ 4. , p  rJ
               	  d4 T3 42 0 p  rJ
     C                  	  d4 T3 42 0 p  rJ
 P   C                  x h 4 0  rJ
  
     
    
     
     
    @
    `
    
    
    
                   P    ]    {                        &    :    Y         	             1 14    !     q 
 !5 5 / ) #  	   q 
 
 
2PrJ
   4 
RprJ
                T
 @           
 8         7 
     
    

     
 
2PrJ
   4 
RprJ
                
 @            
 8   P u       
     -
    J
     !     A ! 4    A 	 T/ 4. * p`  rJ
 @       Y    !   
 `  H
 !   `  H
 ! 
 `  H
 
 
2PrJ
 p 
 b  rJ
 p               
 @           `
 8   @ P     j `
     m
    w
     
 
t 4 !     t
 !  l c Z B 9 0  x h   t
 '
 '7  p`P0%
  y q i a Y ;x 4h -47 &#!, p`P!     
 !      
 !     
 ! d 4   
 
 
T	 
2p 	2 0  rJ
  
     
    
  $     j    v          	  d4 T3 42 0 p  rJ
                    % %d; !4: 8 
p  rJ
  
      
     
    @
  5                       d3 42 0 p  rJ
 p `
     
 
 
 
  
  
    @
    `
    
    
    
   a     w                    :    H                  -    A     	        
               !  h R0 d T 4 2p!   P b 
 !   b  
 !     
 !    
 !
 
  b  
 ! 4
 P b 
  Bp`
P   4	 
RprJ
   
 `        4	 
RprJ
 P  
         4	 
RprJ
   
   %     >  4	 
RprJ
  P u       4	 
RprJ
          4	 
RprJ
   5     N  4	 
RprJ
 @ @
 `       
 
2PrJ
  
 b  rJ
                
 @           `
 8   # #     # `
     m
    
        d- T, * p  rJ
  $ /%     %    %  4	 
RprJ
  0
 P
 P' u'     '    '  	  d1 T/ 4. , p  rJ
 ` * f*     *    +    dQ TP N p  rJ
  
     
    Ћ
    
 0+ ~+     +    +    <,    ~, !               	  x
 , T- 
 !   , T- 
 !    , T- 
 !B B < 6 ' !  	 x
 , T- 
   h  0     dQ TP N p  rJ
  `8 8     8    8    l9    9  	  d4 T3 42 0 p  rJ
  9 :     :    :    :    
 
2PrJ
 @ 
 b  rJ
 @               x
 @           
 8   :  ;     ; 
     
    '
     	 T/ 4. * p`  rJ
 p  ; `;     ;     4	 
RprJ
   < %<     >< H<    <  4	 
RprJ
  < =     = (=    ~=  4	 
RprJ
 ` p
 = =     >  4	 
RprJ
  0> >     >  4	 
RprJ
  > >     >  4	 
RprJ
  @? e?     ~? !               	  x
 pD $E 
 !   pD $E 
 !    pD $E 
 !B B < 6 ' !  	 x
 pD $E 
 G G ; 5 / * %   	 x
 h 
 K K  @ : 4 / * %  x h	 
  2pP0rJ
   Rp`0rJ
               D
 @           
 H           
     `U U     U    U     U 
     
    
     % %t1 !d0 T/ 4. ,   rJ
   U 6V     cV    V % %t1 !d0 T/ 4. ,   rJ
 P  
      
 V DW     qW    W  2pP0rJ
   p`0rJ
              
 @           
 H   @
            `
         W W    X    X    6X 
     
    
      4	 
RprJ
  Ѝ
 PX X     X  4	 
RprJ
    Y %Y     >Y !   4 Z Z 
 !   Z Z 
 ! 4 Z Z 
  h R0!   [ !\ 
 !5 5 / ) #  	 [ !\ 
 ,
 , '	 x
 h 
  t 4 !     
 i i 
 !   i i 
 !
 
 
 i i 
 !   l m \
 !  l m \
 !  x
 `j l t
 B B < + %   	 h 
 ! 	 x
  p r 
 ? ? 9 - ' "   h 
 !   u u $
 !   u u 
 ! h T	 u u 
 ! 4 u u $
  d
 Rp!      d  4 v v 
 !      t  d  4 v v 
 !   w ~w 
 ! t w ~w 
 ! 4     d v v 
 !	 	  d v v 
  P	 T/ 4. * p`  rJ
   x x     y     4	 
RprJ
 P y z     .z 8z    z  4	 
RprJ
  z z     z z    N{ E E  x h 
4 
p!   Â  
 !	 	 Â  
 !
  x
  [h  ~ Â 
 #
 #   	 
 !     <
 !s s j R I @ 7  x h   <
 8 8
 '/  p`P0 4	 
RprJ
 P `             4	 
RprJ
    E     ^  4	 
RprJ
 М  Ř     ޘ X X : 5 0 x h d 4 p 4	 
RprJ
 @ 
 
  5     N      4	 
RprJ
  М        4	 
RprJ
  P u      !    ̞ A !	 	t  4  ̞ A !   0 k X
 ! t 0 k X
  d 4
 RprJ
   p
     
           Ң     & !   P  
 !.
 .  x t d
 T P  
  h 0 d
 T	 4 Rp!     
 ! d   
  T
 4	 Rp)
 )t3 %d2 !T1 40 , 	  rJ
   v         ;  h 
/ rJ
 П ` ժ         ?  
R0rJ
   
 p         0  rJ
 P P                   O !   t  4 p  
 !   p  
 !
 
t 4 p  
  b   d
 4	 
RprJ
 @ P
     
  T     b     /
 / ) x h 0 2pP0rJ
 p  d
 4 
rprJ
 p              
 @           
 H           
           ϳ          
     Ϗ
    
      20 
R0rJ
        _  
R0rJ
 С 
  ɵ       
R0rJ
   @ y       
R0rJ
 0  )     o  d 4	 
RprJ
 ` @
     p
   D     R       0  rJ
            ,     8         ˺  0rJ
  
     
       T    d       0rJ
        4    D        0  rJ
    ټ                  a       d
 4	 
RprJ
 P 
     
           `  d
 4	 
RprJ
  0
     `
  ľ     Ҿ       
R0rJ
  
         d 4	 
RprJ
  
     
 p            d 4	 
RprJ
   
     0
 0 t            0  rJ
 @ P
     
  &     Y          !     
 ! 4   
  p   4  d
 4	 
RprJ
 p 
     В
  T     b      d 4 2p h d x   !     
 ! x 4
 h   
  d T p h g    !     L 
 ! x t d
 {T j4 h   L 
 
 

 
2PrJ
   4$ " p  rJ
              4
 	   hp     P
 8   
 
    0
               `               
    m    y      P
      d 4	 
RprJ
 Ф p
     
           P !   
   H
 !     H
 ! 
   H
  4 Rp`P!     
 @ h 
 !   @ h 
 !
 
 
 @ h 
  4
 Rp`P 	  d1 T/ 4. , p  rJ
              !     H
 !  d 
T 4   H
 !   0 [ H
 !  d 
T 4 0 [ H
  
p 
R0rJ
 0         
R0rJ
 ` @ y        0  rJ
  P                        [   0  rJ
  p                   1     {  d
 4	 
RprJ
  0
     `
           0  d
 4	 
RprJ
   
     
 P           !
   qx
 < 		  w 
 ! h    P  
    !     D
 ! d 
T 4   D
  t    
R0rJ
   0 i       d 4	 
RprJ
 0 Д
      
              d 4	 
RprJ
 `  
     P
 @             0  rJ
  
     
     0
   9     P    l     x           d
 4	 
RprJ
  p
     
   d     r     !     G h
 !  t 
T 4   G h
 !     8
 !    , $
 !    T  , $
 ! t   8
  r`0 
R0rJ
          d 4	 
RprJ
   
     
 p              0  rJ
 P 
     
     
 0  i                      /  d
 4	 
RprJ
  
     @
 P            d 4	 
RprJ
  `
     
  T     b     !     X
 !
 
t d   X
 ,
 ,t? (d> $T=  4< 8 	  rJ
  
     Ж
    
 
    0
    P
 p
    
    
    З
    
 
   
    0
 P      e    q             I    U    p                  	   :    L     
   ,
    8
    S
    e
 
 
4 
2p!    O @
 ! t
 
d	 T  O @
 
 
20!   `  x
 ! 
 
t	 d `  x
 	 	2P0
 
2PrJ
 p # #t d
 4	 RrJ
 p             
 @           p
 8   P
                  W          p
     }
    
      d
 4	 
RprJ
  
 
    
  L     X    v      R0rJ
 Ы 
         d T 4 prJ
    
 @ m       R0rJ
 0 @ a      "
  
	p`P0rJ
 `  
 @
    `
    
    
    Й
    
    
    0
    P
 	   p
    
   r                 "    j                !    X    m 	   z 
    	           N            M  P  "
  
	p`P0rJ
  К
 
    
    @
    `
    
    
    
    
     
 	    
    `
       :    U                    4                 	    
   \ 	   a            ;    [     !   M! f! 
 !n n
 e N E
 <  x M! f! 
 ! h 0 @  M! 
 B
 B =  ( p`P0  
 
2PrJ
   d 4
 
RprJ
                 
 @           
 8   01 1     1 
     
    
      R0rJ
   2 A2     d2  4 RprJ
   
     М
     
 2 2     2    2    (3     ,3  4 RprJ
 P  
     @
    p
 P3 3     3    3    3     3  R0rJ
  
  4 A4     d4 $ $x h   !   p6 6 
 !  t 
T 4 p6 6 
  
` R0rJ
  < =     4= !   P= = ,
 !   t P= = ,
 !
    t 
d	 T P= = ,
    x h 0 # rJ
  
  C AC     !   G G 
 ! 4 G G 
 >
u>h ,s'9  p`0P  rJ
 @ Н
     
  I dJ     K    R     R !    S ;S 
 !
 
 4  S ;S 
  d	 T 2p R0rJ
 p S T     $T  R0rJ
  @T aT     T  R0rJ
 Ю U U     U 
 
2PrJ
   !
 !d 4 
prJ
                 
 @           
 8   @V >W     W 
     
    3
     !   0Y AY L
 ! 
 
t	 4 0Y AY L
  2
`
P R0rJ
 0  Z AZ     dZ ;
u;h ,s'!  p`0P  rJ
 ` @
     `
 Z [     x\    _     _ ;
u;h ,s'!  p`0P  rJ
  _ `     ma    
d     d !   d d X
 !
 
t d d d X
  0   4
 RprJ
  g Eg     Qg    T 4 
R	p`rJ
  
     
 `g g     h    Wh !   h h 
 ! t h h 
  T
 4	 R`* *d %T  4
 R
prJ
 @ 
      
     
 pi j     Ej    j    j  	  d T 4  p  rJ
  Х
      
 j Bk     Pk ck    }k     k 
 
4 
Rp d T 4
 rp 	  d T 4  p  rJ
         @  pm m     m    m     n 
 
2PrJ
   # #t d
 4	 RrJ
               
 @           `
 8   @
                 n 7o     o    o `
     m
    
     !   o p  ! 4 o p   4 2p!   pq q @
 ! d pq q @
 
 
4 
2p
 
2PrJ
 P ) )h $d 4 r
prJ
 P               
             
 @           
 8   @           
 8                   q r     s as    s 
     
    
     ͟
    ן
     
 
RPrJ
   R	p`P0rJ
  / &p`0rJ
                
             
 @           
 H   @           
 h           
               
 0t Xu     u v    v    	w    7w Vw    w 
     
    i
     
    
     
 
2PrJ
  !
 !d 4
 R
prJ
                
             
 @           @
 8   @           
 8   x x     9y y    y 
     
    0
     M
    W
     
 
2PrJ
  !
 !d 4
 R
prJ
                
             
 @           
 8   @           `
 8   `z {     { {    | `
     m
    
     
    
      
R0rJ
  0
     P
    p
    
    
    Т
 | |    |    |    |    }    
}     } !   } s~ 
 !   s~ }~ 
 ! 
 s~ }~ 
 !
 
t T
 } s~ 
 
 
R	`0 d 4 
rprJ
 @ 
     С
     
    
 `                        4	 
RprJ
 p  8     @    H    P    X    `    # " "d T
 4	 
RprJ
  @ k     ܁  h 4. , p  rJ
   `      ˂    ؂       bP0  rJ
 ` " 
p`0rJ
 `               l
 @           
 X    ˄      
     
    M
      # rJ
  `
        # rJ
  
 0 Q       rJ
  
 Ї      
 
B	p`P0  rJ
    R
p`0rJ
                h
 @           
 X           
      8     G    X     g 
     
    
      48 	6 p  rJ
 P           Ŋ            
     # rJ
  Ф
 @ a     
 t d T 4  dC 4B @ p  rJ
  
     
    0
    P
    p
    
    
 `          ό    y    1    T    c    y     	  d T 4  p  rJ
                  N  	  d T 4  p  rJ
              -     ^  	  d T 4  p  rJ
 @        #    =     n !    u  ! 4  u  
 
d 
2p
 
RPrJ
 p ! !d 4
 r
prJ
 p             ` @           P
 H   0
                   G          P
     ]
    p
      d
 4	 
RprJ
   0     k !    3 
 !   3 = ( ! 
 3 = ( !
 
t T
  3 
 !       !     t ! 
   t !
 
t T
      R
`0
 
2PrJ
 ж  d
 4	 
RprJ
 ж                @           
 8           
     
    
     
 
RPrJ
   ! !d 4
 r
prJ
                 X @           
 H    ^      
     
    Ц
     
 
2PrJ
 0  d
 4	 
RprJ
 0                @           
 8    
     * 
     
     
     
 
RPrJ
 ` "
 "t d 4 
rrJ
 `               ` @           
 H    O      
     
    0
      4+ ( p  rJ
 @ 
     p
   ^          h 4. , p  rJ
        .    ;     T  h 4. , p  rJ
  @
     `
  G     ~          
 
RPrJ
 0 (
 (d  4 r
prJ
 0                             @           
 H   @           
 H   p 5      0    e 
     
    
     
    ǧ
       rJ
 ` Ч
     
     
  B     N    k     w     
   rJ
  0
       
 
B	p`P0  rJ
 к  r
p`0rJ
 к               @           p
 X           P
     p               Ƭ p
     
    
     
 
4 
p d# 4"   p  rJ
   
     
      
     
  *     6    S    f      4" 	  p  rJ
   Ю      !    >    Q    w 
 
B	p`P0  rJ
 `  R
p`0rJ
 `              x	 @           `
 X           @
      د               `
     p
    
      dC 4B @ p  rJ
  
     Щ
    
    
    0
    P
    p
  ͱ     ܱ            Q    t             48 	6 p  rJ
  0
     P
    p
    
    
           մ                
 
RPrJ
     rJ
                , @           
 H   P s     ȵ 
     
    
      dC 4B @ p  rJ
   е      ,    ?            ķ    ӷ        
 
RPrJ
 `    rJ
 `                @           
 H    Ӹ     ( 
     ͪ
    
      
"  !    ,  ! t  
T 4  ,   `  *
 *h %t !d T 4    rJ
 н 
  [      *
 *h %t !d T 4    rJ
   @      | !     A !	 	t  4   A !     h
 ! t 
T 4   h
  `  !     
 ! t d 
T 4   
     	  d T 4  p  rJ
 0 `                	  d T 4  p  rJ
 ` 
 0
 P
  c     {    C      d T
 4	 Rp d 4
 rp$
 $T  4 
	p`rJ
  p
       F  d
 4	 RprJ
 о 
     
 p            d
 4	 RprJ
     B     X    f )
 )tI %dH !TG 4F B 	  rJ
 0 Ы
     
    
    0
    P
 p
    
    
    Ь
    
  +                         %     
        4    @    S 	   y !    o X !
  	 
 
d T  o X 	 	p0
 
4
 
r` 0rJ
  
 0
 P
        !    / M    [  0rJ
   p
 
 
 Э
 
             =    K i    w       d
 T 4 rp h 
4
 
p,
 , x h 
4 
p 
R0rJ
   >     f !     H
 !  d 
T 4   H
  
R0rJ
  p        
R0rJ
 @   N     v !     
 !  t 
T 4   
 !     A ! 4    A  t 
d 4  
R0rJ
    N     v  t
 d T 4
 R(
 (h $d  T 4  p  rJ
 p p
 
              
 
B	p`P0  rJ
   r
p`0rJ
                @           Ю
 X           
            '    8     F Ю
     
    
      R0 r0 h 0' 'h #T 4 	p`rJ
   
         d 4  p  rJ
  @
        !k k ;x
  J
 Y  !   y  ` J
    	 h  !` `  U R  !
 x	  nh
 9    U  " "  
 !   		  9 D    ٸ &  x
 h  !  h `# &  M M G ; 5 0  	 x
  -
 -h (t $d  T 4    rJ
  `
 ) y*     * !    + H+   !  t 
d T  + H+    
0!   p- - \ !
    d 
T 4 p- - \  
p  !   P3 x3   !  t 
d T P3 x3    4	 
RprJ
 ` 5 5     6  d
 4	 
RprJ
  @6 6     6  d
 4 rp" "4 
p`PrJ
  
 
    
    
     
     
    @
    `
    
    
 p8 8     8     9    9    9    9    9    9    9    9 	   <: !   P: :  !
 
 T P: :   Rp`0 h r0rJ
  
 ; "<     4<  d T
 4	 RprJ
 P `= =     =  h d 4
 rprJ
  > >     >  h d 4
 rprJ
   
 P? ?     ?  h d 4
 rprJ
  @
  @ @     @  d
 4	 RprJ
 `  
 `A A     A  d
 4	 
RprJ
  `
  B 8B     B  4 RprJ
  
 0C C     C ) )t %d !T 4 	rJ
   
     
 
     
 C UD     rD    ~D     D D    D    D    D  bP0  rJ
 P 1 1hN ! p`0  rJ
 P             0       !       -   -   1       ;   ;   ?       K   K   N       	   k X  
 X   	   k P  p
 X   	   k @  `
 X   	   k 8  
 X   	   k 0   
 X    
 @
    `
    
    
    
    
     
     
    @
 	   `
    
    
    
 
   
                  
    
    д
    
    
    0
    P
    p
    
    
    е
    
                  
    
     
     
     
 #   @
    `
 %   
    
 '   
 (   
 )    
     
    @
 ,       ,       .   
 /   
 0   0
 ,   P
 ,   p
 3   
 ,   
 5   й
 ,   
 7   
 8   0
 9   P
 ,       ,       <    
 =    
 >   @
 ,   `
 ,   
 A   
 ,   
 C   
 ,    
 E    
 F   @
 G   `
 ,   
 ,   
 J       J       L   0
 M   P
  F JF     F    F    F    F    G    G    4G    YG    hG    G    G    G 	   G 
   G 	   H    (H    >H    TH 
   _H    H 
   H    H    H    I    lJ    J    J    J    J    J    J    K    "K    3K    hK    K    K    K    K    K    L    !L    0L    uL    M    M "   M    N #   !N $   DN #   YN    lN %   N &   N %   N    N '    O (   O )   %O *   HO )   }O (   O '   O    O +   O ,   P -   :R ,   UR 2   hR ,   R 3   R 4   R 3   R ,   R 5   R 6   	S 5   >S ,   _S 7   uS 8   S 9   S :   S 9   S 8   S 7   T ,   BT ;   U ,   U @   U ,   U A    V B   #V A   8V ,   KV C   _V D   pV C   V ,   V E   V F   V G   W H   $W G   YW F   eW E   tW ,   W I   W J   jX K   
Z J   =Z ,   uZ    Z    Z    [  
     
    "
    E
    S
    r
    
     
    2
    U
     c
 !   
     
     n
 .   
 /   
 0   
 1   Ҹ
 0   
     ~
 <   
 =   
 >   ú
 ?   
 >   
     μ
 L   
 M   
 N   &
     % %t !d T 4    rJ
  p
 
    
    н
 [ \     \    5\    M\    \    ]  2P$ $d0  T/ 4. * p  rJ
   
     
     0
     P
     p
     
     
     о
     
     
     0
     P
     p
 p] ]     ]    ]     ^    
^     $^    3^     `^    l^     ^    ^     ^    ^     _    _     G_    S_     q_ 	   _     _ 
   _     _ _     `    `     ``    l`     ` !   ` ` $ !     T  4 ` ` $ !	 	T    4 ` ` $ !  4 ` ` $  bp`     T 4
 
R	p`rJ
 P 
     
 b c     0c    <c     !   c c % ! d c c %  T 4 2p$ $d  T 4  p  rJ
  
      
 d \d     hd    d     d !   h }i % ! 
 h }i %  T 4 rp`!   i j % ! 4 i j %  d T 2p
 
RPrJ
   t d
 4 rJ
               0& @           @
 H            
     j j     j    .k @
     M
    `
     
 
RPrJ
    t d
 4 rJ
                & @           
 H           p
     Pk k     k    k 
     
    
     !   k k `' !
 
d 4 k k `' 
 
2p d 4
 p   T
 4
 
R	p`rJ
 0 
 n <o     o    4 p`PrJ
 ` 
 p q     q    T
 4
 
R	p`rJ
  q ,r     r !   t ps s 
 ! t ps s 
 !   t u u 
 ! t u u 
  T 4 Rp`
 
RPrJ
  > >' 9( 4) /x* +h+ 'd_ #4^ X 
p  rJ
              )             ( 	   k `  
 H   	   k h  
 H    
  
    @
    `
    
    
    
    
            
 	    
    @
    `
        
                                          x x     x    z    z        0 ]            ߀                Ԃ         	   T 
               T             &    [ 
     
 
   
     
    
     (	 (d; $T9  48 6 	p  rJ
   
  
     
    @
       #    ;        ˆ    Ї    ߇    d T 4 prJ
 0 `
 
    
    
 
   l     {                ̈    	    N &	 &T "4  	p`  rJ
 `  
      
     @
    `
    
    
    
    
      
       ։                2    E            Ɋ            ^     i 
 
B	p`P0  rJ
  # #4 p`rJ
              , @           
 X    
 @
           `
                             +     
     
    
      4 p 4 rp`P
 d
 T	 4 2p
 
4
 
rp/ /
 *x &h "4#  
p`P  rJ
              
  
     
    @
                                    
            /    U    t    Ǖ     %
 %t !d T 4 rJ
  `            d= 4; 8 p  rJ
 @ `
 
    
    
    
               {                T 4 
R	p`rJ
 p  
  V      G G / * %  x h 4  p  +
 +d% 'T# #4"  
p  rJ
   
 @
    `
    
    
    
       2            ܝ                H !     0 ! 4   0  d p  ) )x %h !d T 4 prJ
  
 С j       
  T 4
 
R	p`rJ
    
 P ٣      #
 #h 4 
p	`PrJ
 0  ?     ¥             $
 $T 4 R
	p`rJ
 ` 
 
    
    
       ɧ            Ԩ  4 R
p`PrJ
   
  
    @
  d     
    0         ( (h $T  4 
	p`rJ
   
 @
    `
        &    {         $
 $T  4 
	p`rJ
  `
 
    
       :            	 %
 %4 r
p`PrJ
 @ 
 
     
     
 0      Y        Y    e %
 %4 R
p`PrJ
  @
 `
    
                      0rJ
  
 
 
  
  
 @
        )    7 U    c           ٵ     
 
RPrJ
   ! !d 4
 r
prJ
               4 @           
 H   `
                  Ƕ     3    y 
     
    
     !     |D !    |D 
 
RPrJ
 P  rp`0rJ
 P               5 @           
 H     i      
     
    
      	  d T 4  p  rJ
                 6 
 
RPrJ
   rp`0rJ
                P6 @           
 H           
     
    
      	  d T 4  p  rJ
            8     V !   @  % ! 
 @  % !   x p  (7 ! x p  (7  h 
   d 4
 
prJ
 ` p
     P
     
 @ c                       !    M 7 ! t  M 7  0 4 
p	`PrJ
  
  J      
 
RPrJ
  '
 't "d 4
 r	rJ
                @8 @           
 H           
     
     
     !        8 !   d
   8  R
pP0!      0 	 8 !   d
 0 	 8 ] ]d T 4 2p8 8 3x /h +d- 'T, #4+ $ 
p  rJ
  
 0
 `           8
 8 2 x h 0 d
 
4 
R	pP!     : !      9 !  
 d   9 ! T   9 ! x h   :  	p0  ! d
  | 0: 
 
4 
R	pP3 3 .x	 *h
 &4   
p	`P  rJ
               P
 p
                                                  
        \    {     !     T (; ! x	  t d p4 h
   T (;   P
 
B	p`P0  rJ
 P # #4 p`rJ
 P             |; @           
 X   
 
           
                f     u              
      
    >
     
 
RPrJ
  H H* C+ >, 9- 4x. 0h/ ,g (tf $de  4d ` 	  rJ
              <    !   $      < 	   k   @
 H   	   k   
 H   P
 p
    
    
    
    
    
    0
           P
 	   p
    
    
        
                                              
     
                                                                                             "       #       `          u        y        9    V            *    \    t 	    
           B    \                1    i     
     
 
   
     M
 "   `
        T 4 
R	p`rJ
  p
   g     f p      \ \d T 4 2p& &t "d T 4 
	rJ
   
 
 
 
 P          Z          1 1d )T $4 r
prJ
 0 
 0
  
           `
 `d T
 4	 2
p* *TB &4A : 
	p`  rJ
  P
 p
    
    
    
  :     I        7            \    k    w    T 4 
R	p`rJ
  
 
  6            d d B = 8  x h 4  p    x xh ( #  
 
 
t 4  T 4 2p`Q Q K . ) $  x h	 
 8
U8h 1t #d 4 S
P  -
U-h & t d 4 SP  !    & A ! 4   & A    !      B !
 
d 4	    B >
 > 9 4t +T ! !4 
p`PrJ
        -    a         k kd T 4 2p
 4 t d
 T	 R h 
4
 
pb
 b4 h d T
 p
 d 4
 T R
p d 4 rp d
 4 rp
 
RPrJ
  ! !d 4
 r
prJ
              PC @           P
 H   0
                 - .     s.    . P
     ]
    p
     !   . . C !   
  4	 . . C ! 
 4	 . . C 
 
d 
Rp
 t d T
 4  0
 d T
 4 rp x h 
4 
rp! !h 	0!   @8 8 |D !  @8 8 |D  4 Rp`P7 7 2 -x )h %47 0 p
`P  rJ
    : N<     	= 
>    i>    ?    ?    ? ?    ?    /@    @    iA    uA    A    A A    B    xC    C    C    C    D    *D 7 7 2 -x )h %47 0 p
`P  rJ
 P 
 
    
    
     
     
    @
    `
    
 D .G     G H    II    I    J    J J    J    K    K    IL    UL    L    L L    pM    XN    N    N    N    N    
O 7 7 2 -x )h %47 0 p
`P  rJ
  O R     R S    )T    T    mU    |U U    U    U    V    )W    5W    `W    oW W    PX    8Y    Y    Y    Y    Y    Y 3 3h /d! +T  '4  
p  rJ
  
 
    
     
 0Z Z     Z    V\    q\    \    \  T 4 p`rJ
   
  ] ]     &^ 6 6 1x -h )t %d !T 4  	  rJ
  @
 P^ ^     ` 
 t d T 4 !   `b c H !  `b c H : :   x h 4 p> >   x h 4 pF F A <  x h d 4 p, ,x 'h d T 4
 rpe
 ed t	 T 4 2
 t d T 4  h t d T
 4 $ $d  T 4  p  rJ
  `
 t )u      v !   w 4w J !d dd T
 4 w 4w J  h p# #T 4 
	p`rJ
  
     
 0x ax     x    vy % %t/ !d. T- 4, *   rJ
   
 
     
 y y     y y    cz    qz    }z (
 (d $T  4  
p  rJ
   
     @
 `
    
 z F{     R{    o{     { {    {    {    { 
 
2PrJ
    4	 
RprJ
               K @           
 8   
                 p~ ~     ~    ~ 
     
    
     
 
2PrJ
 0  4	 
RprJ
 0             LL @           
 8   
                            
     
    0
      4 p!    ʀ M !   ʀ . L !# #  ʀ . L ! 4  ʀ M 
 
T 
	p`!     M !     PM !# #    PM ! 4   M 
 
RPrJ
 `  R	p`P0rJ
 ` / &p`0rJ
 `               M             M @            
 H   @           @
 h           
               P
 p      @ ܈        Y         6 @
     R
    
     
    H
      d
 4	 Rp!    	 C !   
  4	  	 C ! 
 4	  	 C  d
 4	 
RprJ
  `       
 
RPrJ
  7 7xB 3hC /d +4  p  rJ
              O             |O 	   k    
 H   	   k   P
 H   p
 
 
 
    
    
    0
    P
    p
    
    
 
          
    
    
    0
 
                     
   
    
    
 
          
     
 
                           - `         ɏ    N    f        ƒ        7     	   1 
   ٕ        6    o         
    
   e                    !    <        = 
   e        ՟    
 P
     ]
    p
     -
    @
     
 
RPrJ
 ` 7 7xB 3hC /d +4  p  rJ
 `             <R             (R 	   k   
 H   	   k   
 H   P
 p
 
 
    
    
           
    0
    P
    p
 
          
    
    
    
 
                     
   @
    `
    
 
          
    
 
                     p       P    k         .    F            w 	    
   9    ]        Ϩ          
   Y 
   ũ             A    V            X     
           (    ` 
     
    0
     
     
     B B x h d T 4 p h R0   T 4 	p`rJ
   ٴ      m m4 2pD D !x h d T 4 p!	 ! x h ( 0  rJ
   
     0
     P
    p
 p i     k      "    ?    R    x      1 14$ ! p`P  rJ
   
     (        !    <    }  bP0  rJ
  " 
p`0rJ
                V @           
 X   о       
     
    
     7E7h 3t ,d %4 C 
PrJ
  
      
 @ M              $  4 p`P 4 p`P&
U&h  t d 4 SP   
R0rJ
 @   6     <  4
 
RprJ
 p  
     @
    `
     
 P k                 '    0     9 #
 #h 4 
p	`PrJ
  P      R        ?    H !   p  X ! t p  X  h 0( (h $T  4 
	p`rJ
  
 
    
     
  +             s    |  d 4
 
prJ
    
 @
            5  d 4
 
prJ
 `       E O    e #
 #4 
p	`PrJ
                          #
 #4 
p	`PrJ
  `
 
    
    
                         
  T 4 	p`rJ
    l                       
  T 4 	p`rJ
 P  |     
    '              4
 
RprJ
  
      
     
    @
               '    ; % %t !d T 4    rJ
   P                 d 4
 
RprJ
 P `
     
            +     .  4
 
RprJ
  
     
     
     
     
    @
                            <  h 
4 
Rp
 t d
 T	 4 R 4
 
RprJ
  `
     
    
    
    
      
  +    9    G    P    Y    b     k    t     }  4	 
RprJ
 @  
     @
    `
    
    
    
    
     
              0    I    V    o    |       
R0rJ
 p        ' 'd1 #T0 4/ * p  rJ
                )    ;    ^    q        ! ' 'd1 #T0 4/ * p  rJ
   
 @
    `
 
    
    
    
                           1    d     
 
RPrJ
   $
 $d 4 r
prJ
                 _ @            
 H            
     
     
     
 
RPrJ
 0  R	p`P0rJ
 0 / &p`0rJ
 0               _             _ @           
 H   @           0
 h           
               @
 `      0         I    v     & 0
     B
    
     
    8
     
 
RPrJ
 ` 3
 3h /dC +4B : p  rJ
 ` O   O   R      ` 	   k   @
 H   `
 
    
    
    
     
     
    @
    `
    
    
 
   
    
     
     
    @
    `
    
    
    
    
     
     
    @
    `
    
    
    
    
     
     
    @
    `
     
 !   
 "   
    
 $    
     
 &   @
 '   `
 (   
    
    
 +   
 +    
     
 .   @
    `
 0   
 1   
 2   
    
     
     
 6   @
    `
 8   
 9   
 :   
    
     
 =    
 =   @
    `
 @   
    
    
 C   
 D    
 E    
    @
 G   `
    
 I   
 J   
 K   
     
 M    
               P       Q       p              5    H    ^    t                             	   0    Y     
            
       *    6 
   E    t                    '    :    I    l                        )    d    x            _     u                                   N    a    s                          !    "    #    "   / !   ;     J    r $    %    $        &   * '   = (   S )   v (    '    &       ' *   : +   _ ,   r -    +       : .   N /   _ .        0    1    2    3   = 2   f 1   r 0        4    5   	    @	 6   T	 7   e	 6   	    ?
 8   U
 9   h
 :   ~
 ;   
 :   
 9   
 8   
    S <   l =    >    ?    =   6     @    A    @       u B   K    j C    D    E    F    E    D    C       @ G   W H   h G       2 I   E J   X K   f L    K    J    I       	 M   # N   4 M   l    "    Z @
     M
 P   `
     
 
RPrJ
 @ . .h ! p`0  rJ
 @             h    k    
 H   p
 
    
                     3            N     
     
    
     
 
RPrJ
 p . .h ! p`0  rJ
 p             `i    k    `
 H    
  
    @
                ;     S            n     `
     m
    |
     
 
RPrJ
  ) )h % !t 4 	rJ
               4j 	   k h   
 H           
     
    
       5     a                      
     
    
     
 
RPrJ
  ) )h % !t 4 	rJ
               k 	   k h   
 H            
     @
    `
     0 e                 .         ( 
     
    
      4
 
RprJ
   
     
 
 ` {                    n n4 2p bP0  rJ
 0 - -h )d %4 prJ
 0               `l 	   k 8   
 X           P         ! 
     
    S
     3 3x$ /h% +dT 'TS #4R L 
p  rJ
  p
     
     
    
    
    
    0
    P
    p
    
    
    
    
  # W#     {#    #    #    $    9$    Q$    $    $    $    $    I%    V%    ~% 	   %    & 
   '    S'    g'    )    )    ]*    *     * 5 5x 1h
 -4'  p
`P  rJ
   
 0
    P
    p
  + /,     Q,    ,    ,    .    / D D ? : +x 'h d T 4 p^! ^ X R J	 B
 : 5 0
 +x 'h #d) #T' #4& #  p     h b  *
U*h &t "d 4 S
P  rJ
  
 9 :     ; ` `4
 d
 T rp d T 4 p 4 p`P 4  
p	`P  7U7h
 -! &  d 4 S	 P'
 'T 4 r
	p`rJ
  
     
    
    
    0
    P
    p
    
    
 B C     $C    .C    RC    ^C    C    C    C    C    C 
 t
 d T 4
 r d T 4
 Rp d 4
 
prJ
 ` 
     
     
 I I     I    ZJ    J (
 (d2 $T1  40 * 
p  rJ
  0
 P
    p
    
  K AK     OK oK    K    K    .L    ;L    YL !   L L q !
 T  x h	  d L L q 
 
4 
 p  /
 /d1 +T0 '4. ( 
p  rJ
  
 
    
    
 N P     P    /Q    @Q    Q    !R  d	 4 Rp(
 (d $T  4  
p  rJ
  0
     P
     p
 S T     U    =U    U     U *
 *h
 &4&  
p	`P  rJ
  
 `V X     Y  4 RprJ
   
     
 Y Y    Z     + "Rp`P0rJ
 P  
      
    @
    `
    
    
    
    
     
     
    @
  Z WZ    jZ    Z    Z    Z    Z 	   Z 
   Z    [    
[     [    T 4 	p`rJ
  `
 
    
    
    
     
     
    @
    p
    
 	   
 	   
    
 [ [     [    '\    3\    Q\    ]\    ~\    \    \    \ 	   \ 
   \    \    	]  d
 4	 
RprJ
  @
     `
    
    
    
    
     
     
 0] P]    ]]    v]    ]    ]    ]    ]    ]     
^  
R0rJ
  @
     `
    
    
 @^ a^     k^    u^    ^    ^    d6 44 2 p  rJ
  
 @
     
    
     
     
 _ _     _    _    `    (`    4`    b`    `     ) )h# %4P H 
p	`P  rJ
 @ 
 p
     
    
    
    
    
    0
    P
    p
 ` `     `    %a    a    a    a    a    .b    Db    wb    b     b b    c    Jc     sc c    c    c    @d    xd    d     d ,	 ,4K B 
p`P  rJ
  
 
     
    
    
    
    
    0
    P
    p
  e Ye     ae    oe    e    f    (f    If    mf    f    f    f    f    >g    sg    g        T 4 	p`rJ
  
 
 g 	h     Li &
  p
`P0rJ
  
 
    i j     'j    %o  d
 4	 
RprJ
  
 
 q 2r     Yr  d
 4	 
RprJ
 0
 0
 pr r     s % %t !d T 4    rJ
 `
  s ,t     8t    Ut     gt  d
 4	 
RprJ
 
 
 pu u     v !   v v z !   v *w z ! h	 v *w z !F F ( #  	 4 v v z  x 
 0 04$  
p`P  rJ
 @
 `                                   Px x     x    x     x ,y     Ly    ay    w{    {    {    {    |     }     )} 
 
2PrJ
 p
 '
 'h 
p`0rJ
 p
              { 	   k      8           @    `     p} }     ~    P~    c~         (               s s k c [ S K C > 9x 5h 14< !2 p`P  rJ
 
   P      }     
 
RPrJ
 
    rJ
 
               } @            H   @ c                     d 4 prJ
  
          ! d2 0 ( } 
 T1 "x h 43 , 
p  )U)h  t d 4 S	 P:U:h
 6 (t d 4 S	 P 4 p`P 
 rJ
 0
 @         d 4 prJ
 `
 `                           @    `     	    
                     @    `                       &    D    P    q    }         	    
       Ē     
                ,    M    Y #
 #t
 d T 4
 rrJ
 
 p      ! !   P e  ! 4 P e  (
 (d< $T;  4: 4 
p  rJ
 
            @  A     P        &    2    >    t  BP0  rJ
 
 !	 !t2 d1 40 .   rJ
 
             Ѐ    k `   H   `                           R    u              ˙                       / /x h    d 4 2p R0rJ
 p
 0  .     G  d 4 2p bP0  rJ
 
 $ $d  4 
prJ
 
               0              	   k 8     X   	   k @   ` X                                                   0    P    p       -     3     6    T     	       Ğ 
   Ӟ              )             
       ݟ              `     n                 .    S    `    |              2pP0rJ
 
  4 
r	p`rJ
 
               @            H                P y                        '	      4&   p`P  * *h" &G p`P0$ $d  T 4  p  rJ
 
 0	 P	    p	  y     N        |     !     8 ! d   8 
 
4 
 p  $ $d  T 4  p  rJ
 @
 	 	 	        6    E    f    T 4 	p`rJ
 p
 	     
     0
    P
    p
  ӱ             e    {         0 04$  
p`P  rJ
 
 
 
 
           ش      &	 &T' "4%   	p`  rJ
 
 P     
         0                               '    ޶        t            Ʒ     !   P m | !
 
h d P m |  T 4
 Rp!   и   ! x 
h d
 и    T
 4 rp d
 4	 
RprJ
 
   2     Y  d
 4	 
RprJ
 
 P
 p ܻ      
 
RPrJ
 
 ! !4 prJ
 
               p 	   k 8     H     D     o       
    6      d T 4 2p. .x *h &t "d T 4 
	rJ
 @
  y     ) 
 
RPrJ
 p
 5
 5x# 1h$ !J p`0  rJ
 p
    
         X 	   k    
 H   P p                    
    0
    P
    p
 	   
 	          
    
 	       p m          R                     o        Q 	    
    	           U 
   g    p     	                   ' 
     
    H     i
 i4
 t
 d T rU U9 M: E; @< ;= 6> 1x? -h@ )t %d !T 4  	  rJ
 	
 `                               @    `     	        `          9    R    f                     	    
    	           &    5    A    P    \    k                     h R0 P0  rJ
  

 Z ZG RH JI BJ =K 8L 3xM /hN +d '4  
p  rJ
  

     &   )       	   k    h                          @    `                 	     	        @    `                         0    P                        0    P    p                      !   0 "   P    p               '   p '                  C    c    v                 	   N 
   ]    k     
       /    v                        3    V                 	   1    i             &   A     O V    e    s 	           F    T                (    <    U    n          !    "    #    "    !                "    1    =    I    m $   ~             %        
       '    (   
 '   5 )   E '   S     #%#
 t d 4
 #rP  rJ
 0

  ` 1     E   	p`P0  rJ
 `

              0    P         p                  #    b    n         ( (d $T  4  
p  rJ
 

                                        l     w %
 %4 
p`PrJ
 

 @     `                     P    p         	    	                                  (    J    V 	    
         d 4 
RprJ
  
 `     @ 0 S     q    }     # #h 
4 
p
 
RPrJ
 P
 0 0x ,h 9 p`0rJ
 P
              	   Hl    H                            @          #                               B     O O G ? : 5 0x ,h (d3 $T2  41 * 
p  rJ
 
  *                   "    4     J    V    y      P0  rJ
 
 $	 $d:  49 4 
p  rJ
 
              	   k h    h   `                             @       L                                                      4
 
RprJ
 
 ` 0 u     
 !     J 4 !# #h G E TD   J 4  > 
p`0  	 d! T  4  p   T 4 rp`0 0x ,h	 (d $T  4  
p  rJ
 

  4      [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  rJ
 @

                       b    .        P     	    
   s         	 
   F 	    X 	 
   4	    C	    R	    a	    p	    	    	     	 0 0x ,h	 (d $T  4  
p  rJ
 p

 p	 	     ^	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  rJ
 

                        @    `                 
     
     	 v	     	    	    	    	    2	    	    _	     	    w	 	   X		 
   C
	    
	    	 
   	    (	 
   	    	    "	    1	    @	    k	    	     	 0 0x ,h	 (d $T  4  
p  rJ
 

  @	 	     1	 [ [! S" K# C$ ;% 6& 1x' -h( )4] R 
p	`P  rJ
  
 	 F	     \	    r	    	    	    	    	    /	    	    G	 	   (	 
   	    	    	 
   	    	 
   	    	    	    	     	    K	    v	     	 !     	 ` 	  ! 4	   	 ` 	  
 
d
 
Rp
 
4	 
Rp
 
rPrJ
 0
 ;
 ;x/ 6h0 %b p`0  rJ
 0
                                        	   Hl    X   	   Hl     X   	   Hl   ` X   @                                        P    p 
                                  @    `          !	 !	     !	 "	    )"	 >"	    S"	    "	    "	    )#	    8#	    D#	    #	    $	 	   #$	    o$	 
   $	    $	 
   $	    8%	    r%	 
   ~%	    %	    %	    %	    P&	    &	    &	    &	    P'	    '	    '	    '	    (	    (	    R(	    o(	 `     m         -    :         
     u uA mB eC ]D UE MF EG @H ;xI 7hJ 34 # p`P  rJ
 
                      @     `                      	    !     !    @!    `! 
   ! 
   !    !    !     "     "    @" (	 *	     *	    *	    *	    *	    *	    +	    =+	    S+	    m+	    +	    +	    ~,	    ,	    ,	 	   -	 
   +-	 	   H-	    -	    -	    -	    
.	    /	 
   1	    2	    ]6	    k6	    6	    6	    6	    6	    
7	 
   B7	    7	    7	    7	    7	    7	    B8	     _8	  4	 
RprJ
  
 `"     "    "    "    "     #     #                      8	 8	      9	    9	    9	    9	     9	    .9	    :	 
 
2PrJ
 P
  4 
	p`rJ
 P
                @           @# 8    :	 :	     .;	 @#     M#    h#     O O G ? : 5 0x ,h (d3 $T2  41 * 
p  rJ
 
 @;	 ;	     E>	 k>	     >	    >	    >	    >	     >	    >	    ?	    ?	 O O G ? : 5 0x ,h (d3 $T2  41 * 
p  rJ
 
 p#     #    #     #    # ?	 ?	     B	 B	     B	    B	    B	    C	     C	    $C	    GC	    YC	 5 5xx 1hy -4  p
`P  rJ
 
 $ 0$    P$    p$    $    $    $    $    %    0% 	   P% 	   p% 	   %    % 
   %    %    & 
   &    0&    P&    p&    p&    &    &    &    &    &    '    0'    P'    p'    '    '     '     '     (     0(     P(     p(     (     ( (   ( (   ( *   ) *   0) *   P)    p)    )    ) 
   ) 	   ) 2   *    0*    P*    p*    * * C	 (D	     @D	    gD	    D	    D	    D	    D	    D	    $E	    <E	 	   RE	 
   hE	 	   E	    E	 	   G	     G	 
   6G	    lG	    G	    G	    H	    !H	    OH	    H	    I	    'I	    I	    ?J	    VJ	    J	    J	    NK	     qK	 !   K	     K	 "   K	     'L	 #   9L	     lL	 $   ~L	     ?M	 %   VM	     M	 &   M	     N	 '   N	 (   Q	 )   .R	 *   R	 +   ,S	 ,   ET	 -   T	 *   T	 (   'U	     _U	    nU	    }U	    U	 .   U	    U	 /   U	    U	 0   U	    U	 1   U	 
   U	    U	 2   dV	 3   sV	 2   {V	 	   V	 4   V	    V	 5   <W	    JW	 6   W	    W	 7    X	    X	 8   jX	  BP0  rJ
 
 . . )x %h !t d 4    rJ
 
               | 	   k (   * H              P+    p+ X	 ZY	     =Z	 *     *    *    +    &+    3+    >+      BP0  rJ
 @
 . . )x %h !t d 4    rJ
 @
               T 	   k (   + H              ,    0, pZ	 *[	     
\	 +     +    +    +    +    +    +     1 1 , 'x #h T 4  p`  rJ
 p
 P, @\	 W]	     e]	  BP0  rJ
 
 . . )x %h !t d 4    rJ
 
               | 	   k (   p, H              ,    - ]	 ^	     _	 p,     ~,    ,    ,    ,    ,    ,      BP0  rJ
 
 . . )x %h !t d 4    rJ
 
               T 	   k (   0- H              -    - _	 }`	     `a	 0-     >-    P-    d-    -    -    -      BP0  rJ
  
 . . )x %h !t d 4    rJ
  
               , 	   k (   - H              p.    . a	 Mb	     0c	 -     -    .    $.    F.    S.    ^.      BP0  rJ
 0
 . . )x %h !t d 4    rJ
 0
                	   k (   . H              0/    P/ `c	 d	      e	 .     .    .    .    /    /    /     !   0e	 e	  ! d 0e	 e	   t	 T 4 2 4	 
RprJ
 `
 Pf	 kf	    f	    f	    f	    f	    f	     f	 / /h2 +dn 'Tm #4l f 
p  rJ
 
 p/ /    /    /    /    0    00    P0    p0    0 	   0 	   0 f	 Bg	     [g	 {g	    g	    g	    g	    /h	    <h	    Kh	    i	    i	    j	    j	    <k	 	   k	 
   k	 	   
m	    m	 	   *m	    9m	    }m	    m	 $
 $T  4 r
	p`rJ
 `
  n	 -n	      4 r
p	`PrJ
 
 0o	 Xo	     $
 $T  4 r
	p`rJ
 
 p	 =p	      4 r
p	`PrJ
 
 0 @q	 hq	     Y Y K 'x h d T 4 p, , 'x #h
  
	p`P0rJ
  
  1     @1 `v	 v	     v	    y	     y	 y	    *~	     6~	  d T 4 prJ
 p
 `1 p~	 ~	     o	 / /x' *h( %4[ R 
p`P  rJ
 
 1 	 ق	     	 . .x *h &T3 "42 * 	p`  rJ
 
 1 @	 
	     )	 + +x! 'h" #TO 4N F 	p`  rJ
  
 1 	 	     2	  d8 47 4 p  rJ
 0
 1 	 	     	 '
 'T #4 
	p`rJ
 `
  2      2 	 n	     ҏ	    	  h  0  rJ
 
 @2 	 	     T	 8 8& 3x' /h( "S p`P0rJ
 
 `2     2     2     2     2      3      3     @3    `3 	 	     )	    >	     ے	    	     	    ȓ	     	    $	     	    	     ژ	    	     
	    #	    0	    <	     K	 . .x *h &t "d T 4 
	rJ
  
  	 	     ɚ	 
 
RPrJ
 P
 5
 5x# 1h$ !J p`0  rJ
 P
    
         @ 	   k     5 H   3 3    3    3     4     4    @4    `4    4    4 	   4 	          4     5 	        	 	     y	    	    	    	    	    	    /	    U	    	 	   	 
   j	 	   v	    	    	 
   )	    2	    A	 	   	    	    	    ʤ	    ֤	  5     -5    x5      4 Rp`PrJ
 
 	 	     	  4 p`PrJ
 
 5     5  	 `	     	    *	 
 
RPrJ
 
 0 0x ,h 9 p`0rJ
 
             d 	   Hl   06 H   5            5    6         P	 	     	    3	    	    	    	    	     Z	 06     =6    6     9 9
 4 /x +h 'd) #T( 4& " p  rJ
 @
 6     6     6      7     7    @7 	 	     [	    5	     	    ;	     c	    	    	    U	    a	    p	     ͭ	 !   	 A	   !$
 $h $ , T+ 4* 	 A	    % 
	p` d2 41 . p  rJ
 p
 `7 	 	     	 
 
rPrJ
 
 ;
 ;x3 6h4 %j p`0  rJ
 
                          Է              	   Hl    09 X   	   Hl   `8 X   	   Hl   7 X   7         7     8     8    @8                  8    8 
   8    8    9                  `9    9    9    9    9  	 	     	 	    )	 >	    S	    	    	    )	    8	    D	    ƶ	    	 	   #	    o	 
   	    	 
   ַ	    8	    r	 
   ~	    	    ø	    Ҹ	    P	    չ	    	    	    P	    	    	    Һ	    	    	    R	    o	 7     7    7     m8    z8     =9    J9     u uC mD eE ]F UG MH EI @J ;xK 7hL 34 # p`P  rJ
 
  :      :    @:    `:    :    :    :    :     ;     ; 	   @;    `;    ;    ; 
   ; 
   ;     <     <    @<    `<    < 	 	     	    	    ý	    	    	    	    =	    S	    m	    	    	    {	    	    ӿ	 	   	 
   "	 	   9	    	    	    	    	    	 
   	    	    M	    [	    	    	    	    	    	 
   2	    o	    	    	    	    	    2	     O	 , , 'x #h
  
	p`P0rJ
  
 	 	     	    >	     J	 ]	    	     	 , ,h  
	p`P0/ /h3 +dp 'To #4n h 
p  rJ
 0
 < <    <     =     =    @=    `=    =    =    = 	   = 	    > p	 	     	 	    8	    Q	    w	    	    	    	    		    ,	    I	    m	    	 	   	 
   	 	   	    	 	   	    	    	    2	 8 8& 3x' /h( "S p`P0rJ
 `
 	 	     )	    >	     	    	     	    	     	    $	     	    	     	    	     
	    #	    0	    <	     K	 +
u+h s% 
	p`0P  rJ
 
  > 	 w	     5	  d T 4
 rprJ
 
 p	 	     	 !   h     !  t"  T#  4$  	 G	  !I Ih 9  /! t" T# 4$  	 G	   % ` 4	 
RprJ
 
 @> `> 	 C	     	    	 $
 $d  T 4 prJ
  
 > 	 n	     	 #
 #h T 4 p`rJ
 P
 >     >  	 v	     	    v	     	 / /	 *x
 &h "4#  
p`P  $
 $T 4
 R
	p`rJ
 
 >  ?     ?    @? `
 
     
    H
    
    
 
 
RPrJ
 
 ? ? : 5x 1h !, p`0  rJ
 
 	   	   
      p    k   @ H   `? ?    ?    ?    ?     @     @    @@    `@               
 =
     L
    m
    
    
    `
    
    
    
    
    L
    X
    g
    
 
    N
 	   o
    1
    i
    u
    
    
 @     @ 
   @     C C ; 6 1x -h )4UJ
p	`P  rJ
 
 @     @    @    A     A    0A    PA    pA    pA    A    A 
   A 
   A    B    0B    PB    pB    B    B    B    B    C    0C    PC    pC    C    C    C    C    D    0D    PD    pD    pD !   D "   D    D    D %   E    0E    PE    pE )   E *   E *   E )   E -   E )   F    0F     PF )   pF 2   F 3   F 4   F 4   F 3   F 7   G 7   0G 9   PG :   pG :   G 9   G =   G >   G >   G =   G A   H B   0H B   PH D   pH D   H B   H B   H H   H H   I A   0I =   PI 9   pI 3   I    I     I 7   I Q   J Q   0J 7   PJ T   pJ 7   J V   J W   J W    K V    K V    K 7   @K \   `K \   K 7   K _   K 7   K a   L b   0L b   PL a   PL a   pL 7   L g   L g   L 7   L j   M j   0M 3   PM    pM     M 7   M p   M 7   M r   N 3   0N    PN     pN r   N r   N r   N r   N r   O r   0O r   PO r   pO r   O r   O r   O r   O r   P    0P 3   PP    pP     P 	
 	
     	
    	
    	
    !

    
 	   /
 
   
    
    W
 
   p
    
    
    
    
    
    
    A
    b
    
    
    
    
    
    
    O
    y
    
    
    
    
 !   
 "   
 #   
 "   
 !   v
 $   
    
 %   
 &   =
 %   K
    [
 '   i
    w
    
 (   
 )   _
 +   
 -   
 .   
 -   -
 /   <
 )   K
    
    
    
    
    :
 
   F
    ~
 0   
    
 1   
     
 
 )   
 2   
 3   
 5   
 7   4
 8   
 9   
 ;   
 =   
 ?   '
 A   c
 B   
 C   
 D   
 E   
 D   
 F   3
 D   B
 B   
 G   2
 H   H
 I   [
 H   
 J   
 H   
 B   Y
 K   h
 A   w
 L   
 =   
 M   
 9   
 7   
 N   
 3   
 2   
 )   
    #
    2
    j
    
    
 
   
    
 O   -
    5
 P   D
     L
 a
 7   &
 Q   &
 R   &
 Q   '
 S   *'
 Q   6'
 7   v'
 T   '
 U   '
 V   H(
 X   {(
 Z   )
 [   )
 V   )
 7   `.
 \   s.
 ]   .
 \   .
 ^   .
 \   .
 7   +/
 _   G/
 `   ]/
 a   /
 c   0
 e   :1
 f   I1
 a   X1
 7   2
 g   2
 h   2
 g   2
 i   3
 g   +3
 7   F3
 j   y5
 k   5
 j   N6
 l   i6
 j   6
 7   6
 m   6
 3   6
 2   6
 )   6
    77
    F7
    ~7
    7
    7
 
   7
    28
 n   A8
    I8
 o   X8
     `8
 u8
 7   9
 p   9
 q   :
 p   &:
 7   A:
 r   Y:
 s   :
 r   ;
 7    ;
 t   /;
 3   >;
 2   M;
 )   \;
    ;
    ;
    ;
    <
    K<
 
   W<
    <
 u   <
    <
 v   <
     <
 <
 r   F=
     H=
 r   \=
 w   =
 r   =
 x   f>
 r   >
 y   >
 r   $?
 z   ?
 r   ?
 {   .@
 r   T@
 |   @
 r   @
 }   A
 r   A
 ~   B
 r   B
    fC
 r   C
    (D
 r   ND
    D
 r   E
    E
 r   E
 7   E
    E
 3   E
 2   F
 )   F
    LF
    [F
    F
    F
    G
 
   G
    GG
    VG
    ^G
    mG
     uG
 G
 r   G
    G
    G
    G
 $H
       rJ
  
 
     0
 H
 8I
     DI
    aI
     sI
  B  
 b  rJ
 
 P  W TW     iW 
 b  rJ
 
 P W W     W 
 b  rJ
 
 P W X     )X 
 b  rJ
 
 Q pX X     X 
 b  rJ
 @
 0Q X Y     Y 
 b  rJ
 p
 PQ 0Y dY     yY  h b  !   [ [ 
 ! t [ [ 
 !    \ 2\ 
 ! t  \ 2\ 
 !   p\ \ 
 ! t p\ \ 
 !   \ \ 
 ! t \ \ 
     20bP
    J
 YK
 kQ       t
 T	 4 2 t
 d	 4 RbP
    kN
 MO
 Q MO
 eN
 SO
 Q     	 4
 rp`bP
    O
 O
 Q O
  bp`0  bP
    7P
 XP
 R     	 B  bP
    Q
 Q
 @R Q
 
 
4 
2p                                   @                 k            p                 k            xJ
                                            @                     l         @                     l         @                                             8  @                     l         @   @                                           @                                            @                     pl         @                                               @  @                     Hl         @   0                                           @                 l         @   0                      8                                                                              `                                                                         P                                                     @                      q         @   `                0 X @                     pq         @                    pn            J
                  @                     q         @   `                 k                             8 @                     r         @                     @p            J
                  @                     m         @                     @                     xm         @   P                  @                     Hm         @                   P @                 `r         @                    P                            @   H                                             p                          h   P'                  @       (   P!                 m     h                                                       @   H                                                                          h    <                 p     @                    x     @                                         X                              @   =                          (   P!                 k (          p                 k (          xJ
                 m     @                                                         @                                p         X   @                 X         @   0>                 k (                           ж     X                        @   H                                                                           h   <                 `                         H p  X @                                               h                    `         P   PX                 @n         (   @                  (       (   P!                 m     P                          p     0                    p  @  @   H                                                                          h   y                                             H   @   H                                                 @                           h   z                                               @   H                                                0                          h   `                 o         @                         h                       @   H                                С                             p         h                      d          2 @` (          b P           `                               v     f     L     0     (             
     
     x
     <
               J                    <     
     
     J
     	     	     t	     8	                         8               b                    P     
                              b                     J          x     &               \     :                 n                            T          t     l     0                         P          V                    D          B               
          f               t     "                                      |     p     b     P     F     >     ,                                                  |     p     ^     L     .                                             \     @     *                                        |     v     p     j     b     \     V     N     F     >                  n     P     :                                                   |     n     Z     L     :          
                                        x     j     V     B     &                                             t     \     6     $                                        |     h     Z     @     &          
                                        z     d     P     <     (                                             x     h     T     >     &                                   v     b     L     <     (                                             t     `     J     6     "                                        h     J     :     (                                             l     Z     F     0                                        F     ~                                                       PyErr_Format  0 PyCObject_AsVoidPtr  PyExc_RuntimeError  6 PyCObject_Type   PyExc_AttributeError  	PyObject_GetAttrString   PyErr_SetString  PyExc_ImportError CPyImport_ImportModule  PyErr_CheckSignals  PyObject_GetAttr  _PyList_Append  PyExc_ArithmeticError  PyExc_OverflowError  PyExc_IndexError   PyExc_IOError  PyExc_ValueError   PyExc_TypeError  PyExc_MemoryError  PyErr_Occurred  _Py_NoneStruct   PyBaseObject_Type SPyInt_FromSsize_t PyObject_GC_Track PyObject_GC_UnTrack P PyCode_New  mPySlice_New PyTuple_Pack   PyExc_NameError  PyEval_EvalFrameEx  !PyFrame_New _PyThreadState_Current   PyEval_EvalCodeEx  PyDict_Next PyTuple_New _Py_CheckRecursiveCall  _Py_CheckRecursionLimit  PyDict_Size  PyExc_SystemError PyObject_Call / PyCFunction_Type  -PyFunction_Type PyUnicodeUCS2_Decode  PyUnicodeUCS2_FromUnicode } PyDict_GetItem  PyObject_CallMethodObjArgs  WPyInt_Type  ,PyUnicode_Type  PyString_Type 2PyGILState_Release   PyErr_WriteUnraisable PyString_FromString  PyErr_PrintEx 0PyGILState_Ensure uPyString_AsString  PyDict_SetItem  _PyString_Eq  PyUnicodeUCS2_Compare PyType_IsSubtype   PyExc_BaseException  PyErr_NormalizeException  PyTraceBack_Type  PyObject_GetItem   PyErr_Clear  PyErr_ExceptionMatches  PyTuple_Type  kPyList_Type PyObject_RichCompare  PyFloat_Type  PyLong_Type _Py_ZeroStruct  _Py_TrueStruct  PyMethod_Type PyObject_CallFunctionObjArgs  QPyInt_FromLong   PyDict_New  PyModule_GetDict  ePyList_New  PyObject_SetAttr   PyErr_Restore PyObject_Not   PyErr_Fetch _PyObject_GetDictPtr  PyMem_Realloc PyMem_Malloc  ~PyString_FromFormat PyTraceBack_Here  ~PyLong_FromUnsignedLong PyObject_IsSubclass  PyErr_GivenExceptionMatches N PyClass_Type   PyObject_SetAttrString  PyType_Ready  7PyImport_AddModule  UPySequence_GetItem   PyExc_StopIteration  PyErr_SetNone _PyObject_CallFunction_SizeT   PyExc_GeneratorExit PyObject_CallObject 	 PyArg_UnpackTuple PyObject_GC_Del PyObject_ClearWeakRefs   PyErr_WarnEx   PyExc_RuntimeWarning  IPyRun_StringFlags  PyDict_SetItemString  PyObject_SelfIter PyObject_GenericGetAttr QPy_GetVersion PyOS_snprintf APyImport_Import PyObject_Hash PyString_FromStringAndSize  PyString_InternFromString PyUnicodeUCS2_DecodeUTF8  v_PyByteArray_empty_string vPyString_AsStringAndSize  & PyByteArray_Type  PyObject_IsTrue LPyInt_AsSsize_t PyNumber_Index  qPyLong_AsSsize_t  PyObject_GetIter  PyFloat_FromDouble  PyFloat_AsDouble   PyDict_Type aPySequence_Tuple   PyExc_AssertionError  "PyObject_Size `Py_OptimizeFlag 
 PyBaseString_Type mPyLong_AsLong rPyLong_AsUnsignedLong sPyLong_AsUnsignedLongLong _PyObject_GC_New  PyNumber_Add  PyObject_IsInstance !PyObject_SetItem  PyNumber_Subtract  PyExc_Exception  PyExc_NotImplementedError . PyCFunction_NewEx UPy_InitModule4_64 PyUnicodeUCS2_FromStringAndSize  PyErr_SetObject python27.dll  o??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@AEBV01@@Z  _??1?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 
?replace@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0PEBD@Z  	?npos@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@2_KB ?find@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z  t??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD@Z i ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBDAEBV10@@Z ?erase@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV12@_K0@Z  ?find_first_of@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA_KPEBD_K1@Z e ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@0@Z  g ??$?HDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@AEBV10@PEBD@Z  ??$?MDU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  ]?_Lock@_Mutex@std@@QEAAXXZ  ?_Unlock@_Mutex@std@@QEAAXXZ  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  , ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@0@Z  - ??$?8DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YA_NAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAV01@AEAV01@@Z@Z  ?endl@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z   ??$?6DU?$char_traits@D@std@@V?$allocator@D@1@@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@0@AEAV10@AEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@0@@Z  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@N@Z  ?swap@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEAV12@@Z \??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UEAA@XZ O_LNan ??_D?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@O@Z  Y?setprecision@std@@YA?AU?$_Smanip@_J@1@_J@Z ??0?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z  G_Inf  v??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@PEBD_K@Z y??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@XZ 7?flush@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV12@XZ ?_Osfx@?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?uncaught_exception@std@@YA_NXZ Z?setstate@?$basic_ios@DU?$char_traits@D@std@@@std@@QEAAXH_N@Z ?sputc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAAHD@Z  ?sputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@QEAA_JPEBD_J@Z  ??_D?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXXZ ?str@?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@XZ  ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@H@Z  d??0?$basic_ostringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@H@Z "??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_J@Z $??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_N@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@I@Z  #??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@_K@Z z??0?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAA@_KD@Z  ?str@?$basic_stringstream@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAXAEBV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z N_LInf j??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAA@XZ !
?overflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z +
?pbackfail@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHH@Z  j?showmanyc@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JXZ  ?underflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ ?uflow@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ &?xsgetn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_J@Z ?_Xsgetn_s@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEAD_K_J@Z  )?xsputn@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAA_JPEBD_J@Z ?sync@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAHXZ  ?imbue@?$basic_streambuf@DU?$char_traits@D@std@@@std@@MEAAXAEBVlocale@2@@Z  :?flush@std@@YAAEAV?$basic_ostream@DU?$char_traits@D@std@@@1@AEAV21@@Z c?setw@std@@YA?AU?$_Smanip@_J@1@_J@Z [_Nan  ??_D?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAXXZ  L?get@?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAHXZ ??5?$basic_istream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@AEAN@Z ?exceptions@ios_base@std@@QEAAXH@Z  @??0?$basic_istream@DU?$char_traits@D@std@@@std@@QEAA@PEAV?$basic_streambuf@DU?$char_traits@D@std@@@1@_N@Z O?setg@?$basic_streambuf@DU?$char_traits@D@std@@@std@@IEAAXPEAD00@Z  `??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ^??Y?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@AEBV01@@Z  J?c_str@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBAPEBDXZ  
?quiet_NaN@?$numeric_limits@N@std@@SANXZ  ?cout@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??4?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEAAAEAV01@PEBD@Z ??6?$basic_ostream@DU?$char_traits@D@std@@@std@@QEAAAEAV01@P6AAEAVios_base@1@AEAV21@@Z@Z  d?close@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ ?substr@?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@QEBA?AV12@_K0@Z  P?cerr@std@@3V?$basic_ostream@DU?$char_traits@D@std@@@1@A  ??_D?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXXZ  	?open@?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAAXPEBDHH@Z  ??0?$basic_fstream@DU?$char_traits@D@std@@@std@@QEAA@XZ MSVCP90.dll {atan  |atan2 ceil  cos exp floor log pow sin sqrt  <tan _time64  ??0exception@std@@QEAA@AEBQEBD@Z  E ?what@exception@std@@UEBAPEBDXZ  ??1exception@std@@UEAA@XZ  ??3@YAXPEAX@Z 	 ??0exception@std@@QEAA@AEBQEBDH@Z c __CxxFrameHandler3   ??0exception@std@@QEAA@XZ 
 ??0exception@std@@QEAA@AEBV01@@Z  _purecall 
 ??1bad_cast@std@@UEAA@XZ   ??0bad_cast@std@@QEAA@PEBD@Z  I _CxxThrowException  malloc  free  _invalid_parameter_noinfo  ??0bad_typeid@std@@QEAA@PEBD@Z   ??1bad_typeid@std@@UEAA@XZ  l __RTDynamicCast  ??2@YAPEAX_K@Z  memmove_s  ??0bad_cast@std@@QEAA@AEBV01@@Z =_errno  memcpy  memcmp  log10  ??0bad_typeid@std@@QEAA@AEBV01@@Z clock MSVCR90.dll Y __C_specific_handler  _unlock  __dllonexit 7_encode_pointer =_lock _onexit -_decode_pointer N_malloc_crt _initterm _initterm_e 8_encoded_null  _amsg_exit  Z __CppXcptFilter C ?terminate@@YAXXZ 8 ?_type_info_dtor_internal_method@type_info@@QEAAXXZ { __clean_type_info_names_internal  Sleep  DisableThreadLibraryCalls QueryPerformanceCounter GetTickCount  GetCurrentThreadId  GetCurrentProcessId GetSystemTimeAsFileTime KERNEL32.dll            eY                   E   stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835.pyd initstanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835                                                                                                                                    H   X   h      @r                  Wrapper for call_sampler in stan_fit

    This function is self-contained and suitable for parallel invocation.

       X             P            Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}
            parameter name(s); by default use all parameters of interest

        Note
        ----
        This is currently an alias for the `traceplot` method.
                  Visualize samples from posterior distributions

        Parameters
        ---------
        pars : {str, sequence of str}, optional
            parameter name(s); by default use all parameters of interest
                  Extract samples in different forms for different parameters.

        Parameters
        ----------
        pars : {str, sequence of str}
            parameter (or quantile) name(s)
        permuted : bool
            If True, returned samples are permuted. All chains are merged and
            warmup samples are discarded.
        inc_warmup : bool
           If True, warmup samples are kept; otherwise they are discarded. If
           `permuted` is True, `inc_warmup` is ignored.

        Returns
        -------
        samples : dict or array
        If `permuted` is True, return dictionary with samples for each
        parameter (or other quantity) named in `pars`.

        If `permuted` is False, an array is returned. The first dimension of
        the array is for the iterations; the second for the number of chains;
        the third for the parameters. Vectors and arrays are expanded to one
        parameter (a scalar) per cell, with names indicating the third dimension.
        Parameters are listed in the same order as `model_pars` and `flatnames`.

              
        Expose the log_prob of the model to stan_fit so user can call
        this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.

        Note
        ----
        In Stan, the parameters need be defined with their supports. For
        example, for a variance parameter, we must define it on the positive
        real line. But inside Stan's sampler, all parameters defined on the
        constrained space are transformed to unconstrained space, so the log
        density function need be adjusted (i.e., adding the log of the absolute
        value of the Jacobian determinant).  With the transformation, Stan's
        samplers work on the unconstrained space and once a new iteration is
        drawn, Stan transforms the parameters back to their supports. All the
        transformation are done inside Stan without interference from the users.
        However, when using the log density function for a model exposed to
        Python, we need to be careful.  For example, if we are interested in
        finding the mode of parameters on the constrained space, we then do not
        need the adjustment.  For this reason, there is an argument named
        `adjust_transform` for functions `log_prob` and `grad_log_prob`.

              
        Expose the grad_log_prob of the model to stan_fit so user
        can call this function.

        Parameters
        ----------
        upar : array
            The real parameters on the unconstrained space.
        adjust_transform : bool
            Whether we add the term due to the transform from constrained
            space to unconstrained space implicitly done in Stan.
         Obtain adaptation information for sampler, which now only NUTS2 has.

        The results are returned as a list, each element of which is a character
        string for a chain.              Get the log-posterior (up to an additive constant) for all chains.

        Each element of the returned array is the log-posterior for
        a chain. Optional parameter `inc_warmup` indicates whether to
        include the warmup period.
               Obtain the parameters used for the sampler such as `stepsize` and
        `treedepth`. The results are returned as a list, each element of which
        is an OrderedDict a chain. The dictionary has number of elements
        corresponding to the number of parameters used in the sampler. Optional
        parameter `inc_warmup` indicates whether to include the warmup period.
                       Get the posterior mean for all parameters

        Returns
        -------
        means : array of shape (num_parameters, num_chains)
            Order of parameters is given by self.model_pars or self.flatnames
            if parameters of interest include non-scalar parameters. An additional
            column for mean lp__ is also included.
                     Transform parameters from defined support to unconstrained space                                         %                       %                                                  0                          @   p                                                   ,                           L                         T                           \                           h                           x                            P    p                                                                                                                                                    (                                                                                                          p               >                                                   P6   6                                                   E&        &    P'                                    3           @4                                                           %                                                                                                             v                     v                                    (   P           "   8              #   @                      P   @                  X   0/          @'   h   1           -   x   `          .      P          p/                 p0      @           2      3          p3      P                                            `                                         0   p                  H   e                  `   `y                  x    f                     py                                                               y                     y                                                                          Pe                           $                           D                          0                           @   P    p                    P                             \                           d   `                        p       0                                                  p                                                                                        +                                                            0                                             h               -                                               =   @>                                              E&        0)     *                                    P8           <                                           @            f                                                                                                          0                   ,                                                                                                                    A&             -     .                                                                                                                    `,                                                                                                                               /                                                                                                                    A&             /                                                                                                                            p.                                                                                                                              0                                                                                                                    A&             P1    1                                                                                                                    0                                                                                                           `                   2                                                                                                                    A&             `3                                                                                                                             2                                                                                    4   j                  q               l   @m           x                                             l                                H                                                                     t    t               (   0u    Pu    8                                                                                  X   p               `s                                                                                                                    A             q                    8               l    0F   F   0G                                                                                                                           s            iW
@      <                            `                              ċ                              (                             &                      H      &                      x                                                      н                              ؖ   <                      @   (   #                      x                                                      @   t                                                    X   x                           ̋                                                         $                         |                                                   P                              @                         @      
                     X      	                            (                            A                                                                                                          (                        0                                                       X   8                                                      H                                                                                  X                              	                     p   (                        h      
                        H                        `                           p   x   
                         $                                                   й   ԋ                                                                                                                                           t                      p                           (   @                              	                        ,                                                   h                           H                           8   h                        (   (   
                     8                           h   ܋                        x                           x      
                        4                           <                               L                      м   D                                                    H      
                         L                           Ȏ   	                      x   X                            H                                                   8   T                           8   
                                                0   \                                                   @                                                            
                     p                              d                        ػ                                 
                                                   ȏ   
                     P   l                        л                                                          ؏   
                     `                           x   x   
                        ؎   
                     (   `                        غ   H   
                           	                        (                        P      	                        X   
                     (   t                        ؾ      
                     X                                                            .                                                                            P   Ȑ                        0      
                     Ƚ                                 	                     @                                 
                                                                               0                                                   x      	                        Ȓ                           8   
                     `      
                     P                           p                           ȹ                              ؐ                                                   X                           X                                                       `      "                         H                        8                           H       x                                                    8   '                      0      "                                                     h   
                        Č                                                   H   $                        @   P                           ؒ                                                         	                     (   ,                        0   ̌                        (                           H   Ԍ                        H                              (                        ؼ   ȓ                                                      x   
                                                   ܌                            X                            X                           `                                                      (   
                                                                           `   0                           8                        ȼ   8   
                        h                        h   (   	                        h                        (   p                        X   x                        ع   ȑ                        H   4                            <                        h                           X                           H                              p                           Д                              ?                     @   8   	                                                                                 
                     8                              x   	                     P   H   	                        H   
                     h   T                        0                              H   	                                                x                              X   
                           
                        ؑ                           h   
                     8                              X   	                      h   `   %                      P   \                                                   @   d                                                     P                                                                                     č                        0   ̍                                                       ԍ                        p                              l                           h   	                     к                                                                   
           .?AVbad_exception@std@@ 
           .?AVexception@std@@     
           .?AVbad_alloc@std@@     
           .?AVlogic_error@std@@   
           .?AVdomain_error@std@@  
           .?AVinvalid_argument@std@@      
           .?AVlength_error@std@@  
           .?AVout_of_range@std@@  
           .?AVruntime_error@std@@ 
           .?AVoverflow_error@std@@        
           .?AVunderflow_error@std@@       
           .?AVrange_error@std@@   
           .?AVvar_context@io@stan@@       
           .?AVclone_base@exception_detail@boost@@ 
           .?AVsp_counted_base@detail@boost@@      
           .?AVbad_lexical_cast@boost@@    
           .?AVbad_cast@std@@              
           .?AVbase_writer@writer@interface_callbacks@stan@@       
           .?AVvari@math@stan@@    
           .?AVrounding_error@math@boost@@ 
           .?AVbase_adapter@mcmc@stan@@    
           .?AVbase_mcmc@mcmc@stan@@       
           .?AVbase_adaptation@mcmc@stan@@ 
           .?AVfixed_param_sampler@mcmc@stan@@     
           .?AVchained_var_context@io@stan@@       
           .?AVbad_typeid@std@@    
           .?AVfailure@ios_base@std@@              
           .?AV?$var_context_factory@Vpy_var_context@io@pystan@@@var_context_factory@interface_callbacks@stan@@            
           .?AU?$located_exception@Vbad_alloc@std@@@lang@stan@@            
           .?AU?$located_exception@Vbad_cast@std@@@lang@stan@@             
           .?AU?$located_exception@Vbad_exception@std@@@lang@stan@@        
           .?AU?$located_exception@Vbad_typeid@std@@@lang@stan@@           
           .?AU?$located_exception@Vexception@std@@@lang@stan@@            
           .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         
           .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@         
           .?AV?$base_hamiltonian@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_point@mcmc@stan@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@        
           .?AV?$base_integrator@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      
           .?AV?$base_integrator@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@      
           .?AV?$base_integrator@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@     
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@              
           .?AV?$sp_counted_impl_p@V?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@@detail@boost@@  
           .?AVwindowed_adaptation@mcmc@stan@@     
           .?AVstepsize_adaptation@mcmc@stan@@     
           .?AVstepsize_adapter@mcmc@stan@@        
           .?AVstream_writer@writer@interface_callbacks@stan@@     x                   
           .?AV?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     
           .?AV?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@     
           .?AV?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    
           .?AV?$base_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$base_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$base_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       
           .?AV?$unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                
           .?AV?$dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      
           .?AV?$adapt_unit_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           
           .?AV?$adapt_unit_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$adapt_diag_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@           
           .?AV?$adapt_diag_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@ 
           .?AV?$adapt_dense_e_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@          
           .?AV?$adapt_dense_e_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@                
           .?AV?$basic_pointerbuf@DV?$basic_streambuf@DU?$char_traits@D@std@@@std@@@detail@boost@@         
           .?AV?$basic_streambuf@DU?$char_traits@D@std@@@std@@     
           .?AVexception@boost@@   
           .?AUbad_alloc_@exception_detail@boost@@ 
           .?AUbad_exception_@exception_detail@boost@@     H           H   H           
           .?AU?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@         
           .?AV?$clone_impl@U?$error_info_injector@Vruntime_error@std@@@exception_detail@boost@@@exception_detail@boost@@  
           .?AU?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@      
           .?AV?$expl_leapfrog@V?$unit_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$expl_leapfrog@V?$diag_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@        
           .?AV?$expl_leapfrog@V?$dense_e_metric@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@@mcmc@stan@@       
           .?AU?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@          
           .?AV?$clone_impl@U?$error_info_injector@Vinvalid_argument@std@@@exception_detail@boost@@@exception_detail@boost@@               
           .?AV?$clone_impl@Ubad_alloc_@exception_detail@boost@@@exception_detail@boost@@  
           .?AV?$clone_impl@Ubad_exception_@exception_detail@boost@@@exception_detail@boost@@              
           .?AV?$clone_impl@U?$error_info_injector@Vlength_error@std@@@exception_detail@boost@@@exception_detail@boost@@   
           .?AU?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@    
           .?AV?$clone_impl@U?$error_info_injector@Vbad_lexical_cast@boost@@@exception_detail@boost@@@exception_detail@boost@@             
           .?AV?$basic_unlockedbuf@V?$basic_streambuf@DU?$char_traits@D@std@@@std@@D@detail@boost@@        
           .?AU?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@          
           .?AU?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@        
           .?AV?$clone_impl@U?$error_info_injector@Vdomain_error@std@@@exception_detail@boost@@@exception_detail@boost@@   
           .?AV?$clone_impl@U?$error_info_injector@Voverflow_error@std@@@exception_detail@boost@@@exception_detail@boost@@ 
           .?AU?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@ 
           .?AV?$clone_impl@U?$error_info_injector@Vrounding_error@math@boost@@@exception_detail@boost@@@exception_detail@boost@@          
           .?AU?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@           
           .?AV?$clone_impl@U?$error_info_injector@Vlogic_error@std@@@exception_detail@boost@@@exception_detail@boost@@    H           H                                       (   (         (            0         0   
           .?AVsample@mcmc@stan@@  Ј   
           .?AVps_point@mcmc@stan@@        
           .?AVunit_e_point@mcmc@stan@@    
           .?AVsum_values@pystan@@ 
           .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              
           .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vunit_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@       
           .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@              
           .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdiag_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_static_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@      
           .?AV?$base_hmc@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@             
           .?AV?$base_nuts@Vanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@Vdense_e_metric@mcmc@stan@@Vexpl_leapfrog@45@V?$additive_combine_engine@V?$linear_congruential_engine@I$0JMEO@$0A@$0HPPPPPKL@@random@boost@@V?$linear_congruential_engine@I$0JOPE@$0A@$0HPPPPPAH@@23@@random@boost@@@mcmc@stan@@    
           .N      
           .?AV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@std@@       
           .?AVprob_grad@model@stan@@      
           .?AVstepsize_var_adapter@mcmc@stan@@    
           .?AVstepsize_covar_adapter@mcmc@stan@@  H   U   Z   
           .?AVop_vv_vari@math@stan@@      
           .?AVop_vd_vari@math@stan@@      
           .?AVadd_vv_vari@?A0x5e4e3b7e@math@stan@@        
           .?AVadd_vd_vari@?A0x5e4e3b7e@math@stan@@        
           .?AVmultiply_vd_vari@?A0x5e4e3b7e@math@stan@@   
           .?AVop_v_vari@math@stan@@       
           .?AVstored_gradient_vari@math@stan@@    
           .?AVpartials_vari@?A0x5e4e3b7e@math@stan@@      
           .?AVexp_vari@?A0x5e4e3b7e@math@stan@@   
           .?AVsum_v_vari@math@stan@@            ࿰               8	   	         @
         
         @           
           .?AV?$dot_product_vari@NVvar@math@stan@@@?A0x5e4e3b7e@math@stan@@             X            (   X            
           .?AVdiag_e_point@mcmc@stan@@    
           .?AV?$values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@     
           .?AVanon_model_1988b9d517e3c16daf27a07f09e3de97@anon_model_1988b9d517e3c16daf27a07f09e3de97_namespace@@ P   
           .?AVcovar_adaptation@mcmc@stan@@        
           .?AVvar_adaptation@mcmc@stan@@  
           .?AVpy_var_context_factory@io@pystan@@  
           .?AV?$filtered_values@V?$vector@NV?$allocator@N@std@@@std@@@pystan@@    
           .?AVpystan_sample_writer@pystan@@          
           .?AVpy_var_context@io@pystan@@  
           .?AVdense_e_point@mcmc@stan@@   
           .?AVarray_var_context@io@stan@@    `
   P   `              P   `           	
   d   d   
   
   
   
   
   x
   
   
   
   
          x   й   @           u      
           .?AVtype_info@@ 2-+  ] f                                                                                                                                                                                                                                                                                                          U  i
 U    i
     (i
   4  <i
 4  t  Pi
 t    di
     xi
     i
   $  i
   t  i
     j
     j
     Hk
     dl
    q  $n
     ,n
    m  4n
     @n
    Q  Hn
     Pn
   1  \n
 `    dn
     pn
 @    xn
     n
    q  n
     n
 @    n
     n
    q  n
     n
    Q  n
     n
   1   n
 `      n
    !  n
 @!  !  n
 !  !  o
  "  m"  o
 "  "  o
  #  M#   o
 `#  #  ,o
 #  -$  4o
 @$  $  @o
 $  
%  Ho
  %  q%  To
 %  o&  \o
 &  >'  do
 P'  (  to
 (  )  |o
 0)  *  o
  *  +  o
 +  L,  o
 `,  ,  o
 ,  -  o
 -  -  o
  .  g.  o
 p.  .  o
  /  /  o
 /  /  o
 0  0  o
 0  ;1  p
 P1  1  p
 1  2   p
  2  2  (p
 2  K3  0p
 `3  3  <p
 3  ;  Lp
 ;  <  Tp
 <  *=  `p
 0=  d?  tp
 p?  9@  p
 @@  @  p
  A  sA  p
 A  A  p
 A  B  p
 B  B  p
 B  B   q
 B  B  q
 B  RC  q
 RC  C  4q
 C  /D  Pq
 D  D  `q
  E  iE  hq
 E  LF  pq
 F  F  |q
 F  F  q
 F  kG  q
 kG  G  q
 G  G  q
 G  G  q
 G  G  q
  H  rH  r
 H  H  r
 H  K  r
 K  L  4r
 L  L  <r
 L  L  Pr
 L  L  dr
 L  M  tr
 M  N  r
 N  "O  r
 0O  tO  r
 tO  O  r
 O  O  r
 O  YQ  r
 R  S  r
 S  :T  r
 @T  T  s
  U  U  s
 U  %W  s
 0W  W  0s
 W  =X  Hs
 =X  X  \s
 X  Y  ls
 0Y  uY  xs
 uY  Z  s
 Z  aZ  s
 pZ  Z  s
  [  P[  s
 `[  [  s
 [  \  s
 \  \  s
 \  ]  s
 ]  ^  t
  _  _  t
  _  /_  $t
 @_  O_  ,t
 `_  o_  4t
 _  _  <t
 _  _  Dt
 _  _  Lt
 _  _  Tt
 `  `  \t
 `  da  ht
 da  a  t
 a  a  t
  b  b  t
 b  c  t
 c  c  t
  d  )f  t
 )f  'g  t
 0g  g  t
 g  h   u
  h  ^i  u
 pi  i  u
 i  i   u
 i  	j  8u
 	j  j  Lu
  j  j  \u
 j  \k  hu
 pk  k  pu
 k  vl  u
 vl  l  u
 l  3m  u
 @m  m  u
 m  m  u
 m  qn  u
 n  n  u
 n  o  u
 o  hp   v
 hp  q  v
  q  q  (v
 q  Vr  4v
 `r  Ls  Dv
 `s  s  Pv
 s  s  Xv
 s  t  `v
 t  t  v
 t  u  v
 Pu  u  v
 u  7v  v
 @v  w  v
 w  x  v
 x  x  v
 x  y  v
 y  z  v
  z  {  v
 {  U|  v
 `|  |  w
 |  .}  w
 @}  }  w
 }  }   w
 }  6~  (w
 6~  f~  <w
 f~  r~  Pw
 ~  *  `w
 *  K  hw
 K  y  |w
 y    w
 P    w
     w
   ȁ  w
 Ё  7  w
 @    Px
    Ճ  hx
   b  x
 p    x
   R  x
 R    x
      x
   ;   y
 ;  Y  (y
 Y  ŋ  8y
 Ћ  -  `y
 @    ty
     |y
    ֏  y
      y
 А  !  y
 P    y
    q  y
   Ғ  y
     y
     y
   a  y
   K  y
 `    y
   -  y
 @     z
     z
      z
 З    z
 0    (z
     0z
   a  <z
   K  Dz
 `    Pz
   ,  Xz
 @  ɝ  hz
 Н    z
     z
   P  z
 `  o  z
 o    z
     {
   %  {
 0  ?  <{
 ?  Ǫ  H{
 Ǫ    p{
     {
   P  {
 `  h  {
 h    {
     {
     {
     {
   |  |
     ,|
      8|
      X|
 0    h|
     |
   v  |
 v    |
     |
    0  |
 0    |
     (}
     @}
   8  T}
 @    d}
   q  p}
     x}
   ,  }
 `    }
     }
 @    }
   a  }
     }
   A  }
 p    }
   !  }
 P    }
     ~
 0  }  ~
     ~
   ]  $~
 p    0~
   =  8~
 P    D~
     L~
 0    X~
     `~
   a  l~
 p    t~
    b  ~
 p  -  ~
 @  I  ~
 P    
   }  
   k  4
   ;  @
 p    L
      X
   k  d
   ;  p
 p    |
      
   K  
     
 0    
   [  
    
    
   > 
 P  
  / 
 / | 
 |  
   $
   4
   	 <
 	 J
 X
 P
 
 `
 `  t
   |
   
  < 
 P  
   
  
 Ԁ
  
 
 
 
 
 
 
 
 
 
 
  
  w 0
 w  8
   L
   d
   g t
 g  |
   
   
  W 
 W v 
 v  ԁ
   
  G 
 G f 
 f  
   0
  ` @
 `  H
   \
  ( t
   
   
   
  A 
 P  
  y \
    4
   	" 
 " "" ؅
 "" $ 
 $ $  
 0% % 
 % & 
 `& & $
 & 2' ,
 `' m' 4
 m' q @
 q q l
 q q 
 q q 
 q /r 
 Pr s Ć
 s s ܆
 s v 
 v v 
 v v 
 v   
  $ L
 $ A `
 P  p
   " 
 "  
  7 
 7  ̇
 @ L 
 p  
  T 
 T w H
 w  \
   l
   
   
   Ј
  7 
  D 
 `   
   d  
      
   
 (
   m 0
   8
   @
   m H
   P
   X
   m `
   h
   p
    
  D 
 P  
    ĉ
   ؉
  ! 
 ! ! D
 ! " L
 " 2 
 2 4 0
 4 26 \
 @6 7 
 8 @< 
 P< =  
 = A h
 0A 1B ̌
 @B F <
 F 2K 
 @K Q 
  Q nU 
 U Y[ 
 `[ _ 
 _ ` `
 ` ` t
 ` 2a 
 @a a В
 a e `
 e i t
 i m 
 m q 
 q Lu 
 `u u 
 u .v Ș
 @v v 
 v uw @
 w w 
 w Nx 
 `x x 
 x Ny 8
 y { p
 {  
  V Ț
 ` ݁  
  m 
   
    
  ś  
 Л  
   
   
  {
 d
 
  
   4) L
 @) q- 
 - . 
  / %/ 
 0/ 1 
 1 3 
 3 4 ܦ
 4 > D
 > &@ `
 0@ J d
  K Z @
 Z 8a 
 @a Ge 
 `e e 
 f xg 
 g l 
  m  l
  E 
 p  
 Ѝ 
 
  = 
 @  
  ێ h
  ( 
 0 | h
  ̏ h
  6 
 P v 
     * 
 @ f 
 p  
   
   
   v 
   A   
  F 
 P 5 
 @ % 
 0  
   G 
 P  
   D
  F l
   
   
  G 
 P } 
   
   
   
 @  ĵ
   
   G   ț 
 Л  
  F 4
 P  
  Ɯ 
 М  l
  F Է
 P  <
  Ɲ 
 Н  
  F t
 P  ܹ
  ƞ D
 О  
  F 
 P   П  l
  8 
 @  
  `  `  
  M 
 M q 
   H
  ( 4
 ( N $
 P  
  . 
  4 \
 @ ~ 
   |
 P  
  ֫ 
   
   $
  w  
 w < 
 @  0
   
  س l
 س ޳ \
  ? 
 ` ɵ 
 е  
   '  0 i 
 p ¶ 
 ж " 
 0 x 
  ҷ 
  ( 
 0 x 
   
  K 
 P  Ľ
   
  s 
   
  S 
 ` ) 
 0 
 ؾ
   
   ܿ
    (
  M 
 P  
  8 t
 8 H d
 P  
  /  0 H  p  
  $ 
 $ 7 
 7 @ 
 @  
   
   $
   l
  ^  `  
   
   ~ 
   
  > 
 @  
   
   ^ 
 `  
  l 
 p  
    
  4 
 @  
  t 
  , 
 0  
  o 
 p  
    
  4 
 @ @ 
 @ ; h
 ; H L
 H S <
 `  
  I 
 I D x
 P  
    
    4
    |
    
   
   q 
 q  
   
  E ,
 P  
   A   $
   
   8
 @ \  `  H
   
   
  
 p
  6 
 @ r 
    
   t
  Z <
 Z X ,
 `  
   
    
  w 
 w  
   
   
   $
   
   
   \ <
 `  
  / 
 0  
  M 
 P b 
 b  
   
  F 
 F P 
 P ^ 
 ^ ` 
 `   
   T
   L 
 P  
   
  \ 
 `  @
    
     
     
   O! 
 P! ! 
 ! " 
  " K" 
 P" " 
 " # 
  # # 
 # # 
 # m$  p$ $  $ % 
 % & 
 & L& 
 P& & 
 & & 
 & ' 
 ' K' 
 P' ' (
 ( l( 
 p( ) 
 0) ) 
 ) * 
 * .+ l
 0+ , 
 , T- 
 T- / l
 / / X
 / 0 H
 0 ^8 
 `8 9 
 9 : 
 : ; T
  ; ; 
  < < 
 < = 0
 = "> l
 0> > 
 > 6? 
 @? ? 
 0A A 
 A |B 
 B ,C 
 PC C 
 C FD 
 pD $E 
 $E G x
 G G d
 G G T
 G .P $
 0P CR 
 PR >U 
 @U _U 
 `U U 
 U V 
 V W 
 W LX \
 PX X 
  Y vY ,
 Y Y 
 Y lZ 
 Z Z 
 Z Z |
 Z Z l
 Z [ X
 [ [ 
 [ !\ 
 !\ fc 
 fc c 
 c fg  pg "h 
 0h Yi 
 `i i 
 i i 
 i j  
 j 'j 
 'j Qj 
 `j l t
 l m \
 m o H
 o o 8
  p r 
 r u 
 u u $
 u u 
 u }v 
 }v v 
 v v 
 v v 
 v v 
 v w 
 w ~w 
 ~w ,x |
 ,x @x l
 @x Dx L
 Dx x 0
 x wy 
 y z 
 z \{ @
 p{ { 
 { f| 
 | | 
 | } 
 } ~ |
 ~ Â 
 Â  
  ȅ 
 ȅ 
 
   <
   
   
 `  X
    
   
   | 
   
 @  
   
    
   
 М F X
 P Ɲ 
 Н f 
   
  ̞ A ̞  
  $ 
 0 k X
 k 8 
 8 r 
  D 
 P  
  5 \
 5 D L
 P  
  @ 
 @  
  S 
 `  
   
  r 
 r  
        ] 
 ` O 
 P o 
 p  P
   : 
 @  
  N 
 P a 
 p  
  ޮ 
 ޮ  
   
   
   
  ñ 
 б  
  b T
 p  
   
      ߴ 
  h  
 p  
   H
   ? 
 @ ȶ x
 ж  
  x 
   
   
   : 
 @ z 
   
    
  ݺ 
   \
   
   
  s (
  3 p
 @ _ 
 `  
   
  J 
 P  
  p 
 p # 
 0  0
   x
   
   
   
   
   
  F @
 P  P
   
   t
   d
   
   L 
 L H 
 H W 
 `  
   
  c 
   H
   4
   $
  1 
 @ h 
 h  
   p
   X
   
   
   H
   
  / 
 0 [ H
 [  (
  l 
 p  
   P
   ? 
 @  x
  
 
   
   
  H 
 P m 
 p  
  C 8
 P  
  / 
 0 O 
 P  
  w 
 w  
   D
  : (
 :  
  / 
 0  P
   
   x 
  3 x
 @  
    
    l
   
    
   G h
 G  
   
   8
  , $
 ,  
   
   
  x 
   
  ( D
 0 j 
 p #  l
 0  A 
 P  
   X
   X
   
   
 P 
 
 
    0  d 
 N
 
 P
 
 
 
 
 
 
  
  O @
 O O $
 O Y 
 `  x
   \
   L
   
   
  
 
   (
   
   p  < 
 @     6  @ 3 
 @  
      
    
  6  D
 @  M! 
 M! f! 
 f! U- |
 U- "1 l
 01 2 
  2 2 d
 2 M3 
 P3 4 
  4 4 D
 4 6 t
 6 56 
 @6 e6 
 p6 6 
 6 -8 
 -8 8 
 < P= 
 P= = ,
 = eA 
 eA B 
 B B 
 B C 
  C `C <
 `C G 
 G G 
 G H t
 H H d
  I S 
  S ;S 
 ;S S 
 S S 
 S @T  
 @T T H
 T CU 
 PU uU 
 U U 
 U V p
 V 5V 
 @V "Y 
 0Y AY L
 AY Z 0
 Z Z  
  Z Z X
 Z H_ 
 P_ u_ 
 _ Fd 
 Pd d 
 d d X
 d e @
 e e 0
 e of 
 g _g `
 `g mh 
 h h 
 h Ni 
 Ni gi 
 pi j 
 j k p
  l l 
 l gm 
 pm n 
 n n 
 n o X
 o p  p p 
 p .q 
 0q cq 
 pq q @
 q q ,
 q q 
 q .t \
 0t x h
 x Tz 
 `z | T
 | (} 
 0} }  } s~ 
 s~ }~ 
 }~ ~ 
 ~ Q 
 Q Z 
 `  
  1 \
 @  
 `  
   } 
   <
  0 
 0 p 
 p  
 Ї   
  r @
  } 
  2 
 @  $   \ L  `  d    
       P     u  u         
 0     G  P y 
   
  3 
 3 = ( =               t   `   P   @                 (  :  @ o   ҡ 
  آ ,   ʣ   x   Ȧ (  a 
 p  
  a 
 p     L     n  p ά   ߭ x  ή  Ю     P	  ~ x(   	  B 
 P ͵  е  p  -  P ܺ L  ,  , ʼ d ʼ 8 T  
   8 
 @     A   $
   
   h
  h L
 h  <
   
   
  o 
 o  p
 ` 
 
   
   
   Z 
 `  d   h'   P   d  h t p         4  o X o  4   $   
  < 
 @  
   
  F 
 P  
   
  n 
 p  
   
  k 
 p N ` P  d  l p p  
      `   
  ^ t ` > ` @  
   	   2 
 @  
  ~ 
   
  
 
      H
          
 p         
   T   D   A      t         7 
 @  
  % 
 0  
   
   
  ? 
 @ o 
 p         N \ P       \   `      
         P   Y  ` J
  J
 Y  Y     U  U R  R    9 D 9 R# ( `# &  & ) h ) +   + H+   H+ ,   , a-  p- - \ - :/ 8 :/ / ( P3 x3   x3 :5 x :5 5 h 5 76  @6 6   7 m8  p8 O:  P: :  : ;  ; ;  ; E<   `= 
> 4 > > h P? @   @ @  `A A   B B L 0C C  C 2E  @E  F   F [ X [ b] D" p] ` " ` ` $ ` *a $ *a a h$ a b L$ b b <$ b rc $ c c % c c % c d $ d h (% h }i % }i i % i i % i j % j j % j j % j Gk  & Pk k & k k `' k =l H' =l ?l 8' @l vl  l Dm h' Pm Bn - Pn n 
 n o x'  p p ' p q ' q r ' ps s 
 s s <( s s (( s s (( u u 
 u u d( u v P( v v P( 0w 
x x( x  (    *   q D+   +   ,   -   -   -   - А h  p    X - ` ߗ .  י .   L/    /   /   0  
 l0 
  \0    
 С L 0 P  0   1   d1   1    82  % 2 0  3   |3   3   z    4   
  ٷ 
  	 
   |D   @5   05    d5   5    (6  1 6 @  %  N 6 N d 6 p  (7   7  3  7 @ 4 V @  47  M 7 M  7   7   7    8   8   8  ) 8 0 	 8 	 ? 8 ? y 8  ^ 8 ` 0 9 0  t9   9   :   9   9  p 9 p ] 9 ] t 9  | 0: | x :    @:   T (; T   ;   :  \ P; `  <    >   t
   ?     N  P   ?  t PA  ' ? 0 > ? @  
   @   @   @  b
 @ p
  $A  } DA  b
 ? @  PA  S dA ` r V   A   A  & A &  A   A    B   B   A   
   8B    B   
    B    B   ! B ! #  C  # $ B  $ % P %  ' P  ' ( B ( \* B `* n+ B p+ ,  C , - B - .  C . . C . >/ C >/ 0 C 0 0 C 0 ,2  D 02 2   3 f3 D p3 ?4  @4 ^5  D `5 ~6  D 6 G7 8D P7 18 LD @8 8 |D 8 9 hD 9 +9 XD 09 9 
  : aD D pD D 
 D AO xE PO O 
 O !Z F 0Z ] G  ] C^ H P^ }` XH ` ea H pa _b ? `b c H c e H e e H e h I h j  I j k - k l DI l m `I m 9n  @n o xI o (p - 0p Hq - Pq s I s t I t w I w 4w J 4w #x  J #x .x I 0x y (J y z tJ z z 
 z | J | }   } ;~  @~ o~ 
 p~ ~ K   q L   $L   L  ʀ M ʀ . L .  L  c L c w L   M   PM   8M  S (M S g M p q M   N  	 C 	 ^ N ^ ܌ N ܌  N  W 
 `  N  w 
  k (O p  Q   `T    T  ^ T `  T   i T p  T  Ͼ tU о 1 U @ Y XV ` w ~   V   V   V   I V P N $W P d W p  X   W   W   X  H X P  
  x X   
    Y   tY   Y   DZ      I Z P   [  A L[ P  
  J [ P   \  *  0          0\   
   t 
   
   
   H\   \  
 ]   ]   ^      U ^ ` a x_ p  `   Th   (i   $ i 0 T j `  k   
  L  l P  " (l  # * l  + z/ n / 1 n 1 \2 l `2 8 n  9 9 o 9 5; o @; 4< V @< E= `o P= %> to 0> }? o ? @ o  A B o B C o C D p D E p E ~F P F G P  G JH  D PH zI  D I I 
 I J p  K L q L L q L N q N N q N R q R RS 0\ `S S lr S ZV |r `V Y r Y Z 4s  Z M[ ps P[ [ 
 [ !] Dt 0] <^ @u @^ ^ u ^ _ h' _ ` Hv ` e v  e g  x g i x i yo $y o p  p Qq 
 `q q 
 q lr ty pr s y  s lu y pu v 0z  v v 
 v v z v *w z *w w z w &x xz &x Bx hz Px g} z p} B { P e l| p 9 o @  |  , `} 0 ( } ( f } p f ` p  }   }  ڐ ~   ~  n L~ p a h' p G  P e  e              = d @  t  g  p     L ؁ P    b x p    ަ H  ֧ `      8  z $ z     H  ײ    8  M  P m | m  d  ĸ T и    R  R b  p ѹ 
  Q 
 `  
  l ȇ p      ] H `    ] Ȉ ` e `o p X  ` Z  `  Ԋ   D  U d ` h  p  ̐   p  '  0     ,  7  @  L      ' ؔ 0  Е   J 4 J 0  0 ?  @  H   `   t  a	  p	 	 ȗ 	 1	  @	 	  	  	 ԙ   	 ` 	  ` 	  	   	  	   	  	   !	 (	 , (	 8	 ԝ 8	 :	   :	 ?;	 ̠ @;	 ~?	 < ?	 C	  C	 X	  X	 lZ	 < pZ	 <\	  @\	 ]	 ب ]	 _	 < _	 a	  a	 _c	  `c	 /e	 ī 0e	 e	  e	 f	  f	 Cf	  Pf	 f	  f	 m	   n	 -o	 X 0o	 p	  p	 =q	  @q	 r	   r	 $s	  0s	 4t	  @t	 Du	  Pu	 Tv	  `v	 k~	 < p~	 	  	 :	  @	 	 @ 	 	  	 z	 ذ 	 	  	 Ґ	 
 	 t	 d 	 	  	 	   	 	  	 	   	 E	 Դ P	 	 , 	 
	   	 A	   A	 	 ܶ 	 	 ̶ 	 	   	 	 \ 	 	  	 	 @ 	 f	  p	 v	 ȼ 	 	  	 b	 о p	 	   	 G	  G	 	 t 	 	 L 	 	  	 	  	 	 
 	 	   	 	 , 	 _
  `
 
  
 	
 , 	
 H
  H
 }I
  I
 eJ
  J
 lK
  lK
 K
  K
 K
 
 K
 =N
  @N
 uO
 $ xO
 O
  O
 P
 ` P
 bP
  P
 P
 
 P
 P
 
 Q
 Q
  Q
 Q
   R
 R
  R
 .S
  0S
 IS
 " PS
 iS
 i
 pS
 S
 j
 S
 S
 j
 S
 S
 j
 S
 S
 $j
 S
 	T
 j
 T
 )T
 j
 0T
 IT
 j
 PT
 iT
  k
 pT
 T
 k
 T
 T
 tl
 T
 U
 l
 U
 KU
 l
 PU
 U
 l
 U
 U
 l
 U
 V
 l
 V
 KV
 l
 PV
 V
 l
 V
 V
 l
 V
 W
 m
 W
 KW
 m
 PW
 W
 $m
 W
 W
 x
 W
 W
 x
 W
 W
  x
  X
 X
 |x
  X
 GX
 ~
 PX
 iX
 ~
 pX
 X
 
 X
 X
 
 X
 X
 ,
 X
 X
 |
  Y
 Y
 
  Y
 <Y
 P
 @Y
 \Y
 X
 `Y
 |Y
 `
 Y
 Y
 h
 Y
 Y
 p
 Y
 Y
 x
 Y
 Y
 
  Z
 Z
 
  Z
 9Z
 
 @Z
 YZ
 
 `Z
 yZ
 
 Z
 Z
 
 Z
 Z
 
 Z
 Z
 
 Z
 Z
 
  [
 [
 Ȅ
  [
 9[
 
 @[
 Y[
 
 `[
 |[
 
 [
 [
 
 [
 [
 
 [
 [
 Ȋ
 [
 [
 Њ
 \
 )\
 p
 0\
 I\
 x
 P\
 i\
 ̋
 p\
 \
 ԋ
 \
 \
 @
 \
 \
 
 \
 \
 
  ]
 ]
 
  ]
 8]
 h
 @]
 X]
 p
 `]
 {]
 x
 ]
 ]
 
 ]
 ]
  
 ]
 ]
 
  ^
 ^
 
  ^
 O^
 
 `^
 ^
 Ԏ
 ^
 ^
 ܎
 ^
 ^
 
 ^
 ^
 
 ^
 _
 
 _
 (_
 
 0_
 H_
 
 P_
 k_
 
 p_
 _
 
 _
 _
 
 _
 _
 $
 _
 _
 
  `
 `
 
  `
 ;`
 
 @`
 o`
 
 `
 `
 ؐ
 `
 `
 
 `
 `
 
 `
 a
 
 a
 +a
 
 0a
 Ha
  
 Pa
 ha
 
 pa
 a
 
 a
 a
 
 a
 a
  
 a
 a
 (
  b
 b
 
  b
 8b
 
 @b
 [b
 
 `b
 b
  
 b
 b
 
 b
 b
 
  c
 c
 
  c
 <c
 
 @c
 \c
 
 `c
 xc
 
 c
 c
 
 c
 c
 
 c
 c
 
 c
 c
 
  d
 d
 
  d
 <d
 
 @d
 \d
 
 `d
 xd
 
 d
 d
 
 d
 d
 Ȕ
 d
 d
 Д
 d
 d
 
  e
 e
 
  e
 <e
 
 @e
 \e
 ĕ
 `e
 xe
 ̕
 e
 e
 ԕ
 e
 e
 ܕ
 e
 e
 
 e
 e
 
  f
 f
 Ȗ
  f
 <f
 Ж
 @f
 \f
 ؖ
 `f
 xf
 
 f
 f
 
 f
 f
 
 f
 f
 
 f
 f
 ԗ
  g
 g
 ܗ
  g
 ;g
 
 @g
 og
 
 pg
 g
 
 g
 g
 
 g
 g
 
 g
 g
 
 g
 h
 
 h
 (h
 ܘ
 0h
 Hh
 
 Ph
 kh
 \
 h
 h
 
 h
 h
 ԙ
 h
 h
 
 h
 h
 P
  i
 i
  
  i
 8i
 (
 @i
 Xi
 0
 `i
 xi
 8
 i
 i
 @
 i
 i
 ؛
 i
 i
 
 i
 j
 
 j
 (j
 
 0j
 Kj
 
 `j
 xj
 Ĝ
 j
 j
 ̜
 j
 j
 Ԝ
 j
 j
 ܜ
 j
 k
 
 k
 +k
 
 0k
 Kk
 
 Pk
 lk
 
 pk
 k
 
 k
 k
 
 k
 k
 
 k
 k
  
 k
 l
 (
 l
 ?l
 0
 @l
 [l
 8
 `l
 {l
 @
 l
 l
 H
 l
 l
 P
 l
 l
 X
 l
 l
 `
  m
 m
 h
  m
 8m
 p
 @m
 [m
 ԟ
 `m
 {m
 ܟ
 m
 m
 
 m
 m
 
 m
 m
 
 m
 m
 
  n
 n
 
  n
 8n
 
 @n
 Xn
 
 `n
 xn
 
 n
 n
 $
 n
 n
 ,
 n
 n
 4
 n
 n
 <
 o
 (o
 
 0o
 Ho
 
 Po
 ho
 
 po
 o
 
 o
 o
 
 o
 o
 
  p
 p
 Ԣ
  p
 ;p
 ܢ
 @p
 [p
 
 `p
 {p
 
 p
 p
 
 p
 p
 
 p
 p
 
 p
 p
 
  q
 q
 
  q
 ;q
 
 @q
 q
 $
 q
 q
 t
 q
 q
 |
 q
 q
 
 q
 r
 
 r
 +r
 
 0r
 Kr
 
 Pr
 hr
 
 pr
 r
 
 r
 r
 
 r
 r
 
 r
 r
 Ĥ
 r
 s
 ̤
 s
 +s
 Ԥ
 @s
 Xs
 
 `s
 xs
 
 s
 s
 
 s
 s
 
 s
 s
  
 s
 t
 
 t
 +t
 
 0t
 Kt
 
 `t
 xt
 h
 t
 t
 p
 t
 t
 x
 t
 t
 
 t
 t
 
  u
 u
 
  u
 <u
 
 @u
 Xu
 
 `u
 xu
 
 u
 u
 
 u
 u
 
 u
 u
 
 u
 u
 
  v
 v
 
  v
 8v
 
 @v
 Xv
 
 `v
 {v
 
 v
 v
 
 v
 v
 
 v
 v
 
 v
 v
 ȩ
  w
 w
 Щ
  w
 ;w
 ة
 @w
 [w
 
 `w
 {w
 
 w
 w
 
 w
 w
 
 w
 w
  
 w
 w
 
  x
 x
 
  x
 <x
 
 @x
 Xx
  
 `x
 {x
 (
 x
 x
 0
 x
 x
 8
 x
 x
 @
 x
 x
 H
  y
 y
 P
  y
 ;y
 X
 @y
 iy
 `
 py
 y
 h
 y
 y
 p
 y
 y
 x
 y
 y
 d
  z
 z
 l
  z
 ;z
 t
 @z
 [z
 |
 `z
 xz
 
 z
 z
 
 z
 z
 
 z
 z
 
 z
 z
 
  {
 D{
 
 P{
 k{
 
 p{
 {
 Ĭ
 {
 {
 ح
 {
 {
 
 {
 {
 
  |
 |
 
  |
 ;|
 
 @|
 [|
  
 `|
 x|
 
 |
 |
 
 |
 |
 ܮ
 |
 |
 
 |
 |
 
  }
 }
 
  }
 8}
 
 @}
 X}
 
 `}
 |}
 
 }
 }
 
 }
 }
 ,
 }
 }
 4
 }
 }
 <
  ~
 ~
 D
  ~
 8~
 L
 @~
 [~
 T
 `~
 x~
 \
 ~
 ~
 d
 ~
 ~
 l
 ~
 ~
 t
 ~
 
 
 
 +
 
 0
 K
 
 P
 k
 
 p
 
 
 
 
 
 
 
 Ĳ
 
 
 ̲
  
 ;
 ܲ
 @
 
 
 
 
 
 
 ˀ
 
 Ѐ
 
 
 
 
 
 
 (
 
 0
 t
 
 
 
 ,
 
 
 4
 
 
 D
 
 +
 L
 0
 K
 T
 P
 m
 $
 p
 
 
 
 
 
 
 ͂
 \
 Ђ
 
 ķ
 
 
 ,
 
 -
 
 0
 M
 
 P
 m
 d
 p
 
 ̹
 
 
 4
 
 ̓
 
 Ѓ
 
 
 
 	
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ؄
 " 
 
 "  
 
 "  
 8
 " @
 ~
 
 
 
 " 
 
 " 
 ؅
 " 
 
 ľ
  
 8
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 ܆
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ه
 " 
 
 
  
 Q
 
 `
 ~
 
 
 
 " 
 
 " 
 و
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ى
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ي
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 
 t
 
 
 " 
 ɋ
 " Ћ
 
 " 
 	
 " 
 .
 D
 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 
 
  
 
 "  
 9
 " @
 Y
 " `
 
 " 
 Ǎ
 H
 Ѝ
 
 " 
 	
 " 
 (
 " 0
 I
 " P
 h
 " p
 
 " 
 
 " 
 ڎ
 " 
 
 " 
 )
 " 0
 H
 " P
 z
 " 
 
 " 
 
 " 
 
 l
 
 :
 " @
 j
 " p
 
 " 
 
 " 
 ؐ
 " 
 

 " 
 (
 " 0
 Z
 " `
 x
 " 
 
 " 
 ڑ
 " 
 
 "  
 *
 " 0
 H
 " P
 
 " 
 
 " 
 ʒ
 " В
 
 " 
 
 " 
 +
 " 0
 I
 " P
 m
 
 p
 
 " 
 
 " 
 
 " 
 	
 " 
 (
 " 0
 Z
 " `
 x
 " 
 
 " 
 Ȕ
 " Д
 
 "  
 
 "  
 J
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 :
 " @
 X
 " `
 
 " 
 
 " 
 ̖
 " Ж
 
 " 
 	
 " 
 ,
 " 0
 L
 " P
 i
 " p
 
 " 
 
 " 
 ̗
 " З
 
 " 
 
 " 
 ,
 " 0
 I
 " P
 h
 " p
 
 
 
 
 " 
 ؘ
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 
 " 
 
 " 
 ș
 " Й
 
 " 
 
 " 
 (
 " 0
 F
 <
 P
 k
 " p
 
 " 
 ̚
 " К
 
 " 
 
 " 
 @
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 ؛
 " 
 
 <
  
 
 "  
 S
 " `
 |
 " 
 
 
 
 Ȝ
 " М
 
 "  
 
 "  
 8
 " @
 j
 " p
 
 " 
 
 " 
 ˝
 " Н
 
 " 
 
 " 
 :
 
 @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 ܞ
 " 
 
 "  
 
 "  
 <
 " @
 X
 " `
 
 H
 
 
 L
 
 ޟ
 L
 
 u
 P
 
 
 " 
 
 @
 
 	
 " 
 7
 t
 @
 ^
 t
 `
 
 D
 
 
 D
 
 ̡
 " С
 
 " 
 
 " 
 (
 " 0
 L
 " P
 l
 " p
 
 " 
 
 " 
 ̢
 " Т
 
 " 
 
 " 
 U
 (
 `
 {
 " 
 
 " 
 
 " 
 ܣ
 " 
 )
 (
 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ˤ
 " Ф
 
 " 
 	
 " 
 )
 " 0
 I
 " P
 l
 " p
 
 " 
 
 " 
 ˥
 " Х
 
 "  
 ,
 " 0
 H
 " P
 w
   
 
  
 צ
  
 
  
 7
  @
 Y
 " `
 y
 " 
 
 | 
 Χ
 | Ч
 
 " 
 	
 " 
 (
 " 0
 H
 " P
 l
 " p
 
  
 ٨
 " 
 
 "  
 
 "  
 ;
 " @
 \
 " `
 
 8	 
 ɩ
 " Щ
 
 " 
 	
 " 
 ,
 " 0
 L
 " P
 k
 " p
 
 " 
 
 
 
 
  
 
 " 
 (
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 ȫ
 " Ы
 
 " 
 	
 " 
 )
 " 0
 H
 " P
 k
 " p
 
 " 
 
 " 
 ɬ
 " Ь
 
 " 
 
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ɭ
 " Э
 
 " 
 	
 " 
 (
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 ̮
 " Ю
 
 D  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 ۯ
 " 
 
 "  
 
 "  
 ?
 " @
 X
 " `
 
 " 
 
 " 
 Ұ
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 ٱ
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 {
 " 
 
 " 
 
 " 
 ۲
 " 
 
 "  
 
 "  
 <
 " @
 \
 " `
 x
 " 
 
 " 
 
 " 
 ܳ
 " 
 
 "  
 
 D 
 
 " 
 ̴
 " д
 
 " 
 	
 " 
 )
 " 0
 L
 " P
 i
 " p
 
 " 
 
 " 
 ̵
 " е
 
 " 
 
 " 
 
 D 
 
 " 
 ܶ
 " 
 
 "  
 
 "  
 9
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 ܷ
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 
 D 
 	
 " 
 ,
 " 0
 L
 " P
 i
 " p
 
 " 
 
 " 
 ɹ
 " й
 
 " 
 
 " 
 ,
 " 0
 I
 " P
 h
 " p
 
 D  
 
 "  
 <
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 ٻ
 " 
 
 "  
 
 "  
 <
 " @
 Y
 " `
 x
 " 
 
 " 
 
 " 
 .
 D 0
 I
 " P
 l
 " p
 
 " 
 
 " 
 Ƚ
 " н
 
 " 
 	
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ɾ
 " о
 
 " 
 	
 " 
 )
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 ֿ
 " 
 
 "  
 
 "  
 <
 " @
 g
 % p
 
 " 
 
 & 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 \
 " `
 |
 " 
 
 ( 
 
 ( 
 
 "  
 
 "  
 <
 " @
 \
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 |
 " 
 
 , 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ?
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 x
 " 
 
 4 
 
 T5 
 
 6 
 )
 " 0
 I
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 7 
 +
 " 0
 K
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 H
 8; P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 +
 " 0
 K
 " P
 l
 " p
 
 " 
 
 " 
 
 " 
 
 <  
 
 "  
 8
 " @
 g
 < p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 H
 " P
 w
 C 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 Y
 " `
 y
 " 
 
 " 
 
 " 
 
 xK 
 
 " 
 7
 L @
 
 tM 
 
 "  
 O
 dM P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 +
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 L
 " P
 w
 O 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 G
 O P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 +
 " 0
 K
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 7
 Q @
 \
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 Q 
 )
 " 0
 I
 " P
 h
 " p
 
 " 
 
 U 
 
 "  
 
 "  
 8
 " @
 \
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 \
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ?
 " @
 X
 " `
 }
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 _
 " `
 
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 '
 ^ 0
 
 `_ 
 
 " 
 ?
 P_ @
 X
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 X
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 <
 " @
 \
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 9
 " @
 X
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 y
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 Y
 " `
 {
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 g
 ` p
 
 " 
 
 " 
 
 " 
 
 Dh  
 
 "  
 8
 " @
 X
 " `
 
 i 
 
 " 
 
 " 
 
 " 
 
 i  
 8
 " @
 X
 " `
 {
 " 
 
 j 
 
 " 
 
 " 
 
 " 
 d
 l p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 +
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 	
 " 
 +
 " 0
 K
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 O
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 I
 " P
 i
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 +
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 [
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 X
 " `
 x
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 8
 " @
 b
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 2
 " @
 \
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
  
 "  
 ?
 " @
 ]
 " `
 |
 " 
 
 " 
 
 " 
 
 " 
 
 "  
 
 "  
 ;
 " @
 i
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 (
 " 0
 H
 " P
 k
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 
 " 
 ,
 " 0
 H
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 "      "    9  " @  Y  " `  {  "     "     "     "     "    "   8 " @ X " ` { "   {   "   "   |   8 " @ X " ` x "   "   "   "   "    "   8 " @ _ " ` } "   "   "   "   "    "   ? " @ ` " ` x "   "   "   "   "    "   < " @ Y " ` y "     	 "  ) " 0 T " `  ā   "   "    "    ā   "   "  	 "  ) " 0 I " P i " p  "   "   "  0	 ̃ 0	 H	 " P	 h	 " p	 	 " 	 	 " 	 	 " 	 	 " 	 
 " 
 (
 " 0
 O
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
  "  ( " 0 K " P  "   "   "   "   "   F 8 P k " p  "   "   "   "  
 " 
 +
 " 0
 K
 " P
 h
 " p
 
 " 
 
 " 
 
 " 
 
 " 
 X  ` | "   "   "   "   "    "   9 " @ \ " ` | "   "   "   "   "    "   8 " @ X " ` { "   "   "   "   "    "   8 " @ [ " ` { "   "   "   "   "   " " 0 K " P r "   "   "   "   "  , " 0 L " P l " p  "   "   "   "   "  , " 0 L " P l " p  "   "   "  d P p  "   "   "   "   "  / " 0 K " P r "   "   "   "   "    "   8 " @ [ " `  "   "   "   "   B " P h " p  "   "   "   "  2 " @ X " `  "   "   "   "  R < ` | "   "   Ĕ   9 " @ Y " ` x "   "   "   "   "    "   ; " @ [ " ` { "   "   "   "   "    "   8 " @ \ " `     "   "   "    "   J  P h " p  "   "   "   "      < " @ Y " ` | "   "   "   "   "      "    <  " @  [  " `  x  "     "     "     "     "  ! ! "  ! ;! " @! [! " `! |! " ! ! " ! ! " ! ! " ! ! "  " " "  " <" " @" \" " `" |" " " " " " " " " " " " " "  # # "  # @# " @# o#  p# # " # # " # # " # # " # 	$ " $ +$ " 0$ K$ " P$ k$ " p$ $ " $ $ " $ $ " $ $ " $ % " % +% " 0% K% " P% l% " p% % " % % " % % " % % " % & " & +& " 0& L& " P& k& " p& & " & & " & & " & & " & ' " ' ,' " 0' L' " P' l' " p' ' " ' ' " ' ' " ' ' " ' ( " ( ,( " 0( L( " P( i( " p( ( " ( ( " ( ( " ( ( " ( ) " ) +) " 0) K) " P) k) " p) ) " ) ) " ) ) " ) ) " ) * " * (* " 0* K* " P* k* " p* * " * * " * * " * O+ ( P+ i+ " p+ + " + ,   , ), " 0, I, " P, h, " p, , ( , 	- " - )- " 0- -   - - " - - " - o. ت p. . " . . " . //  0/ I/ " P/ i/ " p/ / " / / " / / " / / " / 0 " 0 (0 " 00 H0 " P0 k0 " p0 0 " 0 0 " 0 0 " 0 0 " 0 1 "  1 81 " @1 X1 " `1 x1 " 1 1 " 1 1 " 1 1 " 1 1 "  2 2 "  2 ;2 " @2 X2 " `2 |2 " 2 2 " 2 2 " 2 2 " 2 2 "  3 3 "  3 93 " @3 \3 " `3 y3 " 3 3 " 3 3 " 3 3 " 3 3 "  4 4 "  4 ;4 " @4 [4 " `4 {4 " 4 4 " 4 4 " 4 4 " 4 4 "  5 5 "  5 5  5 5 " 5 5 " 5 5 " 5 6 " 6 )6 " 06 6  6 6 " 6 6 " 6 6 "  7 7 "  7 ;7 " @7 X7 " `7 {7 " 7 7 " 7 7 L 7 7 "  8 8 "  8 98 " @8 \8 " `8 8 L 8 8 " 8 8 " 8 8 " 8 9 " 9 (9 " 09 Z9 L `9 |9 " 9 9 " 9 9 " 9 9 " 9 9 "  : : "  : ;: " @: \: " `: |: " : : " : : " : : " : : "  ; ; "  ; ;; " @; X; " `; {; " ; ; " ; ; " ; ; " ; ; "  < < "  < << " @< \< " `< |< " < < " < < " < < " < < "  = = "  = <= " @= X= " `= x= " = = " = = " = = " = = "  > > "  > <> " @> X> " `> x> " > > " > > " > > " > > "  ? ? "  ? <? " @? \? " `? x? " ? ? " ? ? " ? ? " ? ? "  @ @ "  @ 8@ " @@ [@ " `@ {@ " @ @  @ @ " @ @ " @ A " A +A " 0A LA " PA kA " pA A " A A " A A " A A " A B " B +B " 0B KB " PB kB " pB B " B B " B B " B B " B C " C +C " 0C KC " PC kC " pC C " C C " C C " C C " C D " D )D " 0D LD " PD kD " pD D " D D " D D " D D " D E " E +E " 0E KE " PE kE " pE E " E E " E E " E E " E 	F " F +F " 0F KF " PF kF " pF F " F F " F F " F F " F G " G +G " 0G KG " PG lG " pG G " G G " G G " G G " G H " H +H " 0H HH " PH hH " pH H " H H " H H " H H " H I " I ,I " 0I KI " PI kI " pI I " I I " I I " I I " I J " J ,J " 0J IJ " PJ kJ " pJ J " J J " J J " J J "  K K "  K ;K " @K [K " `K yK " K K " K K " K K " K L " L )L " 0L KL " PL kL " pL L " L L " L L " L L " L M " M )M " 0M IM " PM kM " pM M " M M " M M " M M " M N " N +N " 0N KN " PN kN " pN N " N N " N N " N N " N O " O +O " 0O KO " PO kO " pO O " O O " O O " O O " O P " P )P " 0P LP " PP kP " pP P " P P " P P " P P " P Q " Q +Q " 0Q KQ " PQ kQ " kQ Q " Q Q " Q Q " Q R " R 6R " @R aR " pR R  R R  R R   S S  @S ^S  `S ~S  T 6T  @T ^T  T T  T U  U .U  0U JU  PU nU  pU U  U U   V +V  V V  V V  V W   W yW $ W W T W 9X  @X eX  pX X  X )Y  0Y Y  Y Y  Y Y  Y GZ D [ [ 
 [ \ ` \ \ P  \ 2\ 
 2\ \\  \\ b\ t p\ \ 
 \ \  \ \  \ \ 
 \ \  \ ]  ] L]  P] ]  ] ]  ] ^   ^ \^  `^ ^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ` T   8@HPX`hpxȩЩة  (08@HPX` p (   hpxȬЭخ        `    ȦЦئ  (08@HPȧЧاPX`hpxȨШب pxȩЩة (08@HPX`hpxȬЬجȭЭح  (0 p t   @HPX`hpxȡС  ȦЦئ   (08@HPX`       (0@HPX`hpxȡС (08@HPX`hpxhpx (08@HPX`hpxȬЬج  (08@    ȡСء 8@HPX (08@HPX`hpxȣУأ  (0إ(08@HPX`hȦЦئxȩЩة  (08@HPX`hpxx  (08@HPhpخ      X`      (0hpx`hpxУأ ȧЧا  (0px  (08@PX`hpxЩة       ȢТآ @HPX`hpx(08@HPX`hpxȤФؤ 8@HPX`hpxȥХإ  (0hpxȦ  (08@HPX` (08@    (    (08@HPXȠРؠ    @   إ`hpxȧЧا     |   (0HPXxȢТآ ȣУأ  (08@HPX@HPX`hpx  
 p   PX`hpxȡСء  (  (08@HPX`hpx 
             (08ȠР   0 \  ȣ @HPhpxȤ08@X`hХإ hئ(0pxPXpxȨШب08PXhpxȩЩة(08PXpxЪت08PXpxЫث8@H`hpج (08PX`xHxȮЮ HX   @    (8(@ȣУHФXإ08HPXhpxئ08@HX`hpȧh(pxȩ8@`hت (0PXxȫЫ @Hhp08X`Эح  (HPpxȮ8@`hد P    (0PXxȠР @Hhp08X`Тآ  (HPpxȣ8@`hؤ (0PXxȥХ @Hhp08X`Чا  (HPpxȨ8@`hة (0PXxȪЪ @Hhp08X`Ьج  (HPpxȭ8@`hخ (0PXxȯЯ ` \   @Hhp08X`Сء  (HPpxȢ8@`hأ (0PXxȤФ @Hhp08X`Цئ  (HPpxȧ8@`hب (0PXxȩЩ @Hhp08X`Ы HpȬHxЭ@p@pЯ p <   @h p`pЦ0𪀫@xP        Р00p@Э  @   `@ X  ` p`P   H    pСP`hpТHx`Ъ@        (`PТ 8x 0@PȤФؤ 0 8h08hȧЧا  (08@HPX`hx                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          q
Umodule_nameqU>stanfit4anon_model_1988b9d517e3c16daf27a07f09e3de97_1415952835qU
model_nameqU+anon_model_1988b9d517e3c16daf27a07f09e3de97qub.