#
# Autogenerated by Thrift Compiler (0.11.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:package_prefix=fastparquet
#

from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
from thrift.TRecursive import fix_spec

import sys

from thrift.transport import TTransport
all_structs = []


class Type(object):
    """
    Types supported by Parquet.  These types are intended to be used in combination
    with the encodings to control the on disk storage format.
    For example INT16 is not included as a type since a good encoding of INT32
    would handle this.

    When a logical type is not present, the type-defined sort order of these
    physical types are:
    * BOOLEAN - false, true
    * INT32 - signed comparison
    * INT64 - signed comparison
    * INT96 - signed comparison
    * FLOAT - signed comparison
    * DOUBLE - signed comparison
    * BYTE_ARRAY - unsigned byte-wise comparison
    * FIXED_LEN_BYTE_ARRAY - unsigned byte-wise comparison
    """
    BOOLEAN = 0
    INT32 = 1
    INT64 = 2
    INT96 = 3
    FLOAT = 4
    DOUBLE = 5
    BYTE_ARRAY = 6
    FIXED_LEN_BYTE_ARRAY = 7

    _VALUES_TO_NAMES = {
        0: "BOOLEAN",
        1: "INT32",
        2: "INT64",
        3: "INT96",
        4: "FLOAT",
        5: "DOUBLE",
        6: "BYTE_ARRAY",
        7: "FIXED_LEN_BYTE_ARRAY",
    }

    _NAMES_TO_VALUES = {
        "BOOLEAN": 0,
        "INT32": 1,
        "INT64": 2,
        "INT96": 3,
        "FLOAT": 4,
        "DOUBLE": 5,
        "BYTE_ARRAY": 6,
        "FIXED_LEN_BYTE_ARRAY": 7,
    }


class ConvertedType(object):
    """
    Common types used by frameworks(e.g. hive, pig) using parquet.  This helps map
    between types in those frameworks to the base types in parquet.  This is only
    metadata and not needed to read or write the data.
    """
    UTF8 = 0
    MAP = 1
    MAP_KEY_VALUE = 2
    LIST = 3
    ENUM = 4
    DECIMAL = 5
    DATE = 6
    TIME_MILLIS = 7
    TIME_MICROS = 8
    TIMESTAMP_MILLIS = 9
    TIMESTAMP_MICROS = 10
    UINT_8 = 11
    UINT_16 = 12
    UINT_32 = 13
    UINT_64 = 14
    INT_8 = 15
    INT_16 = 16
    INT_32 = 17
    INT_64 = 18
    JSON = 19
    BSON = 20
    INTERVAL = 21
    NULL = 24
    NA = 25

    _VALUES_TO_NAMES = {
        0: "UTF8",
        1: "MAP",
        2: "MAP_KEY_VALUE",
        3: "LIST",
        4: "ENUM",
        5: "DECIMAL",
        6: "DATE",
        7: "TIME_MILLIS",
        8: "TIME_MICROS",
        9: "TIMESTAMP_MILLIS",
        10: "TIMESTAMP_MICROS",
        11: "UINT_8",
        12: "UINT_16",
        13: "UINT_32",
        14: "UINT_64",
        15: "INT_8",
        16: "INT_16",
        17: "INT_32",
        18: "INT_64",
        19: "JSON",
        20: "BSON",
        21: "INTERVAL",
        24: "NULL",
        25: "NA",
    }

    _NAMES_TO_VALUES = {
        "UTF8": 0,
        "MAP": 1,
        "MAP_KEY_VALUE": 2,
        "LIST": 3,
        "ENUM": 4,
        "DECIMAL": 5,
        "DATE": 6,
        "TIME_MILLIS": 7,
        "TIME_MICROS": 8,
        "TIMESTAMP_MILLIS": 9,
        "TIMESTAMP_MICROS": 10,
        "UINT_8": 11,
        "UINT_16": 12,
        "UINT_32": 13,
        "UINT_64": 14,
        "INT_8": 15,
        "INT_16": 16,
        "INT_32": 17,
        "INT_64": 18,
        "JSON": 19,
        "BSON": 20,
        "INTERVAL": 21,
        "NULL": 24,
        "NA": 25,
    }


class FieldRepetitionType(object):
    """
    Representation of Schemas
    """
    REQUIRED = 0
    OPTIONAL = 1
    REPEATED = 2

    _VALUES_TO_NAMES = {
        0: "REQUIRED",
        1: "OPTIONAL",
        2: "REPEATED",
    }

    _NAMES_TO_VALUES = {
        "REQUIRED": 0,
        "OPTIONAL": 1,
        "REPEATED": 2,
    }


class Encoding(object):
    """
    Encodings supported by Parquet.  Not all encodings are valid for all types.  These
    enums are also used to specify the encoding of definition and repetition levels.
    See the accompanying doc for the details of the more complicated encodings.
    """
    PLAIN = 0
    PLAIN_DICTIONARY = 2
    RLE = 3
    BIT_PACKED = 4
    DELTA_BINARY_PACKED = 5
    DELTA_LENGTH_BYTE_ARRAY = 6
    DELTA_BYTE_ARRAY = 7
    RLE_DICTIONARY = 8

    _VALUES_TO_NAMES = {
        0: "PLAIN",
        2: "PLAIN_DICTIONARY",
        3: "RLE",
        4: "BIT_PACKED",
        5: "DELTA_BINARY_PACKED",
        6: "DELTA_LENGTH_BYTE_ARRAY",
        7: "DELTA_BYTE_ARRAY",
        8: "RLE_DICTIONARY",
    }

    _NAMES_TO_VALUES = {
        "PLAIN": 0,
        "PLAIN_DICTIONARY": 2,
        "RLE": 3,
        "BIT_PACKED": 4,
        "DELTA_BINARY_PACKED": 5,
        "DELTA_LENGTH_BYTE_ARRAY": 6,
        "DELTA_BYTE_ARRAY": 7,
        "RLE_DICTIONARY": 8,
    }


class CompressionCodec(object):
    """
    Supported compression algorithms.
    """
    UNCOMPRESSED = 0
    SNAPPY = 1
    GZIP = 2
    LZO = 3
    BROTLI = 4
    LZ4 = 5
    ZSTD = 6
    LZ4_RAW = 7

    _VALUES_TO_NAMES = {
        0: "UNCOMPRESSED",
        1: "SNAPPY",
        2: "GZIP",
        3: "LZO",
        4: "BROTLI",
        5: "LZ4",
        6: "ZSTD",
        7: "LZ4_RAW",
    }

    _NAMES_TO_VALUES = {
        "UNCOMPRESSED": 0,
        "SNAPPY": 1,
        "GZIP": 2,
        "LZO": 3,
        "BROTLI": 4,
        "LZ4": 5,
        "ZSTD": 6,
        "LZ4_RAW": 7,
    }


class PageType(object):
    DATA_PAGE = 0
    INDEX_PAGE = 1
    DICTIONARY_PAGE = 2
    DATA_PAGE_V2 = 3

    _VALUES_TO_NAMES = {
        0: "DATA_PAGE",
        1: "INDEX_PAGE",
        2: "DICTIONARY_PAGE",
        3: "DATA_PAGE_V2",
    }

    _NAMES_TO_VALUES = {
        "DATA_PAGE": 0,
        "INDEX_PAGE": 1,
        "DICTIONARY_PAGE": 2,
        "DATA_PAGE_V2": 3,
    }


class Statistics(object):
    """
    Statistics per row group and per page
    All fields are optional.

    Attributes:
     - max: DEPRECATED: min and max value of the column. Use min_value and max_value.

    Values are encoded using PLAIN encoding, except that variable-length byte
    arrays do not include a length prefix.

    These fields encode min and max values determined by SIGNED comparison
    only. New files should use the correct order for a column's logical type
    and store the values in the min_value and max_value fields.

    To support older readers, these may be set when the column order is
    SIGNED.
     - min
     - null_count: count of null value in the column
     - distinct_count: count of distinct values occurring
     - max_value: Min and max values for the column, determined by its ColumnOrder.

    Values are encoded using PLAIN encoding, except that variable-length byte
    arrays do not include a length prefix.
     - min_value
    """


    def __init__(self, max=None, min=None, null_count=None, distinct_count=None, max_value=None, min_value=None,):
        self.max = max
        self.min = min
        self.null_count = null_count
        self.distinct_count = distinct_count
        self.max_value = max_value
        self.min_value = min_value

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.max = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.min = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.null_count = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.distinct_count = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.max_value = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRING:
                    self.min_value = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('Statistics')
        if self.max is not None:
            oprot.writeFieldBegin('max', TType.STRING, 1)
            oprot.writeBinary(self.max)
            oprot.writeFieldEnd()
        if self.min is not None:
            oprot.writeFieldBegin('min', TType.STRING, 2)
            oprot.writeBinary(self.min)
            oprot.writeFieldEnd()
        if self.null_count is not None:
            oprot.writeFieldBegin('null_count', TType.I64, 3)
            oprot.writeI64(self.null_count)
            oprot.writeFieldEnd()
        if self.distinct_count is not None:
            oprot.writeFieldBegin('distinct_count', TType.I64, 4)
            oprot.writeI64(self.distinct_count)
            oprot.writeFieldEnd()
        if self.max_value is not None:
            oprot.writeFieldBegin('max_value', TType.STRING, 5)
            oprot.writeBinary(self.max_value)
            oprot.writeFieldEnd()
        if self.min_value is not None:
            oprot.writeFieldBegin('min_value', TType.STRING, 6)
            oprot.writeBinary(self.min_value)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SchemaElement(object):
    """
    Represents a element inside a schema definition.
     - if it is a group (inner node) then type is undefined and num_children is defined
     - if it is a primitive type (leaf) then type is defined and num_children is undefined
    the nodes are listed in depth first traversal order.

    Attributes:
     - type: Data type for this field. Not set if the current element is a non-leaf node
     - type_length: If type is FIXED_LEN_BYTE_ARRAY, this is the byte length of the vales.
    Otherwise, if specified, this is the maximum bit length to store any of the values.
    (e.g. a low cardinality INT col could have this set to 3).  Note that this is
    in the schema, and therefore fixed for the entire file.
     - repetition_type: repetition of the field. The root of the schema does not have a repetition_type.
    All other nodes must have one
     - name: Name of the field in the schema
     - num_children: Nested fields.  Since thrift does not support nested fields,
    the nesting is flattened to a single list by a depth-first traversal.
    The children count is used to construct the nested relationship.
    This field is not set when the element is a primitive type
     - converted_type: When the schema is the result of a conversion from another model
    Used to record the original type to help with cross conversion.
     - scale: Used when this column contains decimal data.
    See the DECIMAL converted type for more details.
     - precision
     - field_id: When the original schema supports field ids, this will save the
    original field id in the parquet schema
    """


    def __init__(self, type=None, type_length=None, repetition_type=None, name=None, num_children=None, converted_type=None, scale=None, precision=None, field_id=None,):
        self.type = type
        self.type_length = type_length
        self.repetition_type = repetition_type
        self.name = name
        self.num_children = num_children
        self.converted_type = converted_type
        self.scale = scale
        self.precision = precision
        self.field_id = field_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.type_length = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.repetition_type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.STRING:
                    self.name = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.num_children = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I32:
                    self.converted_type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.I32:
                    self.scale = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.I32:
                    self.precision = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.I32:
                    self.field_id = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SchemaElement')
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 1)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        if self.type_length is not None:
            oprot.writeFieldBegin('type_length', TType.I32, 2)
            oprot.writeI32(self.type_length)
            oprot.writeFieldEnd()
        if self.repetition_type is not None:
            oprot.writeFieldBegin('repetition_type', TType.I32, 3)
            oprot.writeI32(self.repetition_type)
            oprot.writeFieldEnd()
        if self.name is not None:
            oprot.writeFieldBegin('name', TType.STRING, 4)
            oprot.writeString(self.name.encode('utf-8') if sys.version_info[0] == 2 else self.name)
            oprot.writeFieldEnd()
        if self.num_children is not None:
            oprot.writeFieldBegin('num_children', TType.I32, 5)
            oprot.writeI32(self.num_children)
            oprot.writeFieldEnd()
        if self.converted_type is not None:
            oprot.writeFieldBegin('converted_type', TType.I32, 6)
            oprot.writeI32(self.converted_type)
            oprot.writeFieldEnd()
        if self.scale is not None:
            oprot.writeFieldBegin('scale', TType.I32, 7)
            oprot.writeI32(self.scale)
            oprot.writeFieldEnd()
        if self.precision is not None:
            oprot.writeFieldBegin('precision', TType.I32, 8)
            oprot.writeI32(self.precision)
            oprot.writeFieldEnd()
        if self.field_id is not None:
            oprot.writeFieldBegin('field_id', TType.I32, 9)
            oprot.writeI32(self.field_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.name is None:
            raise TProtocolException(message='Required field name is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class DataPageHeader(object):
    """
    Data page header

    Attributes:
     - num_values: Number of values, including NULLs, in this data page. *
     - encoding: Encoding used for this data page *
     - definition_level_encoding: Encoding used for definition levels *
     - repetition_level_encoding: Encoding used for repetition levels *
     - statistics: Optional statistics for the data in this page*
    """


    def __init__(self, num_values=None, encoding=None, definition_level_encoding=None, repetition_level_encoding=None, statistics=None,):
        self.num_values = num_values
        self.encoding = encoding
        self.definition_level_encoding = definition_level_encoding
        self.repetition_level_encoding = repetition_level_encoding
        self.statistics = statistics

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.num_values = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.encoding = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.definition_level_encoding = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.repetition_level_encoding = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRUCT:
                    self.statistics = Statistics()
                    self.statistics.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('DataPageHeader')
        if self.num_values is not None:
            oprot.writeFieldBegin('num_values', TType.I32, 1)
            oprot.writeI32(self.num_values)
            oprot.writeFieldEnd()
        if self.encoding is not None:
            oprot.writeFieldBegin('encoding', TType.I32, 2)
            oprot.writeI32(self.encoding)
            oprot.writeFieldEnd()
        if self.definition_level_encoding is not None:
            oprot.writeFieldBegin('definition_level_encoding', TType.I32, 3)
            oprot.writeI32(self.definition_level_encoding)
            oprot.writeFieldEnd()
        if self.repetition_level_encoding is not None:
            oprot.writeFieldBegin('repetition_level_encoding', TType.I32, 4)
            oprot.writeI32(self.repetition_level_encoding)
            oprot.writeFieldEnd()
        if self.statistics is not None:
            oprot.writeFieldBegin('statistics', TType.STRUCT, 5)
            self.statistics.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.num_values is None:
            raise TProtocolException(message='Required field num_values is unset!')
        if self.encoding is None:
            raise TProtocolException(message='Required field encoding is unset!')
        if self.definition_level_encoding is None:
            raise TProtocolException(message='Required field definition_level_encoding is unset!')
        if self.repetition_level_encoding is None:
            raise TProtocolException(message='Required field repetition_level_encoding is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class IndexPageHeader(object):


    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('IndexPageHeader')
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class DictionaryPageHeader(object):
    """
    TODO: *

    Attributes:
     - num_values: Number of values in the dictionary *
     - encoding: Encoding using this dictionary page *
     - is_sorted: If true, the entries in the dictionary are sorted in ascending order *
    """


    def __init__(self, num_values=None, encoding=None, is_sorted=None,):
        self.num_values = num_values
        self.encoding = encoding
        self.is_sorted = is_sorted

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.num_values = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.encoding = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.BOOL:
                    self.is_sorted = iprot.readBool()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('DictionaryPageHeader')
        if self.num_values is not None:
            oprot.writeFieldBegin('num_values', TType.I32, 1)
            oprot.writeI32(self.num_values)
            oprot.writeFieldEnd()
        if self.encoding is not None:
            oprot.writeFieldBegin('encoding', TType.I32, 2)
            oprot.writeI32(self.encoding)
            oprot.writeFieldEnd()
        if self.is_sorted is not None:
            oprot.writeFieldBegin('is_sorted', TType.BOOL, 3)
            oprot.writeBool(self.is_sorted)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.num_values is None:
            raise TProtocolException(message='Required field num_values is unset!')
        if self.encoding is None:
            raise TProtocolException(message='Required field encoding is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class DataPageHeaderV2(object):
    """
    New page format alowing reading levels without decompressing the data
    Repetition and definition levels are uncompressed
    The remaining section containing the data is compressed if is_compressed is true


    Attributes:
     - num_values: Number of values, including NULLs, in this data page. *
     - num_nulls: Number of NULL values, in this data page.
    Number of non-null = num_values - num_nulls which is also the number of values in the data section *
     - num_rows: Number of rows in this data page. which means pages change on record boundaries (r = 0) *
     - encoding: Encoding used for data in this page *
     - definition_levels_byte_length: length of the repetition levels
     - repetition_levels_byte_length: length of the definition levels
     - is_compressed: whether the values are compressed.
    Which means the section of the page between
    definition_levels_byte_length + repetition_levels_byte_length + 1 and compressed_page_size (included)
    is compressed with the compression_codec.
    If missing it is considered compressed
     - statistics: optional statistics for this column chunk
    """


    def __init__(self, num_values=None, num_nulls=None, num_rows=None, encoding=None, definition_levels_byte_length=None, repetition_levels_byte_length=None, is_compressed=True, statistics=None,):
        self.num_values = num_values
        self.num_nulls = num_nulls
        self.num_rows = num_rows
        self.encoding = encoding
        self.definition_levels_byte_length = definition_levels_byte_length
        self.repetition_levels_byte_length = repetition_levels_byte_length
        self.is_compressed = is_compressed
        self.statistics = statistics

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.num_values = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.num_nulls = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.num_rows = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.encoding = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.definition_levels_byte_length = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I32:
                    self.repetition_levels_byte_length = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.BOOL:
                    self.is_compressed = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRUCT:
                    self.statistics = Statistics()
                    self.statistics.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('DataPageHeaderV2')
        if self.num_values is not None:
            oprot.writeFieldBegin('num_values', TType.I32, 1)
            oprot.writeI32(self.num_values)
            oprot.writeFieldEnd()
        if self.num_nulls is not None:
            oprot.writeFieldBegin('num_nulls', TType.I32, 2)
            oprot.writeI32(self.num_nulls)
            oprot.writeFieldEnd()
        if self.num_rows is not None:
            oprot.writeFieldBegin('num_rows', TType.I32, 3)
            oprot.writeI32(self.num_rows)
            oprot.writeFieldEnd()
        if self.encoding is not None:
            oprot.writeFieldBegin('encoding', TType.I32, 4)
            oprot.writeI32(self.encoding)
            oprot.writeFieldEnd()
        if self.definition_levels_byte_length is not None:
            oprot.writeFieldBegin('definition_levels_byte_length', TType.I32, 5)
            oprot.writeI32(self.definition_levels_byte_length)
            oprot.writeFieldEnd()
        if self.repetition_levels_byte_length is not None:
            oprot.writeFieldBegin('repetition_levels_byte_length', TType.I32, 6)
            oprot.writeI32(self.repetition_levels_byte_length)
            oprot.writeFieldEnd()
        if self.is_compressed is not None:
            oprot.writeFieldBegin('is_compressed', TType.BOOL, 7)
            oprot.writeBool(self.is_compressed)
            oprot.writeFieldEnd()
        if self.statistics is not None:
            oprot.writeFieldBegin('statistics', TType.STRUCT, 8)
            self.statistics.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.num_values is None:
            raise TProtocolException(message='Required field num_values is unset!')
        if self.num_nulls is None:
            raise TProtocolException(message='Required field num_nulls is unset!')
        if self.num_rows is None:
            raise TProtocolException(message='Required field num_rows is unset!')
        if self.encoding is None:
            raise TProtocolException(message='Required field encoding is unset!')
        if self.definition_levels_byte_length is None:
            raise TProtocolException(message='Required field definition_levels_byte_length is unset!')
        if self.repetition_levels_byte_length is None:
            raise TProtocolException(message='Required field repetition_levels_byte_length is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class PageHeader(object):
    """
    Attributes:
     - type: the type of the page: indicates which of the *_header fields is set *
     - uncompressed_page_size: Uncompressed page size in bytes (not including this header) *
     - compressed_page_size: Compressed page size in bytes (not including this header) *
     - crc: 32bit crc for the data below. This allows for disabling checksumming in HDFS
    if only a few pages needs to be read

     - data_page_header
     - index_page_header
     - dictionary_page_header
     - data_page_header_v2
    """


    def __init__(self, type=None, uncompressed_page_size=None, compressed_page_size=None, crc=None, data_page_header=None, index_page_header=None, dictionary_page_header=None, data_page_header_v2=None,):
        self.type = type
        self.uncompressed_page_size = uncompressed_page_size
        self.compressed_page_size = compressed_page_size
        self.crc = crc
        self.data_page_header = data_page_header
        self.index_page_header = index_page_header
        self.dictionary_page_header = dictionary_page_header
        self.data_page_header_v2 = data_page_header_v2

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.uncompressed_page_size = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.compressed_page_size = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.crc = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRUCT:
                    self.data_page_header = DataPageHeader()
                    self.data_page_header.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRUCT:
                    self.index_page_header = IndexPageHeader()
                    self.index_page_header.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.STRUCT:
                    self.dictionary_page_header = DictionaryPageHeader()
                    self.dictionary_page_header.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.STRUCT:
                    self.data_page_header_v2 = DataPageHeaderV2()
                    self.data_page_header_v2.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('PageHeader')
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 1)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        if self.uncompressed_page_size is not None:
            oprot.writeFieldBegin('uncompressed_page_size', TType.I32, 2)
            oprot.writeI32(self.uncompressed_page_size)
            oprot.writeFieldEnd()
        if self.compressed_page_size is not None:
            oprot.writeFieldBegin('compressed_page_size', TType.I32, 3)
            oprot.writeI32(self.compressed_page_size)
            oprot.writeFieldEnd()
        if self.crc is not None:
            oprot.writeFieldBegin('crc', TType.I32, 4)
            oprot.writeI32(self.crc)
            oprot.writeFieldEnd()
        if self.data_page_header is not None:
            oprot.writeFieldBegin('data_page_header', TType.STRUCT, 5)
            self.data_page_header.write(oprot)
            oprot.writeFieldEnd()
        if self.index_page_header is not None:
            oprot.writeFieldBegin('index_page_header', TType.STRUCT, 6)
            self.index_page_header.write(oprot)
            oprot.writeFieldEnd()
        if self.dictionary_page_header is not None:
            oprot.writeFieldBegin('dictionary_page_header', TType.STRUCT, 7)
            self.dictionary_page_header.write(oprot)
            oprot.writeFieldEnd()
        if self.data_page_header_v2 is not None:
            oprot.writeFieldBegin('data_page_header_v2', TType.STRUCT, 8)
            self.data_page_header_v2.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.type is None:
            raise TProtocolException(message='Required field type is unset!')
        if self.uncompressed_page_size is None:
            raise TProtocolException(message='Required field uncompressed_page_size is unset!')
        if self.compressed_page_size is None:
            raise TProtocolException(message='Required field compressed_page_size is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class KeyValue(object):
    """
    Wrapper struct to store key values

    Attributes:
     - key
     - value
    """


    def __init__(self, key=None, value=None,):
        self.key = key
        self.value = value

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.key = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.value = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('KeyValue')
        if self.key is not None:
            oprot.writeFieldBegin('key', TType.STRING, 1)
            oprot.writeString(self.key.encode('utf-8') if sys.version_info[0] == 2 else self.key)
            oprot.writeFieldEnd()
        if self.value is not None:
            oprot.writeFieldBegin('value', TType.STRING, 2)
            oprot.writeString(self.value.encode('utf-8') if sys.version_info[0] == 2 else self.value)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.key is None:
            raise TProtocolException(message='Required field key is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class SortingColumn(object):
    """
    Wrapper struct to specify sort order

    Attributes:
     - column_idx: The column index (in this row group) *
     - descending: If true, indicates this column is sorted in descending order. *
     - nulls_first: If true, nulls will come before non-null values, otherwise,
    nulls go at the end.
    """


    def __init__(self, column_idx=None, descending=None, nulls_first=None,):
        self.column_idx = column_idx
        self.descending = descending
        self.nulls_first = nulls_first

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.column_idx = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.BOOL:
                    self.descending = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.BOOL:
                    self.nulls_first = iprot.readBool()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('SortingColumn')
        if self.column_idx is not None:
            oprot.writeFieldBegin('column_idx', TType.I32, 1)
            oprot.writeI32(self.column_idx)
            oprot.writeFieldEnd()
        if self.descending is not None:
            oprot.writeFieldBegin('descending', TType.BOOL, 2)
            oprot.writeBool(self.descending)
            oprot.writeFieldEnd()
        if self.nulls_first is not None:
            oprot.writeFieldBegin('nulls_first', TType.BOOL, 3)
            oprot.writeBool(self.nulls_first)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.column_idx is None:
            raise TProtocolException(message='Required field column_idx is unset!')
        if self.descending is None:
            raise TProtocolException(message='Required field descending is unset!')
        if self.nulls_first is None:
            raise TProtocolException(message='Required field nulls_first is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class PageEncodingStats(object):
    """
    statistics of a given page type and encoding

    Attributes:
     - page_type: the page type (data/dic/...) *
     - encoding: encoding of the page *
     - count: number of pages of this type with this encoding *
    """


    def __init__(self, page_type=None, encoding=None, count=None,):
        self.page_type = page_type
        self.encoding = encoding
        self.count = count

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.page_type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.encoding = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I32:
                    self.count = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('PageEncodingStats')
        if self.page_type is not None:
            oprot.writeFieldBegin('page_type', TType.I32, 1)
            oprot.writeI32(self.page_type)
            oprot.writeFieldEnd()
        if self.encoding is not None:
            oprot.writeFieldBegin('encoding', TType.I32, 2)
            oprot.writeI32(self.encoding)
            oprot.writeFieldEnd()
        if self.count is not None:
            oprot.writeFieldBegin('count', TType.I32, 3)
            oprot.writeI32(self.count)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.page_type is None:
            raise TProtocolException(message='Required field page_type is unset!')
        if self.encoding is None:
            raise TProtocolException(message='Required field encoding is unset!')
        if self.count is None:
            raise TProtocolException(message='Required field count is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ColumnMetaData(object):
    """
    Description for column metadata

    Attributes:
     - type: Type of this column *
     - encodings: Set of all encodings used for this column. The purpose is to validate
    whether we can decode those pages. *
     - path_in_schema: Path in schema *
     - codec: Compression codec *
     - num_values: Number of values in this column *
     - total_uncompressed_size: total byte size of all uncompressed pages in this column chunk (including the headers) *
     - total_compressed_size: total byte size of all compressed pages in this column chunk (including the headers) *
     - key_value_metadata: Optional key/value metadata *
     - data_page_offset: Byte offset from beginning of file to first data page *
     - index_page_offset: Byte offset from beginning of file to root index page *
     - dictionary_page_offset: Byte offset from the beginning of file to first (only) dictionary page *
     - statistics: optional statistics for this column chunk
     - encoding_stats: Set of all encodings used for pages in this column chunk.
    This information can be used to determine if all data pages are
    dictionary encoded for example *
    """


    def __init__(self, type=None, encodings=None, path_in_schema=None, codec=None, num_values=None, total_uncompressed_size=None, total_compressed_size=None, key_value_metadata=None, data_page_offset=None, index_page_offset=None, dictionary_page_offset=None, statistics=None, encoding_stats=None,):
        self.type = type
        self.encodings = encodings
        self.path_in_schema = path_in_schema
        self.codec = codec
        self.num_values = num_values
        self.total_uncompressed_size = total_uncompressed_size
        self.total_compressed_size = total_compressed_size
        self.key_value_metadata = key_value_metadata
        self.data_page_offset = data_page_offset
        self.index_page_offset = index_page_offset
        self.dictionary_page_offset = dictionary_page_offset
        self.statistics = statistics
        self.encoding_stats = encoding_stats

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.type = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.encodings = []
                    (_etype3, _size0) = iprot.readListBegin()
                    for _i4 in range(_size0):
                        _elem5 = iprot.readI32()
                        self.encodings.append(_elem5)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.path_in_schema = []
                    (_etype9, _size6) = iprot.readListBegin()
                    for _i10 in range(_size6):
                        _elem11 = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                        self.path_in_schema.append(_elem11)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.codec = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I64:
                    self.num_values = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.I64:
                    self.total_uncompressed_size = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.I64:
                    self.total_compressed_size = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 8:
                if ftype == TType.LIST:
                    self.key_value_metadata = []
                    (_etype15, _size12) = iprot.readListBegin()
                    for _i16 in range(_size12):
                        _elem17 = KeyValue()
                        _elem17.read(iprot)
                        self.key_value_metadata.append(_elem17)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 9:
                if ftype == TType.I64:
                    self.data_page_offset = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 10:
                if ftype == TType.I64:
                    self.index_page_offset = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 11:
                if ftype == TType.I64:
                    self.dictionary_page_offset = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 12:
                if ftype == TType.STRUCT:
                    self.statistics = Statistics()
                    self.statistics.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 13:
                if ftype == TType.LIST:
                    self.encoding_stats = []
                    (_etype21, _size18) = iprot.readListBegin()
                    for _i22 in range(_size18):
                        _elem23 = PageEncodingStats()
                        _elem23.read(iprot)
                        self.encoding_stats.append(_elem23)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ColumnMetaData')
        if self.type is not None:
            oprot.writeFieldBegin('type', TType.I32, 1)
            oprot.writeI32(self.type)
            oprot.writeFieldEnd()
        if self.encodings is not None:
            oprot.writeFieldBegin('encodings', TType.LIST, 2)
            oprot.writeListBegin(TType.I32, len(self.encodings))
            for iter24 in self.encodings:
                oprot.writeI32(iter24)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.path_in_schema is not None:
            oprot.writeFieldBegin('path_in_schema', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.path_in_schema))
            for iter25 in self.path_in_schema:
                oprot.writeString(iter25.encode('utf-8') if sys.version_info[0] == 2 else iter25)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.codec is not None:
            oprot.writeFieldBegin('codec', TType.I32, 4)
            oprot.writeI32(self.codec)
            oprot.writeFieldEnd()
        if self.num_values is not None:
            oprot.writeFieldBegin('num_values', TType.I64, 5)
            oprot.writeI64(self.num_values)
            oprot.writeFieldEnd()
        if self.total_uncompressed_size is not None:
            oprot.writeFieldBegin('total_uncompressed_size', TType.I64, 6)
            oprot.writeI64(self.total_uncompressed_size)
            oprot.writeFieldEnd()
        if self.total_compressed_size is not None:
            oprot.writeFieldBegin('total_compressed_size', TType.I64, 7)
            oprot.writeI64(self.total_compressed_size)
            oprot.writeFieldEnd()
        if self.key_value_metadata is not None:
            oprot.writeFieldBegin('key_value_metadata', TType.LIST, 8)
            oprot.writeListBegin(TType.STRUCT, len(self.key_value_metadata))
            for iter26 in self.key_value_metadata:
                iter26.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.data_page_offset is not None:
            oprot.writeFieldBegin('data_page_offset', TType.I64, 9)
            oprot.writeI64(self.data_page_offset)
            oprot.writeFieldEnd()
        if self.index_page_offset is not None:
            oprot.writeFieldBegin('index_page_offset', TType.I64, 10)
            oprot.writeI64(self.index_page_offset)
            oprot.writeFieldEnd()
        if self.dictionary_page_offset is not None:
            oprot.writeFieldBegin('dictionary_page_offset', TType.I64, 11)
            oprot.writeI64(self.dictionary_page_offset)
            oprot.writeFieldEnd()
        if self.statistics is not None:
            oprot.writeFieldBegin('statistics', TType.STRUCT, 12)
            self.statistics.write(oprot)
            oprot.writeFieldEnd()
        if self.encoding_stats is not None:
            oprot.writeFieldBegin('encoding_stats', TType.LIST, 13)
            oprot.writeListBegin(TType.STRUCT, len(self.encoding_stats))
            for iter27 in self.encoding_stats:
                iter27.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.type is None:
            raise TProtocolException(message='Required field type is unset!')
        if self.encodings is None:
            raise TProtocolException(message='Required field encodings is unset!')
        if self.path_in_schema is None:
            raise TProtocolException(message='Required field path_in_schema is unset!')
        if self.codec is None:
            raise TProtocolException(message='Required field codec is unset!')
        if self.num_values is None:
            raise TProtocolException(message='Required field num_values is unset!')
        if self.total_uncompressed_size is None:
            raise TProtocolException(message='Required field total_uncompressed_size is unset!')
        if self.total_compressed_size is None:
            raise TProtocolException(message='Required field total_compressed_size is unset!')
        if self.data_page_offset is None:
            raise TProtocolException(message='Required field data_page_offset is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ColumnChunk(object):
    """
    Attributes:
     - file_path: File where column data is stored.  If not set, assumed to be same file as
    metadata.  This path is relative to the current file.

     - file_offset: Byte offset in file_path to the ColumnMetaData *
     - meta_data: Column metadata for this chunk. This is the same content as what is at
    file_path/file_offset.  Having it here has it replicated in the file
    metadata.

    """


    def __init__(self, file_path=None, file_offset=None, meta_data=None,):
        self.file_path = file_path
        self.file_offset = file_offset
        self.meta_data = meta_data

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.file_path = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.file_offset = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.meta_data = ColumnMetaData()
                    self.meta_data.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ColumnChunk')
        if self.file_path is not None:
            oprot.writeFieldBegin('file_path', TType.STRING, 1)
            oprot.writeString(self.file_path.encode('utf-8') if sys.version_info[0] == 2 else self.file_path)
            oprot.writeFieldEnd()
        if self.file_offset is not None:
            oprot.writeFieldBegin('file_offset', TType.I64, 2)
            oprot.writeI64(self.file_offset)
            oprot.writeFieldEnd()
        if self.meta_data is not None:
            oprot.writeFieldBegin('meta_data', TType.STRUCT, 3)
            self.meta_data.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.file_offset is None:
            raise TProtocolException(message='Required field file_offset is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class RowGroup(object):
    """
    Attributes:
     - columns: Metadata for each column chunk in this row group.
    This list must have the same order as the SchemaElement list in FileMetaData.

     - total_byte_size: Total byte size of all the uncompressed column data in this row group *
     - num_rows: Number of rows in this row group *
     - sorting_columns: If set, specifies a sort ordering of the rows in this RowGroup.
    The sorting columns can be a subset of all the columns.
    """


    def __init__(self, columns=None, total_byte_size=None, num_rows=None, sorting_columns=None,):
        self.columns = columns
        self.total_byte_size = total_byte_size
        self.num_rows = num_rows
        self.sorting_columns = sorting_columns

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype31, _size28) = iprot.readListBegin()
                    for _i32 in range(_size28):
                        _elem33 = ColumnChunk()
                        _elem33.read(iprot)
                        self.columns.append(_elem33)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.total_byte_size = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.num_rows = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.sorting_columns = []
                    (_etype37, _size34) = iprot.readListBegin()
                    for _i38 in range(_size34):
                        _elem39 = SortingColumn()
                        _elem39.read(iprot)
                        self.sorting_columns.append(_elem39)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('RowGroup')
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.columns))
            for iter40 in self.columns:
                iter40.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.total_byte_size is not None:
            oprot.writeFieldBegin('total_byte_size', TType.I64, 2)
            oprot.writeI64(self.total_byte_size)
            oprot.writeFieldEnd()
        if self.num_rows is not None:
            oprot.writeFieldBegin('num_rows', TType.I64, 3)
            oprot.writeI64(self.num_rows)
            oprot.writeFieldEnd()
        if self.sorting_columns is not None:
            oprot.writeFieldBegin('sorting_columns', TType.LIST, 4)
            oprot.writeListBegin(TType.STRUCT, len(self.sorting_columns))
            for iter41 in self.sorting_columns:
                iter41.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.columns is None:
            raise TProtocolException(message='Required field columns is unset!')
        if self.total_byte_size is None:
            raise TProtocolException(message='Required field total_byte_size is unset!')
        if self.num_rows is None:
            raise TProtocolException(message='Required field num_rows is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class TypeDefinedOrder(object):
    """
    Empty struct to signal the order defined by the physical or logical type
    """


    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('TypeDefinedOrder')
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class ColumnOrder(object):
    """
    Union to specify the order used for min, max, and sorting values in a column.

    Possible values are:
    * TypeDefinedOrder - the column uses the order defined by its logical or
                         physical type (if there is no logical type).

    If the reader does not support the value of this union, min and max stats
    for this column should be ignored.

    Attributes:
     - TYPE_ORDER
    """


    def __init__(self, TYPE_ORDER=None,):
        self.TYPE_ORDER = TYPE_ORDER

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.TYPE_ORDER = TypeDefinedOrder()
                    self.TYPE_ORDER.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('ColumnOrder')
        if self.TYPE_ORDER is not None:
            oprot.writeFieldBegin('TYPE_ORDER', TType.STRUCT, 1)
            self.TYPE_ORDER.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)


class FileMetaData(object):
    """
    Description for file metadata

    Attributes:
     - version: Version of this file *
     - schema: Parquet schema for this file.  This schema contains metadata for all the columns.
    The schema is represented as a tree with a single root.  The nodes of the tree
    are flattened to a list by doing a depth-first traversal.
    The column metadata contains the path in the schema for that column which can be
    used to map columns to nodes in the schema.
    The first element is the root *
     - num_rows: Number of rows in this file *
     - row_groups: Row groups in this file *
     - key_value_metadata: Optional key/value metadata *
     - created_by: String for application that wrote this file.  This should be in the format
    <Application> version <App Version> (build <App Build Hash>).
    e.g. impala version 1.0 (build 6cf94d29b2b7115df4de2c06e2ab4326d721eb55)

     - column_orders: Sort order used for each column in this file.

    If this list is not present, then the order for each column is assumed to
    be Signed. In addition, min and max values for INTERVAL or DECIMAL stored
    as fixed or bytes should be ignored.
    """


    def __init__(self, version=None, schema=None, num_rows=None, row_groups=None, key_value_metadata=None, created_by=None, column_orders=None,):
        self.version = version
        self.schema = schema
        self.num_rows = num_rows
        self.row_groups = row_groups
        self.key_value_metadata = key_value_metadata
        self.created_by = created_by
        self.column_orders = column_orders

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.version = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.schema = []
                    (_etype45, _size42) = iprot.readListBegin()
                    for _i46 in range(_size42):
                        _elem47 = SchemaElement()
                        _elem47.read(iprot)
                        self.schema.append(_elem47)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.num_rows = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.row_groups = []
                    (_etype51, _size48) = iprot.readListBegin()
                    for _i52 in range(_size48):
                        _elem53 = RowGroup()
                        _elem53.read(iprot)
                        self.row_groups.append(_elem53)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.LIST:
                    self.key_value_metadata = []
                    (_etype57, _size54) = iprot.readListBegin()
                    for _i58 in range(_size54):
                        _elem59 = KeyValue()
                        _elem59.read(iprot)
                        self.key_value_metadata.append(_elem59)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRING:
                    self.created_by = iprot.readString().decode('utf-8') if sys.version_info[0] == 2 else iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.LIST:
                    self.column_orders = []
                    (_etype63, _size60) = iprot.readListBegin()
                    for _i64 in range(_size60):
                        _elem65 = ColumnOrder()
                        _elem65.read(iprot)
                        self.column_orders.append(_elem65)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('FileMetaData')
        if self.version is not None:
            oprot.writeFieldBegin('version', TType.I32, 1)
            oprot.writeI32(self.version)
            oprot.writeFieldEnd()
        if self.schema is not None:
            oprot.writeFieldBegin('schema', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.schema))
            for iter66 in self.schema:
                iter66.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.num_rows is not None:
            oprot.writeFieldBegin('num_rows', TType.I64, 3)
            oprot.writeI64(self.num_rows)
            oprot.writeFieldEnd()
        if self.row_groups is not None:
            oprot.writeFieldBegin('row_groups', TType.LIST, 4)
            oprot.writeListBegin(TType.STRUCT, len(self.row_groups))
            for iter67 in self.row_groups:
                iter67.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.key_value_metadata is not None:
            oprot.writeFieldBegin('key_value_metadata', TType.LIST, 5)
            oprot.writeListBegin(TType.STRUCT, len(self.key_value_metadata))
            for iter68 in self.key_value_metadata:
                iter68.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.created_by is not None:
            oprot.writeFieldBegin('created_by', TType.STRING, 6)
            oprot.writeString(self.created_by.encode('utf-8') if sys.version_info[0] == 2 else self.created_by)
            oprot.writeFieldEnd()
        if self.column_orders is not None:
            oprot.writeFieldBegin('column_orders', TType.LIST, 7)
            oprot.writeListBegin(TType.STRUCT, len(self.column_orders))
            for iter69 in self.column_orders:
                iter69.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        if self.version is None:
            raise TProtocolException(message='Required field version is unset!')
        if self.schema is None:
            raise TProtocolException(message='Required field schema is unset!')
        if self.num_rows is None:
            raise TProtocolException(message='Required field num_rows is unset!')
        if self.row_groups is None:
            raise TProtocolException(message='Required field row_groups is unset!')
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(Statistics)
Statistics.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'max', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'min', 'BINARY', None, ),  # 2
    (3, TType.I64, 'null_count', None, None, ),  # 3
    (4, TType.I64, 'distinct_count', None, None, ),  # 4
    (5, TType.STRING, 'max_value', 'BINARY', None, ),  # 5
    (6, TType.STRING, 'min_value', 'BINARY', None, ),  # 6
)
all_structs.append(SchemaElement)
SchemaElement.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'type', None, None, ),  # 1
    (2, TType.I32, 'type_length', None, None, ),  # 2
    (3, TType.I32, 'repetition_type', None, None, ),  # 3
    (4, TType.STRING, 'name', 'UTF8', None, ),  # 4
    (5, TType.I32, 'num_children', None, None, ),  # 5
    (6, TType.I32, 'converted_type', None, None, ),  # 6
    (7, TType.I32, 'scale', None, None, ),  # 7
    (8, TType.I32, 'precision', None, None, ),  # 8
    (9, TType.I32, 'field_id', None, None, ),  # 9
)
all_structs.append(DataPageHeader)
DataPageHeader.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'num_values', None, None, ),  # 1
    (2, TType.I32, 'encoding', None, None, ),  # 2
    (3, TType.I32, 'definition_level_encoding', None, None, ),  # 3
    (4, TType.I32, 'repetition_level_encoding', None, None, ),  # 4
    (5, TType.STRUCT, 'statistics', [Statistics, None], None, ),  # 5
)
all_structs.append(IndexPageHeader)
IndexPageHeader.thrift_spec = (
)
all_structs.append(DictionaryPageHeader)
DictionaryPageHeader.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'num_values', None, None, ),  # 1
    (2, TType.I32, 'encoding', None, None, ),  # 2
    (3, TType.BOOL, 'is_sorted', None, None, ),  # 3
)
all_structs.append(DataPageHeaderV2)
DataPageHeaderV2.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'num_values', None, None, ),  # 1
    (2, TType.I32, 'num_nulls', None, None, ),  # 2
    (3, TType.I32, 'num_rows', None, None, ),  # 3
    (4, TType.I32, 'encoding', None, None, ),  # 4
    (5, TType.I32, 'definition_levels_byte_length', None, None, ),  # 5
    (6, TType.I32, 'repetition_levels_byte_length', None, None, ),  # 6
    (7, TType.BOOL, 'is_compressed', None, True, ),  # 7
    (8, TType.STRUCT, 'statistics', [Statistics, None], None, ),  # 8
)
all_structs.append(PageHeader)
PageHeader.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'type', None, None, ),  # 1
    (2, TType.I32, 'uncompressed_page_size', None, None, ),  # 2
    (3, TType.I32, 'compressed_page_size', None, None, ),  # 3
    (4, TType.I32, 'crc', None, None, ),  # 4
    (5, TType.STRUCT, 'data_page_header', [DataPageHeader, None], None, ),  # 5
    (6, TType.STRUCT, 'index_page_header', [IndexPageHeader, None], None, ),  # 6
    (7, TType.STRUCT, 'dictionary_page_header', [DictionaryPageHeader, None], None, ),  # 7
    (8, TType.STRUCT, 'data_page_header_v2', [DataPageHeaderV2, None], None, ),  # 8
)
all_structs.append(KeyValue)
KeyValue.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'key', 'UTF8', None, ),  # 1
    (2, TType.STRING, 'value', 'UTF8', None, ),  # 2
)
all_structs.append(SortingColumn)
SortingColumn.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'column_idx', None, None, ),  # 1
    (2, TType.BOOL, 'descending', None, None, ),  # 2
    (3, TType.BOOL, 'nulls_first', None, None, ),  # 3
)
all_structs.append(PageEncodingStats)
PageEncodingStats.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'page_type', None, None, ),  # 1
    (2, TType.I32, 'encoding', None, None, ),  # 2
    (3, TType.I32, 'count', None, None, ),  # 3
)
all_structs.append(ColumnMetaData)
ColumnMetaData.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'type', None, None, ),  # 1
    (2, TType.LIST, 'encodings', (TType.I32, None, False), None, ),  # 2
    (3, TType.LIST, 'path_in_schema', (TType.STRING, 'UTF8', False), None, ),  # 3
    (4, TType.I32, 'codec', None, None, ),  # 4
    (5, TType.I64, 'num_values', None, None, ),  # 5
    (6, TType.I64, 'total_uncompressed_size', None, None, ),  # 6
    (7, TType.I64, 'total_compressed_size', None, None, ),  # 7
    (8, TType.LIST, 'key_value_metadata', (TType.STRUCT, [KeyValue, None], False), None, ),  # 8
    (9, TType.I64, 'data_page_offset', None, None, ),  # 9
    (10, TType.I64, 'index_page_offset', None, None, ),  # 10
    (11, TType.I64, 'dictionary_page_offset', None, None, ),  # 11
    (12, TType.STRUCT, 'statistics', [Statistics, None], None, ),  # 12
    (13, TType.LIST, 'encoding_stats', (TType.STRUCT, [PageEncodingStats, None], False), None, ),  # 13
)
all_structs.append(ColumnChunk)
ColumnChunk.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'file_path', 'UTF8', None, ),  # 1
    (2, TType.I64, 'file_offset', None, None, ),  # 2
    (3, TType.STRUCT, 'meta_data', [ColumnMetaData, None], None, ),  # 3
)
all_structs.append(RowGroup)
RowGroup.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'columns', (TType.STRUCT, [ColumnChunk, None], False), None, ),  # 1
    (2, TType.I64, 'total_byte_size', None, None, ),  # 2
    (3, TType.I64, 'num_rows', None, None, ),  # 3
    (4, TType.LIST, 'sorting_columns', (TType.STRUCT, [SortingColumn, None], False), None, ),  # 4
)
all_structs.append(TypeDefinedOrder)
TypeDefinedOrder.thrift_spec = (
)
all_structs.append(ColumnOrder)
ColumnOrder.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'TYPE_ORDER', [TypeDefinedOrder, None], None, ),  # 1
)
all_structs.append(FileMetaData)
FileMetaData.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'version', None, None, ),  # 1
    (2, TType.LIST, 'schema', (TType.STRUCT, [SchemaElement, None], False), None, ),  # 2
    (3, TType.I64, 'num_rows', None, None, ),  # 3
    (4, TType.LIST, 'row_groups', (TType.STRUCT, [RowGroup, None], False), None, ),  # 4
    (5, TType.LIST, 'key_value_metadata', (TType.STRUCT, [KeyValue, None], False), None, ),  # 5
    (6, TType.STRING, 'created_by', 'UTF8', None, ),  # 6
    (7, TType.LIST, 'column_orders', (TType.STRUCT, [ColumnOrder, None], False), None, ),  # 7
)
fix_spec(all_structs)
del all_structs
