# coding=utf-8
from __future__ import unicode_literals

from .. import Provider as PersonProvider


class Provider(PersonProvider):
    formats_female = (
        '{{first_name_female}}',
        '{{first_name_female}}',
        '{{first_name_female}}',
        '{{first_name_female}} {{last_name}}',
        '{{first_name_female}} {{last_name}}')

    formats_male = (
        '{{first_name_male}}',
        '{{first_name_male}}',
        '{{first_name_male}}',
        '{{first_name_male}} {{last_name}}',
        '{{first_name_male}} {{last_name}}')

    formats = formats_male + formats_female

    # Source: http://tamilcube.com/babynames/tamil-baby-names.aspx
    first_names_male = (
        'அகண்டலன்',
        'அகத்தியன்',
        'அகரன்',
        'அகரமுதல்வன்',
        'அகற்கண்ணன்',
        'அகற்குறி',
        'அகலன்',
        'அகலறிவன்',
        'அகலார்சடையன்',
        'அகல்',
        'அகழ்மேனி',
        'அகவன்',
        'அகாத்',
        'அகிரா',
        'அகிலங்கடந்தான்',
        'அகிலன்',
        'அகில்',
        'அகுல்,',
        'அகோரா',
        'அக்தர்',
        'அக்னி',
        'அக்னிகுமாரன்',
        'அக்மல்,',
        'அக்ரூர்,',
        'அக்ரோதனன்',
        'அங்கணன்',
        'அங்கதன்',
        'அச்சுதானந்தன்',
        'அஜய்',
        'ஆகர்ணா,',
        'ஆகாஷ்',
        'ஆகேந்திரா',
        'ஆக்னேயா',
        'ஆசைத்தம்பி',
        'ஆஞ்சனேயா',
        'ஆடலரசன்',
        'ஆடலரசு',
        'ஆட்டனத்தி',
        'ஆண்டர்ஸன்',
        'ஆண்ட்ரு',
        'ஆதர்ஷ்',
        'ஆதர்ஷ்,ஆதேஷ்',
        'ஆதவன்',
        'ஆதி',
        'ஆதிகுணா',
        'ஆதிகேசவன்',
        'ஆதிசங்கரா',
        'ஆதிசேஷா',
        'ஆதிதேவா',
        'ஆதித்யவர்த்தன்',
        'ஆதித்யா',
        'ஆதிநாதன்',
        'ஆதிநாராயணா',
        'ஆதிமூர்த்தி',
        'ஆத்மஜா,',
        'ஆனந்த',
        'ஆனந்தகிரி',
        'ஆனந்தசாகரன்',
        'ஆனந்ததேவன்',
        'இக்பால்',
        'இக்ஷூ,',
        'இசக்கிமுத்து',
        'இசைக்கலை',
        'இசைக்கலைவாணன்',
        'இசைக்கோ',
        'இசைச்செல்வன்',
        'இசைச்செல்வம்',
        'இசைத்தமிழன்',
        'இசைத்தம்பி',
        'இசைமணி',
        'இசைமாமணி',
        'இசைமுதல்வன்',
        'இசையரசன்',
        'இசையரசு',
        'இசையறிவன்',
        'இசையழகன்',
        'இசையாளன்',
        'இசையேந்தல்',
        'இசைவளன்',
        'இசைவளவன்',
        'இசைவாணன்',
        'இசைவேந்தன்',
        'இடைக்காடன்',
        'இடைக்காடர்',
        'இந்தரஜித்',
        'இந்திகாப்',
        'இந்திரகுமார்',
        'இந்திரநீல்',
        'இந்திவார்',
        'உஜாகர்',
        'உஜேஷ்',
        'உட்கர்ஷ்',
        'உதயகுமார்;',
        'உதயச்சல்',
        'உதயன்',
        'உதயபரிதி',
        'உதயமூர்த்தி',
        'உதயவன்',
        'உதயவானன்',
        'உதயா',
        'உதய்',
        'உதர்',
        'உதாங்கன்',
        'உதித்',
        'உதியஞ்சேரல்',
        'உதியன்',
        'உதீப்',
        'உத்கர்ஷா',
        'உத்சவ்',
        'உத்தம்',
        'உத்தர்',
        'உத்தவ்',
        'உத்தியா',
        'உத்பல்',
        'உன்னத்',
        'உன்மேஷ்',
        'உபதேஷ்',
        'உபமன்யூ',
        'உபேந்திரா',
        'ஊர்ஜித்',
        'எகாம்பரம்',
        'எட்டப்பன்',
        'எழினி',
        'எழிற்கண்',
        'எழிற்கதிர்',
        'எழிற்குமரன்',
        'எழிற்கோ',
        'எழிற்கோமகன்',
        'எழிற்பாவியன்',
        'எழிலகன்',
        'எழிலன்',
        'எழிலன்பன்',
        'எழிலரசன்',
        'எழிலழகன்',
        'எழிலாம்பல்',
        'எழிலேந்தி',
        'எழில்',
        'எழில்குமரன்',
        'எழில்மணி',
        'எழில்மதி',
        'எழில்மன்னன்',
        'எழில்மலை',
        'எழில்முகிலன்',
        'ஏகசந்திரா',
        'ஏகசிந்த்',
        'ஏகராஜ்',
        'ஏகலைவன்',
        'ஏகா',
        'ஏகாங்கா',
        'ஏகாம்பரம்',
        'ஏக்ராம்',
        'ஏந்தல்',
        'ஏழிசை',
        'ஏழிசைக்கதிர்',
        'ஏழிசைக்கனல்',
        'ஏழிசைக்கனி',
        'ஏழிசைக்கலை',
        'ஏழிசைக்குமரன்',
        'ஏழிசைக்குரிசில்',
        'ஐயனாரப்பன்',
        'ஐயன்',
        'ஐயப்பன்',
        'ஐயம்பெருமான்',
        'ஐயா',
        'ஐஸக்',
        'ஒட்டக்கூத்தன்',
        'ஒட்டக்கூத்தர்',
        'ஒளி',
        'ஒளிஒவியம்',
        'ஒளிமதி',
        'ஒளியன்',
        'ஒளியழகன்',
        'ஒளியவன்',
        'ஒளிர்நிலவன்',
        'ஒளிவேந்தன்',
        'ஒள்ளறிவன்',
        'கங்கைகொண்டான்',
        'கசரா',
        'கடம்பன்',
        'கடம்பா',
        'கடர்',
        'கடற்கோ',
        'கடலரசன்',
        'கடலிறை',
        'கடல்வேந்தன்',
        'கணியன்',
        'கணேஷ்',
        'கணைக்கால்',
        'கண்ணதாசன்',
        'கண்ணன்',
        'கண்ணப்பன்',
        'கண்ணாயிரம்',
        'கண்ணுக்கினியன்',
        'கண்ணையன்',
        'கண்மணி',
        'கண்மதியன்',
        'கண்மயா',
        'கதிரழகன்',
        'கதிரவன்',
        'கதிரொளி',
        'கதிரேசன்',
        'கதிரோன்',
        'கதிர்',
        'சகுந்தன்',
        'சக்கரவர்த்தி',
        'சக்திவேல',
        'சங்கன்',
        'சங்கிலி',
        'சசி',
        'சசிகாந்த்',
        'சசிகுமார்',
        'சசிதரன்',
        'சச்சிதாநந்தம்',
        'சஜீத்',
        'சஞ்சய்',
        'சஞ்ஜோக்',
        'சடகோபன்',
        'சதிஷ்வரன்',
        'சதீஷ்',
        'சத்தியலிங்கம்',
        'சத்யநாராயணன்',
        'சத்யமூர்த்தி',
        'சத்யராஐ;',
        'சத்யவாணன்',
        'சத்யவிரதன்',
        'சத்யா',
        'சத்யேந்திரா',
        'சத்ருகணன்',
        'சந்தனு',
        'சந்தானம்',
        'சந்திர',
        'தக்ஷேஷ்',
        'தங்கக்கதிர்',
        'தங்கச்சுடர்',
        'தங்கதுரை',
        'தங்கத்தமிழன்',
        'தங்கத்தமிழ்',
        'தங்கபாண்டியன்',
        'தங்கமகன்',
        'தங்கமணி',
        'தங்கமதி',
        'தங்கமுத்து',
        'தங்கம்',
        'தங்கராஐ;',
        'தங்கவேலன்',
        'தங்கவேலு',
        'தங்கவேல்',
        'தங்கேஷ்வரன்',
        'தசரதன்',
        'தஞ்சைவாணன்',
        'தணி;சேரன்',
        'தணிகேவேலன்',
        'தணிகைச்செல்வன்',
        'தணிகைத்தம்பி',
        'தணிகைநம்பி',
        'தணிகைமணி',
        'தணிகைமுருகன்',
        'தணிகைமுருகு',
        'தணிகையரசு',
        'தணிகைவேலன்',
        'தணிகைவேல்',
        'நக்கீரத்தமிழன்',
        'நக்கீரன்',
        'நக்கீரர்',
        'நச்சினார்க்கினியன்',
        'நச்சினார்க்கினியர்',
        'நடராஜன்',
        'நடவரசன்',
        'நடேஷ்',
        'நட்புச்செல்வன்',
        'நந்தன்',
        'நந்தா',
        'நன்னன்',
        'நன்னாடன்',
        'நன்னாயகம்',
        'நன்னி',
        'நன்னூலன்',
        'நன்னெறியன்',
        'நன்மணி',
        'நன்மதி',
        'நன்மாறன்',
        'நன்மொழியன்',
        'நம்பி',
        'நம்பிகுட்டுவன்',
        'நம்பியருள்',
        'நம்பியூரான்',
        'நம்பிள்ளை',
        'நம்பெருமான்',
        'நம்பெருமாள்',
        'நம்மாழ்வார்',
        'பகத்',
        'பகலவன்',
        'பகவந்த்',
        'பகீரதன்',
        'பகுகுனன்',
        'பகுதானன்',
        'பகுபலி',
        'பகுபாலன்',
        'பகுபுத்ரன்',
        'பகுப்ரியன்',
        'பகுமான்யன்',
        'பகுமித்ரன்',
        'பக்தவச்சலம்',
        'பசந்த்',
        'பசவராஜ்',
        'பசுபதி',
        'பச்சையப்பன்',
        'பஜன்',
        'பஜரங்கன்',
        'பதிரன்',
        'பதுமனார்',
        'பத்மநாபன்',
        'பத்ரநிதி',
        'பத்ராகன்',
        'பத்ராயணர்',
        'பத்ரி',
        'பத்ரிநாதன்',
        'பத்ரிநாராயணன்',
        'பத்ருஹரி',
        'பந்துல்',
        'மகிணன்',
        'மகிழரசன்',
        'மகிழரசு',
        'மகிழ்கோ',
        'மகிழ்ச்சிக்கு',
        'மகிழ்நன்',
        'மகிழ்ந்தன்',
        'மணவழகன்',
        'மணவாளன்',
        'மணி',
        'மணிகண்டன்',
        'மணிக்கதிர்',
        'மணிக்கொடி',
        'மணிக்கோ',
        'மணிக்கோவன்',
        'மணிச்சுடர்',
        'மணிநிலவன்',
        'மணிப்பவளன்',
        'மணிமன்றவாணன்',
        'மணிமலை',
        'மணிமார்பன்',
        'மணிமாறன்',
        'மணிமுடி',
        'மணிமுத்து',
        'மணிமொழியன்',
        'மணியன்',
        'மணியன்செல்வம்',
        'மணியரசன்',
        'மணிரத்ணம்',
        'மணிவண்ணன்',
        'யஷ்வந்த்',
        'யாழரசன்',
        'யாழ்பாடி',
        'யாழ்ப்பாணன்',
        'யாழ்வாணன்',
        'யூகேந்திரன்',
        'யூகேஷ்',
        'யூசுப்',
        'யூவராஐன்',
        'யூவராஜ்',
        'யேவான்',
        'யோகலிங்கம்',
        'யோகாநந்தன்',
        'யோகேஷ்',
        'ரஃபி',
        'ரகு',
        'ரகுபதி',
        'ரகுராம்',
        'ரகுவரன்',
        'ரங்கசாமி',
        'ரஜினி',
        'ரத்தினம்',
        'ரமணன்',
        'ரமணி',
        'ரமேஷ்',
        'ரமேஷ்கண்ணா',
        'ரவி',
        'ரவின்',
        'ரஷஷுத்',
        'ராகவன்',
        'ராகவ்',
        'ராஜ',
        'ராஜகுரு',
        'ராஜகோபால்',
        'ராஜசேகர்',
        'ராஜதுரை',
        'ராஜப்பிரியன்',
        'ராஜவேலு',
        'ராஜா',
        'ராஜீவ்',
        'ராஜேஷ்',
        'ராஜ்குமார்',
        'ராபர்ட்',
        'ராமசாமி',
        'வசந்த்',
        'வசந்த்குமார்',
        'வடிவேற்கரசன்',
        'வடிவேலன்',
        'வடிவேல்',
        'வடிவேல்முருகன்',
        'வணங்காமுடி',
        'வண்டார்குழலி',
        'வண்ணநிலவன்',
        'வண்ணன்',
        'வரதராஐன்',
        'வரதராஜ்',
        'வருண்குமாH',
        'வருனேஷ்',
        'வல்லரசு',
        'வல்லவன்',
        'வளவன்',
        'வள்ளல்',
        'வள்ளிமணாளன்',
        'வள்ளுவன்',
        'வள்ளுவர்',
        'வழுதி',
        'வஷிஷ்டர்',
        'வாகீசன்',
        'வாசு',
        'வாசுதேவன்',
        'வாஞ்சினாதன்',
        'வாணன்',
        'வானத்து',
        'வானமாமலை',
        'ஷகுந்த்',
        'ஷசி',
        'ஷத்ருஞ்ஜய்',
        'ஷபீர்',
        'ஷம்பு',
        'ஷரண்',
        'ஷலின்',
        'ஷஷாங்க்',
        'ஷஸ்வத்',
        'ஷா',
        'ஷானவாஸ்',
        'ஷிங்',
        'ஷியாம்',
        'ஷிஷிர்',
        'ஷைலேந்திரா',
        'ஷைலேஷ்',
        'ஷைல்',
        'ஷோபன்',
        'ஷ்னேகல்',
        'ஷ்யாமல்',
        'ஷ்யாம்',
        'ஷ்ராவண்',
        'ஷ்வேதங்க்',
        'ஸ்டீபன்',
        'ஸ்ரீகாந்த்',
        'ஸ்ரீசிவநாராயணன்',
        'ஸ்ரீதர்',
        'ஸ்ரீநிவாசன்',
        'ஸ்ரீநிவாஸ்',
        'ஸ்ரீபிரசாத்',
        'ஸ்ரீராம்',
        'ஸ்வப்நில்',
        'ஹம்ரிஷ்',
        'ஹரி',
        'ஹரிகரண்',
        'ஹரிதாஸ்',
        'ஹரிஷ்',
        'ஹரிஹரன்',
        'ஹவினாஷன்',
        'ஹஷ்விந்ரன்',
        'ஹாருண்',
    )

    first_names_female = (
        'அகத்தழகி',
        'அகமணி',
        'அகமதி',
        'அகலிகை',
        'அகல்யா',
        'அகல்விழி',
        'அகவழகு',
        'அகவொளி',
        'அகானா',
        'அகிலா',
        'அகிலாண்டம்',
        'அகிலேஷ்வரி',
        'அகில்',
        'அக்னிகா',
        'அக்னிமுகி',
        'அக்னேயி',
        'அக்ஷயா',
        'அக்ஷரா',
        'அக்ஷா',
        'அக்ஷிதா',
        'அங்கம்மாள்',
        'அங்கயர்க்கண்ணி',
        'அங்கவை',
        'அங்கால',
        'அங்கையர்க்கரசி',
        'அசிரா',
        'அச்சலா',
        'அஜந்தா',
        'ஆகமா',
        'ஆசிரா',
        'ஆசைச்செல்வி',
        'ஆஞ்சல்',
        'ஆடற்கொடி',
        'ஆடற்கோமகள்',
        'ஆடற்செல்வி',
        'ஆடலரசி',
        'ஆடலழகி',
        'ஆடல்',
        'ஆட்டநத்தி',
        'ஆண்டாள்',
        'ஆதர்ஷா',
        'ஆதி',
        'ஆதிசக்தி',
        'ஆதித்தமிழ்',
        'ஆதித்தா',
        'ஆதித்தி',
        'ஆதித்யபிரபா',
        'ஆதிமகள்',
        'ஆதிமறை',
        'ஆதிமொழி',
        'ஆதியரசி',
        'இக்ஷிதா',
        'இசை',
        'இசைக்கதிர்',
        'இசைக்கொடி',
        'இசைக்கோமகள்',
        'இசைச்செல்வம்',
        'இசைச்செல்வி',
        'இசைத்தேவி',
        'இசைநேயம்',
        'இசைமகள்',
        'இசைமறை',
        'இசைமுரசு',
        'இசைமொழி',
        'இசையமுதம்',
        'இசையமுது',
        'இசையரசி',
        'இசையொளி',
        'இசைவாணி',
        'இதயா',
        'இந்திரஜா',
        'இந்திரா',
        'இந்திராக்ஷி',
        'இந்திராணி',
        'இந்து',
        'இந்துகலா',
        'இந்துகா',
        'இந்துஜா',
        'இந்துமதி',
        'இந்துமுகி',
        'இந்துவதனி',
        'உச்சிதா',
        'உஜிலா',
        'உண்மை',
        'உண்மையொளி',
        'உண்மைவிளம்பி',
        'உதயசந்திரிகா',
        'உதயா',
        'உதயாதி',
        'உத்தமி',
        'உத்பலா',
        'உன்னதி',
        'உன்மைமொழி',
        'உபாஸனா',
        'உமயாள்',
        'உமா',
        'உமாமகேஷ்வரி',
        'உமை',
        'உமையம்மை',
        'உமையரசி',
        'உமையாள்',
        'உயிரோவியம்',
        'உலக',
        'உலகநங்கை',
        'உலகநேயம்',
        'உலகமணி',
        'உலகமதி',
        'உலகம்மை',
        'உலகிறை',
        'உலகொளி',
        'உலகோவியம்',
        'ஊர்மிளா',
        'ஊர்வசி',
        'எமலி',
        'எமல்டா',
        'எமில்டா',
        'எயினி',
        'எரிதழல்',
        'எரியீட்டி',
        'எல்லி',
        'எழிசை',
        'எழினி',
        'எழிற்கதிர்',
        'எழிற்குமரி',
        'எழிற்குவளை',
        'எழிற்கோமகள்',
        'எழிற்செல்வம்',
        'எழிற்செல்வி',
        'எழிலம்மை',
        'எழிலரசி',
        'எழிலழகி',
        'எழிலி',
        'எழிலிசை',
        'எழிலேந்தி',
        'எழிலோவியம்',
        'எழில்',
        'எழில்நிலவு',
        'எழில்மகள்',
        'எழில்மங்கை',
        'ஏகாபரனா',
        'ஏந்திசை',
        'ஏந்திழை',
        'ஏனாக்ஷி',
        'ஏறுநடை',
        'ஏலா',
        'ஏழிசை',
        'ஏழிசைக்கதிர்',
        'ஏழிசைக்கனல்',
        'ஏழிசைக்கனி',
        'ஏழிசைக்கலை',
        'ஏழிசைக்குமரி',
        'ஏழிசைக்கொடி',
        'ஏழிசைக்கோமகள்',
        'ஏழிசைச்சுடர்',
        'ஏழிசைச்செல்வம்',
        'ஏழிசைச்செல்வி',
        'ஏழிசைதேவி',
        'ஏழிசைத்தென்றல்',
        'ஏழிசைநாயகி',
        'ஏழிசைநேயம்',
        'ஏழிசைப்பாமகள்',
        'ஏழிசைப்பாவை',
        'ஏழிசைப்புதல்வி',
        'ஏழிசைப்பொழில்',
        'ஏழிசைமணி',
        'ஏழிசைமதி',
        'ஏழிசைமுரசு',
        'ஐக்கியா',
        'ஐராவதி',
        'ஐஸ்வர்யா',
        'ஒளவை',
        'ஒளிசுடர',
        'ஒளிமுகம்',
        'ஒளிவாணி',
        'கஐலட்சுமி',
        'கங்கா',
        'கங்கை',
        'கஜோல்',
        'கஜ்ரி',
        'கடற்கோமகள்',
        'கடலரசி',
        'கடலிறை',
        'கணையாழி',
        'கண்ணகி',
        'கண்ணம்மா',
        'கண்ணிமை',
        'கண்மணி',
        'கண்மதி',
        'கண்மலர்',
        'கதிரழகி',
        'கதிர்',
        'கதிர்க்குமரி',
        'கதிர்ச்செல்வி',
        'கதிர்மாமணி',
        'கத்ரினா',
        'கனகவள்ளி',
        'கனகா',
        'கனல்',
        'கனல்மொழி',
        'கனிகா',
        'கனிமதி',
        'கனிமொழி',
        'கனியமுது',
        'கனிரா',
        'சஃபா',
        'சஃபியா',
        'சகீனா',
        'சகுண்',
        'சக்தி',
        'சங்கமித்ரா',
        'சங்கமித்ரை',
        'சங்கரி',
        'சங்கவி',
        'சங்கவை',
        'சங்காரம்',
        'சங்கீதா',
        'சங்கு',
        'சங்குக்கொடி',
        'சங்குப்பூ',
        'சங்குப்பூவழகி',
        'சங்குமணி',
        'சங்குமதி',
        'சங்குமாலை',
        'சங்கெழில்',
        'சங்கொலி',
        'சசிகலா',
        'சசிரேகா',
        'சச்சி',
        'சஜனி',
        'சஞ்சு',
        'சதிகா',
        'சத்தியவாணி',
        'சந்தனம்',
        'சந்தானலட்சுமி',
        'தங்கக்கதிர்',
        'தங்கச்சுடர்',
        'தங்கத்தமிழ்',
        'தங்கபாப்பா',
        'தங்கபுஷ்பம்',
        'தங்கமகள்',
        'தங்கமணி',
        'தங்கமதி',
        'தங்கம்',
        'தங்கம்மா',
        'தங்கம்மாள்',
        'தடாகை',
        'தணிகைச்செல்வி',
        'தண்ணிலவு',
        'தண்ணொளி',
        'தண்மதி',
        'தத்தை',
        'தனக்கோட்டி',
        'தனபாக்கியம்',
        'தனலட்சுமி',
        'தனஸ்ரீ',
        'தனித்தமிழ்',
        'தனுப்பிரியா',
        'தனுஷா',
        'தனுஷ்கா',
        'தனுஷ்ரி',
        'தன்சி',
        'தன்மானம்',
        'தன்வி',
        'தமயந்தி',
        'நங்கை',
        'நடவரசி',
        'நதியா',
        'நந்திகா',
        'நந்திதா',
        'நந்தினி',
        'நன்முத்து',
        'நன்மொழி',
        'நப்பசலையார்',
        'நயன்தாரா',
        'நர்மதா',
        'நறுமலர்',
        'நறுமுகை',
        'நற்றிணை',
        'நல்ல',
        'நல்லிசை',
        'நளாயினி',
        'நளினி',
        'நவிதா',
        'நவீனா',
        'நவ்யா',
        'நாகதேவி',
        'நாகமணி',
        'நாகமதி',
        'நாகம்மாள்',
        'நாகம்மை',
        'நாகவல்லி',
        'நாச்சி',
        'நாச்சியார்',
        'நாதவேணி',
        'பகவதி',
        'பகவத்',
        'பச்சையம்மாள்',
        'பஞ்சாமிர்தம்',
        'பதுமை',
        'பத்மபிரியா',
        'பத்மா',
        'பத்மினி',
        'பனிமலர்',
        'பன்னீர்',
        'பன்னீர்செல்வி',
        'பபிதா',
        'பரணி',
        'பரமேஷ்வரி',
        'பரிமளம்',
        'பரிமளா',
        'பல்லவி',
        'பழகுத்தமிழ்',
        'பவதா',
        'பவதாரணி',
        'பவளக்கொடி',
        'பவளமலை',
        'பவளமல்லி',
        'பவளம்',
        'பவழமொழி',
        'பவானி',
        'பவித்ரா',
        'பாக்கியலக்ஷ்மி',
        'பாக்யஸ்ரீ',
        'மகஷேவரி',
        'மகிழினி',
        'மகிழ்',
        'மகிழ்வதனி',
        'மங்களம்',
        'மங்களா',
        'மங்கை',
        'மங்கையர்க்கரசி',
        'மஞ்சனா',
        'மஞ்சரி',
        'மஞ்சள்',
        'மஞ்சு',
        'மணவழகி',
        'மணி',
        'மணிகா',
        'மணிக்கதிர்',
        'மணிக்கொடி',
        'மணிச்சுடர்',
        'மணிப்பவளம்',
        'மணிமகள்',
        'மணிமலர்',
        'மணிமாலா',
        'மணிமுகில்',
        'மணிமேகலை',
        'மணிமொழி',
        'மணியம்மை',
        'மணியரசி',
        'மணியெழில்',
        'மணியொளி',
        'யசோதா',
        'யமுனா',
        'யஷ்வினி',
        'யாமினி',
        'யாளினி',
        'யாழரசி',
        'யாழிசை',
        'யாழினி',
        'யாழின்',
        'யாழைப்போல்',
        'யாழ்நங்கை',
        'யாழ்மொழி',
        'யூதிகா',
        'யூவரானி',
        'யேகம்மை',
        'யோகமலர்',
        'யோகராணி',
        'யோகலட்சுமி',
        'யோகவல்லி',
        'யோஸ்னிதா',
        'யோஹிதா',
        'ரகசியா',
        'ரக்ஷனா',
        'ரக்ஷிகா',
        'ரக்ஷிதா',
        'ரக்ஷினி',
        'ரங்கநாயகி',
        'ரஞ்சனா',
        'ரஞ்சிதம்',
        'ரஞ்சிதா',
        'ரஞ்சினி',
        'ரட்சகா',
        'ரதவனி',
        'ரதி',
        'ரனித்தா',
        'ரமணி',
        'ரம்ஜான்',
        'ரம்யா',
        'ராகினி',
        'ராசாத்தி',
        'ராஜகுமாரி',
        'ராஜலட்சுமி',
        'ராஜி',
        'ராஜேஷ்வரி',
        'ராணி',
        'ராதா',
        'ராதிகா',
        'ரித்திகா',
        'ரீஜா',
        'ரீட்டா',
        'ரீனா',
        'வகேஷ்வரி',
        'வசந்தசேனா',
        'வசந்தா',
        'வசந்தி',
        'வசனா',
        'வசுதா',
        'வசுதாரிணி',
        'வசுமதி',
        'வஞ்சி',
        'வஞ்சிக்கொடி',
        'வஞ்சிப்பாமகள்',
        'வஞ்சிமகள்',
        'வடிவரசி',
        'வடிவழகி',
        'வடிவு',
        'வடிவுக்கரசி',
        'வண்டமிழ்',
        'வண்டார்குழலி',
        'வண்ணக்கதிர்',
        'வண்ணமதி',
        'வதனா',
        'வதனி',
        'வத்ஸலா',
        'வனிதா',
        'வமகேஷி',
        'வருணி',
        'வருனிதா',
        'வர்ணவதி',
        'வர்ஷா',
        'வர்ஷினி',
        'ஷக்தி',
        'ஷண்சிலாதேவி',
        'ஷதா',
        'ஷதாக்ஷி',
        'ஷந்தோஷி',
        'ஷந்ஸா',
        'ஷபரி',
        'ஷப்னம்',
        'ஷமா',
        'ஷரணி',
        'ஷரினி',
        'ஷர்மிதா',
        'ஷர்மிளா',
        'ஷர்மிஸ்தா',
        'ஷர்வானி',
        'ஷஷி',
        'ஷாந்தலா',
        'ஷாந்தி',
        'ஷானன்',
        'ஷாமினி',
        'ஷாரன்',
        'ஷாலிகா',
        'ஷாலினி',
        'ஷாலு',
        'ஷாஷினி,',
        'ஷாஹ்னா',
        'ஷிஃபாலி',
        'ஷிகா',
        'ஷிச்சி',
        'ஷிபானி',
        'ஸகஸ்ரா',
        'ஸங்கரி',
        'ஸத்யா',
        'ஸத்வரி',
        'ஸன்யுக்தா',
        'ஸபீனா',
        'ஸயூரி',
        'ஸரயூ',
        'ஸரளா',
        'ஸரஸ்வதி',
        'ஸரிகா',
        'ஸஹிரா',
        'ஸுபத்திரை',
        'ஸுப்ரியா',
        'ஸுப்ரீத்',
        'ஸுமா',
        'ஸுரபி',
        'ஸெடெஃபானியா',
        'ஸெடெபானி',
        'ஸௌரா',
        'ஸ்கந்தா',
        'ஸ்திரிரத்னா',
        'ஸ்துதி',
        'ஸ்னேஹல்',
        'ஸ்ப்ரிஹா',
        'ஸ்மிதா',
        'ஸ்மிருதி',
        'ஸ்மேரா',
        'ஸ்ராவந்தி',
        'ஸ்ராவனி',
        'ஸ்ரீகமா',
        'ஸ்ரீகலா',
        'ஸ்ரீகா',
        'ஸ்ரீதேவி',
        'ஸ்ரீநிதி',
        'ஸ்ரீனா',
        'ஸ்ரீமயி',
        'ஸ்ரீமா',
        'ஸ்ரீயா',
        'ஸ்ரீயாதித்யா',
        'ஸ்ரீலக்ஷ்மி',
        'ஸ்ரீலா',
        'ஸ்ரீலேகா',
        'ஸ்ரீவல்லி',
        'ஸ்ரீவித்யா',
        'ஹசினிகா',
        'ஹனிஷா',
        'ஹன்சா',
        'ஹன்யா',
        'ஹன்ஷிகா',
        'ஹம்சவர்த்தினி',
        'ஹம்சவானி',
        'ஹம்சா',
        'ஹரிதா',
        'ஹரினி',
        'ஹரினிவேதா',
        'ஹர்ஷா',
        'ஹர்ஷிகா',
        'ஹர்ஷிதா',
        'ஹர்ஷினி',
        'ஹலிமா',
        'ஹவிஷ்மதி',
        'ஹஸிதா',
        'ஹஸினா',
        'ஹஸ்னா',
        'ஹாசினி',
        'ஹிரண்யா',
        'ஹெலன்',
        'ஹேமந்தினி',
        'ஹேமலதா',
        'ஹேமா',
    )

    first_names = first_names_male + first_names_female
    last_names = first_names
