from typing import Any, Iterator, List, Tuple

from typing import overload

class CutResult:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def ik_1(self) -> float: ...
    @property
    def ik_2(self) -> float: ...
    @property
    def point(self) -> Vector2D: ...
    @property
    def success(self) -> bool: ...

class Interpolation:
    @overload
    def __init__(self, nodes: list) -> None: ...
    @overload
    def __init__(self, arg0: Interpolation) -> None: ...
    @overload
    def __init__(self, nodes: list, extrapolate: bool) -> None: ...
    def add(self, arg0: PolyLine2D) -> PolyLine2D: ...
    def copy(self) -> Interpolation: ...
    @overload
    def get(self, arg0: float) -> Vector2D: ...
    @overload
    def get(self, arg0: float, arg1: float) -> PolyLine2D: ...
    def get_length(self) -> float: ...
    def get_positions(self, arg0: float, arg1: float) -> List[float]: ...
    def get_segment_lengthes(self) -> List[float]: ...
    def get_segments(self) -> List[Vector2D]: ...
    def get_tangents(self) -> List[Vector2D]: ...
    def get_value(self, arg0: float) -> float: ...
    def mix(self, arg0: PolyLine2D, arg1: float) -> PolyLine2D: ...
    def move(self, arg0: Vector2D) -> PolyLine2D: ...
    def resample(self, arg0: int) -> PolyLine2D: ...
    def reverse(self) -> PolyLine2D: ...
    @overload
    def scale(self, arg0: float) -> PolyLine2D: ...
    @overload
    def scale(self, arg0: Vector2D) -> PolyLine2D: ...
    def scale_nodes(self, arg0: List[float]) -> PolyLine2D: ...
    def sub(self, arg0: PolyLine2D) -> PolyLine2D: ...
    def tolist(self) -> list: ...
    def walk(self, arg0: float, arg1: float) -> float: ...
    def __add__(self, arg0: Interpolation) -> Interpolation: ...
    def __copy__(self) -> Interpolation: ...
    def __deepcopy__(self, memo: dict) -> Interpolation: ...
    def __iter__(self) -> Iterator: ...
    def __json__(self) -> dict: ...
    def __len__(self) -> int: ...
    @overload
    def __mul__(self, arg0: float) -> PolyLine2D: ...
    @overload
    def __mul__(self, arg0: Vector2D) -> PolyLine2D: ...
    @overload
    def __mul__(self, arg0: float) -> Interpolation: ...
    @property
    def nodes(self) -> List[Vector2D]: ...

class PolyLine2D:
    @overload
    def __init__(self, nodes: list) -> None: ...
    @overload
    def __init__(self, arg0: PolyLine2D) -> None: ...
    def add(self, arg0: PolyLine2D) -> PolyLine2D: ...
    def copy(self) -> PolyLine2D: ...
    @overload
    def cut(self, arg0: Vector2D, arg1: Vector2D) -> List[Tuple[float,float]]: ...
    @overload
    def cut(self, arg0: Vector2D, arg1: Vector2D, arg2: float) -> Tuple[float,float]: ...
    @overload
    def cut(self, arg0: PolyLine2D) -> List[Tuple[float,float]]: ...
    @overload
    def cut(self, arg0: PolyLine2D, arg1: float) -> Tuple[float,float]: ...
    def fix_errors(self) -> PolyLine2D: ...
    @overload
    def get(self, arg0: float) -> Vector2D: ...
    @overload
    def get(self, arg0: float, arg1: float) -> PolyLine2D: ...
    def get_area(self) -> float: ...
    def get_length(self) -> float: ...
    def get_positions(self, arg0: float, arg1: float) -> List[float]: ...
    def get_segment_lengthes(self) -> List[float]: ...
    def get_segments(self) -> List[Vector2D]: ...
    def get_tangents(self) -> List[Vector2D]: ...
    @overload
    def mirror(self, arg0: Vector2D, arg1: Vector2D) -> PolyLine2D: ...
    @overload
    def mirror(self) -> PolyLine2D: ...
    def mix(self, arg0: PolyLine2D, arg1: float) -> PolyLine2D: ...
    def move(self, arg0: Vector2D) -> PolyLine2D: ...
    def normvectors(self) -> PolyLine2D: ...
    def offset(self, arg0: float) -> PolyLine2D: ...
    def resample(self, arg0: int) -> PolyLine2D: ...
    def reverse(self) -> PolyLine2D: ...
    def rotate(self, arg0: float, arg1: Vector2D) -> PolyLine2D: ...
    @overload
    def scale(self, arg0: float) -> PolyLine2D: ...
    @overload
    def scale(self, arg0: Vector2D) -> PolyLine2D: ...
    def scale_nodes(self, arg0: List[float]) -> PolyLine2D: ...
    def sub(self, arg0: PolyLine2D) -> PolyLine2D: ...
    def tolist(self) -> list: ...
    def walk(self, arg0: float, arg1: float) -> float: ...
    def __add__(self, arg0: PolyLine2D) -> PolyLine2D: ...
    def __copy__(self) -> PolyLine2D: ...
    def __deepcopy__(self, memo: dict) -> PolyLine2D: ...
    def __iter__(self) -> Iterator: ...
    def __json__(self) -> dict: ...
    def __len__(self) -> int: ...
    @overload
    def __mul__(self, arg0: float) -> PolyLine2D: ...
    @overload
    def __mul__(self, arg0: Vector2D) -> PolyLine2D: ...
    @property
    def nodes(self) -> List[Vector2D]: ...

class PolyLine3D:
    @overload
    def __init__(self, nodes: list) -> None: ...
    @overload
    def __init__(self, arg0: PolyLine3D) -> None: ...
    def add(self, arg0: PolyLine3D) -> PolyLine3D: ...
    def copy(self) -> PolyLine3D: ...
    @overload
    def get(self, arg0: float) -> Vector3D: ...
    @overload
    def get(self, arg0: float, arg1: float) -> PolyLine3D: ...
    def get_length(self) -> float: ...
    def get_positions(self, arg0: float, arg1: float) -> List[float]: ...
    def get_segment_lengthes(self) -> List[float]: ...
    def get_segments(self) -> List[Vector3D]: ...
    def get_tangents(self) -> List[Vector3D]: ...
    def mix(self, arg0: PolyLine3D, arg1: float) -> PolyLine3D: ...
    def move(self, arg0: Vector3D) -> PolyLine3D: ...
    def resample(self, arg0: int) -> PolyLine3D: ...
    def reverse(self) -> PolyLine3D: ...
    @overload
    def scale(self, arg0: float) -> PolyLine3D: ...
    @overload
    def scale(self, arg0: Vector3D) -> PolyLine3D: ...
    def scale_nodes(self, arg0: List[float]) -> PolyLine3D: ...
    def sub(self, arg0: PolyLine3D) -> PolyLine3D: ...
    def tolist(self) -> list: ...
    def walk(self, arg0: float, arg1: float) -> float: ...
    def __add__(self, arg0: PolyLine3D) -> PolyLine3D: ...
    def __copy__(self) -> PolyLine3D: ...
    def __deepcopy__(self, memo: dict) -> PolyLine3D: ...
    def __iter__(self) -> Iterator: ...
    def __json__(self) -> dict: ...
    def __len__(self) -> int: ...
    @overload
    def __mul__(self, arg0: float) -> PolyLine3D: ...
    @overload
    def __mul__(self, arg0: Vector3D) -> PolyLine3D: ...
    @property
    def nodes(self) -> List[Vector3D]: ...

class Rotation2D:
    def __init__(self, arg0: float) -> None: ...
    def apply(self, arg0: Vector2D) -> Vector2D: ...

class Transformation:
    def __init__(self) -> None: ...
    @overload
    def apply(self, arg0: Vector3D) -> Vector3D: ...
    @overload
    def apply(self, arg0: Vector2D) -> Vector3D: ...
    @overload
    def apply(self, arg0: PolyLine2D) -> PolyLine3D: ...
    @overload
    def apply(self, arg0: PolyLine3D) -> PolyLine3D: ...
    def chain(self, arg0: Transformation) -> Transformation: ...
    def rotation(self, *args, **kwargs) -> Any: ...
    def scale(self, *args, **kwargs) -> Any: ...
    def translation(self, *args, **kwargs) -> Any: ...
    def __copy__(self) -> Transformation: ...
    def __deepcopy__(self, memo: dict) -> Transformation: ...
    def __mul__(self, arg0: Transformation) -> Transformation: ...
    @property
    def matrix(self) -> List[List[float[4]][4]]: ...

class Vector2D:
    @overload
    def __init__(self, arg0: tuple) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    @overload
    def __init__(self, arg0: Vector2D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def angle(self) -> float: ...
    def copy(self) -> Vector2D: ...
    def cross(self, arg0: Vector2D) -> float: ...
    def dot(self, arg0: Vector2D) -> float: ...
    def length(self) -> float: ...
    def normalized(self) -> Vector2D: ...
    def __add__(self, arg0: Vector2D) -> Vector2D: ...
    def __copy__(self) -> Vector2D: ...
    def __deepcopy__(self, memo: dict) -> Vector2D: ...
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> Iterator: ...
    def __json__(self) -> list: ...
    def __len__(self) -> int: ...
    @overload
    def __mul__(self, arg0: Vector2D) -> Vector2D: ...
    @overload
    def __mul__(self, arg0: float) -> Vector2D: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    def __sub__(self, arg0: Vector2D) -> Vector2D: ...
    def __truediv__(self, arg0: float) -> Vector2D: ...

class Vector3D:
    @overload
    def __init__(self, arg0: tuple) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    @overload
    def __init__(self, arg0: Vector3D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def copy(self) -> Vector3D: ...
    def cross(self, arg0: Vector3D) -> Vector3D: ...
    def dot(self, arg0: Vector3D) -> float: ...
    def length(self) -> float: ...
    def normalized(self) -> Vector3D: ...
    def __add__(self, arg0: Vector3D) -> Vector3D: ...
    def __copy__(self) -> Vector3D: ...
    def __deepcopy__(self, memo: dict) -> Vector3D: ...
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> Iterator: ...
    def __json__(self) -> list: ...
    def __len__(self) -> int: ...
    @overload
    def __mul__(self, arg0: Vector3D) -> Vector3D: ...
    @overload
    def __mul__(self, arg0: float) -> Vector3D: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    def __sub__(self, arg0: Vector3D) -> Vector3D: ...
    def __truediv__(self, arg0: float) -> Vector3D: ...

def cut(arg0: Vector2D, arg1: Vector2D, arg2: Vector2D, arg3: Vector2D) -> CutResult: ...
