/* mbboRecord.h generated from mbboRecord.dbd */

#ifndef INC_mbboRecord_H
#define INC_mbboRecord_H

#include "epicsTypes.h"
#include "link.h"
#include "epicsMutex.h"
#include "ellLib.h"
#include "devSup.h"
#include "epicsTime.h"
/* Declare Device Support Entry Table */
struct mbboRecord;
typedef struct mbbodset {
    dset common; /*init_record returns: (0, 2) => (success, success no convert)*/
    long (*write_mbbo)(struct mbboRecord *prec); /*returns: (0, 2) => (success, success no convert)*/
} mbbodset;
#define HAS_mbbodset

#include "callback.h"

typedef struct mbboRecord {
    char                name[61];   /* Record Name */
    char                desc[41];   /* Descriptor */
    char                asg[29];    /* Access Security Group */
    epicsEnum16         scan;       /* Scan Mechanism */
    epicsEnum16         pini;       /* Process at iocInit */
    epicsInt16          phas;       /* Scan Phase */
    char                evnt[40];   /* Event Name */
    epicsInt16          tse;        /* Time Stamp Event */
    DBLINK              tsel;       /* Time Stamp Link */
    epicsEnum16         dtyp;       /* Device Type */
    epicsInt16          disv;       /* Disable Value */
    epicsInt16          disa;       /* Disable */
    DBLINK              sdis;       /* Scanning Disable */
    epicsMutexId        mlok;       /* Monitor lock */
    ELLLIST             mlis;       /* Monitor List */
    ELLLIST             bklnk;      /* Backwards link tracking */
    epicsUInt8          disp;       /* Disable putField */
    epicsUInt8          proc;       /* Force Processing */
    epicsEnum16         stat;       /* Alarm Status */
    epicsEnum16         sevr;       /* Alarm Severity */
    epicsEnum16         nsta;       /* New Alarm Status */
    epicsEnum16         nsev;       /* New Alarm Severity */
    epicsEnum16         acks;       /* Alarm Ack Severity */
    epicsEnum16         ackt;       /* Alarm Ack Transient */
    epicsEnum16         diss;       /* Disable Alarm Sevrty */
    epicsUInt8          lcnt;       /* Lock Count */
    epicsUInt8          pact;       /* Record active */
    epicsUInt8          putf;       /* dbPutField process */
    epicsUInt8          rpro;       /* Reprocess  */
    struct asgMember    *asp;       /* Access Security Pvt */
    struct processNotify *ppn;      /* pprocessNotify */
    struct processNotifyRecord *ppnr; /* pprocessNotifyRecord */
    struct scan_element *spvt;      /* Scan Private */
    struct typed_rset   *rset;      /* Address of RSET */
    unambiguous_dset    *dset;      /* DSET address */
    void                *dpvt;      /* Device Private */
    struct dbRecordType *rdes;      /* Address of dbRecordType */
    struct lockRecord   *lset;      /* Lock Set */
    epicsEnum16         prio;       /* Scheduling Priority */
    epicsUInt8          tpro;       /* Trace Processing */
    epicsUInt8          bkpt;       /* Break Point */
    epicsUInt8          udf;        /* Undefined */
    epicsEnum16         udfs;       /* Undefined Alarm Sevrty */
    epicsTimeStamp      time;       /* Time */
    DBLINK              flnk;       /* Forward Process Link */
    epicsEnum16         val;        /* Desired Value */
    DBLINK              dol;        /* Desired Output Loc */
    epicsEnum16         omsl;       /* Output Mode Select */
    epicsUInt16         nobt;       /* Number of Bits */
    DBLINK              out;        /* Output Specification */
    epicsUInt32         zrvl;       /* Zero Value */
    epicsUInt32         onvl;       /* One Value */
    epicsUInt32         twvl;       /* Two Value */
    epicsUInt32         thvl;       /* Three Value */
    epicsUInt32         frvl;       /* Four Value */
    epicsUInt32         fvvl;       /* Five Value */
    epicsUInt32         sxvl;       /* Six Value */
    epicsUInt32         svvl;       /* Seven Value */
    epicsUInt32         eivl;       /* Eight Value */
    epicsUInt32         nivl;       /* Nine Value */
    epicsUInt32         tevl;       /* Ten Value */
    epicsUInt32         elvl;       /* Eleven Value */
    epicsUInt32         tvvl;       /* Twelve Value */
    epicsUInt32         ttvl;       /* Thirteen Value */
    epicsUInt32         ftvl;       /* Fourteen Value */
    epicsUInt32         ffvl;       /* Fifteen Value */
    char                zrst[26];   /* Zero String */
    char                onst[26];   /* One String */
    char                twst[26];   /* Two String */
    char                thst[26];   /* Three String */
    char                frst[26];   /* Four String */
    char                fvst[26];   /* Five String */
    char                sxst[26];   /* Six String */
    char                svst[26];   /* Seven String */
    char                eist[26];   /* Eight String */
    char                nist[26];   /* Nine String */
    char                test[26];   /* Ten String */
    char                elst[26];   /* Eleven String */
    char                tvst[26];   /* Twelve String */
    char                ttst[26];   /* Thirteen String */
    char                ftst[26];   /* Fourteen String */
    char                ffst[26];   /* Fifteen String */
    epicsEnum16         zrsv;       /* State Zero Severity */
    epicsEnum16         onsv;       /* State One Severity */
    epicsEnum16         twsv;       /* State Two Severity */
    epicsEnum16         thsv;       /* State Three Severity */
    epicsEnum16         frsv;       /* State Four Severity */
    epicsEnum16         fvsv;       /* State Five Severity */
    epicsEnum16         sxsv;       /* State Six Severity */
    epicsEnum16         svsv;       /* State Seven Severity */
    epicsEnum16         eisv;       /* State Eight Severity */
    epicsEnum16         nisv;       /* State Nine Severity */
    epicsEnum16         tesv;       /* State Ten Severity */
    epicsEnum16         elsv;       /* State Eleven Severity */
    epicsEnum16         tvsv;       /* State Twelve Severity */
    epicsEnum16         ttsv;       /* State Thirteen Sevr */
    epicsEnum16         ftsv;       /* State Fourteen Sevr */
    epicsEnum16         ffsv;       /* State Fifteen Sevr */
    epicsEnum16         unsv;       /* Unknown State Sevr */
    epicsEnum16         cosv;       /* Change of State Sevr */
    epicsUInt32         rval;       /* Raw Value */
    epicsUInt32         oraw;       /* Prev Raw Value */
    epicsUInt32         rbv;        /* Readback Value */
    epicsUInt32         orbv;       /* Prev Readback Value */
    epicsUInt32         mask;       /* Hardware Mask */
    epicsUInt16         mlst;       /* Last Value Monitored */
    epicsUInt16         lalm;       /* Last Value Alarmed */
    epicsInt16          sdef;       /* States Defined */
    epicsUInt16         shft;       /* Shift */
    DBLINK              siol;       /* Simulation Output Link */
    DBLINK              siml;       /* Simulation Mode Link */
    epicsEnum16         simm;       /* Simulation Mode */
    epicsEnum16         sims;       /* Simulation Mode Severity */
    epicsEnum16         oldsimm;    /* Prev. Simulation Mode */
    epicsEnum16         sscn;       /* Sim. Mode Scan */
    epicsFloat64        sdly;       /* Sim. Mode Async Delay */
    epicsCallback            *simpvt; /* Sim. Mode Private */
    epicsEnum16         ivoa;       /* INVALID outpt action */
    epicsUInt16         ivov;       /* INVALID output value */
} mbboRecord;

typedef enum {
	mbboRecordNAME = 0,
	mbboRecordDESC = 1,
	mbboRecordASG = 2,
	mbboRecordSCAN = 3,
	mbboRecordPINI = 4,
	mbboRecordPHAS = 5,
	mbboRecordEVNT = 6,
	mbboRecordTSE = 7,
	mbboRecordTSEL = 8,
	mbboRecordDTYP = 9,
	mbboRecordDISV = 10,
	mbboRecordDISA = 11,
	mbboRecordSDIS = 12,
	mbboRecordMLOK = 13,
	mbboRecordMLIS = 14,
	mbboRecordBKLNK = 15,
	mbboRecordDISP = 16,
	mbboRecordPROC = 17,
	mbboRecordSTAT = 18,
	mbboRecordSEVR = 19,
	mbboRecordNSTA = 20,
	mbboRecordNSEV = 21,
	mbboRecordACKS = 22,
	mbboRecordACKT = 23,
	mbboRecordDISS = 24,
	mbboRecordLCNT = 25,
	mbboRecordPACT = 26,
	mbboRecordPUTF = 27,
	mbboRecordRPRO = 28,
	mbboRecordASP = 29,
	mbboRecordPPN = 30,
	mbboRecordPPNR = 31,
	mbboRecordSPVT = 32,
	mbboRecordRSET = 33,
	mbboRecordDSET = 34,
	mbboRecordDPVT = 35,
	mbboRecordRDES = 36,
	mbboRecordLSET = 37,
	mbboRecordPRIO = 38,
	mbboRecordTPRO = 39,
	mbboRecordBKPT = 40,
	mbboRecordUDF = 41,
	mbboRecordUDFS = 42,
	mbboRecordTIME = 43,
	mbboRecordFLNK = 44,
	mbboRecordVAL = 45,
	mbboRecordDOL = 46,
	mbboRecordOMSL = 47,
	mbboRecordNOBT = 48,
	mbboRecordOUT = 49,
	mbboRecordZRVL = 50,
	mbboRecordONVL = 51,
	mbboRecordTWVL = 52,
	mbboRecordTHVL = 53,
	mbboRecordFRVL = 54,
	mbboRecordFVVL = 55,
	mbboRecordSXVL = 56,
	mbboRecordSVVL = 57,
	mbboRecordEIVL = 58,
	mbboRecordNIVL = 59,
	mbboRecordTEVL = 60,
	mbboRecordELVL = 61,
	mbboRecordTVVL = 62,
	mbboRecordTTVL = 63,
	mbboRecordFTVL = 64,
	mbboRecordFFVL = 65,
	mbboRecordZRST = 66,
	mbboRecordONST = 67,
	mbboRecordTWST = 68,
	mbboRecordTHST = 69,
	mbboRecordFRST = 70,
	mbboRecordFVST = 71,
	mbboRecordSXST = 72,
	mbboRecordSVST = 73,
	mbboRecordEIST = 74,
	mbboRecordNIST = 75,
	mbboRecordTEST = 76,
	mbboRecordELST = 77,
	mbboRecordTVST = 78,
	mbboRecordTTST = 79,
	mbboRecordFTST = 80,
	mbboRecordFFST = 81,
	mbboRecordZRSV = 82,
	mbboRecordONSV = 83,
	mbboRecordTWSV = 84,
	mbboRecordTHSV = 85,
	mbboRecordFRSV = 86,
	mbboRecordFVSV = 87,
	mbboRecordSXSV = 88,
	mbboRecordSVSV = 89,
	mbboRecordEISV = 90,
	mbboRecordNISV = 91,
	mbboRecordTESV = 92,
	mbboRecordELSV = 93,
	mbboRecordTVSV = 94,
	mbboRecordTTSV = 95,
	mbboRecordFTSV = 96,
	mbboRecordFFSV = 97,
	mbboRecordUNSV = 98,
	mbboRecordCOSV = 99,
	mbboRecordRVAL = 100,
	mbboRecordORAW = 101,
	mbboRecordRBV = 102,
	mbboRecordORBV = 103,
	mbboRecordMASK = 104,
	mbboRecordMLST = 105,
	mbboRecordLALM = 106,
	mbboRecordSDEF = 107,
	mbboRecordSHFT = 108,
	mbboRecordSIOL = 109,
	mbboRecordSIML = 110,
	mbboRecordSIMM = 111,
	mbboRecordSIMS = 112,
	mbboRecordOLDSIMM = 113,
	mbboRecordSSCN = 114,
	mbboRecordSDLY = 115,
	mbboRecordSIMPVT = 116,
	mbboRecordIVOA = 117,
	mbboRecordIVOV = 118
} mbboFieldIndex;

#ifdef GEN_SIZE_OFFSET

#include <epicsExport.h>
#include <cantProceed.h>
#ifdef __cplusplus
extern "C" {
#endif
static int mbboRecordSizeOffset(dbRecordType *prt)
{
    mbboRecord *prec = 0;

    if (prt->no_fields != 119) {
        cantProceed("IOC build or installation error:\n"
            "    The mbboRecord defined in the DBD file has %d fields,\n"
            "    but the record support code was built with 119.\n",
            prt->no_fields);
    }
    prt->papFldDes[mbboRecordNAME]->size = sizeof(prec->name);
    prt->papFldDes[mbboRecordNAME]->offset = (unsigned short)((char *)&prec->name - (char *)prec);
    prt->papFldDes[mbboRecordDESC]->size = sizeof(prec->desc);
    prt->papFldDes[mbboRecordDESC]->offset = (unsigned short)((char *)&prec->desc - (char *)prec);
    prt->papFldDes[mbboRecordASG]->size = sizeof(prec->asg);
    prt->papFldDes[mbboRecordASG]->offset = (unsigned short)((char *)&prec->asg - (char *)prec);
    prt->papFldDes[mbboRecordSCAN]->size = sizeof(prec->scan);
    prt->papFldDes[mbboRecordSCAN]->offset = (unsigned short)((char *)&prec->scan - (char *)prec);
    prt->papFldDes[mbboRecordPINI]->size = sizeof(prec->pini);
    prt->papFldDes[mbboRecordPINI]->offset = (unsigned short)((char *)&prec->pini - (char *)prec);
    prt->papFldDes[mbboRecordPHAS]->size = sizeof(prec->phas);
    prt->papFldDes[mbboRecordPHAS]->offset = (unsigned short)((char *)&prec->phas - (char *)prec);
    prt->papFldDes[mbboRecordEVNT]->size = sizeof(prec->evnt);
    prt->papFldDes[mbboRecordEVNT]->offset = (unsigned short)((char *)&prec->evnt - (char *)prec);
    prt->papFldDes[mbboRecordTSE]->size = sizeof(prec->tse);
    prt->papFldDes[mbboRecordTSE]->offset = (unsigned short)((char *)&prec->tse - (char *)prec);
    prt->papFldDes[mbboRecordTSEL]->size = sizeof(prec->tsel);
    prt->papFldDes[mbboRecordTSEL]->offset = (unsigned short)((char *)&prec->tsel - (char *)prec);
    prt->papFldDes[mbboRecordDTYP]->size = sizeof(prec->dtyp);
    prt->papFldDes[mbboRecordDTYP]->offset = (unsigned short)((char *)&prec->dtyp - (char *)prec);
    prt->papFldDes[mbboRecordDISV]->size = sizeof(prec->disv);
    prt->papFldDes[mbboRecordDISV]->offset = (unsigned short)((char *)&prec->disv - (char *)prec);
    prt->papFldDes[mbboRecordDISA]->size = sizeof(prec->disa);
    prt->papFldDes[mbboRecordDISA]->offset = (unsigned short)((char *)&prec->disa - (char *)prec);
    prt->papFldDes[mbboRecordSDIS]->size = sizeof(prec->sdis);
    prt->papFldDes[mbboRecordSDIS]->offset = (unsigned short)((char *)&prec->sdis - (char *)prec);
    prt->papFldDes[mbboRecordMLOK]->size = sizeof(prec->mlok);
    prt->papFldDes[mbboRecordMLOK]->offset = (unsigned short)((char *)&prec->mlok - (char *)prec);
    prt->papFldDes[mbboRecordMLIS]->size = sizeof(prec->mlis);
    prt->papFldDes[mbboRecordMLIS]->offset = (unsigned short)((char *)&prec->mlis - (char *)prec);
    prt->papFldDes[mbboRecordBKLNK]->size = sizeof(prec->bklnk);
    prt->papFldDes[mbboRecordBKLNK]->offset = (unsigned short)((char *)&prec->bklnk - (char *)prec);
    prt->papFldDes[mbboRecordDISP]->size = sizeof(prec->disp);
    prt->papFldDes[mbboRecordDISP]->offset = (unsigned short)((char *)&prec->disp - (char *)prec);
    prt->papFldDes[mbboRecordPROC]->size = sizeof(prec->proc);
    prt->papFldDes[mbboRecordPROC]->offset = (unsigned short)((char *)&prec->proc - (char *)prec);
    prt->papFldDes[mbboRecordSTAT]->size = sizeof(prec->stat);
    prt->papFldDes[mbboRecordSTAT]->offset = (unsigned short)((char *)&prec->stat - (char *)prec);
    prt->papFldDes[mbboRecordSEVR]->size = sizeof(prec->sevr);
    prt->papFldDes[mbboRecordSEVR]->offset = (unsigned short)((char *)&prec->sevr - (char *)prec);
    prt->papFldDes[mbboRecordNSTA]->size = sizeof(prec->nsta);
    prt->papFldDes[mbboRecordNSTA]->offset = (unsigned short)((char *)&prec->nsta - (char *)prec);
    prt->papFldDes[mbboRecordNSEV]->size = sizeof(prec->nsev);
    prt->papFldDes[mbboRecordNSEV]->offset = (unsigned short)((char *)&prec->nsev - (char *)prec);
    prt->papFldDes[mbboRecordACKS]->size = sizeof(prec->acks);
    prt->papFldDes[mbboRecordACKS]->offset = (unsigned short)((char *)&prec->acks - (char *)prec);
    prt->papFldDes[mbboRecordACKT]->size = sizeof(prec->ackt);
    prt->papFldDes[mbboRecordACKT]->offset = (unsigned short)((char *)&prec->ackt - (char *)prec);
    prt->papFldDes[mbboRecordDISS]->size = sizeof(prec->diss);
    prt->papFldDes[mbboRecordDISS]->offset = (unsigned short)((char *)&prec->diss - (char *)prec);
    prt->papFldDes[mbboRecordLCNT]->size = sizeof(prec->lcnt);
    prt->papFldDes[mbboRecordLCNT]->offset = (unsigned short)((char *)&prec->lcnt - (char *)prec);
    prt->papFldDes[mbboRecordPACT]->size = sizeof(prec->pact);
    prt->papFldDes[mbboRecordPACT]->offset = (unsigned short)((char *)&prec->pact - (char *)prec);
    prt->papFldDes[mbboRecordPUTF]->size = sizeof(prec->putf);
    prt->papFldDes[mbboRecordPUTF]->offset = (unsigned short)((char *)&prec->putf - (char *)prec);
    prt->papFldDes[mbboRecordRPRO]->size = sizeof(prec->rpro);
    prt->papFldDes[mbboRecordRPRO]->offset = (unsigned short)((char *)&prec->rpro - (char *)prec);
    prt->papFldDes[mbboRecordASP]->size = sizeof(prec->asp);
    prt->papFldDes[mbboRecordASP]->offset = (unsigned short)((char *)&prec->asp - (char *)prec);
    prt->papFldDes[mbboRecordPPN]->size = sizeof(prec->ppn);
    prt->papFldDes[mbboRecordPPN]->offset = (unsigned short)((char *)&prec->ppn - (char *)prec);
    prt->papFldDes[mbboRecordPPNR]->size = sizeof(prec->ppnr);
    prt->papFldDes[mbboRecordPPNR]->offset = (unsigned short)((char *)&prec->ppnr - (char *)prec);
    prt->papFldDes[mbboRecordSPVT]->size = sizeof(prec->spvt);
    prt->papFldDes[mbboRecordSPVT]->offset = (unsigned short)((char *)&prec->spvt - (char *)prec);
    prt->papFldDes[mbboRecordRSET]->size = sizeof(prec->rset);
    prt->papFldDes[mbboRecordRSET]->offset = (unsigned short)((char *)&prec->rset - (char *)prec);
    prt->papFldDes[mbboRecordDSET]->size = sizeof(prec->dset);
    prt->papFldDes[mbboRecordDSET]->offset = (unsigned short)((char *)&prec->dset - (char *)prec);
    prt->papFldDes[mbboRecordDPVT]->size = sizeof(prec->dpvt);
    prt->papFldDes[mbboRecordDPVT]->offset = (unsigned short)((char *)&prec->dpvt - (char *)prec);
    prt->papFldDes[mbboRecordRDES]->size = sizeof(prec->rdes);
    prt->papFldDes[mbboRecordRDES]->offset = (unsigned short)((char *)&prec->rdes - (char *)prec);
    prt->papFldDes[mbboRecordLSET]->size = sizeof(prec->lset);
    prt->papFldDes[mbboRecordLSET]->offset = (unsigned short)((char *)&prec->lset - (char *)prec);
    prt->papFldDes[mbboRecordPRIO]->size = sizeof(prec->prio);
    prt->papFldDes[mbboRecordPRIO]->offset = (unsigned short)((char *)&prec->prio - (char *)prec);
    prt->papFldDes[mbboRecordTPRO]->size = sizeof(prec->tpro);
    prt->papFldDes[mbboRecordTPRO]->offset = (unsigned short)((char *)&prec->tpro - (char *)prec);
    prt->papFldDes[mbboRecordBKPT]->size = sizeof(prec->bkpt);
    prt->papFldDes[mbboRecordBKPT]->offset = (unsigned short)((char *)&prec->bkpt - (char *)prec);
    prt->papFldDes[mbboRecordUDF]->size = sizeof(prec->udf);
    prt->papFldDes[mbboRecordUDF]->offset = (unsigned short)((char *)&prec->udf - (char *)prec);
    prt->papFldDes[mbboRecordUDFS]->size = sizeof(prec->udfs);
    prt->papFldDes[mbboRecordUDFS]->offset = (unsigned short)((char *)&prec->udfs - (char *)prec);
    prt->papFldDes[mbboRecordTIME]->size = sizeof(prec->time);
    prt->papFldDes[mbboRecordTIME]->offset = (unsigned short)((char *)&prec->time - (char *)prec);
    prt->papFldDes[mbboRecordFLNK]->size = sizeof(prec->flnk);
    prt->papFldDes[mbboRecordFLNK]->offset = (unsigned short)((char *)&prec->flnk - (char *)prec);
    prt->papFldDes[mbboRecordVAL]->size = sizeof(prec->val);
    prt->papFldDes[mbboRecordVAL]->offset = (unsigned short)((char *)&prec->val - (char *)prec);
    prt->papFldDes[mbboRecordDOL]->size = sizeof(prec->dol);
    prt->papFldDes[mbboRecordDOL]->offset = (unsigned short)((char *)&prec->dol - (char *)prec);
    prt->papFldDes[mbboRecordOMSL]->size = sizeof(prec->omsl);
    prt->papFldDes[mbboRecordOMSL]->offset = (unsigned short)((char *)&prec->omsl - (char *)prec);
    prt->papFldDes[mbboRecordNOBT]->size = sizeof(prec->nobt);
    prt->papFldDes[mbboRecordNOBT]->offset = (unsigned short)((char *)&prec->nobt - (char *)prec);
    prt->papFldDes[mbboRecordOUT]->size = sizeof(prec->out);
    prt->papFldDes[mbboRecordOUT]->offset = (unsigned short)((char *)&prec->out - (char *)prec);
    prt->papFldDes[mbboRecordZRVL]->size = sizeof(prec->zrvl);
    prt->papFldDes[mbboRecordZRVL]->offset = (unsigned short)((char *)&prec->zrvl - (char *)prec);
    prt->papFldDes[mbboRecordONVL]->size = sizeof(prec->onvl);
    prt->papFldDes[mbboRecordONVL]->offset = (unsigned short)((char *)&prec->onvl - (char *)prec);
    prt->papFldDes[mbboRecordTWVL]->size = sizeof(prec->twvl);
    prt->papFldDes[mbboRecordTWVL]->offset = (unsigned short)((char *)&prec->twvl - (char *)prec);
    prt->papFldDes[mbboRecordTHVL]->size = sizeof(prec->thvl);
    prt->papFldDes[mbboRecordTHVL]->offset = (unsigned short)((char *)&prec->thvl - (char *)prec);
    prt->papFldDes[mbboRecordFRVL]->size = sizeof(prec->frvl);
    prt->papFldDes[mbboRecordFRVL]->offset = (unsigned short)((char *)&prec->frvl - (char *)prec);
    prt->papFldDes[mbboRecordFVVL]->size = sizeof(prec->fvvl);
    prt->papFldDes[mbboRecordFVVL]->offset = (unsigned short)((char *)&prec->fvvl - (char *)prec);
    prt->papFldDes[mbboRecordSXVL]->size = sizeof(prec->sxvl);
    prt->papFldDes[mbboRecordSXVL]->offset = (unsigned short)((char *)&prec->sxvl - (char *)prec);
    prt->papFldDes[mbboRecordSVVL]->size = sizeof(prec->svvl);
    prt->papFldDes[mbboRecordSVVL]->offset = (unsigned short)((char *)&prec->svvl - (char *)prec);
    prt->papFldDes[mbboRecordEIVL]->size = sizeof(prec->eivl);
    prt->papFldDes[mbboRecordEIVL]->offset = (unsigned short)((char *)&prec->eivl - (char *)prec);
    prt->papFldDes[mbboRecordNIVL]->size = sizeof(prec->nivl);
    prt->papFldDes[mbboRecordNIVL]->offset = (unsigned short)((char *)&prec->nivl - (char *)prec);
    prt->papFldDes[mbboRecordTEVL]->size = sizeof(prec->tevl);
    prt->papFldDes[mbboRecordTEVL]->offset = (unsigned short)((char *)&prec->tevl - (char *)prec);
    prt->papFldDes[mbboRecordELVL]->size = sizeof(prec->elvl);
    prt->papFldDes[mbboRecordELVL]->offset = (unsigned short)((char *)&prec->elvl - (char *)prec);
    prt->papFldDes[mbboRecordTVVL]->size = sizeof(prec->tvvl);
    prt->papFldDes[mbboRecordTVVL]->offset = (unsigned short)((char *)&prec->tvvl - (char *)prec);
    prt->papFldDes[mbboRecordTTVL]->size = sizeof(prec->ttvl);
    prt->papFldDes[mbboRecordTTVL]->offset = (unsigned short)((char *)&prec->ttvl - (char *)prec);
    prt->papFldDes[mbboRecordFTVL]->size = sizeof(prec->ftvl);
    prt->papFldDes[mbboRecordFTVL]->offset = (unsigned short)((char *)&prec->ftvl - (char *)prec);
    prt->papFldDes[mbboRecordFFVL]->size = sizeof(prec->ffvl);
    prt->papFldDes[mbboRecordFFVL]->offset = (unsigned short)((char *)&prec->ffvl - (char *)prec);
    prt->papFldDes[mbboRecordZRST]->size = sizeof(prec->zrst);
    prt->papFldDes[mbboRecordZRST]->offset = (unsigned short)((char *)&prec->zrst - (char *)prec);
    prt->papFldDes[mbboRecordONST]->size = sizeof(prec->onst);
    prt->papFldDes[mbboRecordONST]->offset = (unsigned short)((char *)&prec->onst - (char *)prec);
    prt->papFldDes[mbboRecordTWST]->size = sizeof(prec->twst);
    prt->papFldDes[mbboRecordTWST]->offset = (unsigned short)((char *)&prec->twst - (char *)prec);
    prt->papFldDes[mbboRecordTHST]->size = sizeof(prec->thst);
    prt->papFldDes[mbboRecordTHST]->offset = (unsigned short)((char *)&prec->thst - (char *)prec);
    prt->papFldDes[mbboRecordFRST]->size = sizeof(prec->frst);
    prt->papFldDes[mbboRecordFRST]->offset = (unsigned short)((char *)&prec->frst - (char *)prec);
    prt->papFldDes[mbboRecordFVST]->size = sizeof(prec->fvst);
    prt->papFldDes[mbboRecordFVST]->offset = (unsigned short)((char *)&prec->fvst - (char *)prec);
    prt->papFldDes[mbboRecordSXST]->size = sizeof(prec->sxst);
    prt->papFldDes[mbboRecordSXST]->offset = (unsigned short)((char *)&prec->sxst - (char *)prec);
    prt->papFldDes[mbboRecordSVST]->size = sizeof(prec->svst);
    prt->papFldDes[mbboRecordSVST]->offset = (unsigned short)((char *)&prec->svst - (char *)prec);
    prt->papFldDes[mbboRecordEIST]->size = sizeof(prec->eist);
    prt->papFldDes[mbboRecordEIST]->offset = (unsigned short)((char *)&prec->eist - (char *)prec);
    prt->papFldDes[mbboRecordNIST]->size = sizeof(prec->nist);
    prt->papFldDes[mbboRecordNIST]->offset = (unsigned short)((char *)&prec->nist - (char *)prec);
    prt->papFldDes[mbboRecordTEST]->size = sizeof(prec->test);
    prt->papFldDes[mbboRecordTEST]->offset = (unsigned short)((char *)&prec->test - (char *)prec);
    prt->papFldDes[mbboRecordELST]->size = sizeof(prec->elst);
    prt->papFldDes[mbboRecordELST]->offset = (unsigned short)((char *)&prec->elst - (char *)prec);
    prt->papFldDes[mbboRecordTVST]->size = sizeof(prec->tvst);
    prt->papFldDes[mbboRecordTVST]->offset = (unsigned short)((char *)&prec->tvst - (char *)prec);
    prt->papFldDes[mbboRecordTTST]->size = sizeof(prec->ttst);
    prt->papFldDes[mbboRecordTTST]->offset = (unsigned short)((char *)&prec->ttst - (char *)prec);
    prt->papFldDes[mbboRecordFTST]->size = sizeof(prec->ftst);
    prt->papFldDes[mbboRecordFTST]->offset = (unsigned short)((char *)&prec->ftst - (char *)prec);
    prt->papFldDes[mbboRecordFFST]->size = sizeof(prec->ffst);
    prt->papFldDes[mbboRecordFFST]->offset = (unsigned short)((char *)&prec->ffst - (char *)prec);
    prt->papFldDes[mbboRecordZRSV]->size = sizeof(prec->zrsv);
    prt->papFldDes[mbboRecordZRSV]->offset = (unsigned short)((char *)&prec->zrsv - (char *)prec);
    prt->papFldDes[mbboRecordONSV]->size = sizeof(prec->onsv);
    prt->papFldDes[mbboRecordONSV]->offset = (unsigned short)((char *)&prec->onsv - (char *)prec);
    prt->papFldDes[mbboRecordTWSV]->size = sizeof(prec->twsv);
    prt->papFldDes[mbboRecordTWSV]->offset = (unsigned short)((char *)&prec->twsv - (char *)prec);
    prt->papFldDes[mbboRecordTHSV]->size = sizeof(prec->thsv);
    prt->papFldDes[mbboRecordTHSV]->offset = (unsigned short)((char *)&prec->thsv - (char *)prec);
    prt->papFldDes[mbboRecordFRSV]->size = sizeof(prec->frsv);
    prt->papFldDes[mbboRecordFRSV]->offset = (unsigned short)((char *)&prec->frsv - (char *)prec);
    prt->papFldDes[mbboRecordFVSV]->size = sizeof(prec->fvsv);
    prt->papFldDes[mbboRecordFVSV]->offset = (unsigned short)((char *)&prec->fvsv - (char *)prec);
    prt->papFldDes[mbboRecordSXSV]->size = sizeof(prec->sxsv);
    prt->papFldDes[mbboRecordSXSV]->offset = (unsigned short)((char *)&prec->sxsv - (char *)prec);
    prt->papFldDes[mbboRecordSVSV]->size = sizeof(prec->svsv);
    prt->papFldDes[mbboRecordSVSV]->offset = (unsigned short)((char *)&prec->svsv - (char *)prec);
    prt->papFldDes[mbboRecordEISV]->size = sizeof(prec->eisv);
    prt->papFldDes[mbboRecordEISV]->offset = (unsigned short)((char *)&prec->eisv - (char *)prec);
    prt->papFldDes[mbboRecordNISV]->size = sizeof(prec->nisv);
    prt->papFldDes[mbboRecordNISV]->offset = (unsigned short)((char *)&prec->nisv - (char *)prec);
    prt->papFldDes[mbboRecordTESV]->size = sizeof(prec->tesv);
    prt->papFldDes[mbboRecordTESV]->offset = (unsigned short)((char *)&prec->tesv - (char *)prec);
    prt->papFldDes[mbboRecordELSV]->size = sizeof(prec->elsv);
    prt->papFldDes[mbboRecordELSV]->offset = (unsigned short)((char *)&prec->elsv - (char *)prec);
    prt->papFldDes[mbboRecordTVSV]->size = sizeof(prec->tvsv);
    prt->papFldDes[mbboRecordTVSV]->offset = (unsigned short)((char *)&prec->tvsv - (char *)prec);
    prt->papFldDes[mbboRecordTTSV]->size = sizeof(prec->ttsv);
    prt->papFldDes[mbboRecordTTSV]->offset = (unsigned short)((char *)&prec->ttsv - (char *)prec);
    prt->papFldDes[mbboRecordFTSV]->size = sizeof(prec->ftsv);
    prt->papFldDes[mbboRecordFTSV]->offset = (unsigned short)((char *)&prec->ftsv - (char *)prec);
    prt->papFldDes[mbboRecordFFSV]->size = sizeof(prec->ffsv);
    prt->papFldDes[mbboRecordFFSV]->offset = (unsigned short)((char *)&prec->ffsv - (char *)prec);
    prt->papFldDes[mbboRecordUNSV]->size = sizeof(prec->unsv);
    prt->papFldDes[mbboRecordUNSV]->offset = (unsigned short)((char *)&prec->unsv - (char *)prec);
    prt->papFldDes[mbboRecordCOSV]->size = sizeof(prec->cosv);
    prt->papFldDes[mbboRecordCOSV]->offset = (unsigned short)((char *)&prec->cosv - (char *)prec);
    prt->papFldDes[mbboRecordRVAL]->size = sizeof(prec->rval);
    prt->papFldDes[mbboRecordRVAL]->offset = (unsigned short)((char *)&prec->rval - (char *)prec);
    prt->papFldDes[mbboRecordORAW]->size = sizeof(prec->oraw);
    prt->papFldDes[mbboRecordORAW]->offset = (unsigned short)((char *)&prec->oraw - (char *)prec);
    prt->papFldDes[mbboRecordRBV]->size = sizeof(prec->rbv);
    prt->papFldDes[mbboRecordRBV]->offset = (unsigned short)((char *)&prec->rbv - (char *)prec);
    prt->papFldDes[mbboRecordORBV]->size = sizeof(prec->orbv);
    prt->papFldDes[mbboRecordORBV]->offset = (unsigned short)((char *)&prec->orbv - (char *)prec);
    prt->papFldDes[mbboRecordMASK]->size = sizeof(prec->mask);
    prt->papFldDes[mbboRecordMASK]->offset = (unsigned short)((char *)&prec->mask - (char *)prec);
    prt->papFldDes[mbboRecordMLST]->size = sizeof(prec->mlst);
    prt->papFldDes[mbboRecordMLST]->offset = (unsigned short)((char *)&prec->mlst - (char *)prec);
    prt->papFldDes[mbboRecordLALM]->size = sizeof(prec->lalm);
    prt->papFldDes[mbboRecordLALM]->offset = (unsigned short)((char *)&prec->lalm - (char *)prec);
    prt->papFldDes[mbboRecordSDEF]->size = sizeof(prec->sdef);
    prt->papFldDes[mbboRecordSDEF]->offset = (unsigned short)((char *)&prec->sdef - (char *)prec);
    prt->papFldDes[mbboRecordSHFT]->size = sizeof(prec->shft);
    prt->papFldDes[mbboRecordSHFT]->offset = (unsigned short)((char *)&prec->shft - (char *)prec);
    prt->papFldDes[mbboRecordSIOL]->size = sizeof(prec->siol);
    prt->papFldDes[mbboRecordSIOL]->offset = (unsigned short)((char *)&prec->siol - (char *)prec);
    prt->papFldDes[mbboRecordSIML]->size = sizeof(prec->siml);
    prt->papFldDes[mbboRecordSIML]->offset = (unsigned short)((char *)&prec->siml - (char *)prec);
    prt->papFldDes[mbboRecordSIMM]->size = sizeof(prec->simm);
    prt->papFldDes[mbboRecordSIMM]->offset = (unsigned short)((char *)&prec->simm - (char *)prec);
    prt->papFldDes[mbboRecordSIMS]->size = sizeof(prec->sims);
    prt->papFldDes[mbboRecordSIMS]->offset = (unsigned short)((char *)&prec->sims - (char *)prec);
    prt->papFldDes[mbboRecordOLDSIMM]->size = sizeof(prec->oldsimm);
    prt->papFldDes[mbboRecordOLDSIMM]->offset = (unsigned short)((char *)&prec->oldsimm - (char *)prec);
    prt->papFldDes[mbboRecordSSCN]->size = sizeof(prec->sscn);
    prt->papFldDes[mbboRecordSSCN]->offset = (unsigned short)((char *)&prec->sscn - (char *)prec);
    prt->papFldDes[mbboRecordSDLY]->size = sizeof(prec->sdly);
    prt->papFldDes[mbboRecordSDLY]->offset = (unsigned short)((char *)&prec->sdly - (char *)prec);
    prt->papFldDes[mbboRecordSIMPVT]->size = sizeof(prec->simpvt);
    prt->papFldDes[mbboRecordSIMPVT]->offset = (unsigned short)((char *)&prec->simpvt - (char *)prec);
    prt->papFldDes[mbboRecordIVOA]->size = sizeof(prec->ivoa);
    prt->papFldDes[mbboRecordIVOA]->offset = (unsigned short)((char *)&prec->ivoa - (char *)prec);
    prt->papFldDes[mbboRecordIVOV]->size = sizeof(prec->ivov);
    prt->papFldDes[mbboRecordIVOV]->offset = (unsigned short)((char *)&prec->ivov - (char *)prec);
    prt->rec_size = sizeof(*prec);
    return 0;
}
epicsExportRegistrar(mbboRecordSizeOffset);

#ifdef __cplusplus
}
#endif
#endif /* GEN_SIZE_OFFSET */

#endif /* INC_mbboRecord_H */
