/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.common.cache.CacheBuilder;
import com.google.javascript.jscomp.transpile.BaseTranspiler;
import com.google.javascript.jscomp.transpile.CachingTranspiler;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import javax.annotation.CheckReturnValue;

public final class TranspilerBuilder {
    private static final TranspilerBuilder TO_ES5 = new TranspilerBuilder(new BaseTranspiler(new BaseTranspiler.CompilerSupplier(), "es6_runtime"));
    private final Transpiler transpiler;
    private static final String DEFAULT_CACHE_SPEC = "maximumSize=10000";

    public static TranspilerBuilder toEs5() {
        return TO_ES5;
    }

    TranspilerBuilder(Transpiler transpiler) {
        this.transpiler = transpiler;
    }

    @CheckReturnValue
    public TranspilerBuilder caching() {
        return this.caching(DEFAULT_CACHE_SPEC);
    }

    @CheckReturnValue
    public TranspilerBuilder caching(String spec) {
        return this.caching(CacheBuilder.from(spec));
    }

    @CheckReturnValue
    public TranspilerBuilder caching(CacheBuilder<Object, ? super TranspileResult> builder) {
        return new TranspilerBuilder(new CachingTranspiler(this.transpiler, builder));
    }

    public Transpiler build() {
        return this.transpiler;
    }
}

