/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Ordering;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.List;

@GwtIncompatible(value="JsMessage")
class ReplaceMessagesForChrome
extends JsMessageVisitor {
    ReplaceMessagesForChrome(AbstractCompiler compiler, JsMessage.IdGenerator idGenerator, boolean checkDuplicatedMessages, JsMessage.Style style) {
        super(compiler, checkDuplicatedMessages, style, idGenerator);
    }

    private static Node getChromeI18nGetMessageNode(String messageId) {
        Node chromeI18n = IR.getprop(IR.name("chrome"), IR.string("i18n"));
        Node getMessage = IR.getprop(chromeI18n, IR.string("getMessage"));
        return IR.call(getMessage, IR.string(messageId));
    }

    @Override
    protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
        try {
            Node msgNode = definition.getMessageNode();
            Node newValue = this.getNewValueNode(msgNode, message);
            newValue.useSourceInfoIfMissingFromForTree(msgNode);
            msgNode.replaceWith(newValue);
            this.compiler.reportChangeToEnclosingScope(newValue);
        }
        catch (JsMessageVisitor.MalformedException e) {
            this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
        }
    }

    private Node getNewValueNode(Node origNode, JsMessage message) throws JsMessageVisitor.MalformedException {
        Node newValueNode = ReplaceMessagesForChrome.getChromeI18nGetMessageNode(message.getId());
        boolean isHtml = this.isHtml(origNode);
        if (!message.placeholders().isEmpty() || isHtml) {
            Node placeholderValues = origNode.getChildAtIndex(2);
            this.checkNode(placeholderValues, Token.OBJECTLIT);
            List<String> placeholderNames = Ordering.natural().sortedCopy(message.placeholders());
            Node placeholderValueArray = IR.arraylit(new Node[0]);
            for (String name : placeholderNames) {
                Node value = ReplaceMessagesForChrome.getPlaceholderValue(placeholderValues, name);
                if (value == null) {
                    throw new JsMessageVisitor.MalformedException("No value was provided for placeholder " + name, origNode);
                }
                placeholderValueArray.addChildToBack(value);
            }
            if (isHtml) {
                Node args = IR.arraylit(IR.string(message.getId()), placeholderValueArray);
                Node options = IR.arraylit(IR.objectlit(IR.stringKey("escapeLt", IR.trueNode())));
                Node regexp = IR.regexp(IR.string("Chrome\\/(\\d+)"));
                Node userAgent = NodeUtil.newQName(this.compiler, "navigator.userAgent");
                Node version = IR.getelem(IR.or(IR.call(IR.getprop(regexp, "exec", new String[0]), userAgent), IR.arraylit(new Node[0])), IR.number(1.0));
                Node condition = IR.ge(version, IR.number(79.0));
                args = IR.call(IR.getprop(args, "concat", new String[0]), IR.hook(condition, options, IR.arraylit(new Node[0])));
                newValueNode = IR.call(NodeUtil.newQName(this.compiler, "chrome.i18n.getMessage.apply"), IR.nullNode(), args);
            } else {
                newValueNode.addChildToBack(placeholderValueArray);
            }
        }
        newValueNode.useSourceInfoIfMissingFromForTree(origNode);
        return newValueNode;
    }

    private boolean isHtml(Node node) throws JsMessageVisitor.MalformedException {
        if (node.getChildCount() > 3) {
            Node options = node.getChildAtIndex(3);
            this.checkNode(options, Token.OBJECTLIT);
            for (Node opt = options.getFirstChild(); opt != null; opt = opt.getNext()) {
                this.checkNode(opt, Token.STRING_KEY);
                if (!opt.getString().equals("html")) continue;
                return opt.getFirstChild().isTrue();
            }
        }
        return false;
    }

    private static Node getPlaceholderValue(Node placeholderValues, String placeholderName) {
        for (Node key : placeholderValues.children()) {
            if (!key.getString().equals(placeholderName)) continue;
            return key.getFirstChild().cloneTree();
        }
        return null;
    }
}

