/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractVar;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class ScopedAliases
implements HotSwapCompilerPass {
    static final String SCOPING_METHOD_NAME = "goog.scope";
    private final AbstractCompiler compiler;
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final CompilerOptions.AliasTransformationHandler transformationHandler;
    static final DiagnosticType GOOG_SCOPE_MUST_BE_ALONE = DiagnosticType.error("JSC_GOOG_SCOPE_MUST_BE_ALONE", "The call to goog.scope must be alone in a single statement.");
    static final DiagnosticType GOOG_SCOPE_MUST_BE_IN_GLOBAL_SCOPE = DiagnosticType.error("JSC_GOOG_SCOPE_MUST_BE_IN_GLOBAL_SCOPE", "The call to goog.scope must be in the global scope.");
    static final DiagnosticType GOOG_SCOPE_HAS_BAD_PARAMETERS = DiagnosticType.error("JSC_GOOG_SCOPE_HAS_BAD_PARAMETERS", "The call to goog.scope must take only a single parameter.  It must be an anonymous function that itself takes no parameters.");
    static final DiagnosticType GOOG_SCOPE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_SCOPE_REFERENCES_THIS", "The body of a goog.scope function cannot reference 'this'.");
    static final DiagnosticType GOOG_SCOPE_USES_RETURN = DiagnosticType.error("JSC_GOOG_SCOPE_USES_RETURN", "The body of a goog.scope function cannot use 'return'.");
    static final DiagnosticType GOOG_SCOPE_USES_THROW = DiagnosticType.error("JSC_GOOG_SCOPE_USES_THROW", "The body of a goog.scope function cannot use 'throw'.");
    static final DiagnosticType GOOG_SCOPE_ALIAS_REDEFINED = DiagnosticType.error("JSC_GOOG_SCOPE_ALIAS_REDEFINED", "The alias {0} is assigned a value more than once.");
    static final DiagnosticType GOOG_SCOPE_ALIAS_CYCLE = DiagnosticType.error("JSC_GOOG_SCOPE_ALIAS_CYCLE", "The aliases {0} has a cycle.");
    static final DiagnosticType GOOG_SCOPE_NON_ALIAS_LOCAL = DiagnosticType.error("JSC_GOOG_SCOPE_NON_ALIAS_LOCAL", "The local variable {0} is in a goog.scope and is not an alias.");
    static final DiagnosticType GOOG_SCOPE_INVALID_VARIABLE = DiagnosticType.error("JSC_GOOG_SCOPE_INVALID_VARIABLE", "The variable {0} cannot be declared in this scope");
    private final Multiset<String> scopedAliasNames = HashMultiset.create();
    private final Set<String> closureNamespaces;
    private final InvalidModuleGetHandling invalidModuleGetHandling;

    @Deprecated
    ScopedAliases(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CompilerOptions.AliasTransformationHandler transformationHandler) {
        this(compiler, preprocessorSymbolTable, transformationHandler, ImmutableSet.of(), InvalidModuleGetHandling.PRESERVE);
    }

    private ScopedAliases(AbstractCompiler compiler, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, CompilerOptions.AliasTransformationHandler transformationHandler, Set<String> closureNamespaces, InvalidModuleGetHandling invalidModuleGetHandling) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.transformationHandler = transformationHandler;
        this.closureNamespaces = closureNamespaces;
        this.invalidModuleGetHandling = invalidModuleGetHandling;
    }

    static Builder builder(AbstractCompiler compiler) {
        return new Builder(compiler);
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node root, Node originalRoot) {
        Traversal traversal = new Traversal();
        NodeTraversal.traverse(this.compiler, root, traversal);
        if (!traversal.hasErrors()) {
            ArrayList aliasWorkQueue = new ArrayList(traversal.getAliasUsages());
            while (!aliasWorkQueue.isEmpty()) {
                ArrayList<AliasUsage> newQueue = new ArrayList<AliasUsage>();
                for (AliasUsage aliasUsage : aliasWorkQueue) {
                    if (aliasUsage.referencesOtherAlias(traversal.deletedAliasVars)) {
                        newQueue.add(aliasUsage);
                        continue;
                    }
                    aliasUsage.applyAlias(this.compiler);
                }
                if (newQueue.size() == aliasWorkQueue.size()) {
                    Var cycleVar = ((AliasUsage)newQueue.get((int)0)).aliasVar;
                    this.compiler.report(JSError.make(cycleVar.getNode(), GOOG_SCOPE_ALIAS_CYCLE, cycleVar.getName()));
                    break;
                }
                aliasWorkQueue = newQueue;
            }
            for (Node aliasDefinition : traversal.getAliasDefinitionsToDelete()) {
                this.compiler.reportChangeToEnclosingScope(aliasDefinition);
                if (NodeUtil.isNameDeclaration(aliasDefinition.getParent()) && aliasDefinition.getParent().hasOneChild()) {
                    aliasDefinition.getParent().detach();
                    continue;
                }
                aliasDefinition.detach();
            }
            for (Node scopeCall : traversal.getScopeCalls()) {
                Node expressionWithScopeCall = scopeCall.getParent();
                Node scopeClosureBlock = scopeCall.getLastChild().getLastChild();
                scopeClosureBlock.detach();
                expressionWithScopeCall.replaceWith(scopeClosureBlock);
                NodeUtil.markFunctionsDeleted(expressionWithScopeCall, this.compiler);
                this.compiler.reportChangeToEnclosingScope(scopeClosureBlock);
                NodeUtil.tryMergeBlock(scopeClosureBlock, false);
            }
        }
    }

    private static boolean isValidAliasRhs(Node rhs) {
        switch (rhs.getToken()) {
            case GETPROP: {
                return ScopedAliases.isValidAliasRhs(rhs.getFirstChild());
            }
            case NAME: {
                return true;
            }
            case CALL: {
                return NodeUtil.isCallTo(rhs, "goog.module.get");
            }
        }
        return false;
    }

    private static boolean isAliasDefinition(Node nameNode) {
        if (!nameNode.hasChildren()) {
            return false;
        }
        Node rhs = nameNode.getLastChild();
        return ScopedAliases.isValidAliasRhs(rhs);
    }

    private static String getAliasedNamespace(Node rhs) {
        switch (rhs.getToken()) {
            case GETPROP: {
                return ScopedAliases.getAliasedNamespace(rhs.getFirstChild()) + '.' + rhs.getLastChild().getString();
            }
            case NAME: {
                return rhs.getString();
            }
            case CALL: {
                Preconditions.checkState(NodeUtil.isCallTo(rhs, "goog.module.get"), rhs);
                Preconditions.checkState(rhs.hasTwoChildren(), rhs);
                return rhs.getLastChild().getString();
            }
        }
        throw new RuntimeException("Invalid alias RHS:" + rhs);
    }

    private class Traversal
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private final List<Node> aliasDefinitionsToDelete = new ArrayList<Node>();
        private final List<Node> scopeCalls = new ArrayList<Node>();
        private final List<AliasUsage> aliasUsages = new ArrayList<AliasUsage>();
        private final Map<String, Var> aliases = new HashMap<String, Var>();
        private final Set<Node> injectedDecls = new HashSet<Node>();
        private final Set<Var> deletedAliasVars = new HashSet<Var>();
        private final Set<String> forbiddenLocals = new HashSet<String>(ImmutableSet.of("$jscomp"));
        private boolean hasNamespaceShadows = false;
        private boolean hasErrors = false;
        private CompilerOptions.AliasTransformation transformation = null;
        private Node scopeFunctionBody = null;

        private Traversal() {
        }

        Collection<Node> getAliasDefinitionsToDelete() {
            return this.aliasDefinitionsToDelete;
        }

        private List<AliasUsage> getAliasUsages() {
            return this.aliasUsages;
        }

        List<Node> getScopeCalls() {
            return this.scopeCalls;
        }

        boolean hasErrors() {
            return this.hasErrors;
        }

        private boolean inGoogScopeBody() {
            return this.scopeFunctionBody != null;
        }

        private boolean isGoogScopeFunctionBody(Node n) {
            return this.inGoogScopeBody() && n == this.scopeFunctionBody;
        }

        private boolean isCallToScopeMethod(Node n) {
            return n.isCall() && n.getFirstChild().matchesQualifiedName(ScopedAliases.SCOPING_METHOD_NAME);
        }

        private Node findScopeMethodCall(Node scopeRoot) {
            Node n = scopeRoot.getGrandparent();
            if (this.isCallToScopeMethod(n)) {
                return n;
            }
            return null;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalHoistScope()) {
                return;
            }
            Node scopeMethodCall = this.findScopeMethodCall(t.getScopeRoot());
            if (scopeMethodCall != null) {
                this.transformation = ScopedAliases.this.transformationHandler.logAliasTransformation(scopeMethodCall.getSourceFileName(), this.getSourceRegion(scopeMethodCall));
                this.findAliases(t.getScope());
                this.scopeFunctionBody = scopeMethodCall.getLastChild().getLastChild();
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
            if (this.isGoogScopeFunctionBody(t.getScopeRoot())) {
                this.scopeFunctionBody = null;
                this.renameNamespaceShadows(t);
                this.injectedDecls.clear();
                this.aliases.clear();
                this.forbiddenLocals.clear();
                this.transformation = null;
                this.hasNamespaceShadows = false;
            } else if (this.inGoogScopeBody()) {
                this.findNamespaceShadows(t);
                this.reportInvalidVariables(t);
            }
        }

        private void reportInvalidVariables(NodeTraversal t) {
            Node scopeRoot = t.getScopeRoot();
            Node enclosingFunctionBody = t.getEnclosingFunction().getLastChild();
            if (this.isGoogScopeFunctionBody(enclosingFunctionBody) && scopeRoot.isBlock() && !scopeRoot.getParent().isFunction()) {
                for (Var v : t.getScope().getVarIterable()) {
                    Node parent = v.getNameNode().getParent();
                    if (!NodeUtil.isFunctionDeclaration(parent)) continue;
                    this.report(v.getNode(), GOOG_SCOPE_INVALID_VARIABLE, v.getName());
                }
            }
        }

        private SourcePosition<CompilerOptions.AliasTransformation> getSourceRegion(Node n) {
            Node testNode = n;
            Node next = null;
            while (next != null || testNode.isScript()) {
                next = testNode.getNext();
                testNode = testNode.getParent();
            }
            int endLine = next == null ? Integer.MAX_VALUE : next.getLineno();
            int endChar = next == null ? Integer.MAX_VALUE : next.getCharno();
            SourcePosition<CompilerOptions.AliasTransformation> pos = new SourcePosition<CompilerOptions.AliasTransformation>(){};
            pos.setPositionInformation(n.getLineno(), n.getCharno(), endLine, endChar);
            return pos;
        }

        private void report(Node n, DiagnosticType error, String ... arguments) {
            ScopedAliases.this.compiler.report(JSError.make(n, error, arguments));
            this.hasErrors = true;
        }

        private void findAliases(Scope scope) {
            for (Var v : scope.getVarIterable()) {
                Node n = v.getNode();
                Node parent = n.getParent();
                boolean isVar = NodeUtil.isNameDeclaration(parent) && parent.getParent().isBlock();
                boolean isFunctionDecl = NodeUtil.isFunctionDeclaration(parent);
                if (isVar && ScopedAliases.isAliasDefinition(n)) {
                    this.recordAlias(v);
                    continue;
                }
                if (v.isBleedingFunction() || parent.isParamList()) continue;
                if (isVar || isFunctionDecl || NodeUtil.isClassDeclaration(parent)) {
                    boolean isHoisted = NodeUtil.isHoistedFunctionDeclaration(parent);
                    Node grandparent = parent.getParent();
                    Node value = v.getInitialValue();
                    Node varNode = null;
                    if (n.getJSDocInfo() != null) {
                        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(parent.getJSDocInfo());
                        if (isFunctionDecl) {
                            builder.recordReturnType(n.getJSDocInfo().getType());
                        } else {
                            builder.recordType(n.getJSDocInfo().getType());
                        }
                        parent.setJSDocInfo(builder.build());
                        n.setJSDocInfo(null);
                    }
                    JSDocInfo varDocInfo = v.getJSDocInfo();
                    String name = n.getString();
                    int nameCount = ScopedAliases.this.scopedAliasNames.count(name);
                    ScopedAliases.this.scopedAliasNames.add(name);
                    String globalName = "$jscomp.scope." + name + (nameCount == 0 ? "" : "$jscomp$" + nameCount);
                    Node lastInjectedNode = ScopedAliases.this.compiler.ensureLibraryInjected("base", false);
                    if (lastInjectedNode != null) {
                        ScopedAliases.this.compiler.reportChangeToEnclosingScope(lastInjectedNode);
                    }
                    if (isFunctionDecl || NodeUtil.isClassDeclaration(parent)) {
                        Node newName = isFunctionDecl ? IR.name("") : IR.empty();
                        newName.useSourceInfoFrom(n);
                        value.replaceChild(n, newName);
                        ScopedAliases.this.compiler.reportChangeToEnclosingScope(newName);
                        varNode = IR.var(n).useSourceInfoFrom(n);
                        grandparent.replaceChild(parent, varNode);
                    } else {
                        if (value != null) {
                            value.detach();
                        }
                        varNode = parent;
                    }
                    if (value != null || varDocInfo != null) {
                        Node newDecl = NodeUtil.newQNameDeclaration(ScopedAliases.this.compiler, globalName, value, varDocInfo).useSourceInfoIfMissingFromForTree(n);
                        newDecl.getFirstFirstChild().useSourceInfoFrom(n);
                        newDecl.getFirstFirstChild().setOriginalName(name);
                        if (isHoisted) {
                            grandparent.addChildToFront(newDecl);
                        } else {
                            grandparent.addChildBefore(newDecl, varNode);
                        }
                        ScopedAliases.this.compiler.reportChangeToEnclosingScope(newDecl);
                        this.injectedDecls.add(newDecl.getFirstChild());
                    }
                    v.getNameNode().addChildToFront(NodeUtil.newQName(ScopedAliases.this.compiler, globalName, n, name));
                    this.recordAlias(v);
                    continue;
                }
                this.report(n, GOOG_SCOPE_NON_ALIAS_LOCAL, n.getString());
            }
        }

        private void recordAlias(Var aliasVar) {
            String qNameRoot;
            Node initialValue = aliasVar.getInitialValue();
            this.aliasDefinitionsToDelete.add(aliasVar.getNameNode());
            if (ScopedAliases.this.invalidModuleGetHandling.shouldDelete() && this.containsInvalidGoogModuleGet(initialValue)) {
                this.deletedAliasVars.add(aliasVar);
                return;
            }
            String name = aliasVar.getName();
            this.aliases.put(name, aliasVar);
            String qualifiedName = ScopedAliases.getAliasedNamespace(initialValue);
            this.transformation.addAlias(name, qualifiedName);
            int rootIndex = qualifiedName.indexOf(46);
            if (rootIndex != -1 && !this.aliases.containsKey(qNameRoot = qualifiedName.substring(0, rootIndex))) {
                this.forbiddenLocals.add(qNameRoot);
            }
        }

        private boolean containsInvalidGoogModuleGet(Node expression) {
            switch (expression.getToken()) {
                case NAME: {
                    return false;
                }
                case GETPROP: {
                    return this.containsInvalidGoogModuleGet(expression.getFirstChild());
                }
                case CALL: {
                    String namespace = expression.getSecondChild().getString();
                    return !ScopedAliases.this.closureNamespaces.contains(namespace);
                }
            }
            throw new IllegalStateException("Unrecognized alias rhs " + expression);
        }

        private void findNamespaceShadows(NodeTraversal t) {
            if (this.hasNamespaceShadows) {
                return;
            }
            Scope scope = t.getScope();
            for (Var v : scope.getVarIterable()) {
                if (!this.forbiddenLocals.contains(v.getName())) continue;
                this.hasNamespaceShadows = true;
                return;
            }
        }

        private void renameNamespaceShadows(NodeTraversal t) {
            Preconditions.checkState(NodeUtil.isFunctionBlock(t.getScopeRoot()), t.getScopeRoot());
            if (this.hasNamespaceShadows) {
                MakeDeclaredNamesUnique.TargettedRenamer renamer = new MakeDeclaredNamesUnique.TargettedRenamer(new MakeDeclaredNamesUnique.ContextualRenamer(), this.forbiddenLocals);
                for (String s : this.forbiddenLocals) {
                    renamer.addDeclaredName(s, false);
                }
                MakeDeclaredNamesUnique uniquifier = new MakeDeclaredNamesUnique(renamer);
                NodeTraversal.traverseScopeRoots(ScopedAliases.this.compiler, null, ImmutableList.of(t.getScopeRoot()), uniquifier, true);
            }
        }

        private void renameBleedingFunctionName(NodeTraversal t, final Node fnName) {
            final String name = fnName.getString();
            final String suffix = ScopedAliases.this.compiler.getUniqueNameIdSupplier().get();
            NodeTraversal.AbstractPostOrderCallback cb = new NodeTraversal.AbstractPostOrderCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isName() && n.getString().equals(name) && ((Var)t.getScope().getVar(name)).getNode() == fnName) {
                        n.setString(name + "$jscomp$scopedAliases$" + suffix);
                        ScopedAliases.this.compiler.reportChangeToEnclosingScope(n);
                    }
                }
            };
            new NodeTraversal(ScopedAliases.this.compiler, cb, t.getScopeCreator()).traverseAtScope(t.getScope());
            fnName.setString(name + "$jscomp$scopedAliases$" + suffix);
        }

        private void validateScopeCall(NodeTraversal t, Node n, Node parent) {
            if (ScopedAliases.this.preprocessorSymbolTable != null) {
                ScopedAliases.this.preprocessorSymbolTable.addReference(n.getFirstChild());
            }
            if (!parent.isExprResult()) {
                this.report(n, GOOG_SCOPE_MUST_BE_ALONE, new String[0]);
            }
            if (t.getEnclosingFunction() != null) {
                this.report(n, GOOG_SCOPE_MUST_BE_IN_GLOBAL_SCOPE, new String[0]);
            }
            if (!n.hasTwoChildren()) {
                this.report(n, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
            } else {
                Node anonymousFnNode = n.getSecondChild();
                if (!anonymousFnNode.isFunction() || NodeUtil.getName(anonymousFnNode) != null || NodeUtil.getFunctionParameters(anonymousFnNode).hasChildren()) {
                    this.report(anonymousFnNode, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
                } else {
                    this.scopeCalls.add(n);
                }
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info;
            if (this.isCallToScopeMethod(n)) {
                this.validateScopeCall(t, n, n.getParent());
            }
            if (!this.inGoogScopeBody()) {
                return;
            }
            Token type = n.getToken();
            AbstractVar aliasVar = null;
            if (type == Token.NAME) {
                String name = n.getString();
                Var lexicalVar = (Var)t.getScope().getVar(name);
                if (lexicalVar != null && lexicalVar.equals(this.aliases.get(name))) {
                    aliasVar = lexicalVar;
                    if (ScopedAliases.this.compiler.getOptions().preservesDetailedSourceInfo() && n.isName()) {
                        n.setOriginalName(name);
                    }
                }
            }
            if (this.isGoogScopeFunctionBody(t.getEnclosingFunction().getLastChild())) {
                if (aliasVar != null && NodeUtil.isLValue(n)) {
                    if (aliasVar.getNode() == n) {
                        return;
                    }
                    this.report(n, GOOG_SCOPE_ALIAS_REDEFINED, n.getString());
                }
                if (type == Token.RETURN) {
                    this.report(n, GOOG_SCOPE_USES_RETURN, new String[0]);
                } else if (type == Token.THIS) {
                    this.report(n, GOOG_SCOPE_REFERENCES_THIS, new String[0]);
                } else if (type == Token.THROW) {
                    this.report(n, GOOG_SCOPE_USES_THROW, new String[0]);
                }
            }
            if (NodeUtil.isBleedingFunctionName(n)) {
                this.renameBleedingFunctionName(t, n);
            }
            if (aliasVar != null) {
                this.aliasUsages.add(new AliasedNode((Var)aliasVar, n));
            }
            if ((info = n.getJSDocInfo()) != null && !this.injectedDecls.contains(n)) {
                for (Node node : info.getTypeNodes()) {
                    this.fixTypeNode(node);
                }
            }
        }

        private void fixTypeNode(Node typeNode) {
            if (typeNode.isString()) {
                String baseName;
                Var aliasVar;
                String name = typeNode.getString();
                int endIndex = name.indexOf(46);
                if (endIndex == -1) {
                    endIndex = name.length();
                }
                if ((aliasVar = this.aliases.get(baseName = name.substring(0, endIndex))) != null) {
                    this.aliasUsages.add(new AliasedTypeNode(aliasVar, typeNode));
                }
                if (ScopedAliases.this.compiler.getOptions().preservesDetailedSourceInfo()) {
                    typeNode.setOriginalName(name);
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(child);
            }
        }
    }

    private static class AliasedTypeNode
    extends AliasUsage {
        AliasedTypeNode(Var aliasVar, Node aliasReference) {
            super(aliasVar, aliasReference);
        }

        @Override
        public void applyAlias(AbstractCompiler compiler) {
            Node aliasDefinition = this.aliasVar.getInitialValue();
            String aliasName = this.aliasVar.getName();
            String typeName = this.aliasReference.getString();
            if (typeName.startsWith("$jscomp.scope.")) {
                return;
            }
            String aliasExpanded = Preconditions.checkNotNull(ScopedAliases.getAliasedNamespace(aliasDefinition));
            Preconditions.checkState(typeName.startsWith(aliasName), "%s must start with %s", (Object)typeName, (Object)aliasName);
            String replacement = aliasExpanded + typeName.substring(aliasName.length());
            this.aliasReference.setString(replacement);
        }
    }

    private static class AliasedNode
    extends AliasUsage {
        AliasedNode(Var aliasVar, Node aliasReference) {
            super(aliasVar, aliasReference);
        }

        @Override
        public void applyAlias(AbstractCompiler compiler) {
            Node aliasDefinition = this.aliasVar.getInitialValue();
            Node replacement = aliasDefinition.cloneTree();
            replacement.useSourceInfoFromForTree(this.aliasReference);
            if (replacement.hasChildren()) {
                replacement.getFirstChild().makeNonIndexableRecursive();
            }
            if (this.aliasReference.isStringKey()) {
                Preconditions.checkState(!this.aliasReference.hasChildren());
                this.aliasReference.addChildToFront(replacement);
            } else {
                this.aliasReference.replaceWith(replacement);
            }
            compiler.reportChangeToEnclosingScope(replacement);
        }
    }

    private static abstract class AliasUsage {
        final Var aliasVar;
        final Node aliasReference;

        AliasUsage(Var aliasVar, Node aliasReference) {
            this.aliasVar = aliasVar;
            this.aliasReference = aliasReference;
        }

        public boolean referencesOtherAlias(Set<Var> deletedAliasVars) {
            Node aliasDefinition = this.aliasVar.getInitialValue();
            String qname = ScopedAliases.getAliasedNamespace(aliasDefinition);
            int dotIndex = qname.indexOf(46);
            String rootName = dotIndex == -1 ? qname : qname.substring(0, dotIndex);
            Var otherAliasVar = (Var)((Scope)this.aliasVar.getScope()).getOwnSlot(rootName);
            return otherAliasVar != null && !deletedAliasVars.contains(otherAliasVar);
        }

        public abstract void applyAlias(AbstractCompiler var1);
    }

    static class Builder {
        private final AbstractCompiler compiler;
        @Nullable
        private PreprocessorSymbolTable preprocessorSymbolTable = null;
        private CompilerOptions.AliasTransformationHandler transformationHandler = CompilerOptions.NULL_ALIAS_TRANSFORMATION_HANDLER;
        private ModuleMetadataMap moduleMetadataMap = null;
        private InvalidModuleGetHandling invalidModuleGetHandling = InvalidModuleGetHandling.PRESERVE;

        private Builder(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        Builder setPreprocessorSymbolTable(@Nullable PreprocessorSymbolTable preprocessorSymbolTable) {
            this.preprocessorSymbolTable = preprocessorSymbolTable;
            return this;
        }

        Builder setModuleMetadataMap(ModuleMetadataMap moduleMetadataMap) {
            this.moduleMetadataMap = moduleMetadataMap;
            return this;
        }

        Builder setInvalidModuleGetHandling(InvalidModuleGetHandling invalidModuleGetHandling) {
            this.invalidModuleGetHandling = invalidModuleGetHandling;
            return this;
        }

        Builder setAliasTransformationHandler(CompilerOptions.AliasTransformationHandler aliasTransformationHandler) {
            this.transformationHandler = aliasTransformationHandler;
            return this;
        }

        ScopedAliases build() {
            return new ScopedAliases(this.compiler, this.preprocessorSymbolTable, this.transformationHandler, this.moduleMetadataMap == null ? ImmutableSet.of() : this.moduleMetadataMap.getModulesByGoogNamespace().keySet(), this.invalidModuleGetHandling);
        }
    }

    static enum InvalidModuleGetHandling {
        PRESERVE,
        DELETE;


        boolean shouldDelete() {
            return this.equals((Object)DELETE);
        }
    }
}

