/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Consumer;

public final class JSTypeExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final JSTypeExpression IMPLICIT_TEMPLATE_BOUND = new JSTypeExpression(new Node(Token.QMARK), "");
    private final Node root;
    private final String sourceName;

    public JSTypeExpression(Node root, String sourceName) {
        this.root = root;
        this.sourceName = sourceName;
    }

    public JSTypeExpression replaceNamesWithUnknownType(Set<String> names) {
        Node oldExprRoot = this.root.cloneTree();
        Node newExprRoot = JSTypeExpression.replaceNames(oldExprRoot, names);
        JSTypeExpression newTypeExpression = new JSTypeExpression(newExprRoot, this.sourceName);
        return newTypeExpression;
    }

    private static Node replaceNames(Node n, Set<String> names) {
        if (n == null) {
            return null;
        }
        for (Node child : n.children()) {
            JSTypeExpression.replaceNames(child, names);
        }
        if (n.isString() && names.contains(n.getString())) {
            Node qMark = new Node(Token.QMARK);
            qMark.addChildrenToBack(n.removeChildren());
            if (n.getParent() != null) {
                n.replaceWith(qMark);
            }
            return qMark;
        }
        return n;
    }

    public ImmutableList<Node> getAllTypeNodes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        JSTypeExpression.visitAllTypeNodes(this.root, builder::add);
        return builder.build();
    }

    public ImmutableSet<String> getAllTypeNames() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        JSTypeExpression.visitAllTypeNodes(this.root, n -> builder.add(n.getString()));
        return builder.build();
    }

    private static void visitAllTypeNodes(Node n, Consumer<Node> visitor) {
        if (n == null) {
            return;
        }
        for (Node child : n.children()) {
            JSTypeExpression.visitAllTypeNodes(child, visitor);
        }
        if (n.isString()) {
            visitor.accept(n);
        }
    }

    public static JSTypeExpression makeOptionalArg(JSTypeExpression expr) {
        if (expr.isOptionalArg() || expr.isVarArgs()) {
            return expr;
        }
        Node equals = new Node(Token.EQUALS, expr.root);
        equals.clonePropsFrom(expr.root);
        return new JSTypeExpression(equals, expr.sourceName);
    }

    public boolean isOptionalArg() {
        return this.root.getToken() == Token.EQUALS;
    }

    public boolean isVarArgs() {
        return this.root.getToken() == Token.ITER_REST;
    }

    public JSType evaluate(StaticTypedScope scope, JSTypeRegistry registry) {
        JSType type = registry.createTypeFromCommentNode(this.root, this.sourceName, scope);
        this.root.setJSType(type);
        return type;
    }

    public boolean equals(Object other) {
        return other instanceof JSTypeExpression && ((JSTypeExpression)other).root.isEquivalentTo(this.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public Node getRoot() {
        return this.root;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return "type: " + this.root.toStringTree();
    }

    public JSTypeExpression copy() {
        return new JSTypeExpression(this.root.cloneTree(), this.sourceName);
    }

    public boolean isExplicitUnknownTemplateBound() {
        return this != IMPLICIT_TEMPLATE_BOUND && this.equals(IMPLICIT_TEMPLATE_BOUND);
    }

    public ImmutableSet<String> getRecordPropertyNames() {
        ImmutableSet.Builder<String> builder = ImmutableSet.builder();
        JSTypeExpression.getRecordPropertyNamesRecursive(this.root, builder);
        return builder.build();
    }

    private static void getRecordPropertyNamesRecursive(Node n, ImmutableSet.Builder<String> names) {
        if (n == null) {
            return;
        }
        for (Node child : n.children()) {
            JSTypeExpression.getRecordPropertyNamesRecursive(child, names);
        }
        if (n.isStringKey()) {
            names.add((Object)n.getString());
        }
    }

    static {
        IMPLICIT_TEMPLATE_BOUND.getRoot().setStaticSourceFile(new SimpleSourceFile("<IMPLICT_TEMPLATE_BOUND>", StaticSourceFile.SourceKind.STRONG));
    }
}

