/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphNode;
import java.util.LinkedHashSet;
import java.util.Set;

public final class FixedPointGraphTraversal<N, E> {
    private final EdgeCallback<N, E> callback;
    private final TraversalDirection traversalDirection;
    public static final String NON_HALTING_ERROR_MSG = "Fixed point computation not halting";

    private FixedPointGraphTraversal(EdgeCallback<N, E> callback, TraversalDirection traversalDirection) {
        this.callback = callback;
        this.traversalDirection = traversalDirection;
    }

    public static <NodeT, EdgeT> FixedPointGraphTraversal<NodeT, EdgeT> newTraversal(EdgeCallback<NodeT, EdgeT> callback) {
        return new FixedPointGraphTraversal<NodeT, EdgeT>(callback, TraversalDirection.OUTWARDS);
    }

    public static <NodeT, EdgeT> FixedPointGraphTraversal<NodeT, EdgeT> newReverseTraversal(EdgeCallback<NodeT, EdgeT> callback) {
        return new FixedPointGraphTraversal<NodeT, EdgeT>(callback, TraversalDirection.INWARDS);
    }

    public void computeFixedPoint(DiGraph<N, E> graph) {
        LinkedHashSet nodes = new LinkedHashSet();
        for (DiGraph.DiGraphNode<N, E> node : graph.getNodes()) {
            nodes.add(node.getValue());
        }
        this.computeFixedPoint(graph, nodes);
    }

    public void computeFixedPoint(DiGraph<N, E> graph, N entry) {
        LinkedHashSet<N> entrySet = new LinkedHashSet<N>();
        entrySet.add(entry);
        this.computeFixedPoint(graph, (Set<N>)entrySet);
    }

    public void computeFixedPoint(DiGraph<N, E> graph, Set<N> entrySet) {
        int cycleCount = 0;
        long nodeCount = graph.getNodeCount();
        long maxIterations = Math.max(nodeCount * nodeCount * nodeCount, 100L);
        LinkedHashSet<DiGraph.DiGraphNode<N, GraphNode>> workSet = new LinkedHashSet<DiGraph.DiGraphNode<N, GraphNode>>();
        for (N n : entrySet) {
            workSet.add((DiGraph.DiGraphNode<N, GraphNode>)graph.getNode((Object)n));
        }
        while (!workSet.isEmpty() && (long)cycleCount < maxIterations) {
            this.visitNode((DiGraph.DiGraphNode)workSet.iterator().next(), workSet);
            ++cycleCount;
        }
        Preconditions.checkState((long)cycleCount != maxIterations, NON_HALTING_ERROR_MSG);
    }

    private void visitNode(DiGraph.DiGraphNode<N, E> node, LinkedHashSet<DiGraph.DiGraphNode<N, E>> workSet) {
        workSet.remove(node);
        switch (this.traversalDirection) {
            case OUTWARDS: {
                Object sourceValue = node.getValue();
                for (DiGraph.DiGraphEdge<N, E> edge : node.getOutEdges()) {
                    Object destValue = edge.getDestination().getValue();
                    if (!this.callback.traverseEdge(sourceValue, edge.getValue(), destValue)) continue;
                    workSet.add(edge.getDestination());
                }
                return;
            }
            case INWARDS: {
                Object revSourceValue = node.getValue();
                for (DiGraph.DiGraphEdge<N, E> edge : node.getInEdges()) {
                    Object revDestValue = edge.getSource().getValue();
                    if (!this.callback.traverseEdge(revSourceValue, edge.getValue(), revDestValue)) continue;
                    workSet.add(edge.getSource());
                }
                return;
            }
        }
        throw new AssertionError((Object)("Unrecognized direction " + (Object)((Object)this.traversalDirection)));
    }

    public static interface EdgeCallback<Node, Edge> {
        public boolean traverseEdge(Node var1, Edge var2, Node var3);
    }

    private static enum TraversalDirection {
        INWARDS,
        OUTWARDS;

    }
}

