/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

public abstract class FileAwareWarningsGuard
extends WarningsGuard {
    private final AbstractCompiler compiler;

    protected FileAwareWarningsGuard(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Nullable
    protected final Node getScriptNodeForError(JSError error) {
        for (Node n = error.getNode(); n != null; n = n.getParent()) {
            if (!n.isScript()) continue;
            return n;
        }
        if (error.getSourceName() == null) {
            return null;
        }
        Node scriptNode = this.compiler.getScriptNode(error.getSourceName());
        if (scriptNode != null) {
            if (!scriptNode.isScript()) {
                return null;
            }
            Preconditions.checkState(scriptNode.isScript(), scriptNode);
            return scriptNode;
        }
        return null;
    }
}

