/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.regex.RegExpTree;
import com.google.javascript.rhino.Node;
import java.util.function.Predicate;

public final class MarkUntranspilableFeaturesAsRemoved
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    @VisibleForTesting
    public static final DiagnosticType UNTRANSPILABLE_FEATURE_PRESENT = DiagnosticType.error("JSC_UNTRANSPILABLE", "Cannot convert {0} feature \"{1}\" to targeted output language.");
    private static final FeatureSet UNTRANSPILABLE_2018_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.REGEXP_FLAG_S, FeatureSet.Feature.REGEXP_LOOKBEHIND, FeatureSet.Feature.REGEXP_NAMED_GROUPS, FeatureSet.Feature.REGEXP_UNICODE_PROPERTY_ESCAPE);
    private static final FeatureSet UNTRANSPILABLE_2019_FEATURES = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.UNESCAPED_UNICODE_LINE_OR_PARAGRAPH_SEP);
    private static final FeatureSet ALL_UNTRANSPILABLE_FEATURES = FeatureSet.BARE_MINIMUM.union(UNTRANSPILABLE_2018_FEATURES).union(UNTRANSPILABLE_2019_FEATURES);
    private final AbstractCompiler compiler;
    private final FeatureSet untranspilableFeaturesToRemove;

    MarkUntranspilableFeaturesAsRemoved(AbstractCompiler compiler, FeatureSet outputFeatures) {
        Preconditions.checkNotNull(compiler);
        Preconditions.checkNotNull(outputFeatures);
        this.compiler = compiler;
        this.untranspilableFeaturesToRemove = ALL_UNTRANSPILABLE_FEATURES.without(outputFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.checkForUntranspilable(scriptRoot);
    }

    @Override
    public void process(Node externs, Node root) {
        this.checkForUntranspilable(root);
    }

    private void checkForUntranspilable(Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, this.untranspilableFeaturesToRemove);
    }

    private void reportUntranspilable(FeatureSet.Feature feature, Node node) {
        this.compiler.report(JSError.make(node, UNTRANSPILABLE_FEATURE_PRESENT, Config.LanguageMode.minimumRequiredFor(feature).toString(), feature.toString()));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case REGEXP: {
                RegExpTree reg;
                String pattern = n.getFirstChild().getString();
                String flags = n.hasTwoChildren() ? n.getLastChild().getString() : "";
                try {
                    reg = RegExpTree.parseRegExp(pattern, flags);
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException ex) {
                    t.report(n, CheckRegExp.MALFORMED_REGEXP, ex.getMessage());
                    break;
                }
                if (this.untranspilableFeaturesToRemove.contains(FeatureSet.Feature.REGEXP_FLAG_S)) {
                    this.checkForRegExpSFlag(n);
                }
                if (this.untranspilableFeaturesToRemove.contains(FeatureSet.Feature.REGEXP_LOOKBEHIND)) {
                    this.checkForLookbehind(n, reg);
                }
                if (this.untranspilableFeaturesToRemove.contains(FeatureSet.Feature.REGEXP_NAMED_GROUPS)) {
                    this.checkForNamedGroups(n, reg);
                }
                if (!this.untranspilableFeaturesToRemove.contains(FeatureSet.Feature.REGEXP_UNICODE_PROPERTY_ESCAPE)) break;
                this.checkForUnicodePropertyEscape(n, reg);
                break;
            }
        }
    }

    private void checkForRegExpSFlag(Node regexpNode) {
        String flags;
        Preconditions.checkArgument(regexpNode.isRegExp());
        String string = flags = regexpNode.hasTwoChildren() ? regexpNode.getLastChild().getString() : "";
        if (flags.contains("s")) {
            this.reportUntranspilable(FeatureSet.Feature.REGEXP_FLAG_S, regexpNode);
        }
    }

    private void checkForLookbehind(Node regexpNode, RegExpTree tree) {
        Preconditions.checkArgument(regexpNode != null);
        if (MarkUntranspilableFeaturesAsRemoved.anySubtreeMeetsPredicate(tree, t -> t instanceof RegExpTree.LookbehindAssertion)) {
            this.reportUntranspilable(FeatureSet.Feature.REGEXP_LOOKBEHIND, regexpNode);
        }
    }

    private void checkForNamedGroups(Node regexpNode, RegExpTree tree) {
        Preconditions.checkArgument(regexpNode != null);
        if (MarkUntranspilableFeaturesAsRemoved.anySubtreeMeetsPredicate(tree, t -> t instanceof RegExpTree.NamedCaptureGroup)) {
            this.reportUntranspilable(FeatureSet.Feature.REGEXP_NAMED_GROUPS, regexpNode);
        }
    }

    private void checkForUnicodePropertyEscape(Node regexpNode, RegExpTree tree) {
        Preconditions.checkArgument(regexpNode != null);
        if (MarkUntranspilableFeaturesAsRemoved.anySubtreeMeetsPredicate(tree, t -> t instanceof RegExpTree.UnicodePropertyEscape)) {
            this.reportUntranspilable(FeatureSet.Feature.REGEXP_UNICODE_PROPERTY_ESCAPE, regexpNode);
        }
    }

    private static boolean anySubtreeMeetsPredicate(RegExpTree tree, Predicate<RegExpTree> p) {
        if (p.test(tree)) {
            return true;
        }
        for (RegExpTree regExpTree : tree.children()) {
            if (!MarkUntranspilableFeaturesAsRemoved.anySubtreeMeetsPredicate(regExpTree, p)) continue;
            return true;
        }
        return false;
    }
}

