## Copyright 2009-2020 Intel Corporation
## SPDX-License-Identifier: Apache-2.0

SET(EMBREE_ROOT_DIR ${CMAKE_CURRENT_LIST_DIR}/.)
GET_FILENAME_COMPONENT(EMBREE_ROOT_DIR "${EMBREE_ROOT_DIR}" ABSOLUTE)

MARK_AS_ADVANCED(embree_DIR)

SET(EMBREE_VERSION 3.10.0)
SET(EMBREE_VERSION_MAJOR 3)
SET(EMBREE_VERSION_MINOR 10)
SET(EMBREE_VERSION_PATCH 0)
SET(EMBREE_VERSION_NOTE "")

SET(EMBREE_MAX_ISA AVX2)
SET(EMBREE_ISA_SSE2  ON)
SET(EMBREE_ISA_SSE42 ON)
SET(EMBREE_ISA_AVX ON) 
SET(EMBREE_ISA_AVX2  ON)
SET(EMBREE_ISA_AVX512KNL OFF)
SET(EMBREE_ISA_AVX512SKX OFF)

SET(EMBREE_BUILD_TYPE Release)
SET(EMBREE_ISPC_SUPPORT OFF)
SET(EMBREE_STATIC_LIB OFF)
SET(EMBREE_TUTORIALS OFF)

SET(EMBREE_RAY_MASK OFF)
SET(EMBREE_STAT_COUNTERS OFF)
SET(EMBREE_BACKFACE_CULLING OFF)
SET(EMBREE_FILTER_FUNCTION ON)
SET(EMBREE_IGNORE_INVALID_RAYS OFF)
SET(EMBREE_TASKING_SYSTEM TBB)
SET(EMBREE_COMPACT_POLYS OFF)

SET(EMBREE_GEOMETRY_TRIANGLE ON)
SET(EMBREE_GEOMETRY_QUAD ON)
SET(EMBREE_GEOMETRY_CURVE ON)
SET(EMBREE_GEOMETRY_SUBDIVISION ON)
SET(EMBREE_GEOMETRY_USER ON)
SET(EMBREE_GEOMETRY_POINT ON)

SET(EMBREE_RAY_PACKETS ON)
SET(EMBREE_MAX_INSTANCE_LEVEL_COUNT 1)

IF (EMBREE_STATIC_LIB)
  INCLUDE("${EMBREE_ROOT_DIR}/cmake/sys-targets.cmake")
  INCLUDE("${EMBREE_ROOT_DIR}/cmake/math-targets.cmake")
  INCLUDE("${EMBREE_ROOT_DIR}/cmake/simd-targets.cmake")
  INCLUDE("${EMBREE_ROOT_DIR}/cmake/lexers-targets.cmake")
  INCLUDE("${EMBREE_ROOT_DIR}/cmake/tasking-targets.cmake")

  add_library(TBB::tbb SHARED IMPORTED)
  set_target_properties(TBB::tbb PROPERTIES IMPORTED_LOCATION "${EMBREE_ROOT_DIR}/")
  
ENDIF()

INCLUDE("${EMBREE_ROOT_DIR}/cmake/embree-targets.cmake")


