import eigenpy
import typing

__all__ = [
    "AngleAxis",
    "ComputationInfo",
    "DecompositionOptions",
    "EigenSolver",
    "Exception",
    "LDLT",
    "LLT",
    "MINRES",
    "Quaternion",
    "SelfAdjointEigenSolver",
    "checkVersionAtLeast",
    "eigenpy_pywrap",
    "fromEulerAngles",
    "getNumpyType",
    "is_approx",
    "seed",
    "setNumpyType",
    "sharedMemory",
    "solvers",
    "switchToNumpyArray",
    "switchToNumpyMatrix",
    "toEulerAngles"
]

class AngleAxis(Boost.Python.instance):
    """
    AngleAxis representation of a rotation.
    """
    @staticmethod
    def __eq__(arg1: AngleAxis, arg2: AngleAxis) -> bool: 
        """
        __eq__( (AngleAxis)arg1, (AngleAxis)arg2) -> bool :

            C++ signature :
                bool __eq__(class Eigen::AngleAxis<double>,class Eigen::AngleAxis<double>)
        """
    @typing.overload
    def __init__(self) -> None: 
        """
        __init__( (object)self) -> None :
            Default constructor

            C++ signature :
                void __init__(struct _object * __ptr64)

            C++ signature :
                void __init__(struct _object * __ptr64,double,class Eigen::Matrix<double,3,1,0,3,1>)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Matrix<double,3,3,0,3,3>)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Quaternion<double,0>)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::AngleAxis<double>)
        """
    @typing.overload
    def __init__(self, R: numpy.ndarray) -> None: ...
    @typing.overload
    def __init__(self, angle: float, axis: numpy.ndarray) -> None: ...
    @typing.overload
    def __init__(self, copy: AngleAxis) -> None: ...
    @typing.overload
    def __init__(self, quaternion: Quaternion) -> None: ...
    @staticmethod
    @typing.overload
    def __mul__(arg1: AngleAxis, arg2: AngleAxis) -> object: 
        """
        __mul__( (AngleAxis)arg1, (numpy.ndarray)arg2) -> object :

            C++ signature :
                struct _object * __ptr64 __mul__(class Eigen::AngleAxis<double> {lvalue},class Eigen::Matrix<double,3,1,0,3,1>)

            C++ signature :
                struct _object * __ptr64 __mul__(class Eigen::AngleAxis<double> {lvalue},class Eigen::Quaternion<double,0>)

            C++ signature :
                struct _object * __ptr64 __mul__(class Eigen::AngleAxis<double> {lvalue},class Eigen::AngleAxis<double>)
        """
    @staticmethod
    @typing.overload
    def __mul__(arg1: AngleAxis, arg2: Quaternion) -> object: ...
    @staticmethod
    @typing.overload
    def __mul__(arg1: AngleAxis, arg2: numpy.ndarray) -> object: ...
    @staticmethod
    def __ne__(arg1: AngleAxis, arg2: AngleAxis) -> bool: 
        """
        __ne__( (AngleAxis)arg1, (AngleAxis)arg2) -> bool :

            C++ signature :
                bool __ne__(class Eigen::AngleAxis<double>,class Eigen::AngleAxis<double>)
        """
    @staticmethod
    def __repr__(arg1: AngleAxis) -> str: 
        """
        __repr__( (AngleAxis)arg1) -> str :

            C++ signature :
                class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > __repr__(class Eigen::AngleAxis<double>)
        """
    @staticmethod
    def __str__(arg1: AngleAxis) -> str: 
        """
        __str__( (AngleAxis)arg1) -> str :

            C++ signature :
                class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > __str__(class Eigen::AngleAxis<double>)
        """
    def fromRotationMatrix(self, rotation_matrix: numpy.ndarray) -> AngleAxis: 
        """
        fromRotationMatrix( (AngleAxis)self, (numpy.ndarray)rotation matrix) -> AngleAxis :
            Sets *this from a 3x3 rotation matrix

            C++ signature :
                class Eigen::AngleAxis<double> {lvalue} fromRotationMatrix(class Eigen::AngleAxis<double> {lvalue},class Eigen::MatrixBase<class Eigen::Matrix<double,3,3,0,3,3> >)
        """
    def inverse(self) -> AngleAxis: 
        """
        inverse( (AngleAxis)self) -> AngleAxis :
            Return the inverse rotation.

            C++ signature :
                class Eigen::AngleAxis<double> inverse(class Eigen::AngleAxis<double> {lvalue})
        """
    def isApprox(self, other_: AngleAxis, prec: float) -> bool: 
        """
        isApprox( (AngleAxis)self, (AngleAxis)other [, (float)prec]) -> bool :
            Returns true if *this is approximately equal to other, within the precision determined by prec.

            C++ signature :
                bool isApprox(class Eigen::AngleAxis<double>,class Eigen::AngleAxis<double> [,double])
        """
    def matrix(self) -> numpy.ndarray: 
        """
        matrix( (AngleAxis)self) -> numpy.ndarray :
            Returns an equivalent rotation matrix.

            C++ signature :
                class Eigen::Matrix<double,3,3,0,3,3> matrix(class Eigen::AngleAxis<double> {lvalue})
        """
    @staticmethod
    def toRotationMatrix(arg1: AngleAxis) -> numpy.ndarray: 
        """
        toRotationMatrix( (AngleAxis)arg1) -> numpy.ndarray :
            Constructs and returns an equivalent rotation matrix.

            C++ signature :
                class Eigen::Matrix<double,3,3,0,3,3> toRotationMatrix(class Eigen::AngleAxis<double> {lvalue})
        """
    @property
    def angle(self) -> None:
        """
        The rotation angle.

        :type: None
        """
    @property
    def axis(self) -> None:
        """
        The rotation axis.

        :type: None
        """
    pass

class EigenSolver(Boost.Python.instance):
    @staticmethod
    @typing.overload
    def __init__(arg1: object) -> None: 
        """
        __init__( (object)arg1) -> None :
            Default constructor

            C++ signature :
                void __init__(struct _object * __ptr64)

            C++ signature :
                void __init__(struct _object * __ptr64,__int64)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1> [,bool])
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object, matrix_: numpy.ndarray, compute_eigen_vectors: bool) -> None: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, size: int) -> None: ...
    @typing.overload
    def compute(self, matrix: numpy.ndarray) -> EigenSolver: 
        """
        compute( (EigenSolver)self, (numpy.ndarray)matrix) -> EigenSolver :
            Computes the eigendecomposition of given matrix.

            C++ signature :
                class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} compute(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)

            C++ signature :
                class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} compute(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >,bool)
        """
    @typing.overload
    def compute(self, matrix: numpy.ndarray, compute_eigen_vectors: bool) -> EigenSolver: ...
    def eigenvalues(self) -> object: 
        """
        eigenvalues( (EigenSolver)self) -> object :
            Returns the eigenvalues of given matrix.

            C++ signature :
                class Eigen::Matrix<class std::complex<double>,-1,1,0,-1,1> eigenvalues(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def eigenvectors(self) -> numpy.ndarray: 
        """
        eigenvectors( (EigenSolver)self) -> numpy.ndarray :
            Returns the eigenvectors of given matrix.

            C++ signature :
                class Eigen::Matrix<class std::complex<double>,-1,-1,0,-1,-1> eigenvectors(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def getMaxIterations(self) -> int: 
        """
        getMaxIterations( (EigenSolver)self) -> int :
            Returns the maximum number of iterations.

            C++ signature :
                __int64 getMaxIterations(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def info(self) -> ComputationInfo: 
        """
        info( (EigenSolver)self) -> ComputationInfo :
            NumericalIssue if the input contains INF or NaN values or overflow occured. Returns Success otherwise.

            C++ signature :
                enum Eigen::ComputationInfo info(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def pseudoEigenvalueMatrix(self) -> numpy.ndarray: 
        """
        pseudoEigenvalueMatrix( (EigenSolver)self) -> numpy.ndarray :
            Returns the block-diagonal matrix in the pseudo-eigendecomposition.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> pseudoEigenvalueMatrix(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def pseudoEigenvectors(self) -> object: 
        """
        pseudoEigenvectors( (EigenSolver)self) -> object :
            Returns the pseudo-eigenvectors of given matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> pseudoEigenvectors(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def setMaxIterations(self, max_iter: int) -> EigenSolver: 
        """
        setMaxIterations( (EigenSolver)self, (int)max_iter) -> EigenSolver :
            Sets the maximum number of iterations allowed.

            C++ signature :
                class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} setMaxIterations(class Eigen::EigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},__int64)
        """
    pass

class Exception(Boost.Python.instance):
    @staticmethod
    def __init__(arg1: object, arg2: str) -> None: 
        """
        __init__( (object)arg1, (str)arg2) -> None :

            C++ signature :
                void __init__(struct _object * __ptr64,class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> >)
        """
    @property
    def message(self) -> None:
        """
        :type: None
        """
    __instance_size__ = 72
    pass

class LDLT(Boost.Python.instance):
    """
    Robust Cholesky decomposition of a matrix with pivoting.

    Perform a robust Cholesky decomposition of a positive semidefinite or negative semidefinite matrix $ A $ such that $ A = P^TLDL^*P $, where P is a permutation matrix, L is lower triangular with a unit diagonal and D is a diagonal matrix.

    The decomposition uses pivoting to ensure stability, so that L will have zeros in the bottom right rank(A) - n submatrix. Avoiding the square root on D also stabilizes the computation.
    """
    @staticmethod
    @typing.overload
    def __init__(arg1: object) -> None: 
        """
        __init__( (object)arg1) -> None :
            Default constructor

            C++ signature :
                void __init__(struct _object * __ptr64)

            C++ signature :
                void __init__(struct _object * __ptr64,__int64)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object, matrix: numpy.ndarray) -> None: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, size: int) -> None: ...
    def adjoint(self) -> LDLT: 
        """
        adjoint( (LDLT)self) -> LDLT :
            Returns the adjoint, that is, a reference to the decomposition itself as if the underlying matrix is self-adjoint.

            C++ signature :
                class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue} adjoint(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def compute(self, matrix: numpy.ndarray) -> LDLT: 
        """
        compute( (LDLT)self, (numpy.ndarray)matrix) -> LDLT :
            Computes the LDLT of given matrix.

            C++ signature :
                class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue} compute(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)
        """
    def info(self) -> ComputationInfo: 
        """
        info( (LDLT)self) -> ComputationInfo :
            NumericalIssue if the input contains INF or NaN values or overflow occured. Returns Success otherwise.

            C++ signature :
                enum Eigen::ComputationInfo info(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def isNegative(self) -> bool: 
        """
        isNegative( (LDLT)self) -> bool :
            Returns true if the matrix is negative (semidefinite).

            C++ signature :
                bool isNegative(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def isPositive(self) -> bool: 
        """
        isPositive( (LDLT)self) -> bool :
            Returns true if the matrix is positive (semidefinite).

            C++ signature :
                bool isPositive(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def matrixL(self) -> numpy.ndarray: 
        """
        matrixL( (LDLT)self) -> numpy.ndarray :
            Returns the lower triangular matrix L.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> matrixL(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>)
        """
    def matrixLDLT(self) -> object: 
        """
        matrixLDLT( (LDLT)self) -> object :
            Returns the LDLT decomposition matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> matrixLDLT(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def matrixU(self) -> numpy.ndarray: 
        """
        matrixU( (LDLT)self) -> numpy.ndarray :
            Returns the upper triangular matrix U.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> matrixU(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>)
        """
    def rankUpdate(self, vector: numpy.ndarray, sigma: float) -> LDLT: 
        """
        rankUpdate( (LDLT)self, (numpy.ndarray)vector, (float)sigma) -> LDLT :

            C++ signature :
                class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue} rankUpdate(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue},class Eigen::MatrixBase<class Eigen::Matrix<double,-1,1,0,-1,1> >,double)
        """
    def rcond(self) -> float: 
        """
        rcond( (LDLT)self) -> float :
            Returns an estimate of the reciprocal condition number of the matrix.

            C++ signature :
                double rcond(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def reconstructedMatrix(self) -> numpy.ndarray: 
        """
        reconstructedMatrix( (LDLT)self) -> numpy.ndarray :
            Returns the matrix represented by the decomposition, i.e., it returns the product: L L^*. This function is provided for debug purpose.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> reconstructedMatrix(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def setZero(self) -> None: 
        """
        setZero( (LDLT)self) -> None :
            Clear any existing decomposition.

            C++ signature :
                void setZero(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    @typing.overload
    def solve(self, B: numpy.ndarray) -> numpy.ndarray: 
        """
        solve( (LDLT)self, (numpy.ndarray)b) -> numpy.ndarray :
            Returns the solution x of A x = b using the current decomposition of A.

            C++ signature :
                class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>,class Eigen::Matrix<double,-1,1,0,-1,1>)

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> solve(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    @typing.overload
    def solve(self, b: numpy.ndarray) -> numpy.ndarray: ...
    def transpositionsP(self) -> numpy.ndarray: 
        """
        transpositionsP( (LDLT)self) -> numpy.ndarray :
            Returns the permutation matrix P.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> transpositionsP(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>)
        """
    def vectorD(self) -> numpy.ndarray: 
        """
        vectorD( (LDLT)self) -> numpy.ndarray :
            Returns the coefficients of the diagonal matrix D.

            C++ signature :
                class Eigen::Matrix<double,-1,1,0,-1,1> vectorD(class Eigen::LDLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>)
        """
    pass

class LLT(Boost.Python.instance):
    """
    Standard Cholesky decomposition (LL^T) of a matrix and associated features.

    This class performs a LL^T Cholesky decomposition of a symmetric, positive definite matrix A such that A = LL^* = U^*U, where L is lower triangular.

    While the Cholesky decomposition is particularly useful to solve selfadjoint problems like D^*D x = b, for that purpose, we recommend the Cholesky decomposition without square root which is more stable and even faster. Nevertheless, this standard Cholesky decomposition remains useful in many other situations like generalised eigen problems with hermitian matrices.
    """
    @staticmethod
    @typing.overload
    def __init__(arg1: object) -> None: 
        """
        __init__( (object)arg1) -> None :
            Default constructor

            C++ signature :
                void __init__(struct _object * __ptr64)

            C++ signature :
                void __init__(struct _object * __ptr64,__int64)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object, matrix: numpy.ndarray) -> None: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, size: int) -> None: ...
    def adjoint(self) -> LLT: 
        """
        adjoint( (LLT)self) -> LLT :
            Returns the adjoint, that is, a reference to the decomposition itself as if the underlying matrix is self-adjoint.

            C++ signature :
                class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue} adjoint(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def compute(self, matrix: numpy.ndarray) -> LLT: 
        """
        compute( (LLT)self, (numpy.ndarray)matrix) -> LLT :
            Computes the LLT of given matrix.

            C++ signature :
                class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue} compute(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)
        """
    def info(self) -> ComputationInfo: 
        """
        info( (LLT)self) -> ComputationInfo :
            NumericalIssue if the input contains INF or NaN values or overflow occured. Returns Success otherwise.

            C++ signature :
                enum Eigen::ComputationInfo info(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def matrixL(self) -> numpy.ndarray: 
        """
        matrixL( (LLT)self) -> numpy.ndarray :
            Returns the lower triangular matrix L.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> matrixL(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>)
        """
    def matrixLLT(self) -> object: 
        """
        matrixLLT( (LLT)self) -> object :
            Returns the LLT decomposition matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> matrixLLT(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def matrixU(self) -> numpy.ndarray: 
        """
        matrixU( (LLT)self) -> numpy.ndarray :
            Returns the upper triangular matrix U.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> matrixU(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>)
        """
    def rankUpdate(self, vector: numpy.ndarray, sigma: float) -> LLT: 
        """
        rankUpdate( (LLT)self, (numpy.ndarray)vector, (float)sigma) -> LLT :

            C++ signature :
                class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue} rankUpdate(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>,double)
        """
    def rcond(self) -> float: 
        """
        rcond( (LLT)self) -> float :
            Returns an estimate of the reciprocal condition number of the matrix.

            C++ signature :
                double rcond(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    def reconstructedMatrix(self) -> numpy.ndarray: 
        """
        reconstructedMatrix( (LLT)self) -> numpy.ndarray :
            Returns the matrix represented by the decomposition, i.e., it returns the product: L L^*. This function is provided for debug purpose.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> reconstructedMatrix(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1> {lvalue})
        """
    @typing.overload
    def solve(self, B: numpy.ndarray) -> numpy.ndarray: 
        """
        solve( (LLT)self, (numpy.ndarray)b) -> numpy.ndarray :
            Returns the solution x of A x = b using the current decomposition of A.

            C++ signature :
                class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>,class Eigen::Matrix<double,-1,1,0,-1,1>)

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> solve(class Eigen::LLT<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1>,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    @typing.overload
    def solve(self, b: numpy.ndarray) -> numpy.ndarray: ...
    pass

class MINRES(Boost.Python.instance):
    """
    A minimal residual solver for sparse symmetric problems.
    This class allows to solve for A.x = b sparse linear problems using the MINRES algorithm of Paige and Saunders (1975). The sparse matrix A must be symmetric (possibly indefinite). The vectors x and b can be either dense or sparse.
    The maximal number of iterations and tolerance value can be controlled via the setMaxIterations() and setTolerance() methods. The defaults are the size of the problem for the maximal number of iterations and NumTraits<Scalar>::epsilon() for the tolerance.
    """
    @staticmethod
    @typing.overload
    def __init__(arg1: object) -> None: 
        """
        __init__( (object)arg1) -> None :
            Default constructor

            C++ signature :
                void __init__(struct _object * __ptr64)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object, matrix: numpy.ndarray) -> None: ...
    def analyzePattern(self, A: numpy.ndarray) -> MINRES: 
        """
        analyzePattern( (MINRES)self, (numpy.ndarray)A) -> MINRES :
            Initializes the iterative solver for the sparsity pattern of the matrix A for further solving Ax=b problems.

            C++ signature :
                class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue} analyzePattern(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)
        """
    def cols(self) -> int: 
        """
        cols( (MINRES)self) -> int :
            Returns the number of columns.

            C++ signature :
                __int64 cols(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def compute(self, A: numpy.ndarray) -> MINRES: 
        """
        compute( (MINRES)self, (numpy.ndarray)A) -> MINRES :
            Initializes the iterative solver with the matrix A for further solving Ax=b problems.

            C++ signature :
                class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue} compute(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)
        """
    def error(self) -> float: 
        """
        error( (MINRES)self) -> float :
            Returns the tolerance error reached during the last solve.
            It is a close approximation of the true relative residual error |Ax-b|/|b|.

            C++ signature :
                double error(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def factorize(self, A: numpy.ndarray) -> MINRES: 
        """
        factorize( (MINRES)self, (numpy.ndarray)A) -> MINRES :
            Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.

            C++ signature :
                class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue} factorize(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)
        """
    @staticmethod
    def info(info: MINRES) -> float: 
        """
        info( (MINRES)info) -> float :
            Returns Success if the iterations converged, and NoConvergence otherwise.

            C++ signature :
                double info(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def iterations(self) -> int: 
        """
        iterations( (MINRES)self) -> int :
            Returns the number of iterations performed during the last solve.

            C++ signature :
                __int64 iterations(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def maxIterations(self) -> int: 
        """
        maxIterations( (MINRES)self) -> int :
            Returns the max number of iterations.
            It is either the value setted by setMaxIterations or, by default, twice the number of columns of the matrix.

            C++ signature :
                __int64 maxIterations(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def preconditioner(self) -> IdentityPreconditioner: 
        """
        preconditioner( (MINRES)self) -> IdentityPreconditioner :
            Returns a read-write reference to the preconditioner for custom configuration.

            C++ signature :
                class Eigen::IdentityPreconditioner {lvalue} preconditioner(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def rows(self) -> int: 
        """
        rows( (MINRES)self) -> int :
            Returns the number of rows.

            C++ signature :
                __int64 rows(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    def setMaxIterations(self, max_iterations: int) -> MINRES: 
        """
        setMaxIterations( (MINRES)self, (int)max_iterations) -> MINRES :
            Sets the max number of iterations.
            Default is twice the number of columns of the matrix.

            C++ signature :
                class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue} setMaxIterations(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue},__int64)
        """
    def setTolerance(self, tolerance: float) -> MINRES: 
        """
        setTolerance( (MINRES)self, (float)tolerance) -> MINRES :
            Sets the tolerance threshold used by the stopping criteria.
            This value is used as an upper bound to the relative residual error: |Ax-b|/|b|.
            The default value is the machine precision given by NumTraits<Scalar>::epsilon().

            C++ signature :
                class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue} setTolerance(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue},double)
        """
    def solve(self, b: numpy.ndarray) -> numpy.ndarray: 
        """
        solve( (MINRES)self, (numpy.ndarray)b) -> numpy.ndarray :
            Returns the solution x of A x = b using the current decomposition of A where b is a right hand side matrix or vector.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> solve(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner>,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    def solveWithGuess(self, b: numpy.ndarray, x0: numpy.ndarray) -> numpy.ndarray: 
        """
        solveWithGuess( (MINRES)self, (numpy.ndarray)b, (numpy.ndarray)x0) -> numpy.ndarray :
            Returns the solution x of A x = b using the current decomposition of A and x0 as an initial solution.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> solveWithGuess(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner>,class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
        """
    def tolerance(self) -> float: 
        """
        tolerance( (MINRES)self) -> float :
            Returns the tolerance threshold used by the stopping criteria.

            C++ signature :
                double tolerance(class Eigen::MINRES<class Eigen::Matrix<double,-1,-1,0,-1,-1>,1,class Eigen::IdentityPreconditioner> {lvalue})
        """
    pass

class Quaternion(Boost.Python.instance):
    """
    Quaternion representing rotation.

    Supported operations ('q is a Quaternion, 'v' is a Vector3): 'q*q' (rotation composition), 'q*=q', 'q*v' (rotating 'v' by 'q'), 'q==q', 'q!=q', 'q[0..3]'.
    """
    @staticmethod
    def FromTwoVectors(a: numpy.ndarray, b: numpy.ndarray) -> Quaternion: 
        """
        FromTwoVectors( (numpy.ndarray)a, (numpy.ndarray)b) -> Quaternion :
            Returns the quaternion which transforms a into b through a rotation.

            C++ signature :
                class Eigen::Quaternion<double,0> * __ptr64 FromTwoVectors(class Eigen::Ref<class Eigen::Matrix<double,3,1,0,3,1>,0,class Eigen::InnerStride<1> >,class Eigen::Ref<class Eigen::Matrix<double,3,1,0,3,1>,0,class Eigen::InnerStride<1> >)
        """
    @staticmethod
    def Identity() -> Quaternion: 
        """
        Identity() -> Quaternion :
            Returns a quaternion representing an identity rotation.

            C++ signature :
                class Eigen::Quaternion<double,0> * __ptr64 Identity()
        """
    @staticmethod
    def __abs__(arg1: Quaternion) -> float: 
        """
        __abs__( (Quaternion)arg1) -> float :

            C++ signature :
                double __abs__(class Eigen::Quaternion<double,0> {lvalue})
        """
    @staticmethod
    def __eq__(arg1: Quaternion, arg2: Quaternion) -> bool: 
        """
        __eq__( (Quaternion)arg1, (Quaternion)arg2) -> bool :

            C++ signature :
                bool __eq__(class Eigen::Quaternion<double,0>,class Eigen::Quaternion<double,0>)
        """
    @staticmethod
    def __getitem__(arg1: Quaternion, arg2: int) -> float: 
        """
        __getitem__( (Quaternion)arg1, (int)arg2) -> float :

            C++ signature :
                double __getitem__(class Eigen::Quaternion<double,0>,int)
        """
    @staticmethod
    def __imul__(arg1: object, arg2: Quaternion) -> object: 
        """
        __imul__( (object)arg1, (Quaternion)arg2) -> object :

            C++ signature :
                struct _object * __ptr64 __imul__(struct boost::python::back_reference<class Eigen::Quaternion<double,0> & __ptr64>,class Eigen::Quaternion<double,0>)
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object) -> object: 
        """
        __init__( (object)arg1, (numpy.ndarray)R) -> object :
            Initialize from rotation matrix.
            	R : a rotation matrix 3x3.

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object,class Eigen::Ref<class Eigen::Matrix<double,3,3,0,3,3>,0,class Eigen::OuterStride<-1> >)

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object,class Eigen::AngleAxis<double>)

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object,class Eigen::Quaternion<double,0>)

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object,class Eigen::Ref<class Eigen::Matrix<double,3,1,0,3,1>,0,class Eigen::InnerStride<1> >,class Eigen::Ref<class Eigen::Matrix<double,3,1,0,3,1>,0,class Eigen::InnerStride<1> >)

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object,class Eigen::Ref<class Eigen::Matrix<double,4,1,0,4,1>,0,class Eigen::InnerStride<1> >)

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object)

            C++ signature :
                void * __ptr64 __init__(class boost::python::api::object,double,double,double,double)
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object, R: numpy.ndarray) -> object: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, aa: AngleAxis) -> object: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, quat: Quaternion) -> object: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, u: numpy.ndarray, v: numpy.ndarray) -> object: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, vec4: numpy.ndarray) -> object: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, w: float, x: float, y: float, z: float) -> object: ...
    @staticmethod
    def __len__() -> int: 
        """
        __len__() -> int :

            C++ signature :
                int __len__()
        """
    @staticmethod
    @typing.overload
    def __mul__(arg1: Quaternion, arg2: Quaternion) -> object: 
        """
        __mul__( (Quaternion)arg1, (Quaternion)arg2) -> object :

            C++ signature :
                struct _object * __ptr64 __mul__(class Eigen::Quaternion<double,0> {lvalue},class Eigen::Quaternion<double,0>)

            C++ signature :
                struct _object * __ptr64 __mul__(class Eigen::Quaternion<double,0> {lvalue},class Eigen::Matrix<double,3,1,0,3,1>)
        """
    @staticmethod
    @typing.overload
    def __mul__(arg1: Quaternion, arg2: numpy.ndarray) -> object: ...
    @staticmethod
    def __ne__(arg1: Quaternion, arg2: Quaternion) -> bool: 
        """
        __ne__( (Quaternion)arg1, (Quaternion)arg2) -> bool :

            C++ signature :
                bool __ne__(class Eigen::Quaternion<double,0>,class Eigen::Quaternion<double,0>)
        """
    @staticmethod
    def __repr__(arg1: Quaternion) -> str: 
        """
        __repr__( (Quaternion)arg1) -> str :

            C++ signature :
                class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > __repr__(class Eigen::Quaternion<double,0>)
        """
    @staticmethod
    def __setitem__(arg1: Quaternion, arg2: int, arg3: float) -> None: 
        """
        __setitem__( (Quaternion)arg1, (int)arg2, (float)arg3) -> None :

            C++ signature :
                void __setitem__(class Eigen::Quaternion<double,0> {lvalue},int,double)
        """
    @staticmethod
    def __str__(arg1: Quaternion) -> str: 
        """
        __str__( (Quaternion)arg1) -> str :

            C++ signature :
                class std::basic_string<char,struct std::char_traits<char>,class std::allocator<char> > __str__(class Eigen::Quaternion<double,0>)
        """
    def _transformVector(self, vector: numpy.ndarray) -> numpy.ndarray: 
        """
        _transformVector( (Quaternion)self, (numpy.ndarray)vector) -> numpy.ndarray :
            Rotation of a vector by a quaternion.

            C++ signature :
                class Eigen::Matrix<double,3,1,0,3,1> _transformVector(class Eigen::Quaternion<double,0> {lvalue},class Eigen::Matrix<double,3,1,0,3,1>)
        """
    @staticmethod
    def angularDistance(arg1: Quaternion, arg2: Quaternion) -> float: 
        """
        angularDistance( (Quaternion)arg1, (Quaternion)arg2) -> float :
            Returns the angle (in radian) between two rotations.

            C++ signature :
                double angularDistance(class Eigen::Quaternion<double,0> {lvalue},class Eigen::QuaternionBase<class Eigen::Quaternion<double,0> >)
        """
    @typing.overload
    def assign(self, aa: AngleAxis) -> Quaternion: 
        """
        assign( (Quaternion)self, (Quaternion)quat) -> Quaternion :
            Set *this from an quaternion quat and returns a reference to *this.

            C++ signature :
                class Eigen::Quaternion<double,0> {lvalue} assign(class Eigen::Quaternion<double,0> {lvalue},class Eigen::Quaternion<double,0>)

            C++ signature :
                class Eigen::Quaternion<double,0> {lvalue} assign(class Eigen::Quaternion<double,0> {lvalue},class Eigen::AngleAxis<double>)
        """
    @typing.overload
    def assign(self, quat: Quaternion) -> Quaternion: ...
    def coeffs(self) -> object: 
        """
        coeffs( (Quaternion)self) -> object :
            Returns a vector of the coefficients (x,y,z,w)

            C++ signature :
                class Eigen::Matrix<double,4,1,0,4,1> coeffs(class Eigen::Quaternion<double,0> {lvalue})
        """
    def conjugate(self) -> Quaternion: 
        """
        conjugate( (Quaternion)self) -> Quaternion :
            Returns the conjugated quaternion.
            The conjugate of a quaternion represents the opposite rotation.

            C++ signature :
                class Eigen::Quaternion<double,0> conjugate(class Eigen::Quaternion<double,0> {lvalue})
        """
    def dot(self, other: Quaternion) -> float: 
        """
        dot( (Quaternion)self, (Quaternion)other) -> float :
            Returns the dot product of *this with an other Quaternion.
            Geometrically speaking, the dot product of two unit quaternions corresponds to the cosine of half the angle between the two rotations.

            C++ signature :
                double dot(class Eigen::Quaternion<double,0> {lvalue},class Eigen::QuaternionBase<class Eigen::Quaternion<double,0> >)
        """
    def inverse(self) -> Quaternion: 
        """
        inverse( (Quaternion)self) -> Quaternion :
            Returns the quaternion describing the inverse rotation.

            C++ signature :
                class Eigen::Quaternion<double,0> inverse(class Eigen::Quaternion<double,0> {lvalue})
        """
    def isApprox(self, other_: Quaternion, prec: float) -> bool: 
        """
        isApprox( (Quaternion)self, (Quaternion)other [, (float)prec]) -> bool :
            Returns true if *this is approximately equal to other, within the precision determined by prec.

            C++ signature :
                bool isApprox(class Eigen::Quaternion<double,0>,class Eigen::Quaternion<double,0> [,double])
        """
    def matrix(self) -> numpy.ndarray: 
        """
        matrix( (Quaternion)self) -> numpy.ndarray :
            Returns an equivalent 3x3 rotation matrix. Similar to toRotationMatrix.

            C++ signature :
                class Eigen::Matrix<double,3,3,0,3,3> matrix(class Eigen::Quaternion<double,0> {lvalue})
        """
    def norm(self) -> float: 
        """
        norm( (Quaternion)self) -> float :
            Returns the norm of the quaternion's coefficients.

            C++ signature :
                double norm(class Eigen::Quaternion<double,0> {lvalue})
        """
    def normalize(self) -> Quaternion: 
        """
        normalize( (Quaternion)self) -> Quaternion :
            Normalizes the quaternion *this.

            C++ signature :
                class Eigen::Quaternion<double,0> {lvalue} normalize(class Eigen::Quaternion<double,0> {lvalue})
        """
    def normalized(self) -> Quaternion: 
        """
        normalized( (Quaternion)self) -> Quaternion :
            Returns a normalized copy of *this.

            C++ signature :
                class Eigen::Quaternion<double,0> * __ptr64 normalized(class Eigen::Quaternion<double,0>)
        """
    def setFromTwoVectors(self, a: numpy.ndarray, b: numpy.ndarray) -> Quaternion: 
        """
        setFromTwoVectors( (Quaternion)self, (numpy.ndarray)a, (numpy.ndarray)b) -> Quaternion :
            Set *this to be the quaternion which transforms a into b through a rotation.

            C++ signature :
                class Eigen::Quaternion<double,0> {lvalue} setFromTwoVectors(class Eigen::Quaternion<double,0> {lvalue},class Eigen::Matrix<double,3,1,0,3,1>,class Eigen::Matrix<double,3,1,0,3,1>)
        """
    def setIdentity(self) -> Quaternion: 
        """
        setIdentity( (Quaternion)self) -> Quaternion :
            Set *this to the identity rotation.

            C++ signature :
                class Eigen::Quaternion<double,0> {lvalue} setIdentity(class Eigen::Quaternion<double,0> {lvalue})
        """
    def slerp(self, t: float, other: Quaternion) -> Quaternion: 
        """
        slerp( (Quaternion)self, (float)t, (Quaternion)other) -> Quaternion :
            Returns the spherical linear interpolation between the two quaternions *this and other at the parameter t in [0;1].

            C++ signature :
                class Eigen::Quaternion<double,0> slerp(class Eigen::Quaternion<double,0>,double,class Eigen::Quaternion<double,0>)
        """
    def squaredNorm(self) -> float: 
        """
        squaredNorm( (Quaternion)self) -> float :
            Returns the squared norm of the quaternion's coefficients.

            C++ signature :
                double squaredNorm(class Eigen::Quaternion<double,0> {lvalue})
        """
    @staticmethod
    def toRotationMatrix(arg1: Quaternion) -> numpy.ndarray: 
        """
        toRotationMatrix( (Quaternion)arg1) -> numpy.ndarray :
            Returns an equivalent rotation matrix.

            C++ signature :
                class Eigen::Matrix<double,3,3,0,3,3> toRotationMatrix(class Eigen::Quaternion<double,0> {lvalue})
        """
    def vec(self) -> numpy.ndarray: 
        """
        vec( (Quaternion)self) -> numpy.ndarray :
            Returns a vector expression of the imaginary part (x,y,z).

            C++ signature :
                class Eigen::Matrix<double,3,1,0,3,1> vec(class Eigen::Quaternion<double,0>)
        """
    @property
    def w(self) -> None:
        """
        The w coefficient.

        :type: None
        """
    @property
    def x(self) -> None:
        """
        The x coefficient.

        :type: None
        """
    @property
    def y(self) -> None:
        """
        The y coefficient.

        :type: None
        """
    @property
    def z(self) -> None:
        """
        The z coefficient.

        :type: None
        """
    pass

class SelfAdjointEigenSolver(Boost.Python.instance):
    @staticmethod
    @typing.overload
    def __init__(arg1: object) -> None: 
        """
        __init__( (object)arg1) -> None :
            Default constructor

            C++ signature :
                void __init__(struct _object * __ptr64)

            C++ signature :
                void __init__(struct _object * __ptr64,__int64)

            C++ signature :
                void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1> [,int])
        """
    @staticmethod
    @typing.overload
    def __init__(arg1: object, matrix_: numpy.ndarray, options: int) -> None: ...
    @staticmethod
    @typing.overload
    def __init__(arg1: object, size: int) -> None: ...
    @typing.overload
    def compute(self, matrix: numpy.ndarray) -> SelfAdjointEigenSolver: 
        """
        compute( (SelfAdjointEigenSolver)self, (numpy.ndarray)matrix) -> SelfAdjointEigenSolver :
            Computes the eigendecomposition of given matrix.

            C++ signature :
                class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} compute(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)

            C++ signature :
                class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} compute(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},struct Eigen::EigenBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >,int)
        """
    @typing.overload
    def compute(self, matrix: numpy.ndarray, options: int) -> SelfAdjointEigenSolver: ...
    @typing.overload
    def computeDirect(self, matrix: numpy.ndarray) -> SelfAdjointEigenSolver: 
        """
        computeDirect( (SelfAdjointEigenSolver)self, (numpy.ndarray)matrix) -> SelfAdjointEigenSolver :
            Computes eigendecomposition of given matrix using a closed-form algorithm.

            C++ signature :
                class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} computeDirect(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)

            C++ signature :
                class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue} computeDirect(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>,int)
        """
    @typing.overload
    def computeDirect(self, matrix: numpy.ndarray, options: int) -> SelfAdjointEigenSolver: ...
    def eigenvalues(self) -> object: 
        """
        eigenvalues( (SelfAdjointEigenSolver)self) -> object :
            Returns the eigenvalues of given matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,1,0,-1,1> eigenvalues(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def eigenvectors(self) -> object: 
        """
        eigenvectors( (SelfAdjointEigenSolver)self) -> object :
            Returns the eigenvectors of given matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> eigenvectors(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def info(self) -> ComputationInfo: 
        """
        info( (SelfAdjointEigenSolver)self) -> ComputationInfo :
            NumericalIssue if the input contains INF or NaN values or overflow occured. Returns Success otherwise.

            C++ signature :
                enum Eigen::ComputationInfo info(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def operatorInverseSqrt(self) -> numpy.ndarray: 
        """
        operatorInverseSqrt( (SelfAdjointEigenSolver)self) -> numpy.ndarray :
            Computes the inverse square root of the matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> operatorInverseSqrt(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    def operatorSqrt(self) -> numpy.ndarray: 
        """
        operatorSqrt( (SelfAdjointEigenSolver)self) -> numpy.ndarray :
            Computes the inverse square root of the matrix.

            C++ signature :
                class Eigen::Matrix<double,-1,-1,0,-1,-1> operatorSqrt(class Eigen::SelfAdjointEigenSolver<class Eigen::Matrix<double,-1,-1,0,-1,-1> > {lvalue})
        """
    pass

class solvers(Boost.Python.instance):
    class ComputationInfo(Boost.Python.enum, int):
        InvalidInput = eigenpy.eigenpy_pywrap.ComputationInfo.InvalidInput
        NoConvergence = eigenpy.eigenpy_pywrap.ComputationInfo.NoConvergence
        NumericalIssue = eigenpy.eigenpy_pywrap.ComputationInfo.NumericalIssue
        Success = eigenpy.eigenpy_pywrap.ComputationInfo.Success
        __slots__ = ()
        names = {'Success': eigenpy.eigenpy_pywrap.ComputationInfo.Success, 'NumericalIssue': eigenpy.eigenpy_pywrap.ComputationInfo.NumericalIssue, 'NoConvergence': eigenpy.eigenpy_pywrap.ComputationInfo.NoConvergence, 'InvalidInput': eigenpy.eigenpy_pywrap.ComputationInfo.InvalidInput}
        values = {0: eigenpy.eigenpy_pywrap.ComputationInfo.Success, 1: eigenpy.eigenpy_pywrap.ComputationInfo.NumericalIssue, 2: eigenpy.eigenpy_pywrap.ComputationInfo.NoConvergence, 3: eigenpy.eigenpy_pywrap.ComputationInfo.InvalidInput}
        pass
    class ConjugateGradient(Boost.Python.instance):
        @staticmethod
        @typing.overload
        def __init__(arg1: object) -> None: 
            """
            __init__( (object)arg1) -> None :
                Default constructor

                C++ signature :
                    void __init__(struct _object * __ptr64)

                C++ signature :
                    void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        @typing.overload
        def __init__(arg1: object, A: numpy.ndarray) -> None: ...
        @staticmethod
        def analyzePattern(arg1: ConjugateGradient, A: numpy.ndarray) -> ConjugateGradient: 
            """
            analyzePattern( (ConjugateGradient)arg1, (numpy.ndarray)A) -> ConjugateGradient :
                Initializes the iterative solver for the sparsity pattern of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls analyzePattern on the preconditioner.
                In the future we might, for instance, implement column reordering for faster matrix vector products.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue} analyzePattern(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def compute(arg1: ConjugateGradient, A: numpy.ndarray) -> ConjugateGradient: 
            """
            compute( (ConjugateGradient)arg1, (numpy.ndarray)A) -> ConjugateGradient :
                Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls factorize on the preconditioner.
                In the future we might, for instance, implement column reordering for faster matrix vector products.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue} compute(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def error(arg1: ConjugateGradient) -> float: 
            """
            error( (ConjugateGradient)arg1) -> float :
                Returns the tolerance error reached during the last solve.
                It is a close approximation of the true relative residual error |Ax-b|/|b|.

                C++ signature :
                    double error(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def factorize(arg1: ConjugateGradient, A: numpy.ndarray) -> ConjugateGradient: 
            """
            factorize( (ConjugateGradient)arg1, (numpy.ndarray)A) -> ConjugateGradient :
                Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls factorize on the preconditioner.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue} factorize(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def info(arg1: ConjugateGradient) -> ComputationInfo: 
            """
            info( (ConjugateGradient)arg1) -> ComputationInfo :
                Returns success if the iterations converged, and NoConvergence otherwise.

                C++ signature :
                    enum Eigen::ComputationInfo info(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def iterations(arg1: ConjugateGradient) -> int: 
            """
            iterations( (ConjugateGradient)arg1) -> int :
                Returns the number of iterations performed during the last solve.

                C++ signature :
                    __int64 iterations(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def maxIterations(arg1: ConjugateGradient) -> int: 
            """
            maxIterations( (ConjugateGradient)arg1) -> int :
                Returns the max number of iterations.
                It is either the value setted by setMaxIterations or, by default, twice the number of columns of the matrix.

                C++ signature :
                    __int64 maxIterations(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def preconditioner(arg1: ConjugateGradient) -> DiagonalPreconditioner: 
            """
            preconditioner( (ConjugateGradient)arg1) -> DiagonalPreconditioner :
                Returns a read-write reference to the preconditioner for custom configuration.

                C++ signature :
                    class Eigen::DiagonalPreconditioner<double> {lvalue} preconditioner(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def setMaxIterations(arg1: ConjugateGradient, arg2: int) -> ConjugateGradient: 
            """
            setMaxIterations( (ConjugateGradient)arg1, (int)arg2) -> ConjugateGradient :
                Sets the max number of iterations.
                Default is twice the number of columns of the matrix.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue} setMaxIterations(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},__int64)
            """
        @staticmethod
        def setTolerance(arg1: ConjugateGradient, arg2: float) -> ConjugateGradient: 
            """
            setTolerance( (ConjugateGradient)arg1, (float)arg2) -> ConjugateGradient :
                Sets the tolerance threshold used by the stopping criteria.
                This value is used as an upper bound to the relative residual error: |Ax-b|/|b|. The default value is the machine precision.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue} setTolerance(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},double)
            """
        @staticmethod
        def solve(arg1: ConjugateGradient, b: numpy.ndarray) -> numpy.ndarray: 
            """
            solve( (ConjugateGradient)arg1, (numpy.ndarray)b) -> numpy.ndarray :
                Returns the solution x of Ax = b using the current decomposition of A.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        @staticmethod
        def solveWithGuess(arg1: ConjugateGradient, b: numpy.ndarray, x0: numpy.ndarray) -> numpy.ndarray: 
            """
            solveWithGuess( (ConjugateGradient)arg1, (numpy.ndarray)b, (numpy.ndarray)x0) -> numpy.ndarray :
                Returns the solution x of Ax = b using the current decomposition of A and x0 as an initial solution.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solveWithGuess(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>,class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        @staticmethod
        def tolerance(arg1: ConjugateGradient) -> float: 
            """
            tolerance( (ConjugateGradient)arg1) -> float :
                Returns he tolerance threshold used by the stopping criteria.

                C++ signature :
                    double tolerance(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::DiagonalPreconditioner<double> > {lvalue})
            """
        pass
    class DiagonalPreconditioner(Boost.Python.instance):
        """
        A preconditioner based on the digonal entrie.
        This class allows to approximately solve for A.x = b problems assuming A is a diagonal matrix.
        """
        pass
    class IdentityConjugateGradient(Boost.Python.instance):
        @staticmethod
        @typing.overload
        def __init__(arg1: object) -> None: 
            """
            __init__( (object)arg1) -> None :
                Default constructor

                C++ signature :
                    void __init__(struct _object * __ptr64)

                C++ signature :
                    void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        @typing.overload
        def __init__(arg1: object, A: numpy.ndarray) -> None: ...
        @staticmethod
        def analyzePattern(arg1: IdentityConjugateGradient, A: numpy.ndarray) -> IdentityConjugateGradient: 
            """
            analyzePattern( (IdentityConjugateGradient)arg1, (numpy.ndarray)A) -> IdentityConjugateGradient :
                Initializes the iterative solver for the sparsity pattern of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls analyzePattern on the preconditioner.
                In the future we might, for instance, implement column reordering for faster matrix vector products.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue} analyzePattern(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def compute(arg1: IdentityConjugateGradient, A: numpy.ndarray) -> IdentityConjugateGradient: 
            """
            compute( (IdentityConjugateGradient)arg1, (numpy.ndarray)A) -> IdentityConjugateGradient :
                Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls factorize on the preconditioner.
                In the future we might, for instance, implement column reordering for faster matrix vector products.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue} compute(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def error(arg1: IdentityConjugateGradient) -> float: 
            """
            error( (IdentityConjugateGradient)arg1) -> float :
                Returns the tolerance error reached during the last solve.
                It is a close approximation of the true relative residual error |Ax-b|/|b|.

                C++ signature :
                    double error(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue})
            """
        @staticmethod
        def factorize(arg1: IdentityConjugateGradient, A: numpy.ndarray) -> IdentityConjugateGradient: 
            """
            factorize( (IdentityConjugateGradient)arg1, (numpy.ndarray)A) -> IdentityConjugateGradient :
                Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls factorize on the preconditioner.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue} factorize(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def info(arg1: IdentityConjugateGradient) -> ComputationInfo: 
            """
            info( (IdentityConjugateGradient)arg1) -> ComputationInfo :
                Returns success if the iterations converged, and NoConvergence otherwise.

                C++ signature :
                    enum Eigen::ComputationInfo info(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue})
            """
        @staticmethod
        def iterations(arg1: IdentityConjugateGradient) -> int: 
            """
            iterations( (IdentityConjugateGradient)arg1) -> int :
                Returns the number of iterations performed during the last solve.

                C++ signature :
                    __int64 iterations(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue})
            """
        @staticmethod
        def maxIterations(arg1: IdentityConjugateGradient) -> int: 
            """
            maxIterations( (IdentityConjugateGradient)arg1) -> int :
                Returns the max number of iterations.
                It is either the value setted by setMaxIterations or, by default, twice the number of columns of the matrix.

                C++ signature :
                    __int64 maxIterations(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue})
            """
        @staticmethod
        def preconditioner(arg1: IdentityConjugateGradient) -> IdentityPreconditioner: 
            """
            preconditioner( (IdentityConjugateGradient)arg1) -> IdentityPreconditioner :
                Returns a read-write reference to the preconditioner for custom configuration.

                C++ signature :
                    class Eigen::IdentityPreconditioner {lvalue} preconditioner(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue})
            """
        @staticmethod
        def setMaxIterations(arg1: IdentityConjugateGradient, arg2: int) -> IdentityConjugateGradient: 
            """
            setMaxIterations( (IdentityConjugateGradient)arg1, (int)arg2) -> IdentityConjugateGradient :
                Sets the max number of iterations.
                Default is twice the number of columns of the matrix.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue} setMaxIterations(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},__int64)
            """
        @staticmethod
        def setTolerance(arg1: IdentityConjugateGradient, arg2: float) -> IdentityConjugateGradient: 
            """
            setTolerance( (IdentityConjugateGradient)arg1, (float)arg2) -> IdentityConjugateGradient :
                Sets the tolerance threshold used by the stopping criteria.
                This value is used as an upper bound to the relative residual error: |Ax-b|/|b|. The default value is the machine precision.

                C++ signature :
                    class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue} setTolerance(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},double)
            """
        @staticmethod
        def solve(arg1: IdentityConjugateGradient, b: numpy.ndarray) -> numpy.ndarray: 
            """
            solve( (IdentityConjugateGradient)arg1, (numpy.ndarray)b) -> numpy.ndarray :
                Returns the solution x of Ax = b using the current decomposition of A.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        @staticmethod
        def solveWithGuess(arg1: IdentityConjugateGradient, b: numpy.ndarray, x0: numpy.ndarray) -> numpy.ndarray: 
            """
            solveWithGuess( (IdentityConjugateGradient)arg1, (numpy.ndarray)b, (numpy.ndarray)x0) -> numpy.ndarray :
                Returns the solution x of Ax = b using the current decomposition of A and x0 as an initial solution.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solveWithGuess(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>,class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        @staticmethod
        def tolerance(arg1: IdentityConjugateGradient) -> float: 
            """
            tolerance( (IdentityConjugateGradient)arg1) -> float :
                Returns he tolerance threshold used by the stopping criteria.

                C++ signature :
                    double tolerance(class Eigen::ConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,3,class Eigen::IdentityPreconditioner> {lvalue})
            """
        pass
    class IdentityPreconditioner(Boost.Python.instance):
        @staticmethod
        @typing.overload
        def __init__(arg1: object) -> None: 
            """
            __init__( (object)arg1) -> None :
                Default constructor

                C++ signature :
                    void __init__(struct _object * __ptr64)

                C++ signature :
                    void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        @typing.overload
        def __init__(arg1: object, A: numpy.ndarray) -> None: ...
        @staticmethod
        def compute(arg1: IdentityPreconditioner, mat: numpy.ndarray) -> IdentityPreconditioner: 
            """
            compute( (IdentityPreconditioner)arg1, (numpy.ndarray)mat) -> IdentityPreconditioner :
                Initialize the preconditioner from the matrix value.

                C++ signature :
                    class Eigen::IdentityPreconditioner {lvalue} compute(class Eigen::IdentityPreconditioner {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def factorize(arg1: IdentityPreconditioner, mat: numpy.ndarray) -> IdentityPreconditioner: 
            """
            factorize( (IdentityPreconditioner)arg1, (numpy.ndarray)mat) -> IdentityPreconditioner :
                Initialize the preconditioner from the matrix value, i.e factorize the mat given as input to approximate its inverse.

                C++ signature :
                    class Eigen::IdentityPreconditioner {lvalue} factorize(class Eigen::IdentityPreconditioner {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def info(arg1: IdentityPreconditioner) -> ComputationInfo: 
            """
            info( (IdentityPreconditioner)arg1) -> ComputationInfo :
                Returns success if the Preconditioner has been well initialized.

                C++ signature :
                    enum Eigen::ComputationInfo info(class Eigen::IdentityPreconditioner {lvalue})
            """
        @staticmethod
        def solve(arg1: IdentityPreconditioner, b: numpy.ndarray) -> numpy.ndarray: 
            """
            solve( (IdentityPreconditioner)arg1, (numpy.ndarray)b) -> numpy.ndarray :
                Returns the solution A * z = b where the preconditioner is an estimate of A^-1.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::IdentityPreconditioner {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        pass
    class LeastSquareDiagonalPreconditioner(Boost.Python.instance):
        """
        Jacobi preconditioner for LeastSquaresConjugateGradient.
        his class allows to approximately solve for A' A x  = A' b problems assuming A' A is a diagonal matrix.
        """
        @staticmethod
        @typing.overload
        def __init__(arg1: object) -> None: 
            """
            __init__( (object)arg1) -> None :
                Default constructor

                C++ signature :
                    void __init__(struct _object * __ptr64)

                C++ signature :
                    void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        @typing.overload
        def __init__(arg1: object, A: numpy.ndarray) -> None: ...
        @staticmethod
        def compute(arg1: LeastSquareDiagonalPreconditioner, mat: numpy.ndarray) -> DiagonalPreconditioner: 
            """
            compute( (LeastSquareDiagonalPreconditioner)arg1, (numpy.ndarray)mat) -> DiagonalPreconditioner :
                Initialize the preconditioner from the matrix value.

                C++ signature :
                    class Eigen::DiagonalPreconditioner<double> {lvalue} compute(class Eigen::LeastSquareDiagonalPreconditioner<double> {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def factorize(arg1: LeastSquareDiagonalPreconditioner, mat: numpy.ndarray) -> DiagonalPreconditioner: 
            """
            factorize( (LeastSquareDiagonalPreconditioner)arg1, (numpy.ndarray)mat) -> DiagonalPreconditioner :
                Initialize the preconditioner from the matrix value, i.e factorize the mat given as input to approximate its inverse.

                C++ signature :
                    class Eigen::DiagonalPreconditioner<double> {lvalue} factorize(class Eigen::LeastSquareDiagonalPreconditioner<double> {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def info(arg1: LeastSquareDiagonalPreconditioner) -> ComputationInfo: 
            """
            info( (LeastSquareDiagonalPreconditioner)arg1) -> ComputationInfo :
                Returns success if the Preconditioner has been well initialized.

                C++ signature :
                    enum Eigen::ComputationInfo info(class Eigen::LeastSquareDiagonalPreconditioner<double> {lvalue})
            """
        @staticmethod
        def solve(arg1: DiagonalPreconditioner, b: numpy.ndarray) -> numpy.ndarray: 
            """
            solve( (DiagonalPreconditioner)arg1, (numpy.ndarray)b) -> numpy.ndarray :
                Returns the solution A * z = b where the preconditioner is an estimate of A^-1.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::DiagonalPreconditioner<double> {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        pass
    class LeastSquaresConjugateGradient(Boost.Python.instance):
        @staticmethod
        @typing.overload
        def __init__(arg1: object) -> None: 
            """
            __init__( (object)arg1) -> None :
                Default constructor

                C++ signature :
                    void __init__(struct _object * __ptr64)

                C++ signature :
                    void __init__(struct _object * __ptr64,class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        @typing.overload
        def __init__(arg1: object, A: numpy.ndarray) -> None: ...
        @staticmethod
        def analyzePattern(arg1: LeastSquaresConjugateGradient, A: numpy.ndarray) -> LeastSquaresConjugateGradient: 
            """
            analyzePattern( (LeastSquaresConjugateGradient)arg1, (numpy.ndarray)A) -> LeastSquaresConjugateGradient :
                Initializes the iterative solver for the sparsity pattern of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls analyzePattern on the preconditioner.
                In the future we might, for instance, implement column reordering for faster matrix vector products.

                C++ signature :
                    class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue} analyzePattern(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def compute(arg1: LeastSquaresConjugateGradient, A: numpy.ndarray) -> LeastSquaresConjugateGradient: 
            """
            compute( (LeastSquaresConjugateGradient)arg1, (numpy.ndarray)A) -> LeastSquaresConjugateGradient :
                Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls factorize on the preconditioner.
                In the future we might, for instance, implement column reordering for faster matrix vector products.

                C++ signature :
                    class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue} compute(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def error(arg1: LeastSquaresConjugateGradient) -> float: 
            """
            error( (LeastSquaresConjugateGradient)arg1) -> float :
                Returns the tolerance error reached during the last solve.
                It is a close approximation of the true relative residual error |Ax-b|/|b|.

                C++ signature :
                    double error(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def factorize(arg1: LeastSquaresConjugateGradient, A: numpy.ndarray) -> LeastSquaresConjugateGradient: 
            """
            factorize( (LeastSquaresConjugateGradient)arg1, (numpy.ndarray)A) -> LeastSquaresConjugateGradient :
                Initializes the iterative solver with the numerical values of the matrix A for further solving Ax=b problems.
                Currently, this function mostly calls factorize on the preconditioner.

                C++ signature :
                    class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue} factorize(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,-1,0,-1,-1>)
            """
        @staticmethod
        def info(arg1: LeastSquaresConjugateGradient) -> ComputationInfo: 
            """
            info( (LeastSquaresConjugateGradient)arg1) -> ComputationInfo :
                Returns success if the iterations converged, and NoConvergence otherwise.

                C++ signature :
                    enum Eigen::ComputationInfo info(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def iterations(arg1: LeastSquaresConjugateGradient) -> int: 
            """
            iterations( (LeastSquaresConjugateGradient)arg1) -> int :
                Returns the number of iterations performed during the last solve.

                C++ signature :
                    __int64 iterations(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def maxIterations(arg1: LeastSquaresConjugateGradient) -> int: 
            """
            maxIterations( (LeastSquaresConjugateGradient)arg1) -> int :
                Returns the max number of iterations.
                It is either the value setted by setMaxIterations or, by default, twice the number of columns of the matrix.

                C++ signature :
                    __int64 maxIterations(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def preconditioner(arg1: LeastSquaresConjugateGradient) -> LeastSquareDiagonalPreconditioner: 
            """
            preconditioner( (LeastSquaresConjugateGradient)arg1) -> LeastSquareDiagonalPreconditioner :
                Returns a read-write reference to the preconditioner for custom configuration.

                C++ signature :
                    class Eigen::LeastSquareDiagonalPreconditioner<double> {lvalue} preconditioner(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue})
            """
        @staticmethod
        def setMaxIterations(arg1: LeastSquaresConjugateGradient, arg2: int) -> LeastSquaresConjugateGradient: 
            """
            setMaxIterations( (LeastSquaresConjugateGradient)arg1, (int)arg2) -> LeastSquaresConjugateGradient :
                Sets the max number of iterations.
                Default is twice the number of columns of the matrix.

                C++ signature :
                    class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue} setMaxIterations(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},__int64)
            """
        @staticmethod
        def setTolerance(arg1: LeastSquaresConjugateGradient, arg2: float) -> LeastSquaresConjugateGradient: 
            """
            setTolerance( (LeastSquaresConjugateGradient)arg1, (float)arg2) -> LeastSquaresConjugateGradient :
                Sets the tolerance threshold used by the stopping criteria.
                This value is used as an upper bound to the relative residual error: |Ax-b|/|b|. The default value is the machine precision.

                C++ signature :
                    class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue} setTolerance(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},double)
            """
        @staticmethod
        def solve(arg1: LeastSquaresConjugateGradient, b: numpy.ndarray) -> numpy.ndarray: 
            """
            solve( (LeastSquaresConjugateGradient)arg1, (numpy.ndarray)b) -> numpy.ndarray :
                Returns the solution x of Ax = b using the current decomposition of A.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solve(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        @staticmethod
        def solveWithGuess(arg1: LeastSquaresConjugateGradient, b: numpy.ndarray, x0: numpy.ndarray) -> numpy.ndarray: 
            """
            solveWithGuess( (LeastSquaresConjugateGradient)arg1, (numpy.ndarray)b, (numpy.ndarray)x0) -> numpy.ndarray :
                Returns the solution x of Ax = b using the current decomposition of A and x0 as an initial solution.

                C++ signature :
                    class Eigen::Matrix<double,-1,1,0,-1,1> solveWithGuess(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue},class Eigen::Matrix<double,-1,1,0,-1,1>,class Eigen::Matrix<double,-1,1,0,-1,1>)
            """
        @staticmethod
        def tolerance(arg1: LeastSquaresConjugateGradient) -> float: 
            """
            tolerance( (LeastSquaresConjugateGradient)arg1) -> float :
                Returns he tolerance threshold used by the stopping criteria.

                C++ signature :
                    double tolerance(class Eigen::LeastSquaresConjugateGradient<class Eigen::Matrix<double,-1,-1,0,-1,-1>,class Eigen::LeastSquareDiagonalPreconditioner<double> > {lvalue})
            """
        pass
    @staticmethod
    def __init__(arg1: object) -> None: 
        """
        __init__( (object)arg1) -> None :

            C++ signature :
                void __init__(struct _object * __ptr64)
        """
    __instance_size__ = 24
    pass

def checkVersionAtLeast(major_version: int, minor_version: int, patch_version: int) -> bool:
    """
    checkVersionAtLeast( (int)major_version, (int)minor_version, (int)patch_version) -> bool :
        Checks if the current version of EigenPy is at least the version provided by the input arguments.

        C++ signature :
            bool checkVersionAtLeast(unsigned int,unsigned int,unsigned int)
    """

def fromEulerAngles(euler_angles: numpy.ndarray, a0: int, a1: int, a2: int) -> numpy.ndarray:
    """
    fromEulerAngles( (numpy.ndarray)euler_angles, (int)a0, (int)a1, (int)a2) -> numpy.ndarray :
        It returns the rotation matrix associated to the Euler angles using the convention defined by the triplet (a0,a1,a2).

        C++ signature :
            class Eigen::Matrix<double,3,3,0,3,3> fromEulerAngles(class Eigen::Matrix<double,3,1,0,3,1>,__int64,__int64,__int64)
    """

def getNumpyType() -> object:
    """
    getNumpyType() -> object :
        Get the Numpy type returned by the converters from an Eigen object.

        C++ signature :
            class boost::python::api::object getNumpyType()
    """

def is_approx(A: numpy.ndarray, B_: numpy.ndarray, prec: float = 1e-12) -> bool:
    """
    is_approx( (numpy.ndarray)A, (numpy.ndarray)B [, (float)prec=1e-12]) -> bool :
        Returns True if A is approximately equal to B, within the precision determined by prec.

        C++ signature :
            bool is_approx(class Eigen::MatrixBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >,class Eigen::MatrixBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> > [,double=1e-12])
    """

def seed(seed_value: int) -> None:
    """
    seed( (int)seed_value) -> None :
        Initialize the pseudo-random number generator with the argument seed_value.

        C++ signature :
            void seed(unsigned int)
    """

def setNumpyType(numpy_type: object) -> None:
    """
    setNumpyType( (object)numpy_type) -> None :
        Change the Numpy type returned by the converters from an Eigen object.

        C++ signature :
            void setNumpyType(class boost::python::api::object {lvalue})
    """

@typing.overload
def sharedMemory() -> bool:
    """
    sharedMemory( (bool)value) -> None :
        Share the memory when converting from Eigen to Numpy.

        C++ signature :
            void sharedMemory(bool)

        C++ signature :
            bool sharedMemory()
    """
@typing.overload
def sharedMemory(value: bool) -> None:
    pass

def switchToNumpyArray() -> None:
    """
    switchToNumpyArray() -> None :
        Set the conversion from Eigen::Matrix to numpy.ndarray.

        C++ signature :
            void switchToNumpyArray()
    """

def switchToNumpyMatrix() -> None:
    """
    switchToNumpyMatrix() -> None :
        Set the conversion from Eigen::Matrix to numpy.matrix.

        C++ signature :
            void switchToNumpyMatrix()
    """

def toEulerAngles(rotation_matrix: numpy.ndarray, a0: int, a1: int, a2: int) -> numpy.ndarray:
    """
    toEulerAngles( (numpy.ndarray)rotation_matrix, (int)a0, (int)a1, (int)a2) -> numpy.ndarray :
        It returns the Euler-angles of the rotation matrix mat using the convention defined by the triplet (a0,a1,a2).

        C++ signature :
            class Eigen::Matrix<double,3,1,0,3,1> toEulerAngles(class Eigen::Matrix<double,3,3,0,3,3>,__int64,__int64,__int64)
    """

__raw_version__ = '2.7.6'
__version__ = '2.7.6'
import Boost.Python
import numpy
_Shape = typing.Tuple[int, ...]

