import eigenpy.eigenpy_pywrap
import typing

__all__ = [
    "AngleAxis",
    "ComputationInfo",
    "DecompositionOptions",
    "EigenSolver",
    "Exception",
    "LDLT",
    "LLT",
    "MINRES",
    "Quaternion",
    "SelfAdjointEigenSolver",
    "checkVersionAtLeast",
    "fromEulerAngles",
    "getNumpyType",
    "is_approx",
    "seed",
    "setNumpyType",
    "sharedMemory",
    "solvers",
    "switchToNumpyArray",
    "switchToNumpyMatrix",
    "toEulerAngles"
]

class AngleAxis():
    pass

class EigenSolver():
    pass

class Exception():
    pass

class LDLT():
    pass

class LLT():
    pass

class MINRES():
    pass

class Quaternion():
    pass

class SelfAdjointEigenSolver():
    pass

class solvers():
    pass

def checkVersionAtLeast(major_version: int, minor_version: int, patch_version: int) -> bool:
    """
    checkVersionAtLeast( (int)major_version, (int)minor_version, (int)patch_version) -> bool :
        Checks if the current version of EigenPy is at least the version provided by the input arguments.

        C++ signature :
            bool checkVersionAtLeast(unsigned int,unsigned int,unsigned int)
    """

def fromEulerAngles(euler_angles: object, a0: int, a1: int, a2: int) -> object:
    """
    fromEulerAngles( (object)euler_angles, (int)a0, (int)a1, (int)a2) -> object :
        It returns the rotation matrix associated to the Euler angles using the convention defined by the triplet (a0,a1,a2).

        C++ signature :
            class Eigen::Matrix<double,3,3,0,3,3> fromEulerAngles(class Eigen::Matrix<double,3,1,0,3,1>,__int64,__int64,__int64)
    """

def getNumpyType() -> object:
    """
    getNumpyType() -> object :
        Get the Numpy type returned by the converters from an Eigen object.

        C++ signature :
            class boost::python::api::object getNumpyType()
    """

@typing.overload
def is_approx(A: object, B: object) -> bool:
    """
    is_approx( (object)A, (object)B, (float)prec) -> bool :
        Returns True if A is approximately equal to B, within the precision determined by prec.

        C++ signature :
            bool is_approx(class Eigen::MatrixBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >,class Eigen::MatrixBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >,double)

        C++ signature :
            bool is_approx(class Eigen::MatrixBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >,class Eigen::MatrixBase<class Eigen::Matrix<double,-1,-1,0,-1,-1> >)
    """
@typing.overload
def is_approx(A: object, B: object, prec: float) -> bool:
    pass

def seed(seed_value: int) -> None:
    """
    seed( (int)seed_value) -> None :
        Initialize the pseudo-random number generator with the argument seed_value.

        C++ signature :
            void seed(unsigned int)
    """

def setNumpyType(numpy_type: object) -> None:
    """
    setNumpyType( (object)numpy_type) -> None :
        Change the Numpy type returned by the converters from an Eigen object.

        C++ signature :
            void setNumpyType(class boost::python::api::object {lvalue})
    """

@typing.overload
def sharedMemory() -> bool:
    """
    sharedMemory( (bool)value) -> None :
        Share the memory when converting from Eigen to Numpy.

        C++ signature :
            void sharedMemory(bool)

        C++ signature :
            bool sharedMemory()
    """
@typing.overload
def sharedMemory(value: bool) -> None:
    pass

def switchToNumpyArray() -> None:
    """
    switchToNumpyArray() -> None :
        Set the conversion from Eigen::Matrix to numpy.ndarray.

        C++ signature :
            void switchToNumpyArray()
    """

def switchToNumpyMatrix() -> None:
    """
    switchToNumpyMatrix() -> None :
        Set the conversion from Eigen::Matrix to numpy.matrix.

        C++ signature :
            void switchToNumpyMatrix()
    """

def toEulerAngles(rotation_matrix: object, a0: int, a1: int, a2: int) -> object:
    """
    toEulerAngles( (object)rotation_matrix, (int)a0, (int)a1, (int)a2) -> object :
        It returns the Euler-angles of the rotation matrix mat using the convention defined by the triplet (a0,a1,a2).

        C++ signature :
            class Eigen::Matrix<double,3,1,0,3,1> toEulerAngles(class Eigen::Matrix<double,3,3,0,3,3>,__int64,__int64,__int64)
    """

__raw_version__ = '2.6.11'
__version__ = '2.6.11'

