# when installed through setup.py, the first line is replaced with the normal,
# non-framework build python. Replace bin/python after ENV with::
# #!/Users/christian/anaconda/envs/ENV/python.app/Contents/MacOS/python
from argparse import ArgumentParser
import os
import sys
from warnings import catch_warnings, filterwarnings

from traits.trait_base import ETSConfig
from IPython import start_ipython
from IPython.paths import get_ipython_dir
with catch_warnings():
    filterwarnings('ignore', "can't resolve package from __spec__", ImportWarning)
    import eelbrain


parser = ArgumentParser('eelbrain', description='Start iPython with eelbrain profile')
parser.add_argument('--version', action='version', version=eelbrain.__version__)
parser.add_argument('--debug-warnings', action='store_true', help='Print tracebacks for warnings')
parser.add_argument('--show-warnings', action='store_true', help='Show all warnings; by default, many warnings that are probably irrelevant are suppressed')


if __name__ == '__main__':
    args = parser.parse_args()
    del sys.argv[1:]
    if args.debug_warnings:
        from eelbrain._utils.debug import warn_with_traceback
        warn_with_traceback()
    if args.show_warnings:
        eelbrain._config.SUPPRESS_WARNINGS = False

    # set ETS toolkit before it is launched
    ETSConfig.toolkit = 'wx'

    if not os.path.exists(os.path.join(get_ipython_dir(), 'profile_eelbrain')):
        from IPython.core.profileapp import ProfileCreate
        app = ProfileCreate()
        app.parse_command_line(('eelbrain', '--quiet'))
        app.init_config_files()
        file_path = os.path.join(get_ipython_dir(), 'profile_eelbrain',
                                 'startup', 'import_eelbrain.py')
        with open(file_path, 'w') as fid:
            fid.write("from eelbrain import *\n")

    sys.exit(start_ipython(profile='eelbrain'))
