/*
 * (C) Copyright 2005- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities granted to it by
 * virtue of its status as an intergovernmental organisation nor does it submit to any jurisdiction.
 */

#ifndef eccodes_config_h
#define eccodes_config_h

#include "eccodes_ecbuild_config.h" /* generated by ecbuild */

#define ECCODES_VERSION_STR      "2.18.0"

/* ECCODES_VERSION is defined in eccodes_version.h from the 3 version components below */

#define ECCODES_MAJOR_VERSION    2
#define ECCODES_MINOR_VERSION    18
#define ECCODES_REVISION_VERSION 0

#define ECCODES_DEFINITION_PATH      "D:/bld/eccodes_1602593877820/_h_env/Library/share/eccodes/definitions"

#ifdef ECCODES_HAVE_C_INLINE
#define GRIB_INLINE inline
#endif

#define GRIB_LINUX_PTHREADS 0

#define GRIB_MEM_ALIGN      0

#define GRIB_PTHREADS       0
#define GRIB_OMP_THREADS    0

#define ECCODES_SAMPLES_PATH    "D:/bld/eccodes_1602593877820/_h_env/Library/share/eccodes/samples"

#define GRIB_TIMER 0

/* headers */

#define ECCODES_HAVE_ASSERT_H
#define ECCODES_HAVE_STRING_H
#define ECCODES_HAVE_SYS_TYPES_H
#define ECCODES_HAVE_SYS_STAT_H
#define ECCODES_HAVE_FCNTL_H
/* #undef ECCODES_HAVE_UNISTD_H */
/* #undef ECCODES_HAVE_FSEEKO */
/* #undef ECCODES_HAVE_POSIX_MEMALIGN */
/* #undef ECCODES_HAVE_FMEMOPEN */
/* #undef ECCODES_HAVE_FUNOPEN */

#if defined(EC_HAVE_ASSERT_H) || defined(ECCODES_HAVE_ASSERT_H)
#define   HAVE_ASSERT_H 1
#endif

#if defined(EC_HAVE_STRING_H) || defined(ECCODES_HAVE_STRING_H)
#define   HAVE_STRING_H 1
#endif

#if defined(EC_HAVE_SYS_TYPES_H) || defined(ECCODES_HAVE_SYS_TYPES_H)
#define   HAVE_SYS_TYPES_H 1
#endif

#if defined(EC_HAVE_SYS_STAT_H) || defined(ECCODES_HAVE_SYS_STAT_H)
#define    HAVE_SYS_STAT_H 1
#endif

#if defined(EC_HAVE_FCNTL_H) || defined(ECCODES_HAVE_FCNTL_H)
#define    HAVE_FCNTL_H 1
#endif

#if defined(EC_HAVE_UNISTD_H) || defined(ECCODES_HAVE_UNISTD_H)
#define    HAVE_UNISTD_H 1
#endif

#if defined(EC_HAVE_FSEEKO) || defined(ECCODES_HAVE_FSEEKO)
#define   HAVE_FSEEKO 1
#endif

#if defined(EC_HAVE_POSIX_MEMALIGN) || defined(ECCODES_HAVE_POSIX_MEMALIGN)
#define         POSIX_MEMALIGN 1
#endif

/* other */

#define IEEE_BE 0

#define IEEE_LE 1

#define IS_BIG_ENDIAN 0

#define MANAGE_MEM    0

/* packages */

#define HAVE_JPEG         1

#define HAVE_LIBJASPER    0

#define HAVE_LIBOPENJPEG  1

#define HAVE_LIBPNG  1

/* #undef HAVE_AEC */

#define HAVE_NETCDF

/* #undef HAVE_MEMFS */

#ifdef HAVE_MEMFS
#undef ECCODES_DEFINITION_PATH
#define ECCODES_DEFINITION_PATH "/MEMFS/definitions"
#undef ECCODES_SAMPLES_PATH
#define ECCODES_SAMPLES_PATH "/MEMFS/samples"
#undef ECCODES_IFS_SAMPLES_PATH
#define ECCODES_IFS_SAMPLES_PATH "/MEMFS/ifs_samples"
#endif

#ifdef HAVE_LIBJASPER
#define JASPER_VERSION_MAJOR 
#endif

#endif /* eccodes_config_h */
