# -*- coding: utf-8 -*-
from __future__ import print_function
from future import standard_library
standard_library.install_aliases()
from builtins import str
from builtins import range
import os, sys
from subprocess import getstatusoutput
from doconce.misc import system, misc_option, load_preprocessed_doconce_file
from doconce.misc import (
    insertdocstr,
    spellcheck,
    capitalize,
    #sphinx_dir,
    gwiki_figsubst,
    latin2html,
    remove_inline_comments,
    apply_inline_edits,
    sphinxfix_localURLs,
    old2new_format,
    latex_header,
    latex_footer,
    latex_problems,
    ref_external,
    find_nonascii_chars,
    replace_from_file,
    replace,
    subst,
    find,
    include_map,
    expand_mako,
    wildcard_notation,
    teamod,
    list_fig_src_files,
    list_labels,
    split_rst,
    slides_html,
    split_html,
    slides_beamer,
    slides_markdown,
    html_colorbullets,
    md2html,
    md2latex,
    change_encoding,
    guess_encoding,
    clean,
    lightclean,
    remove_exercise_answers,
    remove,
    grab,
    ptex2tex,
    include_map,
    expand_commands,
    combine_images,
    latex_exercise_toc,
    pygmentize,
    makefile,
    latex2doconce,
    latex_dislikes,
    html2doconce,
    ipynb2doconce,
    fix_bibtex4publish,
    diff,
    gitdiff,
    csv2table,
    extract_exercises,
    linkchecker,
    grep,
    help_format
    )

def remove_options_from_command_line():
    """Remove options (--name) from sys.argv."""
    opts_index = [i for i in range(len(sys.argv))
                  if sys.argv[i].startswith('--')]
    for i in opts_index:
        del sys.argv[i]

def format():
    """
    Run the doconce module on a file (with extension .do.txt) in Doconce format
    and produce another format (latex, html, plain text, reStructuredText, ...)::

       doconce format html mydoc.do.txt
    """

    try:
        import doconce.doconce
    except ImportError:
        # use local doconce module in the doconce package source:
        try:
            thisdir = os.path.dirname(sys.argv[0])
            doconce_lib = os.path.join(thisdir, os.pardir, 'lib', 'doconce')
            sys.path.insert(0, doconce_lib)
            import doconce.doconce
            print('Successfull import of doconce locally')
        except ImportError as e:
            print(e)
            print('Could not import doconce from directory\n', os.getcwd())
            sys.exit(1)

    bg_session = doconce.doconce.format_driver()
    return bg_session



# sphinx_dir must be defined here because it imports sphinx,
# and in misc.py this is interpreted as the local doconce sphinx.py
# file...

def _usage_sphinx_dir():
    print("""Usage: doconce sphinx_dir short-title="some short title" version=0.1 theme=themename dirname=sphinx-rootdir toc_depth=2 intersphinx  doconcefile [--runestone]

Additional command-line arguments: theme_dir=directoryname conf.py=filename logo=filename favicon=filename

The sphinx_dir command creates a directory (dirname) for compiling a
sphinx version of a doconce document. The option --runestone makes a
directory for RunestoneInteractive documents (slightly different from
a standard sphinx directory).

The default dirname is "sphinx-rootdir". The intersphinx option is used
for links to other sphinx documents.

toc_depth governs the depth in the table of contents, default value is 2
(sections and subsections are included).

The copyright in the footer of Sphinx documents is based on the AUTHOR
field(s) in doconcefile, and if no {copyright...} specification is given
in the field(s), all authors are listed.

The theme option can be chosen from basic sphinx themes (agogo,
basic, bizstyle, classic, default, epub, haiku, nature, pyramid,
scrolls, sphinxdoc, traditional), extra themes that can be installed
(alabaster, bootstrap, cloud, redcloud, solarized, sphinx_rtd_theme,
'draft', 'flat', 'modern5', 'minimal5', 'responsive'),
or themes that come with DocOnce (ADCtheme, agni, basicstrap,
bloodish, cbc, fenics, fenics_classic, fenics_minimal1, fenics_minimal2,
jal, pylons, scipy_lectures, slim-agogo, uio, uio2, vlinux-theme).
See bundled/sphinx_themes/install.txt for how to install extra
themes.

A custom theme can also be specified by giving a "_themes-like"
directory: theme_dir=dirname, where dirname can be any path
(DocOnce will copy this directory to the sphinx root directory).
Note that this must be the *theme directory* with files like
layout.html and theme.conf (not the entire Python package for
a theme.)
Alternatively, one can use a standard theme, but provide one's
own tailored conf.py file through the conf.py=filename option.
If the file (filename) has empty strings for the project and
copyright, those values as well as the variables depending on
these values will get content based on the title, author, and
copyright from the DocOnce source file mydoc.do.txt.
(It is recommended to leave project and copyright as empty strings,
and latex_documents, texinfo_documents, and man_pages as empty lists.)

---

The steps for copying files to the sphinx directory and compiling the document
is done by an automatically generated script:

  python automake_sphinx.py [doconce format options]

The master file can be split into parts. Here is the typical code:

  doconce format sphinx mydoc.do.txt
  doconce split_rst mydoc
  doconce sphinx_dir mydoc  # or with a lot of options...
  python automake_sphinx.py

Note that split_rst must be run prior to sphinx_dir!
""")

import time, shutil, glob, re  # used in sphinx_dir

def sphinx_dir():
    if len(sys.argv) < 2:
        _usage_sphinx_dir()
        sys.exit(1)

    # Grab title, author/copyright, version from the command line
    # (set default values first)
    short_title = None
    version = '1.0'
    theme = 'classic'
    doconce_files = []
    sphinx_rootdir = 'sphinx-rootdir'
    toc_depth = 2
    conf_py = None
    theme_dir = None
    logo = None
    favicon = None
    intersphinx = False
    runestone = False
    # For backward compatibility we need to detect title, copyright and author
    # on the command line
    title_cml = copyright_cml = author_cml = None

    # Get user's info
    for arg in sys.argv[1:]:
        if arg.startswith('short_title='):
            short_title = arg.split('=')[1]
        elif arg.startswith('version='):
            version = arg.split('=')[1]
        elif arg.startswith('dirname='):
            sphinx_rootdir = arg.split('=')[1]
        elif arg.startswith('toc_depth='):
            toc_depth = int(arg.split('=')[1])
        elif arg.startswith('theme='):
            theme = arg.split('=')[1]
        elif arg.startswith('conf.py='):
            conf_py = arg.split('=')[1]
        elif arg.startswith('theme_dir='):
            theme_dir = arg.split('=')[1]
        elif arg.startswith('logo='):
            logo = arg.split('=')[1]
        elif arg.startswith('favicon='):
            favicon = arg.split('=')[1]
        elif arg.startswith('intersphinx'):
            intersphinx = True
        elif arg == '--runestone':
            runestone = True
        elif arg.startswith('author='):
            author_cml = arg.split('=')[1]
        elif arg.startswith('copyright='):
            copyright_cml = arg.split('=')[1]
        elif arg.startswith('title='):
            title_cml = arg.split('=')[1]
        else:
            doconce_files.append(arg)

    if not doconce_files:
        print('must have (at least one) doconce file as argument')
        print('doconce sphinx_dir somefile.do.txt')
        sys.exit(1)
    try:
        import sphinx
    except ImportError:
        print('Unable to import sphinx. Install sphinx from sphinx.pocoo.org.')
        print('On Debian systems, install the \'python-sphinx\' package.')
        sys.exit(1)
    if float(sphinx.__version__[:3]) < 1.1:
        print('Abort: sphinx version >= 1.1 required')
        sys.exit(1)

    if len(doconce_files) > 1:
        print('can only specify one main doconce file')
        print('(here you have specified %s)' % ', '.join(doconce_files))
        sys.exit(1)

    filename = doconce_files[0]
    if filename.endswith('do.txt'):
        filename = filename[:-7]
    else:
        if not os.path.isfile(filename + '.do.txt'):
            print('%s.do.txt does not exist' % filename)
            sys.exit(1)

    parts = glob.glob('._%s[0-9][0-9][0-9].rst' % filename)
    parts = [part[:-4] for part in sorted(parts)]

    # Extract title, author from .do.txt file (try mako processed file first)
    fstr = load_preprocessed_doconce_file(filename)
    if 'TITLE:' in fstr:
        for line in fstr.splitlines():
            if line.startswith('TITLE:'):
                title = line[6:].strip()
                break # use the first TITLE spec
        if title_cml is not None:
            print('*** error: cannot give title= on the command line when TITLE is specified in the DocOnce file', filename)
            sys.exit(1)
    else:
        # No TITLE in the DocOnce file
        if title_cml is None:
            title = 'No title'
        else:
            title = title_cml

    if short_title is None:
        # Default is to use title
        short_title = title

    import doconce.doconce
    # The following can be misleading if there are examples on
    # various AUTHOR: in e.g. vertabim code in the .do.txt file
    authors_and_institutions, dummy1, dummy2, dummy3, dummy4, dummy5 = \
         doconce.doconce.interpret_authors(fstr, 'sphinx')
    if authors_and_institutions:
        author = [a for a, i, e in authors_and_institutions]

        if len(author) == 1:
            author = author[0]
        else:
            author = ', '.join(author[:-1]) + ' and ' + author[-1]
        if author_cml is not None:
            print('*** error: cannot give author= on the command line when AUTHOR is specified in the DocOnce file', filename)
            sys.exit(1)
    else:
        if author_cml is None:
            author = 'No author'
        else:
            author = author_cml

    from doconce.common import get_copyfile_info
    copyright_filename = '.' + filename + '.copyright'
    copyright_ = get_copyfile_info(copyright_filename=copyright_filename,
                                   format='sphinx')
    # copyright_ is None if no copyright and no doconce citation
    # copyright_ is 'Made with DocOnce' if just citation and no copyright,
    # otherwise it is a text with authors/institutions and optionally citation
    # in conf.py we *always* include a copyright with authors, so if
    # copyright is None or just 'Made with DocOnce' we add authors and year
    if isinstance(copyright_, str) and 'DocOnce' in copyright_:
        cite_doconce = True
        if copyright_ == 'Made with DocOnce':
            copyright_ = None  # No specified authors or institutions
    else:
        cite_doconce = False

    if copyright_ is None:
        # No copyright given in the file, use copyright= from command
        # line, if it was provided, or use this year and author
        if copyright_cml is None:
            # use this year, author
            this_year = time.asctime().split()[4]
            copyright_ = this_year + ', ' + author
            if cite_doconce:
                copyright_ += '. Made with DocOnce'
        else:
            copyright_ = copyright_cml
    else:
        if copyright_cml is not None:
            print('*** error: cannot give copyright= on the command line when {coppyright...} is specified as part of AUTHOR in the DocOnce file', filename)
            sys.exit(1)

    chapters = '=========' in fstr
    if chapters:
        toc_depth += 1

    if theme_dir is not None and conf_py is None:
        print('theme_dir is given, but then also conf_py must be specified')
        print('Abort!')
        sys.exit(1)

    print('title:', title)
    print('author:', author)
    print('copyright:', copyright_)
    print('theme:', theme)
    print()
    time.sleep(1.5)

    #make_conf_py_runestone(themes, theme, title, short_title,
    #                       copyright_, logo, favicon, intersphinx)

    if os.path.isdir(sphinx_rootdir):
        shutil.rmtree(sphinx_rootdir)
    if sys.platform.startswith('win'):
        f1 = open('tmp_sphinx_gen.bat', 'w')
        f2 = open('tmp_sphinx_gen.inp', 'w')
        f1.write("""\
echo Making %(sphinx_rootdir)s
mkdir %(sphinx_rootdir)s
sphinx-quickstart < tmp_sphinx_gen.inp
""" % vars())
        f2.write("""\
%(sphinx_rootdir)s
n
_
%(title)s
%(author)s
%(version)s
%(version)s
en
.rst
index
y
y
n
n
n
n
n
y
n
y
y
y
""" % vars())
        f1.close()
        f2.close()
        system('tmp_sphinx_gen',
               failure_info='to generate sphinx directory')
        #os.remove('tmp_sphinx_gen.bat')
        #os.remove('tmp_sphinx_gen.inp')
    else:
        f = open('tmp_sphinx_gen.sh', 'w')
        f.write("""\
#!/bin/bash
echo Making %(sphinx_rootdir)s
mkdir %(sphinx_rootdir)s
sphinx-quickstart <<EOF
%(sphinx_rootdir)s
n
_
%(title)s
%(author)s
%(version)s
%(version)s
en
.rst
index
y
y
n
n
n
n
n
y
n
y
y
y

EOF
""" % vars())
        f.close()
        system('sh tmp_sphinx_gen.sh',
               failure_info='to generate sphinx directory')
        #os.remove('tmp_sphinx_gen.sh')
    os.chdir(sphinx_rootdir)

    sphinx_basic_themes = 'agogo basic bizstyle classic default epub haiku nature pyramid scrolls sphinxdoc traditional'.split()
    # See what is installed of other themes
    sphinx_potentially_installed_themes = 'alabaster bootstrap cloud redcloud solarized impressjs sphinx_rtd_theme dark flat modern5 minimal5 responsive'.split()
    sphinx_installed_themes = []
    try:
        import alabaster
        sphinx_installed_themes.append('alabaster')
    except ImportError:
        pass
    try:
        import sphinx_bootstrap_theme
        sphinx_installed_themes.append('bootstrap')
    except ImportError:
        pass
    try:
        import cloud_sptheme
        sphinx_installed_themes.append('cloud')
        sphinx_installed_themes.append('redcloud')
    except ImportError:
        pass
    try:
        import sphinxjp.themes.impressj
        sphinx_installed_themes.append('impressjs')
    except ImportError:
        pass
    try:
        import sphinxjp.themes.solarized
        sphinx_installed_themes.append('solarized')
    except ImportError:
        pass
    try:
        import sphinx_rtd_theme
        sphinx_installed_themes.append('sphinx_rtd_theme')
    except ImportError:
        pass
    try:
        import tinkerer
        import tinkerer.paths
        sphinx_installed_themes += ['boilerplate', 'dark', 'flat', 'modern5', 'minimal5', 'responsive']
    except ImportError:
        pass

    if theme_dir is None:
        # Copy themes
        import doconce.common
        install_dir = doconce.common.where()
        shutil.copy(os.path.join(install_dir, 'sphinx_themes.zip'), os.curdir)
        devnull = 'NUL' if sys.platform.startswith('win') else '/dev/null'
        system('unzip sphinx_themes.zip > %s' % devnull)
        os.remove('sphinx_themes.zip')
        os.rename('sphinx_themes', '_themes')
        files = sorted(glob.glob(os.path.join('_themes', '*')))
        themes = [name[8:] for name in files
                  if os.path.isdir(name)] + \
                  sphinx_basic_themes + sphinx_installed_themes

        if conf_py is None:
            print('These Sphinx themes were found:', ', '.join(sorted(themes)))
            make_conf_py(themes, theme, title, short_title, copyright_,
                         logo, favicon, intersphinx)
    else:
        # Copy theme_dir
        if not os.path.isdir('_themes'):
            os.mkdir('_themes')
        shutil.copy(theme_dir, os.path.join('_themes', theme_dir))


    if conf_py is not None:
        shutil.copy(os.path.join(os.pardir, conf_py), 'conf.py')

        # Edit the file appropriately if title, author, or copyright are given
        with open('conf.py', 'r') as f:
            conf_text = f.read()

        # Make conf.py ready for latex, man pages, texinfo, epub etc
        # with current doc info
        pattern = r'latex_documents = \[.*?\]'
        replacement = r"latex_documents = [('index', 'doc.tex', project, u'%s',  'manual'),]" % author
        conf_text = re.sub(pattern, replacement, conf_text,
                           flags=re.DOTALL)

        pattern = r'man_pages = \[.*?^# '
        replacement = r"man_pages = [('index', 'doc', project, [u'%s'], 1),]\n\n# " % author
        conf_text = re.sub(pattern, replacement, conf_text,
                           flags=re.DOTALL|re.MULTILINE)

        pattern = r'texinfo_documents = \[.*?\]'
        replacement = r"texinfo_documents = [('index', 'doc', project, u'%s', 'doc', 'One line description of project.', 'Miscellaneous'),]" % author
        conf_text = re.sub(pattern, replacement, conf_text,
                           flags=re.DOTALL)

        pattern = r'''project *= *u?['"](.*?)['"]'''
        m = re.search(pattern, conf_text)
        if m:
            if m.group(1).strip() == '':
                # No title found, take the one from .do.txt
                conf_text = re.sub(pattern, "project = u'%s'" % title,
                                   conf_text)
                conf_text = re.sub(r'html_title.+', "html_title = project", conf_text)
                conf_text = re.sub(r'epub_title.+', "epub_title = project", conf_text)
        pattern = '''^short_title *= *project'''
        m = re.search(pattern, conf_text, flags=re.MULTILINE)
        if short_title != title and m:
            # Update short_title
            conf_text = re.sub(pattern, "short_title = u'%s'" % short_title,
                               conf_text, flags=re.MULTILINE)

        # Fix copyright issues
        pattern = r'''copyright *= *u?['"](.*?)['"]'''
        m = re.search(pattern, conf_text)
        if m:
            if m.group(1).strip() == '':
                # No copyright found, take the one from .do.txt
                conf_text = re.sub(pattern, "copyright = u'%s'" % copyright_,
                                   conf_text)
                conf_text = re.sub(r'epub_copyright.+', "epub_copyright = u'%s'" % copyright_, conf_text)
                conf_text = re.sub(r'epub_author.+', "epub_author = u'%s'" % author, conf_text)
                conf_text = re.sub(r'epub_publisher.+', "epub_publisher = u'%s'" % author, conf_text)
        with open('conf.py', 'w') as f:
            f.write(conf_text)

    # Make a script that can generate all available sphinx themes
    f = open('make_themes.sh', 'w')
    f.write("""#!/bin/sh
# Make all themes given on the command line (or if no themes are
# given, make all themes in _themes/)

if [ $# -gt 0 ]; then
    themes=$@
else
    themes="%s"
fi

for theme in $themes; do
    echo "building theme $theme..."
    doconce subst -m "^html_theme =.*$" "html_theme = '$theme'" conf.py
    make clean
    make html
    mv -f _build/html sphinx-$theme
done
echo
echo "Here are the built themes:"
ls -d sphinx-*
echo "for i in sphinx-*; do google-chrome $i/index.html; done"

""" % (' '.join(themes)))
    f.close()
    os.chmod('make_themes.sh', 0o755)

    # Make index.rst main file for the document
    f = open('index.rst', 'w')
    if parts:
        files = parts
    else:
        files = [filename]
    filenames = '\n   '.join(files)
    title_underline = '='*len(title)
    dropdown_scrollbar = '' if not 'bootstrap' in theme else """

.. raw:: html

  <style type="text/css">
    .dropdown-menu {
      height: auto;
      max-height: 400px;
      overflow-x: hidden;
  }
  </style>

"""
    f.write("""
.. Master file automatically created by doconce sphinx_dir

%(dropdown_scrollbar)s
%(title)s
%(title_underline)s

Contents:

.. toctree::
   :maxdepth: %(toc_depth)s

   %(filenames)s
""" % vars())

    # Do we have idx{} commands in the document? Cannot just check fstr,
    # that is the top/master file. Need to check the entire file.
    dotext = load_preprocessed_doconce_file(filename, dirpath=os.pardir)
    if 'idx{' in dotext:
        f.write("""

Index
=====

* :ref:`genindex`
""")
    f.close()
    os.chdir(os.pardir)

    # Make the automake_sphinx.py compilation file for automatically
    # preparing the sphinx document, copying various files, and running make

    f = open('automake_sphinx.py', 'w')
    f.write('''\
#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Autogenerated file (by doconce sphinx_dir).
# Purpose: create HTML Sphinx version of document "%(filename)s".
#
# Note: doconce clean removes this file, so if you edit the file,
# rename it to avoid automatic removal.

# To force compilation of the doconce file to sphinx format, remove
# the sphinx (.rst) file first.
#
# Command-line arguments are transferred to the "doconce format sphinx"
# compilation command.
#

import glob, sys, os, commands, shutil, logging
logging.basicConfig(
    filename='automake_sphinx.log', filemode='w', level=logging.DEBUG,
    format='%%(asctime)s - %%(levelname)s - %%(message)s',
    datefmt='%%Y.%%m.%%d %%I:%%M:%%S %%p')


command_line_options = ' '.join(['"%%s"' %% arg for arg in sys.argv[1:]])

sphinx_rootdir = '%(sphinx_rootdir)s'
source_dir = sphinx_rootdir

if not os.path.isdir(sphinx_rootdir):
    print """*** error: %%(sphinx_rootdir)s does not exist. This means unsuccessful
    doconce sphinx_dir command. Try to upgrade to latest DocOnce version.
    (The script tmp_sphinx_gen.sh runs sphinx-quickstart - it may have failed.)
""" %% vars()
    sys.exit(1)

def system(cmd, capture_output=False, echo=True):
    if echo:
        print 'running', cmd
    if capture_output:
        failure, outtext = commands.getstatusoutput(cmd) # Unix/Linux only
    else:
        failure = os.system(cmd)
    if failure:
        print 'Could not run', cmd
        logging.critical('Could not run %%s' %% cmd)
        sys.exit(1)
    if capture_output:
        return outtext
''' % vars())
    if parts == []:
        f.write('''
# Compile the doconce file if a sphinx version of it is not found
filename = '%(filename)s'
if not os.path.isfile(filename + '.rst'):
    # Transform doconce format to sphinx format and copy to sphinx directory
    cmd = 'doconce format sphinx %%s %%s' %% (filename, command_line_options)
    print cmd
    logging.info('running %%s' %% cmd)
    system(cmd)

    # Fix: utf-8 encoding for non-English chars
    cmd = 'doconce guess_encoding %%s.rst' %% filename
    enc = system(cmd, capture_output=True)
    if enc == "iso-8859-1":
        # sphinx does not like non-English characters in iso-8859-1
        cmd = 'doconce change_encoding iso-8859-1 utf-8 %%s.rst' %% filename
        logging.info('running %%s' %% cmd)
        system(cmd)

# Copy generated sphinx file to sphinx directory
logging.info('copy: %%s.rst to %%s and reading the content' %% (filename, source_dir))
shutil.copy('%%s.rst' %% filename, source_dir)
with open('%%s.rst' %% filename, 'r') as rst_file:
    rst_text = rst_file.read()
''' % vars())


    else:
        # user has run doconce split_rst so doconce format is already
        # run and all parts must be copied
        parts_names = str(parts)
        f.write('''
# Copy generated sphinx files to sphinx root directory
filename = '%(filename)s'
rst_text = ''  # holds all text in all .rst files
for part in %(parts_names)s:
    shutil.copy('%%s.rst' %% part, source_dir)
    with open('%%s.rst' %% part, 'r') as rst_file:
        rst_text += rst_file.read()
''' % vars())

    f.write('''
# Copy figures and movies directories
figdirs = glob.glob('fig*') + glob.glob('mov*')
for figdir in figdirs:
    destdir = None
    if figdir.startswith('fig'):
        # Figures can be anywhere (copied by sphinx to _images)
        destdir = os.path.join(source_dir, figdir)
    elif figdir.startswith('mov'):
        # Movies must be in _static
        # Copy only the movies if they are needed through local filenames
        if '"'+ figdir in rst_text or '<' + figdir in rst_text:
            destdir = os.path.join(source_dir, '_static', figdir)
    if destdir is not None and os.path.isdir(figdir) and not os.path.isdir(destdir):
        msg = 'copy: %%s to %%s' %% (figdir, destdir)
        print msg
        logging.info(msg)
        shutil.copytree(figdir, destdir)

# Copy needed figure files in current dir (not in fig* directories)
for rstfile in glob.glob(os.path.join(source_dir, '*.rst')) + glob.glob(os.path.join(source_dir, '.*.rst')):
    f = open(rstfile, 'r')
    text = text_orig = f.read()
    f.close()
    import re
    figfiles = [name.strip() for name in
                re.findall('.. figure:: (.+)', text)]
    local_figfiles = [name for name in figfiles if not os.sep in name]

    for name in figfiles:
        basename = os.path.basename(name)
        if name.startswith('http') or name.startswith('ftp'):
            pass
        else:
            if not os.path.isfile(os.path.join(source_dir, basename)):
                msg = 'copy: %%s to %%s' %% (name, source_dir)
                print msg
                logging.info(msg)
                shutil.copy(name, source_dir)
            if name not in local_figfiles:
                # name lies in another directory, make local reference to it
                # since it is copied to source_dir
                text = text.replace('.. figure:: %%s' %% name,
                                    '.. figure:: %%s' %% basename)
                logging.info('edit: figure path to %%s' %% basename)
    if text != text_orig:
        f = open(rstfile, 'w')
        f.write(text)
        f.close()

# Copy linked local files, placed in _static*, to source_dir/_static
staticdirs = glob.glob('_static*')
for staticdir in staticdirs:
    if os.listdir(staticdir):  # copy only if non-empty dir
        cmd = 'cp -r %%(staticdir)s/* %%(source_dir)s/_static/' %% vars()
        logging.info('running %%s' %% cmd)
        system(cmd)

# Create custom files in _static/_templates?
if '**Show/Hide Code**' in rst_text:
    with open(os.path.join(sphinx_rootdir, '_templates', 'page.html'), 'w') as f:
        f.write("""
{%% extends "!page.html" %%}

{%% set css_files = css_files + ["_static/custom.css"] %%}

{%% block footer %%}
 <script type="text/javascript">
    $(document).ready(function() {
        $(".toggle > *").hide();
        $(".toggle .header").show();
        $(".toggle .header").click(function() {
            $(this).parent().children().not(".header").toggle(400);
            $(this).parent().children(".header").toggleClass("open");
        })
    });
</script>
{%% endblock %%}
""")
    with open(os.path.join(sphinx_rootdir, '_static', 'custom.css'), 'w') as f:
        f.write("""
.toggle .header {
    display: block;
    clear: both;
}

.toggle .header:after {
    content: " ▼";
}

.toggle .header.open:after {
    content: " ▲";
}
""")
''' % vars())
    # (Note: must do cp -r above since shutil.copy/copytree cannot copy a la cp -r)
    f.write('''
os.chdir(sphinx_rootdir)
if '--runestone' not in sys.argv:
    # Compile web version of the sphinx document
    print os.getcwd()
    logging.info('running make clean and make html')
    system('make clean')
    system('make html')

    print 'Fix generated files:',
    os.chdir('_build/html')
    for filename in glob.glob('*.html') + glob.glob('.*.html'):
        print filename,
        f = open(filename, 'r'); text = f.read(); f.close()
        text_orig = text
        # Fix double title in <title> tags
        text = re.sub(r'<title>(.+?) &mdash;.+?</title>', r'<title>\g<1></title>', text)
        # Fix untranslated math (e.g. in figure captions and raw html)
        text = re.sub(r':math:`(.+?)`', r' \( \g<1> \) ', text)
        # Fix links to movies
        text = re.sub(r"""src=['"](mov.+?)['"]""", r'src="_static/\g<1>"', text)
        # Fix movie frames in javascript player
        text = text.replace(r'.src = "mov', '.src = "_static/mov')
        # Fix admonition style
        text = text.replace('</head>', """
       <style type="text/css">
         div.admonition {
           background-color: whiteSmoke;
           border: 1px solid #bababa;
         }
       </style>
      </head>
    """)

        # Check if external links should pop up in separate windows
        if '.. NOTE: Open external links in new windows.' in text:
            text = text.replace('<a class="reference external"',
                                '<a class="reference external" target="_blank"')

        # Make a link for doconce citation in copyright
        if '. Made with DocOnce' in text:
            text = text.replace('. Made with DocOnce', '')
            text = text.replace('      Created using <a href="http://sphinx-doc.org/">Sphinx', '      Created using <a href="https://github.com/hplgit/doconce">DocOnce</a> and <a href="http://sphinx-doc.org/">Sphinx')
        # Remove (1), (2), ... numberings in identical headings
        headings_wno = re.findall(r'(?<=(\d|"))>([^>]+?)          \((\d+)\)<', text)
        for dummy, heading, no in headings_wno:
            heading = heading.strip()
            text = re.sub(r'>%%s +\(%%d\)<' %%
                          (re.escape(heading), int(no)),
                          '>%%s<' %% heading, text)
            text = re.sub(r'title="%%s +\(%%d\)"' %%
                          (re.escape(heading), int(no)),
                          r'title="%%s"' %% heading, text)

        if os.path.isfile(filename + '.old~~'):
            os.remove(filename + '.old~~')
        f = open(filename, 'w'); f.write(text); f.close()
        if text != text_orig:
            logging.info('edit: %%s' %% filename)
    os.chdir('../../')
    print """

google-chrome %(sphinx_rootdir)s/_build/html/index.html
"""

else:
    # Add directory for RunestoneInteractive book
    use_runestonebooks_style = True  # False: use user-chosen style
    print """

create RunestoneInteractive directory
"""
    sys.path.insert(0, os.curdir)
    import conf as source_dir_conf  # read data from conf.py

    if not os.path.isdir('RunestoneTools'):
        system('git clone https://github.com/RunestoneInteractive/RunestoneComponents.git')
    os.chdir('RunestoneComponents')
    logging.info('creating RunestoneInteractive directory')

    # Edit conf.py
    # This one does not work anymore: run runestone init instead,
    print 'RunestoneInteractive has recently changed its setup - must abort'
    sys.exit(1)
    # it's the file runestone/__main__.py and function init()
    # Need to build a bash script that runs the command and feeds the answers
    # See also https://github.com/RunestoneInteractive/RunestoneComponents
    f = open('conf.py.prototype', 'r');  text = f.read();  f.close()
    text = text.replace('<ENTER YOUR PROJECT NAME HERE>', source_dir_conf.project)
    text = text.replace('<INSERT YOUR PROJECT NAME HERE>', source_dir_conf.project)
    text = text.replace('<ENTER YOUR COPYRIGHT NOTICE HERE>', source_dir_conf.copyright)
    text = text.replace('<INSERT YOUR PROJECT NAME OR OTHER TITLE HERE>', source_dir_conf.project)
    text = text.replace('<INSERT YOUR PROJECT NAME OR OTHER SHORT TITLE HERE>', source_dir_conf.project)
    text = text.replace('html_theme_path = ["_templates"]', 'html_theme_path = ["_templates", "../_themes"]')
    if not use_runestonebooks_style:
        text = text.replace("html_theme = 'sphinx_bootstrap'", "html_theme = '%%s'" %% source_dir_conf.html_theme)
        text = re.sub(r'html_theme_options = \{.+?\}', 'html_theme_options = ' + str(source_dir_conf.html_theme_options) if hasattr(source_dir_conf, 'html_theme_options') else 'html_theme_options = {}', text, flags=re.DOTALL)
    f = open('conf.py', 'w');  f.write(text);  f.close()

    # Copy .rst files from sphinx dir
    rst_files = [os.path.join(os.pardir, 'index.rst')] + glob.glob(os.path.join(os.pardir, '*.rst')) + glob.glob(os.path.join(os.pardir, '._*.rst'))
    for filename in rst_files:
        print 'copying', filename, 'to _sources'
        logging.info('copy: %%s to _sources' %% filename)
        shutil.copy(filename, '_sources')
    print '*** running paver build to build the RunestoneInteractive book'
    logging.info('running paver build to create the RunestoneInteractive book')
    system('paver build')

    print """

google-chrome %(sphinx_rootdir)s/RunestoneTools/build/index.html
"""
''' % vars())
    f.close()
    os.chmod('automake_sphinx.py', 0o755)
    print("""
'automake_sphinx.py' contains the steps to (re)compile the sphinx
version. You may want to edit this file, or run the steps manually,
or just run it by

  python automake_sphinx.py
""")
    # Add scrollbars to navigation bar dropdown menu in case of bootstrap
    # (this css style is already written to index.rst)
    if 'bootstrap' in theme:
        with open(filename + '.rst', 'r') as f:
            text = f.read()
        # Trick to get scrollbar in dropdown menus
        text = """
.. raw:: html

  <style type="text/css">
    .dropdown-menu {
      height: auto;
      max-height: 400px;
      overflow-x: hidden;
  }
  </style>

""" + text
        with open(filename + '.rst', 'w') as f:
            f.write(text)

def make_conf_py(themes, theme, title, short_title, copyright_,
                 logo, favicon, intersphinx):
    f = open('conf.py', 'r');  text = f.read();  f.close()

    # Compensate bug July 2016 in Sphinx
    text = text.replace('# import os', 'import os')

    # sphinx-quickstart sets copyright to authors with current year,
    # we customize this
    text = re.sub(r"copyright = u'(\d\d\d\d),.+",
                  r"copyright = u'%s'" % copyright_, text)

    # Propagate short_title
    pattern1 = '^short_title *='
    m = re.search(pattern1, text, flags=re.MULTILINE)
    if not m:
        # No short_title found, insert short_title after project
        pattern2 = r'(project *=.+)'
        if short_title == title:
            text = re.sub(pattern2, "\g<1>\nshort_title = project", text)
        else:
            text = re.sub(pattern2, "\g<1>\nshort_title = u'%s'" % short_title, text)
    else:
        if short_title != title:
            # User has given a short_title, must update short_title =
            text = re.sub(pattern1, "short_title = u'%s'" % short_title, text, flags=re.MULTILINE)

    pattern = r'#? *html_short_title *=.+'
    text = re.sub(pattern, 'html_short_title = short_title', text)
    # html_title defaults to "<project> v<release> documentation",
    # let it just be the title
    text = re.sub(r'# *html_title =.+', 'html_title = project', text)


    themes_list = ["html_theme = '%s'" % theme] + \
                  ["#html_theme = '%s'" % t for t in sorted(themes)]
    themes_code = r"""

check_additional_themes= [
   'solarized', 'cloud', 'redcloud',
   'alabaster', 'bootstrap', 'impressjs']

for theme in check_additional_themes:
    if html_theme == theme:
        if not theme in additional_themes_installed:
            raise ImportError(
                'html_theme = "%s", but this theme is not installed. %s' % (theme, additional_themes_url[theme]))

if html_theme == 'solarized':
    pygments_style = 'solarized'

"""
    text = re.sub(r"^html_theme = '.+?' *$",
                  '\n'.join(themes_list) + themes_code,
                  text, flags=re.MULTILINE)

    # Remove html_theme_path and html_static_path deep down in the conf.py
    # file because we need them earlier and must initialize them ourselves
    text = re.sub(r'# Add any paths that contain custom themes.+\n# *html_theme_path = \[\]', "", text)
    text = re.sub(r"# Add any paths that contain custom static.+?\n# *html_static_path = \['_static'\]", "", text)
    # Paths are added below when we try to import various themes in conf.py

    extensions = """\
extensions = [
          #'sphinx.ext.pngmath',
          #'sphinx.ext.jsmath',
          'sphinx.ext.mathjax',
          #'matplotlib.sphinxext.mathmpl',
          #'matplotlib.sphinxext.only_directives',
          'matplotlib.sphinxext.plot_directive',
          'sphinx.ext.autodoc',
          'sphinx.ext.doctest',
          'sphinx.ext.viewcode',
          'sphinx.ext.intersphinx',
          'sphinx.ext.inheritance_diagram',
          'IPython.sphinxext.ipython_console_highlighting']

#pngmath_dvipng_args = ['-D 200', '-bg Transparent', '-gamma 1.5']  # large math fonts (200)

# Make sphinx aware of the DocOnce lexer
def setup(app):
    from sphinx.highlighting import lexers
    from doconce.misc import DocOnceLexer
    lexers['doconce'] = DocOnceLexer()

# Check which additional themes that are installed
additional_themes_installed = []
additional_themes_url = {}

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = ['_themes']
# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

try:
    import alabaster
    additional_themes_installed.append('alabaster')
except ImportError:
    additional_themes_url['alabaster'] = 'sudo pip install alabaster'

try:
    import sphinxjp.themes.solarized
    additional_themes_installed.append('solarized')
except ImportError:
    additional_themes_url['solarized'] = 'https://bitbucket.org/miiton/sphinxjp.themes.solarized: sudo pip install -e hg+https://bitbucket.org/miiton/sphinxjp.themes.solarized#egg=sphinxjp.themes.solarized --upgrade'

try:
    import cloud_sptheme as csp
    additional_themes_installed.append('cloud')
    additional_themes_installed.append('redcloud')
except ImportError:
    url = 'https://bitbucket.org/ecollins/cloud_sptheme: sudo pip install -e hg+https://bitbucket.org/ecollins/cloud_sptheme#egg=cloud_sptheme --upgrade'
    additional_themes_url['cloud'] = url
    additional_themes_url['redcloud'] = url


'''
# FIXME: think we do not need to test on basicstrap, but some themes
# need themecore and we must test for that
try:
    import sphinxjp.themecore
    if not 'sphinxjp.themecore' in extensions:
        extensions += ['sphinxjp.themecore']
    additional_themes_installed.append('basicstrap')
except ImportError:
    # Use basicstrap as an example on a theme with sphinxjp.themecore (??)
    additional_themes_url['basicstrap'] = 'https://github.com/tell-k/sphinxjp.themes.basicstrap: sudo pip install -e git+https://github.com/ryan-roemer/sphinx-bootstrap-theme#egg=sphinx-bootstrap-theme --upgrade'
'''

try:
    import sphinxjp.themes.impressjs
    additional_themes_installed.append('impressjs')
except ImportError:
    additional_themes_url['impressjs'] = 'https://github.com/shkumagai/sphinxjp.themes.impressjs: sudo pip install -e git+https://github.com/shkumagai/sphinxjp.themes.impressjs#egg=sphinxjp.themes.impressjs --upgrade'

try:
    import sphinx_bootstrap_theme
    additional_themes_installed.append('bootstrap')
except ImportError:
    additional_themes_url['bootstrap'] = 'https://github.com/ryan-roemer/sphinx-bootstrap-theme: sudo pip install -e git+https://github.com/ryan-roemer/sphinx-bootstrap-theme#egg=sphinx-bootstrap-theme --upgrade'

try:
    import icsecontrib.sagecellserver
    extensions += ['icsecontrib.sagecellserver']
except ImportError:
    # sudo pip install -e git+https://github.com/kriskda/sphinx-sagecell#egg=sphinx-sagecell --upgrade
    pass

# Is the document built on readthedocs.org? If so, don't import
on_rtd = os.environ.get('READTHEDOCS', None) == 'True'
if not on_rtd:  # only import and set the theme if we're building docs locally
    try:
        import sphinx_rtd_theme
        additional_themes_installed.append('sphinx_rtd_theme')
    except ImportError:
        additional_themes_url['sphinx_rtd_theme'] = 'sudo pip install sphinx_rtd_theme'

tinker_themes = [
  'dark', 'flat', 'modern5', 'minimal5', 'responsive']
# http://tinkerer.me/index.html
# See Preview Another Theme in the sidebar of the above URL
try:
    import tinkerer
    import tinkerer.paths
    additional_themes_installed += tinker_themes
except ImportError:
    for theme in tinker_themes:
        additional_themes_url[theme] = 'sudo pip install tinkerer --upgrade'

"""
    # Intersphinx mapping: the look up of URLs can take quite
    # some time, so this is not enabled by default
    if intersphinx:
        extensions +="""

#intersphinx_mapping = {}
# Example configuration for intersphinx for references to the
# the Sphinx documents for Python, NumPy, SciPy, Matplotlib.
# (Domos in http://scipy-lectures.github.com, typically :mod:`scipy.io`
# or :class:`numpy.ndarray` or :func:`math.asin`)
intersphinx_mapping = {
    'python': ('http://docs.python.org/2.7', None),
    'numpy': ('http://docs.scipy.org/doc/numpy', None),
    'scipy': ('http://docs.scipy.org/doc/scipy/reference', None),
    'mpl': ('http://matplotlib.org/', None),
}
"""

    #'matplotlib.sphinxext.ipython_directive',
    #'matplotlib.sphinxext.ipython_console_highlighting',
    # are now in IPython, but not installed as Python modules

    text = re.sub(r'extensions = .*?\]', extensions, text, flags=re.DOTALL)
    html_theme_options = r"""# See http://sphinx.pocoo.org/theming.html for options
if html_theme in ('default', 'classic'):
    # pygments_style =
    html_theme_options = {
       'rightsidebar': 'false',  # 'true'
       'stickysidebar': 'false', # Make the sidebar "fixed" so that it doesn't scroll out of view for long body content.  This may not work well with all browsers.  Defaults to false.
       'collapsiblesidebar': 'false', # Add an *experimental* JavaScript snippet that makes the sidebar collapsible via a button on its side. *Doesn't work together with "rightsidebar" or "stickysidebar".* Defaults to false.
       'externalrefs': 'false', # Display external links differently from internal links.  Defaults to false.
       # For colors and fonts, see default/theme.conf for default values
       #'footerbgcolor':    # Background color for the footer line.
       #'footertextcolor:'  # Text color for the footer line.
       #'sidebarbgcolor':   # Background color for the sidebar.
       #'sidebarbtncolor':  # Background color for the sidebar collapse button (used when *collapsiblesidebar* is true).
       #'sidebartextcolor': # Text color for the sidebar.
       #'sidebarlinkcolor': # Link color for the sidebar.
       #'relbarbgcolor':    # Background color for the relation bar.
       #'relbartextcolor':  # Text color for the relation bar.
       #'relbarlinkcolor':  # Link color for the relation bar.
       #'bgcolor':          # Body background color.
       #'textcolor':        # Body text color.
       #'linkcolor':        # Body link color.
       #'visitedlinkcolor': # Body color for visited links.
       #'headbgcolor':      # Background color for headings.
       #'headtextcolor':    # Text color for headings.
       #'headlinkcolor':    # Link color for headings.
       #'codebgcolor':      # Background color for code blocks.
       #'codetextcolor':    # Default text color for code blocks, if not set differently by the highlighting style.
       #'bodyfont':         # Font for normal text.
       #'headfont':         # Font for headings.
    }

elif html_theme == 'alabaster':
    # Doc: https://pypi.python.org/pypi/alabaster
    extensions += ['alabaster']
    html_theme_path += [alabaster.get_path()]
    html_theme_sidebars = {
      '**': [
        'about.html',
        'navigation.html',
        'relations.html',
        'searchbox.html',
        'donate.html',
      ]
    }

elif html_theme == 'sphinx_rtd_theme':
    # Doc: https://pypi.python.org/pypi/sphinx_rtd_theme
    if not on_rtd:
        html_theme_path += [sphinx_rtd_theme.get_html_theme_path()]

elif html_theme == 'sphinxdoc':
    # Doc: http://sphinx-doc.org/theming.html
    html_theme_options = {
       'nosidebar': 'false',  # 'true'
    }

elif html_theme == 'solarized':
    extensions += ['sphinxjp.themecore', 'sphinxjp.themes.solarized']

elif html_theme in ('cloud', 'redcloud'):
    html_theme_path += [csp.get_theme_dir()]

elif html_theme == 'impressjs':
    html_theme_path += [csp.get_theme_dir()]
    if not 'sphinxjp.themecore' in extensions:
        extensions += ['sphinxjp.themecore']

elif html_theme == 'scrolls':
    # Doc: http://sphinx.pocoo.org/theming.html
    pass
    #html_theme_options = {
       #'headerbordercolor':,
       #'subheadlinecolor:',
       #'linkcolor':,
       #'visitedlinkcolor':
       #'admonitioncolor':
    #}

elif html_theme == 'agogo':
    # Doc: http://sphinx.pocoo.org/theming.html
    pass

elif html_theme == 'nature':
    # Doc: http://sphinx.pocoo.org/theming.html
    html_theme_options = {
       'nosidebar': 'false',  # 'true'
    }

elif html_theme == 'traditional':
    # Doc: http://sphinx.pocoo.org/theming.html
    html_theme_options = {
       'nosidebar': 'false',  # 'true'
    }

elif html_theme == 'haiku':
    # Doc: http://sphinx.pocoo.org/theming.html
    html_theme_options = {
       'nosidebar': 'false',  # 'true'
    }

elif html_theme == 'pyramid':
    # Doc: http://sphinx.pocoo.org/theming.html
    html_theme_options = {
       'nosidebar': 'false',  # 'true'
    }

elif html_theme == 'bizstyle':
    # Doc: http://sphinx.pocoo.org/theming.html
    html_theme_options = {
       'nosidebar': 'false',  # 'true'
       'rightsidebar': 'false',  # 'true'
    }

elif html_theme == 'epub':
    # Doc: http://sphinx.pocoo.org/theming.html
    html_theme_options = {
       'relbar1': 'true',
       'footer': 'true',
    }

elif html_theme == 'basicstrap':
    html_theme_options = {
       'rightsidebar': 'false',  # 'true'
    }

elif html_theme == 'bootstrap':
    # Doc: https://ryan-roemer.github.io/sphinx-bootstrap-theme/README.html#customization
    html_theme_options = {
        'navbar_title': short_title,

        # Global TOC depth for "site" navbar tab. (Default: 1)
        # Switching to -1 shows all levels.
        'globaltoc_depth': -1,

        # HTML navbar class (Default: "navbar") to attach to <div> element.
        # For black navbar, do "navbar navbar-inverse"
        'navbar_class': "navbar navbar-inverse",

        # Fix navigation bar to top of page?
        # Values: "true" (default) or "false"
        'navbar_fixed_top': "true",

        # Location of link to source.
        # Options are "nav" (default), "footer" or anything else to exclude.
        'source_link_position': "footer",

        # Any Bootswatch theme (http://bootswatch.com/) can be used
        #'bootswatch_theme': 'readable',

        # A list of tuples containing pages or urls to link to.
        # Valid tuples should be in the following forms:
        #    (name, page)                 # a link to a page
        #    (name, "/aa/bb", 1)          # a link to an arbitrary relative url
        #    (name, "http://example.com", True) # arbitrary absolute url
        # Note the "1" or "True" value above as the third argument to indicate
        # an arbitrary url.
        #'navbar_links': [('PDF', '../mydoc.pdf', True), ('HTML', '../mydoc.html', True)],

        # TODO: Future.
        # Add page navigation to it's own navigation bar.
        #'navbar_page_separate': True,
    }
    html_theme_path += sphinx_bootstrap_theme.get_html_theme_path()

elif html_theme == 'scipy_lectures':
    # inherits the default theme and has all those options
    # set rightsidebar to true and nodesidebar to true to get
    # sidebar with the matching colors
    html_theme_options = {
        'nosidebar': 'true',
        'rightsidebar': 'false',
        'sidebarbgcolor': '#f2f2f2',
        'sidebartextcolor': '#20435c',
        'sidebarlinkcolor': '#20435c',
        'footerbgcolor': '#000000',
        'relbarbgcolor': '#000000',
    }

elif html_theme == 'cbc':
    pygments_style = "friendly"
elif html_theme == 'uio':
    pygments_style = "tango"
elif html_theme in tinker_themes:
    html_theme_options = {}
    extensions += ['tinkerer.ext.blog', 'tinkerer.ext.disqus']
    html_static_path += [tinkerer.paths.static]
    html_theme_path += [tinkerer.paths.themes]


"""
    text = re.sub(r'^# *html_theme_options = \{\}', html_theme_options,
                  text, flags=re.MULTILINE)
    #text = re.sub('^# *html_theme_path = \[\]', html_theme_options,

    # Examples on settings: http://pylit.berlios.de/conf.py.html

    text = re.sub(r'# *html_use_index =.+', """
if html_theme == 'impressjs':
    html_use_index = False
""", text)

    if logo is not None:
        # Must copy logo file
        logo_basename = os.path.basename(logo)
        shutil.copy(os.path.abspath(logo), logo_basename)
        text = re.sub(r'# *html_logo = None', 'html_logo = "%s"'
                      % logo_basename, text)

    if favicon is not None:
        # Must copy logo file
        favicon_basename = os.path.basename(favicon)
        shutil.copy(os.path.abspath(favicon),
                    os.path.join('_static', favicon_basename))
        text = re.sub(r'# *html_favicon = None', 'html_favicon = "%s"'
                      % favicon_basename, text)

    # For tinker themes we need to copy index.rst to master.rst
    if theme in ['dark', 'flat', 'modern5', 'minimal5', 'responsive']:
        shutil.copy('index.rst', 'master.rst')
        text = text.replace("master_doc = 'index'", "master_doc = 'master'")
        text = re.sub(r'(html_title =.+)', r'''\g<1>
tagline = ""  # subtitle
html_add_permalinks = None''', text)

    f = open('conf.py', 'w');  f.write(text);  f.close()

    # Write _templates/layout.html file for sagecellserver boxes
    try:
        import icsecontrib.sagecellserver
        f = open(os.path.join('_templates', 'layout.html'), 'w')
        f.write("""\
{% extends "!layout.html" %}
{% block linktags %}

        <script src="http://sagecell.sagemath.org/static/jquery.min.js"></script>
        <script src="http://sagecell.sagemath.org/static/embedded_sagecell.js"></script>

        <script>sagecell.makeSagecell({inputLocation: ".sage"});</script>

        <style type="text/css">
                .sagecell .CodeMirror-scroll {
                        overflow-y: hidden;
                        overflow-x: auto;
                }
                .sagecell .CodeMirror {
                        height: auto;
                }
        </style>

    {{ super() }}
{% endblock %}
""")
        f.close()
    except ImportError:
        pass


def make_conf_py_runestone(themes, theme, title, short_title,
                           copyright_, logo, favicon, intersphinx):
    f = open('conf.py', 'r');  text = f.read();  f.close()
    text = re.sub(r"^project = u'<ENTER.+", "project = u'%s'" % title,
                  flags=re.MULTILINE)
    text = re.sub(r"^copyright = u'<ENTER.+", "copyright = u'%s'" % copyright_,
                  flags=re.MULTILINE)
    text = re.sub(r"'navbar_title':.+", "'navbar_title': '%s'" % title)
    f = open('conf.py', 'w');  f.write(text);  f.close()




# -----------------------------------------------------------------------

commands = """
format
help
sphinx_dir
subst
replace
replace_from_file
clean
lightclean
spellcheck
find
ptex2tex
guess_encoding
include_map
expand_commands
expand_mako
combine_images
change_encoding
capitalize
find_nonascii_chars
gwiki_figsubst
md2html
md2latex
remove_inline_comments
apply_inline_edits
grab
remove
remove_exercise_answers
split_rst
split_html
slides_html
slides_beamer
slides_markdown
csv2table
extract_exercises
latin2html
grep
latex_header
latex_footer
latex_problems
ref_external
html_colorbullets
list_fig_src_files
list_labels
teamod
sphinxfix_localURLs
latex_exercise_toc
insertdocstr
old2new_format
linkchecker
latex2doconce
latex_dislikes
html2doconce
ipynb2doconce
pygmentize
makefile
diff
gitdiff
fix_bibtex4publish
""".split()

# -----------------------------------------------------------------------

def help():
    print(r"""

# transform doconce file to another format
doconce format html|latex|pdflatex|rst|sphinx|plain|gwiki|mwiki|cwiki|pandoc|st|epytext dofile

# substitute a phrase by another using regular expressions
doconce subst [-s -m -x --restore] regex-pattern regex-replacement file1 file2 ...
(-s is the re.DOTALL modifier, -m is the re.MULTILINE modifier,
 -x is the re.VERBOSE modifier, --restore copies backup files back again)

# replace a phrase by another literally
doconce replace from-text to-text file1 file2 ...
(exact text substutition)

# doconce replace using from and to phrases from file
doconce replace_from_file file-with-from-to-replacements file1 file2 ...

# search for a (regular) expression in all .do.txt files in
# the current directory tree (useful when removing compilation errors)
doconce find expression

# print an overview of how various files are included in the root doc
doconce include_map mydoc.do.txt

# replace all mako function calls by the results of the calls
doconce expand_mako mako_code_file funcname file1 file2 ...

# remove all inline comments in a doconce file
doconce remove_inline_comments dofile

# apply all edits specified through inline comments
apply_inline_edits

# create a directory for the sphinx format
doconce sphinx_dir copyright='John Doe' title='Long title' \
    short_title="Short title" version=0.1 intersphinx \
    dirname=sphinx-rootdir theme=default logo=/path/to/mylogo.png \
    dofile
(requires sphinx version >= 1.1)

# walk through a directory tree and insert doconce files as
# docstrings in *.p.py files
doconce insertdocstr rootdir

# remove all redundant files (keep source .do.txt and results:
# .pdf, .html, sphinx- dirs, .mwiki, .ipynb, etc.)
doconce lightclean

# remove all files that the doconce can regenerate
doconce clean

# change encoding
doconce change_encoding utf-8 latin1 dofile

# guess the encoding in a text
doconce guess_encoding filename

# find non-ascii characters in a file
doconce find_nonascii_chars file1 file2 ...

# split a sphinx/rst file into parts
doconce format sphinx complete_file
doconce split_rst complete_file        # !split specifies the splitting points
doconce sphinx_dir complete_file
python automake_sphinx.py

# split an html file into parts according to !split commands
doconce split_html complete_file.html

# create HTML slides from a (doconce) html file
doconce slides_html slide_type complete_file.html

# create LaTeX Beamer slides from a (doconce) latex/pdflatex file
doconce slides_beamer complete_file.tex

# create Remark slides from Markdown
doconce slides_markdown complete_file.md remark --slide_style=light

# replace bullets in lists by colored bullets
doconce html_colorbullets file1.html file2.html ...

# extract all exercises (projects and problems too)
doconce extract_exercises tmp_mako__mydoc

# grab selected text from a file
doconce grab   --from[-] from-text [--to[-] to-text] somefile > result

# remove selected text from a file
doconce remove --from[-] from-text [--to[-] to-text] somefile > result

# list all figure, movie or included code files
doconce grep FIGURE|MOVIE|CODE dofile

# run spellcheck on a set of files
doconce spellcheck [-d .mydict.txt] *.do.txt

# transform ptex2tex files (.p.tex) to ordinary latex file
# and manage the code environments
doconce ptex2tex mydoc -DMINTED pycod=minted sys=Verbatim \
        dat=\begin{quote}\begin{verbatim};\end{verbatim}\end{quote}

# make HTML file via pandoc from Markdown (.md) file
doconce md2html file.md

# make LaTeX file via pandoc from Markdown (.md) file
doconce md2latex file.md

# combine several images into one
doconce combine_images image1 image2 ... output_file

# report problems from a LaTeX .log file
doconce latex_problems mydoc.log [overfull-hbox-limit]

# list all figure files, movie files, and source code files needed
doconce list_fig_src_files *.do.txt

# list all labels in a document (for purposes of cleaning them up)
doconce list_labels myfile

# generate script for substituting generalized references
doconce ref_external mydoc [pubfile]

# check all links in HTML files
doconce linkchecker *.html

# change headings from "This is a Heading" to "This is a heading"
doconce capitalize [-d .mydict.txt] *.do.txt

# translate a latex document to doconce (requires usually manual fixing)
doconce latex2doconce latexfile

# check if there are problems with translating latex to doconce
doconce latex_dislikes latexfile

# translate an IPython/Jupyter notebook to doconce
doconce ipynb2doconce notebookfile

# typeset a doconce document with pygments (for pretty print of doconce itself)
doconce pygmentize myfile [pygments-style]

# generate a make.py script for translating a doconce file to various formats
doconce makefile docname doconcefile [html sphinx pdflatex ...]

# find differences between two files
doconce diff file1.do.txt file2.do.txt [diffprog]
(diffprog can be difflib, diff, pdiff, latexdiff, kdiff3, diffuse, ...)

# find differences between the last two Git versions of several files
doconce gitdiff file1 file2 file3 ...

# convert csv file to doconce table format
doconce csv2table somefile.csv

# edit URLs to local files and place them in _static
doconce sphinxfix_local_URLs file.rst

# replace latex-1 (non-ascii) characters by html codes
doconce latin2html file.html

# fix common problems in bibtex files for publish import
doconce fix_bibtex4publish file1.bib file2.bib ...

# print the header (preamble) for latex file
doconce latex_header

# print the footer for latex files
doconce latex_footer

# expand short cut commands to full form in files
doconce expand_commands file1 file2 ...

# insert a table of exercises in a latex file myfile.p.tex
doconce latex_exercise_toc myfile
""")
#doconce teamod name
#doconce assemble name master.do.txt


def main():
    from doconce import __version__ as version
    import doconce
    doconce_dir = os.path.dirname(doconce.__file__)
    if len(sys.argv) > 2 and sys.argv[1] == 'format' and misc_option('help'):
        help_format()
        sys.exit(0)
    if len(sys.argv) == 1 or misc_option('help'):
        print('DocOnce version', version, '(from %s)' % doconce_dir)
        print('Usage: doconce command [optional arguments]')
        print('commands: %s' % (' '.join(commands)))
        help()
        sys.exit(0)
    if misc_option('version'):
        print('DocOnce version', version, '(from %s)' % doconce_dir)
        sys.exit(0)

    command = sys.argv[1]
    del sys.argv[1]
    if command == '2format':
        command = 'format'
    if command == 'format':
        # For backward compatibility:
        if len(sys.argv) >= 2 and sys.argv[1] == 'LaTeX':
            sys.argv[1] = 'latex'
            print('\nWarning: Previous format LaTeX now has the name latex\n')
        if len(sys.argv) >= 2 and sys.argv[1] == 'HTML':
            sys.argv[1] = 'html'
            print('\nWarning: Previous format HTML now has the name html\n')

    # Treat wrong command name
    found = False
    retval = None
    if command in commands:
        found = True
        retval = eval(command + '()')
    if not found:
        if command in ('html', 'latex', 'sphinx', 'rst', 'plain', 'gwiki', \
           'mwiki', 'epydoc', 'pandoc'):
            print('command', command, 'is not a legal command for doconce, did you mean')
            print('doconce format %s %s?' % (command, ' '.join(sys.argv[1:])))
        else:
            print('command "%s" is not legal, must be among\n' % command)
            print(', '.join(commands))
    return retval

bg_session = main()
if bg_session is not None:
    print('...running bokeh bg_session.loop_until_closed() in the background')
    bg_session.loop_until_closed()
