# -*- coding: utf-8 -*-
# Generated by Django 1.11.8 on 2018-03-08 03:34
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='EmailMessage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False)),
                ('subject', models.TextField(verbose_name='Subject')),
                ('body_text', models.TextField(verbose_name='Body (text)')),
                ('body_html', models.TextField(blank=True, null=True, verbose_name='Body (HTML)')),
                ('from_email', models.EmailField(max_length=254, verbose_name='From')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Date created')),
                ('date_modified', models.DateTimeField(auto_now=True, verbose_name='Date modified')),
                ('date_sent', models.DateTimeField(blank=True, null=True, verbose_name='Date sent')),
                ('state', models.CharField(default='draft', max_length=20, verbose_name='State')),
                ('send_retries', models.SmallIntegerField(default=0, verbose_name='Send retries')),
                ('send_error_message', models.TextField(blank=True, null=True, verbose_name='Send error message')),
                ('send_error_code', models.SmallIntegerField(blank=True, null=True, verbose_name='Send error code')),
                ('from_template', models.CharField(blank=True, max_length=100, null=True, verbose_name='From template')),
            ],
            options={
                'verbose_name': 'Email message',
                'verbose_name_plural': 'Email messages',
                'ordering': ['-date_created', '-date_sent'],
            },
        ),
        migrations.CreateModel(
            name='EmailRecipient',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('to', 'To'), ('cc', 'C.C.'), ('bcc', 'B.C.C.')], default='to', max_length=5, verbose_name='Recipient type')),
                ('address', models.EmailField(max_length=254, verbose_name='Recipient email address')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='recipients', to='emailhub.EmailMessage')),
                ('users', models.ManyToManyField(blank=True, related_name='emailhub', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Email recipient',
                'verbose_name_plural': 'Email recipients',
            },
        ),
        migrations.CreateModel(
            name='EmailSignature',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('slug', models.SlugField(max_length=80, verbose_name='Slug')),
                ('language', models.CharField(choices=[('fr', 'French'), ('en', 'English')], default='en', max_length=6, verbose_name='Language')),
                ('text_content', models.TextField(verbose_name='Text content')),
                ('html_content', models.TextField(blank=True, null=True, verbose_name='HTML content')),
            ],
            options={
                'verbose_name': 'Email signature',
                'verbose_name_plural': 'Email signatures',
                'ordering': ['slug'],
            },
        ),
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language', models.CharField(choices=[('fr', 'French'), ('en', 'English')], default='en', max_length=6, verbose_name='Language')),
                ('slug', models.SlugField(max_length=80, verbose_name='Slug')),
                ('subject', models.CharField(max_length=100, verbose_name='Subject')),
                ('text_content', models.TextField(verbose_name='Text content')),
                ('html_content', models.TextField(verbose_name='HTML content')),
                ('email_from', models.EmailField(blank=True, help_text='Will be sent from "no-reply@domain.com" if left blank.', max_length=254, null=True, verbose_name='Email from')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is active')),
                ('is_auto_send', models.BooleanField(default=False, help_text='If checked, email will be sent without going through a "draft" state.', verbose_name='Auto send')),
                ('signature', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='emailhub.EmailSignature')),
            ],
            options={
                'verbose_name': 'Email template',
                'verbose_name_plural': 'Email templates',
            },
        ),
    ]
