# -*- coding: utf-8 -*-
"""
EmailHub AnyMail SendGrid v2 backend
"""
from anymail.backends.sendgrid_v2 import EmailBackend as BaseEmailBackend  # noqa pylint: disable=import-error
from emailhub.utils.email import process_outgoing_email


class EmailBackend(BaseEmailBackend):
    """ AnyMail Sendgrid v2 backend """
    def _send(self, message):  # noqa pylint: disable=missing-docstring
        process_outgoing_email(message)
        super(EmailBackend, self)._send(message)
