"""
The ``aiohttp_jinja2`` integration adds tracing of template rendering.


Enabling
~~~~~~~~

The integration is enabled automatically when using
:ref:`ddtrace-run<ddtracerun>` or :ref:`patch_all()<patch_all>`.

Or use :ref:`patch()<patch>` to manually enable the integration::

    from ddtrace import patch
    patch(aiohttp_jinja2=True)
"""
from ...internal.utils.importlib import require_modules


required_modules = ["aiohttp_jinja2"]

with require_modules(required_modules) as missing_modules:
    if not missing_modules:
        from .patch import patch
        from .patch import unpatch

        __all__ = ["patch", "unpatch"]
