/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.Driver;
import org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCostFactory;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.PlannerImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.statistic.QuerySqlStatisticProvider;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Frameworks {
    private static final Supplier<Driver> DRIVER_SUPPLIER = Suppliers.memoize(Driver::new)::get;

    private Frameworks() {
    }

    public static Planner getPlanner(FrameworkConfig config) {
        return new PlannerImpl(config);
    }

    public static <R> R withPlanner(PlannerAction<R> action, FrameworkConfig config) {
        return (R)Frameworks.withPrepare(config, (cluster, relOptSchema, rootSchema, statement) -> {
            CalciteSchema schema = CalciteSchema.from(Util.first(config.getDefaultSchema(), rootSchema));
            return action.apply(cluster, relOptSchema, schema.root().plus());
        });
    }

    public static <R> R withPlanner(PlannerAction<R> action) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        return Frameworks.withPlanner(action, config);
    }

    @Deprecated
    public static <R> R withPrepare(PrepareAction<R> action) {
        return Frameworks.withPrepare(action.getConfig(), action);
    }

    public static <R> R withPrepare(BasePrepareAction<R> action) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        return Frameworks.withPrepare(config, action);
    }

    public static <R> R withPrepare(FrameworkConfig config, BasePrepareAction<R> action) {
        try {
            Properties info = new Properties();
            if (config.getTypeSystem() != RelDataTypeSystem.DEFAULT) {
                info.setProperty(CalciteConnectionProperty.TYPE_SYSTEM.camelName(), config.getTypeSystem().getClass().getName());
            }
            Connection connection = DRIVER_SUPPLIER.get().connect("jdbc:calcite:", info);
            CalciteServerStatement statement = connection.createStatement().unwrap(CalciteServerStatement.class);
            return new CalcitePrepareImpl().perform(statement, config, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SchemaPlus createRootSchema(boolean addMetadataSchema) {
        return CalciteSchema.createRootSchema(addMetadataSchema).plus();
    }

    public static ConfigBuilder newConfigBuilder() {
        return new ConfigBuilder();
    }

    public static ConfigBuilder newConfigBuilder(FrameworkConfig config) {
        return new ConfigBuilder(config);
    }

    static class StdFrameworkConfig
    implements FrameworkConfig {
        private final Context context;
        private final SqlRexConvertletTable convertletTable;
        private final SqlOperatorTable operatorTable;
        private final ImmutableList<Program> programs;
        private final @Nullable ImmutableList<RelTraitDef> traitDefs;
        private final SqlParser.Config parserConfig;
        private final SqlValidator.Config sqlValidatorConfig;
        private final SqlToRelConverter.Config sqlToRelConverterConfig;
        private final @Nullable SchemaPlus defaultSchema;
        private final @Nullable RelOptCostFactory costFactory;
        private final RelDataTypeSystem typeSystem;
        private final @Nullable RexExecutor executor;
        private final boolean evolveLattice;
        private final SqlStatisticProvider statisticProvider;
        private final @Nullable RelOptTable.ViewExpander viewExpander;

        StdFrameworkConfig(Context context, SqlRexConvertletTable convertletTable, SqlOperatorTable operatorTable, ImmutableList<Program> programs, @Nullable ImmutableList<RelTraitDef> traitDefs, SqlParser.Config parserConfig, SqlValidator.Config sqlValidatorConfig, SqlToRelConverter.Config sqlToRelConverterConfig, @Nullable SchemaPlus defaultSchema, @Nullable RelOptCostFactory costFactory, RelDataTypeSystem typeSystem, @Nullable RexExecutor executor, boolean evolveLattice, SqlStatisticProvider statisticProvider, @Nullable RelOptTable.ViewExpander viewExpander) {
            this.context = context;
            this.convertletTable = convertletTable;
            this.operatorTable = operatorTable;
            this.programs = programs;
            this.traitDefs = traitDefs;
            this.parserConfig = parserConfig;
            this.sqlValidatorConfig = sqlValidatorConfig;
            this.sqlToRelConverterConfig = sqlToRelConverterConfig;
            this.defaultSchema = defaultSchema;
            this.costFactory = costFactory;
            this.typeSystem = typeSystem;
            this.executor = executor;
            this.evolveLattice = evolveLattice;
            this.statisticProvider = statisticProvider;
            this.viewExpander = viewExpander;
        }

        @Override
        public SqlParser.Config getParserConfig() {
            return this.parserConfig;
        }

        @Override
        public SqlValidator.Config getSqlValidatorConfig() {
            return this.sqlValidatorConfig;
        }

        @Override
        public SqlToRelConverter.Config getSqlToRelConverterConfig() {
            return this.sqlToRelConverterConfig;
        }

        @Override
        public @Nullable SchemaPlus getDefaultSchema() {
            return this.defaultSchema;
        }

        @Override
        public @Nullable RexExecutor getExecutor() {
            return this.executor;
        }

        @Override
        public ImmutableList<Program> getPrograms() {
            return this.programs;
        }

        @Override
        public @Nullable RelOptCostFactory getCostFactory() {
            return this.costFactory;
        }

        @Override
        public @Nullable ImmutableList<RelTraitDef> getTraitDefs() {
            return this.traitDefs;
        }

        @Override
        public SqlRexConvertletTable getConvertletTable() {
            return this.convertletTable;
        }

        @Override
        public Context getContext() {
            return this.context;
        }

        @Override
        public SqlOperatorTable getOperatorTable() {
            return this.operatorTable;
        }

        @Override
        public RelDataTypeSystem getTypeSystem() {
            return this.typeSystem;
        }

        @Override
        public boolean isEvolveLattice() {
            return this.evolveLattice;
        }

        @Override
        public SqlStatisticProvider getStatisticProvider() {
            return this.statisticProvider;
        }

        @Override
        public @Nullable RelOptTable.ViewExpander getViewExpander() {
            return this.viewExpander;
        }
    }

    public static class ConfigBuilder {
        private SqlRexConvertletTable convertletTable;
        private SqlOperatorTable operatorTable;
        private ImmutableList<Program> programs;
        private Context context;
        private @Nullable ImmutableList<RelTraitDef> traitDefs;
        private SqlParser.Config parserConfig;
        private SqlValidator.Config sqlValidatorConfig;
        private SqlToRelConverter.Config sqlToRelConverterConfig;
        private @Nullable SchemaPlus defaultSchema;
        private @Nullable RexExecutor executor;
        private @Nullable RelOptCostFactory costFactory;
        private RelDataTypeSystem typeSystem;
        private boolean evolveLattice;
        private SqlStatisticProvider statisticProvider;
        private @Nullable RelOptTable.ViewExpander viewExpander;

        private ConfigBuilder() {
            this.convertletTable = StandardConvertletTable.INSTANCE;
            this.operatorTable = SqlStdOperatorTable.instance();
            this.programs = ImmutableList.of();
            this.context = Contexts.empty();
            this.parserConfig = SqlParser.Config.DEFAULT;
            this.sqlValidatorConfig = SqlValidator.Config.DEFAULT;
            this.sqlToRelConverterConfig = SqlToRelConverter.config();
            this.typeSystem = RelDataTypeSystem.DEFAULT;
            this.evolveLattice = false;
            this.statisticProvider = QuerySqlStatisticProvider.SILENT_CACHING_INSTANCE;
        }

        private ConfigBuilder(FrameworkConfig config) {
            this.convertletTable = config.getConvertletTable();
            this.operatorTable = config.getOperatorTable();
            this.programs = config.getPrograms();
            this.context = config.getContext();
            this.traitDefs = config.getTraitDefs();
            this.parserConfig = config.getParserConfig();
            this.sqlValidatorConfig = config.getSqlValidatorConfig();
            this.sqlToRelConverterConfig = config.getSqlToRelConverterConfig();
            this.defaultSchema = config.getDefaultSchema();
            this.executor = config.getExecutor();
            this.costFactory = config.getCostFactory();
            this.typeSystem = config.getTypeSystem();
            this.evolveLattice = config.isEvolveLattice();
            this.statisticProvider = config.getStatisticProvider();
        }

        public FrameworkConfig build() {
            return new StdFrameworkConfig(this.context, this.convertletTable, this.operatorTable, this.programs, this.traitDefs, this.parserConfig, this.sqlValidatorConfig, this.sqlToRelConverterConfig, this.defaultSchema, this.costFactory, this.typeSystem, this.executor, this.evolveLattice, this.statisticProvider, this.viewExpander);
        }

        public ConfigBuilder context(Context c) {
            this.context = Objects.requireNonNull(c, "c");
            return this;
        }

        public ConfigBuilder executor(RexExecutor executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public ConfigBuilder convertletTable(SqlRexConvertletTable convertletTable) {
            this.convertletTable = Objects.requireNonNull(convertletTable, "convertletTable");
            return this;
        }

        public ConfigBuilder operatorTable(SqlOperatorTable operatorTable) {
            this.operatorTable = Objects.requireNonNull(operatorTable, "operatorTable");
            return this;
        }

        public ConfigBuilder traitDefs(@Nullable List<RelTraitDef> traitDefs) {
            this.traitDefs = traitDefs == null ? null : ImmutableList.copyOf(traitDefs);
            return this;
        }

        public ConfigBuilder traitDefs(RelTraitDef ... traitDefs) {
            this.traitDefs = ImmutableList.copyOf(traitDefs);
            return this;
        }

        public ConfigBuilder parserConfig(SqlParser.Config parserConfig) {
            this.parserConfig = Objects.requireNonNull(parserConfig, "parserConfig");
            return this;
        }

        public ConfigBuilder sqlValidatorConfig(SqlValidator.Config sqlValidatorConfig) {
            this.sqlValidatorConfig = Objects.requireNonNull(sqlValidatorConfig, "sqlValidatorConfig");
            return this;
        }

        public ConfigBuilder sqlToRelConverterConfig(SqlToRelConverter.Config sqlToRelConverterConfig) {
            this.sqlToRelConverterConfig = Objects.requireNonNull(sqlToRelConverterConfig, "sqlToRelConverterConfig");
            return this;
        }

        public ConfigBuilder defaultSchema(SchemaPlus defaultSchema) {
            this.defaultSchema = defaultSchema;
            return this;
        }

        public ConfigBuilder costFactory(RelOptCostFactory costFactory) {
            this.costFactory = costFactory;
            return this;
        }

        public ConfigBuilder ruleSets(RuleSet ... ruleSets) {
            return this.programs(Programs.listOf(ruleSets));
        }

        public ConfigBuilder ruleSets(List<RuleSet> ruleSets) {
            return this.programs(Programs.listOf(Objects.requireNonNull(ruleSets, "ruleSets")));
        }

        public ConfigBuilder programs(List<Program> programs) {
            this.programs = ImmutableList.copyOf(programs);
            return this;
        }

        public ConfigBuilder programs(Program ... programs) {
            this.programs = ImmutableList.copyOf(programs);
            return this;
        }

        public ConfigBuilder typeSystem(RelDataTypeSystem typeSystem) {
            this.typeSystem = Objects.requireNonNull(typeSystem, "typeSystem");
            return this;
        }

        public ConfigBuilder evolveLattice(boolean evolveLattice) {
            this.evolveLattice = evolveLattice;
            return this;
        }

        public ConfigBuilder statisticProvider(SqlStatisticProvider statisticProvider) {
            this.statisticProvider = Objects.requireNonNull(statisticProvider, "statisticProvider");
            return this;
        }

        public ConfigBuilder viewExpander(RelOptTable.ViewExpander viewExpander) {
            this.viewExpander = viewExpander;
            return this;
        }
    }

    @Deprecated
    public static abstract class PrepareAction<R>
    implements BasePrepareAction<R> {
        private final FrameworkConfig config;

        protected PrepareAction() {
            this.config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        }

        protected PrepareAction(FrameworkConfig config) {
            this.config = config;
        }

        public FrameworkConfig getConfig() {
            return this.config;
        }
    }

    @FunctionalInterface
    public static interface BasePrepareAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3, CalciteServerStatement var4);
    }

    @FunctionalInterface
    public static interface PlannerAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3);
    }
}

