/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.calcite.linq4j.Extensions;
import org.apache.calcite.linq4j.function.Function;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.linq4j.tree.AbstractNode;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.CallSiteBinder;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.ConditionalExpression;
import org.apache.calcite.linq4j.tree.ConditionalStatement;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.ConstantUntypedNull;
import org.apache.calcite.linq4j.tree.ConstructorDeclaration;
import org.apache.calcite.linq4j.tree.DeclarationStatement;
import org.apache.calcite.linq4j.tree.DefaultExpression;
import org.apache.calcite.linq4j.tree.DynamicExpression;
import org.apache.calcite.linq4j.tree.ElementInit;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionVisitor;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.FieldDeclaration;
import org.apache.calcite.linq4j.tree.ForEachStatement;
import org.apache.calcite.linq4j.tree.ForStatement;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.GotoExpressionKind;
import org.apache.calcite.linq4j.tree.GotoStatement;
import org.apache.calcite.linq4j.tree.IndexExpression;
import org.apache.calcite.linq4j.tree.InvocationExpression;
import org.apache.calcite.linq4j.tree.LabelStatement;
import org.apache.calcite.linq4j.tree.LabelTarget;
import org.apache.calcite.linq4j.tree.LambdaExpression;
import org.apache.calcite.linq4j.tree.ListInitExpression;
import org.apache.calcite.linq4j.tree.MemberAssignment;
import org.apache.calcite.linq4j.tree.MemberBinding;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MemberInitExpression;
import org.apache.calcite.linq4j.tree.MemberListBinding;
import org.apache.calcite.linq4j.tree.MemberMemberBinding;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.NewArrayExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.PseudoField;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.SwitchCase;
import org.apache.calcite.linq4j.tree.SwitchStatement;
import org.apache.calcite.linq4j.tree.TernaryExpression;
import org.apache.calcite.linq4j.tree.ThrowStatement;
import org.apache.calcite.linq4j.tree.TryStatement;
import org.apache.calcite.linq4j.tree.TypeBinaryExpression;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.linq4j.tree.UnaryExpression;
import org.apache.calcite.linq4j.tree.Visitor;
import org.apache.calcite.linq4j.tree.WhileStatement;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Expressions {
    private Expressions() {
    }

    public static String toString(List<? extends Node> expressions, String sep, boolean generics) {
        ExpressionWriter writer = new ExpressionWriter(generics);
        for (Node node : expressions) {
            writer.write(node);
            writer.append(sep);
        }
        return writer.toString();
    }

    public static String toString(Node expression) {
        return Expressions.toString(Collections.singletonList(expression), "", true);
    }

    public static BinaryExpression add(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Add, left, right);
    }

    public static BinaryExpression add(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression addAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.AddAssign, left, right);
    }

    public static BinaryExpression addAssign(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression addAssign(Expression left, Expression right, Method method, LambdaExpression lambdaLeft, LambdaExpression lambdaRight) {
        throw Extensions.todo();
    }

    public static BinaryExpression addAssignChecked(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.AddAssignChecked, left, right);
    }

    public static BinaryExpression addAssignChecked(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression addAssignChecked(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static BinaryExpression addChecked(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.AddChecked, left, right);
    }

    public static BinaryExpression addChecked(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression and(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.And, left, right);
    }

    public static BinaryExpression and(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression andAlso(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.AndAlso, left, right);
    }

    public static BinaryExpression andAlso(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression andAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.AndAssign, left, right);
    }

    public static BinaryExpression andAssign(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression andAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static IndexExpression arrayIndex(Expression array, Expression indexExpression) {
        return new IndexExpression(array, Collections.singletonList(indexExpression));
    }

    public static UnaryExpression arrayLength(Expression array) {
        throw Extensions.todo();
    }

    public static BinaryExpression assign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Assign, left, right);
    }

    public static MemberAssignment bind(Member member, Expression right) {
        throw Extensions.todo();
    }

    public static MemberAssignment bind(Method method, Expression expression) {
        throw Extensions.todo();
    }

    public static BlockStatement block(Iterable<? extends Statement> statements) {
        return Expressions.block((Type)null, statements);
    }

    public static BlockStatement block(Statement ... statements) {
        return Expressions.block(Expressions.toList(statements));
    }

    public static BlockStatement block(@Nullable Type type, Iterable<? extends Statement> expressions) {
        List<Statement> list = Expressions.toList(expressions);
        if (type == null) {
            type = list.size() > 0 ? list.get(list.size() - 1).getType() : Void.TYPE;
        }
        return new BlockStatement(list, type);
    }

    public static BlockStatement block(Type type, Statement ... statements) {
        return Expressions.block(type, Expressions.toList(statements));
    }

    public static GotoStatement break_(LabelTarget labelTarget) {
        return new GotoStatement(GotoExpressionKind.Break, null, null);
    }

    public static GotoStatement break_(LabelTarget labelTarget, Expression expression) {
        return new GotoStatement(GotoExpressionKind.Break, null, expression);
    }

    public static GotoStatement break_(LabelTarget labelTarget, Type type) {
        throw Extensions.todo();
    }

    public static GotoStatement break_(LabelTarget labelTarget, Expression expression, Type type) {
        throw Extensions.todo();
    }

    public static MethodCallExpression call(Method method, Iterable<? extends Expression> arguments) {
        return new MethodCallExpression(method, null, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Method method, Expression ... arguments) {
        return new MethodCallExpression(method, null, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(@Nullable Expression expression, Method method, Iterable<? extends Expression> arguments) {
        return new MethodCallExpression(method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(@Nullable Expression expression, Method method, Expression ... arguments) {
        return new MethodCallExpression(method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type returnType, @Nullable Expression expression, Method method, Iterable<? extends Expression> arguments) {
        return new MethodCallExpression(returnType, method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type returnType, @Nullable Expression expression, Method method, Expression ... arguments) {
        return new MethodCallExpression(returnType, method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Expression target, String methodName, Iterable<? extends Expression> arguments) {
        Method method;
        try {
            method = Types.toClass(target.getType()).getMethod(methodName, Types.toClassArray(arguments));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("while resolving method '" + methodName + "' in class " + target.getType(), e);
        }
        return Expressions.call(target, method, arguments);
    }

    public static MethodCallExpression call(Expression target, String methodName, Expression ... arguments) {
        return Expressions.call(target, methodName, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type type, String methodName, Iterable<? extends Expression> arguments) {
        Method method = Types.lookupMethod(Types.toClass(type), methodName, Types.toClassArray(arguments));
        return new MethodCallExpression(method, null, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type type, String methodName, Expression ... arguments) {
        return Expressions.call(type, methodName, Expressions.toList(arguments));
    }

    public static CatchBlock catch_(ParameterExpression parameter, Statement statement) {
        return new CatchBlock(parameter, statement);
    }

    public static void clearDebugInfo() {
        throw Extensions.todo();
    }

    public static BinaryExpression coalesce(Expression left, Expression right) {
        throw Extensions.todo();
    }

    public static BinaryExpression coalesce(Expression left, Expression right, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static Expression condition(Expression test, Expression ifTrue, Expression ifFalse) {
        return Expressions.makeTernary(ExpressionType.Conditional, test, ifTrue, ifFalse);
    }

    public static boolean isConstantNull(Expression e) {
        return e instanceof ConstantExpression && ((ConstantExpression)e).value == null;
    }

    public static ConditionalExpression condition(Expression test, Expression ifTrue, Expression ifFalse, Type type) {
        return new ConditionalExpression(Arrays.asList(test, ifFalse, ifTrue), type);
    }

    public static ConstantExpression constant(@Nullable Object value) {
        if (value == null) {
            return ConstantUntypedNull.INSTANCE;
        }
        Class type = Primitive.unbox(value.getClass());
        return new ConstantExpression(type, value);
    }

    public static ConstantExpression constant(@Nullable Object value, Type type) {
        if (value != null && type instanceof Class) {
            Class clazz = (Class)type;
            Primitive primitive = Primitive.ofBoxOr(clazz);
            if (primitive != null) {
                clazz = Objects.requireNonNull(primitive.boxClass, "boxClass");
            }
            if ((clazz != Float.class && clazz != Double.class || !(value instanceof BigDecimal)) && !clazz.isInstance(value)) {
                String stringValue = String.valueOf(value);
                if (type == BigDecimal.class) {
                    value = new BigDecimal(stringValue);
                }
                if (type == BigInteger.class) {
                    value = new BigInteger(stringValue);
                }
                if (primitive != null) {
                    value = primitive.parse(stringValue);
                }
            }
        }
        return new ConstantExpression(type, value);
    }

    public static GotoStatement continue_(LabelTarget labelTarget) {
        return new GotoStatement(GotoExpressionKind.Continue, null, null);
    }

    public static GotoStatement continue_(LabelTarget labelTarget, Type type) {
        throw Extensions.todo();
    }

    public static UnaryExpression convert_(Expression expression, Type type) {
        return new UnaryExpression(ExpressionType.Convert, type, expression);
    }

    public static UnaryExpression convert_(Expression expression, Type type, Method method) {
        throw Extensions.todo();
    }

    public static UnaryExpression convertChecked(Expression expression, Type type) {
        throw Extensions.todo();
    }

    public static UnaryExpression convertChecked_(Expression expression, Type type, Method method) {
        throw Extensions.todo();
    }

    public static void debugInfo() {
        throw Extensions.todo();
    }

    public static UnaryExpression decrement(Expression expression) {
        throw Extensions.todo();
    }

    public static UnaryExpression decrement(Expression expression, Method method) {
        throw Extensions.todo();
    }

    public static DefaultExpression default_() {
        throw Extensions.todo();
    }

    public static BinaryExpression divide(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Divide, left, right);
    }

    public static BinaryExpression divide(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.Divide, left, right, Expressions.shouldLift(left, right, method), method);
    }

    public static BinaryExpression divideAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.DivideAssign, left, right);
    }

    public static BinaryExpression divideAssign(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression divideAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static DynamicExpression dynamic(CallSiteBinder binder, Type type, Iterable<? extends Expression> expressions) {
        throw Extensions.todo();
    }

    public static DynamicExpression dynamic(CallSiteBinder binder, Type type, Expression ... expression) {
        throw Extensions.todo();
    }

    public static ElementInit elementInit(Method method, Iterable<? extends Expression> expressions) {
        throw Extensions.todo();
    }

    public static ElementInit elementInit(Method method, Expression ... expressions) {
        throw Extensions.todo();
    }

    public static DefaultExpression empty() {
        throw Extensions.todo();
    }

    public static BinaryExpression equal(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Equal, left, right);
    }

    public static BinaryExpression equal(Expression expression0, Expression expression1, boolean liftToNull, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression exclusiveOr(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.ExclusiveOr, left, right);
    }

    public static BinaryExpression exclusiveOr(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression exclusiveOrAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.ExclusiveOrAssign, left, right);
    }

    public static BinaryExpression exclusiveOrAssign(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression exclusiveOrAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static MemberExpression field(@Nullable Expression expression, Field field) {
        return Expressions.makeMemberAccess(expression, Types.field(field));
    }

    public static MemberExpression field(@Nullable Expression expression, PseudoField field) {
        return Expressions.makeMemberAccess(expression, field);
    }

    public static MemberExpression field(Expression expression, String fieldName) {
        PseudoField field = Types.getField(fieldName, expression.getType());
        return Expressions.makeMemberAccess(expression, field);
    }

    public static MemberExpression field(@Nullable Expression expression, Type type, String fieldName) {
        PseudoField field = Types.getField(fieldName, type);
        return Expressions.makeMemberAccess(expression, field);
    }

    public static Class getActionType(Class ... typeArgs) {
        throw Extensions.todo();
    }

    public static Class getDelegateType(Class ... typeArgs) {
        throw Extensions.todo();
    }

    public static Class getFuncType(Class ... typeArgs) {
        throw Extensions.todo();
    }

    public static GotoStatement goto_(LabelTarget labelTarget) {
        throw Extensions.todo();
    }

    public static GotoStatement goto_(LabelTarget labelTarget, Expression expression) {
        throw Extensions.todo();
    }

    public static GotoStatement goto_(LabelTarget labelTarget, Type type) {
        throw Extensions.todo();
    }

    public static GotoStatement goto_(LabelTarget labelTarget, Expression expression, Type type) {
        throw Extensions.todo();
    }

    public static BinaryExpression greaterThan(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.GreaterThan, left, right);
    }

    public static BinaryExpression greaterThan(Expression left, Expression right, boolean liftToNull, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression greaterThanOrEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.GreaterThanOrEqual, left, right);
    }

    public static BinaryExpression greaterThanOrEqual(Expression left, Expression right, boolean liftToNull, Method method) {
        throw Extensions.todo();
    }

    public static ConditionalStatement ifThen(Expression test, Node ifTrue) {
        return new ConditionalStatement(Arrays.asList(test, ifTrue));
    }

    public static ConditionalStatement ifThenElse(Expression test, Node ifTrue, Node ifFalse) {
        return new ConditionalStatement(Arrays.asList(test, ifTrue, ifFalse));
    }

    public static ConditionalStatement ifThenElse(Expression test, Node ... nodes) {
        return Expressions.ifThenElse(new FluentArrayList<Expression>().append(test).appendAll((Expression[])nodes));
    }

    public static ConditionalStatement ifThenElse(Iterable<? extends Node> nodes) {
        List<Node> list = Expressions.toList(nodes);
        assert (list.size() >= 2) : "At least one test and one statement is required";
        return new ConditionalStatement(list);
    }

    public static UnaryExpression increment(Expression expression) {
        throw Extensions.todo();
    }

    public static UnaryExpression increment(Expression expression, Method method) {
        throw Extensions.todo();
    }

    public static InvocationExpression invoke(Expression expression, Iterable<? extends Expression> arguments) {
        throw Extensions.todo();
    }

    public static InvocationExpression invoke(Expression expression, Expression ... arguments) {
        throw Extensions.todo();
    }

    public static UnaryExpression isFalse(Expression expression) {
        throw Extensions.todo();
    }

    public static UnaryExpression isFalse(Expression expression, Method method) {
        throw Extensions.todo();
    }

    public static UnaryExpression isTrue(Expression expression) {
        throw Extensions.todo();
    }

    public static UnaryExpression isTrue(Expression expression, Method method) {
        throw Extensions.todo();
    }

    public static LabelTarget label() {
        throw Extensions.todo();
    }

    public static LabelStatement label(LabelTarget labelTarget) {
        throw Extensions.todo();
    }

    public static LabelTarget label(String name) {
        throw Extensions.todo();
    }

    public static LabelTarget label(Type type) {
        throw Extensions.todo();
    }

    public static LabelStatement label(LabelTarget labelTarget, Expression expression) {
        throw Extensions.todo();
    }

    public static LabelTarget label(Type type, String name) {
        throw Extensions.todo();
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(F function) {
        return new FunctionExpression<F>(function);
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(BlockStatement body, Iterable<? extends ParameterExpression> parameters) {
        List<ParameterExpression> parameterList = Expressions.toList(parameters);
        Class type = Expressions.deduceType(parameterList, body.getType());
        return new FunctionExpression(type, body, parameterList);
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(BlockStatement body, ParameterExpression ... parameters) {
        return Expressions.lambda(body, Expressions.toList(parameters));
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(Expression body, Iterable<? extends ParameterExpression> parameters) {
        return Expressions.lambda(Blocks.toFunctionBlock(body), parameters);
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(Expression body, ParameterExpression ... parameters) {
        return Expressions.lambda(Blocks.toFunctionBlock(body), Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, BlockStatement body, Iterable<? extends ParameterExpression> parameters) {
        return new FunctionExpression<F>(type, body, Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, BlockStatement body, ParameterExpression ... parameters) {
        return Expressions.lambda(type, body, Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, Expression body, Iterable<? extends ParameterExpression> parameters) {
        return Expressions.lambda(type, Blocks.toFunctionBlock(body), Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, Expression body, ParameterExpression ... parameters) {
        return Expressions.lambda(type, Blocks.toFunctionBlock(body), Expressions.toList(parameters));
    }

    public static BinaryExpression leftShift(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.LeftShift, left, right);
    }

    public static BinaryExpression leftShift(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression leftShiftAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.LeftShiftAssign, left, right);
    }

    public static BinaryExpression leftShiftAssign(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression leftShiftAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static BinaryExpression lessThan(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.LessThan, left, right);
    }

    public static BinaryExpression lessThan(Expression left, Expression right, boolean liftToNull, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression lessThanOrEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.LessThanOrEqual, left, right);
    }

    public static BinaryExpression lessThanOrEqual(Expression left, Expression right, boolean liftToNull, Method method) {
        throw Extensions.todo();
    }

    public static MemberListBinding listBind(Member member, Iterable<? extends ElementInit> elementInits) {
        throw Extensions.todo();
    }

    public static MemberListBinding listBind(Member member, ElementInit ... elementInits) {
        throw Extensions.todo();
    }

    public static MemberListBinding listBind(Method method, Iterable<? extends ElementInit> elementInits) {
        throw Extensions.todo();
    }

    public static MemberListBinding listBind(Method method, ElementInit ... elementInits) {
        throw Extensions.todo();
    }

    public static ListInitExpression listInit(NewExpression newExpression, Iterable<? extends ElementInit> elementInits) {
        throw Extensions.todo();
    }

    public static ListInitExpression listInit(NewExpression newExpression, ElementInit ... elementInits) {
        throw Extensions.todo();
    }

    public static ListInitExpression listInitE(NewExpression newExpression, Iterable<? extends Expression> arguments) {
        throw Extensions.todo();
    }

    public static ListInitExpression listInit(NewExpression newExpression, Expression ... arguments) {
        throw Extensions.todo();
    }

    public static ListInitExpression listInit(NewExpression newExpression, Method method, Iterable<? extends Expression> arguments) {
        throw Extensions.todo();
    }

    public static ListInitExpression listInit(NewExpression newExpression, Method method, Expression ... arguments) {
        throw Extensions.todo();
    }

    public static ForStatement for_(Iterable<? extends DeclarationStatement> declarations, @Nullable Expression condition, @Nullable Expression post, Statement body) {
        return new ForStatement(Expressions.toList(declarations), condition, post, body);
    }

    public static ForStatement for_(DeclarationStatement declaration, @Nullable Expression condition, @Nullable Expression post, Statement body) {
        return new ForStatement(Collections.singletonList(declaration), condition, post, body);
    }

    public static ForEachStatement forEach(ParameterExpression parameter, Expression iterable, Statement body) {
        return new ForEachStatement(parameter, iterable, body);
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right) {
        Type type;
        switch (binaryType) {
            case Equal: 
            case NotEqual: 
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case AndAlso: 
            case OrElse: {
                type = Boolean.TYPE;
                break;
            }
            default: {
                type = Expressions.larger(left.type, right.type);
            }
        }
        return new BinaryExpression(binaryType, type, left, right);
    }

    public static Expression box(Expression expression, Primitive primitive) {
        return Expressions.call((Type)Objects.requireNonNull(primitive.boxClass), "valueOf", expression);
    }

    public static Expression box(Expression expression) {
        Primitive primitive = Primitive.of(expression.getType());
        if (primitive == null) {
            return expression;
        }
        return Expressions.box(expression, primitive);
    }

    public static Expression unbox(Expression expression, Primitive primitive) {
        return Expressions.call(expression, Objects.requireNonNull(primitive.primitiveName) + "Value", new Expression[0]);
    }

    public static Expression unbox(Expression expression) {
        Primitive primitive = Primitive.ofBox(expression.getType());
        if (primitive == null) {
            return expression;
        }
        return Expressions.unbox(expression, primitive);
    }

    private static Type larger(Type type0, Type type1) {
        if (type0 == Double.TYPE || type0 == Double.class || type1 == Double.TYPE || type1 == Double.class) {
            return Double.TYPE;
        }
        if (type0 == Float.TYPE || type0 == Float.class || type1 == Float.TYPE || type1 == Float.class) {
            return Float.TYPE;
        }
        if (type0 == Long.TYPE || type0 == Long.class || type1 == Long.TYPE || type1 == Long.class) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right, boolean liftToNull, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right, boolean liftToNull, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static TernaryExpression makeTernary(ExpressionType ternaryType, Expression e0, Expression e1, Expression e2) {
        Type type;
        switch (ternaryType) {
            case Conditional: {
                if (e1 instanceof ConstantUntypedNull) {
                    type = Primitive.box(e2.getType());
                    if (e1.getType() == type) break;
                    e1 = Expressions.constant(null, type);
                    break;
                }
                if (e2 instanceof ConstantUntypedNull) {
                    type = Primitive.box(e1.getType());
                    if (e2.getType() == type) break;
                    e2 = Expressions.constant(null, type);
                    break;
                }
                type = Types.gcd(e1.getType(), e2.getType());
                break;
            }
            default: {
                type = e1.getType();
            }
        }
        return new TernaryExpression(ternaryType, type, e0, e1, e2);
    }

    public static CatchBlock makeCatchBlock(Type type, ParameterExpression variable, Expression body, Expression filter) {
        throw Extensions.todo();
    }

    public static DynamicExpression makeDynamic(Type type, CallSiteBinder binder, Iterable<? extends Expression> arguments) {
        throw Extensions.todo();
    }

    public static DynamicExpression makeDynamic(Type type, CallSiteBinder binder, Expression ... arguments) {
        throw Extensions.todo();
    }

    public static GotoStatement makeGoto(GotoExpressionKind kind, LabelTarget target, Expression value, Type type) {
        throw Extensions.todo();
    }

    public static MemberExpression makeMemberAccess(@Nullable Expression expression, PseudoField member) {
        return new MemberExpression(expression, member);
    }

    public static TryStatement makeTry(Type type, Expression body, Expression finally_, Expression fault, Iterable<? extends CatchBlock> handlers) {
        throw Extensions.todo();
    }

    public static TryStatement makeTry(Type type, Expression body, Expression finally_, Expression fault, CatchBlock ... handlers) {
        throw Extensions.todo();
    }

    public static UnaryExpression makeUnary(ExpressionType expressionType, Expression expression) {
        Class<Integer> type = expression.getType();
        switch (expressionType) {
            case Negate: {
                if (type != Byte.TYPE && type != Short.TYPE) break;
                type = Integer.TYPE;
                break;
            }
        }
        return new UnaryExpression(expressionType, type, expression);
    }

    public static UnaryExpression makeUnary(ExpressionType expressionType, Expression expression, Type type, @Nullable Method method) {
        assert (type != null);
        return new UnaryExpression(expressionType, type, expression);
    }

    public static MemberMemberBinding memberBind(Member member, Iterable<? extends MemberBinding> bindings) {
        throw Extensions.todo();
    }

    public static MemberMemberBinding memberBind(Member member, MemberBinding ... bindings) {
        return Expressions.memberBind(member, Expressions.toList(bindings));
    }

    public static MemberMemberBinding memberBind(Method method, Iterable<? extends MemberBinding> bindings) {
        throw Extensions.todo();
    }

    public static MemberMemberBinding memberBind(Method method, MemberBinding ... bindings) {
        return Expressions.memberBind(method, Expressions.toList(bindings));
    }

    public static MemberInitExpression memberInit(NewExpression newExpression, Iterable<? extends MemberBinding> bindings) {
        throw Extensions.todo();
    }

    public static MemberInitExpression memberInit(NewExpression newExpression, MemberBinding ... bindings) {
        return Expressions.memberInit(newExpression, Expressions.toList(bindings));
    }

    public static MethodDeclaration methodDecl(int modifier, Type resultType, String name, Iterable<? extends ParameterExpression> parameters, BlockStatement body) {
        return new MethodDeclaration(modifier, name, resultType, Expressions.toList(parameters), body);
    }

    public static ConstructorDeclaration constructorDecl(int modifier, Type declaredAgainst, Iterable<? extends ParameterExpression> parameters, BlockStatement body) {
        return new ConstructorDeclaration(modifier, declaredAgainst, Expressions.toList(parameters), body);
    }

    public static FieldDeclaration fieldDecl(int modifier, ParameterExpression parameter, @Nullable Expression initializer) {
        return new FieldDeclaration(modifier, parameter, initializer);
    }

    public static FieldDeclaration fieldDecl(int modifier, ParameterExpression parameter) {
        return new FieldDeclaration(modifier, parameter, null);
    }

    public static ClassDeclaration classDecl(int modifier, String name, @Nullable Type extended, List<Type> implemented, List<MemberDeclaration> memberDeclarations) {
        return new ClassDeclaration(modifier, name, extended, implemented, memberDeclarations);
    }

    public static BinaryExpression modulo(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Modulo, left, right);
    }

    public static BinaryExpression modulo(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.Modulo, left, right, Expressions.shouldLift(left, right, method), method);
    }

    public static BinaryExpression moduloAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.ModuloAssign, left, right);
    }

    public static BinaryExpression moduloAssign(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.ModuloAssign, left, right, false, method);
    }

    public static BinaryExpression moduloAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.ModuloAssign, left, right, false, method, lambdaExpression);
    }

    public static BinaryExpression multiply(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Multiply, left, right);
    }

    public static BinaryExpression multiply(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.Multiply, left, right, Expressions.shouldLift(left, right, method), method);
    }

    public static BinaryExpression multiplyAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.MultiplyAssign, left, right);
    }

    public static BinaryExpression multiplyAssign(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.MultiplyAssign, left, right, false, method);
    }

    public static BinaryExpression multiplyAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.MultiplyAssign, left, right, false, method, lambdaExpression);
    }

    public static BinaryExpression multiplyAssignChecked(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.MultiplyAssignChecked, left, right);
    }

    public static BinaryExpression multiplyAssignChecked(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.MultiplyAssignChecked, left, right, false, method);
    }

    public static BinaryExpression multiplyAssignChecked(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.MultiplyAssignChecked, left, right, false, method, lambdaExpression);
    }

    public static BinaryExpression multiplyChecked(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.MultiplyChecked, left, right);
    }

    public static BinaryExpression multiplyChecked(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.MultiplyChecked, left, right, Expressions.shouldLift(left, right, method), method);
    }

    public static UnaryExpression negate(Expression expression) {
        return Expressions.makeUnary(ExpressionType.Negate, expression);
    }

    public static UnaryExpression negate(Expression expression, Method method) {
        return Expressions.negate(expression);
    }

    public static UnaryExpression negateChecked(Expression expression) {
        return Expressions.makeUnary(ExpressionType.NegateChecked, expression);
    }

    public static UnaryExpression negateChecked(Expression expression, Method method) {
        throw new UnsupportedOperationException("not implemented");
    }

    public static NewExpression new_(Constructor constructor) {
        return Expressions.new_(constructor.getDeclaringClass(), ImmutableList.of());
    }

    public static NewExpression new_(Type type) {
        return Expressions.new_(type, ImmutableList.of());
    }

    public static NewExpression new_(Type type, Iterable<? extends Expression> arguments) {
        return new NewExpression(type, Expressions.toList(arguments), null);
    }

    public static NewExpression new_(Type type, Expression ... arguments) {
        return new NewExpression(type, Expressions.toList(arguments), null);
    }

    public static NewExpression new_(Type type, Iterable<? extends Expression> arguments, @Nullable Iterable<? extends MemberDeclaration> memberDeclarations) {
        return new NewExpression(type, Expressions.toList(arguments), memberDeclarations == null ? null : Expressions.toList(memberDeclarations));
    }

    public static NewExpression new_(Type type, Iterable<? extends Expression> arguments, MemberDeclaration ... memberDeclarations) {
        return new NewExpression(type, Expressions.toList(arguments), Expressions.toList(memberDeclarations));
    }

    public static NewExpression new_(Constructor constructor, Iterable<? extends Expression> expressions) {
        return new NewExpression(constructor.getDeclaringClass(), Expressions.toList(expressions), null);
    }

    public static NewExpression new_(Constructor constructor, Expression ... expressions) {
        return new NewExpression(constructor.getDeclaringClass(), Expressions.toList(expressions), null);
    }

    public static NewExpression new_(Constructor constructor, Iterable<? extends Expression> expressions, Iterable<? extends MemberDeclaration> memberDeclarations) {
        return Expressions.new_(constructor.getDeclaringClass(), Expressions.toList(expressions), Expressions.toList(memberDeclarations));
    }

    public static NewExpression new_(Constructor constructor, Iterable<? extends Expression> expressions, MemberDeclaration ... memberDeclarations) {
        return Expressions.new_(constructor.getDeclaringClass(), Expressions.toList(expressions), Expressions.toList(memberDeclarations));
    }

    public static NewArrayExpression newArrayBounds(Type type, int dimension, @Nullable Expression bound) {
        return new NewArrayExpression(type, dimension, bound, null);
    }

    public static NewArrayExpression newArrayInit(Type type, Iterable<? extends Expression> expressions) {
        return new NewArrayExpression(type, 1, null, Expressions.toList(expressions));
    }

    public static NewArrayExpression newArrayInit(Type type, Expression ... expressions) {
        return new NewArrayExpression(type, 1, null, Expressions.toList(expressions));
    }

    public static NewArrayExpression newArrayInit(Type type, int dimension, Iterable<? extends Expression> expressions) {
        return new NewArrayExpression(type, dimension, null, Expressions.toList(expressions));
    }

    public static NewArrayExpression newArrayInit(Type type, int dimension, Expression ... expressions) {
        return new NewArrayExpression(type, dimension, null, Expressions.toList(expressions));
    }

    public static UnaryExpression not(Expression expression) {
        return Expressions.makeUnary(ExpressionType.Not, expression);
    }

    public static UnaryExpression not(Expression expression, Method method) {
        return Expressions.not(expression);
    }

    public static BinaryExpression notEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.NotEqual, left, right);
    }

    public static BinaryExpression notEqual(Expression left, Expression right, boolean liftToNull, Method method) {
        return Expressions.makeBinary(ExpressionType.NotEqual, left, right, liftToNull, method);
    }

    public static UnaryExpression onesComplement(Expression expression) {
        return Expressions.makeUnary(ExpressionType.OnesComplement, expression);
    }

    public static UnaryExpression onesComplement(Expression expression, Method method) {
        return Expressions.makeUnary(ExpressionType.OnesComplement, expression, expression.getType(), method);
    }

    public static BinaryExpression or(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Or, left, right);
    }

    public static BinaryExpression or(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.Or, left, right, false, method);
    }

    public static BinaryExpression orAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.OrAssign, left, right);
    }

    public static BinaryExpression orAssign(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.OrAssign, left, right);
    }

    public static BinaryExpression orAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.OrAssign, left, right, false, method, lambdaExpression);
    }

    public static BinaryExpression orElse(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.OrElse, left, right);
    }

    public static BinaryExpression orElse(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.OrElse, left, right, false, method);
    }

    public static ParameterExpression parameter(Type type) {
        return new ParameterExpression(type);
    }

    public static ParameterExpression parameter(Type type, String name) {
        return new ParameterExpression(0, type, name);
    }

    public static ParameterExpression parameter(int modifiers, Type type, String name) {
        return new ParameterExpression(modifiers, type, name);
    }

    public static UnaryExpression postDecrementAssign(Expression expression) {
        return Expressions.makeUnary(ExpressionType.PostDecrementAssign, expression);
    }

    public static UnaryExpression postDecrementAssign(Expression expression, Method method) {
        return Expressions.makeUnary(ExpressionType.PostDecrementAssign, expression, expression.getType(), method);
    }

    public static UnaryExpression postIncrementAssign(Expression expression) {
        return Expressions.makeUnary(ExpressionType.PostIncrementAssign, expression);
    }

    public static UnaryExpression postIncrementAssign(Expression expression, Method method) {
        return Expressions.makeUnary(ExpressionType.PostIncrementAssign, expression, expression.getType(), method);
    }

    public static BinaryExpression power(Expression left, Expression right) {
        throw Extensions.todo();
    }

    public static BinaryExpression power(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression powerAssign(Expression left, Expression right) {
        throw Extensions.todo();
    }

    public static BinaryExpression powerAssign(Expression left, Expression right, Method method) {
        throw Extensions.todo();
    }

    public static BinaryExpression powerAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        throw Extensions.todo();
    }

    public static UnaryExpression preDecrementAssign(Expression expression) {
        return Expressions.makeUnary(ExpressionType.PreDecrementAssign, expression);
    }

    public static UnaryExpression preDecrementAssign(Expression expression, Method method) {
        return Expressions.makeUnary(ExpressionType.PreDecrementAssign, expression, expression.getType(), method);
    }

    public static UnaryExpression preIncrementAssign(Expression expression) {
        return Expressions.makeUnary(ExpressionType.PreIncrementAssign, expression);
    }

    public static UnaryExpression preIncrementAssign(Expression expression, Method method) {
        return Expressions.makeUnary(ExpressionType.PreIncrementAssign, expression, expression.getType(), method);
    }

    public static MemberExpression property(Expression expression, Method method) {
        throw Extensions.todo();
    }

    public static MemberExpression property(Expression expression, PropertyInfo property) {
        throw Extensions.todo();
    }

    public static MemberExpression property(Expression expression, String name) {
        throw Extensions.todo();
    }

    public static IndexExpression property(Expression expression, PropertyInfo property, Iterable<? extends Expression> arguments) {
        throw Extensions.todo();
    }

    public static IndexExpression property(Expression expression, PropertyInfo property, Expression ... arguments) {
        throw Extensions.todo();
    }

    public static IndexExpression property(Expression expression, String name, Expression ... arguments) {
        throw Extensions.todo();
    }

    public static MemberExpression property(Expression expression, Type type, String name) {
        throw Extensions.todo();
    }

    public static MemberExpression propertyOrField(Expression expression, String propertyOfFieldName) {
        throw Extensions.todo();
    }

    public static UnaryExpression quote(Expression expression) {
        return Expressions.makeUnary(ExpressionType.Quote, expression);
    }

    public static Expression reduce(Expression expression) {
        throw Extensions.todo();
    }

    public static Expression reduceAndCheck(Expression expression) {
        throw Extensions.todo();
    }

    public static Expression reduceExtensions(Expression expression) {
        throw Extensions.todo();
    }

    public static Expression referenceEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Equal, left, right);
    }

    public static Expression referenceNotEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.NotEqual, left, right);
    }

    public static UnaryExpression rethrow() {
        throw Extensions.todo();
    }

    public static UnaryExpression rethrow(Type type) {
        throw Extensions.todo();
    }

    public static GotoStatement return_(LabelTarget labelTarget) {
        return Expressions.return_(labelTarget, (Expression)null);
    }

    public static GotoStatement return_(@Nullable LabelTarget labelTarget, @Nullable Expression expression) {
        return Expressions.makeGoto(GotoExpressionKind.Return, labelTarget, expression);
    }

    public static GotoStatement makeGoto(GotoExpressionKind kind, @Nullable LabelTarget labelTarget, @Nullable Expression expression) {
        return new GotoStatement(kind, labelTarget, expression);
    }

    public static GotoStatement return_(LabelTarget labelTarget, Type type) {
        throw Extensions.todo();
    }

    public static GotoStatement return_(LabelTarget labelTarget, Expression expression, Type type) {
        throw Extensions.todo();
    }

    public static BinaryExpression rightShift(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.RightShift, left, right);
    }

    public static BinaryExpression rightShift(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.RightShift, left, right, false, method);
    }

    public static BinaryExpression rightShiftAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.RightShiftAssign, left, right);
    }

    public static BinaryExpression rightShiftAssign(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.RightShiftAssign, left, right, false, method);
    }

    public static BinaryExpression rightShiftAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.RightShiftAssign, left, right, false, method, lambdaExpression);
    }

    public static RuntimeVariablesExpression runtimeVariables(Iterable<? extends ParameterExpression> expressions) {
        throw Extensions.todo();
    }

    public static RuntimeVariablesExpression runtimeVariables(ParameterExpression ... arguments) {
        throw Extensions.todo();
    }

    public static BinaryExpression subtract(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Subtract, left, right);
    }

    public static BinaryExpression subtract(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.Subtract, left, right, Expressions.shouldLift(left, right, method), method);
    }

    public static BinaryExpression subtractAssign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.SubtractAssign, left, right);
    }

    public static BinaryExpression subtractAssign(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.SubtractAssign, left, right, false, method);
    }

    public static BinaryExpression subtractAssign(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.SubtractAssign, left, right, false, method, lambdaExpression);
    }

    public static BinaryExpression subtractAssignChecked(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.SubtractAssignChecked, left, right);
    }

    public static BinaryExpression subtractAssignChecked(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.SubtractAssignChecked, left, right, false, method);
    }

    public static BinaryExpression subtractAssignChecked(Expression left, Expression right, Method method, LambdaExpression lambdaExpression) {
        return Expressions.makeBinary(ExpressionType.SubtractAssignChecked, left, right, false, method, lambdaExpression);
    }

    public static BinaryExpression subtractChecked(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.SubtractChecked, left, right);
    }

    public static BinaryExpression subtractChecked(Expression left, Expression right, Method method) {
        return Expressions.makeBinary(ExpressionType.SubtractChecked, left, right, Expressions.shouldLift(left, right, method), method);
    }

    public static SwitchStatement switch_(Expression switchValue, SwitchCase ... cases) {
        return Expressions.switch_(switchValue, null, null, Expressions.toList(cases));
    }

    public static SwitchStatement switch_(Expression switchValue, Expression defaultBody, SwitchCase ... cases) {
        return Expressions.switch_(switchValue, defaultBody, null, Expressions.toList(cases));
    }

    public static SwitchStatement switch_(Expression switchValue, Expression defaultBody, Method method, Iterable<? extends SwitchCase> cases) {
        throw Extensions.todo();
    }

    public static SwitchStatement switch_(Expression switchValue, Expression defaultBody, Method method, SwitchCase ... cases) {
        return Expressions.switch_(switchValue, defaultBody, method, Expressions.toList(cases));
    }

    public static SwitchStatement switch_(Type type, Expression switchValue, Expression defaultBody, Method method, Iterable<? extends SwitchCase> cases) {
        throw Extensions.todo();
    }

    public static SwitchStatement switch_(Type type, Expression switchValue, Expression defaultBody, Method method, SwitchCase ... cases) {
        return Expressions.switch_(type, switchValue, defaultBody, method, Expressions.toList(cases));
    }

    public static SwitchCase switchCase(Expression expression, Iterable<? extends Expression> body) {
        throw Extensions.todo();
    }

    public static SwitchCase switchCase(Expression expression, Expression ... body) {
        return Expressions.switchCase(expression, Expressions.toList(body));
    }

    public static SymbolDocumentInfo symbolDocument(String fileName) {
        throw Extensions.todo();
    }

    public static SymbolDocumentInfo symbolDocument(String fileName, UUID language) {
        throw Extensions.todo();
    }

    public static SymbolDocumentInfo symbolDocument(String fileName, UUID language, UUID vendor) {
        throw Extensions.todo();
    }

    public static SymbolDocumentInfo symbolDocument(String filename, UUID language, UUID vendor, UUID documentType) {
        throw Extensions.todo();
    }

    public static ThrowStatement throw_(Expression expression) {
        return new ThrowStatement(expression);
    }

    public static TryStatement tryCatch(Statement body, Iterable<? extends CatchBlock> handlers) {
        return new TryStatement(body, Expressions.toList(handlers), null);
    }

    public static TryStatement tryCatch(Statement body, CatchBlock ... handlers) {
        return new TryStatement(body, Expressions.toList(handlers), null);
    }

    public static TryStatement tryCatchFinally(Statement body, Iterable<? extends CatchBlock> handlers, Statement finally_) {
        return new TryStatement(body, Expressions.toList(handlers), finally_);
    }

    public static TryStatement tryCatchFinally(Statement body, Statement finally_, CatchBlock ... handlers) {
        return new TryStatement(body, Expressions.toList(handlers), finally_);
    }

    public static TryStatement tryFinally(Statement body, Statement finally_) {
        return new TryStatement(body, ImmutableList.of(), finally_);
    }

    public static UnaryExpression typeAs(Expression expression, Type type) {
        throw Extensions.todo();
    }

    public static TypeBinaryExpression typeEqual(Expression expression, Type type) {
        throw Extensions.todo();
    }

    public static TypeBinaryExpression typeIs(Expression expression, Type type) {
        return new TypeBinaryExpression(ExpressionType.TypeIs, expression, type);
    }

    public static UnaryExpression unaryPlus(Expression expression) {
        return Expressions.makeUnary(ExpressionType.UnaryPlus, expression);
    }

    public static UnaryExpression unaryPlus(Expression expression, Method method) {
        return Expressions.makeUnary(ExpressionType.UnaryPlus, expression, expression.getType(), method);
    }

    public static UnaryExpression unbox(Expression expression, Type type) {
        return new UnaryExpression(ExpressionType.Unbox, type, expression);
    }

    public static ParameterExpression variable(Type type) {
        throw Extensions.todo();
    }

    public static ParameterExpression variable(Type type, String name) {
        return new ParameterExpression(0, type, name);
    }

    public static Expression visitChildren(ExpressionVisitor visitor) {
        throw Extensions.todo();
    }

    public static WhileStatement while_(Expression condition, Statement body) {
        return new WhileStatement(condition, body);
    }

    public static DeclarationStatement declare(int modifiers, ParameterExpression parameter, @Nullable Expression initializer) {
        return new DeclarationStatement(modifiers, parameter, initializer);
    }

    public static DeclarationStatement declare(int modifiers, String name, Expression initializer) {
        assert (initializer != null) : "empty initializer for variable declaration with name '" + name + "', modifiers " + modifiers + ". Please use declare(int, ParameterExpression, initializer) instead";
        return Expressions.declare(modifiers, Expressions.parameter(initializer.getType(), name), initializer);
    }

    public static Statement statement(@Nullable Expression expression) {
        return new GotoStatement(GotoExpressionKind.Sequence, null, expression);
    }

    public static Expression foldAnd(List<Expression> conditions) {
        Expression e = null;
        int nullCount = 0;
        for (Expression condition : conditions) {
            if (condition instanceof ConstantExpression) {
                Boolean value = (Boolean)((ConstantExpression)condition).value;
                if (value == null) {
                    ++nullCount;
                    continue;
                }
                if (value.booleanValue()) continue;
                return Expressions.constant(false);
            }
            if (e == null) {
                e = condition;
                continue;
            }
            e = Expressions.andAlso(e, condition);
        }
        if (nullCount > 0) {
            return Expressions.constant(null);
        }
        if (e == null) {
            return Expressions.constant(true);
        }
        return e;
    }

    public static Expression foldOr(List<Expression> conditions) {
        Expression e = null;
        int nullCount = 0;
        for (Expression condition : conditions) {
            if (condition instanceof ConstantExpression) {
                Boolean value = (Boolean)((ConstantExpression)condition).value;
                if (value == null) {
                    ++nullCount;
                    continue;
                }
                if (!value.booleanValue()) continue;
                return Expressions.constant(true);
            }
            if (e == null) {
                e = condition;
                continue;
            }
            e = Expressions.orElse(e, condition);
        }
        if (e == null) {
            if (nullCount > 0) {
                return Expressions.constant(null);
            }
            return Expressions.constant(false);
        }
        return e;
    }

    public static <T> FluentList<T> list() {
        return new FluentArrayList();
    }

    @SafeVarargs
    public static <T> FluentList<T> list(T ... ts) {
        return new FluentArrayList<T>(Arrays.asList(ts));
    }

    public static <T> FluentList<T> list(Iterable<T> ts) {
        return new FluentArrayList<T>(Expressions.toList(ts));
    }

    public static @Nullable Object evaluate(Node node) {
        Objects.requireNonNull(node, "node");
        Evaluator evaluator = new Evaluator();
        return ((AbstractNode)node).evaluate(evaluator);
    }

    private static boolean shouldLift(Expression left, Expression right, Method method) {
        return true;
    }

    private static Class deduceType(List<ParameterExpression> parameterList, Type type) {
        switch (parameterList.size()) {
            case 0: {
                return Function0.class;
            }
            case 1: {
                return type == Boolean.TYPE ? Predicate1.class : Function1.class;
            }
            case 2: {
                return type == Boolean.TYPE ? Predicate2.class : Function2.class;
            }
        }
        return Function.class;
    }

    private static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T parameter : iterable) {
            list.add(parameter);
        }
        return list;
    }

    private static <T> List<T> toList(T[] ts) {
        if (ts.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(ts);
    }

    private static <T> Collection<T> toCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return Expressions.toList(iterable);
    }

    static List<Statement> acceptStatements(List<Statement> statements, Shuttle shuttle) {
        if (statements.isEmpty()) {
            return statements;
        }
        ArrayList<Statement> statements1 = new ArrayList<Statement>();
        for (Statement statement : statements) {
            Statement newStatement = statement.accept(shuttle);
            if (newStatement instanceof GotoStatement) {
                GotoStatement goto_ = (GotoStatement)newStatement;
                if (goto_.kind == GotoExpressionKind.Sequence && goto_.expression == null) continue;
            }
            statements1.add(newStatement);
        }
        return statements1;
    }

    static List<Node> acceptNodes(List<Node> nodes, Shuttle shuttle) {
        if (nodes.isEmpty()) {
            return nodes;
        }
        ArrayList<Node> statements1 = new ArrayList<Node>();
        for (Node node : nodes) {
            statements1.add(node.accept(shuttle));
        }
        return statements1;
    }

    static List<Expression> acceptParameterExpressions(List<ParameterExpression> parameterExpressions, Shuttle shuttle) {
        if (parameterExpressions.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder parameterExpressions1 = new ImmutableList.Builder();
        for (ParameterExpression parameterExpression : parameterExpressions) {
            parameterExpressions1.add(parameterExpression.accept(shuttle));
        }
        return parameterExpressions1.build();
    }

    static List<DeclarationStatement> acceptDeclarations(List<DeclarationStatement> declarations, Shuttle shuttle) {
        if (declarations.isEmpty()) {
            return declarations;
        }
        ArrayList<DeclarationStatement> declarations1 = new ArrayList<DeclarationStatement>();
        for (DeclarationStatement declaration : declarations) {
            declarations1.add(declaration.accept(shuttle));
        }
        return declarations1;
    }

    static List<MemberDeclaration> acceptMemberDeclarations(List<MemberDeclaration> memberDeclarations, Shuttle shuttle) {
        if (memberDeclarations.isEmpty()) {
            return memberDeclarations;
        }
        ArrayList<MemberDeclaration> memberDeclarations1 = new ArrayList<MemberDeclaration>();
        for (MemberDeclaration memberDeclaration : memberDeclarations) {
            memberDeclarations1.add(memberDeclaration.accept(shuttle));
        }
        return memberDeclarations1;
    }

    static List<Expression> acceptExpressions(List<Expression> expressions, Shuttle shuttle) {
        if (expressions.isEmpty()) {
            return expressions;
        }
        ArrayList<Expression> expressions1 = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            expressions1.add(expression.accept(shuttle));
        }
        return expressions1;
    }

    static <R> @Nullable R acceptNodes(@Nullable List<? extends Node> nodes, Visitor<R> visitor) {
        R r = null;
        if (nodes != null) {
            for (Node node : nodes) {
                r = node.accept(visitor);
            }
        }
        return r;
    }

    private static class FluentArrayList<T>
    extends ArrayList<T>
    implements FluentList<T> {
        FluentArrayList() {
        }

        FluentArrayList(Collection<? extends T> c) {
            super(c);
        }

        @Override
        public FluentList<T> append(T t) {
            this.add(t);
            return this;
        }

        @Override
        public FluentList<T> appendIf(boolean condition, T t) {
            if (condition) {
                this.add(t);
            }
            return this;
        }

        @Override
        public FluentList<T> appendIfNotNull(@Nullable T t) {
            if (t != null) {
                this.add(t);
            }
            return this;
        }

        @Override
        public FluentList<T> appendAll(Iterable<T> ts) {
            this.addAll(Expressions.toCollection(ts));
            return this;
        }

        @Override
        public FluentList<T> appendAll(T ... ts) {
            this.addAll(Arrays.asList(ts));
            return this;
        }
    }

    public static interface FluentList<T>
    extends List<T> {
        public FluentList<T> append(T var1);

        public FluentList<T> appendIf(boolean var1, T var2);

        public FluentList<T> appendIfNotNull(@Nullable T var1);

        public FluentList<T> appendAll(Iterable<T> var1);

        public FluentList<T> appendAll(T ... var1);
    }

    static interface SymbolDocumentInfo {
    }

    static interface RuntimeVariablesExpression {
    }

    static interface PropertyInfo {
    }
}

