/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.AggImpState;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.AggregateLambdaFactory;
import org.apache.calcite.adapter.enumerable.EnumerableAggregateBase;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.impl.AggResultContextImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableAggregate
extends EnumerableAggregateBase
implements EnumerableRel {
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traitSet, ImmutableList.of(), input, groupSet, groupSets, aggCalls);
        assert (this.getConvention() instanceof EnumerableConvention);
        for (AggregateCall aggCall : aggCalls) {
            if (aggCall.isDistinct()) {
                throw new InvalidRelException("distinct aggregation not supported");
            }
            if (aggCall.distinctKeys != null) {
                throw new InvalidRelException("within-distinct aggregation not supported");
            }
            AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
            if (implementor2 != null) continue;
            throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
        }
    }

    @Deprecated
    public EnumerableAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        this(cluster, traitSet, input, groupSet, groupSets, aggCalls);
        EnumerableAggregate.checkIndicator(indicator);
    }

    @Override
    public EnumerableAggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, @Nullable List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new EnumerableAggregate(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ParameterExpression key_;
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        Expression childExp = builder.append("child", result.block);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferCustom());
        PhysType inputPhysType = result.physType;
        ParameterExpression parameter = Expressions.parameter(inputPhysType.getJavaRowType(), "a0");
        PhysType keyPhysType = inputPhysType.project(this.groupSet.asList(), this.getGroupType() != Aggregate.Group.SIMPLE, JavaRowFormat.LIST);
        int groupCount = this.getGroupCount();
        ArrayList<AggImpState> aggs = new ArrayList<AggImpState>(this.aggCalls.size());
        for (Ord call : Ord.zip(this.aggCalls)) {
            aggs.add(new AggImpState(call.i, (AggregateCall)call.e, false));
        }
        ArrayList<Expression> initExpressions = new ArrayList<Expression>();
        BlockBuilder initBlock = new BlockBuilder();
        List<Type> aggStateTypes = this.createAggStateTypes(initExpressions, initBlock, aggs, typeFactory);
        PhysType accPhysType = PhysTypeImpl.of(typeFactory, typeFactory.createSyntheticType(aggStateTypes));
        this.declareParentAccumulator(initExpressions, initBlock, accPhysType);
        Expression accumulatorInitializer = builder.append("accumulatorInitializer", Expressions.lambda(Function0.class, initBlock.toBlock(), new ParameterExpression[0]));
        ParameterExpression inParameter = Expressions.parameter(inputPhysType.getJavaRowType(), "in");
        ParameterExpression acc_ = Expressions.parameter(accPhysType.getJavaRowType(), "acc");
        this.createAccumulatorAdders(inParameter, aggs, accPhysType, acc_, inputPhysType, builder, implementor, typeFactory);
        ParameterExpression lambdaFactory = Expressions.parameter(AggregateLambdaFactory.class, builder.newName("lambdaFactory"));
        this.implementLambdaFactory(builder, inputPhysType, aggs, accumulatorInitializer, EnumerableAggregate.hasOrderedCall(aggs), lambdaFactory);
        BlockBuilder resultBlock = new BlockBuilder();
        Expressions.FluentList<Expression> results = Expressions.list();
        if (groupCount == 0) {
            key_ = null;
        } else {
            Type keyType = keyPhysType.getJavaRowType();
            key_ = Expressions.parameter(keyType, "key");
            for (int j = 0; j < groupCount; ++j) {
                Expression ref = keyPhysType.fieldReference(key_, j);
                if (this.getGroupType() == Aggregate.Group.SIMPLE) {
                    results.add(ref);
                    continue;
                }
                results.add(Expressions.condition(keyPhysType.fieldReference(key_, groupCount + j), Expressions.constant(null), Expressions.box(ref)));
            }
        }
        for (AggImpState agg : aggs) {
            results.add(agg.implementor.implementResult(Objects.requireNonNull(agg.context, "agg.context"), new AggResultContextImpl(resultBlock, agg.call, Objects.requireNonNull(agg.state, "agg.state"), key_, keyPhysType)));
        }
        resultBlock.add(physType.record(results));
        if (this.getGroupType() != Aggregate.Group.SIMPLE) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            for (ImmutableBitSet set : this.groupSets) {
                list.add(inputPhysType.generateSelector(parameter, this.groupSet.asList(), set.asList(), keyPhysType.getFormat()));
            }
            Expression keySelectors_ = builder.append("keySelectors", Expressions.call(BuiltInMethod.ARRAYS_AS_LIST.method, list));
            Expression resultSelector = builder.append("resultSelector", Expressions.lambda(Function2.class, resultBlock.toBlock(), Objects.requireNonNull(key_, "key_"), acc_));
            builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.GROUP_BY_MULTIPLE.method, Expressions.list(childExp, keySelectors_, Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_RESULT_SELECTOR.method, resultSelector)).appendIfNotNull(keyPhysType.comparer()))));
        } else if (groupCount == 0) {
            Expression resultSelector = builder.append("resultSelector", Expressions.lambda(Function1.class, resultBlock.toBlock(), acc_));
            builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.SINGLETON_ENUMERABLE.method, Expressions.call(childExp, BuiltInMethod.AGGREGATE.method, Expressions.call((Expression)Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, new Expression[0]), BuiltInMethod.FUNCTION0_APPLY.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_SINGLE_GROUP_RESULT_SELECTOR.method, resultSelector)))));
        } else if (this.aggCalls.isEmpty() && this.groupSet.equals(ImmutableBitSet.range(child.getRowType().getFieldCount()))) {
            builder.add(Expressions.return_(null, Expressions.call(inputPhysType.convertTo(childExp, physType.getFormat()), BuiltInMethod.DISTINCT.method, Expressions.list().appendIfNotNull(physType.comparer()))));
        } else {
            Expression keySelector_ = builder.append("keySelector", inputPhysType.generateSelector(parameter, this.groupSet.asList(), keyPhysType.getFormat()));
            Expression resultSelector_ = builder.append("resultSelector", Expressions.lambda(Function2.class, resultBlock.toBlock(), Objects.requireNonNull(key_, "key_"), acc_));
            builder.add(Expressions.return_(null, Expressions.call(childExp, BuiltInMethod.GROUP_BY2.method, Expressions.list(keySelector_, Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_INITIALIZER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_ADDER.method, new Expression[0]), Expressions.call((Expression)lambdaFactory, BuiltInMethod.AGG_LAMBDA_FACTORY_ACC_RESULT_SELECTOR.method, resultSelector_)).appendIfNotNull(keyPhysType.comparer()))));
        }
        return implementor.result(physType, builder.toBlock());
    }
}

