/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.metadata.NullSentinel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlBinaryStringLiteral;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDateLiteral;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlTimeLiteral;
import org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLiteralChainOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlLiteral
extends SqlNode {
    private final SqlTypeName typeName;
    protected final @Nullable Object value;

    protected SqlLiteral(@Nullable Object value, SqlTypeName typeName, SqlParserPos pos) {
        super(pos);
        this.value = value;
        this.typeName = typeName;
        assert (typeName != null);
        assert (SqlLiteral.valueMatchesType(value, typeName));
    }

    public SqlTypeName getTypeName() {
        return this.typeName;
    }

    public static boolean valueMatchesType(@Nullable Object value, SqlTypeName typeName) {
        switch (typeName) {
            case BOOLEAN: {
                return value == null || value instanceof Boolean;
            }
            case NULL: {
                return value == null;
            }
            case DECIMAL: 
            case DOUBLE: {
                return value instanceof BigDecimal;
            }
            case DATE: {
                return value instanceof DateString;
            }
            case TIME: {
                return value instanceof TimeString;
            }
            case TIMESTAMP: {
                return value instanceof TimestampString;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return value instanceof SqlIntervalLiteral.IntervalValue;
            }
            case BINARY: {
                return value instanceof BitString;
            }
            case CHAR: {
                return value instanceof NlsString;
            }
            case SYMBOL: {
                return value instanceof Enum || value instanceof SqlSampleSpec;
            }
            case MULTISET: {
                return true;
            }
        }
        throw Util.unexpected(typeName);
    }

    @Override
    public SqlLiteral clone(SqlParserPos pos) {
        return new SqlLiteral(this.value, this.typeName, pos);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LITERAL;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public <T> T getValueAs(Class<T> clazz) {
        Object value = this.value;
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        if (this.typeName == SqlTypeName.NULL) {
            return clazz.cast((Object)NullSentinel.INSTANCE);
        }
        Objects.requireNonNull(value, "value");
        switch (this.typeName) {
            case CHAR: {
                if (clazz != String.class) break;
                return clazz.cast(((NlsString)value).getValue());
            }
            case BINARY: {
                if (clazz != byte[].class) break;
                return clazz.cast(((BitString)value).getAsByteArray());
            }
            case DECIMAL: {
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)value).longValueExact());
                }
            }
            case DOUBLE: 
            case INTEGER: 
            case BIGINT: 
            case SMALLINT: 
            case TINYINT: 
            case REAL: 
            case FLOAT: {
                if (clazz == Long.class) {
                    return clazz.cast(((BigDecimal)value).longValueExact());
                }
                if (clazz == Integer.class) {
                    return clazz.cast(((BigDecimal)value).intValueExact());
                }
                if (clazz == Short.class) {
                    return clazz.cast(((BigDecimal)value).shortValueExact());
                }
                if (clazz == Byte.class) {
                    return clazz.cast(((BigDecimal)value).byteValueExact());
                }
                if (clazz == Double.class) {
                    return clazz.cast(((BigDecimal)value).doubleValue());
                }
                if (clazz != Float.class) break;
                return clazz.cast(Float.valueOf(((BigDecimal)value).floatValue()));
            }
            case DATE: {
                if (clazz != Calendar.class) break;
                return clazz.cast(((DateString)value).toCalendar());
            }
            case TIME: {
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimeString)value).toCalendar());
            }
            case TIMESTAMP: {
                if (clazz != Calendar.class) break;
                return clazz.cast(((TimestampString)value).toCalendar());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                SqlIntervalLiteral.IntervalValue valMonth = (SqlIntervalLiteral.IntervalValue)value;
                if (clazz == Long.class) {
                    return clazz.cast((long)valMonth.getSign() * SqlParserUtil.intervalToMonths(valMonth));
                }
                if (clazz == BigDecimal.class) {
                    return clazz.cast(BigDecimal.valueOf(this.getValueAs(Long.class)));
                }
                if (clazz == TimeUnitRange.class) {
                    return clazz.cast((Object)valMonth.getIntervalQualifier().timeUnitRange);
                }
                if (clazz != SqlIntervalQualifier.class) break;
                return clazz.cast(valMonth.getIntervalQualifier());
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                SqlIntervalLiteral.IntervalValue valTime = (SqlIntervalLiteral.IntervalValue)value;
                if (clazz == Long.class) {
                    return clazz.cast((long)valTime.getSign() * SqlParserUtil.intervalToMillis(valTime));
                }
                if (clazz == BigDecimal.class) {
                    return clazz.cast(BigDecimal.valueOf(this.getValueAs(Long.class)));
                }
                if (clazz == TimeUnitRange.class) {
                    return clazz.cast((Object)valTime.getIntervalQualifier().timeUnitRange);
                }
                if (clazz != SqlIntervalQualifier.class) break;
                return clazz.cast(valTime.getIntervalQualifier());
            }
        }
        throw new AssertionError((Object)("cannot cast " + value + " as " + clazz));
    }

    @Deprecated
    public <E extends Enum<E>> @Nullable E symbolValue_() {
        return (E)((Enum)this.value);
    }

    public <E extends Enum<E>> @Nullable E symbolValue(Class<E> class_) {
        return (E)((Enum)class_.cast(this.value));
    }

    public boolean booleanValue() {
        return this.getValueAs(Boolean.class);
    }

    public static SqlSampleSpec sampleValue(SqlNode node) {
        return ((SqlLiteral)node).getValueAs(SqlSampleSpec.class);
    }

    public static @Nullable Comparable value(SqlNode node) throws IllegalArgumentException {
        SqlLiteral literal;
        if (node instanceof SqlLiteral) {
            literal = (SqlLiteral)node;
            if (literal.getTypeName() == SqlTypeName.SYMBOL) {
                return (Enum)literal.value;
            }
            switch (Objects.requireNonNull(literal.getTypeName().getFamily())) {
                case CHARACTER: {
                    return (NlsString)literal.value;
                }
                case NUMERIC: {
                    return (BigDecimal)literal.value;
                }
                case INTERVAL_YEAR_MONTH: {
                    SqlIntervalLiteral.IntervalValue valMonth = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
                    return Long.valueOf((long)valMonth.getSign() * SqlParserUtil.intervalToMonths(valMonth));
                }
                case INTERVAL_DAY_TIME: {
                    SqlIntervalLiteral.IntervalValue valTime = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
                    return Long.valueOf((long)valTime.getSign() * SqlParserUtil.intervalToMillis(valTime));
                }
            }
        }
        if (SqlUtil.isLiteralChain(node)) {
            assert (node instanceof SqlCall);
            literal = SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
            assert (SqlTypeUtil.inCharFamily(literal.getTypeName()));
            return (NlsString)literal.value;
        }
        switch (node.getKind()) {
            case INTERVAL_QUALIFIER: {
                return ((SqlIntervalQualifier)node).timeUnitRange;
            }
            case CAST: {
                assert (node instanceof SqlCall);
                return SqlLiteral.value(((SqlCall)node).operand(0));
            }
            case MINUS_PREFIX: {
                assert (node instanceof SqlCall);
                Comparable o = SqlLiteral.value(((SqlCall)node).operand(0));
                if (!(o instanceof BigDecimal)) break;
                BigDecimal bigDecimal = (BigDecimal)o;
                return bigDecimal.negate();
            }
        }
        throw new IllegalArgumentException("not a literal: " + node);
    }

    @Deprecated
    public static String stringValue(SqlNode node) {
        if (node instanceof SqlLiteral) {
            SqlLiteral literal = (SqlLiteral)node;
            assert (SqlTypeUtil.inCharFamily(literal.getTypeName()));
            return Objects.requireNonNull(literal.value).toString();
        }
        if (SqlUtil.isLiteralChain(node)) {
            SqlLiteral literal = SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
            assert (SqlTypeUtil.inCharFamily(literal.getTypeName()));
            return Objects.requireNonNull(literal.value).toString();
        }
        if (node instanceof SqlCall && ((SqlCall)node).getOperator() == SqlStdOperatorTable.CAST) {
            return SqlLiteral.stringValue(((SqlCall)node).operand(0));
        }
        throw new AssertionError((Object)("invalid string literal: " + node));
    }

    public static SqlLiteral unchain(SqlNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                return (SqlLiteral)node;
            }
            case LITERAL_CHAIN: {
                return SqlLiteralChainOperator.concatenateOperands((SqlCall)node);
            }
            case INTERVAL_QUALIFIER: {
                SqlIntervalQualifier q = (SqlIntervalQualifier)node;
                return new SqlLiteral(new SqlIntervalLiteral.IntervalValue(q, 1, q.toString()), q.typeName(), q.pos);
            }
        }
        throw new IllegalArgumentException("invalid literal: " + node);
    }

    public @Nullable String toValue() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case CHAR: {
                return ((NlsString)this.value).getValue();
            }
        }
        return this.value.toString();
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateLiteral(this);
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(@Nullable SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlLiteral)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlLiteral that = (SqlLiteral)node;
        if (!this.equals(that)) {
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    @Override
    public SqlMonotonicity getMonotonicity(@Nullable SqlValidatorScope scope) {
        return SqlMonotonicity.CONSTANT;
    }

    public static SqlLiteral createNull(SqlParserPos pos) {
        return new SqlLiteral(null, SqlTypeName.NULL, pos);
    }

    public static SqlLiteral createBoolean(boolean b, SqlParserPos pos) {
        return b ? new SqlLiteral(Boolean.TRUE, SqlTypeName.BOOLEAN, pos) : new SqlLiteral(Boolean.FALSE, SqlTypeName.BOOLEAN, pos);
    }

    public static SqlLiteral createUnknown(SqlParserPos pos) {
        return new SqlLiteral(null, SqlTypeName.BOOLEAN, pos);
    }

    public static SqlLiteral createSymbol(@Nullable Enum<?> o, SqlParserPos pos) {
        return new SqlLiteral(o, SqlTypeName.SYMBOL, pos);
    }

    public static SqlLiteral createSample(SqlSampleSpec sampleSpec, SqlParserPos pos) {
        return new SqlLiteral(sampleSpec, SqlTypeName.SYMBOL, pos);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof SqlLiteral)) {
            return false;
        }
        SqlLiteral that = (SqlLiteral)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public int intValue(boolean exact) {
        switch (this.typeName) {
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal bd = (BigDecimal)Objects.requireNonNull(this.value, "value");
                if (exact) {
                    try {
                        return bd.intValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
                    }
                }
                return bd.intValue();
            }
        }
        throw Util.unexpected(this.typeName);
    }

    public long longValue(boolean exact) {
        switch (this.typeName) {
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal bd = (BigDecimal)Objects.requireNonNull(this.value, "value");
                if (exact) {
                    try {
                        return bd.longValueExact();
                    }
                    catch (ArithmeticException e) {
                        throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
                    }
                }
                return bd.longValue();
            }
        }
        throw Util.unexpected(this.typeName);
    }

    @Deprecated
    public int signum() {
        return Nullness.castNonNull(this.bigDecimalValue()).compareTo(BigDecimal.ZERO);
    }

    public @Nullable BigDecimal bigDecimalValue() {
        switch (this.typeName) {
            case DECIMAL: 
            case DOUBLE: {
                return (BigDecimal)this.value;
            }
        }
        throw Util.unexpected(this.typeName);
    }

    @Deprecated
    public String getStringValue() {
        return ((NlsString)Objects.requireNonNull(this.value, "value")).getValue();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (this.typeName) {
            case BOOLEAN: {
                writer.keyword(this.value == null ? "UNKNOWN" : ((Boolean)this.value != false ? "TRUE" : "FALSE"));
                break;
            }
            case NULL: {
                writer.keyword("NULL");
                break;
            }
            case DECIMAL: 
            case DOUBLE: 
            case BINARY: 
            case CHAR: {
                throw Util.unexpected(this.typeName);
            }
            case SYMBOL: {
                writer.keyword(String.valueOf(this.value));
                break;
            }
            default: {
                writer.literal(String.valueOf(this.value));
            }
        }
    }

    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        switch (this.typeName) {
            case BOOLEAN: 
            case NULL: {
                RelDataType ret = typeFactory.createSqlType(this.typeName);
                ret = typeFactory.createTypeWithNullability(ret, null == this.value);
                return ret;
            }
            case BINARY: {
                BitString bitString = (BitString)Objects.requireNonNull(this.value, "value");
                int bitCount = bitString.getBitCount();
                return typeFactory.createSqlType(SqlTypeName.BINARY, bitCount / 8);
            }
            case CHAR: {
                SqlCollation collation;
                NlsString string = (NlsString)Objects.requireNonNull(this.value, "value");
                Charset charset = string.getCharset();
                if (null == charset) {
                    charset = typeFactory.getDefaultCharset();
                }
                if (null == (collation = string.getCollation())) {
                    collation = SqlCollation.COERCIBLE;
                }
                RelDataType type = typeFactory.createSqlType(SqlTypeName.CHAR, string.getValue().length());
                type = typeFactory.createTypeWithCharsetAndCollation(type, charset, collation);
                return type;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                SqlIntervalLiteral.IntervalValue intervalValue = (SqlIntervalLiteral.IntervalValue)Objects.requireNonNull(this.value, "value");
                return typeFactory.createSqlIntervalType(intervalValue.getIntervalQualifier());
            }
            case SYMBOL: {
                return typeFactory.createSqlType(SqlTypeName.SYMBOL);
            }
        }
        throw Util.needToImplement(this.toString() + ", operand=" + this.value);
    }

    @Deprecated
    public static SqlDateLiteral createDate(Calendar calendar, SqlParserPos pos) {
        return SqlLiteral.createDate(DateString.fromCalendarFields(calendar), pos);
    }

    public static SqlDateLiteral createDate(DateString date, SqlParserPos pos) {
        return new SqlDateLiteral(date, pos);
    }

    @Deprecated
    public static SqlTimestampLiteral createTimestamp(Calendar calendar, int precision, SqlParserPos pos) {
        return SqlLiteral.createTimestamp(TimestampString.fromCalendarFields(calendar), precision, pos);
    }

    public static SqlTimestampLiteral createTimestamp(TimestampString ts, int precision, SqlParserPos pos) {
        return new SqlTimestampLiteral(ts, precision, false, pos);
    }

    @Deprecated
    public static SqlTimeLiteral createTime(Calendar calendar, int precision, SqlParserPos pos) {
        return SqlLiteral.createTime(TimeString.fromCalendarFields(calendar), precision, pos);
    }

    public static SqlTimeLiteral createTime(TimeString t, int precision, SqlParserPos pos) {
        return new SqlTimeLiteral(t, precision, false, pos);
    }

    public static SqlIntervalLiteral createInterval(int sign, String intervalStr, SqlIntervalQualifier intervalQualifier, SqlParserPos pos) {
        return new SqlIntervalLiteral(sign, intervalStr, intervalQualifier, intervalQualifier.typeName(), pos);
    }

    public static SqlNumericLiteral createNegative(SqlNumericLiteral num, SqlParserPos pos) {
        return new SqlNumericLiteral(((BigDecimal)Objects.requireNonNull(num.getValue())).negate(), num.getPrec(), num.getScale(), num.isExact(), pos);
    }

    public static SqlNumericLiteral createExactNumeric(String s2, SqlParserPos pos) {
        int prec;
        int scale;
        BigDecimal value;
        int i = s2.indexOf(46);
        if (i >= 0 && s2.length() - 1 != i) {
            value = SqlParserUtil.parseDecimal(s2);
            scale = s2.length() - i - 1;
            assert (scale == value.scale()) : s2;
            prec = s2.length() - 1;
        } else if (i >= 0 && s2.length() - 1 == i) {
            value = SqlParserUtil.parseInteger(s2.substring(0, i));
            scale = 0;
            prec = s2.length() - 1;
        } else {
            value = SqlParserUtil.parseInteger(s2);
            scale = 0;
            prec = s2.length();
        }
        return new SqlNumericLiteral(value, prec, scale, true, pos);
    }

    public static SqlNumericLiteral createApproxNumeric(String s2, SqlParserPos pos) {
        BigDecimal value = SqlParserUtil.parseDecimal(s2);
        return new SqlNumericLiteral(value, null, null, false, pos);
    }

    public static SqlBinaryStringLiteral createBinaryString(String s2, SqlParserPos pos) {
        BitString bits;
        try {
            bits = BitString.createFromHexString(s2);
        }
        catch (NumberFormatException e) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.binaryLiteralInvalid());
        }
        return new SqlBinaryStringLiteral(bits, pos);
    }

    public static SqlBinaryStringLiteral createBinaryString(byte[] bytes, SqlParserPos pos) {
        BitString bits;
        try {
            bits = BitString.createFromBytes(bytes);
        }
        catch (NumberFormatException e) {
            throw SqlUtil.newContextException(pos, Static.RESOURCE.binaryLiteralInvalid());
        }
        return new SqlBinaryStringLiteral(bits, pos);
    }

    public static SqlCharStringLiteral createCharString(String s2, SqlParserPos pos) {
        return SqlLiteral.createCharString(s2, null, pos);
    }

    public static SqlCharStringLiteral createCharString(String s2, @Nullable String charSet, SqlParserPos pos) {
        NlsString slit = new NlsString(s2, charSet, null);
        return new SqlCharStringLiteral(slit, pos);
    }

    public SqlLiteral unescapeUnicode(char unicodeEscapeChar) {
        if (unicodeEscapeChar == '\u0000') {
            return this;
        }
        assert (SqlTypeUtil.inCharFamily(this.getTypeName()));
        NlsString ns = (NlsString)Objects.requireNonNull(this.value, "value");
        String s2 = ns.getValue();
        StringBuilder sb = new StringBuilder();
        int n = s2.length();
        for (int i = 0; i < n; ++i) {
            char c = s2.charAt(i);
            if (c == unicodeEscapeChar) {
                int v;
                if (n > i + 1 && s2.charAt(i + 1) == unicodeEscapeChar) {
                    sb.append(unicodeEscapeChar);
                    ++i;
                    continue;
                }
                if (i + 5 > n) {
                    throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.unicodeEscapeMalformed(i));
                }
                String u = s2.substring(i + 1, i + 5);
                try {
                    v = Integer.parseInt(u, 16);
                }
                catch (NumberFormatException ex) {
                    throw SqlUtil.newContextException(this.getParserPosition(), Static.RESOURCE.unicodeEscapeMalformed(i));
                }
                sb.append((char)(v & 0xFFFF));
                i += 4;
                continue;
            }
            sb.append(c);
        }
        ns = new NlsString(sb.toString(), ns.getCharsetName(), ns.getCollation());
        return new SqlCharStringLiteral(ns, this.getParserPosition());
    }

    @Deprecated
    public static interface SqlSymbol {
        public String name();

        public int ordinal();
    }
}

