/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.zip.DeflaterOutputStream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompressionFunctions {
    private CompressionFunctions() {
    }

    public static @Nullable ByteString compress(@Nullable String data) {
        try {
            if (data == null) {
                return null;
            }
            if (StringUtils.isEmpty(data)) {
                return new ByteString(new byte[0]);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteBuffer dataLength = ByteBuffer.allocate(4);
            dataLength.order(ByteOrder.LITTLE_ENDIAN);
            dataLength.putInt(data.length());
            outputStream.write(dataLength.array());
            DeflaterOutputStream inflaterStream = new DeflaterOutputStream(outputStream);
            inflaterStream.write(data.getBytes(Charset.defaultCharset()));
            inflaterStream.close();
            return new ByteString(outputStream.toByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }
}

