/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.HashMultiset;
import java.util.AbstractCollection;
import java.util.HashSet;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.interpreter.Source;
import org.apache.calcite.rel.core.SetOp;

public class SetOpNode
implements Node {
    private final Source leftSource;
    private final Source rightSource;
    private final Sink sink;
    private final SetOp setOp;

    public SetOpNode(Compiler compiler, SetOp setOp) {
        this.leftSource = compiler.source(setOp, 0);
        this.rightSource = compiler.source(setOp, 1);
        this.sink = compiler.sink(setOp);
        this.setOp = setOp;
    }

    @Override
    public void close() {
        this.leftSource.close();
        this.rightSource.close();
    }

    @Override
    public void run() throws InterruptedException {
        Row row;
        AbstractCollection rightRows;
        AbstractCollection leftRows;
        if (this.setOp.all) {
            leftRows = HashMultiset.create();
            rightRows = HashMultiset.create();
        } else {
            leftRows = new HashSet();
            rightRows = new HashSet();
        }
        while ((row = this.leftSource.receive()) != null) {
            leftRows.add(row);
        }
        while ((row = this.rightSource.receive()) != null) {
            rightRows.add(row);
        }
        switch (this.setOp.kind) {
            case INTERSECT: {
                for (Row leftRow : leftRows) {
                    if (!rightRows.remove(leftRow)) continue;
                    this.sink.send(leftRow);
                }
                break;
            }
            case EXCEPT: {
                for (Row leftRow : leftRows) {
                    if (rightRows.remove(leftRow)) continue;
                    this.sink.send(leftRow);
                }
                break;
            }
            case UNION: {
                leftRows.addAll(rightRows);
                for (Row r : leftRows) {
                    this.sink.send(r);
                }
                break;
            }
        }
    }
}

