/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.schema;

import java.util.ArrayList;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;

public class DaskTable
implements TranslatableTable {
    private final ArrayList<Pair<String, SqlTypeName>> tableColumns;
    private final String name;
    private final DaskStatistics statistics;

    public DaskTable(String name, Double rowCount) {
        this.name = name;
        this.tableColumns = new ArrayList();
        this.statistics = new DaskStatistics(rowCount);
    }

    public DaskTable(String name) {
        this(name, null);
    }

    public void addColumn(String columnName, SqlTypeName columnType) {
        this.tableColumns.add(new Pair<String, SqlTypeName>(columnName, columnType));
    }

    public String getTableName() {
        return this.name;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(relDataTypeFactory);
        for (Pair<String, SqlTypeName> column : this.tableColumns) {
            String name = column.getKey();
            SqlTypeName type = column.getValue();
            builder.add(name, relDataTypeFactory.createSqlType(type));
            builder.nullable(true);
        }
        return builder.build();
    }

    @Override
    public Statistic getStatistic() {
        return this.statistics;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    @Override
    public boolean isRolledUp(String string) {
        return false;
    }

    @Override
    public boolean rolledUpColumnValidInsideAgg(String string, SqlCall sc, SqlNode sn, CalciteConnectionConfig ccc) {
        throw new AssertionError((Object)"This should not be called!");
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelTraitSet traitSet = context.getCluster().traitSet();
        return new LogicalTableScan(context.getCluster(), traitSet, context.getTableHints(), relOptTable);
    }

    private final class DaskStatistics
    implements Statistic {
        private final Double rowCount;

        public DaskStatistics(Double rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public Double getRowCount() {
            return this.rowCount;
        }
    }
}

