/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.Lex;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSetOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BigQuerySqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.BIG_QUERY).withLiteralQuoteString("'").withLiteralEscapedQuoteString("\\'").withIdentifierQuoteString("`").withIdentifierEscapedQuoteString("\\`").withNullCollation(NullCollation.LOW).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED).withCaseSensitive(false);
    public static final SqlDialect DEFAULT = new BigQuerySqlDialect(DEFAULT_CONTEXT);
    private static final List<String> RESERVED_KEYWORDS = ImmutableList.copyOf(Arrays.asList("ALL", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERT_ROWS_MODIFIED", "AT", "BETWEEN", "BY", "CASE", "CAST", "COLLATE", "CONTAINS", "CREATE", "CROSS", "CUBE", "CURRENT", "DEFAULT", "DEFINE", "DESC", "DISTINCT", "ELSE", "END", "ENUM", "ESCAPE", "EXCEPT", "EXCLUDE", "EXISTS", "EXTRACT", "FALSE", "FETCH", "FOLLOWING", "FOR", "FROM", "FULL", "GROUP", "GROUPING", "GROUPS", "HASH", "HAVING", "IF", "IGNORE", "IN", "INNER", "INTERSECT", "INTERVAL", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LIMIT", "LOOKUP", "MERGE", "NATURAL", "NEW", "NO", "NOT", "NULL", "NULLS", "OF", "ON", "OR", "ORDER", "OUTER", "OVER", "PARTITION", "PRECEDING", "PROTO", "RANGE", "RECURSIVE", "RESPECT", "RIGHT", "ROLLUP", "ROWS", "SELECT", "SET", "SOME", "STRUCT", "TABLESAMPLE", "THEN", "TO", "TREAT", "TRUE", "UNBOUNDED", "UNION", "UNNEST", "USING", "WHEN", "WHERE", "WINDOW", "WITH", "WITHIN"));
    private static final Pattern IDENTIFIER_REGEX = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    private static final SqlOperator UNION_DISTINCT = new SqlSetOperator("UNION DISTINCT", SqlKind.UNION, 14, false);
    private static final SqlSetOperator EXCEPT_DISTINCT = new SqlSetOperator("EXCEPT DISTINCT", SqlKind.EXCEPT, 14, false);
    private static final SqlSetOperator INTERSECT_DISTINCT = new SqlSetOperator("INTERSECT DISTINCT", SqlKind.INTERSECT, 18, false);

    public BigQuerySqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    protected boolean identifierNeedsQuote(String val) {
        return !IDENTIFIER_REGEX.matcher(val).matches() || RESERVED_KEYWORDS.contains(val.toUpperCase(Locale.ROOT));
    }

    @Override
    public @Nullable SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    @Override
    public boolean supportsImplicitTypeCoercion(RexCall call) {
        return super.supportsImplicitTypeCoercion(call) && RexUtil.isLiteral(call.getOperands().get(0), false) && !SqlTypeUtil.isNumeric(call.type);
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsAggregateFunctionFilter() {
        return false;
    }

    @Override
    public SqlParser.Config configureParser(SqlParser.Config configBuilder) {
        return super.configureParser(configBuilder).withCharLiteralStyles(Lex.BIG_QUERY.charLiteralStyles);
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        BigQuerySqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("STRPOS");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                if (3 == call.operandCount()) {
                    throw new RuntimeException("3rd operand Not Supported for Function STRPOS in Big Query");
                }
                writer.endFunCall(frame);
                break;
            }
            case UNION: {
                if (((SqlSetOperator)call.getOperator()).isAll()) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    break;
                }
                SqlSyntax.BINARY.unparse(writer, UNION_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case EXCEPT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) {
                    throw new RuntimeException("BigQuery does not support EXCEPT ALL");
                }
                SqlSyntax.BINARY.unparse(writer, EXCEPT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case INTERSECT: {
                if (((SqlSetOperator)call.getOperator()).isAll()) {
                    throw new RuntimeException("BigQuery does not support INTERSECT ALL");
                }
                SqlSyntax.BINARY.unparse(writer, INTERSECT_DISTINCT, call, leftPrec, rightPrec);
                break;
            }
            case TRIM: {
                BigQuerySqlDialect.unparseTrim(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    @Override
    public void unparseSqlIntervalLiteral(SqlWriter writer, SqlIntervalLiteral literal, int leftPrec, int rightPrec) {
        SqlIntervalLiteral.IntervalValue interval = literal.getValueAs(SqlIntervalLiteral.IntervalValue.class);
        writer.keyword("INTERVAL");
        if (interval.getSign() == -1) {
            writer.print("-");
        }
        try {
            Long.parseLong(interval.getIntervalLiteral());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Only INT64 is supported as the interval value for BigQuery.");
        }
        writer.literal(interval.getIntervalLiteral());
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        String start = BigQuerySqlDialect.validate(qualifier.timeUnitRange.startUnit).name();
        if (qualifier.timeUnitRange.endUnit != null) {
            throw new RuntimeException("Range time unit is not supported for BigQuery.");
        }
        writer.keyword(start);
    }

    private static void unparseTrim(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        String operatorName;
        SqlLiteral trimFlag = (SqlLiteral)call.operand(0);
        SqlLiteral valueToTrim = (SqlLiteral)call.operand(1);
        switch (trimFlag.getValueAs(SqlTrimFunction.Flag.class)) {
            case LEADING: {
                operatorName = "LTRIM";
                break;
            }
            case TRAILING: {
                operatorName = "RTRIM";
                break;
            }
            default: {
                operatorName = call.getOperator().getName();
            }
        }
        SqlWriter.Frame trimFrame = writer.startFunCall(operatorName);
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        String value = Objects.requireNonNull(valueToTrim.toValue(), "valueToTrim.toValue()");
        if (!value.matches("\\s+")) {
            writer.literal(",");
            ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(trimFrame);
    }

    private static TimeUnit validate(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECOND: 
            case MILLISECOND: 
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case DAY: 
            case WEEK: 
            case MONTH: 
            case QUARTER: 
            case YEAR: 
            case ISOYEAR: {
                return timeUnit;
            }
        }
        throw new RuntimeException("Time unit " + (Object)((Object)timeUnit) + " is not supported for BigQuery.");
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        if (type instanceof BasicSqlType) {
            SqlTypeName typeName = type.getSqlTypeName();
            switch (typeName) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("INT64", typeName);
                }
                case FLOAT: 
                case DOUBLE: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("FLOAT64", typeName);
                }
                case DECIMAL: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("NUMERIC", typeName);
                }
                case BOOLEAN: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("BOOL", typeName);
                }
                case CHAR: 
                case VARCHAR: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("STRING", typeName);
                }
                case BINARY: 
                case VARBINARY: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("BYTES", typeName);
                }
                case DATE: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("DATE", typeName);
                }
                case TIME: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("TIME", typeName);
                }
                case TIMESTAMP: {
                    return BigQuerySqlDialect.createSqlDataTypeSpecByName("TIMESTAMP", typeName);
                }
            }
        }
        return super.getCastSpec(type);
    }

    private static SqlDataTypeSpec createSqlDataTypeSpecByName(String typeAlias, SqlTypeName typeName) {
        SqlAlienSystemTypeNameSpec typeNameSpec = new SqlAlienSystemTypeNameSpec(typeAlias, typeName, SqlParserPos.ZERO);
        return new SqlDataTypeSpec(typeNameSpec, SqlParserPos.ZERO);
    }
}

