/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexSubQuery
extends RexCall {
    public final RelNode rel;

    private RexSubQuery(RelDataType type, SqlOperator op, ImmutableList<RexNode> operands, RelNode rel) {
        super(type, op, operands);
        this.rel = rel;
    }

    public static RexSubQuery in(RelNode rel, ImmutableList<RexNode> nodes) {
        RelDataType type = RexSubQuery.type(rel, nodes);
        return new RexSubQuery(type, SqlStdOperatorTable.IN, nodes, rel);
    }

    public static RexSubQuery some(RelNode rel, ImmutableList<RexNode> nodes, SqlQuantifyOperator op) {
        assert (op.kind == SqlKind.SOME);
        if (op == SqlStdOperatorTable.SOME_EQ) {
            return RexSubQuery.in(rel, nodes);
        }
        RelDataType type = RexSubQuery.type(rel, nodes);
        return new RexSubQuery(type, op, nodes, rel);
    }

    static RelDataType type(RelNode rel, ImmutableList<RexNode> nodes) {
        assert (rel.getRowType().getFieldCount() == nodes.size());
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        boolean nullable = false;
        for (RexNode node : nodes) {
            if (!node.getType().isNullable()) continue;
            nullable = true;
        }
        for (RelDataTypeField field : rel.getRowType().getFieldList()) {
            if (!field.getType().isNullable()) continue;
            nullable = true;
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), nullable);
    }

    public static RexSubQuery exists(RelNode rel) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        return new RexSubQuery(type, SqlStdOperatorTable.EXISTS, ImmutableList.of(), rel);
    }

    public static RexSubQuery unique(RelNode rel) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        return new RexSubQuery(type, SqlStdOperatorTable.UNIQUE, ImmutableList.of(), rel);
    }

    public static RexSubQuery scalar(RelNode rel) {
        List<RelDataTypeField> fieldList = rel.getRowType().getFieldList();
        if (fieldList.size() != 1) {
            throw new IllegalArgumentException();
        }
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createTypeWithNullability(fieldList.get(0).getType(), true);
        return new RexSubQuery(type, SqlStdOperatorTable.SCALAR_QUERY, ImmutableList.of(), rel);
    }

    public static RexSubQuery array(RelNode rel) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createArrayType(rel.getRowType(), -1L);
        return new RexSubQuery(type, SqlStdOperatorTable.ARRAY_QUERY, ImmutableList.of(), rel);
    }

    public static RexSubQuery multiset(RelNode rel) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType type = typeFactory.createMultisetType(rel.getRowType(), -1L);
        return new RexSubQuery(type, SqlStdOperatorTable.MULTISET_QUERY, ImmutableList.of(), rel);
    }

    public static RexSubQuery map(RelNode rel) {
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataType rowType = rel.getRowType();
        Preconditions.checkArgument(rowType.getFieldCount() == 2, "MAP requires exactly two fields, got %s; row type %s", rowType.getFieldCount(), (Object)rowType);
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        RelDataType type = typeFactory.createMapType(fieldList.get(0).getType(), fieldList.get(1).getType());
        return new RexSubQuery(type, SqlStdOperatorTable.MAP_QUERY, ImmutableList.of(), rel);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitSubQuery(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitSubQuery(this, arg);
    }

    @Override
    protected String computeDigest(boolean withType) {
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        for (RexNode operand : this.operands) {
            sb.append(operand);
            sb.append(", ");
        }
        sb.append("{\n");
        sb.append(RelOptUtil.toString(this.rel));
        sb.append("})");
        return sb.toString();
    }

    @Override
    public RexSubQuery clone(RelDataType type, List<RexNode> operands) {
        return new RexSubQuery(type, this.getOperator(), ImmutableList.copyOf(operands), this.rel);
    }

    public RexSubQuery clone(RelNode rel) {
        return new RexSubQuery(this.type, this.getOperator(), this.operands, rel);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RexSubQuery)) {
            return false;
        }
        RexSubQuery sq = (RexSubQuery)obj;
        return this.op.equals(sq.op) && this.operands.equals(sq.operands) && this.rel.deepEquals(sq.rel);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.op, this.operands, this.rel.deepHashCode());
        }
        return this.hash;
    }
}

