/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.Converter;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class RelOptRule {
    protected final String description;
    private final RelOptRuleOperand operand;
    public final RelBuilderFactory relBuilderFactory;
    public final List<RelOptRuleOperand> operands;

    protected RelOptRule(RelOptRuleOperand operand) {
        this(operand, RelFactories.LOGICAL_BUILDER, null);
    }

    protected RelOptRule(RelOptRuleOperand operand, String description) {
        this(operand, RelFactories.LOGICAL_BUILDER, description);
    }

    protected RelOptRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, @Nullable String description) {
        this.operand = Objects.requireNonNull(operand, "operand");
        this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
        if (description == null) {
            description = RelOptRule.guessDescription(this.getClass().getName());
        }
        if (!description.matches("[A-Za-z][-A-Za-z0-9_.(),\\[\\]\\s:]*")) {
            throw new RuntimeException("Rule description '" + description + "' is not valid");
        }
        this.description = description;
        this.operands = this.flattenOperands(operand);
        RelOptRule.assignSolveOrder(this.operands);
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelOptRuleOperandChildren operandList) {
        return new RelOptRuleOperand(clazz, null, r -> true, operandList.policy, operandList.operands);
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelTrait trait, RelOptRuleOperandChildren operandList) {
        return new RelOptRuleOperand(clazz, trait, r -> true, operandList.policy, operandList.operands);
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operandJ(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildren operandList) {
        return new RelOptRuleOperand(clazz, trait, predicate, operandList.policy, operandList.operands);
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelTrait trait, com.google.common.base.Predicate<? super R> predicate, RelOptRuleOperandChildren operandList) {
        return RelOptRule.operandJ(clazz, trait, predicate::apply, operandList);
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operandJ(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return RelOptRule.operandJ(clazz, trait, predicate, RelOptRule.some(first, rest));
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelTrait trait, com.google.common.base.Predicate<? super R> predicate, RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return RelOptRule.operandJ(clazz, trait, predicate::apply, first, rest);
    }

    @Deprecated
    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return RelOptRule.operand(clazz, RelOptRule.some(first, rest));
    }

    @Deprecated
    protected static <R extends RelNode> ConverterRelOptRuleOperand convertOperand(Class<R> clazz, Predicate<? super R> predicate, RelTrait trait) {
        return new ConverterRelOptRuleOperand(clazz, trait, predicate);
    }

    @Deprecated
    protected static <R extends RelNode> ConverterRelOptRuleOperand convertOperand(Class<R> clazz, com.google.common.base.Predicate<? super R> predicate, RelTrait trait) {
        return new ConverterRelOptRuleOperand(clazz, trait, predicate::apply);
    }

    @Deprecated
    public static RelOptRuleOperandChildren some(RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return new RelOptRuleOperandChildren(RelOptRuleOperandChildPolicy.SOME, Lists.asList(first, rest));
    }

    @Deprecated
    public static RelOptRuleOperandChildren unordered(RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return new RelOptRuleOperandChildren(RelOptRuleOperandChildPolicy.UNORDERED, Lists.asList(first, rest));
    }

    @Deprecated
    public static RelOptRuleOperandChildren none() {
        return RelOptRuleOperandChildren.LEAF_CHILDREN;
    }

    @Deprecated
    public static RelOptRuleOperandChildren any() {
        return RelOptRuleOperandChildren.ANY_CHILDREN;
    }

    private List<RelOptRuleOperand> flattenOperands(@UnderInitialization RelOptRule this, RelOptRuleOperand rootOperand) {
        ArrayList<RelOptRuleOperand> operandList = new ArrayList<RelOptRuleOperand>();
        rootOperand.setRule(this);
        rootOperand.setParent(null);
        rootOperand.ordinalInParent = 0;
        rootOperand.ordinalInRule = operandList.size();
        operandList.add(rootOperand);
        this.flattenRecurse(operandList, rootOperand);
        return ImmutableList.copyOf(operandList);
    }

    private void flattenRecurse(@UnderInitialization RelOptRule this, List<RelOptRuleOperand> operandList, RelOptRuleOperand parentOperand) {
        int k = 0;
        for (RelOptRuleOperand operand : parentOperand.getChildOperands()) {
            operand.setRule(this);
            operand.setParent(parentOperand);
            operand.ordinalInParent = k++;
            operand.ordinalInRule = operandList.size();
            operandList.add(operand);
            this.flattenRecurse(operandList, operand);
        }
    }

    private static void assignSolveOrder(List<RelOptRuleOperand> operands) {
        for (RelOptRuleOperand operand : operands) {
            operand.solveOrder = new int[operands.size()];
            int m3 = 0;
            for (RelOptRuleOperand o = operand; o != null; o = o.getParent()) {
                operand.solveOrder[m3++] = o.ordinalInRule;
            }
            for (int k = 0; k < operands.size(); ++k) {
                boolean exists = false;
                for (int n = 0; n < m3; ++n) {
                    if (operand.solveOrder[n] != k) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                operand.solveOrder[m3++] = k;
            }
            assert (m3 == operands.size());
        }
    }

    public RelOptRuleOperand getOperand() {
        return this.operand;
    }

    public List<RelOptRuleOperand> getOperands() {
        return ImmutableList.copyOf(this.operands);
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof RelOptRule && this.equals((RelOptRule)obj);
    }

    protected boolean equals(RelOptRule that) {
        return this == that || this.getClass() == that.getClass() && this.description.equals(that.description) && this.operand.equals(that.operand);
    }

    public boolean matches(RelOptRuleCall call) {
        return true;
    }

    public abstract void onMatch(RelOptRuleCall var1);

    public @Nullable Convention getOutConvention() {
        return null;
    }

    public @Nullable RelTrait getOutTrait() {
        return null;
    }

    public final String toString() {
        return this.description;
    }

    public static RelNode convert(RelNode rel, RelTraitSet toTraits) {
        RelOptPlanner planner = rel.getCluster().getPlanner();
        RelTraitSet outTraits = rel.getTraitSet();
        for (int i = 0; i < toTraits.size(); ++i) {
            RelTrait toTrait = toTraits.getTrait(i);
            if (toTrait == null) continue;
            outTraits = outTraits.replace(i, toTrait);
        }
        if (rel.getTraitSet().matches(outTraits)) {
            return rel;
        }
        return planner.changeTraits(rel, outTraits);
    }

    public static RelNode convert(RelNode rel, @Nullable RelTrait toTrait) {
        RelOptPlanner planner = rel.getCluster().getPlanner();
        RelTraitSet outTraits = rel.getTraitSet();
        if (toTrait != null) {
            outTraits = outTraits.replace(toTrait);
        }
        if (rel.getTraitSet().matches(outTraits)) {
            return rel;
        }
        return planner.changeTraits(rel, outTraits.simplify());
    }

    protected static List<RelNode> convertList(List<RelNode> rels, RelTrait trait) {
        return Util.transform(rels, rel -> RelOptRule.convert(rel, rel.getTraitSet().replace(trait)));
    }

    static String guessDescription(String className) {
        String description = className;
        int punc = Math.max(className.lastIndexOf(46), className.lastIndexOf(36));
        if (punc >= 0) {
            description = className.substring(punc + 1);
        }
        if (description.matches("[0-9]+")) {
            throw new RuntimeException("Derived description of rule class " + className + " is an integer, not valid. Supply a description manually.");
        }
        return description;
    }

    protected static class ConverterRelOptRuleOperand
    extends RelOptRuleOperand {
        <R extends RelNode> ConverterRelOptRuleOperand(Class<R> clazz, RelTrait in, Predicate<? super R> predicate) {
            super(clazz, in, predicate, RelOptRuleOperandChildPolicy.ANY, ImmutableList.of());
        }

        @Override
        public boolean matches(RelNode rel) {
            if (rel instanceof Converter && ((ConverterRule)this.getRule()).getTraitDef() == ((Converter)rel).getTraitDef()) {
                return false;
            }
            return super.matches(rel);
        }
    }
}

