/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.InternalCompilerException;
import org.codehaus.janino.Java;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Token;
import org.codehaus.janino.TokenStream;
import org.codehaus.janino.TokenStreamImpl;
import org.codehaus.janino.TokenType;

public class Parser {
    private final Scanner scanner;
    private final TokenStream tokenStream;
    @Nullable
    private String optionalDocComment;
    private static final String[] ACCESS_FLAG_NAMES = new String[]{"public", "protected", "private", "static", "abstract", "final", "native", "synchronized", "transient", "volatile", "strictfp"};
    private static final short[] ACCESS_FLAG_CODES = new short[]{1, 4, 2, 8, 1024, 16, 256, 32, 128, 64, 2048};
    private static final short[] MUTUALLY_EXCLUSIVE_ACCESS_FLAGS = new short[]{7, 1040};
    private static final Java.Modifiers NO_MODIFIERS = new Java.Modifiers();
    @Nullable
    private WarningHandler optionalWarningHandler;

    public Parser(Scanner scanner) {
        this(scanner, new TokenStreamImpl(scanner));
    }

    public Parser(Scanner scanner, TokenStream tokenStream) {
        this.scanner = scanner;
        this.scanner.setIgnoreWhiteSpace(true);
        this.tokenStream = tokenStream;
    }

    @Nullable
    public String doc() {
        String s2 = this.optionalDocComment;
        this.optionalDocComment = null;
        return s2;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public Java.CompilationUnit parseCompilationUnit() throws CompileException, IOException {
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(this.location().getFileName());
        String docComment = this.doc();
        Java.Modifiers modifiers = this.parseModifiers();
        if (this.peek("package")) {
            if (modifiers.isDefault) {
                this.warning("package.defaultModifier", "No \"default\" modifier allowed on package declaration", this.location());
            }
            if (modifiers.accessFlags != 0) {
                this.warning("package.accessFlags", "No access flags allowed on package declaration", this.location());
            }
            compilationUnit.setPackageDeclaration(this.parsePackageDeclaration());
            docComment = this.doc();
            modifiers = this.parseModifiers();
        }
        while (this.peek("import")) {
            if (modifiers.isDefault) {
                this.warning("import.defaultModifier", "No \"default\" modifier allowed on import declaration", this.location());
            }
            if (modifiers.accessFlags != 0) {
                this.warning("import.accessFlags", "No access flags allowed on import declarations", this.location());
            }
            if (modifiers.annotations.length > 0) {
                this.warning("import.annotations", "No annotations allowed on import declarations", this.location());
            }
            if (docComment != null) {
                this.warning("import.doc_comment", "Doc comment on import declaration", this.location());
            }
            compilationUnit.addImportDeclaration(this.parseImportDeclaration());
            docComment = this.doc();
            modifiers = this.parseModifiers();
        }
        if (this.peek(TokenType.END_OF_INPUT)) {
            return compilationUnit;
        }
        compilationUnit.addPackageMemberTypeDeclaration(this.parsePackageMemberTypeDeclarationRest(docComment, modifiers));
        while (!this.peek(TokenType.END_OF_INPUT)) {
            if (this.peekRead(";")) continue;
            compilationUnit.addPackageMemberTypeDeclaration(this.parsePackageMemberTypeDeclaration());
        }
        return compilationUnit;
    }

    public Java.PackageDeclaration parsePackageDeclaration() throws CompileException, IOException {
        this.read("package");
        Location loc = this.location();
        String packageName = Parser.join(this.parseQualifiedIdentifier(), ".");
        this.read(";");
        this.verifyStringIsConventionalPackageName(packageName, loc);
        return new Java.PackageDeclaration(loc, packageName);
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclaration() throws CompileException, IOException {
        this.read("import");
        Java.CompilationUnit.ImportDeclaration importDeclaration = this.parseImportDeclarationBody();
        this.read(";");
        return importDeclaration;
    }

    public Java.CompilationUnit.ImportDeclaration parseImportDeclarationBody() throws CompileException, IOException {
        Location loc = this.location();
        boolean isStatic = this.peekRead("static");
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.read(TokenType.IDENTIFIER));
        while (true) {
            if (!this.peek(".")) {
                String[] identifiers = l.toArray(new String[l.size()]);
                return isStatic ? new Java.CompilationUnit.SingleStaticImportDeclaration(loc, identifiers) : new Java.CompilationUnit.SingleTypeImportDeclaration(loc, identifiers);
            }
            this.read(".");
            if (this.peekRead("*")) {
                String[] identifiers = l.toArray(new String[l.size()]);
                return isStatic ? new Java.CompilationUnit.StaticImportOnDemandDeclaration(loc, identifiers) : new Java.CompilationUnit.TypeImportOnDemandDeclaration(loc, identifiers);
            }
            l.add(this.read(TokenType.IDENTIFIER));
        }
    }

    public String[] parseQualifiedIdentifier() throws CompileException, IOException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.read(TokenType.IDENTIFIER));
        while (this.peek(".") && this.peekNextButOne().type == TokenType.IDENTIFIER) {
            this.read();
            l.add(this.read(TokenType.IDENTIFIER));
        }
        return l.toArray(new String[l.size()]);
    }

    public Java.PackageMemberTypeDeclaration parsePackageMemberTypeDeclaration() throws CompileException, IOException {
        return this.parsePackageMemberTypeDeclarationRest(this.doc(), this.parseModifiers());
    }

    private Java.PackageMemberTypeDeclaration parsePackageMemberTypeDeclarationRest(@Nullable String optionalDocComment, Java.Modifiers modifiers) throws CompileException, IOException {
        if (modifiers.isDefault) {
            this.warning("classOrInterfaceDeclaration.defaultModifier", "No \"default\" modifier allowed for class or interface declaration", this.location());
        }
        switch (this.read("class", "enum", "interface", "@")) {
            case 0: {
                if (optionalDocComment == null) {
                    this.warning("CDCM", "Class doc comment missing", this.location());
                }
                return (Java.PackageMemberClassDeclaration)this.parseClassDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.COMPILATION_UNIT);
            }
            case 1: {
                if (optionalDocComment == null) {
                    this.warning("EDCM", "Enum doc comment missing", this.location());
                }
                return (Java.PackageMemberEnumDeclaration)this.parseEnumDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.COMPILATION_UNIT);
            }
            case 2: {
                if (optionalDocComment == null) {
                    this.warning("IDCM", "Interface doc comment missing", this.location());
                }
                return (Java.PackageMemberInterfaceDeclaration)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers, InterfaceDeclarationContext.COMPILATION_UNIT);
            }
            case 3: {
                this.read("interface");
                if (optionalDocComment == null) {
                    this.warning("ATDCM", "Annotation type doc comment missing", this.location());
                }
                return (Java.PackageMemberAnnotationTypeDeclaration)this.parseAnnotationTypeDeclarationRest(optionalDocComment, modifiers, InterfaceDeclarationContext.COMPILATION_UNIT);
            }
        }
        throw new IllegalStateException();
    }

    public Java.Modifiers parseModifiers() throws CompileException, IOException {
        short afs = 0;
        ArrayList<Java.Annotation> as = new ArrayList<Java.Annotation>();
        boolean isDefault = false;
        while (true) {
            if (this.peek("@")) {
                if (this.peekNextButOne().value.equals("interface")) break;
                as.add(this.parseAnnotation());
                continue;
            }
            if (this.peekRead("default")) {
                if (isDefault) {
                    throw this.compileException("At most one \"default\" modifier allowed\"");
                }
                isDefault = true;
                continue;
            }
            int idx = this.peekRead(ACCESS_FLAG_NAMES);
            if (idx == -1) break;
            String afn = ACCESS_FLAG_NAMES[idx];
            short af = ACCESS_FLAG_CODES[idx];
            if ((afs & af) != 0) {
                throw this.compileException("Duplicate access flag \"" + afn + "\"");
            }
            for (short meafs : MUTUALLY_EXCLUSIVE_ACCESS_FLAGS) {
                if ((af & meafs) == 0 || (afs & meafs) == 0) continue;
                throw this.compileException("Only one of \"" + Mod.shortToString(meafs) + "\" allowed");
            }
            afs = (short)(afs | af);
        }
        if (as.isEmpty() && afs == 0 && !isDefault) {
            return NO_MODIFIERS;
        }
        return new Java.Modifiers(afs, as.toArray(new Java.Annotation[as.size()]), isDefault);
    }

    private Java.Annotation parseAnnotation() throws CompileException, IOException {
        Java.ElementValuePair[] elementValuePairs;
        this.read("@");
        Java.ReferenceType type = new Java.ReferenceType(this.location(), this.parseQualifiedIdentifier(), null);
        if (!this.peekRead("(")) {
            return new Java.MarkerAnnotation(type);
        }
        if (!this.peek(TokenType.IDENTIFIER) || !this.peekNextButOne("=")) {
            Java.ElementValue elementValue = this.parseElementValue();
            this.read(")");
            return new Java.SingleElementAnnotation(type, elementValue);
        }
        if (this.peekRead(")")) {
            elementValuePairs = new Java.ElementValuePair[]{};
        } else {
            ArrayList<Java.ElementValuePair> evps = new ArrayList<Java.ElementValuePair>();
            do {
                evps.add(this.parseElementValuePair());
            } while (this.read(",", ")") == 0);
            elementValuePairs = evps.toArray(new Java.ElementValuePair[evps.size()]);
        }
        return new Java.NormalAnnotation(type, elementValuePairs);
    }

    private Java.ElementValuePair parseElementValuePair() throws CompileException, IOException {
        String identifier = this.read(TokenType.IDENTIFIER);
        this.read("=");
        return new Java.ElementValuePair(identifier, this.parseElementValue());
    }

    private Java.ElementValue parseElementValue() throws CompileException, IOException {
        if (this.peek("@")) {
            return this.parseAnnotation();
        }
        if (this.peek("{")) {
            return this.parseElementValueArrayInitializer();
        }
        return this.parseConditionalAndExpression().toRvalueOrCompileException();
    }

    private Java.ElementValue parseElementValueArrayInitializer() throws CompileException, IOException {
        this.read("{");
        Location loc = this.location();
        ArrayList<Java.ElementValue> evs = new ArrayList<Java.ElementValue>();
        while (!this.peekRead("}")) {
            if (this.peekRead(",")) continue;
            evs.add(this.parseElementValue());
        }
        return new Java.ElementValueArrayInitializer(evs.toArray(new Java.ElementValue[evs.size()]), loc);
    }

    public Java.NamedClassDeclaration parseClassDeclarationRest(@Nullable String optionalDocComment, Java.Modifiers modifiers, ClassDeclarationContext context) throws CompileException, IOException {
        Java.NamedClassDeclaration namedClassDeclaration;
        Location location = this.location();
        String className = this.read(TokenType.IDENTIFIER);
        this.verifyIdentifierIsConventionalClassOrInterfaceName(className, location);
        Java.TypeParameter[] optionalTypeParameters = this.parseTypeParametersOpt();
        Java.ReferenceType optionalExtendedType = null;
        if (this.peekRead("extends")) {
            optionalExtendedType = this.parseReferenceType();
        }
        Java.Type[] implementedTypes = new Java.ReferenceType[]{};
        if (this.peekRead("implements")) {
            implementedTypes = this.parseReferenceTypeList();
        }
        if (context == ClassDeclarationContext.COMPILATION_UNIT) {
            namedClassDeclaration = new Java.PackageMemberClassDeclaration(location, optionalDocComment, modifiers, className, optionalTypeParameters, optionalExtendedType, implementedTypes);
        } else if (context == ClassDeclarationContext.TYPE_DECLARATION) {
            namedClassDeclaration = new Java.MemberClassDeclaration(location, optionalDocComment, modifiers, className, optionalTypeParameters, optionalExtendedType, implementedTypes);
        } else if (context == ClassDeclarationContext.BLOCK) {
            namedClassDeclaration = new Java.LocalClassDeclaration(location, optionalDocComment, modifiers, className, optionalTypeParameters, optionalExtendedType, implementedTypes);
        } else {
            throw new InternalCompilerException("SNO: Class declaration in unexpected context " + (Object)((Object)context));
        }
        this.parseClassBody(namedClassDeclaration);
        return namedClassDeclaration;
    }

    public Java.EnumDeclaration parseEnumDeclarationRest(@Nullable String optionalDocComment, Java.Modifiers modifiers, ClassDeclarationContext context) throws CompileException, IOException {
        Java.NamedClassDeclaration enumDeclaration;
        Location location = this.location();
        String enumName = this.read(TokenType.IDENTIFIER);
        this.verifyIdentifierIsConventionalClassOrInterfaceName(enumName, location);
        if (this.peekRead("<")) {
            throw new CompileException("Enum declaration must not have type parameters", this.location());
        }
        if (this.peekRead("extends")) {
            throw new CompileException("Enum declaration must not have an EXTENDS clause", this.location());
        }
        Java.Type[] implementedTypes = new Java.ReferenceType[]{};
        if (this.peekRead("implements")) {
            implementedTypes = this.parseReferenceTypeList();
        }
        if (context == ClassDeclarationContext.COMPILATION_UNIT) {
            enumDeclaration = new Java.PackageMemberEnumDeclaration(location, optionalDocComment, modifiers, enumName, implementedTypes);
        } else if (context == ClassDeclarationContext.TYPE_DECLARATION) {
            enumDeclaration = new Java.MemberEnumDeclaration(location, optionalDocComment, modifiers, enumName, implementedTypes);
        } else {
            throw new InternalCompilerException("SNO: Enum declaration in unexpected context " + (Object)((Object)context));
        }
        this.parseEnumBody((Java.EnumDeclaration)((Object)enumDeclaration));
        return enumDeclaration;
    }

    public void parseClassBody(Java.AbstractClassDeclaration classDeclaration) throws CompileException, IOException {
        this.read("{");
        while (!this.peekRead("}")) {
            this.parseClassBodyDeclaration(classDeclaration);
        }
        return;
    }

    public void parseEnumBody(Java.EnumDeclaration enumDeclaration) throws CompileException, IOException {
        this.read("{");
        while (this.peek(";", "}") == -1) {
            enumDeclaration.addConstant(this.parseEnumConstant());
            if (this.peekRead(",")) continue;
        }
        while (!this.peekRead("}")) {
            this.parseClassBodyDeclaration((Java.AbstractClassDeclaration)((Object)enumDeclaration));
        }
    }

    public Java.EnumConstant parseEnumConstant() throws CompileException, IOException {
        ArrayList<Java.Annotation> annotations = new ArrayList<Java.Annotation>();
        while (this.peek("@")) {
            annotations.add(this.parseAnnotation());
        }
        String name = this.read(TokenType.IDENTIFIER);
        Java.Rvalue[] arguments = this.peek("(") ? this.parseArguments() : null;
        Java.EnumConstant result = new Java.EnumConstant(this.location(), this.doc(), annotations, name, arguments);
        if (this.peek("{")) {
            this.parseClassBody(result);
        }
        return result;
    }

    public void parseClassBodyDeclaration(Java.AbstractClassDeclaration classDeclaration) throws CompileException, IOException {
        if (this.peekRead(";")) {
            return;
        }
        String optionalDocComment = this.doc();
        Java.Modifiers modifiers = this.parseModifiers();
        if (modifiers.isDefault) {
            throw this.compileException("Modifier \"default\" not allowed on class member");
        }
        if (this.peek("{")) {
            if ((modifiers.accessFlags & 0xFFFFFFF7) != 0) {
                throw this.compileException("Only access flag \"static\" allowed on initializer");
            }
            Java.Initializer initializer = new Java.Initializer(this.location(), Mod.isStatic(modifiers.accessFlags), this.parseBlock());
            classDeclaration.addInitializer(initializer);
            return;
        }
        if (this.peekRead("void")) {
            Location location = this.location();
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", location);
            }
            String name = this.read(TokenType.IDENTIFIER);
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers, null, new Java.PrimitiveType(location, Java.Primitive.VOID), name, false));
            return;
        }
        if (this.peekRead("class")) {
            if (optionalDocComment == null) {
                this.warning("MCDCM", "Member class doc comment missing", this.location());
            }
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, modifiers, ClassDeclarationContext.TYPE_DECLARATION)));
            return;
        }
        if (this.peekRead("enum")) {
            if (optionalDocComment == null) {
                this.warning("MEDCM", "Member enum doc comment missing", this.location());
            }
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseEnumDeclarationRest(optionalDocComment, modifiers.add(16384), ClassDeclarationContext.TYPE_DECLARATION)));
            return;
        }
        if (this.peekRead("interface")) {
            if (optionalDocComment == null) {
                this.warning("MIDCM", "Member interface doc comment missing", this.location());
            }
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers.add(8), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
            return;
        }
        if (this.peek("@") && this.peekNextButOne("interface")) {
            this.read();
            this.read();
            if (optionalDocComment == null) {
                this.warning("MATDCM", "Member annotation type doc comment missing", this.location());
            }
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers.add(8200), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
            return;
        }
        if (classDeclaration instanceof Java.NamedClassDeclaration && this.peek().value.equals(((Java.NamedClassDeclaration)classDeclaration).getName()) && this.peekNextButOne("(")) {
            if (optionalDocComment == null) {
                this.warning("CDCM", "Constructor doc comment missing", this.location());
            }
            classDeclaration.addConstructor(this.parseConstructorDeclarator(optionalDocComment, modifiers));
            return;
        }
        Java.TypeParameter[] optionalTypeParameters = this.parseTypeParametersOpt();
        if (this.peekRead("void")) {
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", this.location());
            }
            String name = this.read(TokenType.IDENTIFIER);
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers, optionalTypeParameters, new Java.PrimitiveType(this.location(), Java.Primitive.VOID), name, false));
            return;
        }
        Java.Type memberType = this.parseType();
        Location location = this.location();
        String memberName = this.read(TokenType.IDENTIFIER);
        if (this.peek("(")) {
            if (optionalDocComment == null) {
                this.warning("MDCM", "Method doc comment missing", this.location());
            }
            classDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers, optionalTypeParameters, memberType, memberName, false));
            return;
        }
        if (optionalTypeParameters != null) {
            throw new CompileException("Type parameters not allowed on field declaration", this.location());
        }
        if (optionalDocComment == null) {
            this.warning("FDCM", "Field doc comment missing", this.location());
        }
        Java.FieldDeclaration fd = new Java.FieldDeclaration(location, optionalDocComment, modifiers, memberType, this.parseFieldDeclarationRest(memberName));
        this.read(";");
        classDeclaration.addFieldDeclaration(fd);
    }

    public Java.InterfaceDeclaration parseInterfaceDeclarationRest(@Nullable String optionalDocComment, Java.Modifiers modifiers, InterfaceDeclarationContext context) throws CompileException, IOException {
        Java.InterfaceDeclaration id;
        Location location = this.location();
        String interfaceName = this.read(TokenType.IDENTIFIER);
        this.verifyIdentifierIsConventionalClassOrInterfaceName(interfaceName, location);
        Java.TypeParameter[] optionalTypeParameters = this.parseTypeParametersOpt();
        Java.Type[] extendedTypes = new Java.ReferenceType[]{};
        if (this.peekRead("extends")) {
            extendedTypes = this.parseReferenceTypeList();
        }
        if (context == InterfaceDeclarationContext.COMPILATION_UNIT) {
            id = new Java.PackageMemberInterfaceDeclaration(location, optionalDocComment, modifiers, interfaceName, optionalTypeParameters, extendedTypes);
        } else if (context == InterfaceDeclarationContext.NAMED_TYPE_DECLARATION) {
            id = new Java.MemberInterfaceDeclaration(location, optionalDocComment, modifiers, interfaceName, optionalTypeParameters, extendedTypes);
        } else {
            throw new InternalCompilerException("SNO: Interface declaration in unexpected context " + (Object)((Object)context));
        }
        this.parseInterfaceBody(id);
        return id;
    }

    public Java.AnnotationTypeDeclaration parseAnnotationTypeDeclarationRest(@Nullable String optionalDocComment, Java.Modifiers modifiers, InterfaceDeclarationContext context) throws CompileException, IOException {
        Java.InterfaceDeclaration atd;
        Location location = this.location();
        String annotationTypeName = this.read(TokenType.IDENTIFIER);
        this.verifyIdentifierIsConventionalClassOrInterfaceName(annotationTypeName, location);
        if (context == InterfaceDeclarationContext.COMPILATION_UNIT) {
            atd = new Java.PackageMemberAnnotationTypeDeclaration(location, optionalDocComment, modifiers, annotationTypeName);
        } else if (context == InterfaceDeclarationContext.NAMED_TYPE_DECLARATION) {
            atd = new Java.MemberAnnotationTypeDeclaration(location, optionalDocComment, modifiers, annotationTypeName);
        } else {
            throw new InternalCompilerException("SNO: Interface declaration in unexpected context " + (Object)((Object)context));
        }
        this.parseInterfaceBody(atd);
        return atd;
    }

    public void parseInterfaceBody(Java.InterfaceDeclaration interfaceDeclaration) throws CompileException, IOException {
        this.read("{");
        while (!this.peekRead("}")) {
            if (this.peekRead(";")) continue;
            String optionalDocComment = this.doc();
            Java.Modifiers modifiers = this.parseModifiers();
            if (this.peekRead("void")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Default interface methods not implemented");
                }
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers.add(1025), null, new Java.PrimitiveType(this.location(), Java.Primitive.VOID), this.read(TokenType.IDENTIFIER), false));
                continue;
            }
            if (this.peekRead("class")) {
                if (optionalDocComment == null) {
                    this.warning("MCDCM", "Member class doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Modifier \"default\" not allowed on member class declaration");
                }
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, modifiers.add(9), ClassDeclarationContext.TYPE_DECLARATION)));
                continue;
            }
            if (this.peekRead("enum")) {
                if (optionalDocComment == null) {
                    this.warning("MEDCM", "Member enum doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Modifier \"default\" not allowed on member enum declaration");
                }
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(optionalDocComment, modifiers.add(16393), ClassDeclarationContext.TYPE_DECLARATION)));
                continue;
            }
            if (this.peekRead("interface")) {
                if (optionalDocComment == null) {
                    this.warning("MIDCM", "Member interface doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Modifier \"default\" not allowed on member interface declaration");
                }
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers.add(9), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
                continue;
            }
            if (this.peek("@") && this.peekNextButOne("interface")) {
                this.read();
                this.read();
                if (optionalDocComment == null) {
                    this.warning("MATDCM", "Member annotation type doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Modifier \"default\" not allowed on member annotation type declaration");
                }
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(optionalDocComment, modifiers.add(8201), InterfaceDeclarationContext.NAMED_TYPE_DECLARATION)));
                continue;
            }
            Java.TypeParameter[] optionalTypeParameters = this.parseTypeParametersOpt();
            if (this.peekRead("void")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Default interface methods not implemented");
                }
                Location location = this.location();
                String name = this.read(TokenType.IDENTIFIER);
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers.add(1025), optionalTypeParameters, new Java.PrimitiveType(location, Java.Primitive.VOID), name, false));
                continue;
            }
            Java.Type memberType = this.parseType();
            String memberName = this.read(TokenType.IDENTIFIER);
            Location location = this.location();
            if (this.peek("(")) {
                if (optionalDocComment == null) {
                    this.warning("MDCM", "Method doc comment missing", this.location());
                }
                if (modifiers.isDefault) {
                    throw this.compileException("Default interface methods not implemented");
                }
                interfaceDeclaration.addDeclaredMethod(this.parseMethodDeclarationRest(optionalDocComment, modifiers.add(1), optionalTypeParameters, memberType, memberName, true));
                continue;
            }
            if (optionalTypeParameters != null) {
                throw new CompileException("Type parameters not allowed with field declaration", this.location());
            }
            if (optionalDocComment == null) {
                this.warning("FDCM", "Field doc comment missing", this.location());
            }
            if (modifiers.isDefault) {
                throw this.compileException("Modifier \"default\" not allowed for fields");
            }
            Java.FieldDeclaration fd = new Java.FieldDeclaration(location, optionalDocComment, modifiers.add(25), memberType, this.parseFieldDeclarationRest(memberName));
            interfaceDeclaration.addConstantDeclaration(fd);
        }
    }

    public Java.ConstructorDeclarator parseConstructorDeclarator(@Nullable String optionalDocComment, Java.Modifiers modifiers) throws CompileException, IOException {
        this.read(TokenType.IDENTIFIER);
        Java.FunctionDeclarator.FormalParameters formalParameters = this.parseFormalParameters();
        Java.Type[] thrownExceptions = this.peekRead("throws") ? this.parseReferenceTypeList() : new Java.ReferenceType[]{};
        Location location = this.location();
        this.read("{");
        Java.ConstructorInvocation optionalConstructorInvocation = null;
        ArrayList<Java.BlockStatement> statements = new ArrayList<Java.BlockStatement>();
        if (this.peek("this", "super", "new", "void", "byte", "char", "short", "int", "long", "float", "double", "boolean") != -1 || this.peekLiteral() || this.peek(TokenType.IDENTIFIER)) {
            Java.Atom a = this.parseExpression();
            if (a instanceof Java.ConstructorInvocation) {
                this.read(";");
                optionalConstructorInvocation = (Java.ConstructorInvocation)a;
            } else {
                Java.Statement s2;
                if (this.peek(TokenType.IDENTIFIER)) {
                    Java.Type variableType = a.toTypeOrCompileException();
                    s2 = new Java.LocalVariableDeclarationStatement(a.getLocation(), new Java.Modifiers(0), variableType, this.parseVariableDeclarators());
                    this.read(";");
                } else {
                    s2 = new Java.ExpressionStatement(a.toRvalueOrCompileException());
                    this.read(";");
                }
                statements.add(s2);
            }
        }
        statements.addAll(this.parseBlockStatements());
        this.read("}");
        return new Java.ConstructorDeclarator(location, optionalDocComment, modifiers, formalParameters, thrownExceptions, optionalConstructorInvocation, statements);
    }

    public Java.MethodDeclarator parseMethodDeclaration(boolean allowDefaultClause) throws CompileException, IOException {
        return this.parseMethodDeclarationRest(this.doc(), this.parseModifiers(), this.parseTypeParametersOpt(), this.parseVoidOrType(), this.read(TokenType.IDENTIFIER), allowDefaultClause);
    }

    public Java.Type parseVoidOrType() throws CompileException, IOException {
        return this.peekRead("void") ? new Java.PrimitiveType(this.location(), Java.Primitive.VOID) : this.parseType();
    }

    public Java.MethodDeclarator parseMethodDeclarationRest(@Nullable String optionalDocComment, Java.Modifiers modifiers, @Nullable Java.TypeParameter[] optionalTypeParameters, Java.Type type, String name, boolean allowDefaultClause) throws CompileException, IOException {
        List<Java.BlockStatement> optionalStatements;
        Java.ElementValue defaultValue;
        Location location = this.location();
        this.verifyIdentifierIsConventionalMethodName(name, location);
        Java.FunctionDeclarator.FormalParameters formalParameters = this.parseFormalParameters();
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            type = new Java.ArrayType(type);
        }
        Java.Type[] thrownExceptions = this.peekRead("throws") ? this.parseReferenceTypeList() : new Java.ReferenceType[]{};
        Java.ElementValue elementValue = defaultValue = allowDefaultClause && this.peekRead("default") ? this.parseElementValue() : null;
        if (this.peekRead(";")) {
            optionalStatements = null;
        } else {
            if (Mod.isAbstract(modifiers.accessFlags) || Mod.isNative(modifiers.accessFlags)) {
                throw this.compileException("Abstract or native method must not have a body");
            }
            this.read("{");
            optionalStatements = this.parseBlockStatements();
            this.read("}");
        }
        return new Java.MethodDeclarator(location, optionalDocComment, modifiers, optionalTypeParameters, type, name, formalParameters, thrownExceptions, defaultValue, optionalStatements);
    }

    public Java.ArrayInitializerOrRvalue parseVariableInitializer() throws CompileException, IOException {
        if (this.peek("{")) {
            return this.parseArrayInitializer();
        }
        return this.parseExpression().toRvalueOrCompileException();
    }

    public Java.ArrayInitializer parseArrayInitializer() throws CompileException, IOException {
        Location location = this.location();
        this.read("{");
        ArrayList<Java.ArrayInitializerOrRvalue> l = new ArrayList<Java.ArrayInitializerOrRvalue>();
        while (!this.peekRead("}")) {
            l.add(this.parseVariableInitializer());
            if (this.peekRead("}")) break;
            this.read(",");
        }
        return new Java.ArrayInitializer(location, l.toArray(new Java.ArrayInitializerOrRvalue[l.size()]));
    }

    public Java.FunctionDeclarator.FormalParameters parseFormalParameters() throws CompileException, IOException {
        this.read("(");
        if (this.peekRead(")")) {
            return new Java.FunctionDeclarator.FormalParameters(this.location());
        }
        ArrayList<Java.FunctionDeclarator.FormalParameter> l = new ArrayList<Java.FunctionDeclarator.FormalParameter>();
        boolean[] hasEllipsis = new boolean[1];
        do {
            if (hasEllipsis[0]) {
                throw this.compileException("Only the last parameter may have an ellipsis");
            }
            l.add(this.parseFormalParameter(hasEllipsis));
        } while (this.read(",", ")") == 0);
        return new Java.FunctionDeclarator.FormalParameters(this.location(), l.toArray(new Java.FunctionDeclarator.FormalParameter[l.size()]), hasEllipsis[0]);
    }

    public Java.FunctionDeclarator.FormalParameter parseFormalParameter(boolean[] hasEllipsis) throws CompileException, IOException {
        Java.Modifiers modifiers = this.parseModifiers();
        if (modifiers.isDefault) {
            throw this.compileException("Modifier \"default\" not allowed on formal parameters");
        }
        if ((modifiers.accessFlags & 0xFFFFFFEF) != 0) {
            this.warning("OFAAAOPD", "Only \"final\" and annotations allowed on parameter declaration", this.location());
        }
        boolean finaL = (modifiers.accessFlags & 0x10) != 0;
        Java.Type type = this.parseType();
        if (this.peekRead(".")) {
            this.read(".");
            this.read(".");
            hasEllipsis[0] = true;
        }
        Location location = this.location();
        String name = this.read(TokenType.IDENTIFIER);
        this.verifyIdentifierIsConventionalLocalVariableOrParameterName(name, location);
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            type = new Java.ArrayType(type);
        }
        return new Java.FunctionDeclarator.FormalParameter(location, finaL, type, name);
    }

    int parseBracketsOpt() throws CompileException, IOException {
        int res = 0;
        while (this.peek("[") && this.peekNextButOne("]")) {
            this.read();
            this.read();
            ++res;
        }
        return res;
    }

    public Java.Block parseMethodBody() throws CompileException, IOException {
        return this.parseBlock();
    }

    public Java.Block parseBlock() throws CompileException, IOException {
        Java.Block block = new Java.Block(this.location());
        this.read("{");
        block.addStatements(this.parseBlockStatements());
        this.read("}");
        return block;
    }

    public List<Java.BlockStatement> parseBlockStatements() throws CompileException, IOException {
        ArrayList<Java.BlockStatement> l = new ArrayList<Java.BlockStatement>();
        while (!(this.peek("}") || this.peek("case") || this.peek("default"))) {
            l.add(this.parseBlockStatement());
        }
        return l;
    }

    public Java.BlockStatement parseBlockStatement() throws CompileException, IOException {
        if (this.peek(TokenType.IDENTIFIER) && this.peekNextButOne(":") || this.peek("if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue", "assert") != -1 || this.peek("{", ";") != -1) {
            return this.parseStatement();
        }
        if (this.peekRead("class")) {
            String optionalDocComment = this.doc();
            if (optionalDocComment == null) {
                this.warning("LCDCM", "Local class doc comment missing", this.location());
            }
            Java.LocalClassDeclaration lcd = (Java.LocalClassDeclaration)this.parseClassDeclarationRest(optionalDocComment, new Java.Modifiers(), ClassDeclarationContext.BLOCK);
            return new Java.LocalClassDeclarationStatement(lcd);
        }
        if (this.peek("final", "@") != -1) {
            Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(this.location(), this.parseModifiers(), this.parseType(), this.parseVariableDeclarators());
            this.read(";");
            return lvds;
        }
        Java.Atom a = this.parseExpression();
        if (this.peekRead(";")) {
            return new Java.ExpressionStatement(a.toRvalueOrCompileException());
        }
        Java.Type variableType = a.toTypeOrCompileException();
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            variableType = new Java.ArrayType(variableType);
        }
        Java.LocalVariableDeclarationStatement lvds = new Java.LocalVariableDeclarationStatement(a.getLocation(), new Java.Modifiers(0), variableType, this.parseVariableDeclarators());
        this.read(";");
        return lvds;
    }

    public Java.VariableDeclarator[] parseVariableDeclarators() throws CompileException, IOException {
        ArrayList<Java.VariableDeclarator> l = new ArrayList<Java.VariableDeclarator>();
        do {
            Java.VariableDeclarator vd = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalLocalVariableOrParameterName(vd.name, vd.getLocation());
            l.add(vd);
        } while (this.peekRead(","));
        return l.toArray(new Java.VariableDeclarator[l.size()]);
    }

    public Java.VariableDeclarator[] parseFieldDeclarationRest(String name) throws CompileException, IOException {
        ArrayList<Java.VariableDeclarator> l = new ArrayList<Java.VariableDeclarator>();
        Java.VariableDeclarator vd = this.parseVariableDeclaratorRest(name);
        this.verifyIdentifierIsConventionalFieldName(vd.name, vd.getLocation());
        l.add(vd);
        while (this.peekRead(",")) {
            vd = this.parseVariableDeclarator();
            this.verifyIdentifierIsConventionalFieldName(vd.name, vd.getLocation());
            l.add(vd);
        }
        return l.toArray(new Java.VariableDeclarator[l.size()]);
    }

    public Java.VariableDeclarator parseVariableDeclarator() throws CompileException, IOException {
        return this.parseVariableDeclaratorRest(this.read(TokenType.IDENTIFIER));
    }

    public Java.VariableDeclarator parseVariableDeclaratorRest(String name) throws CompileException, IOException {
        Location loc = this.location();
        int brackets = this.parseBracketsOpt();
        Java.ArrayInitializerOrRvalue initializer = null;
        if (this.peekRead("=")) {
            initializer = this.parseVariableInitializer();
        }
        return new Java.VariableDeclarator(loc, name, brackets, initializer);
    }

    public Java.Statement parseStatement() throws CompileException, IOException {
        if (this.peek(TokenType.IDENTIFIER) && this.peekNextButOne(":")) {
            return this.parseLabeledStatement();
        }
        Java.Block stmt = this.peek("{") ? this.parseBlock() : (this.peek("if") ? this.parseIfStatement() : (this.peek("for") ? this.parseForStatement() : (this.peek("while") ? this.parseWhileStatement() : (this.peek("do") ? this.parseDoStatement() : (this.peek("try") ? this.parseTryStatement() : (this.peek("switch") ? this.parseSwitchStatement() : (this.peek("synchronized") ? this.parseSynchronizedStatement() : (this.peek("return") ? this.parseReturnStatement() : (this.peek("throw") ? this.parseThrowStatement() : (this.peek("break") ? this.parseBreakStatement() : (this.peek("continue") ? this.parseContinueStatement() : (this.peek("assert") ? this.parseAssertStatement() : (this.peek(";") ? this.parseEmptyStatement() : this.parseExpressionStatement())))))))))))));
        return stmt;
    }

    public Java.Statement parseLabeledStatement() throws CompileException, IOException {
        String label = this.read(TokenType.IDENTIFIER);
        this.read(":");
        return new Java.LabeledStatement(this.location(), label, this.parseStatement());
    }

    public Java.Statement parseIfStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("if");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        Java.Statement thenStatement = this.parseStatement();
        Java.Statement elseStatement = this.peekRead("else") ? this.parseStatement() : null;
        return new Java.IfStatement(location, condition, thenStatement, elseStatement);
    }

    public Java.Statement parseForStatement() throws CompileException, IOException {
        this.read("for");
        Location forLocation = this.location();
        this.read("(");
        Java.Statement optionalInit = null;
        if (!this.peek(";")) {
            if (this.peek("final", "@", "byte", "short", "char", "int", "long", "float", "double", "boolean") != -1) {
                Java.Modifiers modifiers = this.parseModifiers();
                Java.Type type = this.parseType();
                if (this.peek(TokenType.IDENTIFIER) && this.peekNextButOne(":")) {
                    String name = this.read(TokenType.IDENTIFIER);
                    Location nameLocation = this.location();
                    this.read(":");
                    Java.Rvalue expression = this.parseExpression().toRvalueOrCompileException();
                    this.read(")");
                    return new Java.ForEachStatement(forLocation, new Java.FunctionDeclarator.FormalParameter(nameLocation, Mod.isFinal(modifiers.accessFlags), type, name), expression, this.parseStatement());
                }
                optionalInit = new Java.LocalVariableDeclarationStatement(this.location(), modifiers, type, this.parseVariableDeclarators());
            } else {
                Java.Atom a = this.parseExpression();
                if (this.peek(TokenType.IDENTIFIER)) {
                    if (this.peekNextButOne(":")) {
                        String name = this.read(TokenType.IDENTIFIER);
                        Location nameLocation = this.location();
                        this.read(":");
                        Java.Rvalue expression = this.parseExpression().toRvalueOrCompileException();
                        this.read(")");
                        return new Java.ForEachStatement(forLocation, new Java.FunctionDeclarator.FormalParameter(nameLocation, false, a.toTypeOrCompileException(), name), expression, this.parseStatement());
                    }
                    optionalInit = new Java.LocalVariableDeclarationStatement(this.location(), new Java.Modifiers(0), a.toTypeOrCompileException(), this.parseVariableDeclarators());
                } else if (!this.peekRead(",")) {
                    optionalInit = new Java.ExpressionStatement(a.toRvalueOrCompileException());
                } else {
                    ArrayList<Java.ExpressionStatement> l = new ArrayList<Java.ExpressionStatement>();
                    l.add(new Java.ExpressionStatement(a.toRvalueOrCompileException()));
                    do {
                        l.add(new Java.ExpressionStatement(this.parseExpression().toRvalueOrCompileException()));
                    } while (this.peekRead(","));
                    Java.Block b = new Java.Block(a.getLocation());
                    b.addStatements(l);
                    optionalInit = b;
                }
            }
        }
        this.read(";");
        Java.Rvalue optionalCondition = null;
        if (!this.peek(";")) {
            optionalCondition = this.parseExpression().toRvalueOrCompileException();
        }
        this.read(";");
        Java.Rvalue[] optionalUpdate = null;
        if (!this.peek(")")) {
            optionalUpdate = this.parseExpressionList();
        }
        this.read(")");
        return new Java.ForStatement(forLocation, optionalInit, optionalCondition, optionalUpdate, this.parseStatement());
    }

    public Java.Statement parseWhileStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("while");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        return new Java.WhileStatement(location, condition, this.parseStatement());
    }

    public Java.Statement parseDoStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("do");
        Java.Statement body = this.parseStatement();
        this.read("while");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        this.read(";");
        return new Java.DoStatement(location, body, condition);
    }

    public Java.Statement parseTryStatement() throws CompileException, IOException {
        Java.Block finallY;
        Location location = this.location();
        this.read("try");
        ArrayList<Java.TryStatement.Resource> resources = new ArrayList<Java.TryStatement.Resource>();
        if (this.peekRead("(")) {
            resources.add(this.parseResource());
            block4: while (true) {
                switch (this.read(";", ")")) {
                    case 0: {
                        if (this.peekRead(")")) break block4;
                        resources.add(this.parseResource());
                        continue block4;
                    }
                    case 1: {
                        break block4;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                break;
            }
        }
        Java.Block body = this.parseBlock();
        ArrayList<Java.CatchClause> ccs = new ArrayList<Java.CatchClause>();
        while (this.peekRead("catch")) {
            Location loc = this.location();
            this.read("(");
            boolean[] hasEllipsis = new boolean[1];
            Java.FunctionDeclarator.FormalParameter caughtException = this.parseFormalParameter(hasEllipsis);
            if (hasEllipsis[0]) {
                throw this.compileException("Catch clause parameter must not have an ellipsis");
            }
            this.read(")");
            ccs.add(new Java.CatchClause(loc, caughtException, this.parseBlock()));
        }
        Java.Block block = finallY = this.peekRead("finally") ? this.parseBlock() : null;
        if (resources.isEmpty() && ccs.isEmpty() && finallY == null) {
            throw this.compileException("\"try\" statement must have at least one resource, \"catch\" clause or \"finally\" clause");
        }
        return new Java.TryStatement(location, resources, body, ccs, finallY);
    }

    private Java.TryStatement.Resource parseResource() throws CompileException, IOException {
        Location loc = this.location();
        Java.Modifiers modifiers = this.parseModifiers();
        Java.Atom a = this.parseExpression();
        if (modifiers != NO_MODIFIERS || this.peek(TokenType.IDENTIFIER)) {
            if (modifiers.isDefault) {
                throw this.compileException("Modifier \"default\" not allowed on resource");
            }
            if ((modifiers.accessFlags & 0xFFFFFFEF) != 0) {
                throw this.compileException("Only access flag FINAL allowed in this place");
            }
            return new Java.TryStatement.LocalVariableDeclaratorResource(loc, modifiers, a.toTypeOrCompileException(), this.parseVariableDeclarator());
        }
        Java.Rvalue rv = a.toRvalueOrCompileException();
        if (!(rv instanceof Java.FieldAccess)) {
            this.compileException("Rvalue " + rv.getClass().getSimpleName() + " disallowed as a resource");
        }
        return new Java.TryStatement.VariableAccessResource(loc, rv);
    }

    public Java.Statement parseSwitchStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("switch");
        this.read("(");
        Java.Rvalue condition = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        this.read("{");
        ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup> sbsgs = new ArrayList<Java.SwitchStatement.SwitchBlockStatementGroup>();
        while (!this.peekRead("}")) {
            Location location2 = this.location();
            boolean hasDefaultLabel = false;
            ArrayList<Java.Rvalue> caseLabels = new ArrayList<Java.Rvalue>();
            do {
                if (this.peekRead("case")) {
                    caseLabels.add(this.parseExpression().toRvalueOrCompileException());
                } else if (this.peekRead("default")) {
                    if (hasDefaultLabel) {
                        throw this.compileException("Duplicate \"default\" label");
                    }
                    hasDefaultLabel = true;
                } else {
                    throw this.compileException("\"case\" or \"default\" expected");
                }
                this.read(":");
            } while (this.peek("case", "default") != -1);
            Java.SwitchStatement.SwitchBlockStatementGroup sbsg = new Java.SwitchStatement.SwitchBlockStatementGroup(location2, caseLabels, hasDefaultLabel, this.parseBlockStatements());
            sbsgs.add(sbsg);
        }
        return new Java.SwitchStatement(location, condition, sbsgs);
    }

    public Java.Statement parseSynchronizedStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("synchronized");
        this.read("(");
        Java.Rvalue expression = this.parseExpression().toRvalueOrCompileException();
        this.read(")");
        return new Java.SynchronizedStatement(location, expression, this.parseBlock());
    }

    public Java.Statement parseReturnStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("return");
        Java.Rvalue returnValue = this.peek(";") ? null : this.parseExpression().toRvalueOrCompileException();
        this.read(";");
        return new Java.ReturnStatement(location, returnValue);
    }

    public Java.Statement parseThrowStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("throw");
        Java.Rvalue expression = this.parseExpression().toRvalueOrCompileException();
        this.read(";");
        return new Java.ThrowStatement(location, expression);
    }

    public Java.Statement parseBreakStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("break");
        String optionalLabel = null;
        if (this.peek(TokenType.IDENTIFIER)) {
            optionalLabel = this.read(TokenType.IDENTIFIER);
        }
        this.read(";");
        return new Java.BreakStatement(location, optionalLabel);
    }

    public Java.Statement parseContinueStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read("continue");
        String optionalLabel = null;
        if (this.peek(TokenType.IDENTIFIER)) {
            optionalLabel = this.read(TokenType.IDENTIFIER);
        }
        this.read(";");
        return new Java.ContinueStatement(location, optionalLabel);
    }

    public Java.Statement parseAssertStatement() throws CompileException, IOException {
        this.read("assert");
        Location loc = this.location();
        Java.Rvalue expression1 = this.parseExpression().toRvalueOrCompileException();
        Java.Rvalue optionalExpression2 = this.peekRead(":") ? this.parseExpression().toRvalueOrCompileException() : null;
        this.read(";");
        return new Java.AssertStatement(loc, expression1, optionalExpression2);
    }

    public Java.Statement parseEmptyStatement() throws CompileException, IOException {
        Location location = this.location();
        this.read(";");
        return new Java.EmptyStatement(location);
    }

    public Java.Rvalue[] parseExpressionList() throws CompileException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        do {
            l.add(this.parseExpression().toRvalueOrCompileException());
        } while (this.peekRead(","));
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Type parseType() throws CompileException, IOException {
        Java.Type res;
        switch (this.peekRead("byte", "short", "char", "int", "long", "float", "double", "boolean")) {
            case 0: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.BYTE);
                break;
            }
            case 1: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.SHORT);
                break;
            }
            case 2: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.CHAR);
                break;
            }
            case 3: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.INT);
                break;
            }
            case 4: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.LONG);
                break;
            }
            case 5: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.FLOAT);
                break;
            }
            case 6: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.DOUBLE);
                break;
            }
            case 7: {
                res = new Java.PrimitiveType(this.location(), Java.Primitive.BOOLEAN);
                break;
            }
            case -1: {
                res = this.parseReferenceType();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            res = new Java.ArrayType(res);
        }
        return res;
    }

    public Java.ReferenceType parseReferenceType() throws CompileException, IOException {
        return new Java.ReferenceType(this.location(), this.parseQualifiedIdentifier(), this.parseTypeArgumentsOpt());
    }

    @Nullable
    private Java.TypeParameter[] parseTypeParametersOpt() throws CompileException, IOException {
        if (!this.peekRead("<")) {
            return null;
        }
        ArrayList<Java.TypeParameter> l = new ArrayList<Java.TypeParameter>();
        l.add(this.parseTypeParameter());
        while (this.read(",", ">") == 0) {
            l.add(this.parseTypeParameter());
        }
        return l.toArray(new Java.TypeParameter[l.size()]);
    }

    private Java.TypeParameter parseTypeParameter() throws CompileException, IOException {
        String name = this.read(TokenType.IDENTIFIER);
        if (this.peekRead("extends")) {
            ArrayList<Java.ReferenceType> bound = new ArrayList<Java.ReferenceType>();
            bound.add(this.parseReferenceType());
            while (this.peekRead("&")) {
                this.parseReferenceType();
            }
            return new Java.TypeParameter(name, bound.toArray(new Java.ReferenceType[bound.size()]));
        }
        return new Java.TypeParameter(name, null);
    }

    @Nullable
    private Java.TypeArgument[] parseTypeArgumentsOpt() throws CompileException, IOException {
        if (!this.peekRead("<")) {
            return null;
        }
        ArrayList<Java.TypeArgument> typeArguments = new ArrayList<Java.TypeArgument>();
        typeArguments.add(this.parseTypeArgument());
        while (this.read(">", ",") == 1) {
            typeArguments.add(this.parseTypeArgument());
        }
        return typeArguments.toArray(new Java.TypeArgument[typeArguments.size()]);
    }

    private Java.TypeArgument parseTypeArgument() throws CompileException, IOException {
        if (this.peekRead("?")) {
            return this.peekRead("extends") ? new Java.Wildcard(1, this.parseReferenceType()) : (this.peekRead("super") ? new Java.Wildcard(2, this.parseReferenceType()) : new Java.Wildcard());
        }
        Java.Type t = this.parseType();
        for (int i = this.parseBracketsOpt(); i > 0; --i) {
            t = new Java.ArrayType(t);
        }
        if (!(t instanceof Java.TypeArgument)) {
            throw this.compileException("'" + t + "' is not a valid type argument");
        }
        return (Java.TypeArgument)((Object)t);
    }

    public Java.ReferenceType[] parseReferenceTypeList() throws CompileException, IOException {
        ArrayList<Java.ReferenceType> l = new ArrayList<Java.ReferenceType>();
        l.add(this.parseReferenceType());
        while (this.peekRead(",")) {
            l.add(this.parseReferenceType());
        }
        return l.toArray(new Java.ReferenceType[l.size()]);
    }

    public Java.Atom parseExpression() throws CompileException, IOException {
        return this.parseAssignmentExpression();
    }

    public Java.Atom parseAssignmentExpression() throws CompileException, IOException {
        Java.Atom a = this.parseConditionalExpression();
        if (this.peek("=", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>=") != -1) {
            Java.Lvalue lhs = a.toLvalueOrCompileException();
            Location location = this.location();
            String operator = this.read(TokenType.OPERATOR);
            Java.Rvalue rhs = this.parseAssignmentExpression().toRvalueOrCompileException();
            return new Java.Assignment(location, lhs, operator, rhs);
        }
        return a;
    }

    public Java.Atom parseConditionalExpression() throws CompileException, IOException {
        Java.Atom a = this.parseConditionalOrExpression();
        if (!this.peekRead("?")) {
            return a;
        }
        Location location = this.location();
        Java.Rvalue lhs = a.toRvalueOrCompileException();
        Java.Rvalue mhs = this.parseExpression().toRvalueOrCompileException();
        this.read(":");
        Java.Rvalue rhs = this.parseConditionalExpression().toRvalueOrCompileException();
        return new Java.ConditionalExpression(location, lhs, mhs, rhs);
    }

    public Java.Atom parseConditionalOrExpression() throws CompileException, IOException {
        Java.Atom a = this.parseConditionalAndExpression();
        while (this.peekRead("||")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "||", this.parseConditionalAndExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseConditionalAndExpression() throws CompileException, IOException {
        Java.Atom a = this.parseInclusiveOrExpression();
        while (this.peekRead("&&")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "&&", this.parseInclusiveOrExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseInclusiveOrExpression() throws CompileException, IOException {
        Java.Atom a = this.parseExclusiveOrExpression();
        while (this.peekRead("|")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "|", this.parseExclusiveOrExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseExclusiveOrExpression() throws CompileException, IOException {
        Java.Atom a = this.parseAndExpression();
        while (this.peekRead("^")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "^", this.parseAndExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseAndExpression() throws CompileException, IOException {
        Java.Atom a = this.parseEqualityExpression();
        while (this.peekRead("&")) {
            Location location = this.location();
            a = new Java.BinaryOperation(location, a.toRvalueOrCompileException(), "&", this.parseEqualityExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseEqualityExpression() throws CompileException, IOException {
        Java.Atom a = this.parseRelationalExpression();
        while (this.peek("==", "!=") != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseRelationalExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseRelationalExpression() throws CompileException, IOException {
        Java.Atom a = this.parseShiftExpression();
        while (true) {
            if (this.peekRead("instanceof")) {
                Location location = this.location();
                a = new Java.Instanceof(location, a.toRvalueOrCompileException(), this.parseType());
                continue;
            }
            if (this.peek("<", ">", "<=", ">=") == -1) break;
            if (a instanceof Java.AmbiguousName && this.peek("<") && this.peekNextButOne("?")) {
                return new Java.ReferenceType(this.location(), ((Java.AmbiguousName)a).identifiers, this.parseTypeArgumentsOpt());
            }
            String operator = this.read().value;
            Java.Atom rhs = this.parseShiftExpression();
            if ("<".equals(operator) && a instanceof Java.AmbiguousName && this.peek("<", ">", ",") != -1) {
                Java.Type ta;
                String[] identifiers = ((Java.AmbiguousName)a).identifiers;
                this.parseTypeArgumentsOpt();
                Java.Type t = rhs.toTypeOrCompileException();
                if (t instanceof Java.ArrayType) {
                    ta = (Java.ArrayType)t;
                } else if (t instanceof Java.ReferenceType) {
                    ta = (Java.ReferenceType)t;
                } else {
                    throw this.compileException("'" + t + "' is not a valid type argument");
                }
                ArrayList<Java.TypeArgument> typeArguments = new ArrayList<Java.TypeArgument>();
                typeArguments.add((Java.TypeArgument)((Object)ta));
                while (this.read(">", ",") == 1) {
                    typeArguments.add(this.parseTypeArgument());
                }
                return new Java.ReferenceType(this.location(), identifiers, typeArguments.toArray(new Java.TypeArgument[typeArguments.size()]));
            }
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), operator, rhs.toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseShiftExpression() throws CompileException, IOException {
        Java.Atom a = this.parseAdditiveExpression();
        while (this.peek("<<", ">>", ">>>") != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseAdditiveExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseAdditiveExpression() throws CompileException, IOException {
        Java.Atom a = this.parseMultiplicativeExpression();
        while (this.peek("+", "-") != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseMultiplicativeExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseMultiplicativeExpression() throws CompileException, IOException {
        Java.Atom a = this.parseUnaryExpression();
        while (this.peek("*", "/", "%") != -1) {
            a = new Java.BinaryOperation(this.location(), a.toRvalueOrCompileException(), this.read().value, this.parseUnaryExpression().toRvalueOrCompileException());
        }
        return a;
    }

    public Java.Atom parseUnaryExpression() throws CompileException, IOException {
        if (this.peek("++", "--") != -1) {
            return new Java.Crement(this.location(), this.read().value, this.parseUnaryExpression().toLvalueOrCompileException());
        }
        if (this.peek("+", "-", "~", "!") != -1) {
            return new Java.UnaryOperation(this.location(), this.read().value, this.parseUnaryExpression().toRvalueOrCompileException());
        }
        Java.Atom a = this.parsePrimary();
        while (this.peek(".", "[") != -1) {
            a = this.parseSelector(a);
        }
        while (this.peek("++", "--") != -1) {
            a = new Java.Crement(this.location(), a.toLvalueOrCompileException(), this.read().value);
        }
        return a;
    }

    public Java.Atom parsePrimary() throws CompileException, IOException {
        if (this.peekRead("(")) {
            if (this.peek("boolean", "char", "byte", "short", "int", "long", "float", "double") != -1) {
                Java.Type type = this.parseType();
                int brackets = this.parseBracketsOpt();
                this.read(")");
                for (int i = 0; i < brackets; ++i) {
                    type = new Java.ArrayType(type);
                }
                return new Java.Cast(this.location(), type, this.parseUnaryExpression().toRvalueOrCompileException());
            }
            Java.Atom a = this.parseExpression();
            this.read(")");
            if (this.peekLiteral() || this.peek(TokenType.IDENTIFIER) || this.peek("(", "~", "!") != -1 || this.peek("this", "super", "new") != -1) {
                return new Java.Cast(this.location(), a.toTypeOrCompileException(), this.parseUnaryExpression().toRvalueOrCompileException());
            }
            return new Java.ParenthesizedExpression(a.getLocation(), a.toRvalueOrCompileException());
        }
        if (this.peekLiteral()) {
            return this.parseLiteral();
        }
        if (this.peek(TokenType.IDENTIFIER)) {
            Location location = this.location();
            String[] qi = this.parseQualifiedIdentifier();
            if (this.peek("(")) {
                return new Java.MethodInvocation(this.location(), qi.length == 1 ? null : new Java.AmbiguousName(location, qi, qi.length - 1), qi[qi.length - 1], this.parseArguments());
            }
            if (this.peek("[") && this.peekNextButOne("]")) {
                Java.Type res = new Java.ReferenceType(location, qi, null);
                int brackets = this.parseBracketsOpt();
                for (int i = 0; i < brackets; ++i) {
                    res = new Java.ArrayType(res);
                }
                if (this.peek(".") && this.peekNextButOne("class")) {
                    this.read();
                    Location location2 = this.location();
                    this.read();
                    return new Java.ClassLiteral(location2, res);
                }
                return res;
            }
            return new Java.AmbiguousName(location, qi);
        }
        if (this.peekRead("this")) {
            Location location = this.location();
            if (this.peek("(")) {
                return new Java.AlternateConstructorInvocation(location, this.parseArguments());
            }
            return new Java.ThisReference(location);
        }
        if (this.peekRead("super")) {
            if (this.peek("(")) {
                return new Java.SuperConstructorInvocation(this.location(), null, this.parseArguments());
            }
            this.read(".");
            String name = this.read(TokenType.IDENTIFIER);
            if (this.peek("(")) {
                return new Java.SuperclassMethodInvocation(this.location(), name, this.parseArguments());
            }
            return new Java.SuperclassFieldAccessExpression(this.location(), null, name);
        }
        if (this.peekRead("new")) {
            Location location = this.location();
            Java.Type type = this.parseType();
            if (type instanceof Java.ArrayType) {
                return new Java.NewInitializedArray(location, (Java.ArrayType)type, this.parseArrayInitializer());
            }
            if (type instanceof Java.ReferenceType && this.peek("(")) {
                Java.Rvalue[] arguments = this.parseArguments();
                if (this.peek("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, null, anonymousClassDeclaration, arguments);
                }
                return new Java.NewClassInstance(location, (Java.Rvalue)null, type, arguments);
            }
            return new Java.NewArray(location, type, this.parseDimExprs(), this.parseBracketsOpt());
        }
        if (this.peek("boolean", "char", "byte", "short", "int", "long", "float", "double") != -1) {
            Java.Type res = this.parseType();
            int brackets = this.parseBracketsOpt();
            for (int i = 0; i < brackets; ++i) {
                res = new Java.ArrayType(res);
            }
            if (this.peek(".") && this.peekNextButOne("class")) {
                this.read();
                Location location = this.location();
                this.read();
                return new Java.ClassLiteral(location, res);
            }
            return res;
        }
        if (this.peekRead("void")) {
            if (this.peek(".") && this.peekNextButOne("class")) {
                this.read();
                Location location = this.location();
                this.read();
                return new Java.ClassLiteral(location, new Java.PrimitiveType(location, Java.Primitive.VOID));
            }
            throw this.compileException("\"void\" encountered in wrong context");
        }
        throw this.compileException("Unexpected token \"" + this.peek().value + "\" in primary");
    }

    public Java.Atom parseSelector(Java.Atom atom) throws CompileException, IOException {
        if (this.peekRead(".")) {
            this.parseTypeArgumentsOpt();
            if (this.peek().type == TokenType.IDENTIFIER) {
                String identifier = this.read(TokenType.IDENTIFIER);
                if (this.peek("(")) {
                    return new Java.MethodInvocation(this.location(), atom.toRvalueOrCompileException(), identifier, this.parseArguments());
                }
                return new Java.FieldAccessExpression(this.location(), atom.toRvalueOrCompileException(), identifier);
            }
            if (this.peekRead("this")) {
                Location location = this.location();
                return new Java.QualifiedThisReference(location, atom.toTypeOrCompileException());
            }
            if (this.peekRead("super")) {
                Location location = this.location();
                if (this.peek("(")) {
                    return new Java.SuperConstructorInvocation(location, atom.toRvalueOrCompileException(), this.parseArguments());
                }
                this.read(".");
                String identifier = this.read(TokenType.IDENTIFIER);
                if (this.peek("(")) {
                    throw this.compileException("Qualified superclass method invocation NYI");
                }
                return new Java.SuperclassFieldAccessExpression(location, atom.toTypeOrCompileException(), identifier);
            }
            if (this.peekRead("new")) {
                Java.Rvalue lhs = atom.toRvalueOrCompileException();
                Location location = this.location();
                String identifier = this.read(TokenType.IDENTIFIER);
                Java.RvalueMemberType type = new Java.RvalueMemberType(location, lhs, identifier);
                Java.Rvalue[] arguments = this.parseArguments();
                if (this.peek("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.location(), type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, lhs, anonymousClassDeclaration, arguments);
                }
                return new Java.NewClassInstance(location, lhs, type, arguments);
            }
            if (this.peekRead("class")) {
                Location location = this.location();
                return new Java.ClassLiteral(location, atom.toTypeOrCompileException());
            }
            throw this.compileException("Unexpected selector '" + this.peek().value + "' after \".\"");
        }
        if (this.peekRead("[")) {
            Location location = this.location();
            Java.Rvalue index = this.parseExpression().toRvalueOrCompileException();
            this.read("]");
            return new Java.ArrayAccessExpression(location, atom.toRvalueOrCompileException(), index);
        }
        throw this.compileException("Unexpected token '" + this.peek().value + "' in selector");
    }

    public Java.Rvalue[] parseDimExprs() throws CompileException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        l.add(this.parseDimExpr());
        while (this.peek("[") && !this.peekNextButOne("]")) {
            l.add(this.parseDimExpr());
        }
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Rvalue parseDimExpr() throws CompileException, IOException {
        this.read("[");
        Java.Rvalue res = this.parseExpression().toRvalueOrCompileException();
        this.read("]");
        return res;
    }

    public Java.Rvalue[] parseArguments() throws CompileException, IOException {
        this.read("(");
        if (this.peekRead(")")) {
            return new Java.Rvalue[0];
        }
        Java.Rvalue[] arguments = this.parseArgumentList();
        this.read(")");
        return arguments;
    }

    public Java.Rvalue[] parseArgumentList() throws CompileException, IOException {
        ArrayList<Java.Rvalue> l = new ArrayList<Java.Rvalue>();
        do {
            l.add(this.parseExpression().toRvalueOrCompileException());
        } while (this.peekRead(","));
        return l.toArray(new Java.Rvalue[l.size()]);
    }

    public Java.Rvalue parseLiteral() throws CompileException, IOException {
        Token t = this.read();
        switch (t.type) {
            case INTEGER_LITERAL: {
                return new Java.IntegerLiteral(t.getLocation(), t.value);
            }
            case FLOATING_POINT_LITERAL: {
                return new Java.FloatingPointLiteral(t.getLocation(), t.value);
            }
            case BOOLEAN_LITERAL: {
                return new Java.BooleanLiteral(t.getLocation(), t.value);
            }
            case CHARACTER_LITERAL: {
                return new Java.CharacterLiteral(t.getLocation(), t.value);
            }
            case STRING_LITERAL: {
                return new Java.StringLiteral(t.getLocation(), t.value);
            }
            case NULL_LITERAL: {
                return new Java.NullLiteral(t.getLocation());
            }
        }
        throw this.compileException("Literal expected");
    }

    public Java.Statement parseExpressionStatement() throws CompileException, IOException {
        Java.Rvalue rv = this.parseExpression().toRvalueOrCompileException();
        this.read(";");
        return new Java.ExpressionStatement(rv);
    }

    public Location location() {
        return this.scanner.location();
    }

    public Token peek() throws CompileException, IOException {
        return this.tokenStream.peek();
    }

    public Token read() throws CompileException, IOException {
        return this.tokenStream.read();
    }

    public boolean peek(String suspected) throws CompileException, IOException {
        return this.tokenStream.peek(suspected);
    }

    public int peek(String ... suspected) throws CompileException, IOException {
        return this.tokenStream.peek(suspected);
    }

    public boolean peek(TokenType suspected) throws CompileException, IOException {
        return this.tokenStream.peek(suspected);
    }

    public int peek(TokenType ... suspected) throws CompileException, IOException {
        return this.tokenStream.peek(suspected);
    }

    public Token peekNextButOne() throws CompileException, IOException {
        return this.tokenStream.peekNextButOne();
    }

    public boolean peekNextButOne(String suspected) throws CompileException, IOException {
        return this.tokenStream.peekNextButOne(suspected);
    }

    public void read(String expected) throws CompileException, IOException {
        this.tokenStream.read(expected);
    }

    public int read(String ... expected) throws CompileException, IOException {
        return this.tokenStream.read(expected);
    }

    public String read(TokenType expected) throws CompileException, IOException {
        return this.tokenStream.read(expected);
    }

    public boolean peekRead(String suspected) throws CompileException, IOException {
        return this.tokenStream.peekRead(suspected);
    }

    public int peekRead(String ... suspected) throws CompileException, IOException {
        return this.tokenStream.peekRead(suspected);
    }

    public boolean peekLiteral() throws CompileException, IOException {
        return this.peek(TokenType.INTEGER_LITERAL, TokenType.FLOATING_POINT_LITERAL, TokenType.BOOLEAN_LITERAL, TokenType.CHARACTER_LITERAL, TokenType.STRING_LITERAL, TokenType.NULL_LITERAL) != -1;
    }

    private void verifyStringIsConventionalPackageName(String s2, Location loc) throws CompileException {
        if (!Character.isLowerCase(s2.charAt(0))) {
            this.warning("UPN", "Package name \"" + s2 + "\" does not begin with a lower-case letter (see JLS7 6.8.1)", loc);
            return;
        }
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (Character.isLowerCase(c) || c == '_' || c == '.') continue;
            this.warning("PPN", "Poorly chosen package name \"" + s2 + "\" contains bad character '" + c + "'", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalClassOrInterfaceName(String id, Location loc) throws CompileException {
        if (!Character.isUpperCase(id.charAt(0))) {
            this.warning("UCOIN1", "Class or interface name \"" + id + "\" does not begin with an upper-case letter (see JLS7 6.8.2)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("UCOIN", "Class or interface name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.2)", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalMethodName(String id, Location loc) throws CompileException {
        if (!Character.isLowerCase(id.charAt(0))) {
            this.warning("UMN1", "Method name \"" + id + "\" does not begin with a lower-case letter (see JLS7 6.8.3)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("UMN", "Method name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.3)", loc);
            return;
        }
    }

    private void verifyIdentifierIsConventionalFieldName(String id, Location loc) throws CompileException {
        if (Character.isUpperCase(id.charAt(0))) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isUpperCase(c) || Character.isDigit(c) || c == '_') continue;
                this.warning("UCN", "Constant name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.5)", loc);
                return;
            }
        } else if (Character.isLowerCase(id.charAt(0))) {
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c)) continue;
                this.warning("UFN", "Field name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.4)", loc);
                return;
            }
        } else {
            this.warning("UFN1", "\"" + id + "\" is neither a conventional field name (JLS7 6.8.4) nor a conventional constant name (JLS7 6.8.5)", loc);
        }
    }

    private void verifyIdentifierIsConventionalLocalVariableOrParameterName(String id, Location loc) throws CompileException {
        if (!Character.isLowerCase(id.charAt(0))) {
            this.warning("ULVN1", "Local variable name \"" + id + "\" does not begin with a lower-case letter (see JLS7 6.8.6)", loc);
            return;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c)) continue;
            this.warning("ULVN", "Local variable name \"" + id + "\" contains unconventional character \"" + c + "\" (see JLS7 6.8.6)", loc);
            return;
        }
    }

    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
        this.tokenStream.setWarningHandler(optionalWarningHandler);
    }

    private void warning(String handle, String message, @Nullable Location optionalLocation) throws CompileException {
        if (this.optionalWarningHandler != null) {
            this.optionalWarningHandler.handleWarning(handle, message, optionalLocation);
        }
    }

    protected final CompileException compileException(String message) {
        return new CompileException(message, this.location());
    }

    private static String join(@Nullable String[] sa, String separator) {
        if (sa == null) {
            return "(null)";
        }
        if (sa.length == 0) {
            return "(zero length array)";
        }
        StringBuilder sb = new StringBuilder(sa[0]);
        for (int i = 1; i < sa.length; ++i) {
            sb.append(separator).append(sa[i]);
        }
        return sb.toString();
    }

    public static enum InterfaceDeclarationContext {
        NAMED_TYPE_DECLARATION,
        COMPILATION_UNIT;

    }

    public static enum ClassDeclarationContext {
        BLOCK,
        TYPE_DECLARATION,
        COMPILATION_UNIT;

    }
}

