/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.Content;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class LongContent
implements Content<LongContent> {
    private long v;

    public LongContent(long v) {
        Preconditions.checkArgument(v >= 0L);
        this.v = v;
    }

    public long value() {
        return this.v;
    }

    @Override
    public int compareTo(LongContent o) {
        return Long.compare(this.v, o.v);
    }

    @Override
    public void add(LongContent other) {
        this.v += other.v;
    }

    @Override
    public LongContent clone() {
        return new LongContent(this.v);
    }

    public int hashCode() {
        return ~Objects.hashCode(this.v);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LongContent)) {
            return false;
        }
        LongContent other = (LongContent)o;
        return this.v == other.v;
    }

    @Override
    public void shiftRight(int n) {
        Preconditions.checkArgument(n >= 0);
        this.v >>>= Math.min(n, 63);
    }

    @Override
    public boolean isZero() {
        return this.v == 0L;
    }

    @Override
    public boolean isOne() {
        return this.v == 1L;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

