/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.util.ImmutableBeans;

public class Hoist {
    private final Config config;

    public static Config config() {
        return ImmutableBeans.create(Config.class).withParserConfig(SqlParser.config());
    }

    public static Hoist create(Config config) {
        return new Hoist(config);
    }

    private Hoist(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public static String ordinalString(Variable v) {
        return "?" + v.ordinal;
    }

    public static String ordinalStringIfChar(Variable v) {
        if (v.node instanceof SqlLiteral && ((SqlLiteral)v.node).getTypeName() == SqlTypeName.CHAR) {
            return "?" + v.ordinal;
        }
        return v.sql();
    }

    public Hoisted hoist(final String sql) {
        SqlNode node;
        final ArrayList<Variable> variables = new ArrayList<Variable>();
        SqlParser parser = SqlParser.create(sql, this.config.parserConfig());
        try {
            node = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new RuntimeException(e);
        }
        node.accept(new SqlShuttle(){

            @Override
            public SqlNode visit(SqlLiteral literal) {
                variables.add(new Variable(sql, variables.size(), literal));
                return super.visit(literal);
            }
        });
        return new Hoisted(sql, variables);
    }

    public static class Hoisted {
        public final String originalSql;
        public final List<Variable> variables;

        Hoisted(String originalSql, List<Variable> variables) {
            this.originalSql = originalSql;
            this.variables = ImmutableList.copyOf(variables);
        }

        public String toString() {
            return this.substitute(Hoist::ordinalString);
        }

        public String substitute(Function<Variable, String> fn) {
            StringBuilder b = new StringBuilder(this.originalSql);
            for (Variable variable : Lists.reverse(this.variables)) {
                String s2 = fn.apply(variable);
                b.replace(variable.start, variable.end, s2);
            }
            return b.toString();
        }
    }

    public static class Variable {
        public final String originalSql;
        public final int ordinal;
        public final SqlNode node;
        public final int start;
        public final int end;

        private Variable(String originalSql, int ordinal, SqlNode node) {
            this.originalSql = Objects.requireNonNull(originalSql);
            this.ordinal = ordinal;
            this.node = Objects.requireNonNull(node);
            SqlParserPos pos = node.getParserPosition();
            this.start = SqlParserUtil.lineColToIndex(originalSql, pos.getLineNum(), pos.getColumnNum());
            this.end = SqlParserUtil.lineColToIndex(originalSql, pos.getEndLineNum(), pos.getEndColumnNum()) + 1;
            Preconditions.checkArgument(ordinal >= 0);
            Preconditions.checkArgument(this.start >= 0);
            Preconditions.checkArgument(this.start <= this.end);
            Preconditions.checkArgument(this.end <= originalSql.length());
        }

        public String sql() {
            return this.originalSql.substring(this.start, this.end);
        }
    }

    public static interface Config {
        @ImmutableBeans.Property
        @Nonnull
        public SqlParser.Config parserConfig();

        public Config withParserConfig(SqlParser.Config var1);
    }
}

