/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.materialize;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.materialize.MaterializationKey;
import org.apache.calcite.materialize.TileKey;
import org.apache.calcite.rel.type.RelDataType;

class MaterializationActor {
    final Map<MaterializationKey, Materialization> keyMap = new HashMap<MaterializationKey, Materialization>();
    final Map<QueryKey, MaterializationKey> keyBySql = new HashMap<QueryKey, MaterializationKey>();
    final Map<TileKey, MaterializationKey> keyByTile = new HashMap<TileKey, MaterializationKey>();
    final Multimap<TileKey, TileKey> tilesByDimensionality = HashMultimap.create();

    MaterializationActor() {
    }

    static class QueryKey {
        final String sql;
        final CalciteSchema schema;
        final List<String> path;

        QueryKey(String sql, CalciteSchema schema, List<String> path) {
            this.sql = sql;
            this.schema = schema;
            this.path = path;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QueryKey && this.sql.equals(((QueryKey)obj).sql) && this.schema.equals(((QueryKey)obj).schema) && this.path.equals(((QueryKey)obj).path);
        }

        public int hashCode() {
            return Objects.hash(this.sql, this.schema, this.path);
        }
    }

    static class Materialization {
        final MaterializationKey key;
        final CalciteSchema rootSchema;
        CalciteSchema.TableEntry materializedTable;
        final String sql;
        final RelDataType rowType;
        final List<String> viewSchemaPath;

        Materialization(MaterializationKey key, CalciteSchema rootSchema, CalciteSchema.TableEntry materializedTable, String sql, RelDataType rowType, List<String> viewSchemaPath) {
            this.key = key;
            this.rootSchema = Objects.requireNonNull(rootSchema);
            Preconditions.checkArgument(rootSchema.isRoot(), "must be root schema");
            this.materializedTable = materializedTable;
            this.sql = sql;
            this.rowType = rowType;
            this.viewSchemaPath = viewSchemaPath;
        }
    }
}

