/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.IndexCalculator;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.SpaceVisitor;
import com.google.uzaygezen.core.ZoomingNavigator;
import java.util.Arrays;
import java.util.Collections;

public class ZoomingSpaceVisitorAdapter
implements ZoomingNavigator {
    private final IndexCalculator curve;
    private final SpaceVisitor visitor;
    private final int[] m;

    public ZoomingSpaceVisitorAdapter(IndexCalculator curve, SpaceVisitor visitor) {
        this.curve = curve;
        this.visitor = visitor;
        this.m = Ints.toArray(curve.getSpec().getBitsPerDimension());
    }

    @Override
    public boolean visit(int level, BitVector index, BitVector[] p) {
        this.checkArguments(level, p);
        Pow2LengthBitSetRange[] ranges = new Pow2LengthBitSetRange[p.length];
        int n = p.length;
        int lowOrderBitCount = 0;
        for (int i = 0; i < n; ++i) {
            int realLevel = Math.min(this.m[i], level);
            ranges[i] = new Pow2LengthBitSetRange(p[i], realLevel);
            lowOrderBitCount += realLevel;
        }
        assert (this.computeIndex(p, level).equals(index));
        assert (index.areAllLowestBitsClear(lowOrderBitCount));
        boolean needChildren = this.visitor.visit(new Pow2LengthBitSetRange(index, lowOrderBitCount), Collections.unmodifiableList(Arrays.asList(ranges)));
        return needChildren;
    }

    private BitVector computeIndex(BitVector[] p, int level) {
        BitVector index = (BitVector)BitVectorFactories.OPTIMAL.apply(this.curve.getSpec().sumBitsPerDimension());
        this.curve.index(p, level, index);
        return index;
    }

    private void checkArguments(int level, BitVector[] p) {
        Preconditions.checkArgument(0 <= level & level <= this.curve.getSpec().maxBitsPerDimension(), "Level out of range.");
        int len = p.length;
        Preconditions.checkArgument(len == this.m.length, "p.length must match the number of dimensions.");
        for (int i = 0; i < len; ++i) {
            BitVector point = p[i];
            int pointSize = point.size();
            Preconditions.checkArgument(pointSize == this.m[i] & (pointSize < level && point.isEmpty() || point.areAllLowestBitsClear(level)));
        }
    }
}

