/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.application;

import com.dask.sql.application.DaskSqlDialect;
import com.dask.sql.application.DaskSqlParserImplFactory;
import com.dask.sql.schema.DaskSchema;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;

public class RelationalAlgebraGenerator {
    final Planner planner;
    final HepPlanner hepPlanner;

    public RelationalAlgebraGenerator(String rootSchemaName, List<DaskSchema> schemas, boolean case_sensitive) throws ClassNotFoundException, SQLException {
        SchemaPlus rootSchema = this.createRootSchema(rootSchemaName, schemas);
        JavaTypeFactoryImpl typeFactory = this.createTypeFactory();
        CalciteCatalogReader calciteCatalogReader = this.createCatalogReader(rootSchemaName, rootSchema, typeFactory);
        SqlOperatorTable operatorTable = this.createOperatorTable(calciteCatalogReader);
        SqlParser.Config parserConfig = this.createParserConfig(case_sensitive);
        SchemaPlus schemaPlus = rootSchema.getSubSchema(rootSchemaName);
        FrameworkConfig frameworkConfig = this.createFrameworkConfig(schemaPlus, operatorTable, parserConfig);
        this.planner = this.createPlanner(frameworkConfig);
        this.hepPlanner = this.createHepPlanner(frameworkConfig);
    }

    public static SqlDialect getDialect() {
        return DaskSqlDialect.DEFAULT;
    }

    public SqlNode getSqlNode(String sql) throws SqlParseException {
        try {
            return this.planner.parse(sql);
        }
        catch (SqlParseException e) {
            this.planner.close();
            throw e;
        }
    }

    public SqlNode getValidatedNode(SqlNode sqlNode) throws ValidationException {
        try {
            return this.planner.validate(sqlNode);
        }
        catch (ValidationException e) {
            this.planner.close();
            throw e;
        }
    }

    public RelNode getRelationalAlgebra(SqlNode validatedSqlNode) throws RelConversionException {
        try {
            return this.planner.rel(validatedSqlNode).project(true);
        }
        catch (RelConversionException e) {
            this.planner.close();
            throw e;
        }
    }

    public RelNode getOptimizedRelationalAlgebra(RelNode nonOptimizedPlan) {
        this.hepPlanner.setRoot(nonOptimizedPlan);
        this.planner.close();
        return this.hepPlanner.findBestExp();
    }

    public String getRelationalAlgebraString(RelNode relNode) {
        return RelOptUtil.toString(relNode);
    }

    private Planner createPlanner(FrameworkConfig config) {
        return Frameworks.getPlanner(config);
    }

    private JavaTypeFactoryImpl createTypeFactory() {
        return new JavaTypeFactoryImpl(DaskSqlDialect.DASKSQL_TYPE_SYSTEM);
    }

    private SchemaPlus createRootSchema(String rootSchemaName, List<DaskSchema> schemas) throws SQLException {
        CalciteConnection calciteConnection = this.createConnection(rootSchemaName);
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        for (DaskSchema schema : schemas) {
            rootSchema.add(schema.getName(), schema);
        }
        return rootSchema;
    }

    private CalciteConnection createConnection(String schemaName) throws SQLException {
        Properties info = new Properties();
        info.setProperty("lex", "JAVA");
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
        calciteConnection.setSchema(schemaName);
        return calciteConnection;
    }

    private CalciteCatalogReader createCatalogReader(String schemaName, SchemaPlus schemaPlus, JavaTypeFactoryImpl typeFactory) {
        CalciteSchema calciteSchema = CalciteSchema.from(schemaPlus);
        Properties props = new Properties();
        props.setProperty("defaultSchema", schemaName);
        ArrayList<String> defaultSchema = new ArrayList<String>();
        defaultSchema.add(schemaName);
        CalciteCatalogReader calciteCatalogReader = new CalciteCatalogReader(calciteSchema, defaultSchema, typeFactory, new CalciteConnectionConfigImpl(props));
        return calciteCatalogReader;
    }

    private SqlOperatorTable createOperatorTable(CalciteCatalogReader calciteCatalogReader) {
        ArrayList<SqlOperatorTable> sqlOperatorTables = new ArrayList<SqlOperatorTable>();
        sqlOperatorTables.add(SqlStdOperatorTable.instance());
        sqlOperatorTables.add(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(SqlLibrary.POSTGRESQL));
        sqlOperatorTables.add(calciteCatalogReader);
        SqlOperatorTable operatorTable = SqlOperatorTables.chain(sqlOperatorTables);
        return operatorTable;
    }

    private SqlParser.Config createParserConfig(boolean case_sensitive) {
        return RelationalAlgebraGenerator.getDialect().configureParser(SqlParser.Config.DEFAULT).withConformance(SqlConformanceEnum.DEFAULT).withCaseSensitive(case_sensitive).withParserFactory(new DaskSqlParserImplFactory());
    }

    private FrameworkConfig createFrameworkConfig(SchemaPlus schemaPlus, SqlOperatorTable operatorTable, SqlParser.Config parserConfig) {
        Context defaultContext = Contexts.of((Object)CalciteConnectionConfig.DEFAULT.set(CalciteConnectionProperty.TYPE_SYSTEM, "com.dask.sql.application.DaskSqlDialect#DASKSQL_TYPE_SYSTEM"));
        return Frameworks.newConfigBuilder().context(defaultContext).defaultSchema(schemaPlus).parserConfig(parserConfig).executor(new RexExecutorImpl(null)).operatorTable(operatorTable).build();
    }

    private HepPlanner createHepPlanner(FrameworkConfig config) {
        HepProgram program = new HepProgramBuilder().addRuleInstance(CoreRules.AGGREGATE_PROJECT_MERGE).addRuleInstance(CoreRules.AGGREGATE_PROJECT_PULL_UP_CONSTANTS).addRuleInstance(CoreRules.AGGREGATE_ANY_PULL_UP_CONSTANTS).addRuleInstance(CoreRules.AGGREGATE_REDUCE_FUNCTIONS).addRuleInstance(CoreRules.AGGREGATE_MERGE).addRuleInstance(CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES_TO_JOIN).addRuleInstance(CoreRules.AGGREGATE_JOIN_REMOVE).addRuleInstance(CoreRules.FILTER_AGGREGATE_TRANSPOSE).addRuleInstance(CoreRules.JOIN_CONDITION_PUSH).addRuleInstance(CoreRules.FILTER_INTO_JOIN).addRuleInstance(CoreRules.PROJECT_MERGE).addRuleInstance(CoreRules.FILTER_MERGE).addRuleInstance(CoreRules.PROJECT_JOIN_TRANSPOSE).addRuleInstance(CoreRules.PROJECT_REDUCE_EXPRESSIONS).addRuleInstance(CoreRules.FILTER_REDUCE_EXPRESSIONS).addRuleInstance(CoreRules.FILTER_EXPAND_IS_NOT_DISTINCT_FROM).addRuleInstance(CoreRules.PROJECT_TO_LOGICAL_PROJECT_AND_WINDOW).build();
        return new HepPlanner(program, config.getContext());
    }
}

