/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.ImmutableBitSet;

public class ProjectFilterTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectFilterTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectFilterTransposeRule(Class<? extends Project> projectClass, Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory, PushProjector.ExprCondition preserveExprCondition) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(projectClass, filterClass).withPreserveExprCondition(preserveExprCondition));
    }

    @Deprecated
    protected ProjectFilterTransposeRule(RelOptRuleOperand operand, PushProjector.ExprCondition preserveExprCondition, boolean wholeProject, boolean wholeFilter, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withOperandSupplier(b -> b.exactly(operand)).withRelBuilderFactory(relBuilderFactory).as(Config.class).withPreserveExprCondition(preserveExprCondition).withWholeProject(wholeProject).withWholeFilter(wholeFilter));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode topProject;
        Filter filter;
        Project origProject;
        if (call.rels.length >= 2) {
            origProject = (Project)call.rel(0);
            filter = (Filter)call.rel(1);
        } else {
            origProject = null;
            filter = (Filter)call.rel(0);
        }
        RelNode input = filter.getInput();
        RexNode origFilter = filter.getCondition();
        if (origProject != null && origProject.containsOver()) {
            return;
        }
        if (origProject != null && origProject.getRowType().isStruct() && origProject.getRowType().getFieldList().stream().anyMatch(RelDataTypeField::isDynamicStar)) {
            return;
        }
        RelBuilder builder = call.builder();
        if (origProject != null && (((Config)this.config).isWholeProject() || ((Config)this.config).isWholeFilter())) {
            builder.push(input);
            LinkedHashSet<RexNode> set = new LinkedHashSet<RexNode>();
            RelOptUtil.InputFinder refCollector = new RelOptUtil.InputFinder();
            if (((Config)this.config).isWholeFilter()) {
                set.add(filter.getCondition());
            } else {
                filter.getCondition().accept(refCollector);
            }
            if (((Config)this.config).isWholeProject()) {
                set.addAll(origProject.getProjects());
            } else {
                refCollector.visitEach(origProject.getProjects());
            }
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            ImmutableBitSet refs = refCollector.build();
            for (RexNode field : builder.fields()) {
                if (!refs.get(((RexInputRef)field).getIndex()) && !set.contains(field)) continue;
                list.add(field);
            }
            set.removeAll(list);
            list.addAll(set);
            builder.project(list);
            Replacer replacer = new Replacer(list, builder);
            builder.filter(replacer.visit(filter.getCondition()));
            builder.project(replacer.visitList(origProject.getProjects()), origProject.getRowType().getFieldNames());
            topProject = builder.build();
        } else {
            PushProjector pushProjector = new PushProjector(origProject, origFilter, input, ((Config)this.config).preserveExprCondition(), builder);
            topProject = pushProjector.convertProject(null);
        }
        if (topProject != null) {
            call.transformTo(topProject);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(LogicalProject.class, LogicalFilter.class).withPreserveExprCondition(expr -> false).withWholeProject(false).withWholeFilter(false);
        public static final Config PROJECT = DEFAULT.withWholeProject(true);
        public static final Config PROJECT_FILTER = PROJECT.withWholeFilter(true);

        @Override
        default public ProjectFilterTransposeRule toRule() {
            return new ProjectFilterTransposeRule(this);
        }

        @ImmutableBeans.Property
        public PushProjector.ExprCondition preserveExprCondition();

        public Config withPreserveExprCondition(PushProjector.ExprCondition var1);

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=false)
        public boolean isWholeProject();

        public Config withWholeProject(boolean var1);

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=false)
        public boolean isWholeFilter();

        public Config withWholeFilter(boolean var1);

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Filter> filterClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(filterClass).anyInputs())).as(Config.class);
        }

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Filter> filterClass, Class<? extends RelNode> inputClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(filterClass).oneInput(b2 -> b2.operand(inputClass).anyInputs()))).as(Config.class);
        }
    }

    private static class Replacer
    extends RexShuttle {
        final ImmutableMap<RexNode, Integer> map;
        final RelBuilder relBuilder;

        Replacer(Iterable<? extends RexNode> exprs, RelBuilder relBuilder) {
            this.relBuilder = relBuilder;
            ImmutableMap.Builder<RexNode, Integer> b = ImmutableMap.builder();
            int i = 0;
            for (RexNode rexNode : exprs) {
                b.put(rexNode, i++);
            }
            this.map = b.build();
        }

        RexNode visit(RexNode e) {
            Integer i = this.map.get(e);
            if (i != null) {
                return this.relBuilder.field(i);
            }
            return e.accept(this);
        }

        @Override
        public void visitList(Iterable<? extends RexNode> exprs, List<RexNode> out) {
            for (RexNode rexNode : exprs) {
                out.add(this.visit(rexNode));
            }
        }

        @Override
        protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
            ImmutableList.Builder clonedOperands = ImmutableList.builder();
            for (RexNode rexNode : exprs) {
                RexNode clonedOperand = this.visit(rexNode);
                if (clonedOperand != rexNode && update != null) {
                    update[0] = true;
                }
                clonedOperands.add(clonedOperand);
            }
            return clonedOperands.build();
        }
    }
}

