/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.util.ImmutableBitSet;

public class Statistics {
    public static final Statistic UNKNOWN = new Statistic(){};

    private Statistics() {
    }

    public static Statistic of(List<RelReferentialConstraint> referentialConstraints) {
        return Statistics.of(null, null, referentialConstraints, null);
    }

    public static Statistic of(double rowCount, List<ImmutableBitSet> keys) {
        return Statistics.of(rowCount, keys, null, null);
    }

    public static Statistic of(double rowCount, List<ImmutableBitSet> keys, List<RelCollation> collations) {
        return Statistics.of(rowCount, keys, null, collations);
    }

    public static Statistic of(final Double rowCount, List<ImmutableBitSet> keys, List<RelReferentialConstraint> referentialConstraints, List<RelCollation> collations) {
        final ImmutableList<Object> keysCopy = keys == null ? ImmutableList.of() : ImmutableList.copyOf(keys);
        final ImmutableList<RelReferentialConstraint> referentialConstraintsCopy = referentialConstraints == null ? null : ImmutableList.copyOf(referentialConstraints);
        final ImmutableList<RelCollation> collationsCopy = collations == null ? null : ImmutableList.copyOf(collations);
        return new Statistic(){

            @Override
            public Double getRowCount() {
                return rowCount;
            }

            @Override
            public boolean isKey(ImmutableBitSet columns) {
                for (ImmutableBitSet key : keysCopy) {
                    if (!columns.contains(key)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public List<ImmutableBitSet> getKeys() {
                return keysCopy;
            }

            @Override
            public List<RelReferentialConstraint> getReferentialConstraints() {
                return referentialConstraintsCopy;
            }

            @Override
            public List<RelCollation> getCollations() {
                return collationsCopy;
            }
        };
    }
}

