/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.BitVectorFactories;
import com.google.uzaygezen.core.LongContent;
import com.google.uzaygezen.core.ranges.LongRange;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Comparator;

public class TestUtils {
    public static final LongRange ZERO_ONE = LongRange.of(0L, 1L);
    public static final LongRange ZERO_TWO = LongRange.of(0L, 2L);
    public static final LongRange ZERO_FOUR = LongRange.of(0L, 4L);
    public static final LongRange ZERO_TEN = LongRange.of(0L, 10L);
    public static final LongRange ONE_TEN = LongRange.of(1L, 10L);
    public static final LongRange TWO_FOUR = LongRange.of(2L, 4L);
    public static final LongRange TWO_SIX = LongRange.of(2L, 6L);
    public static final LongRange TWO_TEN = LongRange.of(2L, 10L);
    public static final LongRange THREE_FOUR = LongRange.of(3L, 4L);
    public static final LongRange FOUR_EIGHT = LongRange.of(4L, 8L);
    public static final LongRange THREE_SEVEN = LongRange.of(3L, 7L);
    public static final LongRange SIX_SEVEN = LongRange.of(6L, 7L);
    public static final LongRange SIX_TEN = LongRange.of(6L, 10L);
    public static final LongRange EIGHT_TEN = LongRange.of(8L, 10L);
    public static final long SEED = TestUtils.computeSeed();
    public static final LongContent ZERO_LONG_CONTENT = new ImmutableLongContent(0L);
    public static final LongContent ONE_LONG_CONTENT = new ImmutableLongContent(1L);

    private TestUtils() {
    }

    public static BitSet unsignedIntToLittleEndianBitSet(int i) {
        BitSet bs = new BitSet(32);
        for (int j = 0; j < 32; ++j) {
            if ((i & 1) == 1) {
                bs.set(j);
            }
            i >>>= 1;
        }
        return bs;
    }

    public static void generateSpec(int maxDimensions, int maxDimBitsSum, IntArrayCallback callback) {
        TestUtils.generateSpec(maxDimensions, maxDimBitsSum, false, callback);
    }

    public static void generateSpecWithExactSum(int maxDimensions, int dimBitsSum, IntArrayCallback callback) {
        TestUtils.generateSpec(maxDimensions, dimBitsSum, true, callback);
    }

    private static void generateSpec(int maxDimensions, int maxDimBitsSum, boolean exactSum, IntArrayCallback callback) {
        for (int n = 0; n <= maxDimensions; ++n) {
            int[] m3 = new int[n];
            Arrays.fill(m3, -1);
            int sum = 0;
            int k = 0;
            while (k >= 0) {
                if (k == n) {
                    if (sum <= maxDimBitsSum & (!exactSum | sum == maxDimBitsSum)) {
                        callback.call(m3);
                    }
                    if (--k < 0) continue;
                    sum -= m3[k];
                    continue;
                }
                int n2 = k;
                m3[n2] = m3[n2] + 1;
                if (sum + m3[k] <= maxDimBitsSum) {
                    sum += m3[k];
                    ++k;
                    continue;
                }
                m3[k] = -1;
                if (--k < 0) continue;
                sum -= m3[k];
            }
        }
    }

    private static long computeSeed() {
        String s2 = System.getProperty("test.compactHilbertCurve.seed");
        return s2 == null ? (long)Calendar.getInstance().get(5) : Long.parseLong(s2);
    }

    public static BitVector createBitVector(long initialValue, int bitCount) {
        BitVector bitVector = (BitVector)BitVectorFactories.OPTIMAL.apply(bitCount);
        if (initialValue != 0L) {
            bitVector.copyFrom(initialValue);
        }
        return bitVector;
    }

    public static enum IntArrayComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] a, int[] b) {
            int minLen = Math.min(a.length, b.length);
            for (int i = 0; i < minLen; ++i) {
                int cmp = Integer.compare(a[i], b[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(a.length, b.length);
        }
    }

    public static interface IntArrayCallback {
        public void call(int[] var1);
    }

    private static class ImmutableLongContent
    extends LongContent {
        public ImmutableLongContent(long v) {
            super(v);
        }

        @Override
        public void add(LongContent other) {
            throw new IllegalStateException("Cannot modify shared instance.");
        }
    }
}

