from click.testing import CliRunner
import pytest

from ..command import ls
from ...utils import yaml_load


@pytest.mark.parametrize("format", ("auto", "json", "json_pp", "yaml", "pyout"))
def test_smoke(simple1_nwb_metadata, simple1_nwb, format):
    runner = CliRunner()
    r = runner.invoke(ls, ["-f", format, simple1_nwb])
    assert r.exit_code == 0, f"Exited abnormally. out={r.stdout}"
    # we would need to redirect pyout for its analysis
    out = r.stdout

    if format.startswith("json"):
        import json

        load = json.loads
    elif format == "yaml":

        def load(s):
            obj = yaml_load(s, typ="base")
            assert len(obj) == 1  # will be a list with a single elem
            return obj[0]

    else:
        return

    metadata = load(out)
    assert metadata
    # check a few fields
    assert metadata.pop("nwb_version").startswith("2.")
    for f in ["session_id", "experiment_description"]:
        assert metadata[f] == simple1_nwb_metadata[f]


def test_ls_dandiset_url():
    r = CliRunner().invoke(
        ls, ["-f", "yaml", "https://api.dandiarchive.org/api/dandisets/000027"]
    )
    assert r.exit_code == 0, r.output
    data = yaml_load(r.stdout, "safe")
    assert len(data) == 1
    assert data[0]["path"] == "000027"


def test_ls_dandiset_url_recursive():
    r = CliRunner().invoke(
        ls, ["-f", "yaml", "-r", "https://api.dandiarchive.org/api/dandisets/000027"]
    )
    assert r.exit_code == 0, r.output
    data = yaml_load(r.stdout, "safe")
    assert len(data) == 2
    assert data[0]["path"] == "000027"
    assert data[1]["path"] == "sub-RAT123/sub-RAT123.nwb"


def test_ls_path_url():
    r = CliRunner().invoke(
        ls,
        [
            "-f",
            "yaml",
            "https://api.dandiarchive.org/api/dandisets/000027/versions/draft"
            "/assets/?path=sub-RAT123/",
        ],
    )
    assert r.exit_code == 0, r.output
    data = yaml_load(r.stdout, "safe")
    assert len(data) == 1
    assert data[0]["path"] == "sub-RAT123/sub-RAT123.nwb"
