/* file: algorithm.h */
/*******************************************************************************
* Copyright 2014-2020 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

/*
//++
//  Implementation of base classes defining algorithm interface.
//--
*/

#ifndef __ALGORITHM_H__
#define __ALGORITHM_H__


#include "services/base.h"
#include "services/daal_memory.h"
#include "services/daal_defines.h"
#include "services/error_handling.h"
#include "data_management/data/numeric_table.h"
#include "services/env_detect.h"
#include "algorithms/algorithm_types.h"
#include "algorithms/algorithm_base.h"
#include "algorithms/analysis.h"
#include "algorithms/training.h"
#include "algorithms/prediction.h"
#include "algorithms/algorithm_quality_metric_batch.h"

#include "algorithms/model.h"

#endif
