# This code was (mostly) automatically generated by CWrap version 0.0.0
# https://github.com/geggo/cwrap

cdef extern from "flann/flann.h":
    cdef enum flann_algorithm_t:
        FLANN_INDEX_LINEAR        = 0
        FLANN_INDEX_KDTREE        = 1
        FLANN_INDEX_KMEANS        = 2
        FLANN_INDEX_COMPOSITE     = 3
        FLANN_INDEX_KDTREE_SINGLE = 4
        FLANN_INDEX_HIERARCHICAL  = 5
        FLANN_INDEX_LSH           = 6
        FLANN_INDEX_KDTREE_CUDA   = 7
        FLANN_INDEX_SAVED         = 254
        FLANN_INDEX_AUTOTUNED     = 255

    cdef enum flann_centers_init_t:
        FLANN_CENTERS_RANDOM   = 0
        FLANN_CENTERS_GONZALES = 1
        FLANN_CENTERS_KMEANSPP = 2

    cdef enum flann_log_level_t:
        FLANN_LOG_NONE  = 0
        FLANN_LOG_FATAL = 1
        FLANN_LOG_ERROR = 2
        FLANN_LOG_WARN  = 3
        FLANN_LOG_INFO  = 4
        FLANN_LOG_DEBUG = 5

    cdef enum flann_distance_t:
        FLANN_DIST_EUCLIDEAN        = 1
        FLANN_DIST_L2               = 1
        FLANN_DIST_MANHATTAN        = 2
        FLANN_DIST_L1               = 2
        FLANN_DIST_MINKOWSKI        = 3
        FLANN_DIST_MAX              = 4
        FLANN_DIST_HIST_INTERSECT   = 5
        FLANN_DIST_HELLINGER        = 6
        FLANN_DIST_CHI_SQUARE       = 7
        FLANN_DIST_KULLBACK_LEIBLER = 8
        FLANN_DIST_HAMMING          = 9
        FLANN_DIST_HAMMING_LUT      = 10
        FLANN_DIST_HAMMING_POPCNT   = 11
        FLANN_DIST_L2_SIMPLE        = 12

    cdef enum flann_datatype_t:
        FLANN_NONE    = -1
        FLANN_INT8    =  0
        FLANN_INT16   =  1
        FLANN_INT32   =  2
        FLANN_INT64   =  3
        FLANN_UINT8   =  4
        FLANN_UINT16  =  5
        FLANN_UINT32  =  6
        FLANN_UINT64  =  7
        FLANN_FLOAT32 =  8
        FLANN_FLOAT64 =  9

    cdef enum flann_checks_t:
        FLANN_CHECKS_UNLIMITED = -1
        FLANN_CHECKS_AUTOTUNED = -2

    cdef struct FLANNParameters:
        flann_algorithm_t algorithm
        int checks
        float eps
        int sorted
        int max_neighbors
        int cores
        int trees
        int leaf_max_size
        int branching
        int iterations
        flann_centers_init_t centers_init
        float cb_index
        float target_precision
        float build_weight
        float memory_weight
        float sample_fraction
        unsigned int table_number_
        unsigned int key_size_
        unsigned int multi_probe_level_
        flann_log_level_t log_level
        long random_seed

    ctypedef void *FLANN_INDEX

    ctypedef void *flann_index_t

    FLANNParameters DEFAULT_FLANN_PARAMETERS
    void flann_log_verbosity(int level) nogil

    void flann_set_distance_type(flann_distance_t distance_type, int order) nogil

    flann_index_t flann_build_index(float *dataset, int rows, int cols, float *speedup, FLANNParameters *flann_params) nogil
    flann_index_t flann_build_index_float(float *dataset, int rows, int cols, float *speedup, FLANNParameters *flann_params) nogil
    flann_index_t flann_build_index_double(double *dataset, int rows, int cols, float *speedup, FLANNParameters *flann_params) nogil
    flann_index_t flann_build_index_byte(unsigned char *dataset, int rows, int cols, float *speedup, FLANNParameters *flann_params) nogil
    flann_index_t flann_build_index_int(int *dataset, int rows, int cols, float *speedup, FLANNParameters *flann_params) nogil

    int flann_save_index(flann_index_t index_id, char *filename) nogil
    int flann_save_index_float(flann_index_t index_id, char *filename) nogil
    int flann_save_index_double(flann_index_t index_id, char *filename) nogil
    int flann_save_index_byte(flann_index_t index_id, char *filename) nogil
    int flann_save_index_int(flann_index_t index_id, char *filename) nogil

    flann_index_t flann_load_index(char *filename, float *dataset, int rows, int cols) nogil
    flann_index_t flann_load_index_float(char *filename, float *dataset, int rows, int cols) nogil
    flann_index_t flann_load_index_double(char *filename, double *dataset, int rows, int cols) nogil
    flann_index_t flann_load_index_byte(char *filename, unsigned char *dataset, int rows, int cols) nogil
    flann_index_t flann_load_index_int(char *filename, int *dataset, int rows, int cols) nogil

    int flann_find_nearest_neighbors(float *dataset, int rows, int cols, float *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_float(float *dataset, int rows, int cols, float *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_double(double *dataset, int rows, int cols, double *testset, int trows, int *indices, double *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_byte(unsigned char *dataset, int rows, int cols, unsigned char *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_int(int *dataset, int rows, int cols, int *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil

    int flann_find_nearest_neighbors_index(flann_index_t index_id, float *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_index_float(flann_index_t index_id, float *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_index_double(flann_index_t index_id, double *testset, int trows, int *indices, double *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_index_byte(flann_index_t index_id, unsigned char *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil
    int flann_find_nearest_neighbors_index_int(flann_index_t index_id, int *testset, int trows, int *indices, float *dists, int nn, FLANNParameters *flann_params) nogil

    int flann_radius_search(flann_index_t index_ptr, float *query, int *indices, float *dists, int max_nn, float radius, FLANNParameters *flann_params) nogil
    int flann_radius_search_float(flann_index_t index_ptr, float *query, int *indices, float *dists, int max_nn, float radius, FLANNParameters *flann_params) nogil
    int flann_radius_search_double(flann_index_t index_ptr, double *query, int *indices, double *dists, int max_nn, float radius, FLANNParameters *flann_params) nogil
    int flann_radius_search_byte(flann_index_t index_ptr, unsigned char *query, int *indices, float *dists, int max_nn, float radius, FLANNParameters *flann_params) nogil
    int flann_radius_search_int(flann_index_t index_ptr, int *query, int *indices, float *dists, int max_nn, float radius, FLANNParameters *flann_params) nogil

    int flann_free_index(flann_index_t index_id, FLANNParameters *flann_params) nogil
    int flann_free_index_float(flann_index_t index_id, FLANNParameters *flann_params) nogil
    int flann_free_index_double(flann_index_t index_id, FLANNParameters *flann_params) nogil
    int flann_free_index_byte(flann_index_t index_id, FLANNParameters *flann_params) nogil
    int flann_free_index_int(flann_index_t index_id, FLANNParameters *flann_params) nogil

    int flann_compute_cluster_centers(float *dataset, int rows, int cols, int clusters, float *result, FLANNParameters *flann_params) nogil
    int flann_compute_cluster_centers_float(float *dataset, int rows, int cols, int clusters, float *result, FLANNParameters *flann_params) nogil
    int flann_compute_cluster_centers_double(double *dataset, int rows, int cols, int clusters, double *result, FLANNParameters *flann_params) nogil
    int flann_compute_cluster_centers_byte(unsigned char *dataset, int rows, int cols, int clusters, float *result, FLANNParameters *flann_params) nogil
    int flann_compute_cluster_centers_int(int *dataset, int rows, int cols, int clusters, float *result, FLANNParameters *flann_params) nogil
