# Copyright 2021-2022 NVIDIA Corporation.  All rights reserved.
#
# Please refer to the NVIDIA end user license agreement (EULA) associated
# with this source code for terms and conditions that govern your use of
# this software. Any use, reproduction, disclosure, or distribution of
# this software and related documentation outside the terms of the EULA
# is strictly prohibited.
from typing import List, Tuple, Any
from enum import IntEnum
import cython
import ctypes
from libc.stdlib cimport calloc, free
from libc.string cimport memcpy
from libc.stdint cimport int32_t, uint32_t, int64_t, uint64_t
from libc.stddef cimport wchar_t
from libcpp.vector cimport vector
from cpython.buffer cimport PyObject_CheckBuffer, PyObject_GetBuffer, PyBuffer_Release, PyBUF_SIMPLE, PyBUF_ANY_CONTIGUOUS
from cpython.bytes cimport PyBytes_FromStringAndSize

ctypedef unsigned long long signed_char_ptr
ctypedef unsigned long long unsigned_char_ptr
ctypedef unsigned long long char_ptr
ctypedef unsigned long long short_ptr
ctypedef unsigned long long unsigned_short_ptr
ctypedef unsigned long long int_ptr
ctypedef unsigned long long long_int_ptr
ctypedef unsigned long long long_long_int_ptr
ctypedef unsigned long long unsigned_int_ptr
ctypedef unsigned long long unsigned_long_int_ptr
ctypedef unsigned long long unsigned_long_long_int_ptr
ctypedef unsigned long long uint32_t_ptr
ctypedef unsigned long long uint64_t_ptr
ctypedef unsigned long long int32_t_ptr
ctypedef unsigned long long int64_t_ptr
ctypedef unsigned long long unsigned_ptr
ctypedef unsigned long long unsigned_long_long_ptr
ctypedef unsigned long long size_t_ptr
ctypedef unsigned long long float_ptr
ctypedef unsigned long long double_ptr
ctypedef unsigned long long void_ptr

CUDA_VERSION = ccuda.CUDA_VERSION
CU_IPC_HANDLE_SIZE = ccuda.CU_IPC_HANDLE_SIZE
CU_STREAM_LEGACY = ccuda.CU_STREAM_LEGACY
CU_STREAM_PER_THREAD = ccuda.CU_STREAM_PER_THREAD
CU_MEMHOSTALLOC_PORTABLE = ccuda.CU_MEMHOSTALLOC_PORTABLE
CU_MEMHOSTALLOC_DEVICEMAP = ccuda.CU_MEMHOSTALLOC_DEVICEMAP
CU_MEMHOSTALLOC_WRITECOMBINED = ccuda.CU_MEMHOSTALLOC_WRITECOMBINED
CU_MEMHOSTREGISTER_PORTABLE = ccuda.CU_MEMHOSTREGISTER_PORTABLE
CU_MEMHOSTREGISTER_DEVICEMAP = ccuda.CU_MEMHOSTREGISTER_DEVICEMAP
CU_MEMHOSTREGISTER_IOMEMORY = ccuda.CU_MEMHOSTREGISTER_IOMEMORY
CU_MEMHOSTREGISTER_READ_ONLY = ccuda.CU_MEMHOSTREGISTER_READ_ONLY
CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL = ccuda.CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL
CUDA_EXTERNAL_MEMORY_DEDICATED = ccuda.CUDA_EXTERNAL_MEMORY_DEDICATED
CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC = ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC
CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC = ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC
CUDA_NVSCISYNC_ATTR_SIGNAL = ccuda.CUDA_NVSCISYNC_ATTR_SIGNAL
CUDA_NVSCISYNC_ATTR_WAIT = ccuda.CUDA_NVSCISYNC_ATTR_WAIT
CU_MEM_CREATE_USAGE_TILE_POOL = ccuda.CU_MEM_CREATE_USAGE_TILE_POOL
CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC = ccuda.CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC
CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC = ccuda.CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC
CUDA_ARRAY3D_LAYERED = ccuda.CUDA_ARRAY3D_LAYERED
CUDA_ARRAY3D_2DARRAY = ccuda.CUDA_ARRAY3D_2DARRAY
CUDA_ARRAY3D_SURFACE_LDST = ccuda.CUDA_ARRAY3D_SURFACE_LDST
CUDA_ARRAY3D_CUBEMAP = ccuda.CUDA_ARRAY3D_CUBEMAP
CUDA_ARRAY3D_TEXTURE_GATHER = ccuda.CUDA_ARRAY3D_TEXTURE_GATHER
CUDA_ARRAY3D_DEPTH_TEXTURE = ccuda.CUDA_ARRAY3D_DEPTH_TEXTURE
CUDA_ARRAY3D_COLOR_ATTACHMENT = ccuda.CUDA_ARRAY3D_COLOR_ATTACHMENT
CUDA_ARRAY3D_SPARSE = ccuda.CUDA_ARRAY3D_SPARSE
CUDA_ARRAY3D_DEFERRED_MAPPING = ccuda.CUDA_ARRAY3D_DEFERRED_MAPPING
CU_TRSA_OVERRIDE_FORMAT = ccuda.CU_TRSA_OVERRIDE_FORMAT
CU_TRSF_READ_AS_INTEGER = ccuda.CU_TRSF_READ_AS_INTEGER
CU_TRSF_NORMALIZED_COORDINATES = ccuda.CU_TRSF_NORMALIZED_COORDINATES
CU_TRSF_SRGB = ccuda.CU_TRSF_SRGB
CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION = ccuda.CU_TRSF_DISABLE_TRILINEAR_OPTIMIZATION
CU_TRSF_SEAMLESS_CUBEMAP = ccuda.CU_TRSF_SEAMLESS_CUBEMAP
CU_LAUNCH_PARAM_END = ccuda.CU_LAUNCH_PARAM_END
CU_LAUNCH_PARAM_BUFFER_POINTER = ccuda.CU_LAUNCH_PARAM_BUFFER_POINTER
CU_LAUNCH_PARAM_BUFFER_SIZE = ccuda.CU_LAUNCH_PARAM_BUFFER_SIZE
CU_PARAM_TR_DEFAULT = ccuda.CU_PARAM_TR_DEFAULT
CU_DEVICE_CPU = ccuda.CU_DEVICE_CPU
CU_DEVICE_INVALID = ccuda.CU_DEVICE_INVALID
MAX_PLANES = ccuda.MAX_PLANES
CUDA_EGL_INFINITE_TIMEOUT = ccuda.CUDA_EGL_INFINITE_TIMEOUT

class CUipcMem_flags(IntEnum):
    """
    CUDA Ipc Mem Flags
    """
    CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS = ccuda.CUipcMem_flags_enum.CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS

class CUmemAttach_flags(IntEnum):
    """
    CUDA Mem Attach Flags
    """
    CU_MEM_ATTACH_GLOBAL = ccuda.CUmemAttach_flags_enum.CU_MEM_ATTACH_GLOBAL
    CU_MEM_ATTACH_HOST = ccuda.CUmemAttach_flags_enum.CU_MEM_ATTACH_HOST
    CU_MEM_ATTACH_SINGLE = ccuda.CUmemAttach_flags_enum.CU_MEM_ATTACH_SINGLE

class CUctx_flags(IntEnum):
    """
    Context creation flags
    """
    CU_CTX_SCHED_AUTO = ccuda.CUctx_flags_enum.CU_CTX_SCHED_AUTO
    CU_CTX_SCHED_SPIN = ccuda.CUctx_flags_enum.CU_CTX_SCHED_SPIN
    CU_CTX_SCHED_YIELD = ccuda.CUctx_flags_enum.CU_CTX_SCHED_YIELD
    CU_CTX_SCHED_BLOCKING_SYNC = ccuda.CUctx_flags_enum.CU_CTX_SCHED_BLOCKING_SYNC
    CU_CTX_BLOCKING_SYNC = ccuda.CUctx_flags_enum.CU_CTX_BLOCKING_SYNC
    CU_CTX_SCHED_MASK = ccuda.CUctx_flags_enum.CU_CTX_SCHED_MASK
    CU_CTX_MAP_HOST = ccuda.CUctx_flags_enum.CU_CTX_MAP_HOST
    CU_CTX_LMEM_RESIZE_TO_MAX = ccuda.CUctx_flags_enum.CU_CTX_LMEM_RESIZE_TO_MAX
    CU_CTX_FLAGS_MASK = ccuda.CUctx_flags_enum.CU_CTX_FLAGS_MASK

class CUstream_flags(IntEnum):
    """
    Stream creation flags
    """
    CU_STREAM_DEFAULT = ccuda.CUstream_flags_enum.CU_STREAM_DEFAULT
    CU_STREAM_NON_BLOCKING = ccuda.CUstream_flags_enum.CU_STREAM_NON_BLOCKING

class CUevent_flags(IntEnum):
    """
    Event creation flags
    """
    CU_EVENT_DEFAULT = ccuda.CUevent_flags_enum.CU_EVENT_DEFAULT
    CU_EVENT_BLOCKING_SYNC = ccuda.CUevent_flags_enum.CU_EVENT_BLOCKING_SYNC
    CU_EVENT_DISABLE_TIMING = ccuda.CUevent_flags_enum.CU_EVENT_DISABLE_TIMING
    CU_EVENT_INTERPROCESS = ccuda.CUevent_flags_enum.CU_EVENT_INTERPROCESS

class CUevent_record_flags(IntEnum):
    """
    Event record flags
    """
    CU_EVENT_RECORD_DEFAULT = ccuda.CUevent_record_flags_enum.CU_EVENT_RECORD_DEFAULT
    CU_EVENT_RECORD_EXTERNAL = ccuda.CUevent_record_flags_enum.CU_EVENT_RECORD_EXTERNAL

class CUevent_wait_flags(IntEnum):
    """
    Event wait flags
    """
    CU_EVENT_WAIT_DEFAULT = ccuda.CUevent_wait_flags_enum.CU_EVENT_WAIT_DEFAULT
    CU_EVENT_WAIT_EXTERNAL = ccuda.CUevent_wait_flags_enum.CU_EVENT_WAIT_EXTERNAL

class CUstreamWaitValue_flags(IntEnum):
    """
    Flags for cuStreamWaitValue32 and cuStreamWaitValue64
    """
    CU_STREAM_WAIT_VALUE_GEQ = ccuda.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_GEQ
    CU_STREAM_WAIT_VALUE_EQ = ccuda.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_EQ
    CU_STREAM_WAIT_VALUE_AND = ccuda.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_AND
    CU_STREAM_WAIT_VALUE_NOR = ccuda.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_NOR
    CU_STREAM_WAIT_VALUE_FLUSH = ccuda.CUstreamWaitValue_flags_enum.CU_STREAM_WAIT_VALUE_FLUSH

class CUstreamWriteValue_flags(IntEnum):
    """
    Flags for cuStreamWriteValue32
    """
    CU_STREAM_WRITE_VALUE_DEFAULT = ccuda.CUstreamWriteValue_flags_enum.CU_STREAM_WRITE_VALUE_DEFAULT
    CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER = ccuda.CUstreamWriteValue_flags_enum.CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER

class CUstreamBatchMemOpType(IntEnum):
    """
    Operations for cuStreamBatchMemOp
    """
    CU_STREAM_MEM_OP_WAIT_VALUE_32 = ccuda.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WAIT_VALUE_32
    CU_STREAM_MEM_OP_WRITE_VALUE_32 = ccuda.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WRITE_VALUE_32
    CU_STREAM_MEM_OP_WAIT_VALUE_64 = ccuda.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WAIT_VALUE_64
    CU_STREAM_MEM_OP_WRITE_VALUE_64 = ccuda.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_WRITE_VALUE_64
    CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES = ccuda.CUstreamBatchMemOpType_enum.CU_STREAM_MEM_OP_FLUSH_REMOTE_WRITES

class CUoccupancy_flags(IntEnum):
    """
    Occupancy calculator flag
    """
    CU_OCCUPANCY_DEFAULT = ccuda.CUoccupancy_flags_enum.CU_OCCUPANCY_DEFAULT
    CU_OCCUPANCY_DISABLE_CACHING_OVERRIDE = ccuda.CUoccupancy_flags_enum.CU_OCCUPANCY_DISABLE_CACHING_OVERRIDE

class CUstreamUpdateCaptureDependencies_flags(IntEnum):
    """
    Flags for cuStreamUpdateCaptureDependencies
    """
    CU_STREAM_ADD_CAPTURE_DEPENDENCIES = ccuda.CUstreamUpdateCaptureDependencies_flags_enum.CU_STREAM_ADD_CAPTURE_DEPENDENCIES
    CU_STREAM_SET_CAPTURE_DEPENDENCIES = ccuda.CUstreamUpdateCaptureDependencies_flags_enum.CU_STREAM_SET_CAPTURE_DEPENDENCIES

class CUarray_format(IntEnum):
    """
    Array formats
    """
    CU_AD_FORMAT_UNSIGNED_INT8 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNSIGNED_INT8
    CU_AD_FORMAT_UNSIGNED_INT16 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNSIGNED_INT16
    CU_AD_FORMAT_UNSIGNED_INT32 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNSIGNED_INT32
    CU_AD_FORMAT_SIGNED_INT8 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SIGNED_INT8
    CU_AD_FORMAT_SIGNED_INT16 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SIGNED_INT16
    CU_AD_FORMAT_SIGNED_INT32 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SIGNED_INT32
    CU_AD_FORMAT_HALF = ccuda.CUarray_format_enum.CU_AD_FORMAT_HALF
    CU_AD_FORMAT_FLOAT = ccuda.CUarray_format_enum.CU_AD_FORMAT_FLOAT
    CU_AD_FORMAT_NV12 = ccuda.CUarray_format_enum.CU_AD_FORMAT_NV12
    CU_AD_FORMAT_UNORM_INT8X1 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT8X1
    CU_AD_FORMAT_UNORM_INT8X2 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT8X2
    CU_AD_FORMAT_UNORM_INT8X4 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT8X4
    CU_AD_FORMAT_UNORM_INT16X1 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT16X1
    CU_AD_FORMAT_UNORM_INT16X2 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT16X2
    CU_AD_FORMAT_UNORM_INT16X4 = ccuda.CUarray_format_enum.CU_AD_FORMAT_UNORM_INT16X4
    CU_AD_FORMAT_SNORM_INT8X1 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT8X1
    CU_AD_FORMAT_SNORM_INT8X2 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT8X2
    CU_AD_FORMAT_SNORM_INT8X4 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT8X4
    CU_AD_FORMAT_SNORM_INT16X1 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT16X1
    CU_AD_FORMAT_SNORM_INT16X2 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT16X2
    CU_AD_FORMAT_SNORM_INT16X4 = ccuda.CUarray_format_enum.CU_AD_FORMAT_SNORM_INT16X4
    CU_AD_FORMAT_BC1_UNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC1_UNORM
    CU_AD_FORMAT_BC1_UNORM_SRGB = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC1_UNORM_SRGB
    CU_AD_FORMAT_BC2_UNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC2_UNORM
    CU_AD_FORMAT_BC2_UNORM_SRGB = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC2_UNORM_SRGB
    CU_AD_FORMAT_BC3_UNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC3_UNORM
    CU_AD_FORMAT_BC3_UNORM_SRGB = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC3_UNORM_SRGB
    CU_AD_FORMAT_BC4_UNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC4_UNORM
    CU_AD_FORMAT_BC4_SNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC4_SNORM
    CU_AD_FORMAT_BC5_UNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC5_UNORM
    CU_AD_FORMAT_BC5_SNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC5_SNORM
    CU_AD_FORMAT_BC6H_UF16 = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC6H_UF16
    CU_AD_FORMAT_BC6H_SF16 = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC6H_SF16
    CU_AD_FORMAT_BC7_UNORM = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC7_UNORM
    CU_AD_FORMAT_BC7_UNORM_SRGB = ccuda.CUarray_format_enum.CU_AD_FORMAT_BC7_UNORM_SRGB

class CUaddress_mode(IntEnum):
    """
    Texture reference addressing modes
    """
    CU_TR_ADDRESS_MODE_WRAP = ccuda.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_WRAP
    CU_TR_ADDRESS_MODE_CLAMP = ccuda.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_CLAMP
    CU_TR_ADDRESS_MODE_MIRROR = ccuda.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_MIRROR
    CU_TR_ADDRESS_MODE_BORDER = ccuda.CUaddress_mode_enum.CU_TR_ADDRESS_MODE_BORDER

class CUfilter_mode(IntEnum):
    """
    Texture reference filtering modes
    """
    CU_TR_FILTER_MODE_POINT = ccuda.CUfilter_mode_enum.CU_TR_FILTER_MODE_POINT
    CU_TR_FILTER_MODE_LINEAR = ccuda.CUfilter_mode_enum.CU_TR_FILTER_MODE_LINEAR

class CUdevice_attribute(IntEnum):
    """
    Device properties
    """
    CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z
    CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X
    CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y
    CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SHARED_MEMORY_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY
    CU_DEVICE_ATTRIBUTE_WARP_SIZE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_WARP_SIZE
    CU_DEVICE_ATTRIBUTE_MAX_PITCH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_PITCH
    CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_REGISTERS_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_CLOCK_RATE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CLOCK_RATE
    CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT
    CU_DEVICE_ATTRIBUTE_GPU_OVERLAP = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_OVERLAP
    CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT
    CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT
    CU_DEVICE_ATTRIBUTE_INTEGRATED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_INTEGRATED
    CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY
    CU_DEVICE_ATTRIBUTE_COMPUTE_MODE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_MODE
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_NUMSLICES = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_ARRAY_NUMSLICES
    CU_DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SURFACE_ALIGNMENT
    CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS
    CU_DEVICE_ATTRIBUTE_ECC_ENABLED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_ECC_ENABLED
    CU_DEVICE_ATTRIBUTE_PCI_BUS_ID = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PCI_BUS_ID
    CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID
    CU_DEVICE_ATTRIBUTE_TCC_DRIVER = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TCC_DRIVER
    CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE
    CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH
    CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE
    CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR
    CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_ASYNC_ENGINE_COUNT
    CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_CAN_TEX2D_GATHER = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_TEX2D_GATHER
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE
    CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID
    CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT
    CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR
    CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH
    CU_DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_STREAM_PRIORITIES_SUPPORTED
    CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED
    CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR
    CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR
    CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY
    CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD
    CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID
    CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED
    CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS
    CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED
    CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS
    CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR
    CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH
    CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN
    CU_DEVICE_ATTRIBUTE_CAN_FLUSH_REMOTE_WRITES = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_CAN_FLUSH_REMOTE_WRITES
    CU_DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HOST_REGISTER_SUPPORTED
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES
    CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST
    CU_DEVICE_ATTRIBUTE_VIRTUAL_ADDRESS_MANAGEMENT_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_VIRTUAL_ADDRESS_MANAGEMENT_SUPPORTED
    CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR_SUPPORTED
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_HANDLE_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_HANDLE_SUPPORTED
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_KMT_HANDLE_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_KMT_HANDLE_SUPPORTED
    CU_DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR
    CU_DEVICE_ATTRIBUTE_GENERIC_COMPRESSION_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GENERIC_COMPRESSION_SUPPORTED
    CU_DEVICE_ATTRIBUTE_MAX_PERSISTING_L2_CACHE_SIZE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_PERSISTING_L2_CACHE_SIZE
    CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WITH_CUDA_VMM_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WITH_CUDA_VMM_SUPPORTED
    CU_DEVICE_ATTRIBUTE_RESERVED_SHARED_MEMORY_PER_BLOCK = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_RESERVED_SHARED_MEMORY_PER_BLOCK
    CU_DEVICE_ATTRIBUTE_SPARSE_CUDA_ARRAY_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_SPARSE_CUDA_ARRAY_SUPPORTED
    CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED
    CU_DEVICE_ATTRIBUTE_TIMELINE_SEMAPHORE_INTEROP_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_TIMELINE_SEMAPHORE_INTEROP_SUPPORTED
    CU_DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_SUPPORTED
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING
    CU_DEVICE_ATTRIBUTE_MEMPOOL_SUPPORTED_HANDLE_TYPES = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MEMPOOL_SUPPORTED_HANDLE_TYPES
    CU_DEVICE_ATTRIBUTE_DEFERRED_MAPPING_CUDA_ARRAY_SUPPORTED = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_DEFERRED_MAPPING_CUDA_ARRAY_SUPPORTED
    CU_DEVICE_ATTRIBUTE_MAX = ccuda.CUdevice_attribute_enum.CU_DEVICE_ATTRIBUTE_MAX

class CUpointer_attribute(IntEnum):
    """
    Pointer information
    """
    CU_POINTER_ATTRIBUTE_CONTEXT = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_CONTEXT
    CU_POINTER_ATTRIBUTE_MEMORY_TYPE = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MEMORY_TYPE
    CU_POINTER_ATTRIBUTE_DEVICE_POINTER = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_DEVICE_POINTER
    CU_POINTER_ATTRIBUTE_HOST_POINTER = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_HOST_POINTER
    CU_POINTER_ATTRIBUTE_P2P_TOKENS = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_P2P_TOKENS
    CU_POINTER_ATTRIBUTE_SYNC_MEMOPS = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_SYNC_MEMOPS
    CU_POINTER_ATTRIBUTE_BUFFER_ID = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_BUFFER_ID
    CU_POINTER_ATTRIBUTE_IS_MANAGED = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_MANAGED
    CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL
    CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE
    CU_POINTER_ATTRIBUTE_RANGE_START_ADDR = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_RANGE_START_ADDR
    CU_POINTER_ATTRIBUTE_RANGE_SIZE = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_RANGE_SIZE
    CU_POINTER_ATTRIBUTE_MAPPED = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MAPPED
    CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES
    CU_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE
    CU_POINTER_ATTRIBUTE_ACCESS_FLAGS = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAGS
    CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE = ccuda.CUpointer_attribute_enum.CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE

class CUfunction_attribute(IntEnum):
    """
    Function properties
    """
    CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK
    CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES
    CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES
    CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES
    CU_FUNC_ATTRIBUTE_NUM_REGS = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_NUM_REGS
    CU_FUNC_ATTRIBUTE_PTX_VERSION = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_PTX_VERSION
    CU_FUNC_ATTRIBUTE_BINARY_VERSION = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_BINARY_VERSION
    CU_FUNC_ATTRIBUTE_CACHE_MODE_CA = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_CACHE_MODE_CA
    CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES
    CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT
    CU_FUNC_ATTRIBUTE_MAX = ccuda.CUfunction_attribute_enum.CU_FUNC_ATTRIBUTE_MAX

class CUfunc_cache(IntEnum):
    """
    Function cache configurations
    """
    CU_FUNC_CACHE_PREFER_NONE = ccuda.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_NONE
    CU_FUNC_CACHE_PREFER_SHARED = ccuda.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_SHARED
    CU_FUNC_CACHE_PREFER_L1 = ccuda.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_L1
    CU_FUNC_CACHE_PREFER_EQUAL = ccuda.CUfunc_cache_enum.CU_FUNC_CACHE_PREFER_EQUAL

class CUsharedconfig(IntEnum):
    """
    Shared memory configurations
    """
    CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE = ccuda.CUsharedconfig_enum.CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE
    CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE = ccuda.CUsharedconfig_enum.CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE
    CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE = ccuda.CUsharedconfig_enum.CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE

class CUshared_carveout(IntEnum):
    """
    Shared memory carveout configurations. These may be passed to
    cuFuncSetAttribute
    """
    CU_SHAREDMEM_CARVEOUT_DEFAULT = ccuda.CUshared_carveout_enum.CU_SHAREDMEM_CARVEOUT_DEFAULT
    CU_SHAREDMEM_CARVEOUT_MAX_SHARED = ccuda.CUshared_carveout_enum.CU_SHAREDMEM_CARVEOUT_MAX_SHARED
    CU_SHAREDMEM_CARVEOUT_MAX_L1 = ccuda.CUshared_carveout_enum.CU_SHAREDMEM_CARVEOUT_MAX_L1

class CUmemorytype(IntEnum):
    """
    Memory types
    """
    CU_MEMORYTYPE_HOST = ccuda.CUmemorytype_enum.CU_MEMORYTYPE_HOST
    CU_MEMORYTYPE_DEVICE = ccuda.CUmemorytype_enum.CU_MEMORYTYPE_DEVICE
    CU_MEMORYTYPE_ARRAY = ccuda.CUmemorytype_enum.CU_MEMORYTYPE_ARRAY
    CU_MEMORYTYPE_UNIFIED = ccuda.CUmemorytype_enum.CU_MEMORYTYPE_UNIFIED

class CUcomputemode(IntEnum):
    """
    Compute Modes
    """
    CU_COMPUTEMODE_DEFAULT = ccuda.CUcomputemode_enum.CU_COMPUTEMODE_DEFAULT
    CU_COMPUTEMODE_PROHIBITED = ccuda.CUcomputemode_enum.CU_COMPUTEMODE_PROHIBITED
    CU_COMPUTEMODE_EXCLUSIVE_PROCESS = ccuda.CUcomputemode_enum.CU_COMPUTEMODE_EXCLUSIVE_PROCESS

class CUmem_advise(IntEnum):
    """
    Memory advise values
    """
    CU_MEM_ADVISE_SET_READ_MOSTLY = ccuda.CUmem_advise_enum.CU_MEM_ADVISE_SET_READ_MOSTLY
    CU_MEM_ADVISE_UNSET_READ_MOSTLY = ccuda.CUmem_advise_enum.CU_MEM_ADVISE_UNSET_READ_MOSTLY
    CU_MEM_ADVISE_SET_PREFERRED_LOCATION = ccuda.CUmem_advise_enum.CU_MEM_ADVISE_SET_PREFERRED_LOCATION
    CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION = ccuda.CUmem_advise_enum.CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION
    CU_MEM_ADVISE_SET_ACCESSED_BY = ccuda.CUmem_advise_enum.CU_MEM_ADVISE_SET_ACCESSED_BY
    CU_MEM_ADVISE_UNSET_ACCESSED_BY = ccuda.CUmem_advise_enum.CU_MEM_ADVISE_UNSET_ACCESSED_BY

class CUmem_range_attribute(IntEnum):
    """

    """
    CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY = ccuda.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY
    CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION = ccuda.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION
    CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY = ccuda.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY
    CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION = ccuda.CUmem_range_attribute_enum.CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION

class CUjit_option(IntEnum):
    """
    Online compiler and linker options
    """
    CU_JIT_MAX_REGISTERS = ccuda.CUjit_option_enum.CU_JIT_MAX_REGISTERS
    CU_JIT_THREADS_PER_BLOCK = ccuda.CUjit_option_enum.CU_JIT_THREADS_PER_BLOCK
    CU_JIT_WALL_TIME = ccuda.CUjit_option_enum.CU_JIT_WALL_TIME
    CU_JIT_INFO_LOG_BUFFER = ccuda.CUjit_option_enum.CU_JIT_INFO_LOG_BUFFER
    CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES = ccuda.CUjit_option_enum.CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES
    CU_JIT_ERROR_LOG_BUFFER = ccuda.CUjit_option_enum.CU_JIT_ERROR_LOG_BUFFER
    CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES = ccuda.CUjit_option_enum.CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES
    CU_JIT_OPTIMIZATION_LEVEL = ccuda.CUjit_option_enum.CU_JIT_OPTIMIZATION_LEVEL
    CU_JIT_TARGET_FROM_CUCONTEXT = ccuda.CUjit_option_enum.CU_JIT_TARGET_FROM_CUCONTEXT
    CU_JIT_TARGET = ccuda.CUjit_option_enum.CU_JIT_TARGET
    CU_JIT_FALLBACK_STRATEGY = ccuda.CUjit_option_enum.CU_JIT_FALLBACK_STRATEGY
    CU_JIT_GENERATE_DEBUG_INFO = ccuda.CUjit_option_enum.CU_JIT_GENERATE_DEBUG_INFO
    CU_JIT_LOG_VERBOSE = ccuda.CUjit_option_enum.CU_JIT_LOG_VERBOSE
    CU_JIT_GENERATE_LINE_INFO = ccuda.CUjit_option_enum.CU_JIT_GENERATE_LINE_INFO
    CU_JIT_CACHE_MODE = ccuda.CUjit_option_enum.CU_JIT_CACHE_MODE
    CU_JIT_NEW_SM3X_OPT = ccuda.CUjit_option_enum.CU_JIT_NEW_SM3X_OPT
    CU_JIT_FAST_COMPILE = ccuda.CUjit_option_enum.CU_JIT_FAST_COMPILE
    CU_JIT_GLOBAL_SYMBOL_NAMES = ccuda.CUjit_option_enum.CU_JIT_GLOBAL_SYMBOL_NAMES
    CU_JIT_GLOBAL_SYMBOL_ADDRESSES = ccuda.CUjit_option_enum.CU_JIT_GLOBAL_SYMBOL_ADDRESSES
    CU_JIT_GLOBAL_SYMBOL_COUNT = ccuda.CUjit_option_enum.CU_JIT_GLOBAL_SYMBOL_COUNT
    CU_JIT_LTO = ccuda.CUjit_option_enum.CU_JIT_LTO
    CU_JIT_FTZ = ccuda.CUjit_option_enum.CU_JIT_FTZ
    CU_JIT_PREC_DIV = ccuda.CUjit_option_enum.CU_JIT_PREC_DIV
    CU_JIT_PREC_SQRT = ccuda.CUjit_option_enum.CU_JIT_PREC_SQRT
    CU_JIT_FMA = ccuda.CUjit_option_enum.CU_JIT_FMA
    CU_JIT_NUM_OPTIONS = ccuda.CUjit_option_enum.CU_JIT_NUM_OPTIONS

class CUjit_target(IntEnum):
    """
    Online compilation targets
    """
    CU_TARGET_COMPUTE_20 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_20
    CU_TARGET_COMPUTE_21 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_21
    CU_TARGET_COMPUTE_30 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_30
    CU_TARGET_COMPUTE_32 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_32
    CU_TARGET_COMPUTE_35 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_35
    CU_TARGET_COMPUTE_37 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_37
    CU_TARGET_COMPUTE_50 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_50
    CU_TARGET_COMPUTE_52 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_52
    CU_TARGET_COMPUTE_53 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_53
    CU_TARGET_COMPUTE_60 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_60
    CU_TARGET_COMPUTE_61 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_61
    CU_TARGET_COMPUTE_62 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_62
    CU_TARGET_COMPUTE_70 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_70
    CU_TARGET_COMPUTE_72 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_72
    CU_TARGET_COMPUTE_75 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_75
    CU_TARGET_COMPUTE_80 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_80
    CU_TARGET_COMPUTE_86 = ccuda.CUjit_target_enum.CU_TARGET_COMPUTE_86

class CUjit_fallback(IntEnum):
    """
    Cubin matching fallback strategies
    """
    CU_PREFER_PTX = ccuda.CUjit_fallback_enum.CU_PREFER_PTX
    CU_PREFER_BINARY = ccuda.CUjit_fallback_enum.CU_PREFER_BINARY

class CUjit_cacheMode(IntEnum):
    """
    Caching modes for dlcm
    """
    CU_JIT_CACHE_OPTION_NONE = ccuda.CUjit_cacheMode_enum.CU_JIT_CACHE_OPTION_NONE
    CU_JIT_CACHE_OPTION_CG = ccuda.CUjit_cacheMode_enum.CU_JIT_CACHE_OPTION_CG
    CU_JIT_CACHE_OPTION_CA = ccuda.CUjit_cacheMode_enum.CU_JIT_CACHE_OPTION_CA

class CUjitInputType(IntEnum):
    """
    Device code formats
    """
    CU_JIT_INPUT_CUBIN = ccuda.CUjitInputType_enum.CU_JIT_INPUT_CUBIN
    CU_JIT_INPUT_PTX = ccuda.CUjitInputType_enum.CU_JIT_INPUT_PTX
    CU_JIT_INPUT_FATBINARY = ccuda.CUjitInputType_enum.CU_JIT_INPUT_FATBINARY
    CU_JIT_INPUT_OBJECT = ccuda.CUjitInputType_enum.CU_JIT_INPUT_OBJECT
    CU_JIT_INPUT_LIBRARY = ccuda.CUjitInputType_enum.CU_JIT_INPUT_LIBRARY
    CU_JIT_INPUT_NVVM = ccuda.CUjitInputType_enum.CU_JIT_INPUT_NVVM
    CU_JIT_NUM_INPUT_TYPES = ccuda.CUjitInputType_enum.CU_JIT_NUM_INPUT_TYPES

class CUgraphicsRegisterFlags(IntEnum):
    """
    Flags to register a graphics resource
    """
    CU_GRAPHICS_REGISTER_FLAGS_NONE = ccuda.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_NONE
    CU_GRAPHICS_REGISTER_FLAGS_READ_ONLY = ccuda.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_READ_ONLY
    CU_GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD = ccuda.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_WRITE_DISCARD
    CU_GRAPHICS_REGISTER_FLAGS_SURFACE_LDST = ccuda.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_SURFACE_LDST
    CU_GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER = ccuda.CUgraphicsRegisterFlags_enum.CU_GRAPHICS_REGISTER_FLAGS_TEXTURE_GATHER

class CUgraphicsMapResourceFlags(IntEnum):
    """
    Flags for mapping and unmapping interop resources
    """
    CU_GRAPHICS_MAP_RESOURCE_FLAGS_NONE = ccuda.CUgraphicsMapResourceFlags_enum.CU_GRAPHICS_MAP_RESOURCE_FLAGS_NONE
    CU_GRAPHICS_MAP_RESOURCE_FLAGS_READ_ONLY = ccuda.CUgraphicsMapResourceFlags_enum.CU_GRAPHICS_MAP_RESOURCE_FLAGS_READ_ONLY
    CU_GRAPHICS_MAP_RESOURCE_FLAGS_WRITE_DISCARD = ccuda.CUgraphicsMapResourceFlags_enum.CU_GRAPHICS_MAP_RESOURCE_FLAGS_WRITE_DISCARD

class CUarray_cubemap_face(IntEnum):
    """
    Array indices for cube faces
    """
    CU_CUBEMAP_FACE_POSITIVE_X = ccuda.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_POSITIVE_X
    CU_CUBEMAP_FACE_NEGATIVE_X = ccuda.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_NEGATIVE_X
    CU_CUBEMAP_FACE_POSITIVE_Y = ccuda.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_POSITIVE_Y
    CU_CUBEMAP_FACE_NEGATIVE_Y = ccuda.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_NEGATIVE_Y
    CU_CUBEMAP_FACE_POSITIVE_Z = ccuda.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_POSITIVE_Z
    CU_CUBEMAP_FACE_NEGATIVE_Z = ccuda.CUarray_cubemap_face_enum.CU_CUBEMAP_FACE_NEGATIVE_Z

class CUlimit(IntEnum):
    """
    Limits
    """
    CU_LIMIT_STACK_SIZE = ccuda.CUlimit_enum.CU_LIMIT_STACK_SIZE
    CU_LIMIT_PRINTF_FIFO_SIZE = ccuda.CUlimit_enum.CU_LIMIT_PRINTF_FIFO_SIZE
    CU_LIMIT_MALLOC_HEAP_SIZE = ccuda.CUlimit_enum.CU_LIMIT_MALLOC_HEAP_SIZE
    CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH = ccuda.CUlimit_enum.CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH
    CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT = ccuda.CUlimit_enum.CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT
    CU_LIMIT_MAX_L2_FETCH_GRANULARITY = ccuda.CUlimit_enum.CU_LIMIT_MAX_L2_FETCH_GRANULARITY
    CU_LIMIT_PERSISTING_L2_CACHE_SIZE = ccuda.CUlimit_enum.CU_LIMIT_PERSISTING_L2_CACHE_SIZE
    CU_LIMIT_MAX = ccuda.CUlimit_enum.CU_LIMIT_MAX

class CUresourcetype(IntEnum):
    """
    Resource types
    """
    CU_RESOURCE_TYPE_ARRAY = ccuda.CUresourcetype_enum.CU_RESOURCE_TYPE_ARRAY
    CU_RESOURCE_TYPE_MIPMAPPED_ARRAY = ccuda.CUresourcetype_enum.CU_RESOURCE_TYPE_MIPMAPPED_ARRAY
    CU_RESOURCE_TYPE_LINEAR = ccuda.CUresourcetype_enum.CU_RESOURCE_TYPE_LINEAR
    CU_RESOURCE_TYPE_PITCH2D = ccuda.CUresourcetype_enum.CU_RESOURCE_TYPE_PITCH2D

class CUaccessProperty(IntEnum):
    """
    Specifies performance hint with ::CUaccessPolicyWindow for hitProp
    and missProp members.
    """
    CU_ACCESS_PROPERTY_NORMAL = ccuda.CUaccessProperty_enum.CU_ACCESS_PROPERTY_NORMAL
    CU_ACCESS_PROPERTY_STREAMING = ccuda.CUaccessProperty_enum.CU_ACCESS_PROPERTY_STREAMING
    CU_ACCESS_PROPERTY_PERSISTING = ccuda.CUaccessProperty_enum.CU_ACCESS_PROPERTY_PERSISTING

class CUgraphNodeType(IntEnum):
    """
    Graph node types
    """
    CU_GRAPH_NODE_TYPE_KERNEL = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_KERNEL
    CU_GRAPH_NODE_TYPE_MEMCPY = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEMCPY
    CU_GRAPH_NODE_TYPE_MEMSET = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEMSET
    CU_GRAPH_NODE_TYPE_HOST = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_HOST
    CU_GRAPH_NODE_TYPE_GRAPH = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_GRAPH
    CU_GRAPH_NODE_TYPE_EMPTY = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EMPTY
    CU_GRAPH_NODE_TYPE_WAIT_EVENT = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_WAIT_EVENT
    CU_GRAPH_NODE_TYPE_EVENT_RECORD = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EVENT_RECORD
    CU_GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EXT_SEMAS_SIGNAL
    CU_GRAPH_NODE_TYPE_EXT_SEMAS_WAIT = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_EXT_SEMAS_WAIT
    CU_GRAPH_NODE_TYPE_MEM_ALLOC = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEM_ALLOC
    CU_GRAPH_NODE_TYPE_MEM_FREE = ccuda.CUgraphNodeType_enum.CU_GRAPH_NODE_TYPE_MEM_FREE

class CUsynchronizationPolicy(IntEnum):
    """

    """
    CU_SYNC_POLICY_AUTO = ccuda.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_AUTO
    CU_SYNC_POLICY_SPIN = ccuda.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_SPIN
    CU_SYNC_POLICY_YIELD = ccuda.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_YIELD
    CU_SYNC_POLICY_BLOCKING_SYNC = ccuda.CUsynchronizationPolicy_enum.CU_SYNC_POLICY_BLOCKING_SYNC

class CUkernelNodeAttrID(IntEnum):
    """
    Graph kernel node Attributes
    """
    CU_KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW = ccuda.CUkernelNodeAttrID_enum.CU_KERNEL_NODE_ATTRIBUTE_ACCESS_POLICY_WINDOW
    CU_KERNEL_NODE_ATTRIBUTE_COOPERATIVE = ccuda.CUkernelNodeAttrID_enum.CU_KERNEL_NODE_ATTRIBUTE_COOPERATIVE

class CUstreamCaptureStatus(IntEnum):
    """
    Possible stream capture statuses returned by cuStreamIsCapturing
    """
    CU_STREAM_CAPTURE_STATUS_NONE = ccuda.CUstreamCaptureStatus_enum.CU_STREAM_CAPTURE_STATUS_NONE
    CU_STREAM_CAPTURE_STATUS_ACTIVE = ccuda.CUstreamCaptureStatus_enum.CU_STREAM_CAPTURE_STATUS_ACTIVE
    CU_STREAM_CAPTURE_STATUS_INVALIDATED = ccuda.CUstreamCaptureStatus_enum.CU_STREAM_CAPTURE_STATUS_INVALIDATED

class CUstreamCaptureMode(IntEnum):
    """
    Possible modes for stream capture thread interactions. For more
    details see cuStreamBeginCapture and
    cuThreadExchangeStreamCaptureMode
    """
    CU_STREAM_CAPTURE_MODE_GLOBAL = ccuda.CUstreamCaptureMode_enum.CU_STREAM_CAPTURE_MODE_GLOBAL
    CU_STREAM_CAPTURE_MODE_THREAD_LOCAL = ccuda.CUstreamCaptureMode_enum.CU_STREAM_CAPTURE_MODE_THREAD_LOCAL
    CU_STREAM_CAPTURE_MODE_RELAXED = ccuda.CUstreamCaptureMode_enum.CU_STREAM_CAPTURE_MODE_RELAXED

class CUstreamAttrID(IntEnum):
    """
    Stream Attributes
    """
    CU_STREAM_ATTRIBUTE_ACCESS_POLICY_WINDOW = ccuda.CUstreamAttrID_enum.CU_STREAM_ATTRIBUTE_ACCESS_POLICY_WINDOW
    CU_STREAM_ATTRIBUTE_SYNCHRONIZATION_POLICY = ccuda.CUstreamAttrID_enum.CU_STREAM_ATTRIBUTE_SYNCHRONIZATION_POLICY

class CUdriverProcAddress_flags(IntEnum):
    """
    Flags to specify search options. For more details see
    cuGetProcAddress
    """
    CU_GET_PROC_ADDRESS_DEFAULT = ccuda.CUdriverProcAddress_flags_enum.CU_GET_PROC_ADDRESS_DEFAULT
    CU_GET_PROC_ADDRESS_LEGACY_STREAM = ccuda.CUdriverProcAddress_flags_enum.CU_GET_PROC_ADDRESS_LEGACY_STREAM
    CU_GET_PROC_ADDRESS_PER_THREAD_DEFAULT_STREAM = ccuda.CUdriverProcAddress_flags_enum.CU_GET_PROC_ADDRESS_PER_THREAD_DEFAULT_STREAM

class CUexecAffinityType(IntEnum):
    """
    Execution Affinity Types
    """
    CU_EXEC_AFFINITY_TYPE_SM_COUNT = ccuda.CUexecAffinityType_enum.CU_EXEC_AFFINITY_TYPE_SM_COUNT
    CU_EXEC_AFFINITY_TYPE_MAX = ccuda.CUexecAffinityType_enum.CU_EXEC_AFFINITY_TYPE_MAX

class CUresult(IntEnum):
    """
    Error codes
    """
    CUDA_SUCCESS = ccuda.cudaError_enum.CUDA_SUCCESS
    CUDA_ERROR_INVALID_VALUE = ccuda.cudaError_enum.CUDA_ERROR_INVALID_VALUE
    CUDA_ERROR_OUT_OF_MEMORY = ccuda.cudaError_enum.CUDA_ERROR_OUT_OF_MEMORY
    CUDA_ERROR_NOT_INITIALIZED = ccuda.cudaError_enum.CUDA_ERROR_NOT_INITIALIZED
    CUDA_ERROR_DEINITIALIZED = ccuda.cudaError_enum.CUDA_ERROR_DEINITIALIZED
    CUDA_ERROR_PROFILER_DISABLED = ccuda.cudaError_enum.CUDA_ERROR_PROFILER_DISABLED
    CUDA_ERROR_PROFILER_NOT_INITIALIZED = ccuda.cudaError_enum.CUDA_ERROR_PROFILER_NOT_INITIALIZED
    CUDA_ERROR_PROFILER_ALREADY_STARTED = ccuda.cudaError_enum.CUDA_ERROR_PROFILER_ALREADY_STARTED
    CUDA_ERROR_PROFILER_ALREADY_STOPPED = ccuda.cudaError_enum.CUDA_ERROR_PROFILER_ALREADY_STOPPED
    CUDA_ERROR_STUB_LIBRARY = ccuda.cudaError_enum.CUDA_ERROR_STUB_LIBRARY
    CUDA_ERROR_NO_DEVICE = ccuda.cudaError_enum.CUDA_ERROR_NO_DEVICE
    CUDA_ERROR_INVALID_DEVICE = ccuda.cudaError_enum.CUDA_ERROR_INVALID_DEVICE
    CUDA_ERROR_DEVICE_NOT_LICENSED = ccuda.cudaError_enum.CUDA_ERROR_DEVICE_NOT_LICENSED
    CUDA_ERROR_INVALID_IMAGE = ccuda.cudaError_enum.CUDA_ERROR_INVALID_IMAGE
    CUDA_ERROR_INVALID_CONTEXT = ccuda.cudaError_enum.CUDA_ERROR_INVALID_CONTEXT
    CUDA_ERROR_CONTEXT_ALREADY_CURRENT = ccuda.cudaError_enum.CUDA_ERROR_CONTEXT_ALREADY_CURRENT
    CUDA_ERROR_MAP_FAILED = ccuda.cudaError_enum.CUDA_ERROR_MAP_FAILED
    CUDA_ERROR_UNMAP_FAILED = ccuda.cudaError_enum.CUDA_ERROR_UNMAP_FAILED
    CUDA_ERROR_ARRAY_IS_MAPPED = ccuda.cudaError_enum.CUDA_ERROR_ARRAY_IS_MAPPED
    CUDA_ERROR_ALREADY_MAPPED = ccuda.cudaError_enum.CUDA_ERROR_ALREADY_MAPPED
    CUDA_ERROR_NO_BINARY_FOR_GPU = ccuda.cudaError_enum.CUDA_ERROR_NO_BINARY_FOR_GPU
    CUDA_ERROR_ALREADY_ACQUIRED = ccuda.cudaError_enum.CUDA_ERROR_ALREADY_ACQUIRED
    CUDA_ERROR_NOT_MAPPED = ccuda.cudaError_enum.CUDA_ERROR_NOT_MAPPED
    CUDA_ERROR_NOT_MAPPED_AS_ARRAY = ccuda.cudaError_enum.CUDA_ERROR_NOT_MAPPED_AS_ARRAY
    CUDA_ERROR_NOT_MAPPED_AS_POINTER = ccuda.cudaError_enum.CUDA_ERROR_NOT_MAPPED_AS_POINTER
    CUDA_ERROR_ECC_UNCORRECTABLE = ccuda.cudaError_enum.CUDA_ERROR_ECC_UNCORRECTABLE
    CUDA_ERROR_UNSUPPORTED_LIMIT = ccuda.cudaError_enum.CUDA_ERROR_UNSUPPORTED_LIMIT
    CUDA_ERROR_CONTEXT_ALREADY_IN_USE = ccuda.cudaError_enum.CUDA_ERROR_CONTEXT_ALREADY_IN_USE
    CUDA_ERROR_PEER_ACCESS_UNSUPPORTED = ccuda.cudaError_enum.CUDA_ERROR_PEER_ACCESS_UNSUPPORTED
    CUDA_ERROR_INVALID_PTX = ccuda.cudaError_enum.CUDA_ERROR_INVALID_PTX
    CUDA_ERROR_INVALID_GRAPHICS_CONTEXT = ccuda.cudaError_enum.CUDA_ERROR_INVALID_GRAPHICS_CONTEXT
    CUDA_ERROR_NVLINK_UNCORRECTABLE = ccuda.cudaError_enum.CUDA_ERROR_NVLINK_UNCORRECTABLE
    CUDA_ERROR_JIT_COMPILER_NOT_FOUND = ccuda.cudaError_enum.CUDA_ERROR_JIT_COMPILER_NOT_FOUND
    CUDA_ERROR_UNSUPPORTED_PTX_VERSION = ccuda.cudaError_enum.CUDA_ERROR_UNSUPPORTED_PTX_VERSION
    CUDA_ERROR_JIT_COMPILATION_DISABLED = ccuda.cudaError_enum.CUDA_ERROR_JIT_COMPILATION_DISABLED
    CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY = ccuda.cudaError_enum.CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY
    CUDA_ERROR_INVALID_SOURCE = ccuda.cudaError_enum.CUDA_ERROR_INVALID_SOURCE
    CUDA_ERROR_FILE_NOT_FOUND = ccuda.cudaError_enum.CUDA_ERROR_FILE_NOT_FOUND
    CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND = ccuda.cudaError_enum.CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND
    CUDA_ERROR_SHARED_OBJECT_INIT_FAILED = ccuda.cudaError_enum.CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    CUDA_ERROR_OPERATING_SYSTEM = ccuda.cudaError_enum.CUDA_ERROR_OPERATING_SYSTEM
    CUDA_ERROR_INVALID_HANDLE = ccuda.cudaError_enum.CUDA_ERROR_INVALID_HANDLE
    CUDA_ERROR_ILLEGAL_STATE = ccuda.cudaError_enum.CUDA_ERROR_ILLEGAL_STATE
    CUDA_ERROR_NOT_FOUND = ccuda.cudaError_enum.CUDA_ERROR_NOT_FOUND
    CUDA_ERROR_NOT_READY = ccuda.cudaError_enum.CUDA_ERROR_NOT_READY
    CUDA_ERROR_ILLEGAL_ADDRESS = ccuda.cudaError_enum.CUDA_ERROR_ILLEGAL_ADDRESS
    CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES = ccuda.cudaError_enum.CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
    CUDA_ERROR_LAUNCH_TIMEOUT = ccuda.cudaError_enum.CUDA_ERROR_LAUNCH_TIMEOUT
    CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING = ccuda.cudaError_enum.CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
    CUDA_ERROR_PEER_ACCESS_ALREADY_ENABLED = ccuda.cudaError_enum.CUDA_ERROR_PEER_ACCESS_ALREADY_ENABLED
    CUDA_ERROR_PEER_ACCESS_NOT_ENABLED = ccuda.cudaError_enum.CUDA_ERROR_PEER_ACCESS_NOT_ENABLED
    CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE = ccuda.cudaError_enum.CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE
    CUDA_ERROR_CONTEXT_IS_DESTROYED = ccuda.cudaError_enum.CUDA_ERROR_CONTEXT_IS_DESTROYED
    CUDA_ERROR_ASSERT = ccuda.cudaError_enum.CUDA_ERROR_ASSERT
    CUDA_ERROR_TOO_MANY_PEERS = ccuda.cudaError_enum.CUDA_ERROR_TOO_MANY_PEERS
    CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED = ccuda.cudaError_enum.CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED
    CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED = ccuda.cudaError_enum.CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED
    CUDA_ERROR_HARDWARE_STACK_ERROR = ccuda.cudaError_enum.CUDA_ERROR_HARDWARE_STACK_ERROR
    CUDA_ERROR_ILLEGAL_INSTRUCTION = ccuda.cudaError_enum.CUDA_ERROR_ILLEGAL_INSTRUCTION
    CUDA_ERROR_MISALIGNED_ADDRESS = ccuda.cudaError_enum.CUDA_ERROR_MISALIGNED_ADDRESS
    CUDA_ERROR_INVALID_ADDRESS_SPACE = ccuda.cudaError_enum.CUDA_ERROR_INVALID_ADDRESS_SPACE
    CUDA_ERROR_INVALID_PC = ccuda.cudaError_enum.CUDA_ERROR_INVALID_PC
    CUDA_ERROR_LAUNCH_FAILED = ccuda.cudaError_enum.CUDA_ERROR_LAUNCH_FAILED
    CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE = ccuda.cudaError_enum.CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE
    CUDA_ERROR_NOT_PERMITTED = ccuda.cudaError_enum.CUDA_ERROR_NOT_PERMITTED
    CUDA_ERROR_NOT_SUPPORTED = ccuda.cudaError_enum.CUDA_ERROR_NOT_SUPPORTED
    CUDA_ERROR_SYSTEM_NOT_READY = ccuda.cudaError_enum.CUDA_ERROR_SYSTEM_NOT_READY
    CUDA_ERROR_SYSTEM_DRIVER_MISMATCH = ccuda.cudaError_enum.CUDA_ERROR_SYSTEM_DRIVER_MISMATCH
    CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE = ccuda.cudaError_enum.CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE
    CUDA_ERROR_MPS_CONNECTION_FAILED = ccuda.cudaError_enum.CUDA_ERROR_MPS_CONNECTION_FAILED
    CUDA_ERROR_MPS_RPC_FAILURE = ccuda.cudaError_enum.CUDA_ERROR_MPS_RPC_FAILURE
    CUDA_ERROR_MPS_SERVER_NOT_READY = ccuda.cudaError_enum.CUDA_ERROR_MPS_SERVER_NOT_READY
    CUDA_ERROR_MPS_MAX_CLIENTS_REACHED = ccuda.cudaError_enum.CUDA_ERROR_MPS_MAX_CLIENTS_REACHED
    CUDA_ERROR_MPS_MAX_CONNECTIONS_REACHED = ccuda.cudaError_enum.CUDA_ERROR_MPS_MAX_CONNECTIONS_REACHED
    CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_UNSUPPORTED
    CUDA_ERROR_STREAM_CAPTURE_INVALIDATED = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_INVALIDATED
    CUDA_ERROR_STREAM_CAPTURE_MERGE = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_MERGE
    CUDA_ERROR_STREAM_CAPTURE_UNMATCHED = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_UNMATCHED
    CUDA_ERROR_STREAM_CAPTURE_UNJOINED = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_UNJOINED
    CUDA_ERROR_STREAM_CAPTURE_ISOLATION = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_ISOLATION
    CUDA_ERROR_STREAM_CAPTURE_IMPLICIT = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_IMPLICIT
    CUDA_ERROR_CAPTURED_EVENT = ccuda.cudaError_enum.CUDA_ERROR_CAPTURED_EVENT
    CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD = ccuda.cudaError_enum.CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD
    CUDA_ERROR_TIMEOUT = ccuda.cudaError_enum.CUDA_ERROR_TIMEOUT
    CUDA_ERROR_GRAPH_EXEC_UPDATE_FAILURE = ccuda.cudaError_enum.CUDA_ERROR_GRAPH_EXEC_UPDATE_FAILURE
    CUDA_ERROR_EXTERNAL_DEVICE = ccuda.cudaError_enum.CUDA_ERROR_EXTERNAL_DEVICE
    CUDA_ERROR_UNKNOWN = ccuda.cudaError_enum.CUDA_ERROR_UNKNOWN

class CUdevice_P2PAttribute(IntEnum):
    """
    P2P Attributes
    """
    CU_DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK = ccuda.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_PERFORMANCE_RANK
    CU_DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED = ccuda.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_ACCESS_SUPPORTED
    CU_DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED = ccuda.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_NATIVE_ATOMIC_SUPPORTED
    CU_DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED = ccuda.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_ACCESS_ACCESS_SUPPORTED
    CU_DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED = ccuda.CUdevice_P2PAttribute_enum.CU_DEVICE_P2P_ATTRIBUTE_CUDA_ARRAY_ACCESS_SUPPORTED

class CUresourceViewFormat(IntEnum):
    """
    Resource view format
    """
    CU_RES_VIEW_FORMAT_NONE = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_NONE
    CU_RES_VIEW_FORMAT_UINT_1X8 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_1X8
    CU_RES_VIEW_FORMAT_UINT_2X8 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_2X8
    CU_RES_VIEW_FORMAT_UINT_4X8 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_4X8
    CU_RES_VIEW_FORMAT_SINT_1X8 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_1X8
    CU_RES_VIEW_FORMAT_SINT_2X8 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_2X8
    CU_RES_VIEW_FORMAT_SINT_4X8 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_4X8
    CU_RES_VIEW_FORMAT_UINT_1X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_1X16
    CU_RES_VIEW_FORMAT_UINT_2X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_2X16
    CU_RES_VIEW_FORMAT_UINT_4X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_4X16
    CU_RES_VIEW_FORMAT_SINT_1X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_1X16
    CU_RES_VIEW_FORMAT_SINT_2X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_2X16
    CU_RES_VIEW_FORMAT_SINT_4X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_4X16
    CU_RES_VIEW_FORMAT_UINT_1X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_1X32
    CU_RES_VIEW_FORMAT_UINT_2X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_2X32
    CU_RES_VIEW_FORMAT_UINT_4X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UINT_4X32
    CU_RES_VIEW_FORMAT_SINT_1X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_1X32
    CU_RES_VIEW_FORMAT_SINT_2X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_2X32
    CU_RES_VIEW_FORMAT_SINT_4X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SINT_4X32
    CU_RES_VIEW_FORMAT_FLOAT_1X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_1X16
    CU_RES_VIEW_FORMAT_FLOAT_2X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_2X16
    CU_RES_VIEW_FORMAT_FLOAT_4X16 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_4X16
    CU_RES_VIEW_FORMAT_FLOAT_1X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_1X32
    CU_RES_VIEW_FORMAT_FLOAT_2X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_2X32
    CU_RES_VIEW_FORMAT_FLOAT_4X32 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_FLOAT_4X32
    CU_RES_VIEW_FORMAT_UNSIGNED_BC1 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC1
    CU_RES_VIEW_FORMAT_UNSIGNED_BC2 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC2
    CU_RES_VIEW_FORMAT_UNSIGNED_BC3 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC3
    CU_RES_VIEW_FORMAT_UNSIGNED_BC4 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC4
    CU_RES_VIEW_FORMAT_SIGNED_BC4 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SIGNED_BC4
    CU_RES_VIEW_FORMAT_UNSIGNED_BC5 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC5
    CU_RES_VIEW_FORMAT_SIGNED_BC5 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SIGNED_BC5
    CU_RES_VIEW_FORMAT_UNSIGNED_BC6H = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC6H
    CU_RES_VIEW_FORMAT_SIGNED_BC6H = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_SIGNED_BC6H
    CU_RES_VIEW_FORMAT_UNSIGNED_BC7 = ccuda.CUresourceViewFormat_enum.CU_RES_VIEW_FORMAT_UNSIGNED_BC7

class CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS(IntEnum):
    """
    Access flags that specify the level of access the current context's
    device has on the memory referenced.
    """
    CU_POINTER_ATTRIBUTE_ACCESS_FLAG_NONE = ccuda.CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAG_NONE
    CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READ = ccuda.CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READ
    CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READWRITE = ccuda.CUDA_POINTER_ATTRIBUTE_ACCESS_FLAGS_enum.CU_POINTER_ATTRIBUTE_ACCESS_FLAG_READWRITE

class CUexternalMemoryHandleType(IntEnum):
    """
    External memory handle types
    """
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32 = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF = ccuda.CUexternalMemoryHandleType_enum.CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF

class CUexternalSemaphoreHandleType(IntEnum):
    """
    External semaphore handle types
    """
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32 = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32 = ccuda.CUexternalSemaphoreHandleType_enum.CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32

class CUmemAllocationHandleType(IntEnum):
    """
    Flags for specifying particular handle types
    """
    CU_MEM_HANDLE_TYPE_NONE = ccuda.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_NONE
    CU_MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR = ccuda.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR
    CU_MEM_HANDLE_TYPE_WIN32 = ccuda.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_WIN32
    CU_MEM_HANDLE_TYPE_WIN32_KMT = ccuda.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_WIN32_KMT
    CU_MEM_HANDLE_TYPE_MAX = ccuda.CUmemAllocationHandleType_enum.CU_MEM_HANDLE_TYPE_MAX

class CUmemAccess_flags(IntEnum):
    """
    Specifies the memory protection flags for mapping.
    """
    CU_MEM_ACCESS_FLAGS_PROT_NONE = ccuda.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_NONE
    CU_MEM_ACCESS_FLAGS_PROT_READ = ccuda.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_READ
    CU_MEM_ACCESS_FLAGS_PROT_READWRITE = ccuda.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_READWRITE
    CU_MEM_ACCESS_FLAGS_PROT_MAX = ccuda.CUmemAccess_flags_enum.CU_MEM_ACCESS_FLAGS_PROT_MAX

class CUmemLocationType(IntEnum):
    """
    Specifies the type of location
    """
    CU_MEM_LOCATION_TYPE_INVALID = ccuda.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_INVALID
    CU_MEM_LOCATION_TYPE_DEVICE = ccuda.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_DEVICE
    CU_MEM_LOCATION_TYPE_MAX = ccuda.CUmemLocationType_enum.CU_MEM_LOCATION_TYPE_MAX

class CUmemAllocationType(IntEnum):
    """
    Defines the allocation types available
    """
    CU_MEM_ALLOCATION_TYPE_INVALID = ccuda.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_INVALID
    CU_MEM_ALLOCATION_TYPE_PINNED = ccuda.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_PINNED
    CU_MEM_ALLOCATION_TYPE_MAX = ccuda.CUmemAllocationType_enum.CU_MEM_ALLOCATION_TYPE_MAX

class CUmemAllocationGranularity_flags(IntEnum):
    """
    Flag for requesting different optimal and required granularities
    for an allocation.
    """
    CU_MEM_ALLOC_GRANULARITY_MINIMUM = ccuda.CUmemAllocationGranularity_flags_enum.CU_MEM_ALLOC_GRANULARITY_MINIMUM
    CU_MEM_ALLOC_GRANULARITY_RECOMMENDED = ccuda.CUmemAllocationGranularity_flags_enum.CU_MEM_ALLOC_GRANULARITY_RECOMMENDED

class CUarraySparseSubresourceType(IntEnum):
    """
    Sparse subresource types
    """
    CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL = ccuda.CUarraySparseSubresourceType_enum.CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL
    CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL = ccuda.CUarraySparseSubresourceType_enum.CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL

class CUmemOperationType(IntEnum):
    """
    Memory operation types
    """
    CU_MEM_OPERATION_TYPE_MAP = ccuda.CUmemOperationType_enum.CU_MEM_OPERATION_TYPE_MAP
    CU_MEM_OPERATION_TYPE_UNMAP = ccuda.CUmemOperationType_enum.CU_MEM_OPERATION_TYPE_UNMAP

class CUmemHandleType(IntEnum):
    """
    Memory handle types
    """
    CU_MEM_HANDLE_TYPE_GENERIC = ccuda.CUmemHandleType_enum.CU_MEM_HANDLE_TYPE_GENERIC

class CUmemAllocationCompType(IntEnum):
    """
    Specifies compression attribute for an allocation.
    """
    CU_MEM_ALLOCATION_COMP_NONE = ccuda.CUmemAllocationCompType_enum.CU_MEM_ALLOCATION_COMP_NONE
    CU_MEM_ALLOCATION_COMP_GENERIC = ccuda.CUmemAllocationCompType_enum.CU_MEM_ALLOCATION_COMP_GENERIC

class CUgraphExecUpdateResult(IntEnum):
    """

    """
    CU_GRAPH_EXEC_UPDATE_SUCCESS = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_SUCCESS
    CU_GRAPH_EXEC_UPDATE_ERROR = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR
    CU_GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_TOPOLOGY_CHANGED
    CU_GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_NODE_TYPE_CHANGED
    CU_GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_FUNCTION_CHANGED
    CU_GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_PARAMETERS_CHANGED
    CU_GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_NOT_SUPPORTED
    CU_GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_UNSUPPORTED_FUNCTION_CHANGE
    CU_GRAPH_EXEC_UPDATE_ERROR_ATTRIBUTES_CHANGED = ccuda.CUgraphExecUpdateResult_enum.CU_GRAPH_EXEC_UPDATE_ERROR_ATTRIBUTES_CHANGED

class CUmemPool_attribute(IntEnum):
    """
    CUDA memory pool attributes
    """
    CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES
    CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC
    CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES
    CU_MEMPOOL_ATTR_RELEASE_THRESHOLD = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_RELEASE_THRESHOLD
    CU_MEMPOOL_ATTR_RESERVED_MEM_CURRENT = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_RESERVED_MEM_CURRENT
    CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH
    CU_MEMPOOL_ATTR_USED_MEM_CURRENT = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_USED_MEM_CURRENT
    CU_MEMPOOL_ATTR_USED_MEM_HIGH = ccuda.CUmemPool_attribute_enum.CU_MEMPOOL_ATTR_USED_MEM_HIGH

class CUgraphMem_attribute(IntEnum):
    """

    """
    CU_GRAPH_MEM_ATTR_USED_MEM_CURRENT = ccuda.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_USED_MEM_CURRENT
    CU_GRAPH_MEM_ATTR_USED_MEM_HIGH = ccuda.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_USED_MEM_HIGH
    CU_GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT = ccuda.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT
    CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH = ccuda.CUgraphMem_attribute_enum.CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH

class CUflushGPUDirectRDMAWritesOptions(IntEnum):
    """
    Bitmasks for
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS
    """
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_HOST = ccuda.CUflushGPUDirectRDMAWritesOptions_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_HOST
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_MEMOPS = ccuda.CUflushGPUDirectRDMAWritesOptions_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_OPTION_MEMOPS

class CUGPUDirectRDMAWritesOrdering(IntEnum):
    """
    Platform native ordering for GPUDirect RDMA writes
    """
    CU_GPU_DIRECT_RDMA_WRITES_ORDERING_NONE = ccuda.CUGPUDirectRDMAWritesOrdering_enum.CU_GPU_DIRECT_RDMA_WRITES_ORDERING_NONE
    CU_GPU_DIRECT_RDMA_WRITES_ORDERING_OWNER = ccuda.CUGPUDirectRDMAWritesOrdering_enum.CU_GPU_DIRECT_RDMA_WRITES_ORDERING_OWNER
    CU_GPU_DIRECT_RDMA_WRITES_ORDERING_ALL_DEVICES = ccuda.CUGPUDirectRDMAWritesOrdering_enum.CU_GPU_DIRECT_RDMA_WRITES_ORDERING_ALL_DEVICES

class CUflushGPUDirectRDMAWritesScope(IntEnum):
    """
    The scopes for cuFlushGPUDirectRDMAWrites
    """
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_OWNER = ccuda.CUflushGPUDirectRDMAWritesScope_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_OWNER
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_ALL_DEVICES = ccuda.CUflushGPUDirectRDMAWritesScope_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TO_ALL_DEVICES

class CUflushGPUDirectRDMAWritesTarget(IntEnum):
    """
    The targets for cuFlushGPUDirectRDMAWrites
    """
    CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TARGET_CURRENT_CTX = ccuda.CUflushGPUDirectRDMAWritesTarget_enum.CU_FLUSH_GPU_DIRECT_RDMA_WRITES_TARGET_CURRENT_CTX

class CUgraphDebugDot_flags(IntEnum):
    """
    The additional write options for cuGraphDebugDotPrint
    """
    CU_GRAPH_DEBUG_DOT_FLAGS_VERBOSE = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_VERBOSE
    CU_GRAPH_DEBUG_DOT_FLAGS_RUNTIME_TYPES = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_RUNTIME_TYPES
    CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_MEMCPY_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEMCPY_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_MEMSET_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEMSET_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_HOST_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_HOST_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_EVENT_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EVENT_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_SIGNAL_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_SIGNAL_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_WAIT_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_EXT_SEMAS_WAIT_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_ATTRIBUTES = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_KERNEL_NODE_ATTRIBUTES
    CU_GRAPH_DEBUG_DOT_FLAGS_HANDLES = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_HANDLES
    CU_GRAPH_DEBUG_DOT_FLAGS_MEM_ALLOC_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEM_ALLOC_NODE_PARAMS
    CU_GRAPH_DEBUG_DOT_FLAGS_MEM_FREE_NODE_PARAMS = ccuda.CUgraphDebugDot_flags_enum.CU_GRAPH_DEBUG_DOT_FLAGS_MEM_FREE_NODE_PARAMS

class CUuserObject_flags(IntEnum):
    """
    Flags for user objects for graphs
    """
    CU_USER_OBJECT_NO_DESTRUCTOR_SYNC = ccuda.CUuserObject_flags_enum.CU_USER_OBJECT_NO_DESTRUCTOR_SYNC

class CUuserObjectRetain_flags(IntEnum):
    """
    Flags for retaining user object references for graphs
    """
    CU_GRAPH_USER_OBJECT_MOVE = ccuda.CUuserObjectRetain_flags_enum.CU_GRAPH_USER_OBJECT_MOVE

class CUgraphInstantiate_flags(IntEnum):
    """
    Flags for instantiating a graph
    """
    CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH = ccuda.CUgraphInstantiate_flags_enum.CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH

class CUoutput_mode(IntEnum):
    """
    Profiler Output Modes
    """
    CU_OUT_KEY_VALUE_PAIR = ccuda.CUoutput_mode_enum.CU_OUT_KEY_VALUE_PAIR
    CU_OUT_CSV = ccuda.CUoutput_mode_enum.CU_OUT_CSV

class CUeglFrameType(IntEnum):
    """
    CUDA EglFrame type - array or pointer
    """
    CU_EGL_FRAME_TYPE_ARRAY = ccuda.CUeglFrameType_enum.CU_EGL_FRAME_TYPE_ARRAY
    CU_EGL_FRAME_TYPE_PITCH = ccuda.CUeglFrameType_enum.CU_EGL_FRAME_TYPE_PITCH

class CUeglResourceLocationFlags(IntEnum):
    """
    Resource location flags- sysmem or vidmem  For CUDA context on
    iGPU, since video and system memory are equivalent - these flags
    will not have an effect on the execution.  For CUDA context on
    dGPU, applications can use the flag CUeglResourceLocationFlags to
    give a hint about the desired location.
    CU_EGL_RESOURCE_LOCATION_SYSMEM - the frame data is made resident
    on the system memory to be accessed by CUDA.
    CU_EGL_RESOURCE_LOCATION_VIDMEM - the frame data is made resident
    on the dedicated video memory to be accessed by CUDA.  There may be
    an additional latency due to new allocation and data migration, if
    the frame is produced on a different memory.
    """
    CU_EGL_RESOURCE_LOCATION_SYSMEM = ccuda.CUeglResourceLocationFlags_enum.CU_EGL_RESOURCE_LOCATION_SYSMEM
    CU_EGL_RESOURCE_LOCATION_VIDMEM = ccuda.CUeglResourceLocationFlags_enum.CU_EGL_RESOURCE_LOCATION_VIDMEM

class CUeglColorFormat(IntEnum):
    """
    CUDA EGL Color Format - The different planar and multiplanar
    formats currently supported for CUDA_EGL interops. Three channel
    formats are currently not supported for CU_EGL_FRAME_TYPE_ARRAY
    """
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_YUV422_PLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_PLANAR
    CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_RGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_RGB
    CU_EGL_COLOR_FORMAT_BGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BGR
    CU_EGL_COLOR_FORMAT_ARGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_ARGB
    CU_EGL_COLOR_FORMAT_RGBA = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_RGBA
    CU_EGL_COLOR_FORMAT_L = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_L
    CU_EGL_COLOR_FORMAT_R = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_R
    CU_EGL_COLOR_FORMAT_YUV444_PLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_PLANAR
    CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_YUYV_422 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUYV_422
    CU_EGL_COLOR_FORMAT_UYVY_422 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_422
    CU_EGL_COLOR_FORMAT_ABGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_ABGR
    CU_EGL_COLOR_FORMAT_BGRA = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BGRA
    CU_EGL_COLOR_FORMAT_A = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_A
    CU_EGL_COLOR_FORMAT_RG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_RG
    CU_EGL_COLOR_FORMAT_AYUV = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_AYUV
    CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_VYUY_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_VYUY_ER
    CU_EGL_COLOR_FORMAT_UYVY_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_UYVY_ER
    CU_EGL_COLOR_FORMAT_YUYV_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUYV_ER
    CU_EGL_COLOR_FORMAT_YVYU_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVYU_ER
    CU_EGL_COLOR_FORMAT_YUV_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV_ER
    CU_EGL_COLOR_FORMAT_YUVA_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUVA_ER
    CU_EGL_COLOR_FORMAT_AYUV_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_AYUV_ER
    CU_EGL_COLOR_FORMAT_YUV444_PLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_PLANAR_ER
    CU_EGL_COLOR_FORMAT_YUV422_PLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_PLANAR_ER
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR_ER
    CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV444_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV422_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_YVU444_PLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_PLANAR_ER
    CU_EGL_COLOR_FORMAT_YVU422_PLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_PLANAR_ER
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR_ER
    CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_BAYER_RGGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_RGGB
    CU_EGL_COLOR_FORMAT_BAYER_BGGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_BGGR
    CU_EGL_COLOR_FORMAT_BAYER_GRBG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_GRBG
    CU_EGL_COLOR_FORMAT_BAYER_GBRG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_GBRG
    CU_EGL_COLOR_FORMAT_BAYER10_RGGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_RGGB
    CU_EGL_COLOR_FORMAT_BAYER10_BGGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_BGGR
    CU_EGL_COLOR_FORMAT_BAYER10_GRBG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_GRBG
    CU_EGL_COLOR_FORMAT_BAYER10_GBRG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_GBRG
    CU_EGL_COLOR_FORMAT_BAYER12_RGGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_RGGB
    CU_EGL_COLOR_FORMAT_BAYER12_BGGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_BGGR
    CU_EGL_COLOR_FORMAT_BAYER12_GRBG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_GRBG
    CU_EGL_COLOR_FORMAT_BAYER12_GBRG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_GBRG
    CU_EGL_COLOR_FORMAT_BAYER14_RGGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_RGGB
    CU_EGL_COLOR_FORMAT_BAYER14_BGGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_BGGR
    CU_EGL_COLOR_FORMAT_BAYER14_GRBG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_GRBG
    CU_EGL_COLOR_FORMAT_BAYER14_GBRG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER14_GBRG
    CU_EGL_COLOR_FORMAT_BAYER20_RGGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_RGGB
    CU_EGL_COLOR_FORMAT_BAYER20_BGGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_BGGR
    CU_EGL_COLOR_FORMAT_BAYER20_GRBG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_GRBG
    CU_EGL_COLOR_FORMAT_BAYER20_GBRG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER20_GBRG
    CU_EGL_COLOR_FORMAT_YVU444_PLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU444_PLANAR
    CU_EGL_COLOR_FORMAT_YVU422_PLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU422_PLANAR
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR
    CU_EGL_COLOR_FORMAT_BAYER_ISP_RGGB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_RGGB
    CU_EGL_COLOR_FORMAT_BAYER_ISP_BGGR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_BGGR
    CU_EGL_COLOR_FORMAT_BAYER_ISP_GRBG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_GRBG
    CU_EGL_COLOR_FORMAT_BAYER_ISP_GBRG = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_ISP_GBRG
    CU_EGL_COLOR_FORMAT_BAYER_BCCR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_BCCR
    CU_EGL_COLOR_FORMAT_BAYER_RCCB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_RCCB
    CU_EGL_COLOR_FORMAT_BAYER_CRBC = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_CRBC
    CU_EGL_COLOR_FORMAT_BAYER_CBRC = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER_CBRC
    CU_EGL_COLOR_FORMAT_BAYER10_CCCC = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER10_CCCC
    CU_EGL_COLOR_FORMAT_BAYER12_BCCR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_BCCR
    CU_EGL_COLOR_FORMAT_BAYER12_RCCB = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_RCCB
    CU_EGL_COLOR_FORMAT_BAYER12_CRBC = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_CRBC
    CU_EGL_COLOR_FORMAT_BAYER12_CBRC = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_CBRC
    CU_EGL_COLOR_FORMAT_BAYER12_CCCC = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_BAYER12_CCCC
    CU_EGL_COLOR_FORMAT_Y = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_2020 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_2020
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_2020 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_2020
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR_2020 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR_2020
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR_2020 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR_2020
    CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_709 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_SEMIPLANAR_709
    CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_709 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_SEMIPLANAR_709
    CU_EGL_COLOR_FORMAT_YUV420_PLANAR_709 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV420_PLANAR_709
    CU_EGL_COLOR_FORMAT_YVU420_PLANAR_709 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVU420_PLANAR_709
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_2020 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_2020
    CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_2020 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_2020
    CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR
    CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_709 = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_422_SEMIPLANAR_709
    CU_EGL_COLOR_FORMAT_Y_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y_ER
    CU_EGL_COLOR_FORMAT_Y_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y_709_ER
    CU_EGL_COLOR_FORMAT_Y10_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10_ER
    CU_EGL_COLOR_FORMAT_Y10_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10_709_ER
    CU_EGL_COLOR_FORMAT_Y12_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12_ER
    CU_EGL_COLOR_FORMAT_Y12_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12_709_ER
    CU_EGL_COLOR_FORMAT_YUVA = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUVA
    CU_EGL_COLOR_FORMAT_YUV = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YUV
    CU_EGL_COLOR_FORMAT_YVYU = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_YVYU
    CU_EGL_COLOR_FORMAT_VYUY = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_VYUY
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_420_SEMIPLANAR_709_ER
    CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y10V10U10_444_SEMIPLANAR_709_ER
    CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_420_SEMIPLANAR_709_ER
    CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_ER
    CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_709_ER = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_Y12V12U12_444_SEMIPLANAR_709_ER
    CU_EGL_COLOR_FORMAT_MAX = ccuda.CUeglColorFormat_enum.CU_EGL_COLOR_FORMAT_MAX

class CUGLDeviceList(IntEnum):
    """
    CUDA devices corresponding to an OpenGL device
    """
    CU_GL_DEVICE_LIST_ALL = ccuda.CUGLDeviceList_enum.CU_GL_DEVICE_LIST_ALL
    CU_GL_DEVICE_LIST_CURRENT_FRAME = ccuda.CUGLDeviceList_enum.CU_GL_DEVICE_LIST_CURRENT_FRAME
    CU_GL_DEVICE_LIST_NEXT_FRAME = ccuda.CUGLDeviceList_enum.CU_GL_DEVICE_LIST_NEXT_FRAME

class CUGLmap_flags(IntEnum):
    """
    Flags to map or unmap a resource
    """
    CU_GL_MAP_RESOURCE_FLAGS_NONE = ccuda.CUGLmap_flags_enum.CU_GL_MAP_RESOURCE_FLAGS_NONE
    CU_GL_MAP_RESOURCE_FLAGS_READ_ONLY = ccuda.CUGLmap_flags_enum.CU_GL_MAP_RESOURCE_FLAGS_READ_ONLY
    CU_GL_MAP_RESOURCE_FLAGS_WRITE_DISCARD = ccuda.CUGLmap_flags_enum.CU_GL_MAP_RESOURCE_FLAGS_WRITE_DISCARD

cdef class CUcontext:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUcontext *>calloc(1, sizeof(ccuda.CUcontext))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUcontext)))
            self._ptr[0] = <ccuda.CUcontext>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUcontext *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUcontext ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUmodule:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmodule *>calloc(1, sizeof(ccuda.CUmodule))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmodule)))
            self._ptr[0] = <ccuda.CUmodule>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmodule *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUmodule ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUfunction:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUfunction *>calloc(1, sizeof(ccuda.CUfunction))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUfunction)))
            self._ptr[0] = <ccuda.CUfunction>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUfunction *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUfunction ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUarray:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUarray *>calloc(1, sizeof(ccuda.CUarray))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUarray)))
            self._ptr[0] = <ccuda.CUarray>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUarray *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUarray ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUmipmappedArray:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmipmappedArray *>calloc(1, sizeof(ccuda.CUmipmappedArray))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmipmappedArray)))
            self._ptr[0] = <ccuda.CUmipmappedArray>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmipmappedArray *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUmipmappedArray ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUtexref:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUtexref *>calloc(1, sizeof(ccuda.CUtexref))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUtexref)))
            self._ptr[0] = <ccuda.CUtexref>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUtexref *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUtexref ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUsurfref:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUsurfref *>calloc(1, sizeof(ccuda.CUsurfref))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUsurfref)))
            self._ptr[0] = <ccuda.CUsurfref>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUsurfref *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUsurfref ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUevent:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUevent *>calloc(1, sizeof(ccuda.CUevent))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUevent)))
            self._ptr[0] = <ccuda.CUevent>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUevent *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUevent ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUstream:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstream *>calloc(1, sizeof(ccuda.CUstream))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstream)))
            self._ptr[0] = <ccuda.CUstream>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstream *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUstream ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUgraphicsResource:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUgraphicsResource *>calloc(1, sizeof(ccuda.CUgraphicsResource))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUgraphicsResource)))
            self._ptr[0] = <ccuda.CUgraphicsResource>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUgraphicsResource *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUgraphicsResource ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUexternalMemory:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUexternalMemory *>calloc(1, sizeof(ccuda.CUexternalMemory))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUexternalMemory)))
            self._ptr[0] = <ccuda.CUexternalMemory>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUexternalMemory *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUexternalMemory ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUexternalSemaphore:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUexternalSemaphore *>calloc(1, sizeof(ccuda.CUexternalSemaphore))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUexternalSemaphore)))
            self._ptr[0] = <ccuda.CUexternalSemaphore>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUexternalSemaphore *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUexternalSemaphore ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUgraph:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUgraph *>calloc(1, sizeof(ccuda.CUgraph))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUgraph)))
            self._ptr[0] = <ccuda.CUgraph>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUgraph *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUgraph ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUgraphNode:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUgraphNode *>calloc(1, sizeof(ccuda.CUgraphNode))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUgraphNode)))
            self._ptr[0] = <ccuda.CUgraphNode>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUgraphNode *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUgraphNode ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUgraphExec:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUgraphExec *>calloc(1, sizeof(ccuda.CUgraphExec))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUgraphExec)))
            self._ptr[0] = <ccuda.CUgraphExec>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUgraphExec *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUgraphExec ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUmemoryPool:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemoryPool *>calloc(1, sizeof(ccuda.CUmemoryPool))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemoryPool)))
            self._ptr[0] = <ccuda.CUmemoryPool>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemoryPool *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUmemoryPool ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUuserObject:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUuserObject *>calloc(1, sizeof(ccuda.CUuserObject))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUuserObject)))
            self._ptr[0] = <ccuda.CUuserObject>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUuserObject *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUuserObject ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUlinkState:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUlinkState *>calloc(1, sizeof(ccuda.CUlinkState))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUlinkState)))
            self._ptr[0] = <ccuda.CUlinkState>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUlinkState *>_ptr
    def __init__(self, *args, **kwargs):
        self._keepalive = []
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUlinkState ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class EGLImageKHR:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.EGLImageKHR *>calloc(1, sizeof(ccuda.EGLImageKHR))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.EGLImageKHR)))
            self._ptr[0] = <ccuda.EGLImageKHR>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.EGLImageKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<EGLImageKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class EGLStreamKHR:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.EGLStreamKHR *>calloc(1, sizeof(ccuda.EGLStreamKHR))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.EGLStreamKHR)))
            self._ptr[0] = <ccuda.EGLStreamKHR>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.EGLStreamKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<EGLStreamKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class EGLSyncKHR:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.EGLSyncKHR *>calloc(1, sizeof(ccuda.EGLSyncKHR))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.EGLSyncKHR)))
            self._ptr[0] = <ccuda.EGLSyncKHR>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.EGLSyncKHR *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<EGLSyncKHR ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUeglStreamConnection:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUeglStreamConnection *>calloc(1, sizeof(ccuda.CUeglStreamConnection))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUeglStreamConnection)))
            self._ptr[0] = <ccuda.CUeglStreamConnection>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUeglStreamConnection *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUeglStreamConnection ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUhostFn:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUhostFn *>calloc(1, sizeof(ccuda.CUhostFn))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUhostFn)))
            self._ptr[0] = <ccuda.CUhostFn>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUhostFn *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUhostFn ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUstreamCallback:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstreamCallback *>calloc(1, sizeof(ccuda.CUstreamCallback))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstreamCallback)))
            self._ptr[0] = <ccuda.CUstreamCallback>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstreamCallback *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUstreamCallback ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUoccupancyB2DSize:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUoccupancyB2DSize *>calloc(1, sizeof(ccuda.CUoccupancyB2DSize))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUoccupancyB2DSize)))
            self._ptr[0] = <ccuda.CUoccupancyB2DSize>init_value
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUoccupancyB2DSize *>_ptr
    def __init__(self, *args, **kwargs):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUoccupancyB2DSize ' + str(hex(self.__int__())) + '>'
    def __index__(self):
        return self.__int__()
    def __int__(self):
        return <void_ptr>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUuuid_st:
    """

    Attributes
    ----------
    bytes : bytes
        < CUDA definition of UUID

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUuuid_st *>calloc(1, sizeof(ccuda.CUuuid_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUuuid_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUuuid_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['bytes : ' + str(self.bytes.hex())]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def bytes(self):
        return PyBytes_FromStringAndSize(self._ptr[0].bytes, 16)

cdef class CUipcEventHandle_st:
    """
    CUDA IPC event handle

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUipcEventHandle_st *>calloc(1, sizeof(ccuda.CUipcEventHandle_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUipcEventHandle_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUipcEventHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            if b > 127 and b < 256:
                b = b - 256
            self._ptr[0].reserved[i] = b

cdef class CUipcMemHandle_st:
    """
    CUDA IPC mem handle

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUipcMemHandle_st *>calloc(1, sizeof(ccuda.CUipcMemHandle_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUipcMemHandle_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUipcMemHandle_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(self._ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            if b > 127 and b < 256:
                b = b - 256
            self._ptr[0].reserved[i] = b

cdef class CUstreamMemOpWaitValueParams_st:
    """

    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    address : CUdeviceptr

    flags : unsigned int

    value64 : cuuint64_t

    alias : CUdeviceptr
        For driver internal use. Initial value is unimportant.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstreamMemOpWaitValueParams_st *>calloc(1, sizeof(ccuda.CUstreamMemOpWaitValueParams_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstreamMemOpWaitValueParams_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstreamMemOpWaitValueParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._address = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].address)
        self._value64 = cuuint64_t(_ptr=<void_ptr>&self._ptr[0].value64)
        self._alias = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].alias)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['operation : ' + str(self.operation)]
            str_list += ['address : ' + str(self.address)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['value64 : ' + str(self.value64)]
            str_list += ['alias : ' + str(self.alias)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def operation(self):
        return CUstreamBatchMemOpType(self._ptr[0].operation)
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        pass
        self._ptr[0].operation = operation.value
    @property
    def address(self):
        return self._address
    @address.setter
    def address(self, address):
        cdef ccuda.CUdeviceptr caddress
        if address is None:
            caddress = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(address, (CUdeviceptr)):
            paddress = int(address)
            caddress = <ccuda.CUdeviceptr><void_ptr>paddress
        else:
            paddress = int(CUdeviceptr(address))
            caddress = <ccuda.CUdeviceptr><void_ptr>paddress
        self._address._ptr[0] = caddress
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def value64(self):
        return self._value64
    @value64.setter
    def value64(self, value64):
        cdef ccuda.cuuint64_t cvalue64
        if value64 is None:
            cvalue64 = <ccuda.cuuint64_t><void_ptr>0
        elif isinstance(value64, (cuuint64_t)):
            pvalue64 = int(value64)
            cvalue64 = <ccuda.cuuint64_t><void_ptr>pvalue64
        else:
            pvalue64 = int(cuuint64_t(value64))
            cvalue64 = <ccuda.cuuint64_t><void_ptr>pvalue64
        self._value64._ptr[0] = cvalue64
    @property
    def alias(self):
        return self._alias
    @alias.setter
    def alias(self, alias):
        cdef ccuda.CUdeviceptr calias
        if alias is None:
            calias = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(alias, (CUdeviceptr)):
            palias = int(alias)
            calias = <ccuda.CUdeviceptr><void_ptr>palias
        else:
            palias = int(CUdeviceptr(alias))
            calias = <ccuda.CUdeviceptr><void_ptr>palias
        self._alias._ptr[0] = calias

cdef class CUstreamMemOpWriteValueParams_st:
    """

    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    address : CUdeviceptr

    flags : unsigned int

    value64 : cuuint64_t

    alias : CUdeviceptr
        For driver internal use. Initial value is unimportant.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstreamMemOpWriteValueParams_st *>calloc(1, sizeof(ccuda.CUstreamMemOpWriteValueParams_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstreamMemOpWriteValueParams_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstreamMemOpWriteValueParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._address = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].address)
        self._value64 = cuuint64_t(_ptr=<void_ptr>&self._ptr[0].value64)
        self._alias = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].alias)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['operation : ' + str(self.operation)]
            str_list += ['address : ' + str(self.address)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['value64 : ' + str(self.value64)]
            str_list += ['alias : ' + str(self.alias)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def operation(self):
        return CUstreamBatchMemOpType(self._ptr[0].operation)
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        pass
        self._ptr[0].operation = operation.value
    @property
    def address(self):
        return self._address
    @address.setter
    def address(self, address):
        cdef ccuda.CUdeviceptr caddress
        if address is None:
            caddress = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(address, (CUdeviceptr)):
            paddress = int(address)
            caddress = <ccuda.CUdeviceptr><void_ptr>paddress
        else:
            paddress = int(CUdeviceptr(address))
            caddress = <ccuda.CUdeviceptr><void_ptr>paddress
        self._address._ptr[0] = caddress
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def value64(self):
        return self._value64
    @value64.setter
    def value64(self, value64):
        cdef ccuda.cuuint64_t cvalue64
        if value64 is None:
            cvalue64 = <ccuda.cuuint64_t><void_ptr>0
        elif isinstance(value64, (cuuint64_t)):
            pvalue64 = int(value64)
            cvalue64 = <ccuda.cuuint64_t><void_ptr>pvalue64
        else:
            pvalue64 = int(cuuint64_t(value64))
            cvalue64 = <ccuda.cuuint64_t><void_ptr>pvalue64
        self._value64._ptr[0] = cvalue64
    @property
    def alias(self):
        return self._alias
    @alias.setter
    def alias(self, alias):
        cdef ccuda.CUdeviceptr calias
        if alias is None:
            calias = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(alias, (CUdeviceptr)):
            palias = int(alias)
            calias = <ccuda.CUdeviceptr><void_ptr>palias
        else:
            palias = int(CUdeviceptr(alias))
            calias = <ccuda.CUdeviceptr><void_ptr>palias
        self._alias._ptr[0] = calias

cdef class CUstreamMemOpFlushRemoteWritesParams_st:
    """

    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    flags : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstreamMemOpFlushRemoteWritesParams_st *>calloc(1, sizeof(ccuda.CUstreamMemOpFlushRemoteWritesParams_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstreamMemOpFlushRemoteWritesParams_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstreamMemOpFlushRemoteWritesParams_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['operation : ' + str(self.operation)]
            str_list += ['flags : ' + str(self.flags)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def operation(self):
        return CUstreamBatchMemOpType(self._ptr[0].operation)
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        pass
        self._ptr[0].operation = operation.value
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags

cdef class CUstreamBatchMemOpParams_union:
    """

    Attributes
    ----------
    operation : CUstreamBatchMemOpType

    waitValue : CUstreamMemOpWaitValueParams_st

    writeValue : CUstreamMemOpWriteValueParams_st

    flushRemoteWrites : CUstreamMemOpFlushRemoteWritesParams_st

    pad : List[cuuint64_t]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstreamBatchMemOpParams_union *>calloc(1, sizeof(ccuda.CUstreamBatchMemOpParams_union))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstreamBatchMemOpParams_union)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstreamBatchMemOpParams_union *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._waitValue = CUstreamMemOpWaitValueParams_st(_ptr=<void_ptr>&self._ptr[0].waitValue)
        self._writeValue = CUstreamMemOpWriteValueParams_st(_ptr=<void_ptr>&self._ptr[0].writeValue)
        self._flushRemoteWrites = CUstreamMemOpFlushRemoteWritesParams_st(_ptr=<void_ptr>&self._ptr[0].flushRemoteWrites)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['operation : ' + str(self.operation)]
            str_list += ['waitValue :\n' + '\n'.join(['    ' + line for line in str(self.waitValue).splitlines()])]
            str_list += ['writeValue :\n' + '\n'.join(['    ' + line for line in str(self.writeValue).splitlines()])]
            str_list += ['flushRemoteWrites :\n' + '\n'.join(['    ' + line for line in str(self.flushRemoteWrites).splitlines()])]
            str_list += ['pad : ' + str(self.pad)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def operation(self):
        return CUstreamBatchMemOpType(self._ptr[0].operation)
    @operation.setter
    def operation(self, operation not None : CUstreamBatchMemOpType):
        pass
        self._ptr[0].operation = operation.value
    @property
    def waitValue(self):
        return self._waitValue
    @waitValue.setter
    def waitValue(self, waitValue not None : CUstreamMemOpWaitValueParams_st):
        pass
        for _attr in dir(waitValue):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._waitValue, _attr, getattr(waitValue, _attr))
    @property
    def writeValue(self):
        return self._writeValue
    @writeValue.setter
    def writeValue(self, writeValue not None : CUstreamMemOpWriteValueParams_st):
        pass
        for _attr in dir(writeValue):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._writeValue, _attr, getattr(writeValue, _attr))
    @property
    def flushRemoteWrites(self):
        return self._flushRemoteWrites
    @flushRemoteWrites.setter
    def flushRemoteWrites(self, flushRemoteWrites not None : CUstreamMemOpFlushRemoteWritesParams_st):
        pass
        for _attr in dir(flushRemoteWrites):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._flushRemoteWrites, _attr, getattr(flushRemoteWrites, _attr))
    @property
    def pad(self):
        return [cuuint64_t(init_value=_pad) for _pad in self._ptr[0].pad]
    @pad.setter
    def pad(self, pad):
        pass
        self._ptr[0].pad = pad

cdef class CUdevprop_st:
    """
    Legacy device properties

    Attributes
    ----------
    maxThreadsPerBlock : int
        Maximum number of threads per block
    maxThreadsDim : List[int]
        Maximum size of each dimension of a block
    maxGridSize : List[int]
        Maximum size of each dimension of a grid
    sharedMemPerBlock : int
        Shared memory available per block in bytes
    totalConstantMemory : int
        Constant memory available on device in bytes
    SIMDWidth : int
        Warp size in threads
    memPitch : int
        Maximum pitch in bytes allowed by memory copies
    regsPerBlock : int
        32-bit registers available per block
    clockRate : int
        Clock frequency in kilohertz
    textureAlign : int
        Alignment requirement for textures

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUdevprop_st *>calloc(1, sizeof(ccuda.CUdevprop_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUdevprop_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUdevprop_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['maxThreadsPerBlock : ' + str(self.maxThreadsPerBlock)]
            str_list += ['maxThreadsDim : ' + str(self.maxThreadsDim)]
            str_list += ['maxGridSize : ' + str(self.maxGridSize)]
            str_list += ['sharedMemPerBlock : ' + str(self.sharedMemPerBlock)]
            str_list += ['totalConstantMemory : ' + str(self.totalConstantMemory)]
            str_list += ['SIMDWidth : ' + str(self.SIMDWidth)]
            str_list += ['memPitch : ' + str(self.memPitch)]
            str_list += ['regsPerBlock : ' + str(self.regsPerBlock)]
            str_list += ['clockRate : ' + str(self.clockRate)]
            str_list += ['textureAlign : ' + str(self.textureAlign)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def maxThreadsPerBlock(self):
        return self._ptr[0].maxThreadsPerBlock
    @maxThreadsPerBlock.setter
    def maxThreadsPerBlock(self, int maxThreadsPerBlock):
        pass
        self._ptr[0].maxThreadsPerBlock = maxThreadsPerBlock
    @property
    def maxThreadsDim(self):
        return self._ptr[0].maxThreadsDim
    @maxThreadsDim.setter
    def maxThreadsDim(self, maxThreadsDim):
        pass
        self._ptr[0].maxThreadsDim = maxThreadsDim
    @property
    def maxGridSize(self):
        return self._ptr[0].maxGridSize
    @maxGridSize.setter
    def maxGridSize(self, maxGridSize):
        pass
        self._ptr[0].maxGridSize = maxGridSize
    @property
    def sharedMemPerBlock(self):
        return self._ptr[0].sharedMemPerBlock
    @sharedMemPerBlock.setter
    def sharedMemPerBlock(self, int sharedMemPerBlock):
        pass
        self._ptr[0].sharedMemPerBlock = sharedMemPerBlock
    @property
    def totalConstantMemory(self):
        return self._ptr[0].totalConstantMemory
    @totalConstantMemory.setter
    def totalConstantMemory(self, int totalConstantMemory):
        pass
        self._ptr[0].totalConstantMemory = totalConstantMemory
    @property
    def SIMDWidth(self):
        return self._ptr[0].SIMDWidth
    @SIMDWidth.setter
    def SIMDWidth(self, int SIMDWidth):
        pass
        self._ptr[0].SIMDWidth = SIMDWidth
    @property
    def memPitch(self):
        return self._ptr[0].memPitch
    @memPitch.setter
    def memPitch(self, int memPitch):
        pass
        self._ptr[0].memPitch = memPitch
    @property
    def regsPerBlock(self):
        return self._ptr[0].regsPerBlock
    @regsPerBlock.setter
    def regsPerBlock(self, int regsPerBlock):
        pass
        self._ptr[0].regsPerBlock = regsPerBlock
    @property
    def clockRate(self):
        return self._ptr[0].clockRate
    @clockRate.setter
    def clockRate(self, int clockRate):
        pass
        self._ptr[0].clockRate = clockRate
    @property
    def textureAlign(self):
        return self._ptr[0].textureAlign
    @textureAlign.setter
    def textureAlign(self, int textureAlign):
        pass
        self._ptr[0].textureAlign = textureAlign

cdef class CUaccessPolicyWindow_st:
    """
    Specifies an access policy for a window, a contiguous extent of
    memory beginning at base_ptr and ending at base_ptr + num_bytes.
    num_bytes is limited by
    CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE. Partition into
    many segments and assign segments such that: sum of "hit segments"
    / window == approx. ratio. sum of "miss segments" / window ==
    approx 1-ratio. Segments and ratio specifications are fitted to the
    capabilities of the architecture. Accesses in a hit segment apply
    the hitProp access policy. Accesses in a miss segment apply the
    missProp access policy.

    Attributes
    ----------
    base_ptr : Any
        Starting address of the access policy window. CUDA driver may align
        it.
    num_bytes : size_t
        Size in bytes of the window policy. CUDA driver may restrict the
        maximum size and alignment.
    hitRatio : float
        hitRatio specifies percentage of lines assigned hitProp, rest are
        assigned missProp.
    hitProp : CUaccessProperty
        CUaccessProperty set for hit.
    missProp : CUaccessProperty
        CUaccessProperty set for miss. Must be either NORMAL or STREAMING

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUaccessPolicyWindow_st *>calloc(1, sizeof(ccuda.CUaccessPolicyWindow_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUaccessPolicyWindow_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUaccessPolicyWindow_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['base_ptr : ' + hex(self.base_ptr)]
            str_list += ['num_bytes : ' + str(self.num_bytes)]
            str_list += ['hitRatio : ' + str(self.hitRatio)]
            str_list += ['hitProp : ' + str(self.hitProp)]
            str_list += ['missProp : ' + str(self.missProp)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def base_ptr(self):
        return <void_ptr>self._ptr[0].base_ptr
    @base_ptr.setter
    def base_ptr(self, base_ptr):
        _cbase_ptr = utils.HelperInputVoidPtr(base_ptr)
        self._ptr[0].base_ptr = <void*><void_ptr>_cbase_ptr.cptr
    @property
    def num_bytes(self):
        return self._ptr[0].num_bytes
    @num_bytes.setter
    def num_bytes(self, size_t num_bytes):
        pass
        self._ptr[0].num_bytes = num_bytes
    @property
    def hitRatio(self):
        return self._ptr[0].hitRatio
    @hitRatio.setter
    def hitRatio(self, float hitRatio):
        pass
        self._ptr[0].hitRatio = hitRatio
    @property
    def hitProp(self):
        return CUaccessProperty(self._ptr[0].hitProp)
    @hitProp.setter
    def hitProp(self, hitProp not None : CUaccessProperty):
        pass
        self._ptr[0].hitProp = hitProp.value
    @property
    def missProp(self):
        return CUaccessProperty(self._ptr[0].missProp)
    @missProp.setter
    def missProp(self, missProp not None : CUaccessProperty):
        pass
        self._ptr[0].missProp = missProp.value

cdef class CUDA_KERNEL_NODE_PARAMS_st:
    """
    GPU kernel node parameters

    Attributes
    ----------
    func : CUfunction
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    kernelParams : Any
        Array of pointers to kernel parameters
    extra : Any
        Extra options

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_KERNEL_NODE_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_KERNEL_NODE_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_KERNEL_NODE_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_KERNEL_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._func = CUfunction(_ptr=<void_ptr>&self._ptr[0].func)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['func : ' + str(self.func)]
            str_list += ['gridDimX : ' + str(self.gridDimX)]
            str_list += ['gridDimY : ' + str(self.gridDimY)]
            str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            str_list += ['blockDimX : ' + str(self.blockDimX)]
            str_list += ['blockDimY : ' + str(self.blockDimY)]
            str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            str_list += ['kernelParams : ' + str(self.kernelParams)]
            str_list += ['extra : ' + str(self.extra)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def func(self):
        return self._func
    @func.setter
    def func(self, func):
        cdef ccuda.CUfunction cfunc
        if func is None:
            cfunc = <ccuda.CUfunction><void_ptr>0
        elif isinstance(func, (CUfunction)):
            pfunc = int(func)
            cfunc = <ccuda.CUfunction><void_ptr>pfunc
        else:
            pfunc = int(CUfunction(func))
            cfunc = <ccuda.CUfunction><void_ptr>pfunc
        self._func._ptr[0] = cfunc
    @property
    def gridDimX(self):
        return self._ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        pass
        self._ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        pass
        self._ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        pass
        self._ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        pass
        self._ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        pass
        self._ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        pass
        self._ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        pass
        self._ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def kernelParams(self):
        return <void_ptr>self._ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._ckernelParams = utils.HelperKernelParams(kernelParams)
        self._ptr[0].kernelParams = <void**><void_ptr>self._ckernelParams.ckernelParams
    @property
    def extra(self):
        return <void_ptr>self._ptr[0].extra
    @extra.setter
    def extra(self, void_ptr extra):
        self._ptr[0].extra = <void**>extra

cdef class CUDA_MEMSET_NODE_PARAMS_st:
    """
    Memset node parameters

    Attributes
    ----------
    dst : CUdeviceptr
        Destination device pointer
    pitch : size_t
        Pitch of destination device pointer. Unused if height is 1
    value : unsigned int
        Value to be set
    elementSize : unsigned int
        Size of each element in bytes. Must be 1, 2, or 4.
    width : size_t
        Width of the row in elements
    height : size_t
        Number of rows

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_MEMSET_NODE_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_MEMSET_NODE_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_MEMSET_NODE_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_MEMSET_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._dst = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].dst)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['dst : ' + str(self.dst)]
            str_list += ['pitch : ' + str(self.pitch)]
            str_list += ['value : ' + str(self.value)]
            str_list += ['elementSize : ' + str(self.elementSize)]
            str_list += ['width : ' + str(self.width)]
            str_list += ['height : ' + str(self.height)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def dst(self):
        return self._dst
    @dst.setter
    def dst(self, dst):
        cdef ccuda.CUdeviceptr cdst
        if dst is None:
            cdst = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(dst, (CUdeviceptr)):
            pdst = int(dst)
            cdst = <ccuda.CUdeviceptr><void_ptr>pdst
        else:
            pdst = int(CUdeviceptr(dst))
            cdst = <ccuda.CUdeviceptr><void_ptr>pdst
        self._dst._ptr[0] = cdst
    @property
    def pitch(self):
        return self._ptr[0].pitch
    @pitch.setter
    def pitch(self, size_t pitch):
        pass
        self._ptr[0].pitch = pitch
    @property
    def value(self):
        return self._ptr[0].value
    @value.setter
    def value(self, unsigned int value):
        pass
        self._ptr[0].value = value
    @property
    def elementSize(self):
        return self._ptr[0].elementSize
    @elementSize.setter
    def elementSize(self, unsigned int elementSize):
        pass
        self._ptr[0].elementSize = elementSize
    @property
    def width(self):
        return self._ptr[0].width
    @width.setter
    def width(self, size_t width):
        pass
        self._ptr[0].width = width
    @property
    def height(self):
        return self._ptr[0].height
    @height.setter
    def height(self, size_t height):
        pass
        self._ptr[0].height = height

cdef class CUDA_HOST_NODE_PARAMS_st:
    """
    Host node parameters

    Attributes
    ----------
    fn : CUhostFn
        The function to call when the node executes
    userData : Any
        Argument to pass to the function

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_HOST_NODE_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_HOST_NODE_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_HOST_NODE_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_HOST_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._fn = CUhostFn(_ptr=<void_ptr>&self._ptr[0].fn)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fn : ' + str(self.fn)]
            str_list += ['userData : ' + hex(self.userData)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fn(self):
        return self._fn
    @fn.setter
    def fn(self, fn):
        cdef ccuda.CUhostFn cfn
        if fn is None:
            cfn = <ccuda.CUhostFn><void_ptr>0
        elif isinstance(fn, (CUhostFn)):
            pfn = int(fn)
            cfn = <ccuda.CUhostFn><void_ptr>pfn
        else:
            pfn = int(CUhostFn(fn))
            cfn = <ccuda.CUhostFn><void_ptr>pfn
        self._fn._ptr[0] = cfn
    @property
    def userData(self):
        return <void_ptr>self._ptr[0].userData
    @userData.setter
    def userData(self, userData):
        _cuserData = utils.HelperInputVoidPtr(userData)
        self._ptr[0].userData = <void*><void_ptr>_cuserData.cptr

cdef class CUkernelNodeAttrValue_union:
    """

    Attributes
    ----------
    accessPolicyWindow : CUaccessPolicyWindow

    cooperative : int


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUkernelNodeAttrValue_union *>calloc(1, sizeof(ccuda.CUkernelNodeAttrValue_union))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUkernelNodeAttrValue_union)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUkernelNodeAttrValue_union *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._accessPolicyWindow = CUaccessPolicyWindow(_ptr=<void_ptr>&self._ptr[0].accessPolicyWindow)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['accessPolicyWindow :\n' + '\n'.join(['    ' + line for line in str(self.accessPolicyWindow).splitlines()])]
            str_list += ['cooperative : ' + str(self.cooperative)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def accessPolicyWindow(self):
        return self._accessPolicyWindow
    @accessPolicyWindow.setter
    def accessPolicyWindow(self, accessPolicyWindow not None : CUaccessPolicyWindow):
        pass
        for _attr in dir(accessPolicyWindow):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._accessPolicyWindow, _attr, getattr(accessPolicyWindow, _attr))
    @property
    def cooperative(self):
        return self._ptr[0].cooperative
    @cooperative.setter
    def cooperative(self, int cooperative):
        pass
        self._ptr[0].cooperative = cooperative

cdef class CUstreamAttrValue_union:
    """

    Attributes
    ----------
    accessPolicyWindow : CUaccessPolicyWindow

    syncPolicy : CUsynchronizationPolicy


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUstreamAttrValue_union *>calloc(1, sizeof(ccuda.CUstreamAttrValue_union))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUstreamAttrValue_union)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUstreamAttrValue_union *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._accessPolicyWindow = CUaccessPolicyWindow(_ptr=<void_ptr>&self._ptr[0].accessPolicyWindow)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['accessPolicyWindow :\n' + '\n'.join(['    ' + line for line in str(self.accessPolicyWindow).splitlines()])]
            str_list += ['syncPolicy : ' + str(self.syncPolicy)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def accessPolicyWindow(self):
        return self._accessPolicyWindow
    @accessPolicyWindow.setter
    def accessPolicyWindow(self, accessPolicyWindow not None : CUaccessPolicyWindow):
        pass
        for _attr in dir(accessPolicyWindow):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._accessPolicyWindow, _attr, getattr(accessPolicyWindow, _attr))
    @property
    def syncPolicy(self):
        return CUsynchronizationPolicy(self._ptr[0].syncPolicy)
    @syncPolicy.setter
    def syncPolicy(self, syncPolicy not None : CUsynchronizationPolicy):
        pass
        self._ptr[0].syncPolicy = syncPolicy.value

cdef class CUexecAffinitySmCount_st:
    """
    Value for CU_EXEC_AFFINITY_TYPE_SM_COUNT

    Attributes
    ----------
    val : unsigned int
        The number of SMs the context is limited to use.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUexecAffinitySmCount_st *>calloc(1, sizeof(ccuda.CUexecAffinitySmCount_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUexecAffinitySmCount_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUexecAffinitySmCount_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['val : ' + str(self.val)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def val(self):
        return self._ptr[0].val
    @val.setter
    def val(self, unsigned int val):
        pass
        self._ptr[0].val = val

cdef class _CUexecAffinityParam_v1_CUexecAffinityParam_v1_CUexecAffinityParam_st_param_u:
    """

    Attributes
    ----------
    smCount : CUexecAffinitySmCount


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUexecAffinityParam_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._smCount = CUexecAffinitySmCount(_ptr=<void_ptr>&self._ptr[0].param.smCount)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['smCount :\n' + '\n'.join(['    ' + line for line in str(self.smCount).splitlines()])]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def smCount(self):
        return self._smCount
    @smCount.setter
    def smCount(self, smCount not None : CUexecAffinitySmCount):
        pass
        for _attr in dir(smCount):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._smCount, _attr, getattr(smCount, _attr))

cdef class CUexecAffinityParam_st:
    """
    Execution Affinity Parameters

    Attributes
    ----------
    type : CUexecAffinityType

    param : _CUexecAffinityParam_v1_CUexecAffinityParam_v1_CUexecAffinityParam_st_param_u


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUexecAffinityParam_st *>calloc(1, sizeof(ccuda.CUexecAffinityParam_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUexecAffinityParam_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUexecAffinityParam_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._param = _CUexecAffinityParam_v1_CUexecAffinityParam_v1_CUexecAffinityParam_st_param_u(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['type : ' + str(self.type)]
            str_list += ['param :\n' + '\n'.join(['    ' + line for line in str(self.param).splitlines()])]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def type(self):
        return CUexecAffinityType(self._ptr[0].type)
    @type.setter
    def type(self, type not None : CUexecAffinityType):
        pass
        self._ptr[0].type = type.value
    @property
    def param(self):
        return self._param
    @param.setter
    def param(self, param not None : _CUexecAffinityParam_v1_CUexecAffinityParam_v1_CUexecAffinityParam_st_param_u):
        pass
        for _attr in dir(param):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._param, _attr, getattr(param, _attr))

cdef class CUDA_MEMCPY2D_st:
    """
    2D memory copy parameters

    Attributes
    ----------
    srcXInBytes : size_t
        Source X in bytes
    srcY : size_t
        Source Y
    srcMemoryType : CUmemorytype
        Source memory type (host, device, array)
    srcHost : Any
        Source host pointer
    srcDevice : CUdeviceptr
        Source device pointer
    srcArray : CUarray
        Source array reference
    srcPitch : size_t
        Source pitch (ignored when src is array)
    dstXInBytes : size_t
        Destination X in bytes
    dstY : size_t
        Destination Y
    dstMemoryType : CUmemorytype
        Destination memory type (host, device, array)
    dstHost : Any
        Destination host pointer
    dstDevice : CUdeviceptr
        Destination device pointer
    dstArray : CUarray
        Destination array reference
    dstPitch : size_t
        Destination pitch (ignored when dst is array)
    WidthInBytes : size_t
        Width of 2D memory copy in bytes
    Height : size_t
        Height of 2D memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_MEMCPY2D_st *>calloc(1, sizeof(ccuda.CUDA_MEMCPY2D_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_MEMCPY2D_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_MEMCPY2D_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._srcDevice = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].srcDevice)
        self._srcArray = CUarray(_ptr=<void_ptr>&self._ptr[0].srcArray)
        self._dstDevice = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].dstDevice)
        self._dstArray = CUarray(_ptr=<void_ptr>&self._ptr[0].dstArray)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['srcXInBytes : ' + str(self.srcXInBytes)]
            str_list += ['srcY : ' + str(self.srcY)]
            str_list += ['srcMemoryType : ' + str(self.srcMemoryType)]
            str_list += ['srcHost : ' + hex(self.srcHost)]
            str_list += ['srcDevice : ' + str(self.srcDevice)]
            str_list += ['srcArray : ' + str(self.srcArray)]
            str_list += ['srcPitch : ' + str(self.srcPitch)]
            str_list += ['dstXInBytes : ' + str(self.dstXInBytes)]
            str_list += ['dstY : ' + str(self.dstY)]
            str_list += ['dstMemoryType : ' + str(self.dstMemoryType)]
            str_list += ['dstHost : ' + hex(self.dstHost)]
            str_list += ['dstDevice : ' + str(self.dstDevice)]
            str_list += ['dstArray : ' + str(self.dstArray)]
            str_list += ['dstPitch : ' + str(self.dstPitch)]
            str_list += ['WidthInBytes : ' + str(self.WidthInBytes)]
            str_list += ['Height : ' + str(self.Height)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def srcXInBytes(self):
        return self._ptr[0].srcXInBytes
    @srcXInBytes.setter
    def srcXInBytes(self, size_t srcXInBytes):
        pass
        self._ptr[0].srcXInBytes = srcXInBytes
    @property
    def srcY(self):
        return self._ptr[0].srcY
    @srcY.setter
    def srcY(self, size_t srcY):
        pass
        self._ptr[0].srcY = srcY
    @property
    def srcMemoryType(self):
        return CUmemorytype(self._ptr[0].srcMemoryType)
    @srcMemoryType.setter
    def srcMemoryType(self, srcMemoryType not None : CUmemorytype):
        pass
        self._ptr[0].srcMemoryType = srcMemoryType.value
    @property
    def srcHost(self):
        return <void_ptr>self._ptr[0].srcHost
    @srcHost.setter
    def srcHost(self, srcHost):
        _csrcHost = utils.HelperInputVoidPtr(srcHost)
        self._ptr[0].srcHost = <void*><void_ptr>_csrcHost.cptr
    @property
    def srcDevice(self):
        return self._srcDevice
    @srcDevice.setter
    def srcDevice(self, srcDevice):
        cdef ccuda.CUdeviceptr csrcDevice
        if srcDevice is None:
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(srcDevice, (CUdeviceptr)):
            psrcDevice = int(srcDevice)
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
        else:
            psrcDevice = int(CUdeviceptr(srcDevice))
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
        self._srcDevice._ptr[0] = csrcDevice
    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef ccuda.CUarray csrcArray
        if srcArray is None:
            csrcArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(srcArray, (CUarray)):
            psrcArray = int(srcArray)
            csrcArray = <ccuda.CUarray><void_ptr>psrcArray
        else:
            psrcArray = int(CUarray(srcArray))
            csrcArray = <ccuda.CUarray><void_ptr>psrcArray
        self._srcArray._ptr[0] = csrcArray
    @property
    def srcPitch(self):
        return self._ptr[0].srcPitch
    @srcPitch.setter
    def srcPitch(self, size_t srcPitch):
        pass
        self._ptr[0].srcPitch = srcPitch
    @property
    def dstXInBytes(self):
        return self._ptr[0].dstXInBytes
    @dstXInBytes.setter
    def dstXInBytes(self, size_t dstXInBytes):
        pass
        self._ptr[0].dstXInBytes = dstXInBytes
    @property
    def dstY(self):
        return self._ptr[0].dstY
    @dstY.setter
    def dstY(self, size_t dstY):
        pass
        self._ptr[0].dstY = dstY
    @property
    def dstMemoryType(self):
        return CUmemorytype(self._ptr[0].dstMemoryType)
    @dstMemoryType.setter
    def dstMemoryType(self, dstMemoryType not None : CUmemorytype):
        pass
        self._ptr[0].dstMemoryType = dstMemoryType.value
    @property
    def dstHost(self):
        return <void_ptr>self._ptr[0].dstHost
    @dstHost.setter
    def dstHost(self, dstHost):
        _cdstHost = utils.HelperInputVoidPtr(dstHost)
        self._ptr[0].dstHost = <void*><void_ptr>_cdstHost.cptr
    @property
    def dstDevice(self):
        return self._dstDevice
    @dstDevice.setter
    def dstDevice(self, dstDevice):
        cdef ccuda.CUdeviceptr cdstDevice
        if dstDevice is None:
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(dstDevice, (CUdeviceptr)):
            pdstDevice = int(dstDevice)
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
        else:
            pdstDevice = int(CUdeviceptr(dstDevice))
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
        self._dstDevice._ptr[0] = cdstDevice
    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef ccuda.CUarray cdstArray
        if dstArray is None:
            cdstArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(dstArray, (CUarray)):
            pdstArray = int(dstArray)
            cdstArray = <ccuda.CUarray><void_ptr>pdstArray
        else:
            pdstArray = int(CUarray(dstArray))
            cdstArray = <ccuda.CUarray><void_ptr>pdstArray
        self._dstArray._ptr[0] = cdstArray
    @property
    def dstPitch(self):
        return self._ptr[0].dstPitch
    @dstPitch.setter
    def dstPitch(self, size_t dstPitch):
        pass
        self._ptr[0].dstPitch = dstPitch
    @property
    def WidthInBytes(self):
        return self._ptr[0].WidthInBytes
    @WidthInBytes.setter
    def WidthInBytes(self, size_t WidthInBytes):
        pass
        self._ptr[0].WidthInBytes = WidthInBytes
    @property
    def Height(self):
        return self._ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        pass
        self._ptr[0].Height = Height

cdef class CUDA_MEMCPY3D_st:
    """
    3D memory copy parameters

    Attributes
    ----------
    srcXInBytes : size_t
        Source X in bytes
    srcY : size_t
        Source Y
    srcZ : size_t
        Source Z
    srcLOD : size_t
        Source LOD
    srcMemoryType : CUmemorytype
        Source memory type (host, device, array)
    srcHost : Any
        Source host pointer
    srcDevice : CUdeviceptr
        Source device pointer
    srcArray : CUarray
        Source array reference
    reserved0 : Any
        Must be NULL
    srcPitch : size_t
        Source pitch (ignored when src is array)
    srcHeight : size_t
        Source height (ignored when src is array; may be 0 if Depth==1)
    dstXInBytes : size_t
        Destination X in bytes
    dstY : size_t
        Destination Y
    dstZ : size_t
        Destination Z
    dstLOD : size_t
        Destination LOD
    dstMemoryType : CUmemorytype
        Destination memory type (host, device, array)
    dstHost : Any
        Destination host pointer
    dstDevice : CUdeviceptr
        Destination device pointer
    dstArray : CUarray
        Destination array reference
    reserved1 : Any
        Must be NULL
    dstPitch : size_t
        Destination pitch (ignored when dst is array)
    dstHeight : size_t
        Destination height (ignored when dst is array; may be 0 if
        Depth==1)
    WidthInBytes : size_t
        Width of 3D memory copy in bytes
    Height : size_t
        Height of 3D memory copy
    Depth : size_t
        Depth of 3D memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_MEMCPY3D_st *>calloc(1, sizeof(ccuda.CUDA_MEMCPY3D_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_MEMCPY3D_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_MEMCPY3D_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._srcDevice = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].srcDevice)
        self._srcArray = CUarray(_ptr=<void_ptr>&self._ptr[0].srcArray)
        self._dstDevice = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].dstDevice)
        self._dstArray = CUarray(_ptr=<void_ptr>&self._ptr[0].dstArray)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['srcXInBytes : ' + str(self.srcXInBytes)]
            str_list += ['srcY : ' + str(self.srcY)]
            str_list += ['srcZ : ' + str(self.srcZ)]
            str_list += ['srcLOD : ' + str(self.srcLOD)]
            str_list += ['srcMemoryType : ' + str(self.srcMemoryType)]
            str_list += ['srcHost : ' + hex(self.srcHost)]
            str_list += ['srcDevice : ' + str(self.srcDevice)]
            str_list += ['srcArray : ' + str(self.srcArray)]
            str_list += ['reserved0 : ' + hex(self.reserved0)]
            str_list += ['srcPitch : ' + str(self.srcPitch)]
            str_list += ['srcHeight : ' + str(self.srcHeight)]
            str_list += ['dstXInBytes : ' + str(self.dstXInBytes)]
            str_list += ['dstY : ' + str(self.dstY)]
            str_list += ['dstZ : ' + str(self.dstZ)]
            str_list += ['dstLOD : ' + str(self.dstLOD)]
            str_list += ['dstMemoryType : ' + str(self.dstMemoryType)]
            str_list += ['dstHost : ' + hex(self.dstHost)]
            str_list += ['dstDevice : ' + str(self.dstDevice)]
            str_list += ['dstArray : ' + str(self.dstArray)]
            str_list += ['reserved1 : ' + hex(self.reserved1)]
            str_list += ['dstPitch : ' + str(self.dstPitch)]
            str_list += ['dstHeight : ' + str(self.dstHeight)]
            str_list += ['WidthInBytes : ' + str(self.WidthInBytes)]
            str_list += ['Height : ' + str(self.Height)]
            str_list += ['Depth : ' + str(self.Depth)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def srcXInBytes(self):
        return self._ptr[0].srcXInBytes
    @srcXInBytes.setter
    def srcXInBytes(self, size_t srcXInBytes):
        pass
        self._ptr[0].srcXInBytes = srcXInBytes
    @property
    def srcY(self):
        return self._ptr[0].srcY
    @srcY.setter
    def srcY(self, size_t srcY):
        pass
        self._ptr[0].srcY = srcY
    @property
    def srcZ(self):
        return self._ptr[0].srcZ
    @srcZ.setter
    def srcZ(self, size_t srcZ):
        pass
        self._ptr[0].srcZ = srcZ
    @property
    def srcLOD(self):
        return self._ptr[0].srcLOD
    @srcLOD.setter
    def srcLOD(self, size_t srcLOD):
        pass
        self._ptr[0].srcLOD = srcLOD
    @property
    def srcMemoryType(self):
        return CUmemorytype(self._ptr[0].srcMemoryType)
    @srcMemoryType.setter
    def srcMemoryType(self, srcMemoryType not None : CUmemorytype):
        pass
        self._ptr[0].srcMemoryType = srcMemoryType.value
    @property
    def srcHost(self):
        return <void_ptr>self._ptr[0].srcHost
    @srcHost.setter
    def srcHost(self, srcHost):
        _csrcHost = utils.HelperInputVoidPtr(srcHost)
        self._ptr[0].srcHost = <void*><void_ptr>_csrcHost.cptr
    @property
    def srcDevice(self):
        return self._srcDevice
    @srcDevice.setter
    def srcDevice(self, srcDevice):
        cdef ccuda.CUdeviceptr csrcDevice
        if srcDevice is None:
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(srcDevice, (CUdeviceptr)):
            psrcDevice = int(srcDevice)
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
        else:
            psrcDevice = int(CUdeviceptr(srcDevice))
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
        self._srcDevice._ptr[0] = csrcDevice
    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef ccuda.CUarray csrcArray
        if srcArray is None:
            csrcArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(srcArray, (CUarray)):
            psrcArray = int(srcArray)
            csrcArray = <ccuda.CUarray><void_ptr>psrcArray
        else:
            psrcArray = int(CUarray(srcArray))
            csrcArray = <ccuda.CUarray><void_ptr>psrcArray
        self._srcArray._ptr[0] = csrcArray
    @property
    def reserved0(self):
        return <void_ptr>self._ptr[0].reserved0
    @reserved0.setter
    def reserved0(self, reserved0):
        _creserved0 = utils.HelperInputVoidPtr(reserved0)
        self._ptr[0].reserved0 = <void*><void_ptr>_creserved0.cptr
    @property
    def srcPitch(self):
        return self._ptr[0].srcPitch
    @srcPitch.setter
    def srcPitch(self, size_t srcPitch):
        pass
        self._ptr[0].srcPitch = srcPitch
    @property
    def srcHeight(self):
        return self._ptr[0].srcHeight
    @srcHeight.setter
    def srcHeight(self, size_t srcHeight):
        pass
        self._ptr[0].srcHeight = srcHeight
    @property
    def dstXInBytes(self):
        return self._ptr[0].dstXInBytes
    @dstXInBytes.setter
    def dstXInBytes(self, size_t dstXInBytes):
        pass
        self._ptr[0].dstXInBytes = dstXInBytes
    @property
    def dstY(self):
        return self._ptr[0].dstY
    @dstY.setter
    def dstY(self, size_t dstY):
        pass
        self._ptr[0].dstY = dstY
    @property
    def dstZ(self):
        return self._ptr[0].dstZ
    @dstZ.setter
    def dstZ(self, size_t dstZ):
        pass
        self._ptr[0].dstZ = dstZ
    @property
    def dstLOD(self):
        return self._ptr[0].dstLOD
    @dstLOD.setter
    def dstLOD(self, size_t dstLOD):
        pass
        self._ptr[0].dstLOD = dstLOD
    @property
    def dstMemoryType(self):
        return CUmemorytype(self._ptr[0].dstMemoryType)
    @dstMemoryType.setter
    def dstMemoryType(self, dstMemoryType not None : CUmemorytype):
        pass
        self._ptr[0].dstMemoryType = dstMemoryType.value
    @property
    def dstHost(self):
        return <void_ptr>self._ptr[0].dstHost
    @dstHost.setter
    def dstHost(self, dstHost):
        _cdstHost = utils.HelperInputVoidPtr(dstHost)
        self._ptr[0].dstHost = <void*><void_ptr>_cdstHost.cptr
    @property
    def dstDevice(self):
        return self._dstDevice
    @dstDevice.setter
    def dstDevice(self, dstDevice):
        cdef ccuda.CUdeviceptr cdstDevice
        if dstDevice is None:
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(dstDevice, (CUdeviceptr)):
            pdstDevice = int(dstDevice)
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
        else:
            pdstDevice = int(CUdeviceptr(dstDevice))
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
        self._dstDevice._ptr[0] = cdstDevice
    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef ccuda.CUarray cdstArray
        if dstArray is None:
            cdstArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(dstArray, (CUarray)):
            pdstArray = int(dstArray)
            cdstArray = <ccuda.CUarray><void_ptr>pdstArray
        else:
            pdstArray = int(CUarray(dstArray))
            cdstArray = <ccuda.CUarray><void_ptr>pdstArray
        self._dstArray._ptr[0] = cdstArray
    @property
    def reserved1(self):
        return <void_ptr>self._ptr[0].reserved1
    @reserved1.setter
    def reserved1(self, reserved1):
        _creserved1 = utils.HelperInputVoidPtr(reserved1)
        self._ptr[0].reserved1 = <void*><void_ptr>_creserved1.cptr
    @property
    def dstPitch(self):
        return self._ptr[0].dstPitch
    @dstPitch.setter
    def dstPitch(self, size_t dstPitch):
        pass
        self._ptr[0].dstPitch = dstPitch
    @property
    def dstHeight(self):
        return self._ptr[0].dstHeight
    @dstHeight.setter
    def dstHeight(self, size_t dstHeight):
        pass
        self._ptr[0].dstHeight = dstHeight
    @property
    def WidthInBytes(self):
        return self._ptr[0].WidthInBytes
    @WidthInBytes.setter
    def WidthInBytes(self, size_t WidthInBytes):
        pass
        self._ptr[0].WidthInBytes = WidthInBytes
    @property
    def Height(self):
        return self._ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        pass
        self._ptr[0].Height = Height
    @property
    def Depth(self):
        return self._ptr[0].Depth
    @Depth.setter
    def Depth(self, size_t Depth):
        pass
        self._ptr[0].Depth = Depth

cdef class CUDA_MEMCPY3D_PEER_st:
    """
    3D memory cross-context copy parameters

    Attributes
    ----------
    srcXInBytes : size_t
        Source X in bytes
    srcY : size_t
        Source Y
    srcZ : size_t
        Source Z
    srcLOD : size_t
        Source LOD
    srcMemoryType : CUmemorytype
        Source memory type (host, device, array)
    srcHost : Any
        Source host pointer
    srcDevice : CUdeviceptr
        Source device pointer
    srcArray : CUarray
        Source array reference
    srcContext : CUcontext
        Source context (ignored with srcMemoryType is CU_MEMORYTYPE_ARRAY)
    srcPitch : size_t
        Source pitch (ignored when src is array)
    srcHeight : size_t
        Source height (ignored when src is array; may be 0 if Depth==1)
    dstXInBytes : size_t
        Destination X in bytes
    dstY : size_t
        Destination Y
    dstZ : size_t
        Destination Z
    dstLOD : size_t
        Destination LOD
    dstMemoryType : CUmemorytype
        Destination memory type (host, device, array)
    dstHost : Any
        Destination host pointer
    dstDevice : CUdeviceptr
        Destination device pointer
    dstArray : CUarray
        Destination array reference
    dstContext : CUcontext
        Destination context (ignored with dstMemoryType is
        CU_MEMORYTYPE_ARRAY)
    dstPitch : size_t
        Destination pitch (ignored when dst is array)
    dstHeight : size_t
        Destination height (ignored when dst is array; may be 0 if
        Depth==1)
    WidthInBytes : size_t
        Width of 3D memory copy in bytes
    Height : size_t
        Height of 3D memory copy
    Depth : size_t
        Depth of 3D memory copy

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_MEMCPY3D_PEER_st *>calloc(1, sizeof(ccuda.CUDA_MEMCPY3D_PEER_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_MEMCPY3D_PEER_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_MEMCPY3D_PEER_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._srcDevice = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].srcDevice)
        self._srcArray = CUarray(_ptr=<void_ptr>&self._ptr[0].srcArray)
        self._srcContext = CUcontext(_ptr=<void_ptr>&self._ptr[0].srcContext)
        self._dstDevice = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].dstDevice)
        self._dstArray = CUarray(_ptr=<void_ptr>&self._ptr[0].dstArray)
        self._dstContext = CUcontext(_ptr=<void_ptr>&self._ptr[0].dstContext)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['srcXInBytes : ' + str(self.srcXInBytes)]
            str_list += ['srcY : ' + str(self.srcY)]
            str_list += ['srcZ : ' + str(self.srcZ)]
            str_list += ['srcLOD : ' + str(self.srcLOD)]
            str_list += ['srcMemoryType : ' + str(self.srcMemoryType)]
            str_list += ['srcHost : ' + hex(self.srcHost)]
            str_list += ['srcDevice : ' + str(self.srcDevice)]
            str_list += ['srcArray : ' + str(self.srcArray)]
            str_list += ['srcContext : ' + str(self.srcContext)]
            str_list += ['srcPitch : ' + str(self.srcPitch)]
            str_list += ['srcHeight : ' + str(self.srcHeight)]
            str_list += ['dstXInBytes : ' + str(self.dstXInBytes)]
            str_list += ['dstY : ' + str(self.dstY)]
            str_list += ['dstZ : ' + str(self.dstZ)]
            str_list += ['dstLOD : ' + str(self.dstLOD)]
            str_list += ['dstMemoryType : ' + str(self.dstMemoryType)]
            str_list += ['dstHost : ' + hex(self.dstHost)]
            str_list += ['dstDevice : ' + str(self.dstDevice)]
            str_list += ['dstArray : ' + str(self.dstArray)]
            str_list += ['dstContext : ' + str(self.dstContext)]
            str_list += ['dstPitch : ' + str(self.dstPitch)]
            str_list += ['dstHeight : ' + str(self.dstHeight)]
            str_list += ['WidthInBytes : ' + str(self.WidthInBytes)]
            str_list += ['Height : ' + str(self.Height)]
            str_list += ['Depth : ' + str(self.Depth)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def srcXInBytes(self):
        return self._ptr[0].srcXInBytes
    @srcXInBytes.setter
    def srcXInBytes(self, size_t srcXInBytes):
        pass
        self._ptr[0].srcXInBytes = srcXInBytes
    @property
    def srcY(self):
        return self._ptr[0].srcY
    @srcY.setter
    def srcY(self, size_t srcY):
        pass
        self._ptr[0].srcY = srcY
    @property
    def srcZ(self):
        return self._ptr[0].srcZ
    @srcZ.setter
    def srcZ(self, size_t srcZ):
        pass
        self._ptr[0].srcZ = srcZ
    @property
    def srcLOD(self):
        return self._ptr[0].srcLOD
    @srcLOD.setter
    def srcLOD(self, size_t srcLOD):
        pass
        self._ptr[0].srcLOD = srcLOD
    @property
    def srcMemoryType(self):
        return CUmemorytype(self._ptr[0].srcMemoryType)
    @srcMemoryType.setter
    def srcMemoryType(self, srcMemoryType not None : CUmemorytype):
        pass
        self._ptr[0].srcMemoryType = srcMemoryType.value
    @property
    def srcHost(self):
        return <void_ptr>self._ptr[0].srcHost
    @srcHost.setter
    def srcHost(self, srcHost):
        _csrcHost = utils.HelperInputVoidPtr(srcHost)
        self._ptr[0].srcHost = <void*><void_ptr>_csrcHost.cptr
    @property
    def srcDevice(self):
        return self._srcDevice
    @srcDevice.setter
    def srcDevice(self, srcDevice):
        cdef ccuda.CUdeviceptr csrcDevice
        if srcDevice is None:
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(srcDevice, (CUdeviceptr)):
            psrcDevice = int(srcDevice)
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
        else:
            psrcDevice = int(CUdeviceptr(srcDevice))
            csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
        self._srcDevice._ptr[0] = csrcDevice
    @property
    def srcArray(self):
        return self._srcArray
    @srcArray.setter
    def srcArray(self, srcArray):
        cdef ccuda.CUarray csrcArray
        if srcArray is None:
            csrcArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(srcArray, (CUarray)):
            psrcArray = int(srcArray)
            csrcArray = <ccuda.CUarray><void_ptr>psrcArray
        else:
            psrcArray = int(CUarray(srcArray))
            csrcArray = <ccuda.CUarray><void_ptr>psrcArray
        self._srcArray._ptr[0] = csrcArray
    @property
    def srcContext(self):
        return self._srcContext
    @srcContext.setter
    def srcContext(self, srcContext):
        cdef ccuda.CUcontext csrcContext
        if srcContext is None:
            csrcContext = <ccuda.CUcontext><void_ptr>0
        elif isinstance(srcContext, (CUcontext)):
            psrcContext = int(srcContext)
            csrcContext = <ccuda.CUcontext><void_ptr>psrcContext
        else:
            psrcContext = int(CUcontext(srcContext))
            csrcContext = <ccuda.CUcontext><void_ptr>psrcContext
        self._srcContext._ptr[0] = csrcContext
    @property
    def srcPitch(self):
        return self._ptr[0].srcPitch
    @srcPitch.setter
    def srcPitch(self, size_t srcPitch):
        pass
        self._ptr[0].srcPitch = srcPitch
    @property
    def srcHeight(self):
        return self._ptr[0].srcHeight
    @srcHeight.setter
    def srcHeight(self, size_t srcHeight):
        pass
        self._ptr[0].srcHeight = srcHeight
    @property
    def dstXInBytes(self):
        return self._ptr[0].dstXInBytes
    @dstXInBytes.setter
    def dstXInBytes(self, size_t dstXInBytes):
        pass
        self._ptr[0].dstXInBytes = dstXInBytes
    @property
    def dstY(self):
        return self._ptr[0].dstY
    @dstY.setter
    def dstY(self, size_t dstY):
        pass
        self._ptr[0].dstY = dstY
    @property
    def dstZ(self):
        return self._ptr[0].dstZ
    @dstZ.setter
    def dstZ(self, size_t dstZ):
        pass
        self._ptr[0].dstZ = dstZ
    @property
    def dstLOD(self):
        return self._ptr[0].dstLOD
    @dstLOD.setter
    def dstLOD(self, size_t dstLOD):
        pass
        self._ptr[0].dstLOD = dstLOD
    @property
    def dstMemoryType(self):
        return CUmemorytype(self._ptr[0].dstMemoryType)
    @dstMemoryType.setter
    def dstMemoryType(self, dstMemoryType not None : CUmemorytype):
        pass
        self._ptr[0].dstMemoryType = dstMemoryType.value
    @property
    def dstHost(self):
        return <void_ptr>self._ptr[0].dstHost
    @dstHost.setter
    def dstHost(self, dstHost):
        _cdstHost = utils.HelperInputVoidPtr(dstHost)
        self._ptr[0].dstHost = <void*><void_ptr>_cdstHost.cptr
    @property
    def dstDevice(self):
        return self._dstDevice
    @dstDevice.setter
    def dstDevice(self, dstDevice):
        cdef ccuda.CUdeviceptr cdstDevice
        if dstDevice is None:
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(dstDevice, (CUdeviceptr)):
            pdstDevice = int(dstDevice)
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
        else:
            pdstDevice = int(CUdeviceptr(dstDevice))
            cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
        self._dstDevice._ptr[0] = cdstDevice
    @property
    def dstArray(self):
        return self._dstArray
    @dstArray.setter
    def dstArray(self, dstArray):
        cdef ccuda.CUarray cdstArray
        if dstArray is None:
            cdstArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(dstArray, (CUarray)):
            pdstArray = int(dstArray)
            cdstArray = <ccuda.CUarray><void_ptr>pdstArray
        else:
            pdstArray = int(CUarray(dstArray))
            cdstArray = <ccuda.CUarray><void_ptr>pdstArray
        self._dstArray._ptr[0] = cdstArray
    @property
    def dstContext(self):
        return self._dstContext
    @dstContext.setter
    def dstContext(self, dstContext):
        cdef ccuda.CUcontext cdstContext
        if dstContext is None:
            cdstContext = <ccuda.CUcontext><void_ptr>0
        elif isinstance(dstContext, (CUcontext)):
            pdstContext = int(dstContext)
            cdstContext = <ccuda.CUcontext><void_ptr>pdstContext
        else:
            pdstContext = int(CUcontext(dstContext))
            cdstContext = <ccuda.CUcontext><void_ptr>pdstContext
        self._dstContext._ptr[0] = cdstContext
    @property
    def dstPitch(self):
        return self._ptr[0].dstPitch
    @dstPitch.setter
    def dstPitch(self, size_t dstPitch):
        pass
        self._ptr[0].dstPitch = dstPitch
    @property
    def dstHeight(self):
        return self._ptr[0].dstHeight
    @dstHeight.setter
    def dstHeight(self, size_t dstHeight):
        pass
        self._ptr[0].dstHeight = dstHeight
    @property
    def WidthInBytes(self):
        return self._ptr[0].WidthInBytes
    @WidthInBytes.setter
    def WidthInBytes(self, size_t WidthInBytes):
        pass
        self._ptr[0].WidthInBytes = WidthInBytes
    @property
    def Height(self):
        return self._ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        pass
        self._ptr[0].Height = Height
    @property
    def Depth(self):
        return self._ptr[0].Depth
    @Depth.setter
    def Depth(self, size_t Depth):
        pass
        self._ptr[0].Depth = Depth

cdef class CUDA_ARRAY_DESCRIPTOR_st:
    """
    Array descriptor

    Attributes
    ----------
    Width : size_t
        Width of array
    Height : size_t
        Height of array
    Format : CUarray_format
        Array format
    NumChannels : unsigned int
        Channels per array element

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_ARRAY_DESCRIPTOR_st *>calloc(1, sizeof(ccuda.CUDA_ARRAY_DESCRIPTOR_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_ARRAY_DESCRIPTOR_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_ARRAY_DESCRIPTOR_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['Width : ' + str(self.Width)]
            str_list += ['Height : ' + str(self.Height)]
            str_list += ['Format : ' + str(self.Format)]
            str_list += ['NumChannels : ' + str(self.NumChannels)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def Width(self):
        return self._ptr[0].Width
    @Width.setter
    def Width(self, size_t Width):
        pass
        self._ptr[0].Width = Width
    @property
    def Height(self):
        return self._ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        pass
        self._ptr[0].Height = Height
    @property
    def Format(self):
        return CUarray_format(self._ptr[0].Format)
    @Format.setter
    def Format(self, Format not None : CUarray_format):
        pass
        self._ptr[0].Format = Format.value
    @property
    def NumChannels(self):
        return self._ptr[0].NumChannels
    @NumChannels.setter
    def NumChannels(self, unsigned int NumChannels):
        pass
        self._ptr[0].NumChannels = NumChannels

cdef class CUDA_ARRAY3D_DESCRIPTOR_st:
    """
    3D array descriptor

    Attributes
    ----------
    Width : size_t
        Width of 3D array
    Height : size_t
        Height of 3D array
    Depth : size_t
        Depth of 3D array
    Format : CUarray_format
        Array format
    NumChannels : unsigned int
        Channels per array element
    Flags : unsigned int
        Flags

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_ARRAY3D_DESCRIPTOR_st *>calloc(1, sizeof(ccuda.CUDA_ARRAY3D_DESCRIPTOR_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_ARRAY3D_DESCRIPTOR_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_ARRAY3D_DESCRIPTOR_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['Width : ' + str(self.Width)]
            str_list += ['Height : ' + str(self.Height)]
            str_list += ['Depth : ' + str(self.Depth)]
            str_list += ['Format : ' + str(self.Format)]
            str_list += ['NumChannels : ' + str(self.NumChannels)]
            str_list += ['Flags : ' + str(self.Flags)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def Width(self):
        return self._ptr[0].Width
    @Width.setter
    def Width(self, size_t Width):
        pass
        self._ptr[0].Width = Width
    @property
    def Height(self):
        return self._ptr[0].Height
    @Height.setter
    def Height(self, size_t Height):
        pass
        self._ptr[0].Height = Height
    @property
    def Depth(self):
        return self._ptr[0].Depth
    @Depth.setter
    def Depth(self, size_t Depth):
        pass
        self._ptr[0].Depth = Depth
    @property
    def Format(self):
        return CUarray_format(self._ptr[0].Format)
    @Format.setter
    def Format(self, Format not None : CUarray_format):
        pass
        self._ptr[0].Format = Format.value
    @property
    def NumChannels(self):
        return self._ptr[0].NumChannels
    @NumChannels.setter
    def NumChannels(self, unsigned int NumChannels):
        pass
        self._ptr[0].NumChannels = NumChannels
    @property
    def Flags(self):
        return self._ptr[0].Flags
    @Flags.setter
    def Flags(self, unsigned int Flags):
        pass
        self._ptr[0].Flags = Flags

cdef class _CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_st_tileExtent_s:
    """

    Attributes
    ----------
    width : unsigned int

    height : unsigned int

    depth : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_ARRAY_SPARSE_PROPERTIES_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['width : ' + str(self.width)]
            str_list += ['height : ' + str(self.height)]
            str_list += ['depth : ' + str(self.depth)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def width(self):
        return self._ptr[0].tileExtent.width
    @width.setter
    def width(self, unsigned int width):
        pass
        self._ptr[0].tileExtent.width = width
    @property
    def height(self):
        return self._ptr[0].tileExtent.height
    @height.setter
    def height(self, unsigned int height):
        pass
        self._ptr[0].tileExtent.height = height
    @property
    def depth(self):
        return self._ptr[0].tileExtent.depth
    @depth.setter
    def depth(self, unsigned int depth):
        pass
        self._ptr[0].tileExtent.depth = depth

cdef class CUDA_ARRAY_SPARSE_PROPERTIES_st:
    """
    CUDA array sparse properties

    Attributes
    ----------
    tileExtent : _CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_st_tileExtent_s

    miptailFirstLevel : unsigned int
        First mip level at which the mip tail begins.
    miptailSize : unsigned long long
        Total size of the mip tail.
    flags : unsigned int
        Flags will either be zero or
        CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_ARRAY_SPARSE_PROPERTIES_st *>calloc(1, sizeof(ccuda.CUDA_ARRAY_SPARSE_PROPERTIES_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_ARRAY_SPARSE_PROPERTIES_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_ARRAY_SPARSE_PROPERTIES_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._tileExtent = _CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_st_tileExtent_s(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['tileExtent :\n' + '\n'.join(['    ' + line for line in str(self.tileExtent).splitlines()])]
            str_list += ['miptailFirstLevel : ' + str(self.miptailFirstLevel)]
            str_list += ['miptailSize : ' + str(self.miptailSize)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def tileExtent(self):
        return self._tileExtent
    @tileExtent.setter
    def tileExtent(self, tileExtent not None : _CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_v1_CUDA_ARRAY_SPARSE_PROPERTIES_st_tileExtent_s):
        pass
        for _attr in dir(tileExtent):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._tileExtent, _attr, getattr(tileExtent, _attr))
    @property
    def miptailFirstLevel(self):
        return self._ptr[0].miptailFirstLevel
    @miptailFirstLevel.setter
    def miptailFirstLevel(self, unsigned int miptailFirstLevel):
        pass
        self._ptr[0].miptailFirstLevel = miptailFirstLevel
    @property
    def miptailSize(self):
        return self._ptr[0].miptailSize
    @miptailSize.setter
    def miptailSize(self, unsigned long long miptailSize):
        pass
        self._ptr[0].miptailSize = miptailSize
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUDA_ARRAY_MEMORY_REQUIREMENTS_st:
    """
    CUDA array memory requirements

    Attributes
    ----------
    size : size_t
        Total required memory size
    alignment : size_t
        alignment requirement
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_ARRAY_MEMORY_REQUIREMENTS_st *>calloc(1, sizeof(ccuda.CUDA_ARRAY_MEMORY_REQUIREMENTS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_ARRAY_MEMORY_REQUIREMENTS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_ARRAY_MEMORY_REQUIREMENTS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['size : ' + str(self.size)]
            str_list += ['alignment : ' + str(self.alignment)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def size(self):
        return self._ptr[0].size
    @size.setter
    def size(self, size_t size):
        pass
        self._ptr[0].size = size
    @property
    def alignment(self):
        return self._ptr[0].alignment
    @alignment.setter
    def alignment(self, size_t alignment):
        pass
        self._ptr[0].alignment = alignment
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_array_s:
    """

    Attributes
    ----------
    hArray : CUarray


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._hArray = CUarray(_ptr=<void_ptr>&self._ptr[0].res.array.hArray)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['hArray : ' + str(self.hArray)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def hArray(self):
        return self._hArray
    @hArray.setter
    def hArray(self, hArray):
        cdef ccuda.CUarray chArray
        if hArray is None:
            chArray = <ccuda.CUarray><void_ptr>0
        elif isinstance(hArray, (CUarray)):
            phArray = int(hArray)
            chArray = <ccuda.CUarray><void_ptr>phArray
        else:
            phArray = int(CUarray(hArray))
            chArray = <ccuda.CUarray><void_ptr>phArray
        self._hArray._ptr[0] = chArray

cdef class _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_mipmap_s:
    """

    Attributes
    ----------
    hMipmappedArray : CUmipmappedArray


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._hMipmappedArray = CUmipmappedArray(_ptr=<void_ptr>&self._ptr[0].res.mipmap.hMipmappedArray)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['hMipmappedArray : ' + str(self.hMipmappedArray)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def hMipmappedArray(self):
        return self._hMipmappedArray
    @hMipmappedArray.setter
    def hMipmappedArray(self, hMipmappedArray):
        cdef ccuda.CUmipmappedArray chMipmappedArray
        if hMipmappedArray is None:
            chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>0
        elif isinstance(hMipmappedArray, (CUmipmappedArray)):
            phMipmappedArray = int(hMipmappedArray)
            chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>phMipmappedArray
        else:
            phMipmappedArray = int(CUmipmappedArray(hMipmappedArray))
            chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>phMipmappedArray
        self._hMipmappedArray._ptr[0] = chMipmappedArray

cdef class _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_linear_s:
    """

    Attributes
    ----------
    devPtr : CUdeviceptr

    format : CUarray_format

    numChannels : unsigned int

    sizeInBytes : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._devPtr = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].res.linear.devPtr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['devPtr : ' + str(self.devPtr)]
            str_list += ['format : ' + str(self.format)]
            str_list += ['numChannels : ' + str(self.numChannels)]
            str_list += ['sizeInBytes : ' + str(self.sizeInBytes)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def devPtr(self):
        return self._devPtr
    @devPtr.setter
    def devPtr(self, devPtr):
        cdef ccuda.CUdeviceptr cdevPtr
        if devPtr is None:
            cdevPtr = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(devPtr, (CUdeviceptr)):
            pdevPtr = int(devPtr)
            cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
        else:
            pdevPtr = int(CUdeviceptr(devPtr))
            cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
        self._devPtr._ptr[0] = cdevPtr
    @property
    def format(self):
        return CUarray_format(self._ptr[0].res.linear.format)
    @format.setter
    def format(self, format not None : CUarray_format):
        pass
        self._ptr[0].res.linear.format = format.value
    @property
    def numChannels(self):
        return self._ptr[0].res.linear.numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        pass
        self._ptr[0].res.linear.numChannels = numChannels
    @property
    def sizeInBytes(self):
        return self._ptr[0].res.linear.sizeInBytes
    @sizeInBytes.setter
    def sizeInBytes(self, size_t sizeInBytes):
        pass
        self._ptr[0].res.linear.sizeInBytes = sizeInBytes

cdef class _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_pitch2D_s:
    """

    Attributes
    ----------
    devPtr : CUdeviceptr

    format : CUarray_format

    numChannels : unsigned int

    width : size_t

    height : size_t

    pitchInBytes : size_t


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._devPtr = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].res.pitch2D.devPtr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['devPtr : ' + str(self.devPtr)]
            str_list += ['format : ' + str(self.format)]
            str_list += ['numChannels : ' + str(self.numChannels)]
            str_list += ['width : ' + str(self.width)]
            str_list += ['height : ' + str(self.height)]
            str_list += ['pitchInBytes : ' + str(self.pitchInBytes)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def devPtr(self):
        return self._devPtr
    @devPtr.setter
    def devPtr(self, devPtr):
        cdef ccuda.CUdeviceptr cdevPtr
        if devPtr is None:
            cdevPtr = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(devPtr, (CUdeviceptr)):
            pdevPtr = int(devPtr)
            cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
        else:
            pdevPtr = int(CUdeviceptr(devPtr))
            cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
        self._devPtr._ptr[0] = cdevPtr
    @property
    def format(self):
        return CUarray_format(self._ptr[0].res.pitch2D.format)
    @format.setter
    def format(self, format not None : CUarray_format):
        pass
        self._ptr[0].res.pitch2D.format = format.value
    @property
    def numChannels(self):
        return self._ptr[0].res.pitch2D.numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        pass
        self._ptr[0].res.pitch2D.numChannels = numChannels
    @property
    def width(self):
        return self._ptr[0].res.pitch2D.width
    @width.setter
    def width(self, size_t width):
        pass
        self._ptr[0].res.pitch2D.width = width
    @property
    def height(self):
        return self._ptr[0].res.pitch2D.height
    @height.setter
    def height(self, size_t height):
        pass
        self._ptr[0].res.pitch2D.height = height
    @property
    def pitchInBytes(self):
        return self._ptr[0].res.pitch2D.pitchInBytes
    @pitchInBytes.setter
    def pitchInBytes(self, size_t pitchInBytes):
        pass
        self._ptr[0].res.pitch2D.pitchInBytes = pitchInBytes

cdef class _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_reserved_s:
    """

    Attributes
    ----------
    reserved : List[int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def reserved(self):
        return self._ptr[0].res.reserved.reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].res.reserved.reserved = reserved

cdef class _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_u:
    """

    Attributes
    ----------
    array : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_array_s

    mipmap : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_mipmap_s

    linear : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_linear_s

    pitch2D : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_pitch2D_s

    reserved : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_reserved_s


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._array = _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_array_s(_ptr=<void_ptr>self._ptr)
        self._mipmap = _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_mipmap_s(_ptr=<void_ptr>self._ptr)
        self._linear = _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_linear_s(_ptr=<void_ptr>self._ptr)
        self._pitch2D = _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_pitch2D_s(_ptr=<void_ptr>self._ptr)
        self._reserved = _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_reserved_s(_ptr=<void_ptr>self._ptr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['array :\n' + '\n'.join(['    ' + line for line in str(self.array).splitlines()])]
            str_list += ['mipmap :\n' + '\n'.join(['    ' + line for line in str(self.mipmap).splitlines()])]
            str_list += ['linear :\n' + '\n'.join(['    ' + line for line in str(self.linear).splitlines()])]
            str_list += ['pitch2D :\n' + '\n'.join(['    ' + line for line in str(self.pitch2D).splitlines()])]
            str_list += ['reserved :\n' + '\n'.join(['    ' + line for line in str(self.reserved).splitlines()])]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array not None : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_array_s):
        pass
        for _attr in dir(array):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._array, _attr, getattr(array, _attr))
    @property
    def mipmap(self):
        return self._mipmap
    @mipmap.setter
    def mipmap(self, mipmap not None : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_mipmap_s):
        pass
        for _attr in dir(mipmap):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._mipmap, _attr, getattr(mipmap, _attr))
    @property
    def linear(self):
        return self._linear
    @linear.setter
    def linear(self, linear not None : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_linear_s):
        pass
        for _attr in dir(linear):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._linear, _attr, getattr(linear, _attr))
    @property
    def pitch2D(self):
        return self._pitch2D
    @pitch2D.setter
    def pitch2D(self, pitch2D not None : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_pitch2D_s):
        pass
        for _attr in dir(pitch2D):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._pitch2D, _attr, getattr(pitch2D, _attr))
    @property
    def reserved(self):
        return self._reserved
    @reserved.setter
    def reserved(self, reserved not None : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_res_reserved_s):
        pass
        for _attr in dir(reserved):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._reserved, _attr, getattr(reserved, _attr))

cdef class CUDA_RESOURCE_DESC_st:
    """
    CUDA Resource descriptor

    Attributes
    ----------
    resType : CUresourcetype
        Resource type
    res : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_u

    flags : unsigned int
        Flags (must be zero)

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>calloc(1, sizeof(ccuda.CUDA_RESOURCE_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_RESOURCE_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_RESOURCE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._res = _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_u(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['resType : ' + str(self.resType)]
            str_list += ['res :\n' + '\n'.join(['    ' + line for line in str(self.res).splitlines()])]
            str_list += ['flags : ' + str(self.flags)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def resType(self):
        return CUresourcetype(self._ptr[0].resType)
    @resType.setter
    def resType(self, resType not None : CUresourcetype):
        pass
        self._ptr[0].resType = resType.value
    @property
    def res(self):
        return self._res
    @res.setter
    def res(self, res not None : _CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_v1_CUDA_RESOURCE_DESC_st_res_u):
        pass
        for _attr in dir(res):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._res, _attr, getattr(res, _attr))
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags

cdef class CUDA_TEXTURE_DESC_st:
    """
    Texture descriptor

    Attributes
    ----------
    addressMode : List[CUaddress_mode]
        Address modes
    filterMode : CUfilter_mode
        Filter mode
    flags : unsigned int
        Flags
    maxAnisotropy : unsigned int
        Maximum anisotropy ratio
    mipmapFilterMode : CUfilter_mode
        Mipmap filter mode
    mipmapLevelBias : float
        Mipmap level bias
    minMipmapLevelClamp : float
        Mipmap minimum level clamp
    maxMipmapLevelClamp : float
        Mipmap maximum level clamp
    borderColor : List[float]
        Border Color
    reserved : List[int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_TEXTURE_DESC_st *>calloc(1, sizeof(ccuda.CUDA_TEXTURE_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_TEXTURE_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_TEXTURE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['addressMode : ' + str(self.addressMode)]
            str_list += ['filterMode : ' + str(self.filterMode)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['maxAnisotropy : ' + str(self.maxAnisotropy)]
            str_list += ['mipmapFilterMode : ' + str(self.mipmapFilterMode)]
            str_list += ['mipmapLevelBias : ' + str(self.mipmapLevelBias)]
            str_list += ['minMipmapLevelClamp : ' + str(self.minMipmapLevelClamp)]
            str_list += ['maxMipmapLevelClamp : ' + str(self.maxMipmapLevelClamp)]
            str_list += ['borderColor : ' + str(self.borderColor)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def addressMode(self):
        return [CUaddress_mode(_x) for _x in list(self._ptr[0].addressMode)]
    @addressMode.setter
    def addressMode(self, addressMode):
        self._ptr[0].addressMode = [_x.value for _x in addressMode]
    @property
    def filterMode(self):
        return CUfilter_mode(self._ptr[0].filterMode)
    @filterMode.setter
    def filterMode(self, filterMode not None : CUfilter_mode):
        pass
        self._ptr[0].filterMode = filterMode.value
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def maxAnisotropy(self):
        return self._ptr[0].maxAnisotropy
    @maxAnisotropy.setter
    def maxAnisotropy(self, unsigned int maxAnisotropy):
        pass
        self._ptr[0].maxAnisotropy = maxAnisotropy
    @property
    def mipmapFilterMode(self):
        return CUfilter_mode(self._ptr[0].mipmapFilterMode)
    @mipmapFilterMode.setter
    def mipmapFilterMode(self, mipmapFilterMode not None : CUfilter_mode):
        pass
        self._ptr[0].mipmapFilterMode = mipmapFilterMode.value
    @property
    def mipmapLevelBias(self):
        return self._ptr[0].mipmapLevelBias
    @mipmapLevelBias.setter
    def mipmapLevelBias(self, float mipmapLevelBias):
        pass
        self._ptr[0].mipmapLevelBias = mipmapLevelBias
    @property
    def minMipmapLevelClamp(self):
        return self._ptr[0].minMipmapLevelClamp
    @minMipmapLevelClamp.setter
    def minMipmapLevelClamp(self, float minMipmapLevelClamp):
        pass
        self._ptr[0].minMipmapLevelClamp = minMipmapLevelClamp
    @property
    def maxMipmapLevelClamp(self):
        return self._ptr[0].maxMipmapLevelClamp
    @maxMipmapLevelClamp.setter
    def maxMipmapLevelClamp(self, float maxMipmapLevelClamp):
        pass
        self._ptr[0].maxMipmapLevelClamp = maxMipmapLevelClamp
    @property
    def borderColor(self):
        return self._ptr[0].borderColor
    @borderColor.setter
    def borderColor(self, borderColor):
        pass
        self._ptr[0].borderColor = borderColor
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUDA_RESOURCE_VIEW_DESC_st:
    """
    Resource view descriptor

    Attributes
    ----------
    format : CUresourceViewFormat
        Resource view format
    width : size_t
        Width of the resource view
    height : size_t
        Height of the resource view
    depth : size_t
        Depth of the resource view
    firstMipmapLevel : unsigned int
        First defined mipmap level
    lastMipmapLevel : unsigned int
        Last defined mipmap level
    firstLayer : unsigned int
        First layer index
    lastLayer : unsigned int
        Last layer index
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_RESOURCE_VIEW_DESC_st *>calloc(1, sizeof(ccuda.CUDA_RESOURCE_VIEW_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_RESOURCE_VIEW_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_RESOURCE_VIEW_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['format : ' + str(self.format)]
            str_list += ['width : ' + str(self.width)]
            str_list += ['height : ' + str(self.height)]
            str_list += ['depth : ' + str(self.depth)]
            str_list += ['firstMipmapLevel : ' + str(self.firstMipmapLevel)]
            str_list += ['lastMipmapLevel : ' + str(self.lastMipmapLevel)]
            str_list += ['firstLayer : ' + str(self.firstLayer)]
            str_list += ['lastLayer : ' + str(self.lastLayer)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def format(self):
        return CUresourceViewFormat(self._ptr[0].format)
    @format.setter
    def format(self, format not None : CUresourceViewFormat):
        pass
        self._ptr[0].format = format.value
    @property
    def width(self):
        return self._ptr[0].width
    @width.setter
    def width(self, size_t width):
        pass
        self._ptr[0].width = width
    @property
    def height(self):
        return self._ptr[0].height
    @height.setter
    def height(self, size_t height):
        pass
        self._ptr[0].height = height
    @property
    def depth(self):
        return self._ptr[0].depth
    @depth.setter
    def depth(self, size_t depth):
        pass
        self._ptr[0].depth = depth
    @property
    def firstMipmapLevel(self):
        return self._ptr[0].firstMipmapLevel
    @firstMipmapLevel.setter
    def firstMipmapLevel(self, unsigned int firstMipmapLevel):
        pass
        self._ptr[0].firstMipmapLevel = firstMipmapLevel
    @property
    def lastMipmapLevel(self):
        return self._ptr[0].lastMipmapLevel
    @lastMipmapLevel.setter
    def lastMipmapLevel(self, unsigned int lastMipmapLevel):
        pass
        self._ptr[0].lastMipmapLevel = lastMipmapLevel
    @property
    def firstLayer(self):
        return self._ptr[0].firstLayer
    @firstLayer.setter
    def firstLayer(self, unsigned int firstLayer):
        pass
        self._ptr[0].firstLayer = firstLayer
    @property
    def lastLayer(self):
        return self._ptr[0].lastLayer
    @lastLayer.setter
    def lastLayer(self, unsigned int lastLayer):
        pass
        self._ptr[0].lastLayer = lastLayer
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st:
    """
    GPU Direct v3 tokens

    Attributes
    ----------
    p2pToken : unsigned long long

    vaSpaceToken : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st *>calloc(1, sizeof(ccuda.CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_POINTER_ATTRIBUTE_P2P_TOKENS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['p2pToken : ' + str(self.p2pToken)]
            str_list += ['vaSpaceToken : ' + str(self.vaSpaceToken)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def p2pToken(self):
        return self._ptr[0].p2pToken
    @p2pToken.setter
    def p2pToken(self, unsigned long long p2pToken):
        pass
        self._ptr[0].p2pToken = p2pToken
    @property
    def vaSpaceToken(self):
        return self._ptr[0].vaSpaceToken
    @vaSpaceToken.setter
    def vaSpaceToken(self, unsigned int vaSpaceToken):
        pass
        self._ptr[0].vaSpaceToken = vaSpaceToken

cdef class CUDA_LAUNCH_PARAMS_st:
    """
    Kernel launch parameters

    Attributes
    ----------
    function : CUfunction
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    hStream : CUstream
        Stream identifier
    kernelParams : Any
        Array of pointers to kernel parameters

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_LAUNCH_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_LAUNCH_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_LAUNCH_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_LAUNCH_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._function = CUfunction(_ptr=<void_ptr>&self._ptr[0].function)
        self._hStream = CUstream(_ptr=<void_ptr>&self._ptr[0].hStream)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['function : ' + str(self.function)]
            str_list += ['gridDimX : ' + str(self.gridDimX)]
            str_list += ['gridDimY : ' + str(self.gridDimY)]
            str_list += ['gridDimZ : ' + str(self.gridDimZ)]
            str_list += ['blockDimX : ' + str(self.blockDimX)]
            str_list += ['blockDimY : ' + str(self.blockDimY)]
            str_list += ['blockDimZ : ' + str(self.blockDimZ)]
            str_list += ['sharedMemBytes : ' + str(self.sharedMemBytes)]
            str_list += ['hStream : ' + str(self.hStream)]
            str_list += ['kernelParams : ' + str(self.kernelParams)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def function(self):
        return self._function
    @function.setter
    def function(self, function):
        cdef ccuda.CUfunction cfunction
        if function is None:
            cfunction = <ccuda.CUfunction><void_ptr>0
        elif isinstance(function, (CUfunction)):
            pfunction = int(function)
            cfunction = <ccuda.CUfunction><void_ptr>pfunction
        else:
            pfunction = int(CUfunction(function))
            cfunction = <ccuda.CUfunction><void_ptr>pfunction
        self._function._ptr[0] = cfunction
    @property
    def gridDimX(self):
        return self._ptr[0].gridDimX
    @gridDimX.setter
    def gridDimX(self, unsigned int gridDimX):
        pass
        self._ptr[0].gridDimX = gridDimX
    @property
    def gridDimY(self):
        return self._ptr[0].gridDimY
    @gridDimY.setter
    def gridDimY(self, unsigned int gridDimY):
        pass
        self._ptr[0].gridDimY = gridDimY
    @property
    def gridDimZ(self):
        return self._ptr[0].gridDimZ
    @gridDimZ.setter
    def gridDimZ(self, unsigned int gridDimZ):
        pass
        self._ptr[0].gridDimZ = gridDimZ
    @property
    def blockDimX(self):
        return self._ptr[0].blockDimX
    @blockDimX.setter
    def blockDimX(self, unsigned int blockDimX):
        pass
        self._ptr[0].blockDimX = blockDimX
    @property
    def blockDimY(self):
        return self._ptr[0].blockDimY
    @blockDimY.setter
    def blockDimY(self, unsigned int blockDimY):
        pass
        self._ptr[0].blockDimY = blockDimY
    @property
    def blockDimZ(self):
        return self._ptr[0].blockDimZ
    @blockDimZ.setter
    def blockDimZ(self, unsigned int blockDimZ):
        pass
        self._ptr[0].blockDimZ = blockDimZ
    @property
    def sharedMemBytes(self):
        return self._ptr[0].sharedMemBytes
    @sharedMemBytes.setter
    def sharedMemBytes(self, unsigned int sharedMemBytes):
        pass
        self._ptr[0].sharedMemBytes = sharedMemBytes
    @property
    def hStream(self):
        return self._hStream
    @hStream.setter
    def hStream(self, hStream):
        cdef ccuda.CUstream chStream
        if hStream is None:
            chStream = <ccuda.CUstream><void_ptr>0
        elif isinstance(hStream, (CUstream)):
            phStream = int(hStream)
            chStream = <ccuda.CUstream><void_ptr>phStream
        else:
            phStream = int(CUstream(hStream))
            chStream = <ccuda.CUstream><void_ptr>phStream
        self._hStream._ptr[0] = chStream
    @property
    def kernelParams(self):
        return <void_ptr>self._ptr[0].kernelParams
    @kernelParams.setter
    def kernelParams(self, kernelParams):
        self._ckernelParams = utils.HelperKernelParams(kernelParams)
        self._ptr[0].kernelParams = <void**><void_ptr>self._ckernelParams.ckernelParams

cdef class _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_handle_win32_s:
    """

    Attributes
    ----------
    handle : void

    name : void


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['handle : ' + hex(self.handle)]
            str_list += ['name : ' + hex(self.name)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def handle(self):
        return <void_ptr>self._ptr[0].handle.win32.handle
    @handle.setter
    def handle(self, handle):
        _chandle = utils.HelperInputVoidPtr(handle)
        self._ptr[0].handle.win32.handle = <void*><void_ptr>_chandle.cptr
    @property
    def name(self):
        return <void_ptr>self._ptr[0].handle.win32.name
    @name.setter
    def name(self, name):
        _cname = utils.HelperInputVoidPtr(name)
        self._ptr[0].handle.win32.name = <void*><void_ptr>_cname.cptr

cdef class _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_u:
    """

    Attributes
    ----------
    fd : int

    win32 : _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_handle_win32_s

    nvSciBufObject : void


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._win32 = _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_handle_win32_s(_ptr=<void_ptr>self._ptr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fd : ' + str(self.fd)]
            str_list += ['win32 :\n' + '\n'.join(['    ' + line for line in str(self.win32).splitlines()])]
            str_list += ['nvSciBufObject : ' + hex(self.nvSciBufObject)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fd(self):
        return self._ptr[0].handle.fd
    @fd.setter
    def fd(self, int fd):
        pass
        self._ptr[0].handle.fd = fd
    @property
    def win32(self):
        return self._win32
    @win32.setter
    def win32(self, win32 not None : _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_handle_win32_s):
        pass
        for _attr in dir(win32):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._win32, _attr, getattr(win32, _attr))
    @property
    def nvSciBufObject(self):
        return <void_ptr>self._ptr[0].handle.nvSciBufObject
    @nvSciBufObject.setter
    def nvSciBufObject(self, nvSciBufObject):
        _cnvSciBufObject = utils.HelperInputVoidPtr(nvSciBufObject)
        self._ptr[0].handle.nvSciBufObject = <void*><void_ptr>_cnvSciBufObject.cptr

cdef class CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st:
    """
    External memory handle descriptor

    Attributes
    ----------
    type : CUexternalMemoryHandleType
        Type of the handle
    handle : _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_u

    size : unsigned long long
        Size of the memory allocation
    flags : unsigned int
        Flags must either be zero or CUDA_EXTERNAL_MEMORY_DEDICATED
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>calloc(1, sizeof(ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._handle = _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_u(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['type : ' + str(self.type)]
            str_list += ['handle :\n' + '\n'.join(['    ' + line for line in str(self.handle).splitlines()])]
            str_list += ['size : ' + str(self.size)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def type(self):
        return CUexternalMemoryHandleType(self._ptr[0].type)
    @type.setter
    def type(self, type not None : CUexternalMemoryHandleType):
        pass
        self._ptr[0].type = type.value
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle not None : _CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_v1_CUDA_EXTERNAL_MEMORY_HANDLE_DESC_st_handle_u):
        pass
        for _attr in dir(handle):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._handle, _attr, getattr(handle, _attr))
    @property
    def size(self):
        return self._ptr[0].size
    @size.setter
    def size(self, unsigned long long size):
        pass
        self._ptr[0].size = size
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st:
    """
    External memory buffer descriptor

    Attributes
    ----------
    offset : unsigned long long
        Offset into the memory object where the buffer's base is
    size : unsigned long long
        Size of the buffer
    flags : unsigned int
        Flags reserved for future use. Must be zero.
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st *>calloc(1, sizeof(ccuda.CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_BUFFER_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['offset : ' + str(self.offset)]
            str_list += ['size : ' + str(self.size)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def offset(self):
        return self._ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        pass
        self._ptr[0].offset = offset
    @property
    def size(self):
        return self._ptr[0].size
    @size.setter
    def size(self, unsigned long long size):
        pass
        self._ptr[0].size = size
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st:
    """
    External memory mipmap descriptor

    Attributes
    ----------
    offset : unsigned long long
        Offset into the memory object where the base level of the mipmap
        chain is.
    arrayDesc : CUDA_ARRAY3D_DESCRIPTOR
        Format, dimension and type of base level of the mipmap chain
    numLevels : unsigned int
        Total number of levels in the mipmap chain
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st *>calloc(1, sizeof(ccuda.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._arrayDesc = CUDA_ARRAY3D_DESCRIPTOR(_ptr=<void_ptr>&self._ptr[0].arrayDesc)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['offset : ' + str(self.offset)]
            str_list += ['arrayDesc :\n' + '\n'.join(['    ' + line for line in str(self.arrayDesc).splitlines()])]
            str_list += ['numLevels : ' + str(self.numLevels)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def offset(self):
        return self._ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        pass
        self._ptr[0].offset = offset
    @property
    def arrayDesc(self):
        return self._arrayDesc
    @arrayDesc.setter
    def arrayDesc(self, arrayDesc not None : CUDA_ARRAY3D_DESCRIPTOR):
        pass
        for _attr in dir(arrayDesc):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._arrayDesc, _attr, getattr(arrayDesc, _attr))
    @property
    def numLevels(self):
        return self._ptr[0].numLevels
    @numLevels.setter
    def numLevels(self, unsigned int numLevels):
        pass
        self._ptr[0].numLevels = numLevels
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_handle_win32_s:
    """

    Attributes
    ----------
    handle : void

    name : void


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['handle : ' + hex(self.handle)]
            str_list += ['name : ' + hex(self.name)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def handle(self):
        return <void_ptr>self._ptr[0].handle.win32.handle
    @handle.setter
    def handle(self, handle):
        _chandle = utils.HelperInputVoidPtr(handle)
        self._ptr[0].handle.win32.handle = <void*><void_ptr>_chandle.cptr
    @property
    def name(self):
        return <void_ptr>self._ptr[0].handle.win32.name
    @name.setter
    def name(self, name):
        _cname = utils.HelperInputVoidPtr(name)
        self._ptr[0].handle.win32.name = <void*><void_ptr>_cname.cptr

cdef class _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_u:
    """

    Attributes
    ----------
    fd : int

    win32 : _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_handle_win32_s

    nvSciSyncObj : void


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._win32 = _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_handle_win32_s(_ptr=<void_ptr>self._ptr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fd : ' + str(self.fd)]
            str_list += ['win32 :\n' + '\n'.join(['    ' + line for line in str(self.win32).splitlines()])]
            str_list += ['nvSciSyncObj : ' + hex(self.nvSciSyncObj)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fd(self):
        return self._ptr[0].handle.fd
    @fd.setter
    def fd(self, int fd):
        pass
        self._ptr[0].handle.fd = fd
    @property
    def win32(self):
        return self._win32
    @win32.setter
    def win32(self, win32 not None : _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_handle_win32_s):
        pass
        for _attr in dir(win32):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._win32, _attr, getattr(win32, _attr))
    @property
    def nvSciSyncObj(self):
        return <void_ptr>self._ptr[0].handle.nvSciSyncObj
    @nvSciSyncObj.setter
    def nvSciSyncObj(self, nvSciSyncObj):
        _cnvSciSyncObj = utils.HelperInputVoidPtr(nvSciSyncObj)
        self._ptr[0].handle.nvSciSyncObj = <void*><void_ptr>_cnvSciSyncObj.cptr

cdef class CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st:
    """
    External semaphore handle descriptor

    Attributes
    ----------
    type : CUexternalSemaphoreHandleType
        Type of the handle
    handle : _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_u

    flags : unsigned int
        Flags reserved for the future. Must be zero.
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>calloc(1, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._handle = _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_u(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['type : ' + str(self.type)]
            str_list += ['handle :\n' + '\n'.join(['    ' + line for line in str(self.handle).splitlines()])]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def type(self):
        return CUexternalSemaphoreHandleType(self._ptr[0].type)
    @type.setter
    def type(self, type not None : CUexternalSemaphoreHandleType):
        pass
        self._ptr[0].type = type.value
    @property
    def handle(self):
        return self._handle
    @handle.setter
    def handle(self, handle not None : _CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_v1_CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st_handle_u):
        pass
        for _attr in dir(handle):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._handle, _attr, getattr(handle, _attr))
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_fence_s:
    """

    Attributes
    ----------
    value : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['value : ' + str(self.value)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def value(self):
        return self._ptr[0].params.fence.value
    @value.setter
    def value(self, unsigned long long value):
        pass
        self._ptr[0].params.fence.value = value

cdef class _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_nvSciSync_u:
    """

    Attributes
    ----------
    fence : void

    reserved : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fence : ' + hex(self.fence)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fence(self):
        return <void_ptr>self._ptr[0].params.nvSciSync.fence
    @fence.setter
    def fence(self, fence):
        _cfence = utils.HelperInputVoidPtr(fence)
        self._ptr[0].params.nvSciSync.fence = <void*><void_ptr>_cfence.cptr
    @property
    def reserved(self):
        return self._ptr[0].params.nvSciSync.reserved
    @reserved.setter
    def reserved(self, unsigned long long reserved):
        pass
        self._ptr[0].params.nvSciSync.reserved = reserved

cdef class _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_keyedMutex_s:
    """

    Attributes
    ----------
    key : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['key : ' + str(self.key)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def key(self):
        return self._ptr[0].params.keyedMutex.key
    @key.setter
    def key(self, unsigned long long key):
        pass
        self._ptr[0].params.keyedMutex.key = key

cdef class _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_s:
    """

    Attributes
    ----------
    fence : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_fence_s

    nvSciSync : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_nvSciSync_u

    keyedMutex : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_keyedMutex_s

    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._fence = _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_fence_s(_ptr=<void_ptr>self._ptr)
        self._nvSciSync = _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_nvSciSync_u(_ptr=<void_ptr>self._ptr)
        self._keyedMutex = _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_keyedMutex_s(_ptr=<void_ptr>self._ptr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fence :\n' + '\n'.join(['    ' + line for line in str(self.fence).splitlines()])]
            str_list += ['nvSciSync :\n' + '\n'.join(['    ' + line for line in str(self.nvSciSync).splitlines()])]
            str_list += ['keyedMutex :\n' + '\n'.join(['    ' + line for line in str(self.keyedMutex).splitlines()])]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fence(self):
        return self._fence
    @fence.setter
    def fence(self, fence not None : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_fence_s):
        pass
        for _attr in dir(fence):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._fence, _attr, getattr(fence, _attr))
    @property
    def nvSciSync(self):
        return self._nvSciSync
    @nvSciSync.setter
    def nvSciSync(self, nvSciSync not None : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_nvSciSync_u):
        pass
        for _attr in dir(nvSciSync):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._nvSciSync, _attr, getattr(nvSciSync, _attr))
    @property
    def keyedMutex(self):
        return self._keyedMutex
    @keyedMutex.setter
    def keyedMutex(self, keyedMutex not None : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_params_keyedMutex_s):
        pass
        for _attr in dir(keyedMutex):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._keyedMutex, _attr, getattr(keyedMutex, _attr))
    @property
    def reserved(self):
        return self._ptr[0].params.reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].params.reserved = reserved

cdef class CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st:
    """
    External semaphore signal parameters

    Attributes
    ----------
    params : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_s

    flags : unsigned int
        Only when CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS is used to signal a
        CUexternalSemaphore of type
        CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, the valid flag is
        CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC which
        indicates that while signaling the CUexternalSemaphore, no memory
        synchronization operations should be performed for any external
        memory object imported as CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF.
        For all other types of CUexternalSemaphore, flags must be zero.
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._params = _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_s(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['params :\n' + '\n'.join(['    ' + line for line in str(self.params).splitlines()])]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def params(self):
        return self._params
    @params.setter
    def params(self, params not None : _CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS_st_params_s):
        pass
        for _attr in dir(params):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._params, _attr, getattr(params, _attr))
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_fence_s:
    """

    Attributes
    ----------
    value : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['value : ' + str(self.value)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def value(self):
        return self._ptr[0].params.fence.value
    @value.setter
    def value(self, unsigned long long value):
        pass
        self._ptr[0].params.fence.value = value

cdef class _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_nvSciSync_u:
    """

    Attributes
    ----------
    fence : void

    reserved : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fence : ' + hex(self.fence)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fence(self):
        return <void_ptr>self._ptr[0].params.nvSciSync.fence
    @fence.setter
    def fence(self, fence):
        _cfence = utils.HelperInputVoidPtr(fence)
        self._ptr[0].params.nvSciSync.fence = <void*><void_ptr>_cfence.cptr
    @property
    def reserved(self):
        return self._ptr[0].params.nvSciSync.reserved
    @reserved.setter
    def reserved(self, unsigned long long reserved):
        pass
        self._ptr[0].params.nvSciSync.reserved = reserved

cdef class _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_keyedMutex_s:
    """

    Attributes
    ----------
    key : unsigned long long

    timeoutMs : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['key : ' + str(self.key)]
            str_list += ['timeoutMs : ' + str(self.timeoutMs)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def key(self):
        return self._ptr[0].params.keyedMutex.key
    @key.setter
    def key(self, unsigned long long key):
        pass
        self._ptr[0].params.keyedMutex.key = key
    @property
    def timeoutMs(self):
        return self._ptr[0].params.keyedMutex.timeoutMs
    @timeoutMs.setter
    def timeoutMs(self, unsigned int timeoutMs):
        pass
        self._ptr[0].params.keyedMutex.timeoutMs = timeoutMs

cdef class _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_s:
    """

    Attributes
    ----------
    fence : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_fence_s

    nvSciSync : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_nvSciSync_u

    keyedMutex : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_keyedMutex_s

    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._fence = _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_fence_s(_ptr=<void_ptr>self._ptr)
        self._nvSciSync = _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_nvSciSync_u(_ptr=<void_ptr>self._ptr)
        self._keyedMutex = _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_keyedMutex_s(_ptr=<void_ptr>self._ptr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['fence :\n' + '\n'.join(['    ' + line for line in str(self.fence).splitlines()])]
            str_list += ['nvSciSync :\n' + '\n'.join(['    ' + line for line in str(self.nvSciSync).splitlines()])]
            str_list += ['keyedMutex :\n' + '\n'.join(['    ' + line for line in str(self.keyedMutex).splitlines()])]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def fence(self):
        return self._fence
    @fence.setter
    def fence(self, fence not None : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_fence_s):
        pass
        for _attr in dir(fence):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._fence, _attr, getattr(fence, _attr))
    @property
    def nvSciSync(self):
        return self._nvSciSync
    @nvSciSync.setter
    def nvSciSync(self, nvSciSync not None : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_nvSciSync_u):
        pass
        for _attr in dir(nvSciSync):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._nvSciSync, _attr, getattr(nvSciSync, _attr))
    @property
    def keyedMutex(self):
        return self._keyedMutex
    @keyedMutex.setter
    def keyedMutex(self, keyedMutex not None : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_params_keyedMutex_s):
        pass
        for _attr in dir(keyedMutex):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._keyedMutex, _attr, getattr(keyedMutex, _attr))
    @property
    def reserved(self):
        return self._ptr[0].params.reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].params.reserved = reserved

cdef class CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st:
    """
    External semaphore wait parameters

    Attributes
    ----------
    params : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_s

    flags : unsigned int
        Only when CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS is used to wait on a
        CUexternalSemaphore of type
        CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, the valid flag is
        CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC which indicates
        that while waiting for the CUexternalSemaphore, no memory
        synchronization operations should be performed for any external
        memory object imported as CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF.
        For all other types of CUexternalSemaphore, flags must be zero.
    reserved : List[unsigned int]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._params = _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_s(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['params :\n' + '\n'.join(['    ' + line for line in str(self.params).splitlines()])]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def params(self):
        return self._params
    @params.setter
    def params(self, params not None : _CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_v1_CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS_st_params_s):
        pass
        for _attr in dir(params):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._params, _attr, getattr(params, _attr))
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st:
    """
    Semaphore signal node parameters

    Attributes
    ----------
    extSemArray : CUexternalSemaphore
        Array of external semaphore handles.
    paramsArray : CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS
        Array of external semaphore signal parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['extSemArray : ' + str(self.extSemArray)]
            str_list += ['paramsArray : ' + str(self.paramsArray)]
            str_list += ['numExtSems : ' + str(self.numExtSems)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._ptr[0].extSemArray + x*sizeof(ccuda.CUexternalSemaphore) for x in range(self._extSemArray_length)]
        return [CUexternalSemaphore(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <ccuda.CUexternalSemaphore*> calloc(len(val), sizeof(ccuda.CUexternalSemaphore))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(ccuda.CUexternalSemaphore)))
                self._extSemArray_length = <size_t>len(val)
                self._ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<CUexternalSemaphore>val[idx])._ptr[0]
    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._ptr[0].paramsArray + x*sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS) for x in range(self._paramsArray_length)]
        return [CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS*> calloc(len(val), sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS)))
                self._paramsArray_length = <size_t>len(val)
                self._ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                memcpy(&self._paramsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS>val[idx])._ptr, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))
    @property
    def numExtSems(self):
        return self._ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        pass
        self._ptr[0].numExtSems = numExtSems

cdef class CUDA_EXT_SEM_WAIT_NODE_PARAMS_st:
    """
    Semaphore wait node parameters

    Attributes
    ----------
    extSemArray : CUexternalSemaphore
        Array of external semaphore handles.
    paramsArray : CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS
        Array of external semaphore wait parameters.
    numExtSems : unsigned int
        Number of handles and parameters supplied in extSemArray and
        paramsArray.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        if self._extSemArray is not NULL:
            free(self._extSemArray)
        if self._paramsArray is not NULL:
            free(self._paramsArray)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['extSemArray : ' + str(self.extSemArray)]
            str_list += ['paramsArray : ' + str(self.paramsArray)]
            str_list += ['numExtSems : ' + str(self.numExtSems)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def extSemArray(self):
        arrs = [<void_ptr>self._ptr[0].extSemArray + x*sizeof(ccuda.CUexternalSemaphore) for x in range(self._extSemArray_length)]
        return [CUexternalSemaphore(_ptr=arr) for arr in arrs]
    @extSemArray.setter
    def extSemArray(self, val):
        if len(val) == 0:
            free(self._extSemArray)
            self._extSemArray_length = 0
            self._ptr[0].extSemArray = NULL
        else:
            if self._extSemArray_length != <size_t>len(val):
                free(self._extSemArray)
                self._extSemArray = <ccuda.CUexternalSemaphore*> calloc(len(val), sizeof(ccuda.CUexternalSemaphore))
                if self._extSemArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(ccuda.CUexternalSemaphore)))
                self._extSemArray_length = <size_t>len(val)
                self._ptr[0].extSemArray = self._extSemArray
            for idx in range(len(val)):
                self._extSemArray[idx] = (<CUexternalSemaphore>val[idx])._ptr[0]
    @property
    def paramsArray(self):
        arrs = [<void_ptr>self._ptr[0].paramsArray + x*sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS) for x in range(self._paramsArray_length)]
        return [CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS(_ptr=arr) for arr in arrs]
    @paramsArray.setter
    def paramsArray(self, val):
        if len(val) == 0:
            free(self._paramsArray)
            self._paramsArray_length = 0
            self._ptr[0].paramsArray = NULL
        else:
            if self._paramsArray_length != <size_t>len(val):
                free(self._paramsArray)
                self._paramsArray = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS*> calloc(len(val), sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))
                if self._paramsArray is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS)))
                self._paramsArray_length = <size_t>len(val)
                self._ptr[0].paramsArray = self._paramsArray
            for idx in range(len(val)):
                memcpy(&self._paramsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS>val[idx])._ptr, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))
    @property
    def numExtSems(self):
        return self._ptr[0].numExtSems
    @numExtSems.setter
    def numExtSems(self, unsigned int numExtSems):
        pass
        self._ptr[0].numExtSems = numExtSems

cdef class _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_resource_u:
    """

    Attributes
    ----------
    mipmap : CUmipmappedArray

    array : CUarray


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._mipmap = CUmipmappedArray(_ptr=<void_ptr>&self._ptr[0].resource.mipmap)
        self._array = CUarray(_ptr=<void_ptr>&self._ptr[0].resource.array)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['mipmap : ' + str(self.mipmap)]
            str_list += ['array : ' + str(self.array)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def mipmap(self):
        return self._mipmap
    @mipmap.setter
    def mipmap(self, mipmap):
        cdef ccuda.CUmipmappedArray cmipmap
        if mipmap is None:
            cmipmap = <ccuda.CUmipmappedArray><void_ptr>0
        elif isinstance(mipmap, (CUmipmappedArray)):
            pmipmap = int(mipmap)
            cmipmap = <ccuda.CUmipmappedArray><void_ptr>pmipmap
        else:
            pmipmap = int(CUmipmappedArray(mipmap))
            cmipmap = <ccuda.CUmipmappedArray><void_ptr>pmipmap
        self._mipmap._ptr[0] = cmipmap
    @property
    def array(self):
        return self._array
    @array.setter
    def array(self, array):
        cdef ccuda.CUarray carray
        if array is None:
            carray = <ccuda.CUarray><void_ptr>0
        elif isinstance(array, (CUarray)):
            parray = int(array)
            carray = <ccuda.CUarray><void_ptr>parray
        else:
            parray = int(CUarray(array))
            carray = <ccuda.CUarray><void_ptr>parray
        self._array._ptr[0] = carray

cdef class _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_sparseLevel_s:
    """

    Attributes
    ----------
    level : unsigned int

    layer : unsigned int

    offsetX : unsigned int

    offsetY : unsigned int

    offsetZ : unsigned int

    extentWidth : unsigned int

    extentHeight : unsigned int

    extentDepth : unsigned int


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['level : ' + str(self.level)]
            str_list += ['layer : ' + str(self.layer)]
            str_list += ['offsetX : ' + str(self.offsetX)]
            str_list += ['offsetY : ' + str(self.offsetY)]
            str_list += ['offsetZ : ' + str(self.offsetZ)]
            str_list += ['extentWidth : ' + str(self.extentWidth)]
            str_list += ['extentHeight : ' + str(self.extentHeight)]
            str_list += ['extentDepth : ' + str(self.extentDepth)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def level(self):
        return self._ptr[0].subresource.sparseLevel.level
    @level.setter
    def level(self, unsigned int level):
        pass
        self._ptr[0].subresource.sparseLevel.level = level
    @property
    def layer(self):
        return self._ptr[0].subresource.sparseLevel.layer
    @layer.setter
    def layer(self, unsigned int layer):
        pass
        self._ptr[0].subresource.sparseLevel.layer = layer
    @property
    def offsetX(self):
        return self._ptr[0].subresource.sparseLevel.offsetX
    @offsetX.setter
    def offsetX(self, unsigned int offsetX):
        pass
        self._ptr[0].subresource.sparseLevel.offsetX = offsetX
    @property
    def offsetY(self):
        return self._ptr[0].subresource.sparseLevel.offsetY
    @offsetY.setter
    def offsetY(self, unsigned int offsetY):
        pass
        self._ptr[0].subresource.sparseLevel.offsetY = offsetY
    @property
    def offsetZ(self):
        return self._ptr[0].subresource.sparseLevel.offsetZ
    @offsetZ.setter
    def offsetZ(self, unsigned int offsetZ):
        pass
        self._ptr[0].subresource.sparseLevel.offsetZ = offsetZ
    @property
    def extentWidth(self):
        return self._ptr[0].subresource.sparseLevel.extentWidth
    @extentWidth.setter
    def extentWidth(self, unsigned int extentWidth):
        pass
        self._ptr[0].subresource.sparseLevel.extentWidth = extentWidth
    @property
    def extentHeight(self):
        return self._ptr[0].subresource.sparseLevel.extentHeight
    @extentHeight.setter
    def extentHeight(self, unsigned int extentHeight):
        pass
        self._ptr[0].subresource.sparseLevel.extentHeight = extentHeight
    @property
    def extentDepth(self):
        return self._ptr[0].subresource.sparseLevel.extentDepth
    @extentDepth.setter
    def extentDepth(self, unsigned int extentDepth):
        pass
        self._ptr[0].subresource.sparseLevel.extentDepth = extentDepth

cdef class _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_miptail_s:
    """

    Attributes
    ----------
    layer : unsigned int

    offset : unsigned long long

    size : unsigned long long


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['layer : ' + str(self.layer)]
            str_list += ['offset : ' + str(self.offset)]
            str_list += ['size : ' + str(self.size)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def layer(self):
        return self._ptr[0].subresource.miptail.layer
    @layer.setter
    def layer(self, unsigned int layer):
        pass
        self._ptr[0].subresource.miptail.layer = layer
    @property
    def offset(self):
        return self._ptr[0].subresource.miptail.offset
    @offset.setter
    def offset(self, unsigned long long offset):
        pass
        self._ptr[0].subresource.miptail.offset = offset
    @property
    def size(self):
        return self._ptr[0].subresource.miptail.size
    @size.setter
    def size(self, unsigned long long size):
        pass
        self._ptr[0].subresource.miptail.size = size

cdef class _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_u:
    """

    Attributes
    ----------
    sparseLevel : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_sparseLevel_s

    miptail : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_miptail_s


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._sparseLevel = _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_sparseLevel_s(_ptr=<void_ptr>self._ptr)
        self._miptail = _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_miptail_s(_ptr=<void_ptr>self._ptr)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['sparseLevel :\n' + '\n'.join(['    ' + line for line in str(self.sparseLevel).splitlines()])]
            str_list += ['miptail :\n' + '\n'.join(['    ' + line for line in str(self.miptail).splitlines()])]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def sparseLevel(self):
        return self._sparseLevel
    @sparseLevel.setter
    def sparseLevel(self, sparseLevel not None : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_sparseLevel_s):
        pass
        for _attr in dir(sparseLevel):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._sparseLevel, _attr, getattr(sparseLevel, _attr))
    @property
    def miptail(self):
        return self._miptail
    @miptail.setter
    def miptail(self, miptail not None : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_subresource_miptail_s):
        pass
        for _attr in dir(miptail):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._miptail, _attr, getattr(miptail, _attr))

cdef class _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_memHandle_u:
    """

    Attributes
    ----------
    memHandle : CUmemGenericAllocationHandle


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr):
        self._memHandle = CUmemGenericAllocationHandle(_ptr=<void_ptr>&self._ptr[0].memHandle.memHandle)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['memHandle : ' + str(self.memHandle)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def memHandle(self):
        return self._memHandle
    @memHandle.setter
    def memHandle(self, memHandle):
        cdef ccuda.CUmemGenericAllocationHandle cmemHandle
        if memHandle is None:
            cmemHandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>0
        elif isinstance(memHandle, (CUmemGenericAllocationHandle)):
            pmemHandle = int(memHandle)
            cmemHandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>pmemHandle
        else:
            pmemHandle = int(CUmemGenericAllocationHandle(memHandle))
            cmemHandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>pmemHandle
        self._memHandle._ptr[0] = cmemHandle

cdef class CUarrayMapInfo_st:
    """
    Specifies the CUDA array or CUDA mipmapped array memory mapping
    information

    Attributes
    ----------
    resourceType : CUresourcetype
        Resource type
    resource : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_resource_u

    subresourceType : CUarraySparseSubresourceType
        Sparse subresource type
    subresource : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_u

    memOperationType : CUmemOperationType
        Memory operation type
    memHandleType : CUmemHandleType
        Memory handle type
    memHandle : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_memHandle_u

    offset : unsigned long long
        Offset within mip tail  Offset within the memory
    deviceBitMask : unsigned int
        Device ordinal bit mask
    flags : unsigned int
        flags for future use, must be zero now.
    reserved : List[unsigned int]
        Reserved for future use, must be zero now.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUarrayMapInfo_st *>calloc(1, sizeof(ccuda.CUarrayMapInfo_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUarrayMapInfo_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUarrayMapInfo_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._resource = _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_resource_u(_ptr=<void_ptr>self._ptr)
        self._subresource = _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_u(_ptr=<void_ptr>self._ptr)
        self._memHandle = _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_memHandle_u(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['resourceType : ' + str(self.resourceType)]
            str_list += ['resource :\n' + '\n'.join(['    ' + line for line in str(self.resource).splitlines()])]
            str_list += ['subresourceType : ' + str(self.subresourceType)]
            str_list += ['subresource :\n' + '\n'.join(['    ' + line for line in str(self.subresource).splitlines()])]
            str_list += ['memOperationType : ' + str(self.memOperationType)]
            str_list += ['memHandleType : ' + str(self.memHandleType)]
            str_list += ['memHandle :\n' + '\n'.join(['    ' + line for line in str(self.memHandle).splitlines()])]
            str_list += ['offset : ' + str(self.offset)]
            str_list += ['deviceBitMask : ' + str(self.deviceBitMask)]
            str_list += ['flags : ' + str(self.flags)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def resourceType(self):
        return CUresourcetype(self._ptr[0].resourceType)
    @resourceType.setter
    def resourceType(self, resourceType not None : CUresourcetype):
        pass
        self._ptr[0].resourceType = resourceType.value
    @property
    def resource(self):
        return self._resource
    @resource.setter
    def resource(self, resource not None : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_resource_u):
        pass
        for _attr in dir(resource):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._resource, _attr, getattr(resource, _attr))
    @property
    def subresourceType(self):
        return CUarraySparseSubresourceType(self._ptr[0].subresourceType)
    @subresourceType.setter
    def subresourceType(self, subresourceType not None : CUarraySparseSubresourceType):
        pass
        self._ptr[0].subresourceType = subresourceType.value
    @property
    def subresource(self):
        return self._subresource
    @subresource.setter
    def subresource(self, subresource not None : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_subresource_u):
        pass
        for _attr in dir(subresource):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._subresource, _attr, getattr(subresource, _attr))
    @property
    def memOperationType(self):
        return CUmemOperationType(self._ptr[0].memOperationType)
    @memOperationType.setter
    def memOperationType(self, memOperationType not None : CUmemOperationType):
        pass
        self._ptr[0].memOperationType = memOperationType.value
    @property
    def memHandleType(self):
        return CUmemHandleType(self._ptr[0].memHandleType)
    @memHandleType.setter
    def memHandleType(self, memHandleType not None : CUmemHandleType):
        pass
        self._ptr[0].memHandleType = memHandleType.value
    @property
    def memHandle(self):
        return self._memHandle
    @memHandle.setter
    def memHandle(self, memHandle not None : _CUarrayMapInfo_v1_CUarrayMapInfo_v1_CUarrayMapInfo_st_memHandle_u):
        pass
        for _attr in dir(memHandle):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._memHandle, _attr, getattr(memHandle, _attr))
    @property
    def offset(self):
        return self._ptr[0].offset
    @offset.setter
    def offset(self, unsigned long long offset):
        pass
        self._ptr[0].offset = offset
    @property
    def deviceBitMask(self):
        return self._ptr[0].deviceBitMask
    @deviceBitMask.setter
    def deviceBitMask(self, unsigned int deviceBitMask):
        pass
        self._ptr[0].deviceBitMask = deviceBitMask
    @property
    def flags(self):
        return self._ptr[0].flags
    @flags.setter
    def flags(self, unsigned int flags):
        pass
        self._ptr[0].flags = flags
    @property
    def reserved(self):
        return self._ptr[0].reserved
    @reserved.setter
    def reserved(self, reserved):
        pass
        self._ptr[0].reserved = reserved

cdef class CUmemLocation_st:
    """
    Specifies a memory location.

    Attributes
    ----------
    type : CUmemLocationType
        Specifies the location type, which modifies the meaning of id.
    id : int
        identifier for a given this location's CUmemLocationType.

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemLocation_st *>calloc(1, sizeof(ccuda.CUmemLocation_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemLocation_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemLocation_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['type : ' + str(self.type)]
            str_list += ['id : ' + str(self.id)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def type(self):
        return CUmemLocationType(self._ptr[0].type)
    @type.setter
    def type(self, type not None : CUmemLocationType):
        pass
        self._ptr[0].type = type.value
    @property
    def id(self):
        return self._ptr[0].id
    @id.setter
    def id(self, int id):
        pass
        self._ptr[0].id = id

cdef class _CUmemAllocationProp_v1_CUmemAllocationProp_v1_CUmemAllocationProp_st_allocFlags_s:
    """

    Attributes
    ----------
    compressionType : unsigned char

    gpuDirectRDMACapable : unsigned char

    usage : unsigned short

    reserved : unsigned char


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUmemAllocationProp_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['compressionType : ' + str(self.compressionType)]
            str_list += ['gpuDirectRDMACapable : ' + str(self.gpuDirectRDMACapable)]
            str_list += ['usage : ' + str(self.usage)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def compressionType(self):
        return self._ptr[0].allocFlags.compressionType
    @compressionType.setter
    def compressionType(self, unsigned char compressionType):
        pass
        self._ptr[0].allocFlags.compressionType = compressionType
    @property
    def gpuDirectRDMACapable(self):
        return self._ptr[0].allocFlags.gpuDirectRDMACapable
    @gpuDirectRDMACapable.setter
    def gpuDirectRDMACapable(self, unsigned char gpuDirectRDMACapable):
        pass
        self._ptr[0].allocFlags.gpuDirectRDMACapable = gpuDirectRDMACapable
    @property
    def usage(self):
        return self._ptr[0].allocFlags.usage
    @usage.setter
    def usage(self, unsigned short usage):
        pass
        self._ptr[0].allocFlags.usage = usage
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._ptr[0].allocFlags.reserved, 4)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 4:
            raise ValueError("reserved length must be 4, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._ptr[0].allocFlags.reserved[i] = b

cdef class CUmemAllocationProp_st:
    """
    Specifies the allocation properties for a allocation.

    Attributes
    ----------
    type : CUmemAllocationType
        Allocation type
    requestedHandleTypes : CUmemAllocationHandleType
        requested CUmemAllocationHandleType
    location : CUmemLocation
        Location of allocation
    win32HandleMetaData : Any
        Windows-specific POBJECT_ATTRIBUTES required when
        CU_MEM_HANDLE_TYPE_WIN32 is specified. This object atributes
        structure includes security attributes that define the scope of
        which exported allocations may be tranferred to other processes. In
        all other cases, this field is required to be zero.
    allocFlags : _CUmemAllocationProp_v1_CUmemAllocationProp_v1_CUmemAllocationProp_st_allocFlags_s


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemAllocationProp_st *>calloc(1, sizeof(ccuda.CUmemAllocationProp_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemAllocationProp_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemAllocationProp_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._location = CUmemLocation(_ptr=<void_ptr>&self._ptr[0].location)
        self._allocFlags = _CUmemAllocationProp_v1_CUmemAllocationProp_v1_CUmemAllocationProp_st_allocFlags_s(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['type : ' + str(self.type)]
            str_list += ['requestedHandleTypes : ' + str(self.requestedHandleTypes)]
            str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            str_list += ['win32HandleMetaData : ' + hex(self.win32HandleMetaData)]
            str_list += ['allocFlags :\n' + '\n'.join(['    ' + line for line in str(self.allocFlags).splitlines()])]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def type(self):
        return CUmemAllocationType(self._ptr[0].type)
    @type.setter
    def type(self, type not None : CUmemAllocationType):
        pass
        self._ptr[0].type = type.value
    @property
    def requestedHandleTypes(self):
        return CUmemAllocationHandleType(self._ptr[0].requestedHandleTypes)
    @requestedHandleTypes.setter
    def requestedHandleTypes(self, requestedHandleTypes not None : CUmemAllocationHandleType):
        pass
        self._ptr[0].requestedHandleTypes = requestedHandleTypes.value
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : CUmemLocation):
        pass
        for _attr in dir(location):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._location, _attr, getattr(location, _attr))
    @property
    def win32HandleMetaData(self):
        return <void_ptr>self._ptr[0].win32HandleMetaData
    @win32HandleMetaData.setter
    def win32HandleMetaData(self, win32HandleMetaData):
        _cwin32HandleMetaData = utils.HelperInputVoidPtr(win32HandleMetaData)
        self._ptr[0].win32HandleMetaData = <void*><void_ptr>_cwin32HandleMetaData.cptr
    @property
    def allocFlags(self):
        return self._allocFlags
    @allocFlags.setter
    def allocFlags(self, allocFlags not None : _CUmemAllocationProp_v1_CUmemAllocationProp_v1_CUmemAllocationProp_st_allocFlags_s):
        pass
        for _attr in dir(allocFlags):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._allocFlags, _attr, getattr(allocFlags, _attr))

cdef class CUmemAccessDesc_st:
    """
    Memory access descriptor

    Attributes
    ----------
    location : CUmemLocation
        Location on which the request is to change it's accessibility
    flags : CUmemAccess_flags
        ::CUmemProt accessibility flags to set on the request

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemAccessDesc_st *>calloc(1, sizeof(ccuda.CUmemAccessDesc_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemAccessDesc_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemAccessDesc_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._location = CUmemLocation(_ptr=<void_ptr>&self._ptr[0].location)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            str_list += ['flags : ' + str(self.flags)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : CUmemLocation):
        pass
        for _attr in dir(location):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._location, _attr, getattr(location, _attr))
    @property
    def flags(self):
        return CUmemAccess_flags(self._ptr[0].flags)
    @flags.setter
    def flags(self, flags not None : CUmemAccess_flags):
        pass
        self._ptr[0].flags = flags.value

cdef class CUmemPoolProps_st:
    """
    Specifies the properties of allocations made from the pool.

    Attributes
    ----------
    allocType : CUmemAllocationType
        Allocation type. Currently must be specified as
        CU_MEM_ALLOCATION_TYPE_PINNED
    handleTypes : CUmemAllocationHandleType
        Handle types that will be supported by allocations from the pool.
    location : CUmemLocation
        Location where allocations should reside.
    win32SecurityAttributes : Any
        Windows-specific LPSECURITYATTRIBUTES required when
        CU_MEM_HANDLE_TYPE_WIN32 is specified. This security attribute
        defines the scope of which exported allocations may be tranferred
        to other processes. In all other cases, this field is required to
        be zero.
    reserved : bytes
        reserved for future use, must be 0

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemPoolProps_st *>calloc(1, sizeof(ccuda.CUmemPoolProps_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemPoolProps_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemPoolProps_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._location = CUmemLocation(_ptr=<void_ptr>&self._ptr[0].location)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['allocType : ' + str(self.allocType)]
            str_list += ['handleTypes : ' + str(self.handleTypes)]
            str_list += ['location :\n' + '\n'.join(['    ' + line for line in str(self.location).splitlines()])]
            str_list += ['win32SecurityAttributes : ' + hex(self.win32SecurityAttributes)]
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def allocType(self):
        return CUmemAllocationType(self._ptr[0].allocType)
    @allocType.setter
    def allocType(self, allocType not None : CUmemAllocationType):
        pass
        self._ptr[0].allocType = allocType.value
    @property
    def handleTypes(self):
        return CUmemAllocationHandleType(self._ptr[0].handleTypes)
    @handleTypes.setter
    def handleTypes(self, handleTypes not None : CUmemAllocationHandleType):
        pass
        self._ptr[0].handleTypes = handleTypes.value
    @property
    def location(self):
        return self._location
    @location.setter
    def location(self, location not None : CUmemLocation):
        pass
        for _attr in dir(location):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._location, _attr, getattr(location, _attr))
    @property
    def win32SecurityAttributes(self):
        return <void_ptr>self._ptr[0].win32SecurityAttributes
    @win32SecurityAttributes.setter
    def win32SecurityAttributes(self, win32SecurityAttributes):
        _cwin32SecurityAttributes = utils.HelperInputVoidPtr(win32SecurityAttributes)
        self._ptr[0].win32SecurityAttributes = <void*><void_ptr>_cwin32SecurityAttributes.cptr
    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._ptr[0].reserved[i] = b

cdef class CUmemPoolPtrExportData_st:
    """
    Opaque data for exporting a pool allocation

    Attributes
    ----------
    reserved : bytes


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemPoolPtrExportData_st *>calloc(1, sizeof(ccuda.CUmemPoolPtrExportData_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemPoolPtrExportData_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemPoolPtrExportData_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        pass
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['reserved : ' + str(self.reserved)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def reserved(self):
        return PyBytes_FromStringAndSize(<char*>self._ptr[0].reserved, 64)
    @reserved.setter
    def reserved(self, reserved):
        if len(reserved) != 64:
            raise ValueError("reserved length must be 64, is " + str(len(reserved)))
        for i, b in enumerate(reserved):
            self._ptr[0].reserved[i] = b

cdef class CUDA_MEM_ALLOC_NODE_PARAMS_st:
    """
    Memory allocation node parameters

    Attributes
    ----------
    poolProps : CUmemPoolProps
        in: location where the allocation should reside (specified in
        location). handleTypes must be CU_MEM_HANDLE_TYPE_NONE. IPC is not
        supported.
    accessDescs : CUmemAccessDesc
        in: array of memory access descriptors. Used to describe peer GPU
        access
    accessDescCount : size_t
        in: number of memory access descriptors. Must not exceed the number
        of GPUs.
    bytesize : size_t
        in: size in bytes of the requested allocation
    dptr : CUdeviceptr
        out: address of the allocation returned by CUDA

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUDA_MEM_ALLOC_NODE_PARAMS_st *>calloc(1, sizeof(ccuda.CUDA_MEM_ALLOC_NODE_PARAMS_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUDA_MEM_ALLOC_NODE_PARAMS_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUDA_MEM_ALLOC_NODE_PARAMS_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._poolProps = CUmemPoolProps(_ptr=<void_ptr>&self._ptr[0].poolProps)
        self._dptr = CUdeviceptr(_ptr=<void_ptr>&self._ptr[0].dptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        if self._accessDescs is not NULL:
            free(self._accessDescs)
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['poolProps :\n' + '\n'.join(['    ' + line for line in str(self.poolProps).splitlines()])]
            str_list += ['accessDescs : ' + str(self.accessDescs)]
            str_list += ['accessDescCount : ' + str(self.accessDescCount)]
            str_list += ['bytesize : ' + str(self.bytesize)]
            str_list += ['dptr : ' + str(self.dptr)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def poolProps(self):
        return self._poolProps
    @poolProps.setter
    def poolProps(self, poolProps not None : CUmemPoolProps):
        pass
        for _attr in dir(poolProps):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._poolProps, _attr, getattr(poolProps, _attr))
    @property
    def accessDescs(self):
        arrs = [<void_ptr>self._ptr[0].accessDescs + x*sizeof(ccuda.CUmemAccessDesc) for x in range(self._accessDescs_length)]
        return [CUmemAccessDesc(_ptr=arr) for arr in arrs]
    @accessDescs.setter
    def accessDescs(self, val):
        if len(val) == 0:
            free(self._accessDescs)
            self._accessDescs_length = 0
            self._ptr[0].accessDescs = NULL
        else:
            if self._accessDescs_length != <size_t>len(val):
                free(self._accessDescs)
                self._accessDescs = <ccuda.CUmemAccessDesc*> calloc(len(val), sizeof(ccuda.CUmemAccessDesc))
                if self._accessDescs is NULL:
                    raise MemoryError('Failed to allocate length x size memory: ' + str(len(val)) + 'x' + str(sizeof(ccuda.CUmemAccessDesc)))
                self._accessDescs_length = <size_t>len(val)
                self._ptr[0].accessDescs = self._accessDescs
            for idx in range(len(val)):
                memcpy(&self._accessDescs[idx], (<CUmemAccessDesc>val[idx])._ptr, sizeof(ccuda.CUmemAccessDesc))
    @property
    def accessDescCount(self):
        return self._ptr[0].accessDescCount
    @accessDescCount.setter
    def accessDescCount(self, size_t accessDescCount):
        pass
        self._ptr[0].accessDescCount = accessDescCount
    @property
    def bytesize(self):
        return self._ptr[0].bytesize
    @bytesize.setter
    def bytesize(self, size_t bytesize):
        pass
        self._ptr[0].bytesize = bytesize
    @property
    def dptr(self):
        return self._dptr
    @dptr.setter
    def dptr(self, dptr):
        cdef ccuda.CUdeviceptr cdptr
        if dptr is None:
            cdptr = <ccuda.CUdeviceptr><void_ptr>0
        elif isinstance(dptr, (CUdeviceptr)):
            pdptr = int(dptr)
            cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
        else:
            pdptr = int(CUdeviceptr(dptr))
            cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
        self._dptr._ptr[0] = cdptr

cdef class _CUeglFrame_v1_CUeglFrame_v1_CUeglFrame_st_frame_u:
    """

    Attributes
    ----------
    pArray : List[CUarray]

    pPitch : List[void]


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr):
        self._ptr = <ccuda.CUeglFrame_st *>_ptr
    def __init__(self, void_ptr _ptr):
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['pArray : ' + str(self.pArray)]
            str_list += ['pPitch : ' + str(self.pPitch)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def pArray(self):
        return [CUarray(init_value=<void_ptr>_pArray) for _pArray in self._ptr[0].frame.pArray]
    @pArray.setter
    def pArray(self, pArray : List[CUarray]):
        if len(pArray) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(pArray))
        pArray = [int(_pArray) for _pArray in pArray]
        for _idx, _pArray in enumerate(pArray):
            self._ptr[0].frame.pArray[_idx] = <ccuda.CUarray><void_ptr>_pArray
    @property
    def pPitch(self):
        return [<void_ptr>_pPitch for _pPitch in self._ptr[0].frame.pPitch]
    @pPitch.setter
    def pPitch(self, pPitch : List[int]):
        if len(pPitch) != 3:
            raise IndexError('not enough values found during array assignment, expected 3, got', len(pPitch))
        pPitch = [<void_ptr>_pPitch for _pPitch in pPitch]
        for _idx, _pPitch in enumerate(pPitch):
            self._ptr[0].frame.pPitch[_idx] = <void*><void_ptr>_pPitch

cdef class CUeglFrame_st:
    """
    CUDA EGLFrame structure Descriptor - structure defining one frame
    of EGL.  Each frame may contain one or more planes depending on
    whether the surface * is Multiplanar or not.

    Attributes
    ----------
    frame : _CUeglFrame_v1_CUeglFrame_v1_CUeglFrame_st_frame_u

    width : unsigned int
        Width of first plane
    height : unsigned int
        Height of first plane
    depth : unsigned int
        Depth of first plane
    pitch : unsigned int
        Pitch of first plane
    planeCount : unsigned int
        Number of planes
    numChannels : unsigned int
        Number of channels for the plane
    frameType : CUeglFrameType
        Array or Pitch
    eglColorFormat : CUeglColorFormat
        CUDA EGL Color Format
    cuFormat : CUarray_format
        CUDA Array Format

    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUeglFrame_st *>calloc(1, sizeof(ccuda.CUeglFrame_st))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUeglFrame_st)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUeglFrame_st *>_ptr
    def __init__(self, void_ptr _ptr = 0):
        self._frame = _CUeglFrame_v1_CUeglFrame_v1_CUeglFrame_st_frame_u(_ptr=<void_ptr>self._ptr)
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
        pass
    def getPtr(self):
        return <void_ptr>self._ptr
    def __repr__(self):
        if self._ptr is not NULL:
            str_list = []
            str_list += ['frame :\n' + '\n'.join(['    ' + line for line in str(self.frame).splitlines()])]
            str_list += ['width : ' + str(self.width)]
            str_list += ['height : ' + str(self.height)]
            str_list += ['depth : ' + str(self.depth)]
            str_list += ['pitch : ' + str(self.pitch)]
            str_list += ['planeCount : ' + str(self.planeCount)]
            str_list += ['numChannels : ' + str(self.numChannels)]
            str_list += ['frameType : ' + str(self.frameType)]
            str_list += ['eglColorFormat : ' + str(self.eglColorFormat)]
            str_list += ['cuFormat : ' + str(self.cuFormat)]
            return '\n'.join(str_list)
        else:
            return ''

    @property
    def frame(self):
        return self._frame
    @frame.setter
    def frame(self, frame not None : _CUeglFrame_v1_CUeglFrame_v1_CUeglFrame_st_frame_u):
        pass
        for _attr in dir(frame):
            if _attr == 'getPtr':
                continue
            if not _attr.startswith('_'):
                setattr(self._frame, _attr, getattr(frame, _attr))
    @property
    def width(self):
        return self._ptr[0].width
    @width.setter
    def width(self, unsigned int width):
        pass
        self._ptr[0].width = width
    @property
    def height(self):
        return self._ptr[0].height
    @height.setter
    def height(self, unsigned int height):
        pass
        self._ptr[0].height = height
    @property
    def depth(self):
        return self._ptr[0].depth
    @depth.setter
    def depth(self, unsigned int depth):
        pass
        self._ptr[0].depth = depth
    @property
    def pitch(self):
        return self._ptr[0].pitch
    @pitch.setter
    def pitch(self, unsigned int pitch):
        pass
        self._ptr[0].pitch = pitch
    @property
    def planeCount(self):
        return self._ptr[0].planeCount
    @planeCount.setter
    def planeCount(self, unsigned int planeCount):
        pass
        self._ptr[0].planeCount = planeCount
    @property
    def numChannels(self):
        return self._ptr[0].numChannels
    @numChannels.setter
    def numChannels(self, unsigned int numChannels):
        pass
        self._ptr[0].numChannels = numChannels
    @property
    def frameType(self):
        return CUeglFrameType(self._ptr[0].frameType)
    @frameType.setter
    def frameType(self, frameType not None : CUeglFrameType):
        pass
        self._ptr[0].frameType = frameType.value
    @property
    def eglColorFormat(self):
        return CUeglColorFormat(self._ptr[0].eglColorFormat)
    @eglColorFormat.setter
    def eglColorFormat(self, eglColorFormat not None : CUeglColorFormat):
        pass
        self._ptr[0].eglColorFormat = eglColorFormat.value
    @property
    def cuFormat(self):
        return CUarray_format(self._ptr[0].cuFormat)
    @cuFormat.setter
    def cuFormat(self, cuFormat not None : CUarray_format):
        pass
        self._ptr[0].cuFormat = cuFormat.value

cdef class cuuint32_t:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.cuuint32_t *>calloc(1, sizeof(ccuda.cuuint32_t))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.cuuint32_t)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.cuuint32_t *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<cuuint32_t ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class cuuint64_t:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint64_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.cuuint64_t *>calloc(1, sizeof(ccuda.cuuint64_t))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.cuuint64_t)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.cuuint64_t *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<cuuint64_t ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint64_t>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUdeviceptr_v2:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUdeviceptr_v2 *>calloc(1, sizeof(ccuda.CUdeviceptr_v2))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUdeviceptr_v2)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUdeviceptr_v2 *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUdeviceptr_v2 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUdeviceptr:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUdeviceptr *>calloc(1, sizeof(ccuda.CUdeviceptr))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUdeviceptr)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUdeviceptr *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUdeviceptr ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUdevice_v1:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUdevice_v1 *>calloc(1, sizeof(ccuda.CUdevice_v1))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUdevice_v1)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUdevice_v1 *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUdevice_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <int>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUdevice:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUdevice *>calloc(1, sizeof(ccuda.CUdevice))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUdevice)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUdevice *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUdevice ' + str(self.__int__()) + '>'
    def __int__(self):
        return <int>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUtexObject_v1:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUtexObject_v1 *>calloc(1, sizeof(ccuda.CUtexObject_v1))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUtexObject_v1)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUtexObject_v1 *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUtexObject_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUtexObject:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUtexObject *>calloc(1, sizeof(ccuda.CUtexObject))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUtexObject)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUtexObject *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUtexObject ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUsurfObject_v1:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUsurfObject_v1 *>calloc(1, sizeof(ccuda.CUsurfObject_v1))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUsurfObject_v1)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUsurfObject_v1 *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUsurfObject_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUsurfObject:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUsurfObject *>calloc(1, sizeof(ccuda.CUsurfObject))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUsurfObject)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUsurfObject *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUsurfObject ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUmemGenericAllocationHandle_v1:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemGenericAllocationHandle_v1 *>calloc(1, sizeof(ccuda.CUmemGenericAllocationHandle_v1))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemGenericAllocationHandle_v1)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemGenericAllocationHandle_v1 *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUmemGenericAllocationHandle_v1 ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class CUmemGenericAllocationHandle:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.CUmemGenericAllocationHandle *>calloc(1, sizeof(ccuda.CUmemGenericAllocationHandle))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.CUmemGenericAllocationHandle)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.CUmemGenericAllocationHandle *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<CUmemGenericAllocationHandle ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class GLenum:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.GLenum *>calloc(1, sizeof(ccuda.GLenum))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.GLenum)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.GLenum *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<GLenum ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class GLuint:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.GLuint *>calloc(1, sizeof(ccuda.GLuint))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.GLuint)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.GLuint *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<GLuint ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class EGLint:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned int init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.EGLint *>calloc(1, sizeof(ccuda.EGLint))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.EGLint)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.EGLint *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<EGLint ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned int>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class VdpDevice:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.VdpDevice *>calloc(1, sizeof(ccuda.VdpDevice))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.VdpDevice)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.VdpDevice *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<VdpDevice ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class VdpGetProcAddress:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, unsigned long long init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.VdpGetProcAddress *>calloc(1, sizeof(ccuda.VdpGetProcAddress))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.VdpGetProcAddress)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.VdpGetProcAddress *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<VdpGetProcAddress ' + str(self.__int__()) + '>'
    def __int__(self):
        return <unsigned long long>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class VdpVideoSurface:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.VdpVideoSurface *>calloc(1, sizeof(ccuda.VdpVideoSurface))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.VdpVideoSurface)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.VdpVideoSurface *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<VdpVideoSurface ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr

cdef class VdpOutputSurface:
    """


    Methods
    -------
    getPtr()
        Get memory address of class instance

    """
    def __cinit__(self, uint32_t init_value = 0, void_ptr _ptr = 0):
        if _ptr == 0:
            self._ptr_owner = True
            self._ptr = <ccuda.VdpOutputSurface *>calloc(1, sizeof(ccuda.VdpOutputSurface))
            if self._ptr is NULL:
                raise MemoryError('Failed to allocate length x size memory: 1x' + str(sizeof(ccuda.VdpOutputSurface)))
        else:
            self._ptr_owner = False
            self._ptr = <ccuda.VdpOutputSurface *>_ptr
        if init_value:
            self._ptr[0] = init_value
    def __dealloc__(self):
        if self._ptr_owner is True and self._ptr is not NULL:
            free(self._ptr)
    def __repr__(self):
        return '<VdpOutputSurface ' + str(self.__int__()) + '>'
    def __int__(self):
        return <uint32_t>self._ptr[0]
    def getPtr(self):
        return <void_ptr>self._ptr


@cython.embedsignature(True)
def cuGetErrorString(error not None : CUresult):
    """ Gets the string description of an error code.

    Sets `*pStr` to the address of a NULL-terminated string description of
    the error code `error`. If the error code is not recognized,
    CUDA_ERROR_INVALID_VALUE will be returned and `*pStr` will be set to
    the NULL address.

    Parameters
    ----------
    error : CUresult
        Error code to convert to string

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    pStr : bytes
        Address of the string pointer.

    See Also
    --------
    CUresult
    cudaGetErrorString
    """
    cdef ccuda.CUresult cerror = error.value
    cdef const char* pStr = NULL
    err = ccuda.cuGetErrorString(cerror, &pStr)
    return (CUresult(err), <bytes>pStr)

@cython.embedsignature(True)
def cuGetErrorName(error not None : CUresult):
    """ Gets the string representation of an error code enum name.

    Sets `*pStr` to the address of a NULL-terminated string representation
    of the name of the enum error code `error`. If the error code is not
    recognized, CUDA_ERROR_INVALID_VALUE will be returned and `*pStr` will
    be set to the NULL address.

    Parameters
    ----------
    error : CUresult
        Error code to convert to string

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    pStr : bytes
        Address of the string pointer.

    See Also
    --------
    CUresult
    cudaGetErrorName
    """
    cdef ccuda.CUresult cerror = error.value
    cdef const char* pStr = NULL
    err = ccuda.cuGetErrorName(cerror, &pStr)
    return (CUresult(err), <bytes>pStr)

@cython.embedsignature(True)
def cuInit(unsigned int Flags):
    """ Initialize the CUDA driver API.

    Initializes the driver API and must be called before any other function
    from the driver API. Currently, the `Flags` parameter must be 0. If
    cuInit() has not been called, any function from the driver API will
    return CUDA_ERROR_NOT_INITIALIZED.

    Parameters
    ----------
    Flags : unsigned int
        Initialization flag for CUDA.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_SYSTEM_DRIVER_MISMATCH
        CUDA_ERROR_COMPAT_NOT_SUPPORTED_ON_DEVICE
    None
        None
    """
    err = ccuda.cuInit(Flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDriverGetVersion():
    """ Returns the latest CUDA version supported by driver.

    Returns in `*driverVersion` the version of CUDA supported by the
    driver. The version is returned as (1000 * major + 10 * minor). For
    example, CUDA 9.2 would be represented by 9020.

    This function automatically returns CUDA_ERROR_INVALID_VALUE if
    `driverVersion` is NULL.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    driverVersion : int
        Returns the CUDA driver version
    """
    cdef int driverVersion = 0
    err = ccuda.cuDriverGetVersion(&driverVersion)
    return (CUresult(err), driverVersion)

@cython.embedsignature(True)
def cuDeviceGet(int ordinal):
    """ Returns a handle to a compute device.

    Returns in `*device` a device handle given an ordinal in the range [0,
    cuDeviceGetCount()-1].

    Parameters
    ----------
    ordinal : int
        Device number to get handle for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    device : CUdevice
        Returned device handle

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGetLuid
    cuDeviceTotalMem
    cuDeviceGetExecAffinitySupport
    """
    cdef CUdevice device = CUdevice()
    err = ccuda.cuDeviceGet(device._ptr, ordinal)
    return (CUresult(err), device)

@cython.embedsignature(True)
def cuDeviceGetCount():
    """ Returns the number of compute-capable devices.

    Returns in `*count` the number of devices with compute capability
    greater than or equal to 2.0 that are available for execution. If there
    is no such device, cuDeviceGetCount() returns 0.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    count : int
        Returned number of compute-capable devices

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGetLuid
    cuDeviceGet
    cuDeviceTotalMem
    cuDeviceGetExecAffinitySupport
    cudaGetDeviceCount
    """
    cdef int count = 0
    err = ccuda.cuDeviceGetCount(&count)
    return (CUresult(err), count)

@cython.embedsignature(True)
def cuDeviceGetName(int length, dev):
    """ Returns an identifer string for the device.

    Returns an ASCII string identifying the device `dev` in the NULL-
    terminated string pointed to by `name`. `length` specifies the maximum
    length of the string that may be returned.

    Parameters
    ----------
    length : int
        Maximum length of string to store in `name`
    dev : Any
        Device to get identifier string for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    name : bytes
        Returned identifier string for the device

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetUuid
    cuDeviceGetLuid
    cuDeviceGetCount
    cuDeviceGet
    cuDeviceTotalMem
    cuDeviceGetExecAffinitySupport
    cudaGetDeviceProperties
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    pyname = b" " * length
    cdef char* name = pyname
    err = ccuda.cuDeviceGetName(name, length, cdev)
    return (CUresult(err), pyname)

@cython.embedsignature(True)
def cuDeviceGetUuid(dev):
    """ Return an UUID for the device.

    Note there is a later version of this API, cuDeviceGetUuid_v2. It will
    supplant this version in 12.0, which is retained for minor version
    compatibility.

    Returns 16-octets identifing the device `dev` in the structure pointed
    by the `uuid`.

    Parameters
    ----------
    dev : Any
        Device to get identifier string for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    uuid : CUuuid
        Returned UUID

    See Also
    --------
    cuDeviceGetUuid_v2
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetLuid
    cuDeviceGet
    cuDeviceTotalMem
    cuDeviceGetExecAffinitySupport
    cudaGetDeviceProperties
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUuuid uuid = CUuuid()
    err = ccuda.cuDeviceGetUuid(uuid._ptr, cdev)
    return (CUresult(err), uuid)

@cython.embedsignature(True)
def cuDeviceGetUuid_v2(dev):
    """ Return an UUID for the device (11.4+)

    Returns 16-octets identifing the device `dev` in the structure pointed
    by the `uuid`. If the device is in MIG mode, returns its MIG UUID which
    uniquely identifies the subscribed MIG compute instance.

    Parameters
    ----------
    dev : Any
        Device to get identifier string for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    uuid : CUuuid
        Returned UUID

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetLuid
    cuDeviceGet
    cuDeviceTotalMem
    cudaGetDeviceProperties
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUuuid uuid = CUuuid()
    err = ccuda.cuDeviceGetUuid_v2(uuid._ptr, cdev)
    return (CUresult(err), uuid)

@cython.embedsignature(True)
def cuDeviceGetLuid(dev):
    """ Return an LUID and device node mask for the device.

    Return identifying information (`luid` and `deviceNodeMask`) to allow
    matching device with graphics APIs.

    Parameters
    ----------
    dev : Any
        Device to get identifier string for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    luid : bytes
        Returned LUID
    deviceNodeMask : unsigned int
        Returned device node mask

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGet
    cuDeviceTotalMem
    cuDeviceGetExecAffinitySupport
    cudaGetDeviceProperties
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef char luid[8]
    cdef unsigned int deviceNodeMask = 0
    err = ccuda.cuDeviceGetLuid(luid, &deviceNodeMask, cdev)
    return (CUresult(err), <bytes>luid, deviceNodeMask)

@cython.embedsignature(True)
def cuDeviceTotalMem(dev):
    """ Returns the total amount of memory on the device.

    Returns in `*bytes` the total amount of memory available on the device
    `dev` in bytes.

    Parameters
    ----------
    dev : Any
        Device handle

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    numbytes : int
        Returned memory available on device in bytes

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGet
    cuDeviceGetExecAffinitySupport
    cudaMemGetInfo
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef size_t numbytes = 0
    err = ccuda.cuDeviceTotalMem(&numbytes, cdev)
    return (CUresult(err), numbytes)

@cython.embedsignature(True)
def cuDeviceGetTexture1DLinearMaxWidth(pformat not None : CUarray_format, unsigned numChannels, dev):
    """ Returns the maximum number of elements allocatable in a 1D linear texture for a given texture element size.

    Returns in `maxWidthInElements` the maximum number of texture elements
    allocatable in a 1D linear texture for given `pformat` and
    `numChannels`.

    Parameters
    ----------
    pformat : CUarray_format
        Texture format.
    numChannels : unsigned
        Number of channels per texture element.
    dev : Any
        Device handle.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    maxWidthInElements : int
        Returned maximum number of texture elements allocatable for given
        `pformat` and `numChannels`.

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGet
    cudaMemGetInfo
    cuDeviceTotalMem
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef size_t maxWidthInElements = 0
    cdef ccuda.CUarray_format cpformat = pformat.value
    err = ccuda.cuDeviceGetTexture1DLinearMaxWidth(&maxWidthInElements, cpformat, numChannels, cdev)
    return (CUresult(err), maxWidthInElements)

@cython.embedsignature(True)
def cuDeviceGetAttribute(attrib not None : CUdevice_attribute, dev):
    """ Returns information about the device.

    Returns in `*pi` the integer value of the attribute `attrib` on device
    `dev`. The supported attributes are: -
    CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_BLOCK: Maximum number of threads
    per block;    - CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_X: Maximum
    x-dimension of a block    - CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Y:
    Maximum y-dimension of a block    -
    CU_DEVICE_ATTRIBUTE_MAX_BLOCK_DIM_Z: Maximum z-dimension of a block
    - CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_X: Maximum x-dimension of a grid
    - CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Y: Maximum y-dimension of a grid
    - CU_DEVICE_ATTRIBUTE_MAX_GRID_DIM_Z: Maximum z-dimension of a grid
    - CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK: Maximum amount of
    shared memory available to a thread block in bytes    -
    CU_DEVICE_ATTRIBUTE_TOTAL_CONSTANT_MEMORY: Memory available on device
    for constant variables in a CUDA C kernel in bytes    -
    CU_DEVICE_ATTRIBUTE_WARP_SIZE: Warp size in threads    -
    CU_DEVICE_ATTRIBUTE_MAX_PITCH: Maximum pitch in bytes allowed by the
    memory copy functions that involve memory regions allocated through
    cuMemAllocPitch()    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH:
    Maximum 1D texture width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LINEAR_WIDTH: Maximum width for a
    1D texture bound to linear memory    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH: Maximum
    mipmapped 1D texture width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_WIDTH: Maximum 2D texture width
    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_HEIGHT: Maximum 2D texture
    height    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_WIDTH: Maximum
    width for a 2D texture bound to linear memory    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_HEIGHT: Maximum height for
    a 2D texture bound to linear memory    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LINEAR_PITCH: Maximum pitch in
    bytes for a 2D texture bound to linear memory    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_WIDTH: Maximum
    mipmapped 2D texture width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_MIPMAPPED_HEIGHT: Maximum
    mipmapped 2D texture height    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH: Maximum 3D texture width
    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT: Maximum 3D texture
    height    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH: Maximum 3D
    texture depth    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_WIDTH_ALTERNATE: Alternate
    maximum 3D texture width, 0 if no alternate maximum 3D texture size is
    supported    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_HEIGHT_ALTERNATE:
    Alternate maximum 3D texture height, 0 if no alternate maximum 3D
    texture size is supported    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE3D_DEPTH_ALTERNATE: Alternate
    maximum 3D texture depth, 0 if no alternate maximum 3D texture size is
    supported    - CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_WIDTH:
    Maximum cubemap texture width or height    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_WIDTH: Maximum 1D layered
    texture width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_LAYERED_LAYERS: Maximum layers in
    a 1D layered texture    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_WIDTH: Maximum 2D layered
    texture width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_HEIGHT: Maximum 2D
    layered texture height    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_LAYERED_LAYERS: Maximum layers in
    a 2D layered texture    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_WIDTH: Maximum
    cubemap layered texture width or height    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURECUBEMAP_LAYERED_LAYERS: Maximum
    layers in a cubemap layered texture    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_WIDTH: Maximum 1D surface width
    - CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_WIDTH: Maximum 2D surface width
    - CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_HEIGHT: Maximum 2D surface
    height    - CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_WIDTH: Maximum 3D
    surface width    - CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_HEIGHT:
    Maximum 3D surface height    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE3D_DEPTH: Maximum 3D surface depth
    - CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_WIDTH: Maximum 1D
    layered surface width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE1D_LAYERED_LAYERS: Maximum layers in
    a 1D layered surface    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_WIDTH: Maximum 2D layered
    surface width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_HEIGHT: Maximum 2D
    layered surface height    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACE2D_LAYERED_LAYERS: Maximum layers in
    a 2D layered surface    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_WIDTH: Maximum cubemap
    surface width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_WIDTH: Maximum
    cubemap layered surface width    -
    CU_DEVICE_ATTRIBUTE_MAXIMUM_SURFACECUBEMAP_LAYERED_LAYERS: Maximum
    layers in a cubemap layered surface    -
    CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_BLOCK: Maximum number of 32-bit
    registers available to a thread block    -
    CU_DEVICE_ATTRIBUTE_CLOCK_RATE: The typical clock frequency in
    kilohertz    - CU_DEVICE_ATTRIBUTE_TEXTURE_ALIGNMENT: Alignment
    requirement; texture base addresses aligned to textureAlign bytes do
    not need an offset applied to texture fetches    -
    CU_DEVICE_ATTRIBUTE_TEXTURE_PITCH_ALIGNMENT: Pitch alignment
    requirement for 2D texture references bound to pitched memory    -
    CU_DEVICE_ATTRIBUTE_GPU_OVERLAP: 1 if the device can concurrently copy
    memory between host and device while executing a kernel, or 0 if not
    - CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT: Number of multiprocessors
    on the device    - CU_DEVICE_ATTRIBUTE_KERNEL_EXEC_TIMEOUT: 1 if there
    is a run time limit for kernels executed on the device, or 0 if not
    - CU_DEVICE_ATTRIBUTE_INTEGRATED: 1 if the device is integrated with
    the memory subsystem, or 0 if not    -
    CU_DEVICE_ATTRIBUTE_CAN_MAP_HOST_MEMORY: 1 if the device can map host
    memory into the CUDA address space, or 0 if not    -
    CU_DEVICE_ATTRIBUTE_COMPUTE_MODE: Compute mode that device is currently
    in. Available modes are as follows:    - CU_COMPUTEMODE_DEFAULT:
    Default mode - Device is not restricted and can have multiple CUDA
    contexts present at a single time.     - CU_COMPUTEMODE_PROHIBITED:
    Compute-prohibited mode - Device is prohibited from creating new CUDA
    contexts.     - CU_COMPUTEMODE_EXCLUSIVE_PROCESS: Compute-exclusive-
    process mode - Device can have only one context used by a single
    process at a time.     - CU_DEVICE_ATTRIBUTE_CONCURRENT_KERNELS: 1 if
    the device supports executing multiple kernels within the same context
    simultaneously, or 0 if not. It is not guaranteed that multiple kernels
    will be resident on the device concurrently so this feature should not
    be relied upon for correctness.    - CU_DEVICE_ATTRIBUTE_ECC_ENABLED: 1
    if error correction is enabled on the device, 0 if error correction is
    disabled or not supported by the device    -
    CU_DEVICE_ATTRIBUTE_PCI_BUS_ID: PCI bus identifier of the device    -
    CU_DEVICE_ATTRIBUTE_PCI_DEVICE_ID: PCI device (also known as slot)
    identifier of the device    - CU_DEVICE_ATTRIBUTE_PCI_DOMAIN_ID: PCI
    domain identifier of the device    - CU_DEVICE_ATTRIBUTE_TCC_DRIVER: 1
    if the device is using a TCC driver. TCC is only available on Tesla
    hardware running Windows Vista or later    -
    CU_DEVICE_ATTRIBUTE_MEMORY_CLOCK_RATE: Peak memory clock frequency in
    kilohertz    - CU_DEVICE_ATTRIBUTE_GLOBAL_MEMORY_BUS_WIDTH: Global
    memory bus width in bits    - CU_DEVICE_ATTRIBUTE_L2_CACHE_SIZE: Size
    of L2 cache in bytes. 0 if the device doesn't have L2 cache    -
    CU_DEVICE_ATTRIBUTE_MAX_THREADS_PER_MULTIPROCESSOR: Maximum resident
    threads per multiprocessor    - CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING:
    1 if the device shares a unified address space with the host, or 0 if
    not    - CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MAJOR: Major compute
    capability version number    -
    CU_DEVICE_ATTRIBUTE_COMPUTE_CAPABILITY_MINOR: Minor compute capability
    version number    - CU_DEVICE_ATTRIBUTE_GLOBAL_L1_CACHE_SUPPORTED: 1 if
    device supports caching globals in L1 cache, 0 if caching globals in L1
    cache is not supported by the device    -
    CU_DEVICE_ATTRIBUTE_LOCAL_L1_CACHE_SUPPORTED: 1 if device supports
    caching locals in L1 cache, 0 if caching locals in L1 cache is not
    supported by the device    -
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR: Maximum
    amount of shared memory available to a multiprocessor in bytes; this
    amount is shared by all thread blocks simultaneously resident on a
    multiprocessor    -
    CU_DEVICE_ATTRIBUTE_MAX_REGISTERS_PER_MULTIPROCESSOR: Maximum number of
    32-bit registers available to a multiprocessor; this number is shared
    by all thread blocks simultaneously resident on a multiprocessor    -
    CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY: 1 if device supports allocating
    managed memory on this system, 0 if allocating managed memory is not
    supported by the device on this system.    -
    CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD: 1 if device is on a multi-GPU
    board, 0 if not.    - CU_DEVICE_ATTRIBUTE_MULTI_GPU_BOARD_GROUP_ID:
    Unique identifier for a group of devices associated with the same
    board. Devices on the same multi-GPU board will share the same
    identifier.    - CU_DEVICE_ATTRIBUTE_HOST_NATIVE_ATOMIC_SUPPORTED: 1 if
    Link between the device and the host supports native atomic operations.
    - CU_DEVICE_ATTRIBUTE_SINGLE_TO_DOUBLE_PRECISION_PERF_RATIO: Ratio of
    single precision performance (in floating-point operations per second)
    to double precision performance.    -
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS: Device suppports coherently
    accessing pageable memory without calling cudaHostRegister on it.    -
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS: Device can coherently
    access managed memory concurrently with the CPU.    -
    CU_DEVICE_ATTRIBUTE_COMPUTE_PREEMPTION_SUPPORTED: Device supports
    Compute Preemption.    -
    CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM: Device can
    access host registered memory at the same virtual address as the CPU.
    - CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN: The maximum
    per block shared memory size suported on this device. This is the
    maximum value that can be opted into when using the
    cuFuncSetAttribute() call. For more details see
    CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES    -
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES:
    Device accesses pageable memory via the host's page tables.    -
    CU_DEVICE_ATTRIBUTE_DIRECT_MANAGED_MEM_ACCESS_FROM_HOST: The host can
    directly access managed memory on the device without migration.    -
    CU_DEVICE_ATTRIBUTE_VIRTUAL_MEMORY_MANAGEMENT_SUPPORTED: Device
    supports virtual memory management APIs like cuMemAddressReserve,
    cuMemCreate, cuMemMap and related APIs    -
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_POSIX_FILE_DESCRIPTOR_SUPPORTED: Device
    supports exporting memory to a posix file descriptor with
    cuMemExportToShareableHandle, if requested via cuMemCreate    -
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_HANDLE_SUPPORTED: Device supports
    exporting memory to a Win32 NT handle with
    cuMemExportToShareableHandle, if requested via cuMemCreate    -
    CU_DEVICE_ATTRIBUTE_HANDLE_TYPE_WIN32_KMT_HANDLE_SUPPORTED: Device
    supports exporting memory to a Win32 KMT handle with
    cuMemExportToShareableHandle, if requested via cuMemCreate    -
    CU_DEVICE_ATTRIBUTE_MAX_BLOCKS_PER_MULTIPROCESSOR: Maximum number of
    thread blocks that can reside on a multiprocessor    -
    CU_DEVICE_ATTRIBUTE_GENERIC_COMPRESSION_SUPPORTED: Device supports
    compressible memory allocation via cuMemCreate    -
    CU_DEVICE_ATTRIBUTE_MAX_PERSISTING_L2_CACHE_SIZE: Maximum L2 persisting
    lines capacity setting in bytes    -
    CU_DEVICE_ATTRIBUTE_MAX_ACCESS_POLICY_WINDOW_SIZE: Maximum value of
    CUaccessPolicyWindow::num_bytes    -
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WITH_CUDA_VMM_SUPPORTED: Device
    supports specifying the GPUDirect RDMA flag with cuMemCreate.    -
    CU_DEVICE_ATTRIBUTE_RESERVED_SHARED_MEMORY_PER_BLOCK: Amount of shared
    memory per block reserved by CUDA driver in bytes    -
    CU_DEVICE_ATTRIBUTE_SPARSE_CUDA_ARRAY_SUPPORTED: Device supports sparse
    CUDA arrays and sparse CUDA mipmapped arrays.    -
    CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED: Device supports
    using the cuMemHostRegister flag CU_MEMHOSTERGISTER_READ_ONLY to
    register memory that must be mapped as read-only to the GPU    -
    CU_DEVICE_ATTRIBUTE_MEMORY_POOLS_SUPPORTED: Device supports using the
    cuMemAllocAsync and cuMemPool family of APIs    -
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_SUPPORTED: Device supports
    GPUDirect RDMA APIs, like nvidia_p2p_get_pages (see
    https://docs.nvidia.com/cuda/gpudirect-rdma for more information)    -
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_FLUSH_WRITES_OPTIONS: The returned
    attribute shall be interpreted as a bitmask, where the individual bits
    are described by the CUflushGPUDirectRDMAWritesOptions enum    -
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING: GPUDirect RDMA
    writes to the device do not need to be flushed for consumers within the
    scope indicated by the returned attribute. See
    CUGPUDirectRDMAWritesOrdering for the numerical values returned here.
    - CU_DEVICE_ATTRIBUTE_MEMPOOL_SUPPORTED_HANDLE_TYPES: Bitmask of handle
    types supported with mempool based IPC    -
    CU_DEVICE_ATTRIBUTE_DEFERRED_MAPPING_CUDA_ARRAY_SUPPORTED: Device
    supports deferred mapping CUDA arrays and CUDA mipmapped arrays.

    Parameters
    ----------
    attrib : CUdevice_attribute
        Device attribute to query
    dev : Any
        Device handle

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    pi : int
        Returned device attribute value

    See Also
    --------
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGet
    cuDeviceTotalMem
    cuDeviceGetExecAffinitySupport
    cudaDeviceGetAttribute
    cudaGetDeviceProperties
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef int pi = 0
    cdef ccuda.CUdevice_attribute cattrib = attrib.value
    err = ccuda.cuDeviceGetAttribute(&pi, cattrib, cdev)
    return (CUresult(err), pi)

@cython.embedsignature(True)
def cuDeviceGetNvSciSyncAttributes(dev, int flags):
    """ Return NvSciSync attributes that this device can support.

    Returns in `nvSciSyncAttrList`, the properties of NvSciSync that this
    CUDA device, `dev` can support. The returned `nvSciSyncAttrList` can be
    used to create an NvSciSync object that matches this device's
    capabilities.

    If NvSciSyncAttrKey_RequiredPerm field in `nvSciSyncAttrList` is
    already set this API will return CUDA_ERROR_INVALID_VALUE.

    The applications should set `nvSciSyncAttrList` to a valid
    NvSciSyncAttrList failing which this API will return
    CUDA_ERROR_INVALID_HANDLE.

    The `flags` controls how applications intends to use the NvSciSync
    created from the `nvSciSyncAttrList`. The valid flags are: -
    CUDA_NVSCISYNC_ATTR_SIGNAL, specifies that the applications intends to
    signal an NvSciSync on this CUDA device.    - CUDA_NVSCISYNC_ATTR_WAIT,
    specifies that the applications intends to wait on an NvSciSync on this
    CUDA device.

    At least one of these flags must be set, failing which the API returns
    CUDA_ERROR_INVALID_VALUE. Both the flags are orthogonal to one another:
    a developer may set both these flags that allows to set both wait and
    signal specific attributes in the same `nvSciSyncAttrList`.

    Parameters
    ----------
    dev : Any
        Valid Cuda Device to get NvSciSync attributes for.
    flags : int
        flags describing NvSciSync usage.

    Returns
    -------
    CUresult

    nvSciSyncAttrList : int
        Return NvSciSync attributes supported.

    See Also
    --------
    cuImportExternalSemaphore
    cuDestroyExternalSemaphore
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef void_ptr nvSciSyncAttrList = 0
    cdef void* cnvSciSyncAttrList_ptr = <void*>nvSciSyncAttrList
    err = ccuda.cuDeviceGetNvSciSyncAttributes(cnvSciSyncAttrList_ptr, cdev, flags)
    return (CUresult(err), nvSciSyncAttrList)

@cython.embedsignature(True)
def cuDeviceSetMemPool(dev, pool):
    """ Sets the current memory pool of a device.

    The memory pool must be local to the specified device. cuMemAllocAsync
    allocates from the current mempool of the provided stream's device. By
    default, a device's current memory pool is its default memory pool.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    cuMemPoolDestroy
    cuMemAllocFromPoolAsync

    Notes
    -----
    Use cuMemAllocFromPoolAsync to specify asynchronous allocations from a device different than the one the stream runs on.

    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    err = ccuda.cuDeviceSetMemPool(cdev, cpool)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDeviceGetMemPool(dev):
    """ Gets the current mempool for a device.

    Returns the last pool provided to cuDeviceSetMemPool for this device or
    the device's default memory pool if cuDeviceSetMemPool has never been
    called. By default the current mempool is the default mempool for a
    device. Otherwise the returned pool must have been set with
    cuDeviceSetMemPool.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuDeviceGetDefaultMemPool
    cuMemPoolCreate
    cuDeviceSetMemPool
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUmemoryPool pool = CUmemoryPool()
    err = ccuda.cuDeviceGetMemPool(pool._ptr, cdev)
    return (CUresult(err), pool)

@cython.embedsignature(True)
def cuDeviceGetDefaultMemPool(dev):
    """ Returns the default mempool of a device.

    The default mempool of a device contains device memory from that
    device.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemAllocAsync
    cuMemPoolTrimTo
    cuMemPoolGetAttribute
    cuMemPoolSetAttribute
    cuMemPoolSetAccess
    cuDeviceGetMemPool
    cuMemPoolCreate
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUmemoryPool pool_out = CUmemoryPool()
    err = ccuda.cuDeviceGetDefaultMemPool(pool_out._ptr, cdev)
    return (CUresult(err), pool_out)

@cython.embedsignature(True)
def cuFlushGPUDirectRDMAWrites(target not None : CUflushGPUDirectRDMAWritesTarget, scope not None : CUflushGPUDirectRDMAWritesScope):
    """ Blocks until remote writes are visible to the specified scope.

    Blocks until GPUDirect RDMA writes to the target context via mappings
    created through APIs like nvidia_p2p_get_pages (see
    https://docs.nvidia.com/cuda/gpudirect-rdma for more information), are
    visible to the specified scope.

    If the scope equals or lies within the scope indicated by
    CU_DEVICE_ATTRIBUTE_GPU_DIRECT_RDMA_WRITES_ORDERING, the call will be a
    no-op and can be safely omitted for performance. This can be determined
    by comparing the numerical values between the two enums, with smaller
    scopes having smaller values.

    Users may query support for this API via
    CU_DEVICE_ATTRIBUTE_FLUSH_FLUSH_GPU_DIRECT_RDMA_OPTIONS.

    Parameters
    ----------
    target : CUflushGPUDirectRDMAWritesTarget
        The target of the operation, see CUflushGPUDirectRDMAWritesTarget
    scope : CUflushGPUDirectRDMAWritesScope
        The scope of the operation, see CUflushGPUDirectRDMAWritesScope

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None
    """
    cdef ccuda.CUflushGPUDirectRDMAWritesTarget ctarget = target.value
    cdef ccuda.CUflushGPUDirectRDMAWritesScope cscope = scope.value
    err = ccuda.cuFlushGPUDirectRDMAWrites(ctarget, cscope)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDeviceGetProperties(dev):
    """ Returns properties for a selected device.

    Deprecated

    This function was deprecated as of CUDA 5.0 and replaced by
    cuDeviceGetAttribute().

    Returns in `*prop` the properties of device `dev`. The CUdevprop
    structure is defined as:

    typedefstructCUdevprop_st{ intmaxThreadsPerBlock; intmaxThreadsDim[3];
    intmaxGridSize[3]; intsharedMemPerBlock; inttotalConstantMemory;
    intSIMDWidth; intmemPitch; intregsPerBlock; intclockRate;
    inttextureAlign }CUdevprop; where:

    - maxThreadsPerBlock is the maximum number of threads per block;    -
    maxThreadsDim[3] is the maximum sizes of each dimension of a block;
    - maxGridSize[3] is the maximum sizes of each dimension of a grid;    -
    sharedMemPerBlock is the total amount of shared memory available per
    block in bytes;    - totalConstantMemory is the total amount of
    constant memory available on the device in bytes;    - SIMDWidth is the
    warp size;    - memPitch is the maximum pitch allowed by the memory
    copy functions that involve memory regions allocated through
    cuMemAllocPitch();    - regsPerBlock is the total number of registers
    available per block;    - clockRate is the clock frequency in
    kilohertz;    - textureAlign is the alignment requirement; texture base
    addresses that are aligned to textureAlign bytes do not need an offset
    applied to texture fetches.

    Parameters
    ----------
    dev : Any
        Device to get properties for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    prop : CUdevprop
        Returned properties of device

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGet
    cuDeviceTotalMem
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUdevprop prop = CUdevprop()
    err = ccuda.cuDeviceGetProperties(prop._ptr, cdev)
    return (CUresult(err), prop)

@cython.embedsignature(True)
def cuDeviceComputeCapability(dev):
    """ Returns the compute capability of the device.

    Deprecated

    This function was deprecated as of CUDA 5.0 and its functionality
    superceded by cuDeviceGetAttribute().

    Returns in `*major` and `*minor` the major and minor revision numbers
    that define the compute capability of the device `dev`.

    Parameters
    ----------
    dev : Any
        Device handle

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    major : int
        Major revision number
    minor : int
        Minor revision number

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGet
    cuDeviceTotalMem
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef int major = 0
    cdef int minor = 0
    err = ccuda.cuDeviceComputeCapability(&major, &minor, cdev)
    return (CUresult(err), major, minor)

@cython.embedsignature(True)
def cuDevicePrimaryCtxRetain(dev):
    """ Retain the primary context on the GPU.

    Retains the primary context on the device. Once the user successfully
    retains the primary context, the primary context will be active and
    available to the user until the user releases it with
    cuDevicePrimaryCtxRelease() or resets it with
    cuDevicePrimaryCtxReset(). Unlike cuCtxCreate() the newly retained
    context is not pushed onto the stack.

    Retaining the primary context for the first time will fail with
    CUDA_ERROR_UNKNOWN if the compute mode of the device is
    CU_COMPUTEMODE_PROHIBITED. The function cuDeviceGetAttribute() can be
    used with CU_DEVICE_ATTRIBUTE_COMPUTE_MODE to determine the compute
    mode of the device. The nvidia-smi tool can be used to set the compute
    mode for devices. Documentation for nvidia-smi can be obtained by
    passing a -h option to it.

    Please note that the primary context always supports pinned
    allocations. Other flags can be specified by
    cuDevicePrimaryCtxSetFlags().

    Parameters
    ----------
    dev : Any
        Device for which primary context is requested

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_UNKNOWN
    pctx : CUcontext
        Returned context handle of the new context

    See Also
    --------
    cuDevicePrimaryCtxRelease
    cuDevicePrimaryCtxSetFlags
    cuCtxCreate
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUcontext pctx = CUcontext()
    err = ccuda.cuDevicePrimaryCtxRetain(pctx._ptr, cdev)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuDevicePrimaryCtxRelease(dev):
    """ Release the primary context on the GPU.

    Releases the primary context interop on the device. A retained context
    should always be released once the user is done using it. The context
    is automatically reset once the last reference to it is released. This
    behavior is different when the primary context was retained by the CUDA
    runtime from CUDA 4.0 and earlier. In this case, the primary context
    remains always active.

    Releasing a primary context that has not been previously retained will
    fail with CUDA_ERROR_INVALID_CONTEXT.

    Please note that unlike cuCtxDestroy() this method does not pop the
    context from stack in any circumstances.

    Parameters
    ----------
    dev : Any
        Device which primary context is released

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuDevicePrimaryCtxRetain
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    err = ccuda.cuDevicePrimaryCtxRelease(cdev)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDevicePrimaryCtxSetFlags(dev, unsigned int flags):
    """ Set flags for the primary context.

    Sets the flags for the primary context on the device overwriting
    perviously set ones.

    The three LSBs of the `flags` parameter can be used to control how the
    OS thread, which owns the CUDA context at the time of an API call,
    interacts with the OS scheduler when waiting for results from the GPU.
    Only one of the scheduling flags can be set when creating a context.

    - CU_CTX_SCHED_SPIN: Instruct CUDA to actively spin when waiting for
    results from the GPU. This can decrease latency when waiting for the
    GPU, but may lower the performance of CPU threads if they are
    performing work in parallel with the CUDA thread.    -
    CU_CTX_SCHED_YIELD: Instruct CUDA to yield its thread when waiting for
    results from the GPU. This can increase latency when waiting for the
    GPU, but can increase the performance of CPU threads performing work in
    parallel with the GPU.    - CU_CTX_SCHED_BLOCKING_SYNC: Instruct CUDA
    to block the CPU thread on a synchronization primitive when waiting for
    the GPU to finish work.    - CU_CTX_BLOCKING_SYNC: Instruct CUDA to
    block the CPU thread on a synchronization primitive when waiting for
    the GPU to finish work.    Deprecated: This flag was deprecated as of
    CUDA 4.0 and was replaced with CU_CTX_SCHED_BLOCKING_SYNC.    -
    CU_CTX_SCHED_AUTO: The default value if the `flags` parameter is zero,
    uses a heuristic based on the number of active CUDA contexts in the
    process C and the number of logical processors in the system P. If C >
    P, then CUDA will yield to other OS threads when waiting for the GPU
    (CU_CTX_SCHED_YIELD), otherwise CUDA will not yield while waiting for
    results and actively spin on the processor (CU_CTX_SCHED_SPIN).
    Additionally, on Tegra devices, CU_CTX_SCHED_AUTO uses a heuristic
    based on the power profile of the platform and may choose
    CU_CTX_SCHED_BLOCKING_SYNC for low-powered devices.    -
    CU_CTX_LMEM_RESIZE_TO_MAX: Instruct CUDA to not reduce local memory
    after resizing local memory for a kernel. This can prevent thrashing by
    local memory allocations when launching many kernels with high local
    memory usage at the cost of potentially increased memory usage.
    Deprecated: This flag is deprecated and the behavior enabled by this
    flag is now the default and cannot be disabled.

    Parameters
    ----------
    dev : Any
        Device for which the primary context flags are set
    flags : unsigned int
        New flags for the device

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuDevicePrimaryCtxRetain
    cuDevicePrimaryCtxGetState
    cuCtxCreate
    cuCtxGetFlags
    cudaSetDeviceFlags
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    err = ccuda.cuDevicePrimaryCtxSetFlags(cdev, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDevicePrimaryCtxGetState(dev):
    """ Get the state of the primary context.

    Returns in `*flags` the flags for the primary context of `dev`, and in
    `*active` whether it is active. See cuDevicePrimaryCtxSetFlags for flag
    values.

    Parameters
    ----------
    dev : Any
        Device to get primary context flags for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_INVALID_VALUE
    flags : unsigned int
        Pointer to store flags
    active : int
        Pointer to store context state; 0 = inactive, 1 = active

    See Also
    --------
    cuDevicePrimaryCtxSetFlags
    cuCtxGetFlags
    cudaGetDeviceFlags
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef unsigned int flags = 0
    cdef int active = 0
    err = ccuda.cuDevicePrimaryCtxGetState(cdev, &flags, &active)
    return (CUresult(err), flags, active)

@cython.embedsignature(True)
def cuDevicePrimaryCtxReset(dev):
    """ Destroy all allocations and reset all state on the primary context.

    Explicitly destroys and cleans up all resources associated with the
    current device in the current process.

    Note that it is responsibility of the calling function to ensure that
    no other module in the process is using the device any more. For that
    reason it is recommended to use cuDevicePrimaryCtxRelease() in most
    cases. However it is safe for other modules to call
    cuDevicePrimaryCtxRelease() even after resetting the device. Resetting
    the primary context does not release it, an application that has
    retained the primary context should explicitly release its usage.

    Parameters
    ----------
    dev : Any
        Device for which primary context is destroyed

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_PRIMARY_CONTEXT_ACTIVE
    None
        None

    See Also
    --------
    cuDevicePrimaryCtxRetain
    cuDevicePrimaryCtxRelease
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    cudaDeviceReset
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    err = ccuda.cuDevicePrimaryCtxReset(cdev)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDeviceGetExecAffinitySupport(typename not None : CUexecAffinityType, dev):
    """ Returns information about the execution affinity support of the device.

    Returns in `*pi` whether execution affinity type `typename` is
    supported by device `dev`. The supported types are: -
    CU_EXEC_AFFINITY_TYPE_SM_COUNT: 1 if context with limited SMs is
    supported by the device, or 0 if not;

    Parameters
    ----------
    typename : CUexecAffinityType
        Execution affinity type to query
    dev : Any
        Device handle

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    pi : int
        1 if the execution affinity type `typename` is supported by the
        device, or 0 if not

    See Also
    --------
    cuDeviceGetAttribute
    cuDeviceGetCount
    cuDeviceGetName
    cuDeviceGetUuid
    cuDeviceGet
    cuDeviceTotalMem
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef int pi = 0
    cdef ccuda.CUexecAffinityType ctypename = typename.value
    err = ccuda.cuDeviceGetExecAffinitySupport(&pi, ctypename, cdev)
    return (CUresult(err), pi)

@cython.embedsignature(True)
def cuCtxCreate(unsigned int flags, dev):
    """ Create a CUDA context.

    The three LSBs of the `flags` parameter can be used to control how the
    OS thread, which owns the CUDA context at the time of an API call,
    interacts with the OS scheduler when waiting for results from the GPU.
    Only one of the scheduling flags can be set when creating a context.

    - CU_CTX_SCHED_SPIN: Instruct CUDA to actively spin when waiting for
    results from the GPU. This can decrease latency when waiting for the
    GPU, but may lower the performance of CPU threads if they are
    performing work in parallel with the CUDA thread.    -
    CU_CTX_SCHED_YIELD: Instruct CUDA to yield its thread when waiting for
    results from the GPU. This can increase latency when waiting for the
    GPU, but can increase the performance of CPU threads performing work in
    parallel with the GPU.    - CU_CTX_SCHED_BLOCKING_SYNC: Instruct CUDA
    to block the CPU thread on a synchronization primitive when waiting for
    the GPU to finish work.    - CU_CTX_BLOCKING_SYNC: Instruct CUDA to
    block the CPU thread on a synchronization primitive when waiting for
    the GPU to finish work.    Deprecated: This flag was deprecated as of
    CUDA 4.0 and was replaced with CU_CTX_SCHED_BLOCKING_SYNC.    -
    CU_CTX_SCHED_AUTO: The default value if the `flags` parameter is zero,
    uses a heuristic based on the number of active CUDA contexts in the
    process C and the number of logical processors in the system P. If C >
    P, then CUDA will yield to other OS threads when waiting for the GPU
    (CU_CTX_SCHED_YIELD), otherwise CUDA will not yield while waiting for
    results and actively spin on the processor (CU_CTX_SCHED_SPIN).
    Additionally, on Tegra devices, CU_CTX_SCHED_AUTO uses a heuristic
    based on the power profile of the platform and may choose
    CU_CTX_SCHED_BLOCKING_SYNC for low-powered devices.    -
    CU_CTX_MAP_HOST: Instruct CUDA to support mapped pinned allocations.
    This flag must be set in order to allocate pinned host memory that is
    accessible to the GPU.    - CU_CTX_LMEM_RESIZE_TO_MAX: Instruct CUDA to
    not reduce local memory after resizing local memory for a kernel. This
    can prevent thrashing by local memory allocations when launching many
    kernels with high local memory usage at the cost of potentially
    increased memory usage.    Deprecated: This flag is deprecated and the
    behavior enabled by this flag is now the default and cannot be
    disabled. Instead, the per-thread stack size can be controlled with
    cuCtxSetLimit().

    Context creation will fail with CUDA_ERROR_UNKNOWN if the compute mode
    of the device is CU_COMPUTEMODE_PROHIBITED. The function
    cuDeviceGetAttribute() can be used with
    CU_DEVICE_ATTRIBUTE_COMPUTE_MODE to determine the compute mode of the
    device. The nvidia-smi tool can be used to set the compute mode for *
    devices. Documentation for nvidia-smi can be obtained by passing a -h
    option to it.

    Parameters
    ----------
    flags : unsigned int
        Context creation flags
    dev : Any
        Device to create context on

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_UNKNOWN
    pctx : CUcontext
        Returned context handle of the new context

    See Also
    --------
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize

    Notes
    -----
    In most cases it is recommended to use cuDevicePrimaryCtxRetain.

    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    cdef CUcontext pctx = CUcontext()
    err = ccuda.cuCtxCreate(pctx._ptr, flags, cdev)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuCtxCreate_v3(paramsArray : List[CUexecAffinityParam], int numParams, unsigned int flags, dev):
    """ Create a CUDA context with execution affinity.

    Creates a new CUDA context with execution affinity and associates it
    with the calling thread. The `paramsArray` and `flags` parameter are
    described below. The context is created with a usage count of 1 and the
    caller of cuCtxCreate() must call cuCtxDestroy() or when done using the
    context. If a context is already current to the thread, it is
    supplanted by the newly created context and may be restored by a
    subsequent call to cuCtxPopCurrent().

    The type and the amount of execution resource the context can use is
    limited by `paramsArray` and `numParams`. The `paramsArray` is an array
    of `CUexecAffinityParam` and the `numParams` describes the size of the
    array. If two `CUexecAffinityParam` in the array have the same type,
    the latter execution affinity parameter overrides the former execution
    affinity parameter. The supported execution affinity types are: -
    CU_EXEC_AFFINITY_TYPE_SM_COUNT limits the portion of SMs that the
    context can use. The portion of SMs is specified as the number of SMs
    via `CUexecAffinitySmCount`. This limit will be internally rounded up
    to the next hardware-supported amount. Hence, it is imperative to query
    the actual execution affinity of the context via `cuCtxGetExecAffinity`
    after context creation. Currently, this attribute is only supported
    under Volta+ MPS.

    The three LSBs of the `flags` parameter can be used to control how the
    OS thread, which owns the CUDA context at the time of an API call,
    interacts with the OS scheduler when waiting for results from the GPU.
    Only one of the scheduling flags can be set when creating a context.

    - CU_CTX_SCHED_SPIN: Instruct CUDA to actively spin when waiting for
    results from the GPU. This can decrease latency when waiting for the
    GPU, but may lower the performance of CPU threads if they are
    performing work in parallel with the CUDA thread.    -
    CU_CTX_SCHED_YIELD: Instruct CUDA to yield its thread when waiting for
    results from the GPU. This can increase latency when waiting for the
    GPU, but can increase the performance of CPU threads performing work in
    parallel with the GPU.    - CU_CTX_SCHED_BLOCKING_SYNC: Instruct CUDA
    to block the CPU thread on a synchronization primitive when waiting for
    the GPU to finish work.    - CU_CTX_BLOCKING_SYNC: Instruct CUDA to
    block the CPU thread on a synchronization primitive when waiting for
    the GPU to finish work.    Deprecated: This flag was deprecated as of
    CUDA 4.0 and was replaced with CU_CTX_SCHED_BLOCKING_SYNC.    -
    CU_CTX_SCHED_AUTO: The default value if the `flags` parameter is zero,
    uses a heuristic based on the number of active CUDA contexts in the
    process C and the number of logical processors in the system P. If C >
    P, then CUDA will yield to other OS threads when waiting for the GPU
    (CU_CTX_SCHED_YIELD), otherwise CUDA will not yield while waiting for
    results and actively spin on the processor (CU_CTX_SCHED_SPIN).
    Additionally, on Tegra devices, CU_CTX_SCHED_AUTO uses a heuristic
    based on the power profile of the platform and may choose
    CU_CTX_SCHED_BLOCKING_SYNC for low-powered devices.    -
    CU_CTX_MAP_HOST: Instruct CUDA to support mapped pinned allocations.
    This flag must be set in order to allocate pinned host memory that is
    accessible to the GPU.    - CU_CTX_LMEM_RESIZE_TO_MAX: Instruct CUDA to
    not reduce local memory after resizing local memory for a kernel. This
    can prevent thrashing by local memory allocations when launching many
    kernels with high local memory usage at the cost of potentially
    increased memory usage.    Deprecated: This flag is deprecated and the
    behavior enabled by this flag is now the default and cannot be
    disabled. Instead, the per-thread stack size can be controlled with
    cuCtxSetLimit().

    Context creation will fail with CUDA_ERROR_UNKNOWN if the compute mode
    of the device is CU_COMPUTEMODE_PROHIBITED. The function
    cuDeviceGetAttribute() can be used with
    CU_DEVICE_ATTRIBUTE_COMPUTE_MODE to determine the compute mode of the
    device. The nvidia-smi tool can be used to set the compute mode for *
    devices. Documentation for nvidia-smi can be obtained by passing a -h
    option to it.

    Parameters
    ----------
    paramsArray : List[CUexecAffinityParam]
        Execution affinity parameters
    numParams : int
        Number of execution affinity parameters
    flags : unsigned int
        Context creation flags
    dev : Any
        Device to create context on

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY
        CUDA_ERROR_UNKNOWN
    pctx : CUcontext
        Returned context handle of the new context

    See Also
    --------
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    CUexecAffinityParam
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    paramsArray = [] if paramsArray is None else paramsArray
    if not all(isinstance(_x, (CUexecAffinityParam)) for _x in paramsArray):
        raise TypeError("Argument 'paramsArray' is not instance of type (expected List[ccuda.CUexecAffinityParam]")

    cdef CUcontext pctx = CUcontext()
    cdef ccuda.CUexecAffinityParam* cparamsArray = NULL
    if len(paramsArray) > 0:
        cparamsArray = <ccuda.CUexecAffinityParam*> calloc(len(paramsArray), sizeof(ccuda.CUexecAffinityParam))
        if cparamsArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(paramsArray)) + 'x' + str(sizeof(ccuda.CUexecAffinityParam)))
        for idx in range(len(paramsArray)):
            memcpy(&cparamsArray[idx], (<CUexecAffinityParam>paramsArray[idx])._ptr, sizeof(ccuda.CUexecAffinityParam))

    err = ccuda.cuCtxCreate_v3(pctx._ptr, (<CUexecAffinityParam>paramsArray[0])._ptr if len(paramsArray) == 1 else cparamsArray, numParams, flags, cdev)
    if cparamsArray is not NULL:
        free(cparamsArray)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuCtxDestroy(ctx):
    """ Destroy a CUDA context.

    Destroys the CUDA context specified by `ctx`. The context `ctx` will be
    destroyed regardless of how many threads it is current to. It is the
    responsibility of the calling function to ensure that no API call
    issues using `ctx` while cuCtxDestroy() is executing.

    Destroys and cleans up all resources associated with the context. It is
    the caller's responsibility to ensure that the context or its resources
    are not accessed or passed in subsequent API calls and doing so will
    result in undefined behavior. These resources include CUDA types such
    as CUmodule, CUfunction, CUstream, CUevent, CUarray, CUmipmappedArray,
    CUtexObject, CUsurfObject, CUtexref, CUsurfref, CUgraphicsResource,
    CUlinkState, CUexternalMemory and CUexternalSemaphore.

    If `ctx` is current to the calling thread then `ctx` will also be
    popped from the current thread's context stack (as though
    cuCtxPopCurrent() were called). If `ctx` is current to other threads,
    then `ctx` will remain current to those threads, and attempting to
    access `ctx` from those threads will result in the error
    CUDA_ERROR_CONTEXT_IS_DESTROYED.

    Parameters
    ----------
    ctx : Any
        Context to destroy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    err = ccuda.cuCtxDestroy(cctx)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxPushCurrent(ctx):
    """ Pushes a context on the current CPU thread.

    Pushes the given context `ctx` onto the CPU thread's stack of current
    contexts. The specified context becomes the CPU thread's current
    context, so all CUDA functions that operate on the current context are
    affected.

    The previous current context may be made current again by calling
    cuCtxDestroy() or cuCtxPopCurrent().

    Parameters
    ----------
    ctx : Any
        Context to push

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    err = ccuda.cuCtxPushCurrent(cctx)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxPopCurrent():
    """ Pops the current CUDA context from the current CPU thread.

    Pops the current CUDA context from the CPU thread and passes back the
    old context handle in `*pctx`. That context may then be made current to
    a different CPU thread by calling cuCtxPushCurrent().

    If a context was current to the CPU thread before cuCtxCreate() or
    cuCtxPushCurrent() was called, this function makes that context current
    to the CPU thread again.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
    pctx : CUcontext
        Returned popped context handle

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef CUcontext pctx = CUcontext()
    err = ccuda.cuCtxPopCurrent(pctx._ptr)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuCtxSetCurrent(ctx):
    """ Binds the specified CUDA context to the calling CPU thread.

    Binds the specified CUDA context to the calling CPU thread. If `ctx` is
    NULL then the CUDA context previously bound to the calling CPU thread
    is unbound and CUDA_SUCCESS is returned.

    If there exists a CUDA context stack on the calling CPU thread, this
    will replace the top of that stack with `ctx`. If `ctx` is NULL then
    this will be equivalent to popping the top of the calling CPU thread's
    CUDA context stack (or a no-op if the calling CPU thread's CUDA context
    stack is empty).

    Parameters
    ----------
    ctx : Any
        Context to bind to the calling CPU thread

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuCtxGetCurrent
    cuCtxCreate
    cuCtxDestroy
    cudaSetDevice
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    err = ccuda.cuCtxSetCurrent(cctx)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxGetCurrent():
    """ Returns the CUDA context bound to the calling CPU thread.

    Returns in `*pctx` the CUDA context bound to the calling CPU thread. If
    no context is bound to the calling CPU thread then `*pctx` is set to
    NULL and CUDA_SUCCESS is returned.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
    pctx : CUcontext
        Returned context handle

    See Also
    --------
    cuCtxSetCurrent
    cuCtxCreate
    cuCtxDestroy
    cudaGetDevice
    """
    cdef CUcontext pctx = CUcontext()
    err = ccuda.cuCtxGetCurrent(pctx._ptr)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuCtxGetDevice():
    """ Returns the device ID for the current context.

    Returns in `*device` the ordinal of the current context's device.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    device : CUdevice
        Returned device ID for the current context

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    cudaGetDevice
    """
    cdef CUdevice device = CUdevice()
    err = ccuda.cuCtxGetDevice(device._ptr)
    return (CUresult(err), device)

@cython.embedsignature(True)
def cuCtxGetFlags():
    """ Returns the flags for the current context.

    Returns in `*flags` the flags of the current context. See cuCtxCreate
    for flag values.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    flags : unsigned int
        Pointer to store flags of current context

    See Also
    --------
    cuCtxCreate
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetCurrent
    cuCtxGetDevice
    cuCtxGetLimit
    cuCtxGetSharedMemConfig
    cuCtxGetStreamPriorityRange
    cudaGetDeviceFlags
    """
    cdef unsigned int flags = 0
    err = ccuda.cuCtxGetFlags(&flags)
    return (CUresult(err), flags)

@cython.embedsignature(True)
def cuCtxSynchronize():
    """ Block for a context's tasks to complete.

    Blocks until the device has completed all preceding requested tasks.
    cuCtxSynchronize() returns an error if one of the preceding tasks
    failed. If the context was created with the CU_CTX_SCHED_BLOCKING_SYNC
    flag, the CPU thread will block until the GPU context has finished its
    work.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cudaDeviceSynchronize
    """
    err = ccuda.cuCtxSynchronize()
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxSetLimit(limit not None : CUlimit, size_t value):
    """ Set resource limits.

    Setting `limit` to `value` is a request by the application to update
    the current limit maintained by the context. The driver is free to
    modify the requested value to meet h/w requirements (this could be
    clamping to minimum or maximum values, rounding up to nearest element
    size, etc). The application can use cuCtxGetLimit() to find out exactly
    what the limit has been set to.

    Setting each CUlimit has its own specific restrictions, so each is
    discussed here.

    - CU_LIMIT_STACK_SIZE controls the stack size in bytes of each GPU
    thread. The driver automatically increases the per-thread stack size
    for each kernel launch as needed. This size isn't reset back to the
    original value after each launch. Setting this value will take effect
    immediately, and if necessary, the device will block until all
    preceding requested tasks are complete.    - CU_LIMIT_PRINTF_FIFO_SIZE
    controls the size in bytes of the FIFO used by the printf() device
    system call. Setting CU_LIMIT_PRINTF_FIFO_SIZE must be performed before
    launching any kernel that uses the printf() device system call,
    otherwise CUDA_ERROR_INVALID_VALUE will be returned.    -
    CU_LIMIT_MALLOC_HEAP_SIZE controls the size in bytes of the heap used
    by the malloc() and free() device system calls. Setting
    CU_LIMIT_MALLOC_HEAP_SIZE must be performed before launching any kernel
    that uses the malloc() or free() device system calls, otherwise
    CUDA_ERROR_INVALID_VALUE will be returned.    -
    CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH controls the maximum nesting depth of a
    grid at which a thread can safely call cudaDeviceSynchronize(). Setting
    this limit must be performed before any launch of a kernel that uses
    the device runtime and calls cudaDeviceSynchronize() above the default
    sync depth, two levels of grids. Calls to cudaDeviceSynchronize() will
    fail with error code cudaErrorSyncDepthExceeded if the limitation is
    violated. This limit can be set smaller than the default or up the
    maximum launch depth of 24. When setting this limit, keep in mind that
    additional levels of sync depth require the driver to reserve large
    amounts of device memory which can no longer be used for user
    allocations. If these reservations of device memory fail,
    cuCtxSetLimit() will return CUDA_ERROR_OUT_OF_MEMORY, and the limit can
    be reset to a lower value. This limit is only applicable to devices of
    compute capability 3.5 and higher. Attempting to set this limit on
    devices of compute capability less than 3.5 will result in the error
    CUDA_ERROR_UNSUPPORTED_LIMIT being returned.    -
    CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT controls the maximum number
    of outstanding device runtime launches that can be made from the
    current context. A grid is outstanding from the point of launch up
    until the grid is known to have been completed. Device runtime launches
    which violate this limitation fail and return
    cudaErrorLaunchPendingCountExceeded when cudaGetLastError() is called
    after launch. If more pending launches than the default (2048 launches)
    are needed for a module using the device runtime, this limit can be
    increased. Keep in mind that being able to sustain additional pending
    launches will require the driver to reserve larger amounts of device
    memory upfront which can no longer be used for allocations. If these
    reservations fail, cuCtxSetLimit() will return
    CUDA_ERROR_OUT_OF_MEMORY, and the limit can be reset to a lower value.
    This limit is only applicable to devices of compute capability 3.5 and
    higher. Attempting to set this limit on devices of compute capability
    less than 3.5 will result in the error CUDA_ERROR_UNSUPPORTED_LIMIT
    being returned.    - CU_LIMIT_MAX_L2_FETCH_GRANULARITY controls the L2
    cache fetch granularity. Values can range from 0B to 128B. This is
    purely a performence hint and it can be ignored or clamped depending on
    the platform.    - CU_LIMIT_PERSISTING_L2_CACHE_SIZE controls size in
    bytes availabe for persisting L2 cache. This is purely a performance
    hint and it can be ignored or clamped depending on the platform.

    Parameters
    ----------
    limit : CUlimit
        Limit to set
    value : size_t
        Size of limit

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_UNSUPPORTED_LIMIT
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSynchronize
    cudaDeviceSetLimit
    """
    cdef ccuda.CUlimit climit = limit.value
    err = ccuda.cuCtxSetLimit(climit, value)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxGetLimit(limit not None : CUlimit):
    """ Returns resource limits.

    Returns in `*pvalue` the current size of `limit`. The supported CUlimit
    values are: - CU_LIMIT_STACK_SIZE: stack size in bytes of each GPU
    thread.    - CU_LIMIT_PRINTF_FIFO_SIZE: size in bytes of the FIFO used
    by the printf() device system call.    - CU_LIMIT_MALLOC_HEAP_SIZE:
    size in bytes of the heap used by the malloc() and free() device system
    calls.    - CU_LIMIT_DEV_RUNTIME_SYNC_DEPTH: maximum grid depth at
    which a thread can issue the device runtime call
    cudaDeviceSynchronize() to wait on child grid launches to complete.
    - CU_LIMIT_DEV_RUNTIME_PENDING_LAUNCH_COUNT: maximum number of
    outstanding device runtime launches that can be made from this context.
    - CU_LIMIT_MAX_L2_FETCH_GRANULARITY: L2 cache fetch granularity.    -
    CU_LIMIT_PERSISTING_L2_CACHE_SIZE: Persisting L2 cache size in bytes

    Parameters
    ----------
    limit : CUlimit
        Limit to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_UNSUPPORTED_LIMIT
    pvalue : int
        Returned size of limit

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    cudaDeviceGetLimit
    """
    cdef size_t pvalue = 0
    cdef ccuda.CUlimit climit = limit.value
    err = ccuda.cuCtxGetLimit(&pvalue, climit)
    return (CUresult(err), pvalue)

@cython.embedsignature(True)
def cuCtxGetCacheConfig():
    """ Returns the preferred cache configuration for the current context.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this function returns through `pconfig` the preferred cache
    configuration for the current context. This is only a preference. The
    driver will use the requested configuration if possible, but it is free
    to choose a different configuration if required to execute functions.

    This will return a `pconfig` of CU_FUNC_CACHE_PREFER_NONE on devices
    where the size of the L1 cache and shared memory are fixed.

    The supported cache configurations are: - CU_FUNC_CACHE_PREFER_NONE: no
    preference for shared memory or L1 (default)    -
    CU_FUNC_CACHE_PREFER_SHARED: prefer larger shared memory and smaller L1
    cache    - CU_FUNC_CACHE_PREFER_L1: prefer larger L1 cache and smaller
    shared memory    - CU_FUNC_CACHE_PREFER_EQUAL: prefer equal sized L1
    cache and shared memory

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    pconfig : CUfunc_cache
        Returned cache configuration

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    cuFuncSetCacheConfig
    cudaDeviceGetCacheConfig
    """
    cdef ccuda.CUfunc_cache pconfig
    err = ccuda.cuCtxGetCacheConfig(&pconfig)
    return (CUresult(err), CUfunc_cache(pconfig))

@cython.embedsignature(True)
def cuCtxSetCacheConfig(config not None : CUfunc_cache):
    """ Sets the preferred cache configuration for the current context.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this sets through `config` the preferred cache configuration
    for the current context. This is only a preference. The driver will use
    the requested configuration if possible, but it is free to choose a
    different configuration if required to execute the function. Any
    function preference set via cuFuncSetCacheConfig() will be preferred
    over this context-wide setting. Setting the context-wide cache
    configuration to CU_FUNC_CACHE_PREFER_NONE will cause subsequent kernel
    launches to prefer to not change the cache configuration unless
    required to launch the kernel.

    This setting does nothing on devices where the size of the L1 cache and
    shared memory are fixed.

    Launching a kernel with a different preference than the most recent
    preference setting may insert a device-side synchronization point.

    The supported cache configurations are: - CU_FUNC_CACHE_PREFER_NONE: no
    preference for shared memory or L1 (default)    -
    CU_FUNC_CACHE_PREFER_SHARED: prefer larger shared memory and smaller L1
    cache    - CU_FUNC_CACHE_PREFER_L1: prefer larger L1 cache and smaller
    shared memory    - CU_FUNC_CACHE_PREFER_EQUAL: prefer equal sized L1
    cache and shared memory

    Parameters
    ----------
    config : CUfunc_cache
        Requested cache configuration

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetLimit
    cuCtxSynchronize
    cuFuncSetCacheConfig
    cudaDeviceSetCacheConfig
    """
    cdef ccuda.CUfunc_cache cconfig = config.value
    err = ccuda.cuCtxSetCacheConfig(cconfig)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxGetSharedMemConfig():
    """ Returns the current shared memory configuration for the current context.

    This function will return in `pConfig` the current size of shared
    memory banks in the current context. On devices with configurable
    shared memory banks, cuCtxSetSharedMemConfig can be used to change this
    setting, so that all subsequent kernel launches will by default use the
    new bank size. When cuCtxGetSharedMemConfig is called on devices
    without configurable shared memory, it will return the fixed bank size
    of the hardware.

    The returned bank configurations can be either: -
    CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE: shared memory bank width is
    four bytes.    - CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE: shared
    memory bank width will eight bytes.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    pConfig : CUsharedconfig
        returned shared memory configuration

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetLimit
    cuCtxSynchronize
    cuCtxGetSharedMemConfig
    cuFuncSetCacheConfig
    cudaDeviceGetSharedMemConfig
    """
    cdef ccuda.CUsharedconfig pConfig
    err = ccuda.cuCtxGetSharedMemConfig(&pConfig)
    return (CUresult(err), CUsharedconfig(pConfig))

@cython.embedsignature(True)
def cuCtxSetSharedMemConfig(config not None : CUsharedconfig):
    """ Sets the shared memory configuration for the current context.

    On devices with configurable shared memory banks, this function will
    set the context's shared memory bank size which is used for subsequent
    kernel launches.

    Changed the shared memory configuration between launches may insert a
    device side synchronization point between those launches.

    Changing the shared memory bank size will not increase shared memory
    usage or affect occupancy of kernels, but may have major effects on
    performance. Larger bank sizes will allow for greater potential
    bandwidth to shared memory, but will change what kinds of accesses to
    shared memory will result in bank conflicts.

    This function will do nothing on devices with fixed shared memory bank
    size.

    The supported bank configurations are: -
    CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE: set bank width to the default
    initial setting (currently, four bytes).    -
    CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE: set shared memory bank width
    to be natively four bytes.    -
    CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE: set shared memory bank width
    to be natively eight bytes.

    Parameters
    ----------
    config : CUsharedconfig
        requested shared memory configuration

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetLimit
    cuCtxSynchronize
    cuCtxGetSharedMemConfig
    cuFuncSetCacheConfig
    cudaDeviceSetSharedMemConfig
    """
    cdef ccuda.CUsharedconfig cconfig = config.value
    err = ccuda.cuCtxSetSharedMemConfig(cconfig)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxGetApiVersion(ctx):
    """ Gets the context's API version.

    Returns a version number in `version` corresponding to the capabilities
    of the context (e.g. 3010 or 3020), which library developers can use to
    direct callers to a specific API version. If `ctx` is NULL, returns the
    API version used to create the currently bound context.

    Note that new API versions are only introduced when context
    capabilities are changed that break binary compatibility, so the API
    version and driver version may be different. For example, it is valid
    for the API version to be 3020 while the driver version is 4020.

    Parameters
    ----------
    ctx : Any
        Context to check

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_UNKNOWN
    version : unsigned int
        Pointer to version

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    cdef unsigned int version = 0
    err = ccuda.cuCtxGetApiVersion(cctx, &version)
    return (CUresult(err), version)

@cython.embedsignature(True)
def cuCtxGetStreamPriorityRange():
    """ Returns numerical values that correspond to the least and greatest stream priorities.

    Returns in `*leastPriority` and `*greatestPriority` the numerical
    values that correspond to the least and greatest stream priorities
    respectively. Stream priorities follow a convention where lower numbers
    imply greater priorities. The range of meaningful stream priorities is
    given by [`*greatestPriority`, `*leastPriority`]. If the user attempts
    to create a stream with a priority value that is outside the meaningful
    range as specified by this API, the priority is automatically clamped
    down or up to either `*leastPriority` or `*greatestPriority`
    respectively. See cuStreamCreateWithPriority for details on creating a
    priority stream. A NULL may be passed in for `*leastPriority` or
    `*greatestPriority` if the value is not desired.

    This function will return '0' in both `*leastPriority` and
    `*greatestPriority` if the current context's device does not support
    stream priorities (see cuDeviceGetAttribute).

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    leastPriority : int
        Pointer to an int in which the numerical value for least stream
        priority is returned
    greatestPriority : int
        Pointer to an int in which the numerical value for greatest stream
        priority is returned

    See Also
    --------
    cuStreamCreateWithPriority
    cuStreamGetPriority
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxSetLimit
    cuCtxSynchronize
    cudaDeviceGetStreamPriorityRange
    """
    cdef int leastPriority = 0
    cdef int greatestPriority = 0
    err = ccuda.cuCtxGetStreamPriorityRange(&leastPriority, &greatestPriority)
    return (CUresult(err), leastPriority, greatestPriority)

@cython.embedsignature(True)
def cuCtxResetPersistingL2Cache():
    """ Resets all persisting lines in cache to normal status.

    cuCtxResetPersistingL2Cache Resets all persisting lines in cache to
    normal status. Takes effect on function return.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_SUPPORTED
    None
        None
    """
    err = ccuda.cuCtxResetPersistingL2Cache()
    return (CUresult(err),)

@cython.embedsignature(True)
def cuCtxGetExecAffinity(typename not None : CUexecAffinityType):
    """ Returns the execution affinity setting for the current context.

    Returns in `*pExecAffinity` the current value of `typename`. The
    supported CUexecAffinityType values are: -
    CU_EXEC_AFFINITY_TYPE_SM_COUNT: number of SMs the context is limited to
    use.

    Parameters
    ----------
    typename : CUexecAffinityType
        Execution affinity type to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_UNSUPPORTED_EXEC_AFFINITY
    pExecAffinity : CUexecAffinityParam
        Returned execution affinity
    """
    cdef CUexecAffinityParam pExecAffinity = CUexecAffinityParam()
    cdef ccuda.CUexecAffinityType ctypename = typename.value
    err = ccuda.cuCtxGetExecAffinity(pExecAffinity._ptr, ctypename)
    return (CUresult(err), pExecAffinity)

@cython.embedsignature(True)
def cuCtxAttach(unsigned int flags):
    """ Increment a context's usage-count.

    Deprecated

    Note that this function is deprecated and should not be used.

    Increments the usage count of the context and passes back a context
    handle in `*pctx` that must be passed to cuCtxDetach() when the
    application is done with the context. cuCtxAttach() fails if there is
    no context current to the thread.

    Currently, the `flags` parameter must be 0.

    Parameters
    ----------
    flags : unsigned int
        Context attach flags (must be 0)

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    pctx : CUcontext
        Returned context handle of the current context

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxDetach
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef CUcontext pctx = CUcontext()
    err = ccuda.cuCtxAttach(pctx._ptr, flags)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuCtxDetach(ctx):
    """ Decrement a context's usage-count.

    Deprecated

    Note that this function is deprecated and should not be used.

    Decrements the usage count of the context `ctx`, and destroys the
    context if the usage count goes to 0. The context must be a handle that
    was passed back by cuCtxCreate() or cuCtxAttach(), and must be current
    to the calling thread.

    Parameters
    ----------
    ctx : Any
        Context to destroy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuCtxCreate
    cuCtxDestroy
    cuCtxGetApiVersion
    cuCtxGetCacheConfig
    cuCtxGetDevice
    cuCtxGetFlags
    cuCtxGetLimit
    cuCtxPopCurrent
    cuCtxPushCurrent
    cuCtxSetCacheConfig
    cuCtxSetLimit
    cuCtxSynchronize
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    err = ccuda.cuCtxDetach(cctx)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuModuleLoad(char* fname):
    """ Loads a compute module.

    Takes a filename `fname` and loads the corresponding module `module`
    into the current context. The CUDA driver API does not attempt to
    lazily allocate the resources needed by a module; if the memory for
    functions and data (constant and global) needed by the module cannot be
    allocated, cuModuleLoad() fails. The file should be a cubin file as
    output by nvcc, or a PTX file either as output by nvcc or handwritten,
    or a fatbin file as output by nvcc from toolchain 4.0 or later.

    Parameters
    ----------
    fname : bytes
        Filename of module to load

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_PTX
        CUDA_ERROR_UNSUPPORTED_PTX_VERSION
        CUDA_ERROR_NOT_FOUND
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_FILE_NOT_FOUND
        CUDA_ERROR_NO_BINARY_FOR_GPU
        CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
        CUDA_ERROR_JIT_COMPILER_NOT_FOUND
    module : CUmodule
        Returned module

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    cuModuleUnload
    """
    cdef CUmodule module = CUmodule()
    err = ccuda.cuModuleLoad(module._ptr, fname)
    return (CUresult(err), module)

@cython.embedsignature(True)
def cuModuleLoadData(image):
    """ Load a module's data.

    Takes a pointer `image` and loads the corresponding module `module`
    into the current context. The pointer may be obtained by mapping a
    cubin or PTX or fatbin file, passing a cubin or PTX or fatbin file as a
    NULL-terminated text string, or incorporating a cubin or fatbin object
    into the executable resources and using operating system calls such as
    Windows `FindResource()` to obtain the pointer.

    Parameters
    ----------
    image : Any
        Module data to load

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_PTX
        CUDA_ERROR_UNSUPPORTED_PTX_VERSION
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NO_BINARY_FOR_GPU
        CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
        CUDA_ERROR_JIT_COMPILER_NOT_FOUND
    module : CUmodule
        Returned module

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    cuModuleUnload
    """
    cdef CUmodule module = CUmodule()
    cimage = utils.HelperInputVoidPtr(image)
    cdef void* cimage_ptr = <void*><void_ptr>cimage.cptr
    err = ccuda.cuModuleLoadData(module._ptr, cimage_ptr)
    return (CUresult(err), module)

@cython.embedsignature(True)
def cuModuleLoadDataEx(image, unsigned int numOptions, options : List[CUjit_option], optionValues : List[Any]):
    """ Load a module's data with options.

    Takes a pointer `image` and loads the corresponding module `module`
    into the current context. The pointer may be obtained by mapping a
    cubin or PTX or fatbin file, passing a cubin or PTX or fatbin file as a
    NULL-terminated text string, or incorporating a cubin or fatbin object
    into the executable resources and using operating system calls such as
    Windows `FindResource()` to obtain the pointer. Options are passed as
    an array via `options` and any corresponding parameters are passed in
    `optionValues`. The number of total options is supplied via
    `numOptions`. Any outputs will be returned via `optionValues`.

    Parameters
    ----------
    image : Any
        Module data to load
    numOptions : unsigned int
        Number of options
    options : List[CUjit_option]
        Options for JIT
    optionValues : List[Any]
        Option values for JIT

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_PTX
        CUDA_ERROR_UNSUPPORTED_PTX_VERSION
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NO_BINARY_FOR_GPU
        CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
        CUDA_ERROR_JIT_COMPILER_NOT_FOUND
    module : CUmodule
        Returned module

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadFatBinary
    cuModuleUnload
    """
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected List[ccuda.CUjit_option]")

    cdef CUmodule module = CUmodule()
    cimage = utils.HelperInputVoidPtr(image)
    cdef void* cimage_ptr = <void*><void_ptr>cimage.cptr
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[ccuda.CUjit_option] coptions = [pyoptions.value for pyoptions in (options)]
    pylist = [utils.HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef utils.InputVoidPtrPtrHelper voidStarHelper = utils.InputVoidPtrPtrHelper(pylist)
    err = ccuda.cuModuleLoadDataEx(module._ptr, cimage_ptr, numOptions, coptions.data(), <void**><void_ptr>voidStarHelper.cptr)
    return (CUresult(err), module)

@cython.embedsignature(True)
def cuModuleLoadFatBinary(fatCubin):
    """ Load a module's data.

    Takes a pointer `fatCubin` and loads the corresponding module `module`
    into the current context. The pointer represents a fat binary object,
    which is a collection of different cubin and/or PTX files, all
    representing the same device code, but compiled and optimized for
    different architectures.

    Prior to CUDA 4.0, there was no documented API for constructing and
    using fat binary objects by programmers. Starting with CUDA 4.0, fat
    binary objects can be constructed by providing the -fatbin option to
    nvcc. More information can be found in the nvcc document.

    Parameters
    ----------
    fatCubin : Any
        Fat binary to load

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_PTX
        CUDA_ERROR_UNSUPPORTED_PTX_VERSION
        CUDA_ERROR_NOT_FOUND
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NO_BINARY_FOR_GPU
        CUDA_ERROR_SHARED_OBJECT_SYMBOL_NOT_FOUND
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
        CUDA_ERROR_JIT_COMPILER_NOT_FOUND
    module : CUmodule
        Returned module

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleUnload
    """
    cdef CUmodule module = CUmodule()
    cfatCubin = utils.HelperInputVoidPtr(fatCubin)
    cdef void* cfatCubin_ptr = <void*><void_ptr>cfatCubin.cptr
    err = ccuda.cuModuleLoadFatBinary(module._ptr, cfatCubin_ptr)
    return (CUresult(err), module)

@cython.embedsignature(True)
def cuModuleUnload(hmod):
    """ Unloads a module.

    Unloads a module `hmod` from the current context.

    Parameters
    ----------
    hmod : Any
        Module to unload

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    """
    cdef ccuda.CUmodule chmod
    if hmod is None:
        chmod = <ccuda.CUmodule><void_ptr>0
    elif isinstance(hmod, (CUmodule)):
        phmod = int(hmod)
        chmod = <ccuda.CUmodule><void_ptr>phmod
    else:
        phmod = int(CUmodule(hmod))
        chmod = <ccuda.CUmodule><void_ptr>phmod

    err = ccuda.cuModuleUnload(chmod)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuModuleGetFunction(hmod, char* name):
    """ Returns a function handle.

    Returns in `*hfunc` the handle of the function of name `name` located
    in module `hmod`. If no function of that name exists,
    cuModuleGetFunction() returns CUDA_ERROR_NOT_FOUND.

    Parameters
    ----------
    hmod : Any
        Module to retrieve function from
    name : bytes
        Name of function to retrieve

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_FOUND
    hfunc : CUfunction
        Returned function handle

    See Also
    --------
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    cuModuleUnload
    """
    cdef ccuda.CUmodule chmod
    if hmod is None:
        chmod = <ccuda.CUmodule><void_ptr>0
    elif isinstance(hmod, (CUmodule)):
        phmod = int(hmod)
        chmod = <ccuda.CUmodule><void_ptr>phmod
    else:
        phmod = int(CUmodule(hmod))
        chmod = <ccuda.CUmodule><void_ptr>phmod

    cdef CUfunction hfunc = CUfunction()
    err = ccuda.cuModuleGetFunction(hfunc._ptr, chmod, name)
    return (CUresult(err), hfunc)

@cython.embedsignature(True)
def cuModuleGetGlobal(hmod, char* name):
    """ Returns a global pointer from a module.

    Returns in `*dptr` and `*bytes` the base pointer and size of the global
    of name `name` located in module `hmod`. If no variable of that name
    exists, cuModuleGetGlobal() returns CUDA_ERROR_NOT_FOUND. Both
    parameters `dptr` and `numbytes` are optional. If one of them is NULL,
    it is ignored.

    Parameters
    ----------
    hmod : Any
        Module to retrieve global from
    name : bytes
        Name of global to retrieve

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_FOUND
    dptr : CUdeviceptr
        Returned global device pointer
    numbytes : int
        Returned global size in bytes

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    cuModuleUnload
    cudaGetSymbolAddress
    cudaGetSymbolSize
    """
    cdef ccuda.CUmodule chmod
    if hmod is None:
        chmod = <ccuda.CUmodule><void_ptr>0
    elif isinstance(hmod, (CUmodule)):
        phmod = int(hmod)
        chmod = <ccuda.CUmodule><void_ptr>phmod
    else:
        phmod = int(CUmodule(hmod))
        chmod = <ccuda.CUmodule><void_ptr>phmod

    cdef CUdeviceptr dptr = CUdeviceptr()
    cdef size_t numbytes = 0
    err = ccuda.cuModuleGetGlobal(dptr._ptr, &numbytes, chmod, name)
    return (CUresult(err), dptr, numbytes)

@cython.embedsignature(True)
def cuModuleGetTexRef(hmod, char* name):
    """ Returns a handle to a texture reference.

    Returns in `*pTexRef` the handle of the texture reference of name
    `name` in the module `hmod`. If no texture reference of that name
    exists, cuModuleGetTexRef() returns CUDA_ERROR_NOT_FOUND. This texture
    reference handle should not be destroyed, since it will be destroyed
    when the module is unloaded.

    Parameters
    ----------
    hmod : Any
        Module to retrieve texture reference from
    name : bytes
        Name of texture reference to retrieve

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_FOUND
    pTexRef : CUtexref
        Returned texture reference

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetSurfRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    cuModuleUnload
    cudaGetTextureReference
    """
    cdef ccuda.CUmodule chmod
    if hmod is None:
        chmod = <ccuda.CUmodule><void_ptr>0
    elif isinstance(hmod, (CUmodule)):
        phmod = int(hmod)
        chmod = <ccuda.CUmodule><void_ptr>phmod
    else:
        phmod = int(CUmodule(hmod))
        chmod = <ccuda.CUmodule><void_ptr>phmod

    cdef CUtexref pTexRef = CUtexref()
    err = ccuda.cuModuleGetTexRef(pTexRef._ptr, chmod, name)
    return (CUresult(err), pTexRef)

@cython.embedsignature(True)
def cuModuleGetSurfRef(hmod, char* name):
    """ Returns a handle to a surface reference.

    Returns in `*pSurfRef` the handle of the surface reference of name
    `name` in the module `hmod`. If no surface reference of that name
    exists, cuModuleGetSurfRef() returns CUDA_ERROR_NOT_FOUND.

    Parameters
    ----------
    hmod : Any
        Module to retrieve surface reference from
    name : bytes
        Name of surface reference to retrieve

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_FOUND
    pSurfRef : CUsurfref
        Returned surface reference

    See Also
    --------
    cuModuleGetFunction
    cuModuleGetGlobal
    cuModuleGetTexRef
    cuModuleLoad
    cuModuleLoadData
    cuModuleLoadDataEx
    cuModuleLoadFatBinary
    cuModuleUnload
    cudaGetSurfaceReference
    """
    cdef ccuda.CUmodule chmod
    if hmod is None:
        chmod = <ccuda.CUmodule><void_ptr>0
    elif isinstance(hmod, (CUmodule)):
        phmod = int(hmod)
        chmod = <ccuda.CUmodule><void_ptr>phmod
    else:
        phmod = int(CUmodule(hmod))
        chmod = <ccuda.CUmodule><void_ptr>phmod

    cdef CUsurfref pSurfRef = CUsurfref()
    err = ccuda.cuModuleGetSurfRef(pSurfRef._ptr, chmod, name)
    return (CUresult(err), pSurfRef)

@cython.embedsignature(True)
def cuLinkCreate(unsigned int numOptions, options : List[CUjit_option], optionValues : List[Any]):
    """ Creates a pending JIT linker invocation.

    If the call is successful, the caller owns the returned CUlinkState,
    which should eventually be destroyed with cuLinkDestroy. The device
    code machine size (32 or 64 bit) will match the calling application.

    Both linker and compiler options may be specified. Compiler options
    will be applied to inputs to this linker action which must be compiled
    from PTX. The options CU_JIT_WALL_TIME,
    CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES, and
    CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES will accumulate data until the
    CUlinkState is destroyed.

    `optionValues` must remain valid for the life of the CUlinkState if
    output options are used. No other references to inputs are maintained
    after this call returns.

    Parameters
    ----------
    numOptions : unsigned int
        Size of options arrays
    options : List[CUjit_option]
        Array of linker and compiler options
    optionValues : List[Any]
        Array of option values, each cast to void *

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_JIT_COMPILER_NOT_FOUND
    stateOut : CUlinkState
        On success, this will contain a CUlinkState to specify and complete
        this action

    See Also
    --------
    cuLinkAddData
    cuLinkAddFile
    cuLinkComplete
    cuLinkDestroy
    """
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected List[ccuda.CUjit_option]")

    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[ccuda.CUjit_option] coptions = [pyoptions.value for pyoptions in (options)]
    pylist = [utils.HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef utils.InputVoidPtrPtrHelper voidStarHelper = utils.InputVoidPtrPtrHelper(pylist)
    cdef CUlinkState stateOut = CUlinkState()
    err = ccuda.cuLinkCreate(numOptions, coptions.data(), <void**><void_ptr>voidStarHelper.cptr, stateOut._ptr)
    stateOut._keepalive.append(voidStarHelper)
    for option in pylist:
        stateOut._keepalive.append(option)
    return (CUresult(err), stateOut)

@cython.embedsignature(True)
def cuLinkAddData(state, typename not None : CUjitInputType, data, size_t size, char* name, unsigned int numOptions, options : List[CUjit_option], optionValues : List[Any]):
    """ Add an input to a pending linker invocation.

    Ownership of `data` is retained by the caller. No reference is retained
    to any inputs after this call returns.

    This method accepts only compiler options, which are used if the data
    must be compiled from PTX, and does not accept any of CU_JIT_WALL_TIME,
    CU_JIT_INFO_LOG_BUFFER, CU_JIT_ERROR_LOG_BUFFER,
    CU_JIT_TARGET_FROM_CUCONTEXT, or CU_JIT_TARGET.

    Parameters
    ----------
    state : Any
        A pending linker action.
    typename : CUjitInputType
        The type of the input data.
    data : Any
        The input data. PTX must be NULL-terminated.
    size : size_t
        The length of the input data.
    name : bytes
        An optional name for this input in log messages.
    numOptions : unsigned int
        Size of options.
    options : List[CUjit_option]
        Options to be applied only for this input (overrides options from
        cuLinkCreate).
    optionValues : List[Any]
        Array of option values, each cast to void *.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_IMAGE
        CUDA_ERROR_INVALID_PTX
        CUDA_ERROR_UNSUPPORTED_PTX_VERSION
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NO_BINARY_FOR_GPU
    None
        None

    See Also
    --------
    cuLinkCreate
    cuLinkAddFile
    cuLinkComplete
    cuLinkDestroy
    """
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected List[ccuda.CUjit_option]")

    cdef ccuda.CUlinkState cstate
    if state is None:
        cstate = <ccuda.CUlinkState><void_ptr>0
    elif isinstance(state, (CUlinkState)):
        pstate = int(state)
        cstate = <ccuda.CUlinkState><void_ptr>pstate
    else:
        pstate = int(CUlinkState(state))
        cstate = <ccuda.CUlinkState><void_ptr>pstate

    cdef ccuda.CUjitInputType ctypename = typename.value
    cdata = utils.HelperInputVoidPtr(data)
    cdef void* cdata_ptr = <void*><void_ptr>cdata.cptr
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[ccuda.CUjit_option] coptions = [pyoptions.value for pyoptions in (options)]
    pylist = [utils.HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef utils.InputVoidPtrPtrHelper voidStarHelper = utils.InputVoidPtrPtrHelper(pylist)
    err = ccuda.cuLinkAddData(cstate, ctypename, cdata_ptr, size, name, numOptions, coptions.data(), <void**><void_ptr>voidStarHelper.cptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLinkAddFile(state, typename not None : CUjitInputType, char* path, unsigned int numOptions, options : List[CUjit_option], optionValues : List[Any]):
    """ Add a file input to a pending linker invocation.

    No reference is retained to any inputs after this call returns.

    This method accepts only compiler options, which are used if the input
    must be compiled from PTX, and does not accept any of CU_JIT_WALL_TIME,
    CU_JIT_INFO_LOG_BUFFER, CU_JIT_ERROR_LOG_BUFFER,
    CU_JIT_TARGET_FROM_CUCONTEXT, or CU_JIT_TARGET.

    This method is equivalent to invoking cuLinkAddData on the contents of
    the file.

    Parameters
    ----------
    state : Any
        A pending linker action
    typename : CUjitInputType
        The type of the input data
    path : bytes
        Path to the input file
    numOptions : unsigned int
        Size of options
    options : List[CUjit_option]
        Options to be applied only for this input (overrides options from
        cuLinkCreate)
    optionValues : List[Any]
        Array of option values, each cast to void *

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_FILE_NOT_FOUND
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_IMAGE
        CUDA_ERROR_INVALID_PTX
        CUDA_ERROR_UNSUPPORTED_PTX_VERSION
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NO_BINARY_FOR_GPU
    None
        None

    See Also
    --------
    cuLinkCreate
    cuLinkAddData
    cuLinkComplete
    cuLinkDestroy
    """
    options = [] if options is None else options
    if not all(isinstance(_x, (CUjit_option)) for _x in options):
        raise TypeError("Argument 'options' is not instance of type (expected List[ccuda.CUjit_option]")

    cdef ccuda.CUlinkState cstate
    if state is None:
        cstate = <ccuda.CUlinkState><void_ptr>0
    elif isinstance(state, (CUlinkState)):
        pstate = int(state)
        cstate = <ccuda.CUlinkState><void_ptr>pstate
    else:
        pstate = int(CUlinkState(state))
        cstate = <ccuda.CUlinkState><void_ptr>pstate

    cdef ccuda.CUjitInputType ctypename = typename.value
    if numOptions > len(options): raise RuntimeError("List is too small: " + str(len(options)) + " < " + str(numOptions))
    if numOptions > len(optionValues): raise RuntimeError("List is too small: " + str(len(optionValues)) + " < " + str(numOptions))
    cdef vector[ccuda.CUjit_option] coptions = [pyoptions.value for pyoptions in (options)]
    pylist = [utils.HelperCUjit_option(pyoptions, pyoptionValues) for pyoptions, pyoptionValues in zip(options, optionValues)]
    cdef utils.InputVoidPtrPtrHelper voidStarHelper = utils.InputVoidPtrPtrHelper(pylist)
    err = ccuda.cuLinkAddFile(cstate, ctypename, path, numOptions, coptions.data(), <void**><void_ptr>voidStarHelper.cptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLinkComplete(state):
    """ Complete a pending linker invocation.

    Completes the pending linker action and returns the cubin image for the
    linked device code, which can be used with cuModuleLoadData. The cubin
    is owned by `state`, so it should be loaded before `state` is destroyed
    via cuLinkDestroy. This call does not destroy `state`.

    Parameters
    ----------
    state : Any
        A pending linker invocation

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    cubinOut : int
        On success, this will point to the output image
    sizeOut : int
        Optional parameter to receive the size of the generated image

    See Also
    --------
    cuLinkCreate
    cuLinkAddData
    cuLinkAddFile
    cuLinkDestroy
    cuModuleLoadData
    """
    cdef ccuda.CUlinkState cstate
    if state is None:
        cstate = <ccuda.CUlinkState><void_ptr>0
    elif isinstance(state, (CUlinkState)):
        pstate = int(state)
        cstate = <ccuda.CUlinkState><void_ptr>pstate
    else:
        pstate = int(CUlinkState(state))
        cstate = <ccuda.CUlinkState><void_ptr>pstate

    cdef void_ptr cubinOut = 0
    cdef size_t sizeOut = 0
    err = ccuda.cuLinkComplete(cstate, <void**>&cubinOut, &sizeOut)
    return (CUresult(err), cubinOut, sizeOut)

@cython.embedsignature(True)
def cuLinkDestroy(state):
    """ Destroys state for a JIT linker invocation.

    Parameters
    ----------
    state : Any
        State object for the linker invocation

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuLinkCreate
    """
    cdef ccuda.CUlinkState cstate
    if state is None:
        cstate = <ccuda.CUlinkState><void_ptr>0
    elif isinstance(state, (CUlinkState)):
        pstate = int(state)
        cstate = <ccuda.CUlinkState><void_ptr>pstate
    else:
        pstate = int(CUlinkState(state))
        cstate = <ccuda.CUlinkState><void_ptr>pstate

    err = ccuda.cuLinkDestroy(cstate)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemGetInfo():
    """ Gets free and total memory.

    Returns in `*total` the total amount of memory available to the the
    current context. Returns in `*free` the amount of memory on the device
    that is free according to the OS. CUDA is not guaranteed to be able to
    allocate all of the memory that the OS reports as free. In a multi-
    tenet situation, free estimate returned is prone to race condition
    where a new allocation/free done by a different process or a different
    thread in the same process between the time when free memory was
    estimated and reported, will result in deviation in free value reported
    and actual free memory.

    The integrated GPU on Tegra shares memory with CPU and other component
    of the SoC. The free and total values returned by the API excludes the
    SWAP memory space maintained by the OS on some platforms. The OS may
    move some of the memory pages into swap area as the GPU or CPU allocate
    or access memory. See Tegra app note on how to calculate total and free
    memory on Tegra.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    free : int
        Returned free memory in bytes
    total : int
        Returned total memory in bytes

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemGetInfo
    """
    cdef size_t free = 0
    cdef size_t total = 0
    err = ccuda.cuMemGetInfo(&free, &total)
    return (CUresult(err), free, total)

@cython.embedsignature(True)
def cuMemAlloc(size_t bytesize):
    """ Allocates device memory.

    Allocates `bytesize` bytes of linear memory on the device and returns
    in `*dptr` a pointer to the allocated memory. The allocated memory is
    suitably aligned for any kind of variable. The memory is not cleared.
    If `bytesize` is 0, cuMemAlloc() returns CUDA_ERROR_INVALID_VALUE.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    dptr : CUdeviceptr
        Returned device pointer

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMalloc
    """
    cdef CUdeviceptr dptr = CUdeviceptr()
    err = ccuda.cuMemAlloc(dptr._ptr, bytesize)
    return (CUresult(err), dptr)

@cython.embedsignature(True)
def cuMemAllocPitch(size_t WidthInBytes, size_t Height, unsigned int ElementSizeBytes):
    """ Allocates pitched device memory.

    Allocates at least `WidthInBytes` * `Height` bytes of linear memory on
    the device and returns in `*dptr` a pointer to the allocated memory.
    The function may pad the allocation to ensure that corresponding
    pointers in any given row will continue to meet the alignment
    requirements for coalescing as the address is updated from row to row.
    `ElementSizeBytes` specifies the size of the largest reads and writes
    that will be performed on the memory range. `ElementSizeBytes` may be
    4, 8 or 16 (since coalesced memory transactions are not possible on
    other data sizes). If `ElementSizeBytes` is smaller than the actual
    read/write size of a kernel, the kernel will run correctly, but
    possibly at reduced speed. The pitch returned in `*pPitch` by
    cuMemAllocPitch() is the width in bytes of the allocation. The intended
    usage of pitch is as a separate parameter of the allocation, used to
    compute addresses within the 2D array. Given the row and column of an
    array element of type T, the address is computed as:
    T*pElement=(T*)((char*)BaseAddress+Row*Pitch)+Column;

    The pitch returned by cuMemAllocPitch() is guaranteed to work with
    cuMemcpy2D() under all circumstances. For allocations of 2D arrays, it
    is recommended that programmers consider performing pitch allocations
    using cuMemAllocPitch(). Due to alignment restrictions in the hardware,
    this is especially true if the application will be performing 2D memory
    copies between different regions of device memory (whether linear
    memory or CUDA arrays).

    The byte alignment of the pitch returned by cuMemAllocPitch() is
    guaranteed to match or exceed the alignment requirement for texture
    binding with cuTexRefSetAddress2D().

    Parameters
    ----------
    WidthInBytes : size_t
        Requested allocation width in bytes
    Height : size_t
        Requested allocation height in rows
    ElementSizeBytes : unsigned int
        Size of largest reads/writes for range

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    dptr : CUdeviceptr
        Returned device pointer
    pPitch : int
        Returned pitch of allocation in bytes

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMallocPitch
    """
    cdef CUdeviceptr dptr = CUdeviceptr()
    cdef size_t pPitch = 0
    err = ccuda.cuMemAllocPitch(dptr._ptr, &pPitch, WidthInBytes, Height, ElementSizeBytes)
    return (CUresult(err), dptr, pPitch)

@cython.embedsignature(True)
def cuMemFree(dptr):
    """ Frees device memory.

    Frees the memory space pointed to by `dptr`, which must have been
    returned by a previous call to cuMemAlloc() or cuMemAllocPitch().

    Parameters
    ----------
    dptr : Any
        Pointer to memory to free

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaFree
    """
    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    err = ccuda.cuMemFree(cdptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemGetAddressRange(dptr):
    """ Get information on memory allocations.

    Returns the base address in `*pbase` and size in `*psize` of the
    allocation by cuMemAlloc() or cuMemAllocPitch() that contains the input
    pointer `dptr`. Both parameters `pbase` and `psize` are optional. If
    one of them is NULL, it is ignored.

    Parameters
    ----------
    dptr : Any
        Device pointer to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_NOT_FOUND
        CUDA_ERROR_INVALID_VALUE
    pbase : CUdeviceptr
        Returned base address
    psize : int
        Returned size of device memory allocation

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    """
    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    cdef CUdeviceptr pbase = CUdeviceptr()
    cdef size_t psize = 0
    err = ccuda.cuMemGetAddressRange(pbase._ptr, &psize, cdptr)
    return (CUresult(err), pbase, psize)

@cython.embedsignature(True)
def cuMemAllocHost(size_t bytesize):
    """ Allocates page-locked host memory.

    Allocates `bytesize` bytes of host memory that is page-locked and
    accessible to the device. The driver tracks the virtual memory ranges
    allocated with this function and automatically accelerates calls to
    functions such as cuMemcpy(). Since the memory can be accessed directly
    by the device, it can be read or written with much higher bandwidth
    than pageable memory obtained with functions such as malloc().
    Allocating excessive amounts of memory with cuMemAllocHost() may
    degrade system performance, since it reduces the amount of memory
    available to the system for paging. As a result, this function is best
    used sparingly to allocate staging areas for data exchange between host
    and device.

    Note all host memory allocated using cuMemHostAlloc() will
    automatically be immediately accessible to all contexts on all devices
    which support unified addressing (as may be queried using
    CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING). The device pointer that may be
    used to access this host memory from those contexts is always equal to
    the returned host pointer `*pp`. See Unified Addressing for additional
    details.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    pp : int
        Returned host pointer to page-locked memory

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMallocHost
    """
    cdef void_ptr pp = 0
    err = ccuda.cuMemAllocHost(<void**>&pp, bytesize)
    return (CUresult(err), pp)

@cython.embedsignature(True)
def cuMemFreeHost(p):
    """ Frees page-locked host memory.

    Frees the memory space pointed to by `p`, which must have been returned
    by a previous call to cuMemAllocHost().

    Parameters
    ----------
    p : Any
        Pointer to memory to free

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaFreeHost
    """
    cp = utils.HelperInputVoidPtr(p)
    cdef void* cp_ptr = <void*><void_ptr>cp.cptr
    err = ccuda.cuMemFreeHost(cp_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemHostAlloc(size_t bytesize, unsigned int Flags):
    """ Allocates page-locked host memory.

    Allocates `bytesize` bytes of host memory that is page-locked and
    accessible to the device. The driver tracks the virtual memory ranges
    allocated with this function and automatically accelerates calls to
    functions such as cuMemcpyHtoD(). Since the memory can be accessed
    directly by the device, it can be read or written with much higher
    bandwidth than pageable memory obtained with functions such as
    malloc(). Allocating excessive amounts of pinned memory may degrade
    system performance, since it reduces the amount of memory available to
    the system for paging. As a result, this function is best used
    sparingly to allocate staging areas for data exchange between host and
    device.

    The `Flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - CU_MEMHOSTALLOC_PORTABLE: The memory returned by this call will be
    considered as pinned memory by all CUDA contexts, not just the one that
    performed the allocation.    - CU_MEMHOSTALLOC_DEVICEMAP: Maps the
    allocation into the CUDA address space. The device pointer to the
    memory may be obtained by calling cuMemHostGetDevicePointer().    -
    CU_MEMHOSTALLOC_WRITECOMBINED: Allocates the memory as write-combined
    (WC). WC memory can be transferred across the PCI Express bus more
    quickly on some system configurations, but cannot be read efficiently
    by most CPUs. WC memory is a good option for buffers that will be
    written by the CPU and read by the GPU via mapped pinned memory or
    host->device transfers.

    All of these flags are orthogonal to one another: a developer may
    allocate memory that is portable, mapped and/or write-combined with no
    restrictions.

    The CU_MEMHOSTALLOC_DEVICEMAP flag may be specified on CUDA contexts
    for devices that do not support mapped pinned memory. The failure is
    deferred to cuMemHostGetDevicePointer() because the memory may be
    mapped into other CUDA contexts via the CU_MEMHOSTALLOC_PORTABLE flag.

    The memory allocated by this function must be freed with
    cuMemFreeHost().

    Note all host memory allocated using cuMemHostAlloc() will
    automatically be immediately accessible to all contexts on all devices
    which support unified addressing (as may be queried using
    CU_DEVICE_ATTRIBUTE_UNIFIED_ADDRESSING). Unless the flag
    CU_MEMHOSTALLOC_WRITECOMBINED is specified, the device pointer that may
    be used to access this host memory from those contexts is always equal
    to the returned host pointer `*pp`. If the flag
    CU_MEMHOSTALLOC_WRITECOMBINED is specified, then the function
    cuMemHostGetDevicePointer() must be used to query the device pointer,
    even if the context supports unified addressing. See Unified Addressing
    for additional details.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes
    Flags : unsigned int
        Flags for allocation request

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    pp : int
        Returned host pointer to page-locked memory

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaHostAlloc
    """
    cdef void_ptr pp = 0
    err = ccuda.cuMemHostAlloc(<void**>&pp, bytesize, Flags)
    return (CUresult(err), pp)

@cython.embedsignature(True)
def cuMemHostGetDevicePointer(p, unsigned int Flags):
    """ Passes back device pointer of mapped pinned memory.

    Passes back the device pointer `pdptr` corresponding to the mapped,
    pinned host buffer `p` allocated by cuMemHostAlloc.

    cuMemHostGetDevicePointer() will fail if the CU_MEMHOSTALLOC_DEVICEMAP
    flag was not specified at the time the memory was allocated, or if the
    function is called on a GPU that does not support mapped pinned memory.

    For devices that have a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM, the memory
    can also be accessed from the device using the host pointer `p`. The
    device pointer returned by cuMemHostGetDevicePointer() may or may not
    match the original host pointer `p` and depends on the devices visible
    to the application. If all devices visible to the application have a
    non-zero value for the device attribute, the device pointer returned by
    cuMemHostGetDevicePointer() will match the original pointer `p`. If any
    device visible to the application has a zero value for the device
    attribute, the device pointer returned by cuMemHostGetDevicePointer()
    will not match the original host pointer `p`, but it will be suitable
    for use on all devices provided Unified Virtual Addressing is enabled.
    In such systems, it is valid to access the memory using either pointer
    on devices that have a non-zero value for the device attribute. Note
    however that such devices should access the memory using only one of
    the two pointers and not both.

    `Flags` provides for future releases. For now, it must be set to 0.

    Parameters
    ----------
    p : Any
        Host pointer
    Flags : unsigned int
        Options (must be 0)

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    pdptr : CUdeviceptr
        Returned device pointer

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaHostGetDevicePointer
    """
    cdef CUdeviceptr pdptr = CUdeviceptr()
    cp = utils.HelperInputVoidPtr(p)
    cdef void* cp_ptr = <void*><void_ptr>cp.cptr
    err = ccuda.cuMemHostGetDevicePointer(pdptr._ptr, cp_ptr, Flags)
    return (CUresult(err), pdptr)

@cython.embedsignature(True)
def cuMemHostGetFlags(p):
    """ Passes back flags that were used for a pinned allocation.

    Passes back the flags `pFlags` that were specified when allocating the
    pinned host buffer `p` allocated by cuMemHostAlloc.

    cuMemHostGetFlags() will fail if the pointer does not reside in an
    allocation performed by cuMemAllocHost() or cuMemHostAlloc().

    Parameters
    ----------
    p : Any
        Host pointer

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    pFlags : unsigned int
        Returned flags word

    See Also
    --------
    cuMemAllocHost
    cuMemHostAlloc
    cudaHostGetFlags
    """
    cdef unsigned int pFlags = 0
    cp = utils.HelperInputVoidPtr(p)
    cdef void* cp_ptr = <void*><void_ptr>cp.cptr
    err = ccuda.cuMemHostGetFlags(&pFlags, cp_ptr)
    return (CUresult(err), pFlags)

@cython.embedsignature(True)
def cuMemAllocManaged(size_t bytesize, unsigned int flags):
    """ Allocates memory that will be automatically managed by the Unified Memory system.

    Allocates `bytesize` bytes of managed memory on the device and returns
    in `*dptr` a pointer to the allocated memory. If the device doesn't
    support allocating managed memory, CUDA_ERROR_NOT_SUPPORTED is
    returned. Support for managed memory can be queried using the device
    attribute CU_DEVICE_ATTRIBUTE_MANAGED_MEMORY. The allocated memory is
    suitably aligned for any kind of variable. The memory is not cleared.
    If `bytesize` is 0, cuMemAllocManaged returns CUDA_ERROR_INVALID_VALUE.
    The pointer is valid on the CPU and on all GPUs in the system that
    support managed memory. All accesses to this pointer must obey the
    Unified Memory programming model.

    `flags` specifies the default stream association for this allocation.
    `flags` must be one of CU_MEM_ATTACH_GLOBAL or CU_MEM_ATTACH_HOST. If
    CU_MEM_ATTACH_GLOBAL is specified, then this memory is accessible from
    any stream on any device. If CU_MEM_ATTACH_HOST is specified, then the
    allocation should not be accessed from devices that have a zero value
    for the device attribute CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS;
    an explicit call to cuStreamAttachMemAsync will be required to enable
    access on such devices.

    If the association is later changed via cuStreamAttachMemAsync to a
    single stream, the default association as specifed during
    cuMemAllocManaged is restored when that stream is destroyed. For
    managed variables, the default association is always
    CU_MEM_ATTACH_GLOBAL. Note that destroying a stream is an asynchronous
    operation, and as a result, the change to default association won't
    happen until all work in the stream has completed.

    Memory allocated with cuMemAllocManaged should be released with
    cuMemFree.

    Device memory oversubscription is possible for GPUs that have a non-
    zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS. Managed memory on such
    GPUs may be evicted from device memory to host memory at any time by
    the Unified Memory driver in order to make room for other allocations.

    In a multi-GPU system where all GPUs have a non-zero value for the
    device attribute CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS, managed
    memory may not be populated when this API returns and instead may be
    populated on access. In such systems, managed memory can migrate to any
    processor's memory at any time. The Unified Memory driver will employ
    heuristics to maintain data locality and prevent excessive page faults
    to the extent possible. The application can also guide the driver about
    memory usage patterns via cuMemAdvise. The application can also
    explicitly migrate memory to a desired processor's memory via
    cuMemPrefetchAsync.

    In a multi-GPU system where all of the GPUs have a zero value for the
    device attribute CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS and all
    the GPUs have peer-to-peer support with each other, the physical
    storage for managed memory is created on the GPU which is active at the
    time cuMemAllocManaged is called. All other GPUs will reference the
    data at reduced bandwidth via peer mappings over the PCIe bus. The
    Unified Memory driver does not migrate memory among such GPUs.

    In a multi-GPU system where not all GPUs have peer-to-peer support with
    each other and where the value of the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS is zero for at least one
    of those GPUs, the location chosen for physical storage of managed
    memory is system-dependent. - On Linux, the location chosen will be
    device memory as long as the current set of active contexts are on
    devices that either have peer-to-peer support with each other or have a
    non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS. If there is an active
    context on a GPU that does not have a non-zero value for that device
    attribute and it does not have peer-to-peer support with the other
    devices that have active contexts on them, then the location for
    physical storage will be 'zero-copy' or host memory. Note that this
    means that managed memory that is located in device memory is migrated
    to host memory if a new context is created on a GPU that doesn't have a
    non-zero value for the device attribute and does not support peer-to-
    peer with at least one of the other devices that has an active context.
    This in turn implies that context creation may fail if there is
    insufficient host memory to migrate all managed allocations.    - On
    Windows, the physical storage is always created in 'zero-copy' or host
    memory. All GPUs will reference the data at reduced bandwidth over the
    PCIe bus. In these circumstances, use of the environment variable
    CUDA_VISIBLE_DEVICES is recommended to restrict CUDA to only use those
    GPUs that have peer-to-peer support. Alternatively, users can also set
    CUDA_MANAGED_FORCE_DEVICE_ALLOC to a non-zero value to force the driver
    to always use device memory for physical storage. When this environment
    variable is set to a non-zero value, all contexts created in that
    process on devices that support managed memory have to be peer-to-peer
    compatible with each other. Context creation will fail if a context is
    created on a device that supports managed memory and is not peer-to-
    peer compatible with any of the other managed memory supporting devices
    on which contexts were previously created, even if those contexts have
    been destroyed. These environment variables are described in the CUDA
    programming guide under the "CUDA environment variables" section.    -
    On ARM, managed memory is not available on discrete gpu with Drive
    PX-2.

    Parameters
    ----------
    bytesize : size_t
        Requested allocation size in bytes
    flags : unsigned int
        Must be one of CU_MEM_ATTACH_GLOBAL or CU_MEM_ATTACH_HOST

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    dptr : CUdeviceptr
        Returned device pointer

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cuDeviceGetAttribute
    cuStreamAttachMemAsync
    cudaMallocManaged
    """
    cdef CUdeviceptr dptr = CUdeviceptr()
    err = ccuda.cuMemAllocManaged(dptr._ptr, bytesize, flags)
    return (CUresult(err), dptr)

@cython.embedsignature(True)
def cuDeviceGetByPCIBusId(char* pciBusId):
    """ Returns a handle to a compute device.

    Returns in `*device` a device handle given a PCI bus ID string.

    Parameters
    ----------
    pciBusId : bytes
        String in one of the following forms:

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    dev : CUdevice
        Returned device handle

    See Also
    --------
    cuDeviceGet
    cuDeviceGetAttribute
    cuDeviceGetPCIBusId
    cudaDeviceGetByPCIBusId
    """
    cdef CUdevice dev = CUdevice()
    err = ccuda.cuDeviceGetByPCIBusId(dev._ptr, pciBusId)
    return (CUresult(err), dev)

@cython.embedsignature(True)
def cuDeviceGetPCIBusId(int length, dev):
    """ Returns a PCI Bus Id string for the device.

    Returns an ASCII string identifying the device `dev` in the NULL-
    terminated string pointed to by `pciBusId`. `length` specifies the
    maximum length of the string that may be returned.

    Parameters
    ----------
    length : int
        Maximum length of string to store in `name`
    dev : Any
        Device to get identifier string for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    pciBusId : bytes
        Returned identifier string for the device in the following format

    See Also
    --------
    cuDeviceGet
    cuDeviceGetAttribute
    cuDeviceGetByPCIBusId
    cudaDeviceGetPCIBusId
    """
    cdef ccuda.CUdevice cdev
    if dev is None:
        cdev = <ccuda.CUdevice>0
    elif isinstance(dev, (CUdevice)):
        pdev = int(dev)
        cdev = <ccuda.CUdevice>pdev
    else:
        pdev = int(CUdevice(dev))
        cdev = <ccuda.CUdevice>pdev

    pypciBusId = b" " * length
    cdef char* pciBusId = pypciBusId
    err = ccuda.cuDeviceGetPCIBusId(pciBusId, length, cdev)
    return (CUresult(err), pypciBusId)

@cython.embedsignature(True)
def cuIpcGetEventHandle(event):
    """ Gets an interprocess handle for a previously allocated event.

    Takes as input a previously allocated event. This event must have been
    created with the CU_EVENT_INTERPROCESS and CU_EVENT_DISABLE_TIMING
    flags set. This opaque handle may be copied into other processes and
    opened with cuIpcOpenEventHandle to allow efficient hardware
    synchronization between GPU work in different processes.

    After the event has been opened in the importing process,
    cuEventRecord, cuEventSynchronize, cuStreamWaitEvent and cuEventQuery
    may be used in either process. Performing operations on the imported
    event after the exported event has been freed with cuEventDestroy will
    result in undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is restricted to GPUs in TCC mode

    Parameters
    ----------
    event : CUevent or cudaEvent_t
        Event allocated with CU_EVENT_INTERPROCESS and
        CU_EVENT_DISABLE_TIMING flags.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_MAP_FAILED
        CUDA_ERROR_INVALID_VALUE
    pHandle : CUipcEventHandle
        Pointer to a user allocated CUipcEventHandle in which to return the
        opaque event handle

    See Also
    --------
    cuEventCreate
    cuEventDestroy
    cuEventSynchronize
    cuEventQuery
    cuStreamWaitEvent
    cuIpcOpenEventHandle
    cuIpcGetMemHandle
    cuIpcOpenMemHandle
    cuIpcCloseMemHandle
    cudaIpcGetEventHandle
    """
    cdef ccuda.CUevent cevent
    if event is None:
        cevent = <ccuda.CUevent><void_ptr>0
    elif isinstance(event, (CUevent)):
        pevent = int(event)
        cevent = <ccuda.CUevent><void_ptr>pevent
    else:
        pevent = int(CUevent(event))
        cevent = <ccuda.CUevent><void_ptr>pevent

    cdef CUipcEventHandle pHandle = CUipcEventHandle()
    err = ccuda.cuIpcGetEventHandle(pHandle._ptr, cevent)
    return (CUresult(err), pHandle)

@cython.embedsignature(True)
def cuIpcOpenEventHandle(handle not None : CUipcEventHandle):
    """ Opens an interprocess event handle for use in the current process.

    Opens an interprocess event handle exported from another process with
    cuIpcGetEventHandle. This function returns a CUevent that behaves like
    a locally created event with the CU_EVENT_DISABLE_TIMING flag
    specified. This event must be freed with cuEventDestroy.

    Performing operations on the imported event after the exported event
    has been freed with cuEventDestroy will result in undefined behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is restricted to GPUs in TCC mode

    Parameters
    ----------
    handle : CUipcEventHandle
        Interprocess handle to open

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_MAP_FAILED
        CUDA_ERROR_PEER_ACCESS_UNSUPPORTED
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    phEvent : CUevent
        Returns the imported event

    See Also
    --------
    cuEventCreate
    cuEventDestroy
    cuEventSynchronize
    cuEventQuery
    cuStreamWaitEvent
    cuIpcGetEventHandle
    cuIpcGetMemHandle
    cuIpcOpenMemHandle
    cuIpcCloseMemHandle
    cudaIpcOpenEventHandle
    """
    cdef CUevent phEvent = CUevent()
    err = ccuda.cuIpcOpenEventHandle(phEvent._ptr, handle._ptr[0])
    return (CUresult(err), phEvent)

@cython.embedsignature(True)
def cuIpcGetMemHandle(dptr):
    """ Gets an interprocess memory handle for an existing device memory allocation.

    Takes a pointer to the base of an existing device memory allocation
    created with cuMemAlloc and exports it for use in another process. This
    is a lightweight operation and may be called multiple times on an
    allocation without adverse effects.

    If a region of memory is freed with cuMemFree and a subsequent call to
    cuMemAlloc returns memory with the same device address,
    cuIpcGetMemHandle will return a unique handle for the new memory.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is restricted to GPUs in TCC mode

    Parameters
    ----------
    dptr : Any
        Base pointer to previously allocated device memory

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_MAP_FAILED
        CUDA_ERROR_INVALID_VALUE
    pHandle : CUipcMemHandle
        Pointer to user allocated CUipcMemHandle to return the handle in.

    See Also
    --------
    cuMemAlloc
    cuMemFree
    cuIpcGetEventHandle
    cuIpcOpenEventHandle
    cuIpcOpenMemHandle
    cuIpcCloseMemHandle
    cudaIpcGetMemHandle
    """
    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    cdef CUipcMemHandle pHandle = CUipcMemHandle()
    err = ccuda.cuIpcGetMemHandle(pHandle._ptr, cdptr)
    return (CUresult(err), pHandle)

@cython.embedsignature(True)
def cuIpcOpenMemHandle(handle not None : CUipcMemHandle, unsigned int Flags):
    """ Opens an interprocess memory handle exported from another process and returns a device pointer usable in the local process.

    Maps memory exported from another process with cuIpcGetMemHandle into
    the current device address space. For contexts on different devices
    cuIpcOpenMemHandle can attempt to enable peer access between the
    devices as if the user called cuCtxEnablePeerAccess. This behavior is
    controlled by the CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS flag.
    cuDeviceCanAccessPeer can determine if a mapping is possible.

    Contexts that may open CUipcMemHandles are restricted in the following
    way. CUipcMemHandles from each CUdevice in a given process may only be
    opened by one CUcontext per CUdevice per other process.

    If the memory handle has already been opened by the current context,
    the reference count on the handle is incremented by 1 and the existing
    device pointer is returned.

    Memory returned from cuIpcOpenMemHandle must be freed with
    cuIpcCloseMemHandle.

    Calling cuMemFree on an exported memory region before calling
    cuIpcCloseMemHandle in the importing context will result in undefined
    behavior.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is restricted to GPUs in TCC mode

    Parameters
    ----------
    handle : CUipcMemHandle
        ::CUipcMemHandle to open
    Flags : unsigned int
        Flags for this operation. Must be specified as
        CU_IPC_MEM_LAZY_ENABLE_PEER_ACCESS

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_MAP_FAILED
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_TOO_MANY_PEERS
        CUDA_ERROR_INVALID_VALUE
    pdptr : CUdeviceptr
        Returned device pointer

    See Also
    --------
    cuMemAlloc
    cuMemFree
    cuIpcGetEventHandle
    cuIpcOpenEventHandle
    cuIpcGetMemHandle
    cuIpcCloseMemHandle
    cuCtxEnablePeerAccess
    cuDeviceCanAccessPeer
    cudaIpcOpenMemHandle

    Notes
    -----
    No guarantees are made about the address returned in `*pdptr`. In particular, multiple processes may not receive the same address for the same `handle`.

    """
    cdef CUdeviceptr pdptr = CUdeviceptr()
    err = ccuda.cuIpcOpenMemHandle(pdptr._ptr, handle._ptr[0], Flags)
    return (CUresult(err), pdptr)

@cython.embedsignature(True)
def cuIpcCloseMemHandle(dptr):
    """ Attempts to close memory mapped with cuIpcOpenMemHandle.

    Decrements the reference count of the memory returned by
    cuIpcOpenMemHandle by 1. When the reference count reaches 0, this API
    unmaps the memory. The original allocation in the exporting process as
    well as imported mappings in other processes will be unaffected.

    Any resources used to enable peer access will be freed if this is the
    last mapping using them.

    IPC functionality is restricted to devices with support for unified
    addressing on Linux and Windows operating systems. IPC functionality on
    Windows is restricted to GPUs in TCC mode

    Parameters
    ----------
    dptr : Any
        Device pointer returned by cuIpcOpenMemHandle

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_MAP_FAILED
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemAlloc
    cuMemFree
    cuIpcGetEventHandle
    cuIpcOpenEventHandle
    cuIpcGetMemHandle
    cuIpcOpenMemHandle
    cudaIpcCloseMemHandle
    """
    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    err = ccuda.cuIpcCloseMemHandle(cdptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemHostRegister(p, size_t bytesize, unsigned int Flags):
    """ Registers an existing host memory range for use by CUDA.

    Page-locks the memory range specified by `p` and `bytesize` and maps it
    for the device(s) as specified by `Flags`. This memory range also is
    added to the same tracking mechanism as cuMemHostAlloc to automatically
    accelerate calls to functions such as cuMemcpyHtoD(). Since the memory
    can be accessed directly by the device, it can be read or written with
    much higher bandwidth than pageable memory that has not been
    registered. Page-locking excessive amounts of memory may degrade system
    performance, since it reduces the amount of memory available to the
    system for paging. As a result, this function is best used sparingly to
    register staging areas for data exchange between host and device.

    This function has limited support on Mac OS X. OS 10.7 or higher is
    required.

    The `Flags` parameter enables different options to be specified that
    affect the allocation, as follows.

    - CU_MEMHOSTREGISTER_PORTABLE: The memory returned by this call will be
    considered as pinned memory by all CUDA contexts, not just the one that
    performed the allocation.    - CU_MEMHOSTREGISTER_DEVICEMAP: Maps the
    allocation into the CUDA address space. The device pointer to the
    memory may be obtained by calling cuMemHostGetDevicePointer().    -
    CU_MEMHOSTREGISTER_IOMEMORY: The pointer is treated as pointing to some
    I/O memory space, e.g. the PCI Express resource of a 3rd party device.
    - CU_MEMHOSTREGISTER_READ_ONLY: The pointer is treated as pointing to
    memory that is considered read-only by the device. On platforms without
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES, this
    flag is required in order to register memory mapped to the CPU as read-
    only. Support for the use of this flag can be queried from the device
    attribute CU_DEVICE_ATTRIBUTE_READ_ONLY_HOST_REGISTER_SUPPORTED. Using
    this flag with a current context associated with a device that does not
    have this attribute set will cause cuMemHostRegister to error with
    CUDA_ERROR_NOT_SUPPORTED.

    All of these flags are orthogonal to one another: a developer may page-
    lock memory that is portable or mapped with no restrictions.

    The CU_MEMHOSTREGISTER_DEVICEMAP flag may be specified on CUDA contexts
    for devices that do not support mapped pinned memory. The failure is
    deferred to cuMemHostGetDevicePointer() because the memory may be
    mapped into other CUDA contexts via the CU_MEMHOSTREGISTER_PORTABLE
    flag.

    For devices that have a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CAN_USE_HOST_POINTER_FOR_REGISTERED_MEM, the memory
    can also be accessed from the device using the host pointer `p`. The
    device pointer returned by cuMemHostGetDevicePointer() may or may not
    match the original host pointer `ptr` and depends on the devices
    visible to the application. If all devices visible to the application
    have a non-zero value for the device attribute, the device pointer
    returned by cuMemHostGetDevicePointer() will match the original pointer
    `ptr`. If any device visible to the application has a zero value for
    the device attribute, the device pointer returned by
    cuMemHostGetDevicePointer() will not match the original host pointer
    `ptr`, but it will be suitable for use on all devices provided Unified
    Virtual Addressing is enabled. In such systems, it is valid to access
    the memory using either pointer on devices that have a non-zero value
    for the device attribute. Note however that such devices should access
    the memory using only of the two pointers and not both.

    The memory page-locked by this function must be unregistered with
    cuMemHostUnregister().

    Parameters
    ----------
    p : Any
        Host pointer to memory to page-lock
    bytesize : size_t
        Size in bytes of the address range to page-lock
    Flags : unsigned int
        Flags for allocation request

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemHostUnregister
    cuMemHostGetFlags
    cuMemHostGetDevicePointer
    cudaHostRegister
    """
    cp = utils.HelperInputVoidPtr(p)
    cdef void* cp_ptr = <void*><void_ptr>cp.cptr
    err = ccuda.cuMemHostRegister(cp_ptr, bytesize, Flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemHostUnregister(p):
    """ Unregisters a memory range that was registered with cuMemHostRegister.

    Unmaps the memory range whose base address is specified by `p`, and
    makes it pageable again.

    The base address must be the same one specified to cuMemHostRegister().

    Parameters
    ----------
    p : Any
        Host pointer to memory to unregister

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_HOST_MEMORY_NOT_REGISTERED
    None
        None

    See Also
    --------
    cuMemHostRegister
    cudaHostUnregister
    """
    cp = utils.HelperInputVoidPtr(p)
    cdef void* cp_ptr = <void*><void_ptr>cp.cptr
    err = ccuda.cuMemHostUnregister(cp_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy(dst, src, size_t ByteCount):
    """ Copies memory.

    Copies data between two pointers. `dst` and `src` are base pointers of
    the destination and source, respectively. `ByteCount` specifies the
    number of bytes to copy. Note that this function infers the type of the
    transfer (host to host, host to device, device to device, or device to
    host) from the pointer values. This function is only allowed in
    contexts which support unified addressing.

    Parameters
    ----------
    dst : Any
        Destination unified virtual address space pointer
    src : Any
        Source unified virtual address space pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy
    cudaMemcpyToSymbol
    cudaMemcpyFromSymbol
    """
    cdef ccuda.CUdeviceptr csrc
    if src is None:
        csrc = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(src, (CUdeviceptr)):
        psrc = int(src)
        csrc = <ccuda.CUdeviceptr><void_ptr>psrc
    else:
        psrc = int(CUdeviceptr(src))
        csrc = <ccuda.CUdeviceptr><void_ptr>psrc

    cdef ccuda.CUdeviceptr cdst
    if dst is None:
        cdst = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dst, (CUdeviceptr)):
        pdst = int(dst)
        cdst = <ccuda.CUdeviceptr><void_ptr>pdst
    else:
        pdst = int(CUdeviceptr(dst))
        cdst = <ccuda.CUdeviceptr><void_ptr>pdst

    err = ccuda.cuMemcpy(cdst, csrc, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyPeer(dstDevice, dstContext, srcDevice, srcContext, size_t ByteCount):
    """ Copies device memory between two contexts.

    Copies from device memory in one context to device memory in another
    context. `dstDevice` is the base device pointer of the destination
    memory and `dstContext` is the destination context. `srcDevice` is the
    base device pointer of the source memory and `srcContext` is the source
    pointer. `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstContext : Any
        Destination context
    srcDevice : Any
        Source device pointer
    srcContext : Any
        Source context
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemcpyDtoD
    cuMemcpy3DPeer
    cuMemcpyDtoDAsync
    cuMemcpyPeerAsync
    cuMemcpy3DPeerAsync
    cudaMemcpyPeer
    """
    cdef ccuda.CUcontext csrcContext
    if srcContext is None:
        csrcContext = <ccuda.CUcontext><void_ptr>0
    elif isinstance(srcContext, (CUcontext)):
        psrcContext = int(srcContext)
        csrcContext = <ccuda.CUcontext><void_ptr>psrcContext
    else:
        psrcContext = int(CUcontext(srcContext))
        csrcContext = <ccuda.CUcontext><void_ptr>psrcContext

    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdef ccuda.CUcontext cdstContext
    if dstContext is None:
        cdstContext = <ccuda.CUcontext><void_ptr>0
    elif isinstance(dstContext, (CUcontext)):
        pdstContext = int(dstContext)
        cdstContext = <ccuda.CUcontext><void_ptr>pdstContext
    else:
        pdstContext = int(CUcontext(dstContext))
        cdstContext = <ccuda.CUcontext><void_ptr>pdstContext

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemcpyPeer(cdstDevice, cdstContext, csrcDevice, csrcContext, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyHtoD(dstDevice, srcHost, size_t ByteCount):
    """ Copies memory from Host to Device.

    Copies from host memory to device memory. `dstDevice` and `srcHost` are
    the base addresses of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    srcHost : Any
        Source host pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy
    cudaMemcpyToSymbol
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    csrcHost = utils.HelperInputVoidPtr(srcHost)
    cdef void* csrcHost_ptr = <void*><void_ptr>csrcHost.cptr
    err = ccuda.cuMemcpyHtoD(cdstDevice, csrcHost_ptr, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyDtoH(dstHost, srcDevice, size_t ByteCount):
    """ Copies memory from Device to Host.

    Copies from device to host memory. `dstHost` and `srcDevice` specify
    the base pointers of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstHost : Any
        Destination host pointer
    srcDevice : Any
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy
    cudaMemcpyFromSymbol
    """
    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdstHost = utils.HelperInputVoidPtr(dstHost)
    cdef void* cdstHost_ptr = <void*><void_ptr>cdstHost.cptr
    err = ccuda.cuMemcpyDtoH(cdstHost_ptr, csrcDevice, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyDtoD(dstDevice, srcDevice, size_t ByteCount):
    """ Copies memory from Device to Device.

    Copies from device memory to device memory. `dstDevice` and `srcDevice`
    are the base pointers of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    srcDevice : Any
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy
    cudaMemcpyToSymbol
    cudaMemcpyFromSymbol
    """
    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemcpyDtoD(cdstDevice, csrcDevice, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyDtoA(dstArray, size_t dstOffset, srcDevice, size_t ByteCount):
    """ Copies memory from Device to Array.

    Copies from device memory to a 1D CUDA array. `dstArray` and
    `dstOffset` specify the CUDA array handle and starting index of the
    destination data. `srcDevice` specifies the base pointer of the source.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstArray : Any
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcDevice : Any
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpyToArray
    """
    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdef ccuda.CUarray cdstArray
    if dstArray is None:
        cdstArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(dstArray, (CUarray)):
        pdstArray = int(dstArray)
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray
    else:
        pdstArray = int(CUarray(dstArray))
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray

    err = ccuda.cuMemcpyDtoA(cdstArray, dstOffset, csrcDevice, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyAtoD(dstDevice, srcArray, size_t srcOffset, size_t ByteCount):
    """ Copies memory from Array to Device.

    Copies from one 1D CUDA array to device memory. `dstDevice` specifies
    the base pointer of the destination and must be naturally aligned with
    the CUDA array elements. `srcArray` and `srcOffset` specify the CUDA
    array handle and the offset in bytes into the array where the copy is
    to begin. `ByteCount` specifies the number of bytes to copy and must be
    evenly divisible by the array element size.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    srcArray : Any
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpyFromArray
    """
    cdef ccuda.CUarray csrcArray
    if srcArray is None:
        csrcArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(srcArray, (CUarray)):
        psrcArray = int(srcArray)
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray
    else:
        psrcArray = int(CUarray(srcArray))
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemcpyAtoD(cdstDevice, csrcArray, srcOffset, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyHtoA(dstArray, size_t dstOffset, srcHost, size_t ByteCount):
    """ Copies memory from Host to Array.

    Copies from host memory to a 1D CUDA array. `dstArray` and `dstOffset`
    specify the CUDA array handle and starting offset in bytes of the
    destination data. `pSrc` specifies the base address of the source.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstArray : Any
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcHost : Any
        Source host pointer
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpyToArray
    """
    cdef ccuda.CUarray cdstArray
    if dstArray is None:
        cdstArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(dstArray, (CUarray)):
        pdstArray = int(dstArray)
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray
    else:
        pdstArray = int(CUarray(dstArray))
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray

    csrcHost = utils.HelperInputVoidPtr(srcHost)
    cdef void* csrcHost_ptr = <void*><void_ptr>csrcHost.cptr
    err = ccuda.cuMemcpyHtoA(cdstArray, dstOffset, csrcHost_ptr, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyAtoH(dstHost, srcArray, size_t srcOffset, size_t ByteCount):
    """ Copies memory from Array to Host.

    Copies from one 1D CUDA array to host memory. `dstHost` specifies the
    base pointer of the destination. `srcArray` and `srcOffset` specify the
    CUDA array handle and starting offset in bytes of the source data.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstHost : Any
        Destination device pointer
    srcArray : Any
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpyFromArray
    """
    cdef ccuda.CUarray csrcArray
    if srcArray is None:
        csrcArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(srcArray, (CUarray)):
        psrcArray = int(srcArray)
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray
    else:
        psrcArray = int(CUarray(srcArray))
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray

    cdstHost = utils.HelperInputVoidPtr(dstHost)
    cdef void* cdstHost_ptr = <void*><void_ptr>cdstHost.cptr
    err = ccuda.cuMemcpyAtoH(cdstHost_ptr, csrcArray, srcOffset, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyAtoA(dstArray, size_t dstOffset, srcArray, size_t srcOffset, size_t ByteCount):
    """ Copies memory from Array to Array.

    Copies from one 1D CUDA array to another. `dstArray` and `srcArray`
    specify the handles of the destination and source CUDA arrays for the
    copy, respectively. `dstOffset` and `srcOffset` specify the destination
    and source offsets in bytes into the CUDA arrays. `ByteCount` is the
    number of bytes to be copied. The size of the elements in the CUDA
    arrays need not be the same format, but the elements must be the same
    size; and count must be evenly divisible by that size.

    Parameters
    ----------
    dstArray : Any
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcArray : Any
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpyArrayToArray
    """
    cdef ccuda.CUarray csrcArray
    if srcArray is None:
        csrcArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(srcArray, (CUarray)):
        psrcArray = int(srcArray)
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray
    else:
        psrcArray = int(CUarray(srcArray))
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray

    cdef ccuda.CUarray cdstArray
    if dstArray is None:
        cdstArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(dstArray, (CUarray)):
        pdstArray = int(dstArray)
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray
    else:
        pdstArray = int(CUarray(dstArray))
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray

    err = ccuda.cuMemcpyAtoA(cdstArray, dstOffset, csrcArray, srcOffset, ByteCount)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy2D(pCopy : CUDA_MEMCPY2D):
    """ Copies memory for 2D arrays.

    Perform a 2D memory copy according to the parameters specified in
    `pCopy`. The CUDA_MEMCPY2D structure is defined as:

    typedefstructCUDA_MEMCPY2D_st{ unsignedintsrcXInBytes,srcY;
    CUmemorytypesrcMemoryType; constvoid*srcHost; CUdeviceptrsrcDevice;
    CUarraysrcArray; unsignedintsrcPitch;  unsignedintdstXInBytes,dstY;
    CUmemorytypedstMemoryType; void*dstHost; CUdeviceptrdstDevice;
    CUarraydstArray; unsignedintdstPitch;  unsignedintWidthInBytes;
    unsignedintHeight; }CUDA_MEMCPY2D; where: - srcMemoryType and
    dstMemoryType specify the type of memory of the source and destination,
    respectively; CUmemorytype_enum is defined as:

    typedefenumCUmemorytype_enum{ CU_MEMORYTYPE_HOST=0x01,
    CU_MEMORYTYPE_DEVICE=0x02, CU_MEMORYTYPE_ARRAY=0x03,
    CU_MEMORYTYPE_UNIFIED=0x04 }CUmemorytype;

    If srcMemoryType is CU_MEMORYTYPE_UNIFIED, srcDevice and srcPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. srcArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If srcMemoryType is CU_MEMORYTYPE_HOST, srcHost and srcPitch specify
    the (host) base address of the source data and the bytes per row to
    apply. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_DEVICE, srcDevice and srcPitch
    specify the (device) base address of the source data and the bytes per
    row to apply. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_ARRAY, srcArray specifies the handle
    of the source data. srcHost, srcDevice and srcPitch are ignored.

    If dstMemoryType is CU_MEMORYTYPE_HOST, dstHost and dstPitch specify
    the (host) base address of the destination data and the bytes per row
    to apply. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_UNIFIED, dstDevice and dstPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. dstArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If dstMemoryType is CU_MEMORYTYPE_DEVICE, dstDevice and dstPitch
    specify the (device) base address of the destination data and the bytes
    per row to apply. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_ARRAY, dstArray specifies the handle
    of the destination data. dstHost, dstDevice and dstPitch are ignored.

    For host pointers, the starting address is
    void*Start=(void*)((char*)srcHost+srcY*srcPitch+srcXInBytes);

    For device pointers, the starting address is
    CUdeviceptrStart=srcDevice+srcY*srcPitch+srcXInBytes;

    For CUDA arrays, srcXInBytes must be evenly divisible by the array
    element size.

    For host pointers, the base address is
    void*dstStart=(void*)((char*)dstHost+dstY*dstPitch+dstXInBytes);

    For device pointers, the starting address is
    CUdeviceptrdstStart=dstDevice+dstY*dstPitch+dstXInBytes;

    For CUDA arrays, dstXInBytes must be evenly divisible by the array
    element size.

    cuMemcpy2D() returns an error if any pitch is greater than the maximum
    allowed (CU_DEVICE_ATTRIBUTE_MAX_PITCH). cuMemAllocPitch() passes back
    pitches that always work with cuMemcpy2D(). On intra-device memory
    copies (device to device, CUDA array to device, CUDA array to CUDA
    array), cuMemcpy2D() may fail for pitches not computed by
    cuMemAllocPitch(). cuMemcpy2DUnaligned() does not have this
    restriction, but may run significantly slower in the cases where
    cuMemcpy2D() would have returned an error code.

    Parameters
    ----------
    pCopy : CUDA_MEMCPY2D
        Parameters for the memory copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy2D
    cudaMemcpy2DToArray
    cudaMemcpy2DFromArray
    """
    cdef ccuda.CUDA_MEMCPY2D* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy2D(cpCopy_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy2DUnaligned(pCopy : CUDA_MEMCPY2D):
    """ Copies memory for 2D arrays.

    Perform a 2D memory copy according to the parameters specified in
    `pCopy`. The CUDA_MEMCPY2D structure is defined as:

    typedefstructCUDA_MEMCPY2D_st{ unsignedintsrcXInBytes,srcY;
    CUmemorytypesrcMemoryType; constvoid*srcHost; CUdeviceptrsrcDevice;
    CUarraysrcArray; unsignedintsrcPitch; unsignedintdstXInBytes,dstY;
    CUmemorytypedstMemoryType; void*dstHost; CUdeviceptrdstDevice;
    CUarraydstArray; unsignedintdstPitch; unsignedintWidthInBytes;
    unsignedintHeight; }CUDA_MEMCPY2D; where: - srcMemoryType and
    dstMemoryType specify the type of memory of the source and destination,
    respectively; CUmemorytype_enum is defined as:

    typedefenumCUmemorytype_enum{ CU_MEMORYTYPE_HOST=0x01,
    CU_MEMORYTYPE_DEVICE=0x02, CU_MEMORYTYPE_ARRAY=0x03,
    CU_MEMORYTYPE_UNIFIED=0x04 }CUmemorytype;

    If srcMemoryType is CU_MEMORYTYPE_UNIFIED, srcDevice and srcPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. srcArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If srcMemoryType is CU_MEMORYTYPE_HOST, srcHost and srcPitch specify
    the (host) base address of the source data and the bytes per row to
    apply. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_DEVICE, srcDevice and srcPitch
    specify the (device) base address of the source data and the bytes per
    row to apply. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_ARRAY, srcArray specifies the handle
    of the source data. srcHost, srcDevice and srcPitch are ignored.

    If dstMemoryType is CU_MEMORYTYPE_UNIFIED, dstDevice and dstPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. dstArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If dstMemoryType is CU_MEMORYTYPE_HOST, dstHost and dstPitch specify
    the (host) base address of the destination data and the bytes per row
    to apply. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_DEVICE, dstDevice and dstPitch
    specify the (device) base address of the destination data and the bytes
    per row to apply. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_ARRAY, dstArray specifies the handle
    of the destination data. dstHost, dstDevice and dstPitch are ignored.

    For host pointers, the starting address is
    void*Start=(void*)((char*)srcHost+srcY*srcPitch+srcXInBytes);

    For device pointers, the starting address is
    CUdeviceptrStart=srcDevice+srcY*srcPitch+srcXInBytes;

    For CUDA arrays, srcXInBytes must be evenly divisible by the array
    element size.

    For host pointers, the base address is
    void*dstStart=(void*)((char*)dstHost+dstY*dstPitch+dstXInBytes);

    For device pointers, the starting address is
    CUdeviceptrdstStart=dstDevice+dstY*dstPitch+dstXInBytes;

    For CUDA arrays, dstXInBytes must be evenly divisible by the array
    element size.

    cuMemcpy2D() returns an error if any pitch is greater than the maximum
    allowed (CU_DEVICE_ATTRIBUTE_MAX_PITCH). cuMemAllocPitch() passes back
    pitches that always work with cuMemcpy2D(). On intra-device memory
    copies (device to device, CUDA array to device, CUDA array to CUDA
    array), cuMemcpy2D() may fail for pitches not computed by
    cuMemAllocPitch(). cuMemcpy2DUnaligned() does not have this
    restriction, but may run significantly slower in the cases where
    cuMemcpy2D() would have returned an error code.

    Parameters
    ----------
    pCopy : CUDA_MEMCPY2D
        Parameters for the memory copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy2D
    cudaMemcpy2DToArray
    cudaMemcpy2DFromArray
    """
    cdef ccuda.CUDA_MEMCPY2D* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy2DUnaligned(cpCopy_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy3D(pCopy : CUDA_MEMCPY3D):
    """ Copies memory for 3D arrays.

    Perform a 3D memory copy according to the parameters specified in
    `pCopy`. The CUDA_MEMCPY3D structure is defined as:

    typedefstructCUDA_MEMCPY3D_st{  unsignedintsrcXInBytes,srcY,srcZ;
    unsignedintsrcLOD; CUmemorytypesrcMemoryType; constvoid*srcHost;
    CUdeviceptrsrcDevice; CUarraysrcArray;
    unsignedintsrcPitch;//ignoredwhensrcisarray
    unsignedintsrcHeight;//ignoredwhensrcisarray;maybe0ifDepth==1
    unsignedintdstXInBytes,dstY,dstZ; unsignedintdstLOD;
    CUmemorytypedstMemoryType; void*dstHost; CUdeviceptrdstDevice;
    CUarraydstArray; unsignedintdstPitch;//ignoredwhendstisarray
    unsignedintdstHeight;//ignoredwhendstisarray;maybe0ifDepth==1
    unsignedintWidthInBytes; unsignedintHeight; unsignedintDepth;
    }CUDA_MEMCPY3D; where: - srcMemoryType and dstMemoryType specify the
    type of memory of the source and destination, respectively;
    CUmemorytype_enum is defined as:

    typedefenumCUmemorytype_enum{ CU_MEMORYTYPE_HOST=0x01,
    CU_MEMORYTYPE_DEVICE=0x02, CU_MEMORYTYPE_ARRAY=0x03,
    CU_MEMORYTYPE_UNIFIED=0x04 }CUmemorytype;

    If srcMemoryType is CU_MEMORYTYPE_UNIFIED, srcDevice and srcPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. srcArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If srcMemoryType is CU_MEMORYTYPE_HOST, srcHost, srcPitch and srcHeight
    specify the (host) base address of the source data, the bytes per row,
    and the height of each 2D slice of the 3D array. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_DEVICE, srcDevice, srcPitch and
    srcHeight specify the (device) base address of the source data, the
    bytes per row, and the height of each 2D slice of the 3D array.
    srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_ARRAY, srcArray specifies the handle
    of the source data. srcHost, srcDevice, srcPitch and srcHeight are
    ignored.

    If dstMemoryType is CU_MEMORYTYPE_UNIFIED, dstDevice and dstPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. dstArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If dstMemoryType is CU_MEMORYTYPE_HOST, dstHost and dstPitch specify
    the (host) base address of the destination data, the bytes per row, and
    the height of each 2D slice of the 3D array. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_DEVICE, dstDevice and dstPitch
    specify the (device) base address of the destination data, the bytes
    per row, and the height of each 2D slice of the 3D array. dstArray is
    ignored.

    If dstMemoryType is CU_MEMORYTYPE_ARRAY, dstArray specifies the handle
    of the destination data. dstHost, dstDevice, dstPitch and dstHeight are
    ignored.

    For host pointers, the starting address is void*Start=(void*)((char*)sr
    cHost+(srcZ*srcHeight+srcY)*srcPitch+srcXInBytes);

    For device pointers, the starting address is
    CUdeviceptrStart=srcDevice+(srcZ*srcHeight+srcY)*srcPitch+srcXInBytes;

    For CUDA arrays, srcXInBytes must be evenly divisible by the array
    element size.

    For host pointers, the base address is void*dstStart=(void*)((char*)dst
    Host+(dstZ*dstHeight+dstY)*dstPitch+dstXInBytes);

    For device pointers, the starting address is CUdeviceptrdstStart=dstDev
    ice+(dstZ*dstHeight+dstY)*dstPitch+dstXInBytes;

    For CUDA arrays, dstXInBytes must be evenly divisible by the array
    element size.

    cuMemcpy3D() returns an error if any pitch is greater than the maximum
    allowed (CU_DEVICE_ATTRIBUTE_MAX_PITCH).

    Parameters
    ----------
    pCopy : CUDA_MEMCPY3D
        Parameters for the memory copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMemcpy3D
    """
    cdef ccuda.CUDA_MEMCPY3D* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy3D(cpCopy_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy3DPeer(pCopy : CUDA_MEMCPY3D_PEER):
    """ Copies memory between contexts.

    Perform a 3D memory copy according to the parameters specified in
    `pCopy`. See the definition of the CUDA_MEMCPY3D_PEER structure for
    documentation of its parameters.

    Parameters
    ----------
    pCopy : CUDA_MEMCPY3D_PEER
        Parameters for the memory copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemcpyDtoD
    cuMemcpyPeer
    cuMemcpyDtoDAsync
    cuMemcpyPeerAsync
    cuMemcpy3DPeerAsync
    cudaMemcpy3DPeer
    """
    cdef ccuda.CUDA_MEMCPY3D_PEER* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy3DPeer(cpCopy_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyAsync(dst, src, size_t ByteCount, hStream):
    """ Copies memory asynchronously.

    Copies data between two pointers. `dst` and `src` are base pointers of
    the destination and source, respectively. `ByteCount` specifies the
    number of bytes to copy. Note that this function infers the type of the
    transfer (host to host, host to device, device to device, or device to
    host) from the pointer values. This function is only allowed in
    contexts which support unified addressing.

    Parameters
    ----------
    dst : Any
        Destination unified virtual address space pointer
    src : Any
        Source unified virtual address space pointer
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpyAsync
    cudaMemcpyToSymbolAsync
    cudaMemcpyFromSymbolAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr csrc
    if src is None:
        csrc = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(src, (CUdeviceptr)):
        psrc = int(src)
        csrc = <ccuda.CUdeviceptr><void_ptr>psrc
    else:
        psrc = int(CUdeviceptr(src))
        csrc = <ccuda.CUdeviceptr><void_ptr>psrc

    cdef ccuda.CUdeviceptr cdst
    if dst is None:
        cdst = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dst, (CUdeviceptr)):
        pdst = int(dst)
        cdst = <ccuda.CUdeviceptr><void_ptr>pdst
    else:
        pdst = int(CUdeviceptr(dst))
        cdst = <ccuda.CUdeviceptr><void_ptr>pdst

    err = ccuda.cuMemcpyAsync(cdst, csrc, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyPeerAsync(dstDevice, dstContext, srcDevice, srcContext, size_t ByteCount, hStream):
    """ Copies device memory between two contexts asynchronously.

    Copies from device memory in one context to device memory in another
    context. `dstDevice` is the base device pointer of the destination
    memory and `dstContext` is the destination context. `srcDevice` is the
    base device pointer of the source memory and `srcContext` is the source
    pointer. `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstContext : Any
        Destination context
    srcDevice : Any
        Source device pointer
    srcContext : Any
        Source context
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuMemcpyDtoD
    cuMemcpyPeer
    cuMemcpy3DPeer
    cuMemcpyDtoDAsync
    cuMemcpy3DPeerAsync
    cudaMemcpyPeerAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUcontext csrcContext
    if srcContext is None:
        csrcContext = <ccuda.CUcontext><void_ptr>0
    elif isinstance(srcContext, (CUcontext)):
        psrcContext = int(srcContext)
        csrcContext = <ccuda.CUcontext><void_ptr>psrcContext
    else:
        psrcContext = int(CUcontext(srcContext))
        csrcContext = <ccuda.CUcontext><void_ptr>psrcContext

    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdef ccuda.CUcontext cdstContext
    if dstContext is None:
        cdstContext = <ccuda.CUcontext><void_ptr>0
    elif isinstance(dstContext, (CUcontext)):
        pdstContext = int(dstContext)
        cdstContext = <ccuda.CUcontext><void_ptr>pdstContext
    else:
        pdstContext = int(CUcontext(dstContext))
        cdstContext = <ccuda.CUcontext><void_ptr>pdstContext

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemcpyPeerAsync(cdstDevice, cdstContext, csrcDevice, csrcContext, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyHtoDAsync(dstDevice, srcHost, size_t ByteCount, hStream):
    """ Copies memory from Host to Device.

    Copies from host memory to device memory. `dstDevice` and `srcHost` are
    the base addresses of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    srcHost : Any
        Source host pointer
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpyAsync
    cudaMemcpyToSymbolAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    csrcHost = utils.HelperInputVoidPtr(srcHost)
    cdef void* csrcHost_ptr = <void*><void_ptr>csrcHost.cptr
    err = ccuda.cuMemcpyHtoDAsync(cdstDevice, csrcHost_ptr, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyDtoHAsync(dstHost, srcDevice, size_t ByteCount, hStream):
    """ Copies memory from Device to Host.

    Copies from device to host memory. `dstHost` and `srcDevice` specify
    the base pointers of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstHost : Any
        Destination host pointer
    srcDevice : Any
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpyAsync
    cudaMemcpyFromSymbolAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdstHost = utils.HelperInputVoidPtr(dstHost)
    cdef void* cdstHost_ptr = <void*><void_ptr>cdstHost.cptr
    err = ccuda.cuMemcpyDtoHAsync(cdstHost_ptr, csrcDevice, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyDtoDAsync(dstDevice, srcDevice, size_t ByteCount, hStream):
    """ Copies memory from Device to Device.

    Copies from device memory to device memory. `dstDevice` and `srcDevice`
    are the base pointers of the destination and source, respectively.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    srcDevice : Any
        Source device pointer
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpyAsync
    cudaMemcpyToSymbolAsync
    cudaMemcpyFromSymbolAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr csrcDevice
    if srcDevice is None:
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(srcDevice, (CUdeviceptr)):
        psrcDevice = int(srcDevice)
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice
    else:
        psrcDevice = int(CUdeviceptr(srcDevice))
        csrcDevice = <ccuda.CUdeviceptr><void_ptr>psrcDevice

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemcpyDtoDAsync(cdstDevice, csrcDevice, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyHtoAAsync(dstArray, size_t dstOffset, srcHost, size_t ByteCount, hStream):
    """ Copies memory from Host to Array.

    Copies from host memory to a 1D CUDA array. `dstArray` and `dstOffset`
    specify the CUDA array handle and starting offset in bytes of the
    destination data. `srcHost` specifies the base address of the source.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstArray : Any
        Destination array
    dstOffset : size_t
        Offset in bytes of destination array
    srcHost : Any
        Source host pointer
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpyToArrayAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUarray cdstArray
    if dstArray is None:
        cdstArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(dstArray, (CUarray)):
        pdstArray = int(dstArray)
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray
    else:
        pdstArray = int(CUarray(dstArray))
        cdstArray = <ccuda.CUarray><void_ptr>pdstArray

    csrcHost = utils.HelperInputVoidPtr(srcHost)
    cdef void* csrcHost_ptr = <void*><void_ptr>csrcHost.cptr
    err = ccuda.cuMemcpyHtoAAsync(cdstArray, dstOffset, csrcHost_ptr, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpyAtoHAsync(dstHost, srcArray, size_t srcOffset, size_t ByteCount, hStream):
    """ Copies memory from Array to Host.

    Copies from one 1D CUDA array to host memory. `dstHost` specifies the
    base pointer of the destination. `srcArray` and `srcOffset` specify the
    CUDA array handle and starting offset in bytes of the source data.
    `ByteCount` specifies the number of bytes to copy.

    Parameters
    ----------
    dstHost : Any
        Destination pointer
    srcArray : Any
        Source array
    srcOffset : size_t
        Offset in bytes of source array
    ByteCount : size_t
        Size of memory copy in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpyFromArrayAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUarray csrcArray
    if srcArray is None:
        csrcArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(srcArray, (CUarray)):
        psrcArray = int(srcArray)
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray
    else:
        psrcArray = int(CUarray(srcArray))
        csrcArray = <ccuda.CUarray><void_ptr>psrcArray

    cdstHost = utils.HelperInputVoidPtr(dstHost)
    cdef void* cdstHost_ptr = <void*><void_ptr>cdstHost.cptr
    err = ccuda.cuMemcpyAtoHAsync(cdstHost_ptr, csrcArray, srcOffset, ByteCount, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy2DAsync(pCopy : CUDA_MEMCPY2D, hStream):
    """ Copies memory for 2D arrays.

    Perform a 2D memory copy according to the parameters specified in
    `pCopy`. The CUDA_MEMCPY2D structure is defined as:

    typedefstructCUDA_MEMCPY2D_st{ unsignedintsrcXInBytes,srcY;
    CUmemorytypesrcMemoryType; constvoid*srcHost; CUdeviceptrsrcDevice;
    CUarraysrcArray; unsignedintsrcPitch; unsignedintdstXInBytes,dstY;
    CUmemorytypedstMemoryType; void*dstHost; CUdeviceptrdstDevice;
    CUarraydstArray; unsignedintdstPitch; unsignedintWidthInBytes;
    unsignedintHeight; }CUDA_MEMCPY2D; where: - srcMemoryType and
    dstMemoryType specify the type of memory of the source and destination,
    respectively; CUmemorytype_enum is defined as:

    typedefenumCUmemorytype_enum{ CU_MEMORYTYPE_HOST=0x01,
    CU_MEMORYTYPE_DEVICE=0x02, CU_MEMORYTYPE_ARRAY=0x03,
    CU_MEMORYTYPE_UNIFIED=0x04 }CUmemorytype;

    If srcMemoryType is CU_MEMORYTYPE_HOST, srcHost and srcPitch specify
    the (host) base address of the source data and the bytes per row to
    apply. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_UNIFIED, srcDevice and srcPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. srcArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If srcMemoryType is CU_MEMORYTYPE_DEVICE, srcDevice and srcPitch
    specify the (device) base address of the source data and the bytes per
    row to apply. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_ARRAY, srcArray specifies the handle
    of the source data. srcHost, srcDevice and srcPitch are ignored.

    If dstMemoryType is CU_MEMORYTYPE_UNIFIED, dstDevice and dstPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. dstArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If dstMemoryType is CU_MEMORYTYPE_HOST, dstHost and dstPitch specify
    the (host) base address of the destination data and the bytes per row
    to apply. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_DEVICE, dstDevice and dstPitch
    specify the (device) base address of the destination data and the bytes
    per row to apply. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_ARRAY, dstArray specifies the handle
    of the destination data. dstHost, dstDevice and dstPitch are ignored.

    For host pointers, the starting address is
    void*Start=(void*)((char*)srcHost+srcY*srcPitch+srcXInBytes);

    For device pointers, the starting address is
    CUdeviceptrStart=srcDevice+srcY*srcPitch+srcXInBytes;

    For CUDA arrays, srcXInBytes must be evenly divisible by the array
    element size.

    For host pointers, the base address is
    void*dstStart=(void*)((char*)dstHost+dstY*dstPitch+dstXInBytes);

    For device pointers, the starting address is
    CUdeviceptrdstStart=dstDevice+dstY*dstPitch+dstXInBytes;

    For CUDA arrays, dstXInBytes must be evenly divisible by the array
    element size.

    cuMemcpy2DAsync() returns an error if any pitch is greater than the
    maximum allowed (CU_DEVICE_ATTRIBUTE_MAX_PITCH). cuMemAllocPitch()
    passes back pitches that always work with cuMemcpy2D(). On intra-device
    memory copies (device to device, CUDA array to device, CUDA array to
    CUDA array), cuMemcpy2DAsync() may fail for pitches not computed by
    cuMemAllocPitch().

    Parameters
    ----------
    pCopy : CUDA_MEMCPY2D
        Parameters for the memory copy
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpy2DAsync
    cudaMemcpy2DToArrayAsync
    cudaMemcpy2DFromArrayAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUDA_MEMCPY2D* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy2DAsync(cpCopy_ptr, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy3DAsync(pCopy : CUDA_MEMCPY3D, hStream):
    """ Copies memory for 3D arrays.

    Perform a 3D memory copy according to the parameters specified in
    `pCopy`. The CUDA_MEMCPY3D structure is defined as:

    typedefstructCUDA_MEMCPY3D_st{  unsignedintsrcXInBytes,srcY,srcZ;
    unsignedintsrcLOD; CUmemorytypesrcMemoryType; constvoid*srcHost;
    CUdeviceptrsrcDevice; CUarraysrcArray;
    unsignedintsrcPitch;//ignoredwhensrcisarray
    unsignedintsrcHeight;//ignoredwhensrcisarray;maybe0ifDepth==1
    unsignedintdstXInBytes,dstY,dstZ; unsignedintdstLOD;
    CUmemorytypedstMemoryType; void*dstHost; CUdeviceptrdstDevice;
    CUarraydstArray; unsignedintdstPitch;//ignoredwhendstisarray
    unsignedintdstHeight;//ignoredwhendstisarray;maybe0ifDepth==1
    unsignedintWidthInBytes; unsignedintHeight; unsignedintDepth;
    }CUDA_MEMCPY3D; where: - srcMemoryType and dstMemoryType specify the
    type of memory of the source and destination, respectively;
    CUmemorytype_enum is defined as:

    typedefenumCUmemorytype_enum{ CU_MEMORYTYPE_HOST=0x01,
    CU_MEMORYTYPE_DEVICE=0x02, CU_MEMORYTYPE_ARRAY=0x03,
    CU_MEMORYTYPE_UNIFIED=0x04 }CUmemorytype;

    If srcMemoryType is CU_MEMORYTYPE_UNIFIED, srcDevice and srcPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. srcArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If srcMemoryType is CU_MEMORYTYPE_HOST, srcHost, srcPitch and srcHeight
    specify the (host) base address of the source data, the bytes per row,
    and the height of each 2D slice of the 3D array. srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_DEVICE, srcDevice, srcPitch and
    srcHeight specify the (device) base address of the source data, the
    bytes per row, and the height of each 2D slice of the 3D array.
    srcArray is ignored.

    If srcMemoryType is CU_MEMORYTYPE_ARRAY, srcArray specifies the handle
    of the source data. srcHost, srcDevice, srcPitch and srcHeight are
    ignored.

    If dstMemoryType is CU_MEMORYTYPE_UNIFIED, dstDevice and dstPitch
    specify the (unified virtual address space) base address of the source
    data and the bytes per row to apply. dstArray is ignored. This value
    may be used only if unified addressing is supported in the calling
    context.

    If dstMemoryType is CU_MEMORYTYPE_HOST, dstHost and dstPitch specify
    the (host) base address of the destination data, the bytes per row, and
    the height of each 2D slice of the 3D array. dstArray is ignored.

    If dstMemoryType is CU_MEMORYTYPE_DEVICE, dstDevice and dstPitch
    specify the (device) base address of the destination data, the bytes
    per row, and the height of each 2D slice of the 3D array. dstArray is
    ignored.

    If dstMemoryType is CU_MEMORYTYPE_ARRAY, dstArray specifies the handle
    of the destination data. dstHost, dstDevice, dstPitch and dstHeight are
    ignored.

    For host pointers, the starting address is void*Start=(void*)((char*)sr
    cHost+(srcZ*srcHeight+srcY)*srcPitch+srcXInBytes);

    For device pointers, the starting address is
    CUdeviceptrStart=srcDevice+(srcZ*srcHeight+srcY)*srcPitch+srcXInBytes;

    For CUDA arrays, srcXInBytes must be evenly divisible by the array
    element size.

    For host pointers, the base address is void*dstStart=(void*)((char*)dst
    Host+(dstZ*dstHeight+dstY)*dstPitch+dstXInBytes);

    For device pointers, the starting address is CUdeviceptrdstStart=dstDev
    ice+(dstZ*dstHeight+dstY)*dstPitch+dstXInBytes;

    For CUDA arrays, dstXInBytes must be evenly divisible by the array
    element size.

    cuMemcpy3DAsync() returns an error if any pitch is greater than the
    maximum allowed (CU_DEVICE_ATTRIBUTE_MAX_PITCH).

    Parameters
    ----------
    pCopy : CUDA_MEMCPY3D
        Parameters for the memory copy
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemcpy3DAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUDA_MEMCPY3D* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy3DAsync(cpCopy_ptr, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemcpy3DPeerAsync(pCopy : CUDA_MEMCPY3D_PEER, hStream):
    """ Copies memory between contexts asynchronously.

    Perform a 3D memory copy according to the parameters specified in
    `pCopy`. See the definition of the CUDA_MEMCPY3D_PEER structure for
    documentation of its parameters.

    Parameters
    ----------
    pCopy : CUDA_MEMCPY3D_PEER
        Parameters for the memory copy
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemcpyDtoD
    cuMemcpyPeer
    cuMemcpyDtoDAsync
    cuMemcpyPeerAsync
    cuMemcpy3DPeerAsync
    cudaMemcpy3DPeerAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUDA_MEMCPY3D_PEER* cpCopy_ptr = pCopy._ptr if pCopy != None else NULL
    err = ccuda.cuMemcpy3DPeerAsync(cpCopy_ptr, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD8(dstDevice, unsigned char uc, size_t N):
    """ Initializes device memory.

    Sets the memory range of `N` 8-bit values to the specified value `uc`.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    uc : unsigned char
        Value to set
    N : size_t
        Number of elements

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD8(cdstDevice, uc, N)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD16(dstDevice, unsigned short us, size_t N):
    """ Initializes device memory.

    Sets the memory range of `N` 16-bit values to the specified value `us`.
    The `dstDevice` pointer must be two byte aligned.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    us : unsigned short
        Value to set
    N : size_t
        Number of elements

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD16(cdstDevice, us, N)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD32(dstDevice, unsigned int ui, size_t N):
    """ Initializes device memory.

    Sets the memory range of `N` 32-bit values to the specified value `ui`.
    The `dstDevice` pointer must be four byte aligned.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    ui : unsigned int
        Value to set
    N : size_t
        Number of elements

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32Async
    cudaMemset
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD32(cdstDevice, ui, N)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD2D8(dstDevice, size_t dstPitch, unsigned char uc, size_t Width, size_t Height):
    """ Initializes device memory.

    Sets the 2D memory range of `Width` 8-bit values to the specified value
    `uc`. `Height` specifies the number of rows to set, and `dstPitch`
    specifies the number of bytes between each row. This function performs
    fastest when the pitch is one that has been passed back by
    cuMemAllocPitch().

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstPitch : size_t
        Pitch of destination device pointer(Unused if `Height` is 1)
    uc : unsigned char
        Value to set
    Width : size_t
        Width of row
    Height : size_t
        Number of rows

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset2D
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD2D8(cdstDevice, dstPitch, uc, Width, Height)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD2D16(dstDevice, size_t dstPitch, unsigned short us, size_t Width, size_t Height):
    """ Initializes device memory.

    Sets the 2D memory range of `Width` 16-bit values to the specified
    value `us`. `Height` specifies the number of rows to set, and
    `dstPitch` specifies the number of bytes between each row. The
    `dstDevice` pointer and `dstPitch` offset must be two byte aligned.
    This function performs fastest when the pitch is one that has been
    passed back by cuMemAllocPitch().

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstPitch : size_t
        Pitch of destination device pointer(Unused if `Height` is 1)
    us : unsigned short
        Value to set
    Width : size_t
        Width of row
    Height : size_t
        Number of rows

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset2D
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD2D16(cdstDevice, dstPitch, us, Width, Height)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD2D32(dstDevice, size_t dstPitch, unsigned int ui, size_t Width, size_t Height):
    """ Initializes device memory.

    Sets the 2D memory range of `Width` 32-bit values to the specified
    value `ui`. `Height` specifies the number of rows to set, and
    `dstPitch` specifies the number of bytes between each row. The
    `dstDevice` pointer and `dstPitch` offset must be four byte aligned.
    This function performs fastest when the pitch is one that has been
    passed back by cuMemAllocPitch().

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstPitch : size_t
        Pitch of destination device pointer(Unused if `Height` is 1)
    ui : unsigned int
        Value to set
    Width : size_t
        Width of row
    Height : size_t
        Number of rows

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset2D
    """
    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD2D32(cdstDevice, dstPitch, ui, Width, Height)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD8Async(dstDevice, unsigned char uc, size_t N, hStream):
    """ Sets device memory.

    Sets the memory range of `N` 8-bit values to the specified value `uc`.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    uc : unsigned char
        Value to set
    N : size_t
        Number of elements
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemsetAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD8Async(cdstDevice, uc, N, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD16Async(dstDevice, unsigned short us, size_t N, hStream):
    """ Sets device memory.

    Sets the memory range of `N` 16-bit values to the specified value `us`.
    The `dstDevice` pointer must be two byte aligned.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    us : unsigned short
        Value to set
    N : size_t
        Number of elements
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD32
    cuMemsetD32Async
    cudaMemsetAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD16Async(cdstDevice, us, N, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD32Async(dstDevice, unsigned int ui, size_t N, hStream):
    """ Sets device memory.

    Sets the memory range of `N` 32-bit values to the specified value `ui`.
    The `dstDevice` pointer must be four byte aligned.

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    ui : unsigned int
        Value to set
    N : size_t
        Number of elements
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cudaMemsetAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD32Async(cdstDevice, ui, N, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD2D8Async(dstDevice, size_t dstPitch, unsigned char uc, size_t Width, size_t Height, hStream):
    """ Sets device memory.

    Sets the 2D memory range of `Width` 8-bit values to the specified value
    `uc`. `Height` specifies the number of rows to set, and `dstPitch`
    specifies the number of bytes between each row. This function performs
    fastest when the pitch is one that has been passed back by
    cuMemAllocPitch().

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstPitch : size_t
        Pitch of destination device pointer(Unused if `Height` is 1)
    uc : unsigned char
        Value to set
    Width : size_t
        Width of row
    Height : size_t
        Number of rows
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset2DAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD2D8Async(cdstDevice, dstPitch, uc, Width, Height, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD2D16Async(dstDevice, size_t dstPitch, unsigned short us, size_t Width, size_t Height, hStream):
    """ Sets device memory.

    Sets the 2D memory range of `Width` 16-bit values to the specified
    value `us`. `Height` specifies the number of rows to set, and
    `dstPitch` specifies the number of bytes between each row. The
    `dstDevice` pointer and `dstPitch` offset must be two byte aligned.
    This function performs fastest when the pitch is one that has been
    passed back by cuMemAllocPitch().

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstPitch : size_t
        Pitch of destination device pointer(Unused if `Height` is 1)
    us : unsigned short
        Value to set
    Width : size_t
        Width of row
    Height : size_t
        Number of rows
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD2D32Async
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset2DAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD2D16Async(cdstDevice, dstPitch, us, Width, Height, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemsetD2D32Async(dstDevice, size_t dstPitch, unsigned int ui, size_t Width, size_t Height, hStream):
    """ Sets device memory.

    Sets the 2D memory range of `Width` 32-bit values to the specified
    value `ui`. `Height` specifies the number of rows to set, and
    `dstPitch` specifies the number of bytes between each row. The
    `dstDevice` pointer and `dstPitch` offset must be four byte aligned.
    This function performs fastest when the pitch is one that has been
    passed back by cuMemAllocPitch().

    Parameters
    ----------
    dstDevice : Any
        Destination device pointer
    dstPitch : size_t
        Pitch of destination device pointer(Unused if `Height` is 1)
    ui : unsigned int
        Value to set
    Width : size_t
        Width of row
    Height : size_t
        Number of rows
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D8Async
    cuMemsetD2D16
    cuMemsetD2D16Async
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD8Async
    cuMemsetD16
    cuMemsetD16Async
    cuMemsetD32
    cuMemsetD32Async
    cudaMemset2DAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dstDevice, (CUdeviceptr)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice
    else:
        pdstDevice = int(CUdeviceptr(dstDevice))
        cdstDevice = <ccuda.CUdeviceptr><void_ptr>pdstDevice

    err = ccuda.cuMemsetD2D32Async(cdstDevice, dstPitch, ui, Width, Height, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuArrayCreate(pAllocateArray : CUDA_ARRAY_DESCRIPTOR):
    """ Creates a 1D or 2D CUDA array.

    Creates a CUDA array according to the CUDA_ARRAY_DESCRIPTOR structure
    `pAllocateArray` and returns a handle to the new CUDA array in
    `*pHandle`. The CUDA_ARRAY_DESCRIPTOR is defined as:

    typedefstruct{ unsignedintWidth; unsignedintHeight;
    CUarray_formatFormat; unsignedintNumChannels; }CUDA_ARRAY_DESCRIPTOR;
    where:

    - `Width`, and `Height` are the width, and height of the CUDA array (in
    elements); the CUDA array is one-dimensional if height is 0, two-
    dimensional otherwise;    - Format specifies the format of the
    elements; CUarray_format is defined as: typedefenumCUarray_format_enum{
    CU_AD_FORMAT_UNSIGNED_INT8=0x01, CU_AD_FORMAT_UNSIGNED_INT16=0x02,
    CU_AD_FORMAT_UNSIGNED_INT32=0x03, CU_AD_FORMAT_SIGNED_INT8=0x08,
    CU_AD_FORMAT_SIGNED_INT16=0x09, CU_AD_FORMAT_SIGNED_INT32=0x0a,
    CU_AD_FORMAT_HALF=0x10, CU_AD_FORMAT_FLOAT=0x20 }CUarray_format;     -
    `NumChannels` specifies the number of packed components per CUDA array
    element; it may be 1, 2, or 4;

    Here are examples of CUDA array descriptions:

    Description for a CUDA array of 2048 floats: CUDA_ARRAY_DESCRIPTORdesc;
    desc.Format=CU_AD_FORMAT_FLOAT; desc.NumChannels=1; desc.Width=2048;
    desc.Height=1;

    Description for a 64 x 64 CUDA array of floats:
    CUDA_ARRAY_DESCRIPTORdesc; desc.Format=CU_AD_FORMAT_FLOAT;
    desc.NumChannels=1; desc.Width=64; desc.Height=64;

    Description for a `width` x `height` CUDA array of 64-bit, 4x16-bit
    float16's: CUDA_ARRAY_DESCRIPTORdesc; desc.Format=CU_AD_FORMAT_HALF;
    desc.NumChannels=4; desc.Width=width; desc.Height=height;

    Description for a `width` x `height` CUDA array of 16-bit elements,
    each of which is two 8-bit unsigned chars:
    CUDA_ARRAY_DESCRIPTORarrayDesc; desc.Format=CU_AD_FORMAT_UNSIGNED_INT8;
    desc.NumChannels=2; desc.Width=width; desc.Height=height;

    Parameters
    ----------
    pAllocateArray : CUDA_ARRAY_DESCRIPTOR
        Array descriptor

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_UNKNOWN
    pHandle : CUarray
        Returned array

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMallocArray
    """
    cdef CUarray pHandle = CUarray()
    cdef ccuda.CUDA_ARRAY_DESCRIPTOR* cpAllocateArray_ptr = pAllocateArray._ptr if pAllocateArray != None else NULL
    err = ccuda.cuArrayCreate(pHandle._ptr, cpAllocateArray_ptr)
    return (CUresult(err), pHandle)

@cython.embedsignature(True)
def cuArrayGetDescriptor(hArray):
    """ Get a 1D or 2D CUDA array descriptor.

    Returns in `*pArrayDescriptor` a descriptor containing information on
    the format and dimensions of the CUDA array `hArray`. It is useful for
    subroutines that have been passed a CUDA array, but need to know the
    CUDA array parameters for validation or other purposes.

    Parameters
    ----------
    hArray : Any
        Array to get descriptor of

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    pArrayDescriptor : CUDA_ARRAY_DESCRIPTOR
        Returned array descriptor

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaArrayGetInfo
    """
    cdef ccuda.CUarray chArray
    if hArray is None:
        chArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(hArray, (CUarray)):
        phArray = int(hArray)
        chArray = <ccuda.CUarray><void_ptr>phArray
    else:
        phArray = int(CUarray(hArray))
        chArray = <ccuda.CUarray><void_ptr>phArray

    cdef CUDA_ARRAY_DESCRIPTOR pArrayDescriptor = CUDA_ARRAY_DESCRIPTOR()
    err = ccuda.cuArrayGetDescriptor(pArrayDescriptor._ptr, chArray)
    return (CUresult(err), pArrayDescriptor)

@cython.embedsignature(True)
def cuArrayGetSparseProperties(array):
    """ Returns the layout properties of a sparse CUDA array.

    Returns the layout properties of a sparse CUDA array in
    `sparseProperties` If the CUDA array is not allocated with flag
    CUDA_ARRAY3D_SPARSE CUDA_ERROR_INVALID_VALUE will be returned.

    If the returned value in CUDA_ARRAY_SPARSE_PROPERTIES::flags contains
    CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL, then
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailSize represents the total size of
    the array. Otherwise, it will be zero. Also, the returned value in
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailFirstLevel is always zero. Note
    that the `array` must have been allocated using cuArrayCreate or
    cuArray3DCreate. For CUDA arrays obtained using
    cuMipmappedArrayGetLevel, CUDA_ERROR_INVALID_VALUE will be returned.
    Instead, cuMipmappedArrayGetSparseProperties must be used to obtain the
    sparse properties of the entire CUDA mipmapped array to which `array`
    belongs to.

    Parameters
    ----------
    array : Any
        CUDA array to get the sparse properties of

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    sparseProperties : CUDA_ARRAY_SPARSE_PROPERTIES
        Pointer to CUDA_ARRAY_SPARSE_PROPERTIES

    See Also
    --------
    cuMipmappedArrayGetSparseProperties
    cuMemMapArrayAsync
    """
    cdef ccuda.CUarray carray
    if array is None:
        carray = <ccuda.CUarray><void_ptr>0
    elif isinstance(array, (CUarray)):
        parray = int(array)
        carray = <ccuda.CUarray><void_ptr>parray
    else:
        parray = int(CUarray(array))
        carray = <ccuda.CUarray><void_ptr>parray

    cdef CUDA_ARRAY_SPARSE_PROPERTIES sparseProperties = CUDA_ARRAY_SPARSE_PROPERTIES()
    err = ccuda.cuArrayGetSparseProperties(sparseProperties._ptr, carray)
    return (CUresult(err), sparseProperties)

@cython.embedsignature(True)
def cuMipmappedArrayGetSparseProperties(mipmap):
    """ Returns the layout properties of a sparse CUDA mipmapped array.

    Returns the sparse array layout properties in `sparseProperties` If the
    CUDA mipmapped array is not allocated with flag CUDA_ARRAY3D_SPARSE
    CUDA_ERROR_INVALID_VALUE will be returned.

    For non-layered CUDA mipmapped arrays,
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailSize returns the size of the mip
    tail region. The mip tail region includes all mip levels whose width,
    height or depth is less than that of the tile. For layered CUDA
    mipmapped arrays, if CUDA_ARRAY_SPARSE_PROPERTIES::flags contains
    CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL, then
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailSize specifies the size of the mip
    tail of all layers combined. Otherwise,
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailSize specifies mip tail size per
    layer. The returned value of
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailFirstLevel is valid only if
    CUDA_ARRAY_SPARSE_PROPERTIES::miptailSize is non-zero.

    Parameters
    ----------
    mipmap : Any
        CUDA mipmapped array to get the sparse properties of

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    sparseProperties : CUDA_ARRAY_SPARSE_PROPERTIES
        Pointer to CUDA_ARRAY_SPARSE_PROPERTIES

    See Also
    --------
    cuArrayGetSparseProperties
    cuMemMapArrayAsync
    """
    cdef ccuda.CUmipmappedArray cmipmap
    if mipmap is None:
        cmipmap = <ccuda.CUmipmappedArray><void_ptr>0
    elif isinstance(mipmap, (CUmipmappedArray)):
        pmipmap = int(mipmap)
        cmipmap = <ccuda.CUmipmappedArray><void_ptr>pmipmap
    else:
        pmipmap = int(CUmipmappedArray(mipmap))
        cmipmap = <ccuda.CUmipmappedArray><void_ptr>pmipmap

    cdef CUDA_ARRAY_SPARSE_PROPERTIES sparseProperties = CUDA_ARRAY_SPARSE_PROPERTIES()
    err = ccuda.cuMipmappedArrayGetSparseProperties(sparseProperties._ptr, cmipmap)
    return (CUresult(err), sparseProperties)

@cython.embedsignature(True)
def cuArrayGetMemoryRequirements(array, device):
    """ Returns the memory requirements of a CUDA array.

    Returns the memory requirements of a CUDA array in `memoryRequirements`
    If the CUDA array is not allocated with flag
    CUDA_ARRAY3D_DEFERRED_MAPPING CUDA_ERROR_INVALID_VALUE will be
    returned.

    The returned value in CUDA_ARRAY_MEMORY_REQUIREMENTS::size represents
    the total size of the CUDA array. The returned value in
    CUDA_ARRAY_MEMORY_REQUIREMENTS::alignment represents the alignment
    necessary for mapping the CUDA array.

    Parameters
    ----------
    array : Any
        CUDA array to get the memory requirements of
    device : Any
        Device to get the memory requirements for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    memoryRequirements : CUDA_ARRAY_MEMORY_REQUIREMENTS
        Pointer to CUDA_ARRAY_MEMORY_REQUIREMENTS

    See Also
    --------
    cuMipmappedArrayGetMemoryRequirements
    cuMemMapArrayAsync
    """
    cdef ccuda.CUdevice cdevice
    if device is None:
        cdevice = <ccuda.CUdevice>0
    elif isinstance(device, (CUdevice)):
        pdevice = int(device)
        cdevice = <ccuda.CUdevice>pdevice
    else:
        pdevice = int(CUdevice(device))
        cdevice = <ccuda.CUdevice>pdevice

    cdef ccuda.CUarray carray
    if array is None:
        carray = <ccuda.CUarray><void_ptr>0
    elif isinstance(array, (CUarray)):
        parray = int(array)
        carray = <ccuda.CUarray><void_ptr>parray
    else:
        parray = int(CUarray(array))
        carray = <ccuda.CUarray><void_ptr>parray

    cdef CUDA_ARRAY_MEMORY_REQUIREMENTS memoryRequirements = CUDA_ARRAY_MEMORY_REQUIREMENTS()
    err = ccuda.cuArrayGetMemoryRequirements(memoryRequirements._ptr, carray, cdevice)
    return (CUresult(err), memoryRequirements)

@cython.embedsignature(True)
def cuMipmappedArrayGetMemoryRequirements(mipmap, device):
    """ Returns the memory requirements of a CUDA mipmapped array.

    Returns the memory requirements of a CUDA mipmapped array in
    `memoryRequirements` If the CUDA mipmapped array is not allocated with
    flag CUDA_ARRAY3D_DEFERRED_MAPPING CUDA_ERROR_INVALID_VALUE will be
    returned.

    The returned value in CUDA_ARRAY_MEMORY_REQUIREMENTS::size represents
    the total size of the CUDA mipmapped array. The returned value in
    CUDA_ARRAY_MEMORY_REQUIREMENTS::alignment represents the alignment
    necessary for mapping the CUDA mipmapped  array.

    Parameters
    ----------
    mipmap : Any
        CUDA mipmapped array to get the memory requirements of
    device : Any
        Device to get the memory requirements for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    memoryRequirements : CUDA_ARRAY_MEMORY_REQUIREMENTS
        Pointer to CUDA_ARRAY_MEMORY_REQUIREMENTS

    See Also
    --------
    cuArrayGetMemoryRequirements
    cuMemMapArrayAsync
    """
    cdef ccuda.CUdevice cdevice
    if device is None:
        cdevice = <ccuda.CUdevice>0
    elif isinstance(device, (CUdevice)):
        pdevice = int(device)
        cdevice = <ccuda.CUdevice>pdevice
    else:
        pdevice = int(CUdevice(device))
        cdevice = <ccuda.CUdevice>pdevice

    cdef ccuda.CUmipmappedArray cmipmap
    if mipmap is None:
        cmipmap = <ccuda.CUmipmappedArray><void_ptr>0
    elif isinstance(mipmap, (CUmipmappedArray)):
        pmipmap = int(mipmap)
        cmipmap = <ccuda.CUmipmappedArray><void_ptr>pmipmap
    else:
        pmipmap = int(CUmipmappedArray(mipmap))
        cmipmap = <ccuda.CUmipmappedArray><void_ptr>pmipmap

    cdef CUDA_ARRAY_MEMORY_REQUIREMENTS memoryRequirements = CUDA_ARRAY_MEMORY_REQUIREMENTS()
    err = ccuda.cuMipmappedArrayGetMemoryRequirements(memoryRequirements._ptr, cmipmap, cdevice)
    return (CUresult(err), memoryRequirements)

@cython.embedsignature(True)
def cuArrayGetPlane(hArray, unsigned int planeIdx):
    """ Gets a CUDA array plane from a CUDA array.

    Returns in `pPlaneArray` a CUDA array that represents a single format
    plane of the CUDA array `hArray`.

    If `planeIdx` is greater than the maximum number of planes in this
    array or if the array does not have a multi-planar format e.g:
    CU_AD_FORMAT_NV12, then CUDA_ERROR_INVALID_VALUE is returned.

    Note that if the `hArray` has format CU_AD_FORMAT_NV12, then passing in
    0 for `planeIdx` returns a CUDA array of the same size as `hArray` but
    with one channel and CU_AD_FORMAT_UNSIGNED_INT8 as its format. If 1 is
    passed for `planeIdx`, then the returned CUDA array has half the height
    and width of `hArray` with two channels and CU_AD_FORMAT_UNSIGNED_INT8
    as its format.

    Parameters
    ----------
    hArray : Any
        Multiplanar CUDA array
    planeIdx : unsigned int
        Plane index

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    pPlaneArray : CUarray
        Returned CUDA array referenced by the `planeIdx`

    See Also
    --------
    cuArrayCreate
    cudaGetArrayPlane
    """
    cdef ccuda.CUarray chArray
    if hArray is None:
        chArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(hArray, (CUarray)):
        phArray = int(hArray)
        chArray = <ccuda.CUarray><void_ptr>phArray
    else:
        phArray = int(CUarray(hArray))
        chArray = <ccuda.CUarray><void_ptr>phArray

    cdef CUarray pPlaneArray = CUarray()
    err = ccuda.cuArrayGetPlane(pPlaneArray._ptr, chArray, planeIdx)
    return (CUresult(err), pPlaneArray)

@cython.embedsignature(True)
def cuArrayDestroy(hArray):
    """ Destroys a CUDA array.

    Destroys the CUDA array `hArray`.

    Parameters
    ----------
    hArray : Any
        Array to destroy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_ARRAY_IS_MAPPED
        CUDA_ERROR_CONTEXT_IS_DESTROYED
    None
        None

    See Also
    --------
    cuArray3DCreate
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaFreeArray
    """
    cdef ccuda.CUarray chArray
    if hArray is None:
        chArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(hArray, (CUarray)):
        phArray = int(hArray)
        chArray = <ccuda.CUarray><void_ptr>phArray
    else:
        phArray = int(CUarray(hArray))
        chArray = <ccuda.CUarray><void_ptr>phArray

    err = ccuda.cuArrayDestroy(chArray)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuArray3DCreate(pAllocateArray : CUDA_ARRAY3D_DESCRIPTOR):
    """ Creates a 3D CUDA array.

    Creates a CUDA array according to the CUDA_ARRAY3D_DESCRIPTOR structure
    `pAllocateArray` and returns a handle to the new CUDA array in
    `*pHandle`. The CUDA_ARRAY3D_DESCRIPTOR is defined as:

    typedefstruct{ unsignedintWidth; unsignedintHeight; unsignedintDepth;
    CUarray_formatFormat; unsignedintNumChannels; unsignedintFlags;
    }CUDA_ARRAY3D_DESCRIPTOR; where:

    - `Width`, `Height`, and `Depth` are the width, height, and depth of
    the CUDA array (in elements); the following types of CUDA arrays can be
    allocated:    - A 1D array is allocated if `Height` and `Depth` extents
    are both zero.     - A 2D array is allocated if only `Depth` extent is
    zero.     - A 3D array is allocated if all three extents are non-zero.
    - A 1D layered CUDA array is allocated if only `Height` is zero and the
    CUDA_ARRAY3D_LAYERED flag is set. Each layer is a 1D array. The number
    of layers is determined by the depth extent.     - A 2D layered CUDA
    array is allocated if all three extents are non-zero and the
    CUDA_ARRAY3D_LAYERED flag is set. Each layer is a 2D array. The number
    of layers is determined by the depth extent.     - A cubemap CUDA array
    is allocated if all three extents are non-zero and the
    CUDA_ARRAY3D_CUBEMAP flag is set. `Width` must be equal to `Height`,
    and `Depth` must be six. A cubemap is a special type of 2D layered CUDA
    array, where the six layers represent the six faces of a cube. The
    order of the six layers in memory is the same as that listed in
    CUarray_cubemap_face.     - A cubemap layered CUDA array is allocated
    if all three extents are non-zero, and both, CUDA_ARRAY3D_CUBEMAP and
    CUDA_ARRAY3D_LAYERED flags are set. `Width` must be equal to `Height`,
    and `Depth` must be a multiple of six. A cubemap layered CUDA array is
    a special type of 2D layered CUDA array that consists of a collection
    of cubemaps. The first six layers represent the first cubemap, the next
    six layers form the second cubemap, and so on.     - Format specifies
    the format of the elements; CUarray_format is defined as:
    typedefenumCUarray_format_enum{ CU_AD_FORMAT_UNSIGNED_INT8=0x01,
    CU_AD_FORMAT_UNSIGNED_INT16=0x02, CU_AD_FORMAT_UNSIGNED_INT32=0x03,
    CU_AD_FORMAT_SIGNED_INT8=0x08, CU_AD_FORMAT_SIGNED_INT16=0x09,
    CU_AD_FORMAT_SIGNED_INT32=0x0a, CU_AD_FORMAT_HALF=0x10,
    CU_AD_FORMAT_FLOAT=0x20 }CUarray_format;     - `NumChannels` specifies
    the number of packed components per CUDA array element; it may be 1, 2,
    or 4;    - Flags may be set to    - CUDA_ARRAY3D_LAYERED to enable
    creation of layered CUDA arrays. If this flag is set, `Depth` specifies
    the number of layers, not the depth of a 3D array.     -
    CUDA_ARRAY3D_SURFACE_LDST to enable surface references to be bound to
    the CUDA array. If this flag is not set, cuSurfRefSetArray will fail
    when attempting to bind the CUDA array to a surface reference.     -
    CUDA_ARRAY3D_CUBEMAP to enable creation of cubemaps. If this flag is
    set, `Width` must be equal to `Height`, and `Depth` must be six. If the
    CUDA_ARRAY3D_LAYERED flag is also set, then `Depth` must be a multiple
    of six.     - CUDA_ARRAY3D_TEXTURE_GATHER to indicate that the CUDA
    array will be used for texture gather. Texture gather can only be
    performed on 2D CUDA arrays.

    `Width`, `Height` and `Depth` must meet certain size requirements as
    listed in the following table. All values are specified in elements.
    Note that for brevity's sake, the full name of the device attribute is
    not specified. For ex., TEXTURE1D_WIDTH refers to the device attribute
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_WIDTH.

    Note that 2D CUDA arrays have different size requirements if the
    CUDA_ARRAY3D_TEXTURE_GATHER flag is set. `Width` and `Height` must not
    be greater than CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_WIDTH and
    CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE2D_GATHER_HEIGHT respectively, in
    that case.

    CUDA array type  Valid extents that must always be met {(width range in
    elements), (height range), (depth range)}  Valid extents with
    CUDA_ARRAY3D_SURFACE_LDST set {(width range in elements), (height
    range), (depth range)}    1D  { (1,TEXTURE1D_WIDTH), 0, 0 }  {
    (1,SURFACE1D_WIDTH), 0, 0 }    2D  { (1,TEXTURE2D_WIDTH),
    (1,TEXTURE2D_HEIGHT), 0 }  { (1,SURFACE2D_WIDTH), (1,SURFACE2D_HEIGHT),
    0 }    3D  { (1,TEXTURE3D_WIDTH), (1,TEXTURE3D_HEIGHT),
    (1,TEXTURE3D_DEPTH) }  OR { (1,TEXTURE3D_WIDTH_ALTERNATE),
    (1,TEXTURE3D_HEIGHT_ALTERNATE), (1,TEXTURE3D_DEPTH_ALTERNATE) }  {
    (1,SURFACE3D_WIDTH), (1,SURFACE3D_HEIGHT), (1,SURFACE3D_DEPTH) }    1D
    Layered  { (1,TEXTURE1D_LAYERED_WIDTH), 0, (1,TEXTURE1D_LAYERED_LAYERS)
    }  { (1,SURFACE1D_LAYERED_WIDTH), 0, (1,SURFACE1D_LAYERED_LAYERS) }
    2D Layered  { (1,TEXTURE2D_LAYERED_WIDTH),
    (1,TEXTURE2D_LAYERED_HEIGHT), (1,TEXTURE2D_LAYERED_LAYERS) }  {
    (1,SURFACE2D_LAYERED_WIDTH), (1,SURFACE2D_LAYERED_HEIGHT),
    (1,SURFACE2D_LAYERED_LAYERS) }    Cubemap  { (1,TEXTURECUBEMAP_WIDTH),
    (1,TEXTURECUBEMAP_WIDTH), 6 }  { (1,SURFACECUBEMAP_WIDTH),
    (1,SURFACECUBEMAP_WIDTH), 6 }    Cubemap Layered  {
    (1,TEXTURECUBEMAP_LAYERED_WIDTH), (1,TEXTURECUBEMAP_LAYERED_WIDTH),
    (1,TEXTURECUBEMAP_LAYERED_LAYERS) }  {
    (1,SURFACECUBEMAP_LAYERED_WIDTH), (1,SURFACECUBEMAP_LAYERED_WIDTH),
    (1,SURFACECUBEMAP_LAYERED_LAYERS) }

    Here are examples of CUDA array descriptions:

    Description for a CUDA array of 2048 floats:
    CUDA_ARRAY3D_DESCRIPTORdesc; desc.Format=CU_AD_FORMAT_FLOAT;
    desc.NumChannels=1; desc.Width=2048; desc.Height=0; desc.Depth=0;

    Description for a 64 x 64 CUDA array of floats:
    CUDA_ARRAY3D_DESCRIPTORdesc; desc.Format=CU_AD_FORMAT_FLOAT;
    desc.NumChannels=1; desc.Width=64; desc.Height=64; desc.Depth=0;

    Description for a `width` x `height` x `depth` CUDA array of 64-bit,
    4x16-bit float16's: CUDA_ARRAY3D_DESCRIPTORdesc;
    desc.Format=CU_AD_FORMAT_HALF; desc.NumChannels=4; desc.Width=width;
    desc.Height=height; desc.Depth=depth;

    Parameters
    ----------
    pAllocateArray : CUDA_ARRAY3D_DESCRIPTOR
        3D array descriptor

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_UNKNOWN
    pHandle : CUarray
        Returned array

    See Also
    --------
    cuArray3DGetDescriptor
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaMalloc3DArray
    """
    cdef CUarray pHandle = CUarray()
    cdef ccuda.CUDA_ARRAY3D_DESCRIPTOR* cpAllocateArray_ptr = pAllocateArray._ptr if pAllocateArray != None else NULL
    err = ccuda.cuArray3DCreate(pHandle._ptr, cpAllocateArray_ptr)
    return (CUresult(err), pHandle)

@cython.embedsignature(True)
def cuArray3DGetDescriptor(hArray):
    """ Get a 3D CUDA array descriptor.

    Returns in `*pArrayDescriptor` a descriptor containing information on
    the format and dimensions of the CUDA array `hArray`. It is useful for
    subroutines that have been passed a CUDA array, but need to know the
    CUDA array parameters for validation or other purposes.

    This function may be called on 1D and 2D arrays, in which case the
    `Height` and/or `Depth` members of the descriptor struct will be set to
    0.

    Parameters
    ----------
    hArray : Any
        3D array to get descriptor of

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_CONTEXT_IS_DESTROYED
    pArrayDescriptor : CUDA_ARRAY3D_DESCRIPTOR
        Returned 3D array descriptor

    See Also
    --------
    cuArray3DCreate
    cuArrayCreate
    cuArrayDestroy
    cuArrayGetDescriptor
    cuMemAlloc
    cuMemAllocHost
    cuMemAllocPitch
    cuMemcpy2D
    cuMemcpy2DAsync
    cuMemcpy2DUnaligned
    cuMemcpy3D
    cuMemcpy3DAsync
    cuMemcpyAtoA
    cuMemcpyAtoD
    cuMemcpyAtoH
    cuMemcpyAtoHAsync
    cuMemcpyDtoA
    cuMemcpyDtoD
    cuMemcpyDtoDAsync
    cuMemcpyDtoH
    cuMemcpyDtoHAsync
    cuMemcpyHtoA
    cuMemcpyHtoAAsync
    cuMemcpyHtoD
    cuMemcpyHtoDAsync
    cuMemFree
    cuMemFreeHost
    cuMemGetAddressRange
    cuMemGetInfo
    cuMemHostAlloc
    cuMemHostGetDevicePointer
    cuMemsetD2D8
    cuMemsetD2D16
    cuMemsetD2D32
    cuMemsetD8
    cuMemsetD16
    cuMemsetD32
    cudaArrayGetInfo
    """
    cdef ccuda.CUarray chArray
    if hArray is None:
        chArray = <ccuda.CUarray><void_ptr>0
    elif isinstance(hArray, (CUarray)):
        phArray = int(hArray)
        chArray = <ccuda.CUarray><void_ptr>phArray
    else:
        phArray = int(CUarray(hArray))
        chArray = <ccuda.CUarray><void_ptr>phArray

    cdef CUDA_ARRAY3D_DESCRIPTOR pArrayDescriptor = CUDA_ARRAY3D_DESCRIPTOR()
    err = ccuda.cuArray3DGetDescriptor(pArrayDescriptor._ptr, chArray)
    return (CUresult(err), pArrayDescriptor)

@cython.embedsignature(True)
def cuMipmappedArrayCreate(pMipmappedArrayDesc : CUDA_ARRAY3D_DESCRIPTOR, unsigned int numMipmapLevels):
    """ Creates a CUDA mipmapped array.

    Creates a CUDA mipmapped array according to the CUDA_ARRAY3D_DESCRIPTOR
    structure `pMipmappedArrayDesc` and returns a handle to the new CUDA
    mipmapped array in `*pHandle`. `numMipmapLevels` specifies the number
    of mipmap levels to be allocated. This value is clamped to the range
    [1, 1 + floor(log2(max(width, height, depth)))].

    The CUDA_ARRAY3D_DESCRIPTOR is defined as:

    typedefstruct{ unsignedintWidth; unsignedintHeight; unsignedintDepth;
    CUarray_formatFormat; unsignedintNumChannels; unsignedintFlags;
    }CUDA_ARRAY3D_DESCRIPTOR; where:

    - `Width`, `Height`, and `Depth` are the width, height, and depth of
    the CUDA array (in elements); the following types of CUDA arrays can be
    allocated:    - A 1D mipmapped array is allocated if `Height` and
    `Depth` extents are both zero.     - A 2D mipmapped array is allocated
    if only `Depth` extent is zero.     - A 3D mipmapped array is allocated
    if all three extents are non-zero.     - A 1D layered CUDA mipmapped
    array is allocated if only `Height` is zero and the
    CUDA_ARRAY3D_LAYERED flag is set. Each layer is a 1D array. The number
    of layers is determined by the depth extent.     - A 2D layered CUDA
    mipmapped array is allocated if all three extents are non-zero and the
    CUDA_ARRAY3D_LAYERED flag is set. Each layer is a 2D array. The number
    of layers is determined by the depth extent.     - A cubemap CUDA
    mipmapped array is allocated if all three extents are non-zero and the
    CUDA_ARRAY3D_CUBEMAP flag is set. `Width` must be equal to `Height`,
    and `Depth` must be six. A cubemap is a special type of 2D layered CUDA
    array, where the six layers represent the six faces of a cube. The
    order of the six layers in memory is the same as that listed in
    CUarray_cubemap_face.     - A cubemap layered CUDA mipmapped array is
    allocated if all three extents are non-zero, and both,
    CUDA_ARRAY3D_CUBEMAP and CUDA_ARRAY3D_LAYERED flags are set. `Width`
    must be equal to `Height`, and `Depth` must be a multiple of six. A
    cubemap layered CUDA array is a special type of 2D layered CUDA array
    that consists of a collection of cubemaps. The first six layers
    represent the first cubemap, the next six layers form the second
    cubemap, and so on.     - Format specifies the format of the elements;
    CUarray_format is defined as: typedefenumCUarray_format_enum{
    CU_AD_FORMAT_UNSIGNED_INT8=0x01, CU_AD_FORMAT_UNSIGNED_INT16=0x02,
    CU_AD_FORMAT_UNSIGNED_INT32=0x03, CU_AD_FORMAT_SIGNED_INT8=0x08,
    CU_AD_FORMAT_SIGNED_INT16=0x09, CU_AD_FORMAT_SIGNED_INT32=0x0a,
    CU_AD_FORMAT_HALF=0x10, CU_AD_FORMAT_FLOAT=0x20 }CUarray_format;     -
    `NumChannels` specifies the number of packed components per CUDA array
    element; it may be 1, 2, or 4;    - Flags may be set to    -
    CUDA_ARRAY3D_LAYERED to enable creation of layered CUDA mipmapped
    arrays. If this flag is set, `Depth` specifies the number of layers,
    not the depth of a 3D array.     - CUDA_ARRAY3D_SURFACE_LDST to enable
    surface references to be bound to individual mipmap levels of the CUDA
    mipmapped array. If this flag is not set, cuSurfRefSetArray will fail
    when attempting to bind a mipmap level of the CUDA mipmapped array to a
    surface reference.      - CUDA_ARRAY3D_CUBEMAP to enable creation of
    mipmapped cubemaps. If this flag is set, `Width` must be equal to
    `Height`, and `Depth` must be six. If the CUDA_ARRAY3D_LAYERED flag is
    also set, then `Depth` must be a multiple of six.      -
    CUDA_ARRAY3D_TEXTURE_GATHER to indicate that the CUDA mipmapped array
    will be used for texture gather. Texture gather can only be performed
    on 2D CUDA mipmapped arrays.

    `Width`, `Height` and `Depth` must meet certain size requirements as
    listed in the following table. All values are specified in elements.
    Note that for brevity's sake, the full name of the device attribute is
    not specified. For ex., TEXTURE1D_MIPMAPPED_WIDTH refers to the device
    attribute CU_DEVICE_ATTRIBUTE_MAXIMUM_TEXTURE1D_MIPMAPPED_WIDTH.

    CUDA array type  Valid extents that must always be met {(width range in
    elements), (height range), (depth range)}  Valid extents with
    CUDA_ARRAY3D_SURFACE_LDST set {(width range in elements), (height
    range), (depth range)}    1D  { (1,TEXTURE1D_MIPMAPPED_WIDTH), 0, 0 }
    { (1,SURFACE1D_WIDTH), 0, 0 }    2D  { (1,TEXTURE2D_MIPMAPPED_WIDTH),
    (1,TEXTURE2D_MIPMAPPED_HEIGHT), 0 }  { (1,SURFACE2D_WIDTH),
    (1,SURFACE2D_HEIGHT), 0 }    3D  { (1,TEXTURE3D_WIDTH),
    (1,TEXTURE3D_HEIGHT), (1,TEXTURE3D_DEPTH) }  OR {
    (1,TEXTURE3D_WIDTH_ALTERNATE), (1,TEXTURE3D_HEIGHT_ALTERNATE),
    (1,TEXTURE3D_DEPTH_ALTERNATE) }  { (1,SURFACE3D_WIDTH),
    (1,SURFACE3D_HEIGHT), (1,SURFACE3D_DEPTH) }    1D Layered  {
    (1,TEXTURE1D_LAYERED_WIDTH), 0, (1,TEXTURE1D_LAYERED_LAYERS) }  {
    (1,SURFACE1D_LAYERED_WIDTH), 0, (1,SURFACE1D_LAYERED_LAYERS) }    2D
    Layered  { (1,TEXTURE2D_LAYERED_WIDTH), (1,TEXTURE2D_LAYERED_HEIGHT),
    (1,TEXTURE2D_LAYERED_LAYERS) }  { (1,SURFACE2D_LAYERED_WIDTH),
    (1,SURFACE2D_LAYERED_HEIGHT), (1,SURFACE2D_LAYERED_LAYERS) }    Cubemap
    { (1,TEXTURECUBEMAP_WIDTH), (1,TEXTURECUBEMAP_WIDTH), 6 }  {
    (1,SURFACECUBEMAP_WIDTH), (1,SURFACECUBEMAP_WIDTH), 6 }    Cubemap
    Layered  { (1,TEXTURECUBEMAP_LAYERED_WIDTH),
    (1,TEXTURECUBEMAP_LAYERED_WIDTH), (1,TEXTURECUBEMAP_LAYERED_LAYERS) }
    { (1,SURFACECUBEMAP_LAYERED_WIDTH), (1,SURFACECUBEMAP_LAYERED_WIDTH),
    (1,SURFACECUBEMAP_LAYERED_LAYERS) }

    Parameters
    ----------
    pMipmappedArrayDesc : CUDA_ARRAY3D_DESCRIPTOR
        mipmapped array descriptor
    numMipmapLevels : unsigned int
        Number of mipmap levels

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_UNKNOWN
    pHandle : CUmipmappedArray
        Returned mipmapped array

    See Also
    --------
    cuMipmappedArrayDestroy
    cuMipmappedArrayGetLevel
    cuArrayCreate
    cudaMallocMipmappedArray
    """
    cdef CUmipmappedArray pHandle = CUmipmappedArray()
    cdef ccuda.CUDA_ARRAY3D_DESCRIPTOR* cpMipmappedArrayDesc_ptr = pMipmappedArrayDesc._ptr if pMipmappedArrayDesc != None else NULL
    err = ccuda.cuMipmappedArrayCreate(pHandle._ptr, cpMipmappedArrayDesc_ptr, numMipmapLevels)
    return (CUresult(err), pHandle)

@cython.embedsignature(True)
def cuMipmappedArrayGetLevel(hMipmappedArray, unsigned int level):
    """ Gets a mipmap level of a CUDA mipmapped array.

    Returns in `*pLevelArray` a CUDA array that represents a single mipmap
    level of the CUDA mipmapped array `hMipmappedArray`.

    If `level` is greater than the maximum number of levels in this
    mipmapped array, CUDA_ERROR_INVALID_VALUE is returned.

    Parameters
    ----------
    hMipmappedArray : Any
        CUDA mipmapped array
    level : unsigned int
        Mipmap level

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    pLevelArray : CUarray
        Returned mipmap level CUDA array

    See Also
    --------
    cuMipmappedArrayCreate
    cuMipmappedArrayDestroy
    cuArrayCreate
    cudaGetMipmappedArrayLevel
    """
    cdef ccuda.CUmipmappedArray chMipmappedArray
    if hMipmappedArray is None:
        chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>0
    elif isinstance(hMipmappedArray, (CUmipmappedArray)):
        phMipmappedArray = int(hMipmappedArray)
        chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>phMipmappedArray
    else:
        phMipmappedArray = int(CUmipmappedArray(hMipmappedArray))
        chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>phMipmappedArray

    cdef CUarray pLevelArray = CUarray()
    err = ccuda.cuMipmappedArrayGetLevel(pLevelArray._ptr, chMipmappedArray, level)
    return (CUresult(err), pLevelArray)

@cython.embedsignature(True)
def cuMipmappedArrayDestroy(hMipmappedArray):
    """ Destroys a CUDA mipmapped array.

    Destroys the CUDA mipmapped array `hMipmappedArray`.

    Parameters
    ----------
    hMipmappedArray : Any
        Mipmapped array to destroy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_ARRAY_IS_MAPPED
        CUDA_ERROR_CONTEXT_IS_DESTROYED
    None
        None

    See Also
    --------
    cuMipmappedArrayCreate
    cuMipmappedArrayGetLevel
    cuArrayCreate
    cudaFreeMipmappedArray
    """
    cdef ccuda.CUmipmappedArray chMipmappedArray
    if hMipmappedArray is None:
        chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>0
    elif isinstance(hMipmappedArray, (CUmipmappedArray)):
        phMipmappedArray = int(hMipmappedArray)
        chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>phMipmappedArray
    else:
        phMipmappedArray = int(CUmipmappedArray(hMipmappedArray))
        chMipmappedArray = <ccuda.CUmipmappedArray><void_ptr>phMipmappedArray

    err = ccuda.cuMipmappedArrayDestroy(chMipmappedArray)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemAddressReserve(size_t size, size_t alignment, addr, unsigned long long flags):
    """ Allocate an address range reservation.

    Reserves a virtual address range based on the given parameters, giving
    the starting address of the range in `ptr`. This API requires a system
    that supports UVA. The size and address parameters must be a multiple
    of the host page size and the alignment must be a power of two or zero
    for default alignment.

    Parameters
    ----------
    size : size_t
        Size of the reserved virtual address range requested
    alignment : size_t
        Alignment of the reserved virtual address range requested
    addr : Any
        Fixed starting address range requested
    flags : unsigned long long
        Currently unused, must be zero

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    ptr : CUdeviceptr
        Resulting pointer to start of virtual address range allocated

    See Also
    --------
    cuMemAddressFree
    """
    cdef ccuda.CUdeviceptr caddr
    if addr is None:
        caddr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(addr, (CUdeviceptr)):
        paddr = int(addr)
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr
    else:
        paddr = int(CUdeviceptr(addr))
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr

    cdef CUdeviceptr ptr = CUdeviceptr()
    err = ccuda.cuMemAddressReserve(ptr._ptr, size, alignment, caddr, flags)
    return (CUresult(err), ptr)

@cython.embedsignature(True)
def cuMemAddressFree(ptr, size_t size):
    """ Free an address range reservation.

    Frees a virtual address range reserved by cuMemAddressReserve. The size
    must match what was given to memAddressReserve and the ptr given must
    match what was returned from memAddressReserve.

    Parameters
    ----------
    ptr : Any
        Starting address of the virtual address range to free
    size : size_t
        Size of the virtual address region to free

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemAddressReserve
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    err = ccuda.cuMemAddressFree(cptr, size)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemCreate(size_t size, prop : CUmemAllocationProp, unsigned long long flags):
    """ Create a CUDA memory handle representing a memory allocation of a given size described by the given properties.

    This creates a memory allocation on the target device specified through
    the `prop` strcuture. The created allocation will not have any device
    or host mappings. The generic memory `handle` for the allocation can be
    mapped to the address space of calling process via cuMemMap. This
    handle cannot be transmitted directly to other processes (see
    cuMemExportToShareableHandle). On Windows, the caller must also pass an
    LPSECURITYATTRIBUTE in `prop` to be associated with this handle which
    limits or allows access to this handle for a recepient process (see
    CUmemAllocationProp::win32HandleMetaData for more). The `size` of this
    allocation must be a multiple of the the value given via
    cuMemGetAllocationGranularity with the CU_MEM_ALLOC_GRANULARITY_MINIMUM
    flag. If CUmemAllocationProp::allocFlags::usage contains
    CU_MEM_CREATE_USAGE_TILE_POOL flag then the memory allocation is
    intended only to be used as backing tile pool for sparse CUDA arrays
    and sparse CUDA mipmapped arrays. (see cuMemMapArrayAsync).

    Parameters
    ----------
    size : size_t
        Size of the allocation requested
    prop : CUmemAllocationProp
        Properties of the allocation to create.
    flags : unsigned long long
        flags for future use, must be zero now.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    handle : CUmemGenericAllocationHandle
        Value of handle returned. All operations on this allocation are to
        be performed using this handle.

    See Also
    --------
    cuMemRelease
    cuMemExportToShareableHandle
    cuMemImportFromShareableHandle
    """
    cdef CUmemGenericAllocationHandle handle = CUmemGenericAllocationHandle()
    cdef ccuda.CUmemAllocationProp* cprop_ptr = prop._ptr if prop != None else NULL
    err = ccuda.cuMemCreate(handle._ptr, size, cprop_ptr, flags)
    return (CUresult(err), handle)

@cython.embedsignature(True)
def cuMemRelease(handle):
    """ Release a memory handle representing a memory allocation which was previously allocated through cuMemCreate.

    Frees the memory that was allocated on a device through cuMemCreate.

    The memory allocation will be freed when all outstanding mappings to
    the memory are unmapped and when all outstanding references to the
    handle (including it's shareable counterparts) are also released. The
    generic memory handle can be freed when there are still outstanding
    mappings made with this handle. Each time a recepient process imports a
    shareable handle, it needs to pair it with cuMemRelease for the handle
    to be freed. If `handle` is not a valid handle the behavior is
    undefined.

    Parameters
    ----------
    handle : Any
        Value of handle which was returned previously by cuMemCreate.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemCreate
    """
    cdef ccuda.CUmemGenericAllocationHandle chandle
    if handle is None:
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>0
    elif isinstance(handle, (CUmemGenericAllocationHandle)):
        phandle = int(handle)
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle
    else:
        phandle = int(CUmemGenericAllocationHandle(handle))
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle

    err = ccuda.cuMemRelease(chandle)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemMap(ptr, size_t size, size_t offset, handle, unsigned long long flags):
    """ Maps an allocation handle to a reserved virtual address range.

    Maps bytes of memory represented by `handle` starting from byte
    `offset` to `size` to address range [`addr`, `addr` + `size`]. This
    range must be an address reservation previously reserved with
    cuMemAddressReserve, and `offset` + `size` must be less than the size
    of the memory allocation. Both `ptr`, `size`, and `offset` must be a
    multiple of the value given via cuMemGetAllocationGranularity with the
    CU_MEM_ALLOC_GRANULARITY_MINIMUM flag.

    Please note calling cuMemMap does not make the address accessible, the
    caller needs to update accessibility of a contiguous mapped VA range by
    calling cuMemSetAccess.

    Once a recipient process obtains a shareable memory handle from
    cuMemImportFromShareableHandle, the process must use cuMemMap to map
    the memory into its address ranges before setting accessibility with
    cuMemSetAccess.

    cuMemMap can only create mappings on VA range reservations that are not
    currently mapped.

    Parameters
    ----------
    ptr : Any
        Address where memory will be mapped.
    size : size_t
        Size of the memory mapping.
    offset : size_t
        Offset into the memory represented by - `handle` from which to
        start mapping    - Note: currently must be zero.
    handle : Any
        Handle to a shareable memory
    flags : unsigned long long
        flags for future use, must be zero now.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemUnmap
    cuMemSetAccess
    cuMemCreate
    cuMemAddressReserve
    cuMemImportFromShareableHandle
    """
    cdef ccuda.CUmemGenericAllocationHandle chandle
    if handle is None:
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>0
    elif isinstance(handle, (CUmemGenericAllocationHandle)):
        phandle = int(handle)
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle
    else:
        phandle = int(CUmemGenericAllocationHandle(handle))
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle

    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    err = ccuda.cuMemMap(cptr, size, offset, chandle, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemMapArrayAsync(mapInfoList : List[CUarrayMapInfo], unsigned int count, hStream):
    """ Maps or unmaps subregions of sparse CUDA arrays and sparse CUDA mipmapped arrays.

    Performs map or unmap operations on subregions of sparse CUDA arrays
    and sparse CUDA mipmapped arrays. Each operation is specified by a
    CUarrayMapInfo entry in the `mapInfoList` array of size `count`. The
    structure CUarrayMapInfo is defined as follow:
    typedefstructCUarrayMapInfo_st{ CUresourcetyperesourceType; union{
    CUmipmappedArraymipmap; CUarrayarray; }resource;
    CUarraySparseSubresourceTypesubresourceType; union{ struct{
    unsignedintlevel; unsignedintlayer; unsignedintoffsetX;
    unsignedintoffsetY; unsignedintoffsetZ; unsignedintextentWidth;
    unsignedintextentHeight; unsignedintextentDepth; }sparseLevel; struct{
    unsignedintlayer; unsignedlonglongoffset; unsignedlonglongsize;
    }miptail; }subresource;  CUmemOperationTypememOperationType;
    CUmemHandleTypememHandleType; union{
    CUmemGenericAllocationHandlememHandle; }memHandle;
    unsignedlonglongoffset; unsignedintdeviceBitMask; unsignedintflags;
    unsignedintreserved[2]; }CUarrayMapInfo;

    where CUarrayMapInfo::resourceType specifies the type of resource to be
    operated on. If CUarrayMapInfo::resourceType is set to
    CUresourcetype::CU_RESOURCE_TYPE_ARRAY then
    CUarrayMapInfo::resource::array must be set to a valid sparse CUDA
    array handle. The CUDA array must be either a 2D, 2D layered or 3D CUDA
    array and must have been allocated using cuArrayCreate or
    cuArray3DCreate with the flag CUDA_ARRAY3D_SPARSE

    or CUDA_ARRAY3D_DEFERRED_MAPPING.

    For CUDA arrays obtained using cuMipmappedArrayGetLevel,
    CUDA_ERROR_INVALID_VALUE will be returned. If
    CUarrayMapInfo::resourceType is set to
    CUresourcetype::CU_RESOURCE_TYPE_MIPMAPPED_ARRAY then
    CUarrayMapInfo::resource::mipmap must be set to a valid sparse CUDA
    mipmapped array handle. The CUDA mipmapped array must be either a 2D,
    2D layered or 3D CUDA mipmapped array and must have been allocated
    using cuMipmappedArrayCreate with the flag CUDA_ARRAY3D_SPARSE

    or CUDA_ARRAY3D_DEFERRED_MAPPING.

    CUarrayMapInfo::subresourceType specifies the type of subresource
    within the resource. CUarraySparseSubresourceType_enum is defined as:
    typedefenumCUarraySparseSubresourceType_enum{
    CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL=0,
    CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL=1
    }CUarraySparseSubresourceType;

    where CUarraySparseSubresourceType::CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SP
    ARSE_LEVEL indicates a sparse-miplevel which spans at least one tile in
    every dimension. The remaining miplevels which are too small to span at
    least one tile in any dimension constitute the mip tail region as
    indicated by
    CUarraySparseSubresourceType::CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL
    subresource type.

    If CUarrayMapInfo::subresourceType is set to CUarraySparseSubresourceTy
    pe::CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_SPARSE_LEVEL then
    CUarrayMapInfo::subresource::sparseLevel struct must contain valid
    array subregion offsets and extents. The
    CUarrayMapInfo::subresource::sparseLevel::offsetX,
    CUarrayMapInfo::subresource::sparseLevel::offsetY and
    CUarrayMapInfo::subresource::sparseLevel::offsetZ must specify valid X,
    Y and Z offsets respectively. The
    CUarrayMapInfo::subresource::sparseLevel::extentWidth,
    CUarrayMapInfo::subresource::sparseLevel::extentHeight and
    CUarrayMapInfo::subresource::sparseLevel::extentDepth must specify
    valid width, height and depth extents respectively. These offsets and
    extents must be aligned to the corresponding tile dimension. For CUDA
    mipmapped arrays CUarrayMapInfo::subresource::sparseLevel::level must
    specify a valid mip level index. Otherwise, must be zero. For layered
    CUDA arrays and layered CUDA mipmapped arrays
    CUarrayMapInfo::subresource::sparseLevel::layer must specify a valid
    layer index. Otherwise, must be zero.
    CUarrayMapInfo::subresource::sparseLevel::offsetZ must be zero and
    CUarrayMapInfo::subresource::sparseLevel::extentDepth must be set to 1
    for 2D and 2D layered CUDA arrays and CUDA mipmapped arrays. Tile
    extents can be obtained by calling cuArrayGetSparseProperties and
    cuMipmappedArrayGetSparseProperties

    If CUarrayMapInfo::subresourceType is set to
    CUarraySparseSubresourceType::CU_ARRAY_SPARSE_SUBRESOURCE_TYPE_MIPTAIL
    then CUarrayMapInfo::subresource::miptail struct must contain valid mip
    tail offset in CUarrayMapInfo::subresource::miptail::offset and size in
    CUarrayMapInfo::subresource::miptail::size. Both, mip tail offset and
    mip tail size must be aligned to the tile size. For layered CUDA
    mipmapped arrays which don't have the flag
    CU_ARRAY_SPARSE_PROPERTIES_SINGLE_MIPTAIL set in
    CUDA_ARRAY_SPARSE_PROPERTIES::flags as returned by
    cuMipmappedArrayGetSparseProperties,
    CUarrayMapInfo::subresource::miptail::layer must specify a valid layer
    index. Otherwise, must be zero.

    If CUarrayMapInfo::resource::array or CUarrayMapInfo::resource::mipmap
    was created with CUDA_ARRAY3D_DEFERRED_MAPPING flag set the
    CUarrayMapInfo::subresourceType and the contents of
    CUarrayMapInfo::subresource will be ignored.

    CUarrayMapInfo::memOperationType specifies the type of operation.
    CUmemOperationType is defined as: typedefenumCUmemOperationType_enum{
    CU_MEM_OPERATION_TYPE_MAP=1, CU_MEM_OPERATION_TYPE_UNMAP=2
    }CUmemOperationType; If CUarrayMapInfo::memOperationType is set to
    CUmemOperationType::CU_MEM_OPERATION_TYPE_MAP then the subresource will
    be mapped onto the tile pool memory specified by
    CUarrayMapInfo::memHandle at offset CUarrayMapInfo::offset. The tile
    pool allocation has to be created by specifying the
    CU_MEM_CREATE_USAGE_TILE_POOL flag when calling cuMemCreate. Also,
    CUarrayMapInfo::memHandleType must be set to
    CUmemHandleType::CU_MEM_HANDLE_TYPE_GENERIC.

    If CUarrayMapInfo::memOperationType is set to
    CUmemOperationType::CU_MEM_OPERATION_TYPE_UNMAP then an unmapping
    operation is performed. CUarrayMapInfo::memHandle must be NULL.

    CUarrayMapInfo::deviceBitMask specifies the list of devices that must
    map or unmap physical memory. Currently, this mask must have exactly
    one bit set, and the corresponding device must match the device
    associated with the stream. If CUarrayMapInfo::memOperationType is set
    to CUmemOperationType::CU_MEM_OPERATION_TYPE_MAP, the device must also
    match the device associated with the tile pool memory allocation as
    specified by CUarrayMapInfo::memHandle.

    CUarrayMapInfo::flags and CUarrayMapInfo::reserved[] are unused and
    must be set to zero.

    Parameters
    ----------
    mapInfoList : List[CUarrayMapInfo]
        List of CUarrayMapInfo
    count : unsigned int
        Count of CUarrayMapInfo in `mapInfoList`
    hStream : CUstream or cudaStream_t
        Stream identifier for the stream to use for map or unmap operations

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuMipmappedArrayCreate
    cuArrayCreate
    cuArray3DCreate
    cuMemCreate
    cuArrayGetSparseProperties
    cuMipmappedArrayGetSparseProperties
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    mapInfoList = [] if mapInfoList is None else mapInfoList
    if not all(isinstance(_x, (CUarrayMapInfo)) for _x in mapInfoList):
        raise TypeError("Argument 'mapInfoList' is not instance of type (expected List[ccuda.CUarrayMapInfo]")

    cdef ccuda.CUarrayMapInfo* cmapInfoList = NULL
    if len(mapInfoList) > 0:
        cmapInfoList = <ccuda.CUarrayMapInfo*> calloc(len(mapInfoList), sizeof(ccuda.CUarrayMapInfo))
        if cmapInfoList is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(mapInfoList)) + 'x' + str(sizeof(ccuda.CUarrayMapInfo)))
        for idx in range(len(mapInfoList)):
            memcpy(&cmapInfoList[idx], (<CUarrayMapInfo>mapInfoList[idx])._ptr, sizeof(ccuda.CUarrayMapInfo))

    if count > len(mapInfoList): raise RuntimeError("List is too small: " + str(len(mapInfoList)) + " < " + str(count))
    err = ccuda.cuMemMapArrayAsync((<CUarrayMapInfo>mapInfoList[0])._ptr if len(mapInfoList) == 1 else cmapInfoList, count, chStream)
    if cmapInfoList is not NULL:
        free(cmapInfoList)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemUnmap(ptr, size_t size):
    """ Unmap the backing memory of a given address range.

    The range must be the entire contiguous address range that was mapped
    to. In other words, cuMemUnmap cannot unmap a sub-range of an address
    range mapped by cuMemCreate / cuMemMap. Any backing memory allocations
    will be freed if there are no existing mappings and there are no
    unreleased memory handles.

    When cuMemUnmap returns successfully the address range is converted to
    an address reservation and can be used for a future calls to cuMemMap.
    Any new mapping to this virtual address will need to have access
    granted through cuMemSetAccess, as all mappings start with no
    accessibility setup.

    Parameters
    ----------
    ptr : Any
        Starting address for the virtual address range to unmap
    size : size_t
        Size of the virtual address range to unmap

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemCreate
    cuMemAddressReserve
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    err = ccuda.cuMemUnmap(cptr, size)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemSetAccess(ptr, size_t size, desc : List[CUmemAccessDesc], size_t count):
    """ Set the access flags for each location specified in `desc` for the given virtual address range.

    Given the virtual address range via `ptr` and `size`, and the locations
    in the array given by `desc` and `count`, set the access flags for the
    target locations. The range must be a fully mapped address range
    containing all allocations created by cuMemMap / cuMemCreate.

    Parameters
    ----------
    ptr : Any
        Starting address for the virtual address range
    size : size_t
        Length of the virtual address range
    desc : List[CUmemAccessDesc]
        Array of CUmemAccessDesc that describe how to change the - mapping
        for each location specified
    count : size_t
        Number of CUmemAccessDesc in `desc`

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemSetAccess
    cuMemCreate
    cuMemMap
    """
    desc = [] if desc is None else desc
    if not all(isinstance(_x, (CUmemAccessDesc)) for _x in desc):
        raise TypeError("Argument 'desc' is not instance of type (expected List[ccuda.CUmemAccessDesc]")

    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    cdef ccuda.CUmemAccessDesc* cdesc = NULL
    if len(desc) > 0:
        cdesc = <ccuda.CUmemAccessDesc*> calloc(len(desc), sizeof(ccuda.CUmemAccessDesc))
        if cdesc is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(desc)) + 'x' + str(sizeof(ccuda.CUmemAccessDesc)))
        for idx in range(len(desc)):
            memcpy(&cdesc[idx], (<CUmemAccessDesc>desc[idx])._ptr, sizeof(ccuda.CUmemAccessDesc))

    if count > <size_t>len(desc): raise RuntimeError("List is too small: " + str(len(desc)) + " < " + str(count))
    err = ccuda.cuMemSetAccess(cptr, size, (<CUmemAccessDesc>desc[0])._ptr if len(desc) == 1 else cdesc, count)
    if cdesc is not NULL:
        free(cdesc)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemGetAccess(location : CUmemLocation, ptr):
    """ Get the access `flags` set for the given `location` and `ptr`.

    Parameters
    ----------
    location : CUmemLocation
        Location in which to check the flags for
    ptr : Any
        Address in which to check the access flags for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    flags : unsigned long long
        Flags set for this location

    See Also
    --------
    cuMemSetAccess
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    cdef unsigned long long flags = 0
    cdef ccuda.CUmemLocation* clocation_ptr = location._ptr if location != None else NULL
    err = ccuda.cuMemGetAccess(&flags, clocation_ptr, cptr)
    return (CUresult(err), flags)

@cython.embedsignature(True)
def cuMemExportToShareableHandle(handle, handleType not None : CUmemAllocationHandleType, unsigned long long flags):
    """ Exports an allocation to a requested shareable handle type.

    Given a CUDA memory handle, create a shareable memory allocation handle
    that can be used to share the memory with other processes. The
    recipient process can convert the shareable handle back into a CUDA
    memory handle using cuMemImportFromShareableHandle and map it with
    cuMemMap. The implementation of what this handle is and how it can be
    transferred is defined by the requested handle type in `handleType`

    Once all shareable handles are closed and the allocation is released,
    the allocated memory referenced will be released back to the OS and
    uses of the CUDA handle afterward will lead to undefined behavior.

    This API can also be used in conjunction with other APIs (e.g. Vulkan,
    OpenGL) that support importing memory from the shareable type

    Parameters
    ----------
    shareableHandle : Any
        Pointer to the location in which to store the requested handle type
    handle : Any
        CUDA handle for the memory allocation
    handleType : CUmemAllocationHandleType
        Type of shareable handle requested (defines type and size of the
        `shareableHandle` output parameter)
    flags : unsigned long long
        Reserved, must be zero

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuMemImportFromShareableHandle
    """
    cdef ccuda.CUmemGenericAllocationHandle chandle
    if handle is None:
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>0
    elif isinstance(handle, (CUmemGenericAllocationHandle)):
        phandle = int(handle)
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle
    else:
        phandle = int(CUmemGenericAllocationHandle(handle))
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle

    cdef void_ptr shareableHandle = 0
    cdef void* cshareableHandle_ptr = <void*>shareableHandle
    cdef ccuda.CUmemAllocationHandleType chandleType = handleType.value
    err = ccuda.cuMemExportToShareableHandle(cshareableHandle_ptr, chandle, chandleType, flags)
    return (CUresult(err), shareableHandle)

@cython.embedsignature(True)
def cuMemImportFromShareableHandle(osHandle, shHandleType not None : CUmemAllocationHandleType):
    """ Imports an allocation from a requested shareable handle type.

    If the current process cannot support the memory described by this
    shareable handle, this API will error as CUDA_ERROR_NOT_SUPPORTED.

    Parameters
    ----------
    osHandle : Any
        Shareable Handle representing the memory allocation that is to be
        imported.
    shHandleType : CUmemAllocationHandleType
        handle type of the exported handle CUmemAllocationHandleType.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    handle : CUmemGenericAllocationHandle
        CUDA Memory handle for the memory allocation.

    See Also
    --------
    cuMemExportToShareableHandle
    cuMemMap
    cuMemRelease

    Notes
    -----
    Importing shareable handles exported from some graphics APIs(VUlkan, OpenGL, etc) created on devices under an SLI group may not be supported, and thus this API will return CUDA_ERROR_NOT_SUPPORTED. There is no guarantee that the contents of `handle` will be the same CUDA memory handle for the same given OS shareable handle, or the same underlying allocation.

    """
    cdef CUmemGenericAllocationHandle handle = CUmemGenericAllocationHandle()
    cosHandle = utils.HelperInputVoidPtr(osHandle)
    cdef void* cosHandle_ptr = <void*><void_ptr>cosHandle.cptr
    cdef ccuda.CUmemAllocationHandleType cshHandleType = shHandleType.value
    err = ccuda.cuMemImportFromShareableHandle(handle._ptr, cosHandle_ptr, cshHandleType)
    return (CUresult(err), handle)

@cython.embedsignature(True)
def cuMemGetAllocationGranularity(prop : CUmemAllocationProp, option not None : CUmemAllocationGranularity_flags):
    """ Calculates either the minimal or recommended granularity.

    Calculates either the minimal or recommended granularity for a given
    allocation specification and returns it in granularity. This
    granularity can be used as a multiple for alignment, size, or address
    mapping.

    Parameters
    ----------
    prop : CUmemAllocationProp
        Property for which to determine the granularity for
    option : CUmemAllocationGranularity_flags
        Determines which granularity to return

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    granularity : int
        Returned granularity.

    See Also
    --------
    cuMemCreate
    cuMemMap
    """
    cdef size_t granularity = 0
    cdef ccuda.CUmemAllocationProp* cprop_ptr = prop._ptr if prop != None else NULL
    cdef ccuda.CUmemAllocationGranularity_flags coption = option.value
    err = ccuda.cuMemGetAllocationGranularity(&granularity, cprop_ptr, coption)
    return (CUresult(err), granularity)

@cython.embedsignature(True)
def cuMemGetAllocationPropertiesFromHandle(handle):
    """ Retrieve the contents of the property structure defining properties for this handle.

    Parameters
    ----------
    handle : Any
        Handle which to perform the query on

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    prop : CUmemAllocationProp
        Pointer to a properties structure which will hold the information
        about this handle

    See Also
    --------
    cuMemCreate
    cuMemImportFromShareableHandle
    """
    cdef ccuda.CUmemGenericAllocationHandle chandle
    if handle is None:
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>0
    elif isinstance(handle, (CUmemGenericAllocationHandle)):
        phandle = int(handle)
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle
    else:
        phandle = int(CUmemGenericAllocationHandle(handle))
        chandle = <ccuda.CUmemGenericAllocationHandle><void_ptr>phandle

    cdef CUmemAllocationProp prop = CUmemAllocationProp()
    err = ccuda.cuMemGetAllocationPropertiesFromHandle(prop._ptr, chandle)
    return (CUresult(err), prop)

@cython.embedsignature(True)
def cuMemRetainAllocationHandle(addr):
    """ Given an address `addr`, returns the allocation handle of the backing memory allocation.

    The handle is guaranteed to be the same handle value used to map the
    memory. If the address requested is not mapped, the function will fail.
    The returned handle must be released with corresponding number of calls
    to cuMemRelease.

    Parameters
    ----------
    addr : Any
        Memory address to query, that has been mapped previously.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_PERMITTED
        CUDA_ERROR_NOT_SUPPORTED
    handle : CUmemGenericAllocationHandle
        CUDA Memory handle for the backing memory allocation.

    See Also
    --------
    cuMemCreate
    cuMemRelease
    cuMemMap

    Notes
    -----
    The address `addr`, can be any address in a range previously mapped by cuMemMap, and not necessarily the start address.

    """
    cdef CUmemGenericAllocationHandle handle = CUmemGenericAllocationHandle()
    caddr = utils.HelperInputVoidPtr(addr)
    cdef void* caddr_ptr = <void*><void_ptr>caddr.cptr
    err = ccuda.cuMemRetainAllocationHandle(handle._ptr, caddr_ptr)
    return (CUresult(err), handle)

@cython.embedsignature(True)
def cuMemFreeAsync(dptr, hStream):
    """ Frees memory with stream ordered semantics.

    Inserts a free operation into `hStream`. The allocation must not be
    accessed after stream execution reaches the free. After this API
    returns, accessing the memory from any subsequent work launched on the
    GPU or querying its pointer attributes results in undefined behavior.

    Parameters
    ----------
    dptr : Any
        memory to free
    hStream : CUstream or cudaStream_t
        The stream establishing the stream ordering contract.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        (default
        stream
        specified
        with
        no
        current
        context)
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    Notes
    -----
    During stream capture, this function results in the creation of a free node and must therefore be passed the address of a graph allocation.

    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    err = ccuda.cuMemFreeAsync(cdptr, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemAllocAsync(size_t bytesize, hStream):
    """ Allocates memory with stream ordered semantics.

    Inserts an allocation operation into `hStream`. A pointer to the
    allocated memory is returned immediately in *dptr. The allocation must
    not be accessed until the the allocation operation completes. The
    allocation comes from the memory pool current to the stream's device.

    Parameters
    ----------
    bytesize : size_t
        Number of bytes to allocate
    hStream : CUstream or cudaStream_t
        The stream establishing the stream ordering contract and the memory
        pool to allocate from

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        (default
        stream
        specified
        with
        no
        current
        context)
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_OUT_OF_MEMORY
    dptr : CUdeviceptr
        Returned device pointer

    See Also
    --------
    cuMemAllocFromPoolAsync
    cuMemFreeAsync
    cuDeviceSetMemPool
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    cuMemPoolSetAccess
    cuMemPoolSetAttribute

    Notes
    -----
    During stream capture, this function results in the creation of an allocation node. In this case, the allocation is owned by the graph instead of the memory pool. The memory pool's properties are used to set the node's creation parameters.

    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef CUdeviceptr dptr = CUdeviceptr()
    err = ccuda.cuMemAllocAsync(dptr._ptr, bytesize, chStream)
    return (CUresult(err), dptr)

@cython.embedsignature(True)
def cuMemPoolTrimTo(pool, size_t minBytesToKeep):
    """ Tries to release memory back to the OS.

    Releases memory back to the OS until the pool contains fewer than
    minBytesToKeep reserved bytes, or there is no more memory that the
    allocator can safely release. The allocator cannot release OS
    allocations that back outstanding asynchronous allocations. The OS
    allocations may happen at different granularity from the user
    allocations.

    Parameters
    ----------
    pool : Any
        The memory pool to trim
    minBytesToKeep : size_t
        If the pool has less than minBytesToKeep reserved, the TrimTo
        operation is a no-op. Otherwise the pool will be guaranteed to have
        at least minBytesToKeep bytes reserved after the operation.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate

    Notes
    -----
    : Allocations that have been asynchronously freed but whose completion has not been observed on the host (eg. by a synchronize) can count as outstanding.

    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    err = ccuda.cuMemPoolTrimTo(cpool, minBytesToKeep)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemPoolSetAttribute(pool, attr not None : CUmemPool_attribute, value):
    """ Sets attributes of a memory pool.

    Supported attributes are: - CU_MEMPOOL_ATTR_RELEASE_THRESHOLD: (value
    type = cuuint64_t) Amount of reserved memory in bytes to hold onto
    before trying to release memory back to the OS. When more than the
    release threshold bytes of memory are held by the memory pool, the
    allocator will try to release memory back to the OS on the next call to
    stream, event or context synchronize. (default 0)    -
    CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES: (value type = int)
    Allow cuMemAllocAsync to use memory asynchronously freed in another
    stream as long as a stream ordering dependency of the allocating stream
    on the free action exists. Cuda events and null stream interactions can
    create the required stream ordered dependencies. (default enabled)    -
    CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC: (value type = int) Allow
    reuse of already completed frees when there is no dependency between
    the free and allocation. (default enabled)    -
    CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES: (value type = int)
    Allow cuMemAllocAsync to insert new stream dependencies in order to
    establish the stream ordering required to reuse a piece of memory
    released by cuMemFreeAsync (default enabled).    -
    CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH: (value type = cuuint64_t) Reset the
    high watermark that tracks the amount of backing memory that was
    allocated for the memory pool. It is illegal to set this attribute to a
    non-zero value.    - CU_MEMPOOL_ATTR_USED_MEM_HIGH: (value type =
    cuuint64_t) Reset the high watermark that tracks the amount of used
    memory that was allocated for the memory pool.

    Parameters
    ----------
    pool : Any
        The memory pool to modify
    attr : CUmemPool_attribute
        The attribute to modify
    value : Any
        Pointer to the value to assign

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef ccuda.CUmemPool_attribute cattr = attr.value
    cdef utils.HelperCUmemPool_attribute cvalue = utils.HelperCUmemPool_attribute(attr, value, is_getter=False)
    cdef void* cvalue_ptr = <void*><void_ptr>cvalue.cptr
    err = ccuda.cuMemPoolSetAttribute(cpool, cattr, cvalue_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemPoolGetAttribute(pool, attr not None : CUmemPool_attribute):
    """ Gets attributes of a memory pool.

    Supported attributes are: - CU_MEMPOOL_ATTR_RELEASE_THRESHOLD: (value
    type = cuuint64_t) Amount of reserved memory in bytes to hold onto
    before trying to release memory back to the OS. When more than the
    release threshold bytes of memory are held by the memory pool, the
    allocator will try to release memory back to the OS on the next call to
    stream, event or context synchronize. (default 0)    -
    CU_MEMPOOL_ATTR_REUSE_FOLLOW_EVENT_DEPENDENCIES: (value type = int)
    Allow cuMemAllocAsync to use memory asynchronously freed in another
    stream as long as a stream ordering dependency of the allocating stream
    on the free action exists. Cuda events and null stream interactions can
    create the required stream ordered dependencies. (default enabled)    -
    CU_MEMPOOL_ATTR_REUSE_ALLOW_OPPORTUNISTIC: (value type = int) Allow
    reuse of already completed frees when there is no dependency between
    the free and allocation. (default enabled)    -
    CU_MEMPOOL_ATTR_REUSE_ALLOW_INTERNAL_DEPENDENCIES: (value type = int)
    Allow cuMemAllocAsync to insert new stream dependencies in order to
    establish the stream ordering required to reuse a piece of memory
    released by cuMemFreeAsync (default enabled).    -
    CU_MEMPOOL_ATTR_RESERVED_MEM_CURRENT: (value type = cuuint64_t) Amount
    of backing memory currently allocated for the mempool    -
    CU_MEMPOOL_ATTR_RESERVED_MEM_HIGH: (value type = cuuint64_t) High
    watermark of backing memory allocated for the mempool since the last
    time it was reset.    - CU_MEMPOOL_ATTR_USED_MEM_CURRENT: (value type =
    cuuint64_t) Amount of memory from the pool that is currently in use by
    the application.    - CU_MEMPOOL_ATTR_USED_MEM_HIGH: (value type =
    cuuint64_t) High watermark of the amount of memory from the pool that
    was in use by the application.

    Parameters
    ----------
    pool : Any
        The memory pool to get attributes of
    attr : CUmemPool_attribute
        The attribute to get

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    value : Any
        Retrieved value

    See Also
    --------
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef ccuda.CUmemPool_attribute cattr = attr.value
    cdef utils.HelperCUmemPool_attribute cvalue = utils.HelperCUmemPool_attribute(attr, 0, is_getter=True)
    cdef void* cvalue_ptr = <void*><void_ptr>cvalue.cptr
    err = ccuda.cuMemPoolGetAttribute(cpool, cattr, cvalue_ptr)
    return (CUresult(err), cvalue.pyObj())

@cython.embedsignature(True)
def cuMemPoolSetAccess(pool, map : List[CUmemAccessDesc], size_t count):
    """ Controls visibility of pools between devices.

    Parameters
    ----------
    pool : Any
        The pool being modified
    map : List[CUmemAccessDesc]
        Array of access descriptors. Each descriptor instructs the access
        to enable for a single gpu.
    count : size_t
        Number of descriptors in the map array.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    """
    map = [] if map is None else map
    if not all(isinstance(_x, (CUmemAccessDesc)) for _x in map):
        raise TypeError("Argument 'map' is not instance of type (expected List[ccuda.CUmemAccessDesc]")

    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef ccuda.CUmemAccessDesc* cmap = NULL
    if len(map) > 0:
        cmap = <ccuda.CUmemAccessDesc*> calloc(len(map), sizeof(ccuda.CUmemAccessDesc))
        if cmap is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(map)) + 'x' + str(sizeof(ccuda.CUmemAccessDesc)))
        for idx in range(len(map)):
            memcpy(&cmap[idx], (<CUmemAccessDesc>map[idx])._ptr, sizeof(ccuda.CUmemAccessDesc))

    if count > <size_t>len(map): raise RuntimeError("List is too small: " + str(len(map)) + " < " + str(count))
    err = ccuda.cuMemPoolSetAccess(cpool, (<CUmemAccessDesc>map[0])._ptr if len(map) == 1 else cmap, count)
    if cmap is not NULL:
        free(cmap)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemPoolGetAccess(memPool, location : CUmemLocation):
    """ Returns the accessibility of a pool from a device.

    Returns the accessibility of the pool's memory from the specified
    location.

    Parameters
    ----------
    memPool : CUmemoryPool or cudaMemPool_t
        the pool being queried
    location : CUmemLocation
        the location accessing the pool

    Returns
    -------
    CUresult

    flags : CUmemAccess_flags
        the accessibility of the pool from the specified location

    See Also
    --------
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    """
    cdef ccuda.CUmemoryPool cmemPool
    if memPool is None:
        cmemPool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(memPool, (CUmemoryPool)):
        pmemPool = int(memPool)
        cmemPool = <ccuda.CUmemoryPool><void_ptr>pmemPool
    else:
        pmemPool = int(CUmemoryPool(memPool))
        cmemPool = <ccuda.CUmemoryPool><void_ptr>pmemPool

    cdef ccuda.CUmemAccess_flags flags
    cdef ccuda.CUmemLocation* clocation_ptr = location._ptr if location != None else NULL
    err = ccuda.cuMemPoolGetAccess(&flags, cmemPool, clocation_ptr)
    return (CUresult(err), CUmemAccess_flags(flags))

@cython.embedsignature(True)
def cuMemPoolCreate(poolProps : CUmemPoolProps):
    """ Creates a memory pool.

    Creates a CUDA memory pool and returns the handle in `pool`. The
    `poolProps` determines the properties of the pool such as the backing
    device and IPC capabilities.

    By default, the pool's memory will be accessible from the device it is
    allocated on.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuDeviceSetMemPool
    cuDeviceGetMemPool
    cuDeviceGetDefaultMemPool
    cuMemAllocFromPoolAsync
    cuMemPoolExportToShareableHandle

    Notes
    -----
    Specifying CU_MEM_HANDLE_TYPE_NONE creates a memory pool that will not support IPC.

    """
    cdef CUmemoryPool pool = CUmemoryPool()
    cdef ccuda.CUmemPoolProps* cpoolProps_ptr = poolProps._ptr if poolProps != None else NULL
    err = ccuda.cuMemPoolCreate(pool._ptr, cpoolProps_ptr)
    return (CUresult(err), pool)

@cython.embedsignature(True)
def cuMemPoolDestroy(pool):
    """ Destroys the specified memory pool.

    If any pointers obtained from this pool haven't been freed or the pool
    has free operations that haven't completed when cuMemPoolDestroy is
    invoked, the function will return immediately and the resources
    associated with the pool will be released automatically once there are
    no more outstanding allocations.

    Destroying the current mempool of a device sets the default mempool of
    that device as the current mempool for that device.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemFreeAsync
    cuDeviceSetMemPool
    cuDeviceGetMemPool
    cuDeviceGetDefaultMemPool
    cuMemPoolCreate

    Notes
    -----
    A device's default memory pool cannot be destroyed.

    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    err = ccuda.cuMemPoolDestroy(cpool)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemAllocFromPoolAsync(size_t bytesize, pool, hStream):
    """ Allocates memory from a specified pool with stream ordered semantics.

    Inserts an allocation operation into `hStream`. A pointer to the
    allocated memory is returned immediately in *dptr. The allocation must
    not be accessed until the the allocation operation completes. The
    allocation comes from the specified memory pool.

    Parameters
    ----------
    bytesize : size_t
        Number of bytes to allocate
    pool : Any
        The pool to allocate from
    hStream : CUstream or cudaStream_t
        The stream establishing the stream ordering semantic

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        (default
        stream
        specified
        with
        no
        current
        context)
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_OUT_OF_MEMORY
    dptr : CUdeviceptr
        Returned device pointer

    See Also
    --------
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    cuMemPoolSetAccess
    cuMemPoolSetAttribute

    Notes
    -----
    During stream capture, this function results in the creation of an allocation node. In this case, the allocation is owned by the graph instead of the memory pool. The memory pool's properties are used to set the node's creation parameters.

    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef CUdeviceptr dptr = CUdeviceptr()
    err = ccuda.cuMemAllocFromPoolAsync(dptr._ptr, bytesize, cpool, chStream)
    return (CUresult(err), dptr)

@cython.embedsignature(True)
def cuMemPoolExportToShareableHandle(pool, handleType not None : CUmemAllocationHandleType, unsigned long long flags):
    """ Exports a memory pool to the requested handle type.

    Given an IPC capable mempool, create an OS handle to share the pool
    with another process. A recipient process can convert the shareable
    handle into a mempool with cuMemPoolImportFromShareableHandle.
    Individual pointers can then be shared with the cuMemPoolExportPointer
    and cuMemPoolImportPointer APIs. The implementation of what the
    shareable handle is and how it can be transferred is defined by the
    requested handle type.

    Parameters
    ----------
    pool : Any
        pool to export
    handleType : CUmemAllocationHandleType
        the type of handle to create
    flags : unsigned long long
        must be 0

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_OUT_OF_MEMORY
    handle_out : int
        Returned OS handle

    See Also
    --------
    cuMemPoolImportFromShareableHandle
    cuMemPoolExportPointer
    cuMemPoolImportPointer
    cuMemAllocAsync
    cuMemFreeAsync
    cuDeviceGetDefaultMemPool
    cuDeviceGetMemPool
    cuMemPoolCreate
    cuMemPoolSetAccess
    cuMemPoolSetAttribute

    Notes
    -----
    : To create an IPC capable mempool, create a mempool with a CUmemAllocationHandleType other than CU_MEM_HANDLE_TYPE_NONE.

    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef void_ptr handle_out = 0
    cdef void* chandle_out_ptr = <void*>handle_out
    cdef ccuda.CUmemAllocationHandleType chandleType = handleType.value
    err = ccuda.cuMemPoolExportToShareableHandle(chandle_out_ptr, cpool, chandleType, flags)
    return (CUresult(err), handle_out)

@cython.embedsignature(True)
def cuMemPoolImportFromShareableHandle(handle, handleType not None : CUmemAllocationHandleType, unsigned long long flags):
    """ imports a memory pool from a shared handle.

    Specific allocations can be imported from the imported pool with
    cuMemPoolImportPointer.

    Parameters
    ----------
    handle : Any
        OS handle of the pool to open
    handleType : CUmemAllocationHandleType
        The type of handle being imported
    flags : unsigned long long
        must be 0

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_OUT_OF_MEMORY
    pool_out : CUmemoryPool
        Returned memory pool

    See Also
    --------
    cuMemPoolExportToShareableHandle
    cuMemPoolExportPointer
    cuMemPoolImportPointer

    Notes
    -----
    Imported memory pools do not support creating new allocations. As such imported memory pools may not be used in cuDeviceSetMemPool or cuMemAllocFromPoolAsync calls.

    """
    cdef CUmemoryPool pool_out = CUmemoryPool()
    chandle = utils.HelperInputVoidPtr(handle)
    cdef void* chandle_ptr = <void*><void_ptr>chandle.cptr
    cdef ccuda.CUmemAllocationHandleType chandleType = handleType.value
    err = ccuda.cuMemPoolImportFromShareableHandle(pool_out._ptr, chandle_ptr, chandleType, flags)
    return (CUresult(err), pool_out)

@cython.embedsignature(True)
def cuMemPoolExportPointer(ptr):
    """ Export data to share a memory pool allocation between processes.

    Constructs `shareData_out` for sharing a specific allocation from an
    already shared memory pool. The recipient process can import the
    allocation with the cuMemPoolImportPointer api. The data is not a
    handle and may be shared through any IPC mechanism.

    Parameters
    ----------
    ptr : Any
        pointer to memory being exported

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_OUT_OF_MEMORY
    shareData_out : CUmemPoolPtrExportData
        Returned export data

    See Also
    --------
    cuMemPoolExportToShareableHandle
    cuMemPoolImportFromShareableHandle
    cuMemPoolImportPointer
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    cdef CUmemPoolPtrExportData shareData_out = CUmemPoolPtrExportData()
    err = ccuda.cuMemPoolExportPointer(shareData_out._ptr, cptr)
    return (CUresult(err), shareData_out)

@cython.embedsignature(True)
def cuMemPoolImportPointer(pool, shareData : CUmemPoolPtrExportData):
    """ Import a memory pool allocation from another process.

    Returns in `ptr_out` a pointer to the imported memory. The imported
    memory must not be accessed before the allocation operation completes
    in the exporting process. The imported memory must be freed from all
    importing processes before being freed in the exporting process. The
    pointer may be freed with cuMemFree or cuMemFreeAsync. If
    cuMemFreeAsync is used, the free must be completed on the importing
    process before the free operation on the exporting process.

    Parameters
    ----------
    pool : Any
        pool from which to import
    shareData : CUmemPoolPtrExportData
        data specifying the memory to import

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_OUT_OF_MEMORY
    ptr_out : CUdeviceptr
        pointer to imported memory

    See Also
    --------
    cuMemPoolExportToShareableHandle
    cuMemPoolImportFromShareableHandle
    cuMemPoolExportPointer

    Notes
    -----
    The cuMemFreeAsync api may be used in the exporting process before the cuMemFreeAsync operation completes in its stream as long as the cuMemFreeAsync in the exporting process specifies a stream with a stream dependency on the importing process's cuMemFreeAsync.

    """
    cdef ccuda.CUmemoryPool cpool
    if pool is None:
        cpool = <ccuda.CUmemoryPool><void_ptr>0
    elif isinstance(pool, (CUmemoryPool)):
        ppool = int(pool)
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool
    else:
        ppool = int(CUmemoryPool(pool))
        cpool = <ccuda.CUmemoryPool><void_ptr>ppool

    cdef CUdeviceptr ptr_out = CUdeviceptr()
    cdef ccuda.CUmemPoolPtrExportData* cshareData_ptr = shareData._ptr if shareData != None else NULL
    err = ccuda.cuMemPoolImportPointer(ptr_out._ptr, cpool, cshareData_ptr)
    return (CUresult(err), ptr_out)

@cython.embedsignature(True)
def cuPointerGetAttribute(attribute not None : CUpointer_attribute, ptr):
    """ Returns information about a pointer.

    The supported attributes are:

    - CU_POINTER_ATTRIBUTE_CONTEXT: Returns in `*data` the CUcontext in
    which `ptr` was allocated or registered. The type of `data` must be
    CUcontext *. If `ptr` was not allocated by, mapped by, or registered
    with a CUcontext which uses unified virtual addressing then
    CUDA_ERROR_INVALID_VALUE is returned.    -
    CU_POINTER_ATTRIBUTE_MEMORY_TYPE: Returns in `*data` the physical
    memory type of the memory that `ptr` addresses as a CUmemorytype
    enumerated value. The type of `data` must be unsigned int. If `ptr`
    addresses device memory then `*data` is set to CU_MEMORYTYPE_DEVICE.
    The particular CUdevice on which the memory resides is the CUdevice of
    the CUcontext returned by the CU_POINTER_ATTRIBUTE_CONTEXT attribute of
    `ptr`. If `ptr` addresses host memory then `*data` is set to
    CU_MEMORYTYPE_HOST. If `ptr` was not allocated by, mapped by, or
    registered with a CUcontext which uses unified virtual addressing then
    CUDA_ERROR_INVALID_VALUE is returned. If the current CUcontext does not
    support unified virtual addressing then CUDA_ERROR_INVALID_CONTEXT is
    returned.    - CU_POINTER_ATTRIBUTE_DEVICE_POINTER: Returns in `*data`
    the device pointer value through which `ptr` may be accessed by kernels
    running in the current CUcontext. The type of `data` must be
    CUdeviceptr *. If there exists no device pointer value through which
    kernels running in the current CUcontext may access `ptr` then
    CUDA_ERROR_INVALID_VALUE is returned. If there is no current CUcontext
    then CUDA_ERROR_INVALID_CONTEXT is returned. Except in the exceptional
    disjoint addressing cases discussed below, the value returned in
    `*data` will equal the input value `ptr`.    -
    CU_POINTER_ATTRIBUTE_HOST_POINTER: Returns in `*data` the host pointer
    value through which `ptr` may be accessed by by the host program. The
    type of `data` must be void **. If there exists no host pointer value
    through which the host program may directly access `ptr` then
    CUDA_ERROR_INVALID_VALUE is returned. Except in the exceptional
    disjoint addressing cases discussed below, the value returned in
    `*data` will equal the input value `ptr`.    -
    CU_POINTER_ATTRIBUTE_P2P_TOKENS: Returns in `*data` two tokens for use
    with the nv-p2p.h Linux kernel interface. `data` must be a struct of
    type CUDA_POINTER_ATTRIBUTE_P2P_TOKENS. `ptr` must be a pointer to
    memory obtained from :cuMemAlloc(). Note that p2pToken and vaSpaceToken
    are only valid for the lifetime of the source allocation. A subsequent
    allocation at the same address may return completely different tokens.
    Querying this attribute has a side effect of setting the attribute
    CU_POINTER_ATTRIBUTE_SYNC_MEMOPS for the region of memory that `ptr`
    points to.    - CU_POINTER_ATTRIBUTE_SYNC_MEMOPS: A boolean attribute
    which when set, ensures that synchronous memory operations initiated on
    the region of memory that `ptr` points to will always synchronize. See
    further documentation in the section titled "API synchronization
    behavior" to learn more about cases when synchronous memory operations
    can exhibit asynchronous behavior.    - CU_POINTER_ATTRIBUTE_BUFFER_ID:
    Returns in `*data` a buffer ID which is guaranteed to be unique within
    the process. `data` must point to an unsigned long long. `ptr` must be
    a pointer to memory obtained from a CUDA memory allocation API. Every
    memory allocation from any of the CUDA memory allocation APIs will have
    a unique ID over a process lifetime. Subsequent allocations do not
    reuse IDs from previous freed allocations. IDs are only unique within a
    single process.    - CU_POINTER_ATTRIBUTE_IS_MANAGED: Returns in
    `*data` a boolean that indicates whether the pointer points to managed
    memory or not. If `ptr` is not a valid CUDA pointer then
    CUDA_ERROR_INVALID_VALUE is returned.    -
    CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL: Returns in `*data` an integer
    representing a device ordinal of a device against which the memory was
    allocated or registered.    -
    CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE: Returns in `*data` a
    boolean that indicates if this pointer maps to an allocation that is
    suitable for cudaIpcGetMemHandle.    -
    CU_POINTER_ATTRIBUTE_RANGE_START_ADDR: Returns in `*data` the starting
    address for the allocation referenced by the device pointer `ptr`. Note
    that this is not necessarily the address of the mapped region, but the
    address of the mappable address range `ptr` references (e.g. from
    cuMemAddressReserve).    - CU_POINTER_ATTRIBUTE_RANGE_SIZE: Returns in
    `*data` the size for the allocation referenced by the device pointer
    `ptr`. Note that this is not necessarily the size of the mapped region,
    but the size of the mappable address range `ptr` references (e.g. from
    cuMemAddressReserve). To retrieve the size of the mapped region, see
    cuMemGetAddressRange    - CU_POINTER_ATTRIBUTE_MAPPED: Returns in
    `*data` a boolean that indicates if this pointer is in a valid address
    range that is mapped to a backing allocation.    -
    CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES: Returns a bitmask of the
    allowed handle types for an allocation that may be passed to
    cuMemExportToShareableHandle.    - CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE:
    Returns in `*data` the handle to the mempool that the allocation was
    obtained from.



    Parameters
    ----------
    attribute : CUpointer_attribute
        Pointer attribute to query
    ptr : Any
        Pointer

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    data : Any
        Returned pointer attribute value

    See Also
    --------
    cuPointerSetAttribute
    cuMemAlloc
    cuMemFree
    cuMemAllocHost
    cuMemFreeHost
    cuMemHostAlloc
    cuMemHostRegister
    cuMemHostUnregister
    cudaPointerGetAttributes
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    cdef utils.HelperCUpointer_attribute cdata = utils.HelperCUpointer_attribute(attribute, 0, is_getter=True)
    cdef void* cdata_ptr = <void*><void_ptr>cdata.cptr
    cdef ccuda.CUpointer_attribute cattribute = attribute.value
    err = ccuda.cuPointerGetAttribute(cdata_ptr, cattribute, cptr)
    return (CUresult(err), cdata.pyObj())

@cython.embedsignature(True)
def cuMemPrefetchAsync(devPtr, size_t count, dstDevice, hStream):
    """ Prefetches memory to the specified destination device.

    Prefetches memory to the specified destination device. `devPtr` is the
    base device pointer of the memory to be prefetched and `dstDevice` is
    the destination device. `count` specifies the number of bytes to copy.
    `hStream` is the stream in which the operation is enqueued. The memory
    range must refer to managed memory allocated via cuMemAllocManaged or
    declared via managed variables.

    Passing in CU_DEVICE_CPU for `dstDevice` will prefetch the data to host
    memory. If `dstDevice` is a GPU, then the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS must be non-zero.
    Additionally, `hStream` must be associated with a device that has a
    non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS.

    The start address and end address of the memory range will be rounded
    down and rounded up respectively to be aligned to CPU page size before
    the prefetch operation is enqueued in the stream.

    If no physical memory has been allocated for this region, then this
    memory region will be populated and mapped on the destination device.
    If there's insufficient memory to prefetch the desired region, the
    Unified Memory driver may evict pages from other cuMemAllocManaged
    allocations to host memory in order to make room. Device memory
    allocated using cuMemAlloc or cuArrayCreate will not be evicted.

    By default, any mappings to the previous location of the migrated pages
    are removed and mappings for the new location are only setup on
    `dstDevice`. The exact behavior however also depends on the settings
    applied to this memory range via cuMemAdvise as described below:

    If CU_MEM_ADVISE_SET_READ_MOSTLY was set on any subset of this memory
    range, then that subset will create a read-only copy of the pages on
    `dstDevice`.

    If CU_MEM_ADVISE_SET_PREFERRED_LOCATION was called on any subset of
    this memory range, then the pages will be migrated to `dstDevice` even
    if `dstDevice` is not the preferred location of any pages in the memory
    range.

    If CU_MEM_ADVISE_SET_ACCESSED_BY was called on any subset of this
    memory range, then mappings to those pages from all the appropriate
    processors are updated to refer to the new location if establishing
    such a mapping is possible. Otherwise, those mappings are cleared.

    Note that this API is not required for functionality and only serves to
    improve performance by allowing the application to migrate data to a
    suitable location before it is accessed. Memory accesses to this range
    are always coherent and are allowed even when the data is actively
    being migrated.

    Note that this function is asynchronous with respect to the host and
    all work on other devices.

    Parameters
    ----------
    devPtr : Any
        Pointer to be prefetched
    count : size_t
        Size in bytes
    dstDevice : Any
        Destination device to prefetch to
    hStream : CUstream or cudaStream_t
        Stream to enqueue prefetch operation

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    None
        None

    See Also
    --------
    cuMemcpy
    cuMemcpyPeer
    cuMemcpyAsync
    cuMemcpy3DPeerAsync
    cuMemAdvise
    cudaMemPrefetchAsync
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUdevice cdstDevice
    if dstDevice is None:
        cdstDevice = <ccuda.CUdevice>0
    elif isinstance(dstDevice, (CUdevice)):
        pdstDevice = int(dstDevice)
        cdstDevice = <ccuda.CUdevice>pdstDevice
    else:
        pdstDevice = int(CUdevice(dstDevice))
        cdstDevice = <ccuda.CUdevice>pdstDevice

    cdef ccuda.CUdeviceptr cdevPtr
    if devPtr is None:
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(devPtr, (CUdeviceptr)):
        pdevPtr = int(devPtr)
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
    else:
        pdevPtr = int(CUdeviceptr(devPtr))
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr

    err = ccuda.cuMemPrefetchAsync(cdevPtr, count, cdstDevice, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemAdvise(devPtr, size_t count, advice not None : CUmem_advise, device):
    """ Advise about the usage of a given memory range.

    Advise the Unified Memory subsystem about the usage pattern for the
    memory range starting at `devPtr` with a size of `count` bytes. The
    start address and end address of the memory range will be rounded down
    and rounded up respectively to be aligned to CPU page size before the
    advice is applied. The memory range must refer to managed memory
    allocated via cuMemAllocManaged or declared via managed variables. The
    memory range could also refer to system-allocated pageable memory
    provided it represents a valid, host-accessible region of memory and
    all additional constraints imposed by `advice` as outlined below are
    also satisfied. Specifying an invalid system-allocated pageable memory
    range results in an error being returned.

    The `advice` parameter can take the following values: -
    CU_MEM_ADVISE_SET_READ_MOSTLY: This implies that the data is mostly
    going to be read from and only occasionally written to. Any read
    accesses from any processor to this region will create a read-only copy
    of at least the accessed pages in that processor's memory.
    Additionally, if cuMemPrefetchAsync is called on this region, it will
    create a read-only copy of the data on the destination processor. If
    any processor writes to this region, all copies of the corresponding
    page will be invalidated except for the one where the write occurred.
    The `device` argument is ignored for this advice. Note that for a page
    to be read-duplicated, the accessing processor must either be the CPU
    or a GPU that has a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS. Also, if a context is
    created on a device that does not have the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS set, then read-
    duplication will not occur until all such contexts are destroyed. If
    the memory region refers to valid system-allocated pageable memory,
    then the accessing device must have a non-zero value for the device
    attribute CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS for a read-only
    copy to be created on that device. Note however that if the accessing
    device also has a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES, then
    setting this advice will not create a read-only copy when that device
    accesses this memory region.    - CU_MEM_ADVISE_UNSET_READ_MOSTLY:
    Undoes the effect of CU_MEM_ADVISE_SET_READ_MOSTLY and also prevents
    the Unified Memory driver from attempting heuristic read-duplication on
    the memory range. Any read-duplicated copies of the data will be
    collapsed into a single copy. The location for the collapsed copy will
    be the preferred location if the page has a preferred location and one
    of the read-duplicated copies was resident at that location. Otherwise,
    the location chosen is arbitrary.    -
    CU_MEM_ADVISE_SET_PREFERRED_LOCATION: This advice sets the preferred
    location for the data to be the memory belonging to `device`. Passing
    in CU_DEVICE_CPU for `device` sets the preferred location as host
    memory. If `device` is a GPU, then it must have a non-zero value for
    the device attribute CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS.
    Setting the preferred location does not cause data to migrate to that
    location immediately. Instead, it guides the migration policy when a
    fault occurs on that memory region. If the data is already in its
    preferred location and the faulting processor can establish a mapping
    without requiring the data to be migrated, then data migration will be
    avoided. On the other hand, if the data is not in its preferred
    location or if a direct mapping cannot be established, then it will be
    migrated to the processor accessing it. It is important to note that
    setting the preferred location does not prevent data prefetching done
    using cuMemPrefetchAsync. Having a preferred location can override the
    page thrash detection and resolution logic in the Unified Memory
    driver. Normally, if a page is detected to be constantly thrashing
    between for example host and device memory, the page may eventually be
    pinned to host memory by the Unified Memory driver. But if the
    preferred location is set as device memory, then the page will continue
    to thrash indefinitely. If CU_MEM_ADVISE_SET_READ_MOSTLY is also set on
    this memory region or any subset of it, then the policies associated
    with that advice will override the policies of this advice, unless read
    accesses from `device` will not result in a read-only copy being
    created on that device as outlined in description for the advice
    CU_MEM_ADVISE_SET_READ_MOSTLY. If the memory region refers to valid
    system-allocated pageable memory, then `device` must have a non-zero
    value for the device attribute
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS. Additionally, if `device`
    has a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES, then
    this call has no effect. Note however that this behavior may change in
    the future.    - CU_MEM_ADVISE_UNSET_PREFERRED_LOCATION: Undoes the
    effect of CU_MEM_ADVISE_SET_PREFERRED_LOCATION and changes the
    preferred location to none.    - CU_MEM_ADVISE_SET_ACCESSED_BY: This
    advice implies that the data will be accessed by `device`. Passing in
    CU_DEVICE_CPU for `device` will set the advice for the CPU. If `device`
    is a GPU, then the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS must be non-zero. This
    advice does not cause data migration and has no impact on the location
    of the data per se. Instead, it causes the data to always be mapped in
    the specified processor's page tables, as long as the location of the
    data permits a mapping to be established. If the data gets migrated for
    any reason, the mappings are updated accordingly. This advice is
    recommended in scenarios where data locality is not important, but
    avoiding faults is. Consider for example a system containing multiple
    GPUs with peer-to-peer access enabled, where the data located on one
    GPU is occasionally accessed by peer GPUs. In such scenarios, migrating
    data over to the other GPUs is not as important because the accesses
    are infrequent and the overhead of migration may be too high. But
    preventing faults can still help improve performance, and so having a
    mapping set up in advance is useful. Note that on CPU access of this
    data, the data may be migrated to host memory because the CPU typically
    cannot access device memory directly. Any GPU that had the
    CU_MEM_ADVISE_SET_ACCESSED_BY flag set for this data will now have its
    mapping updated to point to the page in host memory. If
    CU_MEM_ADVISE_SET_READ_MOSTLY is also set on this memory region or any
    subset of it, then the policies associated with that advice will
    override the policies of this advice. Additionally, if the preferred
    location of this memory region or any subset of it is also `device`,
    then the policies associated with CU_MEM_ADVISE_SET_PREFERRED_LOCATION
    will override the policies of this advice. If the memory region refers
    to valid system-allocated pageable memory, then `device` must have a
    non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS. Additionally, if `device`
    has a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES, then
    this call has no effect.    - CU_MEM_ADVISE_UNSET_ACCESSED_BY: Undoes
    the effect of CU_MEM_ADVISE_SET_ACCESSED_BY. Any mappings to the data
    from `device` may be removed at any time causing accesses to result in
    non-fatal page faults. If the memory region refers to valid system-
    allocated pageable memory, then `device` must have a non-zero value for
    the device attribute CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS.
    Additionally, if `device` has a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS_USES_HOST_PAGE_TABLES, then
    this call has no effect.

    Parameters
    ----------
    devPtr : Any
        Pointer to memory to set the advice for
    count : size_t
        Size in bytes of the memory range
    advice : CUmem_advise
        Advice to be applied for the specified memory range
    device : Any
        Device to apply the advice for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    None
        None

    See Also
    --------
    cuMemcpy
    cuMemcpyPeer
    cuMemcpyAsync
    cuMemcpy3DPeerAsync
    cuMemPrefetchAsync
    cudaMemAdvise
    """
    cdef ccuda.CUdevice cdevice
    if device is None:
        cdevice = <ccuda.CUdevice>0
    elif isinstance(device, (CUdevice)):
        pdevice = int(device)
        cdevice = <ccuda.CUdevice>pdevice
    else:
        pdevice = int(CUdevice(device))
        cdevice = <ccuda.CUdevice>pdevice

    cdef ccuda.CUdeviceptr cdevPtr
    if devPtr is None:
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(devPtr, (CUdeviceptr)):
        pdevPtr = int(devPtr)
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
    else:
        pdevPtr = int(CUdeviceptr(devPtr))
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr

    cdef ccuda.CUmem_advise cadvice = advice.value
    err = ccuda.cuMemAdvise(cdevPtr, count, cadvice, cdevice)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuMemRangeGetAttribute(size_t dataSize, attribute not None : CUmem_range_attribute, devPtr, size_t count):
    """ Query an attribute of a given memory range.

    Query an attribute about the memory range starting at `devPtr` with a
    size of `count` bytes. The memory range must refer to managed memory
    allocated via cuMemAllocManaged or declared via managed variables.

    The `attribute` parameter can take the following values: -
    CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY: If this attribute is specified,
    `data` will be interpreted as a 32-bit integer, and `dataSize` must be
    4. The result returned will be 1 if all pages in the given memory range
    have read-duplication enabled, or 0 otherwise.    -
    CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION: If this attribute is
    specified, `data` will be interpreted as a 32-bit integer, and
    `dataSize` must be 4. The result returned will be a GPU device id if
    all pages in the memory range have that GPU as their preferred
    location, or it will be CU_DEVICE_CPU if all pages in the memory range
    have the CPU as their preferred location, or it will be
    CU_DEVICE_INVALID if either all the pages don't have the same preferred
    location or some of the pages don't have a preferred location at all.
    Note that the actual location of the pages in the memory range at the
    time of the query may be different from the preferred location.    -
    CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY: If this attribute is specified,
    `data` will be interpreted as an array of 32-bit integers, and
    `dataSize` must be a non-zero multiple of 4. The result returned will
    be a list of device ids that had CU_MEM_ADVISE_SET_ACCESSED_BY set for
    that entire memory range. If any device does not have that advice set
    for the entire memory range, that device will not be included. If
    `data` is larger than the number of devices that have that advice set
    for that memory range, CU_DEVICE_INVALID will be returned in all the
    extra space provided. For ex., if `dataSize` is 12 (i.e. `data` has 3
    elements) and only device 0 has the advice set, then the result
    returned will be { 0, CU_DEVICE_INVALID, CU_DEVICE_INVALID }. If `data`
    is smaller than the number of devices that have that advice set, then
    only as many devices will be returned as can fit in the array. There is
    no guarantee on which specific devices will be returned, however.    -
    CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION: If this attribute is
    specified, `data` will be interpreted as a 32-bit integer, and
    `dataSize` must be 4. The result returned will be the last location to
    which all pages in the memory range were prefetched explicitly via
    cuMemPrefetchAsync. This will either be a GPU id or CU_DEVICE_CPU
    depending on whether the last location for prefetch was a GPU or the
    CPU respectively. If any page in the memory range was never explicitly
    prefetched or if all pages were not prefetched to the same location,
    CU_DEVICE_INVALID will be returned. Note that this simply returns the
    last location that the applicaton requested to prefetch the memory
    range to. It gives no indication as to whether the prefetch operation
    to that location has completed or even begun.

    Parameters
    ----------
    dataSize : size_t
        Array containing the size of data
    attribute : CUmem_range_attribute
        The attribute to query
    devPtr : Any
        Start of the range to query
    count : size_t
        Size of the range to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    data : Any
        A pointers to a memory location where the result of each attribute
        query will be written to.

    See Also
    --------
    cuMemRangeGetAttributes
    cuMemPrefetchAsync
    cuMemAdvise
    cudaMemRangeGetAttribute
    """
    cdef ccuda.CUdeviceptr cdevPtr
    if devPtr is None:
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(devPtr, (CUdeviceptr)):
        pdevPtr = int(devPtr)
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
    else:
        pdevPtr = int(CUdeviceptr(devPtr))
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr

    cdef utils.HelperCUmem_range_attribute cdata = utils.HelperCUmem_range_attribute(attribute, dataSize)
    cdef void* cdata_ptr = <void*><void_ptr>cdata.cptr
    cdef ccuda.CUmem_range_attribute cattribute = attribute.value
    err = ccuda.cuMemRangeGetAttribute(cdata_ptr, dataSize, cattribute, cdevPtr, count)
    return (CUresult(err), cdata.pyObj())

@cython.embedsignature(True)
def cuMemRangeGetAttributes(dataSizes : List[int], attributes : List[CUmem_range_attribute], size_t numAttributes, devPtr, size_t count):
    """ Query attributes of a given memory range.

    Query attributes of the memory range starting at `devPtr` with a size
    of `count` bytes. The memory range must refer to managed memory
    allocated via cuMemAllocManaged or declared via managed variables. The
    `attributes` array will be interpreted to have `numAttributes` entries.
    The `dataSizes` array will also be interpreted to have `numAttributes`
    entries. The results of the query will be stored in `data`.

    The list of supported attributes are given below. Please refer to
    cuMemRangeGetAttribute for attribute descriptions and restrictions.

    - CU_MEM_RANGE_ATTRIBUTE_READ_MOSTLY    -
    CU_MEM_RANGE_ATTRIBUTE_PREFERRED_LOCATION    -
    CU_MEM_RANGE_ATTRIBUTE_ACCESSED_BY    -
    CU_MEM_RANGE_ATTRIBUTE_LAST_PREFETCH_LOCATION

    Parameters
    ----------
    dataSizes : List[int]
        Array containing the sizes of each result
    attributes : List[CUmem_range_attribute]
        An array of attributes to query (numAttributes and the number of
        attributes in this array should match)
    numAttributes : size_t
        Number of attributes to query
    devPtr : Any
        Start of the range to query
    count : size_t
        Size of the range to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    data : List[Any]
        A two-dimensional array containing pointers to memory locations
        where the result of each attribute query will be written to.

    See Also
    --------
    cuMemRangeGetAttribute
    cuMemAdvise
    cuMemPrefetchAsync
    cudaMemRangeGetAttributes
    """
    cdef ccuda.CUdeviceptr cdevPtr
    if devPtr is None:
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(devPtr, (CUdeviceptr)):
        pdevPtr = int(devPtr)
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr
    else:
        pdevPtr = int(CUdeviceptr(devPtr))
        cdevPtr = <ccuda.CUdeviceptr><void_ptr>pdevPtr

    attributes = [] if attributes is None else attributes
    if not all(isinstance(_x, (CUmem_range_attribute)) for _x in attributes):
        raise TypeError("Argument 'attributes' is not instance of type (expected List[ccuda.CUmem_range_attribute]")

    if not all(isinstance(_x, (int)) for _x in dataSizes):
        raise TypeError("Argument 'dataSizes' is not instance of type (expected List[int]")

    pylist = [utils.HelperCUmem_range_attribute(pyattributes, pydataSizes) for (pyattributes, pydataSizes) in zip(attributes, dataSizes)]
    cdef utils.InputVoidPtrPtrHelper voidStarHelper = utils.InputVoidPtrPtrHelper(pylist)
    cdef void** cvoidStarHelper_ptr = <void**><void_ptr>voidStarHelper.cptr
    cdef vector[size_t] cdataSizes = dataSizes
    cdef vector[ccuda.CUmem_range_attribute] cattributes = [pyattributes.value for pyattributes in (attributes)]
    if numAttributes > <size_t>len(dataSizes): raise RuntimeError("List is too small: " + str(len(dataSizes)) + " < " + str(numAttributes))
    if numAttributes > <size_t>len(attributes): raise RuntimeError("List is too small: " + str(len(attributes)) + " < " + str(numAttributes))
    err = ccuda.cuMemRangeGetAttributes(cvoidStarHelper_ptr, cdataSizes.data(), cattributes.data(), numAttributes, cdevPtr, count)
    return (CUresult(err), [obj.pyObj() for obj in pylist])

@cython.embedsignature(True)
def cuPointerSetAttribute(value, attribute not None : CUpointer_attribute, ptr):
    """ Set attributes on a previously allocated memory region.

    The supported attributes are:

    - CU_POINTER_ATTRIBUTE_SYNC_MEMOPS: A boolean attribute that can either
    be set (1) or unset (0). When set, the region of memory that `ptr`
    points to is guaranteed to always synchronize memory operations that
    are synchronous. If there are some previously initiated synchronous
    memory operations that are pending when this attribute is set, the
    function does not return until those memory operations are complete.
    See further documentation in the section titled "API synchronization
    behavior" to learn more about cases when synchronous memory operations
    can exhibit asynchronous behavior. `value` will be considered as a
    pointer to an unsigned integer to which this attribute is to be set.

    Parameters
    ----------
    value : Any
        Pointer to memory containing the value to be set
    attribute : CUpointer_attribute
        Pointer attribute to set
    ptr : Any
        Pointer to a memory region allocated using CUDA memory allocation
        APIs

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    None
        None

    See Also
    --------
    cuPointerGetAttribute
    cuPointerGetAttributes
    cuMemAlloc
    cuMemFree
    cuMemAllocHost
    cuMemFreeHost
    cuMemHostAlloc
    cuMemHostRegister
    cuMemHostUnregister
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    cdef utils.HelperCUpointer_attribute cvalue = utils.HelperCUpointer_attribute(attribute, value, is_getter=False)
    cdef void* cvalue_ptr = <void*><void_ptr>cvalue.cptr
    cdef ccuda.CUpointer_attribute cattribute = attribute.value
    err = ccuda.cuPointerSetAttribute(cvalue_ptr, cattribute, cptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuPointerGetAttributes(unsigned int numAttributes, attributes : List[CUpointer_attribute], ptr):
    """ Returns information about a pointer.

    The supported attributes are (refer to cuPointerGetAttribute for
    attribute descriptions and restrictions):

    - CU_POINTER_ATTRIBUTE_CONTEXT    - CU_POINTER_ATTRIBUTE_MEMORY_TYPE
    - CU_POINTER_ATTRIBUTE_DEVICE_POINTER    -
    CU_POINTER_ATTRIBUTE_HOST_POINTER    - CU_POINTER_ATTRIBUTE_SYNC_MEMOPS
    - CU_POINTER_ATTRIBUTE_BUFFER_ID    - CU_POINTER_ATTRIBUTE_IS_MANAGED
    - CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL    -
    CU_POINTER_ATTRIBUTE_RANGE_START_ADDR    -
    CU_POINTER_ATTRIBUTE_RANGE_SIZE    - CU_POINTER_ATTRIBUTE_MAPPED    -
    CU_POINTER_ATTRIBUTE_IS_LEGACY_CUDA_IPC_CAPABLE    -
    CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES    -
    CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE

    If `ptr` was not allocated by, mapped by, or registered with a
    CUcontext which uses UVA (Unified Virtual Addressing),
    CUDA_ERROR_INVALID_CONTEXT is returned.

    Parameters
    ----------
    numAttributes : unsigned int
        Number of attributes to query
    attributes : List[CUpointer_attribute]
        An array of attributes to query (numAttributes and the number of
        attributes in this array should match)
    ptr : Any
        Pointer to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_DEVICE
    data : List[Any]
        A two-dimensional array containing pointers to memory locations
        where the result of each attribute query will be written to.

    See Also
    --------
    cuPointerGetAttribute
    cuPointerSetAttribute
    cudaPointerGetAttributes
    """
    cdef ccuda.CUdeviceptr cptr
    if ptr is None:
        cptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(ptr, (CUdeviceptr)):
        pptr = int(ptr)
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr
    else:
        pptr = int(CUdeviceptr(ptr))
        cptr = <ccuda.CUdeviceptr><void_ptr>pptr

    attributes = [] if attributes is None else attributes
    if not all(isinstance(_x, (CUpointer_attribute)) for _x in attributes):
        raise TypeError("Argument 'attributes' is not instance of type (expected List[ccuda.CUpointer_attribute]")

    if numAttributes > len(attributes): raise RuntimeError("List is too small: " + str(len(attributes)) + " < " + str(numAttributes))
    cdef vector[ccuda.CUpointer_attribute] cattributes = [pyattributes.value for pyattributes in (attributes)]
    pylist = [utils.HelperCUpointer_attribute(pyattributes, 0, is_getter=True) for pyattributes in attributes]
    cdef utils.InputVoidPtrPtrHelper voidStarHelper = utils.InputVoidPtrPtrHelper(pylist)
    cdef void** cvoidStarHelper_ptr = <void**><void_ptr>voidStarHelper.cptr
    err = ccuda.cuPointerGetAttributes(numAttributes, cattributes.data(), cvoidStarHelper_ptr, cptr)
    return (CUresult(err), [obj.pyObj() for obj in pylist])

@cython.embedsignature(True)
def cuStreamCreate(unsigned int Flags):
    """ Create a stream.

    Creates a stream and returns a handle in `phStream`. The `Flags`
    argument determines behaviors of the stream.

    Valid values for `Flags` are: - CU_STREAM_DEFAULT: Default stream
    creation flag.    - CU_STREAM_NON_BLOCKING: Specifies that work running
    in the created stream may run concurrently with work in stream 0 (the
    NULL stream), and that the created stream should perform no implicit
    synchronization with stream 0.

    Parameters
    ----------
    Flags : unsigned int
        Parameters for stream creation

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    phStream : CUstream
        Returned newly created stream

    See Also
    --------
    cuStreamDestroy
    cuStreamCreateWithPriority
    cuStreamGetPriority
    cuStreamGetFlags
    cuStreamWaitEvent
    cuStreamQuery
    cuStreamSynchronize
    cuStreamAddCallback
    cudaStreamCreate
    cudaStreamCreateWithFlags
    """
    cdef CUstream phStream = CUstream()
    err = ccuda.cuStreamCreate(phStream._ptr, Flags)
    return (CUresult(err), phStream)

@cython.embedsignature(True)
def cuStreamCreateWithPriority(unsigned int flags, int priority):
    """ Create a stream with the given priority.

    Creates a stream with the specified priority and returns a handle in
    `phStream`. This API alters the scheduler priority of work in the
    stream. Work in a higher priority stream may preempt work already
    executing in a low priority stream.

    `priority` follows a convention where lower numbers represent higher
    priorities. '0' represents default priority. The range of meaningful
    numerical priorities can be queried using cuCtxGetStreamPriorityRange.
    If the specified priority is outside the numerical range returned by
    cuCtxGetStreamPriorityRange, it will automatically be clamped to the
    lowest or the highest number in the range.

    Parameters
    ----------
    flags : unsigned int
        Flags for stream creation. See cuStreamCreate for a list of valid
        flags
    priority : int
        Stream priority. Lower numbers represent higher priorities. See
        cuCtxGetStreamPriorityRange for more information about meaningful
        stream priorities that can be passed.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    phStream : CUstream
        Returned newly created stream

    See Also
    --------
    cuStreamDestroy
    cuStreamCreate
    cuStreamGetPriority
    cuCtxGetStreamPriorityRange
    cuStreamGetFlags
    cuStreamWaitEvent
    cuStreamQuery
    cuStreamSynchronize
    cuStreamAddCallback
    cudaStreamCreateWithPriority

    Notes
    -----
    In the current implementation, only compute kernels launched in priority streams are affected by the stream's priority. Stream priorities have no effect on host-to-device and device-to-host memory operations.

    """
    cdef CUstream phStream = CUstream()
    err = ccuda.cuStreamCreateWithPriority(phStream._ptr, flags, priority)
    return (CUresult(err), phStream)

@cython.embedsignature(True)
def cuStreamGetPriority(hStream):
    """ Query the priority of a given stream.

    Query the priority of a stream created using cuStreamCreate or
    cuStreamCreateWithPriority and return the priority in `priority`. Note
    that if the stream was created with a priority outside the numerical
    range returned by cuCtxGetStreamPriorityRange, this function returns
    the clamped priority. See cuStreamCreateWithPriority for details about
    priority clamping.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Handle to the stream to be queried

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    priority : int
        Pointer to a signed integer in which the stream's priority is
        returned

    See Also
    --------
    cuStreamDestroy
    cuStreamCreate
    cuStreamCreateWithPriority
    cuCtxGetStreamPriorityRange
    cuStreamGetFlags
    cudaStreamGetPriority
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef int priority = 0
    err = ccuda.cuStreamGetPriority(chStream, &priority)
    return (CUresult(err), priority)

@cython.embedsignature(True)
def cuStreamGetFlags(hStream):
    """ Query the flags of a given stream.

    Query the flags of a stream created using cuStreamCreate or
    cuStreamCreateWithPriority and return the flags in `flags`.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Handle to the stream to be queried

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    flags : unsigned int
        Pointer to an unsigned integer in which the stream's flags are
        returned The value returned in `flags` is a logical 'OR' of all
        flags that were used while creating this stream. See cuStreamCreate
        for the list of valid flags

    See Also
    --------
    cuStreamDestroy
    cuStreamCreate
    cuStreamGetPriority
    cudaStreamGetFlags
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef unsigned int flags = 0
    err = ccuda.cuStreamGetFlags(chStream, &flags)
    return (CUresult(err), flags)

@cython.embedsignature(True)
def cuStreamGetCtx(hStream):
    """ Query the context associated with a stream.

    Returns the CUDA context that the stream is associated with.

    The stream handle `hStream` can refer to any of the following:  -  a
    stream created via any of the CUDA driver APIs such as cuStreamCreate
    and cuStreamCreateWithPriority, or their runtime API equivalents such
    as cudaStreamCreate, cudaStreamCreateWithFlags and
    cudaStreamCreateWithPriority. The returned context is the context that
    was active in the calling thread when the stream was created. Passing
    an invalid handle will result in undefined behavior.      -  any of the
    special streams such as the NULL stream, CU_STREAM_LEGACY and
    CU_STREAM_PER_THREAD. The runtime API equivalents of these are also
    accepted, which are NULL, cudaStreamLegacy and cudaStreamPerThread
    respectively. Specifying any of the special handles will return the
    context current to the calling thread. If no context is current to the
    calling thread, CUDA_ERROR_INVALID_CONTEXT is returned.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Handle to the stream to be queried

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
    pctx : CUcontext
        Returned context associated with the stream

    See Also
    --------
    cuStreamDestroy
    cuStreamCreateWithPriority
    cuStreamGetPriority
    cuStreamGetFlags
    cuStreamWaitEvent
    cuStreamQuery
    cuStreamSynchronize
    cuStreamAddCallback
    cudaStreamCreate
    cudaStreamCreateWithFlags
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef CUcontext pctx = CUcontext()
    err = ccuda.cuStreamGetCtx(chStream, pctx._ptr)
    return (CUresult(err), pctx)

@cython.embedsignature(True)
def cuStreamWaitEvent(hStream, hEvent, unsigned int Flags):
    """ Make a compute stream wait on an event.

    Makes all future work submitted to `hStream` wait for all work captured
    in `hEvent`. See cuEventRecord() for details on what is captured by an
    event. The synchronization will be performed efficiently on the device
    when applicable. `hEvent` may be from a different context or device
    than `hStream`.

    flags include: - CU_EVENT_WAIT_DEFAULT: Default event creation flag.
    - CU_EVENT_WAIT_EXTERNAL: Event is captured in the graph as an external
    event node when performing stream capture. This flag is invalid outside
    of stream capture.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to wait
    hEvent : Any
        Event to wait on (may not be NULL)
    Flags : unsigned int
        See CUevent_capture_flags

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuStreamCreate
    cuEventRecord
    cuStreamQuery
    cuStreamSynchronize
    cuStreamAddCallback
    cuStreamDestroy
    cudaStreamWaitEvent
    """
    cdef ccuda.CUevent chEvent
    if hEvent is None:
        chEvent = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEvent, (CUevent)):
        phEvent = int(hEvent)
        chEvent = <ccuda.CUevent><void_ptr>phEvent
    else:
        phEvent = int(CUevent(hEvent))
        chEvent = <ccuda.CUevent><void_ptr>phEvent

    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    err = ccuda.cuStreamWaitEvent(chStream, chEvent, Flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamAddCallback(hStream, callback, userData, unsigned int flags):
    """ Add a callback to a compute stream.

    The callback may be passed CUDA_SUCCESS or an error code. In the event
    of a device error, all subsequently executed callbacks will receive an
    appropriate CUresult.

    Callbacks must not make any CUDA API calls. Attempting to use a CUDA
    API will result in CUDA_ERROR_NOT_PERMITTED. Callbacks must not perform
    any synchronization that may depend on outstanding device work or other
    callbacks that are not mandated to run earlier. Callbacks without a
    mandated order (in independent streams) execute in undefined order and
    may be serialized.

    For the purposes of Unified Memory, callback execution makes a number
    of guarantees:  -  The callback stream is considered idle for the
    duration of the callback. Thus, for example, a callback may always use
    memory attached to the callback stream.      -  The start of execution
    of a callback has the same effect as synchronizing an event recorded in
    the same stream immediately prior to the callback. It thus synchronizes
    streams which have been "joined" prior to the callback.      -  Adding
    device work to any stream does not have the effect of making the stream
    active until all preceding host functions and stream callbacks have
    executed. Thus, for example, a callback might use global attached
    memory even if work has been added to another stream, if the work has
    been ordered behind the callback with an event.      -  Completion of a
    callback does not cause a stream to become active except as described
    above. The callback stream will remain idle if no device work follows
    the callback, and will remain idle across consecutive callbacks without
    device work in between. Thus, for example, stream synchronization can
    be done by signaling from a callback at the end of the stream.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to add callback to
    callback : Any
        The function to call once preceding stream operations are complete
    userData : Any
        User specified data to be passed to the callback function
    flags : unsigned int
        Reserved for future use, must be 0

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamQuery
    cuStreamSynchronize
    cuStreamWaitEvent
    cuStreamDestroy
    cuMemAllocManaged
    cuStreamAttachMemAsync
    cuStreamLaunchHostFunc
    cudaStreamAddCallback

    Notes
    -----
    This function is slated for eventual deprecation and removal. If you do not require the callback to execute in case of a device error, consider using cuLaunchHostFunc. Additionally, this function is not supported with cuStreamBeginCapture and cuStreamEndCapture, unlike cuLaunchHostFunc.

    """
    cdef ccuda.CUstreamCallback ccallback
    if callback is None:
        ccallback = <ccuda.CUstreamCallback><void_ptr>0
    elif isinstance(callback, (CUstreamCallback)):
        pcallback = int(callback)
        ccallback = <ccuda.CUstreamCallback><void_ptr>pcallback
    else:
        pcallback = int(CUstreamCallback(callback))
        ccallback = <ccuda.CUstreamCallback><void_ptr>pcallback

    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cuserData = utils.HelperInputVoidPtr(userData)
    cdef void* cuserData_ptr = <void*><void_ptr>cuserData.cptr
    err = ccuda.cuStreamAddCallback(chStream, ccallback, cuserData_ptr, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamBeginCapture(hStream, mode not None : CUstreamCaptureMode):
    """ Begins graph capture on a stream.

    Begin graph capture on `hStream`. When a stream is in capture mode, all
    operations pushed into the stream will not be executed, but will
    instead be captured into a graph, which will be returned via
    cuStreamEndCapture. Capture may not be initiated if `stream` is
    CU_STREAM_LEGACY. Capture must be ended on the same stream in which it
    was initiated, and it may only be initiated if the stream is not
    already in capture mode. The capture mode may be queried via
    cuStreamIsCapturing. A unique id representing the capture sequence may
    be queried via cuStreamGetCaptureInfo.

    If `mode` is not CU_STREAM_CAPTURE_MODE_RELAXED, cuStreamEndCapture
    must be called on this stream from the same thread.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream in which to initiate capture
    mode : CUstreamCaptureMode
        Controls the interaction of this capture sequence with other API
        calls that are potentially unsafe. For more details see
        cuThreadExchangeStreamCaptureMode.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamIsCapturing
    cuStreamEndCapture
    cuThreadExchangeStreamCaptureMode

    Notes
    -----
    Kernels captured using this API must not use texture and surface references. Reading or writing through any texture or surface reference is undefined behavior. This restriction does not apply to texture and surface objects.

    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUstreamCaptureMode cmode = mode.value
    err = ccuda.cuStreamBeginCapture(chStream, cmode)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuThreadExchangeStreamCaptureMode(mode not None : CUstreamCaptureMode):
    """ Swaps the stream capture interaction mode for a thread.

    Sets the calling thread's stream capture interaction mode to the value
    contained in `*mode`, and overwrites `*mode` with the previous mode for
    the thread. To facilitate deterministic behavior across function or
    module boundaries, callers are encouraged to use this API in a push-pop
    fashion:CUstreamCaptureModemode=desiredMode;
    cuThreadExchangeStreamCaptureMode(&mode); ...
    cuThreadExchangeStreamCaptureMode(&mode);//restorepreviousmode

    During stream capture (see cuStreamBeginCapture), some actions, such as
    a call to cudaMalloc, may be unsafe. In the case of cudaMalloc, the
    operation is not enqueued asynchronously to a stream, and is not
    observed by stream capture. Therefore, if the sequence of operations
    captured via cuStreamBeginCapture depended on the allocation being
    replayed whenever the graph is launched, the captured graph would be
    invalid.

    Therefore, stream capture places restrictions on API calls that can be
    made within or concurrently to a cuStreamBeginCapture-
    cuStreamEndCapture sequence. This behavior can be controlled via this
    API and flags to cuStreamBeginCapture.

    A thread's mode is one of the following: -
    `CU_STREAM_CAPTURE_MODE_GLOBAL:` This is the default mode. If the local
    thread has an ongoing capture sequence that was not initiated with
    `CU_STREAM_CAPTURE_MODE_RELAXED` at `cuStreamBeginCapture`, or if any
    other thread has a concurrent capture sequence initiated with
    `CU_STREAM_CAPTURE_MODE_GLOBAL`, this thread is prohibited from
    potentially unsafe API calls.    -
    `CU_STREAM_CAPTURE_MODE_THREAD_LOCAL:` If the local thread has an
    ongoing capture sequence not initiated with
    `CU_STREAM_CAPTURE_MODE_RELAXED`, it is prohibited from potentially
    unsafe API calls. Concurrent capture sequences in other threads are
    ignored.    - `CU_STREAM_CAPTURE_MODE_RELAXED:` The local thread is not
    prohibited from potentially unsafe API calls. Note that the thread is
    still prohibited from API calls which necessarily conflict with stream
    capture, for example, attempting cuEventQuery on an event that was last
    recorded inside a capture sequence.

    Parameters
    ----------
    mode : CUstreamCaptureMode
        Pointer to mode value to swap with the current mode

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuStreamBeginCapture
    """
    cdef ccuda.CUstreamCaptureMode cmode = mode.value
    err = ccuda.cuThreadExchangeStreamCaptureMode(&cmode)
    return (CUresult(err), CUstreamCaptureMode(cmode))

@cython.embedsignature(True)
def cuStreamEndCapture(hStream):
    """ Ends capture on a stream, returning the captured graph.

    End capture on `hStream`, returning the captured graph via `phGraph`.
    Capture must have been initiated on `hStream` via a call to
    cuStreamBeginCapture. If capture was invalidated, due to a violation of
    the rules of stream capture, then a NULL graph will be returned.

    If the `mode` argument to cuStreamBeginCapture was not
    CU_STREAM_CAPTURE_MODE_RELAXED, this call must be from the same thread
    as cuStreamBeginCapture.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_STREAM_CAPTURE_WRONG_THREAD
    phGraph : CUgraph
        The captured graph

    See Also
    --------
    cuStreamCreate
    cuStreamBeginCapture
    cuStreamIsCapturing
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef CUgraph phGraph = CUgraph()
    err = ccuda.cuStreamEndCapture(chStream, phGraph._ptr)
    return (CUresult(err), phGraph)

@cython.embedsignature(True)
def cuStreamIsCapturing(hStream):
    """ Returns a stream's capture status.

    Return the capture status of `hStream` via `captureStatus`. After a
    successful call, `*captureStatus` will contain one of the following: -
    CU_STREAM_CAPTURE_STATUS_NONE: The stream is not capturing.    -
    CU_STREAM_CAPTURE_STATUS_ACTIVE: The stream is capturing.    -
    CU_STREAM_CAPTURE_STATUS_INVALIDATED: The stream was capturing but an
    error has invalidated the capture sequence. The capture sequence must
    be terminated with cuStreamEndCapture on the stream where it was
    initiated in order to continue using `hStream`.

    Note that, if this is called on CU_STREAM_LEGACY (the "null stream")
    while a blocking stream in the same context is capturing, it will
    return CUDA_ERROR_STREAM_CAPTURE_IMPLICIT and `*captureStatus` is
    unspecified after the call. The blocking stream capture is not
    invalidated.

    When a blocking stream is capturing, the legacy stream is in an
    unusable state until the blocking stream capture is terminated. The
    legacy stream is not supported for stream capture, but attempted use
    would have an implicit dependency on the capturing stream(s).

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_STREAM_CAPTURE_IMPLICIT
    captureStatus : CUstreamCaptureStatus
        Returns the stream's capture status

    See Also
    --------
    cuStreamCreate
    cuStreamBeginCapture
    cuStreamEndCapture
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUstreamCaptureStatus captureStatus
    err = ccuda.cuStreamIsCapturing(chStream, &captureStatus)
    return (CUresult(err), CUstreamCaptureStatus(captureStatus))

@cython.embedsignature(True)
def cuStreamGetCaptureInfo(hStream):
    """ Query capture status of a stream.

    Note there is a later version of this API, cuStreamGetCaptureInfo_v2.
    It will supplant this version in 12.0, which is retained for minor
    version compatibility.

    Query the capture status of a stream and and get an id for the capture
    sequence, which is unique over the lifetime of the process.

    If called on CU_STREAM_LEGACY (the "null stream") while a stream not
    created with CU_STREAM_NON_BLOCKING is capturing, returns
    CUDA_ERROR_STREAM_CAPTURE_IMPLICIT.

    A valid id is returned only if both of the following are true: - the
    call returns CUDA_SUCCESS    - captureStatus is set to
    CU_STREAM_CAPTURE_STATUS_ACTIVE

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_STREAM_CAPTURE_IMPLICIT
    None
        None

    See Also
    --------
    cuStreamGetCaptureInfo_v2
    cuStreamBeginCapture
    cuStreamIsCapturing
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUstreamCaptureStatus captureStatus_out
    cdef cuuint64_t id_out = cuuint64_t()
    err = ccuda.cuStreamGetCaptureInfo(chStream, &captureStatus_out, id_out._ptr)
    return (CUresult(err), CUstreamCaptureStatus(captureStatus_out), id_out)

@cython.embedsignature(True)
def cuStreamGetCaptureInfo_v2(hStream):
    """ Query a stream's capture state (11.3+)

    Query stream state related to stream capture.

    If called on CU_STREAM_LEGACY (the "null stream") while a stream not
    created with CU_STREAM_NON_BLOCKING is capturing, returns
    CUDA_ERROR_STREAM_CAPTURE_IMPLICIT.

    Valid data (other than capture status) is returned only if both of the
    following are true: - the call returns CUDA_SUCCESS    - the returned
    capture status is CU_STREAM_CAPTURE_STATUS_ACTIVE

    This version of cuStreamGetCaptureInfo is introduced in CUDA 11.3 and
    will supplant the previous version in 12.0. Developers requiring
    compatibility across minor versions to CUDA 11.0 (driver version 445)
    should use cuStreamGetCaptureInfo or include a fallback path.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        The stream to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_STREAM_CAPTURE_IMPLICIT
    captureStatus_out : CUstreamCaptureStatus
        Location to return the capture status of the stream; required
    id_out : cuuint64_t
        Optional location to return an id for the capture sequence, which
        is unique over the lifetime of the process
    graph_out : CUgraph
        Optional location to return the graph being captured into. All
        operations other than destroy and node removal are permitted on the
        graph while the capture sequence is in progress. This API does not
        transfer ownership of the graph, which is transferred or destroyed
        at cuStreamEndCapture. Note that the graph handle may be
        invalidated before end of capture for certain errors. Nodes that
        are or become unreachable from the original stream at
        cuStreamEndCapture due to direct actions on the graph do not
        trigger CUDA_ERROR_STREAM_CAPTURE_UNJOINED.
    dependencies_out : List[CUgraphNode]
        Optional location to store a pointer to an array of nodes. The next
        node to be captured in the stream will depend on this set of nodes,
        absent operations such as event wait which modify this set. The
        array pointer is valid until the next API call which operates on
        the stream or until end of capture. The node handles may be copied
        out and are valid until they or the graph is destroyed. The driver-
        owned array may also be passed directly to APIs that operate on the
        graph (not the stream) without copying.
    numDependencies_out : int
        Optional location to store the size of the array returned in
        dependencies_out.

    See Also
    --------
    cuStreamGetCaptureInfo
    cuStreamBeginCapture
    cuStreamIsCapturing
    cuStreamUpdateCaptureDependencies
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUstreamCaptureStatus captureStatus_out
    cdef cuuint64_t id_out = cuuint64_t()
    cdef CUgraph graph_out = CUgraph()
    cdef const ccuda.CUgraphNode* cdependencies_out = NULL
    pydependencies_out = []
    cdef size_t numDependencies_out = 0
    err = ccuda.cuStreamGetCaptureInfo_v2(chStream, &captureStatus_out, id_out._ptr, graph_out._ptr, &cdependencies_out, &numDependencies_out)
    if CUresult(err) == CUresult(0):
        pydependencies_out = [CUgraphNode(init_value=<void_ptr>cdependencies_out[idx]) for idx in range(numDependencies_out)]
    return (CUresult(err), CUstreamCaptureStatus(captureStatus_out), id_out, graph_out, pydependencies_out, numDependencies_out)

@cython.embedsignature(True)
def cuStreamUpdateCaptureDependencies(hStream, dependencies : List[CUgraphNode], size_t numDependencies, unsigned int flags):
    """ Update the set of dependencies in a capturing stream (11.3+)

    Modifies the dependency set of a capturing stream. The dependency set
    is the set of nodes that the next captured node in the stream will
    depend on.

    Valid flags are CU_STREAM_ADD_CAPTURE_DEPENDENCIES and
    CU_STREAM_SET_CAPTURE_DEPENDENCIES. These control whether the set
    passed to the API is added to the existing set or replaces it. A flags
    value of 0 defaults to CU_STREAM_ADD_CAPTURE_DEPENDENCIES.

    Nodes that are removed from the dependency set via this API do not
    result in CUDA_ERROR_STREAM_CAPTURE_UNJOINED if they are unreachable
    from the stream at cuStreamEndCapture.

    Returns CUDA_ERROR_ILLEGAL_STATE if the stream is not capturing.

    This API is new in CUDA 11.3. Developers requiring compatibility across
    minor versions to CUDA 11.0 should not use this API or provide a
    fallback.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_ILLEGAL_STATE
    None
        None

    See Also
    --------
    cuStreamBeginCapture
    cuStreamGetCaptureInfo
    cuStreamGetCaptureInfo_v2
    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    err = ccuda.cuStreamUpdateCaptureDependencies(chStream, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, flags)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamAttachMemAsync(hStream, dptr, size_t length, unsigned int flags):
    """ Attach memory to a stream asynchronously.

    Enqueues an operation in `hStream` to specify stream association of
    `length` bytes of memory starting from `dptr`. This function is a
    stream-ordered operation, meaning that it is dependent on, and will
    only take effect when, previous work in stream has completed. Any
    previous association is automatically replaced.

    `dptr` must point to one of the following types of memories: - managed
    memory declared using the managed keyword or allocated with
    cuMemAllocManaged.    - a valid host-accessible region of system-
    allocated pageable memory. This type of memory may only be specified if
    the device associated with the stream reports a non-zero value for the
    device attribute CU_DEVICE_ATTRIBUTE_PAGEABLE_MEMORY_ACCESS.

    For managed allocations, `length` must be either zero or the entire
    allocation's size. Both indicate that the entire allocation's stream
    association is being changed. Currently, it is not possible to change
    stream association for a portion of a managed allocation.

    For pageable host allocations, `length` must be non-zero.

    The stream association is specified using `flags` which must be one of
    CUmemAttach_flags. If the CU_MEM_ATTACH_GLOBAL flag is specified, the
    memory can be accessed by any stream on any device. If the
    CU_MEM_ATTACH_HOST flag is specified, the program makes a guarantee
    that it won't access the memory on the device from any stream on a
    device that has a zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS. If the
    CU_MEM_ATTACH_SINGLE flag is specified and `hStream` is associated with
    a device that has a zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS, the program makes a
    guarantee that it will only access the memory on the device from
    `hStream`. It is illegal to attach singly to the NULL stream, because
    the NULL stream is a virtual global stream and not a specific stream.
    An error will be returned in this case.

    When memory is associated with a single stream, the Unified Memory
    system will allow CPU access to this memory region so long as all
    operations in `hStream` have completed, regardless of whether other
    streams are active. In effect, this constrains exclusive ownership of
    the managed memory region by an active GPU to per-stream activity
    instead of whole-GPU activity.

    Accessing memory on the device from streams that are not associated
    with it will produce undefined results. No error checking is performed
    by the Unified Memory system to ensure that kernels launched into other
    streams do not access this region.

    It is a program's responsibility to order calls to
    cuStreamAttachMemAsync via events, synchronization or other means to
    ensure legal access to memory at all times. Data visibility and
    coherency will be changed appropriately for all kernels which follow a
    stream-association change.

    If `hStream` is destroyed while data is associated with it, the
    association is removed and the association reverts to the default
    visibility of the allocation as specified at cuMemAllocManaged. For
    managed variables, the default association is always
    CU_MEM_ATTACH_GLOBAL. Note that destroying a stream is an asynchronous
    operation, and as a result, the change to default association won't
    happen until all work in the stream has completed.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream in which to enqueue the attach operation
    dptr : Any
        Pointer to memory (must be a pointer to managed memory or to a
        valid host-accessible region of system-allocated pageable memory)
    length : size_t
        Length of memory
    flags : unsigned int
        Must be one of CUmemAttach_flags

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamQuery
    cuStreamSynchronize
    cuStreamWaitEvent
    cuStreamDestroy
    cuMemAllocManaged
    cudaStreamAttachMemAsync
    """
    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    err = ccuda.cuStreamAttachMemAsync(chStream, cdptr, length, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamQuery(hStream):
    """ Determine status of a compute stream.

    Returns CUDA_SUCCESS if all operations in the stream specified by
    `hStream` have completed, or CUDA_ERROR_NOT_READY if not.

    For the purposes of Unified Memory, a return value of CUDA_SUCCESS is
    equivalent to having called cuStreamSynchronize().

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to query status of

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_READY
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamWaitEvent
    cuStreamDestroy
    cuStreamSynchronize
    cuStreamAddCallback
    cudaStreamQuery
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    err = ccuda.cuStreamQuery(chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamSynchronize(hStream):
    """ Wait until a stream's tasks are completed.

    Waits until the device has completed all operations in the stream
    specified by `hStream`. If the context was created with the
    CU_CTX_SCHED_BLOCKING_SYNC flag, the CPU thread will block until the
    stream is finished with all of its tasks.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to wait for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamDestroy
    cuStreamWaitEvent
    cuStreamQuery
    cuStreamAddCallback
    cudaStreamSynchronize
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    err = ccuda.cuStreamSynchronize(chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamDestroy(hStream):
    """ Destroys a stream.

    Destroys the stream specified by `hStream`.

    In case the device is still doing work in the stream `hStream` when
    cuStreamDestroy() is called, the function will return immediately and
    the resources associated with `hStream` will be released automatically
    once the device has completed all work in `hStream`.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to destroy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamWaitEvent
    cuStreamQuery
    cuStreamSynchronize
    cuStreamAddCallback
    cudaStreamDestroy
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    err = ccuda.cuStreamDestroy(chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamCopyAttributes(dst, src):
    """ Copies attributes from source stream to destination stream.

    Copies attributes from source stream `src` to destination stream `dst`.
    Both streams must have the same context.

    Parameters
    ----------
    dst : Any
        Destination stream
    src : Any
        Source stream For list of attributes see CUstreamAttrID

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None
    """
    cdef ccuda.CUstream csrc
    if src is None:
        csrc = <ccuda.CUstream><void_ptr>0
    elif isinstance(src, (CUstream)):
        psrc = int(src)
        csrc = <ccuda.CUstream><void_ptr>psrc
    else:
        psrc = int(CUstream(src))
        csrc = <ccuda.CUstream><void_ptr>psrc

    cdef ccuda.CUstream cdst
    if dst is None:
        cdst = <ccuda.CUstream><void_ptr>0
    elif isinstance(dst, (CUstream)):
        pdst = int(dst)
        cdst = <ccuda.CUstream><void_ptr>pdst
    else:
        pdst = int(CUstream(dst))
        cdst = <ccuda.CUstream><void_ptr>pdst

    err = ccuda.cuStreamCopyAttributes(cdst, csrc)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamGetAttribute(hStream, attr not None : CUstreamAttrID):
    """ Queries stream attribute.

    Queries attribute `attr` from `hStream` and stores it in corresponding
    member of `value_out`.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t

    attr : CUstreamAttrID


    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    value_out : CUstreamAttrValue

    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUstreamAttrID cattr = attr.value
    cdef CUstreamAttrValue value_out = CUstreamAttrValue()
    err = ccuda.cuStreamGetAttribute(chStream, cattr, value_out._ptr)
    return (CUresult(err), value_out)

@cython.embedsignature(True)
def cuStreamSetAttribute(hStream, attr not None : CUstreamAttrID, value : CUstreamAttrValue):
    """ Sets stream attribute.

    Sets attribute `attr` on `hStream` from corresponding attribute of
    `value`. The updated attribute will be applied to subsequent work
    submitted to the stream. It will not affect previously submitted work.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t

    attr : CUstreamAttrID

    value : CUstreamAttrValue


    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    None
        None
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUstreamAttrID cattr = attr.value
    cdef ccuda.CUstreamAttrValue* cvalue_ptr = value._ptr if value != None else NULL
    err = ccuda.cuStreamSetAttribute(chStream, cattr, cvalue_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuEventCreate(unsigned int Flags):
    """ Creates an event.

    Creates an event *phEvent for the current context with the flags
    specified via `Flags`. Valid flags include: - CU_EVENT_DEFAULT: Default
    event creation flag.    - CU_EVENT_BLOCKING_SYNC: Specifies that the
    created event should use blocking synchronization. A CPU thread that
    uses cuEventSynchronize() to wait on an event created with this flag
    will block until the event has actually been recorded.    -
    CU_EVENT_DISABLE_TIMING: Specifies that the created event does not need
    to record timing data. Events created with this flag specified and the
    CU_EVENT_BLOCKING_SYNC flag not specified will provide the best
    performance when used with cuStreamWaitEvent() and cuEventQuery().    -
    CU_EVENT_INTERPROCESS: Specifies that the created event may be used as
    an interprocess event by cuIpcGetEventHandle(). CU_EVENT_INTERPROCESS
    must be specified along with CU_EVENT_DISABLE_TIMING.

    Parameters
    ----------
    Flags : unsigned int
        Event creation flags

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    phEvent : CUevent
        Returns newly created event

    See Also
    --------
    cuEventRecord
    cuEventQuery
    cuEventSynchronize
    cuEventDestroy
    cuEventElapsedTime
    cudaEventCreate
    cudaEventCreateWithFlags
    """
    cdef CUevent phEvent = CUevent()
    err = ccuda.cuEventCreate(phEvent._ptr, Flags)
    return (CUresult(err), phEvent)

@cython.embedsignature(True)
def cuEventRecord(hEvent, hStream):
    """ Records an event.

    Captures in `hEvent` the contents of `hStream` at the time of this
    call. `hEvent` and `hStream` must be from the same context. Calls such
    as cuEventQuery() or cuStreamWaitEvent() will then examine or wait for
    completion of the work that was captured. Uses of `hStream` after this
    call do not modify `hEvent`. See note on default stream behavior for
    what is captured in the default case.

    cuEventRecord() can be called multiple times on the same event and will
    overwrite the previously captured state. Other APIs such as
    cuStreamWaitEvent() use the most recently captured state at the time of
    the API call, and are not affected by later calls to cuEventRecord().
    Before the first call to cuEventRecord(), an event represents an empty
    set of work, so for example cuEventQuery() would return CUDA_SUCCESS.

    Parameters
    ----------
    hEvent : Any
        Event to record
    hStream : CUstream or cudaStream_t
        Stream to record event for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuEventCreate
    cuEventQuery
    cuEventSynchronize
    cuStreamWaitEvent
    cuEventDestroy
    cuEventElapsedTime
    cudaEventRecord
    cuEventRecordWithFlags
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUevent chEvent
    if hEvent is None:
        chEvent = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEvent, (CUevent)):
        phEvent = int(hEvent)
        chEvent = <ccuda.CUevent><void_ptr>phEvent
    else:
        phEvent = int(CUevent(hEvent))
        chEvent = <ccuda.CUevent><void_ptr>phEvent

    err = ccuda.cuEventRecord(chEvent, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuEventRecordWithFlags(hEvent, hStream, unsigned int flags):
    """ Records an event.

    Captures in `hEvent` the contents of `hStream` at the time of this
    call. `hEvent` and `hStream` must be from the same context. Calls such
    as cuEventQuery() or cuStreamWaitEvent() will then examine or wait for
    completion of the work that was captured. Uses of `hStream` after this
    call do not modify `hEvent`. See note on default stream behavior for
    what is captured in the default case.

    cuEventRecordWithFlags() can be called multiple times on the same event
    and will overwrite the previously captured state. Other APIs such as
    cuStreamWaitEvent() use the most recently captured state at the time of
    the API call, and are not affected by later calls to
    cuEventRecordWithFlags(). Before the first call to
    cuEventRecordWithFlags(), an event represents an empty set of work, so
    for example cuEventQuery() would return CUDA_SUCCESS.

    flags include: - CU_EVENT_RECORD_DEFAULT: Default event creation flag.
    - CU_EVENT_RECORD_EXTERNAL: Event is captured in the graph as an
    external event node when performing stream capture. This flag is
    invalid outside of stream capture.

    Parameters
    ----------
    hEvent : Any
        Event to record
    hStream : CUstream or cudaStream_t
        Stream to record event for
    flags : unsigned int
        See CUevent_capture_flags

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuEventCreate
    cuEventQuery
    cuEventSynchronize
    cuStreamWaitEvent
    cuEventDestroy
    cuEventElapsedTime
    cuEventRecord
    cudaEventRecord
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUevent chEvent
    if hEvent is None:
        chEvent = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEvent, (CUevent)):
        phEvent = int(hEvent)
        chEvent = <ccuda.CUevent><void_ptr>phEvent
    else:
        phEvent = int(CUevent(hEvent))
        chEvent = <ccuda.CUevent><void_ptr>phEvent

    err = ccuda.cuEventRecordWithFlags(chEvent, chStream, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuEventQuery(hEvent):
    """ Queries an event's status.

    Queries the status of all work currently captured by `hEvent`. See
    cuEventRecord() for details on what is captured by an event.

    Returns CUDA_SUCCESS if all captured work has been completed, or
    CUDA_ERROR_NOT_READY if any captured work is incomplete.

    For the purposes of Unified Memory, a return value of CUDA_SUCCESS is
    equivalent to having called cuEventSynchronize().

    Parameters
    ----------
    hEvent : Any
        Event to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_READY
    None
        None

    See Also
    --------
    cuEventCreate
    cuEventRecord
    cuEventSynchronize
    cuEventDestroy
    cuEventElapsedTime
    cudaEventQuery
    """
    cdef ccuda.CUevent chEvent
    if hEvent is None:
        chEvent = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEvent, (CUevent)):
        phEvent = int(hEvent)
        chEvent = <ccuda.CUevent><void_ptr>phEvent
    else:
        phEvent = int(CUevent(hEvent))
        chEvent = <ccuda.CUevent><void_ptr>phEvent

    err = ccuda.cuEventQuery(chEvent)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuEventSynchronize(hEvent):
    """ Waits for an event to complete.

    Waits until the completion of all work currently captured in `hEvent`.
    See cuEventRecord() for details on what is captured by an event.

    Waiting for an event that was created with the CU_EVENT_BLOCKING_SYNC
    flag will cause the calling CPU thread to block until the event has
    been completed by the device. If the CU_EVENT_BLOCKING_SYNC flag has
    not been set, then the CPU thread will busy-wait until the event has
    been completed by the device.

    Parameters
    ----------
    hEvent : Any
        Event to wait for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuEventCreate
    cuEventRecord
    cuEventQuery
    cuEventDestroy
    cuEventElapsedTime
    cudaEventSynchronize
    """
    cdef ccuda.CUevent chEvent
    if hEvent is None:
        chEvent = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEvent, (CUevent)):
        phEvent = int(hEvent)
        chEvent = <ccuda.CUevent><void_ptr>phEvent
    else:
        phEvent = int(CUevent(hEvent))
        chEvent = <ccuda.CUevent><void_ptr>phEvent

    err = ccuda.cuEventSynchronize(chEvent)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuEventDestroy(hEvent):
    """ Destroys an event.

    Destroys the event specified by `hEvent`.

    An event may be destroyed before it is complete (i.e., while
    cuEventQuery() would return CUDA_ERROR_NOT_READY). In this case, the
    call does not block on completion of the event, and any associated
    resources will automatically be released asynchronously at completion.

    Parameters
    ----------
    hEvent : Any
        Event to destroy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuEventCreate
    cuEventRecord
    cuEventQuery
    cuEventSynchronize
    cuEventElapsedTime
    cudaEventDestroy
    """
    cdef ccuda.CUevent chEvent
    if hEvent is None:
        chEvent = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEvent, (CUevent)):
        phEvent = int(hEvent)
        chEvent = <ccuda.CUevent><void_ptr>phEvent
    else:
        phEvent = int(CUevent(hEvent))
        chEvent = <ccuda.CUevent><void_ptr>phEvent

    err = ccuda.cuEventDestroy(chEvent)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuEventElapsedTime(hStart, hEnd):
    """ Computes the elapsed time between two events.

    Computes the elapsed time between two events (in milliseconds with a
    resolution of around 0.5 microseconds).

    If either event was last recorded in a non-NULL stream, the resulting
    time may be greater than expected (even if both used the same stream
    handle). This happens because the cuEventRecord() operation takes place
    asynchronously and there is no guarantee that the measured latency is
    actually just between the two events. Any number of other different
    stream operations could execute in between the two measured events,
    thus altering the timing in a significant way.

    If cuEventRecord() has not been called on either event then
    CUDA_ERROR_INVALID_HANDLE is returned. If cuEventRecord() has been
    called on both events but one or both of them has not yet been
    completed (that is, cuEventQuery() would return CUDA_ERROR_NOT_READY on
    at least one of the events), CUDA_ERROR_NOT_READY is returned. If
    either event was created with the CU_EVENT_DISABLE_TIMING flag, then
    this function will return CUDA_ERROR_INVALID_HANDLE.

    Parameters
    ----------
    hStart : Any
        Starting event
    hEnd : Any
        Ending event

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_READY
    pMilliseconds : float
        Time between `hStart` and `hEnd` in ms

    See Also
    --------
    cuEventCreate
    cuEventRecord
    cuEventQuery
    cuEventSynchronize
    cuEventDestroy
    cudaEventElapsedTime
    """
    cdef ccuda.CUevent chEnd
    if hEnd is None:
        chEnd = <ccuda.CUevent><void_ptr>0
    elif isinstance(hEnd, (CUevent)):
        phEnd = int(hEnd)
        chEnd = <ccuda.CUevent><void_ptr>phEnd
    else:
        phEnd = int(CUevent(hEnd))
        chEnd = <ccuda.CUevent><void_ptr>phEnd

    cdef ccuda.CUevent chStart
    if hStart is None:
        chStart = <ccuda.CUevent><void_ptr>0
    elif isinstance(hStart, (CUevent)):
        phStart = int(hStart)
        chStart = <ccuda.CUevent><void_ptr>phStart
    else:
        phStart = int(CUevent(hStart))
        chStart = <ccuda.CUevent><void_ptr>phStart

    cdef float pMilliseconds = 0
    err = ccuda.cuEventElapsedTime(&pMilliseconds, chStart, chEnd)
    return (CUresult(err), pMilliseconds)

@cython.embedsignature(True)
def cuImportExternalMemory(memHandleDesc : CUDA_EXTERNAL_MEMORY_HANDLE_DESC):
    """ Imports an external memory object.

    Imports an externally allocated memory object and returns a handle to
    that in `extMem_out`.

    The properties of the handle being imported must be described in
    `memHandleDesc`. The CUDA_EXTERNAL_MEMORY_HANDLE_DESC structure is
    defined as follows:

    typedefstructCUDA_EXTERNAL_MEMORY_HANDLE_DESC_st{
    CUexternalMemoryHandleTypetype; union{ intfd; struct{ void*handle;
    constvoid*name; }win32; constvoid*nvSciBufObject; }handle;
    unsignedlonglongsize; unsignedintflags;
    }CUDA_EXTERNAL_MEMORY_HANDLE_DESC;

    where CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type specifies the type of
    handle being imported. CUexternalMemoryHandleType is defined as:

    typedefenumCUexternalMemoryHandleType_enum{
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD=1,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32=2,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT=3,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP=4,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE=5,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE=6,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT=7,
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF=8 }CUexternalMemoryHandleType;

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD, then
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::fd must be a valid file
    descriptor referencing a memory object. Ownership of the file
    descriptor is transferred to the CUDA driver when the handle is
    imported successfully. Performing any operations on the file descriptor
    after it is imported results in undefined behavior.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32, then exactly one of
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle and
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name must not be NULL.
    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle is not NULL,
    then it must represent a valid shared NT handle that references a
    memory object. Ownership of this handle is not transferred to CUDA
    after the import operation, so the application must release the handle
    using the appropriate system call. If
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name is not NULL, then
    it must point to a NULL-terminated array of UTF-16 characters that
    refers to a memory object.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT, then
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle must be non-
    NULL and CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name must be
    NULL. The handle specified must be a globally shared KMT handle. This
    handle does not hold a reference to the underlying object, and thus
    will be invalid when all references to the memory object are destroyed.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP, then exactly one of
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle and
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name must not be NULL.
    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle is not NULL,
    then it must represent a valid shared NT handle that is returned by
    ID3D12Device::CreateSharedHandle when referring to a ID3D12Heap object.
    This handle holds a reference to the underlying object. If
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name is not NULL, then
    it must point to a NULL-terminated array of UTF-16 characters that
    refers to a ID3D12Heap object.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE, then exactly one of
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle and
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name must not be NULL.
    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle is not NULL,
    then it must represent a valid shared NT handle that is returned by
    ID3D12Device::CreateSharedHandle when referring to a ID3D12Resource
    object. This handle holds a reference to the underlying object. If
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name is not NULL, then
    it must point to a NULL-terminated array of UTF-16 characters that
    refers to a ID3D12Resource object.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE, then
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle must represent
    a valid shared NT handle that is returned by
    IDXGIResource1::CreateSharedHandle when referring to a ID3D11Resource
    object. If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name is not
    NULL, then it must point to a NULL-terminated array of UTF-16
    characters that refers to a ID3D11Resource object.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT, then
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::handle must represent
    a valid shared KMT handle that is returned by
    IDXGIResource::GetSharedHandle when referring to a ID3D11Resource
    object and CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::win32::name must
    be NULL.

    If CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF, then
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::handle::nvSciBufObject must be non-
    NULL and reference a valid NvSciBuf object. If the NvSciBuf object
    imported into CUDA is also mapped by other drivers, then the
    application must use cuWaitExternalSemaphoresAsync or
    cuSignalExternalSemaphoresAsync as appropriate barriers to maintain
    coherence between CUDA and the other drivers. See
    CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC and
    CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC for memory
    synchronization.

    The size of the memory object must be specified in
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::size.

    Specifying the flag CUDA_EXTERNAL_MEMORY_DEDICATED in
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::flags indicates that the resource is
    a dedicated resource. The definition of what a dedicated resource is
    outside the scope of this extension. This flag must be set if
    CUDA_EXTERNAL_MEMORY_HANDLE_DESC::type is one of the following:
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_RESOURCE_KMT

    Parameters
    ----------
    memHandleDesc : CUDA_EXTERNAL_MEMORY_HANDLE_DESC
        Memory import handle descriptor

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    extMem_out : CUexternalMemory
        Returned handle to an external memory object

    See Also
    --------
    cuDestroyExternalMemory
    cuExternalMemoryGetMappedBuffer
    cuExternalMemoryGetMappedMipmappedArray

    Notes
    -----
    If the Vulkan memory imported into CUDA is mapped on the CPU then the application must use vkInvalidateMappedMemoryRanges/vkFlushMappedMemoryRanges as well as appropriate Vulkan pipeline barriers to maintain coherence between CPU and GPU. For more information on these APIs, please refer to "Synchronization
    and Cache Control" chapter from Vulkan specification.

    """
    cdef CUexternalMemory extMem_out = CUexternalMemory()
    cdef ccuda.CUDA_EXTERNAL_MEMORY_HANDLE_DESC* cmemHandleDesc_ptr = memHandleDesc._ptr if memHandleDesc != None else NULL
    err = ccuda.cuImportExternalMemory(extMem_out._ptr, cmemHandleDesc_ptr)
    return (CUresult(err), extMem_out)

@cython.embedsignature(True)
def cuExternalMemoryGetMappedBuffer(extMem, bufferDesc : CUDA_EXTERNAL_MEMORY_BUFFER_DESC):
    """ Maps a buffer onto an imported memory object.

    Maps a buffer onto an imported memory object and returns a device
    pointer in `devPtr`.

    The properties of the buffer being mapped must be described in
    `bufferDesc`. The CUDA_EXTERNAL_MEMORY_BUFFER_DESC structure is defined
    as follows:

    typedefstructCUDA_EXTERNAL_MEMORY_BUFFER_DESC_st{
    unsignedlonglongoffset; unsignedlonglongsize; unsignedintflags;
    }CUDA_EXTERNAL_MEMORY_BUFFER_DESC;

    where CUDA_EXTERNAL_MEMORY_BUFFER_DESC::offset is the offset in the
    memory object where the buffer's base address is.
    CUDA_EXTERNAL_MEMORY_BUFFER_DESC::size is the size of the buffer.
    CUDA_EXTERNAL_MEMORY_BUFFER_DESC::flags must be zero.

    The offset and size have to be suitably aligned to match the
    requirements of the external API. Mapping two buffers whose ranges
    overlap may or may not result in the same virtual address being
    returned for the overlapped portion. In such cases, the application
    must ensure that all accesses to that region from the GPU are volatile.
    Otherwise writes made via one address are not guaranteed to be visible
    via the other address, even if they're issued by the same thread. It is
    recommended that applications map the combined range instead of mapping
    separate buffers and then apply the appropriate offsets to the returned
    pointer to derive the individual buffers.

    The returned pointer `devPtr` must be freed using cuMemFree.

    Parameters
    ----------
    extMem : Any
        Handle to external memory object
    bufferDesc : CUDA_EXTERNAL_MEMORY_BUFFER_DESC
        Buffer descriptor

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    devPtr : CUdeviceptr
        Returned device pointer to buffer

    See Also
    --------
    cuImportExternalMemory
    cuDestroyExternalMemory
    cuExternalMemoryGetMappedMipmappedArray
    """
    cdef ccuda.CUexternalMemory cextMem
    if extMem is None:
        cextMem = <ccuda.CUexternalMemory><void_ptr>0
    elif isinstance(extMem, (CUexternalMemory)):
        pextMem = int(extMem)
        cextMem = <ccuda.CUexternalMemory><void_ptr>pextMem
    else:
        pextMem = int(CUexternalMemory(extMem))
        cextMem = <ccuda.CUexternalMemory><void_ptr>pextMem

    cdef CUdeviceptr devPtr = CUdeviceptr()
    cdef ccuda.CUDA_EXTERNAL_MEMORY_BUFFER_DESC* cbufferDesc_ptr = bufferDesc._ptr if bufferDesc != None else NULL
    err = ccuda.cuExternalMemoryGetMappedBuffer(devPtr._ptr, cextMem, cbufferDesc_ptr)
    return (CUresult(err), devPtr)

@cython.embedsignature(True)
def cuExternalMemoryGetMappedMipmappedArray(extMem, mipmapDesc : CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC):
    """ Maps a CUDA mipmapped array onto an external memory object.

    Maps a CUDA mipmapped array onto an external object and returns a
    handle to it in `mipmap`.

    The properties of the CUDA mipmapped array being mapped must be
    described in `mipmapDesc`. The structure
    CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC is defined as follows:

    typedefstructCUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC_st{
    unsignedlonglongoffset; CUDA_ARRAY3D_DESCRIPTORarrayDesc;
    unsignedintnumLevels; }CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC;

    where CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC::offset is the offset
    in the memory object where the base level of the mipmap chain is.
    CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC::arrayDesc describes the
    format, dimensions and type of the base level of the mipmap chain. For
    further details on these parameters, please refer to the documentation
    for cuMipmappedArrayCreate. Note that if the mipmapped array is bound
    as a color target in the graphics API, then the flag
    CUDA_ARRAY3D_COLOR_ATTACHMENT must be specified in
    CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC::arrayDesc::Flags.
    CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC::numLevels specifies the
    total number of levels in the mipmap chain.

    If `extMem` was imported from a handle of type
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF, then
    CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC::numLevels must be equal to
    1.

    The returned CUDA mipmapped array must be freed using
    cuMipmappedArrayDestroy.

    Parameters
    ----------
    extMem : Any
        Handle to external memory object
    mipmapDesc : CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC
        CUDA array descriptor

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
    mipmap : CUmipmappedArray
        Returned CUDA mipmapped array

    See Also
    --------
    cuImportExternalMemory
    cuDestroyExternalMemory
    cuExternalMemoryGetMappedBuffer
    """
    cdef ccuda.CUexternalMemory cextMem
    if extMem is None:
        cextMem = <ccuda.CUexternalMemory><void_ptr>0
    elif isinstance(extMem, (CUexternalMemory)):
        pextMem = int(extMem)
        cextMem = <ccuda.CUexternalMemory><void_ptr>pextMem
    else:
        pextMem = int(CUexternalMemory(extMem))
        cextMem = <ccuda.CUexternalMemory><void_ptr>pextMem

    cdef CUmipmappedArray mipmap = CUmipmappedArray()
    cdef ccuda.CUDA_EXTERNAL_MEMORY_MIPMAPPED_ARRAY_DESC* cmipmapDesc_ptr = mipmapDesc._ptr if mipmapDesc != None else NULL
    err = ccuda.cuExternalMemoryGetMappedMipmappedArray(mipmap._ptr, cextMem, cmipmapDesc_ptr)
    return (CUresult(err), mipmap)

@cython.embedsignature(True)
def cuDestroyExternalMemory(extMem):
    """ Destroys an external memory object.

    Destroys the specified external memory object. Any existing buffers and
    CUDA mipmapped arrays mapped onto this object must no longer be used
    and must be explicitly freed using cuMemFree and
    cuMipmappedArrayDestroy respectively.

    Parameters
    ----------
    extMem : Any
        External memory object to be destroyed

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuImportExternalMemory
    cuExternalMemoryGetMappedBuffer
    cuExternalMemoryGetMappedMipmappedArray
    """
    cdef ccuda.CUexternalMemory cextMem
    if extMem is None:
        cextMem = <ccuda.CUexternalMemory><void_ptr>0
    elif isinstance(extMem, (CUexternalMemory)):
        pextMem = int(extMem)
        cextMem = <ccuda.CUexternalMemory><void_ptr>pextMem
    else:
        pextMem = int(CUexternalMemory(extMem))
        cextMem = <ccuda.CUexternalMemory><void_ptr>pextMem

    err = ccuda.cuDestroyExternalMemory(cextMem)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuImportExternalSemaphore(semHandleDesc : CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC):
    """ Imports an external semaphore.

    Imports an externally allocated synchronization object and returns a
    handle to that in `extSem_out`.

    The properties of the handle being imported must be described in
    `semHandleDesc`. The CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC is defined as
    follows:

    typedefstructCUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC_st{
    CUexternalSemaphoreHandleTypetype; union{ intfd; struct{ void*handle;
    constvoid*name; }win32; constvoid*NvSciSyncObj; }handle;
    unsignedintflags; }CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC;

    where CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type specifies the type of
    handle being imported. CUexternalSemaphoreHandleType is defined as:

    typedefenumCUexternalSemaphoreHandleType_enum{
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD=1,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32=2,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT=3,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE=4,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE=5,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC=6,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX=7,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT=8,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD=9,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32=10
    }CUexternalSemaphoreHandleType;

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::fd must be a valid file
    descriptor referencing a synchronization object. Ownership of the file
    descriptor is transferred to the CUDA driver when the handle is
    imported successfully. Performing any operations on the file descriptor
    after it is imported results in undefined behavior.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32, then exactly one of
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle and
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name must not be
    NULL. If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that
    references a synchronization object. Ownership of this handle is not
    transferred to CUDA after the import operation, so the application must
    release the handle using the appropriate system call. If
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name is not NULL,
    then it must name a valid synchronization object.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle must be non-
    NULL and CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name must
    be NULL. The handle specified must be a globally shared KMT handle.
    This handle does not hold a reference to the underlying object, and
    thus will be invalid when all references to the synchronization object
    are destroyed.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE, then exactly one of
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle and
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name must not be
    NULL. If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that is
    returned by ID3D12Device::CreateSharedHandle when referring to a
    ID3D12Fence object. This handle holds a reference to the underlying
    object. If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name is
    not NULL, then it must name a valid synchronization object that refers
    to a valid ID3D12Fence object.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle represents a
    valid shared NT handle that is returned by
    ID3D11Fence::CreateSharedHandle. If
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name is not NULL,
    then it must name a valid synchronization object that refers to a valid
    ID3D11Fence object.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::nvSciSyncObj represents a
    valid NvSciSyncObj.

    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle represents a
    valid shared NT handle that is returned by
    IDXGIResource1::CreateSharedHandle when referring to a IDXGIKeyedMutex
    object. If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name is
    not NULL, then it must name a valid synchronization object that refers
    to a valid IDXGIKeyedMutex object.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle represents a
    valid shared KMT handle that is returned by
    IDXGIResource::GetSharedHandle when referring to a IDXGIKeyedMutex
    object and CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name
    must be NULL.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD, then
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::fd must be a valid file
    descriptor referencing a synchronization object. Ownership of the file
    descriptor is transferred to the CUDA driver when the handle is
    imported successfully. Performing any operations on the file descriptor
    after it is imported results in undefined behavior.

    If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::type is
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32, then
    exactly one of
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle and
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name must not be
    NULL. If CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::handle is
    not NULL, then it must represent a valid shared NT handle that
    references a synchronization object. Ownership of this handle is not
    transferred to CUDA after the import operation, so the application must
    release the handle using the appropriate system call. If
    CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC::handle::win32::name is not NULL,
    then it must name a valid synchronization object.

    Parameters
    ----------
    semHandleDesc : CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC
        Semaphore import handle descriptor

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_HANDLE
    extSem_out : CUexternalSemaphore
        Returned handle to an external semaphore

    See Also
    --------
    cuDestroyExternalSemaphore
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef CUexternalSemaphore extSem_out = CUexternalSemaphore()
    cdef ccuda.CUDA_EXTERNAL_SEMAPHORE_HANDLE_DESC* csemHandleDesc_ptr = semHandleDesc._ptr if semHandleDesc != None else NULL
    err = ccuda.cuImportExternalSemaphore(extSem_out._ptr, csemHandleDesc_ptr)
    return (CUresult(err), extSem_out)

@cython.embedsignature(True)
def cuSignalExternalSemaphoresAsync(extSemArray : List[CUexternalSemaphore], paramsArray : List[CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS], unsigned int numExtSems, stream):
    """ Signals a set of external semaphore objects.

    Enqueues a signal operation on a set of externally allocated semaphore
    object in the specified stream. The operations will be executed when
    all prior operations in the stream complete.

    The exact semantics of signaling a semaphore depends on the type of the
    object.

    If the semaphore object is any one of the following types:
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT then signaling the
    semaphore will set it to the signaled state.

    If the semaphore object is any one of the following types:
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32 then the
    semaphore will be set to the value specified in
    CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS::params::fence::value.

    If the semaphore object is of the type
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC this API sets
    CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS::params::nvSciSync::fence to a
    value that can be used by subsequent waiters of the same NvSciSync
    object to order operations with those currently submitted in `stream`.
    Such an update will overwrite previous contents of
    CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS::params::nvSciSync::fence. By
    default, signaling such an external semaphore object causes appropriate
    memory synchronization operations to be performed over all external
    memory objects that are imported as
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF. This ensures that any
    subsequent accesses made by other importers of the same set of NvSciBuf
    memory object(s) are coherent. These operations can be skipped by
    specifying the flag
    CUDA_EXTERNAL_SEMAPHORE_SIGNAL_SKIP_NVSCIBUF_MEMSYNC, which can be used
    as a performance optimization when data coherency is not required. But
    specifying this flag in scenarios where data coherency is required
    results in undefined behavior. Also, for semaphore object of the type
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, if the NvSciSyncAttrList
    used to create the NvSciSyncObj had not set the flags in
    cuDeviceGetNvSciSyncAttributes to CUDA_NVSCISYNC_ATTR_SIGNAL, this API
    will return CUDA_ERROR_NOT_SUPPORTED.

    If the semaphore object is any one of the following types:
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT then the keyed
    mutex will be released with the key specified in
    CUDA_EXTERNAL_SEMAPHORE_PARAMS::params::keyedmutex::key.

    Parameters
    ----------
    extSemArray : List[CUexternalSemaphore]
        Set of external semaphores to be signaled
    paramsArray : List[CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS]
        Array of semaphore parameters
    numExtSems : unsigned int
        Number of semaphores to signal
    stream : CUstream or cudaStream_t
        Stream to enqueue the signal operations in

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuImportExternalSemaphore
    cuDestroyExternalSemaphore
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    paramsArray = [] if paramsArray is None else paramsArray
    if not all(isinstance(_x, (CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS)) for _x in paramsArray):
        raise TypeError("Argument 'paramsArray' is not instance of type (expected List[ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS]")

    extSemArray = [] if extSemArray is None else extSemArray
    if not all(isinstance(_x, (CUexternalSemaphore)) for _x in extSemArray):
        raise TypeError("Argument 'extSemArray' is not instance of type (expected List[ccuda.CUexternalSemaphore]")

    cdef ccuda.CUexternalSemaphore* cextSemArray = NULL
    if len(extSemArray) > 0:
        cextSemArray = <ccuda.CUexternalSemaphore*> calloc(len(extSemArray), sizeof(ccuda.CUexternalSemaphore))
        if cextSemArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(extSemArray)) + 'x' + str(sizeof(ccuda.CUexternalSemaphore)))
        else:
            for idx in range(len(extSemArray)):
                cextSemArray[idx] = (<CUexternalSemaphore>extSemArray[idx])._ptr[0]

    cdef ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS* cparamsArray = NULL
    if len(paramsArray) > 0:
        cparamsArray = <ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS*> calloc(len(paramsArray), sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))
        if cparamsArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(paramsArray)) + 'x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS)))
        for idx in range(len(paramsArray)):
            memcpy(&cparamsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS>paramsArray[idx])._ptr, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS))

    if numExtSems > len(extSemArray): raise RuntimeError("List is too small: " + str(len(extSemArray)) + " < " + str(numExtSems))
    if numExtSems > len(paramsArray): raise RuntimeError("List is too small: " + str(len(paramsArray)) + " < " + str(numExtSems))
    err = ccuda.cuSignalExternalSemaphoresAsync((<CUexternalSemaphore>extSemArray[0])._ptr if len(extSemArray) == 1 else cextSemArray, (<CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS>paramsArray[0])._ptr if len(paramsArray) == 1 else cparamsArray, numExtSems, cstream)
    if cextSemArray is not NULL:
        free(cextSemArray)
    if cparamsArray is not NULL:
        free(cparamsArray)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuWaitExternalSemaphoresAsync(extSemArray : List[CUexternalSemaphore], paramsArray : List[CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS], unsigned int numExtSems, stream):
    """ Waits on a set of external semaphore objects.

    Enqueues a wait operation on a set of externally allocated semaphore
    object in the specified stream. The operations will be executed when
    all prior operations in the stream complete.

    The exact semantics of waiting on a semaphore depends on the type of
    the object.

    If the semaphore object is any one of the following types:
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT then waiting on the
    semaphore will wait until the semaphore reaches the signaled state. The
    semaphore will then be reset to the unsignaled state. Therefore for
    every signal operation, there can only be one wait operation.

    If the semaphore object is any one of the following types:
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_FENCE,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_FD,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_TIMELINE_SEMAPHORE_WIN32 then waiting
    on the semaphore will wait until the value of the semaphore is greater
    than or equal to
    CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS::params::fence::value.

    If the semaphore object is of the type
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC then, waiting on the
    semaphore will wait until the
    CUDA_EXTERNAL_SEMAPHORE_SIGNAL_PARAMS::params::nvSciSync::fence is
    signaled by the signaler of the NvSciSyncObj that was associated with
    this semaphore object. By default, waiting on such an external
    semaphore object causes appropriate memory synchronization operations
    to be performed over all external memory objects that are imported as
    CU_EXTERNAL_MEMORY_HANDLE_TYPE_NVSCIBUF. This ensures that any
    subsequent accesses made by other importers of the same set of NvSciBuf
    memory object(s) are coherent. These operations can be skipped by
    specifying the flag CUDA_EXTERNAL_SEMAPHORE_WAIT_SKIP_NVSCIBUF_MEMSYNC,
    which can be used as a performance optimization when data coherency is
    not required. But specifying this flag in scenarios where data
    coherency is required results in undefined behavior. Also, for
    semaphore object of the type
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_NVSCISYNC, if the NvSciSyncAttrList
    used to create the NvSciSyncObj had not set the flags in
    cuDeviceGetNvSciSyncAttributes to CUDA_NVSCISYNC_ATTR_WAIT, this API
    will return CUDA_ERROR_NOT_SUPPORTED.

    If the semaphore object is any one of the following types:
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX,
    CU_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D11_KEYED_MUTEX_KMT then the keyed
    mutex will be acquired when it is released with the key specified in
    CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS::params::keyedmutex::key or until
    the timeout specified by
    CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS::params::keyedmutex::timeoutMs has
    lapsed. The timeout interval can either be a finite value specified in
    milliseconds or an infinite value. In case an infinite value is
    specified the timeout never elapses. The windows INFINITE macro must be
    used to specify infinite timeout.

    Parameters
    ----------
    extSemArray : List[CUexternalSemaphore]
        External semaphores to be waited on
    paramsArray : List[CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS]
        Array of semaphore parameters
    numExtSems : unsigned int
        Number of semaphores to wait on
    stream : CUstream or cudaStream_t
        Stream to enqueue the wait operations in

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_TIMEOUT
    None
        None

    See Also
    --------
    cuImportExternalSemaphore
    cuDestroyExternalSemaphore
    cuSignalExternalSemaphoresAsync
    """
    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    paramsArray = [] if paramsArray is None else paramsArray
    if not all(isinstance(_x, (CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS)) for _x in paramsArray):
        raise TypeError("Argument 'paramsArray' is not instance of type (expected List[ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS]")

    extSemArray = [] if extSemArray is None else extSemArray
    if not all(isinstance(_x, (CUexternalSemaphore)) for _x in extSemArray):
        raise TypeError("Argument 'extSemArray' is not instance of type (expected List[ccuda.CUexternalSemaphore]")

    cdef ccuda.CUexternalSemaphore* cextSemArray = NULL
    if len(extSemArray) > 0:
        cextSemArray = <ccuda.CUexternalSemaphore*> calloc(len(extSemArray), sizeof(ccuda.CUexternalSemaphore))
        if cextSemArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(extSemArray)) + 'x' + str(sizeof(ccuda.CUexternalSemaphore)))
        else:
            for idx in range(len(extSemArray)):
                cextSemArray[idx] = (<CUexternalSemaphore>extSemArray[idx])._ptr[0]

    cdef ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS* cparamsArray = NULL
    if len(paramsArray) > 0:
        cparamsArray = <ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS*> calloc(len(paramsArray), sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))
        if cparamsArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(paramsArray)) + 'x' + str(sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS)))
        for idx in range(len(paramsArray)):
            memcpy(&cparamsArray[idx], (<CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS>paramsArray[idx])._ptr, sizeof(ccuda.CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS))

    if numExtSems > len(extSemArray): raise RuntimeError("List is too small: " + str(len(extSemArray)) + " < " + str(numExtSems))
    if numExtSems > len(paramsArray): raise RuntimeError("List is too small: " + str(len(paramsArray)) + " < " + str(numExtSems))
    err = ccuda.cuWaitExternalSemaphoresAsync((<CUexternalSemaphore>extSemArray[0])._ptr if len(extSemArray) == 1 else cextSemArray, (<CUDA_EXTERNAL_SEMAPHORE_WAIT_PARAMS>paramsArray[0])._ptr if len(paramsArray) == 1 else cparamsArray, numExtSems, cstream)
    if cextSemArray is not NULL:
        free(cextSemArray)
    if cparamsArray is not NULL:
        free(cparamsArray)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDestroyExternalSemaphore(extSem):
    """ Destroys an external semaphore.

    Destroys an external semaphore object and releases any references to
    the underlying resource. Any outstanding signals or waits must have
    completed before the semaphore is destroyed.

    Parameters
    ----------
    extSem : Any
        External semaphore to be destroyed

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_HANDLE
    None
        None

    See Also
    --------
    cuImportExternalSemaphore
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUexternalSemaphore cextSem
    if extSem is None:
        cextSem = <ccuda.CUexternalSemaphore><void_ptr>0
    elif isinstance(extSem, (CUexternalSemaphore)):
        pextSem = int(extSem)
        cextSem = <ccuda.CUexternalSemaphore><void_ptr>pextSem
    else:
        pextSem = int(CUexternalSemaphore(extSem))
        cextSem = <ccuda.CUexternalSemaphore><void_ptr>pextSem

    err = ccuda.cuDestroyExternalSemaphore(cextSem)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamWaitValue32(stream, addr, value, unsigned int flags):
    """ Wait on a memory location.

    Enqueues a synchronization of the stream on the given memory location.
    Work ordered after the operation will block until the given condition
    on the memory is satisfied. By default, the condition is to wait for
    (int32_t)(*addr - value) >= 0, a cyclic greater-or-equal. Other
    condition types can be specified via `flags`.

    If the memory was registered via cuMemHostRegister(), the device
    pointer should be obtained with cuMemHostGetDevicePointer(). This
    function cannot be used with managed memory (cuMemAllocManaged).

    Support for this can be queried with cuDeviceGetAttribute() and
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS.

    Support for CU_STREAM_WAIT_VALUE_NOR can be queried with
    cuDeviceGetAttribute() and
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_WAIT_VALUE_NOR.

    Parameters
    ----------
    stream : CUstream or cudaStream_t
        The stream to synchronize on the memory location.
    addr : Any
        The memory location to wait on.
    value : Any
        The value to compare with the memory location.
    flags : unsigned int
        See CUstreamWaitValue_flags.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamWaitValue64
    cuStreamWriteValue32
    cuStreamWriteValue64
    cuStreamBatchMemOp
    cuMemHostRegister
    cuStreamWaitEvent
    """
    cdef ccuda.cuuint32_t cvalue
    if value is None:
        cvalue = <ccuda.cuuint32_t><void_ptr>0
    elif isinstance(value, (cuuint32_t)):
        pvalue = int(value)
        cvalue = <ccuda.cuuint32_t><void_ptr>pvalue
    else:
        pvalue = int(cuuint32_t(value))
        cvalue = <ccuda.cuuint32_t><void_ptr>pvalue

    cdef ccuda.CUdeviceptr caddr
    if addr is None:
        caddr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(addr, (CUdeviceptr)):
        paddr = int(addr)
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr
    else:
        paddr = int(CUdeviceptr(addr))
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr

    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    err = ccuda.cuStreamWaitValue32(cstream, caddr, cvalue, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamWaitValue64(stream, addr, value, unsigned int flags):
    """ Wait on a memory location.

    Enqueues a synchronization of the stream on the given memory location.
    Work ordered after the operation will block until the given condition
    on the memory is satisfied. By default, the condition is to wait for
    (int64_t)(*addr - value) >= 0, a cyclic greater-or-equal. Other
    condition types can be specified via `flags`.

    If the memory was registered via cuMemHostRegister(), the device
    pointer should be obtained with cuMemHostGetDevicePointer().

    Support for this can be queried with cuDeviceGetAttribute() and
    CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS.

    Parameters
    ----------
    stream : CUstream or cudaStream_t
        The stream to synchronize on the memory location.
    addr : Any
        The memory location to wait on.
    value : Any
        The value to compare with the memory location.
    flags : unsigned int
        See CUstreamWaitValue_flags.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamWaitValue32
    cuStreamWriteValue32
    cuStreamWriteValue64
    cuStreamBatchMemOp
    cuMemHostRegister
    cuStreamWaitEvent
    """
    cdef ccuda.cuuint64_t cvalue
    if value is None:
        cvalue = <ccuda.cuuint64_t><void_ptr>0
    elif isinstance(value, (cuuint64_t)):
        pvalue = int(value)
        cvalue = <ccuda.cuuint64_t><void_ptr>pvalue
    else:
        pvalue = int(cuuint64_t(value))
        cvalue = <ccuda.cuuint64_t><void_ptr>pvalue

    cdef ccuda.CUdeviceptr caddr
    if addr is None:
        caddr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(addr, (CUdeviceptr)):
        paddr = int(addr)
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr
    else:
        paddr = int(CUdeviceptr(addr))
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr

    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    err = ccuda.cuStreamWaitValue64(cstream, caddr, cvalue, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamWriteValue32(stream, addr, value, unsigned int flags):
    """ Write a value to memory.

    Write a value to memory. Unless the
    CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER flag is passed, the write is
    preceded by a system-wide memory fence, equivalent to a
    __threadfence_system() but scoped to the stream rather than a CUDA
    thread.

    If the memory was registered via cuMemHostRegister(), the device
    pointer should be obtained with cuMemHostGetDevicePointer(). This
    function cannot be used with managed memory (cuMemAllocManaged).

    Support for this can be queried with cuDeviceGetAttribute() and
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS.

    Parameters
    ----------
    stream : CUstream or cudaStream_t
        The stream to do the write in.
    addr : Any
        The device address to write to.
    value : Any
        The value to write.
    flags : unsigned int
        See CUstreamWriteValue_flags.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamWriteValue64
    cuStreamWaitValue32
    cuStreamWaitValue64
    cuStreamBatchMemOp
    cuMemHostRegister
    cuEventRecord
    """
    cdef ccuda.cuuint32_t cvalue
    if value is None:
        cvalue = <ccuda.cuuint32_t><void_ptr>0
    elif isinstance(value, (cuuint32_t)):
        pvalue = int(value)
        cvalue = <ccuda.cuuint32_t><void_ptr>pvalue
    else:
        pvalue = int(cuuint32_t(value))
        cvalue = <ccuda.cuuint32_t><void_ptr>pvalue

    cdef ccuda.CUdeviceptr caddr
    if addr is None:
        caddr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(addr, (CUdeviceptr)):
        paddr = int(addr)
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr
    else:
        paddr = int(CUdeviceptr(addr))
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr

    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    err = ccuda.cuStreamWriteValue32(cstream, caddr, cvalue, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamWriteValue64(stream, addr, value, unsigned int flags):
    """ Write a value to memory.

    Write a value to memory. Unless the
    CU_STREAM_WRITE_VALUE_NO_MEMORY_BARRIER flag is passed, the write is
    preceded by a system-wide memory fence, equivalent to a
    __threadfence_system() but scoped to the stream rather than a CUDA
    thread.

    If the memory was registered via cuMemHostRegister(), the device
    pointer should be obtained with cuMemHostGetDevicePointer().

    Support for this can be queried with cuDeviceGetAttribute() and
    CU_DEVICE_ATTRIBUTE_CAN_USE_64_BIT_STREAM_MEM_OPS.

    Parameters
    ----------
    stream : CUstream or cudaStream_t
        The stream to do the write in.
    addr : Any
        The device address to write to.
    value : Any
        The value to write.
    flags : unsigned int
        See CUstreamWriteValue_flags.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamWriteValue32
    cuStreamWaitValue32
    cuStreamWaitValue64
    cuStreamBatchMemOp
    cuMemHostRegister
    cuEventRecord
    """
    cdef ccuda.cuuint64_t cvalue
    if value is None:
        cvalue = <ccuda.cuuint64_t><void_ptr>0
    elif isinstance(value, (cuuint64_t)):
        pvalue = int(value)
        cvalue = <ccuda.cuuint64_t><void_ptr>pvalue
    else:
        pvalue = int(cuuint64_t(value))
        cvalue = <ccuda.cuuint64_t><void_ptr>pvalue

    cdef ccuda.CUdeviceptr caddr
    if addr is None:
        caddr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(addr, (CUdeviceptr)):
        paddr = int(addr)
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr
    else:
        paddr = int(CUdeviceptr(addr))
        caddr = <ccuda.CUdeviceptr><void_ptr>paddr

    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    err = ccuda.cuStreamWriteValue64(cstream, caddr, cvalue, flags)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuStreamBatchMemOp(stream, unsigned int count, paramArray : List[CUstreamBatchMemOpParams], unsigned int flags):
    """ Batch operations to synchronize the stream via memory operations.

    This is a batch version of cuStreamWaitValue32() and
    cuStreamWriteValue32(). Batching operations may avoid some performance
    overhead in both the API call and the device execution versus adding
    them to the stream in separate API calls. The operations are enqueued
    in the order they appear in the array.

    See CUstreamBatchMemOpType for the full set of supported operations,
    and cuStreamWaitValue32(), cuStreamWaitValue64(),
    cuStreamWriteValue32(), and cuStreamWriteValue64() for details of
    specific operations.

    Basic support for this can be queried with cuDeviceGetAttribute() and
    CU_DEVICE_ATTRIBUTE_CAN_USE_STREAM_MEM_OPS. See related APIs for
    details on querying support for specific operations.

    Parameters
    ----------
    stream : CUstream or cudaStream_t
        The stream to enqueue the operations in.
    count : unsigned int
        The number of operations in the array. Must be less than 256.
    paramArray : List[CUstreamBatchMemOpParams]
        The types and parameters of the individual operations.
    flags : unsigned int
        Reserved for future expansion; must be 0.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamWaitValue32
    cuStreamWaitValue64
    cuStreamWriteValue32
    cuStreamWriteValue64
    cuMemHostRegister
    """
    paramArray = [] if paramArray is None else paramArray
    if not all(isinstance(_x, (CUstreamBatchMemOpParams)) for _x in paramArray):
        raise TypeError("Argument 'paramArray' is not instance of type (expected List[ccuda.CUstreamBatchMemOpParams]")

    cdef ccuda.CUstream cstream
    if stream is None:
        cstream = <ccuda.CUstream><void_ptr>0
    elif isinstance(stream, (CUstream)):
        pstream = int(stream)
        cstream = <ccuda.CUstream><void_ptr>pstream
    else:
        pstream = int(CUstream(stream))
        cstream = <ccuda.CUstream><void_ptr>pstream

    if count > len(paramArray): raise RuntimeError("List is too small: " + str(len(paramArray)) + " < " + str(count))
    cdef ccuda.CUstreamBatchMemOpParams* cparamArray = NULL
    if len(paramArray) > 0:
        cparamArray = <ccuda.CUstreamBatchMemOpParams*> calloc(len(paramArray), sizeof(ccuda.CUstreamBatchMemOpParams))
        if cparamArray is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(paramArray)) + 'x' + str(sizeof(ccuda.CUstreamBatchMemOpParams)))
        for idx in range(len(paramArray)):
            memcpy(&cparamArray[idx], (<CUstreamBatchMemOpParams>paramArray[idx])._ptr, sizeof(ccuda.CUstreamBatchMemOpParams))

    err = ccuda.cuStreamBatchMemOp(cstream, count, (<CUstreamBatchMemOpParams>paramArray[0])._ptr if len(paramArray) == 1 else cparamArray, flags)
    if cparamArray is not NULL:
        free(cparamArray)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuFuncGetAttribute(attrib not None : CUfunction_attribute, hfunc):
    """ Returns information about a function.

    Returns in `*pi` the integer value of the attribute `attrib` on the
    kernel given by `hfunc`. The supported attributes are: -
    CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK: The maximum number of threads
    per block, beyond which a launch of the function would fail. This
    number depends on both the function and the device on which the
    function is currently loaded.    - CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES:
    The size in bytes of statically-allocated shared memory per block
    required by this function. This does not include dynamically-allocated
    shared memory requested by the user at runtime.    -
    CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES: The size in bytes of user-allocated
    constant memory required by this function.    -
    CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES: The size in bytes of local memory
    used by each thread of this function.    - CU_FUNC_ATTRIBUTE_NUM_REGS:
    The number of registers used by each thread of this function.    -
    CU_FUNC_ATTRIBUTE_PTX_VERSION: The PTX virtual architecture version for
    which the function was compiled. This value is the major PTX version *
    10    - the minor PTX version, so a PTX version 1.3 function would
    return the value 13. Note that this may return the undefined value of 0
    for cubins compiled prior to CUDA 3.0.     -
    CU_FUNC_ATTRIBUTE_BINARY_VERSION: The binary architecture version for
    which the function was compiled. This value is the major binary version
    * 10 + the minor binary version, so a binary version 1.3 function would
    return the value 13. Note that this will return a value of 10 for
    legacy cubins that do not have a properly-encoded binary architecture
    version.    - CU_FUNC_CACHE_MODE_CA: The attribute to indicate whether
    the function has been compiled with user specified option "-Xptxas
    --dlcm=ca" set .    - CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES:
    The maximum size in bytes of dynamically-allocated shared memory.    -
    CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT: Preferred shared
    memory-L1 cache split ratio in percent of total shared memory.

    Parameters
    ----------
    attrib : CUfunction_attribute
        Attribute requested
    hfunc : Any
        Function to query attribute of

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    pi : int
        Returned attribute value

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuFuncSetCacheConfig
    cuLaunchKernel
    cudaFuncGetAttributes
    cudaFuncSetAttribute
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    cdef int pi = 0
    cdef ccuda.CUfunction_attribute cattrib = attrib.value
    err = ccuda.cuFuncGetAttribute(&pi, cattrib, chfunc)
    return (CUresult(err), pi)

@cython.embedsignature(True)
def cuFuncSetAttribute(hfunc, attrib not None : CUfunction_attribute, int value):
    """ Sets information about a function.

    This call sets the value of a specified attribute `attrib` on the
    kernel given by `hfunc` to an integer value specified by `val` This
    function returns CUDA_SUCCESS if the new value of the attribute could
    be successfully set. If the set fails, this call will return an error.
    Not all attributes can have values set. Attempting to set a value on a
    read-only attribute will result in an error (CUDA_ERROR_INVALID_VALUE)

    Supported attributes for the cuFuncSetAttribute call are: -
    CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES: This maximum size in
    bytes of dynamically-allocated shared memory. The value should contain
    the requested maximum size of dynamically-allocated shared memory. The
    sum of this value and the function attribute
    CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES cannot exceed the device attribute
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_BLOCK_OPTIN. The maximal size
    of requestable dynamic shared memory may differ by GPU architecture.
    - CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT: On devices where
    the L1 cache and shared memory use the same hardware resources, this
    sets the shared memory carveout preference, in percent of the total
    shared memory. See
    CU_DEVICE_ATTRIBUTE_MAX_SHARED_MEMORY_PER_MULTIPROCESSOR This is only a
    hint, and the driver can choose a different ratio if required to
    execute the function.

    Parameters
    ----------
    hfunc : Any
        Function to query attribute of
    attrib : CUfunction_attribute
        Attribute requested
    value : int
        The value to set

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuFuncSetCacheConfig
    cuLaunchKernel
    cudaFuncGetAttributes
    cudaFuncSetAttribute
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    cdef ccuda.CUfunction_attribute cattrib = attrib.value
    err = ccuda.cuFuncSetAttribute(chfunc, cattrib, value)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuFuncSetCacheConfig(hfunc, config not None : CUfunc_cache):
    """ Sets the preferred cache configuration for a device function.

    On devices where the L1 cache and shared memory use the same hardware
    resources, this sets through `config` the preferred cache configuration
    for the device function `hfunc`. This is only a preference. The driver
    will use the requested configuration if possible, but it is free to
    choose a different configuration if required to execute `hfunc`. Any
    context-wide preference set via cuCtxSetCacheConfig() will be
    overridden by this per-function setting unless the per-function setting
    is CU_FUNC_CACHE_PREFER_NONE. In that case, the current context-wide
    setting will be used.

    This setting does nothing on devices where the size of the L1 cache and
    shared memory are fixed.

    Launching a kernel with a different preference than the most recent
    preference setting may insert a device-side synchronization point.

    The supported cache configurations are: - CU_FUNC_CACHE_PREFER_NONE: no
    preference for shared memory or L1 (default)    -
    CU_FUNC_CACHE_PREFER_SHARED: prefer larger shared memory and smaller L1
    cache    - CU_FUNC_CACHE_PREFER_L1: prefer larger L1 cache and smaller
    shared memory    - CU_FUNC_CACHE_PREFER_EQUAL: prefer equal sized L1
    cache and shared memory

    Parameters
    ----------
    hfunc : Any
        Kernel to configure cache for
    config : CUfunc_cache
        Requested cache configuration

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuFuncGetAttribute
    cuLaunchKernel
    cudaFuncSetCacheConfig
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    cdef ccuda.CUfunc_cache cconfig = config.value
    err = ccuda.cuFuncSetCacheConfig(chfunc, cconfig)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuFuncSetSharedMemConfig(hfunc, config not None : CUsharedconfig):
    """ Sets the shared memory configuration for a device function.

    On devices with configurable shared memory banks, this function will
    force all subsequent launches of the specified device function to have
    the given shared memory bank size configuration. On any given launch of
    the function, the shared memory configuration of the device will be
    temporarily changed if needed to suit the function's preferred
    configuration. Changes in shared memory configuration between
    subsequent launches of functions, may introduce a device side
    synchronization point.

    Any per-function setting of shared memory bank size set via
    cuFuncSetSharedMemConfig will override the context wide setting set
    with cuCtxSetSharedMemConfig.

    Changing the shared memory bank size will not increase shared memory
    usage or affect occupancy of kernels, but may have major effects on
    performance. Larger bank sizes will allow for greater potential
    bandwidth to shared memory, but will change what kinds of accesses to
    shared memory will result in bank conflicts.

    This function will do nothing on devices with fixed shared memory bank
    size.

    The supported bank configurations are: -
    CU_SHARED_MEM_CONFIG_DEFAULT_BANK_SIZE: use the context's shared memory
    configuration when launching this function.    -
    CU_SHARED_MEM_CONFIG_FOUR_BYTE_BANK_SIZE: set shared memory bank width
    to be natively four bytes when launching this function.    -
    CU_SHARED_MEM_CONFIG_EIGHT_BYTE_BANK_SIZE: set shared memory bank width
    to be natively eight bytes when launching this function.

    Parameters
    ----------
    hfunc : Any
        kernel to be given a shared memory config
    config : CUsharedconfig
        requested shared memory configuration

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
    None
        None

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuCtxGetSharedMemConfig
    cuCtxSetSharedMemConfig
    cuFuncGetAttribute
    cuLaunchKernel
    cudaFuncSetSharedMemConfig
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    cdef ccuda.CUsharedconfig cconfig = config.value
    err = ccuda.cuFuncSetSharedMemConfig(chfunc, cconfig)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuFuncGetModule(hfunc):
    """ Returns a module handle.

    Returns in `*hmod` the handle of the module that function `hfunc` is
    located in. The lifetime of the module corresponds to the lifetime of
    the context it was loaded in or until the module is explicitly
    unloaded.

    The CUDA runtime manages its own modules loaded into the primary
    context. If the handle returned by this API refers to a module loaded
    by the CUDA runtime, calling cuModuleUnload() on that module will
    result in undefined behavior.

    Parameters
    ----------
    hfunc : Any
        Function to retrieve module for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_NOT_FOUND
    hmod : CUmodule
        Returned module handle
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    cdef CUmodule hmod = CUmodule()
    err = ccuda.cuFuncGetModule(hmod._ptr, chfunc)
    return (CUresult(err), hmod)

@cython.embedsignature(True)
def cuLaunchKernel(f, unsigned int gridDimX, unsigned int gridDimY, unsigned int gridDimZ, unsigned int blockDimX, unsigned int blockDimY, unsigned int blockDimZ, unsigned int sharedMemBytes, hStream, kernelParams, void_ptr extra):
    """ Launches a CUDA function.

    Invokes the kernel `f` on a `gridDimX` x `gridDimY` x `gridDimZ` grid
    of blocks. Each block contains `blockDimX` x `blockDimY` x `blockDimZ`
    threads.

    `sharedMemBytes` sets the amount of dynamic shared memory that will be
    available to each thread block.

    Kernel parameters to `f` can be specified in one of two ways:

    1) Kernel parameters can be specified via `kernelParams`. If `f` has N
    parameters, then `kernelParams` needs to be an array of N pointers.
    Each of `kernelParams`[0] through `kernelParams`[N-1] must point to a
    region of memory from which the actual kernel parameter will be copied.
    The number of kernel parameters and their offsets and sizes do not need
    to be specified as that information is retrieved directly from the
    kernel's image.

    2) Kernel parameters can also be packaged by the application into a
    single buffer that is passed in via the `extra` parameter. This places
    the burden on the application of knowing each kernel parameter's size
    and alignment/padding within the buffer. Here is an example of using
    the `extra` parameter in this manner: size_targBufferSize;
    charargBuffer[256];  //populateargBufferandargBufferSize
    void*config[]={ CU_LAUNCH_PARAM_BUFFER_POINTER,argBuffer,
    CU_LAUNCH_PARAM_BUFFER_SIZE,&argBufferSize, CU_LAUNCH_PARAM_END };
    status=cuLaunchKernel(f,gx,gy,gz,bx,by,bz,sh,s,NULL,config);

    The `extra` parameter exists to allow cuLaunchKernel to take additional
    less commonly used arguments. `extra` specifies a list of names of
    extra settings and their corresponding values. Each extra setting name
    is immediately followed by the corresponding value. The list must be
    terminated with either NULL or CU_LAUNCH_PARAM_END.

    - CU_LAUNCH_PARAM_END, which indicates the end of the `extra` array;
    - CU_LAUNCH_PARAM_BUFFER_POINTER, which specifies that the next value
    in `extra` will be a pointer to a buffer containing all the kernel
    parameters for launching kernel `f`;    - CU_LAUNCH_PARAM_BUFFER_SIZE,
    which specifies that the next value in `extra` will be a pointer to a
    size_t containing the size of the buffer specified with
    CU_LAUNCH_PARAM_BUFFER_POINTER;

    The error CUDA_ERROR_INVALID_VALUE will be returned if kernel
    parameters are specified with both `kernelParams` and `extra` (i.e.
    both `kernelParams` and `extra` are non-NULL).

    Calling cuLaunchKernel() invalidates the persistent function state set
    through the following deprecated APIs: cuFuncSetBlockShape(),
    cuFuncSetSharedSize(), cuParamSetSize(), cuParamSeti(), cuParamSetf(),
    cuParamSetv().

    Note that to use cuLaunchKernel(), the kernel `f` must either have been
    compiled with toolchain version 3.2 or later so that it will contain
    kernel parameter information, or have no kernel parameters. If either
    of these conditions is not met, then cuLaunchKernel() will return
    CUDA_ERROR_INVALID_IMAGE.

    Parameters
    ----------
    f : Any
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier
    kernelParams : Any
        Array of pointers to kernel parameters
    extra : void_ptr
        Extra options

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_IMAGE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_LAUNCH_FAILED
        CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
        CUDA_ERROR_LAUNCH_TIMEOUT
        CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    None
        None

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuFuncSetCacheConfig
    cuFuncGetAttribute
    cudaLaunchKernel
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUfunction cf
    if f is None:
        cf = <ccuda.CUfunction><void_ptr>0
    elif isinstance(f, (CUfunction)):
        pf = int(f)
        cf = <ccuda.CUfunction><void_ptr>pf
    else:
        pf = int(CUfunction(f))
        cf = <ccuda.CUfunction><void_ptr>pf

    ckernelParams = utils.HelperKernelParams(kernelParams)
    err = ccuda.cuLaunchKernel(cf, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, chStream, <void**><void_ptr>ckernelParams.ckernelParams, <void**>extra)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLaunchCooperativeKernel(f, unsigned int gridDimX, unsigned int gridDimY, unsigned int gridDimZ, unsigned int blockDimX, unsigned int blockDimY, unsigned int blockDimZ, unsigned int sharedMemBytes, hStream, kernelParams):
    """ Launches a CUDA function where thread blocks can cooperate and synchronize as they execute.

    Invokes the kernel `f` on a `gridDimX` x `gridDimY` x `gridDimZ` grid
    of blocks. Each block contains `blockDimX` x `blockDimY` x `blockDimZ`
    threads.

    `sharedMemBytes` sets the amount of dynamic shared memory that will be
    available to each thread block.

    The device on which this kernel is invoked must have a non-zero value
    for the device attribute CU_DEVICE_ATTRIBUTE_COOPERATIVE_LAUNCH.

    The total number of blocks launched cannot exceed the maximum number of
    blocks per multiprocessor as returned by
    cuOccupancyMaxActiveBlocksPerMultiprocessor (or
    cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags) times the number
    of multiprocessors as specified by the device attribute
    CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT.

    The kernel cannot make use of CUDA dynamic parallelism.

    Kernel parameters must be specified via `kernelParams`. If `f` has N
    parameters, then `kernelParams` needs to be an array of N pointers.
    Each of `kernelParams`[0] through `kernelParams`[N-1] must point to a
    region of memory from which the actual kernel parameter will be copied.
    The number of kernel parameters and their offsets and sizes do not need
    to be specified as that information is retrieved directly from the
    kernel's image.

    Calling cuLaunchCooperativeKernel() sets persistent function state that
    is the same as function state set through cuLaunchKernel API

    When the kernel `f` is launched via cuLaunchCooperativeKernel(), the
    previous block shape, shared size and parameter info associated with
    `f` is overwritten.

    Note that to use cuLaunchCooperativeKernel(), the kernel `f` must
    either have been compiled with toolchain version 3.2 or later so that
    it will contain kernel parameter information, or have no kernel
    parameters. If either of these conditions is not met, then
    cuLaunchCooperativeKernel() will return CUDA_ERROR_INVALID_IMAGE.

    Parameters
    ----------
    f : Any
        Kernel to launch
    gridDimX : unsigned int
        Width of grid in blocks
    gridDimY : unsigned int
        Height of grid in blocks
    gridDimZ : unsigned int
        Depth of grid in blocks
    blockDimX : unsigned int
        X dimension of each thread block
    blockDimY : unsigned int
        Y dimension of each thread block
    blockDimZ : unsigned int
        Z dimension of each thread block
    sharedMemBytes : unsigned int
        Dynamic shared-memory size per thread block in bytes
    hStream : CUstream or cudaStream_t
        Stream identifier
    kernelParams : Any
        Array of pointers to kernel parameters

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_IMAGE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_LAUNCH_FAILED
        CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
        CUDA_ERROR_LAUNCH_TIMEOUT
        CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
        CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    None
        None

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuFuncSetCacheConfig
    cuFuncGetAttribute
    cuLaunchCooperativeKernelMultiDevice
    cudaLaunchCooperativeKernel
    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUfunction cf
    if f is None:
        cf = <ccuda.CUfunction><void_ptr>0
    elif isinstance(f, (CUfunction)):
        pf = int(f)
        cf = <ccuda.CUfunction><void_ptr>pf
    else:
        pf = int(CUfunction(f))
        cf = <ccuda.CUfunction><void_ptr>pf

    ckernelParams = utils.HelperKernelParams(kernelParams)
    err = ccuda.cuLaunchCooperativeKernel(cf, gridDimX, gridDimY, gridDimZ, blockDimX, blockDimY, blockDimZ, sharedMemBytes, chStream, <void**><void_ptr>ckernelParams.ckernelParams)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLaunchCooperativeKernelMultiDevice(launchParamsList : List[CUDA_LAUNCH_PARAMS], unsigned int numDevices, unsigned int flags):
    """ Launches CUDA functions on multiple devices where thread blocks can cooperate and synchronize as they execute.

    DeprecatedThis function is deprecated as of CUDA 11.3.

    Invokes kernels as specified in the `launchParamsList` array where each
    element of the array specifies all the parameters required to perform a
    single kernel launch. These kernels can cooperate and synchronize as
    they execute. The size of the array is specified by `numDevices`.

    No two kernels can be launched on the same device. All the devices
    targeted by this multi-device launch must be identical. All devices
    must have a non-zero value for the device attribute
    CU_DEVICE_ATTRIBUTE_COOPERATIVE_MULTI_DEVICE_LAUNCH.

    All kernels launched must be identical with respect to the compiled
    code. Note that any device, constant or managed variables present in
    the module that owns the kernel launched on each device, are
    independently instantiated on every device. It is the application's
    responsiblity to ensure these variables are initialized and used
    appropriately.

    The size of the grids as specified in blocks, the size of the blocks
    themselves and the amount of shared memory used by each thread block
    must also match across all launched kernels.

    The streams used to launch these kernels must have been created via
    either cuStreamCreate or cuStreamCreateWithPriority. The NULL stream or
    CU_STREAM_LEGACY or CU_STREAM_PER_THREAD cannot be used.

    The total number of blocks launched per kernel cannot exceed the
    maximum number of blocks per multiprocessor as returned by
    cuOccupancyMaxActiveBlocksPerMultiprocessor (or
    cuOccupancyMaxActiveBlocksPerMultiprocessorWithFlags) times the number
    of multiprocessors as specified by the device attribute
    CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT. Since the total number of
    blocks launched per device has to match across all devices, the maximum
    number of blocks that can be launched per device will be limited by the
    device with the least number of multiprocessors.

    The kernels cannot make use of CUDA dynamic parallelism.

    The CUDA_LAUNCH_PARAMS structure is defined as:
    typedefstructCUDA_LAUNCH_PARAMS_st { CUfunctionfunction;
    unsignedintgridDimX; unsignedintgridDimY; unsignedintgridDimZ;
    unsignedintblockDimX; unsignedintblockDimY; unsignedintblockDimZ;
    unsignedintsharedMemBytes; CUstreamhStream; void**kernelParams;
    }CUDA_LAUNCH_PARAMS; where: - CUDA_LAUNCH_PARAMS::function specifies
    the kernel to be launched. All functions must be identical with respect
    to the compiled code.    - CUDA_LAUNCH_PARAMS::gridDimX is the width of
    the grid in blocks. This must match across all kernels launched.    -
    CUDA_LAUNCH_PARAMS::gridDimY is the height of the grid in blocks. This
    must match across all kernels launched.    -
    CUDA_LAUNCH_PARAMS::gridDimZ is the depth of the grid in blocks. This
    must match across all kernels launched.    -
    CUDA_LAUNCH_PARAMS::blockDimX is the X dimension of each thread block.
    This must match across all kernels launched.    -
    CUDA_LAUNCH_PARAMS::blockDimX is the Y dimension of each thread block.
    This must match across all kernels launched.    -
    CUDA_LAUNCH_PARAMS::blockDimZ is the Z dimension of each thread block.
    This must match across all kernels launched.    -
    CUDA_LAUNCH_PARAMS::sharedMemBytes is the dynamic shared-memory size
    per thread block in bytes. This must match across all kernels launched.
    - CUDA_LAUNCH_PARAMS::hStream is the handle to the stream to perform
    the launch in. This cannot be the NULL stream or CU_STREAM_LEGACY or
    CU_STREAM_PER_THREAD. The CUDA context associated with this stream must
    match that associated with CUDA_LAUNCH_PARAMS::function.    -
    CUDA_LAUNCH_PARAMS::kernelParams is an array of pointers to kernel
    parameters. If CUDA_LAUNCH_PARAMS::function has N parameters, then
    CUDA_LAUNCH_PARAMS::kernelParams needs to be an array of N pointers.
    Each of CUDA_LAUNCH_PARAMS::kernelParams[0] through
    CUDA_LAUNCH_PARAMS::kernelParams[N-1] must point to a region of memory
    from which the actual kernel parameter will be copied. The number of
    kernel parameters and their offsets and sizes do not need to be
    specified as that information is retrieved directly from the kernel's
    image.

    By default, the kernel won't begin execution on any GPU until all prior
    work in all the specified streams has completed. This behavior can be
    overridden by specifying the flag
    CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_PRE_LAUNCH_SYNC. When this flag
    is specified, each kernel will only wait for prior work in the stream
    corresponding to that GPU to complete before it begins execution.

    Similarly, by default, any subsequent work pushed in any of the
    specified streams will not begin execution until the kernels on all
    GPUs have completed. This behavior can be overridden by specifying the
    flag CUDA_COOPERATIVE_LAUNCH_MULTI_DEVICE_NO_POST_LAUNCH_SYNC. When
    this flag is specified, any subsequent work pushed in any of the
    specified streams will only wait for the kernel launched on the GPU
    corresponding to that stream to complete before it begins execution.

    Calling cuLaunchCooperativeKernelMultiDevice() sets persistent function
    state that is the same as function state set through cuLaunchKernel API
    when called individually for each element in `launchParamsList`.

    When kernels are launched via cuLaunchCooperativeKernelMultiDevice(),
    the previous block shape, shared size and parameter info associated
    with each CUDA_LAUNCH_PARAMS::function in `launchParamsList` is
    overwritten.

    Note that to use cuLaunchCooperativeKernelMultiDevice(), the kernels
    must either have been compiled with toolchain version 3.2 or later so
    that it will contain kernel parameter information, or have no kernel
    parameters. If either of these conditions is not met, then
    cuLaunchCooperativeKernelMultiDevice() will return
    CUDA_ERROR_INVALID_IMAGE.

    Parameters
    ----------
    launchParamsList : List[CUDA_LAUNCH_PARAMS]
        List of launch parameters, one per device
    numDevices : unsigned int
        Size of the `launchParamsList` array
    flags : unsigned int
        Flags to control launch behavior

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_IMAGE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_LAUNCH_FAILED
        CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
        CUDA_ERROR_LAUNCH_TIMEOUT
        CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
        CUDA_ERROR_COOPERATIVE_LAUNCH_TOO_LARGE
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    None
        None

    See Also
    --------
    cuCtxGetCacheConfig
    cuCtxSetCacheConfig
    cuFuncSetCacheConfig
    cuFuncGetAttribute
    cuLaunchCooperativeKernel
    cudaLaunchCooperativeKernelMultiDevice
    """
    launchParamsList = [] if launchParamsList is None else launchParamsList
    if not all(isinstance(_x, (CUDA_LAUNCH_PARAMS)) for _x in launchParamsList):
        raise TypeError("Argument 'launchParamsList' is not instance of type (expected List[ccuda.CUDA_LAUNCH_PARAMS]")

    cdef ccuda.CUDA_LAUNCH_PARAMS* claunchParamsList = NULL
    if len(launchParamsList) > 0:
        claunchParamsList = <ccuda.CUDA_LAUNCH_PARAMS*> calloc(len(launchParamsList), sizeof(ccuda.CUDA_LAUNCH_PARAMS))
        if claunchParamsList is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(launchParamsList)) + 'x' + str(sizeof(ccuda.CUDA_LAUNCH_PARAMS)))
        for idx in range(len(launchParamsList)):
            memcpy(&claunchParamsList[idx], (<CUDA_LAUNCH_PARAMS>launchParamsList[idx])._ptr, sizeof(ccuda.CUDA_LAUNCH_PARAMS))

    if numDevices > len(launchParamsList): raise RuntimeError("List is too small: " + str(len(launchParamsList)) + " < " + str(numDevices))
    err = ccuda.cuLaunchCooperativeKernelMultiDevice((<CUDA_LAUNCH_PARAMS>launchParamsList[0])._ptr if len(launchParamsList) == 1 else claunchParamsList, numDevices, flags)
    if claunchParamsList is not NULL:
        free(claunchParamsList)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLaunchHostFunc(hStream, fn, userData):
    """ Enqueues a host function call in a stream.

    Enqueues a host function to run in a stream. The function will be
    called after currently enqueued work and will block work added after
    it.

    The host function must not make any CUDA API calls. Attempting to use a
    CUDA API may result in CUDA_ERROR_NOT_PERMITTED, but this is not
    required. The host function must not perform any synchronization that
    may depend on outstanding CUDA work not mandated to run earlier. Host
    functions without a mandated order (such as in independent streams)
    execute in undefined order and may be serialized.

    For the purposes of Unified Memory, execution makes a number of
    guarantees:  -  The stream is considered idle for the duration of the
    function's execution. Thus, for example, the function may always use
    memory attached to the stream it was enqueued in.      -  The start of
    execution of the function has the same effect as synchronizing an event
    recorded in the same stream immediately prior to the function. It thus
    synchronizes streams which have been "joined" prior to the function.
    -  Adding device work to any stream does not have the effect of making
    the stream active until all preceding host functions and stream
    callbacks have executed. Thus, for example, a function might use global
    attached memory even if work has been added to another stream, if the
    work has been ordered behind the function call with an event.      -
    Completion of the function does not cause a stream to become active
    except as described above. The stream will remain idle if no device
    work follows the function, and will remain idle across consecutive host
    functions or stream callbacks without device work in between. Thus, for
    example, stream synchronization can be done by signaling from a host
    function at the end of the stream.

    Note that, in contrast to cuStreamAddCallback, the function will not be
    called in the event of an error in the CUDA context.

    Parameters
    ----------
    hStream : CUstream or cudaStream_t
        Stream to enqueue function call in
    fn : Any
        The function to call once preceding stream operations are complete
    userData : Any
        User-specified data to be passed to the function

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_NOT_SUPPORTED
    None
        None

    See Also
    --------
    cuStreamCreate
    cuStreamQuery
    cuStreamSynchronize
    cuStreamWaitEvent
    cuStreamDestroy
    cuMemAllocManaged
    cuStreamAttachMemAsync
    cuStreamAddCallback
    """
    cdef ccuda.CUhostFn cfn
    if fn is None:
        cfn = <ccuda.CUhostFn><void_ptr>0
    elif isinstance(fn, (CUhostFn)):
        pfn = int(fn)
        cfn = <ccuda.CUhostFn><void_ptr>pfn
    else:
        pfn = int(CUhostFn(fn))
        cfn = <ccuda.CUhostFn><void_ptr>pfn

    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cuserData = utils.HelperInputVoidPtr(userData)
    cdef void* cuserData_ptr = <void*><void_ptr>cuserData.cptr
    err = ccuda.cuLaunchHostFunc(chStream, cfn, cuserData_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuFuncSetBlockShape(hfunc, int x, int y, int z):
    """ Sets the block-dimensions for the function.

    Deprecated

    Specifies the `x`, `y`, and `z` dimensions of the thread blocks that
    are created when the kernel given by `hfunc` is launched.

    Parameters
    ----------
    hfunc : Any
        Kernel to specify dimensions of
    x : int
        X dimension
    y : int
        Y dimension
    z : int
        Z dimension

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuFuncSetSharedSize
    cuFuncSetCacheConfig
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSeti
    cuParamSetf
    cuParamSetv
    cuLaunch
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    err = ccuda.cuFuncSetBlockShape(chfunc, x, y, z)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuFuncSetSharedSize(hfunc, unsigned int numbytes):
    """ Sets the dynamic shared-memory size for the function.

    Deprecated

    Sets through `numbytes` the amount of dynamic shared memory that will
    be available to each thread block when the kernel given by `hfunc` is
    launched.

    Parameters
    ----------
    hfunc : Any
        Kernel to specify dynamic shared-memory size for
    numbytes : unsigned int
        Dynamic shared-memory size per thread in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetCacheConfig
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSeti
    cuParamSetf
    cuParamSetv
    cuLaunch
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    err = ccuda.cuFuncSetSharedSize(chfunc, numbytes)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuParamSetSize(hfunc, unsigned int numbytes):
    """ Sets the parameter size for the function.

    Deprecated

    Sets through `numbytes` the total size in bytes needed by the function
    parameters of the kernel corresponding to `hfunc`.

    Parameters
    ----------
    hfunc : Any
        Kernel to set parameter size for
    numbytes : unsigned int
        Size of parameter list in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetf
    cuParamSeti
    cuParamSetv
    cuLaunch
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    err = ccuda.cuParamSetSize(chfunc, numbytes)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuParamSeti(hfunc, int offset, unsigned int value):
    """ Adds an integer parameter to the function's argument list.

    Deprecated

    Sets an integer parameter that will be specified the next time the
    kernel corresponding to `hfunc` will be invoked. `offset` is a byte
    offset.

    Parameters
    ----------
    hfunc : Any
        Kernel to add parameter to
    offset : int
        Offset to add parameter to argument list
    value : unsigned int
        Value of parameter

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSetf
    cuParamSetv
    cuLaunch
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    err = ccuda.cuParamSeti(chfunc, offset, value)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuParamSetf(hfunc, int offset, float value):
    """ Adds a floating-point parameter to the function's argument list.

    Deprecated

    Sets a floating-point parameter that will be specified the next time
    the kernel corresponding to `hfunc` will be invoked. `offset` is a byte
    offset.

    Parameters
    ----------
    hfunc : Any
        Kernel to add parameter to
    offset : int
        Offset to add parameter to argument list
    value : float
        Value of parameter

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSeti
    cuParamSetv
    cuLaunch
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    err = ccuda.cuParamSetf(chfunc, offset, value)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuParamSetv(hfunc, int offset, ptr, unsigned int numbytes):
    """ Adds arbitrary data to the function's argument list.

    Deprecated

    Copies an arbitrary amount of data (specified in `numbytes`) from `ptr`
    into the parameter space of the kernel corresponding to `hfunc`.
    `offset` is a byte offset.

    Parameters
    ----------
    hfunc : Any
        Kernel to add data to
    offset : int
        Offset to add data to argument list
    ptr : Any
        Pointer to arbitrary data
    numbytes : unsigned int
        Size of data to copy in bytes

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSetf
    cuParamSeti
    cuLaunch
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    cptr = utils.HelperInputVoidPtr(ptr)
    cdef void* cptr_ptr = <void*><void_ptr>cptr.cptr
    err = ccuda.cuParamSetv(chfunc, offset, cptr_ptr, numbytes)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLaunch(f):
    """ Launches a CUDA function.

    Deprecated

    Invokes the kernel `f` on a 1 x 1 x 1 grid of blocks. The block
    contains the number of threads specified by a previous call to
    cuFuncSetBlockShape().

    The block shape, dynamic shared memory size, and parameter information
    must be set using cuFuncSetBlockShape(), cuFuncSetSharedSize(),
    cuParamSetSize(), cuParamSeti(), cuParamSetf(), and cuParamSetv() prior
    to calling this function.

    Launching a function via cuLaunchKernel() invalidates the function's
    block shape, dynamic shared memory size, and parameter information.
    After launching via cuLaunchKernel, this state must be re-initialized
    prior to calling this function. Failure to do so results in undefined
    behavior.

    Parameters
    ----------
    f : Any
        Kernel to launch

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_LAUNCH_FAILED
        CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
        CUDA_ERROR_LAUNCH_TIMEOUT
        CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSetf
    cuParamSeti
    cuParamSetv
    cuLaunchGrid
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction cf
    if f is None:
        cf = <ccuda.CUfunction><void_ptr>0
    elif isinstance(f, (CUfunction)):
        pf = int(f)
        cf = <ccuda.CUfunction><void_ptr>pf
    else:
        pf = int(CUfunction(f))
        cf = <ccuda.CUfunction><void_ptr>pf

    err = ccuda.cuLaunch(cf)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLaunchGrid(f, int grid_width, int grid_height):
    """ Launches a CUDA function.

    Deprecated

    Invokes the kernel `f` on a `grid_width` x `grid_height` grid of
    blocks. Each block contains the number of threads specified by a
    previous call to cuFuncSetBlockShape().

    The block shape, dynamic shared memory size, and parameter information
    must be set using cuFuncSetBlockShape(), cuFuncSetSharedSize(),
    cuParamSetSize(), cuParamSeti(), cuParamSetf(), and cuParamSetv() prior
    to calling this function.

    Launching a function via cuLaunchKernel() invalidates the function's
    block shape, dynamic shared memory size, and parameter information.
    After launching via cuLaunchKernel, this state must be re-initialized
    prior to calling this function. Failure to do so results in undefined
    behavior.

    Parameters
    ----------
    f : Any
        Kernel to launch
    grid_width : int
        Width of grid in blocks
    grid_height : int
        Height of grid in blocks

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_LAUNCH_FAILED
        CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
        CUDA_ERROR_LAUNCH_TIMEOUT
        CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSetf
    cuParamSeti
    cuParamSetv
    cuLaunch
    cuLaunchGridAsync
    cuLaunchKernel
    """
    cdef ccuda.CUfunction cf
    if f is None:
        cf = <ccuda.CUfunction><void_ptr>0
    elif isinstance(f, (CUfunction)):
        pf = int(f)
        cf = <ccuda.CUfunction><void_ptr>pf
    else:
        pf = int(CUfunction(f))
        cf = <ccuda.CUfunction><void_ptr>pf

    err = ccuda.cuLaunchGrid(cf, grid_width, grid_height)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuLaunchGridAsync(f, int grid_width, int grid_height, hStream):
    """ Launches a CUDA function.

    Deprecated

    Invokes the kernel `f` on a `grid_width` x `grid_height` grid of
    blocks. Each block contains the number of threads specified by a
    previous call to cuFuncSetBlockShape().

    The block shape, dynamic shared memory size, and parameter information
    must be set using cuFuncSetBlockShape(), cuFuncSetSharedSize(),
    cuParamSetSize(), cuParamSeti(), cuParamSetf(), and cuParamSetv() prior
    to calling this function.

    Launching a function via cuLaunchKernel() invalidates the function's
    block shape, dynamic shared memory size, and parameter information.
    After launching via cuLaunchKernel, this state must be re-initialized
    prior to calling this function. Failure to do so results in undefined
    behavior.

    Parameters
    ----------
    f : Any
        Kernel to launch
    grid_width : int
        Width of grid in blocks
    grid_height : int
        Height of grid in blocks
    hStream : CUstream or cudaStream_t
        Stream identifier

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_LAUNCH_FAILED
        CUDA_ERROR_LAUNCH_OUT_OF_RESOURCES
        CUDA_ERROR_LAUNCH_TIMEOUT
        CUDA_ERROR_LAUNCH_INCOMPATIBLE_TEXTURING
        CUDA_ERROR_SHARED_OBJECT_INIT_FAILED
    None
        None

    See Also
    --------
    cuFuncSetBlockShape
    cuFuncSetSharedSize
    cuFuncGetAttribute
    cuParamSetSize
    cuParamSetf
    cuParamSeti
    cuParamSetv
    cuLaunch
    cuLaunchGrid
    cuLaunchKernel

    Notes
    -----
    In certain cases where cubins are created with no ABI (i.e., using `ptxas` `--abi-compile` `no`), this function may serialize kernel launches. The CUDA driver retains asynchronous behavior by growing the per-thread stack as needed per launch and not shrinking it afterwards.

    """
    cdef ccuda.CUstream chStream
    if hStream is None:
        chStream = <ccuda.CUstream><void_ptr>0
    elif isinstance(hStream, (CUstream)):
        phStream = int(hStream)
        chStream = <ccuda.CUstream><void_ptr>phStream
    else:
        phStream = int(CUstream(hStream))
        chStream = <ccuda.CUstream><void_ptr>phStream

    cdef ccuda.CUfunction cf
    if f is None:
        cf = <ccuda.CUfunction><void_ptr>0
    elif isinstance(f, (CUfunction)):
        pf = int(f)
        cf = <ccuda.CUfunction><void_ptr>pf
    else:
        pf = int(CUfunction(f))
        cf = <ccuda.CUfunction><void_ptr>pf

    err = ccuda.cuLaunchGridAsync(cf, grid_width, grid_height, chStream)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuParamSetTexRef(hfunc, int texunit, hTexRef):
    """ Adds a texture-reference to the function's argument list.

    Deprecated

    Makes the CUDA array or linear memory bound to the texture reference
    `hTexRef` available to a device program as a texture. In this version
    of CUDA, the texture-reference must be obtained via cuModuleGetTexRef()
    and the `texunit` parameter must be set to CU_PARAM_TR_DEFAULT.

    Parameters
    ----------
    hfunc : Any
        Kernel to add texture-reference to
    texunit : int
        Texture unit (must be CU_PARAM_TR_DEFAULT)
    hTexRef : Any
        Texture-reference to add to argument list

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_CONTEXT
        CUDA_ERROR_INVALID_VALUE
    None
        None
    """
    cdef ccuda.CUtexref chTexRef
    if hTexRef is None:
        chTexRef = <ccuda.CUtexref><void_ptr>0
    elif isinstance(hTexRef, (CUtexref)):
        phTexRef = int(hTexRef)
        chTexRef = <ccuda.CUtexref><void_ptr>phTexRef
    else:
        phTexRef = int(CUtexref(hTexRef))
        chTexRef = <ccuda.CUtexref><void_ptr>phTexRef

    cdef ccuda.CUfunction chfunc
    if hfunc is None:
        chfunc = <ccuda.CUfunction><void_ptr>0
    elif isinstance(hfunc, (CUfunction)):
        phfunc = int(hfunc)
        chfunc = <ccuda.CUfunction><void_ptr>phfunc
    else:
        phfunc = int(CUfunction(hfunc))
        chfunc = <ccuda.CUfunction><void_ptr>phfunc

    err = ccuda.cuParamSetTexRef(chfunc, texunit, chTexRef)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphCreate(unsigned int flags):
    """ Creates a graph.

    Creates an empty graph, which is returned via `phGraph`.

    Parameters
    ----------
    flags : unsigned int
        Graph creation flags, must be 0

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    phGraph : CUgraph
        Returns newly created graph

    See Also
    --------
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddHostNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    cuGraphInstantiate
    cuGraphDestroy
    cuGraphGetNodes
    cuGraphGetRootNodes
    cuGraphGetEdges
    cuGraphClone
    """
    cdef CUgraph phGraph = CUgraph()
    err = ccuda.cuGraphCreate(phGraph._ptr, flags)
    return (CUresult(err), phGraph)

@cython.embedsignature(True)
def cuGraphAddKernelNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, nodeParams : CUDA_KERNEL_NODE_PARAMS):
    """ Creates a kernel execution node and adds it to a graph.

    Creates a new kernel execution node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and
    arguments specified in `nodeParams`. It is possible for
    `numDependencies` to be 0, in which case the node will be placed at the
    root of the graph. `dependencies` may not have any duplicate entries. A
    handle to the new node will be returned in `phGraphNode`.

    The CUDA_KERNEL_NODE_PARAMS structure is defined as:

    typedefstructCUDA_KERNEL_NODE_PARAMS_st{ CUfunctionfunc;
    unsignedintgridDimX; unsignedintgridDimY; unsignedintgridDimZ;
    unsignedintblockDimX; unsignedintblockDimY; unsignedintblockDimZ;
    unsignedintsharedMemBytes; void**kernelParams; void**extra;
    }CUDA_KERNEL_NODE_PARAMS;

    When the graph is launched, the node will invoke kernel `func` on a
    (`gridDimX` x `gridDimY` x `gridDimZ`) grid of blocks. Each block
    contains (`blockDimX` x `blockDimY` x `blockDimZ`) threads.

    `sharedMemBytes` sets the amount of dynamic shared memory that will be
    available to each thread block.

    Kernel parameters to `func` can be specified in one of two ways:

    1) Kernel parameters can be specified via `kernelParams`. If the kernel
    has N parameters, then `kernelParams` needs to be an array of N
    pointers. Each pointer, from `kernelParams`[0] to `kernelParams`[N-1],
    points to the region of memory from which the actual parameter will be
    copied. The number of kernel parameters and their offsets and sizes do
    not need to be specified as that information is retrieved directly from
    the kernel's image.

    2) Kernel parameters for non-cooperative kernels can also be packaged
    by the application into a single buffer that is passed in via `extra`.
    This places the burden on the application of knowing each kernel
    parameter's size and alignment/padding within the buffer. The `extra`
    parameter exists to allow this function to take additional less
    commonly used arguments. `extra` specifies a list of names of extra
    settings and their corresponding values. Each extra setting name is
    immediately followed by the corresponding value. The list must be
    terminated with either NULL or CU_LAUNCH_PARAM_END.

    - CU_LAUNCH_PARAM_END, which indicates the end of the `extra` array;
    - CU_LAUNCH_PARAM_BUFFER_POINTER, which specifies that the next value
    in `extra` will be a pointer to a buffer containing all the kernel
    parameters for launching kernel `func`;    -
    CU_LAUNCH_PARAM_BUFFER_SIZE, which specifies that the next value in
    `extra` will be a pointer to a size_t containing the size of the buffer
    specified with CU_LAUNCH_PARAM_BUFFER_POINTER;

    The error CUDA_ERROR_INVALID_VALUE will be returned if kernel
    parameters are specified with both `kernelParams` and `extra` (i.e.
    both `kernelParams` and `extra` are non-NULL). CUDA_ERROR_INVALID_VALUE
    will be returned if `extra` is used for a cooperative kernel.

    The `kernelParams` or `extra` array, as well as the argument values it
    points to, are copied during this call.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    nodeParams : CUDA_KERNEL_NODE_PARAMS
        Parameters for the GPU execution node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuLaunchKernel
    cuLaunchCooperativeKernel
    cuGraphKernelNodeGetParams
    cuGraphKernelNodeSetParams
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddHostNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode

    Notes
    -----
    Kernels launched using graphs must not use texture and surface references. Reading or writing through any texture or surface reference is undefined behavior. This restriction does not apply to texture and surface objects.

    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_KERNEL_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphAddKernelNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cnodeParams_ptr)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphKernelNodeGetParams(hNode):
    """ Returns a kernel node's parameters.

    Returns the parameters of kernel node `hNode` in `nodeParams`. The
    `kernelParams` or `extra` array returned in `nodeParams`, as well as
    the argument values it points to, are owned by the node. This memory
    remains valid until the node is destroyed or its parameters are
    modified, and should not be modified directly. Use
    cuGraphKernelNodeSetParams to update the parameters of this node.

    The params will contain either `kernelParams` or `extra`, according to
    which of these was most recently set on the node.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    nodeParams : CUDA_KERNEL_NODE_PARAMS
        Pointer to return the parameters

    See Also
    --------
    cuLaunchKernel
    cuGraphAddKernelNode
    cuGraphKernelNodeSetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_KERNEL_NODE_PARAMS nodeParams = CUDA_KERNEL_NODE_PARAMS()
    err = ccuda.cuGraphKernelNodeGetParams(chNode, nodeParams._ptr)
    return (CUresult(err), nodeParams)

@cython.embedsignature(True)
def cuGraphKernelNodeSetParams(hNode, nodeParams : CUDA_KERNEL_NODE_PARAMS):
    """ Sets a kernel node's parameters.

    Sets the parameters of kernel node `hNode` to `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the parameters for
    nodeParams : CUDA_KERNEL_NODE_PARAMS
        Parameters to copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    None
        None

    See Also
    --------
    cuLaunchKernel
    cuGraphAddKernelNode
    cuGraphKernelNodeGetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUDA_KERNEL_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphKernelNodeSetParams(chNode, cnodeParams_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddMemcpyNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, copyParams : CUDA_MEMCPY3D, ctx):
    """ Creates a memcpy node and adds it to a graph.

    Creates a new memcpy node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies`. It is
    possible for `numDependencies` to be 0, in which case the node will be
    placed at the root of the graph. `dependencies` may not have any
    duplicate entries. A handle to the new node will be returned in
    `phGraphNode`.

    When the graph is launched, the node will perform the memcpy described
    by `copyParams`. See cuMemcpy3D() for a description of the structure
    and its restrictions.

    Memcpy nodes have some additional restrictions with regards to managed
    memory, if the system contains at least one device which has a zero
    value for the device attribute
    CU_DEVICE_ATTRIBUTE_CONCURRENT_MANAGED_ACCESS. If one or more of the
    operands refer to managed memory, then using the memory type
    CU_MEMORYTYPE_UNIFIED is disallowed for those operand(s). The managed
    memory will be treated as residing on either the host or the device,
    depending on which memory type is specified.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    copyParams : CUDA_MEMCPY3D
        Parameters for the memory copy
    ctx : Any
        Context on which to run the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuMemcpy3D
    cuGraphMemcpyNodeGetParams
    cuGraphMemcpyNodeSetParams
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddHostNode
    cuGraphAddMemsetNode
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_MEMCPY3D* ccopyParams_ptr = copyParams._ptr if copyParams != None else NULL
    err = ccuda.cuGraphAddMemcpyNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, ccopyParams_ptr, cctx)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphMemcpyNodeGetParams(hNode):
    """ Returns a memcpy node's parameters.

    Returns the parameters of memcpy node `hNode` in `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    nodeParams : CUDA_MEMCPY3D
        Pointer to return the parameters

    See Also
    --------
    cuMemcpy3D
    cuGraphAddMemcpyNode
    cuGraphMemcpyNodeSetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_MEMCPY3D nodeParams = CUDA_MEMCPY3D()
    err = ccuda.cuGraphMemcpyNodeGetParams(chNode, nodeParams._ptr)
    return (CUresult(err), nodeParams)

@cython.embedsignature(True)
def cuGraphMemcpyNodeSetParams(hNode, nodeParams : CUDA_MEMCPY3D):
    """ Sets a memcpy node's parameters.

    Sets the parameters of memcpy node `hNode` to `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the parameters for
    nodeParams : CUDA_MEMCPY3D
        Parameters to copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemcpy3D
    cuGraphAddMemcpyNode
    cuGraphMemcpyNodeGetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUDA_MEMCPY3D* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphMemcpyNodeSetParams(chNode, cnodeParams_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddMemsetNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, memsetParams : CUDA_MEMSET_NODE_PARAMS, ctx):
    """ Creates a memset node and adds it to a graph.

    Creates a new memset node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies`. It is
    possible for `numDependencies` to be 0, in which case the node will be
    placed at the root of the graph. `dependencies` may not have any
    duplicate entries. A handle to the new node will be returned in
    `phGraphNode`.

    The element size must be 1, 2, or 4 bytes. When the graph is launched,
    the node will perform the memset described by `memsetParams`.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    memsetParams : CUDA_MEMSET_NODE_PARAMS
        Parameters for the memory set
    ctx : Any
        Context on which to run the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_CONTEXT
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuMemsetD2D32
    cuGraphMemsetNodeGetParams
    cuGraphMemsetNodeSetParams
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddHostNode
    cuGraphAddMemcpyNode
    """
    cdef ccuda.CUcontext cctx
    if ctx is None:
        cctx = <ccuda.CUcontext><void_ptr>0
    elif isinstance(ctx, (CUcontext)):
        pctx = int(ctx)
        cctx = <ccuda.CUcontext><void_ptr>pctx
    else:
        pctx = int(CUcontext(ctx))
        cctx = <ccuda.CUcontext><void_ptr>pctx

    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_MEMSET_NODE_PARAMS* cmemsetParams_ptr = memsetParams._ptr if memsetParams != None else NULL
    err = ccuda.cuGraphAddMemsetNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cmemsetParams_ptr, cctx)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphMemsetNodeGetParams(hNode):
    """ Returns a memset node's parameters.

    Returns the parameters of memset node `hNode` in `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    nodeParams : CUDA_MEMSET_NODE_PARAMS
        Pointer to return the parameters

    See Also
    --------
    cuMemsetD2D32
    cuGraphAddMemsetNode
    cuGraphMemsetNodeSetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_MEMSET_NODE_PARAMS nodeParams = CUDA_MEMSET_NODE_PARAMS()
    err = ccuda.cuGraphMemsetNodeGetParams(chNode, nodeParams._ptr)
    return (CUresult(err), nodeParams)

@cython.embedsignature(True)
def cuGraphMemsetNodeSetParams(hNode, nodeParams : CUDA_MEMSET_NODE_PARAMS):
    """ Sets a memset node's parameters.

    Sets the parameters of memset node `hNode` to `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the parameters for
    nodeParams : CUDA_MEMSET_NODE_PARAMS
        Parameters to copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuMemsetD2D32
    cuGraphAddMemsetNode
    cuGraphMemsetNodeGetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUDA_MEMSET_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphMemsetNodeSetParams(chNode, cnodeParams_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddHostNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, nodeParams : CUDA_HOST_NODE_PARAMS):
    """ Creates a host execution node and adds it to a graph.

    Creates a new CPU execution node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and
    arguments specified in `nodeParams`. It is possible for
    `numDependencies` to be 0, in which case the node will be placed at the
    root of the graph. `dependencies` may not have any duplicate entries. A
    handle to the new node will be returned in `phGraphNode`.

    When the graph is launched, the node will invoke the specified CPU
    function. Host nodes are not supported under MPS with pre-Volta GPUs.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    nodeParams : CUDA_HOST_NODE_PARAMS
        Parameters for the host node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuLaunchHostFunc
    cuGraphHostNodeGetParams
    cuGraphHostNodeSetParams
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_HOST_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphAddHostNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cnodeParams_ptr)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphHostNodeGetParams(hNode):
    """ Returns a host node's parameters.

    Returns the parameters of host node `hNode` in `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    nodeParams : CUDA_HOST_NODE_PARAMS
        Pointer to return the parameters

    See Also
    --------
    cuLaunchHostFunc
    cuGraphAddHostNode
    cuGraphHostNodeSetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_HOST_NODE_PARAMS nodeParams = CUDA_HOST_NODE_PARAMS()
    err = ccuda.cuGraphHostNodeGetParams(chNode, nodeParams._ptr)
    return (CUresult(err), nodeParams)

@cython.embedsignature(True)
def cuGraphHostNodeSetParams(hNode, nodeParams : CUDA_HOST_NODE_PARAMS):
    """ Sets a host node's parameters.

    Sets the parameters of host node `hNode` to `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the parameters for
    nodeParams : CUDA_HOST_NODE_PARAMS
        Parameters to copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuLaunchHostFunc
    cuGraphAddHostNode
    cuGraphHostNodeGetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUDA_HOST_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphHostNodeSetParams(chNode, cnodeParams_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddChildGraphNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, childGraph):
    """ Creates a child graph node and adds it to a graph.

    Creates a new node which executes an embedded graph, and adds it to
    `hGraph` with `numDependencies` dependencies specified via
    `dependencies`. It is possible for `numDependencies` to be 0, in which
    case the node will be placed at the root of the graph. `dependencies`
    may not have any duplicate entries. A handle to the new node will be
    returned in `phGraphNode`.

    If `hGraph` contains allocation or free nodes, this call will return an
    error.

    The node executes an embedded child graph. The child graph is cloned in
    this call.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    childGraph : CUgraph or cudaGraph_t
        The graph to clone into this node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphChildGraphNodeGetGraph
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddHostNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    cuGraphClone
    """
    cdef ccuda.CUgraph cchildGraph
    if childGraph is None:
        cchildGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(childGraph, (CUgraph)):
        pchildGraph = int(childGraph)
        cchildGraph = <ccuda.CUgraph><void_ptr>pchildGraph
    else:
        pchildGraph = int(CUgraph(childGraph))
        cchildGraph = <ccuda.CUgraph><void_ptr>pchildGraph

    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    err = ccuda.cuGraphAddChildGraphNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cchildGraph)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphChildGraphNodeGetGraph(hNode):
    """ Gets a handle to the embedded graph of a child graph node.

    Gets a handle to the embedded graph in a child graph node. This call
    does not clone the graph. Changes to the graph will be reflected in the
    node, and the node retains ownership of the graph.

    Allocation and free nodes cannot be added to the returned graph.
    Attempting to do so will return an error.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the embedded graph for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    phGraph : CUgraph
        Location to store a handle to the graph

    See Also
    --------
    cuGraphAddChildGraphNode
    cuGraphNodeFindInClone
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUgraph phGraph = CUgraph()
    err = ccuda.cuGraphChildGraphNodeGetGraph(chNode, phGraph._ptr)
    return (CUresult(err), phGraph)

@cython.embedsignature(True)
def cuGraphAddEmptyNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies):
    """ Creates an empty node and adds it to a graph.

    Creates a new node which performs no operation, and adds it to `hGraph`
    with `numDependencies` dependencies specified via `dependencies`. It is
    possible for `numDependencies` to be 0, in which case the node will be
    placed at the root of the graph. `dependencies` may not have any
    duplicate entries. A handle to the new node will be returned in
    `phGraphNode`.

    An empty node performs no operation during execution, but can be used
    for transitive ordering. For example, a phased execution graph with 2
    groups of n nodes with a barrier between them can be represented using
    an empty node and 2*n dependency edges, rather than no empty node and
    n^2 dependency edges.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddKernelNode
    cuGraphAddHostNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    err = ccuda.cuGraphAddEmptyNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphAddEventRecordNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, event):
    """ Creates an event record node and adds it to a graph.

    Creates a new event record node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and event
    specified in `event`. It is possible for `numDependencies` to be 0, in
    which case the node will be placed at the root of the graph.
    `dependencies` may not have any duplicate entries. A handle to the new
    node will be returned in `phGraphNode`.

    Each launch of the graph will record `event` to capture execution of
    the node's dependencies.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    event : CUevent or cudaEvent_t
        Event for the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphAddEventWaitNode
    cuEventRecordWithFlags
    cuStreamWaitEvent
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    cdef ccuda.CUevent cevent
    if event is None:
        cevent = <ccuda.CUevent><void_ptr>0
    elif isinstance(event, (CUevent)):
        pevent = int(event)
        cevent = <ccuda.CUevent><void_ptr>pevent
    else:
        pevent = int(CUevent(event))
        cevent = <ccuda.CUevent><void_ptr>pevent

    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    err = ccuda.cuGraphAddEventRecordNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cevent)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphEventRecordNodeGetEvent(hNode):
    """ Returns the event associated with an event record node.

    Returns the event of event record node `hNode` in `event_out`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the event for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    event_out : CUevent
        Pointer to return the event

    See Also
    --------
    cuGraphAddEventRecordNode
    cuGraphEventRecordNodeSetEvent
    cuGraphEventWaitNodeGetEvent
    cuEventRecordWithFlags
    cuStreamWaitEvent
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUevent event_out = CUevent()
    err = ccuda.cuGraphEventRecordNodeGetEvent(chNode, event_out._ptr)
    return (CUresult(err), event_out)

@cython.embedsignature(True)
def cuGraphEventRecordNodeSetEvent(hNode, event):
    """ Sets an event record node's event.

    Sets the event of event record node `hNode` to `event`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the event for
    event : CUevent or cudaEvent_t
        Event to use

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    None
        None

    See Also
    --------
    cuGraphAddEventRecordNode
    cuGraphEventRecordNodeGetEvent
    cuGraphEventWaitNodeSetEvent
    cuEventRecordWithFlags
    cuStreamWaitEvent
    """
    cdef ccuda.CUevent cevent
    if event is None:
        cevent = <ccuda.CUevent><void_ptr>0
    elif isinstance(event, (CUevent)):
        pevent = int(event)
        cevent = <ccuda.CUevent><void_ptr>pevent
    else:
        pevent = int(CUevent(event))
        cevent = <ccuda.CUevent><void_ptr>pevent

    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    err = ccuda.cuGraphEventRecordNodeSetEvent(chNode, cevent)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddEventWaitNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, event):
    """ Creates an event wait node and adds it to a graph.

    Creates a new event wait node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and event
    specified in `event`. It is possible for `numDependencies` to be 0, in
    which case the node will be placed at the root of the graph.
    `dependencies` may not have any duplicate entries. A handle to the new
    node will be returned in `phGraphNode`.

    The graph node will wait for all work captured in `event`. See
    cuEventRecord() for details on what is captured by an event. `event`
    may be from a different context or device than the launch stream.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    event : CUevent or cudaEvent_t
        Event for the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphAddEventRecordNode
    cuEventRecordWithFlags
    cuStreamWaitEvent
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    cdef ccuda.CUevent cevent
    if event is None:
        cevent = <ccuda.CUevent><void_ptr>0
    elif isinstance(event, (CUevent)):
        pevent = int(event)
        cevent = <ccuda.CUevent><void_ptr>pevent
    else:
        pevent = int(CUevent(event))
        cevent = <ccuda.CUevent><void_ptr>pevent

    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    err = ccuda.cuGraphAddEventWaitNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cevent)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphEventWaitNodeGetEvent(hNode):
    """ Returns the event associated with an event wait node.

    Returns the event of event wait node `hNode` in `event_out`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the event for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    event_out : CUevent
        Pointer to return the event

    See Also
    --------
    cuGraphAddEventWaitNode
    cuGraphEventWaitNodeSetEvent
    cuGraphEventRecordNodeGetEvent
    cuEventRecordWithFlags
    cuStreamWaitEvent
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUevent event_out = CUevent()
    err = ccuda.cuGraphEventWaitNodeGetEvent(chNode, event_out._ptr)
    return (CUresult(err), event_out)

@cython.embedsignature(True)
def cuGraphEventWaitNodeSetEvent(hNode, event):
    """ Sets an event wait node's event.

    Sets the event of event wait node `hNode` to `event`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the event for
    event : CUevent or cudaEvent_t
        Event to use

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    None
        None

    See Also
    --------
    cuGraphAddEventWaitNode
    cuGraphEventWaitNodeGetEvent
    cuGraphEventRecordNodeSetEvent
    cuEventRecordWithFlags
    cuStreamWaitEvent
    """
    cdef ccuda.CUevent cevent
    if event is None:
        cevent = <ccuda.CUevent><void_ptr>0
    elif isinstance(event, (CUevent)):
        pevent = int(event)
        cevent = <ccuda.CUevent><void_ptr>pevent
    else:
        pevent = int(CUevent(event))
        cevent = <ccuda.CUevent><void_ptr>pevent

    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    err = ccuda.cuGraphEventWaitNodeSetEvent(chNode, cevent)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddExternalSemaphoresSignalNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, nodeParams : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS):
    """ Creates an external semaphore signal node and adds it to a graph.

    Creates a new external semaphore signal node and adds it to `hGraph`
    with `numDependencies` dependencies specified via `dependencies` and
    arguments specified in `nodeParams`. It is possible for
    `numDependencies` to be 0, in which case the node will be placed at the
    root of the graph. `dependencies` may not have any duplicate entries. A
    handle to the new node will be returned in `phGraphNode`.

    Performs a signal operation on a set of externally allocated semaphore
    objects when the node is launched. The operation(s) will occur after
    all of the node's dependencies have completed.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    nodeParams : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS
        Parameters for the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphExternalSemaphoresSignalNodeGetParams
    cuGraphExternalSemaphoresSignalNodeSetParams
    cuGraphExecExternalSemaphoresSignalNodeSetParams
    cuGraphAddExternalSemaphoresWaitNode
    cuImportExternalSemaphore
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddEventRecordNode
    cuGraphAddEventWaitNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphAddExternalSemaphoresSignalNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cnodeParams_ptr)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphExternalSemaphoresSignalNodeGetParams(hNode):
    """ Returns an external semaphore signal node's parameters.

    Returns the parameters of an external semaphore signal node `hNode` in
    `params_out`. The `extSemArray` and `paramsArray` returned in
    `params_out`, are owned by the node. This memory remains valid until
    the node is destroyed or its parameters are modified, and should not be
    modified directly. Use cuGraphExternalSemaphoresSignalNodeSetParams to
    update the parameters of this node.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    params_out : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS
        Pointer to return the parameters

    See Also
    --------
    cuLaunchKernel
    cuGraphAddExternalSemaphoresSignalNode
    cuGraphExternalSemaphoresSignalNodeSetParams
    cuGraphAddExternalSemaphoresWaitNode
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_EXT_SEM_SIGNAL_NODE_PARAMS params_out = CUDA_EXT_SEM_SIGNAL_NODE_PARAMS()
    err = ccuda.cuGraphExternalSemaphoresSignalNodeGetParams(chNode, params_out._ptr)
    return (CUresult(err), params_out)

@cython.embedsignature(True)
def cuGraphExternalSemaphoresSignalNodeSetParams(hNode, nodeParams : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS):
    """ Sets an external semaphore signal node's parameters.

    Sets the parameters of an external semaphore signal node `hNode` to
    `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the parameters for
    nodeParams : CUDA_EXT_SEM_SIGNAL_NODE_PARAMS
        Parameters to copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    None
        None

    See Also
    --------
    cuGraphAddExternalSemaphoresSignalNode
    cuGraphExternalSemaphoresSignalNodeSetParams
    cuGraphAddExternalSemaphoresWaitNode
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUDA_EXT_SEM_SIGNAL_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphExternalSemaphoresSignalNodeSetParams(chNode, cnodeParams_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddExternalSemaphoresWaitNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, nodeParams : CUDA_EXT_SEM_WAIT_NODE_PARAMS):
    """ Creates an external semaphore wait node and adds it to a graph.

    Creates a new external semaphore wait node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and
    arguments specified in `nodeParams`. It is possible for
    `numDependencies` to be 0, in which case the node will be placed at the
    root of the graph. `dependencies` may not have any duplicate entries. A
    handle to the new node will be returned in `phGraphNode`.

    Performs a wait operation on a set of externally allocated semaphore
    objects when the node is launched. The node's dependencies will not be
    launched until the wait operation has completed.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    nodeParams : CUDA_EXT_SEM_WAIT_NODE_PARAMS
        Parameters for the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphExternalSemaphoresWaitNodeGetParams
    cuGraphExternalSemaphoresWaitNodeSetParams
    cuGraphExecExternalSemaphoresWaitNodeSetParams
    cuGraphAddExternalSemaphoresSignalNode
    cuImportExternalSemaphore
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddEventRecordNode
    cuGraphAddEventWaitNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphAddExternalSemaphoresWaitNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cnodeParams_ptr)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphExternalSemaphoresWaitNodeGetParams(hNode):
    """ Returns an external semaphore wait node's parameters.

    Returns the parameters of an external semaphore wait node `hNode` in
    `params_out`. The `extSemArray` and `paramsArray` returned in
    `params_out`, are owned by the node. This memory remains valid until
    the node is destroyed or its parameters are modified, and should not be
    modified directly. Use cuGraphExternalSemaphoresSignalNodeSetParams to
    update the parameters of this node.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    params_out : CUDA_EXT_SEM_WAIT_NODE_PARAMS
        Pointer to return the parameters

    See Also
    --------
    cuLaunchKernel
    cuGraphAddExternalSemaphoresWaitNode
    cuGraphExternalSemaphoresWaitNodeSetParams
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_EXT_SEM_WAIT_NODE_PARAMS params_out = CUDA_EXT_SEM_WAIT_NODE_PARAMS()
    err = ccuda.cuGraphExternalSemaphoresWaitNodeGetParams(chNode, params_out._ptr)
    return (CUresult(err), params_out)

@cython.embedsignature(True)
def cuGraphExternalSemaphoresWaitNodeSetParams(hNode, nodeParams : CUDA_EXT_SEM_WAIT_NODE_PARAMS):
    """ Sets an external semaphore wait node's parameters.

    Sets the parameters of an external semaphore wait node `hNode` to
    `nodeParams`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to set the parameters for
    nodeParams : CUDA_EXT_SEM_WAIT_NODE_PARAMS
        Parameters to copy

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_INVALID_HANDLE
        CUDA_ERROR_OUT_OF_MEMORY
    None
        None

    See Also
    --------
    cuGraphAddExternalSemaphoresWaitNode
    cuGraphExternalSemaphoresWaitNodeSetParams
    cuSignalExternalSemaphoresAsync
    cuWaitExternalSemaphoresAsync
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUDA_EXT_SEM_WAIT_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphExternalSemaphoresWaitNodeSetParams(chNode, cnodeParams_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphAddMemAllocNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, nodeParams : CUDA_MEM_ALLOC_NODE_PARAMS):
    """ Creates an allocation node and adds it to a graph.

    Creates a new allocation node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and
    arguments specified in `nodeParams`. It is possible for
    `numDependencies` to be 0, in which case the node will be placed at the
    root of the graph. `dependencies` may not have any duplicate entries. A
    handle to the new node will be returned in `phGraphNode`.

    If the allocation is freed in the same graph, by creating a free node
    using cuGraphAddMemFreeNode, the allocation can be accessed by nodes
    ordered after the allocation node but before the free node. These
    allocations cannot be freed outside the owning graph, and they can only
    be freed once in the owning graph.

    If the allocation is not freed in the same graph, then it can be
    accessed not only by nodes in the graph which are ordered after the
    allocation node, but also by stream operations ordered after the
    graph's execution but before the allocation is freed.

    Allocations which are not freed in the same graph can be freed by: -
    passing the allocation to cuMemFreeAsync or cuMemFree;    - launching a
    graph with a free node for that allocation; or    - specifying
    CUDA_GRAPH_INSTANTIATE_FLAG_AUTO_FREE_ON_LAUNCH during instantiation,
    which makes each launch behave as though it called cuMemFreeAsync for
    every unfreed allocation.

    It is not possible to free an allocation in both the owning graph and
    another graph. If the allocation is freed in the same graph, a free
    node cannot be added to another graph. If the allocation is freed in
    another graph, a free node can no longer be added to the owning graph.

    The following restrictions apply to graphs which contain allocation
    and/or memory free nodes: - Nodes and edges of the graph cannot be
    deleted.    - The graph cannot be used in a child node.    - Only one
    instantiation of the graph may exist at any point in time.    - The
    graph cannot be cloned.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    nodeParams : CUDA_MEM_ALLOC_NODE_PARAMS
        Parameters for the node

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphAddMemFreeNode
    cuGraphMemAllocNodeGetParams
    cuDeviceGraphMemTrim
    cuDeviceGetGraphMemAttribute
    cuDeviceSetGraphMemAttribute
    cuMemAllocAsync
    cuMemFreeAsync
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddEventRecordNode
    cuGraphAddEventWaitNode
    cuGraphAddExternalSemaphoresSignalNode
    cuGraphAddExternalSemaphoresWaitNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    cdef ccuda.CUDA_MEM_ALLOC_NODE_PARAMS* cnodeParams_ptr = nodeParams._ptr if nodeParams != None else NULL
    err = ccuda.cuGraphAddMemAllocNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cnodeParams_ptr)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphMemAllocNodeGetParams(hNode):
    """ Returns a memory alloc node's parameters.

    Returns the parameters of a memory alloc node `hNode` in `params_out`.
    The `poolProps` and `accessDescs` returned in `params_out`, are owned
    by the node. This memory remains valid until the node is destroyed. The
    returned parameters must not be modified.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    params_out : CUDA_MEM_ALLOC_NODE_PARAMS
        Pointer to return the parameters

    See Also
    --------
    cuGraphAddMemAllocNode
    cuGraphMemFreeNodeGetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUDA_MEM_ALLOC_NODE_PARAMS params_out = CUDA_MEM_ALLOC_NODE_PARAMS()
    err = ccuda.cuGraphMemAllocNodeGetParams(chNode, params_out._ptr)
    return (CUresult(err), params_out)

@cython.embedsignature(True)
def cuGraphAddMemFreeNode(hGraph, dependencies : List[CUgraphNode], size_t numDependencies, dptr):
    """ Creates a memory free node and adds it to a graph.

    Creates a new memory free node and adds it to `hGraph` with
    `numDependencies` dependencies specified via `dependencies` and
    arguments specified in `nodeParams`. It is possible for
    `numDependencies` to be 0, in which case the node will be placed at the
    root of the graph. `dependencies` may not have any duplicate entries. A
    handle to the new node will be returned in `phGraphNode`.

    The following restrictions apply to graphs which contain allocation
    and/or memory free nodes: - Nodes and edges of the graph cannot be
    deleted.    - The graph cannot be used in a child node.    - Only one
    instantiation of the graph may exist at any point in time.    - The
    graph cannot be cloned.

    Parameters
    ----------
    hGraph : Any
        Graph to which to add the node
    dependencies : List[CUgraphNode]
        Dependencies of the node
    numDependencies : size_t
        Number of dependencies
    dptr : Any
        Address of memory to free

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_NOT_SUPPORTED
        CUDA_ERROR_INVALID_VALUE
    phGraphNode : CUgraphNode
        Returns newly created node

    See Also
    --------
    cuGraphAddMemAllocNode
    cuGraphMemFreeNodeGetParams
    cuDeviceGraphMemTrim
    cuDeviceGetGraphMemAttribute
    cuDeviceSetGraphMemAttribute
    cuMemAllocAsync
    cuMemFreeAsync
    cuGraphCreate
    cuGraphDestroyNode
    cuGraphAddChildGraphNode
    cuGraphAddEmptyNode
    cuGraphAddEventRecordNode
    cuGraphAddEventWaitNode
    cuGraphAddExternalSemaphoresSignalNode
    cuGraphAddExternalSemaphoresWaitNode
    cuGraphAddKernelNode
    cuGraphAddMemcpyNode
    cuGraphAddMemsetNode
    """
    cdef ccuda.CUdeviceptr cdptr
    if dptr is None:
        cdptr = <ccuda.CUdeviceptr><void_ptr>0
    elif isinstance(dptr, (CUdeviceptr)):
        pdptr = int(dptr)
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr
    else:
        pdptr = int(CUdeviceptr(dptr))
        cdptr = <ccuda.CUdeviceptr><void_ptr>pdptr

    dependencies = [] if dependencies is None else dependencies
    if not all(isinstance(_x, (CUgraphNode)) for _x in dependencies):
        raise TypeError("Argument 'dependencies' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef CUgraphNode phGraphNode = CUgraphNode()
    cdef ccuda.CUgraphNode* cdependencies = NULL
    if len(dependencies) > 0:
        cdependencies = <ccuda.CUgraphNode*> calloc(len(dependencies), sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(dependencies)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(dependencies)):
                cdependencies[idx] = (<CUgraphNode>dependencies[idx])._ptr[0]

    if numDependencies > <size_t>len(dependencies): raise RuntimeError("List is too small: " + str(len(dependencies)) + " < " + str(numDependencies))
    err = ccuda.cuGraphAddMemFreeNode(phGraphNode._ptr, chGraph, (<CUgraphNode>dependencies[0])._ptr if len(dependencies) == 1 else cdependencies, numDependencies, cdptr)
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), phGraphNode)

@cython.embedsignature(True)
def cuGraphMemFreeNodeGetParams(hNode):
    """ Returns a memory free node's parameters.

    Returns the address of a memory free node `hNode` in `dptr_out`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to get the parameters for

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    dptr_out : CUdeviceptr
        Pointer to return the device address

    See Also
    --------
    cuGraphAddMemFreeNode
    cuGraphMemAllocNodeGetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef CUdeviceptr dptr_out = CUdeviceptr()
    err = ccuda.cuGraphMemFreeNodeGetParams(chNode, dptr_out._ptr)
    return (CUresult(err), dptr_out)

@cython.embedsignature(True)
def cuDeviceGraphMemTrim(device):
    """ Free unused memory that was cached on the specified device for use with graphs back to the OS.

    Blocks which are not in use by a graph that is either currently
    executing or scheduled to execute are freed back to the operating
    system.

    Parameters
    ----------
    device : Any
        The device for which cached memory should be freed.

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_DEVICE
    None
        None

    See Also
    --------
    cuGraphAddMemAllocNode
    cuGraphAddMemFreeNode
    cuDeviceSetGraphMemAttribute
    cuDeviceGetGraphMemAttribute
    """
    cdef ccuda.CUdevice cdevice
    if device is None:
        cdevice = <ccuda.CUdevice>0
    elif isinstance(device, (CUdevice)):
        pdevice = int(device)
        cdevice = <ccuda.CUdevice>pdevice
    else:
        pdevice = int(CUdevice(device))
        cdevice = <ccuda.CUdevice>pdevice

    err = ccuda.cuDeviceGraphMemTrim(cdevice)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuDeviceGetGraphMemAttribute(device, attr not None : CUgraphMem_attribute):
    """ Query asynchronous allocation attributes related to graphs.

    Valid attributes are:

    - CU_GRAPH_MEM_ATTR_USED_MEM_CURRENT: Amount of memory, in bytes,
    currently associated with graphs    - CU_GRAPH_MEM_ATTR_USED_MEM_HIGH:
    High watermark of memory, in bytes, associated with graphs since the
    last time it was reset. High watermark can only be reset to zero.    -
    CU_GRAPH_MEM_ATTR_RESERVED_MEM_CURRENT: Amount of memory, in bytes,
    currently allocated for use by the CUDA graphs asynchronous allocator.
    - CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH: High watermark of memory, in
    bytes, currently allocated for use by the CUDA graphs asynchronous
    allocator.

    Parameters
    ----------
    device : Any
        Specifies the scope of the query
    attr : CUgraphMem_attribute
        attribute to get

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_DEVICE
    value : Any
        retrieved value

    See Also
    --------
    cuDeviceSetGraphMemAttribute
    cuGraphAddMemAllocNode
    cuGraphAddMemFreeNode
    """
    cdef ccuda.CUdevice cdevice
    if device is None:
        cdevice = <ccuda.CUdevice>0
    elif isinstance(device, (CUdevice)):
        pdevice = int(device)
        cdevice = <ccuda.CUdevice>pdevice
    else:
        pdevice = int(CUdevice(device))
        cdevice = <ccuda.CUdevice>pdevice

    cdef ccuda.CUgraphMem_attribute cattr = attr.value
    cdef utils.HelperCUgraphMem_attribute cvalue = utils.HelperCUgraphMem_attribute(attr, 0, is_getter=True)
    cdef void* cvalue_ptr = <void*><void_ptr>cvalue.cptr
    err = ccuda.cuDeviceGetGraphMemAttribute(cdevice, cattr, cvalue_ptr)
    return (CUresult(err), cvalue.pyObj())

@cython.embedsignature(True)
def cuDeviceSetGraphMemAttribute(device, attr not None : CUgraphMem_attribute, value):
    """ Set asynchronous allocation attributes related to graphs.

    Valid attributes are:

    - CU_GRAPH_MEM_ATTR_USED_MEM_HIGH: High watermark of memory, in bytes,
    associated with graphs since the last time it was reset. High watermark
    can only be reset to zero.    - CU_GRAPH_MEM_ATTR_RESERVED_MEM_HIGH:
    High watermark of memory, in bytes, currently allocated for use by the
    CUDA graphs asynchronous allocator.

    Parameters
    ----------
    device : Any
        Specifies the scope of the query
    attr : CUgraphMem_attribute
        attribute to get
    value : Any
        pointer to value to set

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_DEVICE
    None
        None

    See Also
    --------
    cuDeviceGetGraphMemAttribute
    cuGraphAddMemAllocNode
    cuGraphAddMemFreeNode
    """
    cdef ccuda.CUdevice cdevice
    if device is None:
        cdevice = <ccuda.CUdevice>0
    elif isinstance(device, (CUdevice)):
        pdevice = int(device)
        cdevice = <ccuda.CUdevice>pdevice
    else:
        pdevice = int(CUdevice(device))
        cdevice = <ccuda.CUdevice>pdevice

    cdef ccuda.CUgraphMem_attribute cattr = attr.value
    cdef utils.HelperCUgraphMem_attribute cvalue = utils.HelperCUgraphMem_attribute(attr, value, is_getter=False)
    cdef void* cvalue_ptr = <void*><void_ptr>cvalue.cptr
    err = ccuda.cuDeviceSetGraphMemAttribute(cdevice, cattr, cvalue_ptr)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphClone(originalGraph):
    """ Clones a graph.

    This function creates a copy of `originalGraph` and returns it in
    `phGraphClone`. All parameters are copied into the cloned graph. The
    original graph may be modified after this call without affecting the
    clone.

    Child graph nodes in the original graph are recursively copied into the
    clone.

    Parameters
    ----------
    originalGraph : CUgraph or cudaGraph_t
        Graph to clone

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
        CUDA_ERROR_OUT_OF_MEMORY
    phGraphClone : CUgraph
        Returns newly created cloned graph

    See Also
    --------
    cuGraphCreate
    cuGraphNodeFindInClone
    """
    cdef ccuda.CUgraph coriginalGraph
    if originalGraph is None:
        coriginalGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(originalGraph, (CUgraph)):
        poriginalGraph = int(originalGraph)
        coriginalGraph = <ccuda.CUgraph><void_ptr>poriginalGraph
    else:
        poriginalGraph = int(CUgraph(originalGraph))
        coriginalGraph = <ccuda.CUgraph><void_ptr>poriginalGraph

    cdef CUgraph phGraphClone = CUgraph()
    err = ccuda.cuGraphClone(phGraphClone._ptr, coriginalGraph)
    return (CUresult(err), phGraphClone)

@cython.embedsignature(True)
def cuGraphNodeFindInClone(hOriginalNode, hClonedGraph):
    """ Finds a cloned version of a node.

    This function returns the node in `hClonedGraph` corresponding to
    `hOriginalNode` in the original graph.

    `hClonedGraph` must have been cloned from `hOriginalGraph` via
    cuGraphClone. `hOriginalNode` must have been in `hOriginalGraph` at the
    time of the call to cuGraphClone, and the corresponding cloned node in
    `hClonedGraph` must not have been removed. The cloned node is then
    returned via `phClonedNode`.

    Parameters
    ----------
    hOriginalNode : Any
        Handle to the original node
    hClonedGraph : Any
        Cloned graph to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    phNode : CUgraphNode
        Returns handle to the cloned node

    See Also
    --------
    cuGraphClone
    """
    cdef ccuda.CUgraph chClonedGraph
    if hClonedGraph is None:
        chClonedGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hClonedGraph, (CUgraph)):
        phClonedGraph = int(hClonedGraph)
        chClonedGraph = <ccuda.CUgraph><void_ptr>phClonedGraph
    else:
        phClonedGraph = int(CUgraph(hClonedGraph))
        chClonedGraph = <ccuda.CUgraph><void_ptr>phClonedGraph

    cdef ccuda.CUgraphNode chOriginalNode
    if hOriginalNode is None:
        chOriginalNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hOriginalNode, (CUgraphNode)):
        phOriginalNode = int(hOriginalNode)
        chOriginalNode = <ccuda.CUgraphNode><void_ptr>phOriginalNode
    else:
        phOriginalNode = int(CUgraphNode(hOriginalNode))
        chOriginalNode = <ccuda.CUgraphNode><void_ptr>phOriginalNode

    cdef CUgraphNode phNode = CUgraphNode()
    err = ccuda.cuGraphNodeFindInClone(phNode._ptr, chOriginalNode, chClonedGraph)
    return (CUresult(err), phNode)

@cython.embedsignature(True)
def cuGraphNodeGetType(hNode):
    """ Returns a node's type.

    Returns the node type of `hNode` in `typename`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    typename : CUgraphNodeType
        Pointer to return the node type

    See Also
    --------
    cuGraphGetNodes
    cuGraphGetRootNodes
    cuGraphChildGraphNodeGetGraph
    cuGraphKernelNodeGetParams
    cuGraphKernelNodeSetParams
    cuGraphHostNodeGetParams
    cuGraphHostNodeSetParams
    cuGraphMemcpyNodeGetParams
    cuGraphMemcpyNodeSetParams
    cuGraphMemsetNodeGetParams
    cuGraphMemsetNodeSetParams
    """
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUgraphNodeType typename
    err = ccuda.cuGraphNodeGetType(chNode, &typename)
    return (CUresult(err), CUgraphNodeType(typename))

@cython.embedsignature(True)
def cuGraphGetNodes(hGraph, size_t numNodes = 0):
    """ Returns a graph's nodes.

    Returns a list of `hGraph's` nodes. `nodes` may be NULL, in which case
    this function will return the number of nodes in `numNodes`. Otherwise,
    `numNodes` entries will be filled in. If `numNodes` is higher than the
    actual number of nodes, the remaining entries in `nodes` will be set to
    NULL, and the number of nodes actually obtained will be returned in
    `numNodes`.

    Parameters
    ----------
    hGraph : Any
        Graph to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    nodes : List[CUgraphNode]
        Pointer to return the nodes
    numNodes : int
        See description

    See Also
    --------
    cuGraphCreate
    cuGraphGetRootNodes
    cuGraphGetEdges
    cuGraphNodeGetType
    cuGraphNodeGetDependencies
    cuGraphNodeGetDependentNodes
    """
    cdef size_t _graph_length = numNodes
    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef ccuda.CUgraphNode* cnodes = NULL
    pynodes = []
    if _graph_length != 0:
        cnodes = <ccuda.CUgraphNode*>calloc(_graph_length, sizeof(ccuda.CUgraphNode))
        if cnodes is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(_graph_length) + 'x' + str(sizeof(ccuda.CUgraphNode)))
    err = ccuda.cuGraphGetNodes(chGraph, cnodes, &numNodes)
    if CUresult(err) == CUresult(0):
        pynodes = [CUgraphNode(init_value=<void_ptr>cnodes[idx]) for idx in range(_graph_length)]
    if cnodes is not NULL:
        free(cnodes)
    return (CUresult(err), pynodes, numNodes)

@cython.embedsignature(True)
def cuGraphGetRootNodes(hGraph, size_t numRootNodes = 0):
    """ Returns a graph's root nodes.

    Returns a list of `hGraph's` root nodes. `rootNodes` may be NULL, in
    which case this function will return the number of root nodes in
    `numRootNodes`. Otherwise, `numRootNodes` entries will be filled in. If
    `numRootNodes` is higher than the actual number of root nodes, the
    remaining entries in `rootNodes` will be set to NULL, and the number of
    nodes actually obtained will be returned in `numRootNodes`.

    Parameters
    ----------
    hGraph : Any
        Graph to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    rootNodes : List[CUgraphNode]
        Pointer to return the root nodes
    numRootNodes : int
        See description

    See Also
    --------
    cuGraphCreate
    cuGraphGetNodes
    cuGraphGetEdges
    cuGraphNodeGetType
    cuGraphNodeGetDependencies
    cuGraphNodeGetDependentNodes
    """
    cdef size_t _graph_length = numRootNodes
    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef ccuda.CUgraphNode* crootNodes = NULL
    pyrootNodes = []
    if _graph_length != 0:
        crootNodes = <ccuda.CUgraphNode*>calloc(_graph_length, sizeof(ccuda.CUgraphNode))
        if crootNodes is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(_graph_length) + 'x' + str(sizeof(ccuda.CUgraphNode)))
    err = ccuda.cuGraphGetRootNodes(chGraph, crootNodes, &numRootNodes)
    if CUresult(err) == CUresult(0):
        pyrootNodes = [CUgraphNode(init_value=<void_ptr>crootNodes[idx]) for idx in range(_graph_length)]
    if crootNodes is not NULL:
        free(crootNodes)
    return (CUresult(err), pyrootNodes, numRootNodes)

@cython.embedsignature(True)
def cuGraphGetEdges(hGraph, size_t numEdges = 0):
    """ Returns a graph's dependency edges.

    Returns a list of `hGraph's` dependency edges. Edges are returned via
    corresponding indices in `from` and `to`; that is, the node in `to`[i]
    has a dependency on the node in `from`[i]. `from` and `to` may both be
    NULL, in which case this function only returns the number of edges in
    `numEdges`. Otherwise, `numEdges` entries will be filled in. If
    `numEdges` is higher than the actual number of edges, the remaining
    entries in `from` and `to` will be set to NULL, and the number of edges
    actually returned will be written to `numEdges`.

    Parameters
    ----------
    hGraph : Any
        Graph to get the edges from

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    from : List[CUgraphNode]
        Location to return edge endpoints
    to : List[CUgraphNode]
        Location to return edge endpoints
    numEdges : int
        See description

    See Also
    --------
    cuGraphGetNodes
    cuGraphGetRootNodes
    cuGraphAddDependencies
    cuGraphRemoveDependencies
    cuGraphNodeGetDependencies
    cuGraphNodeGetDependentNodes
    """
    cdef size_t _graph_length = numEdges
    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef ccuda.CUgraphNode* cfrom_ = NULL
    pyfrom_ = []
    if _graph_length != 0:
        cfrom_ = <ccuda.CUgraphNode*>calloc(_graph_length, sizeof(ccuda.CUgraphNode))
        if cfrom_ is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(_graph_length) + 'x' + str(sizeof(ccuda.CUgraphNode)))
    cdef ccuda.CUgraphNode* cto = NULL
    pyto = []
    if _graph_length != 0:
        cto = <ccuda.CUgraphNode*>calloc(_graph_length, sizeof(ccuda.CUgraphNode))
        if cto is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(_graph_length) + 'x' + str(sizeof(ccuda.CUgraphNode)))
    err = ccuda.cuGraphGetEdges(chGraph, cfrom_, cto, &numEdges)
    if CUresult(err) == CUresult(0):
        pyfrom_ = [CUgraphNode(init_value=<void_ptr>cfrom_[idx]) for idx in range(_graph_length)]
    if cfrom_ is not NULL:
        free(cfrom_)
    if CUresult(err) == CUresult(0):
        pyto = [CUgraphNode(init_value=<void_ptr>cto[idx]) for idx in range(_graph_length)]
    if cto is not NULL:
        free(cto)
    return (CUresult(err), pyfrom_, pyto, numEdges)

@cython.embedsignature(True)
def cuGraphNodeGetDependencies(hNode, size_t numDependencies = 0):
    """ Returns a node's dependencies.

    Returns a list of `node's` dependencies. `dependencies` may be NULL, in
    which case this function will return the number of dependencies in
    `numDependencies`. Otherwise, `numDependencies` entries will be filled
    in. If `numDependencies` is higher than the actual number of
    dependencies, the remaining entries in `dependencies` will be set to
    NULL, and the number of nodes actually obtained will be returned in
    `numDependencies`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    dependencies : List[CUgraphNode]
        Pointer to return the dependencies
    numDependencies : int
        See description

    See Also
    --------
    cuGraphNodeGetDependentNodes
    cuGraphGetNodes
    cuGraphGetRootNodes
    cuGraphGetEdges
    cuGraphAddDependencies
    cuGraphRemoveDependencies
    """
    cdef size_t _graph_length = numDependencies
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUgraphNode* cdependencies = NULL
    pydependencies = []
    if _graph_length != 0:
        cdependencies = <ccuda.CUgraphNode*>calloc(_graph_length, sizeof(ccuda.CUgraphNode))
        if cdependencies is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(_graph_length) + 'x' + str(sizeof(ccuda.CUgraphNode)))
    err = ccuda.cuGraphNodeGetDependencies(chNode, cdependencies, &numDependencies)
    if CUresult(err) == CUresult(0):
        pydependencies = [CUgraphNode(init_value=<void_ptr>cdependencies[idx]) for idx in range(_graph_length)]
    if cdependencies is not NULL:
        free(cdependencies)
    return (CUresult(err), pydependencies, numDependencies)

@cython.embedsignature(True)
def cuGraphNodeGetDependentNodes(hNode, size_t numDependentNodes = 0):
    """ Returns a node's dependent nodes.

    Returns a list of `node's` dependent nodes. `dependentNodes` may be
    NULL, in which case this function will return the number of dependent
    nodes in `numDependentNodes`. Otherwise, `numDependentNodes` entries
    will be filled in. If `numDependentNodes` is higher than the actual
    number of dependent nodes, the remaining entries in `dependentNodes`
    will be set to NULL, and the number of nodes actually obtained will be
    returned in `numDependentNodes`.

    Parameters
    ----------
    hNode : CUgraphNode or cudaGraphNode_t
        Node to query

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_DEINITIALIZED
        CUDA_ERROR_NOT_INITIALIZED
        CUDA_ERROR_INVALID_VALUE
    dependentNodes : List[CUgraphNode]
        Pointer to return the dependent nodes
    numDependentNodes : int
        See description

    See Also
    --------
    cuGraphNodeGetDependencies
    cuGraphGetNodes
    cuGraphGetRootNodes
    cuGraphGetEdges
    cuGraphAddDependencies
    cuGraphRemoveDependencies
    """
    cdef size_t _graph_length = numDependentNodes
    cdef ccuda.CUgraphNode chNode
    if hNode is None:
        chNode = <ccuda.CUgraphNode><void_ptr>0
    elif isinstance(hNode, (CUgraphNode)):
        phNode = int(hNode)
        chNode = <ccuda.CUgraphNode><void_ptr>phNode
    else:
        phNode = int(CUgraphNode(hNode))
        chNode = <ccuda.CUgraphNode><void_ptr>phNode

    cdef ccuda.CUgraphNode* cdependentNodes = NULL
    pydependentNodes = []
    if _graph_length != 0:
        cdependentNodes = <ccuda.CUgraphNode*>calloc(_graph_length, sizeof(ccuda.CUgraphNode))
        if cdependentNodes is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(_graph_length) + 'x' + str(sizeof(ccuda.CUgraphNode)))
    err = ccuda.cuGraphNodeGetDependentNodes(chNode, cdependentNodes, &numDependentNodes)
    if CUresult(err) == CUresult(0):
        pydependentNodes = [CUgraphNode(init_value=<void_ptr>cdependentNodes[idx]) for idx in range(_graph_length)]
    if cdependentNodes is not NULL:
        free(cdependentNodes)
    return (CUresult(err), pydependentNodes, numDependentNodes)

@cython.embedsignature(True)
def cuGraphAddDependencies(hGraph, from_ : List[CUgraphNode], to : List[CUgraphNode], size_t numDependencies):
    """ Adds dependency edges to a graph.

    The number of dependencies to be added is defined by `numDependencies`
    Elements in `from` and `to` at corresponding indices define a
    dependency. Each node in `from` and `to` must belong to `hGraph`.

    If `numDependencies` is 0, elements in `from` and `to` will be ignored.
    Specifying an existing dependency will return an error.

    Parameters
    ----------
    hGraph : Any
        Graph to which dependencies are added
    from_ : List[CUgraphNode]
        Array of nodes that provide the dependencies
    to : List[CUgraphNode]
        Array of dependent nodes
    numDependencies : size_t
        Number of dependencies to be added

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuGraphRemoveDependencies
    cuGraphGetEdges
    cuGraphNodeGetDependencies
    cuGraphNodeGetDependentNodes
    """
    to = [] if to is None else to
    if not all(isinstance(_x, (CUgraphNode)) for _x in to):
        raise TypeError("Argument 'to' is not instance of type (expected List[ccuda.CUgraphNode]")

    from_ = [] if from_ is None else from_
    if not all(isinstance(_x, (CUgraphNode)) for _x in from_):
        raise TypeError("Argument 'from_' is not instance of type (expected List[ccuda.CUgraphNode]")

    cdef ccuda.CUgraph chGraph
    if hGraph is None:
        chGraph = <ccuda.CUgraph><void_ptr>0
    elif isinstance(hGraph, (CUgraph)):
        phGraph = int(hGraph)
        chGraph = <ccuda.CUgraph><void_ptr>phGraph
    else:
        phGraph = int(CUgraph(hGraph))
        chGraph = <ccuda.CUgraph><void_ptr>phGraph

    cdef ccuda.CUgraphNode* cfrom_ = NULL
    if len(from_) > 0:
        cfrom_ = <ccuda.CUgraphNode*> calloc(len(from_), sizeof(ccuda.CUgraphNode))
        if cfrom_ is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(from_)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(from_)):
                cfrom_[idx] = (<CUgraphNode>from_[idx])._ptr[0]

    cdef ccuda.CUgraphNode* cto = NULL
    if len(to) > 0:
        cto = <ccuda.CUgraphNode*> calloc(len(to), sizeof(ccuda.CUgraphNode))
        if cto is NULL:
            raise MemoryError('Failed to allocate length x size memory: ' + str(len(to)) + 'x' + str(sizeof(ccuda.CUgraphNode)))
        else:
            for idx in range(len(to)):
                cto[idx] = (<CUgraphNode>to[idx])._ptr[0]

    err = ccuda.cuGraphAddDependencies(chGraph, (<CUgraphNode>from_[0])._ptr if len(from_) == 1 else cfrom_, (<CUgraphNode>to[0])._ptr if len(to) == 1 else cto, numDependencies)
    if cfrom_ is not NULL:
        free(cfrom_)
    if cto is not NULL:
        free(cto)
    return (CUresult(err),)

@cython.embedsignature(True)
def cuGraphRemoveDependencies(hGraph, from_ : List[CUgraphNode], to : List[CUgraphNode], size_t numDependencies):
    """ Removes dependency edges from a graph.

    The number of `dependencies` to be removed is defined by
    `numDependencies`. Elements in `from` and `to` at corresponding indices
    define a dependency. Each node in `from` and `to` must belong to
    `hGraph`.

    If `numDependencies` is 0, elements in `from` and `to` will be ignored.
    Specifying a non-existing dependency will return an error.

    Dependencies cannot be removed from graphs which contain allocation or
    free nodes. Any attempt to do so will return an error.

    Parameters
    ----------
    hGraph : Any
        Graph from which to remove dependencies
    from_ : List[CUgraphNode]
        Array of nodes that provide the dependencies
    to : List[CUgraphNode]
        Array of dependent nodes
    numDependencies : size_t
        Number of dependencies to be removed

    Returns
    -------
    CUresult
        CUDA_SUCCESS
        CUDA_ERROR_INVALID_VALUE
    None
        None

    See Also
    --------
    cuGraphAddDependencies
    cuGraphGetEdges
    cuGraphNodeGetDependencies
    cuGraphNodeGetDependentNodes
    """
    to = [] if to is None else to
    if not all(isinstance(_x, (CUgraphNode)) for _x in to):
        raise TypeError("Argument 'to' is not instance of type (expected List[ccuda.CUgraphNode]")

    from_ = [] if from_ is None else from_
    if not all