# cppzmq cmake module
# This module sets the following variables in your project::
#
# cppzmq_FOUND - true if cppzmq found on the system
# cppzmq_INCLUDE_DIR - the directory containing cppzmq headers
# cppzmq_LIBRARY - the ZeroMQ library for dynamic linking
# cppzmq_STATIC_LIBRARY - the ZeroMQ library for static linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was cppzmqConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(PN cppzmq)
set_and_check(${PN}_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(${PN}_LIBRARY "C:/bld/recipe_1485603693085/_b_env/Library/lib/libzmq-mt-4_2_1.lib")
set_and_check(${PN}_STATIC_LIBRARY "C:/bld/recipe_1485603693085/_b_env/Library/lib/libzmq-mt-s-4_2_1.lib")
check_required_components(${PN})
