# Copyright (c) Lawrence Livermore National Security, LLC and other Conduit
# Project developers. See top-level LICENSE AND COPYRIGHT files for dates and
# other details. No copyright assignment is required to contribute to Conduit.

###############################################################################
# file: conduit_config.mk
###############################################################################
#
# A CMake-generated Make include file Defines the following Make variables:
#
######
#  CONDUIT_INCLUDE_FLAGS
#  CONDUIT_LIB_FLAGS
#  CONDUIT_MPI_LIB_FLAGS
######
#
# For us in another Makefile build system
############################################################################

CONDUIT_DIR = D:\\bld\\conduit_1613502015053\\_h_env\\Library

CONDUIT_EXTRA_LIB_FLAGS = 

CONDUIT_USE_CXX11 = TRUE
CONDUIT_USE_FMT = TRUE

CONDUIT_SILO_DIR  = 
CONDUIT_ADIOS_DIR = 
CONDUIT_ZFP_DIR   = 

# hdf5 info, including tpls
CONDUIT_HDF5_DIR  = D:/bld/conduit_1613502015053/_h_env/Library
CONDUIT_HDF5_EXTRA_INCLUDE_FLAGS = 
CONDUIT_HDF5_EXTRA_LIB_FLAGS     =   -lD:/bld/conduit_1613502015053/_h_env/Library/lib/libcurl.libD:/bld/conduit_1613502015053/_h_env/Library/lib/libssl.libD:/bld/conduit_1613502015053/_h_env/Library/lib/libcrypto.lib

CONDUIT_LINK_RPATH = -Wl,-rpath,$(CONDUIT_DIR)/lib

# two steps are used b/c there are commas in the linker commands
# which will undermine parsing of the makefile
CONDUIT_SILO_RPATH_FLAGS_VALUE  = -Wl,-rpath,$(CONDUIT_SILO_DIR)/lib
CONDUIT_HDF5_RPATH_FLAGS_VALUE  = -Wl,-rpath,$(CONDUIT_HDF5_DIR)/lib
CONDUIT_ADIOS_RPATH_FLAGS_VALUE = -Wl,-rpath,$(CONDUIT_ADIOS_DIR)/lib
CONDUIT_ZFP_RPATH_FLAGS_VALUE   = -Wl,-rpath,$(CONDUIT_ZFP_DIR)/lib

CONDUIT_LINK_RPATH += $(if $(CONDUIT_SILO_DIR), $(CONDUIT_SILO_RPATH_FLAGS_VALUE))
CONDUIT_LINK_RPATH += $(if $(CONDUIT_HDF5_DIR), $(CONDUIT_HDF5_RPATH_FLAGS_VALUE))
CONDUIT_LINK_RPATH += $(if $(CONDUIT_ADIOS_DIR), $(CONDUIT_ADIOS_RPATH_FLAGS_VALUE))
CONDUIT_LINK_RPATH += $(if $(CONDUIT_ZFP_DIR), $(CONDUIT_ZFP_RPATH_FLAGS_VALUE))


#################
# Include Flags
#################
CONDUIT_INCLUDE_FLAGS  = -I $(CONDUIT_DIR)/include/conduit
CONDUIT_INCLUDE_FLAGS += -I $(CONDUIT_DIR)/include

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_ADIOS_DIR),-I$(CONDUIT_ADIOS_DIR)/include)

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_SILO_DIR),-I$(CONDUIT_SILO_DIR)/include)

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_HDF5_DIR),-I$(CONDUIT_HDF5_DIR)/include)
CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_HDF5_DIR),$(CONDUIT_HDF5_EXTRA_INCLUDE_FLAGS))

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_ZFP_DIR),-I$(CONDUIT_ZFP_DIR)/include)

#################
# Linking Flags
#################

###################################################
# ADIOS
#################
CONDUIT_ADIOS_LIB_FLAGS = $(if $(CONDUIT_ADIOS_DIR),)
CONDUIT_ADIOS_MPI_LIB_FLAGS = $(if $(CONDUIT_ADIOS_DIR),)


##########
# Silo
##########
CONDUIT_SILO_LIB_FLAGS = $(if $(CONDUIT_SILO_DIR),-L $(CONDUIT_SILO_DIR)/lib -lsiloh5)


##########
# HDF5
##########
CONDUIT_HDF5_LIB_FLAGS  = $(if $(CONDUIT_HDF5_DIR),-L $(CONDUIT_HDF5_DIR)/lib -lhdf5)
CONDUIT_HDF5_LIB_FLAGS += $(if $(CONDUIT_HDF5_DIR),$(CONDUIT_HDF5_EXTRA_LIB_FLAGS))

##########
# ZFP
##########
CONDUIT_ZFP_LIB_FLAGS  = $(if $(CONDUIT_ZFP_DIR),-L $(CONDUIT_ZFP_DIR)/lib -lzfp)


##########
# Conduit
##########
# All conduit libs, without MPI
CONDUIT_LIB_FLAGS = -L $(CONDUIT_DIR)/lib \
                    -lconduit_blueprint \
                    -lconduit_relay \
                    -lconduit $(CONDUIT_ADIOS_LIB_FLAGS) $(CONDUIT_SILO_LIB_FLAGS) $(CONDUIT_HDF5_LIB_FLAGS) $(CONDUIT_ZFP_LIB_FLAGS) $(CONDUIT_EXTRA_LIB_FLAGS)

# All conduit libs, with MPI
CONDUIT_MPI_LIB_FLAGS = -L $(CONDUIT_DIR)/lib \
                        -lconduit_relay_mpi_io \
                        -lconduit_relay_mpi \
                        -lconduit_blueprint_mpi \
                        -lconduit_blueprint \
                        -lconduit_relay \
                        -lconduit $(CONDUIT_ADIOS_MPI_LIB_FLAGS) $(CONDUIT_SILO_LIB_FLAGS) $(CONDUIT_HDF5_LIB_FLAGS) $(CONDUIT_ZFP_LIB_FLAGS) $(CONDUIT_EXTRA_LIB_FLAGS)

