###############################################################################
# Copyright (c) 2015-2019, Lawrence Livermore National Security, LLC.
#
# Produced at the Lawrence Livermore National Laboratory
#
# LLNL-CODE-666778
#
# All rights reserved.
#
# This file is part of Conduit.
#
# For details, see: http://software.llnl.gov/conduit/.
#
# Please also read conduit/LICENSE
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice,
#   this list of conditions and the disclaimer below.
#
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the disclaimer (as noted below) in the
#   documentation and/or other materials provided with the distribution.
#
# * Neither the name of the LLNS/LLNL nor the names of its contributors may
#   be used to endorse or promote products derived from this software without
#   specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL LAWRENCE LIVERMORE NATIONAL SECURITY,
# LLC, THE U.S. DEPARTMENT OF ENERGY OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
# IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
###############################################################################

###############################################################################
# file: conduit_config.mk
###############################################################################
#
# A CMake-generated Make include file Defines the following Make variables:
#
######
#  CONDUIT_INCLUDE_FLAGS
#  CONDUIT_LIB_FLAGS
#  CONDUIT_MPI_LIB_FLAGS
######
#
# For us in another Makefile build system
############################################################################

CONDUIT_DIR = D:\\bld\\conduit_1604152175025\\_h_env\\Library

CONDUIT_EXTRA_LIB_FLAGS = 

CONDUIT_SILO_DIR  = 
CONDUIT_ADIOS_DIR = 
CONDUIT_ZFP_DIR   = 

# hdf5 info, including tpls
CONDUIT_HDF5_DIR  = D:/bld/conduit_1604152175025/_h_env/Library
CONDUIT_HDF5_EXTRA_INCLUDE_FLAGS = 
CONDUIT_HDF5_EXTRA_LIB_FLAGS     =  

CONDUIT_LINK_RPATH = -Wl,-rpath,$(CONDUIT_DIR)/lib

# two steps are used b/c there are commas in the linker commands
# which will undermine parsing of the makefile
CONDUIT_SILO_RPATH_FLAGS_VALUE  = -Wl,-rpath,$(CONDUIT_SILO_DIR)/lib
CONDUIT_HDF5_RPATH_FLAGS_VALUE  = -Wl,-rpath,$(CONDUIT_HDF5_DIR)/lib
CONDUIT_ADIOS_RPATH_FLAGS_VALUE = -Wl,-rpath,$(CONDUIT_ADIOS_DIR)/lib
CONDUIT_ZFP_RPATH_FLAGS_VALUE   = -Wl,-rpath,$(CONDUIT_ZFP_DIR)/lib

CONDUIT_LINK_RPATH += $(if $(CONDUIT_SILO_DIR), $(CONDUIT_SILO_RPATH_FLAGS_VALUE))
CONDUIT_LINK_RPATH += $(if $(CONDUIT_HDF5_DIR), $(CONDUIT_HDF5_RPATH_FLAGS_VALUE))
CONDUIT_LINK_RPATH += $(if $(CONDUIT_ADIOS_DIR), $(CONDUIT_ADIOS_RPATH_FLAGS_VALUE))
CONDUIT_LINK_RPATH += $(if $(CONDUIT_ZFP_DIR), $(CONDUIT_ZFP_RPATH_FLAGS_VALUE))


#################
# Include Flags
#################
CONDUIT_INCLUDE_FLAGS  = -I $(CONDUIT_DIR)/include/conduit

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_ADIOS_DIR),-I$(CONDUIT_ADIOS_DIR)/include)

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_SILO_DIR),-I$(CONDUIT_SILO_DIR)/include)

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_HDF5_DIR),-I$(CONDUIT_HDF5_DIR)/include)
CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_HDF5_DIR),$(CONDUIT_HDF5_EXTRA_INCLUDE_FLAGS))

CONDUIT_INCLUDE_FLAGS += $(if $(CONDUIT_ZFP_DIR),-I$(CONDUIT_ZFP_DIR)/include)

#################
# Linking Flags
#################

###################################################
# ADIOS
#################
CONDUIT_ADIOS_LIB_FLAGS = $(if $(CONDUIT_ADIOS_DIR),)
CONDUIT_ADIOS_MPI_LIB_FLAGS = $(if $(CONDUIT_ADIOS_DIR),)


##########
# Silo
##########
CONDUIT_SILO_LIB_FLAGS = $(if $(CONDUIT_SILO_DIR),-L $(CONDUIT_SILO_DIR)/lib -lsiloh5)


##########
# HDF5
##########
CONDUIT_HDF5_LIB_FLAGS  = $(if $(CONDUIT_HDF5_DIR),-L $(CONDUIT_HDF5_DIR)/lib -lhdf5)
CONDUIT_HDF5_LIB_FLAGS += $(if $(CONDUIT_HDF5_DIR),$(CONDUIT_HDF5_EXTRA_LIB_FLAGS))

##########
# ZFP
##########
CONDUIT_ZFP_LIB_FLAGS  = $(if $(CONDUIT_ZFP_DIR),-L $(CONDUIT_ZFP_DIR)/lib -lzfp)


##########
# Conduit
##########
# All conduit libs, without MPI
CONDUIT_LIB_FLAGS = -L $(CONDUIT_DIR)/lib \
                    -lconduit_blueprint \
                    -lconduit_relay \
                    -lconduit $(CONDUIT_ADIOS_LIB_FLAGS) $(CONDUIT_SILO_LIB_FLAGS) $(CONDUIT_HDF5_LIB_FLAGS) $(CONDUIT_ZFP_LIB_FLAGS) $(CONDUIT_EXTRA_LIB_FLAGS)

# All conduit libs, with MPI
CONDUIT_MPI_LIB_FLAGS = -L $(CONDUIT_DIR)/lib \
                        -lconduit_relay_mpi_io \
                        -lconduit_relay_mpi \
                        -lconduit_blueprint \
                        -lconduit_relay \
                        -lconduit $(CONDUIT_ADIOS_MPI_LIB_FLAGS) $(CONDUIT_SILO_LIB_FLAGS) $(CONDUIT_HDF5_LIB_FLAGS) $(CONDUIT_ZFP_LIB_FLAGS) $(CONDUIT_EXTRA_LIB_FLAGS)

