conda config --add channels conda-forge
conda config --set show_channel_urls true
conda config --set add_pip_as_python_dependency false
conda config --add channels conda-forge
conda config --set show_channel_urls true
conda config --set add_pip_as_python_dependency false

if test `uname` = "Linux"
then
  # 2 cores are available on CircleCI workers: https://discuss.circleci.com/t/what-runs-on-the-node-container-by-default/1443
  # MAKEFLAGS is passed through conda build: https://github.com/conda/conda-build/pull/917
  export MAKEFLAGS="-j2 ${MAKEFLAGS}"
fi
package:
  name: conda-forge-build-setup
  version: 1.0.1

build:
  number: 0
  script:
    - IF NOT EXIST %LIBRARY_PREFIX%\etc\conda\activate.d MKDIR %LIBRARY_PREFIX%\etc\conda\activate.d  # [win]
    - COPY %RECIPE_DIR%/activate.bat %LIBRARY_PREFIX%\etc\conda\activate.d\conda-forge-build-setup_activate.bat  # [win]
    - mkdir -p "${PREFIX}/etc/conda/activate.d"  # [unix]
    - cp "${RECIPE_DIR}/activate.sh" "${PREFIX}/etc/conda/activate.d/conda-forge-build-setup_activate.sh"  # [unix]

requirements:
  run:
    - conda-build         # [linux]
    - conda-build 1.20.0  # [osx]
    - conda-build 1.20.0  # [win64 and py34]
    - conda-build         # [win and not (win64 and py34)]
    - jinja2
    - anaconda-client

test: {}

about:
  home: https://github.com/conda-forge/conda-forge-build-setup-feedstock
  summary: A package installed by conda-forge each time a build is run on CI. This package has side-effects to your conda config.
  license: BSD 3-clause

extra:
  recipe-maintainers:
    - jakirkham
    - ocefpaf
    - pelson
