from __future__ import print_function
from __future__ import division
from __future__ import absolute_import

COMPONENT_TYPE_BYTE = 5120
COMPONENT_TYPE_UNSIGNED_BYTE = 5121
COMPONENT_TYPE_SHORT = 5122
COMPONENT_TYPE_UNSIGNED_SHORT = 5123
COMPONENT_TYPE_UNSIGNED_INT = 5125
COMPONENT_TYPE_FLOAT = 5126

TYPE_SCALAR = 'SCALAR'
TYPE_VEC2 = 'VEC2'
TYPE_VEC3 = 'VEC3'
TYPE_VEC4 = 'VEC4'
TYPE_MAT2 = 'MAT2'
TYPE_MAT3 = 'MAT3'
TYPE_MAT4 = 'MAT4'

COMPONENT_TYPE_ENUM = {
    COMPONENT_TYPE_BYTE: 'b',
    COMPONENT_TYPE_UNSIGNED_BYTE: 'B',
    COMPONENT_TYPE_SHORT: 'h',
    COMPONENT_TYPE_UNSIGNED_SHORT: 'H',
    COMPONENT_TYPE_UNSIGNED_INT: 'I',
    COMPONENT_TYPE_FLOAT: 'f',
}

NUM_COMPONENTS_BY_TYPE_ENUM = {
    TYPE_SCALAR: 1,
    TYPE_VEC2: 2,
    TYPE_VEC3: 3,
    TYPE_VEC4: 4,
    TYPE_MAT2: 4,
    TYPE_MAT3: 9,
    TYPE_MAT4: 16,
}

NUM_BYTES_BY_COMPONENT_TYPE = {
    COMPONENT_TYPE_BYTE: 1,
    COMPONENT_TYPE_UNSIGNED_BYTE: 1,
    COMPONENT_TYPE_SHORT: 2,
    COMPONENT_TYPE_UNSIGNED_SHORT: 2,
    COMPONENT_TYPE_UNSIGNED_INT: 4,
    COMPONENT_TYPE_FLOAT: 4,
}

MODE_BY_VERTEX_COUNT = {
    3: None,
    2: 1,
    1: 0,
}

VERTEX_COUNT_BY_MODE = {
    0: 1,
    1: 2,
    4: 3,
    None: 3,
}
