#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Defines unit tests for :mod:`colour.colorimetry.spectrum` module.
"""

from __future__ import division, unicode_literals

import numpy as np
import operator
import unittest

from colour.colorimetry.spectrum import (
    SpectralMapping,
    SpectralShape,
    SpectralPowerDistribution,
    TriSpectralPowerDistribution,
    constant_spd,
    zeros_spd,
    ones_spd)
from colour.utilities import tstack

__author__ = 'Colour Developers'
__copyright__ = 'Copyright (C) 2013-2017 - Colour Developers'
__license__ = 'New BSD License - http://opensource.org/licenses/BSD-3-Clause'
__maintainer__ = 'Colour Developers'
__email__ = 'colour-science@googlegroups.com'
__status__ = 'Production'

__all__ = ['SAMPLE_SPD_DATA',
           'NON_UNIFORM_SAMPLE_SPD_DATA',
           'ZEROS_SAMPLE_SPD_DATA',
           'INTERPOLATED_SAMPLE_SPD_DATA',
           'INTERPOLATED_NON_UNIFORM_SAMPLE_SPD_DATA',
           'NORMALISED_SAMPLE_SPD_DATA',
           'CIE_1931_2_DEGREE_STANDARD_OBSERVER',
           'CMFS_DATA',
           'TestSpectralShape',
           'TestSpectralPowerDistribution',
           'TestTriSpectralPowerDistribution',
           'TestConstantSpd',
           'TestZerosSpd',
           'TestOnes_spd']

SAMPLE_SPD_DATA = {
    340: 0.0000,
    360: 0.0000,
    380: 0.0000,
    400: 0.0641,
    420: 0.0645,
    440: 0.0562,
    460: 0.0537,
    480: 0.0559,
    500: 0.0651,
    520: 0.0705,
    540: 0.0772,
    560: 0.0870,
    580: 0.1128,
    600: 0.1360,
    620: 0.1511,
    640: 0.1688,
    660: 0.1996,
    680: 0.2397,
    700: 0.2852,
    720: 0.0000,
    740: 0.0000,
    760: 0.0000,
    780: 0.0000,
    800: 0.0000,
    820: 0.0000}

NON_UNIFORM_SAMPLE_SPD_DATA = {
    391.898: 16.331740,
    392.069: 16.333122,
    405.606: 40.197224,
    406.794: 39.923366,
    406.891: 39.924098,
    407.026: 39.925138,
    416.286: 40.064293,
    418.690: 40.009950,
    426.700: 18.045809,
    426.726: 18.045986,
    432.556: 38.435883,
    464.742: 29.534647,
    465.025: 29.534647,
    465.147: 29.534647,
    466.586: 38.226470,
    477.175: 7.487795,
    493.205: 7.684766,
    505.217: 7.684766,
    513.294: 20.701285,
    513.328: 20.704211,
    514.349: 20.704211,
    514.516: 20.709788,
    515.109: 20.709788,
    538.034: 7.684766,
    564.807: 20.704211,
    566.247: 20.709788,
    569.592: 32.103387,
    580.133: 37.548490,
    581.198: 37.548490,
    582.642: 40.197224,
    588.977: 18.045986,
    589.159: 18.045809,
    600.113: 8.643020,
    600.603: 8.647157,
    600.718: 8.640394,
    601.068: 8.640394,
    601.322: 8.647157,
    601.484: 8.643020,
    657.805: 14.448826,
    658.288: 14.448826,
    658.761: 8.537097,
    674.438: 38.22647,
    678.390: 20.709788,
    703.725: 38.435883,
    711.318: 8.647157,
    711.519: 8.640394,
    711.563: 22.532398,
    711.699: 8.647157,
    711.990: 22.536906,
    723.132: 16.33174,
    723.642: 16.333122,
    761.265: 41.342187,
    786.089: 8.850659,
    805.862: 8.850659}

ZEROS_SAMPLE_SPD_DATA = (
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0641,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0645,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0562,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0537,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0559,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0651,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0705,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0772,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0870,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.1128,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.1360,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.1511,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.1688,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.1996,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.2397,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.2852,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000,
    0.0000)

INTERPOLATED_SAMPLE_SPD_DATA = (
    0.000000000000000,
    0.000230709627131,
    0.000384144814593,
    0.000507137093115,
    0.000632114832536,
    0.000778810112328,
    0.000955965592105,
    0.001163041382140,
    0.001391921913876,
    0.001628622810444,
    0.001854997757177,
    0.002050445372122,
    0.002193616076555,
    0.002264118965498,
    0.002244228678230,
    0.002120592268802,
    0.001885936076555,
    0.001540772596628,
    0.001095107350478,
    0.000570145756392,
    0.000000000000000,
    -0.000581325882457,
    -0.001183945630981,
    -0.001820338942229,
    -0.002492278660287,
    -0.003192248184715,
    -0.003904858878589,
    -0.004608267476544,
    -0.005275593492823,
    -0.005876336629317,
    -0.006377794183612,
    -0.006746478457031,
    -0.006949534162679,
    -0.006956155833489,
    -0.006739005230263,
    -0.006275628749720,
    -0.005549874832536,
    -0.004553311371393,
    -0.003286643119019,
    -0.001761129096236,
    0.000000000000000,
    0.001979832128906,
    0.004221516875000,
    0.006762744980469,
    0.009617760000000,
    0.012780285644531,
    0.016226453125000,
    0.019917728496094,
    0.023803840000000,
    0.027825705410156,
    0.031918359375000,
    0.036013880761719,
    0.040044320000000,
    0.043944626425781,
    0.047655575625000,
    0.051126696777344,
    0.054319200000000,
    0.057208903691406,
    0.059789161875000,
    0.062073791542969,
    0.064100000000000,
    0.065908998066406,
    0.067477265625000,
    0.068776060136719,
    0.069791040000000,
    0.070520520019531,
    0.070973726875000,
    0.071169054589844,
    0.071132320000000,
    0.070895018222656,
    0.070492578125000,
    0.069962617792969,
    0.069343200000000,
    0.068671087675781,
    0.067979999375000,
    0.067298864746094,
    0.066650080000000,
    0.066047763378906,
    0.065496010625000,
    0.064987150449219,
    0.064500000000000,
    0.064007805449219,
    0.063510900625000,
    0.063016138378906,
    0.062528640000000,
    0.062051989746094,
    0.061588429375000,
    0.061139052675781,
    0.060704000000000,
    0.060282652792969,
    0.059873828125000,
    0.059475973222656,
    0.059087360000000,
    0.058706279589844,
    0.058331236875000,
    0.057961145019531,
    0.057595520000000,
    0.057234675136719,
    0.056879915625000,
    0.056533733066406,
    0.056200000000000,
    0.055883811757812,
    0.055589516250000,
    0.055320009023437,
    0.055076960000000,
    0.054860961914063,
    0.054671678750000,
    0.054507994179687,
    0.054368160000000,
    0.054249944570312,
    0.054150781250000,
    0.054067916835938,
    0.053998560000000,
    0.053940029726562,
    0.053889903750000,
    0.053846166992187,
    0.053807360000000,
    0.053772727382813,
    0.053742366250000,
    0.053717374648438,
    0.053700000000000,
    0.053692483144531,
    0.053693175625000,
    0.053700270058594,
    0.053712960000000,
    0.053731311035156,
    0.053756131875000,
    0.053788845449219,
    0.053831360000000,
    0.053885940175781,
    0.053955078125000,
    0.054041364589844,
    0.054147360000000,
    0.054275465566406,
    0.054427794375000,
    0.054606042480469,
    0.054811360000000,
    0.055044222207031,
    0.055304300625000,
    0.055590334121094,
    0.055900000000000,
    0.056231407851562,
    0.056587597500000,
    0.056971279335937,
    0.057383360000000,
    0.057823168945313,
    0.058288685000000,
    0.058776762929688,
    0.059283360000000,
    0.059803762539063,
    0.060332812500000,
    0.060865134023438,
    0.061395360000000,
    0.061918358632813,
    0.062429460000000,
    0.062924682617188,
    0.063400960000000,
    0.063856367226563,
    0.064290347500000,
    0.064703938710938,
    0.065100000000000,
    0.065481647265625,
    0.065846786250000,
    0.066192982265625,
    0.066519040000000,
    0.066824853515625,
    0.067111256250000,
    0.067379871015625,
    0.067632960000000,
    0.067873274765625,
    0.068103906250000,
    0.068328134765625,
    0.068549280000000,
    0.068770551015625,
    0.068994896250000,
    0.069224853515625,
    0.069462400000000,
    0.069708802265625,
    0.069964466250000,
    0.070228787265625,
    0.070500000000000,
    0.070776270703125,
    0.071059446250000,
    0.071351597578125,
    0.071653920000000,
    0.071966845703125,
    0.072290156250000,
    0.072623095078125,
    0.072964480000000,
    0.073312815703125,
    0.073666406250000,
    0.074023467578125,
    0.074382240000000,
    0.074741100703125,
    0.075098676250000,
    0.075453955078125,
    0.075806400000000,
    0.076156060703125,
    0.076503686250000,
    0.076850837578125,
    0.077200000000000,
    0.077552701992188,
    0.077904262500000,
    0.078250762070313,
    0.078590880000000,
    0.078925561523438,
    0.079257685000000,
    0.079591729101562,
    0.079933440000000,
    0.080289498554688,
    0.080667187500000,
    0.081074058632813,
    0.081517600000000,
    0.082004903085938,
    0.082542330000000,
    0.083135180664063,
    0.083787360000000,
    0.084501045117188,
    0.085276352500000,
    0.086111005195313,
    0.087000000000000,
    0.087938453242188,
    0.088930890000000,
    0.089981833007812,
    0.091092960000000,
    0.092263452148438,
    0.093490342500000,
    0.094768864414062,
    0.096092800000000,
    0.097454828554687,
    0.098846875000000,
    0.100260458320312,
    0.101687040000000,
    0.103118372460937,
    0.104546847500000,
    0.105965844726563,
    0.107370080000000,
    0.108755953867188,
    0.110121900000000,
    0.111468733632812,
    0.112800000000000,
    0.114120657988281,
    0.115431176875000,
    0.116730532871094,
    0.118017600000000,
    0.119291174316406,
    0.120549998125000,
    0.121792784199219,
    0.123018240000000,
    0.124225091894531,
    0.125412109375000,
    0.126578129277344,
    0.127722080000000,
    0.128843005722656,
    0.129940090625000,
    0.131012683105469,
    0.132060320000000,
    0.133082750800781,
    0.134079961875000,
    0.135052200683594,
    0.136000000000000,
    0.136923531484375,
    0.137820920000000,
    0.138690739765625,
    0.139532640000000,
    0.140347216796875,
    0.141135885000000,
    0.141900750078125,
    0.142644480000000,
    0.143370177109375,
    0.144081250000000,
    0.144781285390625,
    0.145473920000000,
    0.146162712421875,
    0.146851015000000,
    0.147541845703125,
    0.148237760000000,
    0.148940722734375,
    0.149651980000000,
    0.150371931015625,
    0.151100000000000,
    0.151834687363281,
    0.152574745625000,
    0.153319862089844,
    0.154070560000000,
    0.154828088378906,
    0.155594311875000,
    0.156371600605469,
    0.157162720000000,
    0.157970720644531,
    0.158798828125000,
    0.159650332871094,
    0.160528480000000,
    0.161436359160156,
    0.162376794375000,
    0.163352233886719,
    0.164364640000000,
    0.165415378925781,
    0.166505110625000,
    0.167633678652344,
    0.168800000000000,
    0.170002988242187,
    0.171244585000000,
    0.172526722382812,
    0.173850400000000,
    0.175215795898437,
    0.176622377500000,
    0.178069012539063,
    0.179554080000000,
    0.181075581054688,
    0.182631250000000,
    0.184218665195313,
    0.185835360000000,
    0.187478933710938,
    0.189147162500000,
    0.190838110351563,
    0.192550240000000,
    0.194282523867188,
    0.196034555000000,
    0.197806658007813,
    0.199600000000000,
    0.201405046894531,
    0.203174116875000,
    0.204868198964844,
    0.206468000000000,
    0.207971350097656,
    0.209390608125000,
    0.210750067167969,
    0.212083360000000,
    0.213430864550781,
    0.214837109375000,
    0.216348179121094,
    0.218009120000000,
    0.219861345253906,
    0.221940040625000,
    0.224271569824219,
    0.226870880000000,
    0.229738907207031,
    0.232859981875000,
    0.236199234277344,
    0.239700000000000,
    0.243337282929688,
    0.247262056250000,
    0.251598942851562,
    0.256394240000000,
    0.261625952148438,
    0.267213823750000,
    0.273029372070313,
    0.278905920000000,
    0.284648628867188,
    0.290044531250000,
    0.294872563789062,
    0.298913600000000,
    0.301960483085938,
    0.303828058750000,
    0.304363208007813,
    0.303454880000000,
    0.301044124804688,
    0.297134126250000,
    0.291800234726562,
    0.285200000000000,
    0.277470396855469,
    0.268408756875000,
    0.257826504003906,
    0.245651040000000,
    0.231911267089844,
    0.216723110625000,
    0.200275041738281,
    0.182813600000000,
    0.164628916074219,
    0.146040234375000,
    0.127381435722656,
    0.108986560000000,
    0.091175328808594,
    0.074238668125000,
    0.058424230957031,
    0.043921920000000,
    0.030849410292969,
    0.019237671875000,
    0.009016492441406,
    0.000000000000000,
    -0.008014721386719,
    -0.014901410625000,
    -0.020510217441406,
    -0.024767360000000,
    -0.027665856933594,
    -0.029256259375000,
    -0.029637382988281,
    -0.028947040000000,
    -0.027352771230469,
    -0.025042578125000,
    -0.022215654785156,
    -0.019073120000000,
    -0.015808749277344,
    -0.012599706875000,
    -0.009597277832031,
    -0.006917600000000,
    -0.004632396074219,
    -0.002759705625000,
    -0.001254617128906,
    0.000000000000000,
    0.001146203203125,
    0.002165737500000,
    0.003010363984375,
    0.003650560000000,
    0.004073291015625,
    0.004279782500000,
    0.004283291796875,
    0.004106880000000,
    0.003781183828125,
    0.003342187500000,
    0.002828994609375,
    0.002281600000000,
    0.001738661640625,
    0.001235272500000,
    0.000800732421875,
    0.000456320000000,
    0.000213064453125,
    0.000069517500000,
    0.000009525234375,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000)

INTERPOLATED_NON_UNIFORM_SAMPLE_SPD_DATA = (
    16.329778095156982,
    16.722912723132556,
    17.781520028373180,
    19.389396167568528,
    21.430343341950202,
    23.788163752749799,
    26.346659601198912,
    28.989633088529139,
    31.600886415972091,
    34.064221784759340,
    36.263441396122502,
    38.082347451293174,
    39.404742151502930,
    40.114427697983402,
    40.111243699421522,
    39.925103629201168,
    39.890167178851087,
    39.799324065847429,
    39.680556791530307,
    39.561846086647805,
    39.471172681947927,
    39.436517308178743,
    39.485860696088267,
    39.647183576424581,
    39.948466679935706,
    40.374181468061238,
    40.480943043251031,
    39.587763148040459,
    37.399010977790780,
    34.259517357831442,
    30.574008076701602,
    26.747208922940480,
    23.183845685087242,
    20.288644151681090,
    18.466330111261207,
    18.131455042017670,
    19.618408432819184,
    22.601624594849554,
    26.621530084079197,
    31.218551456478512,
    35.933115268017922,
    40.312773210265746,
    44.121677838733966,
    47.374686358277039,
    50.100647612970285,
    52.328410446889080,
    54.086823704108710,
    55.404736228704550,
    56.310996864751935,
    56.834454456326178,
    57.003957847502640,
    56.848355882356643,
    56.396497404963519,
    55.677231259398624,
    54.719406289737300,
    53.551871340054845,
    52.203475254426650,
    50.703066876927998,
    49.079495051634254,
    47.361608622620757,
    45.578256433962849,
    43.758287329735850,
    41.930550154015101,
    40.123893750875936,
    38.367166964393718,
    36.689218638643744,
    35.118897617701386,
    33.685052745641954,
    32.416532866540805,
    31.342186824473270,
    30.490863463514671,
    29.891411627740368,
    29.572680161225694,
    29.538621478955591,
    33.594913458907321,
    41.048330707682268,
    45.551744553974856,
    47.142069194639774,
    46.264235270826262,
    43.363173423683598,
    38.883814294360953,
    33.271088524007610,
    26.969926753772803,
    20.425259624805754,
    14.082017778255718,
    8.385131855271933,
    3.728429425644130,
    0.156961054702055,
    -2.429909888257985,
    -4.133307786213816,
    -5.054357022143298,
    -5.294181979024267,
    -4.953907039834574,
    -4.134656587552058,
    -2.937555005154562,
    -1.463726675619941,
    0.185704018073971,
    1.909612692949324,
    3.606874966028280,
    5.176366454332983,
    6.516962774885600,
    7.527539544708277,
    8.122379804499362,
    8.331483145393147,
    8.237444939499099,
    7.923124733018005,
    7.471382072150651,
    6.965076503097814,
    6.487067572060285,
    6.120214825238840,
    5.947377808834269,
    6.051416069047350,
    6.515189152078867,
    7.421556604129607,
    8.833103320349386,
    10.654113910535857,
    12.714472052266359,
    14.843629857037500,
    16.871039436345892,
    18.626152901688148,
    19.938422364560878,
    20.637299936460693,
    20.706835013607193,
    20.713132277712795,
    20.620587314920563,
    20.396819413338232,
    20.054405097739068,
    19.605938072532023,
    19.064012042126031,
    18.441220710930018,
    17.750157783352932,
    17.003416963803701,
    16.213591956691264,
    15.393276466424567,
    14.555064197412538,
    13.711548854064109,
    12.875324140788226,
    12.058983761993822,
    11.275121422089832,
    10.536330825485194,
    9.855205676588847,
    9.244339679809721,
    8.716326539556761,
    8.283759960238900,
    7.959233646265071,
    7.755341302044216,
    7.684676631985266,
    7.756084346361913,
    7.961801723672590,
    8.289468950027061,
    8.726726048071839,
    9.261213040453441,
    9.880569949818376,
    10.572436798813163,
    11.324453610084309,
    12.124260406278331,
    12.959497210041745,
    13.817804044021063,
    14.686820930862797,
    15.554187893213468,
    16.407544953719576,
    17.234532135027642,
    18.022789459784182,
    18.759956950635704,
    19.433674630228733,
    20.031582521209774,
    20.541320646225341,
    20.950529027921945,
    21.246847688946101,
    21.417916651944331,
    21.451375939563139,
    21.334865574449047,
    21.056025579248555,
    20.604750276804520,
    20.494345115539804,
    22.221705466483996,
    25.661450384909422,
    29.775598875963166,
    33.531925166863601,
    36.383260994026813,
    38.399428507026130,
    39.690190939409774,
    40.365311524725989,
    40.534553496523046,
    40.307680088349152,
    39.794454533752578,
    39.104640066281540,
    38.347999919484330,
    37.634297326909127,
    37.374685122096146,
    39.119690202436686,
    40.253206514676137,
    38.299118523707605,
    34.130306344556416,
    28.883500018011556,
    23.695429584861984,
    19.702825085896695,
    18.042370406362124,
    17.942146149315505,
    17.437952042648156,
    16.603615435584160,
    15.527509996211428,
    14.298009392617876,
    13.003487292891400,
    11.732317365119920,
    10.572873277391340,
    9.613528697793571,
    8.942657294414522,
    8.648632735342099,
    8.638275004704358,
    8.608461767970397,
    8.468358252802256,
    8.236485825233604,
    7.918459258060551,
    7.519893324079201,
    7.046402796085658,
    6.503602446876036,
    5.897107049246431,
    5.232531375992957,
    4.515490199911716,
    3.751598293798816,
    2.946470430450363,
    2.105721382662463,
    1.234965923231222,
    0.339818824952746,
    -0.574105139376856,
    -1.501191196961480,
    -2.435824575005022,
    -3.372390500711373,
    -4.305274201284425,
    -5.228860903928080,
    -6.137535835846219,
    -7.025684224242744,
    -7.887691296321547,
    -8.717942279286525,
    -9.510822400341567,
    -10.260716886690570,
    -10.962010965537431,
    -11.609089864086032,
    -12.196338809540270,
    -12.718143029104052,
    -13.168887749981261,
    -13.542958199375791,
    -13.834739604491540,
    -14.038617192532394,
    -14.148976190702248,
    -14.160201826205009,
    -14.066679326244559,
    -13.862793918024790,
    -13.542930828749602,
    -13.101475285622888,
    -12.532812515848539,
    -11.831327746630446,
    -10.991406205172515,
    -10.007433118678625,
    -8.873793714352681,
    -7.584873219398570,
    -6.135056861020184,
    -4.518729866421428,
    -2.730277462806184,
    -0.764084877378354,
    1.385462662658177,
    3.723979930099506,
    6.257081697741744,
    8.990382738381001,
    11.929497824813376,
    14.976162376302216,
    5.084239426857803,
    -6.729199659283580,
    -14.622346068690167,
    -19.038675241923528,
    -20.421662619545231,
    -19.214783642116821,
    -15.861513750199864,
    -10.805328384355935,
    -4.489702985146582,
    2.641887006866627,
    10.145966151122160,
    17.579059007058401,
    24.497690134113824,
    30.458384091726870,
    35.017665439335978,
    37.732058736379557,
    38.169776201971061,
    36.103214681666451,
    31.478432173301290,
    24.247019423375253,
    14.378015306520879,
    2.091468109328641,
    -12.204368690968362,
    -28.096681739822582,
    -45.172657682686484,
    -63.019483165012424,
    -81.224344832252967,
    -99.374429329860462,
    -117.056923303287391,
    -133.859013397986132,
    -149.367886259409232,
    -163.170728533009083,
    -174.854726864238074,
    -184.007067898548712,
    -190.214938281393415,
    -193.065524658224689,
    -192.146013674494867,
    -187.043591975656426,
    -177.345446207161871,
    -162.638763014463592,
    -142.510729043014010,
    -116.548530938265586,
    -84.339355345670725,
    -45.470388910681990,
    0.471181721248317,
    53.864768803115254,
    111.894546378021516,
    165.948982548543711,
    206.804509755528869,
    225.237560439823653,
    212.024567042275038,
    157.941962003729856,
    53.766177765035010,
    24.175603626092354,
    186.235250964189390,
    339.561150780358105,
    476.467689739151297,
    589.269254505121125,
    670.280231742820547,
    711.815008116801778,
    706.187970291617603,
    645.713504931820694,
    522.705998701963495,
    329.479838266598335,
    58.349410290278108,
    509.155161149940227,
    4467.126644650926210,
    11974.831412532214017,
    22711.664944814707269,
    36357.022721519322658,
    52590.300222666955960,
    71090.892928278495674,
    91538.196318374888506,
    113611.605872977001127,
    136990.517072105722036,
    161354.325395782070700,
    186382.426324026688235,
    211754.215336860768730,
    237149.087914305157028,
    262246.439536380639765,
    286725.665683108149096,
    310266.161834508704487,
    332547.323470603034366,
    353248.546071412158199,
    372049.225116957037244,
    388628.756087258341722,
    402666.534462337323930,
    413841.955722214595880,
    421834.415346911351662,
    426323.308816448086873,
    426988.031610845879186,
    423507.979210125980899,
    415562.547094308654778,
    402831.130743415385950,
    384993.125637466786429,
    361727.927256483701058,
    332714.931080487207510,
    297633.532589498150628,
    256163.127263537549879,
    207983.110582626046380,
    152772.878026784601388,
    90211.825076034423546,
    19979.347210396190349,
    -58110.181253942544572,
    -143006.877292386692716,
    -232998.025064318004297,
    -326364.582552921143360,
    -421387.507741380017251,
    -516347.758612881123554,
    -609526.293150608194992,
    -699204.069337745895609,
    -783662.045157479238696,
    -861181.178592992131598,
    -930042.427627470111474,
    -988526.750244098482653,
    -1034915.104426060337573,
    -1067488.448156541679054,
    -1084527.739418727345765,
    -1084313.936195801245049,
    -1065127.996470948448405,
    -1025250.878227353561670,
    -962963.539448202005588,
    -876546.938116677221842,
    -764282.032215965329669,
    -624449.779729250469245,
    -455331.138639716897160,
    -255207.066930550499819,
    -22358.522584934773477,
    243566.517701667617075,
    535769.836361289257184,
    845123.227935563772917,
    1162497.212320821359754,
    1478762.309413394192234,
    1784789.039109614444897,
    2071447.921305815922096,
    2329609.475898326374590,
    2550144.222783482633531,
    2723922.681857613380998,
    2841815.373017050791532,
    2894692.816158128902316,
    2873425.531177176162601,
    2768884.037970530334860,
    2571938.856434516608715,
    2273460.506465472746640,
    1864319.507959727896377,
    1335386.380813611438498,
    677531.644923461717553)

NORMALISED_SAMPLE_SPD_DATA = (
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    22.475455820476860,
    22.615708274894811,
    19.705469845722302,
    18.828892005610097,
    19.600280504908834,
    22.826086956521742,
    24.719495091164092,
    27.068723702664798,
    30.504908835904626,
    39.551192145862551,
    47.685834502103788,
    52.980364656381497,
    59.186535764375883,
    69.985974754558200,
    84.046283309957929,
    100.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000,
    0.000000000000000)

CIE_1931_2_DEGREE_STANDARD_OBSERVER = {
    'x_bar': {
        380: 0.001368,
        385: 0.002236,
        390: 0.004243,
        395: 0.007650,
        400: 0.014310,
        405: 0.023190,
        410: 0.043510,
        415: 0.077630,
        420: 0.134380,
        425: 0.214770,
        430: 0.283900,
        435: 0.328500,
        440: 0.348280,
        445: 0.348060,
        450: 0.336200,
        455: 0.318700,
        460: 0.290800,
        465: 0.251100,
        470: 0.195360,
        475: 0.142100,
        480: 0.095640,
        485: 0.057950,
        490: 0.032010,
        495: 0.014700,
        500: 0.004900,
        505: 0.002400,
        510: 0.009300,
        515: 0.029100,
        520: 0.063270,
        525: 0.109600,
        530: 0.165500,
        535: 0.225750,
        540: 0.290400,
        545: 0.359700,
        550: 0.433450,
        555: 0.512050,
        560: 0.594500,
        565: 0.678400,
        570: 0.762100,
        575: 0.842500,
        580: 0.916300,
        585: 0.978600,
        590: 1.026300,
        595: 1.056700,
        600: 1.062200,
        605: 1.045600,
        610: 1.002600,
        615: 0.938400,
        620: 0.854450,
        625: 0.751400,
        630: 0.642400,
        635: 0.541900,
        640: 0.447900,
        645: 0.360800,
        650: 0.283500,
        655: 0.218700,
        660: 0.164900,
        665: 0.121200,
        670: 0.087400,
        675: 0.063600,
        680: 0.046770,
        685: 0.032900,
        690: 0.022700,
        695: 0.015840,
        700: 0.011359,
        705: 0.008111,
        710: 0.005790,
        715: 0.004109,
        720: 0.002899,
        725: 0.002049,
        730: 0.001440,
        735: 0.001000,
        740: 0.000690,
        745: 0.000476,
        750: 0.000332,
        755: 0.000235,
        760: 0.000166,
        765: 0.000117,
        770: 0.000083,
        775: 0.000059,
        780: 0.000042},
    'y_bar': {
        380: 0.000039,
        385: 0.000064,
        390: 0.000120,
        395: 0.000217,
        400: 0.000396,
        405: 0.000640,
        410: 0.001210,
        415: 0.002180,
        420: 0.004000,
        425: 0.007300,
        430: 0.011600,
        435: 0.016840,
        440: 0.023000,
        445: 0.029800,
        450: 0.038000,
        455: 0.048000,
        460: 0.060000,
        465: 0.073900,
        470: 0.090980,
        475: 0.112600,
        480: 0.139020,
        485: 0.169300,
        490: 0.208020,
        495: 0.258600,
        500: 0.323000,
        505: 0.407300,
        510: 0.503000,
        515: 0.608200,
        520: 0.710000,
        525: 0.793200,
        530: 0.862000,
        535: 0.914850,
        540: 0.954000,
        545: 0.980300,
        550: 0.994950,
        555: 1.000000,
        560: 0.995000,
        565: 0.978600,
        570: 0.952000,
        575: 0.915400,
        580: 0.870000,
        585: 0.816300,
        590: 0.757000,
        595: 0.694900,
        600: 0.631000,
        605: 0.566800,
        610: 0.503000,
        615: 0.441200,
        620: 0.381000,
        625: 0.321000,
        630: 0.265000,
        635: 0.217000,
        640: 0.175000,
        645: 0.138200,
        650: 0.107000,
        655: 0.081600,
        660: 0.061000,
        665: 0.044580,
        670: 0.032000,
        675: 0.023200,
        680: 0.017000,
        685: 0.011920,
        690: 0.008210,
        695: 0.005723,
        700: 0.004102,
        705: 0.002929,
        710: 0.002091,
        715: 0.001484,
        720: 0.001047,
        725: 0.000740,
        730: 0.000520,
        735: 0.000361,
        740: 0.000249,
        745: 0.000172,
        750: 0.000120,
        755: 0.000085,
        760: 0.000060,
        765: 0.000042,
        770: 0.000030,
        775: 0.000021,
        780: 0.000015},
    'z_bar': {
        380: 0.006450,
        385: 0.010550,
        390: 0.020050,
        395: 0.036210,
        400: 0.067850,
        405: 0.110200,
        410: 0.207400,
        415: 0.371300,
        420: 0.645600,
        425: 1.039050,
        430: 1.385600,
        435: 1.622960,
        440: 1.747060,
        445: 1.782600,
        450: 1.772110,
        455: 1.744100,
        460: 1.669200,
        465: 1.528100,
        470: 1.287640,
        475: 1.041900,
        480: 0.812950,
        485: 0.616200,
        490: 0.465180,
        495: 0.353300,
        500: 0.272000,
        505: 0.212300,
        510: 0.158200,
        515: 0.111700,
        520: 0.078250,
        525: 0.057250,
        530: 0.042160,
        535: 0.029840,
        540: 0.020300,
        545: 0.013400,
        550: 0.008750,
        555: 0.005750,
        560: 0.003900,
        565: 0.002750,
        570: 0.002100,
        575: 0.001800,
        580: 0.001650,
        585: 0.001400,
        590: 0.001100,
        595: 0.001000,
        600: 0.000800,
        605: 0.000600,
        610: 0.000340,
        615: 0.000240,
        620: 0.000190,
        625: 0.000100,
        630: 0.000050,
        635: 0.000030,
        640: 0.000020,
        645: 0.000010,
        650: 0.000000,
        655: 0.000000,
        660: 0.000000,
        665: 0.000000,
        670: 0.000000,
        675: 0.000000,
        680: 0.000000,
        685: 0.000000,
        690: 0.000000,
        695: 0.000000,
        700: 0.000000,
        705: 0.000000,
        710: 0.000000,
        715: 0.000000,
        720: 0.000000,
        725: 0.000000,
        730: 0.000000,
        735: 0.000000,
        740: 0.000000,
        745: 0.000000,
        750: 0.000000,
        755: 0.000000,
        760: 0.000000,
        765: 0.000000,
        770: 0.000000,
        775: 0.000000,
        780: 0.000000}}

CMFS_DATA = {
    380: np.array([0.001368, 3.90e-05, 0.006450]),
    385: np.array([0.002236, 6.40e-05, 0.010550]),
    390: np.array([0.004243, 0.000120, 0.020050]),
    395: np.array([0.007650, 0.000217, 0.036210]),
    400: np.array([0.014310, 0.000396, 0.067850]),
    405: np.array([0.023190, 0.000640, 0.110200]),
    410: np.array([0.043510, 0.001210, 0.207400]),
    415: np.array([0.077630, 0.002180, 0.371300]),
    420: np.array([0.134380, 0.004000, 0.645600]),
    425: np.array([0.214770, 0.007300, 1.039050]),
    430: np.array([0.283900, 0.011600, 1.385600]),
    435: np.array([0.328500, 0.016840, 1.622960]),
    440: np.array([0.348280, 0.023000, 1.747060]),
    445: np.array([0.348060, 0.029800, 1.782600]),
    450: np.array([0.336200, 0.038000, 1.772110]),
    455: np.array([0.318700, 0.048000, 1.744100]),
    460: np.array([0.290800, 0.060000, 1.669200]),
    465: np.array([0.251100, 0.073900, 1.528100]),
    470: np.array([0.195360, 0.090980, 1.287640]),
    475: np.array([0.142100, 0.112600, 1.041900]),
    480: np.array([0.095640, 0.139020, 0.812950]),
    485: np.array([0.057950, 0.169300, 0.616200]),
    490: np.array([0.032010, 0.208020, 0.465180]),
    495: np.array([0.014700, 0.258600, 0.353300]),
    500: np.array([0.004900, 0.323000, 0.272000]),
    505: np.array([0.002400, 0.407300, 0.212300]),
    510: np.array([0.009300, 0.503000, 0.158200]),
    515: np.array([0.029100, 0.608200, 0.111700]),
    520: np.array([0.063270, 0.710000, 0.078250]),
    525: np.array([0.109600, 0.793200, 0.057250]),
    530: np.array([0.165500, 0.862000, 0.042160]),
    535: np.array([0.225750, 0.914850, 0.029840]),
    540: np.array([0.290400, 0.954000, 0.020300]),
    545: np.array([0.359700, 0.980300, 0.013400]),
    550: np.array([0.433450, 0.994950, 0.008750]),
    555: np.array([0.512050, 1.000000, 0.005750]),
    560: np.array([0.594500, 0.995000, 0.003900]),
    565: np.array([0.678400, 0.978600, 0.002750]),
    570: np.array([0.762100, 0.952000, 0.002100]),
    575: np.array([0.842500, 0.915400, 0.001800]),
    580: np.array([0.916300, 0.870000, 0.001650]),
    585: np.array([0.978600, 0.816300, 0.001400]),
    590: np.array([1.026300, 0.757000, 0.001100]),
    595: np.array([1.056700, 0.694900, 0.001000]),
    600: np.array([1.062200, 0.631000, 0.000800]),
    605: np.array([1.045600, 0.566800, 0.000600]),
    610: np.array([1.002600, 0.503000, 0.000340]),
    615: np.array([0.938400, 0.441200, 0.000240]),
    620: np.array([0.854450, 0.381000, 0.000190]),
    625: np.array([0.751400, 0.321000, 0.000100]),
    630: np.array([0.642400, 0.265000, 5.00e-05]),
    635: np.array([0.541900, 0.217000, 3.00e-05]),
    640: np.array([0.447900, 0.175000, 2.00e-05]),
    645: np.array([0.360800, 0.138200, 1.00e-05]),
    650: np.array([0.283500, 0.107000, 0.000000]),
    655: np.array([0.218700, 0.081600, 0.000000]),
    660: np.array([0.164900, 0.061000, 0.000000]),
    665: np.array([0.121200, 0.044580, 0.000000]),
    670: np.array([0.087400, 0.032000, 0.000000]),
    675: np.array([0.063600, 0.023200, 0.000000]),
    680: np.array([0.046770, 0.017000, 0.000000]),
    685: np.array([0.032900, 0.011920, 0.000000]),
    690: np.array([0.022700, 0.008210, 0.000000]),
    695: np.array([0.015840, 0.005723, 0.000000]),
    700: np.array([0.011359, 0.004102, 0.000000]),
    705: np.array([0.008111, 0.002929, 0.000000]),
    710: np.array([0.005790, 0.002091, 0.000000]),
    715: np.array([0.004109, 0.001484, 0.000000]),
    720: np.array([0.002899, 0.001047, 0.000000]),
    725: np.array([0.002049, 0.000740, 0.000000]),
    730: np.array([0.001440, 0.000520, 0.000000]),
    735: np.array([0.001000, 0.000361, 0.000000]),
    740: np.array([0.000690, 0.000249, 0.000000]),
    745: np.array([0.000476, 0.000172, 0.000000]),
    750: np.array([0.000332, 0.000120, 0.000000]),
    755: np.array([0.000235, 8.50e-05, 0.000000]),
    760: np.array([0.000166, 6.00e-05, 0.000000]),
    765: np.array([0.000117, 4.20e-05, 0.000000]),
    770: np.array([8.30e-05, 3.00e-05, 0.000000]),
    775: np.array([5.90e-05, 2.10e-05, 0.000000]),
    780: np.array([4.20e-05, 1.50e-05, 0.000000])}


class TestSpectralMapping(unittest.TestCase):
    """
    Defines :class:`colour.colorimetry.spectrum.SpectralMapping` class unit
    tests methods.

    Notes
    -----
    -   This class unit tests are entirely covered by
        :class:`colour.utilities.tests.tests_data_structures.\
TestArbitraryPrecisionMapping` class.
    """

    def test_required_attributes(self):
        """
        Tests presence of required attributes.
        """

        required_attributes = ('key_decimals',)

        for attribute in required_attributes:
            self.assertIn(attribute, dir(SpectralMapping))

    def test_required_methods(self):
        """
        Tests presence of required methods.
        """

        required_methods = ('__setitem__',
                            '__getitem__',
                            '__delitem__',
                            '__contains__',
                            '__iter__',
                            '__len__')

        for method in required_methods:
            self.assertIn(method, dir(SpectralMapping))


class TestSpectralShape(unittest.TestCase):
    """
    Defines :class:`colour.colorimetry.spectrum.SpectralShape` class unit tests
    methods.
    """

    def test_required_attributes(self):
        """
        Tests presence of required attributes.
        """

        required_attributes = ('start',
                               'end',
                               'interval',
                               'boundaries')

        for attribute in required_attributes:
            self.assertIn(attribute, dir(SpectralShape))

    def test_required_methods(self):
        """
        Tests presence of required methods.
        """

        required_methods = ('__init__',
                            '__str__',
                            '__repr__',
                            '__iter__',
                            '__contains__',
                            '__len__',
                            '__eq__',
                            '__ne__',
                            'range')

        for method in required_methods:
            self.assertIn(method, dir(SpectralShape))

    def test_start(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.SpectralShape.start`
        attribute.
        """

        self.assertEqual(SpectralShape(360, 830, 1).start, 360)

        self.assertRaises(AssertionError, lambda: SpectralShape(360, 360, 1))

        self.assertRaises(AssertionError, lambda: SpectralShape(360, 0, 1))

    def test_end(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.SpectralShape.end` attribute.
        """

        self.assertEqual(SpectralShape(360, 830, 1).end, 830)

        self.assertRaises(AssertionError, lambda: SpectralShape(830, 830, 1))

        self.assertRaises(AssertionError, lambda: SpectralShape(830, 0, 1))

    def test_interval(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.SpectralShape.interval`
        attribute.
        """

        self.assertEqual(SpectralShape(360, 830, 1).interval, 1)

    def test_boundaries(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.SpectralShape.boundaries`
        attribute.
        """

        shape = SpectralShape()
        shape.boundaries = (360, 830)

        self.assertEqual(shape.start, 360)
        self.assertEqual(shape.end, 830)

    def test__iter__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.SpectralShape.__iter__`
        method.
        """

        np.testing.assert_almost_equal(
            [wavelength for wavelength in SpectralShape(0, 10, 0.1)],
            np.arange(0, 10 + 0.1, 0.1))

    def test__contains__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.SpectralShape.__contains__`
        method.
        """

        self.assertIn(360.1, SpectralShape(360, 830, 0.1))

        self.assertNotIn(360.11, SpectralShape(360, 830, 0.1))

        self.assertIn(np.array([0.5, 0.6]), SpectralShape(0, 10, 0.1))

        self.assertNotIn(np.array([0.5, 0.61]), SpectralShape(0, 10, 0.1))

    def test__len__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.SpectralShape.__len__`
        method.
        """

        self.assertEqual(len(SpectralShape(0, 10, 0.1)), 101)

    def test__eq__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.SpectralShape.__eq__`
        method.
        """

        self.assertEqual(SpectralShape(0, 10, 0.1), SpectralShape(0, 10, 0.1))

    def test__ne__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.SpectralShape.__ne__`
        method.
        """

        self.assertNotEqual(
            SpectralShape(0, 10, 0.1),
            SpectralShape(1, 10, 0.1))

    def test_range(self):
        """
        Tests :func:`colour.colorimetry.spectrum.SpectralShape.range` method.
        """

        np.testing.assert_almost_equal(
            [wavelength for wavelength in SpectralShape(0, 10, 0.1)],
            np.arange(0, 10 + 0.1, 0.1))


class TestSpectralPowerDistribution(unittest.TestCase):
    """
    Defines :class:`colour.colorimetry.spectrum.SpectralPowerDistribution`
    class unit tests methods.
    """

    def setUp(self):
        """
        Initialises common tests attributes.
        """

        self._spd = SpectralPowerDistribution('Sample', SAMPLE_SPD_DATA)

        self._non_uniform_spd = SpectralPowerDistribution(
            'Non Uniform Sample', NON_UNIFORM_SAMPLE_SPD_DATA)

        self._phi = (1 + np.sqrt(5)) / 2

    def test_required_attributes(self):
        """
        Tests presence of required attributes.
        """

        required_attributes = ('name',
                               'data',
                               'title',
                               'wavelengths',
                               'values',
                               'shape')

        for attribute in required_attributes:
            self.assertIn(attribute, dir(SpectralPowerDistribution))

    def test_required_methods(self):
        """
        Tests presence of required methods.
        """

        required_methods = ('__str__',
                            '__repr__',
                            '__hash__',
                            '__getitem__',
                            '__setitem__',
                            '__iter__',
                            '__contains__',
                            '__len__',
                            '__eq__',
                            '__ne__',
                            '__add__',
                            '__iadd__',
                            '__sub__',
                            '__isub__',
                            '__mul__',
                            '__imul__',
                            '__div__',
                            '__idiv__',
                            '__pow__',
                            '__ipow__',
                            'get',
                            'is_uniform',
                            'extrapolate',
                            'interpolate',
                            'align',
                            'trim_wavelengths',
                            'zeros',
                            'normalise',
                            'clone')

        for method in required_methods:
            self.assertIn(method, dir(SpectralPowerDistribution))

    def test_wavelengths(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.wavelengths` attribute.
        """

        np.testing.assert_almost_equal(
            self._spd.wavelengths,
            sorted(SAMPLE_SPD_DATA))

        spd = self._spd.clone().interpolate(SpectralShape(interval=0.1))
        non_uniform_spd = self._non_uniform_spd.clone().interpolate(
            SpectralShape(interval=0.1))

        self.assertTrue(
            np.all(np.in1d(non_uniform_spd.wavelengths, spd.wavelengths)))

    def test_values(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.values` attribute.
        """

        np.testing.assert_almost_equal(
            self._spd.values,
            [v for k, v in sorted(SAMPLE_SPD_DATA.items())])

    def test_shape(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.shape` attribute.
        """

        self.assertEqual(self._spd.shape, SpectralShape(340, 820, 20))

    def test__str__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__str__` method.
        """

        try:
            self.assertEqual(
                str(self._spd),
                'SpectralPowerDistribution(\'Sample\', (340, 820, 20))')
        except AssertionError:
            self.assertEqual(
                str(self._spd),
                'SpectralPowerDistribution(\'Sample\', (340.0, 820.0, 20.0))')

    def test__getitem__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__getitem__` method.
        """

        self.assertEqual(self._spd[400], 0.0641)

        np.testing.assert_almost_equal(
            self._spd[np.array([340, 620, 820])],
            np.array([0.0000, 0.1511, 0.0000]))

        np.testing.assert_almost_equal(
            self._spd[3:6],
            np.array([0.0641, 0.0645, 0.0562]))

    def test__setitem__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__setitem__` method.
        """

        spd = SpectralPowerDistribution('Spd', {})
        spd[510] = 49.6700
        np.testing.assert_almost_equal(spd.values, np.array(49.6700))

        spd[np.array([520, 530])] = np.array([69.59, 81.73])
        np.testing.assert_almost_equal(
            spd.values,
            np.array([49.67, 69.59, 81.73]))

        spd[np.array([540, 550])] = 88.19
        np.testing.assert_almost_equal(
            spd.values,
            np.array([49.67, 69.59, 81.73, 88.19, 88.19]))

        spd[:] = 49.67
        np.testing.assert_almost_equal(
            spd.values,
            np.array([49.67, 49.67, 49.67, 49.67, 49.67]))

    def test__iter__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__iter__` method.
        """

        self.assertEqual(
            {key: value for key, value in self._spd},
            SAMPLE_SPD_DATA)

    def test__contains__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__contains__` method.
        """

        self.assertIn(340, self._spd)

        self.assertIn(460, self._spd)

        self.assertNotIn(461, self._spd)

    def test__len__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__len__` method.
        """

        self.assertEqual(len(self._spd), 25)

    def test__eq__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__eq__` method.
        """

        self.assertEqual(self._spd, self._spd.clone())

    def test__ne__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
    SpectralPowerDistribution.__ne__` method.
        """

        clone_spd = self._spd.clone()
        clone_spd[500] = 0.

        self.assertNotEqual(self._spd, clone_spd)

    def test_arithmetical_operations(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__add__`,
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__sub__`
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__mult__`
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__div__`
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__truediv__` and
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__pow__`
        methods.
        """

        operations = (
            operator.add,
            operator.sub,
            operator.mul,
            operator.truediv,
            operator.pow)

        for operation in operations:
            self.assertFalse(operation(self._spd, 1) is self._spd)

            values = self._spd.values
            np.testing.assert_almost_equal(
                operation(self._spd, self._phi).values,
                operation(values, self._phi))

            random = np.random.random(values.shape)
            np.testing.assert_almost_equal(
                operation(self._spd, random).values,
                operation(values, random))

            np.testing.assert_almost_equal(
                operation(self._spd, self._spd).values,
                operation(self._spd.values, self._spd.values))

    def test_arithmetical_ioperation(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__iadd__`,
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__isub__`
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__imult__`
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__idiv__`
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__itruediv__` and
:func:`colour.colorimetry.spectrum.SpectralPowerDistribution.__ipow__`
        methods.
        """

        operations = (
            operator.iadd,
            operator.isub,
            operator.imul,
            operator.itruediv,
            operator.ipow)

        for operation in operations:
            spd = self._spd.clone()
            self.assertTrue(operation(spd, 1) is spd)

            spd = self._spd.clone()
            values = spd.values
            np.testing.assert_almost_equal(
                operation(spd, 2).values,
                operation(values, 2))

            spd = self._spd.clone()
            values = spd.values
            random = np.random.random(len(values))
            np.testing.assert_almost_equal(
                operation(spd, random).values,
                operation(values, random))

            spd1 = self._spd.clone()
            spd2 = self._spd.clone()
            np.testing.assert_almost_equal(
                operation(spd1, spd2).values,
                operation(self._spd.values, self._spd.values))

    def test_get(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.get` method.
        """

        self.assertEqual(self._spd.get(340), 0.)

        self.assertEqual(self._spd.get(620), 0.1511)

        self.assertEqual(self._spd.get(820), 0.)

        self.assertEqual(self._spd.get(900, 0), 0)

        np.testing.assert_almost_equal(
            self._spd.get(np.array([340, 620, 820])),
            np.array([0.0000, 0.1511, 0.0000]))

        np.testing.assert_array_equal(self._spd.get(400.1), np.nan)

    def test_is_uniform(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.is_uniform` method.
        """

        self.assertFalse(self._non_uniform_spd.is_uniform())

        self.assertTrue(self._spd.is_uniform())

    def test_extrapolate(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.extrapolate` method.
        """

        spd = SpectralPowerDistribution(
            '', dict(zip(range(25, 35), [0] * 5 + [1] * 5)))
        spd.extrapolate(SpectralShape(10, 50))

        self.assertEqual(spd[10], 0)
        self.assertEqual(spd[50], 1)

    def test_interpolate(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.interpolate` method.
        """

        np.testing.assert_almost_equal(
            self._spd.clone().interpolate(
                SpectralShape(interval=1)).values,
            INTERPOLATED_SAMPLE_SPD_DATA,
            decimal=7)

        np.testing.assert_allclose(
            self._non_uniform_spd.clone().interpolate(
                SpectralShape(interval=1)).values,
            INTERPOLATED_NON_UNIFORM_SAMPLE_SPD_DATA,
            rtol=0.0000001,
            atol=0.0000001)

        np.testing.assert_almost_equal(
            self._spd.clone().interpolate(
                SpectralShape(interval=1),
                method='Linear')[410],
            np.array(0.0643),
            decimal=7)

        np.testing.assert_almost_equal(
            self._spd.clone().interpolate(
                SpectralShape(interval=1),
                method='Pchip')[410],
            np.array(0.064399379844961),
            decimal=7)

    def test_align(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.align` method.
        """

        shape = SpectralShape(100, 900, 5)
        self.assertEqual(self._spd.clone().align(shape).shape, shape)

        shape = SpectralShape(600, 650, 1)
        self.assertEqual(self._spd.clone().align(shape).shape, shape)

    def test_trim_wavelengths(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.trim_wavelengths` method.
        """

        shape = SpectralShape(400, 700, 20)
        self.assertEqual(self._spd.clone().trim_wavelengths(shape).shape,
                         shape)

        shape = SpectralShape(200, 900, 1)
        self.assertEqual(self._spd.clone().trim_wavelengths(shape).shape,
                         self._spd.shape)

    def test_zeros(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.zeros` method.
        """

        np.testing.assert_almost_equal(
            self._spd.clone().zeros(SpectralShape(interval=1)).values,
            ZEROS_SAMPLE_SPD_DATA)

        self.assertRaises(
            RuntimeError,
            lambda: self._non_uniform_spd.clone().zeros(
                SpectralShape(360, 830, 1)))

    def test_normalise(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.normalise` method.
        """

        np.testing.assert_almost_equal(
            self._spd.clone().normalise(100).values,
            NORMALISED_SAMPLE_SPD_DATA)

    def test_clone(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.clone` method.
        """

        self.assertFalse(self._spd is self._spd.clone())
        self.assertEqual(self._spd.title, self._spd.clone().title)


class TestTriSpectralPowerDistribution(unittest.TestCase):
    """
    Defines :class:`colour.colorimetry.spectrum.TriSpectralPowerDistribution`
    class unit tests methods.
    """

    def setUp(self):
        """
        Initialises common tests attributes.
        """

        self._mapping = {'x': 'x_bar',
                         'y': 'y_bar',
                         'z': 'z_bar'}

        self._labels = {'x': 'x_bar',
                        'y': 'y_bar',
                        'z': 'z_bar'}

        self._tri_spd = TriSpectralPowerDistribution(
            name='Observer',
            data=CIE_1931_2_DEGREE_STANDARD_OBSERVER,
            mapping=self._mapping,
            labels=self._labels)

        self._sample_tri_spd = TriSpectralPowerDistribution(
            name='Sample Observer',
            data={'x_bar': SAMPLE_SPD_DATA,
                  'y_bar': SAMPLE_SPD_DATA,
                  'z_bar': SAMPLE_SPD_DATA},
            mapping=self._mapping,
            labels=self._labels)

        self._non_uniform_sample_tri_spd = TriSpectralPowerDistribution(
            name='Non Uniform Sample Observer',
            data={'x_bar': NON_UNIFORM_SAMPLE_SPD_DATA,
                  'y_bar': NON_UNIFORM_SAMPLE_SPD_DATA,
                  'z_bar': NON_UNIFORM_SAMPLE_SPD_DATA},
            mapping=self._mapping,
            labels=self._labels)

        self._phi = (1 + np.sqrt(5)) / 2

    def test_required_attributes(self):
        """
        Tests presence of required attributes.
        """

        required_attributes = ('name',
                               'data',
                               'mapping',
                               'title',
                               'labels',
                               'x',
                               'y',
                               'z',
                               'wavelengths',
                               'values',
                               'shape')

        for attribute in required_attributes:
            self.assertIn(attribute, dir(TriSpectralPowerDistribution))

    def test_required_methods(self):
        """
        Tests presence of required methods.
        """

        required_methods = ('__str__',
                            '__repr__',
                            '__hash__',
                            '__getitem__',
                            '__setitem__',
                            '__iter__',
                            '__contains__',
                            '__len__',
                            '__eq__',
                            '__ne__',
                            '__add__',
                            '__iadd__',
                            '__sub__',
                            '__isub__',
                            '__mul__',
                            '__imul__',
                            '__div__',
                            '__idiv__',
                            '__pow__',
                            '__ipow__',
                            'get',
                            'is_uniform',
                            'extrapolate',
                            'interpolate',
                            'align',
                            'trim_wavelengths',
                            'zeros',
                            'normalise',
                            'clone')

        for method in required_methods:
            self.assertIn(method, dir(TriSpectralPowerDistribution))

    def test_wavelengths(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.wavelengths` attribute.
        """

        np.testing.assert_almost_equal(
            self._tri_spd.wavelengths,
            sorted(CIE_1931_2_DEGREE_STANDARD_OBSERVER['x_bar']))

    def test_values(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.values` attribute.
        """

        np.testing.assert_almost_equal(
            self._tri_spd.values,
            tstack((
                [v for k, v in sorted(
                    CIE_1931_2_DEGREE_STANDARD_OBSERVER['x_bar'].items())],
                [v for k, v in sorted(
                    CIE_1931_2_DEGREE_STANDARD_OBSERVER['y_bar'].items())],
                [v for k, v in sorted(
                    CIE_1931_2_DEGREE_STANDARD_OBSERVER['z_bar'].items())])))

    def test_shape(self):
        """
        Tests :attr:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.shape` attribute.
        """

        self.assertEqual(self._tri_spd.shape, SpectralShape(380, 780, 5))

    def test__str__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__str__` method.
        """

        try:
            self.assertEqual(
                str(self._tri_spd),
                'TriSpectralPowerDistribution(\'Observer\', (380, 780, 5))')
        except AssertionError:
            self.assertEqual(
                str(self._tri_spd),
                'TriSpectralPowerDistribution(\'Observer\', '
                '(380.0, 780.0, 5.0))')

    def test__getitem__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__getitem__` method.
        """

        np.testing.assert_almost_equal(
            self._tri_spd[400],
            np.array([0.01431, 0.000396, 0.06785]))

        np.testing.assert_almost_equal(
            self._tri_spd[np.array([380, 580, 780])],
            np.array([[1.36800000e-03, 3.90000000e-05, 6.45000000e-03],
                      [9.16300000e-01, 8.70000000e-01, 1.65000000e-03],
                      [4.20000000e-05, 1.50000000e-05, 0.00000000e+00]]))

        np.testing.assert_almost_equal(
            self._tri_spd[3:6],
            np.array([[0.00765, 0.000217, 0.03621],
                      [0.01431, 0.000396, 0.06785],
                      [0.02319, 0.000640, 0.1102]]))

    def test__setitem__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__setitem__` method.
        """

        x_bar = {}
        y_bar = {}
        z_bar = {}
        data = {'x_bar': x_bar, 'y_bar': y_bar, 'z_bar': z_bar}
        mapping = {'x': 'x_bar', 'y': 'y_bar', 'z': 'z_bar'}
        tri_spd = TriSpectralPowerDistribution('Observer', data, mapping)
        tri_spd[510] = np.array([49.67, 49.67, 49.67])
        np.testing.assert_almost_equal(
            tri_spd.values,
            np.array([[49.67, 49.67, 49.67]]))

        tri_spd[np.array([520, 530])] = np.array([[69.59, 69.59, 69.59],
                                                  [81.73, 81.73, 81.73]])
        np.testing.assert_almost_equal(
            tri_spd.values,
            np.array([[49.67, 49.67, 49.67],
                      [69.59, 69.59, 69.59],
                      [81.73, 81.73, 81.73]]))

        tri_spd[np.array([540, 550])] = 88.19
        np.testing.assert_almost_equal(
            tri_spd.values,
            np.array([[49.67, 49.67, 49.67],
                      [69.59, 69.59, 69.59],
                      [81.73, 81.73, 81.73],
                      [88.19, 88.19, 88.19],
                      [88.19, 88.19, 88.19]]))

        tri_spd[:] = 49.67
        np.testing.assert_almost_equal(
            tri_spd.values,
            np.array([[49.67, 49.67, 49.67],
                      [49.67, 49.67, 49.67],
                      [49.67, 49.67, 49.67],
                      [49.67, 49.67, 49.67],
                      [49.67, 49.67, 49.67]]))

    def test__iter__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__iter__` method.
        """

        self.assertEqual(
            {key: tuple(value) for key, value in self._tri_spd},
            {key: tuple(value) for key, value in CMFS_DATA.items()})

    def test__contains__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__contains__` method.
        """

        self.assertIn(380, self._tri_spd)

        self.assertIn(460, self._tri_spd)

        self.assertNotIn(461, self._tri_spd)

    def test__len__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__len__` method.
        """

        self.assertEqual(len(self._tri_spd), 81)

    def test__eq__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__eq__` method.
        """

        clone_tri_spd = self._tri_spd.clone()

        self.assertEqual(self._tri_spd, clone_tri_spd)

    def test__ne__(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__ne__` method.
        """

        clone_tri_spd = self._tri_spd.clone()
        clone_tri_spd[500] = (0, 0, 0)

        self.assertNotEqual(self._tri_spd, clone_tri_spd)

    def test_arithmetical_operation(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.__add__`,
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__sub__`
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__mult__`
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__div__`
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__truediv__`
and :func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__pow__`
        methods.
        """

        operations = (
            operator.add,
            operator.sub,
            operator.mul,
            operator.truediv,
            operator.pow)

        for operation in operations:
            self.assertFalse(operation(self._tri_spd, 1) is self._tri_spd)

            values = self._tri_spd.values
            np.testing.assert_almost_equal(
                operation(self._tri_spd, self._phi).values,
                operation(values, self._phi))

            random = np.random.random(values.shape)
            np.testing.assert_almost_equal(
                operation(self._tri_spd, random).values,
                operation(values, random))

            np.testing.assert_almost_equal(
                operation(self._tri_spd, self._tri_spd).values,
                operation(self._tri_spd.values, self._tri_spd.values))

    def test_arithmetical_ioperation(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
SpectralPowerDistribution.__iadd__`,
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__isub__`
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__imult__`
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__idiv__`
:func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__itruediv__`
and :func:`colour.colorimetry.spectrum.TriSpectralPowerDistribution.__ipow__`
        methods.
        """

        operations = (
            operator.iadd,
            operator.isub,
            operator.imul,
            operator.itruediv,
            operator.ipow)

        for operation in operations:
            tri_spd = self._tri_spd.clone()
            self.assertTrue(operation(tri_spd, 1) is tri_spd)

            tri_spd = self._tri_spd.clone()
            values = tri_spd.values
            np.testing.assert_almost_equal(
                operation(tri_spd, self._phi).values,
                operation(values, self._phi))

            tri_spd = self._tri_spd.clone()
            values = tri_spd.values
            random = np.random.random(values.shape)
            np.testing.assert_almost_equal(
                operation(tri_spd, random).values,
                operation(values, random))

            tri_spd1 = self._tri_spd.clone()
            tri_spd2 = self._tri_spd.clone()
            np.testing.assert_almost_equal(
                operation(tri_spd1, tri_spd2).values,
                operation(self._tri_spd.values, self._tri_spd.values))

    def test_get(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.get` method.
        """

        np.testing.assert_almost_equal(
            self._tri_spd.get(380),
            np.array([0.001368, 3.9e-05, 0.00645]))

        np.testing.assert_almost_equal(
            self._tri_spd.get(600),
            np.array([1.0622, 0.6310, 0.0008]))

        np.testing.assert_almost_equal(
            self._tri_spd.get(700),
            np.array([0.011359, 0.004102, 0.000000]))

        np.testing.assert_almost_equal(
            self._tri_spd.get(900, np.array([0, 0, 0])),
            np.array([0, 0, 0]))

        np.testing.assert_almost_equal(
            self._tri_spd.get(np.array([380, 600, 700])),
            np.array([[1.36800000e-03, 3.90000000e-05, 6.45000000e-03],
                      [1.06220000e+00, 6.31000000e-01, 8.00000000e-04],
                      [1.13590000e-02, 4.10200000e-03, 0.00000000e+00]]))

        np.testing.assert_array_equal(
            self._tri_spd.get(400.1),
            np.array([np.nan, np.nan, np.nan]))

    def test_is_uniform(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.is_uniform` method.
        """

        self.assertTrue(self._tri_spd.is_uniform())

    def test_extrapolate(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.extrapolate` method.
        """

        spd_data = dict(zip(range(25, 35), [0] * 5 + [1] * 5))
        tri_spd = TriSpectralPowerDistribution(
            name='',
            mapping=self._mapping,
            data={'x_bar': spd_data,
                  'y_bar': spd_data,
                  'z_bar': spd_data},
            labels=self._labels)

        tri_spd.extrapolate(SpectralShape(10, 50))

        self.assertEqual(tri_spd.x[10], 0)

        self.assertEqual(tri_spd.y[10], 0)

        self.assertEqual(tri_spd.z[10], 0)

        self.assertEqual(tri_spd.x[50], 1)

        self.assertEqual(tri_spd.y[50], 1)

        self.assertEqual(tri_spd.z[50], 1)

    def test_interpolate(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.interpolate` method.
        """

        tri_spd = self._sample_tri_spd.clone()

        tri_spd.interpolate(SpectralShape(interval=1))
        for i in sorted(self._mapping.keys()):
            np.testing.assert_almost_equal(
                getattr(tri_spd, i).values,
                INTERPOLATED_SAMPLE_SPD_DATA,
                decimal=7)

        tri_spd = self._non_uniform_sample_tri_spd.clone()

        tri_spd.interpolate(SpectralShape(interval=1))
        for i in sorted(self._mapping.keys()):
            np.testing.assert_allclose(
                getattr(tri_spd, i).values,
                INTERPOLATED_NON_UNIFORM_SAMPLE_SPD_DATA,
                rtol=0.0000001,
                atol=0.0000001)

        np.testing.assert_almost_equal(
            self._tri_spd.clone().interpolate(
                SpectralShape(interval=1),
                method='Linear')[411],
            np.array([0.050334, 0.001404, 0.24018]),
            decimal=7)

        np.testing.assert_almost_equal(
            self._tri_spd.clone().interpolate(
                SpectralShape(interval=1),
                method='Pchip')[411],
            np.array([0.04895501, 0.00136229, 0.23349933]),
            decimal=7)

    def test_align(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.align` method.
        """

        tri_spd = self._sample_tri_spd.clone()

        shape = SpectralShape(100, 900, 5)
        self.assertEqual(tri_spd.align(shape).shape, shape)

        shape = SpectralShape(600, 650, 1)
        self.assertEqual(tri_spd.align(shape).shape, shape)

    def test_trim_wavelengths(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.trim_wavelengths` method.
        """

        shape = SpectralShape(400, 700, 20)
        self.assertEqual(self._tri_spd.clone().trim_wavelengths(shape).shape,
                         shape)

        shape = SpectralShape(200, 900, 1)
        self.assertEqual(self._tri_spd.clone().trim_wavelengths(shape).shape,
                         self._tri_spd.shape)

    def test_zeros(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.zeros` method.
        """

        tri_spd = TriSpectralPowerDistribution(
            name='',
            mapping=self._mapping,
            data={'x_bar': SAMPLE_SPD_DATA,
                  'y_bar': SAMPLE_SPD_DATA,
                  'z_bar': SAMPLE_SPD_DATA},
            labels=self._labels).clone()

        tri_spd.zeros(SpectralShape(interval=1))
        for i in self._mapping.keys():
            np.testing.assert_almost_equal(
                getattr(tri_spd, i).values,
                ZEROS_SAMPLE_SPD_DATA)

    def test_normalise(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.normalise` method.
        """

        np.testing.assert_almost_equal(
            self._sample_tri_spd.clone().normalise(100).values,
            np.array([[x] * 3 for x in NORMALISED_SAMPLE_SPD_DATA]))

    def test_clone(self):
        """
        Tests :func:`colour.colorimetry.spectrum.\
TriSpectralPowerDistribution.clone` method.
        """

        self.assertFalse(self._tri_spd is self._tri_spd.clone())
        self.assertEqual(self._tri_spd.title, self._tri_spd.clone().title)


class TestConstantSpd(unittest.TestCase):
    """
    Defines :func:`colour.colorimetry.spectrum.constant_spd` definition unit
    tests methods.
    """

    def test_constant_spd(self):
        """
        Tests :func:`colour.colorimetry.spectrum.constant_spd`
        definition.
        """

        k = 3.1415

        spd = constant_spd(k)

        self.assertEqual(spd[360], k)

        self.assertEqual(spd[555], k)

        self.assertEqual(spd[780], k)


class TestZerosSpd(unittest.TestCase):
    """
    Defines :func:`colour.colorimetry.spectrum.zeros_spd` definition unit
    tests methods.
    """

    def test_zeros_spd(self):
        """
        Tests :func:`colour.colorimetry.spectrum.zeros_spd`
        definition.
        """

        spd = zeros_spd()

        self.assertEqual(spd[360], 0)

        self.assertEqual(spd[555], 0)

        self.assertEqual(spd[780], 0)


class TestOnes_spd(unittest.TestCase):
    """
    Defines :func:`colour.colorimetry.spectrum.ones_spd` definition unit
    tests methods.
    """

    def test_ones_spd(self):
        """
        Tests :func:`colour.colorimetry.spectrum.ones_spd`
        definition.
        """

        spd = ones_spd()

        self.assertEqual(spd[360], 1)

        self.assertEqual(spd[555], 1)

        self.assertEqual(spd[780], 1)


if __name__ == '__main__':
    unittest.main()
